/*
 * Created on 25.08.2004
 *
 */
package de.lunqual.rzpro.fenster;

import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;

import javax.swing.JTextArea;


/**
 * @author labor
 * Einfaches Textfeld, dass aber beim Focuserhalt den Inhalt selektiert
 * und bei Focusverlust den Inhalt deselektiert
 */
public class JSelectedTextArea extends JTextArea {

    DecimalFormatSymbols dfs;
    char comma=',';
    NumberFormat nf = NumberFormat.getInstance();

	public JSelectedTextArea() {
		super();
        //this.setDocument(new NumpadDocument());
        try { 
            dfs =  ((DecimalFormat)nf).getDecimalFormatSymbols();
            comma = dfs.getDecimalSeparator();
        } catch (final Exception e)  {};
		this.setSelectedTextColor(Color.WHITE);
		this.setSelectionColor(Color.BLUE);
		this.addFocusListener(new FocusListener() {
			public void focusGained(FocusEvent evt) {
				selectAll();
			}
			public void focusLost(FocusEvent evt) {
				select(0,0);
			}
    	});
	}


}
