/*
 * Created on 25.08.2004
 *
 */
package de.lunqual.rzpro.fenster;

import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;

import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;


/**
 * @author labor
 * Einfaches Textfeld, dass aber beim Focuserhalt den Inhalt selektiert
 * und bei Focusverlust den Inhalt deselektiert
 */
public class JSelectedTextField extends JTextField {

    DecimalFormatSymbols dfs;
    char comma=',';
    NumberFormat nf = NumberFormat.getInstance();

	public JSelectedTextField() {
		super();
        //this.setDocument(new NumpadDocument());
        try { 
            dfs =  ((DecimalFormat)nf).getDecimalFormatSymbols();
            comma = dfs.getDecimalSeparator();
        } catch (final Exception e)  {};
		this.setSelectedTextColor(Color.WHITE);
		this.setSelectionColor(Color.BLUE);
		this.addFocusListener(new FocusListener() {
			public void focusGained(FocusEvent evt) {
				selectAll();
			}
			public void focusLost(FocusEvent evt) {
				select(0,0);
			}
    	});
	}

    /**
     * "wüster" Hack !
     * Numpad-, liefert unter Linux nicht "," oder "." oder DecimalSeparator, sondern
     * ein wildes Unicode Zeichen jenseits von 20000 ?!?!
     * Deshalb wird hier jedes Unicode - Zeichen ausserhalb der ACII-Range kurzerhand
     * in den DecimalSeparator verwandelt.
     * Unter Windows würde das auch ohne diesen Hack funktionieren.
     * Sollte normalweise keine Seiteneffekte haben, weil sich das ohnehin nur auf
     * JNumberfields erstreckt, aber man weiss halt nie ;)
     * @author lunqual
     *
     */
    class NumpadDocument extends PlainDocument {

             @Override
			public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                 if ((str.toCharArray()[0]) > 255 ) {
					str=String.valueOf(comma);
				}
                 super.insertString(offs, str, a);
        }
}
}
