/*
 * Created on 06.08.2004
 *
 */
package de.lunqual.rzpro.fenster;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.ArrayList;

import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.Timer;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.mischungen.MischungsHeaderItem;
/**
 * @author labor
 *
 */
public class MischungsDialog extends JFrame{

    RzPro                		rz;
    ArrayList<MischungsHeaderItem>		liste;
    MischungsHeaderItem								selected;
    JRzFrame													parentFrame;

    Timer				    	ergebnisTimer;
    int							x;
    int							y;
    int							mode;
   
    public static final int		DEFAULT_LIMIT				= 25;

    public static final int       MISCHUNGSDIALOG_CHAR_WIDTH                        = 30;
    public static final int       MISCHUNGSDIALOG_CHAR_HEIGHT                       = 20;
    
    public static final int		MODE_ID =0;
    public static final int		MODE_TEXT = 1;

    /** Creates new form EinheitenDialog */
    public MischungsDialog(JRzFrame parent,RzPro r,int x,int y,String aVorgabe,int mode) {
        rz = r;
        parentFrame = parent;
        this.x = x;
        this.y = y;
        liste = null;
        selected = null;
        this.mode = mode;

        ergebnisTimer = new javax.swing.Timer(rz.getOptionFactory().getOption("list.timeout",RzPro.ZUTATEN_TIMEOUT), new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                 ergebnisTimerEvent();
            }
        });
        createGUI();
        if (!aVorgabe.equals("")){
        	aVorgabe=aVorgabe.replaceAll("\\s|,|;| |:","|");
            txtVorgabe.setText(aVorgabe.trim());
       		showTankListe();
        }
    }

    //
    private void formFocusGained() {
    	showTankListe();
    	txtVorgabe.requestFocus();
    	if(!txtVorgabe.getText().trim().equals("")) {
    	    txtVorgabe.setSelectionStart(0);
    	    txtVorgabe.setSelectionEnd(txtVorgabe.getText().length());
    	}
    }

    private void formFocusLost() {
    	setVisible(false);
    }

    private void showTankListe(){
    	final String match = txtVorgabe.getText();
    	switch(mode) {
    		case MODE_TEXT:
    	  		lstMischungen.setListData(rz.getDatabase().getMischungen().getMischungsListeBezeichnung(match).toArray());
    			break;
    		case MODE_ID:
    			int m=0;
    			try {
    				m = Integer.valueOf(match);
    			}catch(Exception e) {}
    	  		lstMischungen.setListData(rz.getDatabase().getMischungen().getMischungsListeID(m).toArray());
    			break;
    	}
    }

    private void itemSelected() {
		try {
			selected = ((MischungsHeaderItem)lstMischungen.getSelectedValue());
			if(parentFrame != null) {
				parentFrame.getMessage(new MessageItem(MessageItem.MSG_MISCHUNGSLISTE_REPLY,0, ((MischungsHeaderItem)lstMischungen.getSelectedValue()).clones(),this));
			}
		} catch (final Exception e) {}
		setVisible(false);
    }

    private void formKeyEvent(KeyEvent evt){
    	switch (evt.getKeyCode()){
    		case KeyEvent.VK_ESCAPE:
    			this.setVisible(false);
    			break;
    		case KeyEvent.VK_ENTER:
    			itemSelected();
    			break;
    		case KeyEvent.VK_DOWN:
    				if(lstMischungen.getSelectedIndex() == -1) {
    					if(lstMischungen.getModel().getSize() > 0) {
    						lstMischungen.setSelectedIndex(0);
    					}
    				}
    				else {
    					if(lstMischungen.getSelectedIndex() < (lstMischungen.getModel().getSize() -1)) {
    						lstMischungen.setSelectedIndex(lstMischungen.getSelectedIndex()+1);
    					}
    				}
    			break;
    		case KeyEvent.VK_UP:
    			if (lstMischungen.getSelectedIndex() == -1) {
	    			if(lstMischungen.getModel().getSize() > 0) {
	    				lstMischungen.setSelectedIndex(0);
	    			}
    			}
    			else {
	    			if(lstMischungen.getSelectedIndex() > 0){
	    				lstMischungen.setSelectedIndex(lstMischungen.getSelectedIndex()-1);
	    			}
    			}
    			break;
    		default :
    			if(evt.getComponent().equals(txtVorgabe)){
					if(ergebnisTimer.isRunning()){
						ergebnisTimer.stop();
					}
					ergebnisTimer.start();
    			}
    			break;
    	}
    	if(lstMischungen.getSelectedIndex() != -1) {
			lstMischungen.ensureIndexIsVisible(lstMischungen.getSelectedIndex());
		}
    	txtVorgabe.requestFocus();
    }

    private void ergebnisTimerEvent() {
        if(ergebnisTimer.isRunning()) {
			ergebnisTimer.stop();
		}
		showTankListe();
		if(lstMischungen.getModel().getSize() > 0){
			lstMischungen.setSelectedIndex(0);
		}
    }

    private JPanel mainPanel;
    private JScrollPane scrListe;
    private JList	lstMischungen;
    private JTextField txtVorgabe;

    public void createGUI(){
        setUndecorated(true);
    	mainPanel = new JPanel(new BorderLayout());
        getContentPane().add(mainPanel, java.awt.BorderLayout.CENTER);
        addWindowFocusListener(new WindowFocusListener()
                {
            		public void windowLostFocus(WindowEvent evt) {
            		    formFocusLost();
            		}
            		public void windowGainedFocus(WindowEvent evt) {
					    formFocusGained();
					}
                });
        txtVorgabe = new JTextField();
        	txtVorgabe.setColumns(30);
        	mainPanel.add(txtVorgabe,BorderLayout.NORTH);
        scrListe = new JScrollPane();
        	lstMischungen = new JList();
            lstMischungen.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
            scrListe.setViewportView(lstMischungen);
        	mainPanel.add(scrListe,BorderLayout.CENTER);

            lstMischungen.addKeyListener(new java.awt.event.KeyAdapter() {
                @Override
				public void keyReleased(java.awt.event.KeyEvent evt) {
                    formKeyEvent(evt);
                }
            });

 	        lstMischungen.addMouseListener(new MouseAdapter() {
 	            @Override
				public void mousePressed(MouseEvent e) {
 	                if(e.getClickCount() == 2) {
 	                	itemSelected();
 	                }
 	            }
	 	       });

            txtVorgabe.addKeyListener(new java.awt.event.KeyAdapter() {
                @Override
				public void keyReleased(java.awt.event.KeyEvent evt) {
                    formKeyEvent(evt);
                }
            });

		// Grösse, Position, Fonts....
        pack();
		rz.getFontFactory().setFrameFonts(this);
		int pw,ph; // breite und höhe
		pw = getFontMetrics(txtVorgabe.getFont()).charWidth('M') * MISCHUNGSDIALOG_CHAR_WIDTH;
		ph = getFontMetrics(lstMischungen.getFont()).getHeight() * MISCHUNGSDIALOG_CHAR_HEIGHT;
        lstMischungen.setPreferredSize(new Dimension(pw,ph));
		pack();
        setBounds(x,y,pw,ph);
    }


}
