/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package de.lunqual.rzpro.fenster.about;

import de.lunqual.rzpro.*;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.log.LogFactory;

// java pakete
import java.util.*;
import javax.swing.*;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.*;

/** 
 *
 * @author  lunqual
 */
public class AboutFenster extends JRzFrame{
    
	// GUI-Variablen
   private JMenuBar mb;
   private JMenu mnuDatei;
   private JPanel 		mainPanel;
   private JPanel		iconPanel;
   		private JLabel		lblCopyright;
   		private JLabel		lblIcon;
   		private JLabel		lblRechte;
   private JPanel		textPanel;
   		private JLabel		lblVersion;
   		private JLabel		lblOS;
   		private JLabel		lblJava;
   		private JLabel		lblMemory;
   		private JLabel		lblMySQL;
   		private JLabel		lblDriver;
   		private JLabel		lblUser;
   private JPanel 		buttonPanel;
        private JButton         btSponsor;
   		private JButton 		btClose;
   		private JButton			btLizenzen;

   		
    //ActionCodes
    public static final int         ACTION_CLOSE_CODE = 1000;
    public static final String      ACTION_CLOSE_TEXT = "about.action_close";    
    public static final int         ACTION_LIZENZEN_CODE = 1001;
    public static final String      ACTION_LIZENZEN_TEXT = "about.action_licences";   
    
    //Actions
    HashMap             	actionMap;
    JRzFrame				origin;
    
    /** Creates new form AnmeldeEinstellungen */
    public AboutFenster(RzPro rz,String name,Object extendedData) {
    	super(rz,name, extendedData);
        createActions();
        createGUIComponents();
        setGUIComponents();
    }
   /*
    * Actions einrichten
    */
    public void  createActions(){
        actionList.put(String.valueOf(ACTION_CLOSE_CODE),new AuswahlAction(rz,this,ACTION_CLOSE_CODE,ACTION_CLOSE_TEXT,KeyEvent.VK_ESCAPE,0));   
        actionList.put(String.valueOf(ACTION_LIZENZEN_CODE),new AuswahlAction(rz,this,ACTION_LIZENZEN_CODE,ACTION_LIZENZEN_TEXT,0,0));   
        
    }    
    
    /** auf Action-Messages reagieren
     * @param ActionMessage 
     */
    public void getMessage(MessageItem msg) {
    	switch (msg.getMsgCode()){
    		case MessageItem.MSG_ACTIONPERFORMED :
		        switch(msg.getCode()) {
		        	case ACTION_LIZENZEN_CODE:
		                rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"lizenzen.html",this));
		        		break;
			        case ACTION_CLOSE_CODE: okAction();
			        	break;
			        default:
			        	//auch nix zu tin
			        	break;
			    }
    		break;
    		case MessageItem.MSG_SHOW_ABOUT:
    			origin = (JRzFrame)msg.getOrigin();
    			break;
	        default:
	            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "about", "getMessage:" + msg.getMsgCode());
	            break;    			
    	}
     }
    
   /** wird beim Drücken von OK aufgerufen
    * 
    */
    private void okAction(){
    	closeWindow();
    }
   
    /** Das Fenser darstellen
     */
    public void openWindow(){
    	setVisible(true);
    	toFront();
    }
    /** Das Fenster wird nicht nur geschlossen, sondern
     * auf den Müll befördert, deshalb wird eine
     * DISPOSE_FRAME-Message an Rz absetzen
    */
    public void closeWindow(){
    	rz.getFensterFactory().getFensterListe().disposeFrame(this);
   	}

    /** GUI-Komponenten erzeugen
     * 
     */
   public void createGUIComponents(){
   		mb = new JMenuBar();
		mnuDatei = new JMenu();
		mb.add(mnuDatei);
		setJMenuBar(mb);
   		mainPanel=new JPanel(new BorderLayout());
   			iconPanel = new JPanel(new BorderLayout());
   				lblCopyright = new JLabel();
   					lblCopyright.setHorizontalAlignment(SwingConstants.CENTER);
   				iconPanel.add(lblCopyright,BorderLayout.NORTH);
   				lblIcon = new JLabel();
   					lblIcon.setHorizontalAlignment(SwingConstants.CENTER);
   				iconPanel.add(lblIcon,BorderLayout.CENTER);
   				lblRechte = new JLabel();
   					lblRechte.setHorizontalAlignment(SwingConstants.CENTER);
   				iconPanel.add(lblRechte,BorderLayout.SOUTH);
	   			iconPanel.setBorder(BorderFactory.createRaisedBevelBorder());
	   			iconPanel.setBackground(Color.WHITE);
   			mainPanel.add(iconPanel,BorderLayout.NORTH);
   			textPanel = new JPanel(new GridLayout(7,1));
   	   			lblVersion = new JLabel();
   	   			textPanel.add(lblVersion);
   	   			lblOS = new JLabel();
	   			textPanel.add(lblOS);
   	   			lblJava = new JLabel();
	   			textPanel.add(lblJava);
	   			lblMemory = new JLabel();
	   			textPanel.add(lblMemory);
   	   			lblMySQL = new JLabel();
	   			textPanel.add(lblMySQL);
   	   			lblDriver = new JLabel();
   	   			textPanel.add(lblDriver);
	   			lblUser = new JLabel();
	   			textPanel.add(lblUser);	   			
	   			textPanel.setBorder(BorderFactory.createRaisedBevelBorder());
	   			textPanel.setBackground(Color.WHITE);
   			mainPanel.add(textPanel,BorderLayout.CENTER);   			
   			buttonPanel = new JPanel(new BorderLayout());
				btClose = new JButton();
				btLizenzen = new JButton();
                btSponsor=new JButton();
                btSponsor.addActionListener(new java.awt.event.ActionListener() {
                    public void actionPerformed(java.awt.event.ActionEvent evt) {
                            openSponsorLink();
                        }
                    }); 
                //buttonPanel.add(btSponsor,BorderLayout.NORTH);
				buttonPanel.add(btClose,BorderLayout.WEST);
				buttonPanel.add(btLizenzen,BorderLayout.CENTER);
				mainPanel.add(buttonPanel,BorderLayout.SOUTH);
   			
   		getContentPane().setLayout(new BorderLayout());
        getContentPane().add(mainPanel,BorderLayout.CENTER);
   }
   /** GUI-Komponenten mit Text und anderen Attributen versehen
    * 
    */
	public void setGUIComponents() {
        setTitle(rz.getVersionString() + " " + rz.getLocale().getString("about.titel"));
        mnuDatei.setText(rz.getLocale().getString("menu.datei"));
        mnuDatei.add(getAction(ACTION_LIZENZEN_CODE));
        mnuDatei.addSeparator();
        mnuDatei.add(getAction(ACTION_CLOSE_CODE));
	    lblCopyright.setText(rz.getLocale().getString("string.copyright"));
	    lblRechte.setText(rz.getLocale().getString("string.all_rights_reserved"));
	    lblVersion.setText(rz.getLocale().getString("about.label_version").replaceAll( "%s",rz.getVersionString())) ;	    
	    lblJava.setText(rz.getLocale().getString("about.label_java").replaceAll("%s",
	    	System.getProperty("java.vm.vendor") + " " +
	    	System.getProperty("java.version") + " " +
	    	System.getProperty("java.vm.name") + " " +
	    	System.getProperty("user.language")
	    ));
	    lblMemory.setText(rz.getLocale().getString("about.label_memory")
	    		.replaceAll("%m",Long.toString( (Runtime.getRuntime().maxMemory()/(1024*1024))))
	    		.replaceAll("%t",Long.toString( (Runtime.getRuntime().totalMemory()/(1024*1024))))
	    	);
	    lblOS.setText(rz.getLocale().getString("about.label_os").replaceAll("%s",
	    		System.getProperty("os.name") + " "  + System.getProperty("os.arch")   + " " +  	System.getProperty("os.version"))
		    	.replaceAll("%c",String.valueOf(Runtime.getRuntime().availableProcessors())
	    ));
	    lblMySQL.setText(rz.getLocale().getString("about.label_mysql").replaceAll("%s", rz.getDatabase().dbGetDatabaseVersion()));
	    lblDriver.setText(rz.getLocale().getString("about.label_driver").replaceAll("%s",rz.getDatabase().dbGetDriverVersion()));
	    
	    lblUser.setText(rz.getLocale().getString("about.label_user").replaceAll("%s",rz.getDatabase().dbGetUser()));
	    btClose.setAction(getAction(ACTION_CLOSE_CODE));
	    btLizenzen.setAction(getAction(ACTION_LIZENZEN_CODE));
        btSponsor.setText(rz.getOptionFactory().getOption("sponsor.button"));
    	try {
    		//lblIcon.setIcon(new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/" + rz.getOptionFactory().getOption("sponsor.info"))));
    		lblIcon.setIcon(new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/splash.png")));
    		
    	}
	    catch (Exception e) {
	    	rz.getLogFactory().logMessage(LogFactory.LOG_WARN,"about:",e.getLocalizedMessage());
	    }
        setResizable(true);
        rz.getFontFactory().setFrameFonts(this);          
        pack();
        rz.getFensterFactory().setLocation(this,FensterFactory.POSITION);

	}

    private void openSponsorLink() {
        String cmd="";
        if(isWindows()) {
            cmd = "rundll32 url.dll,FileProtocolHandler " + rz.getOptionFactory().getOption("sponsor.link");
            try {
                Runtime.getRuntime().exec(cmd);
                } catch (Exception e) {
                    rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "About:Sponsored Link Windows", cmd + " :"  + e.getMessage());
                }
        }else {
            cmd = rz.getOptionFactory().getOption("sponsor.browser") + "  " +  rz.getOptionFactory().getOption("sponsor.link");
            try {
                Runtime.getRuntime().exec(cmd);
                } catch (Exception e) {
                    rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "About:Sponsored Link Unix", cmd + " :"  + e.getMessage());
                }
        }
    }
    
    public static boolean isWindows()
    {
        String os = System.getProperty("os.name");
        if ( os != null && os.startsWith("Windows"))
            return true;
        else
            return false;
    }
 }
