/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package de.lunqual.rzpro.fenster.acidfenster;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;

import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JToolBar;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.fenster.JNumberField;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fenster.ZutatenDialog;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.acid.AcidAnzeigeItem;
import de.lunqual.rzpro.items.acid.AcidItem;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.rezeptur.RezepturItem;
import de.lunqual.rzpro.items.rezeptur.ZutatenSuchItem;
import de.lunqual.rzpro.options.OptionFactory;


/**
 *
 * @author  administrator
 */
public class AcidRechner extends JRzFrame {

    //GUI-Variablen
	private JMenuBar mb;
    	private JMenu mnuDatei;
    	private JMenu mnuExtras;
    	private JMenu mnuHilfe;
    private JPanel mainPanel;
    	private JPanel toolbarPanel;
    		private JToolBar tb1;
    	private JPanel contentPanel;
    		private JPanel rechenPanel;
    			private JNumberField txtWs1;
    			private JLabel lblWs1;
    			private JComboBox cmbWs1;
    			private JLabel lblMitte;
    			private JNumberField txtWs2;
    			private JLabel lblWs2;
    			private JComboBox cmbWs2;
    		private JPanel rezepturPanel;
    			private JPanel rezepturDatenPanel;
	    			private JButton btRezeptur;
	    			private JLabel lblRezeptur;
	    			private JLabel lblLitergewicht;
	    			private JNumberField txtLitergewicht;
	    			private JLabel lblAcidKg;
	    			private JNumberField txtAcidKg;
	    			private JLabel lblAcidLiter;
	    			private JNumberField txtAcidLiter;
    	private JPanel buttonPanel;
    		private JButton btClose;
    		private JButton btReply;
    		private JButton btHilfe;

    // ActionCodes KalkulationEingabe
    public static final int         ACTION_CLOSE_CODE = 1000;
    public static final String      ACTION_CLOSE_TEXT = "acidrechner.action_close";
    public static final int         ACTION_HILFE_CODE = 1002;
    public static final String      ACTION_HILFE_TEXT = "action_hilfe";
    public static final int         ACTION_HIDE_CODE = 1003;
    public static final String      ACTION_HIDE_TEXT = "action_hide";
    public static final int         ACTION_REZEPTUR_CODE = 1004;
    public static final String      ACTION_REZEPTUR_TEXT = "acidrechner.action_rezeptur";
    public static final int         ACTION_REPLY_CODE = 1005;
    public static final String      ACTION_REPLY_TEXT = "acidrechner.action_reply";

    private static final int			RECHNEN_LG = 0;
    private static final int			RECHNEN_KG=1;
    private static final int			RECHNEN_LITER = 2;
    private static final int			RECHNEN_WS1=3;
    private static final int			RECHNEN_WS2=4;

    JRzFrame			origin;
    ZutatenDialog		zd;
    /** Creates new form AdressAuswahl */

    public AcidRechner(RzPro r, String name,Object extendedData) {
        super(r,name,extendedData);
        createActions();
        createGUIComponents();
        setGUIComponents();
        getMessage((MessageItem)extendedData);
    }

    @Override
	public void createGUIComponents() {
        mb = new JMenuBar();
		mnuDatei = new JMenu();
			mb.add(mnuDatei);
        mnuExtras = new JMenu();
        	mb.add(mnuExtras);
        mnuHilfe = new JMenu();
        	mb.add(mnuHilfe);
		setJMenuBar(mb);
		mainPanel = new JPanel(new BorderLayout());
			toolbarPanel = new JPanel(new BorderLayout());
				tb1 = new JToolBar();
				tb1.setFloatable(false);
				tb1.setRollover(true);
				toolbarPanel.add(tb1);
			mainPanel.add(toolbarPanel,BorderLayout.NORTH);
			contentPanel  = new JPanel(new BorderLayout());
				rechenPanel = new JPanel();
					rechenPanel.setLayout(new BoxLayout(rechenPanel, BoxLayout.LINE_AXIS));
					txtWs1 = new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_NORMAL),rz.getOptionFactory().getDouble("acidrechner.tws1"),0.0,Double.POSITIVE_INFINITY);
	        	    txtWs1.addActionListener(new ActionListener() {
        	        	public void actionPerformed(ActionEvent evt) {
        	        	    rechnenAction(RECHNEN_WS1);
        	        	}
	        	    });
					txtWs1.addFocusListener(new FocusListener() {
						public void focusGained(FocusEvent evt) {
						}
						public void focusLost(FocusEvent evt) {
								rechnenAction(RECHNEN_WS1);
							}
			    		});
					rechenPanel.add(txtWs1);
					//
					lblWs1=new JLabel();
					rechenPanel.add(lblWs1);
					//
					cmbWs1=new JComboBox();
						rz.getDatabase().getAcid().getAcidListeCombo(cmbWs1, rz.getOptionFactory().getOption("acidrechner.ws1",0));
		        	    cmbWs1.addActionListener(new ActionListener() {
	        	        	public void actionPerformed(ActionEvent evt) {
	        	        	    rechnenAction(RECHNEN_WS1);
	        	        	}
		        	    });
					rechenPanel.add(cmbWs1);
					//
					lblMitte = new JLabel();
					rechenPanel.add(lblMitte);
					//
					txtWs2 = new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_NORMAL),rz.getOptionFactory().getDouble("acidrechner.tws2"),0.0,Double.POSITIVE_INFINITY);
	        	    txtWs2.addActionListener(new ActionListener() {
        	        	public void actionPerformed(ActionEvent evt) {
        	        	    rechnenAction(RECHNEN_WS2);
        	        	}
	        	    });
					txtWs2.addFocusListener(new FocusListener() {
						public void focusGained(FocusEvent evt) {
						}
						public void focusLost(FocusEvent evt) {
								rechnenAction(RECHNEN_WS2);
							}
			    		});
					rechenPanel.add(txtWs2);
					//
					lblWs2=new JLabel();
					rechenPanel.add(lblWs2);
					//
					cmbWs2=new JComboBox();
						rz.getDatabase().getAcid().getAcidListeCombo(cmbWs2, rz.getOptionFactory().getOption("acidrechner.ws2",0));
		        	    cmbWs2.addActionListener(new ActionListener() {
	        	        	public void actionPerformed(ActionEvent evt) {
	        	        	    rechnenAction(RECHNEN_WS1);
	        	        	}
		        	    });
						rechenPanel.add(cmbWs2);
					//
					rechenPanel.setBorder(BorderFactory.createEtchedBorder());
				contentPanel.add(rechenPanel,BorderLayout.NORTH);
				rezepturPanel = new JPanel(new BorderLayout());
					rezepturDatenPanel=new JPanel(new GridLayout(4,2));
						btRezeptur=new JButton();
						rezepturDatenPanel.add(btRezeptur);
						lblRezeptur = new JLabel();
						rezepturDatenPanel.add(lblRezeptur);

						lblLitergewicht = new JLabel();
						rezepturDatenPanel.add(lblLitergewicht);
	 					txtLitergewicht = new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_LITERGEWICHT),rz.getTafelFactory().Litergewicht(0),0.0,Double.POSITIVE_INFINITY);
		        	    txtLitergewicht.addActionListener(new ActionListener() {
	        	        	public void actionPerformed(ActionEvent evt) {
	        	        	    rechnenAction(RECHNEN_LG);
	        	        	}
		        	    });
						txtLitergewicht.addFocusListener(new FocusListener() {
							public void focusGained(FocusEvent evt) {
							}
							public void focusLost(FocusEvent evt) {
									rechnenAction(RECHNEN_LG);
								}
				    		});
						rezepturDatenPanel.add(txtLitergewicht);

						lblAcidKg=new JLabel();
						rezepturDatenPanel.add(lblAcidKg);
	 					txtAcidKg = new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_NORMAL),0.0,0.0,Double.POSITIVE_INFINITY);
	 					txtAcidKg.addActionListener(new ActionListener() {
	        	        	public void actionPerformed(ActionEvent evt) {
	        	        	    rechnenAction(RECHNEN_KG);
	        	        	}
		        	    });
						txtAcidKg.addFocusListener(new FocusListener() {
							public void focusGained(FocusEvent evt) {
							}
							public void focusLost(FocusEvent evt) {
								rechnenAction(RECHNEN_KG);
								}
				    		});
						rezepturDatenPanel.add(txtAcidKg);

						lblAcidLiter=new JLabel();
						rezepturDatenPanel.add(lblAcidLiter);
	 					txtAcidLiter = new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_NORMAL),0.0,0.0,Double.POSITIVE_INFINITY);
	 					txtAcidLiter.addActionListener(new ActionListener() {
	        	        	public void actionPerformed(ActionEvent evt) {
	        	        	    rechnenAction(RECHNEN_LITER);
	        	        	}
		        	    });
						txtAcidLiter.addFocusListener(new FocusListener() {
							public void focusGained(FocusEvent evt) {
							}
							public void focusLost(FocusEvent evt) {
								rechnenAction(RECHNEN_LITER);
								}
				    		});
	 					rezepturDatenPanel.add(txtAcidLiter);
					rezepturPanel.add(rezepturDatenPanel,BorderLayout.NORTH);
					rezepturPanel.setBorder(BorderFactory.createEtchedBorder());
				contentPanel.add(rezepturPanel,BorderLayout.SOUTH);
			buttonPanel=new JPanel(new GridLayout(1,3));
    			btClose=new JButton();
    				buttonPanel.add(btClose);
        		btReply=new JButton();
    				buttonPanel.add(btReply);
    			btHilfe = new JButton();
    				buttonPanel.add(btHilfe);
			mainPanel.add(toolbarPanel,BorderLayout.NORTH);
			mainPanel.add(contentPanel,BorderLayout.CENTER);
			mainPanel.add(buttonPanel,BorderLayout.SOUTH);

			getContentPane().setLayout(new BorderLayout());
			getContentPane().add(mainPanel,BorderLayout.CENTER);
    }
    @Override
	public void setGUIComponents() {
        setTitle(rz.getLocale().getString("acidrechner.titel"));

        mnuDatei.setText(rz.getLocale().getString("menu.datei"));
        mnuExtras.setText(rz.getLocale().getString("menu.extras"));
        mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));
        mnuDatei.add(getAction(ACTION_CLOSE_CODE));
        mnuDatei.addSeparator();
        mnuExtras.add(getAction(ACTION_HIDE_CODE));
        mnuHilfe.add(getAction(ACTION_HILFE_CODE));

  	  	tb1.add(getAction(ACTION_CLOSE_CODE));
  	  	tb1.addSeparator();
  	  	tb1.add(getAction(ACTION_HIDE_CODE));
  	  	tb1.addSeparator();
  	  	tb1.add(getAction(ACTION_HILFE_CODE));

        btClose.setAction(getAction(ACTION_CLOSE_CODE));
        btHilfe.setAction(getAction(ACTION_HILFE_CODE));
        btRezeptur.setAction(getAction(ACTION_REZEPTUR_CODE));
        btReply.setAction(getAction(ACTION_REPLY_CODE));
        btReply.setVisible(false);

        lblLitergewicht.setText(rz.getLocale().getString("acidrechner.label_litergewicht"));
        lblAcidKg.setText(rz.getLocale().getString("acidrechner.label_acidkg"));
        lblAcidLiter.setText(rz.getLocale().getString("acidrechner.label_acidliter"));
        lblWs1.setText(rz.getLocale().getString("acidrechner.label_ws1"));
        lblWs2.setText(rz.getLocale().getString("acidrechner.label_ws2"));
        lblMitte.setText(rz.getLocale().getString("acidrechner.label_mitte"));

        setResizable(true);
        rz.getFontFactory().setFrameFonts(this);
        pack();
        rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;
    }
    @Override
	public void getMessage(MessageItem msg) {
        switch(msg.getMsgCode()) {
    	case MessageItem.MSG_ACTIONPERFORMED:
            switch(msg.getCode()){
			case ACTION_CLOSE_CODE :cancelAction();break;
            case ACTION_HILFE_CODE: hilfeAction();break;
            case ACTION_HIDE_CODE:hideAction();break;
            case ACTION_REZEPTUR_CODE:rezepturAction();break;
            case ACTION_REPLY_CODE:replyAction();break;
            default :
                break;
           }
    		break;
   	 	case MessageItem.MSG_ZUTATEN_DIALOG_REPLY:
   	 		if(msg.getData() != null) {
   	 			final ZutatenSuchItem zi = (ZutatenSuchItem)msg.getData();
   	 			if(zi != null){
	   	 				if(zi.getID()!=0) {
			           		 final RezepturItem ri = rz.getDatabase().getRezeptur().dbGetRezeptur(zi.getID(),true);
			        		 lblRezeptur.setText(ri.getTitel());
			        		 txtLitergewicht.setValue(ri.getLitergewicht());
			        		 txtAcidLiter.setValue(ri.getAcid());
	   	 				}
	   	 			}
	   	 		} else {
	           		 lblRezeptur.setText("---");
	        		 txtLitergewicht.setValue(rz.getTafelFactory().Litergewicht(0));
	        		 txtAcidLiter.setValue(0);
	        		 txtAcidKg.setValue(0);
	   	 		}
   	 		rechnenAction(RECHNEN_LITER);
   	 		break;
         case MessageItem.MSG_SHOW_ACIDRECHNER:
 			 origin = msg.getOrigin();
        	 if(msg.getData() != null) {
        		 lblRezeptur.setText(((AcidAnzeigeItem)msg.getData()).getName());
        		 txtLitergewicht.setValue(((AcidAnzeigeItem)msg.getData()).getLitergewicht());
        		 txtAcidLiter.setValue(((AcidAnzeigeItem)msg.getData()).getAcid());
        	 } else {
        		 lblRezeptur.setText("---");
        		 txtLitergewicht.setValue(rz.getTafelFactory().Litergewicht(0));
        		 txtAcidLiter.setValue(0);
        	 }
        	 if(msg.getCode() == 0) {
        		 btReply.setVisible(false);
        	 }else {
        		 btReply.setVisible(true);
        	 }
	      	 break;

        default:
            rz.getLogFactory().logMessage(2, "acidrechner", "auswahlAction:" + msg.getMsgCode());
            break;
        }
    }

    @Override
	public void createActions(){
        actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT, KeyEvent.VK_F5 ,InputEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT, KeyEvent.VK_F1 ,0));
		actionList.put(String.valueOf(ACTION_CLOSE_CODE), new AuswahlAction(rz,this,ACTION_CLOSE_CODE,ACTION_CLOSE_TEXT,KeyEvent.VK_ESCAPE,	0));
		actionList.put(String.valueOf(ACTION_REZEPTUR_CODE), new AuswahlAction(rz,this,ACTION_REZEPTUR_CODE,ACTION_REZEPTUR_TEXT,KeyEvent.VK_R,InputEvent.CTRL_DOWN_MASK));
		actionList.put(String.valueOf(ACTION_REPLY_CODE), new AuswahlAction(rz,this,ACTION_REPLY_CODE,ACTION_REPLY_TEXT,KeyEvent.VK_R,InputEvent.CTRL_DOWN_MASK));

    }

    /**
     * Daten rechnen
     */
    private void rechnenAction(int what) {
    	final double lg = txtLitergewicht.getValue();
    	double acidLiter = txtAcidLiter.getValue();
    	double acidKg = txtAcidKg.getValue();
    	double ws1=txtWs1.getValue();
    	double ws2=txtWs2.getValue();
    	final AcidItem w1=(AcidItem)cmbWs1.getSelectedItem();
    	final AcidItem w2=(AcidItem)cmbWs2.getSelectedItem();
    	try {
	    	switch(what) {
	    		case RECHNEN_LG:
	    		case RECHNEN_LITER:
	    			if(rz.isZero(lg)) {
	    				acidLiter =0;
	    				acidKg=0;
	    			} else {
	    				if(!rz.isZero(acidLiter)) {
	    					acidKg = acidLiter * 1/lg;
	    				} else {
	    					acidKg = 0;
	    				}
	    			}
	    			break;
	    		case RECHNEN_KG:
	    			if(rz.isZero(lg)) {
	    				acidLiter =0;
	    				acidKg=0;
	    			} else {
	    				if(!rz.isZero(acidKg)) {
	    					acidLiter = acidKg * lg;
	    				} else {
	    					acidLiter = 0;
	    				}
	    			}
	    			break;
	    		case RECHNEN_WS1:
	    			ws2=rz.getDatabase().getAcid().convert(ws1, w1, w2);
	    			break;
	    		case RECHNEN_WS2:
	    			ws1=rz.getDatabase().getAcid().convert(ws2, w2, w1);
	    			break;
	    	}
    	}catch (final Exception e) {}
    	txtLitergewicht.setValue(lg);
    	txtAcidKg.setValue(acidKg);
    	txtAcidLiter.setValue(acidLiter);
    	txtWs1.setValue(ws1);
    	txtWs2.setValue(ws2);
    }
    /**
     * RezepturAction
     */
    private void rezepturAction() {
		int x, y;
		x = (int) (btRezeptur.getLocationOnScreen().getX() +20);
		y = (int) (btRezeptur.getLocationOnScreen().getY() +10);
		if(zd != null) {
			zd.dispose();
			zd = null;
		}
		zd = new ZutatenDialog(this, rz, x, y,"",ZutatenDialog.MODE_REZEPTUREN);
		zd.setVisible(true);
    }

    /**
     * WErt zurückgeben
     */
    private void replyAction() {
    	origin.getMessage(new MessageItem(MessageItem.MSG_ACIDRECHNER_REPLY,0,Double.valueOf(txtAcidLiter.getValue()),this));
    	closeWindow();
    }
    /**
     * cancel
     */
    private void cancelAction(){
        closeWindow();
    }


    @Override
	public void closeWindow(){
    	rz.getOptionFactory().setDouble("acidrechner.tws1",txtWs1.getValue());
       	rz.getOptionFactory().setDouble("acidrechner.tws2",txtWs2.getValue());
    	rz.getOptionFactory().setOption("acidrechner.ws1",cmbWs1.getSelectedIndex());
    	rz.getOptionFactory().setOption("acidrechner.ws2",cmbWs2.getSelectedIndex());
    	rz.getOptionFactory().saveOptions();
    	rz.getFensterFactory().getFensterListe().disposeFrame(this);
    }
    @Override
	public void openWindow(){
   		if (!isVisible()) {
			setVisible(true);
		}
  		toFront();
  		rechnenAction(RECHNEN_LG);
   		txtWs1.requestFocus();
    }

	//hilfe
	private void hilfeAction() {
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"acidrechner.html",this));
	}

    private void hideAction() {
        rz.getFensterFactory().getFensterListe().sperren(this);
    }
}
