
/**
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package de.lunqual.rzpro.fenster.adressenfenster;
import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.Date;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.database.DBAdressen;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fenster.JSelectedTextField;
import de.lunqual.rzpro.fenster.dialoge.DialogControl;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.adressen.AdressItem;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.items.message.MessageItem;

/**
 *
 */
public class AdressEingabe extends JRzFrame {

    //GUI-Variablen
    private JMenuBar mb;
    	private JMenu mnuDatei;
    	private JMenu mnuExtras;
    	private JMenu mnuHilfe;
    private JPanel mainPanel;
    	private JPanel toolbarPanel;
    		private JToolBar tb1;
    	private JPanel contentPanel;
    		private JPanel itemPanel;
    	    	private JLabel lblFirma;
    	    	private JSelectedTextField txtFirma;
			    private JLabel lblVorname;
	    		private JSelectedTextField txtVorname;
			    private JLabel lblNachname;
	    		private JSelectedTextField txtNachname;
			    private JLabel lblPlz;
	    		private JSelectedTextField txtPlz;
			    private JLabel lblOrt;
	    		private JSelectedTextField txtOrt;
			    private JLabel lblStrasse;
	    		private JSelectedTextField txtStrasse;
			    private JLabel lblFon;
	    		private JSelectedTextField txtFon;
			    private JLabel lblFax;
	    		private JSelectedTextField txtFax;
			    private JLabel lblMobil;
	    		private JSelectedTextField txtMobil;
			    private JLabel lblMail;
	    		private JSelectedTextField txtMail;
			    private JLabel lblKd1;
	    		private JSelectedTextField txtKd1;
			    private JLabel lblKd2;
	    		private JSelectedTextField txtKd2;
	    		private JLabel lblTypKunde;
	    		private JCheckBox chkKunde;
	    		private JLabel lblTypLieferant;
	    		private JCheckBox chkLieferant;
	    		
    		private JPanel commentPanel;
    	    	private JLabel lblBemerkungen;
    			private JScrollPane scrComment;
    				private JTextArea txtComment;
    				private JPanel datumPanel;
    			    	private JLabel lblErstellt;
    			    	private JLabel lblGeaendert;
    	private JPanel buttonPanel;
    		private JButton btOK;
    		private JButton btHilfe;
    		private JButton btCancel;

	    //Actioncodes
	    public static final int         ACTION_OK_CODE = 1000;
	    public static final String     ACTION_OK_TEXT = "adresseingabe.action_ok";
	    public static final int         ACTION_ABBRECHEN_CODE = 1001;
	    public static final String     ACTION_ABBRECHEN_TEXT = "adresseingabe.action_abbrechen";
	    public static final int         ACTION_HILFE_CODE = 1002;
	    public static final String     ACTION_HILFE_TEXT = "action_hilfe";
	    public static final int         ACTION_HIDE_CODE = 1003;
	    public static final String     ACTION_HIDE_TEXT = "action_hide";

	    AdressItem      adresse;
	    JRzFrame		  origin;

    /** Creates new form AdressEingabe */
    public AdressEingabe(RzPro r, String name,Object extendedData) {
        super(r,name,extendedData);
        createActions();
        createGUIComponents();
        setGUIComponents();
        getMessage((MessageItem)extendedData);
    }

    @Override
	public void createGUIComponents() {
        mb = new JMenuBar();
		mnuDatei = new JMenu();
			mb.add(mnuDatei);
        mnuExtras = new JMenu();
        	mb.add(mnuExtras);
        mnuHilfe = new JMenu();
        	mb.add(mnuHilfe);
		setJMenuBar(mb);
		mainPanel = new JPanel(new BorderLayout());
		toolbarPanel = new JPanel(new BorderLayout());
			tb1 = new JToolBar();
			tb1.setFloatable(false);
			tb1.setRollover(true);
			toolbarPanel.add(tb1);
			mainPanel.add(toolbarPanel,BorderLayout.NORTH);
			contentPanel = new JPanel(new BorderLayout());
				itemPanel = new JPanel(new GridBagLayout());
		    		final GridBagConstraints c = new GridBagConstraints();
		    		c.weightx = 1;c.weighty=1;c.fill = GridBagConstraints.BOTH;
		    		lblFirma = new JLabel();lblFirma.setHorizontalAlignment(SwingConstants.TRAILING);
    					c.gridx=0;c.gridy=0;c.gridheight=1;c.gridwidth = 1;itemPanel.add(lblFirma,c);
    					txtFirma = new JSelectedTextField();
    					txtFirma.setColumns(20);
    					c.gridx=1;c.gridy=0;c.gridheight=1;c.gridwidth = 3;itemPanel.add(txtFirma,c);

    		    		lblVorname = new JLabel();lblVorname.setHorizontalAlignment(SwingConstants.TRAILING);
    					c.gridx=0;c.gridy=1;c.gridheight=1;c.gridwidth = 1;itemPanel.add(lblVorname,c);
    					txtVorname = new JSelectedTextField();
    					c.gridx=1;c.gridy=1;c.gridheight=1;c.gridwidth = 3;itemPanel.add(txtVorname,c);

    		    		lblNachname = new JLabel();lblNachname.setHorizontalAlignment(SwingConstants.TRAILING);
    					c.gridx=0;c.gridy=2;c.gridheight=1;c.gridwidth = 1;itemPanel.add(lblNachname,c);
    					txtNachname = new JSelectedTextField();
    					c.gridx=1;c.gridy=2;c.gridheight=1;c.gridwidth = 3;itemPanel.add(txtNachname,c);

    		    		lblPlz = new JLabel();lblPlz.setHorizontalAlignment(SwingConstants.TRAILING);
    					c.gridx=0;c.gridy=3;c.gridheight=1;c.gridwidth = 1;itemPanel.add(lblPlz,c);
    					txtPlz = new JSelectedTextField();
    					c.gridx=1;c.gridy=3;c.gridheight=1;c.gridwidth = 3;itemPanel.add(txtPlz,c);

    		    		lblOrt = new JLabel();lblOrt.setHorizontalAlignment(SwingConstants.TRAILING);
    					c.gridx=0;c.gridy=4;c.gridheight=1;c.gridwidth = 1;itemPanel.add(lblOrt,c);
    					txtOrt = new JSelectedTextField();
    					c.gridx=1;c.gridy=4;c.gridheight=1;c.gridwidth = 3;itemPanel.add(txtOrt,c);

    		    		lblStrasse = new JLabel();lblStrasse.setHorizontalAlignment(SwingConstants.TRAILING);
    					c.gridx=0;c.gridy=5;c.gridheight=1;c.gridwidth = 1;itemPanel.add(lblStrasse,c);
    					txtStrasse = new JSelectedTextField();
    					c.gridx=1;c.gridy=5;c.gridheight=1;c.gridwidth = 3;itemPanel.add(txtStrasse,c);

    		    		lblFon = new JLabel();lblFon.setHorizontalAlignment(SwingConstants.TRAILING);
    					c.gridx=0;c.gridy=6;c.gridheight=1;c.gridwidth = 1;itemPanel.add(lblFon,c);
    					txtFon = new JSelectedTextField();
    					c.gridx=1;c.gridy=6;c.gridheight=1;c.gridwidth = 3;itemPanel.add(txtFon,c);

    		    		lblFax = new JLabel();lblFax.setHorizontalAlignment(SwingConstants.TRAILING);
    					c.gridx=0;c.gridy=7;c.gridheight=1;c.gridwidth = 1;itemPanel.add(lblFax,c);
    					txtFax = new JSelectedTextField();
    					c.gridx=1;c.gridy=7;c.gridheight=1;c.gridwidth = 3;itemPanel.add(txtFax,c);

    		    		lblMobil = new JLabel();lblMobil.setHorizontalAlignment(SwingConstants.TRAILING);
    					c.gridx=0;c.gridy=8;c.gridheight=1;c.gridwidth = 1;itemPanel.add(lblMobil,c);
    					txtMobil = new JSelectedTextField();
    					c.gridx=1;c.gridy=8;c.gridheight=1;c.gridwidth = 3;itemPanel.add(txtMobil,c);

    		    		lblMail = new JLabel();lblMail.setHorizontalAlignment(SwingConstants.TRAILING);
    					c.gridx=0;c.gridy=9;c.gridheight=1;c.gridwidth = 1;itemPanel.add(lblMail,c);
    					txtMail = new JSelectedTextField();
    					c.gridx=1;c.gridy=9;c.gridheight=1;c.gridwidth = 3;itemPanel.add(txtMail,c);

    		    		lblKd1 = new JLabel();lblKd1.setHorizontalAlignment(SwingConstants.TRAILING);
    					c.gridx=0;c.gridy=10;c.gridheight=1;c.gridwidth = 1;itemPanel.add(lblKd1,c);
    					txtKd1 = new JSelectedTextField();
    					c.gridx=1;c.gridy=10;c.gridheight=1;c.gridwidth = 3;itemPanel.add(txtKd1,c);

    		    		lblKd2 = new JLabel();lblKd2.setHorizontalAlignment(SwingConstants.TRAILING);
    					c.gridx=0;c.gridy=11;c.gridheight=1;c.gridwidth = 1;itemPanel.add(lblKd2,c);
    					txtKd2 = new JSelectedTextField();
    					c.gridx=1;c.gridy=11;c.gridheight=1;c.gridwidth = 3;itemPanel.add(txtKd2,c);

    		    		lblTypKunde = new JLabel();lblTypKunde.setHorizontalAlignment(SwingConstants.TRAILING);
    					c.gridx=0;c.gridy=12;c.gridheight=1;c.gridwidth = 1;itemPanel.add(lblTypKunde,c);
    					chkKunde = new JCheckBox();
    					c.gridx=1;c.gridy=12;c.gridheight=1;c.gridwidth = 3;itemPanel.add(chkKunde,c);

    		    		lblTypLieferant = new JLabel();lblTypLieferant.setHorizontalAlignment(SwingConstants.TRAILING);
    					c.gridx=0;c.gridy=13;c.gridheight=1;c.gridwidth = 1;itemPanel.add(lblTypLieferant,c);
    					chkLieferant = new JCheckBox();
    					c.gridx=1;c.gridy=13;c.gridheight=1;c.gridwidth = 3;itemPanel.add(chkLieferant,c);
    					
				contentPanel.add(itemPanel,BorderLayout.WEST);
				commentPanel = new JPanel(new BorderLayout());
					lblBemerkungen = new JLabel();
						lblBemerkungen.setHorizontalAlignment(SwingConstants.CENTER);
					commentPanel.add(lblBemerkungen,BorderLayout.NORTH);
					scrComment = new JScrollPane();
						txtComment = new JTextArea();
						scrComment.setViewportView(txtComment);
						commentPanel.add(scrComment,BorderLayout.CENTER);
					contentPanel.add(commentPanel,BorderLayout.CENTER);
						datumPanel = new JPanel(new BorderLayout());
						lblErstellt = new JLabel();
							lblErstellt.setHorizontalAlignment(SwingConstants.CENTER);
						datumPanel.add(lblErstellt,BorderLayout.NORTH);
						lblGeaendert = new JLabel();
							lblGeaendert.setHorizontalAlignment(SwingConstants.CENTER);
						datumPanel.add(lblGeaendert,BorderLayout.SOUTH);
					contentPanel.add(datumPanel,BorderLayout.SOUTH);
			mainPanel.add(contentPanel,BorderLayout.CENTER);
			buttonPanel = new JPanel(new GridLayout(1,3));
				btOK = new JButton();
					buttonPanel.add(btOK);
				btHilfe = new JButton();
					buttonPanel.add(btHilfe);
				btCancel = new JButton();
					buttonPanel.add(btCancel);
		getContentPane().setLayout(new BorderLayout());
		getContentPane().add(toolbarPanel,BorderLayout.NORTH);
		getContentPane().add(mainPanel,BorderLayout.CENTER);
		getContentPane().add(buttonPanel,BorderLayout.SOUTH);

    }

    @Override
	public void createActions() {
        actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT, KeyEvent.VK_F1 ,0));
        actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT,KeyEvent.VK_F5 ,InputEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_OK_CODE),new AuswahlAction(rz,this,ACTION_OK_CODE,ACTION_OK_TEXT,KeyEvent.VK_O ,InputEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_ABBRECHEN_CODE),new AuswahlAction(rz,this,ACTION_ABBRECHEN_CODE,ACTION_ABBRECHEN_TEXT,KeyEvent.VK_ESCAPE ,0));

    }

    @Override
	public void setGUIComponents() {
       setTitle(rz.getVersionString() + " " + rz.getLocale().getString("adresseingabe.titel"));

      mnuDatei.setText(rz.getLocale().getString("menu.datei"));
      mnuExtras.setText(rz.getLocale().getString("menu.extras"));
      mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));

      mnuDatei.add(getAction(ACTION_OK_CODE));
      mnuDatei.add(getAction(ACTION_ABBRECHEN_CODE));
      mnuExtras.add(getAction(ACTION_HIDE_CODE));
      mnuHilfe.add(getAction(ACTION_HILFE_CODE));

      tb1.add(getAction(ACTION_OK_CODE));
      tb1.add(getAction(ACTION_ABBRECHEN_CODE));
      tb1.addSeparator();
      tb1.add(getAction(ACTION_HIDE_CODE));
      tb1.addSeparator();
      tb1.add(getAction(ACTION_HILFE_CODE));


      lblFirma.setText(rz.getLocale().getString("adresseingabe.label_firma"));
      lblVorname.setText(rz.getLocale().getString("adresseingabe.label_vorname"));
      lblNachname.setText(rz.getLocale().getString("adresseingabe.label_nachname"));
      lblStrasse.setText(rz.getLocale().getString("adresseingabe.label_strasse"));
      lblPlz.setText(rz.getLocale().getString("adresseingabe.label_plz"));
      lblOrt.setText(rz.getLocale().getString("adresseingabe.label_ort"));
      lblFon.setText(rz.getLocale().getString("adresseingabe.label_fon"));
      lblMobil.setText(rz.getLocale().getString("adresseingabe.label_mobil"));
      lblFax.setText(rz.getLocale().getString("adresseingabe.label_fax"));
      lblMail.setText(rz.getLocale().getString("adresseingabe.label_mail"));
      lblBemerkungen.setText(rz.getLocale().getString("adresseingabe.label_comment"));
      lblKd1.setText(rz.getLocale().getString("adresseingabe.label_kd1"));
      lblKd2.setText(rz.getLocale().getString("adresseingabe.label_kd2"));
      lblTypKunde.setText(rz.getLocale().getString("adresseingabe.label_typ_kunde"));
      lblTypLieferant.setText(rz.getLocale().getString("adresseingabe.label_typ_lieferant"));
      btOK.setAction(getAction(ACTION_OK_CODE));
      btCancel.setAction(getAction(ACTION_ABBRECHEN_CODE));
      btHilfe.setAction(getAction(ACTION_HILFE_CODE));

      setResizable(true);
      rz.getFontFactory().setFrameFonts(this);
      pack();
      rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;
    }

    @Override
	public void getMessage(MessageItem msg) {
        switch(msg.getMsgCode()) {
	    	case MessageItem.MSG_ACTIONPERFORMED:
	            switch(msg.getCode()){
	            	case ACTION_OK_CODE : okAction();break;
	            	case ACTION_ABBRECHEN_CODE :closeWindow();break;
	            	case ACTION_HILFE_CODE: hilfeAction();break;
	            	case ACTION_HIDE_CODE:hideAction();break;
	            default :
	                break;
           }
	    	break;
	       case MessageItem.MSG_EDIT_ADRESSE :
   				origin = msg.getOrigin();
	       		fromItem(msg.getCode());
	       		break;
	       default:
	            rz.getLogFactory().logMessage(2, "adressenAuswahl:", "auswahlAction:" + msg.getMsgCode());
           break;
        }
    }
   /** ok gedrückt... abspeichern
    */
    private void okAction() {
        final String firma = txtFirma.getText().trim();
        if(!firma.equals("")) {
            final int n = toItem();
			try {
					origin.getMessage(new MessageItem(MessageItem.MSG_EDIT_ADRESSE_REPLY, n, firma, this));
				} catch (final Exception e) {
			}
			closeWindow();
        }else {
			    DialogItem                                dlgItem =  new DialogItem(0,"",0.0,"","","","","","",null);
    	        dlgItem.setTyp(DialogControl.HINWEIS_DIALOG);
                dlgItem.setCaption(rz.getLocale().getString("adresseingabe.adresse_fehlt"));
                dlgItem.setTitel(rz.getLocale().getString("adresseingabe.adresse_fehlt"));
                dlgItem.setMessage(rz.getLocale().getString("adresseingabe.adresse_fehlt_message"));
                dlgItem.setIcon("warnung.png");
                dlgItem.setOk(rz.getLocale().getString("string_ok"));
               rz.getDialogFactory().getDialog(dlgItem);
			}
    }

    private void hideAction() {
        rz.getFensterFactory().getFensterListe().sperren(this);
    }

    private void hilfeAction() {
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"adresseingabe.html",this));
    }

    @Override
	public void openWindow(){
    	if(adresse != null) {
        if(!isVisible()) {
			setVisible(true);
		}
        toFront();
        txtFirma.requestFocus();
    	} else {
    		closeWindow();
    	}
    }
    @Override
	public void closeWindow(){
        rz.getFensterFactory().getFensterListe().disposeFrame(this);
    }
    /**
     * fromItem holt die Daten aus der Datenbank und überträgt sie
     * in das Fenster
     */

    private void fromItem(int aKey){
        adresse = rz.getDatabase().getAdressen().dbGetAdresse(aKey,false);
        if(adresse != null) {
	        txtFirma.setText(adresse.getFirma());
	        txtVorname.setText(adresse.getVorname());
	        txtNachname.setText(adresse.getNachname());
	        txtStrasse.setText(adresse.getStrasse());
	        txtPlz.setText(adresse.getPLZ());
	        txtOrt.setText(adresse.getOrt());
	        txtFon.setText(adresse.getFon());
	        txtMobil.setText(adresse.getMobil());
	        txtFax.setText(adresse.getFax());
	        txtMail.setText(adresse.getMail());
	        txtKd1.setText(adresse.getKdnummer1());
	        txtKd2.setText(adresse.getKdnummer2());
	        txtComment.setText(adresse.getComment());
	        lblErstellt.setText(rz.getLocale().getString("string_erstellt").replaceAll("%s",adresse.getErstelltToString()).replaceAll("%v",adresse.getUser1()));
	        lblGeaendert.setText(rz.getLocale().getString("string_geaendert").replaceAll("%s",adresse.getGeaendertToString()).replaceAll("%v",adresse.getUser2()));
	        switch(adresse.getTyp()) {
	        	case DBAdressen.TYP_BEIDE:
	        		chkKunde.setSelected(true);
	        		chkLieferant.setSelected(true);
	        		break;
	        	case DBAdressen.TYP_KUNDE:
	        		chkKunde.setSelected(true);
	        		chkLieferant.setSelected(false);
	        		break;
	        	case DBAdressen.TYP_LIEFERANT:
	        		chkKunde.setSelected(false);
	        		chkLieferant.setSelected(true);
	        		break;
	        	case DBAdressen.TYP_NULL:
	        		chkKunde.setSelected(false);
	        		chkLieferant.setSelected(false);
	        		break;
	        }
	        }
    }

    /**
     * toItem holt die Daten aus dem Fenster und überträgt sie in
     * die Datenbank
     */

    private int toItem(){
        int ret = 0;
        adresse.setFirma(txtFirma.getText().trim());
        adresse.setVorname(txtVorname.getText().trim());
        adresse.setNachname(txtNachname.getText().trim());
        adresse.setStrasse(txtStrasse.getText().trim());
        adresse.setPLZ(txtPlz.getText().trim());
        adresse.setOrt(txtOrt.getText().trim());
        adresse.setFon(txtFon.getText().trim());
        adresse.setMobil(txtMobil.getText().trim());
        adresse.setFax(txtFax.getText().trim());
        adresse.setMail(txtMail.getText().trim());
        adresse.setComment(txtComment.getText().trim());
        adresse.setUser2(rz.getDatabase().dbGetUser());
        adresse.setGeaendert(new Date());
        adresse.setKdnummer1(txtKd1.getText().trim());
        adresse.setKdnummer2(txtKd2.getText().trim());
        if(chkKunde.isSelected()==true&&chkLieferant.isSelected()==true) {
        	adresse.setTyp(DBAdressen.TYP_BEIDE);
        }else    if(chkKunde.isSelected()==false&&chkLieferant.isSelected()==false) {
        	adresse.setTyp(DBAdressen.TYP_NULL);
        }else         if(chkKunde.isSelected()==true&&chkLieferant.isSelected()==false) {
        	adresse.setTyp(DBAdressen.TYP_KUNDE);
        }else        if(chkKunde.isSelected()==false&&chkLieferant.isSelected()==true) {
        	adresse.setTyp(DBAdressen.TYP_LIEFERANT);
        }
        
        ret = rz.getDatabase().getAdressen().dbSaveAdresse(adresse);
        return ret;
    }

}
