/*
 *  Copyright (C) 2004-2005 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package de.lunqual.rzpro.fenster.auswahlfenster;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.text.SimpleDateFormat;
import java.util.Date;

import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;


import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.database.DBAbfrage;
import de.lunqual.rzpro.fenster.JNumberField;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fenster.JSelectedTextField;
import de.lunqual.rzpro.fenster.rzDatePicker.RzSimpleDatePicker;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.abfrage.AbfrageItem;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.deklarationen.DeklarationsListe;
import de.lunqual.rzpro.items.lager.LagerItem;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.mischungen.SortenItem;
import de.lunqual.rzpro.items.rezeptur.SteuerLagerItem;
import de.lunqual.rzpro.items.stichworte.StichwortListe;
import de.lunqual.rzpro.options.OptionFactory;


/**
 *
 * @author  administrator
 */
public class AbfrageFenster  extends JRzFrame{


	StichwortListe adressen;
	StichwortListe stichworte;
	DeklarationsListe deklarationen;

    //GUI-Variablen
	private JMenuBar mb;
    	private JMenu mnuDatei;
    	private JMenu mnuBearbeiten;
    	private JMenu mnuExtras;
    	private JMenu mnuHilfe;
    private JPanel mainPanel;
    	private JPanel toolbarPanel;
    		private JToolBar tb1;
    	private JPanel contentPanel;
    		private JPanel namePanel;
	    		private JCheckBox chkName;
    			private JSelectedTextField txtName;
        		private JPanel textPanel;
	    		private JCheckBox chkText;
    			private JSelectedTextField txtText;
    			
    		private JPanel lagerPanel;
    			private JCheckBox chkLager;
    			private JComboBox cmbLager;

        		private JPanel steuerLagerPanel;
    			private JCheckBox chkSteuerLager;
    			private JComboBox cmbSteuerLager;
    			
        		private JPanel sortenPanel;
    			private JCheckBox chkSorte;
    			private JComboBox cmbSorte;

        		private JPanel steuer_ArtikelPanel;
    			private JCheckBox chkSteuer_Artikel;
    			private JSelectedTextField txtSteuer_Artikel;
    			
    		private JPanel adressenPanel;
    			private JCheckBox chkAdressen;
    			private JPanel adressenButtonPanel;
	    			private JButton btAdressen;
	    			private JLabel lblAdressen;

	       		private JPanel deklarationenPanel;
	    			private JCheckBox chkDeklarationen;
	    			private JPanel deklarationenButtonPanel;
		    			private JButton btDeklarationen;
		    			private JLabel lblDeklarationen;

	    			private JPanel stichwortPanel;
	    			private JCheckBox chkStichworte;
	    			private JPanel stichwortButtonPanel;
		    			private JButton btStichworte;
		    			private JLabel lblStichworte;
	    		private JPanel staerkePanel;
    			private JCheckBox chkStaerke;
    			private JComboBox cmbSt1;
    			private JNumberField txtSt1;
    			private JLabel lblUnd;
    			private JNumberField txtSt2;
    		private JPanel extraktfreiPanel;
    			private JCheckBox chkExtraktfrei;
    			private JComboBox cmbExtraktfrei;
    		private JPanel extraktPanel;
    			private JCheckBox chkExtrakt;
    			private JComboBox cmbEx1;
    			private JNumberField txtEx1;
    			private JLabel lblEXUnd;
    			private JNumberField txtEx2;
        	private JPanel acidPanel;
    			private JCheckBox chkAcid;
    			private JComboBox cmbAc1;
    			private JNumberField txtAc1;
    			private JLabel lblACUnd;
    			private JNumberField txtAc2;
    		private JPanel brennwertPanel;
    			private JCheckBox chkBrennwert;
    			private JComboBox cmbBw1;
    			private JNumberField txtBw1;
    			private JLabel lblBWUnd;
    			private JNumberField txtBw2;
    		private JPanel lgPanel;
    			private JCheckBox chkLitergewicht;
    			private JComboBox cmbLg1;
    			private JNumberField txtLg1;
    			private JLabel lblLGUnd;
    			private JNumberField txtLg2;
    		private JPanel artikelPanel;
	    		private JCheckBox chkArtikel;
    			private JSelectedTextField txtArtikel;
    		private JPanel erstelltPanel;
    			private JCheckBox chkErstellt;
    			private JComboBox cmbEr1;
    			private RzSimpleDatePicker dtErVon;
    			private JLabel lblERUnd;
    			private  RzSimpleDatePicker dtErBis;
        	private JPanel geaendertPanel;
    			private JCheckBox chkGeaendert;
    			private JComboBox cmbGe1;
    			private RzSimpleDatePicker  dtGeVon;
    			private JLabel lblGEUnd;
    			private RzSimpleDatePicker  dtGeBis;
        	private JPanel user1Panel;
	    		private JCheckBox chkUser1;
    			private JSelectedTextField txtUser1;
            private JPanel user2Panel;
	    		private JCheckBox chkUser2;
    			private JSelectedTextField txtUser2;
            private JPanel tankPanel;
	    		private JCheckBox chkTank;
    			private JSelectedTextField txtTank;
    			

    				
    	private JPanel buttonPanel;
    		private JButton btClose;
    		private JButton btSuchen;

    // ActionCodes KalkulationEingabe
    public static final int         ACTION_CANCEL_CODE = 1000;
    public static final String      ACTION_CLOSE_TEXT = "abfragefenster.action_close";
    public static final int         ACTION_SUCHEN_CODE = 1001;
    public static final String      ACTION_SUCHEN_TEXT = "abfragefenster.action_suchen";
	public static final int         ACTION_HILFE_CODE  = 1002;
    public static final String     ACTION_HILFE_TEXT = "action_hilfe";
    public static final int         ACTION_HIDE_CODE  = 1003;
    public static final String     ACTION_HIDE_TEXT = "action_hide";
    public static final int         ACTION_ADRESSEN_CODE = 1004;
    public static final String      ACTION_ADRESSEN_TEXT = "abfragefenster.action_adressen";
    public static final int         ACTION_STICHWORTE_CODE = 1005;
    public static final String      ACTION_STICHWORTE_TEXT = "abfragefenster.action_stichworte";
    public static final int         ACTION_DEKLARATIONEN_CODE = 1006;
    public static final String      ACTION_DEKLARATIONEN_TEXT = "abfragefenster.action_deklarationen";
    Auswahl			origin;

    public static final String 			CALENDAR_FORMAT		=	"d. MMMMMM yyyy";

    /** Creates new form AdressAuswahl */

    public AbfrageFenster(RzPro r, String name,Object extendedData) {
        super(r,name,extendedData);
        adressen = new StichwortListe();
        stichworte = new StichwortListe();
        deklarationen= new DeklarationsListe(rz);
        createActions();
        createGUIComponents();
        setGUIComponents();
        getMessage((MessageItem)extendedData);
    }

    public void createGUIComponents() {
        mb = new JMenuBar();
		mnuDatei = new JMenu();
			mb.add(mnuDatei);
		mnuBearbeiten = new JMenu();
			mb.add(mnuBearbeiten);
        mnuExtras = new JMenu();
        	mb.add(mnuExtras);
        mnuHilfe = new JMenu();
        	mb.add(mnuHilfe);
		setJMenuBar(mb);
		mainPanel = new JPanel(new BorderLayout());
			toolbarPanel = new JPanel(new BorderLayout());
				tb1 = new JToolBar();
				tb1.setFloatable(false);
				tb1.setRollover(true);
				toolbarPanel.add(tb1);
			mainPanel.add(toolbarPanel,BorderLayout.NORTH);
			contentPanel  = new JPanel();
			contentPanel.setLayout(new FlowLayout());
			//NamePanel
				namePanel = new JPanel(new FlowLayout());
					chkName = new JCheckBox();
						chkName.setSelected(false);
		        	    chkName.addActionListener(new ActionListener() {
	        	        	public void actionPerformed(ActionEvent evt) {
	        	        		try {
	        	        	    if(chkName.isSelected()) {
	        	        	    	txtName.setEnabled(true);
	        	        	    	txtName.requestFocus();
	        	        	    }else {
	        	        	    	txtName.setEnabled(false);
	        	        	    }
	        	        		}catch (final Exception e) {}
	        	        	}
		        	    });
						namePanel.add(chkName,BorderLayout.WEST);
					txtName = new JSelectedTextField();
					    txtName.setColumns(20);
						txtName.setEnabled(false);
					namePanel.add(txtName,BorderLayout.CENTER);
				    namePanel.setBorder(BorderFactory.createRaisedBevelBorder());
			contentPanel.add(namePanel);

			//InhaltPanel
			textPanel = new JPanel(new FlowLayout());
				chkText = new JCheckBox();
					chkText.setSelected(false);
	        	    chkText.addActionListener(new ActionListener() {
        	        	public void actionPerformed(ActionEvent evt) {
        	        		try {
        	        	    if(chkText.isSelected()) {
        	        	    	txtText.setEnabled(true);
        	        	    	txtText.requestFocus();
        	        	    }else {
        	        	    	txtText.setEnabled(false);
        	        	    }
        	        		}catch (final Exception e) {}
        	        	}
	        	    });
					textPanel.add(chkText,BorderLayout.WEST);
				txtText = new JSelectedTextField();
					txtText.setColumns(20);
					txtText.setEnabled(false);
				textPanel.add(txtText,BorderLayout.CENTER);
			    textPanel.setBorder(BorderFactory.createRaisedBevelBorder());
		contentPanel.add(textPanel);

			//LagerPanel
			lagerPanel = new JPanel(new FlowLayout());
				cmbLager = new JComboBox();
					rz.getDatabase().getLager().setLagerCmb(cmbLager, rz.getOptionFactory().getOption("abfragefenster.cmb_lager", 0));
					cmbLager.setEnabled(false);
				chkLager = new JCheckBox();
					chkLager.setSelected(false);
	        	    chkLager.addActionListener(new ActionListener() {
	    	        	public void actionPerformed(ActionEvent evt) {
	    	        		try {
	    	        	    if(chkLager.isSelected()) {
	    	        	    	cmbLager.setEnabled(true);
	    	        	    	cmbLager.requestFocus();
	    	        	    }else {
	    	        	    	cmbLager.setEnabled(false);
	    	        	    }
	    	        		}catch (final Exception e) {}
	    	        	}
	        	    });
				lagerPanel.add(chkLager,BorderLayout.WEST);
				lagerPanel.add(cmbLager,BorderLayout.EAST);
			    lagerPanel.setBorder(BorderFactory.createRaisedBevelBorder());
		    contentPanel.add(lagerPanel);

		  //SteuerLagerPanel
			steuerLagerPanel = new JPanel(new FlowLayout());
				cmbSteuerLager = new JComboBox();
					rz.getDatabase().getRezeptur().setSteuerlagerCmb(cmbSteuerLager, rz.getOptionFactory().getOption("abfragefenster.cmb_steuerLager", 0));
					cmbSteuerLager.setEnabled(false);
				chkSteuerLager = new JCheckBox();
					chkSteuerLager.setSelected(false);
	        	    chkSteuerLager.addActionListener(new ActionListener() {
	    	        	public void actionPerformed(ActionEvent evt) {
	    	        		try {
	    	        	    if(chkSteuerLager.isSelected()) {
	    	        	    	cmbSteuerLager.setEnabled(true);
	    	        	    	cmbSteuerLager.requestFocus();
	    	        	    }else {
	    	        	    	cmbSteuerLager.setEnabled(false);
	    	        	    }
	    	        		}catch (final Exception e) {}
	    	        	}
	        	    });
				steuerLagerPanel.add(chkSteuerLager,BorderLayout.WEST);
				steuerLagerPanel.add(cmbSteuerLager,BorderLayout.EAST);
			    steuerLagerPanel.setBorder(BorderFactory.createRaisedBevelBorder());
		    contentPanel.add(steuerLagerPanel);

			  //SortePanel
				sortenPanel = new JPanel(new FlowLayout());
					cmbSorte = new JComboBox();
						rz.getDatabase().getMischungen().setSortenCmb(cmbSorte, rz.getOptionFactory().getOption("abfragefenster.cmb_sorte", 0));
						cmbSorte.setEnabled(false);
					chkSorte = new JCheckBox();
						chkSorte.setSelected(false);
		        	    chkSorte.addActionListener(new ActionListener() {
		    	        	public void actionPerformed(ActionEvent evt) {
		    	        		try {
		    	        	    if(chkSorte.isSelected()) {
		    	        	    	cmbSorte.setEnabled(true);
		    	        	    	cmbSorte.requestFocus();
		    	        	    }else {
		    	        	    	cmbSorte.setEnabled(false);
		    	        	    }
		    	        		}catch (final Exception e) {}
		    	        	}
		        	    });
					sortenPanel.add(chkSorte,BorderLayout.WEST);
					sortenPanel.add(cmbSorte,BorderLayout.EAST);
				    sortenPanel.setBorder(BorderFactory.createRaisedBevelBorder());
			    contentPanel.add(sortenPanel);
		
			    
				  //Steuer_Artikel
					steuer_ArtikelPanel = new JPanel(new FlowLayout());
						txtSteuer_Artikel = new JSelectedTextField(); 
							txtSteuer_Artikel.setColumns(20);
							txtSteuer_Artikel.setEnabled(false);
						chkSteuer_Artikel = new JCheckBox();
							chkSteuer_Artikel.setSelected(false);
			        	    chkSteuer_Artikel.addActionListener(new ActionListener() {
			    	        	public void actionPerformed(ActionEvent evt) {
			    	        		try {
			    	        	    if(chkSteuer_Artikel.isSelected()) {
			    	        	    	txtSteuer_Artikel.setEnabled(true);
			    	        	    	cmbSorte.requestFocus();
			    	        	    }else {
			    	        	    	txtSteuer_Artikel.setEnabled(false);
			    	        	    }
			    	        		}catch (final Exception e) {}
			    	        	}
			        	    });
			        	steuer_ArtikelPanel .add(chkSteuer_Artikel,BorderLayout.WEST);
			        	steuer_ArtikelPanel .add(txtSteuer_Artikel,BorderLayout.CENTER);
			        	steuer_ArtikelPanel .setBorder(BorderFactory.createRaisedBevelBorder());
				    contentPanel.add(steuer_ArtikelPanel );
		
			//AdressenPanel
			adressenPanel = new JPanel(new FlowLayout());
				chkAdressen = new JCheckBox();
					chkAdressen.setSelected(false);
	        	    chkAdressen.addActionListener(new ActionListener() {
	    	        	public void actionPerformed(ActionEvent evt) {
	    	        		try {
	    	        	    if(chkAdressen.isSelected()) {
	    	        	    	btAdressen.setEnabled(true);
	    	        	    	getAction(ACTION_ADRESSEN_CODE).setEnabled(true);
	    	        	    	lblAdressen.setEnabled(true);
	    	        	    	btAdressen.requestFocus();
	    	        	    }else {
	    	        	    	btAdressen.setEnabled(false);
	    	        	    	getAction(ACTION_ADRESSEN_CODE).setEnabled(false);
	    	        	    	lblAdressen.setEnabled(false);
	    	        	    }
	    	        		}catch (final Exception e) {}
	    	        	}
	        	    });
					adressenPanel.add(chkAdressen,BorderLayout.WEST);
					adressenButtonPanel=new JPanel(new FlowLayout());
						btAdressen=new JButton();
						adressenButtonPanel.add(btAdressen,BorderLayout.EAST);
						lblAdressen=new JLabel();
						adressenButtonPanel.add(lblAdressen,BorderLayout.CENTER);
					adressenPanel.add(adressenButtonPanel,BorderLayout.EAST);
			    adressenPanel.setBorder(BorderFactory.createRaisedBevelBorder());
		    contentPanel.add(adressenPanel);

		    
		    
			//deklarationenPanel
			deklarationenPanel = new JPanel(new FlowLayout());
				chkDeklarationen = new JCheckBox();
					chkDeklarationen.setSelected(false);
	        	    chkDeklarationen.addActionListener(new ActionListener() {
	    	        	public void actionPerformed(ActionEvent evt) {
	    	        		try {
	    	        	    if(chkDeklarationen.isSelected()) {
	    	        	    	btDeklarationen.setEnabled(true);
	    	        	    	getAction(ACTION_DEKLARATIONEN_CODE).setEnabled(true);
	    	        	    	lblDeklarationen.setEnabled(true);
	    	        	    	btDeklarationen.requestFocus();
	    	        	    }else {
	    	        	    	btDeklarationen.setEnabled(false);
	    	        	    	getAction(ACTION_DEKLARATIONEN_CODE).setEnabled(false);
	    	        	    	lblDeklarationen.setEnabled(false);
	    	        	    }
	    	        		}catch (final Exception e) {}
	    	        	}
	        	    });
					deklarationenPanel.add(chkDeklarationen,BorderLayout.WEST);
					deklarationenButtonPanel=new JPanel(new BorderLayout());
						btDeklarationen=new JButton();
						deklarationenButtonPanel.add(btDeklarationen,BorderLayout.EAST);
						lblDeklarationen=new JLabel();
						deklarationenButtonPanel.add(lblDeklarationen,BorderLayout.CENTER);
				    deklarationenPanel.add(deklarationenButtonPanel,BorderLayout.EAST);
			    deklarationenPanel.setBorder(BorderFactory.createRaisedBevelBorder());
		    contentPanel.add(deklarationenPanel);


			//StichwortPanel
			stichwortPanel = new JPanel(new FlowLayout());
				chkStichworte = new JCheckBox();
					chkStichworte.setSelected(false);
	        	    chkStichworte.addActionListener(new ActionListener() {
	    	        	public void actionPerformed(ActionEvent evt) {
	    	        		try {
	    	        	    if(chkStichworte.isSelected()) {
	    	        	    	btStichworte.setEnabled(true);
	    	        	    	getAction(ACTION_STICHWORTE_CODE).setEnabled(true);
	    	        	    	lblStichworte.setEnabled(true);
	    	        	    	btStichworte.requestFocus();
	    	        	    }else {
	    	        	    	btStichworte.setEnabled(false);
	    	        	    	getAction(ACTION_STICHWORTE_CODE).setEnabled(false);
	    	        	    	lblStichworte.setEnabled(false);
	    	        	    }
	    	        		}catch (final Exception e) {}
	    	        	}
	        	    });
					stichwortPanel.add(chkStichworte,BorderLayout.WEST);
					stichwortButtonPanel=new JPanel(new BorderLayout());
						btStichworte=new JButton();
						stichwortButtonPanel.add(btStichworte,BorderLayout.EAST);
						lblStichworte=new JLabel();
						stichwortButtonPanel.add(lblStichworte,BorderLayout.CENTER);
				    stichwortPanel.add(stichwortButtonPanel,BorderLayout.EAST);
			    stichwortPanel.setBorder(BorderFactory.createRaisedBevelBorder());
		    contentPanel.add(stichwortPanel);

			//StaerkePanel
			staerkePanel = new JPanel(new FlowLayout());
				chkStaerke = new JCheckBox();
					chkStaerke.setSelected(false);
	        	    chkStaerke.addActionListener(new ActionListener() {
        	        	public void actionPerformed(ActionEvent evt) {
        	        		try {
        	        	    if(chkStaerke.isSelected()) {
        	        	    	txtSt1.setEnabled(true);
        	        	    	cmbSt1.setEnabled(true);
        	        	    	if(cmbSt1.getSelectedIndex()==3) {
            	        	    	txtSt2.setEnabled(true);
            	        	    	lblUnd.setEnabled(true);
        	        	    	} else {
            	        	    	txtSt2.setEnabled(false);
            	        	    	lblUnd.setEnabled(false);
        	        	    	}
        	        	    	cmbSt1.requestFocus();
        	        	    }else {
        	        	    	txtSt1.setEnabled(false);
        	        	    	txtSt2.setEnabled(false);
        	        	    	cmbSt1.setEnabled(false);
        	        	    	lblUnd.setEnabled(false);
        	        	    }
        	        		}catch (final Exception e) {}
        	        	}
	        	    });
			    staerkePanel.add(chkStaerke);
			    cmbSt1 = new JComboBox();
			    	cmbSt1.addItem(rz.getLocale().getString("abfragefenster.label_st1_gleich"));
			    	cmbSt1.addItem(rz.getLocale().getString("abfragefenster.label_st1_kleiner_gleich"));
			    	cmbSt1.addItem(rz.getLocale().getString("abfragefenster.label_st1_groesser_gleich"));
			    	cmbSt1.addItem(rz.getLocale().getString("abfragefenster.label_st1_zwischen"));
			    	cmbSt1.setSelectedIndex(0);
			    	cmbSt1.setEnabled(false);
	        	    cmbSt1.addActionListener(new ActionListener() {
        	        	public void actionPerformed(ActionEvent evt) {
        	        		try {
        	        			if((cmbSt1.getSelectedIndex()==3) && cmbSt1.isEnabled()) {
        	        				lblUnd.setEnabled(true);
        	        				txtSt2.setEnabled(true);
        	        			}else {
        	        				lblUnd.setEnabled(false);
        	        				txtSt2.setEnabled(false);
        	        			}
        	        		}catch (final Exception e) {}
        	        	}
	        	    });
			    staerkePanel.add(cmbSt1);
			    txtSt1 = new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_NORMAL),0.0,0.0,100.0);
			    	txtSt1.setEnabled(false);
			    	txtSt1.setColumns(20);
			    staerkePanel.add(txtSt1);
			    lblUnd = new JLabel();
			    	lblUnd.setHorizontalAlignment(SwingConstants.CENTER);
			    	lblUnd.setEnabled(false);
			    staerkePanel.add(lblUnd);
			    txtSt2 = new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_NORMAL),0.0,0.0,100.0);
			    	txtSt2.setEnabled(false);
			    	txtSt2.setColumns(20);
			    staerkePanel.add(txtSt2);
			    staerkePanel.setBorder(BorderFactory.createRaisedBevelBorder());
			contentPanel.add(staerkePanel);

			//extraktfrei
			extraktfreiPanel = new JPanel(new FlowLayout());
				chkExtraktfrei = new JCheckBox();
	        	    chkExtraktfrei.addActionListener(new ActionListener() {
	    	        	public void actionPerformed(ActionEvent evt) {
	    	        		try {
	    	        	    if(chkExtraktfrei.isSelected()) {
	    	        	    	cmbExtraktfrei.setEnabled(true);
	    	        	    	cmbExtraktfrei.requestFocus();
	    	        	    }else {
	    	        	    	cmbExtraktfrei.setEnabled(false);
	    	        	    }
	    	        		}catch (final Exception e) {}
	    	        	}
	        	    });
					chkExtraktfrei.setSelected(false);
				extraktfreiPanel.add(chkExtraktfrei,BorderLayout.WEST);
				cmbExtraktfrei = new JComboBox();
					cmbExtraktfrei.addItem(rz.getLocale().getString("string_ja"));
					cmbExtraktfrei.addItem(rz.getLocale().getString("string_nein"));
					cmbExtraktfrei.setEnabled(false);
				extraktfreiPanel.add(cmbExtraktfrei);
			    extraktfreiPanel.setBorder(BorderFactory.createRaisedBevelBorder());
			contentPanel.add(extraktfreiPanel);

			//ExtraktPanel
			extraktPanel = new JPanel(new FlowLayout());
				chkExtrakt = new JCheckBox();
					chkExtrakt.setSelected(false);
	        	    chkExtrakt.addActionListener(new ActionListener() {
        	        	public void actionPerformed(ActionEvent evt) {
        	        		try {
        	        	    if(chkExtrakt.isSelected()) {
        	        	    	txtEx1.setEnabled(true);
        	        	    	cmbEx1.setEnabled(true);
        	        	    	if(cmbEx1.getSelectedIndex()==3) {
            	        	    	txtEx2.setEnabled(true);
            	        	    	lblEXUnd.setEnabled(true);
        	        	    	} else {
            	        	    	txtEx2.setEnabled(false);
            	        	    	lblEXUnd.setEnabled(false);
        	        	    	}
        	        	    	cmbEx1.requestFocus();
        	        	    }else {
        	        	    	txtEx1.setEnabled(false);
        	        	    	txtEx2.setEnabled(false);
        	        	    	cmbEx1.setEnabled(false);
        	        	    	lblEXUnd.setEnabled(false);
        	        	    }
        	        		}catch (final Exception e) {}
        	        	}
	        	    });
			    extraktPanel.add(chkExtrakt);
			    cmbEx1 = new JComboBox();
			    	cmbEx1.addItem(rz.getLocale().getString("abfragefenster.label_st1_gleich"));
			    	cmbEx1.addItem(rz.getLocale().getString("abfragefenster.label_st1_kleiner_gleich"));
			    	cmbEx1.addItem(rz.getLocale().getString("abfragefenster.label_st1_groesser_gleich"));
			    	cmbEx1.addItem(rz.getLocale().getString("abfragefenster.label_st1_zwischen"));
			    	cmbEx1.setSelectedIndex(0);
			    	cmbEx1.setEnabled(false);
	        	    cmbEx1.addActionListener(new ActionListener() {
        	        	public void actionPerformed(ActionEvent evt) {
        	        		try {
        	        			if((cmbEx1.getSelectedIndex()==3) && cmbEx1.isEnabled()) {
        	        				lblEXUnd.setEnabled(true);
        	        				txtEx2.setEnabled(true);
        	        			}else {
        	        				lblEXUnd.setEnabled(false);
        	        				txtEx2.setEnabled(false);
        	        			}
        	        		}catch (final Exception e) {}
        	        	}
	        	    });
			    extraktPanel.add(cmbEx1);
			    txtEx1 = new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_NORMAL),0.0,0.0,Double.POSITIVE_INFINITY);
			    	txtEx1.setEnabled(false);
			    	txtEx1.setColumns(10);
			    extraktPanel.add(txtEx1);
			    lblEXUnd = new JLabel();
			    	lblEXUnd.setHorizontalAlignment(SwingConstants.CENTER);
			    	lblEXUnd.setEnabled(false);
			    extraktPanel.add(lblEXUnd);
			    txtEx2 = new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_NORMAL),0.0,0.0,Double.POSITIVE_INFINITY);
			    	txtEx2.setEnabled(false);
			    	txtEx2.setColumns(10);
			    extraktPanel.add(txtEx2);
			    extraktPanel.setBorder(BorderFactory.createRaisedBevelBorder());
			contentPanel.add(extraktPanel);


			//			SäurePanel
			acidPanel = new JPanel(new FlowLayout());
				chkAcid = new JCheckBox();
					chkAcid.setSelected(false);
	        	    chkAcid.addActionListener(new ActionListener() {
        	        	public void actionPerformed(ActionEvent evt) {
        	        		try {
        	        	    if(chkAcid.isSelected()) {
        	        	    	txtAc1.setEnabled(true);
        	        	    	cmbAc1.setEnabled(true);
        	        	    	if(cmbAc1.getSelectedIndex()==3) {
            	        	    	txtAc2.setEnabled(true);
            	        	    	lblACUnd.setEnabled(true);
        	        	    	} else {
            	        	    	txtAc2.setEnabled(false);
            	        	    	lblACUnd.setEnabled(false);
        	        	    	}
        	        	    	cmbEx1.requestFocus();
        	        	    }else {
        	        	    	txtAc1.setEnabled(false);
        	        	    	txtAc2.setEnabled(false);
        	        	    	cmbAc1.setEnabled(false);
        	        	    	lblACUnd.setEnabled(false);
        	        	    }
        	        		}catch (final Exception e) {}
        	        	}
	        	    });
			    acidPanel.add(chkAcid);
			    cmbAc1 = new JComboBox();
			    	cmbAc1.addItem(rz.getLocale().getString("abfragefenster.label_st1_gleich"));
			    	cmbAc1.addItem(rz.getLocale().getString("abfragefenster.label_st1_kleiner_gleich"));
			    	cmbAc1.addItem(rz.getLocale().getString("abfragefenster.label_st1_groesser_gleich"));
			    	cmbAc1.addItem(rz.getLocale().getString("abfragefenster.label_st1_zwischen"));
			    	cmbAc1.setSelectedIndex(0);
			    	cmbAc1.setEnabled(false);
	        	    cmbAc1.addActionListener(new ActionListener() {
        	        	public void actionPerformed(ActionEvent evt) {
        	        		try {
        	        			if((cmbAc1.getSelectedIndex()==3) && cmbAc1.isEnabled()) {
        	        				lblACUnd.setEnabled(true);
        	        				txtAc2.setEnabled(true);
        	        			}else {
        	        				lblACUnd.setEnabled(false);
        	        				txtAc2.setEnabled(false);
        	        			}
        	        		}catch (final Exception e) {}
        	        	}
	        	    });
			    acidPanel.add(cmbAc1);
			    txtAc1 = new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_NORMAL),0.0,0.0,Double.POSITIVE_INFINITY);
			    	txtAc1.setEnabled(false);
			    	txtAc1.setColumns(10);
			    acidPanel.add(txtAc1);
			    lblACUnd = new JLabel();
			    	lblACUnd.setHorizontalAlignment(SwingConstants.CENTER);
			    	lblACUnd.setEnabled(false);
			    acidPanel.add(lblACUnd);
			    txtAc2 = new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_NORMAL),0.0,0.0,Double.POSITIVE_INFINITY);
			    	txtAc2.setEnabled(false);
			    	txtAc2.setColumns(10);
			    acidPanel.add(txtAc2);
			    acidPanel.setBorder(BorderFactory.createRaisedBevelBorder());
			contentPanel.add(acidPanel);

			//BrennwertPanel
			brennwertPanel = new JPanel(new FlowLayout());
			chkBrennwert = new JCheckBox();
				chkBrennwert.setSelected(false);
        	    chkBrennwert.addActionListener(new ActionListener() {
    	        	public void actionPerformed(ActionEvent evt) {
    	        		try {
    	        	    if(chkBrennwert.isSelected()) {
    	        	    	txtBw1.setEnabled(true);
    	        	    	cmbBw1.setEnabled(true);
    	        	    	if(cmbBw1.getSelectedIndex()==3) {
        	        	    	txtBw2.setEnabled(true);
        	        	    	lblBWUnd.setEnabled(true);
    	        	    	} else {
        	        	    	txtBw2.setEnabled(false);
        	        	    	lblBWUnd.setEnabled(false);
    	        	    	}
    	        	    	cmbBw1.requestFocus();
    	        	    }else {
    	        	    	txtBw1.setEnabled(false);
    	        	    	txtBw2.setEnabled(false);
    	        	    	cmbBw1.setEnabled(false);
    	        	    	lblBWUnd.setEnabled(false);
    	        	    }
    	        		}catch (final Exception e) {}
    	        	}
        	    });
		    brennwertPanel.add(chkBrennwert);
		    cmbBw1 = new JComboBox();
		    	cmbBw1.addItem(rz.getLocale().getString("abfragefenster.label_st1_gleich"));
		    	cmbBw1.addItem(rz.getLocale().getString("abfragefenster.label_st1_kleiner_gleich"));
		    	cmbBw1.addItem(rz.getLocale().getString("abfragefenster.label_st1_groesser_gleich"));
		    	cmbBw1.addItem(rz.getLocale().getString("abfragefenster.label_st1_zwischen"));
		    	cmbBw1.setSelectedIndex(0);
		    	cmbBw1.setEnabled(false);
        	    cmbBw1.addActionListener(new ActionListener() {
    	        	public void actionPerformed(ActionEvent evt) {
    	        		try {
    	        			if((cmbBw1.getSelectedIndex()==3) && cmbBw1.isEnabled()) {
    	        				lblBWUnd.setEnabled(true);
    	        				txtBw2.setEnabled(true);
    	        			}else {
    	        				lblBWUnd.setEnabled(false);
    	        				txtBw2.setEnabled(false);
    	        			}
    	        		}catch (final Exception e) {}
    	        	}
        	    });
		    brennwertPanel.add(cmbBw1);
		    txtBw1 = new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_NORMAL),0.0,0.0,Double.POSITIVE_INFINITY);
		    	txtBw1.setEnabled(false);
		    	txtBw1.setColumns(10);
		    brennwertPanel.add(txtBw1);
		    lblBWUnd = new JLabel();
		    	lblBWUnd.setHorizontalAlignment(SwingConstants.CENTER);
		    	lblBWUnd.setEnabled(false);
		    brennwertPanel.add(lblBWUnd);
		    txtBw2 = new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_NORMAL),0.0,0.0,Double.POSITIVE_INFINITY);
		    	txtBw2.setEnabled(false);
		    	txtBw2.setColumns(10);
		    brennwertPanel.add(txtBw2);
		    brennwertPanel.setBorder(BorderFactory.createRaisedBevelBorder());
		contentPanel.add(brennwertPanel);


			//LitergewichtPanel
			lgPanel = new JPanel(new FlowLayout());
				chkLitergewicht = new JCheckBox();
					chkLitergewicht.setSelected(false);
	        	    chkLitergewicht.addActionListener(new ActionListener() {
        	        	public void actionPerformed(ActionEvent evt) {
        	        		try {
        	        	    if(chkLitergewicht.isSelected()) {
        	        	    	txtLg1.setEnabled(true);
        	        	    	cmbLg1.setEnabled(true);
        	        	    	if(cmbLg1.getSelectedIndex()==3) {
            	        	    	txtLg2.setEnabled(true);
            	        	    	lblLGUnd.setEnabled(true);
        	        	    	} else {
            	        	    	txtLg2.setEnabled(false);
            	        	    	lblLGUnd.setEnabled(false);
        	        	    	}
        	        	    	cmbLg1.requestFocus();
        	        	    }else {
        	        	    	txtLg1.setEnabled(false);
        	        	    	txtLg2.setEnabled(false);
        	        	    	cmbLg1.setEnabled(false);
        	        	    	lblLGUnd.setEnabled(false);
        	        	    }
        	        		}catch (final Exception e) {}
        	        	}
	        	    });
			    lgPanel.add(chkLitergewicht);
			    cmbLg1 = new JComboBox();
			    	cmbLg1.addItem(rz.getLocale().getString("abfragefenster.label_st1_gleich"));
			    	cmbLg1.addItem(rz.getLocale().getString("abfragefenster.label_st1_kleiner_gleich"));
			    	cmbLg1.addItem(rz.getLocale().getString("abfragefenster.label_st1_groesser_gleich"));
			    	cmbLg1.addItem(rz.getLocale().getString("abfragefenster.label_st1_zwischen"));
			    	cmbLg1.setSelectedIndex(0);
			    	cmbLg1.setEnabled(false);
	        	    cmbLg1.addActionListener(new ActionListener() {
        	        	public void actionPerformed(ActionEvent evt) {
        	        		try {
        	        			if((cmbLg1.getSelectedIndex()==3) && cmbLg1.isEnabled()) {
        	        				lblLGUnd.setEnabled(true);
        	        				txtLg2.setEnabled(true);
        	        			}else {
        	        				lblLGUnd.setEnabled(false);
        	        				txtLg2.setEnabled(false);
        	        			}
        	        		}catch (final Exception e) {}
        	        	}
	        	    });
			    lgPanel.add(cmbLg1);
			    txtLg1 = new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_NORMAL),0.0,0.0,Double.POSITIVE_INFINITY);
			    	txtLg1.setEnabled(false);
			    	txtLg1.setColumns(10);
			    lgPanel.add(txtLg1);
			    lblLGUnd = new JLabel();
			    	lblLGUnd.setHorizontalAlignment(SwingConstants.CENTER);
			    	lblLGUnd.setEnabled(false);
			    lgPanel.add(lblLGUnd);
			    txtLg2 = new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_NORMAL),0.0,0.0,Double.POSITIVE_INFINITY);
			    	txtLg2.setEnabled(false);
			    	txtLg2.setColumns(10);
			    lgPanel.add(txtLg2);
			    lgPanel.setBorder(BorderFactory.createRaisedBevelBorder());
			contentPanel.add(lgPanel);

//			Artikelnummerpanel
			artikelPanel = new JPanel(new FlowLayout());
				chkArtikel= new JCheckBox();
					chkArtikel.setSelected(false);
	        	    chkArtikel.addActionListener(new ActionListener() {
        	        	public void actionPerformed(ActionEvent evt) {
        	        		try {
	        	        	    if(chkArtikel.isSelected()) {
	        	        	    	txtArtikel.setEnabled(true);
	        	        	    	txtArtikel.requestFocus();
	        	        	    }else {
	        	        	    	txtArtikel.setEnabled(false);
	        	        	    }
        	        		}catch (final Exception e) {}
        	        	}
	        	    });
					artikelPanel.add(chkArtikel,BorderLayout.WEST);
				txtArtikel = new JSelectedTextField();
					txtArtikel.setColumns(20);
					txtArtikel.setEnabled(false);
				artikelPanel.add(txtArtikel,BorderLayout.CENTER);
			    artikelPanel.setBorder(BorderFactory.createRaisedBevelBorder());
		contentPanel.add(artikelPanel);

	//		ErstelltPanel
			erstelltPanel = new JPanel(new FlowLayout());
			erstelltPanel.setLayout(new BoxLayout(erstelltPanel, BoxLayout.Y_AXIS));
				chkErstellt = new JCheckBox();
					chkErstellt.setSelected(false);
	        	    chkErstellt.addActionListener(new ActionListener() {
	    	        	public void actionPerformed(ActionEvent evt) {
	    	        		try {
	    	        	    if(chkErstellt.isSelected()) {
	    	        	    	dtErVon.setEnabled(true);
	    	        	    	cmbEr1.setEnabled(true);
	    	        	    	if(cmbEr1.getSelectedIndex()==3) {
	        	        	    	dtErBis.setEnabled(true);
	        	        	    	lblERUnd.setEnabled(true);
	    	        	    	} else {
	        	        	    	dtErBis.setEnabled(false);
	        	        	    	lblERUnd.setEnabled(false);
	    	        	    	}
	    	        	    	cmbEr1.requestFocus();
	    	        	    }else {
	    	        	    	dtErVon.setEnabled(false);
	    	        	    	dtErBis.setEnabled(false);
	    	        	    	cmbEr1.setEnabled(false);
	    	        	    	lblERUnd.setEnabled(false);
	    	        	    }
	    	        		}catch (final Exception e) {}
	    	        	}
	        	    });
			    erstelltPanel.add(chkErstellt);
			    cmbEr1 = new JComboBox();
		    		cmbEr1.addItem(rz.getLocale().getString("abfragefenster.label_er_gleich"));
			    	cmbEr1.addItem(rz.getLocale().getString("abfragefenster.label_er_vor"));
			    	cmbEr1.addItem(rz.getLocale().getString("abfragefenster.label_er_nach"));
			    	cmbEr1.addItem(rz.getLocale().getString("abfragefenster.label_er_zwischen"));
			    	cmbEr1.setSelectedIndex(0);
			    	cmbEr1.setEnabled(false);
	        	    cmbEr1.addActionListener(new ActionListener() {
	    	        	public void actionPerformed(ActionEvent evt) {
	    	        		try {
	    	        			if((cmbEr1.getSelectedIndex()==3) && cmbEr1.isEnabled()) {
	    	        				lblERUnd.setEnabled(true);
	    	        				dtErBis.setEnabled(true);
	    	        			}else {
	    	        				lblERUnd.setEnabled(false);
	    	        				dtErBis.setEnabled(false);
	    	        			}
	    	        		}catch (final Exception e) {}
	    	        	}
	        	    });
			    erstelltPanel.add(cmbEr1);
	    	    dtErVon = new  RzSimpleDatePicker(rz);dtErVon.setEnabled(false);
			    erstelltPanel.add(dtErVon);
			    lblERUnd = new JLabel();
			    	lblERUnd.setHorizontalAlignment(SwingConstants.CENTER);
			    	lblERUnd.setEnabled(false);
			    erstelltPanel.add(lblERUnd);
	    	    dtErBis = new RzSimpleDatePicker(rz,true);dtErBis.setEnabled(false);
			    erstelltPanel.add(dtErBis);
			    erstelltPanel.setBorder(BorderFactory.createRaisedBevelBorder());
			contentPanel.add(erstelltPanel);


//			GeaendertPanel
			geaendertPanel = new JPanel(new FlowLayout());
			geaendertPanel.setLayout(new BoxLayout(geaendertPanel, BoxLayout.Y_AXIS));
				chkGeaendert = new JCheckBox();
					chkGeaendert.setSelected(false);
	        	    chkGeaendert.addActionListener(new ActionListener() {
	    	        	public void actionPerformed(ActionEvent evt) {
	    	        		try {
	    	        	    if(chkGeaendert.isSelected()) {
	    	        	    	dtGeVon.setEnabled(true);
	    	        	    	cmbGe1.setEnabled(true);
	    	        	    	if(cmbGe1.getSelectedIndex()==3) {
	        	        	    	dtGeBis.setEnabled(true);
	        	        	    	lblGEUnd.setEnabled(true);
	    	        	    	} else {
	        	        	    	dtGeBis.setEnabled(false);
	        	        	    	lblGEUnd.setEnabled(false);
	    	        	    	}
	    	        	    	cmbGe1.requestFocus();
	    	        	    }else {
	    	        	    	dtGeVon.setEnabled(false);
	    	        	    	dtGeBis.setEnabled(false);
	    	        	    	cmbGe1.setEnabled(false);
	    	        	    	lblGEUnd.setEnabled(false);
	    	        	    }
	    	        		}catch (final Exception e) {}
	    	        	}
	        	    });
			    geaendertPanel.add(chkGeaendert);
			    cmbGe1 = new JComboBox();
		    		cmbGe1.addItem(rz.getLocale().getString("abfragefenster.label_er_gleich"));
			    	cmbGe1.addItem(rz.getLocale().getString("abfragefenster.label_er_vor"));
			    	cmbGe1.addItem(rz.getLocale().getString("abfragefenster.label_er_nach"));
			    	cmbGe1.addItem(rz.getLocale().getString("abfragefenster.label_er_zwischen"));
			    	cmbGe1.setSelectedIndex(0);
			    	cmbGe1.setEnabled(false);
	        	    cmbGe1.addActionListener(new ActionListener() {
	    	        	public void actionPerformed(ActionEvent evt) {
	    	        		try {
	    	        			if((cmbGe1.getSelectedIndex()==3) && cmbGe1.isEnabled()) {
	    	        				lblGEUnd.setEnabled(true);
	    	        				dtGeBis.setEnabled(true);
	    	        			}else {
	    	        				lblGEUnd.setEnabled(false);
	    	        				dtGeBis.setEnabled(false);
	    	        			}
	    	        		}catch (final Exception e) {}
	    	        	}
	        	    });
			    geaendertPanel.add(cmbGe1);
	    	    dtGeVon = new RzSimpleDatePicker(rz); dtGeVon.setEnabled(false);

			    geaendertPanel.add(dtGeVon);
			    lblGEUnd = new JLabel();
			    	lblGEUnd.setHorizontalAlignment(SwingConstants.CENTER);
			    	lblGEUnd.setEnabled(false);
			    geaendertPanel.add(lblGEUnd);
	    	    dtGeBis = new RzSimpleDatePicker(rz,true);dtGeBis.setEnabled(false);

			    geaendertPanel.add(dtGeBis);
			    geaendertPanel.setBorder(BorderFactory.createRaisedBevelBorder());
			contentPanel.add(geaendertPanel);

//			User1Panel
			user1Panel = new JPanel(new FlowLayout());
				chkUser1 = new JCheckBox();
					chkUser1.setSelected(false);
	        	    chkUser1.addActionListener(new ActionListener() {
        	        	public void actionPerformed(ActionEvent evt) {
        	        		try {
        	        	    if(chkUser1.isSelected()) {
        	        	    	txtUser1.setEnabled(true);
        	        	    	txtUser1.requestFocus();
        	        	    }else {
        	        	    	txtUser1.setEnabled(false);
        	        	    }
        	        		}catch (final Exception e) {}
        	        	}
	        	    });
					user1Panel.add(chkUser1,BorderLayout.WEST);
				txtUser1 = new JSelectedTextField();
					txtUser1.setEnabled(false);
					txtUser1.setColumns(20);
				user1Panel.add(txtUser1,BorderLayout.CENTER);
			    user1Panel.setBorder(BorderFactory.createRaisedBevelBorder());
		contentPanel.add(user1Panel);

	//		User2Panel
			user2Panel = new JPanel(new FlowLayout());
				chkUser2 = new JCheckBox();
					chkUser2.setSelected(false);
	        	    chkUser2.addActionListener(new ActionListener() {
	    	        	public void actionPerformed(ActionEvent evt) {
	    	        		try {
	    	        	    if(chkUser2.isSelected()) {
	    	        	    	txtUser2.setEnabled(true);
	    	        	    	txtUser2.requestFocus();
	    	        	    }else {
	    	        	    	txtUser2.setEnabled(false);
	    	        	    }
	    	        		}catch (final Exception e) {}
	    	        	}
	        	    });
					user2Panel.add(chkUser2,BorderLayout.WEST);
				txtUser2 = new JSelectedTextField();
					txtUser2.setColumns(20);
					txtUser2.setEnabled(false);
				user2Panel.add(txtUser2,BorderLayout.CENTER);
			    user2Panel.setBorder(BorderFactory.createRaisedBevelBorder());
		contentPanel.add(user2Panel);

		//		tankPanel
		tankPanel = new JPanel(new FlowLayout());
			chkTank = new JCheckBox();
				chkTank.setSelected(false);
        	    chkTank.addActionListener(new ActionListener() {
    	        	public void actionPerformed(ActionEvent evt) {
    	        		try {
    	        	    if(chkTank.isSelected()) {
    	        	    	txtTank.setEnabled(true);
    	        	    	txtTank.requestFocus();
    	        	    }else {
    	        	    	txtTank.setEnabled(false);
    	        	    }
    	        		}catch (final Exception e) {}
    	        	}
        	    });
				tankPanel.add(chkTank,BorderLayout.WEST);
			txtTank = new JSelectedTextField();
				txtTank.setColumns(20);
				txtTank.setEnabled(false);
			tankPanel.add(txtTank,BorderLayout.CENTER);
		    tankPanel.setBorder(BorderFactory.createRaisedBevelBorder());
	contentPanel.add(tankPanel);

	
		/*
		 * ---------------------
		 */

	/*
	 * --------------------
	 */
		buttonPanel=new JPanel(new FlowLayout());
				btSuchen=new JButton();
					buttonPanel.add(btSuchen);
    			btClose=new JButton();
    				buttonPanel.add(btClose);
			mainPanel.add(toolbarPanel,BorderLayout.NORTH);
			mainPanel.add(contentPanel,BorderLayout.CENTER);
			mainPanel.add(buttonPanel,BorderLayout.SOUTH);

			getContentPane().setLayout(new BorderLayout());
			getContentPane().add(mainPanel,BorderLayout.CENTER);
    }
    public void setGUIComponents() {
        setTitle(rz.getLocale().getString("abfragefenster.titel"));
        mnuDatei.setText(rz.getLocale().getString("menu.datei"));
        mnuBearbeiten.setText(rz.getLocale().getString("menu.bearbeiten"));
        mnuExtras.setText(rz.getLocale().getString("menu.extras"));
        mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));
        mnuDatei.addSeparator();
        mnuDatei.add(getAction(ACTION_CANCEL_CODE));

        mnuBearbeiten.add(getAction(ACTION_SUCHEN_CODE));
        mnuExtras.add(getAction(ACTION_HIDE_CODE));
        mnuHilfe.add(getAction(ACTION_HILFE_CODE));

        tb1.add(getAction(ACTION_CANCEL_CODE));
        tb1.add(getAction(ACTION_HIDE_CODE));
        tb1.addSeparator();
  	  	tb1.add(getAction(ACTION_SUCHEN_CODE));
  	  	tb1.addSeparator();
  	  	tb1.add(getAction(ACTION_HILFE_CODE));
        btClose.setAction(getAction(ACTION_CANCEL_CODE));
        btSuchen.setAction(getAction(ACTION_SUCHEN_CODE));
        btAdressen.setAction(getAction(ACTION_ADRESSEN_CODE));
        btStichworte.setAction(getAction(ACTION_STICHWORTE_CODE));
        btDeklarationen.setAction(getAction(ACTION_DEKLARATIONEN_CODE));

        chkStaerke.setText(rz.getLocale().getString("abfragefenster.label_staerke"));
        lblUnd.setText(rz.getLocale().getString("abfragefenster.label_und"));
        lblEXUnd.setText(rz.getLocale().getString("abfragefenster.label_und"));
        lblLGUnd.setText(rz.getLocale().getString("abfragefenster.label_und"));
        lblERUnd.setText(rz.getLocale().getString("abfragefenster.label_er_und"));
        lblBWUnd.setText(rz.getLocale().getString("abfragefenster.label_er_und"));
        lblGEUnd.setText(rz.getLocale().getString("abfragefenster.label_er_und"));
        lblACUnd.setText(rz.getLocale().getString("abfragefenster.label_er_und"));
        chkName.setText(rz.getLocale().getString("abfragefenster.label_name"));
        chkText.setText(rz.getLocale().getString("abfragefenster.label_text"));
        chkExtraktfrei.setText(rz.getLocale().getString("abfragefenster.label_extraktfrei"));
        chkExtrakt.setText(rz.getLocale().getString("abfragefenster.label_extrakt"));
        chkLitergewicht.setText(rz.getLocale().getString("abfragefenster.label_litergewicht"));
        chkArtikel.setText(rz.getLocale().getString("abfragefenster.label_artikel"));
        chkErstellt.setText(rz.getLocale().getString("abfragefenster.label_erstellt"));
        chkGeaendert.setText(rz.getLocale().getString("abfragefenster.label_geaendert"));
        chkUser1.setText(rz.getLocale().getString("abfragefenster.label_user1"));
        chkUser2.setText(rz.getLocale().getString("abfragefenster.label_user2"));
        chkAdressen.setText(rz.getLocale().getString("abfragefenster.label_adressen"));
        chkDeklarationen.setText(rz.getLocale().getString("abfragefenster.label_deklarationen"));
        chkStichworte.setText(rz.getLocale().getString("abfragefenster.label_stichworte"));
        chkBrennwert.setText(rz.getLocale().getString("abfragefenster.label_brennwert"));
        chkAcid.setText(rz.getLocale().getString("abfragefenster.label_acid"));
        chkTank.setText(rz.getLocale().getString("abfragefenster.label_tank"));
        chkLager.setText(rz.getLocale().getString("abfragefenster.label_lager"));
        chkSteuerLager.setText(rz.getLocale().getString("abfragefenster.label_steuerlager")); 
        chkSorte.setText(rz.getLocale().getString("abfragefenster.label_sorte")); 
        chkSteuer_Artikel.setText(rz.getLocale().getString("abfragefenster.label_steuer_artikel"));        
        
        getAction(ACTION_ADRESSEN_CODE).setEnabled(false);
        getAction(ACTION_STICHWORTE_CODE).setEnabled(false);
        getAction(ACTION_DEKLARATIONEN_CODE).setEnabled(false);

        setResizable(true);
         rz.getFontFactory().setFrameFonts(this);
         this.setMinimumSize(new Dimension(300,300));
         this.setPreferredSize(new Dimension(300,300));
         pack();
         rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;
    }


    public void getMessage(MessageItem msg) {
        switch(msg.getMsgCode()) {
    	case MessageItem.MSG_ACTIONPERFORMED:
            switch(msg.getCode()){
            	case ACTION_CANCEL_CODE :closeWindow();break;
            	case ACTION_SUCHEN_CODE:goAction();break;
            	case ACTION_HILFE_CODE:hilfeAction();break;
            	case ACTION_HIDE_CODE:hideAction();break;
            	case ACTION_ADRESSEN_CODE:adressenAction();break;
            	case ACTION_STICHWORTE_CODE:stichworteAction();break;
            	case ACTION_DEKLARATIONEN_CODE:deklarationenAction();break;
            	default :
                break;
           }
	      	break;
	     case MessageItem.MSG_ADRESSLISTE_REPLY:
	      		adressen = (StichwortListe)msg.getData();
	      		lblAdressen.setText(adressen.toVerboseString());
	      		break;
		 case MessageItem.MSG_STICHWORTLISTE_REPLY:
	      		stichworte = (StichwortListe)msg.getData();
	      		lblStichworte.setText("<html>"+stichworte.toHTMLString()+"</html>");
	      		break;
		 case MessageItem.MSG_DEKLARATION_AUSWAHL_REPLY:
	      		deklarationen = (DeklarationsListe)msg.getData();
	      		lblDeklarationen.setText(deklarationen.toVerboseString());
	      		break;
    	case MessageItem.MSG_ABFRAGE_ERWEITERT:
    		origin = (Auswahl)msg.getOrigin();
    		break;
        default:
            rz.getLogFactory().logMessage(2, "AbfrageFenster", "auswahlAction:" + msg.getMsgCode());
            break;
        }
    }

    public void createActions(){
		actionList.put(String.valueOf(ACTION_HIDE_CODE), new AuswahlAction(rz,this, ACTION_HIDE_CODE,ACTION_HIDE_TEXT, KeyEvent.VK_F5, KeyEvent.SHIFT_DOWN_MASK));
		actionList.put(String.valueOf(ACTION_HILFE_CODE), new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT, KeyEvent.VK_F1, 0));
		actionList.put(String.valueOf(ACTION_CANCEL_CODE), new AuswahlAction(rz,this,ACTION_CANCEL_CODE,ACTION_CLOSE_TEXT,KeyEvent.VK_ESCAPE,	0));
		actionList.put(String.valueOf(ACTION_SUCHEN_CODE), new AuswahlAction(rz,this,ACTION_SUCHEN_CODE,ACTION_SUCHEN_TEXT,KeyEvent.VK_ENTER,	KeyEvent.SHIFT_DOWN_MASK));
		actionList.put(String.valueOf(ACTION_ADRESSEN_CODE), new AuswahlAction(rz,this,ACTION_ADRESSEN_CODE,ACTION_ADRESSEN_TEXT,0,0));
		actionList.put(String.valueOf(ACTION_STICHWORTE_CODE), new AuswahlAction(rz,this,ACTION_STICHWORTE_CODE,ACTION_STICHWORTE_TEXT,0,0));
		actionList.put(String.valueOf(ACTION_DEKLARATIONEN_CODE), new AuswahlAction(rz,this,ACTION_DEKLARATIONEN_CODE,ACTION_DEKLARATIONEN_TEXT,0,0));

    }


    /**
     * die Abfrage ausführen
     */
    private void goAction(){
    	saveValues();
    	final AbfrageItem ai = composeAbfrage();
    	if (ai != null) {
	    	try {
	    		origin.getMessage(new MessageItem(MessageItem.MSG_ABFRAGE_ERWEITERT_REPLY,0,ai,this));
	        	closeWindow();
	    	} catch (final Exception e) {
	    	}
    	}
    }

    /**
     * cancel
     */
    private void cancelAction(){
        closeWindow();
    }

    public void closeWindow(){
        rz.getFensterFactory().getFensterListe().disposeFrame(this);
    }
    public void openWindow(){
    	setValues();
        if (!isVisible()) {
			setVisible(true);
			
			
		}
        toFront();
    }

   
    /**
     * die Settings der Comboboxen und Textfelder speichern
     *
     */
    private void saveValues() {
    	rz.getOptionFactory().setOption("abfragefenster.text_name",txtName.getText().trim());
    	rz.getOptionFactory().setOption("abfragefenster.text_text",txtText.getText().trim());
    	rz.getOptionFactory().setOption("abfragefenster.text_st1",txtSt1.getText());
    	rz.getOptionFactory().setOption("abfragefenster.text_st2",txtSt2.getText());
    	rz.getOptionFactory().setOption("abfragefenster.cmbst1",cmbSt1.getSelectedIndex());
    	rz.getOptionFactory().setOption("abfragefenster.cmb_ex",cmbExtraktfrei.getSelectedIndex());
    	rz.getOptionFactory().setOption("abfragefenster.ex1",txtEx1.getText());
    	rz.getOptionFactory().setOption("abfragefenster.ex2",txtEx2.getText());
    	rz.getOptionFactory().setOption("abfragefenster.ac1",txtAc1.getText());
    	rz.getOptionFactory().setOption("abfragefenster.ac2",txtAc2.getText());
    	rz.getOptionFactory().setOption("abfragefenster.cmb_bw",cmbBw1.getSelectedIndex());
    	rz.getOptionFactory().setOption("abfragefenster.bw1",txtBw1.getText());
    	rz.getOptionFactory().setOption("abfragefenster.bw2",txtBw2.getText());
    	rz.getOptionFactory().setOption("abfragefenster.cmbex1",cmbEx1.getSelectedIndex());
    	rz.getOptionFactory().setOption("abfragefenster.cmb_ac1",cmbAc1.getSelectedIndex());
    	rz.getOptionFactory().setOption("abfragefenster.lg1",txtLg1.getText());
    	rz.getOptionFactory().setOption("abfragefenster.lg2",txtLg2.getText());
    	rz.getOptionFactory().setOption("abfragefenster.cmblg1",cmbLg1.getSelectedIndex());
    	rz.getOptionFactory().setOption("abfragefenster.text_artikel",txtArtikel.getText().trim());
    	rz.getOptionFactory().setOption("abfragefenster.cmber1",cmbEr1.getSelectedIndex());
    	rz.getOptionFactory().setOption("abfragefenster.cmbge1",cmbGe1.getSelectedIndex());
    	rz.getOptionFactory().setOption("abfragefenster.text_user1",txtUser1.getText().trim());
    	rz.getOptionFactory().setOption("abfragefenster.text_user2",txtUser2.getText().trim());
    	rz.getOptionFactory().setOption("abfragefenster.text_tank",txtTank.getText().trim());
    	rz.getOptionFactory().setOption("abfragefenster.cmb_lager", cmbLager.getSelectedIndex());
    	rz.getOptionFactory().setOption("abfragefenster.cmb_steuerlager", cmbSteuerLager.getSelectedIndex());
    	rz.getOptionFactory().setOption("abfragefenster.cmb_sorte", cmbSorte.getSelectedIndex());
    	rz.getOptionFactory().setOption("abfragefenster.steuer_artikel",txtSteuer_Artikel.getText().trim());
    	rz.getOptionFactory().saveOptions();

    }

    /**
     * die Settings der Comboboxen und Textfelder laden2004
     *
     */
    private void setValues() {
    	txtName.setText(rz.getOptionFactory().getOption("abfragefenster.text_name"));
    	txtText.setText(rz.getOptionFactory().getOption("abfragefenster.text_text"));
    	txtSt1.setText(rz.getOptionFactory().getOption("abfragefenster.text_st1"));
    	txtSt2.setText(rz.getOptionFactory().getOption("abfragefenster.text_st2"));
    	cmbSt1.setSelectedIndex(rz.getOptionFactory().getOption("abfragefenster.cmbst1",0));
    	cmbExtraktfrei.setSelectedIndex(rz.getOptionFactory().getOption("abfragefenster.cmb_ex",0));
    	cmbAc1.setSelectedIndex(rz.getOptionFactory().getOption("abfragefenster.cmb_ac1",0));
    	txtEx1.setText(rz.getOptionFactory().getOption("abfragefenster.ex1"));
    	txtEx2.setText(rz.getOptionFactory().getOption("abfragefenster.ex2"));
    	txtAc1.setText(rz.getOptionFactory().getOption("abfragefenster.ac1"));
    	txtAc2.setText(rz.getOptionFactory().getOption("abfragefenster.ac2"));
    	cmbEx1.setSelectedIndex(rz.getOptionFactory().getOption("abfragefenster.cmbex1",0));
    	txtBw1.setText(rz.getOptionFactory().getOption("abfragefenster.bw1"));
    	txtBw2.setText(rz.getOptionFactory().getOption("abfragefenster.bw2"));
    	cmbBw1.setSelectedIndex(rz.getOptionFactory().getOption("abfragefenster.cmb_bw",0));
    	txtLg1.setText(rz.getOptionFactory().getOption("abfragefenster.lg1"));
    	txtLg2.setText(rz.getOptionFactory().getOption("abfragefenster.lg2"));
    	cmbLg1.setSelectedIndex(rz.getOptionFactory().getOption("abfragefenster.cmblg1",0));
    	cmbEr1.setSelectedIndex(rz.getOptionFactory().getOption("abfragefenster.cmber1",0));
    	cmbGe1.setSelectedIndex(rz.getOptionFactory().getOption("abfragefenster.cmbge1",0));
    	txtArtikel.setText(rz.getOptionFactory().getOption("abfragefenster.text_artikel"));
    	txtUser1.setText(rz.getOptionFactory().getOption("abfragefenster.text_user1"));
    	txtUser2.setText(rz.getOptionFactory().getOption("abfragefenster.text_user2"));
    	txtTank.setText(rz.getOptionFactory().getOption("abfragefenster.text_tank"));
    	cmbLager.setSelectedIndex(rz.getOptionFactory().getOption("abfragefenster.cmb_lager",0));
    	cmbSteuerLager.setSelectedIndex(rz.getOptionFactory().getOption("abfragefenster.cmb_steuerlager",0));
    	cmbSorte.setSelectedIndex(rz.getOptionFactory().getOption("abfragefenster.cmb_sorte",0));
    	txtSteuer_Artikel.setText(rz.getOptionFactory().getOption("abfragefenster.steuer_artikel"));
    }

    private void adressenAction() {
    	final AbfrageItem ai = new AbfrageItem();
    	ai.setAdressListe(adressen);
    	rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_ADRESSAUSWAHL,true,new MessageItem(MessageItem.MSG_ADRESSLISTE_REQUEST,0,ai,this));
    }

    private void stichworteAction() {
    	final AbfrageItem ai = new AbfrageItem();
    	ai.setStichwortListe(stichworte);
    	rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_STICHWORTAUSWAHL,true,	new MessageItem(MessageItem.MSG_STICHWORTLISTE_REQUEST,0,ai,this));
    }

    private void deklarationenAction() {
    	rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_DEKLARATIONS_AUSWAHL,true,	new MessageItem(MessageItem.MSG_SHOW_DEKLARATION_AUSWAHL,0,deklarationen,this));
    }

    /**
     * Die Abfrage zusammenstellen
     *
     */

    private AbfrageItem composeAbfrage() {
	    final SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
    	final AbfrageItem ai = new AbfrageItem();
    	ai.setTyp(DBAbfrage.ABFRAGE_TYP_SQL);
    	String sql = rz.getDatabase().getErgebnis().getErweitertSQLPrefix();
//    	String sql="SELECT rezeptliste.id,buchungen.datum,rezeptliste.typ,name,rezeptliste.staerke,rezeptliste.geaendert,stichworte,adressen,rezeptliste.litergewicht,acid,bestand,meldebestand,vorschlagsbestand,bestandseinheit,spezifikation,rezeptliste.staerke,sum(bestellung.rest) as menge,rezeptliste.artikelnummer,tempvon,tempbis,at.id,at.erledigt,at.anfrage,at.inarbeit FROM " + 
//
//    	DBFactory.TABLE_REZEPTLISTE + 
//    	" left join bestellung on rezeptliste.id=bestellung.rezeptur " + 
//    	" left join (select id,rezeptur_id,erledigt,anfrage,inarbeit from auftragsliste where erledigt=0 and anfrage=0) as at on at.rezeptur_id=rezeptliste.id "+
//    	" where  ";
    	String clauses="";
    	String muster;
    	//Name
    	if(chkName.isSelected()) {
    		muster = txtName.getText().trim();
            muster = muster.replaceAll("[ ]+", ".*").replaceAll("\\(", "\\\\(").replaceAll("\\)", "\\\\)").replaceAll("\\+", "\\\\+").replaceAll("\"","").replaceAll("'","");
    		if(!muster.equals("")) {
    			clauses +="and name regexp('" + muster + "') ";
    		}
    	}
    	//Name
    	if(chkText.isSelected()) {
    		muster = txtText.getText().trim();
            muster = muster.replaceAll("[ ]+", ".*").replaceAll("\\(", "\\\\(").replaceAll("\\)", "\\\\)").replaceAll("\\+", "\\\\+").replaceAll("\"","").replaceAll("'","");
    		if(!muster.equals("")) {
    			clauses +="and rezeptliste.comment regexp('" + muster + "') ";
    		}
    	}
    	
    	//Lager
    	if(chkLager.isSelected()) {
	    		LagerItem lg = (LagerItem)cmbLager.getSelectedItem();
	    		if(lg != null) {
	    			clauses +="and lager = '" + lg.getID() + "' ";
	    		}
    	}	
    	
    	//SteuerLager
    	if(chkSteuerLager.isSelected()) {
	    		SteuerLagerItem lg = (SteuerLagerItem)cmbSteuerLager.getSelectedItem();
	    		if(lg != null) {
	    			clauses +="and rezeptliste.steuerlager = '" + lg.getId() + "' ";
	    		}
    	}	
    	
    	//Sorte
    	if(chkSorte.isSelected()) {
	    		SortenItem lg = (SortenItem)cmbSorte.getSelectedItem();
	    		if(lg != null) {
	    			clauses +="and rezeptliste.sorte = '" + lg.getId() + "' ";
	    		}
    	}
    	
    	//Steuer_Artikel
    	if(chkSteuer_Artikel.isSelected()) {
    		muster = txtSteuer_Artikel.getText().trim();
            muster = muster.replaceAll(" +", ".*").replaceAll("\\(", "\\\\(").replaceAll("\\)", "\\\\)").replaceAll("\\+", "\\\\+").replaceAll("\"","").replaceAll("'","");
    		if(!muster.equals("")) {
    			clauses +="and rezeptliste.steuer_artikel regexp('" + muster + "') ";
    		}
    	}
    	
    	
    	//Adressen
    	if(chkAdressen.isSelected()) {
    		if(adressen != null) {
	    		muster = adressen.toVerboseString().trim();
	    		if(!muster.equals("")) {
	    			clauses +="and adressen regexp '" + adressen.toSQLAndString() + "' ";
	    		}
    		}
    	}
    	//Deklarationen
    	if(chkDeklarationen.isSelected()) {
    		if(deklarationen != null) {
	    		muster = deklarationen.toVerboseString().trim();
	    		if(!muster.equals("")) {
	    			clauses +="and deklarationen regexp '" + deklarationen.toSQLAndString() + "' or deklarationen_alle regexp '" + deklarationen.toSQLAndString() + "'";
	    		}
    		}
    	}

    	//Stichworte
    	if(chkStichworte.isSelected()) {
    		if(stichworte != null) {
	    		muster = stichworte.toVerboseString().trim();
	    		if(!muster.equals("")) {
	    			clauses +="and stichworte regexp '" + stichworte.toSQLAndString() + "' ";
	    		}
    		}
    	}
    	//staerke
    	if(chkStaerke.isSelected()) {
    		double min = txtSt1.getValue();
    		double max = txtSt2.getValue();
    		if(cmbSt1.getSelectedIndex()==3) {
    			//zwischen
    			if(min >max) {
    				final double t = min;
    				min = max;
    				max = t;
    			}
       			clauses += "and rezeptliste.staerke between "  + Double.toString(min) + " and " + Double.toString(max);

    		}else {
    			clauses += "and rezeptliste.staerke " + (String)cmbSt1.getSelectedItem() + Double.toString(min);
    		}
    	}
    	//extraktfrei
    	if(chkExtraktfrei.isSelected()) {
    		if(cmbExtraktfrei.getSelectedIndex()==0) {
    			clauses += "and extraktfrei=1 ";
    		} else {
    			clauses += "and extraktfrei=0 ";
    		}
    	}
    	//extraktgehalt
    	if(chkExtrakt.isSelected()) {
    		double min = txtEx1.getValue();
    		double max = txtEx2.getValue();
    		if(cmbEx1.getSelectedIndex()==3) {
    			//zwischen
    			if(min >max) {
    				final double t = min;
    				min = max;
    				max = t;
    			}
       			clauses += "and extrakt between "  + Double.toString(min) + " and " + Double.toString(max);

    		}else {
    			clauses += "and extrakt " + (String)cmbEx1.getSelectedItem() + Double.toString(min);
    		}
    	}

    	//säure
    	if(chkAcid.isSelected()) {
    		double min = txtAc1.getValue();
    		double max = txtAc2.getValue();
    		if(cmbAc1.getSelectedIndex()==3) {
    			//zwischen
    			if(min >max) {
    				final double t = min;
    				min = max;
    				max = t;
    			}
       			clauses += "and acid between "  + Double.toString(min) + " and " + Double.toString(max);

    		}else {
    			clauses += "and acid " + (String)cmbAc1.getSelectedItem() + Double.toString(min);
    		}
    	}

    	//brennwert
    	if(chkBrennwert.isSelected()) {
    		double min = txtBw1.getValue();
    		double max = txtBw2.getValue();
    		if(cmbBw1.getSelectedIndex()==3) {
    			//zwischen
    			if(min >max) {
    				final double t = min;
    				min = max;
    				max = t;
    			}
       			clauses += "and brennwert+brennwert_af between "  + Double.toString(min) + " and " + Double.toString(max);

    		}else {
    			clauses += "and brennwert+brennwert_af" + (String)cmbBw1.getSelectedItem() + Double.toString(min);
    		}
    	}

    	//Litergewicht
    	if(chkLitergewicht.isSelected()) {
    		double min = txtLg1.getValue();
    		double max = txtLg2.getValue();
    		if(cmbLg1.getSelectedIndex()==3) {
    			//zwischen
    			if(min >max) {
    				final double t = min;
    				min = max;
    				max = t;
    			}
       			clauses += "and litergewicht between "  + Double.toString(min) + " and " + Double.toString(max);

    		}else {
    			clauses += "and litergewicht " + (String)cmbLg1.getSelectedItem() + Double.toString(min);
    		}
    	}

    	//Artikelnummer
    	if(chkArtikel.isSelected()) {
    		muster = txtArtikel.getText().trim();
            muster = muster.replaceAll("[ ]+", ".*").replaceAll("\\(", "\\\\(").replaceAll("\\)", "\\\\)").replaceAll("\\+", "\\\\+").replaceAll("\"","").replaceAll("'","");
    		if(!muster.equals("")) {
    			clauses +="and rezeptliste.artikelnummer regexp('" + muster + "') ";
    		}
    	}

    	//Erstellt
    	if(chkErstellt.isSelected()) {
    		if(cmbEr1.getSelectedIndex()==3) {
    			//zwischen
    			Date min = new Date();
    			Date max = new Date();
    			if(dtErBis.getDate().compareTo(dtErVon.getDate()) > 0) {
    				min = dtErVon.getDate();
    				max = dtErBis.getDate();
    			}
       			clauses += "and rezeptliste.erstellt between '"  + df.format(min) + " 00:00:00' and '" + df.format(max)+" 23:59:59' ";

    		}else {
	    		  if(((String)cmbEr1.getSelectedItem()).equals("=")) {
	    			  clauses += "and rezeptliste.erstellt >= '" + df.format(dtErVon.getDate()) + " 00:00:00' and rezeptliste.erstellt <='" + df.format(dtErVon.getDate()) + " 23:59:59' ";
	    		  } else if (((String)cmbEr1.getSelectedItem()).equals("<=")) {
	    			  clauses += "and rezeptliste.erstellt <='" + df.format(dtErVon.getDate()) + " 23:59:59' ";
	    		  }else if (((String)cmbEr1.getSelectedItem()).equals(">=")) {
	    			  clauses += "and rezeptliste.erstellt >='" + df.format(dtErVon.getDate()) + " 00:00:00' ";
	    		  }
    		}
    	}

    	//Geandert
    	if(chkGeaendert.isSelected()) {
    		if(cmbGe1.getSelectedIndex()==3) {
    			//zwischen
    			Date min = new Date();
    			Date max = new Date();
    			if(dtGeBis.getDate().compareTo(dtGeVon.getDate()) > 0) {
    				min = dtGeVon.getDate();
    				max = dtGeBis.getDate();
    			}
       			clauses += "and rezeptliste.geaendert between '"  + df.format(min) + " 00:00:00' and '" + df.format(max)+" 23:59:59' ";
    		}else {
	    		  if(((String)cmbGe1.getSelectedItem()).equals("=")) {
	    			  clauses += "and rezeptliste.geaendert >= '" + df.format(dtGeVon.getDate()) + " 00:00:00' and rezeptliste.geaendert <='" + df.format(dtGeVon.getDate()) + " 23:59:59' ";
	    		  } else if (((String)cmbGe1.getSelectedItem()).equals("<=")) {
	    			  clauses += "and rezeptliste.geaendert <='" + df.format(dtGeVon.getDate()) + " 23:59:59' ";
	    		  }else if (((String)cmbGe1.getSelectedItem()).equals(">=")) {
	    			  clauses += "and rezeptliste.geaendert >='" + df.format(dtGeVon.getDate()) + " 00:00:00' ";
	    		  }
	    	}
    	}

    	// User 1
    	if(chkUser1.isSelected()) {
    		muster = txtUser1.getText().trim();
            muster = muster.replaceAll("[ ]+", ".*").replaceAll("\\(", "\\\\(").replaceAll("\\)", "\\\\)").replaceAll("\\+", "\\\\+").replaceAll("\"","").replaceAll("'","");
    		if(!muster.equals("")) {
    			clauses +="and rezeptliste.user_1 regexp('" + muster + "') ";
    		}
    	}

    	// User 2
    	if(chkUser2.isSelected()) {
    		muster = txtUser2.getText().trim();
            muster = muster.replaceAll("[ ]+", ".*").replaceAll("\\(", "\\\\(").replaceAll("\\)", "\\\\)").replaceAll("\\+", "\\\\+").replaceAll("\"","").replaceAll("'","");
    		if(!muster.equals("")) {
    			clauses +="and rezeptliste.user_2 regexp('" + muster + "') ";
    		}
    	}

    	// Tank
    	if(chkTank.isSelected()) {
    		muster = txtTank.getText().trim();
            muster = muster.replaceAll("[ ]+", ".*").replaceAll("\\(", "\\\\(").replaceAll("\\)", "\\\\)").replaceAll("\\+", "\\\\+").replaceAll("\"","").replaceAll("'","");
    		if(!muster.equals("")) {
    			clauses +="and tank regexp('" + muster + "') ";
    		}
    	}
    	/**----------------------------------------------------------------------------------
    	 *
    	 */
    	if (clauses.toLowerCase().startsWith("and")) {
    		clauses = clauses.substring("and".length());
    	}
    	ai.setMuster(sql);
    	if(!clauses.equals("")) {
    		sql += clauses + "  group by rezeptliste.id order by name";
    		ai.setMuster(sql);
    		return ai;
    	} else {
    		return null;
    	}
    }

	//hilfe
	private void hilfeAction() {
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"abfrage_erweitert.html",this));
	}

    private void hideAction() {
        rz.getFensterFactory().getFensterListe().sperren(this);
    }

}


