/*
 * Created on 02.11.2004
 *
 */
package de.lunqual.rzpro.fenster.auswahlfenster;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.ausgabe.ReportFactory;
import de.lunqual.rzpro.database.DBAbfrage;
import de.lunqual.rzpro.database.DBAuftrag;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fenster.JSelectedTextField;
import de.lunqual.rzpro.fenster.buchungsfenster.StatistikFenster;
import de.lunqual.rzpro.fenster.dialoge.DialogControl;
import de.lunqual.rzpro.fenster.dialoge.DruckFormularDialog;
import de.lunqual.rzpro.fenster.dialoge.EingabeDialog;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.abfrage.AbfrageItem;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.auftrag.AuftragsItem;
import de.lunqual.rzpro.items.auftrag.Auftragsliste;
import de.lunqual.rzpro.items.buchung.BuchungsItem;
import de.lunqual.rzpro.items.buchung.ClientBuchungsItem;
import de.lunqual.rzpro.items.currency.CurrencyItem;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.items.ergebnis.ErgebnisItem;
import de.lunqual.rzpro.items.ergebnis.ErgebnisListe;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.rechnen.RechenItem;
import de.lunqual.rzpro.items.rezeptur.AusstattungsItem;
import de.lunqual.rzpro.items.rezeptur.RezepturItem;
import de.lunqual.rzpro.items.rezeptur.SPFormblattItem;
import de.lunqual.rzpro.items.stichworte.StichwortListe;
import de.lunqual.rzpro.items.tank.tankAuswahlItem;
import de.lunqual.rzpro.items.tank.tankItem;
import de.lunqual.rzpro.log.LogFactory;
import de.lunqual.rzpro.options.OptionFactory;

/**
 * @author labor
 *
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class AbgangsClientAuswahl extends JRzFrame  implements TableColumnModelListener {

    //GUI-Variablen
    private JToolBar tb1;
    private JMenuBar mb;
    private JMenu mnuDatei;
    private JMenu mnuBearbeiten;
    private JMenu mnuExtras;
    private JMenu mnuFenster;
    private JMenu mnuHilfe;
      private  JPanel contentPanel;
      	private JPanel tbPanel;
      	private JPanel centerPanel;
      		private JSplitPane spl1;
      			
      			private JSplitPane splListe;
          			private JPanel ergebnisListenPanel;
	      				private JPanel suchPanel;
	      					private JSelectedTextField txtMuster;
	      					private JButton btSuchen;
	      				private JScrollPane scrErgebnis;
	      						private JTable tblErgebnis;
	      			private JPanel auftragsPanel;
		      			private JTabbedPane auftragAnfragenTab;
	    				private JPanel auftragslistenPanel;
	    					private JLabel lblAuftragslisteTitel;
	    					private JScrollPane scrAuftragsliste;
	    						private JTable tblAuftragsliste;
	    					private JPanel auftragsButtonPanel;
	    						private JPanel auftragsButtonObenPanel;
	    							private JButton btAuftragslisteRefresh;
	    							private JButton btAuftragslisteDrucken;
	    							private JButton btAuftragslisteBearbeiten;
			    		 		private JPanel auftragsButtonPanelUnten;
				    		 		private JLabel lblAuftragsliste_text1;
				    		 		private JSpinner splAuftragsliste;
				    		 		private JLabel lblAuftragsliste_text2;
		    				
		    			private JPanel anfragenlistenPanel;
	    					private JLabel lblanfragenlisteTitel;
	    					private JScrollPane scrAnfragenliste;
	    						private JTable tblAnfragenliste;
	    					private JPanel anfragenButtonPanel;
	    						private JPanel anfragenButtonObenPanel;
	    							private JButton btAnfragenlisteRefresh;
	    							private JButton btAnfragenlisteDrucken;
	    							private JButton btAnfragenlisteBearbeiten;
			    		 		private JPanel anfragenButtonPanelUnten;
				    		 		private JLabel lblanfragenliste_text1;
				    		 		private JSpinner splAnfragenliste;
				    		 		private JLabel lblanfragenliste_text2;
	      						
      			private JPanel rightPanel;
      				private JSplitPane splRight;
      					private JPanel splRightOben;
		      				private JScrollPane scrAusgabe;
		      					private JEditorPane txtErgebnis;
		      			private JPanel splRightUnten;
		      				private JPanel buchungenPanel;
		      					private JPanel buchungenRefreshPanel;
		      						private JButton btRefreshBuchungen;
		      					private JScrollPane scrBuchungen;
		      						private JEditorPane txtBuchungen;
      						
    public static final int         		ACTION_QUIT_CODE  = 1000;
    public static final String     			ACTION_QUIT_TEXT = "clientauswahl.action_quit";
    public static final int         		ACTION_HILFE_CODE = 1001;
    public static final String     			ACTION_HILFE_TEXT = "action_hilfe";
    public static final int         		ACTION_HIDE_CODE = 1002;
    public static final String    			ACTION_HIDE_TEXT = "action_hide";
    public static final int         		ACTION_SUCHEN_CODE  = 1003;
    public static final String     			ACTION_SUCHEN_TEXT = "clientauswahl.action_suchen";
    public static final int        			ACTION_STATISTIK_EINZELN_CODE  = 1004;
    public static final String     			ACTION_STATISTIK_EINZELN_TEXT = "clientauswahl.action_statistik_einzeln";
    public static final int         		ACTION_STATISTIK_GRUPPE_CODE  = 1005;
    public static final String     			ACTION_STATISTIK_GRUPPE_TEXT = "clientauswahl.action_statistik_gruppe";
    public static final int         		ACTION_ABGANG_CODE  = 1006;
    public static final String     			ACTION_ABGANG_TEXT = "clientauswahl.action_abgang";
    public static final int         		ACTION_ABOUT_CODE  = 1007;
    public static final String     			ACTION_ABOUT_TEXT = "auswahl.action_about";
    public static final int         		ACTION_EINSTELLUNGEN_CODE  = 1008;
    public static final String     			ACTION_EINSTELLUNGEN_TEXT = "clientauswahl.action_einstellungsfenster";
    public static final int         		ACTION_HINWEIS_CODE = 1009;
    public static final String     			ACTION_HINWEIS_TEXT = "clientauswahl.action_hinweis";
    public static final int         		ACTION_CONTAINER_RETURN_CODE = 1096;
    public static final String    			ACTION_CONTAINER_RETURN_TEXT = "auswahl.action_container_return";
    public static final int         		ACTION_GEWICHT_CODE = 1097;
    public static final String     			ACTION_GEWICHT_TEXT = "auswahl.action_gewicht";
    public static final int         		ACTION_KALENDER_CODE = 1098;
    public static final String     			ACTION_KALENDER_TEXT = "auswahl.action_kalender";
    public static final int         		ACTION_PROBE_CODE = 1099;
    public static final String     			ACTION_PROBE_TEXT = "auswahl.action_probe";
    public static final int         		ACTION_REFRESH_CODE = 1100;
    public static final String     			ACTION_REFRESH_TEXT = "clientauswahl.action_refresh";
    public static final int         		ACTION_AUFTRAG_CODE = 1101;
    public static final String     			ACTION_AUFTRAG_TEXT = "clientauswahl.action_auftrag";    
    public static final int		 			ACTION_SHOW_AUFTRAGSLISTE_CODE=1113;    
    public static final String     			ACTION_SHOW_AUFTRAGSLISTE_TEXT = "auswahl.action_auftragsliste";
    public static final int		 			ACTION_AUFTRAGSLISTE_REFRESH_CODE=1114;    
    public static final String     			ACTION_AUFTRAGSLISTE_REFRESH_TEXT = "auswahl.action_auftragsliste_refresh";
    public static final int		 			ACTION_AUFTRAGSLISTE_DRUCKEN_CODE=1115;    
    public static final String     			ACTION_AUFTRAGSLISTE_DRUCKEN_TEXT = "auswahl.action_auftragsliste_drucken";
    public static final int		 			ACTION_SHOW_ANFRAGENLISTE_CODE=1116;    
    public static final String    			ACTION_SHOW_ANFRAGENLISTE_TEXT = "auswahl.action_anfragenliste_show";
    public static final int		 			ACTION_ANFRAGENLISTE_REFRESH_CODE=1117;    
    public static final String     			ACTION_ANFRAGENLISTE_REFRESH_TEXT = "auswahl.action_anfragenliste_refresh";
    public static final int		 			ACTION_ANFRAGENLISTE_DRUCKEN_CODE=1118;    
    public static final String     			ACTION_ANFRAGENLISTE_DRUCKEN_TEXT = "auswahl.action_anfragenliste_drucken";
    public static final int		 			ACTION_SHOW_TANKLISTE_CODE=1121;    
    public static final String     			ACTION_SHOW_TANKLISTE_TEXT = "auswahl.action_tanks";
    public static final int        			ACTION_SPEZIFIKATION_PDF_KOMPLETT_CODE = 1122;
    public static final String     			ACTION_SPEZIFIKATION_PDF_KOMPLETT_TEXT = "auswahl.action_spezifikation_pdf_komplett";
    public static final int         		ACTION_SPEZIFIKATION_DRUCKEN_KOMPLETT_CODE = 1123;
    public static final String     			ACTION_SPEZIFIKATION_DRUCKEN_KOMPLETT_TEXT = "auswahl.action_spezifikation_drucken_komplett";
    public static final int         		ACTION_SHOW_LOSNUMMER_VORLAGE_CODE = 1124;
    public static final String     			ACTION_SHOW_LOSNUMMER_VORLAGE_TEXT = "auswahl.losnummer_vorlage";
    public static final int         		ACTION_DOKUMENTE_CODE = 1125;
    public static final String     			ACTION_DOKUMENTE_TEXT = "auswahl.action_dokumente";
    
    public static final int 				CE_ICON=0;
    public static final int 				CE_BEZEICHNUNG=1;
    public static final int 				CE_DATUM=2;
    public static final int					CE_STICHWORTE = 3;
    public static final int					CE_FUELLSTAND=4;
    public static final int					CE_MAX=5;
    
    public static final int 				AL_MAX_COLUMNS=2;
    public static final int					AL_C_MENGE=0;
    public static final int					AL_C_BEZEICHNUNG=1;
    
    public static final int					MILLISECONDS_PER_MINUTE = 60000;
    
    // ErgebnisTimer
    javax.swing.Timer   					ergebnisTimer;
    javax.swing.Timer						auftragslisteTimer;
    javax.swing.Timer						anfragenlisteTimer;

    AbfrageItem								abfrage;
    DialogItem                              dlgItem;
    Auftragsliste							auftragsliste;
    Auftragsliste							anfragenliste;
    ErgebnisListe							ergebnisse;
    
    /** Creates new form AdressenFenster */
    public AbgangsClientAuswahl(RzPro r, String name, Object extendedData) {
        super(r,name,extendedData);
        ergebnisTimer = new javax.swing.Timer(rz.getOptionFactory().getOption("list.timeout",RzPro.LIST_TIMEOUT), new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                 ergebnisTimerEvent();
            }
      });
        auftragslisteTimer = new javax.swing.Timer(rz.getOptionFactory().getOption("client_auftragsliste.timer" ,RzPro.LIST_TIMEOUT)*MILLISECONDS_PER_MINUTE, new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                 auftragslisteAction();
            }
        });
        anfragenlisteTimer = new javax.swing.Timer(rz.getOptionFactory().getOption("client_anfragenliste.timer" ,RzPro.LIST_TIMEOUT)*MILLISECONDS_PER_MINUTE, new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                 anfragenlisteAction();
            }
        });
        this.auftragslisteTimer.start();
        this.anfragenlisteTimer.start();
      abfrage = new AbfrageItem();
      abfrage.setAdressListe(new StichwortListe());
      abfrage.setStichwortListe(rz.getDatabase().getSTW().getAbgangsClientFilter());
      createActions();
      createGUIComponents();
	  this.settblErgebnisModel(tblErgebnis);
	  this.settblAuftragslisteModel(tblAuftragsliste);
	  this.settblAnfragenlisteModel(tblAnfragenliste);
      setGUIComponents();
      dlgItem = new DialogItem(0,"",0.0,"","","","","","",null);
      getAuftragsListe();
      getAnfragenListe();
    }

    @Override
	public void createGUIComponents() {
    	// Menü
    	mb = new JMenuBar();
    	mnuDatei = new JMenu();
    	mnuBearbeiten = new JMenu();
    	mnuExtras = new JMenu();
    	mnuFenster=new JMenu();
    	mnuHilfe = new JMenu();
    	mb.add(mnuDatei);
    	mb.add(mnuBearbeiten);
    	mb.add(mnuExtras);
    	mb.add(mnuFenster);
    	mb.add(mnuHilfe);
    	setJMenuBar(mb);
		//Toolbar
		tb1 = new JToolBar();
		tb1.setFloatable(false);
		tb1.setRollover(true);
		//ToolbarPanel
		//contentPanel
		contentPanel = new JPanel(new BorderLayout());
			tbPanel = new JPanel(new BorderLayout());
				tbPanel.add(tb1,BorderLayout.NORTH);
		contentPanel.add(tbPanel,BorderLayout.NORTH);
			centerPanel = new JPanel(new BorderLayout());
				spl1 = new JSplitPane();
				
					splListe = new JSplitPane();
					splListe.setOrientation(JSplitPane.VERTICAL_SPLIT);
					splListe.setName("clientausgabe,splListe");
					
					
					ergebnisListenPanel = new JPanel(new BorderLayout());
						suchPanel = new JPanel(new BorderLayout());
							txtMuster = new JSelectedTextField();
					        txtMuster.addKeyListener(new java.awt.event.KeyAdapter() {
					            @Override
								public void keyReleased(java.awt.event.KeyEvent evt) {
					                if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
					                    suchenAction();
					                }
					            	}
					        	});
							suchPanel.add(txtMuster,BorderLayout.CENTER);
							btSuchen = new JButton();
							suchPanel.add(btSuchen,BorderLayout.EAST);
						scrErgebnis = new JScrollPane();
						
						  tblErgebnis=new JTable();
						  	tblErgebnis.setName("clientauswahl.ergebnis.spalten");
					        scrErgebnis.setViewportView(tblErgebnis);
					        Action enterKeyAction = new AbstractAction() {
					        	public void actionPerformed(ActionEvent e) {
					        	String actionCmd = e.getActionCommand();
					        	if (actionCmd.equals("EnterKey")) {
					        	//... code for the action
					        	}
					        	}
					        };							        
					        
					        InputMap inputMap = tblErgebnis.getInputMap(JComponent.WHEN_FOCUSED);
					        inputMap.remove(KeyStroke.getKeyStroke(KeyEvent.VK_ENTER,0));
					        tblErgebnis.setInputMap(JComponent.WHEN_FOCUSED,inputMap);
					        tblErgebnis.unregisterKeyboardAction(KeyStroke.getKeyStroke(KeyEvent.VK_ENTER,0));
					        
					        tblErgebnis.registerKeyboardAction(enterKeyAction,"EnterKey", KeyStroke.getKeyStroke(KeyEvent.VK_ENTER,0),JComponent.WHEN_FOCUSED);
					        
					        tblErgebnis.getSelectionModel().addListSelectionListener(new javax.swing.event.ListSelectionListener() {
					            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
					            	if(evt.getValueIsAdjusting()) {
										return;
									}
					                lstErgebnisValueChanged(evt);
					            }
					        });
			    				tblErgebnis.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
				    			tblErgebnis.setColumnSelectionAllowed(false);
				    			tblErgebnis.setRowSelectionAllowed(true);
				    			 tblErgebnis.addKeyListener(new java.awt.event.KeyAdapter() {
							            public void keyReleased(java.awt.event.KeyEvent evt) {
							                if(tblErgebnis.getSelectedRow() != -1) {
							                	tblErgebnis.setRowSelectionInterval(tblErgebnis.getSelectedRow(),tblErgebnis.getSelectedRow());
											}
							                if(tblErgebnis.isFocusOwner()) {
							                    if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
							                    	int i = tblErgebnis.getSelectedRow();
							                    	  lstErgebnisValueChanged(null);
							                        tblErgebnis.setRowSelectionInterval(i,i);
							                    	evt=null;
							                    }
							                }
							            }
							        });
							        tblErgebnis.addMouseListener(new java.awt.event.MouseAdapter() {
							            public void mouseClicked(java.awt.event.MouseEvent evt) {
							                if (evt.getClickCount() == 2) {
							               	  lstErgebnisValueChanged(null);
							                }
							            }
							        });
				    			
					    	scrErgebnis.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
					    	scrErgebnis.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
					    	tblErgebnis.setAutoResizeMode(JTable.AUTO_RESIZE_SUBSEQUENT_COLUMNS);

						ergebnisListenPanel.add(scrErgebnis,BorderLayout.CENTER);
						ergebnisListenPanel.add(suchPanel,BorderLayout.NORTH);
						splListe.setTopComponent(ergebnisListenPanel);
						//----------------------------------------------------------
						auftragsPanel= new JPanel(new BorderLayout());
							auftragAnfragenTab = new JTabbedPane();
							auftragAnfragenTab.setTabLayoutPolicy(JTabbedPane.WRAP_TAB_LAYOUT);
								auftragAnfragenTab.addChangeListener(new ChangeListener() {
										public void stateChanged(ChangeEvent arg0) {
											switch(auftragAnfragenTab.getSelectedIndex()) {
												case 0: auftragslisteAction();
													break;
												case 1: anfragenlisteAction();
													break;
											}
										}
									});
						
								//-------------------------------------------
						    	// Auftragsliste
						    	//---------------------------------------------	 	
						    	auftragslistenPanel=new JPanel(new BorderLayout());
						    		auftragslistenPanel.setBorder(BorderFactory.createEtchedBorder());
						    		lblAuftragslisteTitel=new JLabel();
						    			lblAuftragslisteTitel.setHorizontalAlignment(SwingConstants.CENTER);
						    		auftragslistenPanel.add(lblAuftragslisteTitel, BorderLayout.NORTH);
						    		scrAuftragsliste=new JScrollPane();
						    			tblAuftragsliste = new JTable();
							 	        tblAuftragsliste.addMouseListener(new MouseAdapter() {
											public void mousePressed(MouseEvent e) {
							 	                if(e.getClickCount() !=1) {
							 	                }
							 	            }
										public void mouseReleased(MouseEvent e) {
					        			       tblAufragslisteSelectionChanged();     
								 	       }
							 	        });
						    			tblAuftragsliste.setName("clientauswahl.auftragsliste");
							    		tblAuftragsliste.setShowGrid(true);
						    			tblAuftragsliste.setGridColor(Color.BLACK);
						    		scrAuftragsliste.setViewportView(tblAuftragsliste);
						    		auftragslistenPanel.add(scrAuftragsliste);
						    		auftragsButtonPanel = new JPanel(new BorderLayout());
						    			auftragsButtonObenPanel=new JPanel(new GridLayout(2,2));
							    			btAuftragslisteRefresh=new JButton();
							    			auftragsButtonObenPanel.add(btAuftragslisteRefresh);
							    			btAuftragslisteDrucken=new JButton();
							    			auftragsButtonObenPanel.add(btAuftragslisteDrucken);
							    			btAuftragslisteBearbeiten=new JButton();
							    			auftragsButtonObenPanel.add(btAuftragslisteBearbeiten);
							    		auftragsButtonPanel.add(auftragsButtonObenPanel, BorderLayout.NORTH);
							    		
							    		auftragsButtonPanelUnten=new JPanel(new BorderLayout());
							    		lblAuftragsliste_text1=new JLabel();
					    		 		auftragsButtonPanelUnten.add(lblAuftragsliste_text1,BorderLayout.WEST);

		    		    	    		splAuftragsliste = new JSpinner();
			 			    	           splAuftragsliste.addChangeListener(new javax.swing.event.ChangeListener() {
			 			    	               public void stateChanged(javax.swing.event.ChangeEvent evt) {
			 			    	                	AuftragslisteSpinnerChanged(splAuftragsliste,evt);
			 			    	            	}
			 			    	           });
			 			    	          auftragsButtonPanelUnten.add(splAuftragsliste,BorderLayout.CENTER);

					    		 		lblAuftragsliste_text2=new JLabel();
					    		 		auftragsButtonPanelUnten.add(lblAuftragsliste_text2,BorderLayout.EAST);

										auftragsButtonPanel.add(auftragsButtonPanelUnten,BorderLayout.SOUTH);
							    		
						    		auftragslistenPanel.add(auftragsButtonPanel,BorderLayout.SOUTH);
							auftragAnfragenTab.add(auftragslistenPanel);
							
							//-------------------------------
							// AnfragenListe
							
							anfragenlistenPanel=new JPanel(new BorderLayout());
					    		anfragenlistenPanel.setBorder(BorderFactory.createEtchedBorder());
						    		lblanfragenlisteTitel=new JLabel();
						    			lblanfragenlisteTitel.setHorizontalAlignment(SwingConstants.CENTER);
						    		anfragenlistenPanel.add(lblanfragenlisteTitel, BorderLayout.NORTH);
						    		scrAnfragenliste=new JScrollPane();
						    			tblAnfragenliste = new JTable();
							 	        tblAnfragenliste.addMouseListener(new MouseAdapter() {
											public void mousePressed(MouseEvent e) {
							 	                if(e.getClickCount() !=1) {
							 	                }
							 	            }
										public void mouseReleased(MouseEvent e) {
					        			        tblAnfragenlisteSelectionChanged();     
								 	       }
							 	        });
						    			tblAnfragenliste.setName("clientauswahl.anfragenliste");
							    		tblAnfragenliste.setShowGrid(true);
						    			tblAnfragenliste.setGridColor(Color.BLACK);
						    		scrAnfragenliste.setViewportView(tblAnfragenliste);
						    		anfragenlistenPanel.add(scrAnfragenliste);
						    		anfragenButtonPanel = new JPanel(new BorderLayout());
						    			anfragenButtonObenPanel=new JPanel(new GridLayout(2,2));
							    			btAnfragenlisteRefresh=new JButton();
							    			anfragenButtonObenPanel.add(btAnfragenlisteRefresh);
							    			btAnfragenlisteDrucken=new JButton();
							    			anfragenButtonObenPanel.add(btAnfragenlisteDrucken);
							    			btAnfragenlisteBearbeiten=new JButton();
							    			anfragenButtonObenPanel.add(btAnfragenlisteBearbeiten);
							    		anfragenButtonPanel.add(anfragenButtonObenPanel, BorderLayout.NORTH);
							    		
							    		anfragenButtonPanelUnten=new JPanel(new BorderLayout());
							    		lblanfragenliste_text1=new JLabel();
					    		 		anfragenButtonPanelUnten.add(lblanfragenliste_text1,BorderLayout.WEST);
				
					    	    		splAnfragenliste = new JSpinner();
							    	           splAnfragenliste.addChangeListener(new javax.swing.event.ChangeListener() {
							    	               public void stateChanged(javax.swing.event.ChangeEvent evt) {
							    	                	anfragenlisteSpinnerChanged(splAnfragenliste,evt);
							    	            	}
							    	           });
							    	          anfragenButtonPanelUnten.add(splAnfragenliste,BorderLayout.CENTER);
				
					    		 		lblanfragenliste_text2=new JLabel();
					    		 		anfragenButtonPanelUnten.add(lblanfragenliste_text2,BorderLayout.EAST);
				
										anfragenButtonPanel.add(anfragenButtonPanelUnten,BorderLayout.SOUTH);
							    		
						    		anfragenlistenPanel.add(anfragenButtonPanel,BorderLayout.SOUTH);
							auftragAnfragenTab.add(anfragenlistenPanel);
								
							auftragsPanel.add(auftragAnfragenTab,BorderLayout.CENTER);
						splListe.setBottomComponent(auftragsPanel);
					spl1.setLeftComponent(splListe);
					rightPanel = new JPanel(new BorderLayout());
						splRight = new JSplitPane();
						splRight.setOrientation(JSplitPane.VERTICAL_SPLIT);
						splRight.setName("clientausgabe,splRight");
						splRightOben = new JPanel(new BorderLayout());
					
						scrAusgabe=new JScrollPane();
						txtErgebnis = new JEditorPane();
							txtErgebnis.setContentType("text/html");
							txtErgebnis.addHyperlinkListener(new javax.swing.event.HyperlinkListener() {
					            public void hyperlinkUpdate(javax.swing.event.HyperlinkEvent evt) {
					                if(evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED){
						                	ergebnisLinkAction(txtErgebnis);
					                	}
						            }
						        });
							scrAusgabe.setViewportView(txtErgebnis);
						splRightOben.add(scrAusgabe);
						splRight.setTopComponent(splRightOben);
						
							buchungenPanel=new JPanel(new BorderLayout());
								buchungenRefreshPanel=new JPanel(new BorderLayout());
									this.btRefreshBuchungen = new JButton();
									buchungenRefreshPanel.add(btRefreshBuchungen,BorderLayout.CENTER);
								buchungenPanel.add(buchungenRefreshPanel,BorderLayout.NORTH);
								scrBuchungen = new JScrollPane();
									txtBuchungen = new JEditorPane();
										txtBuchungen.setContentType("text/html");
										txtBuchungen.setEditable(false);
									scrBuchungen.setViewportView(txtBuchungen);
									 	txtBuchungen.setMinimumSize(new Dimension(200,200));
								buchungenPanel.add(scrBuchungen,BorderLayout.CENTER);

						splRight.setBottomComponent(buchungenPanel);
					spl1.setRightComponent(splRight);
				centerPanel.add(spl1,BorderLayout.CENTER);
		contentPanel.add(centerPanel,BorderLayout.CENTER);
		//Panels ans Fenster hängen;
		this.getContentPane().setLayout(new BorderLayout());

		this.getContentPane().add(contentPanel, BorderLayout.CENTER);
    }
    
	public void setWindowCaption() {
	     setTitle(rz.getVersionString() + " " + rz.getLocale().getString("auswahl.titel") + "  " + rz.getLocale().getString("benutzer")+" " + rz.getDatabase().dbGetUser() + " " + rz.getDatabase().getKalender().getDatum20Now());
	}

    @Override
	public void setGUIComponents() {
    	setWindowCaption();
		mnuDatei.setText(rz.getLocale().getString("menu.datei"));
		mnuBearbeiten.setText(rz.getLocale().getString("menu.bearbeiten"));
		mnuExtras.setText(rz.getLocale().getString("menu.extras"));
	    mnuFenster.setText(rz.getLocale().getString("menu.fenster"));
		mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));

		mnuDatei.add(getAction(ACTION_ANFRAGENLISTE_DRUCKEN_CODE));
		mnuDatei.addSeparator();
        mnuDatei.add(getAction(ACTION_QUIT_CODE));
        
        mnuExtras.add(getAction(ACTION_HIDE_CODE));
        mnuHilfe.add(getAction(ACTION_HILFE_CODE));
        mnuHilfe.addSeparator();
        mnuHilfe.add(getAction(ACTION_ABOUT_CODE));
		mnuBearbeiten.add(getAction(ACTION_HINWEIS_CODE));
		mnuBearbeiten.add(getAction(ACTION_STATISTIK_EINZELN_CODE));
		mnuBearbeiten.add(getAction(ACTION_STATISTIK_GRUPPE_CODE));
        mnuBearbeiten.addSeparator();
		mnuBearbeiten.add(getAction(ACTION_ABGANG_CODE));
		mnuBearbeiten.add(getAction(ACTION_CONTAINER_RETURN_CODE));
		mnuBearbeiten.addSeparator();
		mnuBearbeiten.add(getAction(ACTION_GEWICHT_CODE));
		mnuBearbeiten.addSeparator();
		mnuBearbeiten.add(getAction(ACTION_AUFTRAG_CODE));
		mnuBearbeiten.add(getAction(ACTION_SHOW_AUFTRAGSLISTE_CODE));
		mnuBearbeiten.add(getAction(ACTION_SHOW_ANFRAGENLISTE_CODE));
		mnuBearbeiten.addSeparator();
		mnuBearbeiten.add(getAction(ACTION_SHOW_LOSNUMMER_VORLAGE_CODE));
		mnuBearbeiten.addSeparator();
        mnuBearbeiten.add(getAction(ACTION_SPEZIFIKATION_DRUCKEN_KOMPLETT_CODE));
        mnuBearbeiten.add(getAction(ACTION_SPEZIFIKATION_PDF_KOMPLETT_CODE));
        mnuBearbeiten.addSeparator();
        mnuBearbeiten.add(getAction(ACTION_DOKUMENTE_CODE));
        mnuFenster.add(getAction(ACTION_PROBE_CODE));
		mnuFenster.add(getAction(ACTION_EINSTELLUNGEN_CODE));
		mnuFenster.add(getAction(ACTION_KALENDER_CODE));
		mnuFenster.addSeparator();
        mnuFenster.add(getAction(ACTION_SHOW_TANKLISTE_CODE));

		tb1.add(getAction(ACTION_QUIT_CODE));
		tb1.add(getAction(ACTION_HIDE_CODE));
		tb1.addSeparator();
        tb1.add(getAction(ACTION_CONTAINER_RETURN_CODE));
        tb1.addSeparator();
		tb1.add(getAction(ACTION_HINWEIS_CODE));
		tb1.add(getAction(ACTION_STATISTIK_EINZELN_CODE));
		tb1.add(getAction(ACTION_STATISTIK_GRUPPE_CODE));
		tb1.add(getAction(ACTION_GEWICHT_CODE));
		tb1.addSeparator();
		tb1.add(getAction(ACTION_ABGANG_CODE));
		tb1.addSeparator();
        tb1.add(getAction(ACTION_SPEZIFIKATION_DRUCKEN_KOMPLETT_CODE));
        tb1.add(getAction(ACTION_SPEZIFIKATION_PDF_KOMPLETT_CODE));
        tb1.addSeparator();
		tb1.add(getAction(ACTION_HILFE_CODE));
		tb1.addSeparator();
		tb1.add(getAction(ACTION_EINSTELLUNGEN_CODE));
        tb1.add(getAction(ACTION_PROBE_CODE));
		tb1.addSeparator();
		tb1.add(getAction(ACTION_AUFTRAG_CODE));
		tb1.add(getAction(ACTION_SHOW_AUFTRAGSLISTE_CODE));
		tb1.add(getAction(ACTION_SHOW_ANFRAGENLISTE_CODE));
		tb1.addSeparator();
		tb1.add(getAction(ACTION_SHOW_LOSNUMMER_VORLAGE_CODE));
		tb1.addSeparator();
        tb1.add(getAction(ACTION_SHOW_TANKLISTE_CODE));
		tb1.add(getAction(ACTION_KALENDER_CODE));
		tb1.addSeparator();
		tb1.add(getAction(ACTION_DOKUMENTE_CODE));
		tb1.addSeparator();
        tb1.add(getAction(ACTION_ABOUT_CODE));

		getAction(ACTION_HINWEIS_CODE).setEnabled(false);
		getAction(ACTION_STATISTIK_EINZELN_CODE).setEnabled(false);
		getAction(ACTION_STATISTIK_GRUPPE_CODE).setEnabled(false);
		getAction(ACTION_ABGANG_CODE).setEnabled(false);
		getAction(ACTION_GEWICHT_CODE).setEnabled(false);
		getAction(ACTION_SPEZIFIKATION_DRUCKEN_KOMPLETT_CODE).setEnabled(false);
		getAction(ACTION_SPEZIFIKATION_PDF_KOMPLETT_CODE).setEnabled(false);
		getAction(ACTION_DOKUMENTE_CODE).setEnabled(false);
		//getAction(ACTION_AUFTRAG_CODE).setEnabled(false);
        
		
        btAuftragslisteDrucken.setAction(getAction(ACTION_AUFTRAGSLISTE_DRUCKEN_CODE));
        btAuftragslisteRefresh.setAction(getAction(ACTION_AUFTRAGSLISTE_REFRESH_CODE));
        btAuftragslisteBearbeiten.setAction(getAction(ACTION_SHOW_AUFTRAGSLISTE_CODE));
        
        btAnfragenlisteDrucken.setAction(getAction(ACTION_ANFRAGENLISTE_DRUCKEN_CODE));
        btAnfragenlisteRefresh.setAction(getAction(ACTION_ANFRAGENLISTE_REFRESH_CODE));
        btAnfragenlisteBearbeiten.setAction(getAction(ACTION_SHOW_ANFRAGENLISTE_CODE));
		
		btSuchen.setAction(getAction(ACTION_SUCHEN_CODE));
		btRefreshBuchungen.setAction(getAction(ACTION_REFRESH_CODE));
		
        this.splAuftragsliste.setValue(Integer.valueOf(rz.getOptionFactory().getOption("client_auftragsliste.timer")));
        this.splAnfragenliste.setValue(Integer.valueOf(rz.getOptionFactory().getOption("client_anfragenliste.timer")));
        auftragAnfragenTab.setSelectedIndex(rz.getOptionFactory().getOption("clientauswahl.tab1_state",0));

        
        if (!auftragslisteTimer.isRunning()) auftragslisteTimer.start();
        if (!anfragenlisteTimer.isRunning()) anfragenlisteTimer.start();
        
        auftragAnfragenTab.setTitleAt(0,rz.getLocale().getString("auswahl.panel_auftragsliste"));
        auftragAnfragenTab.setTitleAt(1,rz.getLocale().getString("auswahl.panel_anfragenliste"));
        
        setResizable(true);
        rz.getFontFactory().setFrameFonts(this);
        pack();
        rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;
    }

    @Override
	public void getMessage(MessageItem msg) {
		rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE,"client-auswahlfenster",String.valueOf(msg.getMsgCode()+":"+String.valueOf(msg.getCode())));
        switch(msg.getMsgCode()) {
    	case MessageItem.MSG_ACTIONPERFORMED:
            switch(msg.getCode()){
		          case ACTION_SPEZIFIKATION_PDF_KOMPLETT_CODE:direktDruckAction(ACTION_SPEZIFIKATION_PDF_KOMPLETT_CODE);break;
		          case ACTION_SPEZIFIKATION_DRUCKEN_KOMPLETT_CODE:direktDruckAction(ACTION_SPEZIFIKATION_DRUCKEN_KOMPLETT_CODE);break;
		          case ACTION_HILFE_CODE: hilfeAction();break;
		          case ACTION_HIDE_CODE:hideAction();break;
		          case ACTION_QUIT_CODE:closeWindow();break;
		          case ACTION_SUCHEN_CODE:suchenAction();break;
		          case ACTION_ABGANG_CODE: abgangAction();break;
		          case ACTION_STATISTIK_EINZELN_CODE : statistikEinzelnAction(MessageItem.MSG_SHOW_STATISTIK);break;
		          case ACTION_STATISTIK_GRUPPE_CODE : statistikGruppeAction(MessageItem.MSG_SHOW_STATISTIK);break;
		          case ACTION_CONTAINER_RETURN_CODE:containerReturnAction();break;
		          case ACTION_ABOUT_CODE:aboutAction();break;
		          case ACTION_EINSTELLUNGEN_CODE:einstellungenAction();break;
		          case ACTION_HINWEIS_CODE:hinweisAction();break;
		          case ACTION_GEWICHT_CODE:gewichtAction();break;
		          case ACTION_KALENDER_CODE:showKalenderAction();break;
		          case ACTION_SHOW_TANKLISTE_CODE:showTankListeAction();break;
		          case ACTION_PROBE_CODE:probenAction();break;
		          case ACTION_REFRESH_CODE:refreshBuchungenAction();break;
		          case ACTION_AUFTRAG_CODE: showAuftragAction();break;
		          case ACTION_SHOW_AUFTRAGSLISTE_CODE: showAuftragslisteAction();
		          case ACTION_SHOW_LOSNUMMER_VORLAGE_CODE:losnummerVorlageAction();break;
		          case ACTION_AUFTRAGSLISTE_REFRESH_CODE: getAuftragsListe();break;
		          case ACTION_DOKUMENTE_CODE:dokumenteAction();break;
		          case ACTION_AUFTRAGSLISTE_DRUCKEN_CODE:
		        	  if(auftragsliste != null && !auftragsliste.isEmpty()) {
		        		  rz.getReportFactory().auftragslistenReport(auftragsliste,false, this);
		        	  }
		        	  break;
		          case ACTION_ANFRAGENLISTE_DRUCKEN_CODE:
		        	  if(anfragenliste != null && !anfragenliste.isEmpty()) {
		        		  rz.getReportFactory().auftragslistenReport(anfragenliste,false, this);
		        	  }
		        	  break;
		          case ACTION_SHOW_ANFRAGENLISTE_CODE: showAnfragenlisteAction();
		          	break;
		          case ACTION_ANFRAGENLISTE_REFRESH_CODE: getAnfragenListe();break;
		          
		          case MessageItem.MSG_ADD_QUERY_ZUGANG:
		          case MessageItem.MSG_ADD_QUERY_ABGANG:
		          case MessageItem.MSG_ADD_QUERY_NOTIZ:
		          case MessageItem.MSG_ADD_QUERY_REZEPT:
		        	  	refreshTable(msg.getCode());
		              	ergebnisTimerEvent();
		            	break;
		          default :
		              break;
           }
			break;
			case MessageItem.MSG_REFRESH_AUSGABE:
				getAuftragsListe();
				getAnfragenListe();
				refreshBuchungenAction();
				refreshTable(msg.getCode());
				ergebnisTimerEvent();
			break;
			case MessageItem.MSG_REFRESH_CAPTION:
		     	setWindowCaption();
		     	break;
			   case MessageItem.MSG_EINGABEDIALOG_REPLY:
		    		modifyTankReply(msg);
		    	 break;
        default:
            break;
        }

    }
    @Override
	public void createActions(){
        actionList.put(String.valueOf(ACTION_QUIT_CODE),new AuswahlAction(rz,this,ACTION_QUIT_CODE,ACTION_QUIT_TEXT, KeyEvent.VK_F4 ,InputEvent.ALT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT, KeyEvent.VK_F5 ,InputEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT, KeyEvent.VK_F1,0));
        actionList.put(String.valueOf(ACTION_SUCHEN_CODE),new AuswahlAction(rz,this,ACTION_SUCHEN_CODE,ACTION_SUCHEN_TEXT, KeyEvent.VK_S,InputEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_ABGANG_CODE),new AuswahlAction(rz,this,ACTION_ABGANG_CODE,ACTION_ABGANG_TEXT, KeyEvent.VK_F7,InputEvent.CTRL_DOWN_MASK + InputEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_STATISTIK_EINZELN_CODE),new AuswahlAction(rz,this,ACTION_STATISTIK_EINZELN_CODE,ACTION_STATISTIK_EINZELN_TEXT, KeyEvent.VK_S,InputEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_STATISTIK_GRUPPE_CODE),new AuswahlAction(rz,this,ACTION_STATISTIK_GRUPPE_CODE,ACTION_STATISTIK_GRUPPE_TEXT, KeyEvent.VK_S,InputEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_ABOUT_CODE),new AuswahlAction(rz,this,ACTION_ABOUT_CODE,ACTION_ABOUT_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_EINSTELLUNGEN_CODE),new AuswahlAction(rz,this,ACTION_EINSTELLUNGEN_CODE,ACTION_EINSTELLUNGEN_TEXT, KeyEvent.VK_F12,0));
        actionList.put(String.valueOf(ACTION_HINWEIS_CODE),new AuswahlAction(rz,this,ACTION_HINWEIS_CODE,ACTION_HINWEIS_TEXT, KeyEvent.VK_F2,InputEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_CONTAINER_RETURN_CODE),new AuswahlAction(rz,this,ACTION_CONTAINER_RETURN_CODE,ACTION_CONTAINER_RETURN_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_GEWICHT_CODE),new AuswahlAction(rz,this,ACTION_GEWICHT_CODE,ACTION_GEWICHT_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_KALENDER_CODE),new AuswahlAction(rz,this,ACTION_KALENDER_CODE,ACTION_KALENDER_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_PROBE_CODE),new AuswahlAction(rz,this,ACTION_PROBE_CODE,ACTION_PROBE_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_REFRESH_CODE),new AuswahlAction(rz,this,ACTION_REFRESH_CODE,ACTION_REFRESH_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_AUFTRAG_CODE),new AuswahlAction(rz,this,ACTION_AUFTRAG_CODE,ACTION_AUFTRAG_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_SHOW_AUFTRAGSLISTE_CODE),new AuswahlAction(rz,this,ACTION_SHOW_AUFTRAGSLISTE_CODE,ACTION_SHOW_AUFTRAGSLISTE_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_AUFTRAGSLISTE_REFRESH_CODE),new AuswahlAction(rz,this,ACTION_AUFTRAGSLISTE_REFRESH_CODE,ACTION_AUFTRAGSLISTE_REFRESH_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_AUFTRAGSLISTE_DRUCKEN_CODE),new AuswahlAction(rz,this,ACTION_AUFTRAGSLISTE_DRUCKEN_CODE,ACTION_AUFTRAGSLISTE_DRUCKEN_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_ANFRAGENLISTE_REFRESH_CODE),new AuswahlAction(rz,this,ACTION_ANFRAGENLISTE_REFRESH_CODE,ACTION_ANFRAGENLISTE_REFRESH_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_ANFRAGENLISTE_DRUCKEN_CODE),new AuswahlAction(rz,this,ACTION_ANFRAGENLISTE_DRUCKEN_CODE,ACTION_ANFRAGENLISTE_DRUCKEN_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_SHOW_ANFRAGENLISTE_CODE),new AuswahlAction(rz,this,ACTION_SHOW_ANFRAGENLISTE_CODE,ACTION_SHOW_ANFRAGENLISTE_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_SHOW_TANKLISTE_CODE),new AuswahlAction(rz,this,ACTION_SHOW_TANKLISTE_CODE,ACTION_SHOW_TANKLISTE_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_SPEZIFIKATION_DRUCKEN_KOMPLETT_CODE),new AuswahlAction(rz,this,ACTION_SPEZIFIKATION_DRUCKEN_KOMPLETT_CODE,ACTION_SPEZIFIKATION_DRUCKEN_KOMPLETT_TEXT, KeyEvent.VK_P,KeyEvent.CTRL_DOWN_MASK + KeyEvent.ALT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_SPEZIFIKATION_PDF_KOMPLETT_CODE),new AuswahlAction(rz,this,ACTION_SPEZIFIKATION_PDF_KOMPLETT_CODE,ACTION_SPEZIFIKATION_PDF_KOMPLETT_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_SHOW_LOSNUMMER_VORLAGE_CODE),new AuswahlAction(rz,this,ACTION_SHOW_LOSNUMMER_VORLAGE_CODE,ACTION_SHOW_LOSNUMMER_VORLAGE_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_DOKUMENTE_CODE),new AuswahlAction(rz,this,ACTION_DOKUMENTE_CODE,ACTION_DOKUMENTE_TEXT, 0,0));
    }

    private void modifyTankReply(MessageItem msg) {
    	String content = (String)msg.getData();
    	if(content != null && msg.getCode() > 0) {
        	rz.getDatabase().getBuchungen().setComment(content,msg.getCode());
        	rz.getFensterFactory().getFensterListe().propagateBestand(this,rz.getDatabase().getBuchungen().getEinzelBuchung(msg.getCode()).getRezeptur_id());
    	}
    }
    
    
	
	private void losnummerVorlageAction() {
		   rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_LOSNUMMER_VORLAGE,true,new MessageItem(MessageItem.MSG_SHOW_LOSNUMMERVORLAGE_SINGLE, 0,null,this));
	}
    /**
     * Direktdruck
     */
    private void direktDruckAction(int formular) {
        if(tblErgebnis.getSelectedRow() != -1) {
            final ErgebnisItem ei =ergebnisse.getItem(tblErgebnis.getSelectedRow());
            if(ei != null) {
            	SPFormblattItem spf;
                if((ei.getTyp() == RzPro.TYP_ID_REZEPT) || (ei.getTyp() == RzPro.TYP_ID_VERWEIS)) {
                	final RechenItem ri = new RechenItem(rz,ei.getID(),null);
        	    	ri.setWaehrung(rz.getDatabase().getCurrency().dbGetCurrency(ri.getRezeptur().getWaehrung(),true));
        	    	ri.rechnen(100,RechenItem.RECHNEN_LITER);
        	    	switch (formular) {
        	    		case ACTION_SPEZIFIKATION_DRUCKEN_KOMPLETT_CODE:
        	    			if(getDruckTitel(ri)) {
	        	    			spf = rz.getDatabase().getDeklarationen().getFormBlatt(ei.getName());
	        	    			DruckFormularDialog dfd=new DruckFormularDialog(rz,spf,ri,false,this);
	        	    			dfd.showDialog();
	        	    			dfd.dispose();
        	    			}
        	    			//rz.getReportFactory().SPFormblattReport(spf,this);
        	    			//rz.getReportFactory().rechenAuswahlReport(ri,this,"auswahl.formular_spezifikation");
        	    			break;
        	    		case ACTION_SPEZIFIKATION_PDF_KOMPLETT_CODE:
        	    			if(getDruckTitel(ri)) {
	        	    			spf = rz.getDatabase().getDeklarationen().getFormBlatt(ei.getName());
	        	    			DruckFormularDialog dfdp=new DruckFormularDialog(rz,spf,ri,true,this);
	        	    			dfdp.showDialog();
	        	    			dfdp.dispose();
        	    			}
        	    			//rz.getReportFactory().SPFormblattReportPDF(spf,this,ri.getRezeptur().getTitel());
        	    			//rz.getReportFactory().rechenAuswahlReportPDF(ri,this,"auswahl.formular_spezifikation",ri.getRezeptur().getTitel());
        	    			break;
        	    	}
              	} else if (ei.getTyp()==RzPro.TYP_ID_AUSSTATTUNG) {
              		int report = rz.getOptionFactory().getOption("report.ausstattung_calc",-1);
              		final AusstattungsItem ai = rz.getDatabase().getAusstattung().getAusstattung(ei.getID());
              		final CurrencyItem ci = rz.getDatabase().getCurrency().dbGetCurrency(rz.getOptionFactory().getOption("kalkulation.currency",1),true);
              		if(report == -1) {
                  		final ArrayList<Integer> liste = rz.getDatabase().getAusstattung().getAusstattungsReportFormular(ReportFactory.REPORT_TYPE_AUSSTATTUNG_CALC);
                  		if(!liste.isEmpty()) {
                  			report = liste.get(0);
                  			rz.getOptionFactory().setOption("report.ausstattung_calc", report);
                  		}
              		}
              		if ((ai != null) && (ci != null) && (report >0)) {
              			ai.rechnen(ai.getGebindegroesse(), ci);
              			rz.getReportFactory().AusstattungCalcReport(ai,  ci, this);
              		}
              	}

             }
         }
    	rz.setFreeCursor(this);
    }
    
    private boolean getDruckTitel(RechenItem ri) {
    	boolean ret = false;
    	if(ri != null) {
    		String in=ri.getRezeptur().getTitel();
            final DialogItem di  = new DialogItem(
                    DialogControl.EINGABE_SPEZIFIKATION_DIALOG,
                    "",0.0,
                    rz.getLocale().getString("spezifikation_drucken_titel_label"),
                    rz.getLocale().getString("spezifikation_drucken_titel_caption").replaceAll("%s",ri.getRezeptur().getTitel()),
                    in,
                    "frage.png",
                    rz.getLocale().getString("string_ok"),
                    rz.getLocale().getString("string_abbrechen"),
                    null
            );
            EingabeDialog dlge = rz.getDialogFactory().getEingabeSpezifikationDruck(di);
            dlge.showDialog();
            if(di.getReplyCode() == DialogControl.DIALOG_OK) {
            	String out = di.getContent().trim();
            	if(!out.equals("")) {
            		ri.getRezeptur().setTitel(out);
            		ri.setSpezifikationTextDrucken(dlge.isSpezifikationDruck());
            		ri.setDuplex(dlge.isDuplex());
            		ret = true;
            	}
            }
            if(dlge != null) {
            	dlge.dispose();
            }
    	}
    	return ret;
    }
    
    private void ergebnisLinkAction(JEditorPane txt) {
		 final Document d = txt.getDocument();
		 final HTMLDocument hd = (HTMLDocument)d;
		 final int pos = txt.viewToModel( txt.getMousePosition() );
		 if ( pos >= 0 ) {
		 	final Element e = hd.getCharacterElement(pos);
		 	if (e != null) {
		 		final SimpleAttributeSet se = (SimpleAttributeSet)e.getAttributes().getAttribute(HTML.Tag.A);
		 		if(se != null) {
			 		final String ziel = se.getAttribute(HTML.Attribute.HREF).toString();
		 			if (ziel.indexOf("ttt:") != -1) {
                   		String nummer = ziel.substring(4).trim();
                   		ArrayList<tankItem> ti = rz.getDatabase().getTank().getTankListeFromTankPattern(nummer);
                        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_TANKAUSWAHL,false,new MessageItem(MessageItem.MSG_SHOW_TANKAUSWAHL,0,(Object)(new tankAuswahlItem(ti,this,null,null,null)),this));
                    }else if(ziel.indexOf("DD:") != -1) {
                    	try {
                    		long m = Long.parseLong(ziel.substring(3));
                        	if(m > 0) {
                       	        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_KALENDER,true,new MessageItem(MessageItem.MSG_SHOW_KALENDER_DATUM,0,new Date(m),this));
                        	}
                    	}catch(final NumberFormatException e2) {}
                    } else if(ziel.indexOf("doc:") != -1) {
		 				int n = Integer.parseInt(ziel.substring(4));
                		if(n > 0) {
                			rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_DOCUMENT_LISTE,false,new MessageItem(MessageItem.MSG_SHOW_DOKUMENT_LISTE,0,Integer.valueOf(n),this));
                		}
		 			}   else if (ziel.indexOf("tco:") != -1) {
                   		try {
                    		int id = Integer.parseInt(ziel.substring(4));
                    		BuchungsItem bi = rz.getDatabase().getBuchungen().getEinzelBuchung(id);
                        	if(bi != null) {
                              	String hinweis = bi.getComment() +" ";
                                  final DialogItem di  = new DialogItem(
                                          DialogControl.EINGABE_DIALOG,
                                          "",0.0,
                                          rz.getLocale().getString("auswahl.hinweis_label"),
                                          rz.getLocale().getString("auswahl.tank_caption")
                                          	.replaceAll("%s",bi.getBezeichnung())
                                          	.replaceAll("%l", bi.getLosnummer()),
                                          hinweis,
                                          "frage.png",
                                          rz.getLocale().getString("string_ok"),
                                          rz.getLocale().getString("string_abbrechen"),
                                          null
                                  );
                                  EingabeDialog edi = new EingabeDialog(rz,di,true,true);
                                  edi.setOrigin(this);
                                  edi.toggleEingabe(false);
                                  edi.setBuchungsItem(bi.getId());
                                  edi.setModal(false);
                                  edi.showDialog();
                        	}
                    	}catch (Exception e5){};
                    }
		 		}
		 	}
		 }
    }
    
	private void dokumenteAction() {
    	if(tblErgebnis.getSelectedRow() != -1) {
            final ErgebnisItem ei =ergebnisse.getItem(tblErgebnis.getSelectedRow());
            if(ei != null ) {
            	if((ei.getTyp()==RzPro.TYP_ID_REZEPT) || (ei.getTyp() == RzPro.TYP_ID_VERWEIS) || ei.getTyp() == RzPro.TYP_ID_NOTIZ || ei.getTyp() == RzPro.TYP_ID_AUSSTATTUNG) {
            	 	rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_DOCUMENT_LISTE,false,new MessageItem(MessageItem.MSG_SHOW_DOKUMENT_LISTE,0,(Object)ei.getID(),this));
            	}
            }
		}
	}
    private void showTankListeAction() {
   		ArrayList<tankItem> ti = rz.getDatabase().getTank().getTankListeFromTankPattern("");
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_TANKAUSWAHL,false,new MessageItem(MessageItem.MSG_SHOW_TANKAUSWAHL,0,(Object)(new tankAuswahlItem(ti,this,null,null,null)),this));
    }
    
    private void showAnfragenlisteAction() {
		rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_AUFTRAGSLISTE,true,new MessageItem(MessageItem.MSG_SHOW_AUFTRAGSLISTE_ANFRAGEN,0,null,this));
    }
    
    private void showAuftragslisteAction() {
		rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_AUFTRAGSLISTE,true,new MessageItem(MessageItem.MSG_SHOW_AUFTRAGSLISTE,0,null,this));
    }

    private void refreshBuchungenAction() {
    	ArrayList<ClientBuchungsItem> liste=rz.getDatabase().getBuchungen().getBuchungenForToday();
    	if (liste != null) {
    		rz.getAusgabeFactory().clientBuchungenAusgabe(liste,txtBuchungen);
    	}
    }
    
    
    private void showAuftragAction() {
    	if(tblErgebnis.getSelectedRow()!= -1) {
    		final ErgebnisItem ei =ergebnisse.getItem(tblErgebnis.getSelectedRow());
    		rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_AUFTRAG,false,new MessageItem(MessageItem.MSG_SHOW_AUFTRAG,ei.getID(),null,this));
    	} else {
    		rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_AUFTRAG,false,new MessageItem(MessageItem.MSG_SHOW_AUFTRAG,0,null,this));    		
    	}
    }
    /**
     * probenfenster anzeigen
     */
    private void probenAction() {
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_PROBE,true,new MessageItem(MessageItem.MSG_SHOW_PROBENFENSTER,0,null,this));
    }
    
    private void gewichtAction() {
        if(tblErgebnis.getSelectedRow() != -1) {
            final ErgebnisItem ei =ergebnisse.getItem(tblErgebnis.getSelectedRow());
            if(ei != null) {
                if((ei.getTyp() == RzPro.TYP_ID_REZEPT) || (ei.getTyp() == RzPro.TYP_ID_VERWEIS)) {
                    rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_GEWICHT,false,new MessageItem(MessageItem.MSG_SHOW_GEWICHT,ei.getID(),null,this));
                }
            }
        }
    }
    
    private void anfragenlisteAction() {
    	if (this.anfragenlisteTimer != null) {
	    	if(this.anfragenlisteTimer.isRunning()) {
	    		this.anfragenlisteTimer.restart();
	    	}else {
	    		this.anfragenlisteTimer.start();
	    	}
    	}
    	//liste neu einlesen
    	getAnfragenListe();
    }
    
    private void getAnfragenListe() {
    	anfragenliste=rz.getDatabase().getAuftrag().getAuftragsliste(DBAuftrag.AUFTRAEGE_ANFRAGEN,false,"");
        ((AbstractTableModel)tblAnfragenliste.getModel()).fireTableDataChanged();
    }
    
    private void auftragslisteAction() {
    	if (this.auftragslisteTimer != null) {
	    	if(this.auftragslisteTimer.isRunning()) {
	    		this.auftragslisteTimer.restart();
	    	}else {
	    		this.auftragslisteTimer.start();
	    	}
    	}
    	//liste neu einlesen
    	getAuftragsListe();
    }
    
    private void getAuftragsListe() {
    	auftragsliste=rz.getDatabase().getAuftrag().getAuftragsliste(DBAuftrag.AUFTRAEGE_SICHTBARE,false,"");
        ((AbstractTableModel)tblAuftragsliste.getModel()).fireTableDataChanged();
    }

    private void anfragenlisteSpinnerChanged(JSpinner origin,javax.swing.event.ChangeEvent evt) {
    	int m=1;
    	final int v = ((Integer)this.splAnfragenliste.getValue()).intValue();
    	if (v <= 1) {
    		m=1;
    	} 	else {
    		if (v > RzPro.MAX_AUFTRAGSLISTE_INTERVAL) {
    			m = RzPro.MAX_AUFTRAGSLISTE_INTERVAL;
    		} else {
    			m=v;
    		}
    	}
    	this.splAnfragenliste.setValue(Integer.valueOf(m));
    	if(this.anfragenlisteTimer != null) {
    		if (anfragenlisteTimer.isRunning()){
    			anfragenlisteTimer.stop();
    		}
    		anfragenlisteTimer.setDelay(m * MILLISECONDS_PER_MINUTE);
    		anfragenlisteTimer.start();
    	}
    }
    
    private void AuftragslisteSpinnerChanged(JSpinner origin,javax.swing.event.ChangeEvent evt) {
    	int m=1;
    	final int v = ((Integer)this.splAuftragsliste.getValue()).intValue();
    	if (v <= 1) {
    		m=1;
    	} 	else {
    		if (v > RzPro.MAX_AUFTRAGSLISTE_INTERVAL) {
    			m = RzPro.MAX_AUFTRAGSLISTE_INTERVAL;
    		} else {
    			m=v;
    		}
    	}
    	this.splAuftragsliste.setValue(Integer.valueOf(m));
    	if(this.auftragslisteTimer != null) {
    		if (auftragslisteTimer.isRunning()){
    			auftragslisteTimer.stop();
    		}
    		auftragslisteTimer.setDelay(m * MILLISECONDS_PER_MINUTE);
    		auftragslisteTimer.start();
    	}
    }
    
    
	
	private void tblAufragslisteSelectionChanged() {
		
	}
	
	private void tblAnfragenlisteSelectionChanged() {
		int col = tblAnfragenliste.getSelectedColumn();
		int row = tblAnfragenliste.getSelectedRow();
		if(col != -1 && row != -1) {
			AuftragsItem ai = anfragenliste.getItem(row);
			switch(col) {
				case AL_C_BEZEICHNUNG:
	    			rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_AUFTRAG, false, new MessageItem(MessageItem.MSG_EDIT_AUFTRAG,0,ai,this));
					break;
			}
		}
	}
	
    /**
     * Behälter rückgabe
     */
    private void containerReturnAction() {
    	String liste="";
    	String ret="<ul>";
        final DialogItem di  = new DialogItem(
                DialogControl.EINGABE_DIALOG,
                "",0.0,
                rz.getLocale().getString("auswahl.containerReturn_label"),
                rz.getLocale().getString("auswahl.containerReturn_caption"),
                liste,
                "frage.png",
                rz.getLocale().getString("string_ok"),
                rz.getLocale().getString("string_abbrechen"),
                null
        );
        rz.getDialogFactory().getDialog(di);
        if(di.getReplyCode() == DialogControl.DIALOG_OK) {
        	liste = di.getContent().trim();
        	if(!liste.equals("")) {
        		int x=0;
        		final String n[]=liste.split(" |\\.|;|-|,");
        		for (int i=0;i < n.length;i++) {
        			if(!n[i].equals("")) {
        				try {
    						x = Integer.valueOf(n[i]);
    						if (x != -1) {
    							final int status = rz.getDatabase().getContainer().getStatus(x);
    							if(status == -1) {
    								ret += "<li><font color=\"red\">" + String.valueOf(x)+ rz.getLocale().getString("auswahl.container_nicht_gefunden") +  "</font></li>";
    							}else {
    								if(status == 1) {
	    								rz.getDatabase().getContainer().setStatusBack(x);
	    								ret += "<li><b><font color=\"green\">" + String.valueOf(x)+rz.getLocale().getString("auswahl.container_ok")+  "</font></b></li>";
    								} else {
										ret += "<li><font color=\"blue\">" + String.valueOf(x)+ rz.getLocale().getString("auswahl.container_schon_zurueck") +  "</font></li>";
									}
    							}
    						}
        				}catch(final NumberFormatException e) {
        				}
        			}
        		}
        		ret+="</ul>";
    	        dlgItem.setTyp(DialogControl.HINWEIS_DIALOG);
                dlgItem.setCaption(rz.getLocale().getString("auswahl_container_return_dialog"));
                dlgItem.setTitel(rz.getLocale().getString("auswahl_container_return_dialog"));
                dlgItem.setMessage(rz.getLocale().getString("auswahl_container_return_dialog_message").replaceAll("%l", ret));
                dlgItem.setIcon("warnung.png");
                dlgItem.setOk(rz.getLocale().getString("string_ok"));
               rz.getDialogFactory().getDialog(dlgItem);
        	}
        }
    }
    
	private void refreshTable(int id) {
		try {
			if(id != 0) {
				for(int i=0;i<ergebnisse.size(); i++) {
					if(ergebnisse.getItem(i).getID() == id) {
						ErgebnisItem ei=rz.getDatabase().getErgebnis().getErgebnisItem(ergebnisse.getItem(i).getID());
						int r=tblErgebnis.getSelectedRow();
						if(ei!=null) {
							ergebnisse.getItem(i).setVorschlagsBestand(ei.getVorschlagsBestand());
							ergebnisse.getItem(i).setBestand(ei.getBestand());
							((AbstractTableModel)tblErgebnis.getModel()).fireTableRowsUpdated(i,i);
						}
						tblErgebnis.setRowSelectionInterval(r,r);
						break;
					}
				}
			}
		}catch(Exception e) {
		}
	}
    
	private void setActions() {
		getAction(ACTION_HINWEIS_CODE).setEnabled(false);
		getAction(ACTION_STATISTIK_EINZELN_CODE).setEnabled(false);
		getAction(ACTION_STATISTIK_GRUPPE_CODE).setEnabled(false);
		getAction(ACTION_ABGANG_CODE).setEnabled(false);
		getAction(ACTION_GEWICHT_CODE).setEnabled(false);
		getAction(ACTION_AUFTRAG_CODE).setEnabled(true);
		getAction(ACTION_SPEZIFIKATION_DRUCKEN_KOMPLETT_CODE).setEnabled(false);
		getAction(ACTION_SPEZIFIKATION_PDF_KOMPLETT_CODE).setEnabled(false);
		getAction(ACTION_DOKUMENTE_CODE).setEnabled(false);
		if(tblErgebnis.getSelectedRow() != -1) {
			getAction(ACTION_HINWEIS_CODE).setEnabled(true);
			getAction(ACTION_STATISTIK_EINZELN_CODE).setEnabled(true);
			getAction(ACTION_STATISTIK_GRUPPE_CODE).setEnabled(true);
			getAction(ACTION_ABGANG_CODE).setEnabled(true);
			getAction(ACTION_GEWICHT_CODE).setEnabled(true);
			getAction(ACTION_SPEZIFIKATION_DRUCKEN_KOMPLETT_CODE).setEnabled(true);
			getAction(ACTION_SPEZIFIKATION_PDF_KOMPLETT_CODE).setEnabled(true);
			getAction(ACTION_DOKUMENTE_CODE).setEnabled(true);
			//getAction(ACTION_AUFTRAG_CODE).setEnabled(true);		
		}
	}
	
    private void lstErgebnisValueChanged(javax.swing.event.ListSelectionEvent evt) {
        if(ergebnisTimer.isRunning()) {
			ergebnisTimer.restart();
		} else {
			ergebnisTimer.start();
		}
    }

	/** speichert die Position der Splitbalken
	 */
    private void saveDividerLocations(){
        rz.getFensterFactory().setOption(this.getName() + ".spl1", this.spl1.getDividerLocation());
        rz.getFensterFactory().setOption(this.getName() + ".splr", this.splRight.getDividerLocation());
        rz.getFensterFactory().setOption(this.getName() + ".splliste", this.splListe.getDividerLocation());
        rz.getFensterFactory().saveOptions();
    }
	/** setzt die Position der Splitbalken auf gespeicherte Positionen oder
	 * auf Standardposition, wenn keine gespeicherten vorliegen
	 *
	 */
    private void setDividerLocations() {
        spl1.setDividerLocation(rz.getFensterFactory().getOption(this.getName() + ".spl1",this.getWidth()/2));
        splRight.setDividerLocation(rz.getFensterFactory().getOption(this.getName() + ".splr",this.getHeight()/2));
        splListe.setDividerLocation(rz.getFensterFactory().getOption(this.getName() + ".splliste",this.getHeight()/2));
    }

    /**
     * ergebnisTimerEvent zeigt an, dass eine Notiz/Rezeptur dargestellt werden
     * muss,
     */
    private void ergebnisTimerEvent(){
        if(ergebnisTimer.isRunning()) {
			ergebnisTimer.stop();
		}
        if (tblErgebnis.getSelectedRow() != -1){
            final ErgebnisItem ei = ergebnisse.getItem(tblErgebnis.getSelectedRow());
            rz.getAusgabeFactory().ergebnisAusgabeClient(ei.getID(),ei.getTyp(),txtErgebnis);
        }
        else {
            txtErgebnis.setEditable(true);
            txtErgebnis.setText("");
            txtErgebnis.setEditable(false);
        }
        refreshBuchungenAction();
    }

    private void abgangAction() {
        if(tblErgebnis.getSelectedRow() != -1) {
            final ErgebnisItem ei =  ergebnisse.getItem(tblErgebnis.getSelectedRow());
            if(ei != null) {
                if((ei.getTyp() == RzPro.TYP_ID_REZEPT) || (ei.getTyp() == RzPro.TYP_ID_VERWEIS)) {
                    rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_ABGANG,false,new MessageItem(MessageItem.MSG_SHOW_ABGANG,ei.getID(),null,this));
                }
            }
        }
    }

    /**
     * Hinweise bearbeiten
     */
    private void hinweisAction() {
    	String hinweis;
    	RezepturItem ri;
        if(tblErgebnis.getSelectedRow() != -1) {
            final ErgebnisItem ei =ergebnisse.getItem(tblErgebnis.getSelectedRow());
            if(ei != null) {
                if((ei.getTyp() == RzPro.TYP_ID_REZEPT) || (ei.getTyp() == RzPro.TYP_ID_VERWEIS)) {
                	ri = rz.getDatabase().getRezeptur().dbGetRezeptur(ei.getID(),true);
                	if(ri != null) {
                		hinweis = ri.getHinweis() + "                              ";
                        final DialogItem di  = new DialogItem(
                                DialogControl.EINGABE_DIALOG,
                                "",0.0,
                                rz.getLocale().getString("auswahl.hinweis_label"),
                                rz.getLocale().getString("auswahl.hinweis_caption").replaceAll("%s",ri.getTitel()),
                                hinweis,
                                "frage.png",
                                rz.getLocale().getString("string_ok"),
                                rz.getLocale().getString("string_abbrechen"),
                                null
                        );
                        rz.getDialogFactory().getDialog(di,true,false);
                        if(di.getReplyCode() == DialogControl.DIALOG_OK) {
                        	hinweis = di.getContent().trim();
                        	rz.getDatabase().getRezeptur().updateHinweis(ri.getID(),hinweis);
                            final AbfrageItem ai = new AbfrageItem();
                            ai.setTyp(DBAbfrage.ABFRAGE_TYP_NORMAL);
                            ai.setID(ri.getID());
                            ai.setAdressListe(ri.getAdressListe());
                            ai.setStichwortListe(ri.getStichwortListe());
                            ai.setMuster(rz.getDatabase().getErgebnis().getMusterString(ri.getTitel()));
                            this.getMessage(new MessageItem(MessageItem.MSG_ADD_QUERY_REZEPT,0,ai,this));
                        } else {
                        }
                	}
                }
            }
        }
    }

    /**
     * öffnet das Statistikfenster
     * @param msg  MessageItem.MSG_SHOW_STATISTIK oder essageItem.MSG_SHOW_STATISTIK_BESTAND
     */
    private void statistikEinzelnAction(int msg) {
        if(tblErgebnis.getSelectedRow() != -1) {
            final ErgebnisItem ei = ergebnisse.getItem(tblErgebnis.getSelectedRow());
            rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_STATISTIK,false,new MessageItem(msg,StatistikFenster.USER_FILTER,ei,this));
        }
    }
    /**
     * öffnet das Statistikfenster mit mehreren Rezepturen
     * @param msg  MessageItem.MSG_SHOW_STATISTIK oder essageItem.MSG_SHOW_STATISTIK_BESTAND
     */
    private void statistikGruppeAction(int msg) {
        if(ergebnisse.size() > 0) {
        	rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_STATISTIK,false,new MessageItem(msg,StatistikFenster.USER_FILTER,ergebnisse,this));
        }
    }

    private void einstellungenAction() {
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_CLIENT_EINSTELLUNGEN,true,new MessageItem(MessageItem.MSG_SHOW_EINSTELLUNGEN,0,null,this));
    }

    private void suchenAction() {
        abfrage.setMuster(txtMuster.getText().trim());
        ergebnisse=rz.getDatabase().getErgebnis().dbGetErgebnisListe(abfrage);
        ((AbstractTableModel)tblErgebnis.getModel()).fireTableDataChanged();
        if(ergebnisse.size() > 0) {
        	 tblErgebnis.setRowSelectionInterval(0,0);
        }
        tblErgebnis.requestFocus();
        setActions();
    }

    @Override
	public void openWindow(){
        setDividerLocations();
        if(!isVisible()) {
			setVisible(true);
	        refreshBuchungenAction();
		}
        toFront();
        txtMuster.requestFocus();
    }

    private void showKalenderAction() {
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_KALENDER,true,new MessageItem(MessageItem.MSG_SHOW_KALENDER,0,null,this));
    }
    
    
    @Override
	public void closeWindow(){
        rz.getOptionFactory().setOption("client_auftragsliste.timer", ((Integer)this.splAuftragsliste.getValue()).intValue());
        rz.getOptionFactory().setOption("client_anfragenliste.timer", ((Integer)this.splAnfragenliste.getValue()).intValue());
        rz.getOptionFactory().setOption("clientauswahl.tab1_state",auftragAnfragenTab.getSelectedIndex());
        rz.getOptionFactory().saveOptions();
		saveComponentProperties();
        saveDividerLocations();
		rz.sysMessage(new MessageItem(MessageItem.MSG_QUIT,0,null,this));
    }

    //Extras-Menü
    private void hideAction(){
        rz.getFensterFactory().getFensterListe().sperren(this);
    }

    //hilfe
    private void hilfeAction(){
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"clientauswahl.html",this));
    }

    private void aboutAction(){
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_ABOUT,true,new MessageItem(MessageItem.MSG_SHOW_ABOUT,0,null,this));
    }
    
    
    private void settblAuftragslisteModel(final JTable t) {
	    final AuftragslistenColumnModel rcm = new AuftragslistenColumnModel();
	    final AuftragslisteStringRenderer sr = new AuftragslisteStringRenderer();
	    
	    TableColumn tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("auswahl.tableheader_al_menge"));
	    	tc.setModelIndex(AL_C_MENGE);
	    	tc.setCellRenderer(sr);
	    rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("auswahl.tableheader_al_bezeichnung"));
			tc.setModelIndex(AL_C_BEZEICHNUNG);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
	    
        rcm.addColumnModelListener(this);
        t.setModel(new auftragslisteTableModel());
        t.setColumnModel(rcm);
        t.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
        t.getTableHeader().setReorderingAllowed(false);
        t.setFont(rz.getFontFactory().getAuftragsTableFont());
        rz.setPreferredRowHeights(t);
        TableModelListener l = new TableModelListener() {
			public void tableChanged(TableModelEvent e) {
		         SwingUtilities.invokeLater(new Runnable() {
		              public void run() {
		                  rz.setPreferredRowHeights(t);
		              }
		         });
			}
	     }; 
		 t.getModel().addTableModelListener(l);
	}
    
	private class AuftragslistenColumnModel extends DefaultTableColumnModel{
	    public AuftragslistenColumnModel() {
	        super();
	    }
	}
	
	
	private  class auftragslisteTableModel extends AbstractTableModel    {

    	
        SimpleDateFormat df;

        public auftragslisteTableModel() {
        	super();
        }

	   public int getColumnCount() {
	       	return  AL_MAX_COLUMNS;
        }
        public int getRowCount() {
        	if(auftragsliste != null) {
                return auftragsliste.size();
        	} else {
        		return 0;
        	}
        }

        public AuftragsItem getZeileAt(int rowIndex) {
        	if((rowIndex != -1) && (auftragsliste != null)) {
        		return auftragsliste.getItem(rowIndex);
        	} else {
				return null;
			}
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            Object ret = null;
            if((rowIndex != -1) && (auftragsliste != null)) {
                ret = getContent(auftragsliste.getItem(rowIndex),columnIndex,rowIndex);
            }
            return ret;
        }

        private Object getContent(AuftragsItem ai,int aColumn,int row) {
            Object ret = null;
            if(ai != null) {
	            switch(aColumn){
	            	 case AL_C_BEZEICHNUNG:
	            	     ret = "<html><b>" + ai.getBezeichnung() + "</b><br>" +ai.getFaelligToString() +"<br>" + (rz.getDatabase().getAuftrag().getAuftragsConfig().getColors(ai,0)[2]) + "</html>";
	            		 break;
	            	 case AL_C_MENGE:
		            	 	ret="<html>" + rz.getLocale().formatNumber(ai.getLiter(), OptionFactory.NF_ONE) + "<br>"  + (ai.getArbeit_user().trim().equals("")?"":"("+ai.getArbeit_user()+")"); 
	            	 	break;
	            }
            }
            return ret;
        }
	}

	
    private void settblAnfragenlisteModel(final JTable t) {
	    final AnfragenlistenColumnModel rcm = new AnfragenlistenColumnModel();
	    final AnfragenlisteStringRenderer sr = new AnfragenlisteStringRenderer();
	    
	    TableColumn tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("auswahl.tableheader_an_menge"));
	    	tc.setModelIndex(AL_C_MENGE);
	    	tc.setCellRenderer(sr);
	    rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("auswahl.tableheader_an_bezeichnung"));
			tc.setModelIndex(AL_C_BEZEICHNUNG);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
        rcm.addColumnModelListener(this);
        t.setModel(new anfragenlisteTableModel());
        t.setColumnModel(rcm);
        t.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
        t.getTableHeader().setReorderingAllowed(false);
        t.setFont(rz.getFontFactory().getAuftragsTableFont());
        rz.setPreferredRowHeights(t);
        TableModelListener l = new TableModelListener() {
			public void tableChanged(TableModelEvent e) {
		         SwingUtilities.invokeLater(new Runnable() {
		              public void run() {
		                  rz.setPreferredRowHeights(t);
		              }
		         });
			}
	     }; 
		 t.getModel().addTableModelListener(l);
	}
    
	private class AnfragenlistenColumnModel extends DefaultTableColumnModel{
	    public AnfragenlistenColumnModel() {
	        super();
	    }
	}
	
	
	private  class anfragenlisteTableModel extends AbstractTableModel    {

    	
        SimpleDateFormat df;

        public anfragenlisteTableModel() {
        	super();
        }

	   public int getColumnCount() {
	       	return  AL_MAX_COLUMNS;
        }
        public int getRowCount() {
        	if(anfragenliste != null) {
                return anfragenliste.size();
        	} else {
        		return 0;
        	}
        }

        public AuftragsItem getZeileAt(int rowIndex) {
        	if((rowIndex != -1) && (anfragenliste != null)) {
        		return anfragenliste.getItem(rowIndex);
        	} else {
				return null;
			}
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            Object ret = null;
            if((rowIndex != -1) && (anfragenliste != null)) {
                ret = getContent(anfragenliste.getItem(rowIndex),columnIndex,rowIndex);
            }
            return ret;
        }

        private Object getContent(AuftragsItem ai,int aColumn,int row) {
            Object ret = null;
            if(ai != null) {
	            switch(aColumn){
	            	 case AL_C_BEZEICHNUNG:
	            		 if(ai.isFertig()) {
	            			 ret = "<html><b>" + ai.getBezeichnung() + "</b><br>" +ai.getFertigToString() +"<br>" + (rz.getDatabase().getAuftrag().getAuftragsConfig().getColors(ai,0)[2]) + "</html>";
	            		 } else {
	            			 ret = "<html><b>" + ai.getBezeichnung() + "</b><br>" +ai.getFaelligToString() +"<br>" + (rz.getDatabase().getAuftrag().getAuftragsConfig().getColors(ai,0)[2]) + "</html>";
	            		 }
	            	     break;
	            	 case AL_C_MENGE:
	            	 	ret="<html>" + rz.getLocale().formatNumber(ai.getLiter(), OptionFactory.NF_ONE) + "<br>"  + (ai.getErstellt_user().trim().equals("")?"":"("+ai.getErstellt_user()+")"); 
	            	 	break;
	            }
            }
            return ret;
        }
	}
	
	
	
	private class AnfragenlisteStringRenderer extends DefaultTableCellRenderer {

		Icon				eigen;
	    AnfragenlisteStringRenderer() {
	        super();
            eigen = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/auswahl.icon_auftrag_eigen.png"));
	        setOpaque(true);
	    }
	    public Component getTableCellRendererComponent(JTable table,
                Object value, boolean isSelected, boolean hasFocus, int row,
                int column)
	    {
	    	AuftragsItem ai = anfragenliste.getItem(row);
	    	setIcon(null);
	    	setFont(rz.getFontFactory().getAuftragsTableFont());
	    	if(ai != null) {
	    		setForeground(rz.getOptionFactory().getRGBColorString(ai.getVg()));
	    		setBackground(rz.getOptionFactory().getRGBColorString(ai.getHg()));
	    		if(column == AL_C_MENGE && ai.isEigen()) {
	    			setIcon(eigen);
	    		}
		   	}
	    	setText((String)value);
	        setHorizontalAlignment(SwingConstants.LEADING);
	        return this;
        }
	}
	
	private class AuftragslisteStringRenderer extends DefaultTableCellRenderer {

		Icon				eigen,inarbeit,eigen_inarbeit;
	    AuftragslisteStringRenderer() {
	        super();
            eigen = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/auswahl.icon_auftrag_eigen.png"));
            inarbeit = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/auswahl.icon_auftrag_inarbeit.png"));
            eigen_inarbeit = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/auswahl.icon_auftrag_eigen_inarbeit.png"));
	        setOpaque(true);
	    }
	    public Component getTableCellRendererComponent(JTable table,
                Object value, boolean isSelected, boolean hasFocus, int row,
                int column)
	    {
	    	AuftragsItem ai = auftragsliste.getItem(row);
	    	setIcon(null);
	    	setFont(rz.getFontFactory().getAuftragsTableFont());
	    	if(ai != null) {
	    		setForeground(rz.getOptionFactory().getRGBColorString(ai.getVg()));
	    		setBackground(rz.getOptionFactory().getRGBColorString(ai.getHg()));
	    		if(column == AL_C_MENGE) {
	    			if(ai.isEigen() && ai.isInarbeit()) {
	    				setIcon(eigen_inarbeit);
	    			} else if(ai.isEigen()) {
	    				setIcon(eigen);
	    			} else if(ai.isInarbeit()) {
	    				setIcon(inarbeit);
	    			}
	    		}
		   	}
	    	setText((String)value);
	        setHorizontalAlignment(SwingConstants.LEADING);
	        return this;
        }
	}
    
    
    
    /*------------------------------------------------------------------------
     * ListenRenderer
     *
     *------------------------------------------------------------------------
     */
    private final class ErgebnisListRenderer extends JLabel implements ListCellRenderer{
        RzPro   rz;
        public ErgebnisListRenderer(RzPro r){
            rz = r;
            setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list,Object value,int index, boolean isSelected,boolean cellHasFocus){
            final ErgebnisItem ei = (ErgebnisItem)value;
            this.setFont(rz.getFontFactory().getListFont());
            setText(ei.toString());
            switch (ei.getTyp()) {
            	case RzPro.TYP_ID_NOTIZ:
                    setIcon(rz.getOptionFactory().getIcon(OptionFactory.LIST_ERGEBNIS_ICON_NOTIZ_CLASSPATH));
            		break;
            	case RzPro.TYP_ID_REZEPT :
                    setIcon(rz.getOptionFactory().getIcon(OptionFactory.LIST_ERGEBNIS_ICON_REZEPTUR_CLASSPATH));
            		break;
            	case RzPro.TYP_ID_VERWEIS:
                    setIcon(rz.getOptionFactory().getIcon(OptionFactory.LIST_ERGEBNIS_ICON_VERWEIS_CLASSPATH));
            	break;
            }
            if(isSelected){
                setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_SELECTED));
                setForeground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_FOREGROUND_SELECTED));
            }else {
                setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_NORMAL));
                setForeground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_FOREGROUND_NORMAL));
            }
            return this;
        }
    }
	public void columnAdded(TableColumnModelEvent e) {
	}
	public void columnMarginChanged(ChangeEvent e) {
	}
	public void columnMoved(TableColumnModelEvent e) {
	}
	public void columnRemoved(TableColumnModelEvent e) {
	}
	public void columnSelectionChanged(ListSelectionEvent e) {
	}
	
    private void settblErgebnisModel(JTable t) {
	    final ErgebnisColumnModel rcm = new ErgebnisColumnModel();
	    final StringRenderer sr = new StringRenderer();
	    final IconRenderer ir = new IconRenderer();
	    TableColumn tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("auswahl.tableheader_ce_icon"));
	    	tc.setModelIndex(CE_ICON);
	    	tc.setCellRenderer(ir);
	    rcm.addColumn(tc);
	    tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("auswahl.tableheader_ce_bezeichnung"));
	    	tc.setModelIndex(CE_BEZEICHNUNG);
	    	tc.setCellRenderer(sr);
	    rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("auswahl.tableheader_ce_datum"));
			tc.setModelIndex(CE_DATUM);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("auswahl.tableheader_ce_stichworte"));
			tc.setModelIndex(CE_STICHWORTE);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("auswahl.tableheader_ce_fuellstand"));
			tc.setModelIndex(CE_FUELLSTAND);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
        rcm.addColumnModelListener(this);
        tblErgebnis.setModel(new ergebnisTableModel());
        tblErgebnis.setColumnModel(rcm);
        tblErgebnis.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
        tblErgebnis.getTableHeader().setReorderingAllowed(false);
	}

	private class ErgebnisColumnModel extends DefaultTableColumnModel{
	    public ErgebnisColumnModel() {
	        super();
	    }

	}
    
	private  class ergebnisTableModel extends AbstractTableModel    {

    	Icon						rezeptur;
    	Icon						notiz;
    	Icon						verweis;
    	Icon						ausstattung;
        SimpleDateFormat df;

        public ergebnisTableModel() {
        	try {
            rezeptur = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/rezeptur.png"));
            notiz = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/notiz.png"));
            verweis = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/verweis.png"));
            ausstattung = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/ausstattung.png"));
        	}catch (Exception e) {
        	}
            df = new SimpleDateFormat("dd.MM.yyyy");
        }

	   public int getColumnCount() {
	       	return CE_MAX;
        }
        public int getRowCount() {
        	if(ergebnisse != null) {
                return ergebnisse.size();
        	} else {
        		return 0;
        	}
        }

        public ErgebnisItem getZeileAt(int rowIndex) {
        	if((rowIndex != -1) && (ergebnisse != null)) {
        		return ergebnisse.getItem(rowIndex);
        	} else {
				return null;
			}
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            Object ret = null;
            if((rowIndex != -1) && (ergebnisse != null)) {
                ret = getContent(ergebnisse.getItem(rowIndex),columnIndex,rowIndex);
            }
            return ret;
        }

        private Object getContent(ErgebnisItem ei,int aColumn,int row) {
            Object ret = null;
            if(ei != null) {
	            switch(aColumn){
	            	case CE_ICON:
	            		switch(ei.getTyp()) {
	            			case RzPro.TYP_ID_AUSSTATTUNG: ret=ausstattung;break;
	            			case RzPro.TYP_ID_VERWEIS: ret=verweis;break;
	            			case RzPro.TYP_ID_REZEPT: ret=rezeptur;break;
	            			case RzPro.TYP_ID_NOTIZ: ret=notiz;break;
	            		}
	            		break;
	            	 case CE_BEZEICHNUNG:
	            	     ret = ei.getBezeichnung();
	            	     break;
	            	 case CE_DATUM:
	            		 ret=ei.getDatum();
	            		 break;
	            	 case CE_STICHWORTE:
	            	 	ret= ei.getStichwortString();
	            	 	break;
	            	 case CE_FUELLSTAND:
	            		 ret=ei.getFuellstand();
	            		 break;
	            }
            }
            return ret;
        }
	}

	
	
	
	private class StringRenderer extends DefaultTableCellRenderer {

	    StringRenderer() {
	        super();
	        setOpaque(true);
	    }
	    public Component getTableCellRendererComponent(JTable table,
                Object value, boolean isSelected, boolean hasFocus, int row,
                int column)
	    {
	    	setFont(rz.getFontFactory().getTableFont());
    		if(isSelected) {
    			setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_SELECTED));
    		}else {
    			setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_NORMAL));
    		}
	        if(value != null) {
	        	setText(value.toString());
	         } else {
				setText("");
			}
	        setHorizontalAlignment(SwingConstants.LEADING);
	        return this;
        }
	}

	/** rendert alle Tabellenzeilen mit icon Inhalt
	 *  im wesentlichen heisst das rechts-ausgerichtent
	 * @author lunqual
	 */
	private class IconRenderer extends DefaultTableCellRenderer {

	    IconRenderer() {
	        super();

	        setOpaque(true);
	    }
	    public Component getTableCellRendererComponent(JTable table,
                Object value, boolean isSelected, boolean hasFocus, int row,
                int column)
	    {
	    	setFont(rz.getFontFactory().getTableFont());
    		if(isSelected) {
    			setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_SELECTED));
    		}else {
    			setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_NORMAL));
    		}
	    	if((row != -1) && (ergebnisse != null)) {
		        if(value != null) {
		            setText("");
		            setIcon((Icon)value);
	        }
	    }
	    return this;
	    }
	
	}
}
	

