/*
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */


package de.lunqual.rzpro.fenster.auswahlfenster;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;

import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.ausgabe.ReportFactory;
import de.lunqual.rzpro.database.DBAbfrage;
import de.lunqual.rzpro.database.DBAuftrag;
import de.lunqual.rzpro.database.ItemNotFoundException;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fenster.JRzLabel;
import de.lunqual.rzpro.fenster.JRzList;
import de.lunqual.rzpro.fenster.JSelectedTextArea;
import de.lunqual.rzpro.fenster.JSelectedTextField;
import de.lunqual.rzpro.fenster.ZutatenDialog;
import de.lunqual.rzpro.fenster.buchungsfenster.StatistikFenster;
import de.lunqual.rzpro.fenster.dialoge.DialogControl;
import de.lunqual.rzpro.fenster.dialoge.DruckFormularDialog;
import de.lunqual.rzpro.fenster.dialoge.EingabeDialog;
import de.lunqual.rzpro.fenster.dialoge.MhdDialog;
import de.lunqual.rzpro.fenster.dialoge.StichtagDialog;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.abfrage.AbfrageItem;
import de.lunqual.rzpro.items.abfrage.AbfrageListe;
import de.lunqual.rzpro.items.acid.AcidAnzeigeItem;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.action.priorityAction;
import de.lunqual.rzpro.items.auftrag.AuftragsItem;
import de.lunqual.rzpro.items.auftrag.Auftragsliste;
import de.lunqual.rzpro.items.bewertungen.BewertungsItem;
import de.lunqual.rzpro.items.buchung.BuchungsItem;
import de.lunqual.rzpro.items.currency.CurrencyItem;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.items.ergebnis.DependencyListe;
import de.lunqual.rzpro.items.ergebnis.ErgebnisItem;
import de.lunqual.rzpro.items.ergebnis.ErgebnisListe;
import de.lunqual.rzpro.items.ergebnis.IDItem;
import de.lunqual.rzpro.items.etiketten.EtikettenItem;
import de.lunqual.rzpro.items.etiketten.EtikettenListe;
import de.lunqual.rzpro.items.fenster.FensterItem;
import de.lunqual.rzpro.items.kalender.TerminListe;
import de.lunqual.rzpro.items.kontrakt.kontraktItem;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.mhd.mhdDialogItem;
import de.lunqual.rzpro.items.rechnen.RechenItem;
import de.lunqual.rzpro.items.report.ReportItem;
import de.lunqual.rzpro.items.rezeptur.AusstattungsItem;
import de.lunqual.rzpro.items.rezeptur.BestandswarnungsListe;
import de.lunqual.rzpro.items.rezeptur.RezepturItem;
import de.lunqual.rzpro.items.rezeptur.SPFormblattItem;
import de.lunqual.rzpro.items.rezeptur.ZutatenSuchItem;
import de.lunqual.rzpro.items.stichworte.StichwortItem;
import de.lunqual.rzpro.items.stichworte.StichwortListe;
import de.lunqual.rzpro.items.tafel.TafelItem;
import de.lunqual.rzpro.items.tank.tankAuswahlItem;
import de.lunqual.rzpro.items.tank.tankItem;
import de.lunqual.rzpro.items.zutatenverzeichnis.ZutatenverzeichnisListe;
import de.lunqual.rzpro.log.LogFactory;
import de.lunqual.rzpro.options.OptionFactory;

/**
 *
 * @author  lunqual
 */
public class Auswahl extends JRzFrame implements TableColumnModelListener {

	// GUI -VARIABLEN
    private JMenuBar mb;
    private JMenu mnuAbfragen;
    private JMenu mnuBearbeiten;
    private JMenu mnuDatei;
    private JMenu mnuBuchung;
    private JMenu mnuExtras;
    private JMenu mnuFenster;
    private JMenu mnuHilfe;
    private JMenu mnuNavigation;
    private JMenu mnuNeu;
	JPopupMenu mnuContextAuftrag;
	JPopupMenu mnuContextArbeitsAuftrag;
	
	JPopupMenu mnuContextAuftragNoDelete;
	JPopupMenu mnuContextArbeitsAuftragNoDelete;
	
	JMenu mnuPriorityA;
	JMenu mnuPriorityAN;
	JMenu mnuPriorityAA;
	JMenu mnuPriorityAAN;	
	
    private JToolBar tb1;
	private JToolBar tb2;
	private JToolBar tb3;
	private JPanel mainPanel;
		private JPanel toolbarPanel;
		private JPanel centerPanel;
			private JPanel terminPanel;
				private JPanel terminTimeoutPanel;
				private JLabel lblTimeout;
				private JLabel lblTermine;
				private JLabel lblAnfragen;
    		private JSplitPane splHorizontal;
    			private JTabbedPane auftragBestandswarnungsTab;
    				private JPanel auftragslistenPanel;
    					private JPanel auftragslistenTitelPanel;
    						private JLabel lblAuftragslisteTitel;
    						private JSelectedTextField txtAuftragSucheField;
    						private JPanel auftragSucheButtonPanel;
    							private JButton btAuftragSucheButton;
    							private JButton btAuftragSucheClearButton;
    						private JPanel auftragsListeTblPanel;
		    					private JScrollPane scrAuftragsliste;
		    						private JTable tblAuftragsliste;
		    					private JPanel auftragsZutatenPanel;
		    						private JButton btZutatenliste;
    					private JPanel auftragsButtonPanel;
    						private JPanel auftragsButtonObenPanel;
    							private JButton btAuftragslisteRefresh;
    							private JButton btAuftragslisteDrucken;
    							private JButton btAuftragslisteBearbeiten;
    							private JButton btAuftragslisteEigeneDrucken;
		    		 		private JPanel auftragsButtonPanelUnten;
			    		 		private JLabel lblAuftragsliste_text1;
			    		 		private JSpinner splAuftragsliste;
			    		 		private JLabel lblAuftragsliste_text2;
	    				
	    			private JPanel anfragenlistenPanel;
    					private JLabel lblanfragenlisteTitel;
    					private JScrollPane scrAnfragenliste;
    						private JTable tblAnfragenliste;
    					private JPanel anfragenButtonPanel;
    						private JPanel anfragenButtonObenPanel;
    							private JButton btAnfragenlisteRefresh;
    							private JButton btAnfragenlisteDrucken;
    							private JButton btAnfragenlisteBearbeiten;
		    		 		private JPanel anfragenButtonPanelUnten;
			    		 		private JLabel lblanfragenliste_text1;
			    		 		private JSpinner splAnfragenliste;
			    		 		private JLabel lblanfragenliste_text2;
			    		 		
			    		 		
			    		 private JPanel leftBestandswarnungsPanel;
			    		 	private JLabel lblBestandswarnung;
			    		 	private JScrollPane scrBestandswarnung;
			    		 		private JEditorPane txtBestandswarnung;

			    		 	private JPanel bestandsWarnungButtonPanel;
			    		 		private JPanel bestandsWarnungStichwortPanel;
			    		 			private JLabel lblBestandsWarnungStichwort;
			    		 			private JLabel lblBestandsWarnungStichwortListe;
			    		 			private JPanel bestandsWarnungStichwortButtonPanel;
			    		 				private JButton btBestandsWarnungStichwortAuswahl;
			    		 				private JButton btBestandsWarnungStichwortClear;
				    		 	private JPanel bestandsWarnungButtonPanelOben;
				    		 		private JPanel bestandsWarnungZutatenPanel;
			    		 				private JCheckBox chkBestandZutaten;
			    		 			private JPanel bestandsWarnungBuchungenPanel;
			    		 				private JCheckBox chkBestandBuchungen;
			    		 				private JLabel lblBestandBuchungen;
			    		 			private JPanel bestandsWarnungsActionPanel;
			    		 				private JButton btBestandsWarnungDrucken;
			    		 				private JButton btBestandsWarnungUebertragen;
			    		 		private JPanel bestandsWarnungButtonPanelUnten;
					    		 	private JButton btBestandswarnung;
					    		 		private JLabel lblBestandswarnung_text1;
					    		 		private JSpinner splBestandswarnung;
					    		 		private JLabel lblBestandswarnung_text2;


	    			private JPanel rightPanel;
    			    	private JPanel rightContainerPanel;
		    				private JPanel abfragenAllesPanel;
		    			    		private JPanel abfragePanel;
			    			    		private JPanel abfrageListenPanel;
											private JPanel abfrageListePanel;
						    					private JPanel alpTop;
						    						private JLabel lblAbfragelisteTitel;
						    						private JScrollPane lstAbfragenScrollPane;
						    							private JRzList lstAbfragen;
							    				    private JPanel alpCenter;
							    					private JPanel alpSouth;
							    				    	private JButton btUse;
							    				    	private JButton btGo;
							    				    	private JButton btRefresh;
							    				    	private JButton btRemove;
							    				    	private JButton btPrivate;
							    				    	private JButton btPublic;
							    	private JPanel adressenStichwortePanel;
										private JPanel adressenAuswahlPanel;
											private JPanel adressenAuswahlTitelPanel;
												private JLabel lblAdressenTitel;
											private JPanel adressebAuswahlLabelPanel;
												private JScrollPane adressenScrollPane;
													private JRzLabel lblRzAdressen;
											private JPanel adressenAuswahlButtonPanel;
												private JButton btAdressenBearbeiten;
												private JButton btAdressenLoeschen;
												private JPanel adressenMode;
													private ButtonGroup adressenGroup;
												    	private JRadioButton btAdressenModeAnd;
												    	private JRadioButton btAdressenModeOr;
			
				    					private JPanel stichwortAuswahlPanel;
				    						private JPanel stichwortAuswahlTitelPanel;
												private JLabel lblStichworteTitel;
											private JPanel stichwortAuswahlLabelPanel;
												private JScrollPane stichworteScrollPane;
												private JRzLabel lblRzStichworte;
										    private JPanel stichwortAuswahlButtonPanel;
												private JButton btStichworteBearbeiten;
												private JButton btStichworteLoeschen;
												private JPanel stichworteMode;
														private ButtonGroup stichworteGroup;
															private JRadioButton btStichworteModeAnd;
															private JRadioButton btStichworteModeOr;
				    					private JPanel abfrageTextPanel;
					    						private JPanel musterPanel;
					    							private JComboBox cmbAbfrageModus;
					    							private JPanel txtMusterPanel;
					    								private JSelectedTextArea txtMuster;
					    								private JButton btMusterSuchen;
					    							private JCheckBox chkAblage;
					    							private JComboBox cmbSort;
				    						private JPanel abfrageButtonPanel;
					    					    private JButton btExecuteQuery;
					    					    private JButton btNeu;
					    					    private JButton btSave;
									    		private JButton btErweitert;
											
			    				private JSplitPane splVertical;
			    					private JSplitPane splVertical2;
					    				private JPanel ergebnisListePanel;
											private JPanel elTop;
												private JLabel lblErgebnisTitel;
											private JPanel elCenter;
												private JScrollPane scrErgebnis;
													private JTable tblErgebnis;
											    private JLabel lblErgebnisCount;
											private JPanel elSouth;
										private JPanel ergebnisPanel;
											private JPanel eTop;
												private JPanel eNorth;
													private JLabel lblHistory;
													private JScrollPane scrHistory;
														private JEditorPane txtHistory;
													private JButton btDeleteHistory;
													private JPanel eNorthNavigation;
														private JButton btAnfang;
														private JButton btZurueck;
														private JLabel lblPosition;
														private JButton btVor;
														private JButton btEnde;
										private JPanel eCenter;
											private JScrollPane ausgabeScrollPane;
												private JEditorPane txtErgebnis;
										private JPanel eSouth;
												private JButton btVerbrauch;
												private JButton btVerbrauchListe;
												private JButton btDrucken;	
												private JPanel listenDruckPanel;
													private JComboBox cmbListendruck;
													private JCheckBox chkListendruckBestandOnly;
													private JCheckBox chkDuplex;
													private JButton btListendruck;


    // ActionCodes
	public static final int         ACTION_PLUGIN_CODE=900;

    public static final int         ACTION_QUIT_CODE  = 1000;
    public static final String     ACTION_QUIT_TEXT = "auswahl.action_quit";
    public static final int         ACTION_ABFRAGE_AUSFUEHREN_CODE = 1001;
    public static final String     ACTION_ABFRAGE_AUSFUEHREN_TEXT = "auswahl.action_abfrage_ausfuehren";
    public static final int         ACTION_ADRESSFENSTER_CODE  = 1002;
    public static final String     ACTION_ADRESSFENSTER_TEXT = "auswahl.action_adressfenster";
    public static final int         ACTION_REPORTFENSTER_CODE  = 1003;
    public static final String     ACTION_REPORTFENSTER_TEXT = "auswahl.action_reportfenster";
    public static final int         ACTION_EINSTELLUNGSFENSTER_CODE  = 1004;
    public static final String     ACTION_EINSTELLUNGSFENSTER_TEXT = "auswahl.action_einstellungsfenster";
    public static final int         ACTION_NEUE_NOTIZ_CODE  = 1005;
    public static final String     ACTION_NEUE_NOTIZ_TEXT = "auswahl.action_neue_notiz";
    public static final int         ACTION_ABFRAGE_NEU_CODE  = 1006;
    public static final String     ACTION_ABFRAGE_NEU_TEXT = "auswahl.action_abfrage_neu";
    public static final int         ACTION_ABFRAGE_ADRESSEN_CODE  = 1007;
    public static final String     ACTION_ABFRAGE_ADRESSEN_TEXT = "auswahl.action_abfrage_adressen";
    public static final int         ACTION_ABFRAGE_STICHWORTE_CODE  = 1008;
    public static final String     ACTION_ABFRAGE_STICHWORTE_TEXT = "auswahl.action_abfrage_stichworte";
    public static final int         ACTION_ABFRAGE_ADRESSEN_LOESCHEN_CODE  = 1009;
    public static final String     ACTION_ABFRAGE_ADRESSEN_LOESCHEN_TEXT = "auswahl.action_abfrage_adressen_loeschen";
    public static final int         ACTION_ABFRAGE_STICHWORTE_LOESCHEN_CODE  = 1010;
    public static final String     ACTION_ABFRAGE_STICHWORTE_LOESCHEN_TEXT = "auswahl.action_abfrage_stichworte_loeschen";
    public static final int         ACTION_ABFRAGE_REFRESH_CODE  = 1015;
    public static final String     ACTION_ABFRAGE_REFRESH_TEXT = "auswahl.action_abfrage_refresh";
    public static final int         ACTION_ABFRAGE_SPEICHERN_CODE  = 1016;
    public static final String     ACTION_ABFRAGE_SPEICHERN_TEXT = "auswahl.action_abfrage_speichern";
    public static final int         ACTION_ABFRAGE_USE_CODE  = 1017;
    public static final String     ACTION_ABFRAGE_USE_TEXT = "auswahl.action_abfrage_use";
    public static final int         ACTION_ABFRAGE_GO_CODE  = 1018;
    public static final String     ACTION_ABFRAGE_GO_TEXT = "auswahl.action_abfrage_go";
    public static final int         ACTION_ABFRAGE_LOESCHEN_CODE  = 1019;
    public static final String     ACTION_ABFRAGE_LOESCHEN_TEXT = "auswahl.action_abfrage_loeschen";
    public static final int         ACTION_ABFRAGE_SORT_CODE  = 1020;
    public static final String     ACTION_ABFRAGE_SORT_TEXT = "auswahl.action_abfrage_sort";
    public static final int         ACTION_NAVIGATION_SAVED_CODE  = 1021;
    public static final String     ACTION_NAVIGATION_SAVED_TEXT = "auswahl.action_navigation_saved";
    public static final int         ACTION_NAVIGATION_MUSTER_CODE  = 1022;
    public static final String     ACTION_NAVIGATION_MUSTER_TEXT = "auswahl.action_navigation_muster";
    public static final int         ACTION_NAVIGATION_ERGEBNIS_CODE  = 1023;
    public static final String     ACTION_NAVIGATION_ERGEBNIS_TEXT = "auswahl.action_navigation_ergebnis";
    public static final int         ACTION_DRUCKEN_CODE  = 1024;
    public static final String     ACTION_DRUCKEN_TEXT = "auswahl.action_drucken";
    public static final int         ACTION_BEARBEITEN_CODE  = 1025;
    public static final String     ACTION_BEARBEITEN_TEXT = "auswahl.action_bearbeiten";
    public static final int         ACTION_LOESCHEN_CODE  = 1026;
    public static final String     ACTION_LOESCHEN_TEXT = "auswahl.action_loeschen";
    public static final int         ACTION_KALKULATION_CODE  = 1027;
    public static final String     ACTION_KALKULATION_TEXT = "auswahl.action_kalkulation";
    public static final int         ACTION_LAGER_CODE  = 1028;
    public static final String     ACTION_LAGER_TEXT = "auswahl.action_lagerfenster";
    public static final int         ACTION_NEUE_REZEPTUR_CODE  = 1029;
    public static final String     ACTION_NEUE_REZEPTUR_TEXT = "auswahl.action_neue_rezeptur";
    public static final int         ACTION_VERWENDUNG_CODE = 1030;
    public static final String     ACTION_VERWENDUNG_TEXT = "auswahl.action_verwendung";
    public static final int         ACTION_UND_GRUPPE_CODE = 1031;
    public static final String     ACTION_UND_GRUPPE_TEXT = "auswahl.action_und_gruppe";
    public static final int         ACTION_ODER_GRUPPE_CODE = 1032;
    public static final String     ACTION_ODER_GRUPPE_TEXT = "auswahl.action_oder_gruppe";
    public static final int         ACTION_ADRESSEN_GRUPPE_CODE = 1033;
    public static final String     ACTION_ADRESSEN_GRUPPE_TEXT = "auswahl.action_adressen_alle";
    public static final int         ACTION_NEUE_REZEPTUR_GRUPPE_CODE  = 1034;
    public static final String     ACTION_NEUE_REZEPTUR_GRUPPE_TEXT = "auswahl.action_neue_rezeptur_gruppe";
    public static final int         ACTION_NEUE_NOTIZ_GRUPPE_CODE  = 1035;
    public static final String     ACTION_NEUE_NOTIZ_GRUPPE_TEXT = "auswahl.action_neue_notiz_gruppe";
    public static final int         ACTION_DUPLICATE_CODE  = 1036;
    public static final String     ACTION_DUPLICATE_TEXT = "auswahl.action_duplicate";
    public static final int         ACTION_CALC_CODE  = 1037;
    public static final String     ACTION_CALC_TEXT = "auswahl.action_rechnen";
    public static final int         ACTION_HILFE_CODE  = 1038;
    public static final String     ACTION_HILFE_TEXT = "action_hilfe";
    public static final int         ACTION_HIDE_CODE  = 1039;
    public static final String     ACTION_HIDE_TEXT = "action_hide";
    public static final int         ACTION_ZUTATEN_CODE  = 1040;
    public static final String     ACTION_ZUTATEN_TEXT = "auswahl.action_zutaten";
    public static final int         ACTION_AUFSTAERKEN_CODE  = 1041;
    public static final String     ACTION_AUFSTAERKEN_TEXT = "auswahl.action_aufstaerken";
    public static final int         ACTION_HERABSETZEN_CODE  = 1042;
    public static final String     ACTION_HERABSETZEN_TEXT = "auswahl.action_herabsetzen";
    public static final int         ACTION_LIEFERSCHEIN_LISTE_CODE  = 1043;
    public static final String     ACTION_LIEFERSCHEIN_LISTE_TEXT = "auswahl.action_lieferscheinliste";
    public static final int         ACTION_LIEFERSCHEIN_CODE  = 1044;
    public static final String     ACTION_LIEFERSCHEIN_TEXT = "auswahl.action_lieferschein";
    public static final int         ACTION_BEHAELTER_CODE  = 1045;
    public static final String     ACTION_BEHAELTER_TEXT = "auswahl.action_container";
    public static final int         ACTION_ETIKETTEN_CODE  = 1046;
    public static final String     ACTION_ETIKETTEN_TEXT = "auswahl.action_etiketten";
    public static final int         ACTION_TAFEL_CODE  = 1047;
    public static final String     ACTION_TAFEL_TEXT = "auswahl.action_tafel";
    public static final int         ACTION_ZUGANG_CODE  = 1048;
    public static final String     ACTION_ZUGANG_TEXT = "auswahl.action_zugang";
    public static final int         ACTION_ABGANG_CODE  = 1049;
    public static final String     ACTION_ABGANG_TEXT = "auswahl.action_abgang";
    public static final int         ACTION_STATISTIK_EINZELN_CODE  = 1050;
    public static final String     ACTION_STATISTIK_EINZELN_TEXT = "auswahl.action_statistik_einzeln";
    public static final int         ACTION_STATISTIK_GRUPPE_CODE  = 1051;
    public static final String     ACTION_STATISTIK_GRUPPE_TEXT = "auswahl.action_statistik_gruppe";
    public static final int         ACTION_HERSTELLFENSTER_CODE  = 1052;
    public static final String     ACTION_HERSTELLFENSTER_TEXT = "auswahl.action_herstellfenster";
    public static final int         ACTION_VERLAUF_CODE  = 1053;
    public static final String     ACTION_VERLAUF_TEXT = "auswahl.action_verlauf";
    public static final int         ACTION_ABOUT_CODE  = 1054;
    public static final String     ACTION_ABOUT_TEXT = "auswahl.action_about";
    public static final int         ACTION_STATISTIK_BESTAND_CODE  = 1055;
    public static final String     ACTION_STATISTIK_BESTAND_TEXT = "auswahl.action_statistik_bestand";
    public static final int         ACTION_STATISTIK_BESTAND_GRUPPE_CODE  = 1056;
    public static final String     ACTION_STATISTIK_BESTAND_GRUPPE_TEXT = "auswahl.action_statistik_bestand_gruppe";
    public static final int         ACTION_LOGGING_CODE  = 1057;
    public static final String     ACTION_LOGGING_TEXT = "auswahl.action_logging";
    public static final int         ACTION_ADRESSEN_CODE = 1058;
    public static final String     ACTION_ADRESSEN_TEXT = "auswahl.action_adressen_einzeln";
    public static final int         ACTION_AUSBEUTE_CODE = 1059;
    public static final String     ACTION_AUSBEUTE_TEXT = "auswahl.action_ausbeute";
    public static final int         ACTION_HINWEIS_CODE = 1060;
    public static final String     ACTION_HINWEIS_TEXT = "auswahl.action_hinweis";
    public static final int         ACTION_AUTOCALC_CODE = 1061;
    public static final String     ACTION_AUTOCALC_TEXT = "auswahl.action_autocalc";
    public static final int         ACTION_AUTOCALC_SINGLE_CODE = 1062;
    public static final String     ACTION_AUTOCALC_SINGLE_TEXT = "auswahl.action_autocalc_single";
    public static final int         ACTION_REZEPTUR_DRUCKEN_CODE = 1063;
    public static final String     ACTION_REZEPTUR_DRUCKEN_TEXT = "auswahl.action_rezeptur_drucken";
    public static final int         ACTION_KALKULATION_DRUCKEN_CODE = 1064;
    public static final String     ACTION_KALKULATION_DRUCKEN_TEXT = "auswahl.action_kalkulation_drucken";
    public static final int         ACTION_SPEZIFIKATION_DRUCKEN_CODE = 1065;
    public static final String     ACTION_SPEZIFIKATION_DRUCKEN_TEXT = "auswahl.action_spezifikation_drucken";
    public static final int         ACTION_DEPENDENCY_CALC_CODE = 1066;
    public static final String     ACTION_DEPENDENCY_CALC_TEXT = "auswahl.action_dependency_calc";
    public static final int         ACTION_PALETTEN_CODE = 1067;
    public static final String     ACTION_PALETTEN_TEXT = "auswahl.action_palette";
    public static final int         ACTION_PALETTENRECHNER_CODE = 1068;
    public static final String     ACTION_PALETTENRECHNER_TEXT = "auswahl.action_palettenrechner";
    public static final int         ACTION_ABFRAGE_ERWEITERT_CODE = 1069;
    public static final String     ACTION_ABFRAGE_ERWEITERT_TEXT = "auswahl.action_erweitert";
    public static final int         ACTION_INVENTUR_CODE = 1070;
    public static final String     ACTION_INVENTUR_TEXT = "auswahl.action_inventur";
    public static final int         ACTION_ACIDLISTE_CODE = 1071;
    public static final String     ACTION_ACIDLISTE_TEXT = "auswahl.action_acidliste";
    public static final int         ACTION_ACIDRECHNER_CODE = 1072;
    public static final String     ACTION_ACIDRECHNER_TEXT = "auswahl.action_acidrechner";
    public static final int         ACTION_DEKLARATIONEN_CODE = 1073;
    public static final String     ACTION_DEKLARATIONEN_TEXT = "auswahl.action_deklarationen";
    public static final int         ACTION_SPEZIFIKATION_DRUCKEN_KOMPLETT_CODE = 1074;
    public static final String     ACTION_SPEZIFIKATION_DRUCKEN_KOMPLETT_TEXT = "auswahl.action_spezifikation_drucken_komplett";
    public static final int         ACTION_NEUE_AUSSTATTUNG_CODE = 1075;
    public static final String     ACTION_NEUE_AUSSTATTUNG_TEXT = "auswahl.action_neue_ausstattung";
    public static final int         ACTION_NEUE_AUSSTATTUNG_GRUPPE_CODE  = 1076;
    public static final String     ACTION_NEUE_AUSSTATTUNG_GRUPPE_TEXT = "auswahl.action_neue_ausstattung_gruppe";
    public static final int         ACTION_DATENBLATT_CODE  = 1077;
    public static final String     ACTION_DATENBLATT_TEXT = "auswahl.action_datenblatt";
    public static final int         ACTION_REZEPTUR_DRUCKEN_LISTE_CODE = 1078;
    public static final String     ACTION_REZEPTUR_DRUCKEN_LISTE_TEXT = "auswahl.action_rezeptur_drucken_liste";
    public static final int         ACTION_BESTELLUNGSLISTENFENSTER_CODE = 1079;
    public static final String     ACTION_BESTELLUNGSLISTENFENSTER_TEXT = "auswahl.action_bestellungen";
    public static final int         ACTION_BESTELLUNG_CODE = 1080;
    public static final String     ACTION_BESTELLUNG_TEXT = "auswahl.action_bestellung";
    public static final int         ACTION_BESTANDSWARNUNG_CODE = 1081;
    public static final String     ACTION_BESTANDSWARNUNG_TEXT = "auswahl.action_bestandswarnung";
    public static final int         ACTION_LABORWERTLISTE_CODE = 1082;
    public static final String     ACTION_LABORWERTLISTE_TEXT = "auswahl.action_laborwerte";
    public static final int         ACTION_PROBE_CODE = 1083;
    public static final String     ACTION_PROBE_TEXT = "auswahl.action_probe";
    public static final int         ACTION_PROBE_NEU_CODE = 1084;
    public static final String     ACTION_PROBE_NEU_TEXT = "auswahl.action_neue_probe";
    public static final int         ACTION_NAV_ANFANG_CODE= 1085;
    public static final String     ACTION_NAV_ANFANG_TEXT = "auswahl.action_nav_anfang";
    public static final int         ACTION_NAV_ZURUECK_CODE= 1086;
    public static final String     ACTION_NAV_ZURUECK_TEXT = "auswahl.action_nav_zurueck";
    public static final int         ACTION_NAV_VOR_CODE= 1087;
    public static final String     ACTION_NAV_VOR_TEXT = "auswahl.action_nav_vor";
    public static final int         ACTION_NAV_ENDE_CODE= 1088;
    public static final String     ACTION_NAV_ENDE_TEXT = "auswahl.action_nav_ende";
    public static final int         ACTION_ZUTATENVERZEICHNIS_EINSTELLUNGEN_CODE= 1089;
    public static final String     ACTION_ZUTATENVERZEICHNIS_EINSTELLUNGEN_TEXT = "auswahl.action_zutatenverzeichnis_einstellungen";
    public static final int         ACTION_ZUTATENVERZEICHNIS_DRUCKEN_CODE = 1090;
    public static final String     ACTION_ZUTATENVERZEICHNIS_DRUCKEN_TEXT = "auswahl.action_zutatenverzeichnis_drucken";
    public static final int         ACTION_SPEZIFIKATION_PDF_CODE = 1091;
    public static final String     ACTION_SPEZIFIKATION_PDF_TEXT = "auswahl.action_spezifikation_pdf";
    public static final int         ACTION_SPEZIFIKATION_PDF_KOMPLETT_CODE = 1092;
    public static final String     ACTION_SPEZIFIKATION_PDF_KOMPLETT_TEXT = "auswahl.action_spezifikation_pdf_komplett";
    public static final int         ACTION_VERBRAUCH_CODE = 1093;
    public static final String     ACTION_VERBRAUCH_TEXT = "auswahl.action_verbrauch";
    public static final int         ACTION_VERBRAUCH_LISTE_CODE = 1094;
    public static final String     ACTION_VERBRAUCH_LISTE_TEXT = "auswahl.action_verbrauch_liste";
    public static final int         ACTION_CONTAINER_RETURN_CODE = 1096;
    public static final String     ACTION_CONTAINER_RETURN_TEXT = "auswahl.action_container_return";
    public static final int         ACTION_DELETE_HISTORY_CODE = 1097;
    public static final String     ACTION_DELETE_HISTORY_TEXT = "auswahl.action_delete_history";
    public static final int         ACTION_GEWICHT_CODE = 1098;
    public static final String     ACTION_GEWICHT_TEXT = "auswahl.action_gewicht";
    public static final int         ACTION_ABFRAGE_PRIVAT_CODE = 1099;
    public static final String     ACTION_ABFRAGE_PRIVAT_TEXT = "auswahl.action_abfrage_privat";
    public static final int         ACTION_ABFRAGE_PUBLIC_CODE = 1100;
    public static final String     ACTION_ABFRAGE_PUBLIC_TEXT = "auswahl.action_abfrage_public";
    public static final int         ACTION_LISTE_DRUCKEN_CODE = 1101;
    public static final String     ACTION_LISTE_DRUCKEN_TEXT = "auswahl.action_liste_drucken";
    public static final int         ACTION_BESTANDSWARNUNG_UEBERTRAGEN_CODE = 1102;
    public static final String     ACTION_BESTANDSWARNUNG_UEBERTRAGEN_TEXT = "auswahl.bestandswarnung_uebertragen";
    public static final int         ACTION_BESTANDSWARNUNG_DRUCKEN_CODE = 1103;
    public static final String     ACTION_BESTANDSWARNUNG_DRUCKEN_TEXT = "auswahl.bestandswarnung_drucken";
    public static final int         ACTION_SHOW_LOSNUMMER_VORLAGE_CODE = 1104;
    public static final String     ACTION_SHOW_LOSNUMMER_VORLAGE_TEXT = "auswahl.losnummer_vorlage";
    public static final int		 	ACTION_SHOW_KALENDER_CODE=1105;    
    public static final String     ACTION_SHOW_KALENDER_TEXT = "auswahl.action_kalender";
    public static final int		 	ACTION_SHOW_AUFTRAG_CODE=1106;    
    public static final String     ACTION_SHOW_AUFTRAG_TEXT = "auswahl.action_auftrag";
    public static final int		 	ACTION_SHOW_CHANGES_CODE=1107;    
    public static final String     ACTION_SHOW_CHANGES_TEXT = "auswahl.action_changes";
    public static final int		 	ACTION_SHOW_CHANGES_LISTE_CODE=1108;    
    public static final String     ACTION_SHOW_CHANGES_LISTE_TEXT = "auswahl.action_changesliste";
    public static final int		 	ACTION_SHOW_MHD_CODE=1109;    
    public static final String     ACTION_SHOW_MHD_TEXT = "auswahl.action_mhd";
    public static final int		 	ACTION_ADD_ETIKETTENLISTE_CODE=1110;    
    public static final String     ACTION_ADD_ETIKETTENLISTE_TEXT = "auswahl.action_add_etikettenliste";
    public static final int		 	ACTION_BESTANDSLISTENDRUCK_CODE=1111;    
    public static final String     ACTION_LISTENDRUCK_TEXT = "auswahl.action_bestandslistendruck";
    public static final int		 	ACTION_TEMPERATURZONEN_CODE=1112;    
    public static final String     ACTION_TEMPERATURZONEN_TEXT = "auswahl.action_temperaturzonen";
    public static final int		 	ACTION_SHOW_AUFTRAGSLISTE_CODE=1113;    
    public static final String     ACTION_SHOW_AUFTRAGSLISTE_TEXT = "auswahl.action_auftragsliste";
    public static final int		 	ACTION_AUFTRAGSLISTE_REFRESH_CODE=1114;    
    public static final String     ACTION_AUFTRAGSLISTE_REFRESH_TEXT = "auswahl.action_auftragsliste_refresh";
    public static final int		 	ACTION_AUFTRAGSLISTE_DRUCKEN_CODE=1115;    
    public static final String     ACTION_AUFTRAGSLISTE_DRUCKEN_TEXT = "auswahl.action_auftragsliste_drucken";
    public static final int		 	ACTION_SHOW_ANFRAGENLISTE_CODE=1116;    
    public static final String     ACTION_SHOW_ANFRAGENLISTE_TEXT = "auswahl.action_anfragenliste_show";
    public static final int		 	ACTION_ANFRAGENLISTE_REFRESH_CODE=1117;    
    public static final String     ACTION_ANFRAGENLISTE_REFRESH_TEXT = "auswahl.action_anfragenliste_refresh";
    public static final int		 	ACTION_ANFRAGENLISTE_DRUCKEN_CODE=1118;    
    public static final String     ACTION_ANFRAGENLISTE_DRUCKEN_TEXT = "auswahl.action_anfragenliste_drucken";
    public static final int		 	ACTION_AUFTRAGSLISTE_DRUCKEN_EIGENE_CODE=1119;    
    public static final String     ACTION_AUFTRAGSLISTE_DRUCKEN_EIGENE_TEXT = "auswahl.action_auftragsliste_drucken_eigene";
    public static final int		 	ACTION_SHOW_DMLISTE_CODE=1120;    
    public static final String     ACTION_SHOW_DMLISTE_TEXT = "auswahl.action_dmliste";
    public static final int		 	ACTION_SHOW_TANKLISTE_CODE=1121;    
    public static final String     ACTION_SHOW_TANKLISTE_TEXT = "auswahl.action_tanks";
    public static final int		 	ACTION_SHOW_KONFORM_CODE=1122;    
    public static final String     ACTION_SHOW_KONFORM_TEXT = "auswahl.action_konform";
    public static final int		 	ACTION_AUFTRAG_SUCHEN_CODE=1123;    
    public static final String     ACTION_AUFTRAG_SUCHEN_TEXT = "auswahl.action_auftrag_suchen";
    public static final int		 	ACTION_AUFTRAG_ANZEIGEN_CODE=1124;    
    public static final String     ACTION_AUFTRAG_ANZEIGEN_TEXT = "auswahl.action_auftrag_anzeigen";
    public static final int		 	ACTION_AUFTRAG_RECHNEN_CODE=1125;    
    public static final String     ACTION_AUFTRAG_RECHNEN_TEXT = "auswahl.action_auftrag_rechnen";
    public static final int		 	ACTION_AUFTRAG_LOESCHEN_CODE=1126;    
    public static final String     ACTION_AUFTRAG_LOESCHEN_TEXT = "auswahl.action_auftrag_loeschen";
    public static final int		 	ACTION_SHOW_MISCHUNGSFENSTER_CODE=1127;    
    public static final String     ACTION_SHOW_MISCHUNGSFENSTER_TEXT = "auswahl.action_show_mischungsfenster";
    public static final int		 	ACTION_SHOW_BEWERTUNGEN_CODE=1128;    
    public static final String     ACTION_SHOW_BEWERTUNGEN_TEXT = "auswahl.action_show_bewertungen";
    public static final int		 	ACTION_PRIORITY_CODE=1129;    
    public static final String    	 ACTION_PRIORITY_TEXT = "auswahl.action_priority";
    public static final int		 	ACTION_AUFTRAG_STATUS_CODE=1130;    
    public static final String     ACTION_AUFTRAG_STATUS_TEXT = "auswahl.action_auftrag_status";
    public static final int		 	ACTION_AUFTRAG_ENTFERNEN_CODE=1131;    
    public static final String     ACTION_AUFTRAG_ENTFERNEN_TEXT = "auswahl.action_auftrag_entfernen";
    public static final int		 	ACTION_VERGLEICH_1_CODE=1132;    
    public static final String     ACTION_VERGLEICH_1_TEXT = "auswahl.action_vergleich_1";
    public static final int		 	ACTION_VERGLEICH_2_CODE=1133;    
    public static final String     ACTION_VERGLEICH_2_TEXT = "auswahl.action_vergleich_2";
    public static final int		 	ACTION_BESTANDSWARNUNG_AUSWAHL_CODE=1134;    
    public static final String     ACTION_BESTANDSWARNUNG_AUSWAHL_TEXT = "auswahl.action_abfrage_stichworte";
    public static final int		 	ACTION_BESTANDSWARNUNG_CLEAR_CODE=1135;    
    public static final String     ACTION_BESTANDSWARNUNG_CLEAR_TEXT = "auswahl.action_abfrage_stichworte_loeschen";
    public static final int		 	ACTION_ZUTATENLISTE_CODE=1136;    
    public static final String     ACTION_ZUTATENLISTE_TEXT = "auswahl.action_zutatenliste";
    public static final int		 	ACTION_DRUCKFORMULARE_CODE=1137;    
    public static final String     ACTION_DRUCKFORMULARE_TEXT = "auswahl.action_druckformulare"; 
    public static final int		 	ACTION_MUSTER_SUCHEN_CODE=1138;    
    public static final String     ACTION_MUSTER_SUCHEN_TEXT = "auswahl.action_muster_suchen"; 
    public static final int         ACTION_VERWENDUNG_EINZELN_CODE = 1139;
    public static final String     ACTION_VERWENDUNG_EINZELN_TEXT = "auswahl.action_verwendung_einzeln";
    public static final int         ACTION_DOKUMENTE_CODE = 1140;
    public static final String     ACTION_DOKUMENTE_TEXT = "auswahl.action_dokumente";
    public static final int         ACTION_DOKUMENTE_ALLE_CODE = 1141;
    public static final String     ACTION_DOKUMENTE_ALLE_TEXT = "auswahl.action_dokumente_alle";
    public static final int         ACTION_DOKUMENTE_FILTER_CODE = 1142;
    public static final String     ACTION_DOKUMENTE_FILTER_TEXT = "auswahl.action_dokumente_filter";
    public static final int         ACTION_ZUTATEN_ALLE_CODE  = 1143;
    public static final String     ACTION_ZUTATEN_ALLE_TEXT = "auswahl.action_zutaten_alle";
    public static final int         ACTION_CONTENT_CODE  = 1144;
    public static final String     ACTION_CONTENT_TEXT = "auswahl.action_content";
    public static final int         ACTION_AUFTRAGSLISTE_SUCHEN_CODE  = 1145;
    public static final String     ACTION_AUFTRAGSLISTE_SUCHEN_TEXT = "auswahl.action_auftragsliste_suchen";
    public static final int         ACTION_AUFTRAGSLISTE_SUCHEN_CLEAR_CODE  = 1146;
    public static final String     ACTION_AUFTRAGSLISTE_SUCHEN_CLEAR_TEXT = "auswahl.action_auftragsliste_suchen_clear";
    public static final int         ACTION_SHOW_KONTRAKTE_CODE  = 1147;
    public static final String     ACTION_SHOW_KONTRAKTE_TEXT = "auswahl.action_kontrakte";
    
    		
    public static final int		MAX_COLUMN=3;
    public static final int		C_DIFF =0;
    public static final int		C_EINHEIT =1;
    public static final int		C_BEZEICHNUNG=2;

    public static final int		MILLISECONDS_PER_MINUTE = 60000;
    public static final int		TIMEOUT_REFRESH = 2500;
    
    public static final int 	CE_ICON=0;
    public static final int 	CE_BEZEICHNUNG=1;
    public static final int 	CE_DATUM=2;
    public static final int		CE_STICHWORTE = 3;
    public static final int		CE_FUELLSTAND=4;
    public static final int		CE_KONFORM = 5;
    public static final int		CE_MAX=6;
    
    
    public static final int 		AL_MAX_COLUMNS=3;
    public static final int		AL_C_SUCHEN=0;
    public static final int		AL_C_MENGE=1;
    public static final int		AL_C_BEZEICHNUNG=2;
    
    
    BestandswarnungsListe bl;

    AbfrageListe        	abfragen;

    // die im GUI angezeigte Abfrage
    AbfrageItem         	abfrage;

    DialogItem              dlgItem;
    // ErgebnisTimer
    javax.swing.Timer 	  	ergebnisTimer;
    javax.swing.Timer		bestandswarnungsTimer;
    javax.swing.Timer		auftragslisteTimer;
    javax.swing.Timer		anfragenlisteTimer;
    javax.swing.Timer		timeoutTimer;
    
    ErgebnisListe			ergebnisse;
    Auftragsliste			auftragsliste;
    Auftragsliste			anfragenliste;
    
    Icon					terminLabel;
    Icon					anfragenLabel;
    Icon					auftragPriority;
    Icon					auftragNoPriority;
    
    AuftragsItem			dragSource;
    AuftragsItem			dragDest;
    Cursor					dragCursor;
    boolean 				dragging;
    
    
    ZutatenDialog			zd;
    /** Creates new form auswahl */
    public Auswahl(RzPro r,String name,Object extendedData) {
    	super(r,name,extendedData);
        terminLabel = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/auswahl.action_kalender.png"));
        anfragenLabel = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/auswahl.action_anfrage.png"));
        auftragPriority =  new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/auswahl.icon_priority.png"));
        auftragNoPriority =  new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/auswahl.action_priority.png"));   
        abfrage = new AbfrageItem();
        ergebnisTimer = new javax.swing.Timer(rz.getOptionFactory().getOption("list.timeout",RzPro.LIST_TIMEOUT), new ActionListener() {
              public void actionPerformed(ActionEvent evt) {
                   ergebnisTimerEvent();
              }
        });
        // Der Timer ist in Millisekunden
        bestandswarnungsTimer = new javax.swing.Timer(rz.getOptionFactory().getOption("bestandswarnung.timer" ,RzPro.LIST_TIMEOUT)*MILLISECONDS_PER_MINUTE, new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                 bestandsWarnungsAction();
            }
        });
        auftragslisteTimer = new javax.swing.Timer(rz.getOptionFactory().getOption("auftragsliste.timer" ,RzPro.LIST_TIMEOUT)*MILLISECONDS_PER_MINUTE, new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                 auftragslisteAction();
            }
        });
        anfragenlisteTimer = new javax.swing.Timer(rz.getOptionFactory().getOption("anfragenliste.timer" ,RzPro.LIST_TIMEOUT)*MILLISECONDS_PER_MINUTE, new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                 anfragenlisteAction();
            }
        });
        timeoutTimer = new javax.swing.Timer(TIMEOUT_REFRESH, new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                 timeoutAction();
            }
        });
       	timeoutTimer.start();
        this.bestandswarnungsTimer.start();
        this.auftragslisteTimer.start();
        this.anfragenlisteTimer.start();
        createActions();
        createGUIComponents();
		this.settblErgebnisModel(tblErgebnis);
		this.settblAuftragslisteModel(tblAuftragsliste);
		this.settblAnfragenlisteModel(tblAnfragenliste);
        setGUIComponents();
        getAuftragsListe();
        getAnfragenListe();
        dlgItem = new DialogItem(0,"",0.0,"","","","","","",null);
    }

    /* Das Auswahlfenster schliessen heisst die Anwendung
     * gleich ganz beenden
     *
     */
	public void closeWindow() {
		saveHistory();
		saveComponentProperties();
        saveDividerLocations();
        rz.getOptionFactory().setOption("anfragenliste.timer", ((Integer)this.splAuftragsliste.getValue()).intValue());
        rz.getOptionFactory().setOption("auftragsliste.timer", ((Integer)this.splAuftragsliste.getValue()).intValue());
        rz.getOptionFactory().setOption("bestandswarnung.timer", ((Integer)this.splBestandswarnung.getValue()).intValue());
        rz.getOptionFactory().setOption("auswahl.tab1_state",auftragBestandswarnungsTab.getSelectedIndex());
        rz.getOptionFactory().saveOptions();
		if (zd != null) {
			zd.dispose();
			zd = null;
		}
		rz.sysMessage(new MessageItem(MessageItem.MSG_QUIT,0,null,this));
	}

	/** GUI-Komponenten erzeugen
	 */
	public void createGUIComponents() {
		mb = new JMenuBar();
		mnuDatei = new JMenu();
        	mnuNeu = new JMenu();
        		mnuDatei.add(mnuNeu);
			mb.add(mnuDatei);
        mnuBearbeiten = new JMenu();
        	mb.add(mnuBearbeiten);
        mnuNavigation = new JMenu();
        	mb.add(mnuNavigation);
        mnuAbfragen = new JMenu();
        	mb.add(mnuAbfragen);
        mnuBuchung=new JMenu();
        	mb.add(mnuBuchung);
        mnuExtras = new JMenu();
        	mb.add(mnuExtras);
        mnuFenster = new JMenu();
        	mb.add(mnuFenster);
        mnuHilfe = new JMenu();
        	mb.add(mnuHilfe);
		setJMenuBar(mb);
		
        mnuPriorityA = new JMenu();
        mnuPriorityAN = new JMenu();
        mnuPriorityAA = new JMenu();
        mnuPriorityAAN = new JMenu();
        mnuContextAuftrag = new JPopupMenu();
        mnuContextArbeitsAuftrag = new JPopupMenu();
        
        mnuContextAuftragNoDelete = new JPopupMenu();
        mnuContextArbeitsAuftragNoDelete = new JPopupMenu();
        
		mainPanel = new JPanel(new BorderLayout());
			toolbarPanel = new JPanel(new BorderLayout());
				tb1 = new JToolBar();
				tb1.setFloatable(false);
				tb1.setRollover(true);
				toolbarPanel.add(tb1,BorderLayout.NORTH);
				tb2 = new JToolBar();
				tb2.setFloatable(false);
				tb2.setRollover(true);
				toolbarPanel.add(tb2,BorderLayout.CENTER);
				tb3 = new JToolBar();
				tb3.setFloatable(false);
				tb3.setRollover(true);
				toolbarPanel.add(tb3,BorderLayout.WEST);
			mainPanel.add(toolbarPanel,BorderLayout.NORTH);
			centerPanel  = new JPanel(new BorderLayout());
			
				auftragBestandswarnungsTab = new JTabbedPane();
					auftragBestandswarnungsTab.setTabLayoutPolicy(JTabbedPane.WRAP_TAB_LAYOUT);
						auftragBestandswarnungsTab.addChangeListener(new ChangeListener() {
								public void stateChanged(ChangeEvent arg0) {
									switch(auftragBestandswarnungsTab.getSelectedIndex()) {
										case 0: bestandsWarnungsAction();
											break;
										case 1: auftragslisteAction();
											break;
										case 2: anfragenlisteAction();
											break;
									}
								}
							});
							leftBestandswarnungsPanel = new JPanel(new BorderLayout());
			    		 		lblBestandswarnung=new JLabel();
			    		 			lblBestandswarnung.setHorizontalAlignment(SwingConstants.CENTER);
			    		 		leftBestandswarnungsPanel.add(lblBestandswarnung,BorderLayout.NORTH);
			    		 		scrBestandswarnung = new JScrollPane();
			    	    			txtBestandswarnung=new JEditorPane();
									txtBestandswarnung.setContentType("text/html");
							        txtBestandswarnung.addHyperlinkListener(new javax.swing.event.HyperlinkListener() {
							            public void hyperlinkUpdate(javax.swing.event.HyperlinkEvent evt) {
							                if(evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED){
								                	ergebnisLinkAction(txtBestandswarnung);
							                	}
								            }
								        });
									txtBestandswarnung.setEditable(false);
						
									
			    	    			scrBestandswarnung.setViewportView(txtBestandswarnung);

								leftBestandswarnungsPanel.add(scrBestandswarnung,BorderLayout.CENTER);

								bestandsWarnungButtonPanel=new JPanel();
									bestandsWarnungButtonPanel.setLayout(new BoxLayout(bestandsWarnungButtonPanel,BoxLayout.PAGE_AXIS));
									
				    		 		 bestandsWarnungStichwortPanel = new JPanel(new BorderLayout());
				    		 		 bestandsWarnungStichwortPanel.setBorder(BorderFactory.createEtchedBorder());
				    		 		 	lblBestandsWarnungStichwort = new JLabel();
				    		 		 		lblBestandsWarnungStichwort.setHorizontalAlignment(SwingConstants.TRAILING);
				    		 		 	bestandsWarnungStichwortPanel.add(lblBestandsWarnungStichwort,BorderLayout.WEST);
				    		 		   
				    		 			lblBestandsWarnungStichwortListe = new JLabel();
				    		 			bestandsWarnungStichwortPanel.add(lblBestandsWarnungStichwortListe,BorderLayout.CENTER);
				    		 			
				    		 					bestandsWarnungStichwortButtonPanel = new JPanel(new GridLayout(1,2));
				    		 						btBestandsWarnungStichwortAuswahl = new JButton();
				    		 						bestandsWarnungStichwortButtonPanel.add(btBestandsWarnungStichwortAuswahl);	
				    		 						btBestandsWarnungStichwortClear = new JButton();
				    		 						bestandsWarnungStichwortButtonPanel.add(btBestandsWarnungStichwortClear);
				    		 			bestandsWarnungStichwortPanel.add(bestandsWarnungStichwortButtonPanel,BorderLayout.EAST);	
									bestandsWarnungButtonPanel.add(bestandsWarnungStichwortPanel);
									bestandsWarnungButtonPanelOben=new JPanel(new BorderLayout());
										bestandsWarnungZutatenPanel = new JPanel(new BorderLayout());
											chkBestandZutaten = new JCheckBox();
							        	    chkBestandZutaten.addActionListener(new ActionListener() {
						        	        	public void actionPerformed(ActionEvent evt) {
						        	        		bestandsWarnungsAction();
						        	        	}
							        	    });
										bestandsWarnungZutatenPanel.add(chkBestandZutaten,BorderLayout.NORTH);
									bestandsWarnungButtonPanelOben.add(bestandsWarnungZutatenPanel,BorderLayout.NORTH);
									bestandsWarnungBuchungenPanel = new JPanel(new BorderLayout());
										chkBestandBuchungen = new JCheckBox();
										bestandsWarnungBuchungenPanel.add(chkBestandBuchungen,BorderLayout.NORTH);
										lblBestandBuchungen = new JLabel();
										lblBestandBuchungen.setVisible(false);
						        	    chkBestandBuchungen.addActionListener(new ActionListener() {
					        	        	public void actionPerformed(ActionEvent evt) {
					        	        		if(chkBestandBuchungen.isSelected()) {
					        	        			lblBestandBuchungen.setVisible(true);
					        	        		}else {
					        	        			lblBestandBuchungen.setVisible(false);
					        	        		}
					        	        		bestandsWarnungsAction();
					        	        		//rz.getOptionFactory().setOption("bestandswarnung.buchungen",chkBestandBuchungen.isSelected()?1:0);
					        	        	}
						        	    });

										bestandsWarnungBuchungenPanel.add(lblBestandBuchungen,BorderLayout.WEST);
										bestandsWarnungButtonPanelOben.add(bestandsWarnungBuchungenPanel,BorderLayout.WEST);
										

									bestandsWarnungButtonPanel.add(bestandsWarnungButtonPanelOben,BorderLayout.NORTH);
									bestandsWarnungButtonPanelUnten=new JPanel(new BorderLayout());
				    		 		btBestandswarnung=new JButton();
									btBestandsWarnungDrucken = new JButton();
									btBestandsWarnungUebertragen = new JButton();
									bestandsWarnungsActionPanel=new JPanel(new GridLayout(2,2));
					    		 		bestandsWarnungsActionPanel.add(btBestandsWarnungUebertragen);
					    		 		bestandsWarnungsActionPanel.add(btBestandsWarnungDrucken);
					    		 		bestandsWarnungsActionPanel.add(btBestandswarnung);
				    		 		bestandsWarnungButtonPanelUnten.add(bestandsWarnungsActionPanel,BorderLayout.NORTH);
				    		 		lblBestandswarnung_text1=new JLabel();
				    		 		bestandsWarnungButtonPanelUnten.add(lblBestandswarnung_text1,BorderLayout.WEST);

	    		    	    		splBestandswarnung = new JSpinner();
		 			    	           splBestandswarnung.addChangeListener(new javax.swing.event.ChangeListener() {
		 			    	               public void stateChanged(javax.swing.event.ChangeEvent evt) {
		 			    	                	spinnerChanged(splBestandswarnung,evt);
		 			    	            	}
		 			    	           });
		 			    	          bestandsWarnungButtonPanelUnten.add(splBestandswarnung,BorderLayout.CENTER);

				    		 		lblBestandswarnung_text2=new JLabel();
				    		 		bestandsWarnungButtonPanelUnten.add(lblBestandswarnung_text2,BorderLayout.EAST);

									bestandsWarnungButtonPanel.add(bestandsWarnungButtonPanelUnten,BorderLayout.SOUTH);
				    		 	leftBestandswarnungsPanel.add(bestandsWarnungButtonPanel,BorderLayout.SOUTH);
				    		 	leftBestandswarnungsPanel.setBorder(BorderFactory.createEtchedBorder());
				    		 auftragBestandswarnungsTab.add(leftBestandswarnungsPanel);
				    	//-------------------------------------------
				    	// Auftragsliste
				    	//---------------------------------------------	 	
				    	auftragslistenPanel=new JPanel(new BorderLayout());
				    		auftragslistenPanel.setBorder(BorderFactory.createEtchedBorder());
				    			auftragslistenTitelPanel = new JPanel(new BorderLayout());
				    				lblAuftragslisteTitel=new JLabel();
				    				lblAuftragslisteTitel.setHorizontalAlignment(SwingConstants.CENTER);
				    			auftragslistenTitelPanel.add(lblAuftragslisteTitel,BorderLayout.WEST);
				    			
				    				txtAuftragSucheField = new JSelectedTextField();
				    				txtAuftragSucheField.addKeyListener(new java.awt.event.KeyAdapter() {
							            public void keyReleased(java.awt.event.KeyEvent evt) {
							                 if(txtAuftragSucheField.isFocusOwner()) {
							                 //   if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
							                    	getAuftragsListe();
							                 //   }
							                }
							            }
							        });
				    				auftragslistenTitelPanel.add(txtAuftragSucheField,BorderLayout.CENTER);
				    				
				    				auftragSucheButtonPanel = new JPanel(new GridLayout(1,2));
				    					btAuftragSucheButton = new JButton();
				    					auftragSucheButtonPanel.add(btAuftragSucheButton);
				    					btAuftragSucheClearButton = new JButton();
				    					auftragSucheButtonPanel.add(btAuftragSucheClearButton);
				    				auftragslistenTitelPanel.add(auftragSucheButtonPanel,BorderLayout.EAST);
				    		auftragslistenPanel.add(auftragslistenTitelPanel, BorderLayout.NORTH);
				    		auftragsListeTblPanel = new JPanel(new BorderLayout());
				    			auftragsZutatenPanel = new JPanel(new BorderLayout());
				    				auftragsZutatenPanel.setBorder(BorderFactory.createEtchedBorder());
				    				btZutatenliste = new JButton();
				    				auftragsZutatenPanel.add(btZutatenliste,BorderLayout.SOUTH);
				    			auftragsListeTblPanel.add(auftragsZutatenPanel,BorderLayout.SOUTH);
				    		scrAuftragsliste=new JScrollPane();
				    			tblAuftragsliste = new JTable();
				    			tblAuftragsliste.addMouseMotionListener(new MouseMotionListener() {

									@Override
									public void mouseDragged(MouseEvent e) {
										dragging = true;
										if(dragCursor != null) {
											tblAuftragsliste.setCursor(dragCursor);
										}
									}

									@Override
									public void mouseMoved(MouseEvent e) {
									}
				    			});
				    			//			tblAuftragsliste.setCursor(rz.getDatabase().getAuftrag().getDatumCursor(drag,tblAuftragsliste));
					 	        tblAuftragsliste.addMouseListener(new MouseAdapter() {
									public void mousePressed(MouseEvent e) {
										tblAuftragsListeDragStartAction();
					 	            }
								 public void mouseExited(MouseEvent e) {
								      	resetDragging();
								    }
								public void mouseReleased(MouseEvent e) {
									if(e.isMetaDown()) {
										showPopup(e);
										return;
						 	        }
									if(dragging) {
										tblAuftragslisteDragEndAction();
									}else {
						 	           tblAufragslisteSelectionChanged();
									}
									resetDragging();
						 	    }
								
								private void showPopup(MouseEvent e) {
									 int line;
					 	           	   line = getSelectedLine();
					 	           	   tblAuftragsliste.getSelectionModel().setSelectionInterval(line,line);
					 	           	   tblAuftragsliste.getColumnModel().getSelectionModel().setSelectionInterval(AL_C_SUCHEN,AL_C_SUCHEN);
					 	           	   if(auftragsliste != null && !auftragsliste.isEmpty())  {
					 	           		   AuftragsItem ai = auftragsliste.getItem(line);
					 	           		   if(ai != null){
					 	           			   getAction(ACTION_AUFTRAG_SUCHEN_CODE).putValue(AbstractAction.SHORT_DESCRIPTION, rz.getLocale().getString("auswahl.action_auftrag_suchen.1").replaceAll("%i", ai.getBezeichnung()));
					 	           			   getAction(ACTION_AUFTRAG_ANZEIGEN_CODE).putValue(AbstractAction.SHORT_DESCRIPTION, rz.getLocale().getString("auswahl.action_auftrag_anzeigen.1").replaceAll("%i", ai.getBezeichnung()));
					 	           			   getAction(ACTION_AUFTRAG_RECHNEN_CODE).putValue(AbstractAction.SHORT_DESCRIPTION, rz.getLocale().getString("auswahl.action_auftrag_rechnen.1").replaceAll("%i", ai.getBezeichnung()));
					 	           			   getAction(ACTION_AUFTRAG_LOESCHEN_CODE).putValue(AbstractAction.SHORT_DESCRIPTION, rz.getLocale().getString("auswahl.action_auftrag_loeschen.1").replaceAll("%i", ai.getBezeichnung()));
					 	           			   getAction(ACTION_AUFTRAG_SUCHEN_CODE).putValue(AbstractAction.NAME, "<html><b>" + ai.getBezeichnung() + "</b> " + rz.getLocale().getString("auswahl.action_auftrag_suchen")+"</html>");
					 	           			   getAction(ACTION_AUFTRAG_ANZEIGEN_CODE).putValue(AbstractAction.NAME,"<html><b>" + ai.getBezeichnung() + "</b> " +  rz.getLocale().getString("auswahl.action_auftrag_anzeigen")+"</html>");
					 	           			   getAction(ACTION_AUFTRAG_RECHNEN_CODE).putValue(AbstractAction.NAME,"<html><b>" +  ai.getBezeichnung() + "</b> " + rz.getLocale().getString("auswahl.action_auftrag_rechnen")+"</html>");
					 	           			   getAction(ACTION_AUFTRAG_LOESCHEN_CODE).putValue(AbstractAction.NAME,"<html><b>" +  ai.getBezeichnung() + "</b> " + rz.getLocale().getString("auswahl.action_auftrag_loeschen")+"</html>");
					 	           			   getAction(ACTION_AUFTRAG_STATUS_CODE).putValue(AbstractAction.NAME,"<html><b>" +  ai.getBezeichnung() + "</b> " + rz.getLocale().getString("auswahl.action_auftrag_status")+"</html>");
					 	           			   getAction(ACTION_AUFTRAG_ENTFERNEN_CODE).putValue(AbstractAction.NAME,"<html><b>" +  ai.getBezeichnung() + "</b> " + rz.getLocale().getString("auswahl.action_auftrag_entfernen")+"</html>");
					 	           			   mnuPriorityA.setText("<html><b>" +  ai.getBezeichnung() + "</b>&nbsp;" + rz.getLocale().getString("auswahl.action_priority") +"</html>");
					 	           			   mnuPriorityAN.setText("<html><b>" +  ai.getBezeichnung() + "</b>&nbsp;" + rz.getLocale().getString("auswahl.action_priority") +"</html>");
					 	           			   mnuPriorityAA.setText("<html><b>" +  ai.getBezeichnung() + "</b>&nbsp;" + rz.getLocale().getString("auswahl.action_priority") +"</html>");
					 	           			   mnuPriorityAAN.setText("<html><b>" +  ai.getBezeichnung() + "</b>&nbsp;" + rz.getLocale().getString("auswahl.action_priority") +"</html>");
					 	           			   for(int i = 1;i <=DBAuftrag.PRIORITY_MAX;i++ ) {
						 	           			   mnuPriorityA.getItem(i).setIcon(auftragNoPriority);
						 	           			   mnuPriorityAN.getItem(i).setIcon(auftragNoPriority);
						 	           			   mnuPriorityAA.getItem(i).setIcon(auftragNoPriority);
						 	           			   mnuPriorityAAN.getItem(i).setIcon(auftragNoPriority);
					 	           			   }
					 	           			   if(ai.getPriority() != 0) {
						 	           			   mnuPriorityA.getItem(ai.getPriority()).setIcon(auftragPriority);
						 	           			   mnuPriorityAN.getItem(ai.getPriority()).setIcon(auftragPriority);
						 	           			   mnuPriorityAA.getItem(ai.getPriority()).setIcon(auftragPriority);
						 	           			   mnuPriorityAAN.getItem(ai.getPriority()).setIcon(auftragPriority);
					 	           			   }
					 	           			   if(ai.isArbeitsAuftrag()) {
					 	           				   if(ai.isRepeat()) {
					 	           					   mnuContextArbeitsAuftragNoDelete.show(e.getComponent(),e.getX(), e.getY());
					 	           				   }else {
					 	           					   mnuContextArbeitsAuftrag.show(e.getComponent(),e.getX(), e.getY());
					 	           				   }
					 	           			   }else {
					 	           				   if(ai.isRepeat()) {
					 	           					   mnuContextAuftragNoDelete.show(e.getComponent(),e.getX(), e.getY());
					 	           				   }else {
					 	           					   mnuContextAuftrag.show(e.getComponent(),e.getX(), e.getY());
					 	           				   }
					 	           			   }
					 	           		   }
					 	           	   }
									}
					 	        });
				    			tblAuftragsliste.setName("auswahl.auftragsliste");
					    		tblAuftragsliste.setShowGrid(true);
				    			tblAuftragsliste.setGridColor(Color.BLACK);
				    			tblAuftragsliste.setRowSelectionAllowed(true);
				    			tblAuftragsliste.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
				    			
				    			
				    		scrAuftragsliste.setViewportView(tblAuftragsliste);
				    		auftragsListeTblPanel.add(scrAuftragsliste,BorderLayout.CENTER);
				    		auftragslistenPanel.add(auftragsListeTblPanel);
				    		auftragsButtonPanel = new JPanel(new BorderLayout());
				    			auftragsButtonObenPanel=new JPanel(new GridLayout(2,2));
					    			btAuftragslisteRefresh=new JButton();
					    			auftragsButtonObenPanel.add(btAuftragslisteRefresh);
					    			btAuftragslisteDrucken=new JButton();
					    			auftragsButtonObenPanel.add(btAuftragslisteDrucken);
					    			btAuftragslisteBearbeiten=new JButton();
					    			auftragsButtonObenPanel.add(btAuftragslisteBearbeiten);
					    			btAuftragslisteEigeneDrucken=new JButton();  
					    			auftragsButtonObenPanel.add(btAuftragslisteEigeneDrucken);
					    		auftragsButtonPanel.add(auftragsButtonObenPanel, BorderLayout.NORTH);
					    		
					    		auftragsButtonPanelUnten=new JPanel(new BorderLayout());
					    		lblAuftragsliste_text1=new JLabel();
			    		 		auftragsButtonPanelUnten.add(lblAuftragsliste_text1,BorderLayout.WEST);

    		    	    		splAuftragsliste = new JSpinner();
	 			    	           splAuftragsliste.addChangeListener(new javax.swing.event.ChangeListener() {
	 			    	               public void stateChanged(javax.swing.event.ChangeEvent evt) {
	 			    	                	AuftragslisteSpinnerChanged(splAuftragsliste,evt);
	 			    	            	}
	 			    	           });
	 			    	          auftragsButtonPanelUnten.add(splAuftragsliste,BorderLayout.CENTER);

			    		 		lblAuftragsliste_text2=new JLabel();
			    		 		auftragsButtonPanelUnten.add(lblAuftragsliste_text2,BorderLayout.EAST);

								auftragsButtonPanel.add(auftragsButtonPanelUnten,BorderLayout.SOUTH);
					    		
				    		auftragslistenPanel.add(auftragsButtonPanel,BorderLayout.SOUTH);
					auftragBestandswarnungsTab.add(auftragslistenPanel);
					
					//-------------------------------
					// AnfragenListe
					
					anfragenlistenPanel=new JPanel(new BorderLayout());
			    		anfragenlistenPanel.setBorder(BorderFactory.createEtchedBorder());
				    		lblanfragenlisteTitel=new JLabel();
				    			lblanfragenlisteTitel.setHorizontalAlignment(SwingConstants.CENTER);
				    		anfragenlistenPanel.add(lblanfragenlisteTitel, BorderLayout.NORTH);
				    		scrAnfragenliste=new JScrollPane();
				    			tblAnfragenliste = new JTable();
					 	        tblAnfragenliste.addMouseListener(new MouseAdapter() {
									public void mousePressed(MouseEvent e) {
					 	                if(e.getClickCount() !=1) {
					 	                }
					 	            }
								public void mouseReleased(MouseEvent e) {
			        			        tblAnfragenlisteSelectionChanged();     
						 	       }
					 	        });
				    			tblAnfragenliste.setName("auswahl.anfragenliste");
					    		tblAnfragenliste.setShowGrid(true);
				    			tblAnfragenliste.setGridColor(Color.BLACK);
				    		scrAnfragenliste.setViewportView(tblAnfragenliste);
				    		anfragenlistenPanel.add(scrAnfragenliste);
				    		anfragenButtonPanel = new JPanel(new BorderLayout());
				    			anfragenButtonObenPanel=new JPanel(new GridLayout(2,2));
					    			btAnfragenlisteRefresh=new JButton();
					    			anfragenButtonObenPanel.add(btAnfragenlisteRefresh);
					    			btAnfragenlisteDrucken=new JButton();
					    			anfragenButtonObenPanel.add(btAnfragenlisteDrucken);
					    			btAnfragenlisteBearbeiten=new JButton();
					    			anfragenButtonObenPanel.add(btAnfragenlisteBearbeiten);
					    		anfragenButtonPanel.add(anfragenButtonObenPanel, BorderLayout.NORTH);
					    		
					    		anfragenButtonPanelUnten=new JPanel(new BorderLayout());
					    		lblanfragenliste_text1=new JLabel();
			    		 		anfragenButtonPanelUnten.add(lblanfragenliste_text1,BorderLayout.WEST);
		
			    	    		splAnfragenliste = new JSpinner();
					    	           splAnfragenliste.addChangeListener(new javax.swing.event.ChangeListener() {
					    	               public void stateChanged(javax.swing.event.ChangeEvent evt) {
					    	                	anfragenlisteSpinnerChanged(splAnfragenliste,evt);
					    	            	}
					    	           });
					    	          anfragenButtonPanelUnten.add(splAnfragenliste,BorderLayout.CENTER);
		
			    		 		lblanfragenliste_text2=new JLabel();
			    		 		anfragenButtonPanelUnten.add(lblanfragenliste_text2,BorderLayout.EAST);
		
								anfragenButtonPanel.add(anfragenButtonPanelUnten,BorderLayout.SOUTH);
					    		
				    		anfragenlistenPanel.add(anfragenButtonPanel,BorderLayout.SOUTH);
					auftragBestandswarnungsTab.add(anfragenlistenPanel);
					
					
    				rightPanel = new JPanel(new BorderLayout());
    					rightContainerPanel = new JPanel(new BorderLayout());
    						abfragenAllesPanel=new JPanel(new BorderLayout());
			    				abfragePanel = new JPanel(new BorderLayout());
			    				
								abfrageListenPanel = new JPanel(new BorderLayout());
								abfrageListePanel = new JPanel(new BorderLayout());
									alpTop = new JPanel(new BorderLayout());
										lblAbfragelisteTitel = new JLabel();
										lblAbfragelisteTitel.setHorizontalAlignment(SwingConstants.CENTER);
										lblAbfragelisteTitel.setBorder(BorderFactory.createBevelBorder(BevelBorder.RAISED));
										alpTop.add(lblAbfragelisteTitel,BorderLayout.NORTH);
										abfrageListePanel.add(alpTop,BorderLayout.NORTH);
									alpCenter = new JPanel(new BorderLayout());
										lstAbfragenScrollPane = new JScrollPane();
											lstAbfragen = new JRzList();
									        lstAbfragen.addKeyListener(new java.awt.event.KeyAdapter() {
									            public void keyReleased(java.awt.event.KeyEvent evt) {
									                lstAbfragenKeyReleased(evt);
									            }
									        });
									        lstAbfragen.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
									            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
									            	if(evt.getValueIsAdjusting()) {
														return;
													}
									                lstAbfragenValueChanged(evt);
									            }
									        });
									        lstAbfragen.addMouseListener(new java.awt.event.MouseAdapter() {
									            public void mouseClicked(java.awt.event.MouseEvent evt) {
									                lstAbfragenMouseClicked(evt);
									            }
									        });
											lstAbfragenScrollPane.setViewportView(lstAbfragen);
											alpCenter.add(lstAbfragenScrollPane,BorderLayout.CENTER);
									    abfrageListePanel.add(alpCenter,BorderLayout.CENTER);
									alpSouth = new JPanel(new GridLayout(2,3));
								    	btUse = new JButton();
								    		alpSouth.add(btUse);
								        btGo = new JButton();
								        	alpSouth.add(btGo);
								    	btRefresh = new JButton();
								    		alpSouth.add(btRefresh);
								        btRemove = new JButton();
								        	alpSouth.add(btRemove);
								        btPrivate = new JButton();
								        	alpSouth.add(btPrivate);
									    btPublic = new JButton();
								        	alpSouth.add(btPublic);
								        	abfrageListePanel.add(alpSouth,BorderLayout.SOUTH);
										abfrageListenPanel.add(abfrageListePanel);
			    				abfragenAllesPanel.add(abfrageListenPanel,BorderLayout.CENTER); 
			    				
			    				adressenStichwortePanel = new JPanel (new BorderLayout());
			    				
				    		    	adressenAuswahlPanel = new JPanel(new BorderLayout());
	    		    					adressenAuswahlPanel.setBorder(BorderFactory.createBevelBorder(BevelBorder.RAISED));
				    		    		adressenAuswahlTitelPanel = new JPanel(new BorderLayout());
				    		    			lblAdressenTitel = new JLabel();
				    		    			lblAdressenTitel.setHorizontalAlignment(SwingConstants.CENTER);
				    		    			adressenAuswahlTitelPanel.add(lblAdressenTitel,BorderLayout.NORTH);
				    		    			adressenAuswahlPanel.add(adressenAuswahlTitelPanel,BorderLayout.NORTH);
				    		    		adressebAuswahlLabelPanel = new JPanel( new BorderLayout());
												lblRzAdressen = new JRzLabel();
													lblRzAdressen.setBackground(Color.WHITE);
												adressebAuswahlLabelPanel.add(lblRzAdressen,BorderLayout.CENTER);
											adressenAuswahlPanel.add(adressebAuswahlLabelPanel,BorderLayout.CENTER);
				    		    		adressenAuswahlButtonPanel=new JPanel();
				    		    			adressenAuswahlButtonPanel.setLayout(new BoxLayout(adressenAuswahlButtonPanel, BoxLayout.LINE_AXIS));
				    		    			btAdressenBearbeiten = new JButton();
												adressenAuswahlButtonPanel.add(btAdressenBearbeiten);
										    btAdressenLoeschen = new JButton();
										    	adressenAuswahlButtonPanel.add(btAdressenLoeschen);
										    adressenMode = new JPanel();
										    	adressenMode.setLayout(new BoxLayout(adressenMode, BoxLayout.LINE_AXIS));
										    	adressenMode.setBorder(BorderFactory.createEtchedBorder());
												adressenGroup = new  ButtonGroup();
										    		btAdressenModeAnd = new JRadioButton();
										    			adressenGroup.add(btAdressenModeAnd);
										    			adressenMode.add(btAdressenModeAnd);
										    		btAdressenModeOr = new JRadioButton();
										    			adressenGroup.add(btAdressenModeOr);
										    	        adressenMode.add(btAdressenModeOr);
										    	        btAdressenModeAnd.setSelected(true);
										    adressenAuswahlButtonPanel.add(adressenMode);
										    adressenAuswahlButtonPanel.setBorder(BorderFactory.createBevelBorder(BevelBorder.RAISED));
				    		    			adressenAuswahlPanel.add(adressenAuswahlButtonPanel,BorderLayout.SOUTH);
				    		    		adressenStichwortePanel.add(adressenAuswahlPanel,BorderLayout.NORTH);
									stichwortAuswahlPanel = new JPanel(new BorderLayout());
		    		    				stichwortAuswahlPanel.setBorder(BorderFactory.createBevelBorder(BevelBorder.RAISED));
				    		    		stichwortAuswahlTitelPanel = new JPanel(new BorderLayout());
				    		    			lblStichworteTitel = new JLabel();
				    		    			lblStichworteTitel.setHorizontalAlignment(SwingConstants.CENTER);
				    		    			stichwortAuswahlTitelPanel.add(lblStichworteTitel,BorderLayout.NORTH);
					    		       stichwortAuswahlPanel.add(stichwortAuswahlTitelPanel,BorderLayout.NORTH);
					    		       stichwortAuswahlLabelPanel = new JPanel( new BorderLayout());
					    		       			lblRzStichworte = new JRzLabel();
					    		       				lblRzStichworte.setBackground(Color.WHITE);
										   stichwortAuswahlLabelPanel.add(lblRzStichworte,BorderLayout.NORTH);
										   stichwortAuswahlPanel.add(stichwortAuswahlLabelPanel,BorderLayout.CENTER);
										stichwortAuswahlButtonPanel = new JPanel();
											stichwortAuswahlButtonPanel.setLayout(new BoxLayout(stichwortAuswahlButtonPanel, BoxLayout.LINE_AXIS));
											btStichworteBearbeiten = new JButton();
												stichwortAuswahlButtonPanel.add(btStichworteBearbeiten);
											btStichworteLoeschen = new JButton();
												stichwortAuswahlButtonPanel.add(btStichworteLoeschen);
											stichworteMode = new JPanel();
												stichworteMode.setLayout(new BoxLayout(stichworteMode, BoxLayout.LINE_AXIS));
												stichworteMode.setBorder(BorderFactory.createEtchedBorder());
										        stichworteGroup = new  ButtonGroup();
										        	btStichworteModeAnd = new JRadioButton();
										        		stichworteGroup.add(btStichworteModeAnd);
								    			stichworteMode.add(btStichworteModeAnd);
								    				btStichworteModeOr = new JRadioButton();
								    					stichworteGroup.add(btStichworteModeOr);
								    			stichworteMode.add(btStichworteModeOr);
								    	        btStichworteModeAnd.setSelected(true);
								    	        stichwortAuswahlButtonPanel.setBorder(BorderFactory.createBevelBorder(BevelBorder.RAISED));
								    	        stichwortAuswahlButtonPanel.add(stichworteMode);
											stichwortAuswahlPanel.add(stichwortAuswahlButtonPanel,BorderLayout.SOUTH);
										adressenStichwortePanel.add(stichwortAuswahlPanel,BorderLayout.SOUTH);
									
								abfragenAllesPanel.add(adressenStichwortePanel,BorderLayout.SOUTH);
								abfragePanel.add(abfragenAllesPanel,BorderLayout.CENTER);
									abfrageTextPanel = new JPanel();
										abfrageTextPanel.setLayout(new BoxLayout(abfrageTextPanel,BoxLayout.PAGE_AXIS));
										//musterPanel = new JPanel(new GridLayout(4,1));
										musterPanel = new JPanel();
											musterPanel.setLayout(new BoxLayout(musterPanel,BoxLayout.PAGE_AXIS));
											cmbAbfrageModus = new JComboBox();
											cmbAbfrageModus.addActionListener(new java.awt.event.ActionListener() {
												public void actionPerformed(java.awt.event.ActionEvent evt) {
														txtMuster.requestFocus();
													}
												});
												musterPanel.add(cmbAbfrageModus);
												
												txtMusterPanel = new JPanel(new BorderLayout());
													txtMuster = new JSelectedTextArea();
													txtMuster.setWrapStyleWord(false);
													txtMuster.setLineWrap(true);
											        txtMuster.addKeyListener(new java.awt.event.KeyAdapter() {
											            public void keyReleased(java.awt.event.KeyEvent evt) {
											                txtMusterKeyReleased(evt);
											            	}
											        	});
											    txtMusterPanel.add(txtMuster,BorderLayout.CENTER);   
											    
											    btMusterSuchen = new JButton();
											    txtMusterPanel.add(btMusterSuchen,BorderLayout.EAST);
												musterPanel.add(txtMusterPanel);
											chkAblage = new JCheckBox();
											musterPanel.add(chkAblage);
				    			            cmbSort = new JComboBox();
				    			            cmbSort.addActionListener(new java.awt.event.ActionListener() {
				    			                public void actionPerformed(java.awt.event.ActionEvent evt) {
				    			                    cmbSortActionPerformed(evt);
				    			                	}
				    			            	});
				    			            	musterPanel.add(cmbSort);
											abfrageTextPanel.add(musterPanel,BorderLayout.NORTH);
				    					abfrageButtonPanel = new JPanel(new GridLayout(2,2));
									    	btNeu = new JButton();
								    			abfrageButtonPanel.add(btNeu);
				    					    btExecuteQuery = new JButton();
				    					    	abfrageButtonPanel.add(btExecuteQuery);
				    					    btSave = new JButton();
				    					    	abfrageButtonPanel.add(btSave);
				    					    btErweitert = new JButton();
				    					    	abfrageButtonPanel.add(btErweitert);
				    					    abfrageTextPanel.add(abfrageButtonPanel);
										abfragePanel.add(abfrageTextPanel,BorderLayout.SOUTH);
	                           rightContainerPanel.add(abfragePanel,BorderLayout.WEST);

    					ergebnisListePanel = new JPanel(new BorderLayout());
							elTop = new JPanel(new BorderLayout());
								lblErgebnisTitel = new JLabel();
									lblErgebnisTitel.setHorizontalAlignment(SwingConstants.CENTER);
									lblErgebnisTitel.setBorder(BorderFactory.createBevelBorder(BevelBorder.RAISED));
									elTop.add(lblErgebnisTitel,BorderLayout.NORTH);
								ergebnisListePanel.add(elTop,BorderLayout.NORTH);
						    elCenter = new JPanel(new BorderLayout());
								scrErgebnis = new JScrollPane();
						        scrErgebnis.getViewport().setBackground(new Color(255,255,255));
							        //---------------------------------------------------------
							        tblErgebnis=new JTable();
							        tblErgebnis.setName("auswahl.ergebnis.spalten");
							        JTableHeader header = tblErgebnis.getTableHeader();

							        header.addMouseListener(new ColumnHeaderListener());

							        scrErgebnis.setViewportView(tblErgebnis);
							        Action enterKeyAction = new AbstractAction() {
							        	public void actionPerformed(ActionEvent e) {
								        	String actionCmd = e.getActionCommand();
								        	if (actionCmd.equals("EnterKey")) {
								        	//... code for the action
								        	}
							        	}
							        };							        
							        
							        InputMap inputMap = tblErgebnis.getInputMap(JComponent.WHEN_FOCUSED);
							        inputMap.remove(KeyStroke.getKeyStroke(KeyEvent.VK_ENTER,0));
							        tblErgebnis.setInputMap(JComponent.WHEN_FOCUSED,inputMap);
							        tblErgebnis.unregisterKeyboardAction(KeyStroke.getKeyStroke(KeyEvent.VK_ENTER,0));
							        
							        tblErgebnis.registerKeyboardAction(enterKeyAction,"EnterKey", KeyStroke.getKeyStroke(KeyEvent.VK_ENTER,0),JComponent.WHEN_FOCUSED);
							        
							        tblErgebnis.getSelectionModel().addListSelectionListener(new javax.swing.event.ListSelectionListener() {
							            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
							            	if(evt.getValueIsAdjusting()) {
												return;
											}
							                lstErgebnisValueChanged(evt);
							            }
							        });
					    				tblErgebnis.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
						    			tblErgebnis.setColumnSelectionAllowed(false);
						    			tblErgebnis.setRowSelectionAllowed(true);
						    			 tblErgebnis.addKeyListener(new java.awt.event.KeyAdapter() {
									            public void keyReleased(java.awt.event.KeyEvent evt) {
									                if(tblErgebnis.getSelectedRow() != -1) {
									                	tblErgebnis.setRowSelectionInterval(tblErgebnis.getSelectedRow(),tblErgebnis.getSelectedRow());
													}
									                if(tblErgebnis.isFocusOwner()) {
									                    if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
									                    	int i = tblErgebnis.getSelectedRow();
									                        calcAction();
									                        tblErgebnis.setRowSelectionInterval(i,i);
									                    	evt=null;
									                    }
									                }
									            }
									        });
									        tblErgebnis.addMouseListener(new java.awt.event.MouseAdapter() {
									            public void mouseClicked(java.awt.event.MouseEvent evt) {
									                if (evt.getClickCount() == 2) {
									                	ergebnisDoubleClick();
									                }
									            }
									        });
							    		tblErgebnis.setShowGrid(true);
						    			tblErgebnis.setGridColor(rz.getOptionFactory().getColor(OptionFactory.COLOR_VISIBLE_GRID));
							    	scrErgebnis.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
							    	scrErgebnis.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
							       //---------------------------------------------------------- 
							       
								elCenter.add(scrErgebnis,BorderLayout.CENTER);
								lblErgebnisCount = new JLabel();
									lblErgebnisCount.setHorizontalAlignment(SwingConstants.CENTER);
								elCenter.add(lblErgebnisCount,BorderLayout.SOUTH);
						    	ergebnisListePanel.add(elCenter,BorderLayout.CENTER);
						    elSouth = new JPanel(new BorderLayout());
						    	ergebnisListePanel.add(elSouth,BorderLayout.SOUTH);
    					ergebnisPanel = new JPanel(new BorderLayout());
    						//------------------------------------------------------------
							eTop = new JPanel(new BorderLayout());
						    	eNorth = new JPanel (new BorderLayout());
								    lblHistory = new JLabel();
								    	eNorth.add(lblHistory,BorderLayout.WEST);//eTop
								    scrHistory = new JScrollPane();
								    	txtHistory = new JEditorPane() ;
								    		txtHistory.setContentType("text/html");
									        txtHistory.addHyperlinkListener(new javax.swing.event.HyperlinkListener() {
									            public void hyperlinkUpdate(javax.swing.event.HyperlinkEvent evt) {
									                if(evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED){
										                	ergebnisLinkAction(txtHistory);
									                	}
										            }
										        });
								    		txtHistory.setEditable(false);
								    	scrHistory.setViewportView(txtHistory);
								    eNorth.add(scrHistory,BorderLayout.CENTER);//etop
								    	btDeleteHistory = new JButton();
								    eNorth.add(btDeleteHistory,BorderLayout.EAST);
								    this.eNorthNavigation = new JPanel();
								    	eNorthNavigation.setLayout(new BoxLayout(eNorthNavigation,BoxLayout.LINE_AXIS));
										btAnfang=new JButton();
											eNorthNavigation.add(btAnfang);
										btZurueck = new JButton();
											eNorthNavigation.add(btZurueck);
										lblPosition=new JLabel();
											lblPosition.setHorizontalAlignment(SwingConstants.CENTER);
											eNorthNavigation.add(lblPosition);
										btVor = new JButton();
											eNorthNavigation.add(btVor);
										btEnde = new JButton();
											eNorthNavigation.add(btEnde);
								    eNorth.add(eNorthNavigation,BorderLayout.SOUTH);
								    eTop.add(eNorth, BorderLayout.CENTER);//nix
						    //------------------------------------------------------------
							//ergebnisPanel.add(eTop,BorderLayout.NORTH);
						    eCenter = new JPanel(new BorderLayout());
						    
								ausgabeScrollPane = new JScrollPane();
									txtErgebnis = new JEditorPane();
										txtErgebnis.setContentType("text/html");
								        txtErgebnis.addHyperlinkListener(new javax.swing.event.HyperlinkListener() {
								            public void hyperlinkUpdate(javax.swing.event.HyperlinkEvent evt) {
								                if(evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED){
									                	ergebnisLinkAction(txtErgebnis);
								                	}
									            }
									        });
										txtErgebnis.setEditable(false);
										ausgabeScrollPane.setViewportView(txtErgebnis);
									eCenter.add(ausgabeScrollPane);
						    	ergebnisPanel.add(eCenter,BorderLayout.CENTER);
						    	if(Toolkit.getDefaultToolkit().getScreenSize().getWidth() < rz.getOptionFactory().getOption("main.resolution.min.layout.switch", OptionFactory.MAIN_RESOLUTION_MIN_LAYOUT_SWITCH)){
						    		eSouth = new JPanel(   new GridLayout(4,1));
						    	} else {
						    		eSouth = new JPanel(   new BorderLayout());
						    	}
						    		btVerbrauch=new JButton();
						    		eSouth.add(btVerbrauch,BorderLayout.WEST);
						    		btVerbrauchListe = new JButton();
						    		eSouth.add(btVerbrauchListe,BorderLayout.EAST);
						    		btDrucken = new JButton();
						    		eSouth.add(btDrucken,BorderLayout.SOUTH);
						    			listenDruckPanel = new JPanel(new GridLayout(2,2));
						    				listenDruckPanel.setBorder(BorderFactory.createEtchedBorder());
						    				cmbListendruck = new JComboBox();
						    				chkListendruckBestandOnly = new JCheckBox();
						    				chkListendruckBestandOnly.setSelected((rz.getOptionFactory().getOption("auswahl.bestandslistendruck",0) == 1?true:false));
						    				chkListendruckBestandOnly.addActionListener(new ActionListener() {
						        	        	public void actionPerformed(ActionEvent evt) {
						        	        		rz.getOptionFactory().setOption("auswahl.bestandslistendruck", chkListendruckBestandOnly.isSelected()?1:0);
						        	        		rz.getOptionFactory().saveOptions();
						        	        	}
							        	    });
						    				listenDruckPanel.add(chkListendruckBestandOnly);
						    				rz.getDatabase().getReport().dbGetReportListeCombo(cmbListendruck,ReportFactory.REPORT_TYPE_ERGEBNISLISTE_BESTAND);
							        	    cmbListendruck.addActionListener(new ActionListener() {
												public void actionPerformed(ActionEvent evt) {
						        	        		if(cmbListendruck.getSelectedIndex() != -1) {
						        	        			rz.getOptionFactory().setOption("report.ergebnisliste_bestand",((ReportItem)cmbListendruck.getSelectedItem()).getID());
						        	        		}
						        	        	}
							                });
						    				listenDruckPanel.add(cmbListendruck);
						    				chkDuplex= new JCheckBox();
											chkDuplex.setSelected((rz.getOptionFactory().getOption("auswahl.listendruck.duplex",0) == 1?true:false));
											chkDuplex.addActionListener(new ActionListener() {
									        	public void actionPerformed(ActionEvent evt) {
									        		rz.getOptionFactory().setOption("auswahl.listendruck.duplex", chkDuplex.isSelected()?1:0);
									        		rz.getOptionFactory().saveOptions();
									        	}
								    	    });
						    				listenDruckPanel.add(chkDuplex);
							    			btListendruck = new JButton();
							    			listenDruckPanel.add(btListendruck);
							    	eSouth.add(listenDruckPanel);
						    	ergebnisPanel.add(eSouth,BorderLayout.SOUTH);
						 splVertical2=new JSplitPane();
						 	splVertical2.setOrientation(JSplitPane.VERTICAL_SPLIT);
							splVertical2.setDividerSize(6);
						 	splVertical2.setTopComponent(ergebnisListePanel);
						 	splVertical2.setBottomComponent(eTop);
						 	splVertical = new JSplitPane();
						 	splVertical.setOrientation(JSplitPane.VERTICAL_SPLIT);
						 	splVertical.setDividerSize(6);
						 	splVertical.setTopComponent(splVertical2);
						 	splVertical.setBottomComponent(ergebnisPanel);


						 rightContainerPanel.add(splVertical,BorderLayout.CENTER);
					     rightPanel.add(rightContainerPanel,BorderLayout.CENTER);
						 splHorizontal = new JSplitPane();
					splHorizontal.setDividerSize(6);
					splHorizontal.setLeftComponent(rightPanel);
					splHorizontal.setRightComponent(auftragBestandswarnungsTab);
				centerPanel.add(splHorizontal);
				abfrageListePanel.setBorder(BorderFactory.createBevelBorder(BevelBorder.RAISED));
				abfragePanel.setBorder(BorderFactory.createBevelBorder(BevelBorder.RAISED));
				rightPanel.setBorder(BorderFactory.createBevelBorder(BevelBorder.RAISED));
				
				terminPanel = new JPanel(new BorderLayout());
				lblTermine=new JLabel();
					lblTermine.setText(" ");
					lblTermine.setIcon(terminLabel);
					lblTermine.addMouseListener(new MouseListener()
					 {
						public void mouseClicked(MouseEvent arg0) {
							showKalenderAction();
						}
		
						public void mouseEntered(MouseEvent arg0) {
						}
		
						public void mouseExited(MouseEvent arg0) {
						}
						public void mousePressed(MouseEvent arg0) {
						}
						public void mouseReleased(MouseEvent arg0) {
					}});
					terminPanel.add(lblTermine,BorderLayout.CENTER);
					lblAnfragen=new JLabel();
						lblAnfragen.setText(" ");
						lblAnfragen.setIcon(anfragenLabel);
						lblAnfragen.addMouseListener(new MouseListener()
						 {
							public void mouseClicked(MouseEvent arg0) {
								showAuftragslisteAnfragenAction();
							}
			
							public void mouseEntered(MouseEvent arg0) {
							}
			
							public void mouseExited(MouseEvent arg0) {
							}
							public void mousePressed(MouseEvent arg0) {
							}
							public void mouseReleased(MouseEvent arg0) {
						}});
					terminPanel.add(lblAnfragen,BorderLayout.WEST);
					lblTimeout = new JLabel();
					terminPanel.add(lblTimeout,BorderLayout.EAST);
				mainPanel.add(terminPanel,BorderLayout.SOUTH);
				mainPanel.add(centerPanel,BorderLayout.CENTER);
		        cmbAbfrageModus.addItem(rz.getLocale().getString("auswahl.modus_muster"));
		        cmbAbfrageModus.addItem(rz.getLocale().getString("auswahl.modus_verwendung"));
		        cmbAbfrageModus.addItem(rz.getLocale().getString("auswahl.modus_nummer"));
		        cmbAbfrageModus.addItem(rz.getLocale().getString("auswahl.modus_tank"));
		        cmbAbfrageModus.addItem(rz.getLocale().getString("auswahl.modus_ean"));
		        cmbAbfrageModus.addItem(rz.getLocale().getString("auswahl.modus_artikelnummer"));


		       cmbSort.addItem(rz.getLocale().getString("auswahl.label_sort_alpha_asc"));
		       cmbSort.addItem(rz.getLocale().getString("auswahl.label_sort_alpha_desc"));
		       cmbSort.addItem(rz.getLocale().getString("auswahl.label_sort_date_asc"));
		       cmbSort.addItem(rz.getLocale().getString("auswahl.label_sort_date_desc"));
				
		this.getContentPane().setLayout(new BorderLayout());
		this.getContentPane().add(mainPanel,BorderLayout.CENTER);
        this.addComponentListener(new ComponentListener() {

			@Override
			public void componentResized(ComponentEvent e) {
			}

			@Override
			public void componentMoved(ComponentEvent e) {
			}

			@Override
			public void componentShown(ComponentEvent e) {
				tblAuftragsliste.setGridColor(Color.BLACK);
				tblAuftragsliste.setShowGrid(true);
	    		tblErgebnis.setShowGrid(true);
    			tblErgebnis.setGridColor(rz.getOptionFactory().getColor(OptionFactory.COLOR_VISIBLE_GRID));
				dragging = false;
				dragCursor = null;
				dragSource = null;
				dragDest = null;
				tblAuftragsliste.setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
				
			}

			@Override
			public void componentHidden(ComponentEvent e) {
			}
        	
        });
	}

	public void setWindowCaption() {
	    setTitle(rz.getVersionString() + " " + rz.getLocale().getString("auswahl.titel") + "  " + rz.getLocale().getString("benutzer")+" " + rz.getDatabase().dbGetUser() + " " + rz.getDatabase().getKalender().getDatum20Now());
        lblHistory.setText(rz.getLocale().getString("auswahl.label_history").replaceAll("%u",rz.getDatabase().dbGetUser()));
        getHistory();
        auftragBestandswarnungsTab.setSelectedIndex(rz.getOptionFactory().getOption("auswahl.tab1_state",0));
        switch(auftragBestandswarnungsTab.getSelectedIndex()) {
        	case 0:
        		this.bestandsWarnungsAction();
        		break;
        	case 1:
        		this.auftragslisteAction();
        		break;
        	case 2:
        		this.anfragenlisteAction();
        		break;
        }
        
	}

	/** die GUI-Komponenten mit Texten usw. versehen...
	 *
	 */
	public void setGUIComponents() {
		setWindowCaption();
        mnuNeu.add(getAction(ACTION_NEUE_NOTIZ_CODE));
        mnuNeu.add(getAction(ACTION_NEUE_NOTIZ_GRUPPE_CODE));
        mnuNeu.add(getAction(ACTION_NEUE_REZEPTUR_CODE));
        mnuNeu.add(getAction(ACTION_NEUE_REZEPTUR_GRUPPE_CODE));
        mnuNeu.add(getAction(ACTION_NEUE_AUSSTATTUNG_CODE));
        mnuNeu.add(getAction(ACTION_NEUE_AUSSTATTUNG_GRUPPE_CODE));

        mnuDatei.add(getAction(ACTION_DRUCKEN_CODE));
        mnuDatei.addSeparator();
        mnuDatei.add(getAction(ACTION_LISTE_DRUCKEN_CODE));
        mnuDatei.addSeparator();
        mnuDatei.add(getAction(ACTION_BESTANDSLISTENDRUCK_CODE));
        mnuDatei.addSeparator();
        mnuDatei.add(getAction(ACTION_QUIT_CODE));

        mnuBearbeiten.add(getAction(ACTION_BEARBEITEN_CODE));
        mnuBearbeiten.add(getAction(ACTION_HINWEIS_CODE));
        mnuBearbeiten.add(getAction(ACTION_CALC_CODE));
        mnuBearbeiten.add(getAction(ACTION_AUFSTAERKEN_CODE));
        mnuBearbeiten.add(getAction(ACTION_HERABSETZEN_CODE));
        mnuBearbeiten.addSeparator();
        mnuBearbeiten.add(getAction(ACTION_DUPLICATE_CODE));
        mnuBearbeiten.addSeparator();
        mnuBearbeiten.add(getAction(ACTION_VERWENDUNG_CODE));
        mnuBearbeiten.add(getAction(ACTION_VERWENDUNG_EINZELN_CODE));
        mnuBearbeiten.add(getAction(ACTION_ZUTATEN_CODE));
        mnuBearbeiten.add(getAction(ACTION_ZUTATEN_ALLE_CODE));
        mnuBearbeiten.add(getAction(ACTION_UND_GRUPPE_CODE));
        mnuBearbeiten.add(getAction(ACTION_ODER_GRUPPE_CODE));
        mnuBearbeiten.add(getAction(ACTION_ADRESSEN_CODE));
        mnuBearbeiten.add(getAction(ACTION_ADRESSEN_GRUPPE_CODE));
        mnuBearbeiten.addSeparator();
        mnuBearbeiten.add(getAction(ACTION_AUTOCALC_CODE));
        mnuBearbeiten.add(getAction(ACTION_AUTOCALC_SINGLE_CODE));
        mnuBearbeiten.add(getAction(ACTION_DEPENDENCY_CALC_CODE));
        mnuBearbeiten.addSeparator();
        mnuBearbeiten.add(getAction(ACTION_REZEPTUR_DRUCKEN_CODE));
        mnuBearbeiten.add(getAction(ACTION_KALKULATION_DRUCKEN_CODE));
        mnuBearbeiten.add(getAction(ACTION_SPEZIFIKATION_DRUCKEN_CODE));
        mnuBearbeiten.add(getAction(ACTION_SPEZIFIKATION_PDF_CODE));
        mnuBearbeiten.add(getAction(ACTION_SPEZIFIKATION_DRUCKEN_KOMPLETT_CODE));
        mnuBearbeiten.add(getAction(ACTION_SPEZIFIKATION_PDF_KOMPLETT_CODE));
        mnuBearbeiten.add(getAction(ACTION_ZUTATENVERZEICHNIS_DRUCKEN_CODE));
        mnuBearbeiten.addSeparator();
        mnuBearbeiten.add(getAction(ACTION_SHOW_CHANGES_CODE));
        mnuBearbeiten.addSeparator();
        mnuBearbeiten.add(getAction(ACTION_REZEPTUR_DRUCKEN_LISTE_CODE));
        mnuBearbeiten.addSeparator();
        mnuBearbeiten.add(getAction(ACTION_DATENBLATT_CODE));
        mnuBearbeiten.addSeparator();
        mnuBearbeiten.add(getAction(ACTION_PROBE_NEU_CODE));
        mnuBearbeiten.addSeparator();
        mnuBearbeiten.add(getAction(ACTION_BESTELLUNG_CODE));
        mnuBearbeiten.addSeparator();
        mnuBearbeiten.add(getAction(ACTION_CONTAINER_RETURN_CODE));
        mnuBearbeiten.addSeparator();
        mnuBearbeiten.add(getAction(ACTION_TEMPERATURZONEN_CODE));
        mnuBearbeiten.addSeparator();
        mnuBearbeiten.add(getAction(ACTION_SHOW_AUFTRAG_CODE));
        mnuBearbeiten.addSeparator();
        mnuBearbeiten.add(getAction(ACTION_VERGLEICH_1_CODE));
        mnuBearbeiten.add(getAction(ACTION_VERGLEICH_2_CODE));
        mnuBearbeiten.addSeparator();
        mnuBearbeiten.add(getAction(ACTION_LOESCHEN_CODE));
        mnuBearbeiten.add(getAction(ACTION_DOKUMENTE_CODE));
        mnuBearbeiten.add(getAction(ACTION_DOKUMENTE_ALLE_CODE));
        
        mnuNavigation.add(getAction(ACTION_NAVIGATION_SAVED_CODE));
        mnuNavigation.add(getAction(ACTION_NAVIGATION_MUSTER_CODE));
        mnuNavigation.add(getAction(ACTION_NAVIGATION_ERGEBNIS_CODE));

        mnuBuchung.add(getAction(ACTION_ZUGANG_CODE));
        mnuBuchung.add(getAction(ACTION_ABGANG_CODE));
        mnuBuchung.addSeparator();
        mnuBuchung.add(getAction(ACTION_STATISTIK_EINZELN_CODE));
        mnuBuchung.add(getAction(ACTION_STATISTIK_GRUPPE_CODE));
        mnuBuchung.addSeparator();
        mnuBuchung.add(getAction(ACTION_STATISTIK_BESTAND_CODE));
        mnuBuchung.add(getAction(ACTION_STATISTIK_BESTAND_GRUPPE_CODE));
        mnuBuchung.addSeparator();
        mnuBuchung.add(getAction(ACTION_VERBRAUCH_CODE));
        mnuBuchung.add(getAction(ACTION_VERBRAUCH_LISTE_CODE));

        mnuAbfragen.add(getAction(ACTION_ABFRAGE_NEU_CODE));
        mnuAbfragen.add(getAction(ACTION_ABFRAGE_AUSFUEHREN_CODE));
        mnuAbfragen.add(getAction(ACTION_ABFRAGE_SPEICHERN_CODE));
        mnuAbfragen.addSeparator();
        mnuAbfragen.add(getAction(ACTION_ABFRAGE_REFRESH_CODE));

        mnuAbfragen.addSeparator();
        mnuAbfragen.add(getAction(ACTION_ABFRAGE_LOESCHEN_CODE));
        mnuAbfragen.addSeparator();
        mnuAbfragen.add(getAction(ACTION_ABFRAGE_USE_CODE));
        mnuAbfragen.add(getAction(ACTION_ABFRAGE_GO_CODE));
        mnuAbfragen.add(getAction(ACTION_ABFRAGE_ERWEITERT_CODE));
        mnuAbfragen.addSeparator();
        mnuAbfragen.add(getAction(ACTION_ABFRAGE_ADRESSEN_CODE));
        mnuAbfragen.add(getAction(ACTION_ABFRAGE_ADRESSEN_LOESCHEN_CODE));
        mnuAbfragen.add(getAction(ACTION_ABFRAGE_STICHWORTE_CODE));
        mnuAbfragen.add(getAction(ACTION_ABFRAGE_STICHWORTE_LOESCHEN_CODE));
        mnuAbfragen.addSeparator();

        mnuExtras.add(getAction(ACTION_HIDE_CODE));

        mnuFenster.add(getAction(ACTION_ADRESSFENSTER_CODE));
        mnuFenster.add(getAction(ACTION_LAGER_CODE));
        mnuFenster.add(getAction(ACTION_BEHAELTER_CODE));
        mnuFenster.add(getAction(ACTION_LIEFERSCHEIN_CODE));
        mnuFenster.add(getAction(ACTION_LIEFERSCHEIN_LISTE_CODE));
        mnuFenster.add(getAction(ACTION_ETIKETTEN_CODE));
        mnuFenster.add(getAction(ACTION_ADD_ETIKETTENLISTE_CODE));
        mnuFenster.add(getAction(ACTION_AUSBEUTE_CODE));
        mnuFenster.add(getAction(ACTION_TAFEL_CODE));
        mnuFenster.add(getAction(ACTION_VERLAUF_CODE));
        mnuFenster.add(getAction(ACTION_HERSTELLFENSTER_CODE));
        mnuFenster.add(getAction(ACTION_PALETTEN_CODE));
        mnuFenster.add(getAction(ACTION_PALETTENRECHNER_CODE));
        mnuFenster.add(getAction(ACTION_INVENTUR_CODE));
        mnuFenster.add(getAction(ACTION_ACIDLISTE_CODE));
        mnuFenster.add(getAction(ACTION_ACIDRECHNER_CODE));
        mnuFenster.add(getAction(ACTION_DEKLARATIONEN_CODE));
        mnuFenster.add(getAction(ACTION_BESTELLUNGSLISTENFENSTER_CODE));
        mnuFenster.add(getAction(ACTION_LABORWERTLISTE_CODE));
        mnuFenster.add(getAction(ACTION_PROBE_CODE));
        mnuFenster.add(getAction(ACTION_ZUTATENVERZEICHNIS_EINSTELLUNGEN_CODE));
        mnuFenster.add(getAction(ACTION_GEWICHT_CODE));
        mnuFenster.add(getAction(ACTION_SHOW_LOSNUMMER_VORLAGE_CODE));
        mnuFenster.add(getAction(ACTION_SHOW_KALENDER_CODE));
        mnuFenster.add(getAction(ACTION_SHOW_CHANGES_LISTE_CODE));
        mnuFenster.add(getAction(ACTION_SHOW_MHD_CODE));
        mnuFenster.add(getAction(ACTION_SHOW_KONFORM_CODE));
        mnuFenster.add(getAction(ACTION_SHOW_AUFTRAGSLISTE_CODE));
        mnuFenster.add(getAction(ACTION_SHOW_TANKLISTE_CODE));
        mnuFenster.add(getAction(ACTION_SHOW_MISCHUNGSFENSTER_CODE));
        mnuFenster.add(getAction(ACTION_SHOW_BEWERTUNGEN_CODE));
        mnuFenster.add(getAction(ACTION_ZUTATENLISTE_CODE));
        mnuFenster.add(getAction(ACTION_DRUCKFORMULARE_CODE));
        mnuFenster.add(getAction(ACTION_CONTENT_CODE));
        mnuFenster.add(getAction(ACTION_SHOW_KONTRAKTE_CODE));
        mnuFenster.addSeparator();
        mnuFenster.add(getAction(ACTION_DOKUMENTE_FILTER_CODE));
        mnuFenster.addSeparator();
        mnuFenster.add(getAction(ACTION_KALKULATION_CODE));
        mnuFenster.addSeparator();
        mnuFenster.add(getAction(ACTION_EINSTELLUNGSFENSTER_CODE));
        mnuFenster.addSeparator();
        if(rz.getDatabase().getDM().isConnected()) {
        	mnuFenster.add(getAction(ACTION_SHOW_DMLISTE_CODE));
        }
        mnuFenster.add(getAction(ACTION_LOGGING_CODE));


       mnuHilfe.add(getAction(ACTION_HILFE_CODE));
       mnuHilfe.addSeparator();
       mnuHilfe.add(getAction(ACTION_ABOUT_CODE));

       for(int i=0;i <=DBAuftrag.PRIORITY_MAX;i++) { 
    	   mnuPriorityA.add(new priorityAction(rz,this,ACTION_PRIORITY_CODE,String.valueOf(i)));
    	   mnuPriorityAN.add(new priorityAction(rz,this,ACTION_PRIORITY_CODE,String.valueOf(i)));
    	   mnuPriorityAA.add(new priorityAction(rz,this,ACTION_PRIORITY_CODE,String.valueOf(i)));
    	   mnuPriorityAAN.add(new priorityAction(rz,this,ACTION_PRIORITY_CODE,String.valueOf(i)));
       }
       
       mnuContextAuftrag.add(getAction(ACTION_AUFTRAG_SUCHEN_CODE));
       mnuContextAuftrag.add(getAction(ACTION_AUFTRAG_ANZEIGEN_CODE));
       mnuContextAuftrag.add(getAction(ACTION_AUFTRAG_RECHNEN_CODE));
       mnuContextAuftrag.add(getAction(ACTION_AUFTRAG_STATUS_CODE));
       mnuContextAuftrag.add(getAction(ACTION_AUFTRAG_ENTFERNEN_CODE));
       mnuContextAuftrag.addSeparator();
       mnuContextAuftrag.add(getAction(ACTION_AUFTRAG_LOESCHEN_CODE));
       mnuContextAuftrag.addSeparator();
       mnuContextAuftrag.add(mnuPriorityA);
       
       
       mnuContextAuftragNoDelete.add(getAction(ACTION_AUFTRAG_SUCHEN_CODE));
       mnuContextAuftragNoDelete.add(getAction(ACTION_AUFTRAG_ANZEIGEN_CODE));
       mnuContextAuftragNoDelete.add(getAction(ACTION_AUFTRAG_RECHNEN_CODE));
       mnuContextAuftragNoDelete.add(getAction(ACTION_AUFTRAG_STATUS_CODE));
       mnuContextAuftragNoDelete.add(getAction(ACTION_AUFTRAG_ENTFERNEN_CODE));
       mnuContextAuftragNoDelete.addSeparator();
       mnuContextAuftragNoDelete.add(mnuPriorityAN);
       
       mnuContextArbeitsAuftrag.add(getAction(ACTION_AUFTRAG_ANZEIGEN_CODE));
       mnuContextArbeitsAuftrag.add(getAction(ACTION_AUFTRAG_ENTFERNEN_CODE));
       mnuContextArbeitsAuftrag.add(getAction(ACTION_AUFTRAG_STATUS_CODE));
       mnuContextArbeitsAuftrag.addSeparator();
       mnuContextArbeitsAuftrag.add(getAction(ACTION_AUFTRAG_LOESCHEN_CODE));
       mnuContextArbeitsAuftrag.addSeparator();
       mnuContextArbeitsAuftrag.add(mnuPriorityAA);
       
       mnuContextArbeitsAuftragNoDelete.add(getAction(ACTION_AUFTRAG_ANZEIGEN_CODE));
       mnuContextArbeitsAuftragNoDelete.add(getAction(ACTION_AUFTRAG_ENTFERNEN_CODE));
       mnuContextArbeitsAuftragNoDelete.add(getAction(ACTION_AUFTRAG_STATUS_CODE));
       mnuContextArbeitsAuftragNoDelete.addSeparator();
       mnuContextArbeitsAuftragNoDelete.add(mnuPriorityAAN);
       
        tb1.add(getAction(ACTION_QUIT_CODE));
        tb1.add(getAction(ACTION_HIDE_CODE));
        tb1.addSeparator();
        tb1.add(getAction(ACTION_BEARBEITEN_CODE));
        tb1.add(getAction(ACTION_HINWEIS_CODE));
        tb1.add(getAction(ACTION_CALC_CODE));
        tb1.add(getAction(ACTION_AUFSTAERKEN_CODE));
        tb1.add(getAction(ACTION_HERABSETZEN_CODE));
        tb1.addSeparator();
        tb1.add(getAction(ACTION_DUPLICATE_CODE));
        tb1.addSeparator();
        tb1.add(getAction(ACTION_REZEPTUR_DRUCKEN_CODE));
        tb1.add(getAction(ACTION_KALKULATION_DRUCKEN_CODE));
        tb1.add(getAction(ACTION_SPEZIFIKATION_DRUCKEN_CODE));
        tb1.add(getAction(ACTION_SPEZIFIKATION_PDF_CODE));
        tb1.add(getAction(ACTION_SPEZIFIKATION_DRUCKEN_KOMPLETT_CODE));
        tb1.add(getAction(ACTION_SPEZIFIKATION_PDF_KOMPLETT_CODE));
        tb1.add(getAction(ACTION_ZUTATENVERZEICHNIS_DRUCKEN_CODE));
        tb1.add(getAction(ACTION_DATENBLATT_CODE));
        tb1.add(getAction(ACTION_BESTELLUNG_CODE));
        tb1.add(getAction(ACTION_PROBE_NEU_CODE));
        tb1.addSeparator();
        tb1.add(getAction(ACTION_LOESCHEN_CODE));
        tb1.addSeparator();
        tb1.add(getAction(ACTION_NEUE_NOTIZ_CODE));
        tb1.add(getAction(ACTION_NEUE_NOTIZ_GRUPPE_CODE));
        tb1.add(getAction(ACTION_NEUE_REZEPTUR_CODE));
        tb1.add(getAction(ACTION_NEUE_REZEPTUR_GRUPPE_CODE));
        tb1.add(getAction(ACTION_NEUE_AUSSTATTUNG_CODE));
        tb1.add(getAction(ACTION_NEUE_AUSSTATTUNG_GRUPPE_CODE));
        tb1.addSeparator();
        tb1.add(getAction(ACTION_VERWENDUNG_CODE));
        tb1.add(getAction(ACTION_VERWENDUNG_EINZELN_CODE));
        tb1.add(getAction(ACTION_ZUTATEN_CODE));
        tb1.add(getAction(ACTION_ZUTATEN_ALLE_CODE));        
        tb1.add(getAction(ACTION_UND_GRUPPE_CODE));
        tb1.add(getAction(ACTION_ODER_GRUPPE_CODE));
        tb1.add(getAction(ACTION_ADRESSEN_CODE));
        tb1.add(getAction(ACTION_ADRESSEN_GRUPPE_CODE));
        tb1.add(getAction(ACTION_CONTENT_CODE));
        tb1.addSeparator();
        tb1.add(getAction(ACTION_SHOW_AUFTRAG_CODE));
        tb1.add(getAction(ACTION_TEMPERATURZONEN_CODE));
        tb1.addSeparator();
        tb1.add(getAction(ACTION_VERGLEICH_1_CODE));
        tb1.add(getAction(ACTION_VERGLEICH_2_CODE));
        tb1.addSeparator();
        tb1.add(getAction(ACTION_DRUCKEN_CODE));
        tb1.addSeparator();
        tb1.add(getAction(ACTION_ABOUT_CODE));

        tb2.add(getAction(ACTION_CONTAINER_RETURN_CODE));
        tb2.add(getAction(ACTION_BESTELLUNGSLISTENFENSTER_CODE));
        tb2.add(getAction(ACTION_ZUTATENVERZEICHNIS_EINSTELLUNGEN_CODE));
        tb2.add(getAction(ACTION_PROBE_CODE));
        tb2.add(getAction(ACTION_LABORWERTLISTE_CODE));
        tb2.add(getAction(ACTION_ACIDLISTE_CODE));
        tb2.add(getAction(ACTION_ACIDRECHNER_CODE));
        tb2.add(getAction(ACTION_INVENTUR_CODE));
        tb2.add(getAction(ACTION_DEKLARATIONEN_CODE));
        tb2.add(getAction(ACTION_KALKULATION_CODE));
        tb2.add(getAction(ACTION_ADRESSFENSTER_CODE));
        tb2.add(getAction(ACTION_SHOW_TANKLISTE_CODE));
        tb2.add(getAction(ACTION_SHOW_MISCHUNGSFENSTER_CODE));
        tb2.add(getAction(ACTION_SHOW_BEWERTUNGEN_CODE));
        tb2.add(getAction(ACTION_LAGER_CODE));
        tb2.add(getAction(ACTION_BEHAELTER_CODE));
        tb2.add(getAction(ACTION_PALETTEN_CODE));
        tb2.add(getAction(ACTION_PALETTENRECHNER_CODE));
        tb2.add(getAction(ACTION_ETIKETTEN_CODE));
        tb2.add(getAction(ACTION_ADD_ETIKETTENLISTE_CODE));
        tb2.add(getAction(ACTION_AUSBEUTE_CODE));
        tb2.add(getAction(ACTION_LIEFERSCHEIN_CODE));
        tb2.add(getAction(ACTION_LIEFERSCHEIN_LISTE_CODE));
        tb2.add(getAction(ACTION_EINSTELLUNGSFENSTER_CODE));
        tb2.add(getAction(ACTION_SHOW_LOSNUMMER_VORLAGE_CODE));
        tb2.add(getAction(ACTION_TAFEL_CODE));
        tb2.add(getAction(ACTION_VERLAUF_CODE));
        tb2.add(getAction(ACTION_GEWICHT_CODE));
        tb2.add(getAction(ACTION_SHOW_CHANGES_LISTE_CODE));
        tb2.add(getAction(ACTION_SHOW_MHD_CODE));
        tb2.add(getAction(ACTION_SHOW_KONFORM_CODE));
        tb2.add(getAction(ACTION_SHOW_KALENDER_CODE));
        tb2.add(getAction(ACTION_SHOW_AUFTRAGSLISTE_CODE));
        tb2.add(getAction(ACTION_DOKUMENTE_FILTER_CODE));
        tb2.add(getAction(ACTION_DOKUMENTE_CODE));
        tb2.add(getAction(ACTION_DOKUMENTE_ALLE_CODE));
        tb2.add(getAction(ACTION_SHOW_KONTRAKTE_CODE));
        if(rz.getDatabase().getDM().isConnected()) {
        	tb2.add(getAction(ACTION_SHOW_DMLISTE_CODE));
        }
        tb2.add(getAction(ACTION_HERSTELLFENSTER_CODE));


        tb3.add(getAction(ACTION_ZUGANG_CODE));
        tb3.add(getAction(ACTION_ABGANG_CODE));
        tb3.addSeparator();
        tb3.add(getAction(ACTION_STATISTIK_EINZELN_CODE));
        tb3.add(getAction(ACTION_STATISTIK_GRUPPE_CODE));
        tb3.addSeparator();
        tb3.add(getAction(ACTION_STATISTIK_BESTAND_CODE));
        tb3.add(getAction(ACTION_STATISTIK_BESTAND_GRUPPE_CODE));
        tb3.addSeparator();
        tb3.add(getAction(ACTION_VERBRAUCH_CODE));
        tb3.add(getAction(ACTION_VERBRAUCH_LISTE_CODE));
        tb3.addSeparator();
        tb3.add(getAction(ACTION_AUTOCALC_SINGLE_CODE));
        tb3.add(getAction(ACTION_AUTOCALC_CODE));
        tb3.add(getAction(ACTION_DEPENDENCY_CALC_CODE));

        
        auftragBestandswarnungsTab.setTitleAt(0,rz.getLocale().getString("auswahl.panel_bestandswarnungen"));
        auftragBestandswarnungsTab.setTitleAt(1,rz.getLocale().getString("auswahl.panel_auftragsliste"));
        auftragBestandswarnungsTab.setTitleAt(2,rz.getLocale().getString("auswahl.panel_anfragenliste"));
        
        btVerbrauch.setAction(getAction(ACTION_VERBRAUCH_CODE));
        getAction(ACTION_VERBRAUCH_CODE).setEnabled(false);
        btVerbrauchListe.setAction(getAction(ACTION_VERBRAUCH_LISTE_CODE));
        getAction(ACTION_VERBRAUCH_LISTE_CODE).setEnabled(false);
        
        btAuftragslisteDrucken.setAction(getAction(ACTION_AUFTRAGSLISTE_DRUCKEN_CODE));
        btAuftragslisteEigeneDrucken.setAction(getAction(ACTION_AUFTRAGSLISTE_DRUCKEN_EIGENE_CODE));
        btAuftragslisteRefresh.setAction(getAction(ACTION_AUFTRAGSLISTE_REFRESH_CODE));
        btAuftragslisteBearbeiten.setAction(getAction(ACTION_SHOW_AUFTRAGSLISTE_CODE));
        
        btAnfragenlisteDrucken.setAction(getAction(ACTION_ANFRAGENLISTE_DRUCKEN_CODE));
        btAnfragenlisteRefresh.setAction(getAction(ACTION_ANFRAGENLISTE_REFRESH_CODE));
        btAnfragenlisteBearbeiten.setAction(getAction(ACTION_SHOW_ANFRAGENLISTE_CODE));

        mnuDatei.setText(rz.getLocale().getString("menu.datei"));
        mnuBuchung.setText(rz.getLocale().getString("menu.buchung"));
        mnuNavigation.setText(rz.getLocale().getString("menu.navigation"));
        mnuAbfragen.setText(rz.getLocale().getString("menu.abfragen"));
        mnuFenster.setText(rz.getLocale().getString("menu.fenster"));
        mnuExtras.setText(rz.getLocale().getString("menu.extras"));
        mnuNeu.setText(rz.getLocale().getString("menu.neu"));
        mnuBearbeiten.setText(rz.getLocale().getString("menu.bearbeiten"));
        mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));

        lblAbfragelisteTitel.setText(rz.getLocale().getString("auswahl.label_saved_queries"));
        lblAdressenTitel.setText(rz.getLocale().getString("auswahl.label_adressen_titel"));
        lblStichworteTitel.setText(rz.getLocale().getString("auswahl.label_stichworte_titel"));
        lblErgebnisTitel.setText(rz.getLocale().getString("auswahl.label_ergebnis_titel"));
        lblAuftragslisteTitel.setText(rz.getLocale().getString("auswahl.label_auftragsliste_titel"));

        lblBestandswarnung.setText(rz.getLocale().getString("auswahl.label_bestandswarnung_titel"));
        lblBestandswarnung_text1.setText(rz.getLocale().getString("auswahl.label_bestandswarnung_interval_1"));
        lblBestandswarnung_text2.setText(rz.getLocale().getString("auswahl.label_bestandswarnung_interval_2"));
        lblAuftragsliste_text1.setText(rz.getLocale().getString("auswahl.label_auftragsliste_interval_1"));
        lblAuftragsliste_text2.setText(rz.getLocale().getString("auswahl.label_auftragsliste_interval_2"));
        lblanfragenliste_text1.setText(rz.getLocale().getString("auswahl.label_anfragenliste_interval_1"));
        lblanfragenliste_text2.setText(rz.getLocale().getString("auswahl.label_anfragenliste_interval_2"));
        
        
        lblBestandsWarnungStichwort.setText(rz.getLocale().getString("auswahl.label_bestandswarnung.stichwort"));
        chkBestandZutaten.setText(rz.getLocale().getString("auswahl.label_bestandswarnung_zutaten"));
        chkBestandZutaten.setSelected(rz.getOptionFactory().getOption("bestandswarnung.zutaten",0)==1?true:false);
        chkBestandBuchungen.setText(rz.getLocale().getString("auswahl.label_bestandswarnung_buchung"));
        chkBestandZutaten.setSelected(rz.getOptionFactory().getOption("bestandswarnung.buchung",0)==1?true:false);
        lblBestandBuchungen.setText(rz.getLocale().getString("auswahl.label_bestandswarnung_buchung_color")
        		.replaceAll("%0",rz.getOptionFactory().getOption("bestandswarnung.status_color_0"))
        		.replaceAll("%1",rz.getOptionFactory().getOption("bestandswarnung.status_color_1"))
        		.replaceAll("%2",rz.getOptionFactory().getOption("bestandswarnung.status_color_2"))
        		.replaceAll("%3",rz.getOptionFactory().getOption("bestandswarnung.status_color_3"))
        );
        chkAblage.setText(rz.getLocale().getString("auswahl.label_ablage"));
        
        chkListendruckBestandOnly.setText(rz.getLocale().getString("auswahl.bestandslistendruck_bestand_only"));
        
        btAdressenModeAnd.setText(rz.getLocale().getString("auswahl.label_mode_and"));
        btAdressenModeOr.setText(rz.getLocale().getString("auswahl.label_mode_or"));
        btBestandsWarnungStichwortAuswahl.setAction(getAction(ACTION_BESTANDSWARNUNG_AUSWAHL_CODE));
        btBestandsWarnungStichwortClear.setAction(getAction(ACTION_BESTANDSWARNUNG_CLEAR_CODE));
        
        btAdressenBearbeiten.setAction(getAction(ACTION_ABFRAGE_ADRESSEN_CODE));
        btAdressenLoeschen.setAction(getAction(ACTION_ABFRAGE_ADRESSEN_LOESCHEN_CODE));
        btAdressenModeAnd.setActionCommand(String.valueOf(DBAbfrage.ABFRAGE_MODE_AND));
        btAdressenModeOr.setActionCommand(String.valueOf(DBAbfrage.ABFRAGE_MODE_OR));
        btStichworteModeAnd.setActionCommand(String.valueOf(DBAbfrage.ABFRAGE_MODE_AND));
        btStichworteModeOr.setActionCommand(String.valueOf(DBAbfrage.ABFRAGE_MODE_OR));
        btStichworteModeAnd.setText(rz.getLocale().getString("auswahl.label_mode_and"));
        btStichworteModeOr.setText(rz.getLocale().getString("auswahl.label_mode_or"));
        btStichworteBearbeiten.setAction(getAction(ACTION_ABFRAGE_STICHWORTE_CODE));
        btStichworteLoeschen.setAction(getAction(ACTION_ABFRAGE_STICHWORTE_LOESCHEN_CODE));
        btBestandswarnung.setAction(getAction(ACTION_BESTANDSWARNUNG_CODE));
        btZutatenliste.setAction(getAction(ACTION_ZUTATENLISTE_CODE));
        btAuftragSucheButton.setAction(getAction(ACTION_AUFTRAGSLISTE_SUCHEN_CODE));
        btAuftragSucheClearButton.setAction(getAction(ACTION_AUFTRAGSLISTE_SUCHEN_CLEAR_CODE));
        
        lblErgebnisCount.setText(" ");

        btSave.setAction(getAction(ACTION_ABFRAGE_SPEICHERN_CODE));
        btErweitert.setAction(getAction(ACTION_ABFRAGE_ERWEITERT_CODE));
        btUse.setAction(getAction(ACTION_ABFRAGE_USE_CODE));
        btGo.setAction(getAction(ACTION_ABFRAGE_GO_CODE));
        btRefresh.setAction(getAction(ACTION_ABFRAGE_REFRESH_CODE));
        btRemove.setAction(getAction(ACTION_ABFRAGE_LOESCHEN_CODE));
        btPrivate.setAction(getAction(ACTION_ABFRAGE_PRIVAT_CODE));
        btPublic.setAction(getAction(ACTION_ABFRAGE_PUBLIC_CODE));
        btExecuteQuery.setAction(getAction(ACTION_ABFRAGE_AUSFUEHREN_CODE));
        btNeu.setAction(getAction(ACTION_ABFRAGE_NEU_CODE));
        btDrucken.setAction(getAction(ACTION_DRUCKEN_CODE));
        btListendruck.setAction(getAction(ACTION_BESTANDSLISTENDRUCK_CODE));
        btDeleteHistory.setAction(getAction(ACTION_DELETE_HISTORY_CODE));
        btBestandsWarnungDrucken.setAction(getAction(ACTION_BESTANDSWARNUNG_DRUCKEN_CODE));
        btBestandsWarnungUebertragen.setAction(getAction(ACTION_BESTANDSWARNUNG_UEBERTRAGEN_CODE));        
        
        btAnfang.setAction(getAction(ACTION_NAV_ANFANG_CODE));
        btZurueck.setAction(getAction(ACTION_NAV_ZURUECK_CODE));
        btVor.setAction(getAction(ACTION_NAV_VOR_CODE));
        btEnde.setAction(getAction(ACTION_NAV_ENDE_CODE));
        getAction(ACTION_NAV_ENDE_CODE).setEnabled(false);
        getAction(ACTION_NAV_ANFANG_CODE).setEnabled(false);
        getAction(ACTION_NAV_VOR_CODE).setEnabled(false);
        getAction(ACTION_NAV_ZURUECK_CODE).setEnabled(false);
        getAction(ACTION_SHOW_CHANGES_CODE).setEnabled(false);
        getAction(ACTION_CONTENT_CODE).setEnabled(false);
        btMusterSuchen.setAction(getAction(ACTION_MUSTER_SUCHEN_CODE));
        
        lblHistory.setText(rz.getLocale().getString("auswahl.label_history").replaceAll("%u",rz.getDatabase().dbGetUser()));

        chkDuplex.setText(rz.getLocale().getString("auswahl.listendruck.duplex"));

        lstAbfragen.setCellRenderer(new AbfrageListRenderer(rz));

        this.splBestandswarnung.setValue(Integer.valueOf(rz.getOptionFactory().getOption("bestandswarnung.timer")));
        this.splAuftragsliste.setValue(Integer.valueOf(rz.getOptionFactory().getOption("auftragsliste.timer")));
        this.splAnfragenliste.setValue(Integer.valueOf(rz.getOptionFactory().getOption("anfragenliste.timer")));
        
        setResizable(true);
        rz.getFontFactory().setFrameFonts(this);
        auftragBestandswarnungsTab.setSelectedIndex(rz.getOptionFactory().getOption("auswahl.tab1_state",0));
        pack();
        rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;
        setDividerLocations();
        timeoutAction();
        if (!bestandswarnungsTimer.isRunning()) bestandswarnungsTimer.start();
        if (!auftragslisteTimer.isRunning()) auftragslisteTimer.start();
        if (!anfragenlisteTimer.isRunning()) anfragenlisteTimer.start();
	}


	/** speichert die Position der Splitbalken
	 *
	 */

	public Action getAction(int actionCode) {
		return super.getAction(actionCode);
	}

	/** nimmt messages von anderen FRames oder Actions entgegen
	 *
	 */
	public void getMessage(MessageItem msg) {
		//rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE,"auswahlfenster",String.valueOf(msg.getMsgCode()+":"+String.valueOf(msg.getCode())));
		switch (msg.getMsgCode()) {
			case MessageItem.MSG_ACTIONPERFORMED :
				 switch(msg.getCode()){
		          case ACTION_QUIT_CODE: closeWindow();break;
		          case ACTION_HIDE_CODE: hideAction();break;
		          case ACTION_ADRESSFENSTER_CODE: showAdressenAction();break;
		          case ACTION_EINSTELLUNGSFENSTER_CODE: showEinstellungen();break;
		          case ACTION_REPORTFENSTER_CODE: showReports();break;
		          case ACTION_ABFRAGE_AUSFUEHREN_CODE: abfrageAusfuehrenAction();break;
		          case ACTION_ABFRAGE_NEU_CODE: abfrageNeuAction(); break;
		          case ACTION_ABFRAGE_ADRESSEN_CODE : abfrageAdressenAction(); break;
		          case ACTION_ABFRAGE_ADRESSEN_LOESCHEN_CODE : abfrageAdressenLoeschenAction();break;
		          case ACTION_ABFRAGE_STICHWORTE_CODE : abfrageStichworteAction();break;
		          case ACTION_ABFRAGE_STICHWORTE_LOESCHEN_CODE : abfrageStichworteLoeschenAction();break;
		          case ACTION_ABFRAGE_REFRESH_CODE : abfrageRefreshAction();break;
		          case ACTION_ABFRAGE_SPEICHERN_CODE : abfrageSpeichernAction();break;
		          case ACTION_NEUE_NOTIZ_CODE :neueNotizAction();break;
		          case ACTION_ABFRAGE_USE_CODE : abfrageUseAction();break;
		          case ACTION_ABFRAGE_GO_CODE : abfrageGoAction();break;
		          case ACTION_ABFRAGE_LOESCHEN_CODE : abfrageLoeschenAction();break;
		          case ACTION_NAVIGATION_SAVED_CODE : savedNavigationAction();break;
		          case ACTION_NAVIGATION_MUSTER_CODE : musterNavigationAction();break;
		          case ACTION_NAVIGATION_ERGEBNIS_CODE : ergebnisNavigationAction();break;
		          case ACTION_DRUCKEN_CODE : druckenAction();break;
		          case ACTION_LISTE_DRUCKEN_CODE:listeDruckenAction();break;
		          case ACTION_BESTANDSLISTENDRUCK_CODE:bestandslisteDruckenAction();break;
		          case ACTION_BESTANDSWARNUNG_DRUCKEN_CODE:bestandsWarnungDruckenAction();break;
		          case ACTION_BESTANDSWARNUNG_UEBERTRAGEN_CODE:bestandsWarnungUebertragenAction();break;
		          case ACTION_BEARBEITEN_CODE : bearbeitenAction();break;
		          case ACTION_LOESCHEN_CODE : loeschenAction();break;
		          case ACTION_KALKULATION_CODE : showKalkulationAction();break;
		          case ACTION_LAGER_CODE : showLagerAction();break;
		          case ACTION_NEUE_REZEPTUR_CODE : neueRezepturAction();break;
		          case ACTION_VERWENDUNG_CODE : verwendungAction();break;
		          case ACTION_VERWENDUNG_EINZELN_CODE : verwendungEinzelnAction();break;
		          case ACTION_UND_GRUPPE_CODE : undGruppeAction();break;
		          case ACTION_ODER_GRUPPE_CODE : oderGruppeAction();break;
		          case ACTION_ADRESSEN_CODE : adressenAction(ACTION_ADRESSEN_CODE);break;
		          case ACTION_ADRESSEN_GRUPPE_CODE : adressenAction(ACTION_ADRESSEN_GRUPPE_CODE);break;
		          case ACTION_NEUE_REZEPTUR_GRUPPE_CODE : neueRezepturGruppeAction();break;
		          case ACTION_NEUE_NOTIZ_GRUPPE_CODE : neueNotizGruppeAction();break;
		          case ACTION_DUPLICATE_CODE : duplicateAction();break;
		          case ACTION_ZUTATEN_CODE : zutatenAction();break;
		          case ACTION_ZUTATEN_ALLE_CODE: zutatenAlleAction();break;
		          case ACTION_HERABSETZEN_CODE: staerkeAction(0);break;
		          case ACTION_AUFSTAERKEN_CODE: staerkeAction(1);break;
		          case ACTION_CALC_CODE : calcAction();break;
		          case ACTION_HILFE_CODE : hilfeAction();break;
		          case ACTION_LIEFERSCHEIN_CODE:lieferscheinAction();break;
		          case ACTION_LIEFERSCHEIN_LISTE_CODE:lieferscheinListeAction();break;
		          case ACTION_BEHAELTER_CODE:behaelterAction();break;
		          case ACTION_ETIKETTEN_CODE:etikettenAction();break;
		          case ACTION_ADD_ETIKETTENLISTE_CODE:etikettenListeAction();break;
		          case ACTION_TAFEL_CODE: tafelAction();break;
		          case ACTION_ZUGANG_CODE: zugangAction();break;
		          case ACTION_ABGANG_CODE: abgangAction();break;
		          case ACTION_GEWICHT_CODE: gewichtAction();break;
		          case ACTION_STATISTIK_EINZELN_CODE : statistikEinzelnAction(MessageItem.MSG_SHOW_STATISTIK);break;
		          case ACTION_STATISTIK_GRUPPE_CODE : statistikGruppeAction(MessageItem.MSG_SHOW_STATISTIK);break;
		          case ACTION_STATISTIK_BESTAND_CODE : statistikEinzelnAction(MessageItem.MSG_SHOW_STATISTIK_BESTAND);break;
		          case ACTION_STATISTIK_BESTAND_GRUPPE_CODE : statistikGruppeAction(MessageItem.MSG_SHOW_STATISTIK_BESTAND);break;
		          case ACTION_HERSTELLFENSTER_CODE:herstellfensterAction();break;
		          case ACTION_VERLAUF_CODE:verlaufAction();break;
		          case ACTION_LOGGING_CODE:loggingAction();break;
		          case ACTION_ABOUT_CODE:aboutAction();break;
		          case ACTION_AUSBEUTE_CODE:ausbeuteAction();break;
		          case ACTION_HINWEIS_CODE:hinweisAction();break;
		          case ACTION_AUTOCALC_CODE:autoCalcAction(ACTION_AUTOCALC_CODE);break;
		          case ACTION_AUTOCALC_SINGLE_CODE:autoCalcAction(ACTION_AUTOCALC_SINGLE_CODE);break;
		          case ACTION_REZEPTUR_DRUCKEN_CODE:direktDruckAction(ACTION_REZEPTUR_DRUCKEN_CODE);break;
		          case ACTION_REZEPTUR_DRUCKEN_LISTE_CODE:direktDruckListeAction(ACTION_REZEPTUR_DRUCKEN_LISTE_CODE);break;
		          case ACTION_KALKULATION_DRUCKEN_CODE:direktDruckAction(ACTION_KALKULATION_DRUCKEN_CODE);break;
		          case ACTION_SPEZIFIKATION_DRUCKEN_CODE:direktDruckAction(ACTION_SPEZIFIKATION_DRUCKEN_CODE);break;
		          case ACTION_SPEZIFIKATION_PDF_CODE:direktDruckAction(ACTION_SPEZIFIKATION_PDF_CODE);break;
		          case ACTION_SPEZIFIKATION_PDF_KOMPLETT_CODE:direktDruckAction(ACTION_SPEZIFIKATION_PDF_KOMPLETT_CODE);break;
		          case ACTION_SPEZIFIKATION_DRUCKEN_KOMPLETT_CODE:direktDruckAction(ACTION_SPEZIFIKATION_DRUCKEN_KOMPLETT_CODE);break;
		          case ACTION_ZUTATENVERZEICHNIS_DRUCKEN_CODE:direktDruckAction(ACTION_ZUTATENVERZEICHNIS_DRUCKEN_CODE);break;
		          case ACTION_DEPENDENCY_CALC_CODE:dependencyCalcAction();break;
		          case ACTION_PALETTEN_CODE:palettenAction();break;
		          case ACTION_PALETTENRECHNER_CODE:palettenRechnerAction();break;
		          case ACTION_ABFRAGE_ERWEITERT_CODE:abfrageErweitertAction();break;
		          case ACTION_INVENTUR_CODE:inventurAction();break;
		          case ACTION_ACIDLISTE_CODE:acidListeAction();break;
		          case ACTION_ACIDRECHNER_CODE:acidRechnerAction();break;
		          case ACTION_DEKLARATIONEN_CODE:deklarationenAction();break;
		          case ACTION_NEUE_AUSSTATTUNG_CODE:neueAusstattungAction();break;
		          case ACTION_NEUE_AUSSTATTUNG_GRUPPE_CODE:neueAusstattungGruppeAction();break;
		          case ACTION_DATENBLATT_CODE:datenblattAction();break;
		          case ACTION_BESTELLUNG_CODE:bestellungAction();break;
		          case ACTION_BESTELLUNGSLISTENFENSTER_CODE:bestellungsListeAction();break;
		          case ACTION_LABORWERTLISTE_CODE:laborwertListeAction();break;
		          case ACTION_PROBE_CODE:probenAction();break;
		          case ACTION_PROBE_NEU_CODE:probenNeuAction();break;
		          case ACTION_BESTANDSWARNUNG_CODE:bestandsWarnungsAction();break;
		          case ACTION_ZUTATENVERZEICHNIS_EINSTELLUNGEN_CODE:zutatenverzeichnis_einstellungenAction();break;
		          case ACTION_VERBRAUCH_CODE:verbrauchAction();break;
		          case ACTION_VERBRAUCH_LISTE_CODE:verbrauchListeAction();break;
		          case ACTION_CONTAINER_RETURN_CODE:containerReturnAction();break;
		          case ACTION_SHOW_LOSNUMMER_VORLAGE_CODE:losnummerVorlageAction();break;
		          case ACTION_NAV_ANFANG_CODE:
		          case ACTION_NAV_ENDE_CODE:
		          case ACTION_NAV_ZURUECK_CODE:
		          case ACTION_NAV_VOR_CODE:	abfrageNavigation(msg.getCode());
		          	break;
		          case ACTION_DELETE_HISTORY_CODE: deleteHistoryAction();break;
		          case ACTION_ABFRAGE_PRIVAT_CODE: abfrageStatusAction(true);break;
		          case ACTION_ABFRAGE_PUBLIC_CODE: abfrageStatusAction(false);break;
		          case ACTION_SHOW_KALENDER_CODE: showKalenderAction();break;
		          case ACTION_SHOW_AUFTRAG_CODE: showAuftragAction();break;
		          case ACTION_SHOW_AUFTRAGSLISTE_CODE: showAuftragslisteAction();break;
		          case ACTION_AUFTRAGSLISTE_REFRESH_CODE: getAuftragsListeRefresh();break;
		          case ACTION_AUFTRAGSLISTE_DRUCKEN_EIGENE_CODE:
		        	  if(auftragsliste != null && !auftragsliste.isEmpty()) {
		        		  rz.getReportFactory().auftragslistenReport(auftragsliste, true,this);
		        	  }
		        	  break;
		          case ACTION_AUFTRAGSLISTE_DRUCKEN_CODE:
		        	  if(auftragsliste != null && !auftragsliste.isEmpty()) {
		        		  rz.getReportFactory().auftragslistenReport(auftragsliste, false,this);
		        	  }
		        	  break;
		          case ACTION_ANFRAGENLISTE_DRUCKEN_CODE:
		        	  if(anfragenliste != null && !anfragenliste.isEmpty()) {
		        		  rz.getReportFactory().auftragslistenReport(anfragenliste, false,this);
		        	  }
		        	  break;
		          case ACTION_SHOW_ANFRAGENLISTE_CODE: showAnfragenlisteAction();break;
		          case ACTION_ANFRAGENLISTE_REFRESH_CODE: getAnfragenListe();break;
		          case ACTION_SHOW_CHANGES_CODE: showChangesAction();break;
		          case ACTION_SHOW_CHANGES_LISTE_CODE: showChangesListeAction();break;
		          case ACTION_SHOW_MHD_CODE:showMhdAction();break;
		          case ACTION_SHOW_KONFORM_CODE:showKonformAction();break;
		          case ACTION_TEMPERATURZONEN_CODE:showZonenAction();break;
		          case ACTION_SHOW_DMLISTE_CODE:showDMListeAction();break;
		          case ACTION_SHOW_TANKLISTE_CODE:showTankListeAction();break;
		          case ACTION_AUFTRAG_SUCHEN_CODE:auftragSuchenAction();break;
		          case ACTION_AUFTRAG_ANZEIGEN_CODE:auftragAnzeigenAction();break;
		          case ACTION_AUFTRAG_RECHNEN_CODE:auftragRechnenAction();break;
		          case ACTION_AUFTRAG_STATUS_CODE:auftragStatusAction();break;
		          case ACTION_AUFTRAG_ENTFERNEN_CODE:auftragEntfernenAction();break;
		          case ACTION_AUFTRAG_LOESCHEN_CODE:auftragLoeschenAction();break;
		          case ACTION_SHOW_MISCHUNGSFENSTER_CODE:mischungsFensterAction();break;
		          case ACTION_SHOW_BEWERTUNGEN_CODE:bewertungenAction();break;
		          case ACTION_PRIORITY_CODE:priorityAction(msg.getData());break;
		          case ACTION_VERGLEICH_1_CODE:vergleichAction(false);break;
		          case ACTION_VERGLEICH_2_CODE:vergleichAction(true);break;
		          case ACTION_BESTANDSWARNUNG_AUSWAHL_CODE:bestandsWarnungAuswahlAction();break;
		          case ACTION_BESTANDSWARNUNG_CLEAR_CODE:bestandsWarnungClearAction();break;
		          case ACTION_DRUCKFORMULARE_CODE:druckFormulareAction();break;
		          case ACTION_ZUTATENLISTE_CODE:zutatenListeAction();break;
		          case ACTION_MUSTER_SUCHEN_CODE:musterSuchenAction();break;
		          case ACTION_DOKUMENTE_CODE:dokumenteAction();break;
		          case ACTION_DOKUMENTE_ALLE_CODE:dokumenteAlleAction();break;
		          case ACTION_DOKUMENTE_FILTER_CODE:dokumenteFilterAction();break;
		          case ACTION_CONTENT_CODE:contentAction();break;
		          case ACTION_AUFTRAGSLISTE_SUCHEN_CODE:auftragsListeSuchenAction();break;
		          case ACTION_AUFTRAGSLISTE_SUCHEN_CLEAR_CODE:auftragsListeSuchenClearAction();break;
		          case ACTION_SHOW_KONTRAKTE_CODE:kontrakteAction(0);break;

		          default:
		              rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "auswahl:", "auswahlAction:" + msg.getCode());
		              break;
				}
			break;
		case MessageItem.MSG_ZUTATEN_DIALOG_REPLY :
			zutatenDialogReply((ZutatenSuchItem) msg.getData());
			break;
			
		case MessageItem.MSG_CLEAR_VERGLEICH:
			getAction(ACTION_VERGLEICH_2_CODE).setEnabled(false);
			getAction(ACTION_VERGLEICH_1_CODE).setEnabled(true);
			break;
		case MessageItem.MSG_GET_STICHWORTE_REPLY:
			StichwortListe reply = (StichwortListe)msg.getData();
			if(reply !=null) {
				rz.getOptionFactory().setOption("auswahl.bestandswarnungen.exclude", reply.toString());
				rz.getOptionFactory().saveOptions();
			}
			bestandsWarnungsAction();
			break;
	    case MessageItem.MSG_PROPAGATE_PROBEN:
		case MessageItem.MSG_REFRESH_AUSGABE:
			refreshAusgabe(msg);
			break;
         case MessageItem.MSG_ADD_QUERY_ABGANG:
	     case MessageItem.MSG_ADD_QUERY_ZUGANG:
		 case MessageItem.MSG_ADD_QUERY_NOTIZ:
		 case MessageItem.MSG_ADD_QUERY_REZEPT: 
		 case MessageItem.MSG_ABFRAGE_ERWEITERT_REPLY:
		 case MessageItem.MSG_ADD_MHD_ABFRAGE:
			 if(msg.getCode() != 0) {
				 refreshTable(msg.getCode(),false);
			 }
			 if (msg.getData() != null) {
			     abfrage = (AbfrageItem)msg.getData();
				 if(!refreshTable(abfrage.getID(),true)) {
					 addAbfrage(abfrage);
				 }
		 	     tblErgebnis.requestFocus();
		 	     this.setVisible(true);
			 	 this.toFront();
			 }
			 saveHistory();
		     break;
		 case MessageItem.MSG_STICHWORTLISTE_REPLY:
	      		abfrage.setStichwortListe((StichwortListe)msg.getData());
	      		lblRzStichworte.setListData(abfrage.getStichwortListe());
	      		openWindow();
	      		break;
	     case MessageItem.MSG_ADRESSLISTE_REPLY:
	      		abfrage.setAdressListe((StichwortListe)msg.getData());
	      		lblRzAdressen.setListData(abfrage.getAdressListe());
	      		openWindow();
	      		break;
	     case MessageItem.MSG_REFRESH_CAPTION:
	    	 	setWindowCaption();
	    	 	refreshAusgabe(msg);
	    	 	break;
	     case MessageItem.MSG_AUSWAHL_SAVE_HISTORY:
	    	 	saveHistory();
	    	 	break;
	     case MessageItem.MSG_REFRESH_BESTELLUNGSLISTE:
	    	 	// eine Bestellung ist getätigt worden und das
	    	 	// Bestellungslistenfenster muss benachrichtigt werden
	    	 	bestandsWarnungsAction();
	    	 	final FensterItem fi = ((FensterItem)rz.getFensterFactory().getFensterListe().getFensterItem(de.lunqual.rzpro.fensterfactory.FensterFactory.FENSTER_BESTELLUNGSLISTE));
	    	 	if ( fi != null) {
	    	 		fi.getFrame().getMessage( new MessageItem(MessageItem.MSG_REFRESH_BESTELLUNGSLISTE,0,null,this));
	    	 	}
	    		break;
	     case MessageItem.MSG_EINGABEDIALOG_REPLY:
	    		modifyTankReply(msg);
	    	 break;
		}
	}

	private void auftragsListeSuchenAction() {
		getAuftragsListe();
	}
	private void auftragsListeSuchenClearAction() {
		txtAuftragSucheField.setText("");
		getAuftragsListe();
	}
	
	
	private void zutatenDialogReply(ZutatenSuchItem zi) {
		if (zi != null && !zi.getName().trim().equals("")) {
			try {
				abfrageNeuAction();
				txtMuster.setText("^"+zi.getName().trim().replaceAll("\\s", ".")+ "$");
				abfrageAusfuehrenAction();
			}catch(Exception e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_WARN,"auswahl.zutatenDialogReply.getRezeptur:",e.getLocalizedMessage());
			}
		}
	}
	
	private void kontrakteAction(int id) {
		boolean found = false;
		if(tblErgebnis.getSelectedRow() != -1) {
            final ErgebnisItem ei =ergebnisse.getItem(tblErgebnis.getSelectedRow());
            if(ei != null ) {
    			ArrayList<kontraktItem> kil = rz.getDatabase().getKontrakte().getKontraktRezeptur(ei.getID());
    			if(kil != null && kil.size() >0) {
    				found = true;
    				rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_KONTRAKTE,true,new MessageItem(MessageItem.MSG_SHOW_KONTRAKTE,kil.get(0).getId(),kil.get(0),this));			
    			}
            }
		}
		if(!found) {
				rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_KONTRAKTE,true,new MessageItem(MessageItem.MSG_SHOW_KONTRAKTE,0,null,this));						
		}
	}
	
	private void dokumenteAction() {
    	if(tblErgebnis.getSelectedRow() != -1) {
            final ErgebnisItem ei =ergebnisse.getItem(tblErgebnis.getSelectedRow());
            if(ei != null ) {
            	if((ei.getTyp()==RzPro.TYP_ID_REZEPT) || (ei.getTyp() == RzPro.TYP_ID_VERWEIS) || ei.getTyp() == RzPro.TYP_ID_NOTIZ || ei.getTyp() == RzPro.TYP_ID_AUSSTATTUNG) {
            	 	rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_DOCUMENT_LISTE,false,new MessageItem(MessageItem.MSG_SHOW_DOKUMENT_LISTE,0,(Object)ei.getID(),this));
            	}
            }
		}
	}
	
    private void contentAction() {
    	if(tblErgebnis.getSelectedRow() != -1) {
            final ErgebnisItem ei =ergebnisse.getItem(tblErgebnis.getSelectedRow());
            if(ei != null ) {
	     	 	rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_REZEPTUR_CONTENT,false,new MessageItem(MessageItem.MSG_SHOW_REZEPTUR_CONTENT,ei.getID(),null,this));
	    	}
    	}
    }
	
	private void dokumenteFilterAction() {
		rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_DOCUMENT_LISTE,false,new MessageItem(MessageItem.MSG_SHOW_DOKUMENT_LISTE_FILTER,0,null,this));	
	
	}
	
	private void dokumenteAlleAction() {
    	if(tblErgebnis.getSelectedRow() != -1) {
            final ErgebnisItem ei =ergebnisse.getItem(tblErgebnis.getSelectedRow());
            if(ei != null ) {
            	if((ei.getTyp()==RzPro.TYP_ID_REZEPT) || (ei.getTyp() == RzPro.TYP_ID_VERWEIS) || ei.getTyp() == RzPro.TYP_ID_NOTIZ || ei.getTyp() == RzPro.TYP_ID_AUSSTATTUNG) {
            		String liste = rz.getDatabase().getRezeptur().getAlleRezepturen(ei.getID());
    				if(!liste.trim().equals("")) {
    					rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_DOCUMENT_LISTE,false,new MessageItem(MessageItem.MSG_SHOW_DOKUMENT_LISTE_ALLE,ei.getID(),(Object)liste,this));	
    				}
            	}
            }
    	}
	}
	
	
	
	private void musterSuchenAction() {
		int x, y;
		x = (int) (txtMuster.getLocationOnScreen().getX() );
		y = (int) (txtMuster.getLocationOnScreen().getY() - (txtMuster.getGraphics().getFontMetrics().getStringBounds("M",txtMuster.getGraphics()).getHeight() * rz.getOptionFactory().getOption("zutatendialog.height", ZutatenDialog.ZUTATENDIALOG_CHAR_HEIGHT)));
		if (zd != null) {
			zd.dispose();
			zd = null;
		}
		zd = new ZutatenDialog(this, rz, x, y, txtMuster.getText().trim(),ZutatenDialog.MODE_REZEPTUREN);
		zd.setVisible(true);
	}
	
	private AuftragsItem getSelectedAuftrag() {
		if(auftragsliste != null && !auftragsliste.isEmpty() && tblAuftragsliste.getSelectedRow() != -1 && tblAuftragsliste.getSelectedColumn() != -1) {
			return auftragsliste.getItem(tblAuftragsliste.getSelectedRow());			
		}
		return null;
	}
	
	public void resetDragging() {
		dragging = false;
		dragCursor = null;
		dragSource = null;
		dragDest = null;
		tblAuftragsliste.setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
	}
	private void moveAuftrag(AuftragsItem source,AuftragsItem dest) {
		if(source.getFaellig().getTimeInMillis() != dest.getFaellig().getTimeInMillis() ) {
			int diff = rz.getDatabase().getAuftrag().getAuftragsConfig().getDayDiff(source.getFaellig(), dest.getFaellig());
			if(!source.getGruppe().equals("")) {
				ArrayList<AuftragsItem> ail = rz.getDatabase().getAuftrag().getAuftraegeNachGruppen(source.getGruppe());
				if(!ail.isEmpty()) {
						String liste = "";
						for(AuftragsItem ai:ail) {
							if(ai.isArbeitsAuftrag()) {
								liste += ai.getBezeichnung()+"<br>";
							}else {
								liste += rz.getLocale().formatNumber(ai.getLiter(), OptionFactory.NF_ONE)+ " " +rz.getLocale().getString("string_liter") + " " + ai.getBezeichnung() + "<br>";
							}
						}
						DialogItem di = new DialogItem(
		                        DialogControl.FRAGE_DIALOG,
		                        "",0.0,
		                        rz.getLocale().getString("auftragsliste.question_move"),
		                        rz.getLocale().getString("auftragsliste.question_move"),
		                        rz.getLocale().getString("auftragsliste.question_move_2")
		                        	.replaceAll("%s",liste),
		                        "frage.png",
		                        rz.getLocale().getString("string_ja"),
		                        rz.getLocale().getString("string_nein"),
		                        this
			                );
						  	if(di != null) {
						  		rz.getDialogFactory().getDialog(di);
						  		if ((di.getReplyCode() == DialogControl.DIALOG_YES) || (di.getReplyCode() == DialogControl.DIALOG_OK)){
						  			for(AuftragsItem ai:ail) {
						  				rz.getDatabase().getAuftrag().getAuftragsConfig().move(ai.getFaellig(), diff);		
						  				rz.getDatabase().getAuftrag().saveAuftrag(ai, this);
						  			}
						  		}
							}
				}
				}else {
					source.setFaellig(dest.getFaellig().getTimeInMillis());
					rz.getDatabase().getAuftrag().saveAuftrag(source, this);
			}
			getAuftragsListe();
		}
	}
	
	private void dragAuftrag(AuftragsItem source,AuftragsItem dest) {
		if(source != null && dest != null && source != dest) {
			if(!dest.getGruppe().equals("")) {
				source.setGruppe(dest.getGruppe());
				rz.getDatabase().getAuftrag().saveAuftrag(source, this);
				getAuftragsListe();
			}else {
				if(source.getGruppe().equals("")) {
			        final DialogItem di  = new DialogItem(
			                DialogControl.EINGABE_DIALOG,
			                "",0.0,
			                rz.getLocale().getString("auswahl.auftrag_gruppe"),
			                rz.getLocale().getString("auswahl.auftrag_gruppe_frage"),
			                "",
			                "frage.png",
			                rz.getLocale().getString("string_ok"),
			                rz.getLocale().getString("string_abbrechen"),
			                null
			        );
			        rz.getDialogFactory().getDialog(di);
			        if(di.getReplyCode() == DialogControl.DIALOG_OK) {
			        	if(!di.getContent().trim().equals("")) {
			        		source.setGruppe(di.getContent());
			        		dest.setGruppe(di.getContent());
			        		rz.getDatabase().getAuftrag().saveAuftrag(source, this);
			        		rz.getDatabase().getAuftrag().saveAuftrag(dest, this);
			        		getAuftragsListe();
			        	}
			        }
				}else {
					source.setGruppe("");
					rz.getDatabase().getAuftrag().saveAuftrag(source, this);
					getAuftragsListe();
				}
			}
		}  
	}
	
    private void modifyTankReply(MessageItem msg) {
    	String content = (String)msg.getData();
    	if(content != null && msg.getCode() > 0) {
        	rz.getDatabase().getBuchungen().setComment(content,msg.getCode());
        	refreshAusgabe(msg);
        	rz.getFensterFactory().getFensterListe().propagateBestand(this,rz.getDatabase().getBuchungen().getEinzelBuchung(msg.getCode()).getRezeptur_id());
    	}
    }
	
	private void refreshAusgabe(MessageItem msg) {
		ergebnisTimerEvent();
		bestandsWarnungsAction();
		getAuftragsListe();
		getAnfragenListe();
		abfrageRefreshAction();
		if(msg.getCode() != 0) {
			refreshTable(msg.getCode(),false);
		} else {
			if(msg.getCode()==0) {
				refreshTable((int [])msg.getData());
			}
		}
		setTerminLabel();
		tblErgebnis.setShowGrid(true);
	}
	private boolean refreshTable(int id,boolean setSelection) {
		boolean ret = false;
		try {
			if(id != 0) {
				int r=tblErgebnis.getSelectedRow();
				for(int i=0;i<ergebnisse.size(); i++) {
					if(ergebnisse.getItem(i).getID() == id) {
						ErgebnisItem ei=rz.getDatabase().getErgebnis().getErgebnisItem(ergebnisse.getItem(i).getID());
						if(ei!=null) {
							ergebnisse.getItem(i).setBezeichnung(ei.getBezeichnung());
							ergebnisse.getItem(i).setBestand(ei.getBestandRaw());
							ergebnisse.getItem(i).setBestellung((rz.getDatabase().getBestellung().checkBestellung(ergebnisse.getItem(i).getID()) == null?false:true));
							ergebnisse.getItem(i).setStichwortliste(ergebnisse.getItem(i).getID());
							ergebnisse.getItem(i).setAuftrag(ei.isAuftrag());
							ergebnisse.getItem(i).setInarbeit(ei.isInarbeit());
							ergebnisse.getItem(i).setKonform(ei.isKonform());
							ergebnisse.getItem(i).setKonformComment(ei.getKonformComment());
							ergebnisse.getItem(i).setKonformDatum(ei.getKonformDatum());
							((AbstractTableModel)tblErgebnis.getModel()).fireTableDataChanged();
						}
						if(setSelection ) {
							r=i;
						}
						ret = true;
						break;
					}
				}
				tblErgebnis.setRowSelectionInterval(r,r);
				tblErgebnis.scrollRectToVisible(tblErgebnis.getCellRect(r,0,true));
			}
		}catch(Exception e) {
		}
		return ret;
	}
	
	private void refreshTable(int[] ids) {
		try {
			if(ids != null) {
				int r=tblErgebnis.getSelectedRow();
				for(int i=0;i<ergebnisse.size(); i++) {
					for(int j=0;j < ids.length;j++) {
						if(ergebnisse.getItem(i).getID() == ids[j]) {
							ErgebnisItem ei=rz.getDatabase().getErgebnis().getErgebnisItem(ergebnisse.getItem(i).getID());
							if(ei!=null) {
								ergebnisse.getItem(i).setBestand(ei.getBestandRaw());
								ergebnisse.getItem(i).setBestellung((rz.getDatabase().getBestellung().checkBestellung(ergebnisse.getItem(i).getID()) == null?false:true));
								ergebnisse.getItem(i).setStichwortliste(ei.getID());
								ergebnisse.getItem(i).setAuftrag(ei.isAuftrag());
								((AbstractTableModel)tblErgebnis.getModel()).fireTableDataChanged();
							}
						}
					}
				}
				tblErgebnis.setRowSelectionInterval(r,r);
			}
		}catch(Exception e) {
		}
	}
	
	private void losnummerVorlageAction() {
		   rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_LOSNUMMER_VORLAGE,true,new MessageItem(MessageItem.MSG_SHOW_LOSNUMMERVORLAGE_SINGLE, 0,null,this));
	}
	
	private void deleteHistoryAction() {
		rz.getDatabase().getAbfrage().deleteHistory(rz.getDatabase().dbGetUser());
		getHistory();
		((AbstractTableModel)tblErgebnis.getModel()).fireTableDataChanged();
		setActions();
	}
	/**
	 * History speichern
	 */
	private void saveHistory(){
		rz.getDatabase().getAbfrage().saveHistory(abfragen);
		if(tblErgebnis.getSelectedRow() != -1) {
			ErgebnisItem ei=ergebnisse.getItem(tblErgebnis.getSelectedRow());
			rz.getDatabase().getAbfrage().saveLastActive(ei.getID());
		}
	}

	private void getHistory() {
		try {
			abfragen = rz.getDatabase().getAbfrage().gethistory();
			if(txtHistory != null && abfragen != null) {
				rz.getAusgabeFactory().historyAusgabe(txtHistory, abfragen);
				if(!abfragen.isEmpty()) {
					abfrageNavigation(ACTION_NAV_ENDE_CODE);
					showAbfrage(abfragen.getCurrentItem());
				} else {
					ergebnisse = new ErgebnisListe();
				}
			}
		}catch(Exception e) {
			e.printStackTrace();
		}
		if(abfragen.getCurrentItem() != null) {
			doAbfrage(abfragen.getCurrentItem());
		}
		((AbstractTableModel)tblErgebnis.getModel()).fireTableDataChanged();
		setLastActive();
	}
	
	private void setLastActive() {
		try {
			int id = rz.getDatabase().getAbfrage().getLastActive();
			if(id != 0 && ergebnisse.size()!=0) {
				for(int i=0;i < ergebnisse.size();i++) {
					if(ergebnisse.getItem(i).getID() == id) {
						tblErgebnis.setRowSelectionInterval(i,i);
			            tblErgebnis.scrollRectToVisible(tblErgebnis.getCellRect(i,0,true));
			            tblErgebnis.requestFocus();
						break;
					}
				}
			}
		}catch(Exception e) {
			
		}
		tblErgebnis.setShowGrid(true);
	}
	
	private int getSelectedLine() {
		int y = (int)( tblAuftragsliste.getMousePosition().getY());
		for(int i=0;i<auftragsliste.size();i++) {
			Rectangle r = tblAuftragsliste.getCellRect(i,0,true);
			if(y>r.getY() && y < r.getY()+r.getHeight()) {
				return i;
			}
		}
		return -1;
	}
	
	private void tblAuftragsListeDragStartAction() {
		dragCursor = null;
		int line = getSelectedLine();
      	tblAuftragsliste.getSelectionModel().setSelectionInterval(line,line);
		if(line != -1) {
			dragSource = auftragsliste.getItem(line);
			if(dragSource != null) {
				int col =(int)( tblAuftragsliste.getMousePosition().getX());
				if(col != -1) {
					if(col <= tblAuftragsliste.getColumnModel().getColumn(AL_C_SUCHEN).getWidth()) {
						dragCursor = rz.getDatabase().getAuftrag().getDatumCursor(dragSource, tblAuftragsliste);
					} else {
						dragCursor = rz.getDatabase().getAuftrag().getGruppenCursor(dragSource, tblAuftragsliste);
					}
				}
			}
		}
	}
	
	private void tblAuftragslisteDragEndAction() {
		int row = tblAuftragsliste.getSelectedRow();
		int col = tblAuftragsliste.getSelectedColumn();
		if(row != -1 && col != -1) {
			dragDest = auftragsliste.getItem(row);
     	    if(dragCursor != null && dragSource != null && dragDest != null && dragSource != dragDest) {
     		    if(dragCursor.getName().equals(DBAuftrag.CURSOR_DATUM)){
     		    	moveAuftrag(dragSource,dragDest);
     		    } else if (dragCursor.getName().equals(DBAuftrag.CURSOR_GRUPPE)) {
     		    	dragAuftrag(dragSource,dragDest);
     		    }
     	    }
		}
		
	}
	private void tblAufragslisteSelectionChanged() {
		int col = tblAuftragsliste.getSelectedColumn();
		int row = tblAuftragsliste.getSelectedRow();
		if(col != -1 && row != -1) {
			switch(col) {
				case AL_C_SUCHEN:
	 				auftragSuchenAction();
					break;
				case AL_C_MENGE:
					auftragRechnenAction();
					break;
				case AL_C_BEZEICHNUNG:
					auftragAnzeigenAction();
	    			break;
			}
		}
	}
	
	private void auftragSuchenAction() {
		int col = tblAuftragsliste.getSelectedColumn();
		int row = tblAuftragsliste.getSelectedRow();
		if(col != -1 && row != -1) {
			AuftragsItem ai = auftragsliste.getItem(row);
			if(ai != null) {
				if(ai.getRezeptur_id()!=0) {
					final AbfrageItem abf = new AbfrageItem();
					abf.setTyp(de.lunqual.rzpro.database.DBAbfrage.ABFRAGE_TYP_NORMAL);
					abf.setID(0);
					abf.setAdressListe(new StichwortListe());
					abf.setStichwortListe(new StichwortListe());
					try {
						String gruppe = ai.getGruppe().trim();
						if(gruppe.equals("")){
							abf.setMuster("^" + rz.getDatabase().getRezeptur().dbGetRezepturName(ai.getRezeptur_id()) +  "$");
							abf.setMuster(abf.getMuster().replaceAll(" ","."));
						} else {
							String muster = "";
							for(int i=0;i<auftragsliste.size();i++) {
								AuftragsItem ai1 = auftragsliste.getItem(i);
								if(gruppe.equals(ai1.getGruppe().trim())) {
										muster += ai1.getRezeptur_id() + ",";
								}
							}
							if(muster.endsWith(",")) {
								muster = muster.substring(0,muster.length()-1);
							}
							abf.setID(0);
		    				abf.setAdressListe(new StichwortListe());
		    				abf.setStichwortListe(new StichwortListe());
		    				abf.setTyp(de.lunqual.rzpro.database.DBAbfrage.ABFRAGE_TYP_SQL);
		    				abf.setMuster(rz.getDatabase().getErgebnis().getErweitertSQLPrefix() + " rezeptliste.id in (" + String.valueOf(muster) + ") and rezeptliste.typ=1  group by rezeptliste.id order by name");
						}
						addAbfrage(abf);
					} catch(final ItemNotFoundException e1) {}
				}
				selectErgebnis(ai.getRezeptur_id());
			}
		}
	}
	
	

	
	private void selectErgebnis(int id) {
		if(id != 0 && ergebnisse.size()>0) {
			for(int i=0;i<ergebnisse.size();i++) {
				if (ergebnisse.getItem(i).getID() == id){
					tblErgebnis.setRowSelectionInterval(i,i);
					tblErgebnis.scrollRectToVisible(tblErgebnis.getCellRect(i,0,true));
					break;
				}
			}
		}
	}
	
	private void auftragAnzeigenAction() {
		int col = tblAuftragsliste.getSelectedColumn();
		int row = tblAuftragsliste.getSelectedRow();
		if(col != -1 && row != -1) {
			AuftragsItem ai = auftragsliste.getItem(row);
			if(ai != null) {
    			rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_AUFTRAG, false, new MessageItem(MessageItem.MSG_EDIT_AUFTRAG,0,ai,this));
			}
		}
	}
	
	private void auftragRechnenAction() {
		int col = tblAuftragsliste.getSelectedColumn();
		int row = tblAuftragsliste.getSelectedRow();
		if(col != -1 && row != -1) {
			AuftragsItem ai = auftragsliste.getItem(row);
			if(ai != null) {
				if(ai.getRezeptur_id() != 0) {
					  final ErgebnisItem ei1 = new ErgebnisItem(
		                  		rz,
		                  		ai.getRezeptur_id(),
		                  		RzPro.TYP_ID_REZEPT,
		  						ai.getBezeichnung(),0,0,null,null,null,0,0,0,false,0,0,"","",20,20,false,false);
						  		ei1.setLiter(ai.getLiter());
					rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_RECHNEN,false,new MessageItem(MessageItem.MSG_RECHNEN,0,ei1,this));
				}
			}
		}
	}
	
	private void auftragEntfernenAction() {
		int col = tblAuftragsliste.getSelectedColumn();
		int row = tblAuftragsliste.getSelectedRow();
		boolean doIt = false;
		if(col != -1 && row != -1) {
			AuftragsItem ai = auftragsliste.getItem(row);
			if(ai != null) {
				if(ai.getGruppe().trim().equals("")) {
					  final DialogItem di  = new DialogItem(
				                DialogControl.EINGABE_DIALOG,
				                "",0.0,
				                rz.getLocale().getString("auswahl.auftrag_gruppe"),
				                rz.getLocale().getString("auswahl.auftrag_gruppe_frage"),
				                "",
				                "frage.png",
				                rz.getLocale().getString("string_ok"),
				                rz.getLocale().getString("string_abbrechen"),
				                null
				        );
				        rz.getDialogFactory().getDialog(di);
				        if(di.getReplyCode() == DialogControl.DIALOG_OK) {
				        	ai.setGruppe(di.getContent().trim());
				        	doIt=true;
				        }
				}else {
					ai.setGruppe("");
					doIt = true;
				}
				if(doIt) {
					rz.getDatabase().getAuftrag().saveAuftrag(ai, this);
					getAuftragsListe();
				}
			}
		}
	}
	
	private void auftragStatusAction() {
		int col = tblAuftragsliste.getSelectedColumn();
		int row = tblAuftragsliste.getSelectedRow();
		if(col != -1 && row != -1) {
			AuftragsItem ai = auftragsliste.getItem(row);
			if(ai != null) {
				if(ai.isInarbeit()) {
					ai.setInarbeit(false);
				}else {
					ai.setInarbeit(true);
					ai.setArbeit_user(rz.getDatabase().dbGetUser());
				}
				rz.getDatabase().getAuftrag().saveAuftrag(ai, this);
	  			getAuftragsListe();
			}
		}
	}
	
	private void auftragLoeschenAction() {
		int col = tblAuftragsliste.getSelectedColumn();
		int row = tblAuftragsliste.getSelectedRow();
		if(col != -1 && row != -1) {
			DialogItem di = null;
			AuftragsItem ai = auftragsliste.getItem(row);
			if(ai != null) {
			  	if(ai.isArbeitsAuftrag()) {
			  		di = new DialogItem(
	                        DialogControl.FRAGE_DIALOG,
	                        "",0.0,
	                        rz.getLocale().getString("auftragsliste.question_delete"),
	                        rz.getLocale().getString("auftragsliste.question_delete"),
	                        rz.getLocale().getString("auftragsliste.question_delete_2")
	                        	.replaceAll("%s",ai.getBezeichnung())
	                        	.replaceAll("%d", ai.getFaelligToString()),
	                        "frage.png",
	                        rz.getLocale().getString("string_ja"),
	                        rz.getLocale().getString("string_nein"),
	                        this
	                );
			  	} else {
				  	di = new DialogItem(
	                        DialogControl.FRAGE_DIALOG,
	                        "",0.0,
	                        rz.getLocale().getString("auftragsliste.question_delete"),
	                        rz.getLocale().getString("auftragsliste.question_delete"),
	                        rz.getLocale().getString("auftragsliste.question_delete_1").replaceAll("%l",rz.getLocale().formatNumber(ai.getLiter(),OptionFactory.NF_ONE))
	                        	.replaceAll("%s",ai.getBezeichnung())
	                        	.replaceAll("%d", ai.getFaelligToString()),
	                        "frage.png",
	                        rz.getLocale().getString("string_ja"),
	                        rz.getLocale().getString("string_nein"),
	                        this
	                );
			  	}
			  	if(di != null) {
			  		rz.getDialogFactory().getDialog(di);
			  		if ((di.getReplyCode() == DialogControl.DIALOG_YES) || (di.getReplyCode() == DialogControl.DIALOG_OK)){
			  			rz.getDatabase().getAuftrag().deleteAuftrag(ai);
			  			rz.getFensterFactory().getFensterListe().propagateBestand(this);
			  			getAuftragsListe();
			  		}
			  	}
    		}
		}
	}
	
	private void tblAnfragenlisteSelectionChanged() {
		int col = tblAnfragenliste.getSelectedColumn();
		int row = tblAnfragenliste.getSelectedRow();
		if(col != -1 && row != -1) {
			AuftragsItem ai = anfragenliste.getItem(row);
			switch(col) {
				case AL_C_SUCHEN:
	 				final AbfrageItem abf = new AbfrageItem();
					abf.setTyp(de.lunqual.rzpro.database.DBAbfrage.ABFRAGE_TYP_NORMAL);
					abf.setID(0);
					abf.setAdressListe(new StichwortListe());
					abf.setStichwortListe(new StichwortListe());
					try {
						abf.setMuster("^" + rz.getDatabase().getRezeptur().dbGetRezepturName(ai.getRezeptur_id()) +  "$");
						abf.setMuster(abf.getMuster().replaceAll(" ","."));
						addAbfrage(abf);
					} catch(final ItemNotFoundException e1) {}
					break;
				case AL_C_MENGE:
                    final ErgebnisItem ei1 = new ErgebnisItem(
                    		rz,
                    		ai.getRezeptur_id(),
                    		RzPro.TYP_ID_REZEPT,
    						ai.getBezeichnung(),0,0,null,null,null,0,0,0,false,0,0,"","",20,20,false,false);
                    ei1.setLiter(ai.getLiter());
               		rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_RECHNEN,false,new MessageItem(MessageItem.MSG_RECHNEN,0,ei1,this));
					break;
				case AL_C_BEZEICHNUNG:
	    			rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_AUFTRAG, false, new MessageItem(MessageItem.MSG_EDIT_AUFTRAG,0,ai,this));
					break;
			}
		}
	}
	
	
	/** speichert die Position der Splitbalken
	 */
    private void saveDividerLocations(){
        rz.getFensterFactory().setOption(this.getName() + ".splHorizontal", this.splHorizontal.getDividerLocation());
        rz.getFensterFactory().setOption(this.getName() + ".splVertical", this.splVertical.getDividerLocation());
        rz.getFensterFactory().setOption(this.getName() + ".splVertical2", this.splVertical2.getDividerLocation());
        rz.getOptionFactory().setOption("bestandswarnung.zutaten",chkBestandZutaten.isSelected()?1:0);
        rz.getOptionFactory().setOption("bestandswarnung.buchungen",chkBestandBuchungen.isSelected()?1:0);
        rz.getFensterFactory().saveOptions();
    }
	/** setzt die Position der Splitbalken auf gespeicherte Positionen oder
	 * auf Standardposition, wenn keine gespeicherten vorliegen
	 *
	 */
    private void setDividerLocations() {
        splHorizontal.setDividerLocation(rz.getFensterFactory().getOption(this.getName() + ".splHorizontal",this.getWidth()/3));
        splVertical.setDividerLocation(rz.getFensterFactory().getOption(this.getName() + ".splVertical",this.getHeight()/3));
        splVertical2.setDividerLocation(rz.getFensterFactory().getOption(this.getName() + ".splVertical2",(int)(splVertical.getLocation().getY() + 50.0)  ));
    }

    private void lstErgebnisValueChanged(javax.swing.event.ListSelectionEvent evt) {
    	restartTimer();
    }

    private void restartTimer() {
        if(ergebnisTimer.isRunning()) {
			ergebnisTimer.restart();
		} else {
			ergebnisTimer.start();
		}
    }
    
    private void txtMusterFocusGained(java.awt.event.FocusEvent evt) {
        txtMuster.setSelectionStart(0);
        txtMuster.setSelectionEnd(txtMuster.getText().length());
    }

    private void cmbSortActionPerformed(java.awt.event.ActionEvent evt) {
        if(cmbSort.getSelectedIndex() != -1 ) {
			abfrage.setOrder(cmbSort.getSelectedIndex());
		}
    }

    private void lstAbfragenKeyReleased(java.awt.event.KeyEvent evt) {
        if(evt.getKeyCode() == KeyEvent.VK_ENTER){
            abfrageGoAction();
        }
    }

    private void lstAbfragenMouseClicked(java.awt.event.MouseEvent evt) {
        if (evt.getClickCount() == 2){
            abfrageGoAction();
        }
    }

    private void lstAbfragenValueChanged(javax.swing.event.ListSelectionEvent evt) {
        abfrageUseAction();
    }

    private void txtMusterKeyReleased(java.awt.event.KeyEvent evt) {
        if (evt.getKeyCode() == KeyEvent.VK_ENTER){
            abfrageAusfuehrenAction();
        }
      }

    /**
     * setactions enabled oder disabled actions auf der Basis des gerade angezeigte n
     * elements in der ergebnisliste
     *
     */
    private void setActions() {
    	if(anfragenliste != null && !anfragenliste.isEmpty()) {
    		getAction(ACTION_ANFRAGENLISTE_DRUCKEN_CODE).setEnabled(true);
    	}else {
    		getAction(ACTION_ANFRAGENLISTE_DRUCKEN_CODE).setEnabled(false);	
    	}
    	if(auftragsliste != null && !auftragsliste.isEmpty()) {
    		getAction(ACTION_AUFTRAGSLISTE_DRUCKEN_CODE).setEnabled(true);
    		getAction(ACTION_ZUTATENLISTE_CODE).setEnabled(true);
    	}else {
    		getAction(ACTION_AUFTRAGSLISTE_DRUCKEN_CODE).setEnabled(false);	
    		getAction(ACTION_ZUTATENLISTE_CODE).setEnabled(false);
    	}
    	if(lstAbfragen.getSelectedIndex()==-1) {
    		getAction(ACTION_ABFRAGE_PRIVAT_CODE).setEnabled(false);
    		getAction(ACTION_ABFRAGE_PUBLIC_CODE).setEnabled(false);
    		getAction(ACTION_ABFRAGE_LOESCHEN_CODE).setEnabled(false);
    		getAction(ACTION_SHOW_CHANGES_CODE).setEnabled(false);
    	}else {
        	int id =((AbfrageItem)lstAbfragen.getSelectedValue()).getID();
        	AbfrageItem abfrage = rz.getDatabase().getAbfrage().dbGetAbfrage(id);
        	if(abfrage != null) {
        		if(abfrage.isPrivat()) {
            		getAction(ACTION_ABFRAGE_PRIVAT_CODE).setEnabled(false);
            		getAction(ACTION_ABFRAGE_PUBLIC_CODE).setEnabled(true);
    				getAction(ACTION_ABFRAGE_LOESCHEN_CODE).setEnabled(true);
        		}else {
        			if(abfrage.getUser1().equals(rz.getDatabase().dbGetUser())) {
        				getAction(ACTION_ABFRAGE_PRIVAT_CODE).setEnabled(true);
        				getAction(ACTION_ABFRAGE_LOESCHEN_CODE).setEnabled(true);
        			} else {
        				getAction(ACTION_ABFRAGE_PRIVAT_CODE).setEnabled(false);
        				getAction(ACTION_ABFRAGE_LOESCHEN_CODE).setEnabled(false);
        			}
            		getAction(ACTION_ABFRAGE_PUBLIC_CODE).setEnabled(false);
        		}
        	} 		
    	}
    	chkBestandZutaten.setSelected( rz.getOptionFactory().getOption("bestandswarnung.zutaten", 0)==0?false:true);
    	chkBestandBuchungen.setSelected( rz.getOptionFactory().getOption("bestandswarnung.buchungen", 0)==0?false:true);
		if(chkBestandBuchungen.isSelected()) {
			lblBestandBuchungen.setVisible(true);
		}else {
			lblBestandBuchungen.setVisible(false);
		}
		getAction(ACTION_VERBRAUCH_LISTE_CODE).setEnabled(false);
		if(ergebnisse.size()==0) {
			getAction(ACTION_VERBRAUCH_LISTE_CODE).setEnabled(false);
		}else {
			getAction(ACTION_VERBRAUCH_LISTE_CODE).setEnabled(true);
		}
    	if(tblErgebnis.getSelectedRow() == -1) {
    		// nichts ausgewählt
			getAction(ACTION_VERGLEICH_1_CODE).setEnabled(false);
			getAction(ACTION_VERGLEICH_2_CODE).setEnabled(false);
			getAction(ACTION_VERBRAUCH_CODE).setEnabled(false);
			getAction(ACTION_BEARBEITEN_CODE).setEnabled(false);
			getAction(ACTION_LOESCHEN_CODE).setEnabled(false);
			getAction(ACTION_DRUCKEN_CODE).setEnabled(false);
			getAction(ACTION_BESTANDSLISTENDRUCK_CODE).setEnabled(false);
			getAction(ACTION_LISTE_DRUCKEN_CODE).setEnabled(false);
			getAction(ACTION_VERWENDUNG_CODE).setEnabled(false);
			getAction(ACTION_VERWENDUNG_EINZELN_CODE).setEnabled(false);
			getAction(ACTION_ZUTATEN_CODE).setEnabled(false);
			getAction(ACTION_ZUTATEN_ALLE_CODE).setEnabled(false);
			getAction(ACTION_UND_GRUPPE_CODE).setEnabled(false);
			getAction(ACTION_ODER_GRUPPE_CODE).setEnabled(false);
			getAction(ACTION_ADRESSEN_GRUPPE_CODE).setEnabled(false);
			getAction(ACTION_ADRESSEN_CODE).setEnabled(false);
			getAction(ACTION_NEUE_REZEPTUR_GRUPPE_CODE).setEnabled(false);
			getAction(ACTION_NEUE_NOTIZ_GRUPPE_CODE).setEnabled(false);
			getAction(ACTION_NEUE_AUSSTATTUNG_GRUPPE_CODE).setEnabled(false);
			getAction(ACTION_CALC_CODE).setEnabled(false);
			getAction(ACTION_AUFSTAERKEN_CODE).setEnabled(false);
			getAction(ACTION_HERABSETZEN_CODE).setEnabled(false);
			getAction(ACTION_DUPLICATE_CODE).setEnabled(false);
			getAction(ACTION_ZUGANG_CODE).setEnabled(false);
			getAction(ACTION_GEWICHT_CODE).setEnabled(false);
			getAction(ACTION_ABGANG_CODE).setEnabled(false);
			getAction(ACTION_STATISTIK_EINZELN_CODE).setEnabled(false);
			getAction(ACTION_STATISTIK_GRUPPE_CODE).setEnabled(false);
			getAction(ACTION_STATISTIK_BESTAND_CODE).setEnabled(false);
			getAction(ACTION_STATISTIK_BESTAND_GRUPPE_CODE).setEnabled(false);
			getAction(ACTION_HINWEIS_CODE).setEnabled(false);
			getAction(ACTION_AUTOCALC_CODE).setEnabled(false);
			getAction(ACTION_AUTOCALC_SINGLE_CODE).setEnabled(false);
			getAction(ACTION_REZEPTUR_DRUCKEN_CODE).setEnabled(false);
			getAction(ACTION_KALKULATION_DRUCKEN_CODE).setEnabled(false);
			getAction(ACTION_SPEZIFIKATION_DRUCKEN_CODE).setEnabled(false);
			getAction(ACTION_ZUTATENVERZEICHNIS_DRUCKEN_CODE).setEnabled(false);
			getAction(ACTION_SPEZIFIKATION_DRUCKEN_KOMPLETT_CODE).setEnabled(false);
			getAction(ACTION_SPEZIFIKATION_PDF_CODE).setEnabled(false);
			getAction(ACTION_SPEZIFIKATION_PDF_KOMPLETT_CODE).setEnabled(false);
			getAction(ACTION_AUTOCALC_SINGLE_CODE).setEnabled(false);
			getAction(ACTION_DEPENDENCY_CALC_CODE).setEnabled(false);
			getAction(ACTION_DATENBLATT_CODE).setEnabled(false);
			getAction(ACTION_BESTELLUNG_CODE).setEnabled(false);
			getAction(ACTION_PROBE_NEU_CODE).setEnabled(false);
			getAction(ACTION_SHOW_CHANGES_CODE).setEnabled(false);
			getAction(ACTION_TEMPERATURZONEN_CODE).setEnabled(false);
			getAction(ACTION_DOKUMENTE_CODE).setEnabled(false);
			getAction(ACTION_DOKUMENTE_ALLE_CODE).setEnabled(false);
			getAction(ACTION_CONTENT_CODE).setEnabled(false);
    	}
    	else {
    		// ein element ist ausgewählt
    		final ErgebnisItem ei = ergebnisse.getItem(tblErgebnis.getSelectedRow());
			getAction(ACTION_VERGLEICH_2_CODE).setEnabled(false);
			getAction(ACTION_TEMPERATURZONEN_CODE).setEnabled(true);
			getAction(ACTION_BEARBEITEN_CODE).setEnabled(true);
			getAction(ACTION_LOESCHEN_CODE).setEnabled(true);
			getAction(ACTION_DRUCKEN_CODE).setEnabled(true);
			getAction(ACTION_BESTANDSLISTENDRUCK_CODE).setEnabled(true);
			getAction(ACTION_LISTE_DRUCKEN_CODE).setEnabled(true);
			getAction(ACTION_DUPLICATE_CODE).setEnabled(true);
			if((ei.getTyp() == RzPro.TYP_ID_REZEPT) || (ei.getTyp() == RzPro.TYP_ID_VERWEIS) || (ei.getTyp() == RzPro.TYP_ID_AUSSTATTUNG)) {
				getAction(ACTION_VERWENDUNG_CODE).setEnabled(true);
				getAction(ACTION_VERWENDUNG_EINZELN_CODE).setEnabled(true);
				getAction(ACTION_ZUTATEN_CODE).setEnabled(true);
				getAction(ACTION_ZUTATEN_ALLE_CODE).setEnabled(true);

			}

			getAction(ACTION_NEUE_NOTIZ_GRUPPE_CODE).setEnabled(true);
			getAction(ACTION_NEUE_REZEPTUR_GRUPPE_CODE).setEnabled(true);
			getAction(ACTION_NEUE_AUSSTATTUNG_GRUPPE_CODE).setEnabled(true);
			if (ei.getAdressen().trim().equals("")) {
				getAction(ACTION_ADRESSEN_CODE).setEnabled(false);
			} else {
				getAction(ACTION_ADRESSEN_CODE).setEnabled(true);
			}
			if(ei.getStichworte().trim().equals("")) {
				getAction(ACTION_UND_GRUPPE_CODE).setEnabled(false);
				getAction(ACTION_ODER_GRUPPE_CODE).setEnabled(false);
			} else {
				getAction(ACTION_UND_GRUPPE_CODE).setEnabled(true);
				getAction(ACTION_ODER_GRUPPE_CODE).setEnabled(true);
			}

    		switch (ei.getTyp()) {
    			case RzPro.TYP_ID_REZEPT :
    		    case RzPro.TYP_ID_VERWEIS :
    					getAction(ACTION_VERGLEICH_1_CODE).setEnabled(true);
    					if(rz.getFensterFactory().getFensterListe().getVergleichHasItem1()) {
    						getAction(ACTION_VERGLEICH_2_CODE).setEnabled(true);
    						getAction(ACTION_VERGLEICH_1_CODE).setEnabled(false);
    					}
						getAction(ACTION_VERBRAUCH_CODE).setEnabled(true);
    					getAction(ACTION_CALC_CODE).setEnabled(true);
    					getAction(ACTION_AUFSTAERKEN_CODE).setEnabled(true);
    					getAction(ACTION_HERABSETZEN_CODE).setEnabled(true);
    					getAction(ACTION_ZUGANG_CODE).setEnabled(true);
    					getAction(ACTION_GEWICHT_CODE).setEnabled(true);
    					getAction(ACTION_ABGANG_CODE).setEnabled(true);
    					getAction(ACTION_STATISTIK_EINZELN_CODE).setEnabled(true);
    					getAction(ACTION_STATISTIK_BESTAND_CODE).setEnabled(true);
    					getAction(ACTION_STATISTIK_BESTAND_GRUPPE_CODE).setEnabled(true);
    					getAction(ACTION_HINWEIS_CODE).setEnabled(true);
    					getAction(ACTION_AUTOCALC_CODE).setEnabled(true);
    					getAction(ACTION_AUTOCALC_SINGLE_CODE).setEnabled(true);
    					getAction(ACTION_REZEPTUR_DRUCKEN_CODE).setEnabled(true);
    					getAction(ACTION_REZEPTUR_DRUCKEN_LISTE_CODE).setEnabled(true);
    					getAction(ACTION_KALKULATION_DRUCKEN_CODE).setEnabled(true);
    					getAction(ACTION_SPEZIFIKATION_DRUCKEN_CODE).setEnabled(true);
    					getAction(ACTION_ZUTATENVERZEICHNIS_DRUCKEN_CODE).setEnabled(true);
    					getAction(ACTION_SPEZIFIKATION_DRUCKEN_KOMPLETT_CODE).setEnabled(true);
    					getAction(ACTION_SPEZIFIKATION_PDF_CODE).setEnabled(true);
    					getAction(ACTION_SPEZIFIKATION_PDF_KOMPLETT_CODE).setEnabled(true);
    					getAction(ACTION_DEPENDENCY_CALC_CODE).setEnabled(true);
    					getAction(ACTION_DATENBLATT_CODE).setEnabled(true);
    					getAction(ACTION_BESTELLUNG_CODE).setEnabled(true);
    					getAction(ACTION_PROBE_NEU_CODE).setEnabled(true);
    					getAction(ACTION_SHOW_CHANGES_CODE).setEnabled(true);
    					getAction(ACTION_DOKUMENTE_CODE).setEnabled(true);
    					getAction(ACTION_DOKUMENTE_ALLE_CODE).setEnabled(true);
    					getAction(ACTION_CONTENT_CODE).setEnabled(true);
    					break;
    			case RzPro.TYP_ID_NOTIZ :
					getAction(ACTION_VERBRAUCH_CODE).setEnabled(false);
    				getAction(ACTION_CALC_CODE).setEnabled(false);
						getAction(ACTION_AUFSTAERKEN_CODE).setEnabled(false);
						getAction(ACTION_HERABSETZEN_CODE).setEnabled(false);
    					getAction(ACTION_ZUGANG_CODE).setEnabled(false);
    					getAction(ACTION_GEWICHT_CODE).setEnabled(false);
    					getAction(ACTION_ABGANG_CODE).setEnabled(false);
    					getAction(ACTION_STATISTIK_EINZELN_CODE).setEnabled(false);
    					getAction(ACTION_STATISTIK_BESTAND_CODE).setEnabled(false);
    					getAction(ACTION_STATISTIK_BESTAND_GRUPPE_CODE).setEnabled(false);
    					getAction(ACTION_HINWEIS_CODE).setEnabled(false);
    					getAction(ACTION_AUTOCALC_CODE).setEnabled(false);
    					getAction(ACTION_AUTOCALC_SINGLE_CODE).setEnabled(false);
    					getAction(ACTION_REZEPTUR_DRUCKEN_CODE).setEnabled(false);
    					getAction(ACTION_REZEPTUR_DRUCKEN_LISTE_CODE).setEnabled(false);
    					getAction(ACTION_KALKULATION_DRUCKEN_CODE).setEnabled(false);
    					getAction(ACTION_SPEZIFIKATION_DRUCKEN_CODE).setEnabled(false);
    					getAction(ACTION_ZUTATENVERZEICHNIS_DRUCKEN_CODE).setEnabled(false);
    					getAction(ACTION_SPEZIFIKATION_DRUCKEN_KOMPLETT_CODE).setEnabled(false);
    					getAction(ACTION_SPEZIFIKATION_PDF_CODE).setEnabled(false);
    					getAction(ACTION_SPEZIFIKATION_PDF_KOMPLETT_CODE).setEnabled(false);
    					getAction(ACTION_DEPENDENCY_CALC_CODE).setEnabled(false);
    					getAction(ACTION_PROBE_NEU_CODE).setEnabled(false);
    					getAction(ACTION_DATENBLATT_CODE).setEnabled(false);
    					getAction(ACTION_BESTELLUNG_CODE).setEnabled(false);
    					getAction(ACTION_SHOW_CHANGES_CODE).setEnabled(true);
    					getAction(ACTION_DOKUMENTE_CODE).setEnabled(true);
    					getAction(ACTION_DOKUMENTE_ALLE_CODE).setEnabled(true);
       					getAction(ACTION_CONTENT_CODE).setEnabled(false);
    				break;
    		    case RzPro.TYP_ID_AUSSTATTUNG :
					getAction(ACTION_CALC_CODE).setEnabled(false);
					getAction(ACTION_VERBRAUCH_CODE).setEnabled(false);
					getAction(ACTION_VERBRAUCH_LISTE_CODE).setEnabled(false);
					getAction(ACTION_AUFSTAERKEN_CODE).setEnabled(false);
					getAction(ACTION_HERABSETZEN_CODE).setEnabled(false);
					getAction(ACTION_ZUGANG_CODE).setEnabled(false);
					getAction(ACTION_GEWICHT_CODE).setEnabled(false);
					getAction(ACTION_ABGANG_CODE).setEnabled(false);
					getAction(ACTION_STATISTIK_EINZELN_CODE).setEnabled(false);
					getAction(ACTION_STATISTIK_BESTAND_CODE).setEnabled(false);
					getAction(ACTION_STATISTIK_BESTAND_GRUPPE_CODE).setEnabled(false);
					getAction(ACTION_HINWEIS_CODE).setEnabled(true);
					getAction(ACTION_AUTOCALC_CODE).setEnabled(true);
					getAction(ACTION_AUTOCALC_SINGLE_CODE).setEnabled(true);
					getAction(ACTION_REZEPTUR_DRUCKEN_CODE).setEnabled(false);
					getAction(ACTION_REZEPTUR_DRUCKEN_LISTE_CODE).setEnabled(false);
					getAction(ACTION_KALKULATION_DRUCKEN_CODE).setEnabled(true);
					getAction(ACTION_SPEZIFIKATION_DRUCKEN_CODE).setEnabled(false);
					getAction(ACTION_ZUTATENVERZEICHNIS_DRUCKEN_CODE).setEnabled(false);
					getAction(ACTION_SPEZIFIKATION_DRUCKEN_KOMPLETT_CODE).setEnabled(false);
					getAction(ACTION_SPEZIFIKATION_PDF_CODE).setEnabled(false);
					getAction(ACTION_SPEZIFIKATION_PDF_KOMPLETT_CODE).setEnabled(false);
					getAction(ACTION_DEPENDENCY_CALC_CODE).setEnabled(true);
					getAction(ACTION_DUPLICATE_CODE).setEnabled(true);
					getAction(ACTION_PROBE_NEU_CODE).setEnabled(false);
					getAction(ACTION_SHOW_CHANGES_CODE).setEnabled(true);
					getAction(ACTION_DOKUMENTE_ALLE_CODE).setEnabled(true);
					getAction(ACTION_CONTENT_CODE).setEnabled(false);
					break;
    		}
    		lblPosition.setText("<html>" +
    				"<span style=\"color:#000000;background-color:#ffff00 ;\"><b>&nbsp;&nbsp; " +
    				(- (abfragen.getCount() - abfragen.getCurrentItemNumber()))  +
    				"&nbsp;&nbsp;</span>&nbsp;" +
        			(abfragen.getCurrentItem().getAdressListe().size() > 0?abfragen.getCurrentItem().getAdressListe().toHTMLShortString(3) + " ":"") +
        			(abfragen.getCurrentItem().getStichwortListe().size() > 0?abfragen.getCurrentItem().getStichwortListe().toHTMLShortString(1) + " ":"") +
        			" " + (abfragen.getCurrentItem().getTyp()==DBAbfrage.ABFRAGE_TYP_SQL?rz.getLocale().getString("abfragefenster.string_erweitert") :  abfragen.getCurrentItem().getMuster()) +
    				"</html>");
    	}
    	if(ergebnisse.size() > 0) {
			getAction(ACTION_STATISTIK_GRUPPE_CODE).setEnabled(true);
			getAction(ACTION_STATISTIK_BESTAND_GRUPPE_CODE).setEnabled(true);
			getAction(ACTION_ADRESSEN_GRUPPE_CODE).setEnabled(true);
			getAction(ACTION_AUTOCALC_CODE).setEnabled(true);
			getAction(ACTION_AUTOCALC_SINGLE_CODE).setEnabled(true);
			getAction(ACTION_DEPENDENCY_CALC_CODE).setEnabled(true);
    	} else {
			getAction(ACTION_STATISTIK_GRUPPE_CODE).setEnabled(false);
			getAction(ACTION_STATISTIK_BESTAND_GRUPPE_CODE).setEnabled(false);
			getAction(ACTION_ADRESSEN_GRUPPE_CODE).setEnabled(false);
			getAction(ACTION_AUTOCALC_CODE).setEnabled(false);
			getAction(ACTION_AUTOCALC_SINGLE_CODE).setEnabled(false);
			getAction(ACTION_DEPENDENCY_CALC_CODE).setEnabled(false);
    	}
    	
		if(abfragen.isListEmpty()) {
			getAction(ACTION_DELETE_HISTORY_CODE).setEnabled(false);
			getAction(ACTION_NAV_ANFANG_CODE).setEnabled(false);
			getAction(ACTION_NAV_ZURUECK_CODE).setEnabled(false);
			getAction(ACTION_NAV_VOR_CODE).setEnabled(false);
			getAction(ACTION_NAV_ENDE_CODE).setEnabled(false);
		}else {
			getAction(ACTION_DELETE_HISTORY_CODE).setEnabled(true);
			if (abfragen.isLast()) {
				getAction(ACTION_NAV_ANFANG_CODE).setEnabled(true);
				getAction(ACTION_NAV_ZURUECK_CODE).setEnabled(true);
				getAction(ACTION_NAV_VOR_CODE).setEnabled(false);
				getAction(ACTION_NAV_ENDE_CODE).setEnabled(false);
			} else {
				if(abfragen.isFirst()) {
    				getAction(ACTION_NAV_ANFANG_CODE).setEnabled(false);
    				getAction(ACTION_NAV_ZURUECK_CODE).setEnabled(false);
    				getAction(ACTION_NAV_VOR_CODE).setEnabled(true);
    				getAction(ACTION_NAV_ENDE_CODE).setEnabled(true);
				} else {
    				getAction(ACTION_NAV_ANFANG_CODE).setEnabled(true);
    				getAction(ACTION_NAV_ZURUECK_CODE).setEnabled(true);
    				getAction(ACTION_NAV_VOR_CODE).setEnabled(true);
    				getAction(ACTION_NAV_ENDE_CODE).setEnabled(true);
				}
			}
		}
    }

    private void abfrageNavigation(int n) {
    	AbfrageItem ai=null;
    	switch(n) {
    		case ACTION_NAV_ANFANG_CODE:
    			ai=abfragen.moveFirst();
    			break;
    		case ACTION_NAV_ENDE_CODE:
    			ai=abfragen.moveLast();
    			break;
    		case ACTION_NAV_VOR_CODE:
    			ai=abfragen.moveForward();
    			break;
    		case ACTION_NAV_ZURUECK_CODE:
    			ai=abfragen.moveBack();
    			break;
    	}
    	if(ai != null) {
    		showAbfrage(ai);
    		doAbfrage(ai);
    	}
    }
    /**
     * ergebnisTimerEvent zeigt an, dass eine Notiz/Rezeptur dargestellt werden
     * muss,
     */
    private void ergebnisTimerEvent(){
    	ergebnisTimer.stop();
        if (tblErgebnis.getSelectedRow() != -1){
            final ErgebnisItem ei =ergebnisse.getItem(tblErgebnis.getSelectedRow());
            rz.getAusgabeFactory().ergebnisAusgabe(ei.getID(),ei.getTyp(),txtErgebnis);
            setActions();
        }
        else {
            txtErgebnis.setEditable(true);
            txtErgebnis.setText("");
            txtErgebnis.setEditable(false);
        }
    }

    
    private void abfrageStatusAction(boolean status) {
        if(lstAbfragen.getSelectedIndex() != -1){
        	int id =((AbfrageItem)lstAbfragen.getSelectedValue()).getID();
        	AbfrageItem abfrage = rz.getDatabase().getAbfrage().dbGetAbfrage(id);
        	if(abfrage != null) {
        		rz.getDatabase().getAbfrage().updateAbfrageStatus(id, status);
        		abfrageRefreshAction();
        		setActions();
        	}
        }
    }
    
    private void verbrauchAction() {
    	if(tblErgebnis.getSelectedRow() != -1) {
            final ErgebnisItem ei =ergebnisse.getItem(tblErgebnis.getSelectedRow());
            if(ei != null ) {
            	if((ei.getTyp()==RzPro.TYP_ID_REZEPT) || (ei.getTyp() == RzPro.TYP_ID_VERWEIS)) {
                    rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_VERBRAUCH,false,new MessageItem(MessageItem.MSG_SHOW_VERBRAUCH_SINGLE,ei.getID(),null,this));
            	}
            }
		}
    }
    private void verbrauchListeAction() {
    	if(ergebnisse.size() > 0) {
    		final ArrayList liste= new ArrayList();
    		for(int i = 0;i<ergebnisse.size();i++) {
    			final ErgebnisItem ei = ergebnisse.getItem(i);;
                if((ei != null) && (((ei.getTyp()==RzPro.TYP_ID_REZEPT) || (ei.getTyp() == RzPro.TYP_ID_VERWEIS)))) {
                	liste.add(Integer.valueOf(ei.getID()));
                }
             }
            rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_VERBRAUCH,true,new MessageItem(MessageItem.MSG_SHOW_VERBRAUCH_LISTE,0,liste,this));
		}
    }

    /**
     * erzeugt alle Actions für das Fenster
     */

    public void createActions(){
        actionList.put(String.valueOf(ACTION_QUIT_CODE),new AuswahlAction(rz,this,ACTION_QUIT_CODE,ACTION_QUIT_TEXT, KeyEvent.VK_F4 ,KeyEvent.ALT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT,KeyEvent.VK_F5 ,KeyEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_ABFRAGE_AUSFUEHREN_CODE),new AuswahlAction(rz,this,ACTION_ABFRAGE_AUSFUEHREN_CODE,ACTION_ABFRAGE_AUSFUEHREN_TEXT,KeyEvent.VK_Q ,KeyEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_ADRESSFENSTER_CODE),new AuswahlAction(rz,this,ACTION_ADRESSFENSTER_CODE,ACTION_ADRESSFENSTER_TEXT,KeyEvent.VK_A ,KeyEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_REPORTFENSTER_CODE),new AuswahlAction(rz,this,ACTION_REPORTFENSTER_CODE,ACTION_REPORTFENSTER_TEXT,KeyEvent.VK_R ,KeyEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_EINSTELLUNGSFENSTER_CODE),new AuswahlAction(rz,this,ACTION_EINSTELLUNGSFENSTER_CODE,ACTION_EINSTELLUNGSFENSTER_TEXT,KeyEvent.VK_F12 ,0));
        actionList.put(String.valueOf(ACTION_NEUE_NOTIZ_CODE),new AuswahlAction(rz,this,ACTION_NEUE_NOTIZ_CODE,ACTION_NEUE_NOTIZ_TEXT,KeyEvent.VK_F6 ,KeyEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_ABFRAGE_AUSFUEHREN_CODE),new AuswahlAction(rz,this,ACTION_ABFRAGE_AUSFUEHREN_CODE,ACTION_ABFRAGE_AUSFUEHREN_TEXT,KeyEvent.VK_F ,KeyEvent.CTRL_DOWN_MASK));
		actionList.put(String.valueOf(ACTION_ABFRAGE_NEU_CODE),new AuswahlAction(rz,this,ACTION_ABFRAGE_NEU_CODE,ACTION_ABFRAGE_NEU_TEXT, KeyEvent.VK_N ,KeyEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_ABFRAGE_ADRESSEN_CODE),new AuswahlAction(rz,this,ACTION_ABFRAGE_ADRESSEN_CODE,ACTION_ABFRAGE_ADRESSEN_TEXT, KeyEvent.VK_D ,KeyEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_ABFRAGE_STICHWORTE_CODE),new AuswahlAction(rz,this,ACTION_ABFRAGE_STICHWORTE_CODE,ACTION_ABFRAGE_STICHWORTE_TEXT, KeyEvent.VK_S ,KeyEvent.SHIFT_DOWN_MASK + KeyEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_ABFRAGE_ADRESSEN_LOESCHEN_CODE),new AuswahlAction(rz,this,ACTION_ABFRAGE_ADRESSEN_LOESCHEN_CODE,ACTION_ABFRAGE_ADRESSEN_LOESCHEN_TEXT, KeyEvent.VK_L ,KeyEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_ABFRAGE_STICHWORTE_LOESCHEN_CODE),new AuswahlAction(rz,this,ACTION_ABFRAGE_STICHWORTE_LOESCHEN_CODE,ACTION_ABFRAGE_STICHWORTE_LOESCHEN_TEXT, KeyEvent.VK_W ,KeyEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_ABFRAGE_REFRESH_CODE),new AuswahlAction(rz,this,ACTION_ABFRAGE_REFRESH_CODE,ACTION_ABFRAGE_REFRESH_TEXT, KeyEvent.VK_F5 ,KeyEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_ABFRAGE_SPEICHERN_CODE),new AuswahlAction(rz,this,ACTION_ABFRAGE_SPEICHERN_CODE,ACTION_ABFRAGE_SPEICHERN_TEXT, KeyEvent.VK_G ,KeyEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_ABFRAGE_USE_CODE),new AuswahlAction(rz,this,ACTION_ABFRAGE_USE_CODE,ACTION_ABFRAGE_USE_TEXT, KeyEvent.VK_U ,KeyEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_ABFRAGE_GO_CODE),new AuswahlAction(rz,this,ACTION_ABFRAGE_GO_CODE,ACTION_ABFRAGE_GO_TEXT, KeyEvent.VK_I ,KeyEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_ABFRAGE_LOESCHEN_CODE),new AuswahlAction(rz,this,ACTION_ABFRAGE_LOESCHEN_CODE,ACTION_ABFRAGE_LOESCHEN_TEXT, KeyEvent.VK_J ,KeyEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_NAVIGATION_SAVED_CODE),new AuswahlAction(rz,this,ACTION_NAVIGATION_SAVED_CODE,ACTION_NAVIGATION_SAVED_TEXT, KeyEvent.VK_F1 ,KeyEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_NAVIGATION_MUSTER_CODE),new AuswahlAction(rz,this,ACTION_NAVIGATION_MUSTER_CODE,ACTION_NAVIGATION_MUSTER_TEXT, KeyEvent.VK_F2 ,KeyEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_NAVIGATION_ERGEBNIS_CODE),new AuswahlAction(rz,this,ACTION_NAVIGATION_ERGEBNIS_CODE,ACTION_NAVIGATION_ERGEBNIS_TEXT, KeyEvent.VK_F3 ,KeyEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_DRUCKEN_CODE),new AuswahlAction(rz,this,ACTION_DRUCKEN_CODE,ACTION_DRUCKEN_TEXT, KeyEvent.VK_P,KeyEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_BEARBEITEN_CODE),new AuswahlAction(rz,this,ACTION_BEARBEITEN_CODE,ACTION_BEARBEITEN_TEXT, KeyEvent.VK_F2,0));
        actionList.put(String.valueOf(ACTION_LOESCHEN_CODE),new AuswahlAction(rz,this,ACTION_LOESCHEN_CODE,ACTION_LOESCHEN_TEXT, KeyEvent.VK_DELETE,0));
        actionList.put(String.valueOf(ACTION_KALKULATION_CODE),new AuswahlAction(rz,this,ACTION_KALKULATION_CODE,ACTION_KALKULATION_TEXT, KeyEvent.VK_4,KeyEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_LAGER_CODE),new AuswahlAction(rz,this,ACTION_LAGER_CODE,ACTION_LAGER_TEXT, KeyEvent.VK_L,KeyEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT, KeyEvent.VK_F1,0));
        actionList.put(String.valueOf(ACTION_NEUE_REZEPTUR_CODE),new AuswahlAction(rz,this,ACTION_NEUE_REZEPTUR_CODE,ACTION_NEUE_REZEPTUR_TEXT, KeyEvent.VK_F6,0));
        actionList.put(String.valueOf(ACTION_VERWENDUNG_CODE),new AuswahlAction(rz,this,ACTION_VERWENDUNG_CODE,ACTION_VERWENDUNG_TEXT, KeyEvent.VK_F11,0));
        actionList.put(String.valueOf(ACTION_VERWENDUNG_EINZELN_CODE),new AuswahlAction(rz,this,ACTION_VERWENDUNG_EINZELN_CODE,ACTION_VERWENDUNG_EINZELN_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_ZUTATEN_CODE),new AuswahlAction(rz,this,ACTION_ZUTATEN_CODE,ACTION_ZUTATEN_TEXT, KeyEvent.VK_Z,KeyEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_UND_GRUPPE_CODE),new AuswahlAction(rz,this,ACTION_UND_GRUPPE_CODE ,ACTION_UND_GRUPPE_TEXT,KeyEvent.VK_F11,KeyEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_ODER_GRUPPE_CODE),new AuswahlAction(rz,this,ACTION_ODER_GRUPPE_CODE,ACTION_ODER_GRUPPE_TEXT, KeyEvent.VK_F11,KeyEvent.CTRL_DOWN_MASK + KeyEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_ADRESSEN_GRUPPE_CODE),new AuswahlAction(rz,this,ACTION_ADRESSEN_GRUPPE_CODE,ACTION_ADRESSEN_GRUPPE_TEXT, KeyEvent.VK_F11,KeyEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_ADRESSEN_CODE),new AuswahlAction(rz,this,ACTION_ADRESSEN_CODE,ACTION_ADRESSEN_TEXT, KeyEvent.VK_F11,KeyEvent.SHIFT_DOWN_MASK+KeyEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_NEUE_REZEPTUR_GRUPPE_CODE),new AuswahlAction(rz,this,ACTION_NEUE_REZEPTUR_GRUPPE_CODE,ACTION_NEUE_REZEPTUR_GRUPPE_TEXT, KeyEvent.VK_F6,KeyEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_NEUE_NOTIZ_GRUPPE_CODE),new AuswahlAction(rz,this,ACTION_NEUE_NOTIZ_GRUPPE_CODE,ACTION_NEUE_NOTIZ_GRUPPE_TEXT, KeyEvent.VK_F6,KeyEvent.CTRL_DOWN_MASK + KeyEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_DUPLICATE_CODE),new AuswahlAction(rz,this,ACTION_DUPLICATE_CODE,ACTION_DUPLICATE_TEXT, KeyEvent.VK_D,KeyEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_CALC_CODE),new AuswahlAction(rz,this,ACTION_CALC_CODE,ACTION_CALC_TEXT, KeyEvent.VK_F3,0));
        actionList.put(String.valueOf(ACTION_HERABSETZEN_CODE),new AuswahlAction(rz,this,ACTION_HERABSETZEN_CODE,ACTION_HERABSETZEN_TEXT, KeyEvent.VK_F8,0));
        actionList.put(String.valueOf(ACTION_AUFSTAERKEN_CODE),new AuswahlAction(rz,this,ACTION_AUFSTAERKEN_CODE,ACTION_AUFSTAERKEN_TEXT, KeyEvent.VK_F9,0));
        actionList.put(String.valueOf(ACTION_LIEFERSCHEIN_CODE),new AuswahlAction(rz,this,ACTION_LIEFERSCHEIN_CODE,ACTION_LIEFERSCHEIN_TEXT, KeyEvent.VK_F4,0));
        actionList.put(String.valueOf(ACTION_LIEFERSCHEIN_LISTE_CODE),new AuswahlAction(rz,this,ACTION_LIEFERSCHEIN_LISTE_CODE,ACTION_LIEFERSCHEIN_LISTE_TEXT, KeyEvent.VK_F4,KeyEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_BEHAELTER_CODE),new AuswahlAction(rz,this,ACTION_BEHAELTER_CODE,ACTION_BEHAELTER_TEXT, KeyEvent.VK_B,KeyEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_ETIKETTEN_CODE),new AuswahlAction(rz,this,ACTION_ETIKETTEN_CODE,ACTION_ETIKETTEN_TEXT, KeyEvent.VK_E,KeyEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_TAFEL_CODE),new AuswahlAction(rz,this,ACTION_TAFEL_CODE,ACTION_TAFEL_TEXT, KeyEvent.VK_F12,KeyEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_ZUGANG_CODE),new AuswahlAction(rz,this,ACTION_ZUGANG_CODE,ACTION_ZUGANG_TEXT, KeyEvent.VK_F7,KeyEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_ABGANG_CODE),new AuswahlAction(rz,this,ACTION_ABGANG_CODE,ACTION_ABGANG_TEXT, KeyEvent.VK_F7,KeyEvent.CTRL_DOWN_MASK + KeyEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_STATISTIK_EINZELN_CODE),new AuswahlAction(rz,this,ACTION_STATISTIK_EINZELN_CODE,ACTION_STATISTIK_EINZELN_TEXT, KeyEvent.VK_S,KeyEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_STATISTIK_GRUPPE_CODE),new AuswahlAction(rz,this,ACTION_STATISTIK_GRUPPE_CODE,ACTION_STATISTIK_GRUPPE_TEXT, KeyEvent.VK_S,KeyEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_STATISTIK_BESTAND_CODE),new AuswahlAction(rz,this,ACTION_STATISTIK_BESTAND_CODE,ACTION_STATISTIK_BESTAND_TEXT, KeyEvent.VK_S,KeyEvent.SHIFT_DOWN_MASK + KeyEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_STATISTIK_BESTAND_GRUPPE_CODE),new AuswahlAction(rz,this,ACTION_STATISTIK_BESTAND_GRUPPE_CODE,ACTION_STATISTIK_BESTAND_GRUPPE_TEXT, KeyEvent.VK_S,KeyEvent.SHIFT_DOWN_MASK+ KeyEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_HERSTELLFENSTER_CODE),new AuswahlAction(rz,this,ACTION_HERSTELLFENSTER_CODE,ACTION_HERSTELLFENSTER_TEXT, KeyEvent.VK_H,KeyEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_VERLAUF_CODE),new AuswahlAction(rz,this,ACTION_VERLAUF_CODE,ACTION_VERLAUF_TEXT, KeyEvent.VK_U,KeyEvent.CTRL_DOWN_MASK + KeyEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_ABOUT_CODE),new AuswahlAction(rz,this,ACTION_ABOUT_CODE,ACTION_ABOUT_TEXT, KeyEvent.VK_F12,KeyEvent.CTRL_DOWN_MASK+KeyEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_LOGGING_CODE),new AuswahlAction(rz,this,ACTION_LOGGING_CODE,ACTION_LOGGING_TEXT, KeyEvent.VK_L,KeyEvent.CTRL_DOWN_MASK+KeyEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_AUSBEUTE_CODE),new AuswahlAction(rz,this,ACTION_AUSBEUTE_CODE,ACTION_AUSBEUTE_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_HINWEIS_CODE),new AuswahlAction(rz,this,ACTION_HINWEIS_CODE,ACTION_HINWEIS_TEXT, KeyEvent.VK_F2,KeyEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_AUTOCALC_CODE),new AuswahlAction(rz,this,ACTION_AUTOCALC_CODE,ACTION_AUTOCALC_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_AUTOCALC_SINGLE_CODE),new AuswahlAction(rz,this,ACTION_AUTOCALC_SINGLE_CODE,ACTION_AUTOCALC_SINGLE_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_REZEPTUR_DRUCKEN_CODE),new AuswahlAction(rz,this,ACTION_REZEPTUR_DRUCKEN_CODE,ACTION_REZEPTUR_DRUCKEN_TEXT, KeyEvent.VK_R,KeyEvent.CTRL_DOWN_MASK + KeyEvent.ALT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_KALKULATION_DRUCKEN_CODE),new AuswahlAction(rz,this,ACTION_KALKULATION_DRUCKEN_CODE,ACTION_KALKULATION_DRUCKEN_TEXT, KeyEvent.VK_K,KeyEvent.CTRL_DOWN_MASK + KeyEvent.ALT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_SPEZIFIKATION_DRUCKEN_CODE),new AuswahlAction(rz,this,ACTION_SPEZIFIKATION_DRUCKEN_CODE,ACTION_SPEZIFIKATION_DRUCKEN_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_SPEZIFIKATION_DRUCKEN_KOMPLETT_CODE),new AuswahlAction(rz,this,ACTION_SPEZIFIKATION_DRUCKEN_KOMPLETT_CODE,ACTION_SPEZIFIKATION_DRUCKEN_KOMPLETT_TEXT, KeyEvent.VK_P,KeyEvent.CTRL_DOWN_MASK + KeyEvent.ALT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_DEPENDENCY_CALC_CODE),new AuswahlAction(rz,this,ACTION_DEPENDENCY_CALC_CODE,ACTION_DEPENDENCY_CALC_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_PALETTEN_CODE),new AuswahlAction(rz,this,ACTION_PALETTEN_CODE,ACTION_PALETTEN_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_PALETTENRECHNER_CODE),new AuswahlAction(rz,this,ACTION_PALETTENRECHNER_CODE,ACTION_PALETTENRECHNER_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_ABFRAGE_ERWEITERT_CODE),new AuswahlAction(rz,this,ACTION_ABFRAGE_ERWEITERT_CODE,ACTION_ABFRAGE_ERWEITERT_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_INVENTUR_CODE),new AuswahlAction(rz,this,ACTION_INVENTUR_CODE,ACTION_INVENTUR_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_ACIDLISTE_CODE),new AuswahlAction(rz,this,ACTION_ACIDLISTE_CODE,ACTION_ACIDLISTE_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_ACIDRECHNER_CODE),new AuswahlAction(rz,this,ACTION_ACIDRECHNER_CODE,ACTION_ACIDRECHNER_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_DEKLARATIONEN_CODE),new AuswahlAction(rz,this,ACTION_DEKLARATIONEN_CODE,ACTION_DEKLARATIONEN_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_NEUE_AUSSTATTUNG_CODE),new AuswahlAction(rz,this,ACTION_NEUE_AUSSTATTUNG_CODE,ACTION_NEUE_AUSSTATTUNG_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_NEUE_AUSSTATTUNG_GRUPPE_CODE),new AuswahlAction(rz,this,ACTION_NEUE_AUSSTATTUNG_GRUPPE_CODE,ACTION_NEUE_AUSSTATTUNG_GRUPPE_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_DATENBLATT_CODE),new AuswahlAction(rz,this,ACTION_DATENBLATT_CODE,ACTION_DATENBLATT_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_REZEPTUR_DRUCKEN_LISTE_CODE),new AuswahlAction(rz,this,ACTION_REZEPTUR_DRUCKEN_LISTE_CODE,ACTION_REZEPTUR_DRUCKEN_LISTE_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_BESTELLUNGSLISTENFENSTER_CODE),new AuswahlAction(rz,this,ACTION_BESTELLUNGSLISTENFENSTER_CODE,ACTION_BESTELLUNGSLISTENFENSTER_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_BESTELLUNG_CODE),new AuswahlAction(rz,this,ACTION_BESTELLUNG_CODE,ACTION_BESTELLUNG_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_BESTANDSWARNUNG_CODE),new AuswahlAction(rz,this,ACTION_BESTANDSWARNUNG_CODE,ACTION_BESTANDSWARNUNG_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_LABORWERTLISTE_CODE),new AuswahlAction(rz,this,ACTION_LABORWERTLISTE_CODE,ACTION_LABORWERTLISTE_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_PROBE_CODE),new AuswahlAction(rz,this,ACTION_PROBE_CODE,ACTION_PROBE_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_PROBE_NEU_CODE),new AuswahlAction(rz,this,ACTION_PROBE_NEU_CODE,ACTION_PROBE_NEU_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_NAV_ANFANG_CODE),new AuswahlAction(rz,this,ACTION_NAV_ANFANG_CODE,ACTION_NAV_ANFANG_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_NAV_ZURUECK_CODE),new AuswahlAction(rz,this,ACTION_NAV_ZURUECK_CODE,ACTION_NAV_ZURUECK_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_NAV_VOR_CODE),new AuswahlAction(rz,this,ACTION_NAV_VOR_CODE,ACTION_NAV_VOR_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_NAV_ENDE_CODE),new AuswahlAction(rz,this,ACTION_NAV_ENDE_CODE,ACTION_NAV_ENDE_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_ZUTATENVERZEICHNIS_EINSTELLUNGEN_CODE),new AuswahlAction(rz,this,ACTION_ZUTATENVERZEICHNIS_EINSTELLUNGEN_CODE,ACTION_ZUTATENVERZEICHNIS_EINSTELLUNGEN_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_ZUTATENVERZEICHNIS_DRUCKEN_CODE),new AuswahlAction(rz,this,ACTION_ZUTATENVERZEICHNIS_DRUCKEN_CODE,ACTION_ZUTATENVERZEICHNIS_DRUCKEN_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_SPEZIFIKATION_PDF_CODE),new AuswahlAction(rz,this,ACTION_SPEZIFIKATION_PDF_CODE,ACTION_SPEZIFIKATION_PDF_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_SPEZIFIKATION_PDF_KOMPLETT_CODE),new AuswahlAction(rz,this,ACTION_SPEZIFIKATION_PDF_KOMPLETT_CODE,ACTION_SPEZIFIKATION_PDF_KOMPLETT_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_VERBRAUCH_CODE),new AuswahlAction(rz,this,ACTION_VERBRAUCH_CODE,ACTION_VERBRAUCH_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_VERBRAUCH_LISTE_CODE),new AuswahlAction(rz,this,ACTION_VERBRAUCH_LISTE_CODE,ACTION_VERBRAUCH_LISTE_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_CONTAINER_RETURN_CODE),new AuswahlAction(rz,this,ACTION_CONTAINER_RETURN_CODE,ACTION_CONTAINER_RETURN_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_DELETE_HISTORY_CODE),new AuswahlAction(rz,this,ACTION_DELETE_HISTORY_CODE,ACTION_DELETE_HISTORY_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_GEWICHT_CODE),new AuswahlAction(rz,this,ACTION_GEWICHT_CODE,ACTION_GEWICHT_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_ABFRAGE_PRIVAT_CODE),new AuswahlAction(rz,this,ACTION_ABFRAGE_PRIVAT_CODE,ACTION_ABFRAGE_PRIVAT_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_ABFRAGE_PUBLIC_CODE),new AuswahlAction(rz,this,ACTION_ABFRAGE_PUBLIC_CODE,ACTION_ABFRAGE_PUBLIC_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_LISTE_DRUCKEN_CODE),new AuswahlAction(rz,this,ACTION_LISTE_DRUCKEN_CODE,ACTION_LISTE_DRUCKEN_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_BESTANDSWARNUNG_DRUCKEN_CODE),new AuswahlAction(rz,this,ACTION_BESTANDSWARNUNG_DRUCKEN_CODE,ACTION_BESTANDSWARNUNG_DRUCKEN_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_BESTANDSWARNUNG_UEBERTRAGEN_CODE),new AuswahlAction(rz,this,ACTION_BESTANDSWARNUNG_UEBERTRAGEN_CODE,ACTION_BESTANDSWARNUNG_UEBERTRAGEN_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_SHOW_LOSNUMMER_VORLAGE_CODE),new AuswahlAction(rz,this,ACTION_SHOW_LOSNUMMER_VORLAGE_CODE,ACTION_SHOW_LOSNUMMER_VORLAGE_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_SHOW_KALENDER_CODE),new AuswahlAction(rz,this,ACTION_SHOW_KALENDER_CODE,ACTION_SHOW_KALENDER_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_SHOW_AUFTRAG_CODE),new AuswahlAction(rz,this,ACTION_SHOW_AUFTRAG_CODE,ACTION_SHOW_AUFTRAG_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_SHOW_CHANGES_CODE),new AuswahlAction(rz,this,ACTION_SHOW_CHANGES_CODE,ACTION_SHOW_CHANGES_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_SHOW_AUFTRAGSLISTE_CODE),new AuswahlAction(rz,this,ACTION_SHOW_AUFTRAGSLISTE_CODE,ACTION_SHOW_AUFTRAGSLISTE_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_SHOW_CHANGES_LISTE_CODE),new AuswahlAction(rz,this,ACTION_SHOW_CHANGES_LISTE_CODE,ACTION_SHOW_CHANGES_LISTE_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_SHOW_MHD_CODE),new AuswahlAction(rz,this,ACTION_SHOW_MHD_CODE,ACTION_SHOW_MHD_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_ADD_ETIKETTENLISTE_CODE),new AuswahlAction(rz,this,ACTION_ADD_ETIKETTENLISTE_CODE,ACTION_ADD_ETIKETTENLISTE_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_BESTANDSLISTENDRUCK_CODE),new AuswahlAction(rz,this,ACTION_BESTANDSLISTENDRUCK_CODE,ACTION_LISTENDRUCK_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_TEMPERATURZONEN_CODE),new AuswahlAction(rz,this,ACTION_TEMPERATURZONEN_CODE,ACTION_TEMPERATURZONEN_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_AUFTRAGSLISTE_REFRESH_CODE),new AuswahlAction(rz,this,ACTION_AUFTRAGSLISTE_REFRESH_CODE,ACTION_AUFTRAGSLISTE_REFRESH_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_AUFTRAGSLISTE_DRUCKEN_CODE),new AuswahlAction(rz,this,ACTION_AUFTRAGSLISTE_DRUCKEN_CODE,ACTION_AUFTRAGSLISTE_DRUCKEN_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_ANFRAGENLISTE_REFRESH_CODE),new AuswahlAction(rz,this,ACTION_ANFRAGENLISTE_REFRESH_CODE,ACTION_ANFRAGENLISTE_REFRESH_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_ANFRAGENLISTE_DRUCKEN_CODE),new AuswahlAction(rz,this,ACTION_ANFRAGENLISTE_DRUCKEN_CODE,ACTION_ANFRAGENLISTE_DRUCKEN_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_SHOW_ANFRAGENLISTE_CODE),new AuswahlAction(rz,this,ACTION_SHOW_ANFRAGENLISTE_CODE,ACTION_SHOW_ANFRAGENLISTE_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_AUFTRAGSLISTE_DRUCKEN_EIGENE_CODE),new AuswahlAction(rz,this,ACTION_AUFTRAGSLISTE_DRUCKEN_EIGENE_CODE,ACTION_AUFTRAGSLISTE_DRUCKEN_EIGENE_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_SHOW_TANKLISTE_CODE),new AuswahlAction(rz,this,ACTION_SHOW_TANKLISTE_CODE,ACTION_SHOW_TANKLISTE_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_SHOW_DMLISTE_CODE),new AuswahlAction(rz,this,ACTION_SHOW_DMLISTE_CODE,ACTION_SHOW_DMLISTE_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_SHOW_KONFORM_CODE),new AuswahlAction(rz,this,ACTION_SHOW_KONFORM_CODE,ACTION_SHOW_KONFORM_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_AUFTRAG_SUCHEN_CODE),new AuswahlAction(rz,this,ACTION_AUFTRAG_SUCHEN_CODE,ACTION_AUFTRAG_SUCHEN_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_AUFTRAG_ANZEIGEN_CODE),new AuswahlAction(rz,this,ACTION_AUFTRAG_ANZEIGEN_CODE,ACTION_AUFTRAG_ANZEIGEN_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_AUFTRAG_RECHNEN_CODE),new AuswahlAction(rz,this,ACTION_AUFTRAG_RECHNEN_CODE,ACTION_AUFTRAG_RECHNEN_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_AUFTRAG_LOESCHEN_CODE),new AuswahlAction(rz,this,ACTION_AUFTRAG_LOESCHEN_CODE,ACTION_AUFTRAG_LOESCHEN_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_SHOW_MISCHUNGSFENSTER_CODE),new AuswahlAction(rz,this,ACTION_SHOW_MISCHUNGSFENSTER_CODE,ACTION_SHOW_MISCHUNGSFENSTER_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_SHOW_BEWERTUNGEN_CODE),new AuswahlAction(rz,this,ACTION_SHOW_BEWERTUNGEN_CODE,ACTION_SHOW_BEWERTUNGEN_TEXT, 0,0));
       	actionList.put(String.valueOf(ACTION_PRIORITY_CODE),new AuswahlAction(rz,this,ACTION_PRIORITY_CODE,ACTION_PRIORITY_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_AUFTRAG_STATUS_CODE),new AuswahlAction(rz,this,ACTION_AUFTRAG_STATUS_CODE,ACTION_AUFTRAG_STATUS_TEXT, 0,0));     
        actionList.put(String.valueOf(ACTION_AUFTRAG_ENTFERNEN_CODE),new AuswahlAction(rz,this,ACTION_AUFTRAG_ENTFERNEN_CODE,ACTION_AUFTRAG_ENTFERNEN_TEXT, 0,0)); 
        actionList.put(String.valueOf(ACTION_VERGLEICH_1_CODE),new AuswahlAction(rz,this,ACTION_VERGLEICH_1_CODE,ACTION_VERGLEICH_1_TEXT, KeyEvent.VK_1,KeyEvent.CTRL_DOWN_MASK)); 
        actionList.put(String.valueOf(ACTION_VERGLEICH_2_CODE),new AuswahlAction(rz,this,ACTION_VERGLEICH_2_CODE,ACTION_VERGLEICH_2_TEXT, KeyEvent.VK_2,KeyEvent.CTRL_DOWN_MASK)); 
        actionList.put(String.valueOf(ACTION_BESTANDSWARNUNG_AUSWAHL_CODE),new AuswahlAction(rz,this,ACTION_BESTANDSWARNUNG_AUSWAHL_CODE,ACTION_BESTANDSWARNUNG_AUSWAHL_TEXT, 0,0)); 
        actionList.put(String.valueOf(ACTION_BESTANDSWARNUNG_CLEAR_CODE),new AuswahlAction(rz,this,ACTION_BESTANDSWARNUNG_CLEAR_CODE,ACTION_BESTANDSWARNUNG_CLEAR_TEXT, 0,0)); 
        actionList.put(String.valueOf(ACTION_ZUTATENLISTE_CODE),new AuswahlAction(rz,this,ACTION_ZUTATENLISTE_CODE,ACTION_ZUTATENLISTE_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_DRUCKFORMULARE_CODE),new AuswahlAction(rz,this,ACTION_DRUCKFORMULARE_CODE,ACTION_DRUCKFORMULARE_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_MUSTER_SUCHEN_CODE),new AuswahlAction(rz,this,ACTION_MUSTER_SUCHEN_CODE,ACTION_MUSTER_SUCHEN_TEXT,  KeyEvent.VK_U ,KeyEvent.ALT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_DOKUMENTE_CODE),new AuswahlAction(rz,this,ACTION_DOKUMENTE_CODE,ACTION_DOKUMENTE_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_DOKUMENTE_ALLE_CODE),new AuswahlAction(rz,this,ACTION_DOKUMENTE_ALLE_CODE,ACTION_DOKUMENTE_ALLE_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_DOKUMENTE_FILTER_CODE),new AuswahlAction(rz,this,ACTION_DOKUMENTE_FILTER_CODE,ACTION_DOKUMENTE_FILTER_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_ZUTATEN_ALLE_CODE),new AuswahlAction(rz,this,ACTION_ZUTATEN_ALLE_CODE,ACTION_ZUTATEN_ALLE_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_CONTENT_CODE),new AuswahlAction(rz,this,ACTION_CONTENT_CODE,ACTION_CONTENT_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_AUFTRAGSLISTE_SUCHEN_CODE),new AuswahlAction(rz,this,ACTION_AUFTRAGSLISTE_SUCHEN_CODE,ACTION_AUFTRAGSLISTE_SUCHEN_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_AUFTRAGSLISTE_SUCHEN_CLEAR_CODE),new AuswahlAction(rz,this,ACTION_AUFTRAGSLISTE_SUCHEN_CLEAR_CODE,ACTION_AUFTRAGSLISTE_SUCHEN_CLEAR_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_SHOW_KONTRAKTE_CODE),new AuswahlAction(rz,this,ACTION_SHOW_KONTRAKTE_CODE,ACTION_SHOW_KONTRAKTE_TEXT, 0,0));

    }

    private void spinnerChanged(JSpinner origin,javax.swing.event.ChangeEvent evt) {
    	int m=1;
    	final int v = ((Integer)this.splBestandswarnung.getValue()).intValue();
    	if (v <= 1) {
    		m=1;
    	} 	else {
    		if (v > RzPro.MAX_BESTANDSWARNUNG_INTERVAL) {
    			m = RzPro.MAX_BESTANDSWARNUNG_INTERVAL;
    		} else {
    			m=v;
    		}
    	}
    	this.splBestandswarnung.setValue(Integer.valueOf(m));
    	if(this.bestandswarnungsTimer != null) {
    		if (bestandswarnungsTimer.isRunning()){
    			bestandswarnungsTimer.stop();
    		}
    		bestandswarnungsTimer.setDelay(m * MILLISECONDS_PER_MINUTE);
    		bestandswarnungsTimer.start();
    	}
    }

    private void anfragenlisteSpinnerChanged(JSpinner origin,javax.swing.event.ChangeEvent evt) {
    	int m=1;
    	final int v = ((Integer)this.splAnfragenliste.getValue()).intValue();
    	if (v <= 1) {
    		m=1;
    	} 	else {
    		if (v > RzPro.MAX_AUFTRAGSLISTE_INTERVAL) {
    			m = RzPro.MAX_AUFTRAGSLISTE_INTERVAL;
    		} else {
    			m=v;
    		}
    	}
    	this.splAnfragenliste.setValue(Integer.valueOf(m));
    	if(this.anfragenlisteTimer != null) {
    		if (anfragenlisteTimer.isRunning()){
    			anfragenlisteTimer.stop();
    		}
    		anfragenlisteTimer.setDelay(m * MILLISECONDS_PER_MINUTE);
    		anfragenlisteTimer.start();
    	}
    }
    
    private void AuftragslisteSpinnerChanged(JSpinner origin,javax.swing.event.ChangeEvent evt) {
    	int m=1;
    	final int v = ((Integer)this.splAuftragsliste.getValue()).intValue();
    	if (v <= 1) {
    		m=1;
    	} 	else {
    		if (v > RzPro.MAX_AUFTRAGSLISTE_INTERVAL) {
    			m = RzPro.MAX_AUFTRAGSLISTE_INTERVAL;
    		} else {
    			m=v;
    		}
    	}
    	this.splAuftragsliste.setValue(Integer.valueOf(m));
    	if(this.auftragslisteTimer != null) {
    		if (auftragslisteTimer.isRunning()){
    			auftragslisteTimer.stop();
    		}
    		auftragslisteTimer.setDelay(m * MILLISECONDS_PER_MINUTE);
    		auftragslisteTimer.start();
    	}
    }



    public void openWindow(){
        abfrageRefreshAction();
    	setActions();
    	bestandsWarnungsAction();
        if(!isVisible()) {
    		tblErgebnis.setShowGrid(true);
        	setTerminLabel();
    		setVisible(true);
    		setWindowCaption();
		}
        toFront();
        txtMuster.requestFocus();
    }


    
    /**------------------------------------------------------------------------
     * AbfrageListe
     *-------------------------------------------------------------------------
     */




    /**-----------------------------------------------------------------------
     * die GUI Abfrage im Fenster darstellen
     *------------------------------------------------------------------------
     */
    private void showAbfrage(AbfrageItem ai){
        lblRzStichworte.setListData(ai.getStichwortListe());
        lblRzAdressen.setListData(ai.getAdressListe());
        chkAblage.setSelected(ai.isAblage());
        if(ai.getTyp()==DBAbfrage.ABFRAGE_TYP_NORMAL) {
        	txtMuster.setText(ai.getMuster());
        } else {
        	try {
        		if(ai.getTyp()==DBAbfrage.ABFRAGE_TYP_BESTANDSWARNUNG) {
            		txtMuster.setText(rz.getLocale().getString("abfragefenster.string_bestandswarnung"));
        		}else {
            		txtMuster.setText(rz.getLocale().getString("abfragefenster.string_erweitert"));
        		}
        	}catch (final Exception e) {
        		txtMuster.setText(rz.getLocale().getString("abfragefenster.string_erweitert"));
        	}
        }
        cmbSort.setSelectedIndex(ai.getOrder());
        cmbAbfrageModus.setSelectedIndex(ai.getMode());
        if (ai.getAMode()== DBAbfrage.ABFRAGE_MODE_AND) {
			adressenGroup.setSelected(this.btAdressenModeAnd.getModel(), true);
		} else {
			adressenGroup.setSelected(this.btAdressenModeOr.getModel(), true);
		}

        if (ai.getSMode()== DBAbfrage.ABFRAGE_MODE_AND) {
			stichworteGroup.setSelected(this.btStichworteModeAnd.getModel(), true);
		} else {
			stichworteGroup.setSelected(this.btStichworteModeOr.getModel(), true);
		}
    }

    /**-----------------------------------------------------------------------
     * eine Abfrage zur Liste hinzufügen;
     *------------------------------------------------------------------------
     */
    public void addAbfrage(AbfrageItem ai){
        abfragen.addItem(ai);
        abfrage.setAdressListe(ai.getAdressListe());
        abfrage.setStichwortListe(ai.getStichwortListe());
        showAbfrage(abfragen.getCurrentItem());
        doAbfrage(abfragen.getCurrentItem());
    }


    /**------------------------------------------------------------------------
     * eine Abfrage ausführen
     *-------------------------------------------------------------------------
     */
    private void doAbfrage(AbfrageItem ai){
        rz.setWaitCursor(this); 
        if(ai.getTyp()==DBAbfrage.ABFRAGE_TYP_BESTANDSWARNUNG) {
        	ergebnisse=rz.getDatabase().getErgebnis().dbGetErgebnisListeBW();
        }else {
        	ergebnisse= rz.getDatabase().getErgebnis().dbGetErgebnisListe(ai);
        }
        ((AbstractTableModel)tblErgebnis.getModel()).fireTableDataChanged();
        rz.setFreeCursor(this);
        this.lblErgebnisCount.setText(rz.getLocale().getString("auswahl.ergebnis_count").replaceAll("%s",String.valueOf(ergebnisse.size())));
        rz.getAusgabeFactory().historyAusgabe(txtHistory, abfragen);
        tblErgebnis.requestFocus();
        try {
            tblErgebnis.setRowSelectionInterval(0,0);
            tblErgebnis.scrollRectToVisible(tblErgebnis.getCellRect(0,0,true));
        } catch (Exception e) {};
       	setActions();
		tblErgebnis.setShowGrid(true);
    }

    
    /**
     * Doppelklick in der ErgebnisListe
     */
    private void ergebnisDoubleClick(){
    	calcAction();
    }
    /**
     * Zeigt das Fenster zur erweiterten Auswahl an
     *
     */
    private void abfrageErweitertAction() {
	        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_ABFRAGE_ERWEITERT,false,new MessageItem(MessageItem.MSG_ABFRAGE_ERWEITERT,0,null,this));
    }


    /**
     * im Detail-Textfeld wurde eine Rezeptur oder eine Adressliste angeklicke
     * @param link
     */
    private void ergebnisLinkAction(JEditorPane txt) {
    			 final Document d = txt.getDocument();
    			 final HTMLDocument hd = (HTMLDocument)d;
    			 final int pos = txt.viewToModel2D( txt.getMousePosition() );
    			 if ( pos >= 0 ) {
    			 	final Element e = hd.getCharacterElement(pos);
    			 	if (e != null) {
    			 		final SimpleAttributeSet se = (SimpleAttributeSet)e.getAttributes().getAttribute(HTML.Tag.A);
    			 		if(se != null) {
    			 			final String ziel = se.getAttribute(HTML.Attribute.HREF).toString();
    			 			if(ziel.indexOf("^")!= -1) {
    			 				// Adressliste
    			 		        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_ADRESSEN,true,new MessageItem(MessageItem.MSG_SHOW_ADRESSE,0,ziel,this));
    			 			} else {
    			 				// Zutat
                                if(ziel.indexOf("((")!= -1) {
                                    // Bestandsabfrage
                                    try {
                                        statistikEinzelnAction(MessageItem.MSG_SHOW_STATISTIK_BESTAND);
                                    }
                                    catch( final NumberFormatException n ) {
                                        rz.getLogFactory().logMessage(LogFactory.LOG_WARN,"auswahl.ergebnislinkactionBestand","auswahl>" + ziel+ "<");
                                    }
                                } else
                                if (ziel.indexOf("abf:") != -1){
                                	int n = 0;
                                	try {
                                		n = Integer.parseInt(ziel.substring(ziel.indexOf(":")+1));
                                        abfrage = abfragen.getItem(n);
                                        addAbfrage(abfrage.copyItem());
                                        //showAbfrage(abfrage);
                                        //doAbfrage(abfrage);
                                	}catch (final Exception y) {}
                                }
                                else if(ziel.indexOf("bsw:") != -1) {
                                	double menge=0.0;
                                	String ids="";
                                	String menges="";
                                	String bezeichnung;
                            		try {
                            			ids=ziel.substring(ziel.indexOf("[[")+2, ziel.indexOf("]]"));
                            			if(!ids.equals("")) {
                            				int id=Integer.parseInt(ids);
                                			menges=ziel.substring(ziel.indexOf("]]")+2);
	                                		if(!menges.equals("")) {
	                                			menge=Double.parseDouble(menges);
	                                			bezeichnung=ziel.substring(ziel.indexOf("{{") + 2,ziel.indexOf("}}"));
	                                			if(id != 0 && !rz.isZero(menge)) {
	                                                final ErgebnisItem ei1 = new ErgebnisItem(
	                                                		rz,
	                                                		id,
	                                                		RzPro.TYP_ID_REZEPT,
	                                						bezeichnung,0,0,null,null,null,0,0,0,false,0,0,"","",20,20,false,false);
	                                                ei1.setLiter(menge);
	                                           		rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_RECHNEN,false,new MessageItem(MessageItem.MSG_RECHNEN,0,ei1,this));
	                                			}
                                			}
                            			}
                               		}catch(NumberFormatException ne) {}
                                } else if(ziel.indexOf("bst:") != -1) {
                                	bestellungsListeAction();
                                } else if(ziel.indexOf("vrlf:") != -1) {
                                	String losnummer = ziel.substring("vrlf:".length()).trim();
                                	if(!losnummer.equals("")) {
                                		rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_VERLAUF,false,new MessageItem(MessageItem.MSG_SHOW_HISTORY,0,"^"+losnummer+"$",this));
                                	}
                                }  else if(ziel.indexOf("DD:") != -1) {
                                	try {
                                		long m = Long.parseLong(ziel.substring(3));
                                    	if(m > 0) {
                                   	        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_KALENDER,true,new MessageItem(MessageItem.MSG_SHOW_KALENDER_DATUM,0,new Date(m),this));
                                    	}
                                	}catch(final NumberFormatException e2) {}
                                } else if (ziel.indexOf("std:") != -1) {
                                	try {
                                		int n = Integer.parseInt(ziel.substring(4));
                                		if(n > 0) {
                                			StichtagDialog sd=new StichtagDialog(rz,this,n);
                                			sd.showDialog();
                                		}
                                	}catch(final NumberFormatException e3) {}
                                }else if (ziel.indexOf("cha:") != -1) {
                                	try {
                                		int n = Integer.parseInt(ziel.substring(4));
                                		if(n > 0) {
                                			showChangesAction();
                                		}
                                	}catch(final NumberFormatException e4) {}
                                }
                                else if (ziel.indexOf("mhd:") != -1) {
                                	try {
                                		int n = Integer.parseInt(ziel.substring(4));
                                		if(n > 0) {
                                			//MHD-Dialog
                                			String daten[]=rz.getDatabase().getBuchungen().getMHdDaten(n);
            	        	    			MhdDialog dmhd=new MhdDialog(rz,this,new mhdDialogItem(rz,n,daten[0],daten[1],daten[2],daten[3]));
            	        	    			dmhd.showDialog();
            	        	    			getMessage( new MessageItem(MessageItem.MSG_REFRESH_AUSGABE,n,null,this));

                                		}
                                	}catch(final NumberFormatException e4) {}
                                }
                                else if (ziel.indexOf("etm:") != -1) {
                                	try {
                                		int n = Integer.parseInt(ziel.substring(4));
                                		if(n > 0) {
                                			//MHD-Etikett
                                			String daten[]=rz.getDatabase().getBuchungen().getMHdDaten(n);
                    						long mhd;
                    						try {
                    							mhd=Long.parseLong(daten[2]);
                    						}
                    						catch(NumberFormatException emhd) {
                    							mhd=0;
                    						}
                    						Calendar c=Calendar.getInstance();
                    						if(mhd>0) {
                    							c.setTimeInMillis(mhd);
                    						}
                            	        	final EtikettenListe ei = new EtikettenListe();
	                            	        	ei.setBogen(rz.getDatabase().getEtiketten().getBogen(rz.getOptionFactory().getOption("etiketten.bogen",1)));
	                            	        	String[] args = {
	                            	        			daten[0],
	                            	        			daten[1],
	                            						rz.getLocale().getString("auswahl.mhd_etikett").replaceAll("%s",(mhd != 0?rz.getDatabase().getBuchungen().getMhdString(mhd):rz.getLocale().getString("auswahl.mhd_unbegrenzt"))),
	                            						"",
	                            						""
	                            	        	};
	                            				final EtikettenItem eti = new EtikettenItem(rz,args,daten[1]);
	                            				eti.setImage(ei.getBogen().getImage());
	                            				ei.addItem(eti);
	
	                            	        	if(ei.size() != 0) {
	                            	                rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_ETIKETTEN, true,new MessageItem(MessageItem.MSG_ADD_ETIKETTENLISTE,0,(Object)ei,null));
	                            	        	}
                                		}
                                	}catch(final NumberFormatException e4) {}
                                }
                                else if (ziel.indexOf("naf:") != -1) {
                                	try {
                                		int rezeptur=0;
                                		double menge=0.0;
                                		String bezeichnung = "";
                                		String daten[]=ziel.substring(4).split("§");
                                		if(daten.length==3) {
                                			rezeptur=Integer.parseInt(daten[0]);
                                			menge=Double.parseDouble(daten[1]);
                                			bezeichnung=daten[2];
                                			if(rezeptur != 0 && menge >0 && !bezeichnung.equals("")) {
                                				AuftragsItem ai=new AuftragsItem(rz,rezeptur,bezeichnung,menge);
                                    			rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_AUFTRAG, false, new MessageItem(MessageItem.MSG_EDIT_AUFTRAG,0,ai,this));
                                			}
                                		}
                                	}catch(final NumberFormatException e4) {}
                                }
                                else if (ziel.indexOf("ttt:") != -1) {
                               		String nummer = ziel.substring(4).trim();
                               		ArrayList<tankItem> ti = rz.getDatabase().getTank().getTankListeFromTankPattern(nummer);
                                    rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_TANKAUSWAHL,false,new MessageItem(MessageItem.MSG_SHOW_TANKAUSWAHL,0,(Object)(new tankAuswahlItem(ti,this,null,null,null)),this));
                                } else if (ziel.indexOf("tco:") != -1) {
                               		try {
                                		int id = Integer.parseInt(ziel.substring(4));
                                		BuchungsItem bi = rz.getDatabase().getBuchungen().getEinzelBuchung(id);
		                            	if(bi != null) {
		                                  	String hinweis = bi.getComment() +" ";
		                                      final DialogItem di  = new DialogItem(
		                                              DialogControl.EINGABE_DIALOG,
		                                              "",0.0,
		                                              rz.getLocale().getString("auswahl.hinweis_label"),
		                                              rz.getLocale().getString("auswahl.tank_caption")
		                                              	.replaceAll("%s",bi.getBezeichnung())
		                                              	.replaceAll("%l", bi.getLosnummer()),
		                                              hinweis,
		                                              "frage.png",
		                                              rz.getLocale().getString("string_ok"),
		                                              rz.getLocale().getString("string_abbrechen"),
		                                              null
		                                      );
		                                      EingabeDialog edi = new EingabeDialog(rz,di,true,true);
		                                      edi.setTankActive(true);
		                                      edi.setOrigin(this);
		                                      edi.setBuchungsItem(bi.getId());
		                                      edi.setModal(false);
		                                      edi.showDialog();
		                            	}
	                            	}catch (Exception e5){};
                                }else if(ziel.indexOf("bwe:") != -1) {
        			 				String zeile = ziel.substring(4).trim();
        			 				String z[] = zeile.split("&");
        			 				try {
        			 					BewertungsItem bwi = rz.getDatabase().getBewertungen().getBewertung(z[0],z[1]);
        			 					if(bwi != null) {
        			 			    		rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_BEWERTUNGEN_EINGABE,false,new MessageItem(MessageItem.MSG_SHOW_BEWERTUNGSEINGABE,0,bwi,this));
        			 					}
        			 				}catch(Exception e1) {}
        			 			} else if(ziel.indexOf("doc:") != -1) {
        			 				int n = Integer.parseInt(ziel.substring(4));
                            		if(n > 0) {
                            			rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_DOCUMENT_LISTE,false,new MessageItem(MessageItem.MSG_SHOW_DOKUMENT_LISTE,0,Integer.valueOf(n),this));
                            		}
        			 			}  else if(ziel.indexOf("MM:") != -1) {
	      			 				try {
		      			 					int mischung = Integer.valueOf(ziel.substring(3));
		      				 				if(mischung != 0) {
		      				 			       rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_MISCHUNGSLISTE,true,new MessageItem(MessageItem.MSG_SHOW_MISCHUNGSFENSTER_MISCHUNG,mischung,null,this));
		      				 				}      			 				
	      				 				}catch(Exception e1) {}
	      			 			}  else if(ziel.indexOf("MA:") != -1) {
	      			 				try {
	      			 					String mischungen = ziel.substring(3);
	      				 				if(!mischungen.trim().equals("")) {
	      				 					rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_MISCHUNGSLISTE,true,new MessageItem(MessageItem.MSG_SHOW_MISCHUNGSFENSTER_MISCHUNGSLISTE,0,mischungen,this));
	      				 				}      			 				
      				 				}catch(Exception e1) {}
      			 			   } else if(ziel.indexOf("kon:") != -1) {
	      			 				try {
	      			 					int id = Integer.valueOf(ziel.substring(4));
	      			 					if(id != 0) {
	      			 						kontrakteAction(id);
	      			 					}
	      				 				}catch(Exception e1) {}
	      			 			}
                                else {
                                    //Link
        			 				final AbfrageItem ai = new AbfrageItem();
        							ai.setTyp(de.lunqual.rzpro.database.DBAbfrage.ABFRAGE_TYP_NORMAL);
        							ai.setID(0);
        							ai.setAdressListe(new StichwortListe());
        							ai.setStichwortListe(new StichwortListe());
        							int id=0;
        							try {
        								id = Integer.parseInt(ziel);
        							}
        							catch( final NumberFormatException n ) {
        								id=0;
        								rz.getLogFactory().logMessage(LogFactory.LOG_WARN,"auswahl.ergebnislinkactionLink","auswahl>" + ziel+ "<");
        							}
        							if(id > 0) {
        								try {
	        								ai.setMuster("^" + rz.getDatabase().getRezeptur().dbGetRezepturName(id) +  "$");
	        								ai.setMuster(ai.getMuster().replaceAll(" ","."));
	        								addAbfrage(ai);
        								} catch(final ItemNotFoundException e1) {}
        							}
                                }
    			 			}
    			 		}
    			 	}
    			 }
    }

   /**
     * Bestandswarnung auffrischen
     */
    private void bestandsWarnungsAction() {
    	if (this.bestandswarnungsTimer != null) {
	    	if(this.bestandswarnungsTimer.isRunning()) {
	    		this.bestandswarnungsTimer.restart();
	    	}else {
	    		this.bestandswarnungsTimer.start();
	    	}
    	}
    	rz.setWaitCursor(this);
    	rz.getAusgabeFactory().bestandswarnungsAusgabe(txtBestandswarnung,this.chkBestandZutaten.isSelected()?true:false,this.chkBestandBuchungen.isSelected()?true:false);
    	rz.getOptionFactory().setOption("bestandswarnung.zutaten",this.chkBestandZutaten.isSelected()?1:0);
    	rz.getOptionFactory().setOption("bestandswarnung.buchungen",this.chkBestandBuchungen.isSelected()?1:0);
    	lblBestandsWarnungStichwortListe.setText("<html>" + rz.getDatabase().getSTW().dbGetStichwortListe(rz.getOptionFactory().getOption("auswahl.bestandswarnungen.exclude")).toHTMLString()+ "</html>");
    	rz.setFreeCursor(this);
    }

    private void setTerminLabel() {
    	TerminListe tl = rz.getDatabase().getKalender().getTerminListe();
    	if(!tl.isEmpty()) {
    		lblTermine.setText(rz.getLocale().getString("auswahl.label_termine").replaceAll("%s",tl.getListToHTMLString()));
    		lblTermine.setBorder(BorderFactory.createEtchedBorder());
    	}else {
    		lblTermine.setText(" ");
    		lblTermine.setBorder(null);
    	}
    	Auftragsliste al = rz.getDatabase().getAuftrag().getAuftragsliste(DBAuftrag.AUFTRAEGE_ANFRAGEN,true,"");
    	if(al != null && !al.isEmpty()) {
    		lblAnfragen.setText(rz.getLocale().getString("auswahl.label_anfragen").replaceAll("%s",al.getListeToString()));
    		lblAnfragen.setBorder(BorderFactory.createEtchedBorder());
    	}else {
    		lblAnfragen.setText(" ");
    		lblAnfragen.setBorder(null);
    	}
    }

    private void timeoutAction() {
    	int value = rz.getCountdown();
    	if(value == -1) {
    		lblTimeout.setText("-");
    	}else {
    		lblTimeout.setText(String.valueOf(value));    		
    	}
    	timeoutTimer.start();
    }
    
    private void anfragenlisteAction() {
    	if (this.anfragenlisteTimer != null) {
	    	if(this.anfragenlisteTimer.isRunning()) {
	    		this.anfragenlisteTimer.restart();
	    	}else {
	    		this.anfragenlisteTimer.start();
	    	}
    	}
    	//liste neu einlesen
    	getAnfragenListe();
    	this.setTerminLabel();
    }
    
    public void getAnfragenListe() {
    	anfragenliste=rz.getDatabase().getAuftrag().getAuftragsliste(DBAuftrag.AUFTRAEGE_ANFRAGEN,false,"");
        ((AbstractTableModel)tblAnfragenliste.getModel()).fireTableDataChanged();
    }
    
    private void auftragslisteAction() {
    	if (this.auftragslisteTimer != null) {
	    	if(this.auftragslisteTimer.isRunning()) {
	    		this.auftragslisteTimer.restart();
	    	}else {
	    		this.auftragslisteTimer.start();
	    	}
    	}
    	//liste neu einlesen
    	getAuftragsListe();
    	this.setTerminLabel();
    }
    
    private void getAuftragsListeRefresh() {
    	txtAuftragSucheField.setText("");
    	auftragsliste=rz.getDatabase().getAuftrag().getAuftragsliste(DBAuftrag.AUFTRAEGE_SICHTBARE,true,"");
        ((AbstractTableModel)tblAuftragsliste.getModel()).fireTableDataChanged();
    }
    
    private void getAuftragsListe() {
    	auftragsliste=rz.getDatabase().getAuftrag().getAuftragsliste(DBAuftrag.AUFTRAEGE_SICHTBARE,true,txtAuftragSucheField.getText().trim());
        ((AbstractTableModel)tblAuftragsliste.getModel()).fireTableDataChanged();
    }
    
    private void druckFormulareAction() {
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_DRUCKFORMULARE,true,new MessageItem(MessageItem.MSG_SHOW_DRUCKFORMULARE,0,null,this));
    }

    
    /**
     * Zutatenverzeichnis-einstellungen
     */
    private void zutatenverzeichnis_einstellungenAction() {
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_ZUTATENVERZEICHNIS_EINSTELLUNGEN,true,new MessageItem(MessageItem.MSG_SHOW_ZUTATENVERZEICHNIS_EINSTELLUNGEN,0,null,this));
    }

    
    private void showMhdAction(){
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_MHD,true,new MessageItem(MessageItem.MSG_SHOW_MHD,0,this,this));
    }

    
    private void showKonformAction(){
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_KONFORM,true,new MessageItem(MessageItem.MSG_SHOW_KONFORM,0,this,this));
    }

    
    private void showZonenAction(){
    	String liste="";
    	if(ergebnisse.size()>0) {
    		for(int i =0;i < ergebnisse.size();i++) {
    			if(ergebnisse.getItem(i).getTyp() == RzPro.TYP_ID_REZEPT || ergebnisse.getItem(i).getTyp() == RzPro.TYP_ID_VERWEIS) {
    				liste += String.valueOf(ergebnisse.getItem(i).getID()) + ",";
    			}
    		}
    		if(liste.endsWith(",")) {
    			liste=liste.substring(0,liste.length()-1);
    		}
	    	if(!liste.equals("")) {
	    		rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_TEMPERATURZONEN,false,new MessageItem(MessageItem.MSG_SHOW_TEMPERATURZONEN,0,liste,this));
	    	}
    	}
    }

    private void showDMListeAction() {
    	if(rz.getDatabase().getDM().isConnected()) {
    		rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_DMLISTE,true,new MessageItem(MessageItem.MSG_SHOW_DMLISTE,0,this,this));
    	}
    }
    private void showTankListeAction() {
    	rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_TANKLISTE,true,new MessageItem(MessageItem.MSG_SHOW_TANKLISTE,0,this,this));
    }
    
    private void zutatenListeAction() {
    	if(auftragsliste != null && auftragsliste.size() > 0) {
    		ArrayList<AuftragsItem> ail = new ArrayList<AuftragsItem>();
    		for(int i = 0;i < auftragsliste.size();i++) {
    			if(!auftragsliste.getItem(i).isArbeitsAuftrag()) {
    				ail.add(auftragsliste.getItem(i).duplicate());
    			}
    		}
            rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_BEDARF,false,new MessageItem(MessageItem.MSG_SHOW_BEDARFSFENSTER,0,ail,this));
    	}
    }
    
    /**
     * probenfenster anzeigen
     */
    private void probenAction() {
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_PROBE,true,new MessageItem(MessageItem.MSG_SHOW_PROBENFENSTER,0,null,this));
    }

    private void mischungsFensterAction() {
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_MISCHUNGSLISTE,true,new MessageItem(MessageItem.MSG_SHOW_MISCHUNGSLISTENFENSTER,0,null,this));
    }
    
    private void bewertungenAction() {
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_BEWERTUNGSLISTE,true,new MessageItem(MessageItem.MSG_SHOW_BEWERTUNGS_LISTENFENSTER,0,null,this));
    }
    
    private void bestandsWarnungAuswahlAction() {
    	StichwortListe stichworte = rz.getDatabase().getSTW().dbGetStichwortListe(rz.getOptionFactory().getOption("auswahl.bestandswarnungen.exclude"));
    	rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_STICHWORTAUSWAHL,true,new MessageItem(MessageItem.MSG_GET_STICHWORTE,0,stichworte,this));
    }
    private void bestandsWarnungClearAction() {
    	rz.getOptionFactory().setOption("auswahl.bestandswarnungen.exclude","");
    	rz.getOptionFactory().saveOptions();
    	bestandsWarnungsAction();
    }
    
    private void vergleichAction(boolean show_window) {
		if(tblErgebnis.getSelectedRow() != -1) {
            final ErgebnisItem ei =ergebnisse.getItem(tblErgebnis.getSelectedRow());
            if(ei != null ) {
		    	if(show_window) {
		    		rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_VERGLEICH,true,new MessageItem(MessageItem.MSG_SHOW_VERGLEICH_2,0,ei,this));
		    	}else {
		  	      	rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_VERGLEICH,true,new MessageItem(MessageItem.MSG_SHOW_VERGLEICH_1,0,ei,this));
		    	}
            	if(rz.getFensterFactory().getFensterListe().getVergleichHasItem1()) {
        			getAction(ACTION_VERGLEICH_2_CODE).setEnabled(true);
        			getAction(ACTION_VERGLEICH_1_CODE).setEnabled(false);
            	}
            }
		}
    }
    
    private void priorityAction(Object code) {
		int col = tblAuftragsliste.getSelectedColumn();
		int row = tblAuftragsliste.getSelectedRow();
		if(col != -1 && row != -1) {
			AuftragsItem ai = auftragsliste.getItem(row);
			if(ai != null) {
				try {
					int p = Integer.parseInt((String)code);
					ai.setPriority(p);
					rz.getDatabase().getAuftrag().saveAuftrag(ai, this);
		  			getAuftragsListe();
				}catch(Exception e) {}
			}
		}
    }
    
    /**
     * Probeneingabe
     */

    private void probenNeuAction() {
    	int rezeptur=0;
		if(tblErgebnis.getSelectedRow() != -1) {
			final ErgebnisItem ei =ergebnisse.getItem(tblErgebnis.getSelectedRow());
			if (ei != null) {
				rezeptur= ei.getID();
			}
		}
		rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_PROBEN_EINGABE, false, new MessageItem(MessageItem.MSG_SHOW_PROBENEINGABE_REZEPTUR,rezeptur,null,this));
    }

    /**
     * laborwertlistenfenster anzeigen
     */
    private void laborwertListeAction() {
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_LABORWERTLISTE,true,new MessageItem(MessageItem.MSG_SHOW_LABORWERTLISTENFENSTER,0,null,this));
    }

    /**
     * Bestellungslistenfenster anzeigen
     */
    private void bestellungsListeAction() {
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_BESTELLUNGSLISTE,true,new MessageItem(MessageItem.MSG_SHOW_BESTELLUNGSLISTENFENSTER,0,null,this));
    }
    /**
     * Bestellungsfenster anzeigen
     */
    private void bestellungAction() {
		if(tblErgebnis.getSelectedRow() != -1) {
            final ErgebnisItem ei =ergebnisse.getItem(tblErgebnis.getSelectedRow());
            if(ei != null ) {
            	if((ei.getTyp()==RzPro.TYP_ID_REZEPT) || (ei.getTyp() == RzPro.TYP_ID_VERWEIS)) {
                    rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_BESTELLUNGEN,false,new MessageItem(MessageItem.MSG_SHOW_BESTELLUNGSFENSTER,ei.getID(),null,this));
            	}
            }
		}
    }
    /** Datenblatt anzeigen
     *
     *
     */
    private void datenblattAction() {
    		if(tblErgebnis.getSelectedRow() != -1) {
                final ErgebnisItem ei =ergebnisse.getItem(tblErgebnis.getSelectedRow());
                if(ei != null ) {
                	if((ei.getTyp()==RzPro.TYP_ID_REZEPT) || (ei.getTyp() == RzPro.TYP_ID_VERWEIS)) {
                	      rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_DATENBLATT,false,new MessageItem(MessageItem.MSG_SHOW_DATENBLATT,ei.getID(),ei.getName(),this));
                	}
                }
    		}
    }
    /**
     * Deklarationsliste anzeigen
     */
    private void deklarationenAction() {
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_DEKLARATIONSLISTE,true,new MessageItem(MessageItem.MSG_SHOW_DEKLARATIONSLISTE,0,null,this));
    }
    /**
     * Acidliste anzeigen
     */
    private void acidListeAction() {
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_ACIDLISTENFENSTER,true,new MessageItem(MessageItem.MSG_SHOW_ACIDLISTE,0,null,this));
    }
    /**
     * Säurerechner anzeigen
     */
    private void acidRechnerAction() {
		AcidAnzeigeItem ai = null;
    	if(tblErgebnis.getSelectedRow() != -1) {
    		final ErgebnisItem ei =ergebnisse.getItem(tblErgebnis.getSelectedRow());
    		ai = new AcidAnzeigeItem(ei.getName(),ei.getLitergewicht(),ei.getAcid());
    	}
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_ACIDRECHNER,false,new MessageItem(MessageItem.MSG_SHOW_ACIDRECHNER,0,ai,this));
    }

    private void showAuftragAction() {
    	if(tblErgebnis.getSelectedRow()!= -1) {
    		final ErgebnisItem ei =ergebnisse.getItem(tblErgebnis.getSelectedRow());
    		if(ei.getTyp() == RzPro.TYP_ID_REZEPT ) {
    			rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_AUFTRAG,false,new MessageItem(MessageItem.MSG_SHOW_AUFTRAG,ei.getID(),null,this));
    		} else {
    			rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_AUFTRAG,false,new MessageItem(MessageItem.MSG_SHOW_AUFTRAG,0,null,this));
    		}
    	} else {
  			rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_AUFTRAG,false,new MessageItem(MessageItem.MSG_SHOW_AUFTRAG,0,null,this));
    	}
    }
    
    private void showAnfragenlisteAction() {
		rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_AUFTRAGSLISTE,true,new MessageItem(MessageItem.MSG_SHOW_AUFTRAGSLISTE_ANFRAGEN,0,null,this));
    }
    
    private void showAuftragslisteAction() {
		rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_AUFTRAGSLISTE,true,new MessageItem(MessageItem.MSG_SHOW_AUFTRAGSLISTE,0,null,this));
    }

    private void showAuftragslisteAnfragenAction() {
		rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_AUFTRAGSLISTE,true,new MessageItem(MessageItem.MSG_SHOW_AUFTRAGSLISTE_ANFRAGEN,0,null,this));
    }
    
    
    private void showChangesListeAction() {
		rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_CHANGESLISTE,false,new MessageItem(MessageItem.MSG_SHOW_CHANGES_LISTE,0,null,this));
    }
    
    private void showChangesAction() {
        if(tblErgebnis.getSelectedRow() != -1) {
            final ErgebnisItem ei =ergebnisse.getItem(tblErgebnis.getSelectedRow());
            if(ei != null) {
            	switch (ei.getTyp()){
            		case RzPro.TYP_ID_REZEPT:
            		case RzPro.TYP_ID_VERWEIS:
            			rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_CHANGES,false,new MessageItem(MessageItem.MSG_SHOW_CHANGES,ei.getID(),null,this));
            		break;
            		case RzPro.TYP_ID_NOTIZ:
            			rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_CHANGES,false,new MessageItem(MessageItem.MSG_SHOW_CHANGES_NOTIZ,ei.getID(),null,this));
            		break;
            		case RzPro.TYP_ID_AUSSTATTUNG:
            			rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_CHANGES,false,new MessageItem(MessageItem.MSG_SHOW_CHANGES_AUSSTATTUNG,ei.getID(),null,this));
            		break;
            	}
            }
        }
    }
    
    private void showKalenderAction() {
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_KALENDER,true,new MessageItem(MessageItem.MSG_SHOW_KALENDER,0,null,this));
    }
    
    /**
     * Inventurfenster anzeigen
     */
    private void inventurAction() {
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_INVENTURLISTE,true,new MessageItem(MessageItem.MSG_SHOW_INVENTURLISTE,0,null,this));
    }
    /**
     * PalettenRechner anzeigen
     */
    private void palettenRechnerAction() {
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_PALETTENRECHNER,false,new MessageItem(MessageItem.MSG_SHOW_PALETTENRECHNER,0,null,this));
    }

    /**
     * Palettenfenster
     */
    private void palettenAction() {
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_PALETTENLISTE,true,new MessageItem(MessageItem.MSG_SHOW_PALETTENLISTE,0,null,this));
    }
    /**
     * Alle abhängigen Rezepturen neu berechnen
     *
     */
    private void dependencyCalcAction() {
        if(tblErgebnis.getSelectedRow() != -1) {
            final ErgebnisItem ei =ergebnisse.getItem(tblErgebnis.getSelectedRow());
            if(ei != null) {
            	if ((ei.getTyp() == RzPro.TYP_ID_REZEPT) || (ei.getTyp() == RzPro.TYP_ID_AUSSTATTUNG)) {
            		rz.setWaitCursor(this);
            		final DependencyListe el = rz.getDatabase().getErgebnis().dbGetErgebnisListeByID(ei.getID(),true);
            		rz.setFreeCursor(this);
            		if(el.size() > 0) {
            		       rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_DEPENDENCY,false,new MessageItem(MessageItem.MSG_DEPENDENCY_CALC,0,new IDItem(el,ei.getName()),this));
            		}
            	}
            }
        }
    }
    /**
     * Wrapper für mehrere Rezepturen
     */
    private void direktDruckListeAction(int formular) {
    	if(ergebnisse.size() > 0) {
			for(int i = 0;i < ergebnisse.size();i++) {
	            final ErgebnisItem ei =ergebnisse.getItem(i);
	            if(ei != null) {
	                if((ei.getTyp() == RzPro.TYP_ID_REZEPT) || (ei.getTyp() == RzPro.TYP_ID_VERWEIS) ) {
	                	final RechenItem ri = new RechenItem(rz,ei.getID(),null);
	        	    	ri.setWaehrung(rz.getDatabase().getCurrency().dbGetCurrency(ri.getRezeptur().getWaehrung(),true));
	        	    	ri.rechnen(100,RechenItem.RECHNEN_LITER);
    	    			rz.getReportFactory().rechenAuswahlReport(ri,this,"auswahl.formular_rezeptur");
	              	}
	             }
			}
		}
    }
    /**
     * Direktdruck
     */
    private void direktDruckAction(int formular) {
        if(tblErgebnis.getSelectedRow() != -1) {
            final ErgebnisItem ei =ergebnisse.getItem(tblErgebnis.getSelectedRow());
            if(ei != null) {
            	SPFormblattItem spf;
                if((ei.getTyp() == RzPro.TYP_ID_REZEPT) || (ei.getTyp() == RzPro.TYP_ID_VERWEIS)) {
                	final RechenItem ri = new RechenItem(rz,ei.getID(),null);
        	    	ri.setWaehrung(rz.getDatabase().getCurrency().dbGetCurrency(ri.getRezeptur().getWaehrung(),true));
        	    	ri.rechnen(100,RechenItem.RECHNEN_LITER);
        	    	switch (formular) {
        	    		case ACTION_REZEPTUR_DRUCKEN_CODE:
        	    			rz.getReportFactory().rechenAuswahlReport(ri,this,"auswahl.formular_rezeptur");
        	    			break;
        	    		case ACTION_KALKULATION_DRUCKEN_CODE:
        	    			rz.getReportFactory().rechenAuswahlReport(ri,this,"auswahl.formular_kalkulation");
        	    			break;
        	    		case ACTION_SPEZIFIKATION_DRUCKEN_KOMPLETT_CODE:
        	    			if(getDruckTitel(ri)) {
	        	    			spf = rz.getDatabase().getDeklarationen().getFormBlatt(ei.getName());
	        	    			DruckFormularDialog dfd=new DruckFormularDialog(rz,spf,ri,false,this);
	        	    			dfd.showDialog();
	        	    			dfd.dispose();
        	    			}
        	    			//rz.getReportFactory().SPFormblattReport(spf,this);
        	    			//rz.getReportFactory().rechenAuswahlReport(ri,this,"auswahl.formular_spezifikation");
        	    			break;
        	    		case ACTION_SPEZIFIKATION_PDF_KOMPLETT_CODE:
        	    			if(getDruckTitel(ri)) {
	        	    			spf = rz.getDatabase().getDeklarationen().getFormBlatt(ei.getName());
	        	    			DruckFormularDialog dfdp=new DruckFormularDialog(rz,spf,ri,true,this);
	        	    			dfdp.showDialog();
	        	    			dfdp.dispose();
        	    			}
        	    			//rz.getReportFactory().SPFormblattReportPDF(spf,this,ri.getRezeptur().getTitel());
        	    			//rz.getReportFactory().rechenAuswahlReportPDF(ri,this,"auswahl.formular_spezifikation",ri.getRezeptur().getTitel());
        	    			break;
        	    		case ACTION_SPEZIFIKATION_DRUCKEN_CODE:
        	    			if(getDruckTitel(ri)) {
        	    				rz.getReportFactory().rechenAuswahlReport(ri,this,"auswahl.formular_spezifikation");
        	    			}
        	    			break;
        	    		case ACTION_SPEZIFIKATION_PDF_CODE:
        	    			if(getDruckTitel(ri)) {
        	    				rz.getReportFactory().rechenAuswahlReportPDF(ri,this,"auswahl.formular_spezifikation",ri.getRezeptur().getTitel());
        	    			}
        	    			break;
        	    		case ACTION_ZUTATENVERZEICHNIS_DRUCKEN_CODE:
        	    			zutatenVerzeichnisAction(ri);
        	    			break;
        	    	}
              	} else if (ei.getTyp()==RzPro.TYP_ID_AUSSTATTUNG) {
              		int report = rz.getOptionFactory().getOption("report.ausstattung_calc",-1);
              		final AusstattungsItem ai = rz.getDatabase().getAusstattung().getAusstattung(ei.getID());
              		final CurrencyItem ci = rz.getDatabase().getCurrency().dbGetCurrency(rz.getOptionFactory().getOption("kalkulation.currency",1),true);
              		if(report == -1) {
                  		final ArrayList<Integer> liste = rz.getDatabase().getAusstattung().getAusstattungsReportFormular(ReportFactory.REPORT_TYPE_AUSSTATTUNG_CALC);
                  		if(!liste.isEmpty()) {
                  			report = liste.get(0);
                  			rz.getOptionFactory().setOption("report.ausstattung_calc", report);
                  		}
              		}
              		if ((ai != null) && (ci != null) && (report >0)) {
              			ai.rechnen(ai.getGebindegroesse(), ci);
              			rz.getReportFactory().AusstattungCalcReport(ai,  ci, this);
              		}
              	}

             }
         }
    	rz.setFreeCursor(this);
    }

    private boolean getDruckTitel(RechenItem ri) {
    	boolean ret = false;
    	if(ri != null) {
    		String in = ri.getRezeptur().getTitel();
            final DialogItem di  = new DialogItem(
                    DialogControl.EINGABE_SPEZIFIKATION_DIALOG,
                    "",0.0,
                    rz.getLocale().getString("spezifikation_drucken_titel_label"),
                    rz.getLocale().getString("spezifikation_drucken_titel_caption").replaceAll("%s",ri.getRezeptur().getTitel()),
                    in,
                    "frage.png",
                    rz.getLocale().getString("string_ok"),
                    rz.getLocale().getString("string_abbrechen"),
                    null
            );
            EingabeDialog dlge = rz.getDialogFactory().getEingabeSpezifikationDruck(di);
            dlge.showDialog();
            if(di.getReplyCode() == DialogControl.DIALOG_OK) {
            	String out = di.getContent();
            	if(!out.equals("")) {
            		ri.getRezeptur().setTitel(out);
            		ri.setSpezifikationTextDrucken(dlge.isSpezifikationDruck());
            		ri.setDuplex(dlge.isDuplex());
            		ret = true;
            	}
            }
            if(dlge != null) {
            	dlge.dispose();
            }
    	}
    	return ret;
    }
    
    /**
     * Zutatenverzeichnis
     */
    private void zutatenVerzeichnisAction(RechenItem ri) {
    	final ZutatenverzeichnisListe zl=rz.getDatabase().getZutatenverzeichnis().getListe();
    	if(zl != null) {
    	    zl.setRi(ri);
    		rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_ZUTATENVERZEICHNIS,true,new MessageItem(MessageItem.MSG_SHOW_ZUTATENVERZEICHNIS,0,zl,this));
    	}
    }

    /**
     * Automatische Berechnung
     */
    private void autoCalcAction(int code) {
    	rz.setWaitCursor(this);
    	switch (code) {
    		case ACTION_AUTOCALC_SINGLE_CODE:
    	        if(tblErgebnis.getSelectedRow() != -1) {
    	            final ErgebnisItem ei =ergebnisse.getItem(tblErgebnis.getSelectedRow());
    	            if(ei != null) {
    	                if((ei.getTyp() == RzPro.TYP_ID_REZEPT) || (ei.getTyp() == RzPro.TYP_ID_VERWEIS) || (ei.getTyp() == RzPro.TYP_ID_AUSSTATTUNG)) {
    	                	rz.getDatabase().getRezeptur().calcSingle(ei.getID(),ei.getTyp());
    	              	}
    	             }
    	         }

    			break;
    		case ACTION_AUTOCALC_CODE:
    			if(ergebnisse.size() > 0) {
    				for(int i = 0;i < ergebnisse.size();i++) {
        	            final ErgebnisItem ei = ergebnisse.getItem(i);
        	            if(ei != null) {
        	                if((ei.getTyp() == RzPro.TYP_ID_REZEPT) || (ei.getTyp() == RzPro.TYP_ID_VERWEIS) || (ei.getTyp() == RzPro.TYP_ID_AUSSTATTUNG)) {
        	                	rz.getDatabase().getRezeptur().calcSingle(ei.getID(),ei.getTyp());
        	              	}
        	             }
    				}
    			}
    			break;
    	}
    	ergebnisTimerEvent();
    	rz.setFreeCursor(this);
    }


    /**
     * Behälter rückgabe
     */
    private void containerReturnAction() {
    	String liste="";
    	String ret="<ul>";
        final DialogItem di  = new DialogItem(
                DialogControl.EINGABE_DIALOG,
                "",0.0,
                rz.getLocale().getString("auswahl.containerReturn_label"),
                rz.getLocale().getString("auswahl.containerReturn_caption"),
                liste,
                "frage.png",
                rz.getLocale().getString("string_ok"),
                rz.getLocale().getString("string_abbrechen"),
                null
        );
        rz.getDialogFactory().getDialog(di);
        if(di.getReplyCode() == DialogControl.DIALOG_OK) {
        	liste = di.getContent().trim();
        	if(!liste.equals("")) {
        		int x=0;
        		final String n[]=liste.split(" |\\.|;|-|,");
        		for (int i=0;i < n.length;i++) {
        			if(!n[i].equals("")) {
        				try {
    						x = Integer.valueOf(n[i]);
    						if (x != -1) {
    							final int status = rz.getDatabase().getContainer().getStatus(x);
    							if(status == -1) {
    								ret += "<li><font color=\"red\">" + String.valueOf(x)+ rz.getLocale().getString("auswahl.container_nicht_gefunden") +  "</font></li>";
    							}else {
    								if(status == 1) {
	    								rz.getDatabase().getContainer().setStatusBack(x);
	    								ret += "<li><b><font color=\"green\">" + String.valueOf(x)+rz.getLocale().getString("auswahl.container_ok")+  "</font></b></li>";
    								} else {
										ret += "<li><font color=\"blue\">" + String.valueOf(x)+ rz.getLocale().getString("auswahl.container_schon_zurueck") +  "</font></li>";
									}
    							}
    						}
        				}catch(final NumberFormatException e) {
        				}
        			}
        		}
        		ret+="</ul>";
    	        dlgItem.setTyp(DialogControl.HINWEIS_DIALOG);
                dlgItem.setCaption(rz.getLocale().getString("auswahl_container_return_dialog"));
                dlgItem.setTitel(rz.getLocale().getString("auswahl_container_return_dialog"));
                dlgItem.setMessage(rz.getLocale().getString("auswahl_container_return_dialog_message").replaceAll("%l", ret));
                dlgItem.setIcon("warnung.png");
                dlgItem.setOk(rz.getLocale().getString("string_ok"));
               rz.getDialogFactory().getDialog(dlgItem);
        	}
        }
    }
    /**
     * Hinweise bearbeiten
     */
    private void hinweisAction() {
    	String hinweis;
    	RezepturItem ri;
        if(tblErgebnis.getSelectedRow() != -1) {
            final ErgebnisItem ei =ergebnisse.getItem(tblErgebnis.getSelectedRow());
            if(ei != null) {
                if((ei.getTyp() == RzPro.TYP_ID_REZEPT) || (ei.getTyp() == RzPro.TYP_ID_VERWEIS)) {
                	ri = rz.getDatabase().getRezeptur().dbGetRezeptur(ei.getID(),true);
                	if(ri != null) {
                		hinweis = ri.getHinweis() + "                              ";
                        final DialogItem di  = new DialogItem(
                                DialogControl.EINGABE_DIALOG,
                                "",0.0,
                                rz.getLocale().getString("auswahl.hinweis_label"),
                                rz.getLocale().getString("auswahl.hinweis_caption").replaceAll("%s",ri.getTitel()),
                                hinweis,
                                "frage.png",
                                rz.getLocale().getString("string_ok"),
                                rz.getLocale().getString("string_abbrechen"),
                                null
                        );
                        rz.getDialogFactory().getDialog(di,true,false);
                        if(di.getReplyCode() == DialogControl.DIALOG_OK) {
                        	hinweis = di.getContent().trim();
                        	rz.getDatabase().getRezeptur().updateHinweis(ri.getID(),hinweis);
                            final AbfrageItem ai = new AbfrageItem();
                            ai.setTyp(DBAbfrage.ABFRAGE_TYP_NORMAL);
                            ai.setID(ri.getID());
                            ai.setAdressListe(ri.getAdressListe());
                            ai.setStichwortListe(ri.getStichwortListe());
                            ai.setMuster(rz.getDatabase().getErgebnis().getMusterString(ri.getTitel()));
                            this.getMessage(new MessageItem(MessageItem.MSG_ADD_QUERY_REZEPT,0,ai,this));
                        } else {
                        }
                	}
                }
            }
        }
    }

    /**
     * Das Ausbeutefenster anzeigen
     */
    private void ausbeuteAction(){
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_AUSBEUTE,true,new MessageItem(MessageItem.MSG_SHOW_AUSBEUTE,0,null,this));
    }
    /**
     * Das Losnummer-Verlaufs-Fenster anzeigen
     *
     */
    private void verlaufAction() {
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_VERLAUF,false,new MessageItem(MessageItem.MSG_SHOW_HISTORY,0,null,this));
    }
    /**
     * öffnet das Statistikfenster
     * @param msg  MessageItem.MSG_SHOW_STATISTIK oder essageItem.MSG_SHOW_STATISTIK_BESTAND
     */
    private void statistikEinzelnAction(int msg) {
        if(tblErgebnis.getSelectedRow() != -1) {
            final ErgebnisItem ei =ergebnisse.getItem(tblErgebnis.getSelectedRow());
            rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_STATISTIK,false,new MessageItem(msg,StatistikFenster.NO_FILTER,ei,this));
        }
    }
    /**
     * öffnet das Statistikfenster mit mehreren Rezepturen
     * @param msg  MessageItem.MSG_SHOW_STATISTIK oder essageItem.MSG_SHOW_STATISTIK_BESTAND
     */
    private void statistikGruppeAction(int msg) {
        if(ergebnisse.size() > 0) {
            rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_STATISTIK,false,new MessageItem(msg,StatistikFenster.NO_FILTER,ergebnisse,this));
        }
    }
    private void zugangAction() {
        if(tblErgebnis.getSelectedRow() != -1) {
            final ErgebnisItem ei =ergebnisse.getItem(tblErgebnis.getSelectedRow());
            if(ei != null) {
                if((ei.getTyp() == RzPro.TYP_ID_REZEPT) || (ei.getTyp() == RzPro.TYP_ID_VERWEIS)) {
                    rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_ZUGANG,false,new MessageItem(MessageItem.MSG_SHOW_ZUGANG,ei.getID(),null,this));
                }
            }
        }
     }
    private void abgangAction() {
        if(tblErgebnis.getSelectedRow() != -1) {
            final ErgebnisItem ei =ergebnisse.getItem(tblErgebnis.getSelectedRow());
            if(ei != null) {
                if((ei.getTyp() == RzPro.TYP_ID_REZEPT) || (ei.getTyp() == RzPro.TYP_ID_VERWEIS)) {
                    rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_ABGANG,false,new MessageItem(MessageItem.MSG_SHOW_ABGANG,ei.getID(),null,this));
                }
            }
        }
    }
    private void gewichtAction() {
        if(tblErgebnis.getSelectedRow() != -1) {
            final ErgebnisItem ei =ergebnisse.getItem(tblErgebnis.getSelectedRow());
            if(ei != null) {
                if((ei.getTyp() == RzPro.TYP_ID_REZEPT) || (ei.getTyp() == RzPro.TYP_ID_VERWEIS)) {
                    rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_GEWICHT,false,new MessageItem(MessageItem.MSG_SHOW_GEWICHT,ei.getID(),null,this));
                }
            }
        }
    }
    
    
    private void etikettenAction() {

        if(tblErgebnis.getSelectedRow() != -1) {
            rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_ETIKETTEN, true,new MessageItem(MessageItem.MSG_SHOW_ETIKETTEN,0,ergebnisse.getItem(tblErgebnis.getSelectedRow()),this));
        } else {
            rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_ETIKETTEN, true,new MessageItem(MessageItem.MSG_SHOW_ETIKETTEN,0,null,this));
        }
    }
    private void etikettenListeAction() {

        if(tblErgebnis.getSelectedRow() != -1) {
        	final EtikettenListe ei = new EtikettenListe();
        	ei.setBogen(rz.getDatabase().getEtiketten().getBogen(rz.getOptionFactory().getOption("etiketten.bogen",1)));
        	String staerke ="0";
        	try {
        		staerke = rz.getLocale().formatNumber(rz.getDatabase().getRezeptur().dbGetRezeptur(ergebnisse.getItem(tblErgebnis.getSelectedRow()).getID(),true).getStaerke(), OptionFactory.NF_STAERKE);
        	}catch(Exception e) {}
        	String[] args = {
        			ergebnisse.getItem(tblErgebnis.getSelectedRow()).getBezeichnung(),
        			staerke +" " +rz.getLocale().getString("string_prozentvol"),
        			"",
    				"",
    				""
        	};
    		final EtikettenItem eti = new EtikettenItem(rz,args,"");
    		eti.setImage(ei.getBogen().getImage());
    		eti.setRezepturID(ergebnisse.getItem(tblErgebnis.getSelectedRow()).getID());
    		ei.addItem(eti);

        	if(ei.size() != 0) {
                rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_ETIKETTEN, true,new MessageItem(MessageItem.MSG_ADD_ETIKETTENLISTE,0,(Object)ei,null));
        	} 
        } else {
            rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_ETIKETTEN, true,new MessageItem(MessageItem.MSG_ADD_ETIKETTENLISTE,0,null,this));
        }
    }
    
    private void neueNotizAction(){
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_NOTIZ, false,new MessageItem(MessageItem.MSG_EDIT_NOTIZ,0,new ErgebnisItem(rz,0,RzPro.TYP_ID_NOTIZ,"",0,0,new Date(),"","",0,0,0.0,false,0,0,"","",20,20,false,false),this));
    }

    private void neueNotizGruppeAction(){
    	ErgebnisItem ei;
    	if(tblErgebnis.getSelectedRow() != -1) {
    		ei =ergebnisse.getItem(tblErgebnis.getSelectedRow());
    		ei.setID(0);
    	} else {
    		ei =  new ErgebnisItem(rz,0,RzPro.TYP_ID_NOTIZ,"",0,0,new Date(),"","",0,0,0.0,false,0,0,"","",20,20,false,false);
    	}
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_NOTIZ, false,new MessageItem(MessageItem.MSG_EDIT_NOTIZ_GRUPPE,0,ei,this));
    }
    private void neueRezepturAction(){
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_REZEPTUR, false, new MessageItem(MessageItem.MSG_EDIT_REZEPTUR,0,new ErgebnisItem(rz,0,RzPro.TYP_ID_REZEPT,"",0,0,new Date(),"","",0,0,0.0,false,0,0,"","",20,20,false,false),this));
    }
    private void neueRezepturGruppeAction(){
    	ErgebnisItem ei;
    	if(tblErgebnis.getSelectedRow() != -1) {
    		ei =ergebnisse.getItem(tblErgebnis.getSelectedRow());
    		ei.setID(0);
    	} else {
    		ei =  new ErgebnisItem(rz,0,RzPro.TYP_ID_REZEPT,"",0,0,new Date(),"","",0,.0,0.0,false,0,0,"","",20,20,false,false);
    	}
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_REZEPTUR, false,new MessageItem(MessageItem.MSG_EDIT_REZEPTUR_GRUPPE,0,ei,this));
    }

    private void neueAusstattungGruppeAction(){
    	ErgebnisItem ei;
    	if(tblErgebnis.getSelectedRow() != -1) {
    		ei =ergebnisse.getItem(tblErgebnis.getSelectedRow());
    		ei.setID(0);
    	} else {
    		ei =  new ErgebnisItem(rz,0,RzPro.TYP_ID_AUSSTATTUNG,"",0,0,new Date(),"","",0,0,0.0,false,0,0,"","",20,20,false,false);
    	}
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_AUSSTATTUNG, false,new MessageItem(MessageItem.MSG_EDIT_AUSSTATTUNG,0,ei,this));
    }

    private void neueAusstattungAction() {
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_AUSSTATTUNG, false, new MessageItem(MessageItem.MSG_SHOW_AUSSTATTUNG,0,new ErgebnisItem(rz,0,RzPro.TYP_ID_AUSSTATTUNG,"",0,0,new Date(),"","",0,0,0.0,false,0,0,"","",20,20,false,false),this));
    }

    private void listeDruckenAction() {
    	ArrayList liste = new ArrayList();
    	for(int i=0;i<ergebnisse.size();i++) {
    		liste.add(Integer.valueOf(ergebnisse.getItem(i).getID()));
    	}
    	if(liste.size() > 0) {
        		rz.getReportFactory().ergebnislisteReport(0, this,rz.getDatabase().getErgebnis().getErgebnisListeDruck(ergebnisse));
    	}
    }
    
    private void bestandslisteDruckenAction() {
    	if(ergebnisse.size() > 0) {
        		rz.getReportFactory().ergebnislisteBestandReport(0, this,ergebnisse,chkListendruckBestandOnly.isSelected(),chkDuplex.isSelected());
    	}
    }
    
    private void druckenAction(){
        if(tblErgebnis.getSelectedRow() != -1){
            final ErgebnisItem ei =ergebnisse.getItem(tblErgebnis.getSelectedRow());
            switch(ei.getTyp()) {
            	case RzPro.TYP_ID_NOTIZ : rz.getReportFactory().notizReport(ei.getID(),this);
            		break;
            	case RzPro.TYP_ID_REZEPT :
            	case RzPro.TYP_ID_VERWEIS :
            			rz.getReportFactory().rezepturReport(ei.getID(),this);
            		break;
            	case RzPro.TYP_ID_AUSSTATTUNG:
            			rz.getReportFactory().AusstattungRawReport(rz.getDatabase().getAusstattung().getAusstattung(ei.getID()),this);
            }
        }
    }

    //Bearbeiten-Menü
    /** aufstärken/herabsetzen
     */

    private void staerkeAction(int code) {
        if(tblErgebnis.getSelectedRow() != -1){
            final ErgebnisItem ei =ergebnisse.getItem(tblErgebnis.getSelectedRow());
            switch (ei.getTyp()){
                case RzPro.TYP_ID_NOTIZ:
                    break;
                case RzPro.TYP_ID_REZEPT:
                case RzPro.TYP_ID_VERWEIS:
                    rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_STAERKE, false,new MessageItem(MessageItem.MSG_STAERKE,code,ei,this));
                	break;
            }
        }

    }
    /** ausrechnen
     *
     */
    public void calcAction() {
    	if(tblErgebnis.getSelectedRow() != -1) {
    		final ErgebnisItem ei =ergebnisse.getItem(tblErgebnis.getSelectedRow());
    		if((ei.getTyp() == RzPro.TYP_ID_REZEPT) || (ei.getTyp() == RzPro.TYP_ID_VERWEIS)) {
    		    rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_RECHNEN,false,new MessageItem(MessageItem.MSG_RECHNEN,0,ei,this));
    		}
    	}
    }
    /** ein element wird bearbeitet
     *
     */
    private void bearbeitenAction(){
        if(tblErgebnis.getSelectedRow() != -1){
            final ErgebnisItem ei =ergebnisse.getItem(tblErgebnis.getSelectedRow());
            switch (ei.getTyp()){
            	case RzPro.TYP_ID_AUSSTATTUNG:
                    rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_AUSSTATTUNG, false,new MessageItem(MessageItem.MSG_EDIT_AUSSTATTUNG,0,ei,this));
            		break;
                case RzPro.TYP_ID_NOTIZ:
                    rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_NOTIZ, false, new MessageItem(MessageItem.MSG_EDIT_NOTIZ,0,ei,this));
                    break;
                case RzPro.TYP_ID_REZEPT:
                case RzPro.TYP_ID_VERWEIS:
                    rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_REZEPTUR, false,new MessageItem(MessageItem.MSG_EDIT_REZEPTUR,0,ei,this));
                    break;
            }
        }
    }

    /** in welchen Rezepturen wird diese Zutat verwendet ?
     */
    private void verwendungAction() {
		if(tblErgebnis.getSelectedRow() != -1) {
            final ErgebnisItem ei =ergebnisse.getItem(tblErgebnis.getSelectedRow());
            if(ei != null) {
            	if ((ei.getTyp() == RzPro.TYP_ID_REZEPT) || (ei.getTyp() == RzPro.TYP_ID_AUSSTATTUNG)) {
            		rz.setWaitCursor(this);
            		final DependencyListe liste = rz.getDatabase().getErgebnis().dbGetErgebnisListeByID(ei.getID(),false);
            		rz.setFreeCursor(this);
            		String ids="";
            		if(liste.size() > 0) {
                		for(int i=0;i<liste.size();i++) {
                			ids += liste.getItem(i).getId() + ",";
                		}
                		if(ids.endsWith(",")) {
                			ids = ids.substring(0,ids.length()-1);
                		}
            	    	final AbfrageItem ai = new AbfrageItem();
            			ai.setID(0);
            			ai.setAdressListe(new StichwortListe());
            			ai.setStichwortListe(new StichwortListe());
            			ai.setTyp(de.lunqual.rzpro.database.DBAbfrage.ABFRAGE_TYP_SQL);
            			ai.setMuster(rz.getDatabase().getErgebnis().getErweitertSQLPrefix() + " rezeptliste.id in (" + ids + ") and rezeptliste.typ=1 group by rezeptliste.id order by name");
                		addAbfrage(ai);
            		}
            	}
            }
        }
   	}
    
    private void verwendungEinzelnAction() {
    	    	if (tblErgebnis.getSelectedRow() != -1)
    	    	{
    	    		final ErgebnisItem ei =ergebnisse.getItem(tblErgebnis.getSelectedRow());
    	    		abfrage.setMuster(ei.getName());
    	    		abfrage.setMode(DBAbfrage.ABFRAGE_MODE_VERWENDUNG);
    	    		abfrage.setTyp(DBAbfrage.ABFRAGE_TYP_NORMAL);
    	    		abfrage.setAdressListe(new StichwortListe());
    	    		abfrage.setStichwortListe(new StichwortListe());
    	    		addAbfrage(abfrage);
    	    	}
   	}

    /** alle Zutaten auflisten;
     */
    private void zutatenAction() {
    	if (tblErgebnis.getSelectedRow() != -1)
    	{
    		String muster ="";
    		String zeilen[];
    		int n;
    		final ErgebnisItem ei =ergebnisse.getItem(tblErgebnis.getSelectedRow());
    		muster = "^" + ei.getName()+"$|";
    		final String raw = rz.getDatabase().getRezeptur().getComment(ei.getID());
    		if(raw != null) {
	    		zeilen  =raw.split("\\n");
	    		for (final String element : zeilen) {
	    				try {
	    					n = 0;
	    					if(element.startsWith(RzPro.TYP_CALC) || element.startsWith(RzPro.TYP_AUSSTATTUNG_EINFACH) || element.startsWith(RzPro.TYP_AUSSTATTUNG_MULTI)) {
	    						n = Integer.parseInt( element.substring(element.indexOf("[[")+2,element.indexOf("]]")));
	    					}
	    				} catch (final NumberFormatException e) {
	    					n = 0;
	    				}
	    				if(n != 0) {
	    					try {
	    						muster += "^" + rz.getDatabase().getRezeptur().dbGetRezepturName(n) + "$|";
	    					} catch(final ItemNotFoundException e) {}
	    				}
	    		}
	    		if(muster.endsWith("|")) {
	    			muster = muster.substring(0,muster.length()-1);
	    		}
	    		muster = muster.trim().replaceAll(" ", ".");
	    		if (!muster.equals("")) {
		    		abfrage.setMuster(muster);
		    		abfrage.setMode(DBAbfrage.ABFRAGE_MODE_MUSTER);
		    		abfrage.setAdressListe(new StichwortListe());
		    		abfrage.setStichwortListe(new StichwortListe());
		    		addAbfrage(abfrage);
	    		}
	    	}
    	}
    }
    
    private void zutatenAlleAction() {
    	if(tblErgebnis.getSelectedRow() != -1) {
            final ErgebnisItem ei =ergebnisse.getItem(tblErgebnis.getSelectedRow());
            if(ei != null ) {
            	if((ei.getTyp()==RzPro.TYP_ID_REZEPT) || (ei.getTyp() == RzPro.TYP_ID_VERWEIS) || ei.getTyp() == RzPro.TYP_ID_NOTIZ || ei.getTyp() == RzPro.TYP_ID_AUSSTATTUNG) {
            		String liste = rz.getDatabase().getRezeptur().getAlleRezepturen(ei.getID());
    				if(!liste.trim().equals("")) {
    			    	final AbfrageItem ai = new AbfrageItem();
    			    	ai.setTyp(DBAbfrage.ABFRAGE_TYP_SQL);
    			    	String sql = rz.getDatabase().getErgebnis().getErweitertSQLPrefix();
    			    	sql += " rezeptliste.id in (" + liste + ")" + " and rezeptliste.typ=1 group by rezeptliste.id order by name";
    		    		ai.setMuster(sql);
    		    		addAbfrage(ai);
    				}
            	}
    		}
    	}
    }
    
    /** Notiz/Rezeptur duplizieren
     *
     *
     */
    private void duplicateAction() {
    	ErgebnisItem ei;
    	int aKey= 0;
    	if(tblErgebnis.getSelectedRow() != -1) {
    		ei =ergebnisse.getItem(tblErgebnis.getSelectedRow());
            final DialogItem di  = new DialogItem(
                    DialogControl.EINGABE_DIALOG,
                    "",0.0,
                    rz.getLocale().getString("auswahl.kopie_titel"),
                    rz.getLocale().getString("auswahl.kopie"),
                    ei.getName().trim(),
                    "frage.png",
                    rz.getLocale().getString("string_ok"),
                    rz.getLocale().getString("string_abbrechen"),
                    this
            );
            rz.getDialogFactory().getDialog(di);
            if((di.getReplyCode() == DialogControl.DIALOG_OK) || (di.getReplyCode()==DialogControl.DIALOG_YES)) {
	        	final String n= di.getContent().trim();
	        	if(n != null) {
		        	if (!n.equals("")) {
			    		switch (ei.getTyp()) {
			    			case RzPro.TYP_ID_NOTIZ :
			    				aKey = rz.getDatabase().getNotizen().dbDuplicateNotiz(ei.getID(),n);
			    				break;
			    			case RzPro.TYP_ID_REZEPT :
			    			case RzPro.TYP_ID_VERWEIS:
			    				aKey = rz.getDatabase().getRezeptur().dbDuplicateRezeptur(ei.getID(),n);
			    				break;
			    			case RzPro.TYP_ID_AUSSTATTUNG:
			    				aKey = rz.getDatabase().getAusstattung().duplicateAusstattung(ei.getID(),n);
			    				break;
			    		}
			    		if(aKey != 0) {
			        		abfrage.setMuster(n);
			        		abfrage.setAdressListe(rz.getDatabase().getSTW().dbGetAdressenListe(ei.getAdressen()));
			        		abfrage.setStichwortListe(rz.getDatabase().getSTW().dbGetStichwortListe(ei.getStichworte()));
			        		abfrage.setSMode(DBAbfrage.ABFRAGE_MODE_AND);
			        		abfrage.setMode(DBAbfrage.ABFRAGE_MODE_MUSTER);
			    			addAbfrage(abfrage);
			    		}
			    	}
		    	}
            }
    	}
    }
    /** und gruppe ist die Gruppe, die die gleiche Teilmenge an Stichworten enthält
     *
     *
     */
    private void undGruppeAction() {
    	if(tblErgebnis.getSelectedRow() != -1) {
    		final ErgebnisItem ei =ergebnisse.getItem(tblErgebnis.getSelectedRow());
    		abfrage.setMuster("");
    		abfrage.getAdressListe().clear();
    		abfrage.setStichwortListe(rz.getDatabase().getSTW().dbGetStichwortListe(ei.getStichworte()));
    		abfrage.setSMode(DBAbfrage.ABFRAGE_MODE_AND);
    		abfrage.setMode(DBAbfrage.ABFRAGE_MODE_MUSTER);
    		addAbfrage(abfrage);
    	}
    }
    /** oder-gruppe ist die Gruppe, die mindestens eins der Stichworte enthält
     *
     *
     */
    private void oderGruppeAction() {
    	if(tblErgebnis.getSelectedRow() != -1) {
    		final ErgebnisItem ei =ergebnisse.getItem(tblErgebnis.getSelectedRow());
    		abfrage.setMuster("");
    		abfrage.getAdressListe().clear();
    		abfrage.setStichwortListe(rz.getDatabase().getSTW().dbGetStichwortListe(ei.getStichworte()));
    		abfrage.setSMode(DBAbfrage.ABFRAGE_MODE_OR);
    		abfrage.setMode(DBAbfrage.ABFRAGE_MODE_MUSTER);
    		addAbfrage(abfrage);
    	}
    }

    /** adressengruppe ist die Gruppe, die die gleiche adressenzuordnung enthält
     *
     *
     */
    private void adressenAction(int what) {
    	ErgebnisItem ei;
		StichwortListe adressen = new StichwortListe();
		switch (what) {
			case ACTION_ADRESSEN_CODE:
				if(tblErgebnis.getSelectedRow() != -1) {
					ei =ergebnisse.getItem(tblErgebnis.getSelectedRow());
					adressen=rz.getDatabase().getSTW().dbGetAdressenListe(ei.getAdressen());
				}
				break;
			case ACTION_ADRESSEN_GRUPPE_CODE:
				if(ergebnisse.size() >0) {
					for(int i =0; i < ergebnisse.size();i++) {
						ei=ergebnisse.getItem(i);;
						final StichwortListe s = rz.getDatabase().getSTW().dbGetAdressenListe(ei.getAdressen());
						for(int j = 0; j < s.size();j++) {
							if(!adressen.isInList(((StichwortItem)s.get(j)).getID() )) {
								adressen.add(new StichwortItem(((StichwortItem)s.get(j)).getID(),((StichwortItem)s.get(j)).getName(),((StichwortItem)s.get(j)).getHg(),((StichwortItem)s.get(j)).getVg()));
							}
						}
					}
				}
				break;
		}
		if(!adressen.isEmpty() ) {
    		abfrage.setMuster("");
    		abfrage.getStichwortListe().clear();
    		abfrage.setAdressListe(adressen.copyList());
    		abfrage.setSMode(DBAbfrage.ABFRAGE_MODE_AND);
    		abfrage.setMode(DBAbfrage.ABFRAGE_MODE_MUSTER);
    		String suchString =  abfrage.getAdressListe().toVerboseSearchString().replaceAll(",","|");
    		suchString = suchString.replaceAll("\\)","").replaceAll("\\(", "").replaceAll("\\s\\|", "|").replaceAll("\\|\\s", "|").replaceAll("\\[","").replaceAll("\\]","");
    		if(what==ACTION_ADRESSEN_CODE) {
    			addAbfrage(abfrage);
    		}
            rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_ADRESSEN,true,new MessageItem(MessageItem.MSG_SHOW_ADRESSE,0,suchString,this));
		}
    }


    private void loeschenAction(){
        DialogItem di=null;
        if(!txtMuster.hasFocus()) {
            if(tblErgebnis.getSelectedRow() != -1){
                final ErgebnisItem ei =ergebnisse.getItem(tblErgebnis.getSelectedRow());;
                switch (ei.getTyp()){
                    case RzPro.TYP_ID_NOTIZ:
                        di = new DialogItem(
                                DialogControl.FRAGE_DIALOG,
                                "",0.0,
                                rz.getLocale().getString("auswahl.question_notiz_delete"),
                                rz.getLocale().getString("auswahl.question_notiz_delete"),
                                rz.getLocale().getString("auswahl.question_notiz_delete_1").replaceAll("%s",ei.getName()),
                                "frage.png",
                                rz.getLocale().getString("string_ja"),
                                rz.getLocale().getString("string_nein"),
                                this
                        );
                        rz.getDialogFactory().getDialog(di);
                        if ((di.getReplyCode() == DialogControl.DIALOG_YES) || (di.getReplyCode() == DialogControl.DIALOG_OK)){
                            rz.getDatabase().getNotizen().dbDeleteNotiz(ei.getID());
                            addAbfrage(abfrage);
                        }
                        break;
                    case RzPro.TYP_ID_REZEPT:
                	  	//Kann diese Rezeptur überhaupt gelöscht werden ? ersma checken....
                    	  if (!rz.getDatabase().getRezeptur().dbCheckRezepturUsed(ei.getID(), ei.getName())) {
                    	  		// kann gelöscht werden, Abfrage anzeigen, ob wirklich gelöscht werden soll
                              di = new DialogItem(
                                      DialogControl.FRAGE_DIALOG,
                                      "",0.0,
                                      rz.getLocale().getString("auswahl.question_rezeptur_delete"),
                                      rz.getLocale().getString("auswahl.question_rezeptur_delete"),
                                      rz.getLocale().getString("auswahl.question_rezeptur_delete_1").replaceAll("%s",ei.getName()),
                                      "frage.png",
                                      rz.getLocale().getString("string_ja"),
                                      rz.getLocale().getString("string_nein"),
                                      this
                              );
                              rz.getDialogFactory().getDialog(di);
                              if ((di.getReplyCode() == DialogControl.DIALOG_YES) || (di.getReplyCode() == DialogControl.DIALOG_OK)){
		                      		rz.getDatabase().getRezeptur().dbDeleteRezeptur(ei.getID());
		                      		addAbfrage(abfrage);
		                      }
                    	  }
                        break;
                    case RzPro.TYP_ID_VERWEIS:
                        di = new DialogItem(
                                DialogControl.FRAGE_DIALOG,
                                "",0.0,
                                rz.getLocale().getString("auswahl.question_verweis_delete"),
                                rz.getLocale().getString("auswahl.question_verweis_delete"),
                                rz.getLocale().getString("auswahl.question_verweis_delete_1").replaceAll("%s",ei.getName()),
                                "warnung.png",
                                rz.getLocale().getString("string_ja"),
                                rz.getLocale().getString("string_nein"),
                                this
                        );
                        rz.getDialogFactory().getDialog(di);
                        if ((di.getReplyCode() == DialogControl.DIALOG_YES) || (di.getReplyCode() == DialogControl.DIALOG_OK)){
                            rz.getDatabase().getRezeptur().dbDeleteRezeptur(ei.getID());
                            addAbfrage(abfrage);
                        }
                        break;
                    case RzPro.TYP_ID_AUSSTATTUNG:
                	  	//Kann diese Aqsstattung überhaupt gelöscht werden ? ersma checken....
                    	  if (!rz.getDatabase().getAusstattung().checkAusstattungUsed(ei.getID(), ei.getName())) {
                    	  		// kann gelöscht werden, Abfrage anzeigen, ob wirklich gelöscht werden soll
                              di = new DialogItem(
                                      DialogControl.FRAGE_DIALOG,
                                      "",0.0,
                                      rz.getLocale().getString("auswahl.question_ausstattung_delete"),
                                      rz.getLocale().getString("auswahl.question_ausstattung_delete"),
                                      rz.getLocale().getString("auswahl.question_ausstattung_delete_1").replaceAll("%s",ei.getName()),
                                      "frage.png",
                                      rz.getLocale().getString("string_ja"),
                                      rz.getLocale().getString("string_nein"),
                                      this
                              );
                              rz.getDialogFactory().getDialog(di);
                              if ((di.getReplyCode() == DialogControl.DIALOG_YES) || (di.getReplyCode() == DialogControl.DIALOG_OK)){
		                      		rz.getDatabase().getAusstattung().deleteAusstattung(ei.getID());
		                      		addAbfrage(abfrage);
		                      }
                    	  }
                        break;
                }
            }
        }
    }
    
    private void bestandsWarnungDruckenAction() {
    	rz.getReportFactory().bestandswarnungsReport(0, this);
    }
    
    private void bestandsWarnungUebertragenAction() {
    	AbfrageItem ai=new AbfrageItem();
    	ai.setTyp(DBAbfrage.ABFRAGE_TYP_BESTANDSWARNUNG);
    	addAbfrage(ai);

    }
    //Navigation-Menü

    private void savedNavigationAction(){
        lstAbfragen.requestFocus();
        if(((lstAbfragen.getModel().getSize()) > 0) && (lstAbfragen.getSelectedIndex() == -1)){
            lstAbfragen.setSelectedIndex(0);
        }
    }
    private void musterNavigationAction(){
        txtMuster.requestFocus();
    }
    private void ergebnisNavigationAction(){
        tblErgebnis.requestFocus();
        if(((ergebnisse.size()) > 0) && (tblErgebnis.getSelectedRow() == -1)){
            tblErgebnis.setRowSelectionInterval(0,0);
        }
    }

    //Extras-Menü
    private void hideAction(){
    	saveHistory();
        rz.getOptionFactory().setOption("auswahl.tab1_state",auftragBestandswarnungsTab.getSelectedIndex());
        rz.getOptionFactory().saveOptions();
        rz.getFensterFactory().getFensterListe().sperren(this);
    }

    // Abfragen-Menü


    private void abfrageLoeschenAction(){
        if(lstAbfragen.getSelectedIndex() != -1){
            final AbfrageItem ai = (AbfrageItem)lstAbfragen.getSelectedValue();
            final DialogItem di  = new DialogItem(
                    DialogControl.FRAGE_DIALOG,
                    "",0.0,
                    rz.getLocale().getString("auswahl.question_abfrage_delete"),
                    rz.getLocale().getString("auswahl.question_abfrage_delete"),
                    rz.getLocale().getString("auswahl.question_abfrage_delete_1").replaceAll("%s",ai.getName()),
                    "frage.png",
                    rz.getLocale().getString("string_ja"),
                    rz.getLocale().getString("string_nein"),
                    this
            );
            rz.getDialogFactory().getDialog(di);
            if ((di.getReplyCode() == DialogControl.DIALOG_YES) || (di.getReplyCode() == DialogControl.DIALOG_OK)){
                rz.getDatabase().getAbfrage().dbDeleteAbfrage(ai);
                abfrageRefreshAction();
          }
        }
    }

    private void abfrageGoAction(){
        if(lstAbfragen.getSelectedIndex() != -1){
            final AbfrageItem ai = rz.getDatabase().getAbfrage().dbGetAbfrage(((AbfrageItem)lstAbfragen.getSelectedValue()).getID());
            addAbfrage(ai);
        }
    }

    private void abfrageUseAction(){
    	setActions();
        if(lstAbfragen.getSelectedIndex() != -1){
            abfrage = rz.getDatabase().getAbfrage().dbGetAbfrage(((AbfrageItem)lstAbfragen.getSelectedValue()).getID());
            showAbfrage(abfrage);
        }
        txtMuster.requestFocus();
    }

    private void abfrageSpeichernAction(){
        AbfrageItem ai = new AbfrageItem();
        DialogItem di=null;
        ai = abfrage.copyItem();
        di  = new DialogItem(
                DialogControl.EINGABE_DIALOG,
                "",0.0,
                rz.getLocale().getString("auswahl.question_neue_abfrage_titel"),
                rz.getLocale().getString("auswahl.question_neue_abfrage_label"),
                rz.getLocale().getString("auswahl.question_neue_abfrage_vorlage"),
                "frage.png",
                rz.getLocale().getString("string_ja"),
                rz.getLocale().getString("string_nein"),
                this
        );
        rz.getDialogFactory().getDialog(di);

        final String name = di.getContent();
	    if(name != null) {
        	if (!name.equals("")){
	            if (!rz.getDatabase().getAbfrage().dbCheckAbfrageExists(name)){
	                ai.setName(name);
	                ai.setPrivat(true);
	                rz.getDatabase().getAbfrage().dbSaveAbfrage(ai);
	                abfrageRefreshAction();
	            }
	            else {
	                 di  = new DialogItem(
	                        DialogControl.HINWEIS_DIALOG,
	                        "",0.0,
	                        rz.getLocale().getString("auswahl.question_neue_abfrage_titel"),
	                        rz.getLocale().getString("auswahl.question_neue_abfrage_label"),
	                        rz.getLocale().getString("auswahl.question_neue_abfrage_exists").replaceAll("%s",name),
	                        "warnung.png",
	                        rz.getLocale().getString("string_ok"),
	                        "",
	                        this
	                );
	                rz.getDialogFactory().getDialog(di);
	            }
	        }
	    }
    }

    private void abfrageAusfuehrenAction(){
        //abfrage.setID(DBAbfrage.ABFRAGE_TYP_NORMAL);
        if(abfrage.getTyp() == DBAbfrage.ABFRAGE_TYP_NORMAL){
        	abfrage.setOrder(cmbSort.getSelectedIndex());
        	abfrage.setAMode(Integer.valueOf(adressenGroup.getSelection().getActionCommand()).intValue());
        	abfrage.setSMode(Integer.valueOf(stichworteGroup.getSelection().getActionCommand()).intValue());
        	if(cmbAbfrageModus.getSelectedIndex()==2) {
        		if(!txtMuster.getText().trim().equals("")) {
        			String muster = "";
        			String[] in = txtMuster.getText().trim().split(" |,|;");
        			for(int i = 0; i < in.length;i++) {
        				String n = in[i].trim();
        				if(!n.equals("")) {
        					try {
        					muster += "^" + rz.getDatabase().getRezeptur().dbGetRezepturName(Integer.valueOf(n)) + "$|";
        					} catch(Exception e) {}
        				}
        			}
        			if(muster.endsWith("|"))muster = muster.substring(0, muster.length()-1);
        			if(!muster.trim().equals("")) {
        				txtMuster.setText(muster);
        			}
        		}
        		cmbAbfrageModus.setSelectedIndex(0);
        	} else {
        	}
        	abfrage.setMuster(this.txtMuster.getText().trim());
            abfrage.setMode(cmbAbfrageModus.getSelectedIndex());
            abfrage.setAblage(chkAblage.isSelected());
        }
        addAbfrage(abfrage);
    }

    private void abfrageNeuAction(){
        abfrage = new AbfrageItem();
        showAbfrage(abfrage);
        txtMuster.requestFocus();
    }

    private void abfrageAdressenAction(){
    	rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_ADRESSAUSWAHL,true,
    			new MessageItem(MessageItem.MSG_ADRESSLISTE_REQUEST,0,abfrage,this));
    }

    private void abfrageAdressenLoeschenAction(){
        abfrage.getAdressListe().clear();
        lblRzAdressen.setListData(abfrage.getAdressListe());
        txtMuster.requestFocus();
    }

    private void abfrageStichworteAction(){
    	rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_STICHWORTAUSWAHL,true,
    			new MessageItem(MessageItem.MSG_STICHWORTLISTE_REQUEST,0,abfrage,this));
    }

    private void abfrageStichworteLoeschenAction(){
        abfrage.getStichwortListe().clear();
        lblRzStichworte.setListData(abfrage.getStichwortListe());
        txtMuster.requestFocus();
    }


    public void abfrageRefreshAction(){
        lstAbfragen.setListData(rz.getDatabase().getAbfrage().dbGetAbfrageListe().toArray());
    }

    // Fenster-Menü
    private void showAdressenAction(){
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_ADRESSEN,true,new MessageItem(MessageItem.MSG_SHOW_ADRESSE,0,"",this));
  	}
    private void showReports(){
        //rz.getFensterControl().getFensterListe().createWindow(RzFenster.FENSTER_REPORT,true,null);
    }

    private void herstellfensterAction() {
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HERSTELLUNG,true,new MessageItem(MessageItem.MSG_SHOW_HERSTELLUNG,0,null,this));
    }

    private void showEinstellungen(){
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_EINSTELLUNGEN,true,new MessageItem(MessageItem.MSG_SHOW_EINSTELLUNGEN,0,null,this));
    }
    private void showKalkulationAction(){
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_KALKULATION,true,new MessageItem(MessageItem.MSG_SHOW_WAEHRUNG,0,"",this));
    }
    private void showLagerAction(){
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_LAGER,true,new MessageItem(MessageItem.MSG_SHOW_LAGER,0,"",this));
    }
    private void lieferscheinAction() {
		rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_LIEFERSCHEIN,false,new MessageItem(MessageItem.MSG_EDIT_LIEFERSCHEIN_REQUEST,0,null,this));
   }

    private void lieferscheinListeAction() {
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_LIEFERSCHEIN_LISTE,true,new MessageItem(MessageItem.MSG_LIEFERSCHEINE,0,"",this));
    }
    private void behaelterAction() {
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_BEHAELTER,true,new MessageItem(MessageItem.MSG_SHOW_CONTAINER,0,"",this));
    }
    private void tafelAction() {
        TafelItem ti;
        if(tblErgebnis.getSelectedRow() != -1) {
            final ErgebnisItem ei = ergebnisse.getItem(tblErgebnis.getSelectedRow());;
            switch(ei.getTyp()) {
            	case RzPro.TYP_ID_VERWEIS:
            	    final int id =rz.getDatabase().getRezeptur().dbGetRezeptur(ei.getID(),true).getVerweis();
            		if(id != 0) {
            		    ti=new TafelItem(rz,rz.getDatabase().getRezeptur().dbGetRezeptur(id,true).getStaerke(),0);
            		} else {
            		    ti = new TafelItem(rz,0,0);
            		}
            	    break;
            	case RzPro.TYP_ID_REZEPT:
            	    ti=new TafelItem(rz,rz.getDatabase().getRezeptur().dbGetRezeptur(ei.getID(),true).getStaerke(),0);
            	    break;
            	default:
            	    ti = new TafelItem(rz,0,0);
            	    break;
            }
        } else {
            ti = new TafelItem(rz,0,0);
        }
        if(ti != null) {
            rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_TAFEL,false,new MessageItem(MessageItem.MSG_SHOW_TAFEL,0,ti,this));
        }
    }
    private void loggingAction(){
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_LOGGING,true,new MessageItem(MessageItem.MSG_SHOW_LOG,0,null,this));
    }


    // hilfe-men
    private void hilfeAction(){
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"auswahl.html",this));
    }

    private void aboutAction(){
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_ABOUT,true,new MessageItem(MessageItem.MSG_SHOW_ABOUT,0,null,this));
    }



    /*------------------------------------------------------------------------
     * ListenRenderer
     *
     *------------------------------------------------------------------------
     */
    private final class ErgebnisListRenderer extends JLabel implements ListCellRenderer{
        RzPro   rz;
        public ErgebnisListRenderer(RzPro r){
        	rz = r;
            setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list,Object value,int index, boolean isSelected,boolean cellHasFocus){
        	final ErgebnisItem ei = (ErgebnisItem)value;
            this.setFont(rz.getFontFactory().getListFont());
            setText(ei.toString());
            switch (ei.getTyp()) {
            	case RzPro.TYP_ID_NOTIZ:
                    setIcon(rz.getOptionFactory().getIcon(OptionFactory.LIST_ERGEBNIS_ICON_NOTIZ_CLASSPATH));
            		break;
            	case RzPro.TYP_ID_REZEPT :
           			setIcon(rz.getOptionFactory().getIcon(OptionFactory.LIST_ERGEBNIS_ICON_REZEPTUR_CLASSPATH));
            		break;
            	case RzPro.TYP_ID_VERWEIS:
                    setIcon(rz.getOptionFactory().getIcon(OptionFactory.LIST_ERGEBNIS_ICON_VERWEIS_CLASSPATH));
                    break;
            	case RzPro.TYP_ID_AUSSTATTUNG:
                    setIcon(rz.getOptionFactory().getIcon(OptionFactory.LIST_ERGEBNIS_ICON_AUSSTATTUNG_CLASSPATH));
            	break;
            }
            if(isSelected){
                setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_SELECTED));
                setForeground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_FOREGROUND_SELECTED));
            }else {
                setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_NORMAL));
                setForeground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_FOREGROUND_NORMAL));
            }
            return this;
        }
    }

    private final class AbfrageListRenderer extends JLabel implements ListCellRenderer{
        RzPro   rz;
        public AbfrageListRenderer(RzPro r){
            rz = r;
            setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list,Object value,int index, boolean isSelected,boolean cellHasFocus){
            final AbfrageItem ai = (AbfrageItem)value;
            this.setFont(rz.getFontFactory().getListFont());
            setText(ai.getName());
            setToolTipText(rz.getLocale().getString("auswahl.abfrage_tooltiptext").replaceAll("%s",ai.getUser1()));
            if(ai.isPrivat()) {
            	setIcon(rz.getOptionFactory().getIcon(OptionFactory.LIST_ABFRAGE_ICON_PRIVAT_CLASSPATH));
            } else {
            	setIcon(rz.getOptionFactory().getIcon(OptionFactory.LIST_ABFRAGE_ICON_CLASSPATH));
            }
            if(isSelected){
                setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_SELECTED));
                setForeground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_FOREGROUND_SELECTED));
            }else {
                setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_NORMAL));
                setForeground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_FOREGROUND_NORMAL));
            }
            return this;
        }
    }
    private final class STWListRenderer extends JLabel implements ListCellRenderer{
        RzPro   rz;
        public STWListRenderer(RzPro r){
            rz = r;
            setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list,Object value,int index, boolean isSelected,boolean cellHasFocus){
            final StichwortItem si = (StichwortItem)value;
            this.setFont(rz.getFontFactory().getListFont());
            setText(si.toString());
            if(isSelected){
                setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_SELECTED));
                setForeground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_FOREGROUND_SELECTED));
            }else {
                setBackground(rz.getOptionFactory().getRGBColorString(si.getHg()));
                setForeground(rz.getOptionFactory().getRGBColorString(si.getVg()));
            }
            return this;
        }
    }
    
    private void settblAuftragslisteModel(final JTable t) {
	    final AuftragslistenColumnModel rcm = new AuftragslistenColumnModel();
	    final AuftragslisteStringRenderer sr = new AuftragslisteStringRenderer();
	    
	    TableColumn tc;
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("auswahl.tableheader_al_suchen"));
			tc.setModelIndex(AL_C_SUCHEN);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
	    tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("auswahl.tableheader_al_menge"));
	    	tc.setModelIndex(AL_C_MENGE);
	    	tc.setCellRenderer(sr);
	    rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("auswahl.tableheader_al_bezeichnung"));
			tc.setModelIndex(AL_C_BEZEICHNUNG);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
	    
        rcm.addColumnModelListener(this);
        t.setModel(new auftragslisteTableModel());
        t.setColumnModel(rcm);
        t.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
        t.getTableHeader().setReorderingAllowed(false);
        t.setFont(rz.getFontFactory().getAuftragsTableFont());
        rz.setPreferredRowHeights(t);
        TableModelListener l = new TableModelListener() {
			public void tableChanged(TableModelEvent e) {
		         SwingUtilities.invokeLater(new Runnable() {
		              public void run() {
		                  rz.setPreferredRowHeights(t);
		              }
		         });
			}
	     }; 
		 t.getModel().addTableModelListener(l);
	}
    
	private class AuftragslistenColumnModel extends DefaultTableColumnModel{
	    public AuftragslistenColumnModel() {
	        super();
	    }
	}
	
	
	private  class auftragslisteTableModel extends AbstractTableModel    {

    	
        SimpleDateFormat df;

        public auftragslisteTableModel() {
        	super();
        }

	   public int getColumnCount() {
	       	return  AL_MAX_COLUMNS;
        }
        public int getRowCount() {
        	if(auftragsliste != null) {
                return auftragsliste.size();
        	} else {
        		return 0;
        	}
        }

        public AuftragsItem getZeileAt(int rowIndex) {
        	if((rowIndex != -1) && (auftragsliste != null)) {
        		return auftragsliste.getItem(rowIndex);
        	} else {
				return null;
			}
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            Object ret = null;
            if((rowIndex != -1) && (auftragsliste != null)) {
                ret = getContent(auftragsliste.getItem(rowIndex),columnIndex,rowIndex);
            }
            return ret;
        }

        private Object getContent(AuftragsItem ai,int aColumn,int row) {
            Object ret = null;
            if(ai != null) {
	            switch(aColumn){
	            	 case AL_C_SUCHEN:ret="";
	            			break;
	            	 case AL_C_BEZEICHNUNG:
	            	     	String normal = "<b>" +(ai.getPriority() != 0?ai.getPriorityString():"") +ai.getBezeichnung() + "</b><br>" +ai.getFaelligToString() +"<br>" + (rz.getDatabase().getAuftrag().getAuftragsConfig().getColors(ai,0)[2]);
	            	     	String gruppenHeader = "<b>" +ai.getGruppe()+":</b>&nbsp;" + normal;
	            	     	ret = ai.getGruppe().equals("")?normal:gruppenHeader;
	            	     	ret = "<html>" + ret + "</html>";
	            	     	break;
	            	 case AL_C_MENGE:
	            		 	if(ai.isArbeitsAuftrag()) {
	            		 		ret="<html>" + (ai.getArbeit_user().trim().equals("")?"":"("+ai.getArbeit_user()+")") + "</html>";	            		 		
	            		 	}else {
	            		 		ret="<html>" + rz.getLocale().formatNumber(ai.getLiter(), OptionFactory.NF_ONE) + "<br>"  + (ai.getArbeit_user().trim().equals("")?"":"("+ai.getArbeit_user()+")") + ((!ai.getTank().trim().equals(""))?rz.getLocale().getString("auswahl.auftragliste.tank") + ai.getTank():"");
	            		 	}
		            	 	break;
	            }
            }
            return ret;
        }
	}

	
    private void settblAnfragenlisteModel(final JTable t) {
	    final AnfragenlistenColumnModel rcm = new AnfragenlistenColumnModel();
	    final AnfragenlisteStringRenderer sr = new AnfragenlisteStringRenderer();
	    
	    TableColumn tc;
	    tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("auswahl.tableheader_al_suchen"));
	    	tc.setModelIndex(AL_C_SUCHEN);
	    	tc.setCellRenderer(sr);
    rcm.addColumn(tc);
	    tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("auswahl.tableheader_an_menge"));
	    	tc.setModelIndex(AL_C_MENGE);
	    	tc.setCellRenderer(sr);
	    rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("auswahl.tableheader_an_bezeichnung"));
			tc.setModelIndex(AL_C_BEZEICHNUNG);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
        rcm.addColumnModelListener(this);
        t.setModel(new anfragenlisteTableModel());
        t.setColumnModel(rcm);
        t.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
        t.getTableHeader().setReorderingAllowed(false);
        t.setFont(rz.getFontFactory().getAuftragsTableFont());
        rz.setPreferredRowHeights(t);
        TableModelListener l = new TableModelListener() {
			public void tableChanged(TableModelEvent e) {
		         SwingUtilities.invokeLater(new Runnable() {
		              public void run() {
		                  rz.setPreferredRowHeights(t);
		              }
		         });
			}
	     }; 
		 t.getModel().addTableModelListener(l);
	}
    
	private class AnfragenlistenColumnModel extends DefaultTableColumnModel{
	    public AnfragenlistenColumnModel() {
	        super();
	    }
	}
	
	
	private  class anfragenlisteTableModel extends AbstractTableModel    {

    	
        SimpleDateFormat df;

        public anfragenlisteTableModel() {
        	super();
        }

	   public int getColumnCount() {
	       	return  AL_MAX_COLUMNS;
        }
        public int getRowCount() {
        	if(anfragenliste != null) {
                return anfragenliste.size();
        	} else {
        		return 0;
        	}
        }

        public AuftragsItem getZeileAt(int rowIndex) {
        	if((rowIndex != -1) && (anfragenliste != null)) {
        		return anfragenliste.getItem(rowIndex);
        	} else {
				return null;
			}
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            Object ret = null;
            if((rowIndex != -1) && (anfragenliste != null)) {
                ret = getContent(anfragenliste.getItem(rowIndex),columnIndex,rowIndex);
            }
            return ret;
        }

        private Object getContent(AuftragsItem ai,int aColumn,int row) {
            Object ret = null;
            if(ai != null) {
	            switch(aColumn){
	            	 case AL_C_SUCHEN: ret="";
	            		break;
	            	 case AL_C_BEZEICHNUNG:
	            		 if(ai.isFertig()) {
	            			 ret = "<html><b>" + ai.getBezeichnung() + "</b><br>" +ai.getFertigToString() +"<br>" + (rz.getDatabase().getAuftrag().getAuftragsConfig().getColors(ai,0)[2]) + "</html>";
	            		 } else {
	            			 ret = "<html><b>" + ai.getBezeichnung() + "</b><br>" +ai.getFaelligToString() +"<br>" + (rz.getDatabase().getAuftrag().getAuftragsConfig().getColors(ai,0)[2]) + "</html>";
	            		 }
	            	     break;
	            	 case AL_C_MENGE:
	            	 	ret="<html>" + rz.getLocale().formatNumber(ai.getLiter(), OptionFactory.NF_ONE) + "<br>"  + (ai.getArbeit_user().trim().equals("")?"":"("+ai.getArbeit_user()+")") + ((!ai.getTank().trim().equals(""))?rz.getLocale().getString("auswahl.auftragliste.tank") + ai.getTank():""); 
	            	 	break;
	            }
            }
            return ret;
        }
	}
	
	
	
	private class AnfragenlisteStringRenderer extends DefaultTableCellRenderer {

		Icon				eigen,suchen;
	    AnfragenlisteStringRenderer() {
	        super();
            eigen = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/auswahl.icon_auftrag_eigen.png"));
            suchen = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/auswahl.icon_auftrag_suchen.png"));
	        setOpaque(true);
	    }
	    public Component getTableCellRendererComponent(JTable table,
                Object value, boolean isSelected, boolean hasFocus, int row,
                int column)
	    {
	    	AuftragsItem ai = anfragenliste.getItem(row);
	    	setIcon(null);
	    	setFont(rz.getFontFactory().getAuftragsTableFont());
	    	if(ai != null) {
	    		setForeground(rz.getOptionFactory().getRGBColorString(ai.getVg()));
	    		setBackground(rz.getOptionFactory().getRGBColorString(ai.getHg()));
	    		String tt = rz.getLocale().getString("auswahl.auftragsliste_tooltip")
	    				.replaceAll("%s",ai.getErstellt_user())
	    				.replaceAll("%b",ai.getComment())
	    				.replaceAll("%e",ai.getErstelltToString())
	    				.replaceAll("%z", ai.getGeaendert_user())
	    				.replaceAll("%g", ai.getGeaendertToString())
	    				.replaceAll("\\n","<br>");
	    		this.setToolTipText("<html>" + tt + "</html>");
	    		if(column == AL_C_MENGE && ai.isEigen()) {
	    			setIcon(eigen);
	    		}
	    		if(column==AL_C_SUCHEN) {
	    			setIcon(suchen);
	    		}
		   	}
	    	setText((String)value);
	        setHorizontalAlignment(SwingConstants.LEADING);
	        return this;
        }
	}
	
	private class AuftragslisteStringRenderer extends DefaultTableCellRenderer {

		Icon				eigen,inarbeit,eigen_inarbeit,suchen,repeat,repeat_suchen,gruppe,gruppe_leer;

	    AuftragslisteStringRenderer() {
	        super();
            eigen = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/auswahl.icon_auftrag_eigen.png"));
            inarbeit = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/auswahl.icon_auftrag_inarbeit.png"));
            eigen_inarbeit = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/auswahl.icon_auftrag_eigen_inarbeit.png"));
            suchen = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/auswahl.icon_auftrag_suchen.png"));
            repeat = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/auswahl.icon_auftrag_repeat.png"));
            repeat_suchen = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/auswahl.icon_auftrag_repeat_suchen.png"));
            gruppe = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/auswahl.icon_auftrag_gruppe.png"));
            gruppe_leer = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/auswahl.icon_auftrag_gruppe_leer.png"));

            
	        setOpaque(true);
	    }
	    public Component getTableCellRendererComponent(JTable table,
                Object value, boolean isSelected, boolean hasFocus, int row,
                int column)
	    {
	    	AuftragsItem ai = auftragsliste.getItem(row);
	    	setIcon(null);
	    	setFont(rz.getFontFactory().getAuftragsTableFont());
	    	if(ai != null) {
	    		setForeground(rz.getOptionFactory().getRGBColorString(ai.getVg()));
	    		if(rz.isMain() && !ai.getGruppe().equals("")) {
	    			setBackground(rz.getOptionFactory().getRGBColorString(ai.getHgDark()));
	    		} else {
	    			setBackground(rz.getOptionFactory().getRGBColorString(ai.getHg()));
	    		}
//	    		if(column > 0 && ai.isFertig()) {
//	    			setBackground(rz.getOptionFactory().getRGBColorString(rz.getDatabase().getAuftrag().getAuftragsConfig().getLevelFhg())) ;
//	    			setForeground(rz.getOptionFactory().getRGBColorString(rz.getDatabase().getAuftrag().getAuftragsConfig().getLevelFvg())); 
//	    		}
	    		String tt ="<html>";
	    		tt += rz.getLocale().getString("auswahl.auftragsliste_tooltip")
	    				.replaceAll("%s",ai.getErstellt_user())
	    				.replaceAll("%b",ai.getComment())
	    				.replaceAll("%e",ai.getErstelltToString())
	    				.replaceAll("%z", ai.getGeaendert_user())
	    				.replaceAll("%g", ai.getGeaendertToString())
	    				.replaceAll("\\n","<br>");
	    		if(ai.isRepeat()) {
	    			tt += "<br>" + rz.getDatabase().getAuftrag().getRepeatSpanListe().get(ai.getRepSpan()).getSpanString(ai);
	    		} 
	    		this.setToolTipText(tt + "</html>");
	    		switch(column) {
	    			case AL_C_BEZEICHNUNG:
	    				if(!ai.getGruppe().equals("")) {
	    					setIcon(gruppe);
	    					if(row > 0 ) {
	    						AuftragsItem ai1 = auftragsliste.getItem(row-1);
	    						if(ai1 != null) {
	    							if(ai.getGruppe().equals(ai1.getGruppe())) {
	    								setIcon(gruppe_leer);
	    							}
	    						}
	    					}
	    				}
	    				break;
	    			case AL_C_MENGE:
		    			if(ai.isEigen() && ai.isInarbeit()) {
		    				setIcon(eigen_inarbeit);
		    			} else if(ai.isEigen()) {
		    				setIcon(eigen);
		    			} else if(ai.isInarbeit()) {
		    				setIcon(inarbeit);
		    			}
	    				break;
	    			case AL_C_SUCHEN:
	    				if(ai.isArbeitsAuftrag()) {
	    	    			String colors[] = rz.getDatabase().getAuftrag().getAuftragsConfig().getColors(ai.getFaellig().getTimeInMillis(),null);
	    		    		setForeground(rz.getOptionFactory().getRGBColorString(colors[0]));
	    		    		if(ai.getGruppe().equals("")){
	    		    			setBackground(rz.getOptionFactory().getRGBColorString(colors[1]));
	    		    		}else {
	    		    			setBackground(rz.getOptionFactory().getRGBColorString(ai.getDarkerColor(colors[1])));
	    		    		}
	    					if(ai.isRepeat()) {
	    						setIcon(repeat);
	    					}else {
	    						setIcon(null);
	    					}
	    				} else {
	    					if(ai.isRepeat()) {
	    						setIcon(repeat_suchen);
	    					} else {
	    						setIcon(suchen);
	    					}
	    				}
	    				break;
	    		}
		   	}
	    	setText( (String)value);
	        setHorizontalAlignment(SwingConstants.LEADING);
	        return this;
        }
	}
	
	
    private void settblErgebnisModel(JTable t) {
	    final ErgebnisColumnModel rcm = new ErgebnisColumnModel();
	    final StringRenderer sr = new StringRenderer();
	    final IconRenderer ir = new IconRenderer();
	    TableColumn tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("auswahl.tableheader_ce_icon"));
	    	tc.setModelIndex(CE_ICON);
	    	tc.setCellRenderer(ir);
	    rcm.addColumn(tc);
	    tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("auswahl.tableheader_ce_bezeichnung"));
	    	tc.setModelIndex(CE_BEZEICHNUNG);
	    	tc.setCellRenderer(sr);
	    rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("auswahl.tableheader_ce_datum"));
			tc.setModelIndex(CE_DATUM);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("auswahl.tableheader_ce_stichworte"));
			tc.setModelIndex(CE_STICHWORTE);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("auswahl.tableheader_ce_fuellstand"));
			tc.setModelIndex(CE_FUELLSTAND);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("auswahl.tableheader_ce_konform"));
			tc.setModelIndex(CE_KONFORM);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
        rcm.addColumnModelListener(this);
        tblErgebnis.setModel(new ergebnisTableModel());
        tblErgebnis.setColumnModel(rcm);
        tblErgebnis.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
        tblErgebnis.getTableHeader().setReorderingAllowed(false);
	}


	private class ErgebnisColumnModel extends DefaultTableColumnModel{
	    public ErgebnisColumnModel() {
	        super();
	    }
	}
    
	private  class ergebnisTableModel extends AbstractTableModel    {

    	Icon						rezeptur;
    	Icon						notiz;
    	Icon						verweis;
    	Icon						ausstattung;
    	Icon						rezepturBestellt;
    	Icon						rezepturBestelltAbgelaufen;
    	Icon						rezepturBestelltSpezifikation;
    	Icon						rezepturBestelltSpezifikationAbgelaufen;
    	Icon						rezepturSpezifikation;
    	Icon						verweisBestellt;
    	
        SimpleDateFormat df;

        public ergebnisTableModel() {
        	try {
            rezeptur = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/rezeptur.png"));
            rezepturBestellt = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/rezepturBestellt.png"));
            rezepturBestelltAbgelaufen = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/rezepturBestelltAbgelaufen.png"));
            rezepturBestelltSpezifikation = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/rezepturBestelltSpezifikation.png"));   
            rezepturBestelltSpezifikationAbgelaufen = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/rezepturBestelltSpezifikationAbgelaufen.png")); 
            rezepturSpezifikation = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/rezepturSpezifikation.png"));
            notiz = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/notiz.png"));
            verweis = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/verweis.png"));
            verweisBestellt = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/verweisBestellt.png"));
            ausstattung = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/ausstattung.png"));
        	}catch (Exception e) {
        	}
            df = new SimpleDateFormat("dd.MM.yyyy");
        }

	   public int getColumnCount() {
	       	return CE_MAX;
        }
        public int getRowCount() {
        	if(ergebnisse != null) {
                return ergebnisse.size();
        	} else {
        		return 0;
        	}
        }

        public ErgebnisItem getZeileAt(int rowIndex) {
        	if((rowIndex != -1) && (ergebnisse != null)) {
        		return ergebnisse.getItem(rowIndex);
        	} else {
				return null;
			}
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            Object ret = null;
            if((rowIndex != -1) && (ergebnisse != null)) {
                ret = getContent(ergebnisse.getItem(rowIndex),columnIndex,rowIndex);
            }
            return ret;
        }

        private Object getContent(ErgebnisItem ei,int aColumn,int row) {
            Object ret = null;
            if(ei != null) {
	            switch(aColumn){
	            	case CE_ICON:
	            		switch(ei.getTyp()) {
	            			case RzPro.TYP_ID_AUSSTATTUNG: ret=ausstattung;break;
	            			case RzPro.TYP_ID_VERWEIS: 
	            				if(ei.isBestellung()) {
	            					ret=verweisBestellt;
	            				}else {
	            					ret=verweis;
	            				}
	            				break;
	            			case RzPro.TYP_ID_REZEPT: 
	            				if(ei.isBestellung()) {
	            					if(ei.getSpezifikation().equals("")) {
	            						if(rz.getDatabase().getBestellung().bestellungAbgelaufen(ei.getID())) {
	            							ret = rezepturBestelltAbgelaufen;
	            						} else {
	            							ret=rezepturBestellt;
	            						}
	            					} else {
	            						if(rz.getDatabase().getBestellung().bestellungAbgelaufen(ei.getID())) {
	            							ret=rezepturBestelltSpezifikationAbgelaufen;
	            						} else {
	            							ret=rezepturBestelltSpezifikation;
	            						}
	            					}
	            				} else {
	            					if(ei.getSpezifikation().equals("")) {
	            						ret=rezeptur;
	            					} else {
	            						ret=rezepturSpezifikation;
	            					}
	            				}
	            				break;
	            			case RzPro.TYP_ID_NOTIZ: ret=notiz;break;
	            		}
	            		break;
	            	 case CE_BEZEICHNUNG:
	            	     ret = ei.getBezeichnung();
	            	     break;
	            	 case CE_DATUM:
	            		 ret=ei.getDatum();
	            		 break;
	            	 case CE_STICHWORTE:
	            	 	ret= ei.getStichwortString();
	            	 	break;
	            	 case CE_FUELLSTAND:
	            		 ret=ei.getFuellstand();
	            		 break;
	            	 case CE_KONFORM:
	            		 if(ei.isKonform()) {
	            			 ret = df.format(ei.getKonformDatum());
	            		 }else {
	            			 ret = "";
	            		 }
	            		 break;
	            }
            }
            return ret;
        }
	}

	
	
	
	private class StringRenderer extends DefaultTableCellRenderer {

		Icon auftrag,inarbeit;
	    StringRenderer() {
	        super();
            auftrag = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/auswahl.icon_auftrag.png"));
            inarbeit = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/auswahl.icon_auftrag_inarbeit.png"));
	        setOpaque(true);
	    }
	    public Component getTableCellRendererComponent(JTable table,
                Object value, boolean isSelected, boolean hasFocus, int row,
                int column)
	    {
	    	ErgebnisItem ei = null;
	    	if((row != -1) && (ergebnisse != null)) {
	    	   ei = ergebnisse.getItem(row);
	    	}
    		if(isSelected) {
    			setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_SELECTED));
    	    	setFont(rz.getFontFactory().getTableBoldFont());
    		}else {
    			setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_NORMAL));
    	    	setFont(rz.getFontFactory().getTableFont());
    		}
	        if(value != null && ei != null) {
	        	setText(value.toString());
	        	setToolTipText(null);
	        	setIcon(null);
	        	if(column==CE_BEZEICHNUNG) {
	        		if(ei.isAuftrag()) {
	        			setIcon(auftrag);
	        		} 
	        		if(ei.isInarbeit()) {
	        			setIcon(inarbeit);
	        		}
	        	}
	        	if(column==CE_STICHWORTE) {
	        		setToolTipText(ei.getStichwortListe()==null?null:ei.getStichwortListe());
	        	}
        		if(column == CE_FUELLSTAND) {
        			String s = "";
        			if(ei.getBestand() > 0) {
        				s += rz.getLocale().getString("fuellstand_bezeichnung").replaceAll("%y",ei.getBezeichnung()) + 
        					rz.getLocale().getString("fuellstand_bestand").replaceAll("%b" ,rz.getLocale().formatNumber(ei.getBestand(),OptionFactory.NF_ONE));
        			}
        			if(ei.getMeldebestand()>0) {
    					s+=rz.getLocale().getString("fuellstand_meldebestand").replaceAll("%m" ,rz.getLocale().formatNumber(ei.getMeldebestand(),OptionFactory.NF_ONE));
        			}
        			if(ei.getVorschlagsBestand()>0) {
    					s+=rz.getLocale().getString("fuellstand_vorschlagsbestand").replaceAll("%v" ,rz.getLocale().formatNumber(ei.getVorschlagsBestand(),OptionFactory.NF_ONE));
        			}
        			if(ei.getDifferenz()>0) {
    					s+=rz.getLocale().getString("fuellstand_differenz").replaceAll("%d" ,rz.getLocale().formatNumber(ei.getDifferenz(),OptionFactory.NF_ONE));
        			}
        			if(!s.equals("")) {
        				setToolTipText("<html><center>" + s + "</html></center>");
        			}
	        	}
	        	if(column==CE_KONFORM) {
	        		setToolTipText(ei.isKonform() && !ei.getKonformComment().equals("")?ei.getKonformComment():null);
	        	}
	         } else {
				setText("");
			}
	        setHorizontalAlignment(SwingConstants.LEADING);
	        return this;
        }
	}

	/** rendert alle Tabellenzeilen mit icon Inhalt
	 *  im wesentlichen heisst das rechts-ausgerichtent
	 * @author lunqual
	 */
	private class IconRenderer extends DefaultTableCellRenderer {

	    IconRenderer() {
	        super();

	        setOpaque(true);
	    }
	    public Component getTableCellRendererComponent(JTable table,
                Object value, boolean isSelected, boolean hasFocus, int row,
                int column)
	    {
    		if(isSelected) {
    			setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_SELECTED));
    	    	setFont(rz.getFontFactory().getTableBoldFont());
    		}else {
    			setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_NORMAL));
    	    	setFont(rz.getFontFactory().getTableFont());
    		}
	    	if((row != -1) && (ergebnisse != null)) {
		        if(value != null) {
		            setText("");
		            setIcon((Icon)value);
	        }
	    }
	    return this;
	    }
	}

	public void columnAdded(TableColumnModelEvent arg0) {}
	public void columnMarginChanged(ChangeEvent arg0) {}
	public void columnMoved(TableColumnModelEvent arg0) {}
	public void columnRemoved(TableColumnModelEvent arg0) {}
	public void columnSelectionChanged(ListSelectionEvent arg0) {}
	

	public class ColumnHeaderListener extends MouseAdapter {
	    public void mouseClicked(MouseEvent evt) {
	        JTable table = ((JTableHeader)evt.getSource()).getTable();
	        TableColumnModel colModel = table.getColumnModel();

	        int vColIndex = colModel.getColumnIndexAtX(evt.getX());
	        // Return if not clicked on any column header
	        if (vColIndex == -1) {
	            return;
	        }
	        // Determine if mouse was clicked between column heads
	        Rectangle headerRect = table.getTableHeader().getHeaderRect(vColIndex);
	        if (vColIndex == 0) {
	            headerRect.width -= 3;    // Hard-coded constant
	        } else {
	            headerRect.grow(-3, 0);   // Hard-coded constant
	        }
	        if (!headerRect.contains(evt.getX(), evt.getY())) {
	            // Mouse was clicked between column heads
	            // vColIndex is the column head closest to the click

	            // vLeftColIndex is the column head to the left of the click
	            if (evt.getX() < headerRect.x) {
	                vColIndex--;
	            }
	        }
	        if(ergebnisse != null && ergebnisse.size()>0) {
	        	String sel = "";
	        	try {
	        		sel=ergebnisse.getItem(tblErgebnis.getSelectedRow()).getBezeichnung();
	        	}catch (Exception e) {}
		        switch(vColIndex) {
		        	case CE_ICON:
		        		ergebnisse.sortTyp();
		        		break;
		        	case CE_BEZEICHNUNG:
		        		ergebnisse.sortAlpha();
		        		break;
		        	case CE_DATUM:
		        		ergebnisse.sortDate();
		        		break;
		        	case CE_STICHWORTE:
		        		ergebnisse.sortStichworte();
		        		break;
		        	case CE_FUELLSTAND:
		        		ergebnisse.sortFuellstand();
		        		break;
		        	case CE_KONFORM:
		        		ergebnisse.sortKonform();
		        		break;
		        }
                ((AbstractTableModel)tblErgebnis.getModel()).fireTableDataChanged();
		        if(sel != null && !sel.equals("")) {
		        	for(int i=0;i<ergebnisse.size();i++) {
		        		if(tblErgebnis.getModel().getValueAt(i,1).equals(sel)) {
		        			tblErgebnis.getSelectionModel().setSelectionInterval(i,i);
		        	        tblErgebnis.scrollRectToVisible(tblErgebnis.getCellRect(i, 0,true));
		        			break;
		        		}
		        	}
		        }
	        }
	    }
	}

	
}
