/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package de.lunqual.rzpro.fenster.auswahlfenster;

//eigene Pakete
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;

import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.SwingConstants;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.ausgabe.ReportFactory;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.abfrage.AbfrageItem;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.ergebnis.DependencyItem;
import de.lunqual.rzpro.items.ergebnis.DependencyListe;
import de.lunqual.rzpro.items.ergebnis.IDItem;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.report.ReportItem;
import de.lunqual.rzpro.items.stichworte.StichwortListe;
import de.lunqual.rzpro.options.OptionFactory;


/**
 *
 * @author  administrator
 */
public class DependencyFenster  extends JRzFrame implements TableColumnModelListener{

    //GUI-Variablen
	private JMenuBar mb;
    	private JMenu mnuDatei;
    	private JMenu mnuExtras;
    	private JMenu mnuHilfe;
    private JPanel mainPanel;
    	private JPanel toolbarPanel;
    		private JToolBar tb1;
    	private JPanel contentPanel;
    		private JLabel lblTitel;
    		private JScrollPane scrListe;
    			private JTable tblListe;
    		private JLabel lblRechnen;
    	private JPanel buttonPanel;
    		private JButton btClose;
    		private JButton btCalc;
    		private JButton btAbfrage;
    		private JComboBox cmbDependency;
    		private JButton btDependencyDrucken;
    		private JButton btDependencyPreview;
    		private JComboBox cmbSort;

    // ActionCodes KalkulationEingabe
    public static final int         ACTION_CLOSE_CODE = 1000;
    public static final String      ACTION_CLOSE_TEXT = "dependency.action_close";
    public static final int         ACTION_CALC_CODE = 1001;
    public static final String      ACTION_CALC_TEXT = "dependency.action_calc";
    public static final int         ACTION_DRUCKEN_CODE = 1002;
    public static final String      ACTION_DRUCKEN_TEXT = "dependency.action_drucken";
    public static final int         ACTION_PREVIEW_CODE = 1003;
    public static final String      ACTION_PREVIEW_TEXT = "dependency.action_vorschau";
    public static final int         ACTION_ABFRAGE_CODE = 1004;
    public static final String      ACTION_ABFRAGE_TEXT = "dependency.action_abfrage";


    private static final int		MAX_COLUMN=5;
    private static final int		C_ERLEDIGT = 0;
    private static final int		C_NAME = 1;
    private static final int		C_LAGER = 2;
    private static final int		C_STEUERLAGER = 3;
    private static final int		C_STEUERARTIKEL = 4;
    IDItem							liste;

    static final String SHORTNAME_MASK = "****";

    /** Creates new form AdressAuswahl */

    public DependencyFenster(RzPro r, String name,Object extendedData) {
        super(r,name,extendedData);
        createActions();
        createGUIComponents();
        setGUIComponents();
        getMessage((MessageItem)extendedData);
    }

    @Override
	public void createGUIComponents() {
        mb = new JMenuBar();
		mnuDatei = new JMenu();
			mb.add(mnuDatei);
        mnuExtras = new JMenu();
        	mb.add(mnuExtras);
        mnuHilfe = new JMenu();
        	mb.add(mnuHilfe);
		setJMenuBar(mb);
		mainPanel = new JPanel(new BorderLayout());
			toolbarPanel = new JPanel(new BorderLayout());
				tb1 = new JToolBar();
				tb1.setFloatable(false);
				tb1.setRollover(true);
				toolbarPanel.add(tb1);
			mainPanel.add(toolbarPanel,BorderLayout.NORTH);
			contentPanel  = new JPanel(new BorderLayout());
	        	lblTitel = new JLabel();
	        		lblTitel.setHorizontalAlignment(SwingConstants.CENTER);
	        	contentPanel.add(lblTitel,BorderLayout.NORTH);
	        	scrListe = new JScrollPane();
	        		tblListe  = new JTable();
					tblListe.setName("dependencyfenster.spalten");
	        		scrListe.setViewportView(tblListe);
	        	contentPanel.add(scrListe,BorderLayout.CENTER);
	        	lblRechnen = new JLabel();
        		lblRechnen.setHorizontalAlignment(SwingConstants.CENTER);
        	contentPanel.add(lblRechnen,BorderLayout.SOUTH);
			buttonPanel=new JPanel(new GridLayout(1,8));
    			btClose=new JButton();
    				buttonPanel.add(btClose);
    			btCalc=new JButton();
    				buttonPanel.add(btCalc);
    			btAbfrage = new JButton();
    				buttonPanel.add(btAbfrage);
    			cmbDependency = new JComboBox();
    			rz.getDatabase().getReport().dbGetReportListeCombo(cmbDependency,ReportFactory.REPORT_TYPE_DEPENDENCY);
        	    cmbDependency.addActionListener(new ActionListener() {
					public void actionPerformed(ActionEvent evt) {
    	        		if(cmbDependency.getSelectedIndex() != -1) {
    	        			rz.getOptionFactory().setOption("report.dependency_liste",((ReportItem)cmbDependency.getSelectedItem()).getID());
    	        		}
    	        	}
                });
    			buttonPanel.add(cmbDependency);
    			btDependencyDrucken = new JButton();
    			buttonPanel.add(btDependencyDrucken);
    			btDependencyPreview = new JButton();
    			buttonPanel.add(btDependencyPreview);
    			cmbSort = new JComboBox();
    				cmbSort.addItem(rz.getLocale().getString("dependency.sort.alpha"));
    				cmbSort.addItem(rz.getLocale().getString("dependency.sort.lager"));
    				cmbSort.addItem(rz.getLocale().getString("dependency.sort.steuer_lager"));
    				cmbSort.addItem(rz.getLocale().getString("dependency.sort.steuer_artikel"));
    				cmbSort.addItem(rz.getLocale().getString("dependency.sort.order"));
    				cmbSort.addActionListener(new ActionListener() {
    					public void actionPerformed(ActionEvent evt) {
        	        		if(cmbDependency.getSelectedIndex() != -1) {
        	        			rz.getOptionFactory().setOption("report.dependency_sort_liste",cmbSort.getSelectedIndex());
        	        			rz.getOptionFactory().saveOptions();
        	        			if(liste != null && liste.getListe() != null) {
        	        				liste.getListe().Sort((String)cmbSort.getSelectedItem());
        	        				 ((AbstractTableModel)tblListe.getModel()).fireTableDataChanged();
        	        			}
        	        		}
        	        	}
                    });
    				cmbSort.setSelectedIndex(rz.getOptionFactory().getOption("report.dependency_sort_liste",0));
    			buttonPanel.add(cmbSort);
			mainPanel.add(toolbarPanel,BorderLayout.NORTH);
			mainPanel.add(contentPanel,BorderLayout.CENTER);
			mainPanel.add(buttonPanel,BorderLayout.SOUTH);

			getContentPane().setLayout(new BorderLayout());
			getContentPane().add(mainPanel,BorderLayout.CENTER);
    }
    @Override
	public void setGUIComponents() {
        setTitle(rz.getLocale().getString("dependency.titel"));
        mnuDatei.setText(rz.getLocale().getString("menu.datei"));
        mnuDatei.add(getAction(ACTION_CALC_CODE));
        mnuDatei.addSeparator();
        mnuDatei.add(getAction(ACTION_ABFRAGE_CODE));
        mnuDatei.addSeparator();
        mnuDatei.add(getAction(ACTION_CLOSE_CODE));
        tb1.add(getAction(ACTION_CALC_CODE));
        tb1.addSeparator();
        tb1.add(getAction(ACTION_ABFRAGE_CODE));
        tb1.addSeparator();
  	  	tb1.add(getAction(ACTION_CLOSE_CODE));
        btClose.setAction(getAction(ACTION_CLOSE_CODE));
        btCalc.setAction(getAction(ACTION_CALC_CODE));
        btDependencyDrucken.setAction(getAction(ACTION_DRUCKEN_CODE));
        btDependencyPreview.setAction(getAction(ACTION_PREVIEW_CODE));
        btAbfrage.setAction(getAction(ACTION_ABFRAGE_CODE));
        
        lblTitel.setText(rz.getLocale().getString("dependency.hilfe"));
        lblRechnen.setText("---");
 	   this.settblModel(tblListe);
         setResizable(true);
         rz.getFontFactory().setFrameFonts(this);
         this.setMinimumSize(new Dimension(300,300));
         this.setPreferredSize(new Dimension(300,300));
         pack();
         rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;
    }
    @Override
	public void getMessage(MessageItem msg) {
        switch(msg.getMsgCode()) {
    	case MessageItem.MSG_ACTIONPERFORMED:
            switch(msg.getCode()){
			case ACTION_CLOSE_CODE :okAction();break;
			case ACTION_CALC_CODE :calcAction();break;
			case ACTION_DRUCKEN_CODE: druckenAction();break;
			case ACTION_PREVIEW_CODE: previewAction();break;
			case ACTION_ABFRAGE_CODE: abfrageAction();break;
			default :
                break;
           }
	      	break;
    	case MessageItem.MSG_DEPENDENCY_CALC:
    		liste = (IDItem)msg.getData();
            lblTitel.setText(rz.getLocale().getString("dependency.hilfe").replaceAll("%s",liste.getRezeptur()).replaceAll("%n",String.valueOf(liste.getListe().size())));
            liste.getListe().Sort((String)cmbSort.getSelectedItem());;
            ((AbstractTableModel)tblListe.getModel()).fireTableDataChanged();
            break;
        default:
            rz.getLogFactory().logMessage(2, "dependencyFenster", "auswahlAction:" + msg.getMsgCode());
            break;
        }
    }

    private void abfrageAction() {
    	String ids="";
    	if(liste != null && liste.getListe() != null && liste.getListe().size() > 0) {
    		for(int i=0;i<liste.getListe().size();i++) {
    			ids += liste.getListe().getItem(i).getId() + ",";
    		}
    		if(ids.endsWith(",")) {
    			ids = ids.substring(0,ids.length()-1);
    		}
	    	final AbfrageItem ai = new AbfrageItem();
			ai.setID(0);
			ai.setAdressListe(new StichwortListe());
			ai.setStichwortListe(new StichwortListe());
			ai.setTyp(de.lunqual.rzpro.database.DBAbfrage.ABFRAGE_TYP_SQL);
			ai.setMuster(rz.getDatabase().getErgebnis().getErweitertSQLPrefix() + " rezeptliste.id in (" + ids + ") and rezeptliste.typ=1 group by rezeptliste.id order by name");
			try {
				rz.setWaitCursor(this);
				JRzFrame frame = rz.getFensterFactory().getFensterListe().getAuswahl();
				frame.getMessage(new MessageItem(MessageItem.MSG_ADD_QUERY_REZEPT, ai.getID(), ai,this)); 
				rz.setFreeCursor(this);
			} catch (final Exception e) {}
    	}
	}
    
    private void druckenAction() {
    	rz.getReportFactory().dependencyListeDrucken(liste.getListe(),false, this);
    }
    
    private void previewAction() {
    	rz.getReportFactory().dependencyListeDrucken(liste.getListe(),true, this);
    }
    
    @Override
	public void createActions(){
		actionList.put(String.valueOf(ACTION_CLOSE_CODE), new AuswahlAction(rz,this,ACTION_CLOSE_CODE,ACTION_CLOSE_TEXT,KeyEvent.VK_ESCAPE,	0));
		actionList.put(String.valueOf(ACTION_CALC_CODE), new AuswahlAction(rz,this,ACTION_CALC_CODE,ACTION_CALC_TEXT,KeyEvent.VK_ENTER,	0));
		actionList.put(String.valueOf(ACTION_DRUCKEN_CODE), new AuswahlAction(rz,this,ACTION_DRUCKEN_CODE,ACTION_DRUCKEN_TEXT,0,	0));
		actionList.put(String.valueOf(ACTION_PREVIEW_CODE), new AuswahlAction(rz,this,ACTION_PREVIEW_CODE,ACTION_PREVIEW_TEXT,0,	0));
		actionList.put(String.valueOf(ACTION_ABFRAGE_CODE), new AuswahlAction(rz,this,ACTION_ABFRAGE_CODE,ACTION_ABFRAGE_TEXT,0,	0));
    }


    /**
     * berechnen
     */
    private void calcAction() {
    	DependencyListe l = liste.getListe();
    	l.SortOrder();
    	if(l != null && l.size() > 0) {
    		rz.setWaitCursor(this);
    		for(int i=0;i <l.size();i++) {
    			if(l.getItem(i).getStatus()==DependencyItem.STATUS_NONE) {
    				lblRechnen.setText(rz.getLocale().getString("dependency.rechnen").replaceAll("%s",l.getItem(i).getName()));
    				rz.getDatabase().getRezeptur().calcSingle(liste.getListe().getItem(i).getId(),l.getItem(i).getTyp());
    				l.getItem(i).setStatus(DependencyItem.STATUS_OK);
    				((AbstractTableModel)tblListe.getModel()).fireTableDataChanged();
    			}
    		}
    		l.Sort((String)cmbSort.getSelectedItem());
    		((AbstractTableModel)tblListe.getModel()).fireTableDataChanged();
    		lblRechnen.setText("---");
    		rz.setFreeCursor(this);
    		getAction(ACTION_CALC_CODE).setEnabled(false);
    	}
    }
    /**
     * ok gedrückt... abspeichern oder ändern
     */
    private void okAction(){
    	closeWindow();
    }

    @Override
	public void closeWindow(){
        rz.getFensterFactory().getFensterListe().disposeFrame(this);
    }
    @Override
	public void openWindow(){
        if (!isVisible()) {
			setVisible(true);
		}
        toFront();
    }

    
    private void settblModel(JTable t) {
 	   final srColumnModel rcm = new srColumnModel();
 	    final StringRenderer sr = new StringRenderer();
 	    TableColumn tc = new TableColumn();
     		tc.setHeaderValue(rz.getLocale().getString("dependencyfenster.tableheader_erledigt"));
     		tc.setModelIndex(C_ERLEDIGT);
     		tc.setCellRenderer(sr);
     	rcm.addColumn(tc);
 	   tc = new TableColumn();
 	    	tc.setHeaderValue(rz.getLocale().getString("dependencyfenster.tableheader_name"));
 	    	tc.setModelIndex(C_NAME);
 	    	tc.setCellRenderer(sr);
 	    rcm.addColumn(tc);
 	    tc = new TableColumn();
 	    	tc.setHeaderValue(rz.getLocale().getString("dependencyfenster.tableheader_lager"));
 	    	tc.setModelIndex(C_LAGER);
 	    	tc.setCellRenderer(sr);
 	    rcm.addColumn(tc);
 	    tc = new TableColumn();
 			tc.setHeaderValue(rz.getLocale().getString("dependencyfenster.tableheader_steuerlager"));
 			tc.setModelIndex(C_STEUERLAGER);
 			tc.setCellRenderer(sr);
 		rcm.addColumn(tc);
 	    tc = new TableColumn();
 			tc.setHeaderValue(rz.getLocale().getString("dependencyfenster.tableheader_steuerartikel"));
 			tc.setModelIndex(C_STEUERARTIKEL);
 			tc.setCellRenderer(sr);
 		rcm.addColumn(tc);

         tblListe.setModel(new srTableModel());
         tblListe.setColumnModel(rcm);
         tblListe.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
         tblListe.getTableHeader().setReorderingAllowed(false);
 	}

 	private class srColumnModel extends DefaultTableColumnModel{
 	    public srColumnModel() {
 	        super();
 	    }

 	}
    
	private  class srTableModel extends AbstractTableModel    {

        public srTableModel() {
        }

	   public int getColumnCount() {
	       	return MAX_COLUMN;
        }
        public int getRowCount() {
        	if(liste  != null && liste.getListe() != null) {
                return liste.getListe().size();
        	} else {
        		return 0;
        	}
        }
        public Object getValueAt(int rowIndex, int columnIndex) {
            Object ret = null;
            if((rowIndex != -1) && (liste != null)) {
                ret = getContent(liste.getListe().getItem(rowIndex),columnIndex,rowIndex);
            }
            return ret;
        }


        private Object getContent(DependencyItem di,int aColumn,int row) {
            Object ret = null;
            if(di != null) {
	            switch(aColumn){
	            	case C_ERLEDIGT:
	            		if(di.getStatus()==DependencyItem.STATUS_NONE) {
	            			ret = di.getOrder()+": "+di.getNot_ok();
	            		} else {
	            			ret = di.getOrder() + ": "+di.getOk_string();
	            		}
	            		break;
	            	case C_NAME:
	            		ret=di.getName();
	            	    break;
	            	 case C_LAGER:
	            	     ret = di.getLager();
	            	     break;
	            	 case C_STEUERLAGER:
	            		 ret=di.getSteuer_lager();
	            		 break;
	            	 case C_STEUERARTIKEL:
	            		 ret = di.getSteuer_artikel();
	            		 break;
	            }
            }
            return ret;
        }
	}
    
    /*------------------------------------------------------------------------
     * ListenRenderer
     *
     *------------------------------------------------------------------------
     */
    private final class ListRenderer extends JLabel implements ListCellRenderer{
        RzPro   rz;
        public ListRenderer(RzPro r){
            rz = r;
            setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list,Object value,int index, boolean isSelected,boolean cellHasFocus){
            final DependencyItem di = (DependencyItem)value;
            this.setFont(rz.getFontFactory().getListFont());
            setText(di.toString());
            if(index % 2 == 0){
                setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_EVEN));
                setForeground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_FOREGROUND_NORMAL));
            }else {
                setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_ODD));
                setForeground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_FOREGROUND_SELECTED));
            }
            return this;
        }
    }

    
	/** rendert alle Tabellenzeilen mit String Inhalt
	 *  im wesentlichen heisst das rechts-ausgerichtent
	 * @author lunqual
	 */
	private class StringRenderer extends DefaultTableCellRenderer {

	    StringRenderer() {
	        super();
	        setOpaque(true);
	    }
	    @Override
		public Component getTableCellRendererComponent(JTable table,
                Object value, boolean isSelected, boolean hasFocus, int row,
                int column)
	    {
	    	setFont(rz.getFontFactory().getTableFont());
	    	if (row % 2 == 0) {
		        	setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_ODD));
		        }else {
		        	setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_NORMAL));
		        }
	        if(value != null) {
	        	setText(value.toString());
	         } else {
				setText("");
			}
	        setHorizontalAlignment(SwingConstants.LEADING);
	        return this;
        }
	}
    
    
	@Override
	public void columnAdded(TableColumnModelEvent arg0) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void columnMarginChanged(ChangeEvent arg0) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void columnMoved(TableColumnModelEvent arg0) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void columnRemoved(TableColumnModelEvent arg0) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void columnSelectionChanged(ListSelectionEvent arg0) {
		// TODO Auto-generated method stub
		
	}

}

