/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package de.lunqual.rzpro.fenster.buchungsfenster;


import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;

import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.ScrollPaneConstants;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.database.DBAbfrage;
import de.lunqual.rzpro.database.DBBuchung;
import de.lunqual.rzpro.fenster.JNumberField;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fenster.JSelectedTextField;
import de.lunqual.rzpro.fenster.TankDialog;
import de.lunqual.rzpro.fenster.ZutatenDialog;
import de.lunqual.rzpro.fenster.dialoge.DialogControl;
import de.lunqual.rzpro.fenster.dialoge.EingabeDialog;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.abfrage.AbfrageItem;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.buchung.BuchungsItem;
import de.lunqual.rzpro.items.buchung.LosnummerItem;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.items.einheiten.EinheitsItem;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.mischungen.MischungsHeaderItem;
import de.lunqual.rzpro.items.mischungen.MischungsItem;
import de.lunqual.rzpro.items.paletten.PalettenReturnItem;
import de.lunqual.rzpro.items.rezeptur.ZutatenSuchItem;
import de.lunqual.rzpro.items.stichworte.StichwortListe;
import de.lunqual.rzpro.items.tank.tankAuswahlItem;
import de.lunqual.rzpro.items.tank.tankItem;
import de.lunqual.rzpro.log.LogFactory;
import de.lunqual.rzpro.options.OptionFactory;
/**
 *
 * @author  lunqual
 */
public class AbgangsFenster extends JRzFrame   implements TableColumnModelListener{

	//GUI-Variablen
	private JToolBar tb1;
	private JMenuBar mb;
	private JMenu mnuDatei;
	private JMenu	mnuBearbeiten;
	private JMenu 	mnuFenster;
	private JMenu mnuExtras;
	private JMenu mnuHilfe;
	private  JPanel contentPanel;
	private JPanel tbPanel;
	private JPanel centerPanel;
	private JPanel rezepturPanel;
	private JComboBox cmbAbgangsArt;
	private JLabel lblRezeptur;
	private JPanel bestandPanel;
	private JPanel altBestandPanel;
	private JLabel lblAltHeadline;
	private JPanel altAnzeigePanel;
	private JNumberField txtAltLiter;
	private JLabel lblAltLiter;
	private JNumberField txtAltKg;
	private JLabel lblAltKg;
	private JNumberField txtAltLa;
	private JLabel lblAltLa;
	private JPanel abgangPanel;
	private JPanel abgangTextPanel;
	private JPanel abgangTextObenPanel;
	private JPanel abgangMengenPanel;
	private JPanel abgangPalettenPanel;
	private JLabel lblAbgang;
	private JButton btPalettenrechner;
	private JNumberField txtAbgang;
	private JComboBox cmbAbgangsEinheit;
	private JPanel abgangNummernPanel;
	private JLabel lblFlaschen;
	private JSelectedTextField txtFlaschen;
	private JButton btFlaschenLosnummer;
	private JLabel lblDeckel;
	private JSelectedTextField txtDeckel;
	private JLabel lblTank;
	private JSelectedTextField txtTank;
	private JPanel tankButtonPanel;
	private JButton btTankText;
	private JButton btTankPlan;
	private JButton btDeckelLosnummer;
	private JPanel abgangTextUntenPanel;
	private JLabel lblComment;
	private JSelectedTextField txtComment;
	private JButton btClearComment;
	private JPanel listenPanel;
	private JPanel listenHeaderPanel;
	private JComboBox cmbEntnahme;
	private JLabel lblLosnummer;
	private JScrollPane scrLosnummer;
	private JTable tblLose;
	private JPanel probenPanel;
	private JLabel lblWarnung;
	private JLabel lblDatum;
	private JButton btProbenverzeichnis;
	private JPanel neuBestandPanel;
	private JLabel lblNeuHeadline;
	private JPanel neuAnzeigePanel;
	private JNumberField txtNeuLiter;
	private JLabel lblNeuLiter;
	private JNumberField txtNeuKg;
	private JLabel lblNeuKg;
	private JNumberField txtNeuLa;
	private JLabel lblNeuLa;
	private JPanel buttonPanel;
	private JPanel savePanel;
	private JButton btSpeichern;
	private JPanel umbuchenPanel;
	private JPanel umbuchenLabelPanel;
	private JLabel lblUmbuchen;
	private JButton btZutatenDialog;
	private JButton btUmbuchen;
	private JPanel mischungsPanel;
	private JPanel mischungTankPanel;
	private JLabel lblMischung;
	private JPanel mischungTankButtonPanel;
	private JButton btTankMischungText;
	private JButton btTankMischungPlan;
	private JButton btTankMischungNummer;
	private JButton btMischungUebergang;

	private JButton btHilfe;
	private JButton btAbbrechen;

	public static final int         		ACTION_ABBRECHEN_CODE = 1001;
	public static final String     		ACTION_ABBRECHEN_TEXT = "abgang.action_abbrechen";
	public static final int         		ACTION_SAVE_CODE = 1002;
	public static final String     		ACTION_SAVE_TEXT = "abgang.action_speichern";
	public static final int         		ACTION_HILFE_CODE = 1003;
	public static final String     		ACTION_HILFE_TEXT = "action_hilfe";
	public static final int         		ACTION_HIDE_CODE = 1004;
	public static final String    		ACTION_HIDE_TEXT = "action_hide";
	public static final int         		ACTION_PALETTENRECHNER_CODE = 1005;
	public static final String     		ACTION_PALETTENRECHNER_TEXT = "abgang.action_palettenrechner";
	public static final int         		ACTION_PALETTEN_CODE = 1006;
	public static final String     		ACTION_PALETTEN_TEXT = "abgang.action_palette";
	public static final int        			ACTION_FLASCHEN_LOSNUMMER_CODE  = 1025;
	public static final String     		ACTION_FLASCHEN_LOSNUMMER_TEXT = "abgang.action_flaschen_losnummer";
	public static final int        			ACTION_DECKEL_LOSNUMMER_CODE  = 1026;
	public static final String     		ACTION_DECKEL_LOSNUMMER_TEXT = "abgang.action_deckel_losnummer";
	public static final int        		ACTION_UMBUCHEN_CODE  = 1027;
	public static final String     		ACTION_UMBUCHEN_TEXT = "abgang.action_umbuchen";
	public static final int         		ACTION_PROBE_CODE = 1028;
	public static final String     		ACTION_PROBE_TEXT = "abgang.action_probenverzeichnis";
	public static final int         		ACTION_KALENDER_CODE = 1029;
	public static final String     		ACTION_KALENDER_TEXT = "abgang.action_kalender";
	public static final int        		ACTION_TANKLISTE_TEXT_CODE  = 1030;
	public static final String     		ACTION_TANKLISTE_TEXT_TEXT = "tankliste_text";
	public static final int        		ACTION_TANKLISTE_PLAN_CODE  = 1031;
	public static final String     		ACTION_TANKLISTE_PLAN_TEXT = "tankliste_plan";
	public static final int        		ACTION_TANKLISTE_MISCHUNG_TEXT_CODE  = 1032;
	public static final String     		ACTION_TANKLISTE_MISCHUNG_TEXT_TEXT = "tankliste_text";
	public static final int        		ACTION_TANKLISTE_MISCHUNG_PLAN_CODE  = 1033;
	public static final String     		ACTION_TANKLISTE_MISCHUNG_PLAN_TEXT = "tankliste_plan";
	public static final int        		ACTION_MISCHUNG_UEBERGANG_CODE  = 1034;
	public static final String     		ACTION_MISCHUNG_UEBERGANG_TEXT = "abgang.mischung_uebergang";
	public static final int        		ACTION_CLEAR_COMMENT_CODE  = 1035;
	public static final String     		ACTION_CLEAR_COMMENT_TEXT = "abgang.clear_comment";
	public static final int        		ACTION_TANKLISTE_MISCHUNG_NUMMER_CODE  = 1036;
	public static final String     		ACTION_TANKLISTE_MISCHUNG_NUMMER_TEXT = "abgang.action_mischung_nummer";


	public static final int				RECHNEN_ZUGANG = 1;
	public static final int				RECHNEN_NEU_LITER = 2;
	public static final int				RECHNEN_NEU_KG = 3;
	public static final int				RECHNEN_NEU_LA = 4;

	ZutatenDialog							zd;
	BuchungsItem							bi;
	Color									 	red;
	Color										black;
	Color										white;
	JRzFrame									origin;
	DialogItem                                dlgItem;
	TankDialog								td;


	int											moveToRezepturID=0;
	String										moveToRezepturName="";
	ArrayList<LosnummerItem>		lose;

	public static final int					MAX_COLUMN = 6;
	public static final int					C_LOSNUMMER=0;
	public static final int					C_COMMENT=1;
	public static final int					C_RPROBE=2;
	public static final int					C_RPROBE_BUTTON=3;
	public static final int					C_PROBE=4;
	public static final int					C_ALLES=5;

	private static final int GET_REZEPTUR = 1;
	int zd_dialog_typ = GET_REZEPTUR;

	String										returnRezepturName="";
	int											returnRezepturID=0;
	boolean									tankReplyMischung = false;
	int											mischungUebergangNummer=0;

	/** Creates new form AdressenFenster */
	public AbgangsFenster(final RzPro r, final String name, final Object extendedData) {
		super(r,name,extendedData);
		dlgItem = new DialogItem(0,"",0.0,"","","","","","",null);
		red = Color.RED;
		white = Color.WHITE;
		black = Color.BLACK;
		bi = null;

		createActions();
		createGUIComponents();
		setGUIComponents();
		getMessage((MessageItem)extendedData);
	}

	@Override
	public void createGUIComponents() {
		// Menü
		mb = new JMenuBar();
		mnuDatei = new JMenu();
		mnuFenster = new JMenu();
		mnuExtras = new JMenu();
		mnuHilfe = new JMenu();
		mnuBearbeiten = new JMenu();
		mb.add(mnuDatei);
		mb.add(mnuBearbeiten);
		mb.add(mnuFenster);
		mb.add(mnuExtras);
		mb.add(mnuHilfe);
		setJMenuBar(mb);
		//Toolbar
		tb1 = new JToolBar();
		tb1.setFloatable(false);
		tb1.setRollover(true);
		//ToolbarPanel
		//contentPanel
		contentPanel = new JPanel(new BorderLayout());
		tbPanel = new JPanel(new BorderLayout());
		tbPanel.add(tb1,BorderLayout.NORTH);
		contentPanel.add(tbPanel,BorderLayout.NORTH);
		centerPanel = new JPanel(new BorderLayout());
		rezepturPanel = new JPanel(new BorderLayout());
		cmbAbgangsArt = new JComboBox();
		cmbAbgangsArt.addItem(rz.getLocale().getString("abgang.typ_entnahme"));
		cmbAbgangsArt.addItem(rz.getLocale().getString("abgang.typ_korrektur"));
		cmbAbgangsArt.addActionListener(new ActionListener() {
			public void actionPerformed(final ActionEvent evt) {
				if(bi != null) {
					if(cmbAbgangsArt.getSelectedIndex()==0) {
						bi.setCode(DBBuchung.CODE_ENTNAHME);
					} else {
						bi.setCode(DBBuchung.CODE_KORREKTUR_ABGANG);
					}
					setActions();
				}
			}
		});
		rezepturPanel.add(cmbAbgangsArt,BorderLayout.WEST);
		lblRezeptur = new JLabel();
		lblRezeptur.setHorizontalAlignment(SwingConstants.CENTER);
		rezepturPanel.add(lblRezeptur,BorderLayout.CENTER);
		rezepturPanel.setBorder(BorderFactory.createLoweredBevelBorder());
		centerPanel.add(rezepturPanel,BorderLayout.NORTH);
		bestandPanel=new JPanel(new BorderLayout());
		altBestandPanel = new JPanel(new BorderLayout());
		lblAltHeadline = new JLabel();
		lblAltHeadline.setHorizontalAlignment(SwingConstants.CENTER);
		altBestandPanel.add(lblAltHeadline,BorderLayout.NORTH);
		altAnzeigePanel=new JPanel(new GridLayout(1,6));
		txtAltLiter = new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_NORMAL),0.0,Double.NEGATIVE_INFINITY,Double.POSITIVE_INFINITY);
		txtAltLiter.setEditable(false);
		altAnzeigePanel.add(txtAltLiter);
		lblAltLiter = new JLabel();
		altAnzeigePanel.add(lblAltLiter);
		txtAltKg = new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_NORMAL),0.0,Double.NEGATIVE_INFINITY,Double.POSITIVE_INFINITY);
		txtAltKg.setEditable(false);
		altAnzeigePanel.add(txtAltKg);
		lblAltKg = new JLabel();
		altAnzeigePanel.add(lblAltKg);
		txtAltLa = new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_NORMAL),0.0,Double.NEGATIVE_INFINITY,Double.POSITIVE_INFINITY);
		txtAltLa.setEditable(false);
		altAnzeigePanel.add(txtAltLa);
		lblAltLa = new JLabel();
		altAnzeigePanel.add(lblAltLa);
		altBestandPanel.add(altAnzeigePanel,BorderLayout.SOUTH);
		altBestandPanel.setBorder(BorderFactory.createEtchedBorder());
		bestandPanel.add(altBestandPanel,BorderLayout.NORTH);
		abgangPanel = new JPanel(new BorderLayout());
		abgangTextPanel = new JPanel(new BorderLayout());
		abgangMengenPanel=new JPanel(new BorderLayout());
		abgangTextObenPanel = new JPanel(new BorderLayout());
		abgangPalettenPanel = new JPanel(new BorderLayout());
		lblAbgang=new JLabel();
		lblAbgang.setHorizontalAlignment(SwingConstants.TRAILING);
		abgangPalettenPanel.add(lblAbgang,BorderLayout.WEST);
		btPalettenrechner = new JButton();
		abgangPalettenPanel.add(btPalettenrechner);
		abgangMengenPanel.add(abgangPalettenPanel,BorderLayout.WEST);
		txtAbgang = new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_NORMAL),0.0,0,Double.POSITIVE_INFINITY);
		txtAbgang.addKeyListener(new java.awt.event.KeyAdapter() {
			@Override
			public void keyReleased(final java.awt.event.KeyEvent evt) {
				if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
					if(bi != null) {
						rechnen(RECHNEN_ZUGANG);
					}
				}
			}
		});
		txtAbgang.addFocusListener(new FocusListener() {
			public void focusGained(final FocusEvent evt) {
			}
			public void focusLost(final FocusEvent evt) {
				if(bi != null) {
					rechnen(RECHNEN_ZUGANG);
				}
			}
		});
		abgangMengenPanel.add(txtAbgang,BorderLayout.CENTER);
		cmbAbgangsEinheit = new JComboBox();
		cmbAbgangsEinheit.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(final java.awt.event.ActionEvent evt) {
				rechnen(RECHNEN_ZUGANG);
			}
		});
		abgangMengenPanel.add(cmbAbgangsEinheit,BorderLayout.EAST);
		abgangTextObenPanel.add(abgangMengenPanel,BorderLayout.NORTH);

		abgangNummernPanel=new JPanel(new GridLayout(3,3));
		lblFlaschen=new JLabel();
		lblFlaschen.setHorizontalAlignment(SwingConstants.TRAILING);
		abgangNummernPanel.add(lblFlaschen);
		txtFlaschen=new JSelectedTextField();
		txtFlaschen.setColumns(30);
		abgangNummernPanel.add(txtFlaschen);
		btFlaschenLosnummer = new JButton();
		abgangNummernPanel.add(btFlaschenLosnummer);
		lblDeckel=new JLabel();
		lblDeckel.setHorizontalAlignment(SwingConstants.TRAILING);
		txtDeckel=new JSelectedTextField();
		txtDeckel.setColumns(30);
		this.btDeckelLosnummer=new JButton();
		abgangNummernPanel.add(lblDeckel);
		abgangNummernPanel.add(txtDeckel);
		abgangNummernPanel.add(btDeckelLosnummer);

		lblTank = new JLabel();
		lblTank.setHorizontalAlignment(SwingConstants.TRAILING);
		abgangNummernPanel.add(lblTank);
		txtTank = new JSelectedTextField();
		abgangNummernPanel.add(txtTank);
		tankButtonPanel = new JPanel(new GridLayout(1,2));
		btTankText= new JButton();
		tankButtonPanel.add(btTankText);
		btTankPlan = new JButton();
		tankButtonPanel.add(btTankPlan);
		abgangNummernPanel.add(tankButtonPanel);
		abgangTextObenPanel.add(abgangNummernPanel,BorderLayout.SOUTH);
		abgangTextUntenPanel = new JPanel(new BorderLayout());
		lblComment = new JLabel();
		lblComment.setHorizontalAlignment(SwingConstants.TRAILING);
		abgangTextUntenPanel.add(lblComment,BorderLayout.WEST);
		txtComment=new JSelectedTextField();

		txtComment.addFocusListener(new FocusListener() {
			public void focusGained(final FocusEvent evt) {
			}
			public void focusLost(final FocusEvent evt) {
				if(bi != null) {
					setActions();
				}
			}
		});
		abgangTextUntenPanel.add(txtComment,BorderLayout.CENTER);
		btClearComment = new JButton();
		abgangTextUntenPanel.add(btClearComment,BorderLayout.EAST);
		abgangTextPanel.add(abgangTextObenPanel,BorderLayout.NORTH);
		abgangTextPanel.add(abgangTextUntenPanel,BorderLayout.SOUTH);
		abgangPanel.add(abgangTextPanel,BorderLayout.NORTH);
		listenPanel = new JPanel(new BorderLayout());
		listenHeaderPanel = new JPanel(new BorderLayout());
		lblLosnummer=new JLabel();
		lblLosnummer.setHorizontalAlignment(SwingConstants.CENTER);
		listenHeaderPanel.add(lblLosnummer,BorderLayout.CENTER);
		cmbEntnahme = new JComboBox();
		cmbEntnahme.addItem(rz.getLocale().getString("abgang.entnahme_typ1"));
		cmbEntnahme.addItem(rz.getLocale().getString("abgang.entnahme_typ2"));
		cmbEntnahme.addActionListener(new ActionListener() {
			public void actionPerformed(final ActionEvent evt) {
				if(bi != null) {
					if(cmbEntnahme.getSelectedIndex()==0) {
						bi.setLosnummer_reihe(DBBuchung.REIHE_FIFO);
					} else {
						bi.setLosnummer_reihe(DBBuchung.REIHE_LIFO);
					}
					lose = rz.getDatabase().getBuchungen().getLosNummerListe(bi.getLosnummer_reihe(),bi.getRezeptur_id(), txtAbgang.getValue(),(EinheitsItem)cmbAbgangsEinheit.getSelectedItem());
					if(tblLose != null) {
						((AbstractTableModel)tblLose.getModel()).fireTableDataChanged();
					}
				}
			}
		});
		listenHeaderPanel.add(cmbEntnahme,BorderLayout.WEST);
		listenPanel.add(listenHeaderPanel,BorderLayout.NORTH);
		scrLosnummer = new JScrollPane();
		tblLose = new JTable();
		tblLose.setName("abgangsfenster.spalten");
		tblLose.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		tblLose.getSelectionModel().addListSelectionListener(new ListSelectionListener() {
			public void valueChanged(final ListSelectionEvent e) {
				if (e.getValueIsAdjusting()) {
					return;
				}else {

				}

			}
		});
		tblLose.setColumnSelectionAllowed(false);
		tblLose.setRowSelectionAllowed(true);
		tblLose.setGridColor(rz.getOptionFactory().getColor(OptionFactory.COLOR_VISIBLE_GRID));
		tblLose.setShowGrid(true);
		tblLose.addMouseListener(new MouseAdapter() {
			public void mousePressed(final MouseEvent e) {
			}
			public void mouseReleased(final MouseEvent e) {
				maybeShowPopup(e);
			}

			private void maybeShowPopup(final MouseEvent e) {
				final int row = tblLose.rowAtPoint(e.getPoint());
				final int col = tblLose.columnAtPoint(e.getPoint());
				if((col==(C_RPROBE_BUTTON)) || (col == (C_RPROBE))) {
					probenNeuAction(row);
				}
				if(col == C_ALLES) {
					mengenAction(row);
				}
				if(col == C_COMMENT) {
					discardAction(row);
				}
			}
		});
		rz.setPreferredRowHeights(tblLose);


		scrLosnummer.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_AS_NEEDED);
		scrLosnummer.setHorizontalScrollBarPolicy(ScrollPaneConstants.HORIZONTAL_SCROLLBAR_AS_NEEDED);
		scrLosnummer.setViewportView(tblLose);
		listenPanel.add(scrLosnummer,BorderLayout.CENTER);

		probenPanel=new JPanel(new BorderLayout());
		lblWarnung = new JLabel();
		probenPanel.add(lblWarnung,BorderLayout.WEST);
		lblDatum=new JLabel();
		lblDatum.setHorizontalAlignment(SwingConstants.CENTER);
		probenPanel.add(lblDatum,BorderLayout.CENTER);
		this.btProbenverzeichnis=new JButton();
		probenPanel.add(btProbenverzeichnis,BorderLayout.EAST);
		listenPanel.add(probenPanel,BorderLayout.SOUTH);
		abgangPanel.add(listenPanel,BorderLayout.CENTER);
		bestandPanel.add(abgangPanel,BorderLayout.CENTER);
		neuBestandPanel=new JPanel(new BorderLayout());
		lblNeuHeadline = new JLabel();
		lblNeuHeadline.setHorizontalAlignment(SwingConstants.CENTER);
		neuBestandPanel.add(lblNeuHeadline,BorderLayout.NORTH);
		neuAnzeigePanel = new JPanel(new GridLayout(1,6));
		txtNeuLiter = new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_NORMAL),0.0,Double.NEGATIVE_INFINITY,Double.POSITIVE_INFINITY);
		txtNeuLiter.addKeyListener(new java.awt.event.KeyAdapter() {
			@Override
			public void keyReleased(final java.awt.event.KeyEvent evt) {
				if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
					if(bi != null) {
						rechnen(RECHNEN_NEU_LITER);
					}
				}
			}
		});
		txtNeuLiter.addFocusListener(new FocusListener() {
			public void focusGained(final FocusEvent evt) {
			}
			public void focusLost(final FocusEvent evt) {
				if(bi != null) {
					rechnen(RECHNEN_NEU_LITER);
				}
			}
		});
		neuAnzeigePanel.add(txtNeuLiter);
		lblNeuLiter = new JLabel();
		lblNeuLiter.setHorizontalAlignment(SwingConstants.LEADING);
		neuAnzeigePanel.add(lblNeuLiter);
		txtNeuKg = new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_NORMAL),0.0,Double.NEGATIVE_INFINITY,Double.POSITIVE_INFINITY);
		txtNeuKg.addKeyListener(new java.awt.event.KeyAdapter() {
			@Override
			public void keyReleased(final java.awt.event.KeyEvent evt) {
				if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
					if(bi != null) {
						rechnen(RECHNEN_NEU_KG);
					}
				}
			}
		});
		txtNeuKg.addFocusListener(new FocusListener() {
			public void focusGained(final FocusEvent evt) {
			}
			public void focusLost(final FocusEvent evt) {
				if(bi != null) {
					rechnen(RECHNEN_NEU_KG);
				}
			}
		});
		neuAnzeigePanel.add(txtNeuKg);
		lblNeuKg = new JLabel();
		lblNeuKg.setHorizontalAlignment(SwingConstants.LEADING);
		neuAnzeigePanel.add(lblNeuKg);
		txtNeuLa = new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_NORMAL),0.0,Double.NEGATIVE_INFINITY,Double.POSITIVE_INFINITY);
		txtNeuLa.addKeyListener(new java.awt.event.KeyAdapter() {
			@Override
			public void keyReleased(final java.awt.event.KeyEvent evt) {
				if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
					if(bi != null) {
						rechnen(RECHNEN_NEU_LA);
					}
				}
			}
		});
		txtNeuLa.addFocusListener(new FocusListener() {
			public void focusGained(final FocusEvent evt) {
			}
			public void focusLost(final FocusEvent evt) {
				if(bi != null) {
					rechnen(RECHNEN_NEU_LA);
				}
			}
		});
		neuAnzeigePanel.add(txtNeuLa);
		lblNeuLa = new JLabel();
		lblNeuLa.setHorizontalAlignment(SwingConstants.LEADING);
		neuAnzeigePanel.add(lblNeuLa);
		neuBestandPanel.add(neuAnzeigePanel,BorderLayout.CENTER);
		neuBestandPanel.setBorder(BorderFactory.createEtchedBorder());
		bestandPanel.add(neuBestandPanel,BorderLayout.SOUTH);
		bestandPanel.setBorder(BorderFactory.createLoweredBevelBorder());
		centerPanel.add(bestandPanel,BorderLayout.CENTER);
		contentPanel.add(centerPanel,BorderLayout.CENTER);
		// ButtonPanel
		buttonPanel = new JPanel(new BorderLayout());

		//buttonPanel.add(movePanel,BorderLayout.NORTH);
		savePanel=new JPanel(new GridLayout(1,5));
		btSpeichern = new JButton();
		savePanel.add(btSpeichern);
		umbuchenPanel=new JPanel(new BorderLayout());
		umbuchenPanel.setBorder(BorderFactory.createEtchedBorder());
		umbuchenLabelPanel = new JPanel(new BorderLayout());
		lblUmbuchen=new JLabel();
		lblUmbuchen.addKeyListener(new java.awt.event.KeyAdapter() {
			@Override
			public void keyReleased(final java.awt.event.KeyEvent evt) {
				//txtTextKeyReleased(evt);
			}
		});
		umbuchenLabelPanel.add(lblUmbuchen,BorderLayout.CENTER);
		btZutatenDialog = new JButton();
		btZutatenDialog.addActionListener(new ActionListener() {
			public void actionPerformed(final ActionEvent evt) {
				showZutatenDialog(lblUmbuchen.getText().replaceAll("<html>", "").replaceAll("</html>", ""));
			}
		});
		umbuchenLabelPanel.add(btZutatenDialog,BorderLayout.EAST);
		umbuchenPanel.add(umbuchenLabelPanel,BorderLayout.NORTH);
		btUmbuchen = new JButton();
		umbuchenPanel.add(btUmbuchen,BorderLayout.SOUTH);
		savePanel.add(umbuchenPanel);

		mischungsPanel = new JPanel(new BorderLayout());
		mischungsPanel.setBorder(BorderFactory.createEtchedBorder());
		mischungTankPanel = new JPanel(new BorderLayout());
		lblMischung = new JLabel();
		mischungTankPanel.add(lblMischung,BorderLayout.CENTER);
		mischungTankButtonPanel = new JPanel(new GridLayout(1,3));
		btTankMischungText = new JButton();
		mischungTankButtonPanel.add(btTankMischungText);
		btTankMischungPlan = new JButton();
		mischungTankButtonPanel.add(btTankMischungPlan);
		btTankMischungNummer = new JButton();
		mischungTankButtonPanel.add(btTankMischungNummer);
		mischungTankPanel.add(mischungTankButtonPanel,BorderLayout.EAST);
		btMischungUebergang = new JButton();
		mischungsPanel.add(mischungTankPanel,BorderLayout.NORTH);
		mischungsPanel.add(btMischungUebergang,BorderLayout.SOUTH);
		if(rz.isMain()) {
			savePanel.add(mischungsPanel);
		}
		btHilfe = new JButton();
		savePanel.add(btHilfe);
		btAbbrechen = new JButton();
		savePanel.add(btAbbrechen);
		buttonPanel.add(savePanel,BorderLayout.SOUTH);
		contentPanel.add(buttonPanel,BorderLayout.SOUTH);

		//Panels ans Fenster hängen;
		this.getContentPane().setLayout(new BorderLayout());

		this.getContentPane().add(contentPanel, BorderLayout.CENTER);
	}


	@Override
	public void setGUIComponents() {

		setTitle(rz.getVersionString() + " " + rz.getLocale().getString("abgang.titel") + "  " + rz.getLocale().getString("benutzer")+" " + rz.getDatabase().dbGetUser() + " " + rz.getDatabase().getKalender().getDatum20Now());

		mnuDatei.setText(rz.getLocale().getString("menu.datei"));
		mnuBearbeiten.setText(rz.getLocale().getString("menu.bearbeiten"));
		mnuExtras.setText(rz.getLocale().getString("menu.extras"));
		mnuFenster.setText(rz.getLocale().getString("menu.fenster"));
		mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));

		mnuDatei.add(getAction(ACTION_SAVE_CODE));
		mnuDatei.addSeparator();
		mnuDatei.add(getAction(ACTION_ABBRECHEN_CODE));
		mnuFenster.add(getAction(ACTION_PALETTEN_CODE));
		mnuFenster.add(getAction(ACTION_PALETTENRECHNER_CODE));
		mnuFenster.addSeparator();
		mnuFenster.add(getAction(ACTION_KALENDER_CODE));

		mnuExtras.add(getAction(ACTION_HIDE_CODE));
		mnuHilfe.add(getAction(ACTION_HILFE_CODE));

		tb1.add(getAction(ACTION_ABBRECHEN_CODE));
		tb1.addSeparator();
		tb1.add(getAction(ACTION_PALETTEN_CODE));
		tb1.add(getAction(ACTION_PALETTENRECHNER_CODE));
		tb1.addSeparator();
		tb1.add(getAction(ACTION_SAVE_CODE));
		tb1.add(getAction(ACTION_HIDE_CODE));
		tb1.addSeparator();
		tb1.add(getAction(ACTION_KALENDER_CODE));
		tb1.addSeparator();
		tb1.add(getAction(ACTION_HILFE_CODE));
		tb1.addSeparator();

		lblAltLiter.setText(rz.getLocale().getString("string_liter"));
		lblAltKg.setText(rz.getLocale().getString("string_kg"));
		lblAltLa.setText(rz.getLocale().getString("string_la"));
		lblNeuLiter.setText(rz.getLocale().getString("string_liter"));
		lblNeuKg.setText(rz.getLocale().getString("string_kg"));
		lblNeuLa.setText(rz.getLocale().getString("string_la"));
		lblAbgang.setText(rz.getLocale().getString("abgang.label_abgang"));
		lblAltHeadline.setText(rz.getLocale().getString("abgang.label_alt_headline"));
		lblNeuHeadline.setText(rz.getLocale().getString("abgang.label_neu_headline"));
		lblComment.setText(rz.getLocale().getString("abgang.label_comment"));
		lblLosnummer.setText(rz.getLocale().getString("abgang.label_losnummer"));
		lblFlaschen.setText(rz.getLocale().getString("abgang.label_flaschen"));
		lblDeckel.setText(rz.getLocale().getString("abgang.label_deckel"));
		lblTank.setText(rz.getLocale().getString("abgang.label_tank"));
		btZutatenDialog.setText(rz.getLocale().getString("abgang.zutatendialog"));
		btZutatenDialog.setToolTipText(rz.getLocale().getString("abgang.zutatendialog_tooltip"));

		btSpeichern.setAction(getAction(ACTION_SAVE_CODE));
		btUmbuchen.setAction(getAction(ACTION_UMBUCHEN_CODE));
		btHilfe.setAction(getAction(ACTION_HILFE_CODE));
		btAbbrechen.setAction(getAction(ACTION_ABBRECHEN_CODE));
		btFlaschenLosnummer.setAction(getAction(ACTION_FLASCHEN_LOSNUMMER_CODE));
		btDeckelLosnummer.setAction(getAction(ACTION_DECKEL_LOSNUMMER_CODE));
		btProbenverzeichnis.setAction(getAction(ACTION_PROBE_CODE));
		btTankText.setAction(getAction(ACTION_TANKLISTE_TEXT_CODE));
		btTankPlan.setAction(getAction(ACTION_TANKLISTE_PLAN_CODE));
		btTankMischungText.setAction(getAction(ACTION_TANKLISTE_MISCHUNG_TEXT_CODE));
		btTankMischungPlan.setAction(getAction(ACTION_TANKLISTE_MISCHUNG_PLAN_CODE));
		btTankMischungNummer.setAction(getAction(ACTION_TANKLISTE_MISCHUNG_NUMMER_CODE));
		btMischungUebergang.setAction(getAction(ACTION_MISCHUNG_UEBERGANG_CODE));
		btPalettenrechner.setAction(getAction(ACTION_PALETTENRECHNER_CODE));
		btClearComment.setAction(getAction(ACTION_CLEAR_COMMENT_CODE));

		getAction(ACTION_MISCHUNG_UEBERGANG_CODE).setEnabled(false);
		btUmbuchen.setEnabled(false);

		lblDatum.setText(rz.getDatabase().getKalender().getDatum20Now());
		this.settblLoseModel(tblLose);
		setResizable(true);
		rz.getFontFactory().setFrameFonts(this);
		pack();
		rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;
	}

	@Override
	public void getMessage(final MessageItem msg) {
		rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE,"abgangsfenster",String.valueOf(msg.getMsgCode()+":"+String.valueOf(msg.getCode())));
		switch(msg.getMsgCode()) {
			case MessageItem.MSG_ACTIONPERFORMED:
				switch(msg.getCode()){
					case ACTION_SAVE_CODE:speichernAction();break;
					case ACTION_UMBUCHEN_CODE:umbuchenAction();break;
					case ACTION_HILFE_CODE: hilfeAction();break;
					case ACTION_HIDE_CODE:hideAction();break;
					case ACTION_ABBRECHEN_CODE:closeWindow();break;
					case ACTION_PALETTEN_CODE:palettenAction();break;
					case ACTION_PALETTENRECHNER_CODE:palettenRechnerAction();break;
					case ACTION_FLASCHEN_LOSNUMMER_CODE:losnummerAction(true);break;
					case ACTION_DECKEL_LOSNUMMER_CODE:losnummerAction(false);break;
					case ACTION_PROBE_CODE:probenVerzeichnisAction();break;
					case ACTION_KALENDER_CODE:showKalenderAction();break;
					case ACTION_TANKLISTE_TEXT_CODE:tankReplyMischung=false;tanklisteTextAction();break;
					case ACTION_TANKLISTE_MISCHUNG_TEXT_CODE:tankReplyMischung=true;tanklisteTextAction();break;
					case ACTION_TANKLISTE_PLAN_CODE:tankReplyMischung=false;tanklistePlanAction();break;
					case ACTION_TANKLISTE_MISCHUNG_PLAN_CODE: tankReplyMischung=true;tanklisteMischungPlanAction();break;
					case ACTION_TANKLISTE_MISCHUNG_NUMMER_CODE: tanklisteMischungNummerAction();break;
					case ACTION_MISCHUNG_UEBERGANG_CODE:mischungUebergangAction();break;
					case ACTION_CLEAR_COMMENT_CODE:txtComment.setText("");break;
					default :
						break;
				}
				break;
			case MessageItem.MSG_TANKLISTE_REPLY :
				tanklisteReply((tankItem) msg.getData());
				break;
			case MessageItem.MSG_REPLY_LOSNMMERVORLAGE_DECKEL:
				txtDeckel.setText((String)msg.getData());
				break;
			case MessageItem.MSG_REPLY_LOSNMMERVORLAGE_FLASCHEN:
				txtFlaschen.setText((String)msg.getData());
				break;
			case MessageItem.MSG_SHOW_ABGANG :
				origin = msg.getOrigin();
				final int rezeptur =  msg.getCode();
				if(rezeptur != 0) {
					bi = rz.getDatabase().getBuchungen().dbGetBuchung(0,rezeptur);
					bi.setTyp(DBBuchung.TYP_ABGANG);
					bi.setCode(DBBuchung.CODE_ENTNAHME);
					//rz.getDatabase().getEinheiten().setGrundeinheitenCmb(cmbAbgangsEinheit,bi.getRezeptur().getBasiseinheit());
					rz.getDatabase().getEinheiten().setGrundeinheitenCmb(cmbAbgangsEinheit,rz.getDatabase().getEinheiten().getLiterItem().getID());

				}
				break;
			case MessageItem.MSG_PALETTENRECHNER_REPLY:
				double l = 100.0;
				try {
					l = ((PalettenReturnItem)msg.getData()).getLiter();
					this.txtComment.setText(((PalettenReturnItem)msg.getData()).getComment());
				}catch(final Exception e) {
					l = 100.0;
				}
				txtAbgang.setValue(l);
				for(int i = 0; i < cmbAbgangsEinheit.getModel().getSize();i++) {
					if(((EinheitsItem)cmbAbgangsEinheit.getModel().getElementAt(i)).getTyp() == RzPro.EINHEIT_LITER) {
						cmbAbgangsEinheit.setSelectedIndex(i);
						break;
					}
				}
				rechnen(RECHNEN_NEU_LITER);
				break;
			case MessageItem.MSG_PROPAGATE_PROBEN:
				lose = rz.getDatabase().getBuchungen().getLosNummerListe(bi.getLosnummer_reihe(),bi.getRezeptur_id(), txtAbgang.getValue(),(EinheitsItem)cmbAbgangsEinheit.getSelectedItem());
				if(tblLose != null) {
					((AbstractTableModel)tblLose.getModel()).fireTableDataChanged();
				}
				rechnen(RECHNEN_NEU_LITER);
				break;

			case MessageItem.MSG_ZUTATEN_DIALOG_REPLY :
				returnRezepturName=((ZutatenSuchItem) msg.getData()).getName();
				returnRezepturID=((ZutatenSuchItem) msg.getData()).getID();
				lblUmbuchen.setText("<html>" + returnRezepturName.trim() + "</html>");
				if(bi!=null) {
					if((bi.getRezeptur_id()==returnRezepturID) || (returnRezepturID ==0) || (returnRezepturID == bi.getRezeptur_id())) {
						btUmbuchen.setEnabled(false);
					}else {
						btUmbuchen.setEnabled(true);
					}
				}
				break;
			case MessageItem.MSG_EINGABEDIALOG_REPLY:
				modifyTankReply(msg);
				break;
			default:
				break;
		}

	}
	@Override
	public void createActions(){
		actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT, KeyEvent.VK_F5 ,InputEvent.SHIFT_DOWN_MASK));
		actionList.put(String.valueOf(ACTION_SAVE_CODE),new AuswahlAction(rz,this,ACTION_SAVE_CODE,ACTION_SAVE_TEXT, KeyEvent.VK_S ,InputEvent.CTRL_DOWN_MASK));
		actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT, KeyEvent.VK_F1,0));
		actionList.put(String.valueOf(ACTION_ABBRECHEN_CODE),new AuswahlAction(rz,this,ACTION_ABBRECHEN_CODE,ACTION_ABBRECHEN_TEXT, KeyEvent.VK_ESCAPE,0));
		actionList.put(String.valueOf(ACTION_PALETTEN_CODE),new AuswahlAction(rz,this,ACTION_PALETTEN_CODE,ACTION_PALETTEN_TEXT, 0,0));
		actionList.put(String.valueOf(ACTION_PALETTENRECHNER_CODE),new AuswahlAction(rz,this,ACTION_PALETTENRECHNER_CODE,ACTION_PALETTENRECHNER_TEXT, 0,0));
		actionList.put(String.valueOf(ACTION_FLASCHEN_LOSNUMMER_CODE),new AuswahlAction(rz,this,ACTION_FLASCHEN_LOSNUMMER_CODE,ACTION_FLASCHEN_LOSNUMMER_TEXT, 0,0));
		actionList.put(String.valueOf(ACTION_DECKEL_LOSNUMMER_CODE),new AuswahlAction(rz,this,ACTION_DECKEL_LOSNUMMER_CODE,ACTION_DECKEL_LOSNUMMER_TEXT, 0,0));
		actionList.put(String.valueOf(ACTION_PROBE_CODE),new AuswahlAction(rz,this,ACTION_PROBE_CODE,ACTION_PROBE_TEXT, 0,0));
		actionList.put(String.valueOf(ACTION_KALENDER_CODE),new AuswahlAction(rz,this,ACTION_KALENDER_CODE,ACTION_KALENDER_TEXT, 0,0));
		actionList.put(String.valueOf(ACTION_UMBUCHEN_CODE),new AuswahlAction(rz,this,ACTION_UMBUCHEN_CODE,ACTION_UMBUCHEN_TEXT, 0,0));
		actionList.put(String.valueOf(ACTION_TANKLISTE_TEXT_CODE),new AuswahlAction(rz,this,ACTION_TANKLISTE_TEXT_CODE,ACTION_TANKLISTE_TEXT_TEXT, 0,0));
		actionList.put(String.valueOf(ACTION_TANKLISTE_PLAN_CODE),new AuswahlAction(rz,this,ACTION_TANKLISTE_PLAN_CODE,ACTION_TANKLISTE_PLAN_TEXT, 0,0));
		actionList.put(String.valueOf(ACTION_TANKLISTE_MISCHUNG_TEXT_CODE),new AuswahlAction(rz,this,ACTION_TANKLISTE_MISCHUNG_TEXT_CODE,ACTION_TANKLISTE_MISCHUNG_TEXT_TEXT, 0,0));
		actionList.put(String.valueOf(ACTION_TANKLISTE_MISCHUNG_PLAN_CODE),new AuswahlAction(rz,this,ACTION_TANKLISTE_MISCHUNG_PLAN_CODE,ACTION_TANKLISTE_MISCHUNG_PLAN_TEXT, 0,0));
		actionList.put(String.valueOf(ACTION_MISCHUNG_UEBERGANG_CODE),new AuswahlAction(rz,this,ACTION_MISCHUNG_UEBERGANG_CODE,ACTION_MISCHUNG_UEBERGANG_TEXT, 0,0));
		actionList.put(String.valueOf(ACTION_CLEAR_COMMENT_CODE),new AuswahlAction(rz,this,ACTION_CLEAR_COMMENT_CODE,ACTION_CLEAR_COMMENT_TEXT, 0,0));
		actionList.put(String.valueOf(ACTION_TANKLISTE_MISCHUNG_NUMMER_CODE),new AuswahlAction(rz,this,ACTION_TANKLISTE_MISCHUNG_NUMMER_CODE,ACTION_TANKLISTE_MISCHUNG_NUMMER_TEXT, 0,0));
	}


	private void showZutatenDialog(String aZutat) {
		int x, y;
		x = (int) (lblUmbuchen.getLocationOnScreen().getX());
		y = (int) (lblUmbuchen.getLocationOnScreen().getY());
		aZutat = aZutat.replaceAll("<html>", "").replaceAll("</html>", "");
		if (zd != null) {
			zd.dispose();
			zd = null;
		}
		zd_dialog_typ = GET_REZEPTUR;
		zd = new ZutatenDialog(this, rz, x, y, aZutat,ZutatenDialog.MODE_REZEPTUREN);
		zd.setVisible(true);
	}


	private void tanklisteReply(final tankItem ti) {
		if(ti != null) {
			if(tankReplyMischung) {
				final int mischung = rz.getDatabase().getMischungen().getTankMischung(ti.getNummer());
				if(mischung >0) {
					final MischungsHeaderItem mi = rz.getDatabase().getMischungen().getMischungHeader(mischung);
					lblMischung.setText(rz.getLocale().getString("abgangsfenster.mischung").replaceAll("%t", ti.getNummer()).replaceAll("%s",mi.getBezeichnung() ));
					mischungUebergangNummer=mischung;
					if(getAction(ACTION_SAVE_CODE).isEnabled()){
						getAction(ACTION_MISCHUNG_UEBERGANG_CODE).setEnabled(true);
					}
				} else {
					mischungUebergangNummer = 0;
					dlgItem.setTyp(DialogControl.HINWEIS_DIALOG);
					dlgItem.setCaption(rz.getLocale().getString("abgang.keine_mischung"));
					dlgItem.setTitel(rz.getLocale().getString("abgang.abgang_keine_mischung"));
					dlgItem.setMessage(rz.getLocale().getString("abgang.keine_mischung_message")
							.replaceAll("%t",ti.getNummer()));
					dlgItem.setIcon("warnung.png");
					dlgItem.setOk(rz.getLocale().getString("string_ok"));
					rz.getDialogFactory().getDialog(dlgItem);
				}
				tankReplyMischung=false;
			}else {
				if(txtTank.getText().trim().equals("")) {
					txtTank.setText(ti.getNummer());
				}else {
					txtTank.setText(txtTank.getText().trim()+","+ti.getNummer());
				}
			}
		}
	}

	private void showTankDialog(final String nummer) {
		int x, y;
		if(btTankText.isFocusOwner()) {
			x = (int) (btTankText.getLocationOnScreen().getX());
			y = (int) (btTankText.getLocationOnScreen().getY());
		} else {
			x = (int) (btTankMischungText.getLocationOnScreen().getX());
			y = (int) (btTankMischungText.getLocationOnScreen().getY());
		}
		if (td != null) {
			td.dispose();
			td = null;
		}
		if(rz.isMain()) {
			td = new TankDialog(this,null,null,null, rz, x, y, nummer);
			td.setVisible(true);
		}
	}

	private void tanklisteTextAction() {
		showTankDialog(txtTank.getText().trim());
	}

	private void tanklistePlanAction() {
		final ArrayList<tankItem> ti = rz.getDatabase().getTank().getTankListeFromTankPattern(txtTank.getText().trim());
		rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_TANKAUSWAHL,false,new MessageItem(MessageItem.MSG_SHOW_TANKAUSWAHL,0,(new tankAuswahlItem(ti,this,null,null,null)),this));
	}

	private void tanklisteMischungNummerAction() {
		final String nummer  = JOptionPane.showInputDialog(this, rz.getLocale().getString("abgang.mischung_nummer_input"));
		if(!nummer.trim().equals("")) {
			try {
				final MischungsItem mischung = rz.getDatabase().getMischungen().getMischung(Integer.parseInt(nummer.trim()));
				if(mischung != null) {
					final MischungsHeaderItem mi = mischung.getHeader();
					if(mi.isActive()) {
						lblMischung.setText(rz.getLocale().getString("abgangsfenster.mischung").replaceAll("%t", mi.getTank()).replaceAll("%s",mi.getBezeichnung() ));
						mischungUebergangNummer=mi.getId();
						if(getAction(ACTION_SAVE_CODE).isEnabled()){
							getAction(ACTION_MISCHUNG_UEBERGANG_CODE).setEnabled(true);
						}
					}else {
						lblMischung.setText("");
						mischungUebergangNummer = 0;
						getAction(ACTION_MISCHUNG_UEBERGANG_CODE).setEnabled(false);
					}
				}else {
					lblMischung.setText("");
					mischungUebergangNummer = 0;
					getAction(ACTION_MISCHUNG_UEBERGANG_CODE).setEnabled(false);
				}
			}catch(final Exception e) {}
		}

	}

	private void tanklisteMischungPlanAction() {
		final ArrayList<tankItem> ti = rz.getDatabase().getTank().getTankListeFromTankPattern(txtTank.getText().trim());
		rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_TANKAUSWAHL,false,new MessageItem(MessageItem.MSG_SHOW_TANKAUSWAHL_MISCHUNG,0,(new tankAuswahlItem(ti,this,null,null,null)),this));
	}



	private void showKalenderAction() {
		rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_KALENDER,true,new MessageItem(MessageItem.MSG_SHOW_KALENDER,0,null,this));
	}

	private void mischungUebergangAction() {
		if(mischungUebergangNummer >0 ) {
			final MischungsItem mi = rz.getDatabase().getMischungen().getMischung(mischungUebergangNummer);
			String cm="";
			if(!txtFlaschen.getText().trim().equals("")) {
				cm += "[" + rz.getLocale().getString("abgang.label_flaschen") + txtFlaschen.getText().trim() +  "]";
			}
			if(!txtDeckel.getText().trim().equals("")) {
				cm += "[" + rz.getLocale().getString("abgang.label_deckel") + txtDeckel.getText().trim() +  "]";
			}
			cm += cm.equals("")?"":" ";
			cm += txtComment.getText().trim();
			cm += rz.getLocale().getString("abgang.mischung_comment").replaceAll("%n", String.valueOf(mi.getHeader().getId())).replaceAll("%t", mi.getHeader().getTank());
			bi.setComment(cm);
			getAltBestand();
			rechnen(RECHNEN_ZUGANG);
			setActions();
			if(getAction(ACTION_SAVE_CODE).isEnabled()) {
				if(txtAbgang.getValue() >0 ) {
					if(!rz.getDatabase().getBuchungen().mischungUebergangTransaction(bi,mischungUebergangNummer)) {

					}  else {
						final AbfrageItem ai = new AbfrageItem();
						ai.setTyp(DBAbfrage.ABFRAGE_TYP_NORMAL);
						ai.setID(bi.getRezeptur_id());
						ai.setAdressListe(new StichwortListe());
						ai.setStichwortListe(new StichwortListe());
						ai.setMuster("^"+bi.getRezeptur().getTitel()+"$");
						if(!rz.isMain() || (rz.getOptionFactory().getOption("confirm.abgang",OptionFactory.CONFIRM_ABGANG) == 1)) {
							dlgItem.setTyp(DialogControl.HINWEIS_DIALOG);
							dlgItem.setCaption(rz.getLocale().getString("abgang.speichern"));
							dlgItem.setTitel(rz.getLocale().getString("abgang.speichern"));
							dlgItem.setMessage(rz.getLocale().getString("abgang.speichern_message")
									.replaceAll("%l", rz.getLocale().formatNumber(bi.getLiter(), OptionFactory.NF_NORMAL))
									.replaceAll("%s", bi.getBezeichnung()));
							dlgItem.setIcon("warnung.png");
							dlgItem.setOk(rz.getLocale().getString("string_ok"));
							rz.getDialogFactory().getDialog(dlgItem);
						}
						try {
							//origin.getMessage(new MessageItem(MessageItem.MSG_ADD_QUERY_ZUGANG,0,ai,this));
							rz.getFensterFactory().getFensterListe().propagateBestand(this,bi.getRezeptur_id());
							rz.getFensterFactory().getFensterListe().propagateBestand(this,returnRezepturID);
						} catch (final NullPointerException e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_WARN,"Abgangsfenster:speichernAction",e.getLocalizedMessage());
						}
						closeWindow();
					}
				}
			}else {

			}
		}
	}

	private void discardAction(final int row) {
		if((lose != null) && (row >= 0) && (row < lose.size())) {
			final LosnummerItem li = lose.get(row);
			if(li != null) {
				final BuchungsItem bi1 = rz.getDatabase().getBuchungen().getEinzelBuchung(li.getZugangsBuchung());
				if(bi1 != null) {
					final String hinweis = bi1.getComment() +" ";
					final DialogItem di  = new DialogItem(
							DialogControl.EINGABE_DIALOG,
							"",0.0,
							rz.getLocale().getString("auswahl.hinweis_label"),
							rz.getLocale().getString("auswahl.tank_caption")
							.replaceAll("%s",bi1.getBezeichnung())
							.replaceAll("%l", bi1.getLosnummer()),
							hinweis,
							"frage.png",
							rz.getLocale().getString("string_ok"),
							rz.getLocale().getString("string_abbrechen"),
							null
							);
					final EingabeDialog edi = new EingabeDialog(rz,di,true,true);
					edi.setTankActive(true);
					edi.setOrigin(this);
					edi.setBuchungsItem(bi1.getId());
					edi.setModal(false);
					edi.showDialog();
				}
			}
		}
	}

	private void modifyTankReply(final MessageItem msg) {
		final String content = (String)msg.getData();
		if((content != null) && (msg.getCode() > 0)) {
			rz.getDatabase().getBuchungen().setComment(content,msg.getCode());
			rz.getFensterFactory().getFensterListe().propagateBestand(this,rz.getDatabase().getBuchungen().getEinzelBuchung(msg.getCode()).getRezeptur_id());
			rechnen(RECHNEN_NEU_LITER);
		}
	}

	private void losnummerAction(final boolean what){
		//true=flaschen
		//false=deckel
		if(what) {
			rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_LOSNUMMER_VORLAGE,true,new MessageItem(MessageItem.MSG_SHOW_LOSNUMMERVORLAGE_FLASCHEN, 0,null,this));
		}else {
			rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_LOSNUMMER_VORLAGE,true,new MessageItem(MessageItem.MSG_SHOW_LOSNUMMERVORLAGE_DECKEL, 0,null,this));
		}

	}
	@Override
	public void openWindow(){
		if((bi != null) && (bi.getRezeptur() != null)) {
			fromItem();
			setVisible(true);
			toFront();
			txtAbgang.requestFocus();
		} else {
			closeWindow();
		}
	}

	@Override
	public void closeWindow(){
		rz.getFensterFactory().getFensterListe().disposeFrame(this);
	}

	private void fromItem() {
		lblRezeptur.setText(rz.getLocale().getString("zugang.label_rezeptur")
				.replaceAll("%s" ,bi.getBezeichnung())
				.replaceAll("%n",rz.getLocale().formatNumber(bi.getStaerke(),OptionFactory.NF_STAERKE)));
		txtComment.setText(bi.getComment().trim());
		lblUmbuchen.setText("<html>" + bi.getRezeptur().getTitel()+ "</html>");
		returnRezepturName=bi.getRezeptur().getTitel();
		returnRezepturID=bi.getRezeptur_id();
		getAltBestand();
		rechnen(RECHNEN_ZUGANG);
	}

	private void getAltBestand() {
		bi.getRezeptur().setBestand(rz.getDatabase().getRezeptur().getBestandsSaldo(bi.getRezeptur_id()).getBestand());
		txtAltLiter.setValue(rz.getDatabase().getEinheiten().convert(
				bi.getRezeptur().getBestand(),
				bi.getRezeptur().getStaerke(),
				bi.getRezeptur().getLitergewicht(),
				rz.getDatabase().getEinheiten().getGrundeinheit(bi.getRezeptur().getBestandseinheit()),
				rz.getDatabase().getEinheiten().getEinheit("liter")
				));
		txtAltKg.setValue(rz.getDatabase().getEinheiten().convert(
				bi.getRezeptur().getBestand(),
				bi.getRezeptur().getStaerke(),
				bi.getRezeptur().getLitergewicht(),
				rz.getDatabase().getEinheiten().getGrundeinheit(bi.getRezeptur().getBestandseinheit()),
				rz.getDatabase().getEinheiten().getEinheit("kg")
				));
		txtAltLa.setValue(rz.getDatabase().getEinheiten().convert(
				bi.getRezeptur().getBestand(),
				bi.getRezeptur().getStaerke(),
				bi.getRezeptur().getLitergewicht(),
				rz.getDatabase().getEinheiten().getGrundeinheit(bi.getRezeptur().getBestandseinheit()),
				rz.getDatabase().getEinheiten().getEinheit("la")
				));
	}

	private void rechnen(final int mode) {
		double neuLiter=0;
		double neuKg=0;
		double neuLA=0;
		final EinheitsItem source = getSourceFromCmb(mode);
		switch(mode) {
			case RECHNEN_ZUGANG:
				switch( source.getTyp()) {
					case RzPro.EINHEIT_LITER:
						neuLiter = txtAltLiter.getValue() - txtAbgang.getValue();
						neuKg  = rz.getDatabase().getEinheiten().convert(
								neuLiter,
								bi.getRezeptur().getStaerke(),
								bi.getRezeptur().getLitergewicht(),
								source,
								rz.getDatabase().getEinheiten().getEinheit("kg")
								);
						neuLA   = rz.getDatabase().getEinheiten().convert(
								neuLiter,
								bi.getRezeptur().getStaerke(),
								bi.getRezeptur().getLitergewicht(),
								source,
								rz.getDatabase().getEinheiten().getEinheit("la")
								);
						break;
					case RzPro.EINHEIT_KG:
						neuKg = txtAltKg.getValue() - txtAbgang.getValue();
						neuLiter  = rz.getDatabase().getEinheiten().convert(
								neuKg,
								bi.getRezeptur().getStaerke(),
								bi.getRezeptur().getLitergewicht(),
								source,
								rz.getDatabase().getEinheiten().getEinheit("liter")
								);
						neuLA   = rz.getDatabase().getEinheiten().convert(
								neuKg,
								bi.getRezeptur().getStaerke(),
								bi.getRezeptur().getLitergewicht(),
								source,
								rz.getDatabase().getEinheiten().getEinheit("la")
								);
						break;
					case RzPro.EINHEIT_LA:
						neuLA = txtAltLa.getValue() - txtAbgang.getValue();
						neuLiter  = rz.getDatabase().getEinheiten().convert(
								neuLA,
								bi.getRezeptur().getStaerke(),
								bi.getRezeptur().getLitergewicht(),
								source,
								rz.getDatabase().getEinheiten().getEinheit("liter")
								);
						neuKg   = rz.getDatabase().getEinheiten().convert(
								neuLA,
								bi.getRezeptur().getStaerke(),
								bi.getRezeptur().getLitergewicht(),
								source,
								rz.getDatabase().getEinheiten().getEinheit("kg")
								);
						break;
				}
				break;
			case RECHNEN_NEU_LITER:
				neuLiter = txtNeuLiter.getValue();

				txtAbgang.setValue( rz.getDatabase().getEinheiten().convert(
						txtAltLiter.getValue() - neuLiter,
						bi.getRezeptur().getStaerke(),
						bi.getRezeptur().getLitergewicht(),
						source,
						(EinheitsItem)cmbAbgangsEinheit.getSelectedItem()
						));

				neuKg  = rz.getDatabase().getEinheiten().convert(
						neuLiter,
						bi.getRezeptur().getStaerke(),
						bi.getRezeptur().getLitergewicht(),
						source,
						rz.getDatabase().getEinheiten().getEinheit("kg")
						);
				neuLA   = rz.getDatabase().getEinheiten().convert(
						neuLiter,
						bi.getRezeptur().getStaerke(),
						bi.getRezeptur().getLitergewicht(),
						source,
						rz.getDatabase().getEinheiten().getEinheit("la")
						);
				break;
			case RECHNEN_NEU_KG:
				neuKg = txtNeuKg.getValue();

				txtAbgang.setValue( rz.getDatabase().getEinheiten().convert(
						txtAltKg.getValue() - neuKg,
						bi.getRezeptur().getStaerke(),
						bi.getRezeptur().getLitergewicht(),
						source,
						(EinheitsItem)cmbAbgangsEinheit.getSelectedItem()
						));

				neuLiter  = rz.getDatabase().getEinheiten().convert(
						neuKg,
						bi.getRezeptur().getStaerke(),
						bi.getRezeptur().getLitergewicht(),
						source,
						rz.getDatabase().getEinheiten().getEinheit("liter")
						);
				neuLA   = rz.getDatabase().getEinheiten().convert(
						neuKg,
						bi.getRezeptur().getStaerke(),
						bi.getRezeptur().getLitergewicht(),
						source,
						rz.getDatabase().getEinheiten().getEinheit("la")
						);
				break;
			case RECHNEN_NEU_LA:
				neuLA = txtNeuLa.getValue();

				txtAbgang.setValue( rz.getDatabase().getEinheiten().convert(
						txtAltLa.getValue() - neuLA,
						bi.getRezeptur().getStaerke(),
						bi.getRezeptur().getLitergewicht(),
						source,
						(EinheitsItem)cmbAbgangsEinheit.getSelectedItem()
						));

				neuLiter  = rz.getDatabase().getEinheiten().convert(
						neuLA,
						bi.getRezeptur().getStaerke(),
						bi.getRezeptur().getLitergewicht(),
						source,
						rz.getDatabase().getEinheiten().getEinheit("liter")
						);
				neuKg   = rz.getDatabase().getEinheiten().convert(
						neuLA,
						bi.getRezeptur().getStaerke(),
						bi.getRezeptur().getLitergewicht(),
						source,
						rz.getDatabase().getEinheiten().getEinheit("kg")
						);
				break;

		}

		txtNeuLiter.setValue(neuLiter);
		txtNeuKg.setValue(neuKg);
		txtNeuLa.setValue(neuLA);
		bi.setLiter(neuLiter -txtAltLiter.getValue());
		bi.setKg(neuKg - txtAltKg.getValue());
		bi.setLa(neuLA - txtAltLa.getValue());
		bi.setRest_liter(bi.getLiter());
		bi.setRest_kg(bi.getKg());
		bi.setRest_la(bi.getLa());
		lose = rz.getDatabase().getBuchungen().getLosNummerListe(bi.getLosnummer_reihe(),bi.getRezeptur_id(), txtAbgang.getValue(),(EinheitsItem)cmbAbgangsEinheit.getSelectedItem());
		((AbstractTableModel)tblLose.getModel()).fireTableDataChanged();
		String neueLosnummer="";
		for (final LosnummerItem element : lose) {
			neueLosnummer += element.getLosnummer() + "," ;
		}
		if (neueLosnummer.endsWith(",")) {
			neueLosnummer = neueLosnummer.substring(1,neueLosnummer.length()-1);
		}
		setClipBoard();
		setActions();
	}

	private void setActions() {
		boolean saveAbgang = true;
		switch (bi.getEinheit()) {
			case RzPro.EINHEIT_LITER:
				if(txtNeuLiter.getValue() < 0) {
					saveAbgang = false;
				}
				break;
			case RzPro.EINHEIT_KG:
				if(txtNeuKg.getValue() < 0) {
					saveAbgang = false;
				}
				break;
			case RzPro.EINHEIT_LA:
				if(txtNeuLa.getValue() < 0) {
					saveAbgang = false;
				}
				break;
		}

		if(txtAbgang.getValue() <=0) {
			saveAbgang = false;
		}

		if(!saveAbgang) {
			txtNeuLiter.setBackground(red);
			txtNeuKg.setBackground(red);
			txtNeuLa.setBackground(red);
			txtNeuLiter.setForeground(white);
			txtNeuKg.setForeground(white);
			txtNeuLa.setForeground(white);
		} else {
			txtNeuLiter.setBackground(white);
			txtNeuKg.setBackground(white);
			txtNeuLa.setBackground(white);
			txtNeuLiter.setForeground(black);
			txtNeuKg.setForeground(black);
			txtNeuLa.setForeground(black);
		}
		if(    (txtNeuLiter.getValue() < 0) ||
				(txtNeuKg.getValue() < 0) ||
				(txtNeuLa.getValue() < 0)
				) {
			txtNeuLiter.setBackground(red);
			txtNeuKg.setBackground(red);
			txtNeuLa.setBackground(red);
			txtNeuLiter.setForeground(white);
			txtNeuKg.setForeground(white);
			txtNeuLa.setForeground(white);
			saveAbgang = false;
		}
		if(rz.isMain()) {
			if( !((String)cmbAbgangsArt.getSelectedItem()).equals(rz.getLocale().getString("abgang.typ_korrektur")) && !checkProbeOK()) {
				saveAbgang=false;
				lblWarnung.setText(rz.getLocale().getString("abgangsfenster.label_warnung"));
			} else {
				lblWarnung.setText("");
			}
		} else {
			if(!checkProbeOK()) {
				saveAbgang=false;
				lblWarnung.setText(rz.getLocale().getString("abgangsfenster.label_warnung"));
			} else {
				lblWarnung.setText("");
			}
		}

		getAction(ACTION_UMBUCHEN_CODE).setEnabled(false);
		if(saveAbgang) {
			if(bi!=null) {
				if((bi.getRezeptur_id()==returnRezepturID) || (returnRezepturID ==0)||bi.getRezeptur().getTitel().trim().equals(lblUmbuchen.getText().trim().replaceAll("</html>", "").replaceAll("</html>", ""))) {
					getAction(ACTION_UMBUCHEN_CODE).setEnabled(false);
				}else {
					getAction(ACTION_UMBUCHEN_CODE).setEnabled(true);
				}
			}
			getAction(ACTION_SAVE_CODE).setEnabled(true);
			if(mischungUebergangNummer > 0) {
				getAction(ACTION_MISCHUNG_UEBERGANG_CODE).setEnabled(true);
			}
		} else {
			getAction(ACTION_SAVE_CODE).setEnabled(false);
			getAction(ACTION_MISCHUNG_UEBERGANG_CODE).setEnabled(false);
		}
	}

	private boolean checkProbeOK() {
		boolean ret=true;
		for (final LosnummerItem element : lose) {
			final LosnummerItem li=element;
			if(!li.freigabe()) {
				ret = false;
				break;
			}
		}
		return ret;
	}

	private EinheitsItem getSourceFromCmb(final int mode) {
		EinheitsItem ei = null;
		int index=RzPro.EINHEIT_LITER;
		switch(mode) {
			case RECHNEN_ZUGANG: return (EinheitsItem)cmbAbgangsEinheit.getSelectedItem();
			case RECHNEN_NEU_LITER: index = RzPro.EINHEIT_LITER;break;
			case RECHNEN_NEU_KG: index = RzPro.EINHEIT_KG;break;
			case RECHNEN_NEU_LA: index = RzPro.EINHEIT_LA;break;
		}
		for(int i = 0; i < cmbAbgangsEinheit.getModel().getSize();i++) {
			if(((EinheitsItem)cmbAbgangsEinheit.getModel().getElementAt(i)).getID() == index) {
				ei = (EinheitsItem)cmbAbgangsEinheit.getModel().getElementAt(i);
				break;
			}
		}
		return ei;
	}

	private void umbuchenAction() {
		String cm="";
		if(!txtFlaschen.getText().trim().equals("")) {
			cm += "[" + rz.getLocale().getString("abgang.label_flaschen") + txtFlaschen.getText().trim() +  "]";
		}
		if(!txtDeckel.getText().trim().equals("")) {
			cm += "[" + rz.getLocale().getString("abgang.label_deckel") + txtDeckel.getText().trim() +  "]";
		}
		cm += cm.equals("")?"":" ";
		cm += txtComment.getText().trim();
		bi.setComment(cm);
		getAltBestand();
		rechnen(RECHNEN_ZUGANG);
		setActions();
		if(getAction(ACTION_SAVE_CODE).isEnabled()) {
			if(txtAbgang.getValue() >0 ) {
				if(!rz.getDatabase().getBuchungen().umBuchenTransaction(bi, returnRezepturID)) {

				}  else {
					final AbfrageItem ai = new AbfrageItem();
					ai.setTyp(DBAbfrage.ABFRAGE_TYP_NORMAL);
					ai.setID(bi.getRezeptur_id());
					ai.setAdressListe(new StichwortListe());
					ai.setStichwortListe(new StichwortListe());
					ai.setMuster("^"+bi.getRezeptur().getTitel()+"$");
					if(!rz.isMain() || (rz.getOptionFactory().getOption("confirm.abgang",OptionFactory.CONFIRM_ABGANG) == 1)) {
						dlgItem.setTyp(DialogControl.HINWEIS_DIALOG);
						dlgItem.setCaption(rz.getLocale().getString("abgang.speichern"));
						dlgItem.setTitel(rz.getLocale().getString("abgang.speichern"));
						dlgItem.setMessage(rz.getLocale().getString("abgang.speichern_message")
								.replaceAll("%l", rz.getLocale().formatNumber(bi.getLiter(), OptionFactory.NF_NORMAL))
								.replaceAll("%s", bi.getBezeichnung()));
						dlgItem.setIcon("warnung.png");
						dlgItem.setOk(rz.getLocale().getString("string_ok"));
						rz.getDialogFactory().getDialog(dlgItem);
					}
					try {
						//origin.getMessage(new MessageItem(MessageItem.MSG_ADD_QUERY_ZUGANG,0,ai,this));
						rz.getFensterFactory().getFensterListe().propagateBestand(this,bi.getRezeptur_id());
						rz.getFensterFactory().getFensterListe().propagateBestand(this,returnRezepturID);
					} catch (final NullPointerException e) {
						rz.getLogFactory().logMessage(LogFactory.LOG_WARN,"Abgangsfenster:speichernAction",e.getLocalizedMessage());
					}
					closeWindow();
				}
			}
		}else {

		}
	}


	private void speichernAction() {
		String cm="";
		if(!txtFlaschen.getText().trim().equals("")) {
			cm += "[" + rz.getLocale().getString("abgang.label_flaschen") + txtFlaschen.getText().trim() +  "]";
		}
		if(!txtDeckel.getText().trim().equals("")) {
			cm += "[" + rz.getLocale().getString("abgang.label_deckel") + txtDeckel.getText().trim() +  "]";
		}
		if(!txtTank.getText().trim().equals("")) {
			cm += rz.getOptionFactory().getOption("dbbuchung.tank_sb")+ ":"+ txtTank.getText().trim() + rz.getOptionFactory().getOption("dbbuchung.tank_se") ;
		}
		cm += cm.equals("")?"":" ";
		cm += txtComment.getText().trim();
		bi.setComment(cm);
		getAltBestand();
		rechnen(RECHNEN_ZUGANG);
		setActions();
		if(getAction(ACTION_SAVE_CODE).isEnabled()) {
			if(txtAbgang.getValue() >0 ) {
				if(!rz.getDatabase().getBuchungen().abgangBuchenTransaction(bi)) {

				}  else {
					final AbfrageItem ai = new AbfrageItem();
					ai.setTyp(DBAbfrage.ABFRAGE_TYP_NORMAL);
					ai.setID(bi.getRezeptur_id());
					ai.setAdressListe(new StichwortListe());
					ai.setStichwortListe(new StichwortListe());
					ai.setMuster("^"+bi.getRezeptur().getTitel()+"$");
					if(!rz.isMain() || (rz.getOptionFactory().getOption("confirm.abgang",OptionFactory.CONFIRM_ABGANG) == 1)) {
						dlgItem.setTyp(DialogControl.HINWEIS_DIALOG);
						dlgItem.setCaption(rz.getLocale().getString("abgang.speichern"));
						dlgItem.setTitel(rz.getLocale().getString("abgang.speichern"));
						dlgItem.setMessage(rz.getLocale().getString("abgang.speichern_message")
								.replaceAll("%l", rz.getLocale().formatNumber(bi.getLiter(), OptionFactory.NF_NORMAL))
								.replaceAll("%s", bi.getBezeichnung()));
						dlgItem.setIcon("warnung.png");
						dlgItem.setOk(rz.getLocale().getString("string_ok"));
						rz.getDialogFactory().getDialog(dlgItem);
					}
					try {
						//origin.getMessage(new MessageItem(MessageItem.MSG_ADD_QUERY_ZUGANG,0,ai,this));
						rz.getFensterFactory().getFensterListe().propagateBestand(this,bi.getRezeptur_id());
					} catch (final NullPointerException e) {
						rz.getLogFactory().logMessage(LogFactory.LOG_WARN,"Abgangsfenster:speichernAction",e.getLocalizedMessage());
					}
					closeWindow();
				}
			}
		}else {

		}
	}

	private void setClipBoard() {
		String content = bi.getBezeichnung() + "\n";
		for (final LosnummerItem element : lose) {
			final LosnummerItem li = element;
			content += li.toPlainString();
		}
		final StringSelection s = new StringSelection(content);
		Toolkit.getDefaultToolkit().getSystemClipboard().setContents(s,s);
	}

	private void mengenAction(final int row) {
		if(row == 0) {
			final String losnummer  = lose.get(row).getLosnummer();
			final double liter = rz.getDatabase().getBuchungen().getRestMenge(losnummer, ((EinheitsItem)cmbAbgangsEinheit.getSelectedItem()).getTyp());
			txtAbgang.setValue(liter);
			rechnen(RECHNEN_ZUGANG);
			if(lose.size()>1) {
				lose.remove(1);
			}
		}
	}

	private void probenNeuAction(final int row) {
		if((lose!=null) && (lose.size()>0) && (row >=0)) {
			final LosnummerItem li = lose.get(row);
			//if(!li.isProbeVorhanden()) {
			if(true) {
				if(!li.getLosnummer().trim().equals("")) {
					String cm="";
					if(!txtFlaschen.getText().trim().equals("")) {
						cm += "[" + rz.getLocale().getString("abgang.label_flaschen") + txtFlaschen.getText().trim() +  "]";
					}
					if(!txtDeckel.getText().trim().equals("")) {
						cm += "[" + rz.getLocale().getString("abgang.label_deckel") + txtDeckel.getText().trim() +  "]";
					}
					cm += cm.equals("")?"":" ";
					cm += txtComment.getText().trim();

					li.setComment(cm);
					rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_PROBEN_EINGABE, false, new MessageItem(MessageItem.MSG_SHOW_PROBENEINGABE_ABGANG,0,li,this));
				}
			}
		}
		rechnen(RECHNEN_NEU_LITER);
	}

	private void probenVerzeichnisAction() {
		rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_PROBE,false,new MessageItem(MessageItem.MSG_SHOW_PROBENFENSTER,0,null,this));
	}
	/**
	 * PalettenRechner anzeigen
	 */
	private void palettenRechnerAction() {
		rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_PALETTENRECHNER,false,new MessageItem(MessageItem.MSG_SHOW_PALETTENRECHNER,0,null,this));
	}

	/**
	 * Palettenfenster
	 */
	private void palettenAction() {
		rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_PALETTENLISTE,true,new MessageItem(MessageItem.MSG_SHOW_PALETTENLISTE,0,null,this));
	}


	//Extras-Menü
	private void hideAction(){
		rz.getFensterFactory().getFensterListe().sperren(this);
	}

	//hilfe
	private void hilfeAction(){
		rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"abgang.html",this));
	}

	public void columnAdded(final TableColumnModelEvent arg0) {
	}

	public void columnMarginChanged(final ChangeEvent arg0) {
	}

	public void columnMoved(final TableColumnModelEvent arg0) {
	}

	public void columnRemoved(final TableColumnModelEvent arg0) {
	}

	public void columnSelectionChanged(final ListSelectionEvent arg0) {
	}


	private void settblLoseModel(final JTable t) {
		final LoseColumnModel rcm = new LoseColumnModel();
		final StringRenderer sr = new StringRenderer();
		final IconRenderer ir = new IconRenderer();
		final ButtonRenderer br = new ButtonRenderer();
		final ProbenRenderer pr = new ProbenRenderer();
		TableColumn tc = new TableColumn();
		tc.setHeaderValue(rz.getLocale().getString("abgangsfenster.tableheader_losnummer"));
		tc.setModelIndex(C_LOSNUMMER);
		tc.setCellRenderer(sr);
		rcm.addColumn(tc);
		tc = new TableColumn();
		tc.setHeaderValue(rz.getLocale().getString("abgangsfenster.tableheader_bemerkungen"));
		tc.setModelIndex(C_COMMENT);
		tc.setCellRenderer(sr);
		rcm.addColumn(tc);
		tc = new TableColumn();
		tc.setHeaderValue(rz.getLocale().getString("abgangsfenster.tableheader_rprobe_button"));
		tc.setModelIndex(C_RPROBE_BUTTON);
		tc.setCellRenderer(br);
		rcm.addColumn(tc);
		tc = new TableColumn();
		tc.setHeaderValue(rz.getLocale().getString("abgangsfenster.tableheader_rprobe"));
		tc.setModelIndex(C_RPROBE);
		tc.setCellRenderer(ir);
		rcm.addColumn(tc);
		tc = new TableColumn();
		tc.setHeaderValue(rz.getLocale().getString("abgangsfenster.tableheader_probe"));
		tc.setModelIndex(C_PROBE);
		tc.setCellRenderer(pr);
		rcm.addColumn(tc);
		tc = new TableColumn();
		tc.setHeaderValue(rz.getLocale().getString("abgangsfenster.tableheader_alles"));
		tc.setModelIndex(C_ALLES);
		tc.setCellRenderer(ir);
		rcm.addColumn(tc);
		rcm.addColumnModelListener(this);
		tblLose.setModel(new LoseTableModel());
		tblLose.setColumnModel(rcm);
		tblLose.getTableHeader().setReorderingAllowed(false);
		final TableModelListener l = new TableModelListener() {
			public void tableChanged(final TableModelEvent e) {
				SwingUtilities.invokeLater(new Runnable() {
					public void run() {
						rz.setPreferredRowHeights(tblLose);
					}
				});
			}
		};
		tblLose.getModel().addTableModelListener(l);
	}



	private class LoseColumnModel extends DefaultTableColumnModel{
		public LoseColumnModel() {
			super();
		}
	}

	private  class LoseTableModel extends AbstractTableModel    {

		Icon						probe;
		Icon						rprobe;
		Icon						alles;
		Icon						leer;

		SimpleDateFormat df;


		public LoseTableModel() {
			probe = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/herstellfenster.icon_probe.png"));
			rprobe = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/herstellfenster.icon_rprobe .png"));
			alles = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/herstellfenster.icon_alles .png"));
			leer = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/herstellfenster.icon_leer.png"));

			df = new SimpleDateFormat("dd.MM.yyyy");
		}

		public int getColumnCount() {
			return MAX_COLUMN;
		}
		public int getRowCount() {
			if(lose != null) {
				return lose.size();
			} else {
				return 0;
			}
		}

		public Object getValueAt(final int rowIndex, final int columnIndex) {
			Object ret = null;
			if((rowIndex != -1) && (lose != null)) {
				ret = getContent(lose.get(rowIndex),columnIndex,rowIndex);
			}
			return ret;
		}

		private Object getContent(final LosnummerItem li,final int aColumn,final int row) {
			Object ret = null;
			if(li != null) {
				switch(aColumn){

					case C_COMMENT:
						ret = "<html>" + li.getCommentLink() + "<br></html>";
						break;
					case C_RPROBE:
						ret=li.isProbeErforderlich()?rprobe:leer;
						break;
					case C_LOSNUMMER:
						ret = "<html><center><b><font color=\"blue\">" + li.getLosnummer()+"</font></b><br>"+ rz.getLocale().formatNumber(li.getLiter(),OptionFactory.NF_ONE) + "&nbsp;"+rz.getLocale().getString("string_liter") + "</center></html>";
						break;
					case C_PROBE:
						if(li.isProbeVorhanden()) {
							ret=probe;
						}else {
							ret=leer;
						}
						break;
					case C_ALLES:
						if(row ==0) {
							ret = alles;
						} else {
							ret = null;
						}
						break;
					case C_RPROBE_BUTTON:
						//ret = li.isProbeVorhanden()?"<html></html>":"<html><b>"+rz.getLocale().getString("abgangsfenster.table_button")+"</b></html>";
						ret = "<html><b>"+rz.getLocale().getString("abgangsfenster.table_button")+"</b></html>";
						break;
				}
			}
			return ret;
		}
	}

	/** rendert alle Tabellenzeilen mit String Inhalt
	 *  im wesentlichen heisst das rechts-ausgerichtent
	 * @author lunqual
	 */
	private class ButtonRenderer extends DefaultTableCellRenderer {

		ButtonRenderer() {
			super();
			setOpaque(true);
		}
		public Component getTableCellRendererComponent(final JTable table,
				final Object value, final boolean isSelected, final boolean hasFocus, final int row,
				final int column)
		{
			setText((String)value);
			return this;
		}

	}
	/** rendert alle Tabellenzeilen mit String Inhalt
	 *  im wesentlichen heisst das rechts-ausgerichtent
	 * @author lunqual
	 */
	private class StringRenderer extends DefaultTableCellRenderer {

		Icon warnung;
		StringRenderer() {
			super();
			warnung = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/abgangsfenster.icon_warnung.png"));
			setOpaque(true);
		}
		public Component getTableCellRendererComponent(final JTable table,
				final Object value, final boolean isSelected, final boolean hasFocus, final int row,
				final int column)
		{
			if(value != null) {
				setText((String)value);
				final LosnummerItem li=lose.get(row);
				if(li != null) {
					if (li.isProbeErforderlich() && !li.isProbeVorhanden()) {
						setIcon(warnung);
					}else {
						setIcon(null);
					}
				}
			}
			return this;
		}
	}


	/** rendert alle Tabellenzeilen mit icon Inhalt
	 *  im wesentlichen heisst das rechts-ausgerichtent
	 * @author lunqual
	 */
	private class ProbenRenderer extends DefaultTableCellRenderer {

		ProbenRenderer() {
			super();

			setOpaque(true);
		}
		public Component getTableCellRendererComponent(final JTable table,
				final Object value, final boolean isSelected, final boolean hasFocus, final int row,
				final int column)
		{

			final LosnummerItem li = lose.get(row);
			if(li != null) {
				setText(li.getProbenliste());
			} else {


			}
			setIcon((Icon)value);
			return this;
		}

	}


	/** rendert alle Tabellenzeilen mit icon Inhalt
	 *  im wesentlichen heisst das rechts-ausgerichtent
	 * @author lunqual
	 */
	private class IconRenderer extends DefaultTableCellRenderer {

		IconRenderer() {
			super();

			setOpaque(true);
		}
		public Component getTableCellRendererComponent(final JTable table,
				final Object value, final boolean isSelected, final boolean hasFocus, final int row,
				final int column)
		{
			final LosnummerItem li = lose.get(row);
			if(li!=null) {
				if(li.isProbeErforderlich()) {
					if(column == C_RPROBE_BUTTON) {
						setText("<html>" +
								rz.getLocale().getString("buchungen.probenanzahl").replaceAll("%e",Integer.toString(rz.getDatabase().getRezeptur().getProbenAnzahl(li.getRezeptur())))
								.replaceAll("%n", Integer.toString(rz.getDatabase().getBuchungen().isRProbeVorhanden(li.getLosnummer())))
								);
					}else {
						setText("");
					}
				}
			}
			setIcon((Icon)value);
			return this;
		}
	}


}

