/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package de.lunqual.rzpro.fenster.buchungsfenster;


import java.awt.BorderLayout;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.ArrayList;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.ausgabe.CSVExport;
import de.lunqual.rzpro.database.DBBuchung;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.verbrauch.VerbrauchsListe;
import de.lunqual.rzpro.log.LogFactory;
/**
 *
 * @author  lunqual
 */
public class VerbrauchsFenster extends JRzFrame implements Printable{

    //GUI-Variablen
    private JToolBar tb1;
    private JMenuBar mb;
    private JMenu mnuDatei;
    private JMenu	mnuBearbeiten;
    private JMenu 	mnuFenster;
    private JMenu mnuExtras;
    private JMenu mnuHilfe;
      private  JPanel contentPanel;
      	private JPanel tbPanel;
      	private JPanel centerPanel;
      		private JLabel lblListe;
      		private JScrollPane scrListe;
      			private JEditorPane txtListe;
  		private JPanel buttonPanel;
  	    	private JButton btClose;
  	    	private JPanel rightPanel;
  	    		private JSpinner spJahre;
  	    		private JLabel lblJahre;
  	    		private JCheckBox chkAlignment;
  	    		private JButton btDrucken;
  	    		private JButton btCsvFile;
  	    		private JButton btCsvCopy;
  	    		private JButton btHilfe;

    public static final int         		ACTION_CLOSE_CODE = 1001;
    public static final String     		ACTION_CLOSE_TEXT = "verbrauch.action_close";
    public static final int         		ACTION_HILFE_CODE = 1003;
    public static final String     		ACTION_HILFE_TEXT = "action_hilfe";
    public static final int         		ACTION_HIDE_CODE = 1004;
    public static final String    		ACTION_HIDE_TEXT = "action_hide";
    public static final int         		ACTION_DRUCKEN_CODE = 1005;
    public static final String    		ACTION_DRUCKEN_TEXT = "verbrauch.action_drucken";
    public static final int         		ACTION_ALIGNMENT_CODE = 1006;
    public static final String    		ACTION_ALIGNMENT_TEXT = "verbrauch.action_alignment";
    public static final int         		ACTION_TIME_CODE = 1007;
    public static final String    		ACTION_TIME_TEXT = "verbrauch.action_time";
    public static final int         		ACTION_CSV_FILE_CODE = 1009;
    public static final String      		ACTION_CSV_FILE_TEXT = "csv.export_file";
    public static final int         		ACTION_CSV_COPY_CODE = 1010;
    public static final String      		ACTION_CSV_COPY_TEXT = "csv.export_copy";

    
    
    VerbrauchsListe vl;
    boolean	alignment_lr;
    MessageItem	message;

    /** Creates new form AdressenFenster */
    public VerbrauchsFenster(RzPro r, String name, Object extendedData) {
        super(r,name,extendedData);
        alignment_lr= false;
        createActions();
        createGUIComponents();
        setGUIComponents();
        getMessage((MessageItem)extendedData);
    }

    @Override
	public void createGUIComponents() {
    	// Menü
    	mb = new JMenuBar();
    	mnuDatei = new JMenu();
    	mnuFenster = new JMenu();
    	mnuExtras = new JMenu();
    	mnuHilfe = new JMenu();
    	mnuBearbeiten = new JMenu();
    	mb.add(mnuDatei);
    	mb.add(mnuBearbeiten);
    	mb.add(mnuFenster);
    	mb.add(mnuExtras);
    	mb.add(mnuHilfe);
    	setJMenuBar(mb);
		//Toolbar
		tb1 = new JToolBar();
		tb1.setFloatable(false);
		tb1.setRollover(true);
		//ToolbarPanel
		//contentPanel
		contentPanel = new JPanel(new BorderLayout());
			tbPanel = new JPanel(new BorderLayout());
				tbPanel.add(tb1,BorderLayout.NORTH);
		contentPanel.add(tbPanel,BorderLayout.NORTH);
			centerPanel = new JPanel(new BorderLayout());
				lblListe = new JLabel();
					lblListe.setHorizontalAlignment(SwingConstants.CENTER);
					lblListe.setBorder(BorderFactory.createEtchedBorder());
				centerPanel.add(lblListe,BorderLayout.NORTH);
				scrListe = new JScrollPane();
					txtListe=new JEditorPane();
						txtListe.setContentType("text/html");
						txtListe.setEditable(false);
					scrListe.setViewportView(txtListe);
					scrListe.setBorder(BorderFactory.createEtchedBorder());
				centerPanel.add(scrListe,BorderLayout.CENTER);
			 contentPanel.add(centerPanel,BorderLayout.CENTER);
			 buttonPanel=new JPanel(new BorderLayout());
				btClose = new JButton();
					buttonPanel.add(btClose,BorderLayout.WEST);
				rightPanel=new JPanel(new GridLayout(1,7));
					spJahre = new JSpinner();
					spJahre.addChangeListener(new javax.swing.event.ChangeListener() {
						public void stateChanged(javax.swing.event.ChangeEvent evt) {
							spinnerChanged();
    	            	}
					});
					rightPanel.add(spJahre);
					lblJahre = new JLabel();
					rightPanel.add(lblJahre);
					chkAlignment = new JCheckBox();
					chkAlignment.addActionListener(new ActionListener() {
        	        	public void actionPerformed(ActionEvent evt) {
        	        	    align();
        	        	}
	        	    });
					rightPanel.add(chkAlignment);
					btDrucken = new JButton();
					rightPanel.add(btDrucken);
					btCsvFile = new JButton();
					rightPanel.add(btCsvFile);
					btCsvCopy = new JButton();
					rightPanel.add(btCsvCopy);
					btHilfe = new JButton();
					rightPanel.add(btHilfe,BorderLayout.EAST);
			buttonPanel.add(rightPanel,BorderLayout.EAST);
		contentPanel.add(buttonPanel,BorderLayout.SOUTH);

		//Panels ans Fenster hängen;
		this.getContentPane().setLayout(new BorderLayout());

		this.getContentPane().add(contentPanel, BorderLayout.CENTER);
    }


    @Override
	public void setGUIComponents() {
        setTitle(rz.getVersionString() + " " + rz.getLocale().getString("verbrauch.titel"));

		mnuDatei.setText(rz.getLocale().getString("menu.datei"));
		mnuBearbeiten.setText(rz.getLocale().getString("menu.bearbeiten"));
		mnuExtras.setText(rz.getLocale().getString("menu.extras"));
		mnuFenster.setText(rz.getLocale().getString("menu.fenster"));
		mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));

		mnuDatei.addSeparator();
		mnuDatei.add(getAction(ACTION_DRUCKEN_CODE));
		mnuDatei.addSeparator();
	    mnuDatei.add(getAction(ACTION_CSV_FILE_CODE));
	    mnuDatei.add(getAction(ACTION_CSV_COPY_CODE));
	    mnuDatei.addSeparator();
        mnuDatei.add(getAction(ACTION_CLOSE_CODE));

        mnuExtras.add(getAction(ACTION_ALIGNMENT_CODE));
        mnuExtras.add(getAction(ACTION_HIDE_CODE));
        mnuHilfe.add(getAction(ACTION_HILFE_CODE));

		tb1.add(getAction(ACTION_CLOSE_CODE));
		tb1.addSeparator();
		tb1.add(getAction(ACTION_HIDE_CODE));
		tb1.addSeparator();
		tb1.add(getAction(ACTION_HILFE_CODE));
		tb1.addSeparator();
	    tb1.add(getAction(ACTION_CSV_COPY_CODE));
	    tb1.add(getAction(ACTION_CSV_FILE_CODE));
	    tb1.addSeparator();
		tb1.add(getAction(ACTION_DRUCKEN_CODE));

		lblListe.setText(rz.getLocale().getString("verbrauch.label_liste"));
		btHilfe.setAction(getAction(ACTION_HILFE_CODE));
		btClose.setAction(getAction(ACTION_CLOSE_CODE));
		btDrucken.setAction(getAction(ACTION_DRUCKEN_CODE));
		chkAlignment.setAction(getAction(ACTION_ALIGNMENT_CODE));
		alignment_lr = rz.getOptionFactory().getOption("verbrauch.alignment_lr", 0) == 0?false:true;
		spJahre.setValue((Integer)rz.getOptionFactory().getOption("verbrauch.jahre", DBBuchung.DEFAULT_VERBRAUCH_JAHRE));
		lblJahre.setText(rz.getLocale().getString("verbrauch.jahre"));
		chkAlignment.setSelected(alignment_lr);
	    btCsvFile.setAction(getAction(ACTION_CSV_FILE_CODE));
	    btCsvCopy.setAction(getAction(ACTION_CSV_COPY_CODE));

		
		setResizable(true);
        rz.getFontFactory().setFrameFonts(this);
        pack();
        rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;
    }

    @Override
	public void getMessage(MessageItem msg) {
    	if(msg.getMsgCode() == MessageItem.MSG_SHOW_VERBRAUCH_SINGLE || msg.getMsgCode() == MessageItem.MSG_SHOW_VERBRAUCH_LISTE) {
    		message = msg;
    	}
        switch(msg.getMsgCode()) {
    	case MessageItem.MSG_ACTIONPERFORMED:
            switch(msg.getCode()){
		          case ACTION_HILFE_CODE: hilfeAction();break;
		          case ACTION_HIDE_CODE:hideAction();break;
		          case ACTION_CLOSE_CODE:closeWindow();break;
		          case ACTION_DRUCKEN_CODE:druckenAction();break;
	              case ACTION_CSV_FILE_CODE:csvFileExportAction();break;
	              case ACTION_CSV_COPY_CODE:csvCopyExportAction();break;
		          default :
		              break;
           }
    		break;
         case MessageItem.MSG_SHOW_VERBRAUCH_SINGLE :
        	 final int rezeptur=msg.getCode();
        	 if(rezeptur != 0) {
        		 vl = rz.getDatabase().getBuchungen().getVerbrauch(rezeptur);
        		 vl.rechnen();
                 refreshAction();
        	 }
 	         break;
         case MessageItem.MSG_SHOW_VERBRAUCH_LISTE :
        	 final ArrayList liste = (ArrayList)msg.getData();
        	 if ((liste != null) && !liste.isEmpty()) {
        		 vl = rz.getDatabase().getBuchungen().getVerbrauch(liste);
                 vl.rechnen();
                 refreshAction();
        	 }
	      	break;
        default:
            rz.getLogFactory().logMessage(2, "verbrauchsfenster", "auswahlAction:" + msg.getMsgCode());
            break;
        }

    }

    private void csvFileExportAction() {
    	rz.getCSVExport().VerbrauchCSV(vl, CSVExport.EXPORT_FILE);
    }
    
    private void csvCopyExportAction () {
    	rz.getCSVExport().VerbrauchCSV(vl, CSVExport.EXPORT_COPY);
    }
    
    private void spinnerChanged() {
    	int value = ((Integer)spJahre.getValue()).intValue();
    	if(value < 1) {
    		spJahre.setValue(1);
    		value=1;
    	}
    	rz.getOptionFactory().setOption("verbrauch.jahre",value);
    	rz.getOptionFactory().saveOptions();
    	if(message != null)getMessage(message);
    }
    
    private void refreshAction() {
    	if(vl != null) {
        	rz.getAusgabeFactory().VerbrauchsAusgabe(vl, txtListe,alignment_lr);
    	}
    }
    
    private void align() {
    	alignment_lr = !alignment_lr;
    	rz.getOptionFactory().setOption("verbrauch.alignment_lr", alignment_lr?1:0);
    	int value = ((Integer)spJahre.getValue()).intValue();
    	if(value < 1) {
    		spJahre.setValue(1);
    		value=1;
    	}
    	rz.getOptionFactory().setOption("verbrauch.jahre",value);
    	rz.getOptionFactory().saveOptions();
    	if(message != null)getMessage(message);
    }    
    
   
    @Override
	public void createActions(){
        actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT, KeyEvent.VK_F5 ,InputEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT, KeyEvent.VK_F1,0));
        actionList.put(String.valueOf(ACTION_CLOSE_CODE),new AuswahlAction(rz,this,ACTION_CLOSE_CODE,ACTION_CLOSE_TEXT, KeyEvent.VK_ESCAPE,0));
        actionList.put(String.valueOf(ACTION_DRUCKEN_CODE),new AuswahlAction(rz,this,ACTION_DRUCKEN_CODE,ACTION_DRUCKEN_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_ALIGNMENT_CODE),new AuswahlAction(rz,this,ACTION_ALIGNMENT_CODE,ACTION_ALIGNMENT_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_ALIGNMENT_CODE),new AuswahlAction(rz,this,ACTION_ALIGNMENT_CODE,ACTION_ALIGNMENT_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_CSV_FILE_CODE),new AuswahlAction(rz,this,ACTION_CSV_FILE_CODE,ACTION_CSV_FILE_TEXT, 0 ,0));
        actionList.put(String.valueOf(ACTION_CSV_COPY_CODE),new AuswahlAction(rz,this,ACTION_CSV_COPY_CODE,ACTION_CSV_COPY_TEXT, 0 ,0));
    }

    @Override
	public void openWindow(){
    	if(vl != null) {
            setVisible(true);
            toFront();
    	}
    }

    @Override
	public void closeWindow(){
        rz.getFensterFactory().getFensterListe().disposeFrame(this);
    }

    //Extras-Menü
    private void hideAction(){
        rz.getFensterFactory().getFensterListe().sperren(this);
    }

    //hilfe
    private void hilfeAction(){
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"verbrauchsfenster.html",this));
    }

    private void druckenAction(){
        final PrinterJob job = PrinterJob.getPrinterJob();
        job.setPrintable(this);
        final PageFormat pf=new PageFormat();
        pf.setOrientation(PageFormat.LANDSCAPE);
        if(job.printDialog()){
        try{
            job.print();
            }
        catch(final PrinterException pe){
                rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "HilfeFenster.druckenAction:" ,  pe.getLocalizedMessage());
            }
        }
    }
    public int print(java.awt.Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if(pageIndex != 0){
            return Printable.NO_SUCH_PAGE;
        }
        else {
            final Graphics2D g2d = (Graphics2D)graphics;
            g2d.translate(pageFormat.getImageableX(),
                          pageFormat.getImageableY());
            final int cw = 	txtListe.getWidth();
            final int ch = txtListe.getHeight();
            final double pw = pageFormat.getImageableWidth();
            final double ph = pageFormat.getImageableHeight();
            if ((cw > pw) || (ch > ph)) {
                final double scaleX = pw / cw;
                final double scaleY = ph / ch;
                final double scale = scaleX < scaleY ? scaleX : scaleY;
                g2d.scale(scale, scale);
            }
        txtListe.printAll(g2d);
        return Printable.PAGE_EXISTS;
        }
    }

}

