
/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package de.lunqual.rzpro.fenster.containerfenster;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import java.util.Date;

import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.SwingConstants;
import javax.swing.Timer;
import javax.swing.border.BevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.ausgabe.ReportFactory;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fenster.JSelectedTextField;
import de.lunqual.rzpro.fenster.dialoge.DialogControl;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.abfrage.AbfrageItem;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.container.ContainerItem;
import de.lunqual.rzpro.items.container.ContainerListe;
import de.lunqual.rzpro.items.container.ContainerOrdnerItem;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.report.ReportItem;
import de.lunqual.rzpro.items.stichworte.StichwortListe;
import de.lunqual.rzpro.options.OptionFactory;
/**
 *
 * @author  administrator
 */
public class Container extends JRzFrame implements TableColumnModelListener{

    // GUI-Variablen
    private JMenuBar mb;
    private JMenu mnuBearbeiten;
    private JMenu mnuDatei;
    private JMenu mnuHilfe;
    private JMenu mnuExtras;
    private JPanel mainPanel;
		private JPanel toolbarPanel;
			private JToolBar tb1;
		private JPanel contentPanel;
			private JPanel leftPanel;
				private JLabel lblTypTitel;
				private JScrollPane scrTyp;
					private JList lstOrdner;
				private JPanel leftButtons;
					private JPanel ordnerButtons;
						private JButton btAlles;
						private JButton btNichts;
						private JButton btOrdnerNeu;
						private JButton btOrdnerBearbeiten;
						private JButton btOrdnerRemove;
						private JButton btRefresh;
						private JLabel lblAdresse;
						private JSelectedTextField txtAdresse;
						private JCheckBox chkOut;
					private JPanel containerButtons;
						private JButton btContainerNeu;
						private JButton btContainerBearbeiten;
						private JButton btContainerRemove;
						private JButton btStatus;
			private JPanel rightPanel;
					private JPanel top;
						private JLabel lblStatus;
						private JScrollPane scrContainer;
						private JTable tblContainer;
					private JPanel bottom;
						private JPanel ausgabeButtons;
							private JComboBox cmbFormulare;
							private JCheckBox chkDuplex;
					    	private JButton btDrucken;

		private JPanel buttonPanel;
			private JButton btHilfe;
			private JButton btCancel;

    // ActionCodes StichwortAuswahl
    public static final int         ACTION_SCHLIESSEN_CODE = 1001;
    public static final String     ACTION_SCHLIESSEN_TEXT = "container.action_close";
    public static final int         ACTION_HILFE_CODE = 1002;
    public static final String     ACTION_HILFE_TEXT = "action_hilfe";
    public static final int         ACTION_HIDE_CODE = 1003;
    public static final String     ACTION_HIDE_TEXT = "action_hide";
    public static final int         ACTION_ORDNER_NEU_CODE = 1004;
    public static final String     ACTION_ORDNER_NEU_TEXT = "container.action_ordner_neu";
    public static final int         ACTION_ORDNER_REMOVE_CODE = 1005;
    public static final String     ACTION_ORDNER_REMOVE_TEXT = "container.action_ordner_remove";
    public static final int         ACTION_ORDNER_BEARBEITEN_CODE = 1006;
    public static final String     ACTION_ORDNER_BEARBEITEN_TEXT = "container.action_ordner_bearbeiten";
    public static final int         ACTION_CONTAINER_NEU_CODE = 1007;
    public static final String     ACTION_CONTAINER_NEU_TEXT = "container.action_container_neu";
    public static final int         ACTION_CONTAINER_REMOVE_CODE = 1008;
    public static final String     ACTION_CONTAINER_REMOVE_TEXT = "container.action_container_remove";
    public static final int         ACTION_CONTAINER_BEARBEITEN_CODE = 1009;
    public static final String     ACTION_CONTAINER_BEARBEITEN_TEXT = "container.action_container_bearbeiten";
    public static final int         ACTION_DRUCKEN_CODE = 1010;
    public static final String     ACTION_DRUCKEN_TEXT = "container.action_drucken";
    public static final int         ACTION_REFRESH_CODE = 1011;
    public static final String     ACTION_REFRESH_TEXT = "action_refresh";
    public static final int         ACTION_ALLES_CODE = 1012;
    public static final String     ACTION_ALLES_TEXT = "container.action_alles";
    public static final int         ACTION_NICHTS_CODE = 1013;
    public static final String     ACTION_NICHTS_TEXT = "container.action_nichts";
    public static final int         ACTION_STATUS_CODE = 1014;
    public static final String     ACTION_STATUS_TEXT = "container.action_status";

    static final int					  	MAX_COLUMN = 8;
    static final int						C_OUT=0;
    static final int					 	C_NUMMER = 1;
    static final int						C_TARA = 2;
    static final int						C_COMMENT = 3;
    static final int						C_ORDNER = 4;
    static final int						C_DATUM=5;
    static final int						C_ADRESSE=6;
    static final int						C_FUELLUNG =7;

    static final int							MONATE=9;

    StichwortListe  	auswahl;
    AbfrageItem     	ai;
    MessageItem 		mi;
    DialogItem 		dlgItem;
    ContainerListe		cl;
    String[] 					monate = {"","","","","","","","","",""};
    Color[]					farben= {
    									new Color(0,255,0),
    									new Color(80,255,80),
    									new Color(160,255,160),
    									new Color(255,255,0),
    									new Color(255,255,80),
    									new Color(255,255,160),
    									new Color(255,160,160),
    									new Color(255,80,80),
    									new Color(255,0,0),
    									new Color(210,210,210)
    };

    Timer					   		ergebnisTimer;

    public Container(RzPro r,String name,Object extendedData) {
        super(r,name,extendedData);
        dlgItem = new DialogItem(0,"",0.0,"","","","","","",null);
        createActions();
        createGUIComponents();
        setGUIComponents();
        cl = new ContainerListe();
 		this.settblContainerModel(tblContainer);
        mi = (MessageItem)extendedData;
        this.getMessage(mi);
        final Date now=new Date();
        SimpleDateFormat df = new SimpleDateFormat("MM");
        int m= Integer.valueOf(df.format(now));
        df = new SimpleDateFormat("yyyy");
        int y = Integer.valueOf(df.format(now));
        final int y1 = y -1;
        for (int i=0;i<=MONATE;i++) {
        	monate[i] =((m<10)?"0":"")+ String.valueOf(m) + "." + y;
        	--m;
        	if(m < 1) {
        		m=12;
        		y = y1;
        	}
        }
        ergebnisTimer = new javax.swing.Timer(rz.getOptionFactory().getOption("list.timeout",RzPro.LIST_TIMEOUT), new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                 ergebnisTimerEvent();
            }
      });
    }

    /** GUI-Komponenten erzeugen
     */
    public void createGUIComponents() {
        mb = new JMenuBar();
		mnuDatei = new JMenu();
			mb.add(mnuDatei);
        mnuBearbeiten = new JMenu();
        	mb.add(mnuBearbeiten);
        mnuExtras = new JMenu();
        	mb.add(mnuExtras);
        mnuHilfe = new JMenu();
        	mb.add(mnuHilfe);
		setJMenuBar(mb);
		mainPanel = new JPanel(new GridLayout(1,2));
		toolbarPanel = new JPanel(new BorderLayout());
			tb1 = new JToolBar();
			tb1.setFloatable(false);
			tb1.setRollover(true);
			toolbarPanel.add(tb1);
			mainPanel.add(toolbarPanel,BorderLayout.NORTH);
				contentPanel = new JPanel(new BorderLayout());
			    //---------------------------------------------------------------------
				leftPanel=new JPanel(new BorderLayout());
					lblTypTitel=new JLabel();
						lblTypTitel.setHorizontalAlignment(SwingConstants.CENTER);
					leftPanel.add(lblTypTitel,BorderLayout.NORTH);
					scrTyp = new JScrollPane();
						lstOrdner = new JList();
							lstOrdner.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
						    lstOrdner.setCellRenderer(new OrdnerListRenderer(rz));
			    			lstOrdner.getSelectionModel().addListSelectionListener(new ListSelectionListener() {
			                    public void valueChanged(ListSelectionEvent e) {
			        			        if (!e.getValueIsAdjusting()) {
											return;
										}
			        			        selectionChanged();
			                        }
				    			});
						scrTyp.setViewportView(lstOrdner);
					leftPanel.add(scrTyp,BorderLayout.CENTER);
					leftButtons=new JPanel(new BorderLayout());
					ordnerButtons = new JPanel(new GridLayout(5,2));
						btAlles = new JButton();
						ordnerButtons.add(btAlles);
						btNichts = new JButton();
						ordnerButtons.add(btNichts);
						btOrdnerNeu = new JButton();
						ordnerButtons.add(btOrdnerNeu);
						btOrdnerBearbeiten = new JButton();
						ordnerButtons.add(btOrdnerBearbeiten);
						btOrdnerRemove = new JButton();
						ordnerButtons.add(btOrdnerRemove);
						btRefresh = new JButton();
						ordnerButtons.add(btRefresh);
						lblAdresse = new JLabel();
							lblAdresse.setHorizontalAlignment(SwingConstants.TRAILING);
						ordnerButtons.add(lblAdresse);
						txtAdresse = new JSelectedTextField();
						txtAdresse.addKeyListener(new java.awt.event.KeyAdapter() {
				            public void keyReleased(java.awt.event.KeyEvent evt) {
				                    if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
				                    	refreshAction();
				                }
				            }
				        });
						ordnerButtons.add(txtAdresse);
						chkOut = new JCheckBox();
						chkOut.addActionListener(new ActionListener() {
		    	        	public void actionPerformed(ActionEvent evt) {
		    	        		refreshAction();
		    	        	}
		                });
						ordnerButtons.add(chkOut);
						ordnerButtons.setBorder(BorderFactory.createBevelBorder(BevelBorder.RAISED));
					leftButtons.add(ordnerButtons,BorderLayout.NORTH);

					leftPanel.add(leftButtons,BorderLayout.SOUTH);
				contentPanel.add(leftPanel,BorderLayout.WEST);
			rightPanel = new JPanel(new BorderLayout());
						top = new JPanel(new BorderLayout());
							lblStatus=new JLabel();
								lblStatus.setHorizontalAlignment(SwingConstants.CENTER);
							top.add(lblStatus,BorderLayout.NORTH);
							scrContainer = new JScrollPane();
								tblContainer = new JTable();
								tblContainer.setName("containerfenster.spalten");
						        JTableHeader header = tblContainer.getTableHeader();
						        header.addMouseListener(new ColumnHeaderListener());
					    		tblContainer.setShowGrid(true);
				    			tblContainer.setGridColor(rz.getOptionFactory().getColor(OptionFactory.COLOR_VISIBLE_GRID));
				    			tblContainer.getSelectionModel().addListSelectionListener(new ListSelectionListener() {
				                    public void valueChanged(ListSelectionEvent e) {
				        			        if (e.getValueIsAdjusting()) {
												return;
											}
					        			    if(ergebnisTimer.isRunning()) {
					        			            ergebnisTimer.stop();
					        			        }
				        			        ergebnisTimer.start();
				                        }
					    			});

								scrContainer.setViewportView(tblContainer);
							top.add(scrContainer,BorderLayout.CENTER);
							containerButtons = new JPanel(new GridLayout(2,2));
								btContainerNeu = new JButton();
								containerButtons.add(btContainerNeu);
								btContainerBearbeiten = new JButton();
								containerButtons.add(btContainerBearbeiten);
								btContainerRemove = new JButton();
								containerButtons.add(btContainerRemove);
								btStatus = new JButton();
								containerButtons.add(btStatus);
								containerButtons.setBorder(BorderFactory.createBevelBorder(BevelBorder.RAISED));
							top.add(containerButtons,BorderLayout.SOUTH);
					bottom = new JPanel(new BorderLayout());
					    ausgabeButtons=new JPanel(new GridLayout(1,3));
					    	cmbFormulare = new JComboBox();
							rz.getDatabase().getReport().dbGetReportListeCombo(cmbFormulare,ReportFactory.REPORT_TYPE_CONTAINERLISTE);
			        	    cmbFormulare.addActionListener(new ActionListener() {
			    	        	public void actionPerformed(ActionEvent evt) {
			    	        		if(cmbFormulare.getSelectedIndex() != -1) {
			    	        			rz.getOptionFactory().setOption("report.containerliste",((ReportItem)cmbFormulare.getSelectedItem()).getID());
			    	        		}
			    	        	}
			                });
					    	ausgabeButtons.add(cmbFormulare,BorderLayout.WEST);
					    	chkDuplex= new JCheckBox();
							chkDuplex.setSelected((rz.getOptionFactory().getOption("container.duplex",0) == 1?true:false));
							chkDuplex.addActionListener(new ActionListener() {
					        	public void actionPerformed(ActionEvent evt) {
					        		rz.getOptionFactory().setOption("container.duplex", chkDuplex.isSelected()?1:0);
					        		rz.getOptionFactory().saveOptions();
					        	}
				    	    });
							ausgabeButtons.add(chkDuplex);
					    	btDrucken=new JButton();
					    	ausgabeButtons.add(btDrucken,BorderLayout.CENTER);
					    bottom.add(ausgabeButtons,BorderLayout.SOUTH);
				rightPanel.add(top,BorderLayout.CENTER);
				rightPanel.add(bottom,BorderLayout.SOUTH);
			contentPanel.add(rightPanel,BorderLayout.CENTER);
				//----------------------------------------------------------------------
			buttonPanel= new JPanel(new BorderLayout());
				btHilfe = new JButton();
					buttonPanel.add(btHilfe,BorderLayout.EAST);
				btCancel = new JButton();
					buttonPanel.add(btCancel,BorderLayout.WEST);

			mainPanel.add(contentPanel,BorderLayout.CENTER);
			getContentPane().setLayout(new BorderLayout());
				getContentPane().add(toolbarPanel,BorderLayout.NORTH);
				getContentPane().add(mainPanel,BorderLayout.CENTER);
				getContentPane().add(buttonPanel,BorderLayout.SOUTH);
    }

    /** GUI-Komponenten mit Text usw. versehen...
     */
    public void setGUIComponents() {
        setTitle(rz.getVersionString() + " " + rz.getLocale().getString("container.titel"));
        mnuDatei.setText(rz.getLocale().getString("menu.datei"));
        mnuBearbeiten.setText(rz.getLocale().getString("menu.bearbeiten"));
        mnuExtras.setText(rz.getLocale().getString("menu.extras"));
        mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));

        mnuDatei.add(getAction(ACTION_DRUCKEN_CODE));
        mnuDatei.addSeparator();
        mnuDatei.add(getAction(ACTION_SCHLIESSEN_CODE));

        mnuBearbeiten.add(getAction(ACTION_ALLES_CODE));
        mnuBearbeiten.add(getAction(ACTION_NICHTS_CODE));
        mnuBearbeiten.addSeparator();
        mnuBearbeiten.add(getAction(ACTION_REFRESH_CODE));
        mnuBearbeiten.add(getAction(ACTION_ORDNER_NEU_CODE));
        mnuBearbeiten.add(getAction(ACTION_ORDNER_BEARBEITEN_CODE));
        mnuBearbeiten.add(getAction(ACTION_ORDNER_REMOVE_CODE));
        mnuBearbeiten.addSeparator();
        mnuBearbeiten.add(getAction(ACTION_CONTAINER_NEU_CODE));
        mnuBearbeiten.add(getAction(ACTION_CONTAINER_BEARBEITEN_CODE));
        mnuBearbeiten.add(getAction(ACTION_CONTAINER_REMOVE_CODE));
        mnuBearbeiten.add(getAction(ACTION_STATUS_CODE));

        mnuExtras.add(getAction(ACTION_HIDE_CODE));
        mnuHilfe.add(getAction(ACTION_HILFE_CODE));

        btCancel.setAction(getAction(ACTION_SCHLIESSEN_CODE));

        btHilfe.setAction(getAction(ACTION_HILFE_CODE));

        tb1.addSeparator();
        tb1.add(getAction(ACTION_SCHLIESSEN_CODE));
        tb1.addSeparator();
        tb1.add(getAction(ACTION_ALLES_CODE));
        tb1.add(getAction(ACTION_NICHTS_CODE));
        tb1.addSeparator();
        tb1.add(getAction(ACTION_ORDNER_NEU_CODE));
        tb1.add(getAction(ACTION_ORDNER_BEARBEITEN_CODE));
        tb1.add(getAction(ACTION_ORDNER_REMOVE_CODE));
        tb1.addSeparator();
        tb1.add(getAction(ACTION_CONTAINER_NEU_CODE));
        tb1.add(getAction(ACTION_CONTAINER_BEARBEITEN_CODE));
        tb1.add(getAction(ACTION_CONTAINER_REMOVE_CODE));
        tb1.add(getAction(ACTION_STATUS_CODE));
        tb1.addSeparator();
        tb1.add(getAction(ACTION_REFRESH_CODE));
        tb1.addSeparator();
        tb1.add(getAction(ACTION_HIDE_CODE));
        tb1.addSeparator();
        tb1.add(getAction(ACTION_HILFE_CODE));

        lblTypTitel.setText(rz.getLocale().getString("container.label_ordner_titel"));
        lblStatus.setText(rz.getLocale().getString("container.label_container_titel"));
        lblAdresse.setText(rz.getLocale().getString("container.label_adresse"));
        chkOut.setText(rz.getLocale().getString("container.label_out"));
        chkDuplex.setText(rz.getLocale().getString("container.duplex"));
        
        btOrdnerNeu.setAction(getAction(ACTION_ORDNER_NEU_CODE));
        btOrdnerBearbeiten.setAction(getAction(ACTION_ORDNER_BEARBEITEN_CODE));
        btOrdnerRemove.setAction(getAction(ACTION_ORDNER_REMOVE_CODE));
        btContainerNeu.setAction(getAction(ACTION_CONTAINER_NEU_CODE));
        btContainerBearbeiten.setAction(getAction(ACTION_CONTAINER_BEARBEITEN_CODE));
        btContainerRemove.setAction(getAction(ACTION_CONTAINER_REMOVE_CODE));
        btStatus.setAction(getAction(ACTION_STATUS_CODE));
        btDrucken.setAction(getAction(ACTION_DRUCKEN_CODE));
        btRefresh.setAction(getAction(ACTION_REFRESH_CODE));
        btAlles.setAction(getAction(ACTION_ALLES_CODE));
        btNichts.setAction(getAction(ACTION_NICHTS_CODE));

        getAction(ACTION_CONTAINER_BEARBEITEN_CODE).setEnabled(false);
        getAction(ACTION_CONTAINER_REMOVE_CODE).setEnabled(false);
        getAction(ACTION_STATUS_CODE).setEnabled(false);

        setResizable(true);
        rz.getFontFactory().setFrameFonts(this);
        pack();
        rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;
    }


    public void createActions(){
        actionList.put(String.valueOf(ACTION_SCHLIESSEN_CODE),new AuswahlAction(rz,this,ACTION_SCHLIESSEN_CODE,ACTION_SCHLIESSEN_TEXT,KeyEvent.VK_ESCAPE ,0));
        actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT, KeyEvent.VK_F1 ,0));
        actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT,KeyEvent.VK_F5 ,InputEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_ORDNER_NEU_CODE),new AuswahlAction(rz,this,ACTION_ORDNER_NEU_CODE,ACTION_ORDNER_NEU_TEXT,KeyEvent.VK_F6 ,InputEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_CONTAINER_NEU_CODE),new AuswahlAction(rz,this,ACTION_CONTAINER_NEU_CODE,ACTION_CONTAINER_NEU_TEXT,KeyEvent.VK_F6 ,0));
        actionList.put(String.valueOf(ACTION_ORDNER_BEARBEITEN_CODE),new AuswahlAction(rz,this,ACTION_ORDNER_BEARBEITEN_CODE,ACTION_ORDNER_BEARBEITEN_TEXT,KeyEvent.VK_F2 ,InputEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_CONTAINER_BEARBEITEN_CODE),new AuswahlAction(rz,this,ACTION_CONTAINER_BEARBEITEN_CODE,ACTION_CONTAINER_BEARBEITEN_TEXT,KeyEvent.VK_F2 ,0));
        actionList.put(String.valueOf(ACTION_ORDNER_REMOVE_CODE),new AuswahlAction(rz,this,ACTION_ORDNER_REMOVE_CODE,ACTION_ORDNER_REMOVE_TEXT,KeyEvent.VK_DELETE ,InputEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_CONTAINER_REMOVE_CODE),new AuswahlAction(rz,this,ACTION_CONTAINER_REMOVE_CODE,ACTION_CONTAINER_REMOVE_TEXT,KeyEvent.VK_DELETE ,0));
        actionList.put(String.valueOf(ACTION_DRUCKEN_CODE),new AuswahlAction(rz,this,ACTION_DRUCKEN_CODE,ACTION_DRUCKEN_TEXT,KeyEvent.VK_D ,InputEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_REFRESH_CODE),new AuswahlAction(rz,this,ACTION_REFRESH_CODE,ACTION_REFRESH_TEXT,KeyEvent.VK_F5 ,0));
        actionList.put(String.valueOf(ACTION_ALLES_CODE),new AuswahlAction(rz,this,ACTION_ALLES_CODE,ACTION_ALLES_TEXT,KeyEvent.VK_A ,InputEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_NICHTS_CODE),new AuswahlAction(rz,this,ACTION_NICHTS_CODE,ACTION_NICHTS_TEXT,KeyEvent.VK_N ,InputEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_STATUS_CODE),new AuswahlAction(rz,this,ACTION_STATUS_CODE,ACTION_STATUS_TEXT,0,0));

    }
    /** auf Messages reagieren
     *
     */
    public void getMessage(MessageItem msg) {
        switch (msg.getMsgCode()) {
        	case MessageItem.MSG_ACTIONPERFORMED:
                switch(msg.getCode()){
                case ACTION_SCHLIESSEN_CODE:closeWindow();break;
                case ACTION_HILFE_CODE : hilfeAction();break;
                case ACTION_HIDE_CODE : hideAction();break;
                case ACTION_REFRESH_CODE:refreshAction();break;
                case ACTION_ORDNER_REMOVE_CODE: ordnerRemoveAction();break;
                case ACTION_CONTAINER_BEARBEITEN_CODE:containerBearbeitenAction();break;
                case ACTION_DRUCKEN_CODE:druckenAction();break;
                case ACTION_STATUS_CODE:statusAction();break;
                case ACTION_ALLES_CODE:
                    if(lstOrdner.getModel().getSize() > 0) {
                        lstOrdner.clearSelection();
                        lstOrdner.setSelectionInterval(0, lstOrdner.getModel().getSize()-1);
                        selectionChanged();
                    }
                    break;
                 case ACTION_NICHTS_CODE:
                     lstOrdner.clearSelection();
                     selectionChanged();
                     break;
                 case ACTION_CONTAINER_NEU_CODE:containerNeuAction();break;
                 case ACTION_CONTAINER_REMOVE_CODE:deleteContainerAction();break;
                 case ACTION_ORDNER_NEU_CODE:ordnerNeuAction();break;
                 case ACTION_ORDNER_BEARBEITEN_CODE:ordnerBearbeitenAction();break;
                default:
                    break;
                }
        	    break;
        	case  MessageItem.MSG_EDIT_CONTAINER_REPLY :
        	    final int[] sel= {};
        		lstOrdner.setSelectedIndices(sel);
        		for(int i = 0;i < lstOrdner.getModel().getSize();i++) {
        		    if(((ContainerOrdnerItem)lstOrdner.getModel().getElementAt(i)).getID() == msg.getCode()) {
        		        lstOrdner.setSelectedIndex(i);
        		        break;
        		    }
        		}
        	    selectionChanged();
        	    break;
        	case MessageItem.MSG_SHOW_CONTAINER :
        	    mi = msg;
        		refreshAction();
        	    break;
        }

    }


    public void closeWindow(){
       // this.setVisible(false);
    	rz.getFensterFactory().getFensterListe().disposeFrame(this);
    }


    public void openWindow(){
        if(!isVisible()) {
			setVisible(true);
		}
        toFront();
    }

    private void statusAction() {
        if(tblContainer.getSelectedRow() != -1) {
            final ContainerItem  ci =  cl.getItemOrder(tblContainer.getSelectedRow());
            if(ci != null) {
            	final int sel = this.tblContainer.getSelectedRow();
            	final int value =(ci.getOut()==0)?1:0;
            	rz.getDatabase().getContainer().setStatus(ci.getID(),value);
            	ci.setOut(value);
                ((AbstractTableModel)tblContainer.getModel()).fireTableDataChanged();
                if(sel != -1) {
                	this.tblContainer.setRowSelectionInterval(sel,sel);
                }
                countContainer();
            }
         }
    }

    private void druckenAction() {
        rz.getReportFactory().containerListeReport(cl,this,chkDuplex.isSelected());
    }

    private void ordnerRemoveAction() {
        if(lstOrdner.getSelectedIndices().length == 1) {
            final ContainerOrdnerItem coi = (ContainerOrdnerItem)lstOrdner.getSelectedValue();
            rz.getDatabase().getContainer().deleteContainerOrdner(coi.getID());
            refreshAction();
        } else {
            dlgItem.setTyp(DialogControl.HINWEIS_DIALOG);
            dlgItem.setCaption(rz.getLocale().getString("container.titel"));
            dlgItem.setTitel(rz.getLocale().getString("container.titel"));
            dlgItem.setMessage(rz.getLocale().getString("container.error_select_single_ordner"));
            dlgItem.setIcon("warnung.png");
            dlgItem.setOk(rz.getLocale().getString("string_ok"));
            dlgItem.setOrigin(this);
            rz.getDialogFactory().getDialog(dlgItem);
        }
    }
    private void ordnerNeuAction() {
        String ordner;
    	dlgItem.setTyp(DialogControl.EINGABE_DIALOG);
        dlgItem.setCaption(rz.getLocale().getString("eingabe"));
        dlgItem.setTitel(rz.getLocale().getString("container.question_neuer_ordner"));
        dlgItem.setMessage(rz.getLocale().getString("database.containerordner_neu"));
        dlgItem.setIcon("frage.png");
        dlgItem.setOk(rz.getLocale().getString("string_ok"));
        dlgItem.setCancel(rz.getLocale().getString("string_abbrechen"));
        dlgItem.setOrigin(this);
        rz.getDialogFactory().getDialog(dlgItem);
        ordner = dlgItem.getContent();
        if (ordner != null){
            ordner = ordner.trim();
            if(!ordner.equals("")){
                if(!rz.getDatabase().getContainer().checkOrdnerExists(ordner)) {
                    rz.getDatabase().getContainer().saveOrdner(new ContainerOrdnerItem(0,ordner));
                    refreshAction();
                } else {
                    dlgItem.setTyp(DialogControl.HINWEIS_DIALOG);
                    dlgItem.setCaption(rz.getLocale().getString("container.titel"));
                    dlgItem.setTitel(rz.getLocale().getString("container.titel"));
                    dlgItem.setMessage(rz.getLocale().getString("container.error_ordner_exists").replaceAll("%s",ordner));
                    dlgItem.setIcon("warnung.png");
                    dlgItem.setOk(rz.getLocale().getString("string_ok"));
                    dlgItem.setOrigin(this);
                    rz.getDialogFactory().getDialog(dlgItem);
                }
            }
        }
    }

    private void ordnerBearbeitenAction() {
        if(lstOrdner.getSelectedIndex() != -1){
            final ContainerOrdnerItem ci = (ContainerOrdnerItem)lstOrdner.getSelectedValue();
            String ordner;
        	dlgItem.setTyp(DialogControl.EINGABE_DIALOG);
            dlgItem.setCaption(rz.getLocale().getString("eingabe"));
            dlgItem.setTitel(rz.getLocale().getString("container.question_neuer_ordner"));
            dlgItem.setMessage(ci.getBezeichnung());
            dlgItem.setIcon("frage.png");
            dlgItem.setOk(rz.getLocale().getString("string_ok"));
            dlgItem.setCancel(rz.getLocale().getString("string_abbrechen"));
            dlgItem.setOrigin(this);
            rz.getDialogFactory().getDialog(dlgItem);
            ordner = dlgItem.getContent();
            if (ordner != null){
                ordner = ordner.trim();
                if(!ordner.equals("")){
                    if(!rz.getDatabase().getContainer().checkOrdnerExists(ordner)) {
                        ci.setBezeichnung(ordner);
                        rz.getDatabase().getContainer().saveOrdner(ci);
                        refreshAction();
                    } else {
                        dlgItem.setTyp(DialogControl.HINWEIS_DIALOG);
                        dlgItem.setCaption(rz.getLocale().getString("container.titel"));
                        dlgItem.setTitel(rz.getLocale().getString("container.titel"));
                        dlgItem.setMessage(rz.getLocale().getString("container.error_ordner_exists").replaceAll("%s",ordner));
                        dlgItem.setIcon("warnung.png");
                        dlgItem.setOk(rz.getLocale().getString("string_ok"));
                        dlgItem.setOrigin(this);
                        rz.getDialogFactory().getDialog(dlgItem);
                    }
                }
            }
        }
    }

	private void countContainer() {
		 if (cl.size() > 0) {
	     	int out=0;
	     	for(int i = 0;i < cl.size();i++) {
	     		if(cl.getItemOrder(i).getOut() == 1) {
	     			out++;
	     		}
	     	}
	     	lblStatus.setText(rz.getLocale().getString("container.status")
	     			.replaceAll("%g",String.valueOf(cl.size()))
	     			.replaceAll("%o",String.valueOf(out))
	     			.replaceAll("%i",String.valueOf(cl.size()-out))
	     					);
	     }else {
	     	lblStatus.setText(rz.getLocale().getString("container.status_leer"));
	     }
    }
    /** die Selektion der Ordnerliste wurde geändert;
     */
    private void selectionChanged() {
    	rz.setWaitCursor(this);
        cl = rz.getDatabase().getContainer().getContainerListe(getFilterString(),txtAdresse.getText().trim(),chkOut.isSelected());
        ((AbstractTableModel)tblContainer.getModel()).fireTableDataChanged();
        countContainer();
        rz.setFreeCursor(this);
    }

    private String getFilterString() {
        String filter = "";
        final Object keys[] = lstOrdner.getSelectedValues();
        for (final Object element : keys) {
            filter += "<" + String.valueOf(((ContainerOrdnerItem)element).getID()) + ">|";
        }
        if(filter.endsWith("|")) {
			filter = filter.substring(0,filter.length()-1);
		}
        return filter;
    }

    private void deleteContainerAction() {
        int id;
        if(tblContainer.getSelectedRow() != -1) {
            id = cl.getItemOrder(tblContainer.getSelectedRow()).getID();
            rz.getDatabase().getContainer().deleteContainer(id);
            selectionChanged();
        }
    }

    private void containerNeuAction() {
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_CONTAINER_EINGABE, false, new MessageItem(MessageItem.MSG_EDIT_CONTAINER_REQUEST,0,null,this));
    }

    private void containerBearbeitenAction() {
        int id;
        if(tblContainer.getSelectedRow() != -1) {
            id = cl.getItemOrder(tblContainer.getSelectedRow()).getID();
            rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_CONTAINER_EINGABE, false, new MessageItem(MessageItem.MSG_EDIT_CONTAINER_REQUEST,id,null,this));
        }
     }

    private void refreshAction() {
        final int[] sl = {0};
        lstOrdner.setListData(rz.getDatabase().getContainer().getOrdnerListe().toArray());
        if(lstOrdner.getModel().getSize() > 0) {
            lstOrdner.setSelectedIndices(sl);
        }
        selectionChanged();
    }

    private void ergebnisTimerEvent(){
    	if(tblContainer != null) {
	        if(ergebnisTimer.isRunning()) {
				ergebnisTimer.stop();
			}
	        if (tblContainer.getSelectedRow() != -1){
	        	tblContainer.setRowSelectionInterval(tblContainer.getSelectedRow(),tblContainer.getSelectedRow());
	            getAction(ACTION_CONTAINER_BEARBEITEN_CODE).setEnabled(true);
	            getAction(ACTION_CONTAINER_REMOVE_CODE).setEnabled(true);
	            getAction(ACTION_STATUS_CODE).setEnabled(true);
	        } else {
	            getAction(ACTION_CONTAINER_BEARBEITEN_CODE).setEnabled(false);
	            getAction(ACTION_CONTAINER_REMOVE_CODE).setEnabled(false);
	            getAction(ACTION_STATUS_CODE).setEnabled(false);
	        }
    	}
        countContainer();
    	tblContainer.requestFocus();
    }

    //hilfe
    private void hilfeAction(){
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"container.html",this));
    }

    private void hideAction() {
        rz.getFensterFactory().getFensterListe().sperren(this);
    }
    /*------------------------------------------------------------------------
     * ListenRenderer
     *
     *------------------------------------------------------------------------
     */
    private final class OrdnerListRenderer extends JLabel implements ListCellRenderer{
        RzPro   rz;
        public OrdnerListRenderer(RzPro r){
            rz = r;
            setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list,Object value,int index, boolean isSelected,boolean cellHasFocus){
            this.setFont(rz.getFontFactory().getButtonFont());
            this.setText(((ContainerOrdnerItem)value).getBezeichnung());
            if(isSelected){
                setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_SELECTED));
                setForeground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_FOREGROUND_SELECTED));
                setIcon(rz.getOptionFactory().getIcon(OptionFactory.LIST_CONTAINER_SELECTED_CLASSPATH));
            }else {
                setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_NORMAL));
                setForeground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_FOREGROUND_NORMAL));
                setIcon(rz.getOptionFactory().getIcon(OptionFactory.LIST_CONTAINER_UNSELECTED_CLASSPATH));
            }
            return this;
        }
    }
    private void settblContainerModel(JTable t) {
	    final LagerColumnModel rcm = new LagerColumnModel();
	    final StringRenderer sr = new StringRenderer();
	    final NumericRenderer nr = new NumericRenderer();
	    final IconRenderer ir = new IconRenderer();
	    TableColumn tc;
	    tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("container.tableheader_out"));
	    	tc.setModelIndex(C_OUT);
	    	tc.setCellRenderer(ir);
	    rcm.addColumn(tc);


	    tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("container.tableheader_nummer"));
	    	tc.setModelIndex(C_NUMMER);
	    	tc.setCellRenderer(sr);
	    rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("container.tableheader_tara"));
			tc.setModelIndex(C_TARA);
			tc.setCellRenderer(nr);
		rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("container.tableheader_comment"));
			tc.setModelIndex(C_COMMENT);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
		tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("container.tableheader_ordner"));
			tc.setModelIndex(C_ORDNER);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("container.tableheader_datum"));
			tc.setModelIndex(C_DATUM);
			tc.setCellRenderer(sr);
			rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("container.tableheader_adresse"));
			tc.setModelIndex(C_ADRESSE);
			tc.setCellRenderer(sr);
			rcm.addColumn(tc);
		tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("container.tableheader_fuellung"));
			tc.setModelIndex(C_FUELLUNG);
			tc.setCellRenderer(sr);
			rcm.addColumn(tc);
        rcm.addColumnModelListener(this);
        tblContainer.setModel(new ContainerTableModel());
        tblContainer.setColumnModel(rcm);
        tblContainer.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
        tblContainer.getTableHeader().setReorderingAllowed(false);
	}

	private class LagerColumnModel extends DefaultTableColumnModel{
	    public LagerColumnModel() {
	        super();
	    }

	}

	private  class ContainerTableModel extends AbstractTableModel    {
        	SimpleDateFormat df;
	    	Icon						out;
	    	Icon						in;

	        public ContainerTableModel() {
	            out = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/container_out.png"));
	            in = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/container_in.png"));
	            df = new SimpleDateFormat("dd.MM.yyyy");
	        }

		   public int getColumnCount() {
		       	return MAX_COLUMN;
	        }

	        public int getRowCount() {
	        	if(cl != null) {
					return cl.size();
				} else {
					return 0;
				}
	        }

	        public Object getValueAt(int rowIndex, int columnIndex) {
	            Object ret = null;
	            if((cl != null) && (rowIndex != -1)) {
	            	switch (columnIndex) {
	            		case C_OUT:ret=cl.getItemOrder(rowIndex).getOut()==0?in:out;break;
	            		case C_NUMMER:ret = cl.getItemOrder(rowIndex).getName();break;
	            		case C_TARA: ret = Double.valueOf(cl.getItemOrder(rowIndex).getTara());break;
	            		case C_COMMENT : ret = cl.getItemOrder(rowIndex).getComment();break;
	            		case C_ORDNER : ret = cl.getItemOrder(rowIndex).getOrdnerBezeichnung();break;
	            		case C_ADRESSE:ret=cl.getItemOrder(rowIndex).getLetzteAdresse();break;
	            		case C_FUELLUNG:ret=cl.getItemOrder(rowIndex).getLetzteFuellung();break;
	            		case C_DATUM:
	            			if(cl.getItemOrder(rowIndex).getLetztesDatum() != null) {
	            				ret = df.format(cl.getItemOrder(rowIndex).getLetztesDatum());
	            			}else {
	            				ret="";
	            			}
	            			break;
	            	}
	            }
	            return ret;
	        }

		}

	/** rendert alle Tabellenzeilen mit numerischen Inhalt
	 *  im wesentlichen heisst das rechts-ausgerichtent
	 * @author lunqual
	 */
	private class NumericRenderer extends DefaultTableCellRenderer {

	    NumericRenderer() {
	        super();
	        setOpaque(true);
	    }
	    public Component getTableCellRendererComponent(JTable table,
                Object value, boolean isSelected, boolean hasFocus, int row,
                int column)
	    {
	    	setFont(rz.getFontFactory().getTableFont());
	        if(isSelected) {
	            setBackground( rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_SELECTED));
	        } else {
	            setBackground( rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_NORMAL));
	        }
	        if(value != null) {
	           if(!rz.isZero(rz.getLocale().getNumber(value.toString(), OptionFactory.NF_NORMAL))) {
	               setText(value.toString());
	           } else {
				setText("");
			}
	         } else {
				setText("");
			}
	        setHorizontalAlignment(SwingConstants.TRAILING);
	        return this;
        }
	}
	/** rendert alle Tabellenzeilen mit icon Inhalt
	 *  im wesentlichen heisst das rechts-ausgerichtent
	 * @author lunqual
	 */
	private class IconRenderer extends DefaultTableCellRenderer {

	    IconRenderer() {
	        super();

	        setOpaque(true);
	    }
	    public Component getTableCellRendererComponent(JTable table,
                Object value, boolean isSelected, boolean hasFocus, int row,
                int column)
	    {
	    	if((row != -1) && (cl != null)) {
		        if(value != null) {
		            setText("");
		            setIcon((Icon)value);
	        }
	    }
	    return this;
	    }
	}


	/** rendert alle Tabellenzeilen mit String Inhalt
	 *  im wesentlichen heisst das rechts-ausgerichtent
	 * @author lunqual
	 */
	private class StringRenderer extends DefaultTableCellRenderer {

	    StringRenderer() {
	        super();
	        setOpaque(true);
	    }
	    public Component getTableCellRendererComponent(JTable table,
                Object value, boolean isSelected, boolean hasFocus, int row,
                int column)
	    {
	    	setFont(rz.getFontFactory().getTableFont());
	        if(isSelected) {
	            setBackground( rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_SELECTED));
	        } else {
	            setBackground( rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_NORMAL));
	        }
	        if(column==C_DATUM) {
	        	ContainerItem ci = cl.getItemOrder(row);
	        	if (ci != null && ci.getOut()==1) {
      			    setBackground(farben[9]);
		        	for(int i=0;i < MONATE;i++) {
		        		if( ((String)value).contains(monate[i])) {
		        			  setBackground(farben[i]);
		        		}
		        	}
		        }
	        }
	        if(value != null) {
	        	setText(value.toString());
	         } else {
				setText("");
			}
	        setHorizontalAlignment(SwingConstants.LEADING);
	        return this;
        }
	}


	public void columnAdded(TableColumnModelEvent e) {
	}
	public void columnMarginChanged(ChangeEvent e) {
	}
	public void columnMoved(TableColumnModelEvent e) {
	}
	public void columnRemoved(TableColumnModelEvent e) {
	}
	public void columnSelectionChanged(ListSelectionEvent e) {
	}

	public class ColumnHeaderListener extends MouseAdapter {
	    public void mouseClicked(MouseEvent evt) {
	        JTable table = ((JTableHeader)evt.getSource()).getTable();
	        TableColumnModel colModel = table.getColumnModel();

	        int vColIndex = colModel.getColumnIndexAtX(evt.getX());
	        // Return if not clicked on any column header
	        if (vColIndex == -1) {
	            return;
	        }
	        // Determine if mouse was clicked between column heads
	        Rectangle headerRect = table.getTableHeader().getHeaderRect(vColIndex);
	        if (vColIndex == 0) {
	            headerRect.width -= 3;    // Hard-coded constant
	        } else {
	            headerRect.grow(-3, 0);   // Hard-coded constant
	        }
	        if (!headerRect.contains(evt.getX(), evt.getY())) {
	            // Mouse was clicked between column heads
	            // vColIndex is the column head closest to the click

	            // vLeftColIndex is the column head to the left of the click
	            if (evt.getX() < headerRect.x) {
	                vColIndex--;
	            }
	        }
	        if(cl != null && cl.size()>0) {
		        switch(vColIndex) {
		        	case C_OUT:
		        		cl.sortout();
		        		break;
		        	case C_NUMMER:
		        		cl.sortNummer();
		        		break;
		        	case C_TARA:
		        		cl.sortTara();
		        		break;
		        	case C_COMMENT:
		        		cl.sortBemerkungen();
		        		break;
		        	case C_ORDNER:
		        		cl.sortOrdner();
		        		break;
		        	case C_DATUM :
		        		cl.sortDatum();
		        		break;
		        	case C_ADRESSE: 
		        		cl.sortAdresse();
		        		break;
		        	case C_FUELLUNG:
		        		cl.sortInhalt();
		        		break;
		        }
                ((AbstractTableModel)tblContainer.getModel()).fireTableDataChanged();
	        }
	    }
	}

	
}
