/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package de.lunqual.rzpro.fenster.containerfenster;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.Date;

import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.SwingConstants;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.fenster.JNumberField;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fenster.JSelectedTextField;
import de.lunqual.rzpro.fenster.dialoge.DialogControl;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.container.ContainerItem;
import de.lunqual.rzpro.items.container.ContainerOrdnerItem;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.options.OptionFactory;


/**
 *
 * @author  administrator
 */
public class ContainerEingabe extends JRzFrame {

    //GUI-Variablen
	private JMenuBar mb;
    	private JMenu mnuDatei;
    	private JMenu mnuExtras;
    	private JMenu mnuHilfe;
    private JPanel mainPanel;
    	private JPanel toolbarPanel;
    		private JToolBar tb1;
    	private JPanel contentPanel;
    		private JPanel namePanel;
        		private JLabel lblName;
        		private JSelectedTextField txtName;
        		private JLabel lblTara;
        		private JNumberField txtTara;
        	private JPanel commentPanel;
        		private  JLabel lblOrdner;
        		private JPanel ordnerPanel;
        			private JScrollPane scrOrdner;
        				private JList lstOrdner;
        		private JPanel commentText;
        			private JLabel lblComment;
        			private JScrollPane scrComment;
        				private JTextArea txtComment;
    	private JPanel buttonPanel;
    		private JButton btOK;
    		private JButton btHilfe;
    		private JButton btCancel;

    // ActionCodes KalkulationEingabe
    public static final int         ACTION_OK_CODE = 1000;
    public static final String      ACTION_OK_TEXT = "containereingabe.action_ok";
    public static final int         ACTION_ABBRECHEN_CODE = 1001;
    public static final String      ACTION_ABBRECHEN_TEXT = "containereingabe.action_abbrechen";
    public static final int         ACTION_HILFE_CODE = 1002;
    public static final String      ACTION_HILFE_TEXT = "action_hilfe";
    public static final int         ACTION_HIDE_CODE = 1003;
    public static final String      ACTION_HIDE_TEXT = "action_hide";

    ContainerItem    ci;
    JRzFrame			origin;

    static final String SHORTNAME_MASK = "****";

    /** Creates new form AdressAuswahl */

    public ContainerEingabe(RzPro r, String name,Object extendedData) {
        super(r,name,extendedData);
        createActions();
        createGUIComponents();
        setGUIComponents();
        getMessage((MessageItem)extendedData);
    }

    @Override
	public void createGUIComponents() {
        mb = new JMenuBar();
		mnuDatei = new JMenu();
			mb.add(mnuDatei);
        mnuExtras = new JMenu();
        	mb.add(mnuExtras);
        mnuHilfe = new JMenu();
        	mb.add(mnuHilfe);
		setJMenuBar(mb);
		mainPanel = new JPanel(new BorderLayout());
			toolbarPanel = new JPanel(new BorderLayout());
				tb1 = new JToolBar();
				tb1.setFloatable(false);
				tb1.setRollover(true);
				toolbarPanel.add(tb1);
			mainPanel.add(toolbarPanel,BorderLayout.NORTH);
			contentPanel  = new JPanel(new BorderLayout());
    			namePanel=new JPanel(new GridBagLayout());
    				final java.awt.GridBagConstraints c = new GridBagConstraints();
    				c.insets = new Insets(5,5,5,5);c.fill=GridBagConstraints.BOTH;
    				lblName = new JLabel();
	        			lblName.setHorizontalAlignment(SwingConstants.TRAILING);
	        			c.gridx=0;c.gridy=0;c.gridwidth=1;c.gridheight=1;c.weightx=0;
	        			namePanel.add(lblName,c);
	        		txtName = new JSelectedTextField();
	        			txtName.setColumns(30);
        				c.gridx=1;c.gridy=0;c.gridwidth=2;c.gridheight=1;c.weightx=1;
	            	namePanel.add(txtName,c);
	            	lblTara=new JLabel();
	            		lblTara.setHorizontalAlignment(SwingConstants.TRAILING);
        				c.gridx=0;c.gridy=1;c.gridwidth=1;c.gridheight=1;c.weightx=0;
    	            namePanel.add(lblTara,c);
	            		txtTara = new  JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_EXCHANGE),0.0,0.0,Double.POSITIVE_INFINITY);
	            		txtTara.setColumns(8);
        				c.gridx=1;c.gridy=1;c.gridwidth=2;c.gridheight=1;c.weightx=1;
        			namePanel.add(txtTara,c);
	            contentPanel.add(namePanel,BorderLayout.NORTH);
	            	commentPanel = new JPanel(new BorderLayout());
	            		ordnerPanel=new JPanel(new BorderLayout());
	            			lblOrdner = new JLabel();
	            				lblOrdner.setHorizontalAlignment(SwingConstants.CENTER);
	            			ordnerPanel.add(lblOrdner,BorderLayout.NORTH);
	            			scrOrdner = new JScrollPane();
	            				lstOrdner = new JList();
	            					lstOrdner.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
	            				scrOrdner.setViewportView(lstOrdner);
	            			ordnerPanel.add(scrOrdner,BorderLayout.CENTER);
	            		commentPanel.add(ordnerPanel,BorderLayout.WEST);
	            		commentText = new JPanel(new BorderLayout());
	            		lblComment=new JLabel();
	            			lblComment.setHorizontalAlignment(SwingConstants.CENTER);
	            		commentText.add(lblComment,BorderLayout.NORTH);
	            		scrComment=new JScrollPane();
	            			txtComment=new JTextArea();
	            			txtComment.setPreferredSize(new Dimension(100,100));
	            			scrComment.setViewportView(txtComment);
	            		commentText.add(scrComment,BorderLayout.CENTER);
	            	commentPanel.add(commentText,BorderLayout.CENTER);
	            contentPanel.add(commentPanel,BorderLayout.CENTER);
			buttonPanel=new JPanel(new GridLayout(1,3));
    			btOK=new JButton();
    				buttonPanel.add(btOK);
    			btHilfe = new JButton();
    				buttonPanel.add(btHilfe);
    		    btCancel = new JButton();
    		    	buttonPanel.add(btCancel);
			mainPanel.add(toolbarPanel,BorderLayout.NORTH);
			mainPanel.add(contentPanel,BorderLayout.CENTER);
			mainPanel.add(buttonPanel,BorderLayout.SOUTH);

			getContentPane().setLayout(new BorderLayout());
			getContentPane().add(mainPanel,BorderLayout.CENTER);
    }
    @Override
	public void setGUIComponents() {
        setTitle(rz.getLocale().getString("containereingabe.titel"));

        mnuDatei.setText(rz.getLocale().getString("menu.datei"));
        mnuExtras.setText(rz.getLocale().getString("menu.extras"));
        mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));
        mnuDatei.add(getAction(ACTION_OK_CODE));
        mnuDatei.addSeparator();
        mnuDatei.add(getAction(ACTION_ABBRECHEN_CODE));
        mnuExtras.add(getAction(ACTION_HIDE_CODE));
        mnuHilfe.add(getAction(ACTION_HILFE_CODE));

  	  	tb1.add(getAction(ACTION_OK_CODE));
  	  	tb1.add(getAction(ACTION_ABBRECHEN_CODE));
  	  	tb1.addSeparator();
  	  	tb1.add(getAction(ACTION_HIDE_CODE));
  	  	tb1.addSeparator();
  	  	tb1.add(getAction(ACTION_HILFE_CODE));

        btOK.setAction(getAction(ACTION_OK_CODE));
        btHilfe.setAction(getAction(ACTION_HILFE_CODE));
        btCancel.setAction(getAction(ACTION_ABBRECHEN_CODE));

        lblName.setText(rz.getLocale().getString("containereingabe.label_name"));
        lblTara.setText(rz.getLocale().getString("containereingabe.label_tara"));
        lblComment.setText(rz.getLocale().getString("containereingabe.label_comment"));
        lblOrdner.setText(rz.getLocale().getString("containereingabe.label_ordner"));

        setResizable(true);
         rz.getFontFactory().setFrameFonts(this);
         pack();
         rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;
    }
    @Override
	public void getMessage(MessageItem msg) {
        switch(msg.getMsgCode()) {
    	case MessageItem.MSG_ACTIONPERFORMED:
            switch(msg.getCode()){
            case ACTION_ABBRECHEN_CODE :cancelAction();break;
			case ACTION_OK_CODE :okAction();break;
            case ACTION_HILFE_CODE: hilfeAction();break;
            case ACTION_HIDE_CODE:hideAction();break;
            default :
                break;
           }
    		break;
         case MessageItem.MSG_EDIT_CONTAINER_REQUEST:
 			origin = msg.getOrigin();
            ci = rz.getDatabase().getContainer().getContainer(msg.getCode(),false);
            if(ci != null) {
            	fromItem();
            }
	      	break;

        default:
            rz.getLogFactory().logMessage(2, "kalkulation:_eingabe", "auswahlAction:" + msg.getMsgCode());
            break;
        }
    }

    @Override
	public void createActions(){
        actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT, KeyEvent.VK_F5 ,InputEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT, KeyEvent.VK_F1 ,0));
		actionList.put(String.valueOf(ACTION_OK_CODE), new AuswahlAction(rz,this,ACTION_OK_CODE,ACTION_OK_TEXT,KeyEvent.VK_O,	InputEvent.CTRL_DOWN_MASK));
		actionList.put(String.valueOf(ACTION_ABBRECHEN_CODE), new AuswahlAction(rz,this, ACTION_ABBRECHEN_CODE,ACTION_ABBRECHEN_TEXT,KeyEvent.VK_ESCAPE, 0));

    }

    /**
     * ok gedrückt... abspeichern oder ändern
     */
    private void okAction(){
        int insertID;
        toItem();

        if(!ci.getName().equals("")) {
            insertID = rz.getDatabase().getContainer().saveContainer(ci);
            insertID = lstOrdner.getSelectedIndex() == -1 ? 1 : ((ContainerOrdnerItem)lstOrdner.getSelectedValue()).getID();
            closeWindow();
            origin.getMessage(new MessageItem(MessageItem.MSG_EDIT_CONTAINER_REPLY,insertID,null,this));
        } else {
            final DialogItem dlgItem = new DialogItem(0,"",0.0,"","","","","","",null);
            dlgItem.setTyp(DialogControl.HINWEIS_DIALOG);
            dlgItem.setCaption(rz.getLocale().getString("containereingabe.titel"));
            dlgItem.setTitel(rz.getLocale().getString("containereingabe.titel"));
            dlgItem.setMessage(rz.getLocale().getString("containereingabe.error_kein_name"));
            dlgItem.setIcon("warnung.png");
            dlgItem.setOk(rz.getLocale().getString("string_ok"));
            dlgItem.setOrigin(this);
            rz.getDialogFactory().getDialog(dlgItem);
        }
    }

    /**
     * cancel
     */
    private void cancelAction(){
        closeWindow();
    }

    private void fromItem(){
        final int ordner = Integer.parseInt(ci.getOrdner().substring(1,ci.getOrdner().indexOf(">")));
        lstOrdner.setListData(rz.getDatabase().getContainer().getOrdnerListe().toArray());
        for(int i = 0;i < lstOrdner.getModel().getSize();i++) {
            if(((ContainerOrdnerItem)lstOrdner.getModel().getElementAt(i)).getID() == ordner){
                lstOrdner.setSelectedIndex(i);
                break;
            }
        }
        txtName.setText(ci.getName());
        txtTara.setValue(ci.getTara());
        txtComment.setText(ci.getComment());
    }

    private void toItem(){
        ci.setName(txtName.getText().trim());
        ci.setComment(txtComment.getText().trim());
        ci.setTara(txtTara.getValue());
        ci.setOrdner(lstOrdner.getSelectedIndex() == -1 ? "<1>" : "<" + String.valueOf(((ContainerOrdnerItem)lstOrdner.getSelectedValue()).getID()) + ">");
        ci.setGeaendert(new Date());
        ci.setUser_2(rz.getDatabase().dbGetUser());
    }

    @Override
	public void closeWindow(){
    	rz.getFensterFactory().getFensterListe().disposeFrame(this);
    }
    @Override
	public void openWindow(){
    	if(ci != null) {
    		if (!isVisible()) {
				setVisible(true);
			}
    		toFront();
    		txtName.requestFocus();
    	} else {
    		try {
    			origin.getMessage(new MessageItem(MessageItem.MSG_SHOW_CONTAINER,0,null,this));
    		} catch (final Exception e) {

    		}
    		closeWindow();
    	}
    }

	//hilfe
	private void hilfeAction() {
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"container_eingabe.html",this));
	}

    private void hideAction() {
        rz.getFensterFactory().getFensterListe().sperren(this);
    }
}
