/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/*
 * db ist die zentrale Schnittstelle zur Datenbank. Hier wird die Verbindung
 * zur Datenbank aufgebaut, abgebaut und alle Datentransfers laufen aber
 * diese Klasse. Keine andere Klasse im Programm nimmt eigenständige
 * Verbindungen zur Datenbank auf
 *
 */

package de.lunqual.rzpro.fenster.datenblatt;


import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;

import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.ausgabe.ReportFactory;
import de.lunqual.rzpro.fenster.JNumberField;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fenster.JSelectedTextField;
import de.lunqual.rzpro.fenster.dialoge.DialogControl;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.datenblatt.DatenblattItem;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.report.ReportItem;
import de.lunqual.rzpro.options.OptionFactory;
/**
 *
 * @author  lunqual
 */
public class DatenblattFenster extends JRzFrame {

    //GUI-Variablen
    private JMenuBar mb;
    private JMenu mnuDatei;
    private JMenu mnuBearbeiten;
    private JMenu mnuExtras;
    private JMenu mnuHilfe;
    private JPanel mainPanel;
    	private JPanel toolbarPanel;
    		private JToolBar tb1;
    	private JPanel contentPanel;
    		private JPanel topPanel;
    			private JLabel lblBezeichnung;
    			private JSelectedTextField txtBezeichnung;
    			private JLabel lblStaerke;
    			private JNumberField txtStaerke;
    			private JLabel lblSaved;
    			private JLabel lblSavedStatus;
    		private JPanel textPanel;
    			private JLabel lblText;
    			private JScrollPane scrText;
    				private JEditorPane txtText;
    	private JPanel buttonPanel;
    		private JButton btSave;
    		private JButton btSaveDefault;
    		private JComboBox cmbFormulare;
    		private JButton btDrucken;
    		private JButton btPDF;
    		private JButton btAbbrechen;


    //ActionCodes Adressenfenster
    public static final int         	ACTION_SAVE_CODE = 1001;
    public static final String      	ACTION_SAVE_TEXT = "datenblatt.action_speichern";
    public static final int         	ACTION_HILFE_CODE = 1002;
    public static final String      	ACTION_HILFE_TEXT = "action_hilfe";
    public static final int         	ACTION_HIDE_CODE = 1003;
    public static final String      	ACTION_HIDE_TEXT = "action_hide";
    public static final int         	ACTION_DRUCKEN_CODE = 1004;
    public static final String      	ACTION_DRUCKEN_TEXT = "datenblatt.action_drucken";
    public static final int         	ACTION_CANCEL_CODE = 1005;
    public static final String      	ACTION_CANCEL_TEXT = "datenblatt.action_abbrechen";
    public static final int         	ACTION_PDF_CODE = 1006;
    public static final String      	ACTION_PDF_TEXT = "datenblatt.action_pdf";
    public static final int         	ACTION_SAVE_DEFAULT_CODE = 1007;
    public static final String      	ACTION_SAVE_DEFAULT_TEXT = "datenblatt.action_speichern_default";
    public static final int         	ACTION_DEFAULT_CODE = 1008;
    public static final String      	ACTION_DEFAULT_TEXT = "datenblatt.action_default";

    DatenblattItem							di;

    /** Creates new form AdressenFenster */
    public DatenblattFenster(RzPro r,String name,Object extendedData) {
        super(r,name,extendedData);

        createActions();
        createGUIComponents();
        setGUIComponents();
        getMessage((MessageItem)extendedData);
    }

    @Override
	public void createGUIComponents() {
        mb = new JMenuBar();
		mnuDatei = new JMenu();
			mb.add(mnuDatei);
		mnuBearbeiten=new JMenu();
			mb.add(mnuBearbeiten);
        mnuExtras = new JMenu();
        	mb.add(mnuExtras);
        mnuHilfe = new JMenu();
        	mb.add(mnuHilfe);
		setJMenuBar(mb);
		mainPanel = new JPanel(new BorderLayout());
		toolbarPanel = new JPanel(new BorderLayout());
			tb1 = new JToolBar();
			tb1.setFloatable(false);
			tb1.setRollover(true);
			toolbarPanel.add(tb1);
			contentPanel = new JPanel(new BorderLayout());
				topPanel = new JPanel(new GridLayout(3,2));
					this.lblBezeichnung= new JLabel();
						lblBezeichnung.setHorizontalAlignment(SwingConstants.RIGHT);
					topPanel.add(lblBezeichnung);
					this.txtBezeichnung  = new JSelectedTextField();
					topPanel.add(txtBezeichnung);
					lblStaerke = new JLabel();
						lblStaerke.setHorizontalAlignment(SwingConstants.RIGHT);
					topPanel.add(lblStaerke);
					txtStaerke =new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_NORMAL),0.0,0.0,100.0);
					topPanel.add(txtStaerke);
					lblSaved = new JLabel();
						lblSaved.setHorizontalAlignment(SwingConstants.TRAILING);
					topPanel.add(lblSaved);
					lblSavedStatus = new JLabel();
						lblSavedStatus.setHorizontalAlignment(SwingConstants.LEADING);
					topPanel.add(lblSavedStatus);
				contentPanel.add(topPanel,BorderLayout.NORTH);
				textPanel = new JPanel(new BorderLayout());
					lblText = new JLabel();
						lblText.setHorizontalAlignment(SwingConstants.CENTER);
					textPanel.add(lblText,BorderLayout.NORTH);
					scrText = new JScrollPane();
						txtText = new JEditorPane();
							txtText.setContentType("text/plain");
						scrText.setViewportView(txtText);
					textPanel.add(scrText,BorderLayout.CENTER);
				contentPanel.add(textPanel,BorderLayout.CENTER);
			mainPanel.add(contentPanel,BorderLayout.CENTER);
			buttonPanel = new JPanel(new GridLayout(1,5));
				btSave = new JButton();
				buttonPanel.add(btSave);
				//btSaveDefault = new JButton();
				//buttonPanel.add(btSaveDefault);
				cmbFormulare = new JComboBox();
				rz.getDatabase().getReport().dbGetReportListeCombo(cmbFormulare,ReportFactory.REPORT_TYPE_DATENBLATT);
	        	    cmbFormulare.addActionListener(new ActionListener() {
	    	        	public void actionPerformed(ActionEvent evt) {
	    	        		if(cmbFormulare.getSelectedIndex() != -1) {
	    	        			rz.getOptionFactory().setOption("report.datenblatt",((ReportItem)cmbFormulare.getSelectedItem()).getID());
	    	        			rz.getOptionFactory().saveOptions();
	    	        		}
	    	        	}
	                });
				buttonPanel.add(cmbFormulare);
				btDrucken = new JButton();
				buttonPanel.add(btDrucken);
				btPDF = new JButton();
				buttonPanel.add(btPDF);
				btAbbrechen = new JButton();
				buttonPanel.add(btAbbrechen);
			mainPanel.add(buttonPanel,BorderLayout.SOUTH);
			getContentPane().setLayout(new BorderLayout());
			getContentPane().add(toolbarPanel,BorderLayout.NORTH);
			getContentPane().add(mainPanel,BorderLayout.CENTER);
			getContentPane().add(buttonPanel,BorderLayout.SOUTH);
    }

    @Override
	public void setGUIComponents() {
      setTitle(rz.getVersionString() + " " + rz.getLocale().getString("datenblatt.titel"));
      rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE);

      mnuDatei.setText(rz.getLocale().getString("menu.datei"));
      mnuExtras.setText(rz.getLocale().getString("menu.extras"));
      mnuBearbeiten.setText(rz.getLocale().getString("menu.bearbeiten"));
      mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));

      mnuDatei.addSeparator();
      mnuDatei.add(getAction(ACTION_SAVE_CODE));
      mnuDatei.add(getAction(ACTION_SAVE_DEFAULT_CODE));
      mnuDatei.addSeparator();
      mnuDatei.add(getAction(ACTION_DEFAULT_CODE));
      mnuDatei.addSeparator();
      mnuDatei.add(getAction(ACTION_DRUCKEN_CODE));
      mnuDatei.addSeparator();
      mnuDatei.add(getAction(ACTION_CANCEL_CODE));

      mnuExtras.add(getAction(ACTION_HIDE_CODE));

      mnuHilfe.add(getAction(ACTION_HILFE_CODE));

      btSave.setAction(getAction(ACTION_SAVE_CODE));
     // btSaveDefault.setAction(getAction(ACTION_SAVE_DEFAULT_CODE));
      btDrucken.setAction(getAction(ACTION_DRUCKEN_CODE));
      btAbbrechen.setAction(getAction(ACTION_CANCEL_CODE));
      btPDF.setAction(getAction(ACTION_PDF_CODE));

      tb1.add(getAction(ACTION_CANCEL_CODE));
      tb1.add(getAction(ACTION_HIDE_CODE));
      tb1.addSeparator();
      tb1.add(getAction(ACTION_SAVE_CODE));
      tb1.add(getAction(ACTION_DRUCKEN_CODE));
      tb1.add(getAction(ACTION_PDF_CODE));
      tb1.addSeparator();
      tb1.add(getAction(ACTION_DEFAULT_CODE));
      tb1.addSeparator();
      tb1.add(getAction(ACTION_HILFE_CODE));

      this.lblBezeichnung.setText(rz.getLocale().getString("datenblatt.label_bezeichnung"));
      this.lblStaerke.setText(rz.getLocale().getString("datenblatt.label_staerke"));
      this.lblSaved.setText(rz.getLocale().getString("datenblatt.label_saved"));
      setResizable(true);
      rz.getFontFactory().setFrameFonts(this);
      pack();
      rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;
    }

    @Override
	public void getMessage(MessageItem msg) {
        switch(msg.getMsgCode()) {
        	case MessageItem.MSG_ACTIONPERFORMED:
                switch(msg.getCode()){
                case ACTION_HILFE_CODE: hilfeAction();break;
                case ACTION_HIDE_CODE:hideAction();break;
                case ACTION_CANCEL_CODE:closeWindow();break;
                case ACTION_DRUCKEN_CODE:druckenAction(false);break;
                case ACTION_PDF_CODE:druckenAction(true);break;
                case ACTION_SAVE_CODE:saveAction();break;
                case ACTION_SAVE_DEFAULT_CODE:saveDefaultAction();break;
                case ACTION_DEFAULT_CODE:defaultAction();break;
                default :
                    break;
               }
        		break;
        	case MessageItem.MSG_SHOW_DATENBLATT:
        		final int rezeptur = msg.getCode();
        		final String name = (String)msg.getData();
        		di = rz.getDatabase().getDatenblatt().getDatenblatt(rezeptur, name);
        		break;
           default:
                rz.getLogFactory().logMessage(2, "datenblattfenster:", "auswahlAction:" + msg.getMsgCode());
                break;
        }
    }


     @Override
	public void createActions(){
        actionList.put(String.valueOf(ACTION_SAVE_CODE),new AuswahlAction(rz,this,ACTION_SAVE_CODE,ACTION_SAVE_TEXT,KeyEvent.VK_S ,InputEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_DRUCKEN_CODE),new AuswahlAction(rz,this,ACTION_DRUCKEN_CODE,ACTION_DRUCKEN_TEXT,KeyEvent.VK_D ,InputEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_CANCEL_CODE),new AuswahlAction(rz,this,ACTION_CANCEL_CODE,ACTION_CANCEL_TEXT,KeyEvent.VK_ESCAPE,0));
        actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT,KeyEvent.VK_F5,InputEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT,KeyEvent.VK_F1,0));
        actionList.put(String.valueOf(ACTION_PDF_CODE),new AuswahlAction(rz,this,ACTION_PDF_CODE,ACTION_PDF_TEXT,0,0));
        actionList.put(String.valueOf(ACTION_SAVE_DEFAULT_CODE),new AuswahlAction(rz,this,ACTION_SAVE_DEFAULT_CODE,ACTION_SAVE_DEFAULT_TEXT,0,0));   
        actionList.put(String.valueOf(ACTION_DEFAULT_CODE),new AuswahlAction(rz,this,ACTION_DEFAULT_CODE,ACTION_DEFAULT_TEXT,0,0));   
     }

     private void defaultAction() {
    	 if(di!=null) {
    		 String t =rz.getDatabase().getDatenblatt().getDatenblattDefault();
    		 di.setText(t);
    		 txtText.setText(t);
    	 }
     }
     private void saveDefaultAction() {
    	 if(!txtText.getText().trim().equals("")) {
    			DialogItem dia = new DialogItem(
                        DialogControl.FRAGE_DIALOG,
                        "",0.0,
                        rz.getLocale().getString("datenblattfenster.savedefault"),
                        rz.getLocale().getString("datenblattfenster.savedefault"),
                        rz.getLocale().getString("datenblattfenster.savedefault_1"),
                        "frage.png",
                        rz.getLocale().getString("string_ja"),
                        rz.getLocale().getString("string_nein"),
                        this
	                );
				  	if(dia != null) {
				  		rz.getDialogFactory().getDialog(dia);
				  		if ((dia.getReplyCode() == DialogControl.DIALOG_YES) || (dia.getReplyCode() == DialogControl.DIALOG_OK)){
				    		 di.setText(txtText.getText().trim());
				    		 rz.getDatabase().getDatenblatt().saveDatenBlattDefault(di);				  			
				  		}
				  	}
    	 }
     }
     
     private void saveAction() {
    	 	if(di != null) {
    	 		toItem(di);
    	 		if(rz.getDatabase().getDatenblatt().saveDatenblatt(di) != 0) {
    	 			closeWindow();
    	 		}
    	 	}
     }
     private void druckenAction(boolean pdf) {
    	 	if(di != null) {
    	 		toItem(di);
    	 			rz.getReportFactory().DatenbBlattDrucken(di,pdf,this);    	 			
    	 	}
     }

    @Override
	public void openWindow(){
    		if(di != null) {
    			fromItem(di);
    			if(!isVisible()) {
					setVisible(true);
				}
    			toFront();
    			txtText.requestFocus();
    		} else {
    			closeWindow();
    		}
    }

    @Override
	public void closeWindow(){
        rz.getFensterFactory().getFensterListe().disposeFrame(this);
    }


    private void fromItem(DatenblattItem di) {
    		this.txtBezeichnung.setText(di.getName());
    		this.txtText.setText(di.getText());
    		this.txtStaerke.setValue(di.getStaerke());
    		this.lblSavedStatus.setText((di.isSaved())?rz.getLocale().getString("string_ja"):rz.getLocale().getString("string_nein"));
		txtText.setCaretPosition(0);
    }

    private void toItem(DatenblattItem di) {
    		di.setName(txtBezeichnung.getText().trim());
    		di.setText(txtText.getText().trim());
    		di.setStaerke(txtStaerke.getValue());
    }

    //Extras-Menü
    private void hideAction(){
        rz.getFensterFactory().getFensterListe().sperren(this);
    }

    //hilfe-menü
    private void hilfeAction(){
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"deklarationsliste.html",this));
    }


}
