
/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package de.lunqual.rzpro.fenster.deklarationsfenster;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;

import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fenster.JSelectedTextField;
import de.lunqual.rzpro.fenster.dialoge.DialogControl;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.deklarationen.DeklarationsItem;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.items.message.MessageItem;
/**
 *
 * @author  administrator
 */
public class DeklarationsEingabe extends JRzFrame{

    // GUI-Variablen
    private JMenuBar mb;
    private JMenu mnuDatei;
    private JMenu mnuHilfe;
    private JMenu mnuExtras;
    private JPanel mainPanel;
		private JPanel toolbarPanel;
			private JToolBar tb1;
		private JPanel contentPanel;
			private JPanel namePanel;
				private JLabel lblName;
				private JSelectedTextField txtName;
			private JPanel deklarationsPanel;
				private JLabel lblDeklaration;
				private JScrollPane scrDeklaration;
					private JTextArea txtDeklaration;
		private JPanel buttonPanel;
			private JButton btOK;
			private JButton btHilfe;
			private JButton btCancel;

    // ActionCodes StichwortAuswahl
    public static final int         ACTION_OK_CODE = 1000;
    public static final String     ACTION_OK_TEXT = "deklarationseingabe.action_ok";
    public static final int         ACTION_ABBRECHEN_CODE = 1001;
    public static final String     ACTION_ABBRECHEN_TEXT = "deklarationseingabe.action_abbrechen";
    public static final int         ACTION_HILFE_CODE = 1008;
    public static final String     ACTION_HILFE_TEXT = "action_hilfe";
    public static final int         ACTION_HIDE_CODE = 1009;
    public static final String     ACTION_HIDE_TEXT = "action_hide";

    DeklarationsItem	di;
    MessageItem 		mi;
    /** Creates new form AdressAuswahl */

    public DeklarationsEingabe(RzPro r,String name,Object extendedData) {
        super(r,name,extendedData);
        createActions();
        createGUIComponents();
        setGUIComponents();
        mi = (MessageItem)extendedData;
        this.getMessage(mi);
    }

    /** GUI-Komponenten erzeugen
     */
    @Override
	public void createGUIComponents() {
        mb = new JMenuBar();
		mnuDatei = new JMenu();
			mb.add(mnuDatei);
        mnuExtras = new JMenu();
        	mb.add(mnuExtras);
        mnuHilfe = new JMenu();
        	mb.add(mnuHilfe);
		setJMenuBar(mb);
		mainPanel = new JPanel(new GridLayout(1,2));
		toolbarPanel = new JPanel(new BorderLayout());
			tb1 = new JToolBar();
			tb1.setFloatable(false);
			tb1.setRollover(true);
			toolbarPanel.add(tb1);
			mainPanel.add(toolbarPanel,BorderLayout.NORTH);
				contentPanel = new JPanel(new BorderLayout());
					namePanel=new JPanel( new BorderLayout());
						lblName = new JLabel();
							lblName.setHorizontalAlignment(SwingConstants.RIGHT);
						namePanel.add(lblName,BorderLayout.WEST);
						txtName = new JSelectedTextField();
						namePanel.add(txtName,BorderLayout.CENTER);
				    contentPanel.add(namePanel,BorderLayout.NORTH);
				    deklarationsPanel = new JPanel(new BorderLayout());
				    	lblDeklaration = new JLabel();
				    		lblDeklaration.setHorizontalAlignment(SwingConstants.CENTER);
				    	deklarationsPanel.add(lblDeklaration,BorderLayout.NORTH);
				    	scrDeklaration = new JScrollPane();
				    		txtDeklaration = new JTextArea();
				    			txtDeklaration.setSize(200,200);
				    		scrDeklaration.setViewportView(txtDeklaration);
				    	deklarationsPanel.add(scrDeklaration,BorderLayout.CENTER);
				    contentPanel.add(deklarationsPanel,BorderLayout.CENTER);
				mainPanel.add(contentPanel,BorderLayout.CENTER);
			buttonPanel= new JPanel(new GridLayout(1,3));
				btOK = new JButton();
					buttonPanel.add(btOK);
				btHilfe = new JButton();
					buttonPanel.add(btHilfe);
				btCancel = new JButton();
					buttonPanel.add(btCancel);

			getContentPane().setLayout(new BorderLayout());
				getContentPane().add(toolbarPanel,BorderLayout.NORTH);
				getContentPane().add(mainPanel,BorderLayout.CENTER);
				getContentPane().add(buttonPanel,BorderLayout.SOUTH);
    }

    /** GUI-Komponenten mit Text usw. versehen...
     */
    @Override
	public void setGUIComponents() {
        setTitle(rz.getLocale().getString("deklarationseingabe.titel"));
        mnuDatei.setText(rz.getLocale().getString("menu.datei"));
        mnuExtras.setText(rz.getLocale().getString("menu.extras"));
        mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));

        mnuDatei.add(getAction(ACTION_OK_CODE));
        mnuDatei.addSeparator();
        mnuDatei.add(getAction(ACTION_ABBRECHEN_CODE));
        mnuExtras.add(getAction(ACTION_HIDE_CODE));
        mnuHilfe.add(getAction(ACTION_HILFE_CODE));

        lblName.setText(rz.getLocale().getString("deklarationseingabe.label_name"));
        lblDeklaration.setText(rz.getLocale().getString("deklarationseingabe.label_deklaration"));


        btOK.setAction(getAction(ACTION_OK_CODE));
        btCancel.setAction(getAction(ACTION_ABBRECHEN_CODE));
        btHilfe.setAction(getAction(ACTION_HILFE_CODE));

        tb1.add(getAction(ACTION_OK_CODE));
        tb1.addSeparator();
        tb1.add(getAction(ACTION_HIDE_CODE));
        tb1.addSeparator();
        tb1.add(getAction(ACTION_ABBRECHEN_CODE));
        tb1.addSeparator();
        tb1.add(getAction(ACTION_HILFE_CODE));


        setResizable(true);
        rz.getFontFactory().setFrameFonts(this);
        pack();
        rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;
    }

    @Override
	public void createActions(){
        actionList.put(String.valueOf(ACTION_OK_CODE),new AuswahlAction(rz,this,ACTION_OK_CODE,ACTION_OK_TEXT,KeyEvent.VK_O ,InputEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_ABBRECHEN_CODE),new AuswahlAction(rz,this,ACTION_ABBRECHEN_CODE,ACTION_ABBRECHEN_TEXT,KeyEvent.VK_ESCAPE ,0));
        actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT, KeyEvent.VK_F1 ,0));
        actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT,KeyEvent.VK_F5 ,InputEvent.SHIFT_DOWN_MASK));
    }
    /** auf Messages reagieren
     *
     */
    @Override
	public void getMessage(MessageItem msg) {
        switch (msg.getMsgCode()) {
        	case MessageItem.MSG_ACTIONPERFORMED:
                switch(msg.getCode()){
                case ACTION_ABBRECHEN_CODE  : cancelAction();break;
                case ACTION_OK_CODE  : okAction();break;
                case ACTION_HILFE_CODE : hilfeAction();break;
                case ACTION_HIDE_CODE : hideAction();break;
                default:
                    rz.getLogFactory().logMessage(2, "deklarationseingabe:", "auswahlAction:" + msg.getCode());
                    break;
                }
        	    break;
        	case MessageItem.MSG_SHOW_DEKLARATION_EINGABE :
        		di = rz.getDatabase().getDeklarationen().getDeklaration(msg.getCode());
        		fromItem();
        	    break;
        }

    }

    /**
     * ok gedrückt... abspeichern oder ändern
     */
    private void okAction(){
    	toItem();
    	if(!di.getName().equals("")) {
    		rz.getDatabase().getDeklarationen().saveDeklaration(di);
    		if (di.getId() != 0) {
		    	try {
		    		mi.getOrigin().getMessage(new MessageItem(MessageItem.MSG_EDIT_DEKLARATION_REPLY,di.getId(),null,this ));
		    	} catch (final Exception e) {}
				closeWindow();
    		}
    	}else {
    		 final DialogItem di  = new DialogItem(
	                  DialogControl.HINWEIS_DIALOG,
	                  "",0.0,
	                  rz.getLocale().getString("deklarationseingabe.dialog_titel"),
	                  rz.getLocale().getString("deklaratsionseingabe.dialog_titel"),
	                  rz.getLocale().getString("deklarationseingabe.dialog_no_name"),
	                  "warnung.png",
	                  rz.getLocale().getString("string_ok"),
	                  "",
	                  this
	          );
	          rz.getDialogFactory().getDialog(di);
    	}
    }

    /**
     * cancel
     */
    private void cancelAction(){
        closeWindow();
    }

    @Override
	public void closeWindow(){
        rz.getFensterFactory().getFensterListe().disposeFrame(this);
    }


    @Override
	public void openWindow(){
    	if(di != null) {
    		setVisible(true);
    		toFront();
    		txtName.requestFocus();
    	}
    }

    /**
     * GUI aus Item füllen
     *
     */
    private void fromItem() {
    	txtName.setText(di.getName());
    	txtDeklaration.setText(di.getDeklaration());
    }
    /**
     * Item aus GUI
     *
     */
    private void toItem() {
    	di.setName(txtName.getText().trim());
    	di.setDeklaration(txtDeklaration.getText().trim());
    }

    //hilfe
    private void hilfeAction(){
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"deklarationseingabe.html",this));
    }

    private void hideAction() {
        rz.getFensterFactory().getFensterListe().sperren(this);
    }


}
