/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/*
 * db ist die zentrale Schnittstelle zur Datenbank. Hier wird die Verbindung
 * zur Datenbank aufgebaut, abgebaut und alle Datentransfers laufen aber
 * diese Klasse. Keine andere Klasse im Programm nimmt eigenständige
 * Verbindungen zur Datenbank auf
 *
 */

package de.lunqual.rzpro.fenster.deklarationsfenster;


import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;

import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.SwingConstants;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.database.DBAbfrage;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fenster.dialoge.DialogControl;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.abfrage.AbfrageItem;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.deklarationen.DeklarationsItem;
import de.lunqual.rzpro.items.deklarationen.DeklarationsListe;
import de.lunqual.rzpro.items.deklarationen.FormBlattItem;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.options.OptionFactory;
/**
 *
 * @author  lunqual
 */
public class DeklarationsListenFenster extends JRzFrame  implements TableColumnModelListener {

    //GUI-Variablen
    private JMenuBar mb;
    private JMenu mnuDatei;
    private JMenu mnuBearbeiten;
    private JMenu mnuExtras;
    private JMenu mnuFenster;
    private JMenu mnuHilfe;
    private JPanel mainPanel;
    	private JPanel toolbarPanel;
    		private JToolBar tb1;
    	private JPanel contentPanel;
    		private JPanel listenPanel;
    			private JLabel lblListentitel;
    			private JScrollPane scrListe;
    				private JList lstListe;
    			private JPanel listenButtonPanel;
    				private JButton btNeu;
    				private JButton btEdit;
    				private JButton btRemove;
    				private JButton btRefresh;
    		private JPanel anzeigePanel;
    			private JPanel anzeigeNorthPanel;
	    			private JScrollPane scrAnzeige;
	    				private JEditorPane txtAnzeige;
	    		private JPanel anzeigeCenterPanel;
	    		
	    		     private JSplitPane formPanel;
	    		       private JPanel rightPanel;
		    			private JLabel lblFormblattTitel;
		    			private JScrollPane scrFormblatt;
		    				private JEditorPane txtFormblatt;
		    				   private JPanel formblattButtonPanel;
		    			     	private JButton btFormblattSave;
		    			     	private JButton btFormblattRefresh;
		    				
		    		 private JPanel leftPanel;
		    			private JPanel formblattButtons;
		    			    private JPanel formblattListe;
		    			    	private JScrollPane scrFormblattListe;
		    			        	private JTable tblFormblatt;
		    			        private JPanel fbButtonPanel;
		    			        	private JButton btSpfadd;
		    			        	private JButton btSpfdelete;
		    			  
    	private JPanel buttonPanel;
    		private JButton btClose;
    		private JButton btHilfe;


    //ActionCodes Adressenfenster
    public static final int         		ACTION_CLOSE_CODE = 1001;
    public static final String      	ACTION_CLOSE_TEXT = "deklarationsliste.action_close";
    public static final int         		ACTION_NEU_CODE = 1002;
    public static final String      	ACTION_NEU_TEXT = "deklarationsliste.action_neu";
    public static final int         		ACTION_BEARBEITEN_CODE = 1003;
    public static final String      	ACTION_BEARBEITEN_TEXT = "deklarationsliste.action_bearbeiten";
    public static final int         		ACTION_DELETE_CODE = 1004;
    public static final String      	ACTION_DELETE_TEXT = "deklarationsliste.action_loeschen";
    public static final int         		ACTION_HILFE_CODE = 1006;
    public static final String      	ACTION_HILFE_TEXT = "action_hilfe";
    public static final int         		ACTION_HIDE_CODE = 1007;
    public static final String      	ACTION_HIDE_TEXT = "action_hide";
    public static final int         		ACTION_REFRESH_CODE = 1008;
    public static final String      	ACTION_REFRESH_TEXT = "deklarationsliste.action_refresh";
    public static final int         		ACTION_SPF_SAVE_CODE = 1009;
    public static final String      	ACTION_SPF_SAVE_TEXT = "deklarationsliste.action_spf_speichern";
    public static final int         		ACTION_SPF_REFRESH_CODE = 1010;
    public static final String      	ACTION_SPF_REFRESH_TEXT = "deklarationsliste.action_spf_refresh";
    public static final int         		ACTION_SPF_ADD_CODE = 1011;
    public static final String      	ACTION_SPF_ADD_TEXT = "deklarationsliste.action_spf_add";
    public static final int         		ACTION_SPF_DELETE_CODE = 1012;
    public static final String      	ACTION_SPF_DELETE_TEXT = "deklarationsliste.action_spf_delete";
    public static final int         		ACTION_SUCHEN_CODE = 1013;
    public static final String      	ACTION_SUCHEN_TEXT = "deklarationsliste.action_suchen";
    

    private static final int			MAX_COLUMN			 	= 2;
    private static final int			C_ACTIVE 					= 0;
    private static final int			C_BEZEICHNUNG			= 1;

    DeklarationsListe								liste;
    ArrayList<FormBlattItem>					formblaetter;
    javax.swing.Timer   							ergebnisTimer;
    JRzFrame									parent;

    /** Creates new form AdressenFenster */
    public DeklarationsListenFenster(RzPro r,String name,Object extendedData) {
        super(r,name,extendedData);
        ergebnisTimer = new javax.swing.Timer(rz.getOptionFactory().getOption("list.timeout",RzPro.LIST_TIMEOUT), new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                 ergebnisTimerEvent();
            }
       });
        createActions();
        createGUIComponents();
        setGUIComponents();
        getMessage((MessageItem)extendedData);
    }

    @Override
	public void createGUIComponents() {
        mb = new JMenuBar();
		mnuDatei = new JMenu();
			mb.add(mnuDatei);
		mnuBearbeiten=new JMenu();
			mb.add(mnuBearbeiten);
        mnuExtras = new JMenu();
        	mb.add(mnuExtras);
        mnuFenster=new JMenu();
        	mb.add(mnuFenster);
        mnuHilfe = new JMenu();
        	mb.add(mnuHilfe);
		setJMenuBar(mb);
		mainPanel = new JPanel(new BorderLayout());
		toolbarPanel = new JPanel(new BorderLayout());
			tb1 = new JToolBar();
			tb1.setFloatable(false);
			tb1.setRollover(true);
			toolbarPanel.add(tb1);
			contentPanel = new JPanel(new BorderLayout());
				listenPanel = new JPanel(new BorderLayout());
					lblListentitel=new JLabel();
						lblListentitel.setHorizontalAlignment(SwingConstants.CENTER);
					listenPanel.add(lblListentitel,BorderLayout.NORTH);
					scrListe=new JScrollPane();
						lstListe = new JList();
				        lstListe.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
				            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
				            	if(evt.getValueIsAdjusting()) {
									return;
								}
				                ausgabeAction();
				            }
				        });
						lstListe.setCellRenderer(new DeklarationsListRenderer(rz));
						scrListe.setViewportView(lstListe);
					listenPanel.add(scrListe,BorderLayout.CENTER);
					listenButtonPanel = new JPanel(new GridLayout(2,2));
						btNeu = new JButton();
							listenButtonPanel.add(btNeu);
						btEdit = new JButton();
							listenButtonPanel.add(btEdit);
						btRemove = new JButton();
							listenButtonPanel.add(btRemove);
						btRefresh = new JButton();
							listenButtonPanel.add(btRefresh);
					listenPanel.add(listenButtonPanel,BorderLayout.SOUTH);
				contentPanel.add(listenPanel,BorderLayout.WEST);
				anzeigePanel=new JPanel(new BorderLayout());
					anzeigeNorthPanel = new JPanel(new BorderLayout());
						scrAnzeige = new JScrollPane();
							txtAnzeige = new JEditorPane();
								txtAnzeige.setEditable(false);
								txtAnzeige.setContentType("text/html");
							scrAnzeige.setViewportView(txtAnzeige);
						anzeigeNorthPanel.add(txtAnzeige,BorderLayout.CENTER);
					anzeigePanel.add(anzeigeNorthPanel,BorderLayout.NORTH);
					anzeigeCenterPanel=new JPanel(new BorderLayout());
					  formPanel = new JSplitPane();
					    rightPanel = new JPanel(new BorderLayout());
						
					    lblFormblattTitel = new JLabel();
						anzeigeCenterPanel.add(lblFormblattTitel,BorderLayout.NORTH);
						scrFormblatt = new JScrollPane();
							txtFormblatt = new JEditorPane();
								txtFormblatt.setContentType("text/plain");
						        txtFormblatt.addKeyListener(new java.awt.event.KeyAdapter() {
						            @Override
									public void keyPressed(java.awt.event.KeyEvent evt) {
						                checkSPFSaveStatus();
						            }
						        });
								txtFormblatt.setEditable(true);
						scrFormblatt.setViewportView(txtFormblatt);
						anzeigeCenterPanel.setBorder(BorderFactory.createEtchedBorder());
					   rightPanel.add(scrFormblatt,BorderLayout.CENTER);
					anzeigeCenterPanel.add(formPanel,BorderLayout.CENTER);
					    leftPanel = new JPanel(new BorderLayout());
						formblattButtons=new JPanel(new BorderLayout());
						    formblattListe = new JPanel(new BorderLayout());
						    	scrFormblatt = new JScrollPane();
						    		tblFormblatt = new JTable();
						    		tblFormblatt.setName("deklarationslistenfenster.formblatt");
						    		tblFormblatt.getSelectionModel().addListSelectionListener(new javax.swing.event.ListSelectionListener() {
							            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
							            	if(evt.getValueIsAdjusting()) {
												return;
											}
							                restartTimer();
							            }
							        });
						    		scrFormblatt.setViewportView(tblFormblatt);
						        formblattListe.add(scrFormblatt,BorderLayout.CENTER);
						    formblattButtons.add(formblattListe,BorderLayout.CENTER);
						   
						    formblattButtonPanel = new JPanel(new GridLayout(1,2));
								btFormblattSave = new JButton();
								formblattButtonPanel.add(btFormblattSave);
								btFormblattRefresh=new JButton();
								formblattButtonPanel.add(btFormblattRefresh);
							rightPanel.add(formblattButtonPanel,BorderLayout.SOUTH);
						leftPanel.add(formblattButtons,BorderLayout.CENTER);
							fbButtonPanel = new JPanel(new GridLayout(1,2));
								fbButtonPanel.setBorder(BorderFactory.createEtchedBorder());
								btSpfadd=new JButton();
								fbButtonPanel.add(btSpfadd);
								btSpfdelete = new JButton();
								fbButtonPanel.add(btSpfdelete);
						    
						leftPanel.add(this.fbButtonPanel,BorderLayout.SOUTH);
						formPanel.setLeftComponent(leftPanel);
						formPanel.setRightComponent(rightPanel);
					anzeigePanel.add(anzeigeCenterPanel,BorderLayout.CENTER);
				contentPanel.add(anzeigePanel,BorderLayout.CENTER);

			mainPanel.add(contentPanel,BorderLayout.CENTER);
			buttonPanel = new JPanel(new BorderLayout());
				btClose = new JButton();
				buttonPanel.add(btClose,BorderLayout.WEST);
				btHilfe = new JButton();
				buttonPanel.add(btHilfe,BorderLayout.EAST);
			mainPanel.add(buttonPanel,BorderLayout.SOUTH);
			getContentPane().setLayout(new BorderLayout());
			getContentPane().add(toolbarPanel,BorderLayout.NORTH);
			getContentPane().add(mainPanel,BorderLayout.CENTER);
			getContentPane().add(buttonPanel,BorderLayout.SOUTH);
			this.settblFormblattModel(tblFormblatt);
    }

    @Override
	public void setGUIComponents() {
      setTitle(rz.getVersionString() + " " + rz.getLocale().getString("deklarationsliste.titel"));
      rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE);

      mnuDatei.setText(rz.getLocale().getString("menu.datei"));
      mnuExtras.setText(rz.getLocale().getString("menu.extras"));
      mnuBearbeiten.setText(rz.getLocale().getString("menu.bearbeiten"));
      mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));
      mnuFenster.setText(rz.getLocale().getString("menu.fenster"));

      mnuDatei.add(getAction(ACTION_REFRESH_CODE));
      mnuDatei.addSeparator();
      mnuDatei.add(getAction(ACTION_CLOSE_CODE));
      mnuBearbeiten.add(getAction(ACTION_NEU_CODE));
      mnuBearbeiten.add(getAction(ACTION_BEARBEITEN_CODE));
      mnuBearbeiten.add(getAction(ACTION_SUCHEN_CODE));
      mnuBearbeiten.add(getAction(ACTION_DELETE_CODE));

      mnuExtras.add(getAction(ACTION_HIDE_CODE));

      mnuHilfe.add(getAction(ACTION_HILFE_CODE));

      btHilfe.setAction(getAction(ACTION_HILFE_CODE));
      btClose.setAction(getAction(ACTION_CLOSE_CODE));

      tb1.add(getAction(ACTION_CLOSE_CODE));
      tb1.add(getAction(ACTION_HIDE_CODE));
      tb1.addSeparator();
      tb1.add(getAction(ACTION_REFRESH_CODE));
      tb1.add(getAction(ACTION_NEU_CODE));
      tb1.add(getAction(ACTION_BEARBEITEN_CODE));
      tb1.add(getAction(ACTION_DELETE_CODE));
      tb1.addSeparator();
      tb1.add(getAction(ACTION_SUCHEN_CODE));
      tb1.addSeparator();
      tb1.add(getAction(ACTION_HILFE_CODE));

      btNeu.setAction(getAction(ACTION_NEU_CODE));
      btRefresh.setAction(getAction(ACTION_REFRESH_CODE));
      btEdit.setAction(getAction(ACTION_BEARBEITEN_CODE));
      btRemove.setAction(getAction(ACTION_DELETE_CODE));

      btSpfadd.setAction(getAction(ACTION_SPF_ADD_CODE));
      btSpfdelete.setAction(getAction(ACTION_SPF_DELETE_CODE));
      
      btFormblattSave.setAction(getAction(ACTION_SPF_SAVE_CODE));
      btFormblattRefresh.setAction(getAction(ACTION_SPF_REFRESH_CODE));

      getAction(ACTION_DELETE_CODE).setEnabled(false);
      getAction(ACTION_BEARBEITEN_CODE).setEnabled(false);
	  getAction(ACTION_SPF_SAVE_CODE).setEnabled(false);

	  lblFormblattTitel.setText(rz.getLocale().getString("deklarationsliste.formblatt"));
      setResizable(true);
      rz.getFontFactory().setFrameFonts(this);
	  txtFormblatt.setFont(rz.getFontFactory().getDeckblattFont());
      pack();
      rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;	  
      setDividerLocations();
    }

    @Override
	public void getMessage(MessageItem msg) {
        switch(msg.getMsgCode()) {
        	case MessageItem.MSG_ACTIONPERFORMED:
                switch(msg.getCode()){
                case ACTION_HILFE_CODE: hilfeAction();break;
                case ACTION_HIDE_CODE:hideAction();break;
                case ACTION_REFRESH_CODE:refreshAction();break;
                case ACTION_CLOSE_CODE:closeWindow();break;
                case ACTION_DELETE_CODE:deleteAction();break;
                case ACTION_NEU_CODE:neuAction();break;
                case ACTION_BEARBEITEN_CODE:editAction();break;
                case ACTION_SPF_SAVE_CODE:spfSaveAction();break;
                case ACTION_SPF_REFRESH_CODE:ergebnisTimerEvent();break;
                case ACTION_SUCHEN_CODE:suchenAction();break;
                case ACTION_SPF_ADD_CODE:
                	rz.getDatabase().getDeklarationen().addFormBlatt();
                	formblaetter = rz.getDatabase().getDeklarationen().getFormblattListe();
                	selectActiveFormblatt();
                	break;
                case ACTION_SPF_DELETE_CODE:
                	deleteFormblattAction();
                	formblaetter = rz.getDatabase().getDeklarationen().getFormblattListe();
                	selectActiveFormblatt();
                	break;
                default :
                    break;
               }
        		break;
        	case MessageItem.MSG_EDIT_DEKLARATION_REPLY:
        		refreshAction();
        		if(!liste.isEmpty()) {
        			for(int i = 0;i < liste.size();i++) {
        				if(liste.getItem(i).getId() == msg.getCode()) {
        					lstListe.setSelectedIndex(i);
        					break;
        				}
        			}
        		}
        		break;
           case MessageItem.MSG_SHOW_DEKLARATIONSLISTE:
        	   parent = msg.getOrigin();
        	   refreshAction();
                break;
            default:
                rz.getLogFactory().logMessage(2, "deklarationsListenfenster:", "auswahlAction:" + msg.getMsgCode());
                break;
        }
    }

	/** speichert die Position der Splitbalken
	 */
    private void saveDividerLocations(){
        rz.getFensterFactory().setOption(this.getName() + ".splFormpanel", this.formPanel.getDividerLocation());
        rz.getFensterFactory().saveOptions();
    }
	/** setzt die Position der Splitbalken auf gespeicherte Positionen oder
	 * auf Standardposition, wenn keine gespeicherten vorliegen
	 *
	 */
    private void setDividerLocations() {
        formPanel.setDividerLocation(rz.getFensterFactory().getOption(this.getName() + ".splFormpanel",formPanel.getWidth()/3));
    }
     @Override
	public void createActions(){
        actionList.put(String.valueOf(ACTION_CLOSE_CODE),new AuswahlAction(rz,this,ACTION_CLOSE_CODE,ACTION_CLOSE_TEXT,KeyEvent.VK_ESCAPE ,0));
        actionList.put(String.valueOf(ACTION_NEU_CODE),new AuswahlAction(rz,this,ACTION_NEU_CODE,ACTION_NEU_TEXT, KeyEvent.VK_N ,InputEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_BEARBEITEN_CODE),new AuswahlAction(rz,this,ACTION_BEARBEITEN_CODE,ACTION_BEARBEITEN_TEXT, KeyEvent.VK_F2 ,0));
        actionList.put(String.valueOf(ACTION_DELETE_CODE),new AuswahlAction(rz,this,ACTION_DELETE_CODE,ACTION_DELETE_TEXT,0 ,0));
        actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT, KeyEvent.VK_F5 ,InputEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT, KeyEvent.VK_F1 ,0));
        actionList.put(String.valueOf(ACTION_REFRESH_CODE),new AuswahlAction(rz,this,ACTION_REFRESH_CODE,ACTION_REFRESH_TEXT, KeyEvent.VK_F5 ,0));
        actionList.put(String.valueOf(ACTION_SPF_REFRESH_CODE),new AuswahlAction(rz,this,ACTION_SPF_REFRESH_CODE,ACTION_SPF_REFRESH_TEXT, 0 ,0));
        actionList.put(String.valueOf(ACTION_SPF_SAVE_CODE),new AuswahlAction(rz,this,ACTION_SPF_SAVE_CODE,ACTION_SPF_SAVE_TEXT, 0 ,0));
        actionList.put(String.valueOf(ACTION_SPF_ADD_CODE),new AuswahlAction(rz,this,ACTION_SPF_ADD_CODE,ACTION_SPF_ADD_TEXT, 0 ,0));
        actionList.put(String.valueOf(ACTION_SPF_DELETE_CODE),new AuswahlAction(rz,this,ACTION_SPF_DELETE_CODE,ACTION_SPF_DELETE_TEXT, 0 ,0));
        actionList.put(String.valueOf(ACTION_SUCHEN_CODE),new AuswahlAction(rz,this,ACTION_SUCHEN_CODE,ACTION_SUCHEN_TEXT, 0 ,0));
     }

     private void restartTimer() {
         if(ergebnisTimer.isRunning()) {
 			ergebnisTimer.restart();
 		} else {
 			ergebnisTimer.start();
 		}
     }
     private void ergebnisTimerEvent(){
     	ergebnisTimer.stop();
         if (formblaetter != null && tblFormblatt.getSelectedRow() != -1){
             final FormBlattItem fi = formblaetter.get(tblFormblatt.getSelectedRow());
             if (fi != null) {
            	 txtFormblatt.setText(rz.getDatabase().getDeklarationen().getFormBlattText(fi.getId()));
       	  	   	getAction(ACTION_SPF_SAVE_CODE).setEnabled(false);
             }
             setSPFActions();
         }
         else {
             txtFormblatt.setEditable(true);
             txtFormblatt.setText("");
             txtFormblatt.setEditable(false);
         }
     }

     private void suchenAction() {
    	 rz.setWaitCursor(this);
    	 if(lstListe.getSelectedValue() != null) {
    		DeklarationsItem di = (DeklarationsItem)lstListe.getSelectedValue();
    		if (di != null) {
    			ArrayList<Integer> liste = rz.getDatabase().getRezeptur().getRezepturenFromDeklaration(di.getId());
    			if(liste != null && liste.size()>0) {
    				if(parent != null) {
    					try {
	    			    	final AbfrageItem ai = new AbfrageItem();
	    			    	ai.setTyp(DBAbfrage.ABFRAGE_TYP_SQL);
	    			    	String sql = rz.getDatabase().getErgebnis().getErweitertSQLPrefix();
	    			    	ai.setMuster(sql);
	    			    	String clauses =" rezeptliste.id in(";
	    			    	for(int i=0;i<liste.size();i++) {
	    			    		clauses += String.valueOf(liste.get(i))+",";
	    			    	}
	    			    	if(clauses.endsWith(","))clauses = clauses.substring(0,clauses.length()-1);
	    			    	clauses += ")";
	    			    	sql += clauses + " and rezeptliste.typ=1 group by rezeptliste.id order by name";
	    			    	ai.setMuster(sql);

    						parent.getMessage(new MessageItem(MessageItem.MSG_ABFRAGE_ERWEITERT_REPLY,0,ai,this));
    					}catch (Exception e) {}
    				}
    			}
    		}
    	 }
    	 rz.setFreeCursor(this);
     }
     
     private void deleteFormblattAction() {
    	  if (formblaetter != null && tblFormblatt.getSelectedRow() != -1){
              final FormBlattItem fi = formblaetter.get(tblFormblatt.getSelectedRow());
              if (fi != null) {
            	  if(!fi.isActive()) {
            		  DialogItem di = new DialogItem(
		                        DialogControl.FRAGE_DIALOG,
		                        "",0.0,
		                        rz.getLocale().getString("deklarationsliste.question_spf_delete"),
		                        rz.getLocale().getString("deklarationsliste.question_spf_delete"),
		                        rz.getLocale().getString("deklarationsliste.question_spf_delete_2")
		                        	.replaceAll("%s",fi.getBezeichnung()),
		                        "frage.png",
		                        rz.getLocale().getString("string_ja"),
		                        rz.getLocale().getString("string_nein"),
		                        this
			                );
						  	if(di != null) {
						  		rz.getDialogFactory().getDialog(di);
						  		if ((di.getReplyCode() == DialogControl.DIALOG_YES) || (di.getReplyCode() == DialogControl.DIALOG_OK)){
						  			rz.getDatabase().getDeklarationen().deleteFormBlatt(fi.getId());
						  		}
							}
            	  }
              }
    	  }
     }
     private void setSPFActions() {
         if (formblaetter != null && tblFormblatt.getSelectedRow() != -1){
             final FormBlattItem fi = formblaetter.get(tblFormblatt.getSelectedRow());
             if(fi != null) {
            	 if(fi.isActive()) {
            	  	   	getAction(ACTION_SPF_DELETE_CODE).setEnabled(false);
            	 }else {
         	  	   	getAction(ACTION_SPF_DELETE_CODE).setEnabled(true);            		 
            	 }
             }
         }
     }


    @Override
	public void openWindow(){
        if(!isVisible()) {
			setVisible(true);
		}
        toFront();
        lstListe.requestFocus();
    }

    @Override
	public void closeWindow(){
    	saveDividerLocations();
        rz.getFensterFactory().getFensterListe().disposeFrame(this);
    }

    /**
     * neu anlegen
     */
    private void neuAction() {
   		rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_DEKLARATIONS_EINGABE,false,new MessageItem(MessageItem.MSG_SHOW_DEKLARATION_EINGABE,0,null,this));
    }
    /**
     * ändern
     */
    private void editAction() {
    	if(lstListe.getSelectedIndex() != -1) {
        	final int id = liste.getItem(lstListe.getSelectedIndex()).getId();
       		rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_DEKLARATIONS_EINGABE,false,new MessageItem(MessageItem.MSG_SHOW_DEKLARATION_EINGABE,id,null,this));
        }
    }
    /**
     * löschen
     */
    private void deleteAction() {
    	if(lstListe.getSelectedIndex() != -1) {
    		if(rz.getDatabase().getDeklarationen().deleteDeklaration(liste.getItem(lstListe.getSelectedIndex()))) {
    			refreshAction();
    		}
    	}
    }
    /**
     * Actions enable/disable
     *
     */
    private void setActions() {
    	if(lstListe.getSelectedIndex() != -1) {
    		getAction(ACTION_BEARBEITEN_CODE).setEnabled(true);
    		getAction(ACTION_DELETE_CODE).setEnabled(true);
    	} else {
    		getAction(ACTION_BEARBEITEN_CODE).setEnabled(false);
    		getAction(ACTION_DELETE_CODE).setEnabled(false);
    	}
    }

    /**
     * ausgewähltes Item anzeigen
     *
     */
    private void ausgabeAction() {
    	setActions();
    	if(lstListe.getSelectedIndex() != -1) {
    		rz.getAusgabeFactory().deklarationsListenAusgabe(liste.getItem(lstListe.getSelectedIndex()).getId(),txtAnzeige);
    	} else {
    		txtAnzeige.setEditable(true);
    		txtAnzeige.setText("<html><head></head><body></body></html");
    		txtAnzeige.setEditable(false);
    	}
    }
    /**
     * Formblatt-Text speichern
     */
    private void spfSaveAction() {
    	if(formblaetter != null && tblFormblatt.getSelectedRow() != -1) {
    		rz.getDatabase().getDeklarationen().setFormBlattText(txtFormblatt.getText().trim(),formblaetter.get(tblFormblatt.getSelectedRow()).getId());
    		getAction(ACTION_SPF_SAVE_CODE).setEnabled(false);
    	}
    }

    /**
     * den Status des Speichern-Buttons setzen
     */
    private void checkSPFSaveStatus() {
    	if(!getAction(ACTION_SPF_SAVE_CODE).isEnabled()) {
    		getAction(ACTION_SPF_SAVE_CODE).setEnabled(true);
    	}
    }

    /**
     * Liste neu einlesen
     */
    private void refreshAction() {
    	liste = rz.getDatabase().getDeklarationen().getDeklarationsListe();
    	lstListe.setListData(liste.toArray());
    	if(!liste.isEmpty()) {
    		try {
    			lstListe.setSelectedIndex(0);
    		} catch(final Exception e) {}
    	}
    	formblaetter = rz.getDatabase().getDeklarationen().getFormblattListe();
    	selectActiveFormblatt();
    	ergebnisTimerEvent();
    	ausgabeAction();
    }

    private void selectActiveFormblatt() {
    	((AbstractTableModel)tblFormblatt.getModel()).fireTableDataChanged();
    	for(int i=0;i<formblaetter.size();i++) {
    		if(formblaetter.get(i).isActive()) {
    			tblFormblatt.setRowSelectionInterval(i, i);
    			break;
    		}
    	}
    }
    //Extras-Menü
    private void hideAction(){
        rz.getFensterFactory().getFensterListe().sperren(this);
    }

    //hilfe-menü
    private void hilfeAction(){
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"deklarationsliste.html",this));
    }
    
    private void settblFormblattModel(JTable t) {
    	final JCheckBox chkActive=new JCheckBox();
	    final tblFormblattColumnModel rcm = new tblFormblattColumnModel();
	    final StringRenderer sr = new StringRenderer();
	    final chkRenderer cr = new chkRenderer();
    	TableColumn tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("deklarationslistenfenster.tableheader_active"));
	    	tc.setModelIndex(C_ACTIVE);
        	tc.setCellRenderer(cr);
	    	tc.setCellEditor(new DefaultCellEditor(chkActive));
	    	rcm.addColumn(tc);
	    tc = new TableColumn();
    		tc.setHeaderValue(rz.getLocale().getString("deklarationslistenfenster.tableheader_bezeichnung"));
    		tc.setModelIndex(C_BEZEICHNUNG);
    		tc.setCellRenderer(sr);
    	rcm.addColumn(tc);



        rcm.addColumnModelListener(this);
        tblFormblatt.setModel(new formblattTableModel());
        tblFormblatt.setColumnModel(rcm);
        tblFormblatt.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
        //tblFormblatt.setCellSelectionEnabled(true);
        tblFormblatt.setShowGrid(true);
        tblFormblatt.getTableHeader().setReorderingAllowed(false);
	}
    
    private class tblFormblattColumnModel extends DefaultTableColumnModel{
	    public	tblFormblattColumnModel() {
	        super();
	    }
	}
    
	private  class formblattTableModel extends AbstractTableModel    {

        SimpleDateFormat df;

        public formblattTableModel() {
            df = new SimpleDateFormat("dd.MM.yyyy");
        }

	   public int getColumnCount() {
	       	return MAX_COLUMN;
        }
        public int getRowCount() {
        	if(liste != null) {
                return formblaetter.size();
        	} else {
        		return 0;
        	}
        }

        public FormBlattItem getZeileAt(int rowIndex) {
        	if((rowIndex != -1) && (formblaetter != null)) {
        		return formblaetter.get(rowIndex);
        	} else {
				return null;
			}
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            Object ret = null;
            if((rowIndex != -1) && (formblaetter != null)) {
               ret = getContent(formblaetter.get(rowIndex),columnIndex);
            }
            return ret;
        }

        @Override
		public boolean isCellEditable(int row, int col){
        	boolean ret = false;
        	switch(col) {
        		case C_ACTIVE:ret= true;break;
        		case C_BEZEICHNUNG:ret=true;break;
        	}
        	return ret;
        }


        @Override
		public void setValueAt(Object value, int row, int col) {
        	if (row != -1 && formblaetter != null) {
        		FormBlattItem fi = formblaetter.get(row);
        		if(fi != null) {
	        		switch (col) {
	        			case C_ACTIVE:
	        				if(!fi.isActive()) {
	        					rz.getDatabase().getDeklarationen().setActiveFormBlatt(fi.getId());
	        					formblaetter = rz.getDatabase().getDeklarationen().getFormblattListe();
	        			    	((AbstractTableModel)tblFormblatt.getModel()).fireTableDataChanged();
	        			    	selectActiveFormblatt();
	        				}
	        				break;
	        			case C_BEZEICHNUNG:
	    	        		String v = (String)value;
	        			    if (value != null && !v.trim().isEmpty()) {
	        			    	fi.setBezeichnung(v);
	        			    	rz.getDatabase().getDeklarationen().setFormBlattBezeichnung(v,fi.getId());
	        			    }
	       					break;
	       			}
	        	}
        	}
    	}

        private Object getContent(FormBlattItem vi,int aColumn) {
            Object ret = null;
            switch(aColumn){
                case C_BEZEICHNUNG: ret = vi.getBezeichnung(); break;
                case C_ACTIVE:ret=vi.isActive();break;
            }

            return ret;
        }
	}
    

    
    
	private class StringRenderer extends DefaultTableCellRenderer {

	    StringRenderer() {
	        super();
	        setOpaque(true);
	    }
	    @Override
		public Component getTableCellRendererComponent(JTable table,
                Object value, boolean isSelected, boolean hasFocus, int row,
                int column)
	    {
            this.setFont(rz.getFontFactory().getTableFont());
            if(isSelected){
                setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_SELECTED));
                setForeground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_FOREGROUND_SELECTED));
            }else {
                setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_NORMAL));
                setForeground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_FOREGROUND_NORMAL));
            }
            if(value != null) {
	        	setText(value.toString());
	         } else {
				setText("");
			}
	        setHorizontalAlignment(SwingConstants.LEADING);
	        setIcon(null);
	        return this;
        }
	}

	private class chkRenderer extends JCheckBox implements TableCellRenderer {

	    chkRenderer() {
	        super();
	        setOpaque(true);
	    }
	    public Component getTableCellRendererComponent(JTable table,
                Object value, boolean isSelected, boolean hasFocus, int row,
                int column)
	    {
	    	this.setFont(rz.getFontFactory().getTableFont());
	    	   if(isSelected){
	                setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_SELECTED));
	                setForeground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_FOREGROUND_SELECTED));
	            }else {
	                setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_NORMAL));
	                setForeground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_FOREGROUND_NORMAL));
	            }
	    	if(value != null) {
	    		this.setSelected((Boolean)value);
	    	}
	    	return this;
        }
	}
    
    
    /*------------------------------------------------------------------------
     * ListenRenderer
     *
     *------------------------------------------------------------------------
     */
    private final class DeklarationsListRenderer extends JLabel implements ListCellRenderer{
        RzPro   rz;
        public DeklarationsListRenderer(RzPro r){
            rz = r;
            setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list,Object value,int index, boolean isSelected,boolean cellHasFocus){
            final DeklarationsItem di = (DeklarationsItem)value;
            this.setFont(rz.getFontFactory().getTableFont());
            setText(di.toString());
            if(isSelected){
                setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_SELECTED));
                setForeground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_FOREGROUND_SELECTED));
            }else {
                setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_NORMAL));
                setForeground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_FOREGROUND_NORMAL));
            }
            return this;
        }
    }


	@Override
	public void columnAdded(TableColumnModelEvent e) {
	}

	@Override
	public void columnRemoved(TableColumnModelEvent e) {
	}

	@Override
	public void columnMoved(TableColumnModelEvent e) {
	}

	@Override
	public void columnMarginChanged(ChangeEvent e) {
	}

	@Override
	public void columnSelectionChanged(ListSelectionEvent e) {
	}

}
