/*
 * ConfirmDialog.java
 *
 * Created on 5. April 2004, 18:12
 */

package de.lunqual.rzpro.fenster.dialoge;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;

import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingConstants;
import javax.swing.border.BevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.database.DBDM;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fenster.TankDialog;
import de.lunqual.rzpro.items.dm.DMItem;
import de.lunqual.rzpro.items.mischungen.TicketItem;
import de.lunqual.rzpro.log.LogFactory;
import de.lunqual.rzpro.options.OptionFactory;
/**
 *
 * @author  lunqual
 */
public class DMDialog extends javax.swing.JDialog  implements TableColumnModelListener{
	
	   private static final int					MAX_COLUMN 					= 	8;
	    private static final int					C_DATUM							=	0;
	    private static final int					C_PROBENID						=	1;
	    private static final int					C_STAERKE						= 2;
	    private static final int					C_ZUCKER							= 3;
	    private static final int					C_EXTRAKT						= 4;
	    private static final int					C_FELD1							= 5;
	    private static final int					C_FELD2							= 6;
	    private static final int					C_FELD3							= 7;
	    
	    public static final int					DIALOG_OK		=	0;
	    public static final int					DIALOG_CANCEL = 1;
	    
	    public static final int					DEFAULT_DM_TAGE=-20;
	    public static final int					TANK_COLUMNS = 40;
	
    //GUI-Variablen
    private JPanel contentPanel;
     	private JLabel lblTitel;

     	private JPanel centerPanel;
     		private JPanel DMPanel;
     			private JPanel listenPanel;
     				private JLabel lblListentitel;
     				private JScrollPane scrListe;
     					private JTable tblListe;
     				private JPanel dmInfoPanel;
     					private JLabel lblDmInfoTitel;
     					private JLabel lblDmInfo;
     					private JButton btDmCancel;
    	private JPanel buttonPanel;
    		private JButton btOK;
    		private JButton btCancel;

    RzPro							rz;
	TankDialog 						td;
   ArrayList<DMItem>				liste;
   TicketItem 						ti;
    int								returnCode  = DIALOG_OK ;
    JRzFrame						parent;
    Icon							dmCancel;
    String							bemerkungen;
    ArrayList<DMItem>				dmListe;
    ArrayList<DMItem>				dmSelected;
    /** Creates new form HinweisDialog */

    public DMDialog(RzPro rz,TicketItem ti,JRzFrame parent) {
    	super(parent,true);
    	this.parent = parent;
      	dmCancel= new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/dm_cancel.png"));
      	dmSelected = new ArrayList<DMItem>();
        this.rz = rz;
        this.ti =ti;
        createGUIComponents();
        setGUIComponents();
        init();
    }

	private void createGUIComponents() {
        getContentPane().setLayout(new BorderLayout());
        addComponentListener(new java.awt.event.ComponentAdapter() {
            @Override
			public void componentShown(java.awt.event.ComponentEvent evt) {
                formComponentShown(evt);
            }
        });
        lblTitel = new JLabel();
        	lblTitel.setHorizontalAlignment(SwingConstants.CENTER);
        getContentPane().add(lblTitel,BorderLayout.NORTH);
        contentPanel = new JPanel(new BorderLayout());
        	centerPanel=new JPanel();
        		centerPanel.setLayout(new BoxLayout(centerPanel,BoxLayout.PAGE_AXIS));
        		centerPanel.setBorder(BorderFactory.createEtchedBorder());
        	
        		DMPanel = new JPanel(new BorderLayout());
	        		listenPanel = new JPanel(new BorderLayout());
					lblListentitel=new JLabel();
						lblListentitel.setHorizontalAlignment(SwingConstants.CENTER);
					listenPanel.add(lblListentitel,BorderLayout.NORTH);
					scrListe=new JScrollPane();
				       tblListe=new JTable();
						tblListe.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
						tblListe.setName("erledigenDialog.spalten");
		    			tblListe.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
		    			tblListe.setColumnSelectionAllowed(false);
		    			tblListe.setRowSelectionAllowed(true);
		    			tblListe.setGridColor(rz.getOptionFactory().getColor(OptionFactory.COLOR_VISIBLE_GRID));
		    			tblListe.setShowGrid(true);
		    			tblListe.addKeyListener(new java.awt.event.KeyAdapter() {
	        	            @Override
							public void keyReleased(java.awt.event.KeyEvent evt) {
	        	                	if(evt.getKeyCode() == KeyEvent.VK_ESCAPE) {
	        	                			saveSpalten(tblListe);
	        	                			closeCancel();
	        	                	} 
	        	            	}
	        	        	});
		    			tblListe.getSelectionModel().addListSelectionListener(new ListSelectionListener() {
		                    public void valueChanged(ListSelectionEvent e) {
		        			        if (e.getValueIsAdjusting()) {
										return;
									}
		        			    	if(rz.getDatabase().getDM().isConnected()) {
			        			        dmSelected.clear();
			        			        if(tblListe.getSelectedRow() != -1) {
			        			        	int rows[] = tblListe.getSelectedRows();
			        			        	for(int i:rows) {
			        			        		dmSelected.add(liste.get(i));
			        			        	}
			        			        	setDMInfoLabel(dmSelected);
			        			        }
		        			    	}
		                    }
			    			});
		    		   settblAuftragslisteModel(tblListe);
				       scrListe.setViewportView(tblListe);
					listenPanel.add(scrListe,BorderLayout.CENTER);
					dmInfoPanel = new JPanel(new BorderLayout());
						lblDmInfoTitel= new JLabel();
						dmInfoPanel.add(lblDmInfoTitel,BorderLayout.NORTH);
						lblDmInfo = new JLabel();
						dmInfoPanel.add(lblDmInfo,BorderLayout.CENTER);
						btDmCancel = new JButton();
						  btDmCancel.addActionListener(new ActionListener() {
				 	            public void actionPerformed(ActionEvent evt) {
				 	            	if(rz.getDatabase().getDM().isConnected()) {
					 	            	if(dmListe != null && !dmListe.isEmpty()) {
					 	            		for(DMItem di:dmListe) {
					 	            			rz.getDatabase().getDM().disconnect(di);
					 	            		}
					 	            	}
					 	            	dmSelected.clear();
		        			        	setDMInfoLabel(dmSelected);
					 	            	}
					 	            }
				 	        	});
						dmInfoPanel.add(btDmCancel,BorderLayout.EAST);
					listenPanel.add(dmInfoPanel,BorderLayout.SOUTH);
					DMPanel.add(listenPanel);
        		if(rz.getDatabase().getDM().isConnected()) {
        			DMPanel.setVisible(true);
        			centerPanel.add(DMPanel);
        		}else {
        			DMPanel.setVisible(false);
        		}
        	contentPanel.add(centerPanel,BorderLayout.SOUTH);
        	contentPanel.setBorder(BorderFactory.createBevelBorder(BevelBorder.RAISED));
        	getContentPane().add(contentPanel,BorderLayout.CENTER);
        	buttonPanel = new JPanel(new BorderLayout());
        		btOK = new JButton();
        	     btOK.addActionListener(new ActionListener() {
        	            public void actionPerformed(ActionEvent evt) {
    	                		saveSpalten(tblListe);
        	                	closeOK();
        	            	}
        	        	});
        	        btOK.addKeyListener(new java.awt.event.KeyAdapter() {
        	            @Override
						public void keyReleased(java.awt.event.KeyEvent evt) {
        	                	if(evt.getKeyCode() == KeyEvent.VK_ESCAPE) {
        	                			saveSpalten(tblListe);
        	                			closeCancel();
        	                	} else {
        	                		saveSpalten(tblListe);
        	                		closeOK();
        	                	}
        	            	}
        	        	});
        		buttonPanel.add(btOK,BorderLayout.WEST);
        
        		
        		btCancel = new JButton();
	       	     btCancel.addActionListener(new ActionListener() {
	 	            public void actionPerformed(ActionEvent evt) {
	 	            		saveSpalten(tblListe);
	 	            		closeCancel();
	 	            	}
	 	        	});
	 	        btCancel.addKeyListener(new java.awt.event.KeyAdapter() {
	 	            @Override
					public void keyReleased(java.awt.event.KeyEvent evt) {
	 	            	if(evt.getKeyCode()==KeyEvent.VK_ESCAPE) {
	 	            		saveSpalten(tblListe);
	 	            		closeCancel();
	 	            		}
	 	            	}
	 	        	});
	 	        	buttonPanel.add(btCancel,BorderLayout.EAST);
        		buttonPanel.setBorder(BorderFactory.createEtchedBorder());
        getContentPane().add(buttonPanel,BorderLayout.SOUTH);
        contentPanel.setBorder(BorderFactory.createEtchedBorder());
        setResizable(false);
    }

    
    private void setGUIComponents() {
    	this.setUndecorated(false);
    	this.setTitle(rz.getLocale().getString("DMDialog.titel"));
    	lblListentitel.setText(rz.getLocale().getString("erledigenDialog.label_dm"));
        btCancel.setText(rz.getLocale().getString("erledigenDialog.button_cancel"));
        btOK.setText(rz.getLocale().getString("erledigenDialog.button_ok"));
        lblDmInfoTitel.setText(rz.getLocale().getString("erledigenDialog.label_dm_info_titel"));
        btDmCancel.setIcon(dmCancel);
        btDmCancel.setToolTipText(rz.getLocale().getString("erledigenDialog.tooltip.dmcancel"));
        rz.getFontFactory().setFrameFonts(this);
        pack();
        final Rectangle element=this.getBounds();
        final Toolkit tk = Toolkit.getDefaultToolkit();
        final Dimension screen=tk.getScreenSize();
        element.x = (screen.width - element.width) / 2;
        element.y = (screen.height - element.height)  /2;
        this.setBounds(element);
    	getSpalten(tblListe);
    }

    private void init() {
    	bemerkungen = "";
    	if(ti != null) {
    		if(rz.getDatabase().getDM().isConnected()) {
    			int tage = rz.getOptionFactory().getOption("erledigenDialog.dm_tage", DEFAULT_DM_TAGE);
    	    	Calendar von = Calendar.getInstance();
    	    	Calendar bis = Calendar.getInstance();
    	    	von.add(Calendar.DATE, tage);
    	    	rz.roundDatumUp(bis);
    	    	liste = rz.getDatabase().getDM().getListe(DBDM.DM_UNCONNECTED, new Date(von.getTimeInMillis()),new Date(bis.getTimeInMillis()) );
    	    	Collections.reverse(liste);
    	    	if(rz.getDatabase().getDM().isConnected()) {
		        	dmListe = rz.getDatabase().getDM().getMessung(getTicketDMNummer(ti));
		        	if(dmListe.size() > 0) {
		        		setDMInfoLabel(dmListe);
		        	}
    	    	}
    		}
    	}
    	((AbstractTableModel)tblListe.getModel()).fireTableDataChanged();
    	
    }
    
    private String getTicketDMNummer(TicketItem ti1) {
    	String ret = "";
    	ret ="T"+String.valueOf(ti.getId())+":M"+String.valueOf(ti.getMischung());
    	return ret;
    }
    
    private void closeOK() {
    	if(rz.getDatabase().getDM().isConnected()) {
    		if(dmSelected != null && !dmSelected.isEmpty()) {
    			for(DMItem di:dmSelected) {
    				di.setLosnummer(getTicketDMNummer(ti));
    				di.setConnected(true);
    				rz.getDatabase().getDM().connect(di);
    			}
    		}
    	}
    	try {
    		//((de.lunqual.rzpro.fenster.buchungsfenster.HerstellungsFenster)parent).erledigenActionOK(hi);
    	}catch (Exception e) {}
    	returnCode = DIALOG_OK;
    	setVisible(false);
    }
    private void closeCancel() {
    	returnCode = DIALOG_CANCEL;
    	setVisible(false);
    }
    
    private void setDMInfoLabel(ArrayList<DMItem> l) {
    	if(l != null) {
    		String t = "<html>";
    		for(DMItem di:l) {
    			t+= di.toString() + "<br>";
    		}
    		this.lblDmInfo.setText(t + "</center>");
    	}
    }

    
    public int getReturnCode() {
    	return returnCode;
    }
 

  
    /*
     */
    public void  showDialog() {
        setVisible(true);
        this.tblListe.requestFocus();
    }

    
    public void getSpalten(JTable tbl) {
		String key = tbl.getName();
		if(!key.equals("")) {
		    final String b= rz.getOptionFactory().getOption(key);
		    if(!b.equals("")) {
		        final String breiten[] = b.split(",");
			    for (int i = 0; i < breiten.length;i++) {
			    	try {
			    		tbl.getColumnModel().getColumn(i).setPreferredWidth(Integer.parseInt(breiten[i]));
			    	}catch (Exception e) {
						rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "getSpalten:",key );
			    	}
			    }
			    tbl.validate();
		    }
		}
	}
	
	private void saveSpalten(JTable tbl) {
	    String breiten = "";
	    String key = tbl.getName();
	    if(!key.equals("")) {
		    for(int i = 0;i < tbl.getColumnCount();i++) {
		    	try {
		    		breiten += tbl.getColumnModel().getColumn(i).getWidth() + ",";
		    	}catch (Exception e) {
					rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "saveSpalten:",key );
		    	}
		    }
		    if(breiten != null && breiten.length()>0) {
		    	breiten = breiten.substring(0,breiten.length()-1);
		    }
		    rz.getOptionFactory().setOption(key,breiten);
		    rz.getOptionFactory().saveOptions();
	    }
	}
    private void formComponentShown(java.awt.event.ComponentEvent evt) {
    }
    
    private void settblAuftragslisteModel(JTable t) {
	    final ListenColumnModel rcm = new ListenColumnModel();
	    final StringRenderer sr = new StringRenderer();
	    TableColumn tc = new TableColumn();
	    tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("dmliste.tableheader_datum"));
	    	tc.setModelIndex(C_DATUM);
	    	tc.setCellRenderer(sr);
	    rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("dmliste.tableheader_proben_id"));
			tc.setModelIndex(C_PROBENID);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("dmliste.tableheader_staerke"));
			tc.setModelIndex(C_STAERKE);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("dmliste.tableheader_zucker"));
			tc.setModelIndex(C_ZUCKER);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("dmliste.tableheader_extrakt"));
			tc.setModelIndex(C_EXTRAKT);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("dmliste.tableheader_feld1"));
			tc.setModelIndex(C_FELD1);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("dmliste.tableheader_feld2"));
			tc.setModelIndex(C_FELD2);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("dmliste.tableheader_feld3"));
			tc.setModelIndex(C_FELD3);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
        rcm.addColumnModelListener(this);
        tblListe.setModel(new ListenTableModel());
        tblListe.setColumnModel(rcm);
        tblListe.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
        tblListe.getTableHeader().setReorderingAllowed(false);
	}

	private class ListenColumnModel extends DefaultTableColumnModel{
	    public ListenColumnModel() {
	        super();
	    }

	}

	private  class ListenTableModel extends AbstractTableModel    {

	        SimpleDateFormat df;

	        public ListenTableModel() {
	            df = new SimpleDateFormat("EEEE dd. MMMM yyyy HH:mm");
	        }

		   public int getColumnCount() {
		       	return MAX_COLUMN;
	        }
	        public int getRowCount() {
	        	if(liste != null) {
	                return liste.size();
	        	} else {
	        		return 0;
	        	}
	        }

        
	        public DMItem getZeileAt(int rowIndex) {
	        	if((rowIndex != -1) && (liste != null)) {
	        		return liste.get(rowIndex);
	        	} else {
					return null;
				}
	        }

	        public Object getValueAt(int rowIndex, int columnIndex) {
	            Object ret = null;
	            if((rowIndex != -1) && (liste != null)) {
	                ret = getContent(liste.get(rowIndex),columnIndex,rowIndex);
	            }
	            return ret;
	        }

	        private Object getContent(DMItem di,int aColumn,int row) {
	            Object ret = null;
	            if(di != null) {
		            switch(aColumn){
		            	case C_STAERKE: ret = di.getStaerke();
		            		break;
		            	case C_DATUM:ret = df.format(di.getDatum_zeit());
		            		break;
		            	case C_PROBENID:ret = di.getProben_id();
		            		break;
		            	case C_ZUCKER:ret = di.getZucker();
		            		break;
		            	case C_EXTRAKT:ret = di.getExtrakt();
		            		break;
		            	case C_FELD1: ret = di.getFeld1();
		            		break;
		            	case C_FELD2: ret = di.getFeld2();
		            		break;
		            	case C_FELD3: ret = di.getFeld3();
		            		break;
		            }
	            }
	            return ret;
	        }
		}


	
	/** rendert alle Tabellenzeilen mit String Inhalt
	 *  im wesentlichen heisst das rechts-ausgerichtent
	 * @author lunqual
	 */
	private class StringRenderer extends DefaultTableCellRenderer {
		
		Icon verlauf,zuweisen;
		
	    StringRenderer() {
	        super();
            verlauf = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/dmlistenfenster.icon_verlauf.png"));
            zuweisen = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/dmlistenfenster.icon_zuweisen.png"));
	        setOpaque(true);
	    }
	    public Component getTableCellRendererComponent(JTable table,
                Object value, boolean isSelected, boolean hasFocus, int row,
                int column)
	    {
    		if(!isSelected) {
    			setFont(rz.getFontFactory().getTableFont());
    			setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_NORMAL));
    		}else {
    			setFont(rz.getFontFactory().getTableBoldFont());
    			  setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_SELECTED));
    		}
    		setText((String)value);
	        setHorizontalAlignment(SwingConstants.LEADING);
	        return this;
        }
	}



	@Override
	public void columnAdded(TableColumnModelEvent e) {
		// TODO Auto-generated method stub
		
	}


	@Override
	public void columnRemoved(TableColumnModelEvent e) {
		// TODO Auto-generated method stub
		
	}


	@Override
	public void columnMoved(TableColumnModelEvent e) {
		// TODO Auto-generated method stub
		
	}


	@Override
	public void columnMarginChanged(ChangeEvent e) {
		// TODO Auto-generated method stub
		
	}


	@Override
	public void columnSelectionChanged(ListSelectionEvent e) {
		// TODO Auto-generated method stub
		
	}
    
}
