package de.lunqual.rzpro.fenster.dialoge;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.KeyEvent;

import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingConstants;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.ausgabe.ReportFactory;
import de.lunqual.rzpro.items.deklarationen.FormBlattItem;
import de.lunqual.rzpro.items.rechnen.RechenItem;
import de.lunqual.rzpro.items.report.ReportItem;
import de.lunqual.rzpro.items.rezeptur.SPFormblattItem;
import de.lunqual.rzpro.options.OptionFactory;

public class DruckFormularDialog extends JDialog {
	
	private static final int MIN_WIDTH=600;
	private static final int	MIN_HEIGHT=140;
	RzPro			rz;
	SPFormblattItem	spf;
	JFrame			parent;
	RechenItem	ri;
	boolean 		pdf;
	
	
	JPanel			contentPanel;
		JPanel			cmbPanel;
			JPanel			spezifikationPanel;
				JLabel		lblSpezifikation;
				JComboBox 	cmbSpezifikation;
		JPanel centerPanel;
			JLabel lblCenter;
			JPanel			deckblattPanel;
				JLabel			lblDeckblatt;
				JComboBox 	cmbDeckblatt;
		JPanel formblattPanel;
			JLabel			lblFormblatt;
			JComboBox	cmbFormblatt;
			
	JPanel			buttonPanel;
		JButton 		btOK;
		JButton 		btCancel;
	
	
	public DruckFormularDialog(RzPro rz,SPFormblattItem spf,RechenItem ri,boolean pdf,JFrame parent) {
		super(parent,true);
		this.setModal(true);
		this.rz = rz;
		this.spf=spf;
		this.ri=ri;
		this.parent=parent;
		this.pdf = pdf;
        createGUIComponents();
        setGUIComponents();
	}
	
	private void createGUIComponents() {
        getContentPane().setLayout(new BorderLayout());
        addComponentListener(new java.awt.event.ComponentAdapter() {
            @Override
			public void componentShown(java.awt.event.ComponentEvent evt) {
                formComponentShown(evt);
            }
        });
        
        contentPanel=new JPanel(new BorderLayout());
        	lblCenter = new JLabel();
        		lblCenter.setHorizontalAlignment(SwingConstants.CENTER);
        		lblCenter.setBorder(BorderFactory.createEtchedBorder());
        		contentPanel.add(lblCenter,BorderLayout.NORTH);
        	cmbPanel=new JPanel();
                cmbPanel.setLayout(new BoxLayout(cmbPanel,BoxLayout.PAGE_AXIS));
        		spezifikationPanel=new JPanel(new BorderLayout());
	        		lblSpezifikation=new JLabel();
	        		spezifikationPanel.add(lblSpezifikation,BorderLayout.WEST);
	        		cmbSpezifikation=new JComboBox();
		 	        cmbSpezifikation.addKeyListener(new keys());
	        		spezifikationPanel.add(cmbSpezifikation,BorderLayout.CENTER);
        	cmbPanel.add(spezifikationPanel,BorderLayout.NORTH);
        	
	        	deckblattPanel=new JPanel(new BorderLayout());
	    			lblDeckblatt=new JLabel();
	    			deckblattPanel.add(lblDeckblatt,BorderLayout.WEST);
	    			cmbDeckblatt=new JComboBox();
	    			cmbDeckblatt.addKeyListener(new keys());
	    			deckblattPanel.add(cmbDeckblatt,BorderLayout.CENTER);
	        cmbPanel.add(deckblattPanel,BorderLayout.SOUTH);
	             formblattPanel = new JPanel(new BorderLayout());
	             	lblFormblatt = new JLabel();
	             	    formblattPanel.add(lblFormblatt,BorderLayout.WEST);
	             	cmbFormblatt = new JComboBox();
	                     formblattPanel.add(cmbFormblatt,BorderLayout.CENTER);
	             cmbPanel.add(formblattPanel);
        contentPanel.add(cmbPanel,BorderLayout.CENTER);
        buttonPanel=new JPanel(new BorderLayout());
        	btOK=new JButton();
        		btOK.addKeyListener(new keys());
	            btOK.addActionListener(new java.awt.event.ActionListener() {
	                public void actionPerformed(java.awt.event.ActionEvent evt) {
	                	print();
	                	setVisible(false);
	                	}
	            	});
        	buttonPanel.add(btOK,BorderLayout.WEST);
        	btCancel = new JButton();
            btCancel.addActionListener(new java.awt.event.ActionListener() {
                public void actionPerformed(java.awt.event.ActionEvent evt) {
                	setVisible(false);
                	}
            	});
            btCancel.addKeyListener(new keys());
        	buttonPanel.add(btCancel,BorderLayout.EAST);
    	 	buttonPanel.setBorder(BorderFactory.createEtchedBorder());
    	 	cmbPanel.setBorder(BorderFactory.createEtchedBorder());
	 	contentPanel.add(buttonPanel,BorderLayout.SOUTH);
	 	contentPanel.setBorder(BorderFactory.createEtchedBorder());
	 	getContentPane().add(contentPanel,BorderLayout.CENTER);
        rz.getFontFactory().setFrameFonts(this);
	 	setResizable(true);
	 	setMinimumSize(new Dimension(MIN_WIDTH,MIN_HEIGHT));
    	this.setUndecorated(true);

	 	pack();
    	int x;
    	int y;
    	Point topLeft = parent.getLocationOnScreen();
    	  Dimension parentSize = parent.getSize();

    	  Dimension mySize = getSize();

    	  if (parentSize.width > mySize.width) 
    	    x = ((parentSize.width - mySize.width)/2) + topLeft.x;
    	  else 
    	    x = topLeft.x;
    	   
    	  if (parentSize.height > mySize.height) 
    	    y = ((parentSize.height - mySize.height)/2) + topLeft.y;
    	  else 
    	    y = topLeft.y;
    	   
    	  setLocation (x, y);
	}
	
	private void setGUIComponents() {
		this.setTitle(rz.getLocale().getString("spezifikationDialog.title"));
		this.lblSpezifikation.setText(rz.getLocale().getString("spezifikationDialog.label_spezifikation"));
		this.lblDeckblatt.setText(rz.getLocale().getString("spezifikationDialog.label_deckblatt"));
		this.lblFormblatt.setText(rz.getLocale().getString("spezifikationDialog.label_formblatt"));
		if(pdf) {
			this.btOK.setText(rz.getLocale().getString("spezifikationDialog.btOKPDF"));
		}else {
			this.btOK.setText(rz.getLocale().getString("spezifikationDialog.btOK"));
		}
		this.btCancel.setText(rz.getLocale().getString("spezifikationDialog.btCancel"));
		this.lblCenter.setText(rz.getLocale().getString("spezifikationDialog.label_center"));
		rz.getDatabase().getReport().dbGetReportListeCombo(cmbDeckblatt,ReportFactory.REPORT_TYPE_SPEZIFIKATION_FORMBLATT);
		rz.getDatabase().getReport().dbGetReportListeCombo(cmbSpezifikation,ReportFactory.REPORT_TYPE_RECHNEN);
		rz.getDatabase().getReport().setComboSelection(cmbDeckblatt,rz.getOptionFactory().getOption("auswahl.formular_deckblatt_spezifikation",OptionFactory.AUSWAHL_FORMULAR_DECKBLATT_SPEZIFIKATION));
		rz.getDatabase().getReport().setComboSelection(cmbSpezifikation,rz.getOptionFactory().getOption("auswahl.formular_spezifikation",OptionFactory.AUSWAHL_FORMULAR_KALKULATION));
		cmbFormblatt.setModel(new DefaultComboBoxModel(rz.getDatabase().getDeklarationen().getFormblattListe().toArray()));
		for(int i=0;i<cmbFormblatt.getModel().getSize();i++) {
			FormBlattItem fi = (FormBlattItem)cmbFormblatt.getModel().getElementAt(i);
			if(fi != null && fi.isActive()) {
				cmbFormblatt.setSelectedIndex(i);
				break;
			}
		}
	}
	
	public void showDialog() {
		setVisible(true);
	}
	
    private void formComponentShown(java.awt.event.ComponentEvent evt) {
        btOK.requestFocus();
    }
    
    private void print() {
    	setVisible(false);
		FormBlattItem fi = (FormBlattItem)cmbFormblatt.getSelectedItem();
		if(fi != null) {
			spf.setText(rz.getDatabase().getDeklarationen().getFormBlattText(fi.getId()));
		}
        rz.getOptionFactory().setOption("auswahl.formular_spezifikation",((ReportItem)cmbSpezifikation.getSelectedItem()).getID());
        rz.getOptionFactory().setOption("auswahl.formular_deckblatt_spezifikation",((ReportItem)cmbDeckblatt.getSelectedItem()).getID());
        rz.getOptionFactory().saveOptions();
        if (pdf) {
			rz.getReportFactory().SPFormblattReportPDF(spf,ri,this,ri.getRezeptur().getTitel());
			rz.getReportFactory().rechenAuswahlReportPDF(ri,this,"auswahl.formular_spezifikation",ri.getRezeptur().getTitel());
        } else {
        	rz.getReportFactory().SPFormblattReport(spf,ri,this);
        	rz.getReportFactory().rechenAuswahlReport(ri,this,"auswahl.formular_spezifikation");
        }
    }

    public class keys extends java.awt.event.KeyAdapter {
         @Override
			public void keyReleased(java.awt.event.KeyEvent evt) {
          	switch(evt.getKeyCode()) {
          		case KeyEvent.VK_ENTER:
          			print();
          			setVisible(false);
          			break;
          		case KeyEvent.VK_ESCAPE:
          			setVisible(false);
          			break;
          	}
          	}
      	}
    
}
