package de.lunqual.rzpro.fenster.dialoge;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.KeyEvent;

import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingConstants;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.fenster.JSelectedTextField;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.items.formulare.FormularTypItem;

public class FormularDialog extends JDialog {
	
	private static final int 	MIN_WIDTH=600;
	private static final int	MIN_HEIGHT=140;
	
	RzPro						rz;
	JFrame						parent;
	
	JPanel						contentPanel;
		JLabel						lblFormularTitel;
		JPanel						datenPanel;
			JPanel						datenTitelPanel;
				JLabel						lblTitel;
				JSelectedTextField			txtTitel;
			JPanel 						datenComboPanel;
				JLabel						lblTyp;
				JComboBox					cmbTypen;
	JPanel						buttonPanel;
		JButton						btOK;
		JButton 					btCancel;
	
	String						formularTitel;
	boolean						ok = false;
	
	public FormularDialog(RzPro rz,JFrame parent) {
		super(parent,true);
		this.setModal(true);
		this.rz = rz;
		this.parent=parent;
		this.formularTitel = rz.getLocale().getString("formularDialog.neu");
        createGUIComponents();
        setGUIComponents();
	}
	
	
	public String getFormularTitel() {
		return formularTitel;
	}


	public FormularTypItem getFormularTyp() {
		if(cmbTypen.getSelectedIndex() != -1) {
			return (FormularTypItem)cmbTypen.getSelectedItem();
		} else {
			return null;
		}
	}

	public boolean isOK() {
		return ok;
	}

	private void createGUIComponents() {
        getContentPane().setLayout(new BorderLayout());
        addComponentListener(new java.awt.event.ComponentAdapter() {
            @Override
			public void componentShown(java.awt.event.ComponentEvent evt) {
                formComponentShown(evt);
            }
        });
        
        contentPanel=new JPanel(new BorderLayout());
        	
        datenPanel = new JPanel(new BorderLayout());
        	lblFormularTitel = new JLabel();
        	lblFormularTitel.setHorizontalAlignment(SwingConstants.CENTER);
        	datenPanel.add(lblFormularTitel,BorderLayout.NORTH);
			datenTitelPanel = new JPanel(new BorderLayout());
					lblTitel = new JLabel();
					lblTitel.setHorizontalAlignment(SwingConstants.TRAILING);
					datenTitelPanel.add(lblTitel,BorderLayout.WEST);
					txtTitel = new JSelectedTextField();
					txtTitel.addKeyListener(new keys());
					datenTitelPanel.add(txtTitel,BorderLayout.CENTER);
			datenPanel.add(datenTitelPanel,BorderLayout.NORTH);
			datenComboPanel = new JPanel(new BorderLayout());
				lblTyp = new JLabel();
				lblTyp.setHorizontalAlignment(SwingConstants.TRAILING);
				datenComboPanel.add(lblTyp,BorderLayout.WEST);
				cmbTypen = new JComboBox();
					cmbTypen.setModel(new DefaultComboBoxModel(rz.getReportFactory().getReportTypes().toArray()));
					cmbTypen.addKeyListener(new keys());
				datenComboPanel.add(cmbTypen,BorderLayout.CENTER);
			datenPanel.add(datenComboPanel,BorderLayout.SOUTH);
       
      
        buttonPanel=new JPanel(new BorderLayout());
	    	btOK = new JButton();
	        btOK.addActionListener(new java.awt.event.ActionListener() {
	            public void actionPerformed(java.awt.event.ActionEvent evt) {
	            	checkOK();
	            	}
	        	});
	        btOK.addKeyListener(new keys());
	        buttonPanel.add(btOK,BorderLayout.WEST);
        	btCancel = new JButton();
            btCancel.addActionListener(new java.awt.event.ActionListener() {
                public void actionPerformed(java.awt.event.ActionEvent evt) {
                	setVisible(false);
                	}
            	});
            btCancel.addKeyListener(new keys());
        	buttonPanel.add(btCancel,BorderLayout.EAST);
    	 	buttonPanel.setBorder(BorderFactory.createEtchedBorder());
    	contentPanel.add(datenPanel,BorderLayout.NORTH);
	 	contentPanel.add(buttonPanel,BorderLayout.SOUTH);
	 	contentPanel.setBorder(BorderFactory.createEtchedBorder());
	 	getContentPane().add(contentPanel,BorderLayout.CENTER);
        rz.getFontFactory().setFrameFonts(this);
	 	setResizable(true);
	 	setMinimumSize(new Dimension(MIN_WIDTH,MIN_HEIGHT));
    	this.setUndecorated(true);

	 	pack();
    	int x;
    	int y;
    	Point topLeft = parent.getLocationOnScreen();
    	  Dimension parentSize = parent.getSize();

    	  Dimension mySize = getSize();

    	  if (parentSize.width > mySize.width) 
    	    x = ((parentSize.width - mySize.width)/2) + topLeft.x;
    	  else 
    	    x = topLeft.x;
    	   
    	  if (parentSize.height > mySize.height) 
    	    y = ((parentSize.height - mySize.height)/2) + topLeft.y;
    	  else 
    	    y = topLeft.y;
    	   
    	  setLocation (x, y);
	}
	
	private void setGUIComponents() {
		setTitle(rz.getLocale().getString("formularDialog.titel"));
		btOK.setText(rz.getLocale().getString("formularDialog.btOK"));
		btCancel.setText(rz.getLocale().getString("formularDialog.btCancel"));
		lblTitel.setText(rz.getLocale().getString("formularDialog.label_titel"));
		lblTyp.setText(rz.getLocale().getString("formularDialog.label_typ"));
		txtTitel.setText(rz.getLocale().getString("formularDialog.neu"));
		lblFormularTitel.setText(rz.getLocale().getString("formularDialog.titel"));
		
	}
	
	public void showDialog() {
		setVisible(true);
	}
	
	
	private void refresh() {
		
		
	}
	
    private void formComponentShown(java.awt.event.ComponentEvent evt) {
    	refresh();
    }
    
    private void checkOK() {
    	formularTitel = txtTitel.getText().trim();
    	if(!formularTitel.equals("")) {
		    	if(rz.getDatabase().getReport().dbGetReport(formularTitel) == null) {
		    		ok=true;
		    		setVisible(false);
		    	} else {
		            DialogItem dlgItem = new DialogItem(0,"",0.0,"","","","","","",null);
	    	        		dlgItem.setTyp(DialogControl.HINWEIS_DIALOG);
	                dlgItem.setCaption(rz.getLocale().getString("formulardialog.name"));
	                dlgItem.setTitel(rz.getLocale().getString("formulardialog.name"));
	                dlgItem.setMessage(rz.getLocale().getString("formulardialog.name_message").replaceAll("%n", formularTitel));
	                dlgItem.setIcon("warnung.png");
	                dlgItem.setOk(rz.getLocale().getString("string_ok"));
	               rz.getDialogFactory().getDialog(dlgItem);
		    	}
    	}
    }

    public class keys extends java.awt.event.KeyAdapter {
         @Override
			public void keyReleased(java.awt.event.KeyEvent evt) {
          	switch(evt.getKeyCode()) {
          		case KeyEvent.VK_ENTER:
          			checkOK();
          			break;
          		case KeyEvent.VK_ESCAPE:
          			setVisible(false);
          			break;
          	}
          	}
      	}
    
}
