/*
 * Created on 07.09.2004
 *
 * Window - Preferences - Java - Code Style - Code Templates
 */
package de.lunqual.rzpro.fenster.dialoge;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.Date;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.SwingConstants;
import javax.swing.border.BevelBorder;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.fenster.JSelectedTextField;
import de.lunqual.rzpro.items.bewertungen.BewertungsItem;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.items.mischungen.TicketItem;

/**
 * @author labor
 *
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class KontrollDialog extends JDialog {
    //GUI-Variablen
    private JPanel contentPanel;
     	private JLabel lblTitel;
    	private JPanel mainPanel;
    		private JPanel userPanel;
    			private JLabel lblUser;
    			private JSelectedTextField txtUser;
    		private JPanel pwPanel;
    			private JLabel lblPW;
    			private JPasswordField txtPW;
    	private JPanel buttonPanel;
    		private JButton btOK;
    		private JButton btCancel;

    RzPro			rz;
    TicketItem	ti;
    BewertungsItem bi;
    
    public KontrollDialog(RzPro r,BewertungsItem bi) {
        super();
        rz = r;
        this.ti = null;
        this.bi = bi;
        this.setModal(true);
        createGUIComponents();
        setGUIComponents();
    }
    
    public KontrollDialog(RzPro r,TicketItem ti) {
        super();
        rz = r;
        this.ti = ti;
        this.bi =null;
        this.setModal(true);
        createGUIComponents();
        setGUIComponents();
    }


    private void createGUIComponents() {
        getContentPane().setLayout(new BorderLayout());
        addComponentListener(new java.awt.event.ComponentAdapter() {
            @Override
			public void componentShown(java.awt.event.ComponentEvent evt) {
                formComponentShown(evt);
            }
        });
        lblTitel = new JLabel();
	    	lblTitel.setForeground(Color.WHITE);
	    	lblTitel.setBackground(Color.BLUE);
	    	lblTitel.setOpaque(true);
        	lblTitel.setHorizontalAlignment(SwingConstants.CENTER);
        getContentPane().add(lblTitel,BorderLayout.NORTH);
        contentPanel = new JPanel(new BorderLayout());
        	mainPanel = new JPanel(new GridLayout(2,1));
        		userPanel = new JPanel(new BorderLayout());
        			lblUser = new JLabel();
        			lblUser.setHorizontalAlignment(SwingConstants.TRAILING);
        			txtUser = new JSelectedTextField();
        			txtUser.setColumns(30);
        			txtUser.addKeyListener(new java.awt.event.KeyAdapter() {
        	            @Override
						public void keyReleased(java.awt.event.KeyEvent evt) {
        	                	if(evt.getKeyCode() == KeyEvent.VK_ESCAPE) {
        	                		setVisible(false);
        	                	} else if (evt.getKeyCode() == KeyEvent.VK_ENTER) {
        	                		checkOK();
        	                	}
        	            	}
        	        	});
        			userPanel.add(txtUser,BorderLayout.CENTER);
        			userPanel.add(lblUser,BorderLayout.WEST);
        		mainPanel.add(userPanel);
        		pwPanel = new JPanel(new BorderLayout());
        			lblPW = new JLabel();
        			lblPW.setHorizontalAlignment(SwingConstants.TRAILING);
        			pwPanel.add(lblPW,BorderLayout.WEST);
        			txtPW = new JPasswordField();
        			txtPW.setColumns(30);
        			txtPW.addKeyListener(new java.awt.event.KeyAdapter() {
        	            @Override
						public void keyReleased(java.awt.event.KeyEvent evt) {
        	                	if(evt.getKeyCode() == KeyEvent.VK_ESCAPE) {
        	                		setVisible(false);
        	                	} else if (evt.getKeyCode() == KeyEvent.VK_ENTER) {
        	                		checkOK();
        	                	}
        	            	}
        	        	});
        			pwPanel.add(txtPW,BorderLayout.CENTER);
        		mainPanel.add(pwPanel);
        		mainPanel.setBorder(BorderFactory.createEtchedBorder());
        	contentPanel.add(mainPanel,BorderLayout.CENTER);
        	contentPanel.setBorder(BorderFactory.createBevelBorder(BevelBorder.RAISED));
        getContentPane().add(contentPanel,BorderLayout.CENTER);
        	buttonPanel = new JPanel(new BorderLayout());
        		btOK = new JButton();
        	     btOK.addActionListener(new ActionListener() {
        	            public void actionPerformed(ActionEvent evt) {
        	            		checkOK();
        	            	}
        	        	});
        	        btOK.addKeyListener(new java.awt.event.KeyAdapter() {
        	            @Override
						public void keyReleased(java.awt.event.KeyEvent evt) {
        	                	if(evt.getKeyCode() == KeyEvent.VK_ESCAPE) {
        	                	} else {
        	                	}
        	                	checkOK();
        	            	}
        	        	});
        		buttonPanel.add(btOK,BorderLayout.WEST);
        		btCancel = new JButton();
	       	     btCancel.addActionListener(new ActionListener() {
	 	            public void actionPerformed(ActionEvent evt) {
	 	                	setVisible(false);
	 	            	}
	 	        	});
	 	        btCancel.addKeyListener(new java.awt.event.KeyAdapter() {
	 	            @Override
					public void keyReleased(java.awt.event.KeyEvent evt) {
	 	                	setVisible(false);
	 	            	}
	 	        	});
	 	       buttonPanel.setBorder(BorderFactory.createEtchedBorder());
        		buttonPanel.add(btCancel,BorderLayout.EAST);
        getContentPane().add(buttonPanel,BorderLayout.SOUTH);
        setResizable(false);
    }

    private void setGUIComponents() {
    	this.setUndecorated(true);
        setTitle(rz.getLocale().getString("kontrolldialog.titel"));
        lblTitel.setText(rz.getLocale().getString("kontrolldialog.titel"));
        lblUser.setText(rz.getLocale().getString("kontrolldialog.label_user"));
        lblPW.setText(rz.getLocale().getString("kontrolldialog.label_pw"));
        btOK.setText(rz.getLocale().getString("string_ok"));
        btCancel.setText(rz.getLocale().getString("string_abbrechen"));
        rz.getFontFactory().setFrameFonts(this);
        pack();
            final Rectangle element=this.getBounds();
            final Toolkit tk = Toolkit.getDefaultToolkit();
            final Dimension screen=tk.getScreenSize();
            element.x = (screen.width - element.width) / 2;
            element.y = (screen.height - element.height)  /2;
            this.setBounds(element);
    }

    private void checkOK() {
		DialogItem di;
    	String user = txtUser.getText().trim();
    	if(user.equals("")) {
    			di = new DialogItem(
                       DialogControl.HINWEIS_DIALOG,
                       "",0.0,
                       rz.getLocale().getString("kontrolldialog.error"),
                       rz.getLocale().getString("kontrolldialog.error"),
                       rz.getLocale().getString("kontrolldialog.error_no_user"),
                       "warnung.png",
                       rz.getLocale().getString("string_ok"),
                       "",
                       null
               );
               rz.getDialogFactory().getDialog(di);
    	} else {
    		if (user.equals(rz.getDatabase().dbGetUser())){
    			di = new DialogItem(
                        DialogControl.HINWEIS_DIALOG,
                        "",0.0,
                        rz.getLocale().getString("kontrolldialog.error"),
                        rz.getLocale().getString("kontrolldialog.error"),
                        rz.getLocale().getString("kontrolldialog.error_same_user"),
                        "warnung.png",
                        rz.getLocale().getString("string_ok"),
                        "",
                        null
                );
                rz.getDialogFactory().getDialog(di);
    		} else {
    			 if (rz.getDatabase().dbTryLogin(rz.getOptionFactory().getOption("database.driver"),
                         rz.getOptionFactory().getOption("database.url"),
                         txtUser.getText().trim(),
                         new String(txtPW.getPassword()),
                         rz.getOptionFactory().getOption("database.parameter")
    					 )){
    				 if(ti!=null) {
    					 ti.setKontrolle(txtUser.getText());
    					 ti.setKontrolle_datum(new Date());
    				 } else {
        				 bi.setKontrolle(txtUser.getText());
        				 bi.setKontrolle_datum(new Date());
    				 }
    				 rz.getOptionFactory().setOption("kontrolldialog.user", txtUser.getText());
    				 rz.getOptionFactory().saveOptions();
    				 setVisible(false);
    			 }else {
    				 di = new DialogItem(
    	                        DialogControl.HINWEIS_DIALOG,
    	                        "",0.0,
    	                        rz.getLocale().getString("kontrolldialog.error"),
    	                        rz.getLocale().getString("kontrolldialog.error"),
    	                        rz.getLocale().getString("kontrolldialog.error_db"),
    	                        "warnung.png",
    	                        rz.getLocale().getString("string_ok"),
    	                        "",
    	                        null
    	                );
    	                rz.getDialogFactory().getDialog(di);
    			 }
    		}
    	}
    }
    
    
    /** den Dialog anzeigen
     *
     */
    public void  showDialog() {
        setVisible(true);
    }

    private void formComponentShown(java.awt.event.ComponentEvent evt) {
        String u =rz.getOptionFactory().getOption("kontrolldialog.user");
        if(!u.equals("")) {
        	txtUser.setText(rz.getOptionFactory().getOption("kontrolldialog.user"));
        	txtPW.requestFocus();
        }else {
        	txtUser.requestFocus();
        }
    }

}
