package de.lunqual.rzpro.fenster.dialoge;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.text.SimpleDateFormat;
import java.util.Date;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingConstants;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.database.ItemNotFoundException;
import de.lunqual.rzpro.fenster.rzDatePicker.RzSimpleDatePicker;
import de.lunqual.rzpro.fenster.rzDatePicker.pickerDateListener;
import de.lunqual.rzpro.items.buchung.SaldenItem;
import de.lunqual.rzpro.options.OptionFactory;

public class StichtagDialog extends JDialog {
	
	private static final int MIN_WIDTH=600;
	private static final int	MIN_HEIGHT=140;
	
    public static final String 			CALENDAR_FORMAT		=	"d. MMMMMM yyyy";
	
	RzPro						rz;
	JFrame						parent;
	int							id;
	String						strRezeptur;
	SimpleDateFormat 	df;
	
	JPanel			contentPanel;
		JPanel 			northPanel;
			JLabel				lblRezeptur;
			RzSimpleDatePicker	datum;
		JPanel		ausgabePanel;
			JLabel		lblAusgabe;
	JPanel			buttonPanel;
		JButton 		btCancel;
	
	public StichtagDialog(RzPro rz,JFrame parent,int id) {
		super(parent,true);
		strRezeptur="";
        df = new SimpleDateFormat("EEEE, dd. MMMM yyyy");
		this.setModal(true);
		this.rz = rz;
		this.id=id;
		this.parent=parent;
        createGUIComponents();
        setGUIComponents();
	}
	
	public void setStrRezeptur(String rezeptur) {
		strRezeptur=rezeptur;
	}
	
	private void createGUIComponents() {
        getContentPane().setLayout(new BorderLayout());
        addComponentListener(new java.awt.event.ComponentAdapter() {
            @Override
			public void componentShown(java.awt.event.ComponentEvent evt) {
                formComponentShown(evt);
            }
        });
        
        contentPanel=new JPanel(new BorderLayout());
        	
        northPanel =new JPanel(new BorderLayout());
        	lblRezeptur=new JLabel();
        	lblRezeptur.setHorizontalAlignment(SwingConstants.CENTER);
        	northPanel.add(lblRezeptur,BorderLayout.NORTH);
        	datum=new RzSimpleDatePicker(rz);
	    		datum.addListener(new pickerDateListener() {
					@Override
					public void dateChanged(Date datum) {
						 refresh();
					}
	    		});

        	northPanel.add(datum,BorderLayout.CENTER);
        contentPanel.add(northPanel,BorderLayout.NORTH);
        ausgabePanel=new JPanel(new BorderLayout());
        	lblAusgabe=new JLabel();
        	lblAusgabe.setHorizontalAlignment(SwingConstants.CENTER);
        	ausgabePanel.add(lblAusgabe,BorderLayout.CENTER);
        contentPanel.add(ausgabePanel,BorderLayout.CENTER);
        buttonPanel=new JPanel(new BorderLayout());
        	btCancel = new JButton();
            btCancel.addActionListener(new java.awt.event.ActionListener() {
                public void actionPerformed(java.awt.event.ActionEvent evt) {
                	setVisible(false);
                	}
            	});
            btCancel.addKeyListener(new keys());
        	buttonPanel.add(btCancel,BorderLayout.CENTER);
    	 	buttonPanel.setBorder(BorderFactory.createEtchedBorder());
	 	contentPanel.add(buttonPanel,BorderLayout.SOUTH);
	 	contentPanel.setBorder(BorderFactory.createEtchedBorder());
	 	getContentPane().add(contentPanel,BorderLayout.CENTER);
        rz.getFontFactory().setFrameFonts(this);
	 	setResizable(true);
	 	setMinimumSize(new Dimension(MIN_WIDTH,MIN_HEIGHT));
    	this.setUndecorated(true);

	 	pack();
    	int x;
    	int y;
    	Point topLeft = parent.getLocationOnScreen();
    	  Dimension parentSize = parent.getSize();

    	  Dimension mySize = getSize();

    	  if (parentSize.width > mySize.width) 
    	    x = ((parentSize.width - mySize.width)/2) + topLeft.x;
    	  else 
    	    x = topLeft.x;
    	   
    	  if (parentSize.height > mySize.height) 
    	    y = ((parentSize.height - mySize.height)/2) + topLeft.y;
    	  else 
    	    y = topLeft.y;
    	   
    	  setLocation (x, y);
	}
	
	private void setGUIComponents() {
		this.setTitle(rz.getLocale().getString("stichtagDialog.title"));
		try {
			this.lblRezeptur.setText(rz.getLocale().getString("stichtagDialog.rezeptur").replaceAll("%s",rz.getDatabase().getRezeptur().dbGetRezepturName(id))
					.replaceAll("%d", df.format(datum.getDate())));
		}catch (ItemNotFoundException e) {}
		this.btCancel.setText(rz.getLocale().getString("stichtagDialog.btCancel"));
	}
	
	public void showDialog() {
		setVisible(true);
	}
	
	
	private void refresh() {
    	final SaldenItem s = rz.getDatabase().getRezeptur().getBestandStichtag(id,datum.getCalendar());
			lblAusgabe.setText("<html>" +
				rz.getLocale().getString("ausgabe.bestand_detail")
					.replaceAll("%l",rz.getLocale().formatNumber(s.getLiter(), OptionFactory.NF_NORMAL)  )
					.replaceAll("%k",rz.getLocale().formatNumber(s.getKg(), OptionFactory.NF_NORMAL)  )
					.replaceAll("%a",rz.getLocale().formatNumber(s.getLa(), OptionFactory.NF_NORMAL)  )
				+ "</html>");
		
	}
    private void formComponentShown(java.awt.event.ComponentEvent evt) {
    	refresh();
    }
    
    private void print() {
    	setVisible(false);
    }

    public class keys extends java.awt.event.KeyAdapter {
         @Override
			public void keyReleased(java.awt.event.KeyEvent evt) {
          	switch(evt.getKeyCode()) {
          		case KeyEvent.VK_ENTER:
          			setVisible(false);
          			break;
          		case KeyEvent.VK_ESCAPE:
          			setVisible(false);
          			break;
          	}
          	}
      	}
    
}
