/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */


package de.lunqual.rzpro.fenster.dm;


import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.SwingConstants;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.ausgabe.ReportFactory;
import de.lunqual.rzpro.database.DBDM;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fenster.JSelectedTextField;
import de.lunqual.rzpro.fenster.LosnummerDialog;
import de.lunqual.rzpro.fenster.TicketDialog;
import de.lunqual.rzpro.fenster.dialoge.DialogControl;
import de.lunqual.rzpro.fenster.rzDatePicker.PickerDualDateListener;
import de.lunqual.rzpro.fenster.rzDatePicker.RzDualDatePicker;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.buchung.BuchungLosnummerItem;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.items.dm.DMItem;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.mischungen.TicketAuswahlItem;
import de.lunqual.rzpro.items.report.ReportItem;
import de.lunqual.rzpro.options.OptionFactory;
/**
 *
 * @author  lunqual
 */
public class DMListenFenster extends JRzFrame  implements TableColumnModelListener{

    //GUI-Variablen
    private JMenuBar mb;
    private JMenu mnuDatei;
    private JMenu mnuBearbeiten;
    private JMenu mnuExtras;
    private JMenu mnuFenster;
    private JMenu mnuHilfe;
    private JPanel mainPanel;
    
    private JPanel datumPanel;
		private JPanel boxPanel;
				private JPanel pickerPanel;
					private RzDualDatePicker picker;
    	private JPanel toolbarPanel;
    		private JToolBar tb1;
    	private JPanel contentPanel;
    		private JPanel auswahlPanel;
    			private JPanel auswahlGroupPanel;
					private ButtonGroup auswahlGroup;
						private JRadioButton btAuswahlAlle;
						private JRadioButton btAuswahlConnected;
						private JRadioButton btAuswahlUnConnected;
						
				private JPanel auswahlTextPanel;
					private JPanel bezeichnungPanel;
						private JLabel lblBezeichnung;
						private JSelectedTextField txtBezeichnung;
					private JPanel losnummerPanel;
						private JLabel lblLosnummer;
						private JSelectedTextField txtLosnummer;
				private JPanel refreshPanel;
					private JButton btRefresh;
    		private JSplitPane splCenter;
	    		private JPanel listenPanel;
	    			private JLabel lblListentitel;
	    			private JScrollPane scrListe;
	    				private JTable tblListe;
	    			private JPanel listenButtonPanel;
	    				private JButton btConnectTicket;
	    				private JButton btConnect;
	    				private JButton btDisconnect;
	    				private JButton btDelete;
	    		private JPanel anzeigePanel;
	    			private JScrollPane scrAnzeige;
	    				private JEditorPane txtAnzeige;
    	private JPanel buttonPanel;
    		private JButton btClose;
    		private JComboBox cmbFormulare;
    		private JButton btDrucken;
    		private JButton btListendruck;
    		private JButton btHilfe;


    //ActionCodes Adressenfenster
    public static final int         		ACTION_CLOSE_CODE = 1001;
    public static final String      		ACTION_CLOSE_TEXT = "dmliste.action_close";
    public static final int         		ACTION_HILFE_CODE = 1006;
    public static final String      		ACTION_HILFE_TEXT = "action_hilfe";
    public static final int         		ACTION_HIDE_CODE = 1007;
    public static final String      		ACTION_HIDE_TEXT = "action_hide";
    public static final int         		ACTION_REFRESH_CODE = 1008;
    public static final String      		ACTION_REFRESH_TEXT = "dmliste.action_refresh";
    public static final int         		ACTION_CONNECT_CODE = 1009;
    public static final String      		ACTION_CONNECT_TEXT = "dmlistenfenster.action_connect";
    public static final int         		ACTION_DISCONNECT_CODE = 1010;
    public static final String      		ACTION_DISCONNECT_TEXT = "dmlistenfenster.action_disconnect";
    public static final int         		ACTION_DELETE_CODE = 1011;
    public static final String      		ACTION_DELETE_TEXT = "dmlistenfenster.action_delete";
    public static final int         		ACTION_DRUCKEN_CODE = 1012;
    public static final String      		ACTION_DRUCKEN_TEXT = "dmlistenfenster.action_drucken";
    public static final int         		ACTION_LISTENDRUCK_CODE = 1013;
    public static final String      		ACTION_LISTENDRUCK_TEXT = "dmlistenfenster.action_listendruck";
    public static final int         		ACTION_CONNECT_TICKET_CODE = 1014;
    public static final String      		ACTION_CONNECT_TICKET_TEXT = "dmlistenfenster.action_connect_ticket";
    public static final int         		ACTION_DUPLICATE_CODE = 1015;
    public static final String      		ACTION_DUPLICATE_TEXT = "dmlistenfenster.action_duplicate";
    
    public static final int					MAX_COLUMN 					= 	11;
    public static final int					C_STATUS							=	0;
    public static final int					C_DATUM							=	1;
    public static final int					C_PROBENID						=	2;
    public static final int					C_BEZEICHNUNG 				=	3;
    public static final int					C_LOSNUMMER 					= 	4;
    public static final int					C_STAERKE						= 5;
    public static final int					C_ZUCKER							= 6;
    public static final int					C_EXTRAKT						= 7;
    public static final int					C_FELD1							= 8;
    public static final int					C_FELD2							= 9;
    public static final int					C_FELD3							= 10;
    
    
    public static final int					DATE_HEUTE 					= 0;
    public static final int					DATE_GESTERN 				= 1;
    public static final int					DATE_DIESE_WOCHE 		= 2;
    public static final int					DATE_LETZTE_WOCHE		= 3;
    public static final int					DATE_DIESEN_MONAT		= 4;
    public static final int					DATE_LETZTEN_MONAT		= 5;
    public static final int					DATE_DIESES_JAHR 			= 6;
    public static final int					DATE_LETZTES_JAHR			= 7;
    public static final int					DATE_2_WOCHEN				= 8;
    public static final int					DATE_4_WOCHEN				= 9;
    public static final int					DATE_ALLE						= 10;
    public static final String 				CALENDAR_FORMAT			=	"d. MMMMMM yyyy";

    Timer					   				ergebnisTimer;
    ArrayList<DMItem>				liste;
    JRzFrame								origin;
    LosnummerDialog					ld;
    TicketDialog								td;
    int 										editRow=-1;

    public DMListenFenster(RzPro r,String name,Object extendedData) {
        super(r,name,extendedData);
        ergebnisTimer = new javax.swing.Timer(rz.getOptionFactory().getOption("list.timeout",RzPro.LIST_TIMEOUT), new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                 ergebnisTimerEvent();
            }
        });
        createActions();
        createGUIComponents();
        setGUIComponents();
        getMessage((MessageItem)extendedData);
    }

    @Override
	public void createGUIComponents() {
        mb = new JMenuBar();
		mnuDatei = new JMenu();
			mb.add(mnuDatei);
		mnuBearbeiten=new JMenu();
			mb.add(mnuBearbeiten);
        mnuExtras = new JMenu();
        	mb.add(mnuExtras);
        mnuFenster = new JMenu();
        	mb.add(mnuFenster);
        mnuHilfe = new JMenu();
        	mb.add(mnuHilfe);
		setJMenuBar(mb);
		mainPanel = new JPanel(new BorderLayout());
				 datumPanel = new JPanel(new BorderLayout());
			    	boxPanel = new JPanel(new BorderLayout());
		 	    		pickerPanel = new JPanel(new BorderLayout());
		 	    			picker = new RzDualDatePicker(rz,null,null);
		 	    				picker.addListener(new PickerDualDateListener() {
									@Override
									public void dateChanged(Date datum1, Date datum2) {
										refreshAction();										
									}
		 	    				});
		 	    			pickerPanel.add(picker);
		 	    	boxPanel.add(pickerPanel);
			    	datumPanel.add(boxPanel,BorderLayout.CENTER);
			    
		 		mainPanel.add(datumPanel,BorderLayout.NORTH);
		
		toolbarPanel = new JPanel(new BorderLayout());
			tb1 = new JToolBar();
			tb1.setFloatable(false);
			tb1.setRollover(true);
			toolbarPanel.add(tb1);
			contentPanel = new JPanel(new BorderLayout());
				auswahlGroupPanel = new JPanel(new BorderLayout());
					auswahlPanel = new JPanel(new GridLayout(3,1));
						auswahlGroup=new ButtonGroup();
						btAuswahlAlle = new JRadioButton();
						btAuswahlAlle.addActionListener(new java.awt.event.ActionListener() {
							public void actionPerformed(java.awt.event.ActionEvent evt) {
								refreshAction();
							}
						});
						btAuswahlConnected = new JRadioButton();
						btAuswahlConnected.addActionListener(new java.awt.event.ActionListener() {
							public void actionPerformed(java.awt.event.ActionEvent evt) {
								refreshAction();
							}
						});
						btAuswahlUnConnected = new JRadioButton();
						btAuswahlUnConnected.addActionListener(new java.awt.event.ActionListener() {
							public void actionPerformed(java.awt.event.ActionEvent evt) {
								refreshAction();
							}
						});
					auswahlGroup.add(btAuswahlAlle);
					auswahlPanel.add(btAuswahlAlle);
					auswahlGroup.add(btAuswahlConnected);
					auswahlPanel.add(btAuswahlConnected);
					auswahlGroup.add(btAuswahlUnConnected);
					auswahlPanel.add(btAuswahlUnConnected);
					btAuswahlConnected.setSelected(true);
					auswahlPanel.setBorder(BorderFactory.createEtchedBorder());
				auswahlGroupPanel.add(auswahlPanel, BorderLayout.NORTH);
					auswahlTextPanel = new JPanel(new BorderLayout());
						bezeichnungPanel = new JPanel(new BorderLayout());
							lblBezeichnung = new JLabel();
								lblBezeichnung.setHorizontalAlignment(SwingConstants.TRAILING);
							bezeichnungPanel.add(lblBezeichnung,BorderLayout.WEST);
								txtBezeichnung = new JSelectedTextField();
									txtBezeichnung.addKeyListener(new java.awt.event.KeyAdapter() {
							            public void keyReleased(java.awt.event.KeyEvent evt) {
							                if (evt.getKeyCode() == KeyEvent.VK_ENTER){
							                    refreshAction();
							                	}
							            	}
							        	});
								bezeichnungPanel.add(txtBezeichnung,BorderLayout.CENTER);
							losnummerPanel = new JPanel(new BorderLayout());
								lblLosnummer = new JLabel();
									lblLosnummer.setHorizontalAlignment(SwingConstants.CENTER);
								losnummerPanel.add(lblLosnummer,BorderLayout.WEST);
								txtLosnummer = new JSelectedTextField();
									txtLosnummer.addKeyListener(new java.awt.event.KeyAdapter() {
							            public void keyReleased(java.awt.event.KeyEvent evt) {
							                if (evt.getKeyCode() == KeyEvent.VK_ENTER){
							                    refreshAction();
							                	}
							            	}
							        	});
								losnummerPanel.add(txtLosnummer, BorderLayout.CENTER);
					auswahlTextPanel.add(bezeichnungPanel,BorderLayout.NORTH);
					auswahlTextPanel.add(losnummerPanel,BorderLayout.SOUTH);
				auswahlGroupPanel.add(auswahlTextPanel,BorderLayout.CENTER);
				refreshPanel = new JPanel(new BorderLayout());
					btRefresh = new JButton();
					refreshPanel.add(btRefresh);
				auswahlGroupPanel.add(refreshPanel,BorderLayout.SOUTH);
				contentPanel.add(auswahlGroupPanel,BorderLayout.NORTH);
				splCenter = new JSplitPane();
					splCenter.setDividerSize(6);
					splCenter.setOrientation(JSplitPane.VERTICAL_SPLIT);
					listenPanel = new JPanel(new BorderLayout());
						lblListentitel=new JLabel();
							lblListentitel.setHorizontalAlignment(SwingConstants.CENTER);
						listenPanel.add(lblListentitel,BorderLayout.NORTH);
						scrListe=new JScrollPane();
					       tblListe=new JTable();
							tblListe.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
							tblListe.setName("dmlistenfenster.spalten");
			    			tblListe.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
			    			tblListe.getSelectionModel().addListSelectionListener(new ListSelectionListener() {
		                    public void valueChanged(ListSelectionEvent e) {
		        			        if (e.getValueIsAdjusting()) {
										return;
									}
			        			    if(ergebnisTimer.isRunning()) {
			        			            ergebnisTimer.stop();
			        			        }
		        			        ergebnisTimer.start();
		                        }
			    			});
			    			tblListe.setColumnSelectionAllowed(false);
			    			tblListe.setRowSelectionAllowed(true);
			    			tblListe.setGridColor(rz.getOptionFactory().getColor(OptionFactory.COLOR_VISIBLE_GRID));
			    			tblListe.setShowGrid(true);
			    			tblListe.addMouseListener(new MouseAdapter(){
							     public void mouseClicked(MouseEvent e){
							    	  listeClickedAction(e);
							      }
							} );
			    			 settblAuftragslisteModel(tblListe);
					       scrListe.setViewportView(tblListe);
						listenPanel.add(scrListe,BorderLayout.CENTER);
						listenButtonPanel = new JPanel(new GridLayout(3,2));
							btConnectTicket = new JButton();
							listenButtonPanel.add(btConnectTicket);
							btConnect = new JButton();
							listenButtonPanel.add(btConnect);
							btDisconnect = new JButton();
							listenButtonPanel.add(btDisconnect);
							btDelete = new JButton();
							listenButtonPanel.add(btDelete);
						listenPanel.add(listenButtonPanel,BorderLayout.SOUTH);
					splCenter.setTopComponent(listenPanel);
					anzeigePanel=new JPanel(new BorderLayout());
						scrAnzeige = new JScrollPane();
							txtAnzeige = new JEditorPane();
								txtAnzeige.setEditable(false);
								txtAnzeige.setContentType("text/html");
							scrAnzeige.setViewportView(txtAnzeige);
						anzeigePanel.add(scrAnzeige,BorderLayout.CENTER);
					splCenter.setBottomComponent(anzeigePanel);
				contentPanel.add(splCenter,BorderLayout.CENTER);
			mainPanel.add(contentPanel,BorderLayout.CENTER);
			buttonPanel = new JPanel(new GridLayout(1,5));
				btClose = new JButton();
				buttonPanel.add(btClose);
				
				cmbFormulare = new JComboBox();
				buttonPanel.add(cmbFormulare);
				rz.getDatabase().getReport().dbGetReportListeCombo(cmbFormulare,ReportFactory.REPORT_TYPE_DM);
        	    cmbFormulare.addActionListener(new ActionListener() {
    	        	public void actionPerformed(ActionEvent evt) {
    	        		if(cmbFormulare.getSelectedIndex() != -1) {
    	        			rz.getOptionFactory().setOption("report.dm",((ReportItem)cmbFormulare.getSelectedItem()).getID());
    	        			rz.getOptionFactory().saveOptions();
    	        		}
    	        	}
                });
				
				btDrucken = new JButton();
				buttonPanel.add(btDrucken);
				btListendruck = new JButton();
				buttonPanel.add(btListendruck);
				
				btHilfe = new JButton();
				buttonPanel.add(btHilfe);
			mainPanel.add(buttonPanel,BorderLayout.SOUTH);
			getContentPane().setLayout(new BorderLayout());
			getContentPane().add(toolbarPanel,BorderLayout.NORTH);
			getContentPane().add(mainPanel,BorderLayout.CENTER);
			getContentPane().add(buttonPanel,BorderLayout.SOUTH);
    }

    @Override
	public void setGUIComponents() {
      setTitle(rz.getVersionString() + " " + rz.getLocale().getString("dmliste.titel"));
      rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE);

      mnuDatei.setText(rz.getLocale().getString("menu.datei"));
      mnuExtras.setText(rz.getLocale().getString("menu.extras"));
      mnuBearbeiten.setText(rz.getLocale().getString("menu.bearbeiten"));
      mnuFenster.setText(rz.getLocale().getString("menu.fenster"));
      mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));

      mnuDatei.add(getAction(ACTION_REFRESH_CODE));
      mnuDatei.addSeparator();
      mnuDatei.add(getAction(ACTION_DRUCKEN_CODE));
      mnuDatei.add(getAction(ACTION_LISTENDRUCK_CODE));
      mnuDatei.addSeparator();
      mnuDatei.add(getAction(ACTION_CLOSE_CODE));
      
      mnuBearbeiten.add(getAction(ACTION_CONNECT_CODE));
      mnuBearbeiten.add(getAction(ACTION_DISCONNECT_CODE));
      mnuBearbeiten.addSeparator();
      mnuBearbeiten.add(getAction(ACTION_DUPLICATE_CODE));
      mnuBearbeiten.addSeparator();
      mnuBearbeiten.add(getAction(ACTION_DELETE_CODE));
      
      mnuExtras.add(getAction(ACTION_HIDE_CODE));

      mnuHilfe.add(getAction(ACTION_HILFE_CODE));

      btHilfe.setAction(getAction(ACTION_HILFE_CODE));
      btClose.setAction(getAction(ACTION_CLOSE_CODE));
      
      btConnect.setAction(getAction(ACTION_CONNECT_CODE));
      btConnectTicket.setAction(getAction(ACTION_CONNECT_TICKET_CODE));
      btDisconnect.setAction(getAction(ACTION_DISCONNECT_CODE));
      btDelete.setAction(getAction(ACTION_DELETE_CODE));
      btDrucken.setAction(getAction(ACTION_DRUCKEN_CODE));
      btListendruck.setAction(getAction(ACTION_LISTENDRUCK_CODE));
      getAction(ACTION_DELETE_CODE).setEnabled(false);
      getAction(ACTION_DISCONNECT_CODE).setEnabled(false);
      getAction(ACTION_CONNECT_CODE).setEnabled(false);
      getAction(ACTION_DUPLICATE_CODE).setEnabled(false);
      getAction(ACTION_CONNECT_TICKET_CODE).setEnabled(false);
      getAction(ACTION_DRUCKEN_CODE).setEnabled(false);
      getAction(ACTION_LISTENDRUCK_CODE).setEnabled(false);
      
      tb1.add(getAction(ACTION_CLOSE_CODE));
      tb1.add(getAction(ACTION_HIDE_CODE));
      tb1.addSeparator();
      tb1.add(getAction(ACTION_DUPLICATE_CODE));
      tb1.addSeparator();
      tb1.add(getAction(ACTION_REFRESH_CODE));
      tb1.addSeparator();
      tb1.add(getAction(ACTION_HILFE_CODE));

      btRefresh.setAction(getAction(ACTION_REFRESH_CODE));

      btAuswahlAlle.setText(rz.getLocale().getString("dmliste.label_alle"));
      btAuswahlConnected.setText(rz.getLocale().getString("dmliste.label_connected"));
      btAuswahlUnConnected.setText(rz.getLocale().getString("dmliste.label_unconnected"));
      
      lblBezeichnung.setText(rz.getLocale().getString("dmliste.label_bezeichnung"));
      lblLosnummer.setText(rz.getLocale().getString("dmliste.label_losnummer"));   
      
      setResizable(true);
      setDividerLocations();
      rz.getFontFactory().setFrameFonts(this);
      pack();
      rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;
    }

    @Override
	public void getMessage(MessageItem msg) {
        switch(msg.getMsgCode()) {
        	case MessageItem.MSG_ACTIONPERFORMED:
                switch(msg.getCode()){
                case ACTION_HILFE_CODE: hilfeAction();break;
                case ACTION_HIDE_CODE:hideAction();break;
                case ACTION_REFRESH_CODE:refreshAction();break;
                case ACTION_CLOSE_CODE:closeWindow();break;
                case ACTION_CONNECT_CODE:connectAction();break;
                case ACTION_CONNECT_TICKET_CODE:connectTicketAction();break;
                case ACTION_DISCONNECT_CODE:disconnectAction();break;
                case ACTION_DELETE_CODE:deleteAction();break;
                case ACTION_DRUCKEN_CODE:druckenAction(true);break;
                case ACTION_LISTENDRUCK_CODE:druckenAction(false);break;     
                case ACTION_DUPLICATE_CODE:duplicateAction();break;   
                default :
                    break;
               }
        		break;
           case MessageItem.MSG_SHOW_DMLISTE:
        	   origin=msg.getOrigin();
        	   btAuswahlUnConnected.setSelected(true);
        	   refreshAction();
               break;
           case MessageItem.MSG_TICKET_DIALOG_REPLY:
        	   TicketAuswahlItem ti = (TicketAuswahlItem)msg.getData();
        	   if(ti != null) {
        		   try {
        			   DMItem di = liste.get(editRow);
        			   if(di != null) {
	        			   di.setBezeichnung(ti.getBezeichnung());
	        			   di.setLosnummer(ti.getSaveString());
	        			   di.setConnected(true);
	        			   rz.getDatabase().getDM().connect(di);
	        		        ((AbstractTableModel)tblListe.getModel()).fireTableDataChanged();
	        		        try {
	        		        	tblListe.setRowSelectionInterval(editRow, editRow);
	        		        }catch(Exception e) {}
	        		        
		        			editRow = -1;
        			   }
        		   } catch (Exception e) {}
        	   }
        	   break;
           case MessageItem.MSG_LOSNUMMER_DIALOG_REPLY:
        	   BuchungLosnummerItem bli = (BuchungLosnummerItem)msg.getData();
        	   if(bli != null && liste != null && editRow != -1) {
        		   try {
        			   DMItem di = liste.get(editRow);
        			   if(di != null) {
	        			   di.setBezeichnung(bli.getBezeichnung());
	        			   di.setLosnummer(bli.getLosnummer());
	        			   di.setConnected(true);
	        			   rz.getDatabase().getDM().connect(di);
	        		        ((AbstractTableModel)tblListe.getModel()).fireTableDataChanged();
	        		        try {
	        		        	tblListe.setRowSelectionInterval(editRow, editRow);
	        		        }catch(Exception e) {}
		        		   editRow = -1;
	        		       rz.getFensterFactory().getFensterListe().propagateBestand(this,bli.getRezeptur_id());
        			   }
        		   } catch (Exception e) {}
        	   }
               break;
            default:
                break;
        }
    }


	public void createActions(){
        actionList.put(String.valueOf(ACTION_CLOSE_CODE),new AuswahlAction(rz,this,ACTION_CLOSE_CODE,ACTION_CLOSE_TEXT,KeyEvent.VK_ESCAPE ,0));
        actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT, KeyEvent.VK_F5 ,InputEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT, KeyEvent.VK_F1 ,0));
        actionList.put(String.valueOf(ACTION_REFRESH_CODE),new AuswahlAction(rz,this,ACTION_REFRESH_CODE,ACTION_REFRESH_TEXT, KeyEvent.VK_F5 ,0));
        actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT, KeyEvent.VK_F1 ,0));
        actionList.put(String.valueOf(ACTION_CONNECT_CODE),new AuswahlAction(rz,this,ACTION_CONNECT_CODE,ACTION_CONNECT_TEXT, 0 ,0));
        actionList.put(String.valueOf(ACTION_DISCONNECT_CODE),new AuswahlAction(rz,this,ACTION_DISCONNECT_CODE,ACTION_DISCONNECT_TEXT, 0 ,0));
        actionList.put(String.valueOf(ACTION_DELETE_CODE),new AuswahlAction(rz,this,ACTION_DELETE_CODE,ACTION_DELETE_TEXT, 0 ,0));
        actionList.put(String.valueOf(ACTION_DRUCKEN_CODE),new AuswahlAction(rz,this,ACTION_DRUCKEN_CODE,ACTION_DRUCKEN_TEXT, 0 ,0));
        actionList.put(String.valueOf(ACTION_LISTENDRUCK_CODE),new AuswahlAction(rz,this,ACTION_LISTENDRUCK_CODE,ACTION_LISTENDRUCK_TEXT, 0 ,0));    
        actionList.put(String.valueOf(ACTION_CONNECT_TICKET_CODE),new AuswahlAction(rz,this,ACTION_CONNECT_TICKET_CODE,ACTION_CONNECT_TICKET_TEXT, 0 ,0));
        actionList.put(String.valueOf(ACTION_DUPLICATE_CODE),new AuswahlAction(rz,this,ACTION_DUPLICATE_CODE,ACTION_DUPLICATE_TEXT, 0 ,0));
	}

	
	 private void setDatum() {
	        refreshAction();
	    }

	 	private void datumSelection() {
	         picker.setComponentsEnabled(pickerPanel, true);
	    }

	    
 	/** speichert die Position der Splitbalken
 	 */
     private void saveDividerLocations(){
         rz.getFensterFactory().setOption(this.getName() + ".spldmliste", this.splCenter.getDividerLocation());
         rz.getFensterFactory().saveOptions();
     }
 	/** setzt die Position der Splitbalken auf gespeicherte Positionen oder
 	 * auf Standardposition, wenn keine gespeicherten vorliegen
 	 *
 	 */
     private void setDividerLocations() {
         this.splCenter.setDividerLocation(rz.getFensterFactory().getOption(this.getName() + ".spldmliste",this.getHeight()/2));
     }

     private void druckenAction(boolean single) {
		 ArrayList<DMItem> l = null;
    	 if(single) {
    		 if(tblListe.getSelectedRow() != -1) {
    			 l = new ArrayList<DMItem>();
    			 l.add(liste.get(tblListe.getSelectedRow()));
    		 }
    	 }else {
    		 if(liste != null && !liste.isEmpty()) {
    			 l = liste;
    		 }
    	 }
    	 if(l != null && !l.isEmpty()) {
    		 rz.getReportFactory().DMReport(l, this);
    	 }
     }
     
     private void connectTicketAction() {
    	 DMItem di;
    	 if(tblListe.getSelectedRow()!= -1) {
    		 di = liste.get(tblListe.getSelectedRow());
    		 if(di != null) {
    			 editRow = tblListe.getSelectedRow();
    			 showTicketDialog(di,null);
    		 }
    	 }
     }
     
     private void duplicateAction() {
    	 DMItem di;
    	 if(tblListe.getSelectedRow()!= -1) {
    		 di = liste.get(tblListe.getSelectedRow());
    		 if(di != null) {
    			 rz.getDatabase().getDM().duplicate(di);
    			 refreshAction();
    		 }
    	 } 
     }
     
     private void connectAction() {
    	 DMItem di;
    	 if(tblListe.getSelectedRow()!= -1) {
    		 di = liste.get(tblListe.getSelectedRow());
    		 if(di != null) {
    			 editRow = tblListe.getSelectedRow();
    			 showLosnummerDialog(di,null);
    		 }
    	 }
     }
     
     private void disconnectAction() {
    	 DMItem di;
    	 if(tblListe.getSelectedRow()!= -1) {
    		 di = liste.get(tblListe.getSelectedRow());
    		 if(di != null) {
    			 final DialogItem dlg  = new DialogItem(
    	                    DialogControl.FRAGE_DIALOG,
    	                    "",0.0,
    	                    rz.getLocale().getString("dmliste_disconnect_label"),
    	                    rz.getLocale().getString("dmliste_disconnect_label"),    	                    
    	                    rz.getLocale().getString("dmliste_disconnect_caption").replaceAll("%s",di.getLosnummer()).replaceAll("%n",di.getProben_id()),
    	                    "frage.png",
    	                    rz.getLocale().getString("string_ja"),
    	                    rz.getLocale().getString("string_nein"),
    	                    null
    	            );
    	            rz.getDialogFactory().getDialog(dlg,false,false);
    	            if(dlg.getReplyCode() == DialogControl.DIALOG_OK) {
    	            	rz.getDatabase().getDM().disconnect(di);
    	            	rz.getFensterFactory().getFensterListe().propagateBestand(this);
    	            	refreshAction();
    	            }
    		 }
    	 }
     }
     
     private void deleteAction() {
    	 DMItem di;
    	 if(tblListe.getSelectedRow()!= -1) {
    		 di = liste.get(tblListe.getSelectedRow());
    		 if(di != null) {
    			 final DialogItem dlg  = new DialogItem(
    	                    DialogControl.FRAGE_DIALOG,
    	                    "",0.0,
    	                    rz.getLocale().getString("dmliste_delete_label"),
    	                    rz.getLocale().getString("dmliste_delete_label"),    	                    
    	                    rz.getLocale().getString("dmliste_delete_caption").replaceAll("%n",di.getProben_id()),
    	                    "frage.png",
    	                    rz.getLocale().getString("string_ja"),
    	                    rz.getLocale().getString("string_nein"),
    	                    null
    	            );
    	            rz.getDialogFactory().getDialog(dlg,false,false);
    	            if(dlg.getReplyCode() == DialogControl.DIALOG_OK) {
    	            	rz.getDatabase().getDM().deleteDM(di);
    	            	refreshAction();
    	            }
    		 }
    	 }
     }
     
     private void listeClickedAction(MouseEvent e) {
  	   DMItem di;
  	   if(tblListe.getSelectedRow()!= -1) {
  		   di = liste.get(tblListe.getSelectedRow());
  		   if(di != null) {
  			   int c = tblListe.getSelectedColumn();
  			   switch(c) {
  				   case C_LOSNUMMER:
  					   editRow = tblListe.getSelectedRow();
  					   showLosnummerDialog(di,e);
  					   break;
  				   case C_BEZEICHNUNG:
  	                	if(!di.getLosnummer().trim().equals("") && !(di.getBezeichnung().trim().equals(""))) {
  	                		rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_VERLAUF,false,new MessageItem(MessageItem.MSG_SHOW_HISTORY,0,"^"+di.getLosnummer()+"$",this));
  	                	}
  					   break;
  			   }
  		   }
  	   }
     }
	public void openWindow(){
        if(!isVisible()) {
			setVisible(true);
		}
        toFront();
        tblListe.requestFocus();
    }

	public void closeWindow(){
    	saveDividerLocations();
		if (ld != null) {
			ld.dispose();
			ld = null;
		}
        //this.setVisible(false);
    	rz.getFensterFactory().getFensterListe().disposeFrame(this);
    }

  
    private void refreshAction() {
    	getListe();
        ergebnisTimerEvent();
    }
    
    private void ergebnisTimerEvent(){
    	if(ergebnisTimer.isRunning()) {
    		ergebnisTimer.stop();
    	}
    	if(liste != null && !liste.isEmpty()) {
    		rz.getAusgabeFactory().dmlistenAusgabe(liste.get(tblListe.getSelectedRow()),this.txtAnzeige);
    	} else {
    		rz.getAusgabeFactory().dmlistenAusgabe(null,this.txtAnzeige);	
    	}
    	setActions();
    }
    
    private void setActions() {
        getAction(ACTION_DELETE_CODE).setEnabled(false);
        getAction(ACTION_DISCONNECT_CODE).setEnabled(false);
        getAction(ACTION_CONNECT_CODE).setEnabled(false);
        getAction(ACTION_CONNECT_TICKET_CODE).setEnabled(false);
        getAction(ACTION_DRUCKEN_CODE).setEnabled(false);
        getAction(ACTION_DUPLICATE_CODE).setEnabled(false);
        if(liste.size()>0) {
            getAction(ACTION_LISTENDRUCK_CODE).setEnabled(true);
        }else {
            getAction(ACTION_LISTENDRUCK_CODE).setEnabled(false);
        }
        if(tblListe.getSelectedRow() != -1 && liste != null) {
        	DMItem di = liste.get(tblListe.getSelectedRow());
        	if(di != null) {
                getAction(ACTION_DRUCKEN_CODE).setEnabled(true);
                getAction(ACTION_DUPLICATE_CODE).setEnabled(true);
        		if(di.isConnected()) {
        	        getAction(ACTION_DISCONNECT_CODE).setEnabled(true);
        	        getAction(ACTION_CONNECT_CODE).setEnabled(true);
        	        getAction(ACTION_CONNECT_TICKET_CODE).setEnabled(true);
        		} else {
        	        getAction(ACTION_DELETE_CODE).setEnabled(true);
        	        getAction(ACTION_CONNECT_CODE).setEnabled(true);
        	        getAction(ACTION_CONNECT_TICKET_CODE).setEnabled(true);
        		}
        	}
        }
    }
    
    private void getListe() {
    	if(txtBezeichnung.getText().trim().equals("") && txtLosnummer.getText().trim().equals("")) {
        	if(btAuswahlAlle.isSelected()) {
        		liste = rz.getDatabase().getDM().getListe(DBDM.DM_ALLE,picker.getDate1(),picker.getDate2());
        	} else if(btAuswahlConnected.isSelected()) {
        		liste = rz.getDatabase().getDM().getListe(DBDM.DM_CONNECTED,picker.getDate1(),picker.getDate2());
        	}else if(btAuswahlUnConnected.isSelected()) {
        		liste = rz.getDatabase().getDM().getListe(DBDM.DM_UNCONNECTED,picker.getDate1(),picker.getDate2());
        	}    		
    	} else {
    		liste = rz.getDatabase().getDM().getListeText(txtBezeichnung.getText().trim(),txtLosnummer.getText().trim(),picker.getDate1(),picker.getDate2());
    	}

        ((AbstractTableModel)tblListe.getModel()).fireTableDataChanged();
        if(!liste.isEmpty()) {
        	tblListe.scrollRectToVisible(tblListe.getCellRect(liste.size()-1,liste.size()-1,true));
        	tblListe.setRowSelectionInterval(liste.size()-1,liste.size()-1);
        }
    }

	private void showTicketDialog(DMItem di,MouseEvent e) {
		int x,y;
		if(e != null) {
			Point p = e.getPoint();
			x = (int) (tblListe.getLocationOnScreen().getX() + (int)p.getX());
			y = (int) (tblListe.getLocationOnScreen().getY() + (int)p.getY());
		} else {
			x = (int) (btConnectTicket.getLocationOnScreen().getX() + btConnectTicket.getMousePosition().getX());
			y = (int) (btConnectTicket.getLocationOnScreen().getY() + btConnectTicket.getMousePosition().getY());
		}
		if(di != null) {
			td = new TicketDialog(this, rz, x,y,di.getLosnummer());
			td.setVisible(true);
		}
	}
    
	private void showLosnummerDialog(DMItem di,MouseEvent e) {
		int x,y;
		if(e != null) {
			Point p = e.getPoint();
			x = (int) (tblListe.getLocationOnScreen().getX() + (int)p.getX());
			y = (int) (tblListe.getLocationOnScreen().getY() + (int)p.getY());
		} else {
			x = (int) (btConnect.getLocationOnScreen().getX() + btConnect.getMousePosition().getX());
			y = (int) (btConnect.getLocationOnScreen().getY() + btConnect.getMousePosition().getY());
		}
		if(di != null) {
			ld = new LosnummerDialog(this, rz, x,y,di.getLosnummer());
			ld.setVisible(true);
		}
	}
    
    //Extras-Menü
    private void hideAction(){
        rz.getFensterFactory().getFensterListe().sperren(this);
    }

    //hilfe-menü
    private void hilfeAction(){
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"dmliste.html",this));
    }

    private void settblAuftragslisteModel(JTable t) {
	    final ListenColumnModel rcm = new ListenColumnModel();
	    final StringRenderer sr = new StringRenderer();
	    final IconRenderer ir = new IconRenderer();
	    TableColumn tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("dmliste.tableheader_status"));
	    	tc.setModelIndex(C_STATUS);
	    	tc.setCellRenderer(ir);
	    rcm.addColumn(tc);
	    tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("dmliste.tableheader_datum"));
	    	tc.setModelIndex(C_DATUM);
	    	tc.setCellRenderer(sr);
	    rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("dmliste.tableheader_proben_id"));
			tc.setModelIndex(C_PROBENID);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("dmliste.tableheader_bezeichnung"));
			tc.setModelIndex(C_BEZEICHNUNG);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("dmliste.tableheader_losnummer"));
			tc.setModelIndex(C_LOSNUMMER);
			tc.setCellRenderer(sr);
			rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("dmliste.tableheader_staerke"));
			tc.setModelIndex(C_STAERKE);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("dmliste.tableheader_zucker"));
			tc.setModelIndex(C_ZUCKER);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("dmliste.tableheader_extrakt"));
			tc.setModelIndex(C_EXTRAKT);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("dmliste.tableheader_feld1"));
			tc.setModelIndex(C_FELD1);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("dmliste.tableheader_feld2"));
			tc.setModelIndex(C_FELD2);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("dmliste.tableheader_feld3"));
			tc.setModelIndex(C_FELD3);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
        rcm.addColumnModelListener(this);
        tblListe.setModel(new ListenTableModel());
        tblListe.setColumnModel(rcm);
        tblListe.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
        tblListe.getTableHeader().setReorderingAllowed(false);
	}

	private class ListenColumnModel extends DefaultTableColumnModel{
	    public ListenColumnModel() {
	        super();
	    }

	}

	private  class ListenTableModel extends AbstractTableModel    {

	        SimpleDateFormat df;

	        public ListenTableModel() {
	            df = new SimpleDateFormat("EEEE dd. MMMM yyyy HH:mm");
	        }

		   public int getColumnCount() {
		       	return MAX_COLUMN;
	        }
	        public int getRowCount() {
	        	if(liste != null) {
	                return liste.size();
	        	} else {
	        		return 0;
	        	}
	        }

	        public void setValueAt(Object value, int row, int col) {
	        	final DMItem di = liste.get(row);
	        	switch(col) {
	        		case C_FELD1: di.setFeld1(((String)value).trim());
	        			rz.getDatabase().getDM().setFelder(di);
	        			ergebnisTimerEvent();
	        			break;
	        		case C_FELD2: di.setFeld2(((String)value).trim());
	        			rz.getDatabase().getDM().setFelder(di);
	        			ergebnisTimerEvent();
	        		break;
	        		case C_FELD3: di.setFeld3(((String)value).trim());
        				rz.getDatabase().getDM().setFelder(di);
        				ergebnisTimerEvent();
        			break;
	        	}
	        	
	        }
	        
	        public boolean isCellEditable(int row, int col){
	        	boolean ret = false;
	        	final DMItem di = liste.get(row);
	    		if (di != null) {
		        		switch(col) {
		        			case C_FELD1:ret = true; break;
		        			case C_FELD2:ret = true; break;
		        			case C_FELD3:ret = true; break;
		        	}
	    		}
	        	return ret;
	        }
	        
	        public DMItem getZeileAt(int rowIndex) {
	        	if((rowIndex != -1) && (liste != null)) {
	        		return liste.get(rowIndex);
	        	} else {
					return null;
				}
	        }

	        public Object getValueAt(int rowIndex, int columnIndex) {
	            Object ret = null;
	            if((rowIndex != -1) && (liste != null)) {
	                ret = getContent(liste.get(rowIndex),columnIndex,rowIndex);
	            }
	            return ret;
	        }

	        private Object getContent(DMItem di,int aColumn,int row) {
	            Object ret = null;
	            if(di != null) {
		            switch(aColumn){
		            	case C_BEZEICHNUNG: ret = di.getBezeichnung();
		            		break;
		            	case C_LOSNUMMER: ret = di.getLosnummer();
		            		break;
		            	case C_STAERKE: ret = di.getStaerke();
		            		break;
		            	case C_DATUM:ret = df.format(di.getDatum_zeit());
		            		break;
		            	case C_PROBENID:ret = di.getProben_id();
		            		break;
		            	case C_STATUS: ret = di.isConnected();
		            		break;
		            	case C_ZUCKER:ret = di.getZucker();
		            		break;
		            	case C_EXTRAKT:ret = di.getExtrakt();
		            		break;
		            	case C_FELD1: ret = di.getFeld1();
		            		break;
		            	case C_FELD2: ret = di.getFeld2();
		            		break;
		            	case C_FELD3: ret = di.getFeld3();
		            		break;
		            }
	            }
	            return ret;
	        }
		}


	
	/** rendert alle Tabellenzeilen mit String Inhalt
	 *  im wesentlichen heisst das rechts-ausgerichtent
	 * @author lunqual
	 */
	private class StringRenderer extends DefaultTableCellRenderer {
		
		Icon verlauf,zuweisen;
		
	    StringRenderer() {
	        super();
            verlauf = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/dmlistenfenster.icon_verlauf.png"));
            zuweisen = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/dmlistenfenster.icon_zuweisen.png"));
	        setOpaque(true);
	    }
	    public Component getTableCellRendererComponent(JTable table,
                Object value, boolean isSelected, boolean hasFocus, int row,
                int column)
	    {
	    	DMItem di = null;
	    	setIcon(null);
	    	if((row != -1) && (liste != null)) {
	    	   di = liste.get(row);
	    	   if(di.isConnected()) {
                   setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_BESTAND_GRUEN));
	    	   } else {
                   setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_BESTAND_ROT));
	    	   }
	    	   if(column == C_BEZEICHNUNG) {
	    		   if(di.isConnected()) {
	    			   setIcon(verlauf);
	    		   } 
	    	   }
	    	}
	    	if(column == C_LOSNUMMER) {
	    		setIcon(zuweisen);
	    	}
    		if(isSelected) {
    			setFont(rz.getFontFactory().getTableBoldFont());
    		}else {
    			setFont(rz.getFontFactory().getTableFont());
    		}
    		setText((String)value);
	        setHorizontalAlignment(SwingConstants.LEADING);
	        return this;
        }
	}

	private class IconRenderer extends DefaultTableCellRenderer {

		Icon connected;
		
	    IconRenderer() {
	        super();
	        setOpaque(true);
            connected = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/dmlistenfenster.icon_connected.png"));
	    }
	    public Component getTableCellRendererComponent(JTable table,
                Object value, boolean isSelected, boolean hasFocus, int row,
                int column)
	    {
	    	setIcon(null);
	    	DMItem di = null;
	    	if((row != -1) && (liste != null)) {
	    	   di = liste.get(row);
	    	   if(di.isConnected()) {
                   setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_BESTAND_GRUEN));
	    		   setIcon(connected);
	    	   } else {
                   setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_BESTAND_ROT));
	    		   setIcon(null);
	    	   }
	    	}
	        return this;
        }
	}
    
    
    
    
	public void columnAdded(TableColumnModelEvent arg0) {}
	public void columnMarginChanged(ChangeEvent arg0) {}
	public void columnMoved(TableColumnModelEvent arg0) {}
	public void columnRemoved(TableColumnModelEvent arg0) {}
	public void columnSelectionChanged(ListSelectionEvent arg0) {}
}
