package de.lunqual.rzpro.fenster.dokumente;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import javax.print.PrintService;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fenster.JSelectedTextField;
import de.lunqual.rzpro.fenster.dialoge.DialogControl;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.abfrage.AbfrageItem;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.adressen.AdressItem;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.items.documents.DocumentHeaderItem;
import de.lunqual.rzpro.items.documents.DocumentHeaderListe;
import de.lunqual.rzpro.items.documents.DocumentItem;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.stichworte.StichwortListe;
import de.lunqual.rzpro.options.OptionFactory;

public class DokumentenListeFenster extends JRzFrame implements TableColumnModelListener{

    public static final int         		ACTION_CLOSE_CODE = 1001;
    public static final String      	ACTION_CLOSE_TEXT = "dokumentenliste.action_close";
    public static final int         		ACTION_NEU_CODE = 1002;
    public static final String      	ACTION_NEU_TEXT = "dokumentenliste.action_neu";
    public static final int         		ACTION_BEARBEITEN_CODE = 1003;
    public static final String      	ACTION_BEARBEITEN_TEXT = "dokumentenliste.action_edit";
    public static final int         		ACTION_DELETE_CODE = 1004;
    public static final String      	ACTION_DELETE_TEXT = "dokumentenliste.action_delete";
    public static final int         		ACTION_PRINT_CODE = 1005;
    public static final String      	ACTION_PRINT_TEXT = "dokumentenliste.action_print";
    public static final int         		ACTION_EXPORT_CODE = 1006;
    public static final String      	ACTION_EXPORT_TEXT = "dokumentenliste.action_export";
    public static final int         		ACTION_SUCHEN_CODE = 1007;
    public static final String      	ACTION_SUCHEN_TEXT = "dokumentenliste.action_suchen";
    public static final int         		ACTION_HILFE_CODE = 2006;
    public static final String      	ACTION_HILFE_TEXT = "action_hilfe";
    public static final int         		ACTION_HIDE_CODE = 2007;
    public static final String      	ACTION_HIDE_TEXT = "action_hide";
    
    private static final int			C_MAX		= 5;
    private static final int			C_ICON		= 0;
    private static final int			C_NAME		= 1;
    private static final int			C_FILENAME	= 2;   
    private static final int			C_ERSTELLT 	= 3;
    private static final int			C_GEAENDERT = 4;
	
    private JMenuBar mb;
    private JMenu mnuDatei;
    private JMenu mnuBearbeiten;
    private JMenu mnuExtras;
    private JMenu mnuHilfe;
    private JPanel mainPanel;
    	private JPanel toolbarPanel;
    		private JToolBar tb1;
    	private JSplitPane splContent;
    		private JPanel leftPanel;
    			private JPanel listenPanel;
    				private JPanel northPanelLabel;
    					private JLabel lblListe;
    				private JPanel northPanelFilter;
    					private JLabel lblFilter;
    					private JSelectedTextField txtFilter;
    					private JButton btFilter;
    				private JScrollPane scrListe;
    					private JTable tblListe;
    				private JPanel listenButtonPanel;
    					private JLabel lblCount;
    					private JButton btNeu;
    					private JButton btEdit;
    					private JButton btDelete;
    					private JButton btPrint;
    					private JButton btExport;
    					private JButton btSuchen;
    		private JPanel rightPanel;
	    		private PDFDisplay pdfDisplay;
	    		private GFXDisplay gfxDisplay;
	    		private JPanel emptyDisplay;
    	private JPanel buttonPanel;
			private JButton btClose;
			private JButton btHilfe;

    
	DocumentHeaderListe 									liste;
    int														rezeptur = 0;
    String													rezepturListe ="";
    DocumentItem											di;
    JPanel													currentDisplay;
    boolean													multiMode = false;
    boolean													filterMode = false;
    AdressItem												ai;
    Timer					   								ergebnisTimer;
    
	public DokumentenListeFenster(RzPro r, String name, Object extendedData) {
		super(r, name, extendedData);
		createActions();
		createGUIComponents();
		this.setTableModel(tblListe);
		setGUIComponents();
		 ergebnisTimer = new javax.swing.Timer(rz.getOptionFactory().getOption("list.timeout",RzPro.LIST_TIMEOUT), new ActionListener() {
	            public void actionPerformed(ActionEvent evt) {
	                 ergebnisTimerEvent();
	            }
	        });
		getMessage((MessageItem)extendedData);
	}

	
	@Override
	public void createGUIComponents() {
		  mb = new JMenuBar();
			mnuDatei = new JMenu();
				mb.add(mnuDatei);
			mnuBearbeiten=new JMenu();
				mb.add(mnuBearbeiten);
	        mnuExtras = new JMenu();
	        	mb.add(mnuExtras);
	        mnuHilfe = new JMenu();
	        	mb.add(mnuHilfe);
			setJMenuBar(mb);
			mainPanel = new JPanel(new BorderLayout());
			toolbarPanel = new JPanel(new BorderLayout());
				tb1 = new JToolBar();
				tb1.setFloatable(false);
				tb1.setRollover(true);
				toolbarPanel.add(tb1);
				splContent = new JSplitPane();
			 		splContent.setOrientation(JSplitPane.HORIZONTAL_SPLIT);
			 		splContent.setDividerSize(6);
				
					leftPanel = new JPanel(new BorderLayout());
					
						
						listenPanel = new JPanel(new BorderLayout());	
						
							northPanelFilter = new JPanel(new BorderLayout());
								lblFilter = new JLabel();
									lblFilter.setHorizontalAlignment(SwingConstants.TRAILING);
								northPanelFilter.add(lblFilter,BorderLayout.WEST);
								txtFilter = new JSelectedTextField();
								txtFilter.addKeyListener(new java.awt.event.KeyAdapter() {
						            public void keyReleased(java.awt.event.KeyEvent evt) {
						            	 if (evt.getKeyCode() == KeyEvent.VK_ENTER){
						                     refreshAction();
						                 }
						            	}
						        	});
								northPanelFilter.add(txtFilter,BorderLayout.CENTER);
								btFilter = new JButton();
								btFilter.addActionListener(new ActionListener() {
			        	        	public void actionPerformed(ActionEvent evt) {
			        	        		refreshAction();
			        	        	}
				        	    });
								
								northPanelFilter.add(btFilter,BorderLayout.EAST);
						
						
							northPanelLabel = new JPanel(new BorderLayout());
							lblListe = new JLabel();
								lblListe.setHorizontalAlignment(SwingConstants.CENTER);
							northPanelLabel.add(lblListe,BorderLayout.CENTER);
						listenPanel.add(northPanelLabel,BorderLayout.NORTH);
						
						
							scrListe = new JScrollPane();
								 tblListe = 	new JTable();
								 	tblListe.setName("dokumentenliste.table");
								 	tblListe.getSelectionModel().addListSelectionListener(new ListSelectionListener() {
					                    public void valueChanged(ListSelectionEvent e) {
					        			        if (e.getValueIsAdjusting()) {
													return;
												}
						        			    if(ergebnisTimer.isRunning()) {
						        			            ergebnisTimer.stop();
						        			        }
					        			        ergebnisTimer.start();
					                        }
						    			});
							        JTableHeader header = tblListe.getTableHeader();
							        header.addMouseListener(new ColumnHeaderListener());
							scrListe.setViewportView(tblListe);
						listenPanel.add(scrListe,BorderLayout.CENTER);
						listenButtonPanel = new JPanel(new GridLayout(4,2));
							lblCount=new JLabel();
							listenButtonPanel.add(lblCount);
							btNeu = new JButton();
							listenButtonPanel.add(btNeu);
							btEdit = new JButton();
							listenButtonPanel.add(btEdit);
							btPrint = new JButton();
							listenButtonPanel.add(btPrint);
							btExport = new JButton();
							listenButtonPanel.add(btExport);
							btSuchen = new JButton();
							listenButtonPanel.add(btSuchen);
							btDelete = new JButton();
							listenButtonPanel.add(btDelete);
						listenPanel.add(listenButtonPanel,BorderLayout.SOUTH);
					leftPanel.add(listenPanel,BorderLayout.CENTER);
				splContent.setLeftComponent(leftPanel);
						
				rightPanel = new JPanel(new BorderLayout());
				
					emptyDisplay = new JPanel();
					currentDisplay = emptyDisplay;
					rightPanel.add(emptyDisplay,BorderLayout.CENTER);
					pdfDisplay = new PDFDisplay(rz,true);
					gfxDisplay = new GFXDisplay(rz,true);

				
				splContent.setRightComponent(rightPanel);
				mainPanel.add(splContent,BorderLayout.CENTER);
				buttonPanel = new JPanel(new BorderLayout());
					btClose = new JButton();
					buttonPanel.add(btClose,BorderLayout.WEST);
					btHilfe = new JButton();
					buttonPanel.add(btHilfe,BorderLayout.EAST);
				mainPanel.add(buttonPanel,BorderLayout.SOUTH);
				getContentPane().setLayout(new BorderLayout());
				getContentPane().add(toolbarPanel,BorderLayout.NORTH);
				getContentPane().add(mainPanel,BorderLayout.CENTER);
				getContentPane().add(buttonPanel,BorderLayout.SOUTH);
	}

	@Override
	public void setGUIComponents() {
		  setTitle(rz.getVersionString() + " " + rz.getLocale().getString("dokumentenliste.titel"));
	      rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE);

	      mnuDatei.setText(rz.getLocale().getString("menu.datei"));
	      mnuExtras.setText(rz.getLocale().getString("menu.extras"));
	      mnuBearbeiten.setText(rz.getLocale().getString("menu.bearbeiten"));
	      mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));

	      mnuDatei.add(getAction(ACTION_CLOSE_CODE));
	      mnuBearbeiten.add(getAction(ACTION_NEU_CODE));
	      mnuBearbeiten.add(getAction(ACTION_BEARBEITEN_CODE));
	      mnuBearbeiten.add(getAction(ACTION_PRINT_CODE));
	      mnuBearbeiten.add(getAction(ACTION_EXPORT_CODE));
	      mnuBearbeiten.add(getAction(ACTION_SUCHEN_CODE));
	      mnuBearbeiten.addSeparator();
	      mnuBearbeiten.add(getAction(ACTION_DELETE_CODE));

	      mnuExtras.add(getAction(ACTION_HIDE_CODE));

	      mnuHilfe.add(getAction(ACTION_HILFE_CODE));

	      btHilfe.setAction(getAction(ACTION_HILFE_CODE));
	      btClose.setAction(getAction(ACTION_CLOSE_CODE));
	      btExport.setAction(getAction(ACTION_EXPORT_CODE));
	      btSuchen.setAction(getAction(ACTION_SUCHEN_CODE));

	      tb1.add(getAction(ACTION_CLOSE_CODE));
	      tb1.add(getAction(ACTION_HIDE_CODE));
	      tb1.addSeparator();
	      tb1.add(getAction(ACTION_NEU_CODE));
	      tb1.add(getAction(ACTION_BEARBEITEN_CODE));
	      tb1.add(getAction(ACTION_EXPORT_CODE));
	      tb1.add(getAction(ACTION_SUCHEN_CODE));
	      tb1.addSeparator();
	      tb1.add(getAction(ACTION_DELETE_CODE));
	      tb1.addSeparator();
	      tb1.add(getAction(ACTION_HILFE_CODE));

	      btNeu.setAction(getAction(ACTION_NEU_CODE));
	      btEdit.setAction(getAction(ACTION_BEARBEITEN_CODE));
	      btDelete.setAction(getAction(ACTION_DELETE_CODE));
	      btPrint.setAction(getAction(ACTION_PRINT_CODE));

	      btFilter.setText(rz.getLocale().getString("dokumentenliste.bt_filter"));
	      lblFilter.setText(rz.getLocale().getString("dokumentenliste.label_filter"));
	      
		getAction(ACTION_DELETE_CODE).setEnabled(false);
		getAction(ACTION_BEARBEITEN_CODE).setEnabled(false);
		setResizable(true);
		rz.getFontFactory().setFrameFonts(this);
		pack();
        setDividerLocations();
		rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;
	}

	public void getMessage(MessageItem msg) {
		  switch(msg.getMsgCode()) {
	        	case MessageItem.MSG_ACTIONPERFORMED:
	                switch(msg.getCode()){
	                case ACTION_HILFE_CODE: hilfeAction();break;
	                case ACTION_HIDE_CODE:hideAction();break;
	                case ACTION_CLOSE_CODE:closeWindow();break;
	                case ACTION_DELETE_CODE:deleteAction();break;
	                case ACTION_NEU_CODE:neuAction();break;
	                case ACTION_BEARBEITEN_CODE:editAction();break;
	                case ACTION_PRINT_CODE:druckenAction();break;
	                case ACTION_EXPORT_CODE:exportAction();break;
	                case ACTION_SUCHEN_CODE:suchenAction();break;
	                default :
	                    break;
	               }
	        		break;
	        	case MessageItem.MSG_DOKUMENT_EINGABE_REPLY:
	        			di = (DocumentItem)msg.getData();
	        			refreshAction();
	        			break;
		        case MessageItem.MSG_SHOW_DOKUMENT_ADRESSE:
		        	    multiMode = true;
		        	    filterMode = false;
		        	    ai = (AdressItem)msg.getData();
		        	    if(ai != null) {
		        	    	lblListe.setText(rz.getLocale().getString("dokumentenliste.adressen").replaceAll("%s", ai.getFirma()));
		        	    }
		        	    refreshAction();
		        	    break;
		        	    
		        case MessageItem.MSG_SHOW_DOKUMENT_LISTE_FILTER:
		        	   multiMode = false;
		        	   filterMode = true;
		        	   listenPanel.remove(northPanelLabel);
		        	   listenPanel.add(northPanelFilter,BorderLayout.NORTH);
		        	   rezepturListe = null;
		        	   rezeptur = 0;
		        	   txtFilter.setText(rz.getOptionFactory().getOption("dokumentenliste.filter.text"));	
		        	   refreshAction();
		               break;
		        case MessageItem.MSG_SHOW_DOKUMENT_LISTE_ALLE:
		        	   multiMode = true;
		        	   filterMode = false;
		        	   rezepturListe = (String)msg.getData();
		        	   rezeptur = msg.getCode();
		        	   try {
		        	     lblListe.setText(rz.getLocale().getString("dokumentenliste.multi").replaceAll("%s",rz.getDatabase().getRezeptur().dbGetRezepturName(rezeptur)));
		        	   }catch (Exception e){}
		        	   refreshAction();
		                break;
	           case MessageItem.MSG_SHOW_DOKUMENT_LISTE:
	        	   multiMode = false;
	        	   filterMode = false;
	        	   rezeptur = (Integer)msg.getData();
	        	   try {
	        	     lblListe.setText(rz.getLocale().getString("dokumentenliste.liste").replaceAll("%s",rz.getDatabase().getRezeptur().dbGetRezepturName(rezeptur)));
	        	   }catch (Exception e){}
	        	   refreshAction();
	                break;
	            default:
	                rz.getLogFactory().logMessage(2, "laborwertlistenfenster:", "auswahlAction:" + msg.getMsgCode());
	                break;
	        }
	}
	
	 private void ergebnisTimerEvent(){
		 if(tblListe != null) {
	        if(ergebnisTimer.isRunning()) {
				ergebnisTimer.stop();
			}
	        lstListeValueChanged();
	        setActions();
		}
	}
	 
	 private void saveDividerLocations(){
	        rz.getFensterFactory().setOption(this.getName() + ".splContent", this.splContent.getDividerLocation());
	        rz.getFensterFactory().saveOptions();
	    }
		/** setzt die Position der Splitbalken auf gespeicherte Positionen oder
		 * auf Standardposition, wenn keine gespeicherten vorliegen
		 *
		 */
	    private void setDividerLocations() {
	    	splContent.setDividerLocation(rz.getFensterFactory().getOption(this.getName() + ".splContent",this.getWidth()/4));
	    }

	@Override
	public void createActions() {
        actionList.put(String.valueOf(ACTION_CLOSE_CODE),new AuswahlAction(rz,this,ACTION_CLOSE_CODE,ACTION_CLOSE_TEXT,KeyEvent.VK_ESCAPE ,0));
        actionList.put(String.valueOf(ACTION_NEU_CODE),new AuswahlAction(rz,this,ACTION_NEU_CODE,ACTION_NEU_TEXT, KeyEvent.VK_N ,InputEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_BEARBEITEN_CODE),new AuswahlAction(rz,this,ACTION_BEARBEITEN_CODE,ACTION_BEARBEITEN_TEXT, KeyEvent.VK_F2 ,0));
        actionList.put(String.valueOf(ACTION_DELETE_CODE),new AuswahlAction(rz,this,ACTION_DELETE_CODE,ACTION_DELETE_TEXT,0 ,0));
        actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT, KeyEvent.VK_F5 ,InputEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT, KeyEvent.VK_F1 ,0));
        actionList.put(String.valueOf(ACTION_PRINT_CODE),new AuswahlAction(rz,this,ACTION_PRINT_CODE,ACTION_PRINT_TEXT, KeyEvent.VK_P ,InputEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_EXPORT_CODE),new AuswahlAction(rz,this,ACTION_EXPORT_CODE,ACTION_EXPORT_TEXT, 0 ,0));
        actionList.put(String.valueOf(ACTION_SUCHEN_CODE),new AuswahlAction(rz,this,ACTION_SUCHEN_CODE,ACTION_SUCHEN_TEXT, 0 ,0));
	}
	private void tbllisteSelectionChanged() {
		refreshAction();
	}

	@Override
	public void openWindow() {
	        if(!isVisible()) {
				setVisible(true);
			}
	        toFront();
	}

	@Override
	public void closeWindow() {
		saveDividerLocations();
	    rz.getFensterFactory().getFensterListe().disposeFrame(this);
	}

	public void setDocument(DocumentItem di) {
		this.di =di;
		refreshAction();
	}
	 /**
     * neu anlegen
     */
    private void neuAction() {
    	String path = "";
    	long size = 0;
    	String  dir = rz.getOptionFactory().getOption("document.load.directory");
    	final JFileChooser fc = new JFileChooser();
    	fc.addChoosableFileFilter(new FileNameExtensionFilter("PDF/JPG/PNG", "png","jpg", "pdf"));
    	fc.setAcceptAllFileFilterUsed(false);
    	fc.setDialogTitle(rz.getLocale().getString("document.load.file_titel"));
    	fc.setCurrentDirectory(new File(dir));
    	fc.setApproveButtonText(rz.getLocale().getString("dokumentenliste.upload"));
    	if(fc.showOpenDialog(this) == JFileChooser.APPROVE_OPTION) { 
    		path = fc.getSelectedFile().getPath();
    		Path pfad = Paths.get(path);
    		try {
				size = Files.size(pfad);
			} catch (IOException e) {}
    		if(size >  de.lunqual.rzpro.database.DBDocuments.MAX_FILE_SIZE) {
    			DialogItem dlgItem =  new DialogItem(0,"",0.0,"","","","","","",null);
    			dlgItem.setTyp(DialogControl.HINWEIS_DIALOG);
	            dlgItem.setCaption(rz.getLocale().getString("dokument.filesize"));
	            dlgItem.setTitel(rz.getLocale().getString("dokument.filesize"));
	            dlgItem.setMessage(rz.getLocale().getString("dokument.file_too_large"));
	            dlgItem.setIcon("frage.png");
	            dlgItem.setOk(rz.getLocale().getString("string_ok"));
	            rz.getDialogFactory().getDialog(dlgItem);
    		} else {
		    	if(!path.trim().equals("")) {
		    		rz.getOptionFactory().setOption("document.load.directory",path.toString());
		    		rz.getOptionFactory().saveOptions();
		    		DocumentItem di1 = rz.getDatabase().getDocuments().getNewDocument(rezeptur, path);
		    		if(di1 != null) {
		    			rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_DOCUMENT_EINGABE,false,new MessageItem(MessageItem.MSG_SHOW_DOKUMENT_EINGABE,0,(Object)di1,this));
		    		}
		    	}
	    	}
    	}
    }
    
  
    private void setActions() {
    	lblCount.setText(rz.getLocale().getString("dokumentenliste.label_count").replaceAll("%s", String.valueOf(liste.size())));
    	getAction(ACTION_NEU_CODE).setEnabled(false);
    	if(multiMode || filterMode) {
    	   getAction(ACTION_NEU_CODE).setEnabled(false);
    	} else {
	      getAction(ACTION_NEU_CODE).setEnabled(true);
    	}
    	getAction(ACTION_EXPORT_CODE).setEnabled(false);
    	getAction(ACTION_BEARBEITEN_CODE).setEnabled(false);
    	getAction(ACTION_DELETE_CODE).setEnabled(false);
    	getAction(ACTION_PRINT_CODE).setEnabled(false);
    	getAction(ACTION_SUCHEN_CODE).setEnabled(false);
    	if(tblListe.getSelectedRow()!= -1) {
    		getAction(ACTION_BEARBEITEN_CODE).setEnabled(true);
    		getAction(ACTION_DELETE_CODE).setEnabled(true);
    		getAction(ACTION_PRINT_CODE).setEnabled(true);
    		getAction(ACTION_EXPORT_CODE).setEnabled(true);
    		getAction(ACTION_SUCHEN_CODE).setEnabled(true);
    	}
    }
    
    private void lstListeValueChanged() {
    	if(tblListe.getSelectedRow() != -1) {
    		DocumentHeaderItem dhi = liste.get(tblListe.getSelectedRow());
	    	if(dhi != null) {
	    		di =rz.getDatabase().getDocuments().getDocument(dhi.getId());
	    		if(di != null) {
	    			switch(di.getTyp()) {
	    				case de.lunqual.rzpro.database.DBDocuments.TYP_PDF:
	    					if(currentDisplay != pdfDisplay){
	    						rightPanel.remove(currentDisplay);
	    						rightPanel.add(pdfDisplay);
	    						currentDisplay = pdfDisplay;
	    					}
	    					rz.setWaitCursor(this);
	    					pdfDisplay.setDocument(di);
	    					rz.setFreeCursor(this);
	    					break;
	    				case de.lunqual.rzpro.database.DBDocuments.TYP_JPG:
	    				case de.lunqual.rzpro.database.DBDocuments.TYP_PNG:
	    					if(currentDisplay != gfxDisplay){
	    						rightPanel.remove(currentDisplay);
	    						rightPanel.add(gfxDisplay);
	    						currentDisplay = gfxDisplay;
	    					}
	    					rz.setWaitCursor(this);
	    					gfxDisplay.setDocument(di);
	    					rz.setFreeCursor(this);
	    					break;
	    			}
	    			setActions();
	    		}
	    	} 
    	} else {
    		if(currentDisplay != emptyDisplay) {
    			rightPanel.remove(currentDisplay);
    			rightPanel.add(emptyDisplay);
    			currentDisplay = emptyDisplay;
    		}
    	}
		currentDisplay.repaint();
    }
    
    
    private void druckenAction(){
    	DocumentHeaderItem dhi = liste.get(tblListe.getSelectedRow());
        if (dhi != null) {
        	PrintService printer = choosePrinter();
        	if(printer != null) {
        		switch (dhi.getTyp()) {
        			case de.lunqual.rzpro.database.DBDocuments.TYP_PDF:
        				rz.setWaitCursor(this);
        				pdfDisplay.print(printer);
        				rz.setFreeCursor(this);
        				break;
        			case de.lunqual.rzpro.database.DBDocuments.TYP_JPG:
        			case de.lunqual.rzpro.database.DBDocuments.TYP_PNG:
        				rz.setWaitCursor(this);
        				gfxDisplay.print(printer);
        				rz.setFreeCursor(this);
        				break;
        		}
        	}
        }
    }
    
   
    
    public static PrintService choosePrinter() {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        if(printJob.printDialog()) {
            return printJob.getPrintService();          
        }
        else {
            return null;
        }
    }
    
    private void suchenAction() {
    	DocumentHeaderItem dhi = liste.get(tblListe.getSelectedRow());
    	if(dhi != null) {
    		DocumentItem di = rz.getDatabase().getDocuments().getDocument(dhi.getId());
    		if(di != null) {
    			int rezeptur = di.getRezeptur();
    			if(rezeptur != 0) {
    				final AbfrageItem ai = new AbfrageItem();
    				ai.setID(0);
    				ai.setAdressListe(new StichwortListe());
    				ai.setStichwortListe(new StichwortListe());
    				ai.setTyp(de.lunqual.rzpro.database.DBAbfrage.ABFRAGE_TYP_SQL);
    				ai.setMuster(rz.getDatabase().getErgebnis().getErweitertSQLPrefix() + " rezeptliste.id =" + String.valueOf(rezeptur) + "  group by rezeptliste.id order by name");
    				try {
    					rz.setWaitCursor(this);
    					JRzFrame frame = rz.getFensterFactory().getFensterListe().getAuswahl();
    					frame.getMessage(new MessageItem(MessageItem.MSG_ADD_QUERY_REZEPT, ai.getID(), ai,this)); 
    					rz.setFreeCursor(this);
    				} catch (final Exception e) {}
    			}
    		}
    	}
    }
    
    private void exportAction() {
    	DocumentHeaderItem dhi = liste.get(tblListe.getSelectedRow());
    	if(dhi != null) {
    		DocumentItem di = rz.getDatabase().getDocuments().getDocument(dhi.getId());
    		if(di != null) {
    			String path = "";
    	    	final JFileChooser fc = new JFileChooser();
    	    	fc.setDialogTitle(rz.getLocale().getString("dokumentenliste.save_file_titel"));
    	    	fc.setSelectedFile(new File(di.getFilename()));
    	    	fc.setCurrentDirectory(new File(rz.getOptionFactory().getOption("dokumentenliste.save.directory")));
    	    	if(fc.showSaveDialog(this) == JFileChooser.APPROVE_OPTION) {
    	    		path = fc.getSelectedFile().getPath();
    		    	if(!path.trim().equals("")) {
    		    		try (FileOutputStream stream = new FileOutputStream(path)) {
    		    		    stream.write(di.getDaten());
    		    		    rz.getOptionFactory().setOption("dokumentenliste.save.directory",fc.getCurrentDirectory().getPath());
    		    		    rz.getOptionFactory().saveOptions();
    		    		} catch (FileNotFoundException e) {
						} catch (IOException e) {}
    		    	}
    	    	}
    		}
    	}
    }
    /**
     * ändern
     */
    private void editAction() {
    	DocumentHeaderItem dhi = liste.get(tblListe.getSelectedRow());
    	if(dhi != null) {
    		DocumentItem di1 = rz.getDatabase().getDocuments().getDocument(dhi.getId());
    		if(di1 != null) {
    			rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_DOCUMENT_EINGABE,false,new MessageItem(MessageItem.MSG_SHOW_DOKUMENT_EINGABE,0,(Object)di1,this));
    		}
    	}
    }
    /**
     * löschen
     */
    private void deleteAction() {
    	if(tblListe.getSelectedRow()!= -1) {
        	DocumentHeaderItem dhi = liste.get(tblListe.getSelectedRow());
    		if(dhi != null) {
    			DialogItem dlgItem =  new DialogItem(0,"",0.0,"","","","","","",null);
    			dlgItem.setTyp(DialogControl.FRAGE_DIALOG);
	            dlgItem.setCaption(rz.getLocale().getString("dokumentenliste.delete"));
	            dlgItem.setTitel(rz.getLocale().getString("dokumentenliste.delete"));
	            dlgItem.setMessage(rz.getLocale().getString("dokumentenliste.delete.frage").replaceAll("%s", dhi.getFilename()));
	            dlgItem.setIcon("frage.png");
	            dlgItem.setOk(rz.getLocale().getString("string_ja"));
	            dlgItem.setCancel(rz.getLocale().getString("string_nein"));
	            rz.getDialogFactory().getDialog(dlgItem);
	            if((dlgItem.getReplyCode() == DialogControl.DIALOG_OK) || (dlgItem.getReplyCode()==DialogControl.DIALOG_YES)) {
	            	rz.getDatabase().getDocuments().deleteDocument(dhi.getId());
	            	refreshAction();
	            }
    		}
    	}
    	try {
    		rz.getFensterFactory().getFensterListe().propagateBestand(rz.getFensterFactory().getFensterListe().getAuswahl());
    	}catch(Exception e) {}
    	refreshAction();

    }
	
    private void refreshAction() {
    	if(multiMode) {
    		if(ai != null) {
    			liste = rz.getDatabase().getDocuments().getAdressenHeaders(ai);
    	        ((AbstractTableModel)tblListe.getModel()).fireTableDataChanged();
    	        if(liste.size() > 0) {
    	        	//tblListe.setRowSelectionInterval(liste.size()-1,liste.size()-1);
    	        	tblListe.setRowSelectionInterval(0,0);
    	        }
    		} else {
	    		if(!rezepturListe.equals("")) {
	    			liste = rz.getDatabase().getDocuments().getRezepturAlleHeaders(rezepturListe);
	    	        ((AbstractTableModel)tblListe.getModel()).fireTableDataChanged();
	    	        if(liste.size() > 0) {
	    	        	//tblListe.setRowSelectionInterval(liste.size()-1,liste.size()-1);
	    	        	tblListe.setRowSelectionInterval(0,0);
	    	        }
	    		}
    		}
    	} else if (filterMode) {
    		String regString = txtFilter.getText().trim();
    		regString = regString.replaceAll("[ ]+", ".*").replaceAll("\\(", "\\\\(").replaceAll("\\)", "\\\\)");
    	        if (regString.equals("")) {
    	            regString = ".*";
    	        }
    		liste = rz.getDatabase().getDocuments().getRezepturHeaders(regString);
    		((AbstractTableModel)tblListe.getModel()).fireTableDataChanged();
	        if(liste.size() > 0) {
	        	//tblListe.setRowSelectionInterval(liste.size()-1,liste.size()-1);
	        	tblListe.setRowSelectionInterval(0,0);
	        }
	        txtFilter.requestFocus();
	        rz.getOptionFactory().setOption("dokumentenliste.filter.text",txtFilter.getText());
    	} else {
	    	if(rezeptur != 0) {
	    		liste = rz.getDatabase().getDocuments().getRezepturHeaders(rezeptur);
    	        ((AbstractTableModel)tblListe.getModel()).fireTableDataChanged();
    	        if(liste.size() > 0) {
    	        	//tblListe.setRowSelectionInterval(liste.size()-1,liste.size()-1);
    	        	tblListe.setRowSelectionInterval(0,0);
    	        }
	    	}
    	}
    	lstListeValueChanged();
		setActions();
    	tblListe.scrollRectToVisible(tblListe.getCellRect(liste.size()-1, 0,true));
    }

    //Extras-Menü
    private void hideAction(){
        rz.getFensterFactory().getFensterListe().sperren(this);
    }

    //hilfe-menü
    private void hilfeAction(){
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"laborwertliste.html",this));
    }


	@Override
	public void columnAdded(TableColumnModelEvent e) {
	}
	@Override
	public void columnRemoved(TableColumnModelEvent e) {
	}
	@Override
	public void columnMoved(TableColumnModelEvent e) {
	}
	@Override
	public void columnMarginChanged(ChangeEvent e) {
	}
	@Override
	public void columnSelectionChanged(ListSelectionEvent e) {
	}

    private void setTableModel(JTable t) {
	    final ErgebnisColumnModel rcm = new ErgebnisColumnModel();
	    final StringRenderer sr = new StringRenderer();
	    final IconRenderer ir = new IconRenderer();
	    TableColumn tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("dokumentenliste.tableheader_c_icon"));
	    	tc.setModelIndex(C_ICON);
	    	tc.setCellRenderer(ir);
	    rcm.addColumn(tc);
	    tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("dokumentenliste.tableheader_c_name"));
	    	tc.setModelIndex(C_NAME);
	    	tc.setCellRenderer(sr);
	    rcm.addColumn(tc);
	    tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("dokumentenliste.tableheader_c_filename"));
	    	tc.setModelIndex(C_FILENAME);
	    	tc.setCellRenderer(sr);
	    rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("dokumentenliste.tableheader_c_erstellt"));
			tc.setModelIndex(C_ERSTELLT);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("dokumentenliste.tableheader_c_geaendert"));
			tc.setModelIndex(C_GEAENDERT);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
	 
        rcm.addColumnModelListener(this);
        tblListe.setModel(new ergebnisTableModel());
        tblListe.setColumnModel(rcm);
        tblListe.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
        tblListe.getTableHeader().setReorderingAllowed(false);
	}
	
	

	private class ErgebnisColumnModel extends DefaultTableColumnModel{
	    public ErgebnisColumnModel() {
	        super();
	    }
	}
	
	
	private  class ergebnisTableModel extends AbstractTableModel    {
		Icon pdfIcon,bildIcon;
        SimpleDateFormat df;

        public ergebnisTableModel() {
        	super();
	    	pdfIcon = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/dokumentenliste.icon.pdf.png"));
			bildIcon = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/dokumentenliste.icon.bild.png"));
            df = new SimpleDateFormat("EEEE, dd.MM.yyyy HH:mm");
        }

	   public int getColumnCount() {
	       	return C_MAX;
        }
        public int getRowCount() {
        	if(liste != null) {
                return liste.size();
        	} else {
        		return 0;
        	}
        }

        public DocumentHeaderItem getZeileAt(int rowIndex) {
        	if((rowIndex != -1) && (liste!= null)) {
        		return liste.get(rowIndex);
        	} else {
				return null;
			}
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            Object ret = null;
            if((rowIndex != -1) && (liste!= null)) {
                ret = getContent(liste.get(rowIndex),columnIndex,rowIndex);
            }
            return ret;
        }

        private Object getContent(DocumentHeaderItem dhi,int aColumn,int row) {
            Object ret = null;
            if(dhi != null) {
	            switch(aColumn){
	            	case C_ICON: if(dhi.getTyp() == de.lunqual.rzpro.database.DBDocuments.TYP_PDF) {
	            		ret = pdfIcon;
	            	} else {
	            		ret = bildIcon;
	            	}
	            	break;
	            	case C_NAME:ret = dhi.getName();
	            	break;
	            	case C_FILENAME:ret = dhi.getFilename();
	            	break;
	            	case C_ERSTELLT:ret = df.format(dhi.getErstellt()) + " ("+dhi.getUser1()+")";
	            	break;
	            	case C_GEAENDERT:ret = df.format(dhi.getGeaendert()) + " ("+dhi.getUser2()+")";
	            	break;
 	            		
	            }
            }
            return ret;
        }
	}
	
	private class StringRenderer extends DefaultTableCellRenderer {

	    StringRenderer() {
	        super();
	        setOpaque(true);
	    }
	    public Component getTableCellRendererComponent(JTable table,
                Object value, boolean isSelected, boolean hasFocus, int row,
                int column)
	    {
	    	
    		if(isSelected) {
    			setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_SELECTED));
    	    	setFont(rz.getFontFactory().getTableBoldFont());
    		}else {
    			setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_NORMAL));
    	    	setFont(rz.getFontFactory().getTableFont());
    		}
        	setText((String)value);
        	setIcon(null);
	        setHorizontalAlignment(SwingConstants.LEADING);
	        return this;
        }
	}

	/** rendert alle Tabellenzeilen mit icon Inhalt
	 *  im wesentlichen heisst das rechts-ausgerichtent
	 * @author lunqual
	 */
	private class IconRenderer extends DefaultTableCellRenderer {

	    IconRenderer() {
	        super();
	        setOpaque(true);
	    }
	    public Component getTableCellRendererComponent(JTable table,
                Object value, boolean isSelected, boolean hasFocus, int row,
                int column)
	    {
    		if(isSelected) {
    			setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_SELECTED));
    	    	setFont(rz.getFontFactory().getTableBoldFont());
    		}else {
    			setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_NORMAL));
    	    	setFont(rz.getFontFactory().getTableFont());
    		}
	    	if((row != -1) && (liste != null)) {
		        if(value != null) {
		            setText("");
		            setIcon((Icon)value);
	        }
	    }
	    return this;
	    }
	}
	public class ColumnHeaderListener extends MouseAdapter {
	    public void mouseClicked(MouseEvent evt) {
	        JTable table = ((JTableHeader)evt.getSource()).getTable();
	        TableColumnModel colModel = table.getColumnModel();

	        int vColIndex = colModel.getColumnIndexAtX(evt.getX());
	        // Return if not clicked on any column header
	        if (vColIndex == -1) {
	            return;
	        }
	        // Determine if mouse was clicked between column heads
	        Rectangle headerRect = table.getTableHeader().getHeaderRect(vColIndex);
	        if (vColIndex == 0) {
	            headerRect.width -= 3;    // Hard-coded constant
	        } else {
	            headerRect.grow(-3, 0);   // Hard-coded constant
	        }
	        if (!headerRect.contains(evt.getX(), evt.getY())) {
	            // Mouse was clicked between column heads
	            // vColIndex is the column head closest to the click

	            // vLeftColIndex is the column head to the left of the click
	            if (evt.getX() < headerRect.x) {
	                vColIndex--;
	            }
	        }
	        if(liste != null && liste.size()>0) {
	        	String sel = "";
	        	try {
	        		sel=liste.getItem(tblListe.getSelectedRow()).getName();
	        	}catch (Exception e) {}
		        switch(vColIndex) {
		        	case C_NAME:
		        		liste.sortName();
		        		break;
		        	case C_FILENAME:
		        		liste.sortFileName();
		        		break;
		        	case C_ERSTELLT:
		        		liste.sortErstellt();
		        		break;
		        	case C_GEAENDERT:
		        		liste.sortGeaendert();
		        		break;
		        }
		        	
                ((AbstractTableModel)tblListe.getModel()).fireTableDataChanged();
		        if(sel != null && !sel.equals("")) {
		        	for(int i=0;i<liste.size();i++) {
		        		if(tblListe.getModel().getValueAt(i,1).equals(sel)) {
		        			tblListe.getSelectionModel().setSelectionInterval(i,i);
		        	        tblListe.scrollRectToVisible(tblListe.getCellRect(i, 0,true));
		        			break;
		        		}
		        	}
		        }
	        }
	    }
	}
	
}

