package de.lunqual.rzpro.fenster.dokumente;


import java.awt.BorderLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.text.SimpleDateFormat;

import javax.print.PrintService;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SwingConstants;


import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.documents.DocumentItem;
import de.lunqual.rzpro.options.OptionFactory;

public class GFXDisplay extends JPanel implements Printable {
	
	private 	JPanel controlPanel;
			private 	JLabel lblScale;
			private 	JSpinner spScale;
			private 	JButton btRotateLeft;
			private 	JButton btRotateRight;
	private JPanel pagePanel;
		private JScrollPane scrDocument;
		private DokumentenPanel dokumentPanel;
	private JPanel infoPanel;
		private JLabel lblTyp;
		private JLabel lblTyp1;
		private JLabel lblName;
		private JLabel txtName;
		private JLabel lblFilename;
		private JLabel txtFileName;
		private JLabel lblBemerkungen;
		private JLabel txtBemerkungen;
		private JLabel lblRezeptur;
		private JLabel txtRezeptur;
		private JLabel lblErstellt;
		private JLabel lblGeaendert;
		
	RzPro					rz;
	DocumentItem			di;
	boolean 				info = false;
	ImageIcon 			rLeft,rRight;
	
	public GFXDisplay(RzPro rz,boolean info) {
		super();
		di = null;
		this.info = info;
		this.rz = rz;
		rLeft = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/gfxDisplayRotateLeft.png"));
		rRight = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/gfxDisplayRotateRight.png"));
		this.setLayout(new BorderLayout());
		createGUI();
	}
	
	public void setDocument(DocumentItem di) {
		this.di = di;
		if(di != null) {
			dokumentPanel.setDocument(di, (int)spScale.getValue(),0);
			spScale.setValue(di.getZoom());
			if(info) {
				showInfo();
			}
		}
	}
	
	
	private void createGUI() {
		controlPanel = new JPanel(new GridLayout(1,7));
		controlPanel.setBorder(BorderFactory.createEtchedBorder());
		btRotateLeft = new JButton(); 
		controlPanel.add(btRotateLeft);
			btRotateLeft.addActionListener(new ActionListener() {
	        	public void actionPerformed(ActionEvent evt) {
	        		if(dokumentPanel != null) {
	        			setDocument(dokumentPanel.rotate(-90.0));
	        		}
	        	}
    	    });
		btRotateLeft.setIcon(rLeft);
		btRotateLeft.setText(rz.getLocale().getString("gfxDisplay.rotate.left"));
		btRotateRight = new JButton(); 
		btRotateRight.addActionListener(new ActionListener() {
        	public void actionPerformed(ActionEvent evt) {
        		if(dokumentPanel != null) {
        			di = dokumentPanel.rotate(90.0);
        		}
        	}
	    });
		btRotateRight.setIcon(rRight);
		btRotateRight.setText(rz.getLocale().getString("gfxDisplay.rotate.right"));
		controlPanel.add(btRotateRight);
		lblScale = new JLabel();
			lblScale.setHorizontalAlignment(SwingConstants.TRAILING);
		controlPanel.add(lblScale);
		spScale = new JSpinner();
			Integer v = Integer.valueOf(rz.getOptionFactory().getOption("gfxdocument.scale",100));
			spScale.setValue(v);
			spScale.addChangeListener(new javax.swing.event.ChangeListener() {
				public void stateChanged(javax.swing.event.ChangeEvent evt) {
					scaleChanged();
            	}
			});

		controlPanel.add(spScale);
		this.add(controlPanel,BorderLayout.NORTH);


		dokumentPanel = new DokumentenPanel(rz);
		dokumentPanel.setBorder(BorderFactory.createEtchedBorder());
		scrDocument = new JScrollPane();
			scrDocument.setViewportView(dokumentPanel);
		this.add(scrDocument,BorderLayout.CENTER);
	    lblScale.setText(rz.getLocale().getString("pdfdisplay.label_scale"));
	    this.setBorder(BorderFactory.createEtchedBorder());
	    
	    if(info) {
	    	infoPanel = new JPanel(new GridLayout(7,2));
	    	infoPanel.setBorder(BorderFactory.createEtchedBorder());
	    	lblTyp = new JLabel();
			lblTyp.setHorizontalAlignment(SwingConstants.TRAILING);
			infoPanel.add(lblTyp);	
			lblTyp1 = new JLabel();
				lblTyp1.setHorizontalAlignment(SwingConstants.LEADING);
			infoPanel.add(lblTyp1);
			lblName = new JLabel();
				lblName.setHorizontalAlignment(SwingConstants.TRAILING);
			infoPanel.add(lblName);
			txtName = new JLabel();
				txtName.setHorizontalAlignment(SwingConstants.LEADING);
			infoPanel.add(txtName);
			lblFilename = new JLabel();
				lblFilename.setHorizontalAlignment(SwingConstants.TRAILING);
			infoPanel.add(lblFilename);
			txtFileName = new JLabel();
				txtFileName.setHorizontalAlignment(SwingConstants.LEADING);
			infoPanel.add(txtFileName);
			lblBemerkungen = new JLabel();
				lblBemerkungen.setHorizontalAlignment(SwingConstants.TRAILING);
			infoPanel.add(lblBemerkungen);
			txtBemerkungen = new JLabel();
				txtBemerkungen.setHorizontalAlignment(SwingConstants.LEADING);
			infoPanel.add(txtBemerkungen);
			lblRezeptur = new JLabel();
				lblRezeptur.setHorizontalAlignment(SwingConstants.TRAILING);
			infoPanel.add(lblRezeptur);
			txtRezeptur = new JLabel();
				txtRezeptur.setHorizontalAlignment(SwingConstants.LEADING);
			infoPanel.add(txtRezeptur);
			lblErstellt = new JLabel();
				lblErstellt.setHorizontalAlignment(SwingConstants.TRAILING);
			infoPanel.add(lblErstellt);
		     lblGeaendert = new JLabel();
		     	lblGeaendert.setHorizontalAlignment(SwingConstants.LEADING);
		     infoPanel.add(lblGeaendert);	
		      lblTyp.setText(rz.getLocale().getString("dokumenteneingabe.label_typ"));
		      lblName.setText(rz.getLocale().getString("dokumenteneingabe.label_name"));
		      lblFilename.setText(rz.getLocale().getString("dokumenteneingabe.label_filename"));
		      lblBemerkungen.setText(rz.getLocale().getString("dokumenteneingabe.label_bemerkungen"));
		      lblRezeptur.setText(rz.getLocale().getString("dokumenteneingabe.label_rezeptur"));
	    	this.add(infoPanel,BorderLayout.SOUTH );
	    }
	}

	private void showInfo() {
		if(info && infoPanel != null) {
			   final SimpleDateFormat df = new SimpleDateFormat("EEEE dd.MM YYYY");
				if(di != null){
					double size = (double)di.getDaten().length/(1024*1024);
					lblTyp1.setText(rz.getDatabase().getDocuments().getDokumentString(di.getTyp()) + " ("+ rz.getLocale().formatNumber(size,OptionFactory.NF_TWO) + " MB)");
					txtName.setText(di.getName());
					txtFileName.setText(di.getFilename());
					txtBemerkungen.setText(di.getBemerkungen());
					txtRezeptur.setText(rz.getDatabase().getRezeptur().dbGetRezepturNameNEX(di.getRezeptur())+ " ("+Integer.valueOf(di.getRezeptur())+")");
					lblErstellt.setText(rz.getLocale().getString("dokument.erstellt") + " "+  df.format(di.getErstellt())+ " ("+ di.getUser1() + ")");
					lblGeaendert.setText(rz.getLocale().getString("dokument.geaendert") + " "+ df.format(di.getGeaendert())+ " ("+ di.getUser2() + ")");
				}
		}
	}
	

	    private void scaleChanged() {
	    	int value = (int)spScale.getValue();
	    	if(value < rz.getOptionFactory().getOption("dokumentpanel.min_scale", de.lunqual.rzpro.options.OptionFactory.DOKUMENTPANEL_MIN_SCALE)) {
	    		value = rz.getOptionFactory().getOption("dokumentpanel.min_scale", de.lunqual.rzpro.options.OptionFactory.DOKUMENTPANEL_MIN_SCALE);
	    		spScale.setValue(value);
	    	} else if(value > rz.getOptionFactory().getOption("dokumentpanel.max_scale", de.lunqual.rzpro.options.OptionFactory.DOKUMENTPANEL_MAX_SCALE)) {
	    		value =rz.getOptionFactory().getOption("dokumentpanel.max_scale", de.lunqual.rzpro.options.OptionFactory.DOKUMENTPANEL_MAX_SCALE);
	    		spScale.setValue(value);
	    	}
	    	di.setZoom(value);
	    	rz.getOptionFactory().setOption("gfxdocument.scale", value);
			rz.getOptionFactory().saveOptions();
	    	dokumentPanel.setScale(value);
	    	rz.getDatabase().getDocuments().udpateZoom(di.getId(),value);
	    	dokumentPanel.repaint();
	    }
	
	    public void print(PrintService printer) {
	    	if(di != null) {
	    		final PrinterJob job = PrinterJob.getPrinterJob();
	    		job.setPrintable(this);
	    		try {
					job.print();
				} catch (PrinterException e) {}
		    }
	    }

		@Override
		public int print(Graphics graphics, PageFormat pageFormat,int pageIndex) throws PrinterException {
			if(pageIndex != 0){
	            return Printable.NO_SUCH_PAGE;
	        }
	        else {
	            final Graphics2D g2d = (Graphics2D)graphics;
	            g2d.translate(pageFormat.getImageableX(),
	                          pageFormat.getImageableY());
	            final int cw = dokumentPanel.getWidth();
	            final int ch = dokumentPanel.getHeight();
	            final double pw = pageFormat.getImageableWidth();
	            final double ph = pageFormat.getImageableHeight();
	            if ((cw > pw) || (ch > ph)) {
	                final double scaleX = pw / cw;
	                final double scaleY = ph / ch;
	                final double scale = scaleX < scaleY ? scaleX : scaleY;
	                g2d.scale(scale, scale);
	            }
	        dokumentPanel.printAll(g2d);
	        return Printable.PAGE_EXISTS;
	        }
			
		}


}
