package de.lunqual.rzpro.fenster.dokumente;


import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.IOException;
import java.text.SimpleDateFormat;

import javax.print.PrintService;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SwingConstants;

import org.apache.pdfbox.Loader;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.printing.PDFPageable;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.documents.DocumentItem;
import de.lunqual.rzpro.options.OptionFactory;

public class PDFDisplay extends JPanel {
	
	private 	JPanel controlPanel;
			private 	JLabel lblPage;
			private 	JSpinner spPage;
			private     JLabel lblPageNumber;
			private 	JLabel lblScale;
			private 	JSpinner spScale;
	private JPanel pagePanel;
		private JScrollPane scrDocument;
		private DokumentenPanel dokumentPanel;
	private JPanel southPanel;
		private JPanel infoPanel;
			private JLabel lblTyp;
			private JLabel lblTyp1;
			private JLabel lblName;
			private JLabel txtName;
			private JLabel lblFilename;
			private JLabel txtFileName;
			private JLabel lblBemerkungen;
			private JLabel txtBemerkungen;
			private JLabel lblRezeptur;
			private JLabel txtRezeptur;
			private JLabel lblErstellt;
			private JLabel lblGeaendert;
	private JPanel PageButtonPanel;
		private JPanel pageInlayPanel;
			private JButton btFirstPage;
			private JButton btPrevPage;
			private JLabel lblPageNumberSouth;
			private JButton btNextPage;
			private JButton btLastPage;
			
	private static final int	PAGE_FIRST = 1;
	private static final int	PAGE_LAST = 2;
	private static final int	PAGE_NEXT = 3;
	private static final int	PAGE_PREV = 4;
		
	RzPro					rz;
	DocumentItem			di;
	boolean 				info = false;
	Icon						icFirst,icLast,icNext,icPrev;
	
	public PDFDisplay(RzPro rz,boolean info) {
		super();
		di = null;
		this.info = info;
		this.rz = rz;
    	icFirst = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/pdfdisplay.action_first.png"));
    	icLast = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/pdfdisplay.action_last.png"));
    	icPrev = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/pdfdisplay.action_prev.png"));
    	icNext = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/pdfdisplay.action_next.png"));
		this.setLayout(new BorderLayout());
		createGUI();
	}
	
	public void setDocument(DocumentItem di) {
		this.di = di;
		if(di != null) {
			dokumentPanel.setDocument(di, (int)spScale.getValue(),0);
			lblPageNumber.setText("/" + di.getSeiten());
			lblPageNumberSouth.setText(rz.getLocale().getString("pdfdisplay.pagenumber").replaceAll("%n", "1").replaceAll("%p",String.valueOf(di.getSeiten())));
			spPage.setValue(1);
			pageChanged();
			spScale.setValue(di.getZoom());
			if(info) {
				showInfo();
			}
		}
	}
	
	
	private void createGUI() {
		controlPanel = new JPanel(new GridLayout(1,5));
		controlPanel.setBorder(BorderFactory.createEtchedBorder());
		lblPage = new JLabel();
			lblPage.setHorizontalAlignment(SwingConstants.TRAILING);
		controlPanel.add(lblPage);
		spPage = new JSpinner();
			spPage.setValue(1);
			spPage.addChangeListener(new javax.swing.event.ChangeListener() {
				public void stateChanged(javax.swing.event.ChangeEvent evt) {
					pageChanged();
            	}
			});
		controlPanel.add(spPage);
		lblPageNumber = new JLabel();
			lblPageNumber.setHorizontalAlignment(SwingConstants.LEADING);
		controlPanel.add(lblPageNumber);
		lblScale = new JLabel();
			lblScale.setHorizontalAlignment(SwingConstants.TRAILING);
		controlPanel.add(lblScale);
		spScale = new JSpinner();
			Integer v = Integer.valueOf(rz.getOptionFactory().getOption("pdfdocument.scale",100));
			spScale.setValue(v);
			spScale.addChangeListener(new javax.swing.event.ChangeListener() {
				public void stateChanged(javax.swing.event.ChangeEvent evt) {
					scaleChanged();
            	}
			});

		controlPanel.add(spScale);
		this.add(controlPanel,BorderLayout.NORTH);


		dokumentPanel = new DokumentenPanel(rz);
		dokumentPanel.setBorder(BorderFactory.createEtchedBorder());
		scrDocument = new JScrollPane();
			scrDocument.setViewportView(dokumentPanel);
		this.add(scrDocument,BorderLayout.CENTER);
	    lblPage.setText(rz.getLocale().getString("pdfdisplay.label_page"));
	    lblScale.setText(rz.getLocale().getString("pdfdisplay.label_scale"));
	    this.setBorder(BorderFactory.createEtchedBorder());

	    southPanel = new JPanel(new BorderLayout());
	    this.add(southPanel,BorderLayout.SOUTH );
	    if(info) {
	    	infoPanel = new JPanel(new GridLayout(6,2));
	    	infoPanel.setBorder(BorderFactory.createEtchedBorder());
	    	lblTyp = new JLabel();
			lblTyp.setHorizontalAlignment(SwingConstants.TRAILING);
			infoPanel.add(lblTyp);	
			lblTyp1 = new JLabel();
				lblTyp1.setHorizontalAlignment(SwingConstants.LEADING);
			infoPanel.add(lblTyp1);
			lblName = new JLabel();
				lblName.setHorizontalAlignment(SwingConstants.TRAILING);
			infoPanel.add(lblName);
			txtName = new JLabel();
				txtName.setHorizontalAlignment(SwingConstants.LEADING);
			infoPanel.add(txtName);
			lblFilename = new JLabel();
				lblFilename.setHorizontalAlignment(SwingConstants.TRAILING);
			infoPanel.add(lblFilename);
			txtFileName = new JLabel();
				txtFileName.setHorizontalAlignment(SwingConstants.LEADING);
			infoPanel.add(txtFileName);
			lblBemerkungen = new JLabel();
				lblBemerkungen.setHorizontalAlignment(SwingConstants.TRAILING);
			infoPanel.add(lblBemerkungen);
			txtBemerkungen = new JLabel();
				txtBemerkungen.setHorizontalAlignment(SwingConstants.LEADING);
			infoPanel.add(txtBemerkungen);
			lblRezeptur = new JLabel();
				lblRezeptur.setHorizontalAlignment(SwingConstants.TRAILING);
			infoPanel.add(lblRezeptur);
			txtRezeptur = new JLabel();
				txtRezeptur.setHorizontalAlignment(SwingConstants.LEADING);
			infoPanel.add(txtRezeptur);
			lblErstellt = new JLabel();
				lblErstellt.setHorizontalAlignment(SwingConstants.TRAILING);
			infoPanel.add(lblErstellt);
		     lblGeaendert = new JLabel();
		     	lblGeaendert.setHorizontalAlignment(SwingConstants.LEADING);
		     infoPanel.add(lblGeaendert);	
		      lblTyp.setText(rz.getLocale().getString("dokumenteneingabe.label_typ"));
		      lblName.setText(rz.getLocale().getString("dokumenteneingabe.label_name"));
		      lblFilename.setText(rz.getLocale().getString("dokumenteneingabe.label_filename"));
		      lblBemerkungen.setText(rz.getLocale().getString("dokumenteneingabe.label_bemerkungen"));
		      lblRezeptur.setText(rz.getLocale().getString("dokumenteneingabe.label_rezeptur"));
		      southPanel.add(infoPanel,BorderLayout.NORTH);
		   }
	    	PageButtonPanel=new JPanel(new  BorderLayout());
	    		pageInlayPanel= new JPanel(new GridLayout(1,5));
	    		btFirstPage = new JButton();
    			btFirstPage.addActionListener(new ActionListener() {
        	        	public void actionPerformed(ActionEvent evt) {
	        	        		pageButtons(PAGE_FIRST);
	        	        	}
		        	    });
    			pageInlayPanel.add(btFirstPage);
	    		btPrevPage = new JButton();
	    			btPrevPage.addActionListener(new ActionListener() {
	        	        	public void actionPerformed(ActionEvent evt) {
		        	        		pageButtons(PAGE_PREV);
		        	        	}
			        	    });
	    		pageInlayPanel.add(btPrevPage);
	    		lblPageNumberSouth = new JLabel();
	    		lblPageNumberSouth.setHorizontalAlignment(SwingConstants.CENTER);
	    		pageInlayPanel.add(lblPageNumberSouth);
	    		btNextPage = new JButton();
	    		btNextPage.addActionListener(new ActionListener() {
    	        	public void actionPerformed(ActionEvent evt) {
        	        		pageButtons(PAGE_NEXT);
        	        	}
	        	    });
	    		pageInlayPanel.add(btNextPage);
	    		btLastPage = new JButton();
    			btLastPage.addActionListener(new ActionListener() {
        	        	public void actionPerformed(ActionEvent evt) {
	        	        		pageButtons(PAGE_LAST);
	        	        	}
		        	    });
    			pageInlayPanel.add(btLastPage);
	    		
	    		PageButtonPanel.add(pageInlayPanel,BorderLayout.WEST);
	    	southPanel.add(PageButtonPanel,BorderLayout.SOUTH);
	    	btPrevPage.setEnabled(false);
	    	btNextPage.setEnabled(false);
	    	btPrevPage.setIcon(icPrev);
	    	btNextPage.setIcon(icNext);
	    	btFirstPage.setIcon(icFirst);
	    	btLastPage.setIcon(icLast);
	        lblPageNumberSouth.setText(rz.getLocale().getString("pdfdisplay.pagenumber").replaceAll("%n", "").replaceAll("%p",""));
	}

	private void showInfo() {
		if(info && infoPanel != null) {
			   final SimpleDateFormat df = new SimpleDateFormat("EEEE dd.MM YYYY");
				if(di != null){
					double size = (double)di.getDaten().length/(1024*1024);
					lblTyp1.setText(rz.getDatabase().getDocuments().getDokumentString(di.getTyp()) + " ("+ rz.getLocale().formatNumber(size,OptionFactory.NF_TWO) + " MB)");
					txtName.setText(di.getName());
					txtFileName.setText(di.getFilename());
					txtBemerkungen.setText(di.getBemerkungen());
					txtRezeptur.setText(rz.getDatabase().getRezeptur().dbGetRezepturNameNEX(di.getRezeptur())+ " ("+Integer.valueOf(di.getRezeptur())+")");
					lblErstellt.setText(rz.getLocale().getString("dokument.erstellt") + " "+  df.format(di.getErstellt())+ " ("+ di.getUser1() + ")");
					lblGeaendert.setText(rz.getLocale().getString("dokument.geaendert") + " "+ df.format(di.getGeaendert())+ " ("+ di.getUser2() + ")");
				}
		}
	}
	
	private void pageButtons(int n) {
		switch(n) {
			case PAGE_FIRST:
				spPage.setValue(1);;
				break;
			case PAGE_LAST:
				if(di != null) {
					spPage.setValue(di.getSeiten());
				} else {
					spPage.setValue(1);
				}
				break;
			case PAGE_NEXT:
				spPage.setValue((int)spPage.getValue() +1);
				break;
			case PAGE_PREV:
				spPage.setValue((int)spPage.getValue() -1);
				break;
		}
	}
	
	private void pageChanged() {
	    	if(di != null){
	    		int seite = (int)spPage.getValue();
	        	if(seite <1) {
	        		spPage.setValue(1);
	        	} else if(seite > di.getSeiten()) {
	        		spPage.setValue(di.getSeiten());
	        		seite = di.getSeiten();
	        	}
	   			dokumentPanel.setPage(seite-1);
	        	dokumentPanel.repaint();
	    		lblPageNumberSouth.setText(rz.getLocale().getString("pdfdisplay.pagenumber").replaceAll("%n", String.valueOf(seite)).replaceAll("%p",String.valueOf(di.getSeiten())));
	    		if(seite == 1 && seite < di.getSeiten()) {
	    			btPrevPage.setEnabled(false);
	    			btNextPage.setEnabled(true);
	    			btFirstPage.setEnabled(false);
	    			btLastPage.setEnabled(true);
	    		} else {
	    			if (seite >1 && seite < di.getSeiten()) {
		    			btPrevPage.setEnabled(true);
		    			btNextPage.setEnabled(true);
		    			btFirstPage.setEnabled(true);
		    			btLastPage.setEnabled(true);
	    			} else if(seite > 1 && seite >= di.getSeiten()) {
	    				btPrevPage.setEnabled(true);
	    				btNextPage.setEnabled(false);
		    			btFirstPage.setEnabled(true);
		    			btLastPage.setEnabled(false);
	    			} 
	    		}
	    		if(seite == 1 && di.getSeiten() ==1) {
	    	    	btPrevPage.setEnabled(false);
	    	    	btNextPage.setEnabled(false);
	    	    	btFirstPage.setEnabled(false);
	    	    	btLastPage.setEnabled(false);
	    		}
	    	} else {
        		btNextPage.setEnabled(false);
        		btPrevPage.setEnabled(false);
    	    	btFirstPage.setEnabled(false);
    	    	btLastPage.setEnabled(false);
	    		lblPageNumberSouth.setText(rz.getLocale().getString("pdfdisplay.pagenumber").replaceAll("%n", "").replaceAll("%p",""));
	    	}
	    }
	
	    
	    private void scaleChanged() {
	    	int value = (int)spScale.getValue();
	    	if(value < rz.getOptionFactory().getOption("dokumentpanel.min_scale", de.lunqual.rzpro.options.OptionFactory.DOKUMENTPANEL_MIN_SCALE)) {
	    		value = rz.getOptionFactory().getOption("dokumentpanel.min_scale", de.lunqual.rzpro.options.OptionFactory.DOKUMENTPANEL_MIN_SCALE);
	    		spScale.setValue(value);
	    	} else if(value > rz.getOptionFactory().getOption("dokumentpanel.max_scale", de.lunqual.rzpro.options.OptionFactory.DOKUMENTPANEL_MAX_SCALE)) {
	    		value =rz.getOptionFactory().getOption("dokumentpanel.max_scale", de.lunqual.rzpro.options.OptionFactory.DOKUMENTPANEL_MAX_SCALE);
	    		spScale.setValue(value);
	    	}
	    	rz.getOptionFactory().setOption("pdfdocument.scale", value);
			rz.getOptionFactory().saveOptions();
	    	dokumentPanel.setScale(value);
	    	rz.getDatabase().getDocuments().udpateZoom(di.getId(),value);
	    	dokumentPanel.repaint();
	    }
	
	    public void print(PrintService printer) {
	    	if(di != null) {
		    	try {
					PDDocument pdfDocument = Loader.loadPDF(di.getDaten());
					 PrinterJob job = PrinterJob.getPrinterJob();
	 			    try {
						job.setPrintService(printer);
						job.setPageable(new PDFPageable(pdfDocument));
						job.print();
					} catch (PrinterException e) {}
					pdfDocument.close();
				} catch (IOException e) {}
		    }
	    }


}
