/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package de.lunqual.rzpro.fenster.einstellungsfenster;


import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;

import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingConstants;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.ausgabe.ReportFactory;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fenster.ZutatenDialog;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.fonts.FontFactory;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.report.ReportItem;
import de.lunqual.rzpro.items.rezeptur.ZutatenListe;
import de.lunqual.rzpro.items.stichworte.StichwortListe;
import de.lunqual.rzpro.options.OptionFactory;
/**
 *
 * @author  lunqual
 */
public class EinstellungenClient extends JRzFrame{

    //GUI-Variablen
    private JToolBar tb1;
    private JMenuBar mb;
    private JMenu mnuDatei;
    private JMenu mnuExtras;
    private JMenu mnuHilfe;
      private  JPanel contentPanel;
      	private JPanel tbPanel;
  		private JPanel tabPanel;
      	    private JTabbedPane tab1;
  	    	    private JPanel tbAllgemein;

  	    	    private JPanel allgemeinNorthPanel;
  	    	    		private JPanel timeoutPanel;
  	    	    			private JSpinner splTimeout;
  	    	    				private JLabel lblTimeout;
  	    	    
  	    	    		 		private JPanel tanklagerFixPanel;
  	  	    	    			private JCheckBox chkTanklagerFix;
  	  	    	    			
  	    	    				
	  	    	    private JPanel allgemeinSouthPanel;
		    	    	
                      private JPanel allgemeinCenterPanel;
                      private JPanel meldungenPanel;
                          private JLabel lblMeldungen;
                          private JCheckBox chkAbgang;
	  	    	private JPanel tbFonts;
	  	    		private JPanel fontPanel;
	  	    			private JPanel fontPanelNorth;
	  	    				private JLabel lblButtonFont;
	  	    				private JLabel lblButtonFontName;
	  	    				private JComboBox cmbButtonFont;
	  	    				private JSpinner jspButtonFont;

	  	    				private JLabel lblMenuFont;
	  	    				private JLabel lblMenuFontName;
	  	    				private JComboBox cmbMenuFont;
	  	    				private JSpinner jspMenuFont;

	  	    				private JLabel lblListFont;
	  	    				private JLabel lblListFontName;
	  	    				private JComboBox cmbListFont;
	  	    				private JSpinner jspListFont;

	  	    				private JLabel lblTextFont;
	  	    				private JLabel lblTextFontName;
	  	    				private JComboBox cmbTextFont;
	  	    				private JSpinner jspTextFont;

	  	    				private JLabel lblErgebnisFont;
	  	    				private JLabel lblErgebnisFontName;
	  	    				private JComboBox cmbErgebnisFont;
	  	    				private JSpinner jspErgebnisFont;

	  	    				private JLabel lblTableFont;
	  	    				private JLabel lblTableFontName;
	  	    				private JComboBox cmbTableFont;
	  	    				private JSpinner jspTableFont;

	  	    			private JPanel fontCenterPanel;
	  	    				private JLabel lblTestSchrift;
		  	   	 private JPanel tbFarben;
			 			private JPanel farbenNorth;
	 					private JLabel lblColorText;
	 					private JButton btColorText;
	 					private JLabel lblColorBackground;
	 					private JButton btColorBackground;
		 				private JLabel lblColorHeadlineText;
		 				private JButton btColorHeadlineText;
		 				private JLabel lblColorHeadlineBackground;
		 				private JButton btColorHeadlineBackground;
		 				private JLabel lblColorErstellt;
		 				private JButton btColorErstellt;
		 				private JLabel lblColorErstelltBack;
		 				private JButton btColorErstelltBack;
		 				private JLabel lblColorGeaendert;
		 				private JButton btColorGeaendert;
		 				private JLabel lblColorGeaendertBack;
		 				private JButton btColorGeaendertBack;
		 				private JLabel lblColorAdressen;
		 				private JButton btColorAdressen;
		 				private JLabel lblColorAdressenBack;
		 				private JButton btColorAdressenBack;
		 				private JLabel lblColorMarkup;
		 				private JButton btColorMarkup;
		 				private JLabel lblColorHinweis;
		 				private JButton btColorHinweis;
		 				private JLabel lblColorHinweisBack;
		 				private JButton btColorHinweisBack;
		 			private JPanel farbenSouth;
		 				private JButton btFarbenDefault;
	  	    	    private JPanel tbDrucker;
  	    	    	private JPanel druckerPanel;
  	    	    		private JLabel lblDrucker;
  	    	    		private JComboBox cmbDrucker;
  	  	    	    	private JPanel rbPanel;
  	    	    		private ButtonGroup btgDrucker;
  	    	    			private JRadioButton rbDialog;
  	    	    			private JRadioButton rbDirekt;
  	    	    			private JRadioButton rbVorschau;
  	    	    		private JPanel formularPanel;
  	  	    	    		private JLabel lblFormularTitel;
  	  	    	    		private JPanel comboPanel;
  	  	    	    			private JLabel lblFormularSpezifikation;
  	  	    	    			private JComboBox cmbFormularSpezifikation;
  	  	    	    			private JLabel lblFormularDeckblattSpezifikation;
  	  	    	    			private JComboBox cmbFormularDeckblattSpezifikation;
  		private JPanel buttonPanel;
  	    	private JButton btSpeichern;
      	    private JButton btAnwenden;
      	    private JButton btRefresh;
      	    private JButton btHilfe;
      	    private JButton btAbbrechen;


    // Spinner für Zahlenformate
    SpinnerModel        allgemeinMin;
    SpinnerModel        allgemeinMax;
    SpinnerModel        lgMin;
    SpinnerModel        lgMax;
    SpinnerModel        stMin;
    SpinnerModel        stMax;
    SpinnerModel		   hbText;
    SpinnerModel		   buttonFontModel;
    //aufstärken

    ZutatenListe			staerkeListe;
    ZutatenListe			extraktListe;

    ZutatenDialog		zd;

    // client
    StichwortListe			clientfilter;

    //Schrifart geändert
    boolean				resetGUI=false;
    //Design geändert
    boolean				resetDesign=false;

    //ActionCodes Einstellungsfenster
    public static final int         ACTION_SPEICHERN_CODE = 1000;
    public static final String     ACTION_SPEICHERN_TEXT = "einstellungen.action_save";
    public static final int         ACTION_ANWENDEN_CODE = 1001;
    public static final String     ACTION_ANWENDEN_TEXT = "einstellungen.action_apply";
    public static final int         ACTION_ABBRECHEN_CODE = 1002;
    public static final String     ACTION_ABBRECHEN_TEXT = "einstellungen.action_abbrechen";
    public static final int         ACTION_CLOSE_CODE = 1003;
    public static final String     ACTION_CLOSE_TEXT = "einstellungen.action_close";
    public static final int         ACTION_KALKULATION_REFRESH_CODE = 1004;
    public static final String     ACTION_KALKULATION_REFRESH_TEXT = "action_refresh";
    public static final int         ACTION_HILFE_CODE = 1005;
    public static final String      ACTION_HILFE_TEXT = "action_hilfe";
    public static final int         ACTION_HIDE_CODE = 1006;
    public static final String      ACTION_HIDE_TEXT = "action_hide";
    public static final int         ACTION_REFRESH_CODE = 1007;
    public static final String      ACTION_REFRESH_TEXT = "action_refresh";


    // aufstärken/herabsetzen-ACtions
    public static final int         ACTION_STAERKE_ADD_CODE = 1008;
    public static final String      ACTION_STAERKE_ADD_TEXT = "einstellungen.action_staerke_add";
    public static final int         ACTION_STAERKE_REMOVE_CODE = 1009;
    public static final String      ACTION_STAERKE_REMOVE_TEXT = "einstellungen.action_staerke_remove";
    public static final int         ACTION_STAERKE_CLEAR_CODE = 1010;
    public static final String      ACTION_STAERKE_CLEAR_TEXT = "einstellungen.action_staerke_clear";



    //client
    public static final int         ACTION_CLIENT_BEARBEITEN_CODE = 1011;
    public static final String      ACTION_CLIENT_BEARBEITEN_TEXT = "einstellungen.action_client_bearbeiten";
    public static final int         ACTION_CLIENT_LOESCHEN_CODE = 1012;
    public static final String      ACTION_CLIENT_LOESCHEN_TEXT = "einstellungen.action_client_loeschen";

    //Farben
    public static final int         ACTION_FARBEN_DEFAULT_CODE = 1013;
    public static final String      ACTION_FARBEN_DEFAULT_TEXT = "einstellungen.action_farben_default";


    /** Creates new form AdressenFenster */
    public EinstellungenClient(RzPro r, String name, Object extendedData) {
        super(r,name,extendedData);
        staerkeListe = new ZutatenListe(rz);
        extraktListe = new ZutatenListe(rz);
        createActions();
        createGUIComponents();
        setGUIComponents();
        getMessage((MessageItem)extendedData);
    }

    public void createGUIComponents() {
    	// Menü
    	mb = new JMenuBar();
    	mnuDatei = new JMenu();
    	mnuExtras = new JMenu();
    	mnuHilfe = new JMenu();
    	mb.add(mnuDatei);
    	mb.add(mnuExtras);
    	mb.add(mnuHilfe);
    	setJMenuBar(mb);
		//Toolbar
		tb1 = new JToolBar();
		tb1.setFloatable(false);
		tb1.setRollover(true);
		//ToolbarPanel
		tbPanel = new JPanel(new BorderLayout());
		tbPanel.add(tb1,BorderLayout.NORTH);

		//contentPanel
		contentPanel = new JPanel(new BorderLayout());
			tabPanel = new JPanel(new BorderLayout());
				tab1=new JTabbedPane();
				tbAllgemein = new JPanel(new BorderLayout());
				
				allgemeinNorthPanel = new JPanel(new BorderLayout());
					allgemeinNorthPanel.setLayout(new BoxLayout(allgemeinNorthPanel,BoxLayout.PAGE_AXIS));
						timeoutPanel = new JPanel(new BorderLayout());
							timeoutPanel.setBorder(BorderFactory.createEtchedBorder());
							splTimeout = new JSpinner();
								splTimeout.setModel(new SpinnerNumberModel(10,0, 360,1));
							timeoutPanel.add(splTimeout,BorderLayout.WEST);
							lblTimeout = new JLabel();
							lblTimeout.setText(rz.getLocale().getString("einstellungen.label_timeout"));
							timeoutPanel.add(lblTimeout,BorderLayout.CENTER);
					allgemeinNorthPanel.add(timeoutPanel);
					
					tanklagerFixPanel = new JPanel(new BorderLayout());
						chkTanklagerFix = new JCheckBox();
						tanklagerFixPanel.add(chkTanklagerFix);
				allgemeinNorthPanel.add(tanklagerFixPanel);
				
					tbAllgemein.add(allgemeinNorthPanel,BorderLayout.NORTH);
				
					allgemeinSouthPanel = new JPanel(new GridLayout(3,2));
		        	
		    		allgemeinSouthPanel.setBorder(BorderFactory.createRaisedBevelBorder());
	        tbAllgemein.add(allgemeinSouthPanel,BorderLayout.SOUTH);
                    allgemeinCenterPanel = new JPanel(new BorderLayout());
                    meldungenPanel = new JPanel(new GridLayout(2,1));
                        lblMeldungen = new JLabel();
                            lblMeldungen.setHorizontalAlignment(SwingConstants.CENTER);
                        meldungenPanel.add(lblMeldungen);
                        chkAbgang = new JCheckBox();
                        meldungenPanel.add(chkAbgang);
                        meldungenPanel.setBorder(BorderFactory.createRaisedBevelBorder());
                    allgemeinCenterPanel.add(meldungenPanel,BorderLayout.NORTH);
                tbAllgemein.add(allgemeinCenterPanel,BorderLayout.CENTER);
					tab1.add(tbAllgemein,BorderLayout.CENTER);
					/*
					 * Fonts
					 */
					tbFonts = new JPanel(new BorderLayout());
						fontPanel=new JPanel(new BorderLayout());
							fontPanelNorth=new JPanel(new GridLayout(7,4));
								// buttonfont
								lblButtonFont=new JLabel();
								fontPanelNorth.add(lblButtonFont);
								lblButtonFontName = new JLabel();
									lblButtonFontName.setBorder(BorderFactory.createLoweredBevelBorder());
								fontPanelNorth.add(lblButtonFontName);
								cmbButtonFont=new JComboBox();
									rz.getFontFactory().fillFontCMB(cmbButtonFont,FontFactory.BUTTON_FONT);
	  		    	 				cmbButtonFont.addActionListener(new ActionListener() {
		  		        	        	public void actionPerformed(ActionEvent evt) {
		  		        	        		fontAction(FontFactory.BUTTON_FONT);
		  		        	        	}
		  			        	    });
								fontPanelNorth.add(cmbButtonFont);
								jspButtonFont = new JSpinner();
								jspButtonFont.addChangeListener(new javax.swing.event.ChangeListener() {
									public void stateChanged(javax.swing.event.ChangeEvent evt) {
										spinnerChanged(jspButtonFont,evt);
			    	            	}
								});
								fontPanelNorth.add(jspButtonFont);

								// buttonfont
								lblMenuFont=new JLabel();
								fontPanelNorth.add(lblMenuFont);
								lblMenuFontName = new JLabel();
									lblMenuFontName.setBorder(BorderFactory.createLoweredBevelBorder());
								fontPanelNorth.add(lblMenuFontName);
								cmbMenuFont=new JComboBox();
									rz.getFontFactory().fillFontCMB(cmbMenuFont,FontFactory.MENU_FONT);
	  		    	 				cmbMenuFont.addActionListener(new ActionListener() {
		  		        	        	public void actionPerformed(ActionEvent evt) {
		  		        	        		fontAction(FontFactory.MENU_FONT);
		  		        	        	}
		  			        	    });
								fontPanelNorth.add(cmbMenuFont);
								jspMenuFont = new JSpinner();
								jspMenuFont.addChangeListener(new javax.swing.event.ChangeListener() {
									public void stateChanged(javax.swing.event.ChangeEvent evt) {
										spinnerChanged(jspMenuFont,evt);
			    	            	}
								});
								fontPanelNorth.add(jspMenuFont);


								// buttonfont
								lblListFont=new JLabel();
								fontPanelNorth.add(lblListFont);
								lblListFontName = new JLabel();
									lblListFontName.setBorder(BorderFactory.createLoweredBevelBorder());
								fontPanelNorth.add(lblListFontName);
								cmbListFont=new JComboBox();
									rz.getFontFactory().fillFontCMB(cmbListFont,FontFactory.LIST_FONT);
	  		    	 				cmbListFont.addActionListener(new ActionListener() {
		  		        	        	public void actionPerformed(ActionEvent evt) {
		  		        	        		fontAction(FontFactory.LIST_FONT);
		  		        	        	}
		  			        	    });
								fontPanelNorth.add(cmbListFont);
								jspListFont = new JSpinner();
								jspListFont.addChangeListener(new javax.swing.event.ChangeListener() {
									public void stateChanged(javax.swing.event.ChangeEvent evt) {
										spinnerChanged(jspListFont,evt);
			    	            	}
								});
								fontPanelNorth.add(jspListFont);

								// buttonfont
								lblTextFont=new JLabel();
								fontPanelNorth.add(lblTextFont);
								lblTextFontName = new JLabel();
									lblTextFontName.setBorder(BorderFactory.createLoweredBevelBorder());
								fontPanelNorth.add(lblTextFontName);
								cmbTextFont=new JComboBox();
									rz.getFontFactory().fillFontCMB(cmbTextFont,FontFactory.TEXT_FONT);
	  		    	 				cmbTextFont.addActionListener(new ActionListener() {
		  		        	        	public void actionPerformed(ActionEvent evt) {
		  		        	        		fontAction(FontFactory.TEXT_FONT);
		  		        	        	}
		  			        	    });
								fontPanelNorth.add(cmbTextFont);
								jspTextFont = new JSpinner();
								jspTextFont.addChangeListener(new javax.swing.event.ChangeListener() {
									public void stateChanged(javax.swing.event.ChangeEvent evt) {
										spinnerChanged(jspTextFont,evt);
			    	            	}
								});
								fontPanelNorth.add(jspTextFont);

								// Ergebnisfont
								lblErgebnisFont=new JLabel();
								fontPanelNorth.add(lblErgebnisFont);
								lblErgebnisFontName = new JLabel();
									lblErgebnisFontName.setBorder(BorderFactory.createLoweredBevelBorder());
								fontPanelNorth.add(lblErgebnisFontName);
								cmbErgebnisFont=new JComboBox();
									rz.getFontFactory().fillFontCMB(cmbErgebnisFont,FontFactory.ERGEBNIS_FONT);
	  		    	 				cmbErgebnisFont.addActionListener(new ActionListener() {
		  		        	        	public void actionPerformed(ActionEvent evt) {
		  		        	        		fontAction(FontFactory.ERGEBNIS_FONT);
		  		        	        	}
		  			        	    });
									fontPanelNorth.add(cmbErgebnisFont);
									jspErgebnisFont = new JSpinner();
									jspErgebnisFont.addChangeListener(new javax.swing.event.ChangeListener() {
										public void stateChanged(javax.swing.event.ChangeEvent evt) {
											spinnerChanged(jspErgebnisFont,evt);
				    	            	}
									});
									fontPanelNorth.add(jspErgebnisFont);


								//Tabellenfont
								lblTableFont=new JLabel();
								fontPanelNorth.add(lblTableFont);
								lblTableFontName = new JLabel();
									lblTableFontName.setBorder(BorderFactory.createLoweredBevelBorder());
								fontPanelNorth.add(lblTableFontName);
								cmbTableFont=new JComboBox();
									rz.getFontFactory().fillFontCMB(cmbTableFont,FontFactory.TABLE_FONT);
	  		    	 				cmbTableFont.addActionListener(new ActionListener() {
		  		        	        	public void actionPerformed(ActionEvent evt) {
		  		        	        		fontAction(FontFactory.TABLE_FONT);
		  		        	        	}
		  			        	    });
								fontPanelNorth.add(cmbTableFont);
								jspTableFont = new JSpinner();
								jspTableFont.addChangeListener(new javax.swing.event.ChangeListener() {
									public void stateChanged(javax.swing.event.ChangeEvent evt) {
										spinnerChanged(jspTableFont,evt);
			    	            	}
								});
								fontPanelNorth.add(jspTableFont);
							fontPanel.add(fontPanelNorth,BorderLayout.NORTH);
							fontCenterPanel = new JPanel(new BorderLayout());
								lblTestSchrift = new JLabel();
									lblTestSchrift.setHorizontalAlignment(SwingConstants.CENTER);
								    lblTestSchrift.setVerticalAlignment(SwingConstants.CENTER);
								    lblTestSchrift.setBackground(Color.WHITE);
								    lblTestSchrift.setForeground(Color.BLACK);
								    lblTestSchrift.setOpaque(true);
								    lblTestSchrift.setBorder(BorderFactory.createRaisedBevelBorder());
								fontCenterPanel.add(lblTestSchrift,BorderLayout.CENTER);
							fontPanel.add(fontCenterPanel,BorderLayout.CENTER);
						tbFonts.add(fontPanel,BorderLayout.CENTER);


					tab1.add(tbFonts,BorderLayout.CENTER);
					/*
					 * Farben
					 */
  		    	 	tbFarben = new JPanel(new BorderLayout());
  		    	 	tab1.add(tbFarben,BorderLayout.CENTER);
  		    	 		farbenNorth=new JPanel(new GridLayout(20,2));

	  		    	 		lblColorText = new JLabel();
	    	 				lblColorText.setHorizontalAlignment(SwingConstants.TRAILING);
		    	 			farbenNorth.add(lblColorText);
		    	 			btColorText = new JButton();
		    	 				btColorText.setBorder(BorderFactory.createRaisedBevelBorder());
		    	 				btColorText.addActionListener(new ActionListener() {
		        	        	public void actionPerformed(ActionEvent evt) {
		        	        		setColor(btColorText,"auswahl.color_text");
		        	        	}
			        	    });
		    	 			farbenNorth.add(btColorText);

		    	 			lblColorBackground = new JLabel();
	    	 				lblColorBackground.setHorizontalAlignment(SwingConstants.TRAILING);
		    	 			farbenNorth.add(lblColorBackground);
		    	 			btColorBackground = new JButton();
		    	 				btColorBackground.setBorder(BorderFactory.createRaisedBevelBorder());
		    	 				btColorBackground.addActionListener(new ActionListener() {
		        	        	public void actionPerformed(ActionEvent evt) {
		        	        		setColor(btColorBackground,"auswahl.color_background");
		        	        	}
			        	    });
		    	 			farbenNorth.add(btColorBackground);

			    	 			lblColorHeadlineText = new JLabel();
	    	 				lblColorHeadlineText.setHorizontalAlignment(SwingConstants.TRAILING);
		    	 			farbenNorth.add(lblColorHeadlineText);
		    	 			btColorHeadlineText = new JButton();
		    	 				btColorHeadlineText.setBorder(BorderFactory.createRaisedBevelBorder());
		    	 				btColorHeadlineText.addActionListener(new ActionListener() {
		        	        	public void actionPerformed(ActionEvent evt) {
		        	        		setColor(btColorHeadlineText,"auswahl.color_headline_text");
		        	        	}
			        	    });
		    	 			farbenNorth.add(btColorHeadlineText);

		    	 			lblColorHeadlineBackground = new JLabel();
	    	 				lblColorHeadlineBackground.setHorizontalAlignment(SwingConstants.TRAILING);
		    	 			farbenNorth.add(lblColorHeadlineBackground);
		    	 			btColorHeadlineBackground = new JButton();
		    	 				btColorHeadlineBackground.setBorder(BorderFactory.createRaisedBevelBorder());
		    	 				btColorHeadlineBackground.addActionListener(new ActionListener() {
		        	        	public void actionPerformed(ActionEvent evt) {
		        	        		setColor(btColorHeadlineBackground,"auswahl.color_background");
		        	        	}
			        	    });
		    	 			farbenNorth.add(btColorHeadlineBackground);

  		    	 			lblColorErstellt = new JLabel();
		    	 				lblColorErstellt.setHorizontalAlignment(SwingConstants.TRAILING);
		    	 			farbenNorth.add(lblColorErstellt);
		    	 			btColorErstellt = new JButton();
		    	 				btColorErstellt.setBorder(BorderFactory.createRaisedBevelBorder());
		    	 				btColorErstellt.addActionListener(new ActionListener() {
		        	        	public void actionPerformed(ActionEvent evt) {
		        	        		setColor(btColorErstellt,"auswahl.color_erstellt_text");
		        	        	}
			        	    });
		    	 			farbenNorth.add(btColorErstellt);

  		    	 			lblColorErstelltBack = new JLabel();
		    	 				lblColorErstelltBack.setHorizontalAlignment(SwingConstants.TRAILING);
		    	 			farbenNorth.add(lblColorErstelltBack);
		    	 			btColorErstelltBack = new JButton();
		    	 				btColorErstelltBack.setBorder(BorderFactory.createRaisedBevelBorder());
		    	 				btColorErstelltBack.addActionListener(new ActionListener() {
		        	        	public void actionPerformed(ActionEvent evt) {
		        	        		setColor(btColorErstelltBack,"auswahl.color_erstellt_back");
		        	        	}
			        	    });
		    	 			farbenNorth.add(btColorErstelltBack);

  		    	 			lblColorGeaendert = new JLabel();
	    	 				lblColorGeaendert.setHorizontalAlignment(SwingConstants.TRAILING);
	    	 			farbenNorth.add(lblColorGeaendert);
	    	 			btColorGeaendert = new JButton();
	    	 				btColorGeaendert.setBorder(BorderFactory.createRaisedBevelBorder());
	    	 				btColorGeaendert.addActionListener(new ActionListener() {
	        	        	public void actionPerformed(ActionEvent evt) {
	        	        		setColor(btColorGeaendert,"auswahl.color_geaendert_text");
	        	        	}
		        	    });
	    	 			farbenNorth.add(btColorGeaendert);

		    	 			lblColorGeaendertBack = new JLabel();
	    	 				lblColorGeaendertBack.setHorizontalAlignment(SwingConstants.TRAILING);
	    	 			farbenNorth.add(lblColorGeaendertBack);
	    	 			btColorGeaendertBack = new JButton();
	    	 				btColorGeaendertBack.setBorder(BorderFactory.createRaisedBevelBorder());
	    	 				btColorGeaendertBack.addActionListener(new ActionListener() {
	        	        	public void actionPerformed(ActionEvent evt) {
	        	        		setColor(btColorGeaendertBack,"auswahl.color_geaendert_back");
	        	        	}
		        	    });
	    	 			farbenNorth.add(btColorGeaendertBack);

		    	 			lblColorAdressen = new JLabel();
	    	 				lblColorAdressen.setHorizontalAlignment(SwingConstants.TRAILING);
	    	 			farbenNorth.add(lblColorAdressen);
	    	 			btColorAdressen = new JButton();
	    	 				btColorAdressen.setBorder(BorderFactory.createRaisedBevelBorder());
	    	 				btColorAdressen.addActionListener(new ActionListener() {
	        	        	public void actionPerformed(ActionEvent evt) {
	        	        		setColor(btColorAdressen,"auswahl.color_adressen_text");
	        	        	}
		        	    });
	    	 			farbenNorth.add(btColorAdressen);

		    	 			lblColorAdressenBack = new JLabel();
	    	 				lblColorAdressenBack.setHorizontalAlignment(SwingConstants.TRAILING);
	    	 			farbenNorth.add(lblColorAdressenBack);
	    	 			btColorAdressenBack = new JButton();
	    	 				btColorAdressenBack.setBorder(BorderFactory.createRaisedBevelBorder());
	    	 				btColorAdressenBack.addActionListener(new ActionListener() {
	        	        	public void actionPerformed(ActionEvent evt) {
	        	        		setColor(btColorAdressenBack,"auswahl.color_adressen_back");
	        	        	}
		        	    });
	    	 			farbenNorth.add(btColorAdressenBack);


		    	 			lblColorMarkup = new JLabel();
		    	 				lblColorMarkup.setHorizontalAlignment(SwingConstants.TRAILING);
		    	 			farbenNorth.add(lblColorMarkup);
		    	 			btColorMarkup = new JButton();
		    	 				btColorMarkup.setBorder(BorderFactory.createRaisedBevelBorder());
		    	 				btColorMarkup.addActionListener(new ActionListener() {
		        	        	public void actionPerformed(ActionEvent evt) {
		        	        		setColor(btColorMarkup,"auswahl.color_markup");
		        	        	}
			        	    });
		    	 			farbenNorth.add(btColorMarkup);

		    	 			//----------------

		    	 			lblColorHinweis = new JLabel();
		 					lblColorHinweis.setHorizontalAlignment(SwingConstants.TRAILING);
		 				farbenNorth.add(lblColorHinweis);
		 				btColorHinweis = new JButton();
	    	 				btColorHinweis.addActionListener(new ActionListener() {
		        	        	public void actionPerformed(ActionEvent evt) {
		        	        		setColor(btColorHinweis,"auswahl.color_hinweis_text");
		        	        	}
			        	    });
		 					btColorHinweis.setBorder(BorderFactory.createRaisedBevelBorder());
		 			farbenNorth.add(btColorHinweis);

	    	 			lblColorHinweisBack = new JLabel();
	 					lblColorHinweisBack.setHorizontalAlignment(SwingConstants.TRAILING);
	 				farbenNorth.add(lblColorHinweisBack);
	 				btColorHinweisBack = new JButton();
		 				btColorHinweisBack.addActionListener(new ActionListener() {
	        	        	public void actionPerformed(ActionEvent evt) {
	        	        		setColor(btColorHinweisBack,"auswahl.color_hinweis_back");
	        	        	}
		        	    });
	 					btColorHinweisBack.setBorder(BorderFactory.createRaisedBevelBorder());
	 			farbenNorth.add(btColorHinweisBack);

		    	 			//---------------------



		    	 			tbFarben.add(farbenNorth,BorderLayout.NORTH);
  		    	 			farbenSouth = new JPanel(new BorderLayout());
  		    	 				btFarbenDefault = new JButton();
  		    	 				farbenSouth.add(this.btFarbenDefault);

  		    	 		tbFarben.add(farbenSouth,BorderLayout.SOUTH);

  						/* Drucker
  						 *
  						 */
  						tbDrucker = new JPanel(new BorderLayout());
  						tab1.add(tbDrucker,BorderLayout.CENTER);
  							druckerPanel = new JPanel(new BorderLayout());
  								lblDrucker = new JLabel();
  								druckerPanel.add(lblDrucker,BorderLayout.WEST);
  								cmbDrucker = new JComboBox();
  								druckerPanel.add(cmbDrucker,BorderLayout.CENTER);
  							tbDrucker.add(druckerPanel,BorderLayout.NORTH);
  							rbPanel = new JPanel();
  								rbPanel.setLayout(new BoxLayout(rbPanel, BoxLayout.PAGE_AXIS));
  								btgDrucker = new ButtonGroup();
  									rbDialog = new JRadioButton();
  										btgDrucker.add(rbDialog);
  										rbPanel.add(rbDialog);
  									rbDirekt = new JRadioButton();
  										btgDrucker.add(rbDirekt);
  										rbPanel.add(rbDirekt);
  									rbVorschau = new JRadioButton();
  										btgDrucker.add(rbVorschau);
  										rbPanel.add(rbVorschau);
  							tbDrucker.add(rbPanel,BorderLayout.WEST);

  							formularPanel=new JPanel(new BorderLayout());
							formularPanel.setBorder(BorderFactory.createRaisedBevelBorder());
								lblFormularTitel = new JLabel();
								lblFormularTitel.setHorizontalAlignment(SwingConstants.CENTER);
								formularPanel.add(lblFormularTitel,BorderLayout.NORTH);
							    comboPanel = new JPanel(new GridLayout(2,2));
									
									lblFormularSpezifikation=new JLabel();
									lblFormularSpezifikation.setHorizontalAlignment(SwingConstants.RIGHT);
									comboPanel.add(lblFormularSpezifikation);
									cmbFormularSpezifikation = new JComboBox();
				    				rz.getDatabase().getReport().dbGetReportListeCombo(cmbFormularSpezifikation,ReportFactory.REPORT_TYPE_RECHNEN);
				    				rz.getDatabase().getReport().setComboSelection(cmbFormularSpezifikation,rz.getOptionFactory().getOption("auswahl.formular_spezifikation",OptionFactory.AUSWAHL_FORMULAR_SPEZIFIKATION));
					        	    cmbFormularSpezifikation.addActionListener(new ActionListener() {
				        	        	public void actionPerformed(ActionEvent evt) {
				        	        		if(cmbFormularSpezifikation.getSelectedIndex() != -1) {
				        	        			rz.getOptionFactory().setOption("auswahl.formular_spezifikation",((ReportItem)cmbFormularSpezifikation.getSelectedItem()).getID());
				        	        		}
				        	        	}
					                });
					        	    comboPanel.add(cmbFormularSpezifikation);

									lblFormularDeckblattSpezifikation=new JLabel();
									lblFormularDeckblattSpezifikation.setHorizontalAlignment(SwingConstants.RIGHT);
									comboPanel.add(lblFormularDeckblattSpezifikation);
									cmbFormularDeckblattSpezifikation = new JComboBox();
				    				rz.getDatabase().getReport().dbGetReportListeCombo(cmbFormularDeckblattSpezifikation,ReportFactory.REPORT_TYPE_SPEZIFIKATION_FORMBLATT);
				    				rz.getDatabase().getReport().setComboSelection(cmbFormularDeckblattSpezifikation,rz.getOptionFactory().getOption("auswahl.formular_deckblatt_spezifikation",OptionFactory.AUSWAHL_FORMULAR_SPEZIFIKATION));
					        	    cmbFormularDeckblattSpezifikation.addActionListener(new ActionListener() {
				        	        	public void actionPerformed(ActionEvent evt) {
				        	        		if(cmbFormularDeckblattSpezifikation.getSelectedIndex() != -1) {
				        	        			rz.getOptionFactory().setOption("auswahl.formular_deckblatt_spezifikation",((ReportItem)cmbFormularDeckblattSpezifikation.getSelectedItem()).getID());
				        	        		}
				        	        	}
					                });
					        	    comboPanel.add(cmbFormularDeckblattSpezifikation);
					        	    
							    formularPanel.add(comboPanel,BorderLayout.CENTER);
						tbDrucker.add(formularPanel,BorderLayout.SOUTH);
  							
  							
		    	 	tabPanel.add(tab1,BorderLayout.CENTER);
				contentPanel.add(tabPanel,BorderLayout.CENTER);

	    // ButtonPanel
		buttonPanel=new JPanel(new GridLayout(1,5));
			btAbbrechen = new JButton();
			buttonPanel.add(btAbbrechen);
			btSpeichern = new JButton();
			buttonPanel.add(btSpeichern);
			btAnwenden = new JButton();
			buttonPanel.add(btAnwenden);
			btRefresh = new JButton();
			buttonPanel.add(btRefresh);
			btHilfe = new JButton();
			buttonPanel.add(btHilfe);
	//Panels ans Fenster hängen;
	this.getContentPane().setLayout(new BorderLayout());

	this.getContentPane().add(tbPanel,BorderLayout.NORTH);
	this.getContentPane().add(contentPanel, BorderLayout.CENTER);
	this.getContentPane().add(buttonPanel, BorderLayout.SOUTH);
    }


    public void setGUIComponents() {
        setTitle(rz.getVersionString() + " " + rz.getLocale().getString("einstellungen.titel"));
		mnuDatei.setText(rz.getLocale().getString("menu.datei"));
		mnuExtras.setText(rz.getLocale().getString("menu.extras"));
		mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));
        mnuDatei.add(getAction(ACTION_ANWENDEN_CODE));
        mnuDatei.add(getAction(ACTION_SPEICHERN_CODE));
        mnuDatei.add(getAction(ACTION_ABBRECHEN_CODE));
        mnuDatei.addSeparator();
        mnuDatei.add(getAction(ACTION_CLOSE_CODE));
        mnuExtras.add(getAction(ACTION_HIDE_CODE));
        mnuHilfe.add(getAction(ACTION_HILFE_CODE));

		tb1.add(getAction(ACTION_CLOSE_CODE));
		tb1.add(getAction(ACTION_HIDE_CODE));
		tb1.addSeparator();
		tb1.add(getAction(ACTION_SPEICHERN_CODE));
		tb1.add(getAction(ACTION_ANWENDEN_CODE));
		tb1.add(getAction(ACTION_REFRESH_CODE));
		tb1.addSeparator();
		tb1.add(getAction(ACTION_HILFE_CODE));
		tb1.addSeparator();

		tab1.setTitleAt(0, rz.getLocale().getString("einstellungen.tab_allgemein"));
		tab1.setTitleAt(1, rz.getLocale().getString("einstellungen.tab_fonts"));
        tab1.setTitleAt(2, rz.getLocale().getString("einstellungen.tab_farben"));
		tab1.setTitleAt(3, rz.getLocale().getString("einstellungen.tab_drucker"));

		//Allgemein
        lblMeldungen.setText(rz.getLocale().getString("einstellungen.allgemein.meldungen_titel"));
        chkAbgang.setText(rz.getLocale().getString("einstellungen.allgemein.meldungen_abgang"));
        chkTanklagerFix.setText(rz.getLocale().getString("einstellungen.allgemein.tanklager.fix"));

		//fonts
        lblButtonFont.setText(rz.getLocale().getString("einstellungen.fonts.label_buttonfont"));
        lblErgebnisFont.setText(rz.getLocale().getString("einstellungen.fonts.label_ergebnis"));
        lblMenuFont.setText(rz.getLocale().getString("einstellungen.fonts.label_menu"));
        lblListFont.setText(rz.getLocale().getString("einstellungen.fonts.label_list"));
        lblTextFont.setText(rz.getLocale().getString("einstellungen.fonts.label_text"));
        lblTableFont.setText(rz.getLocale().getString("einstellungen.fonts.label_table"));
        lblTestSchrift.setText(rz.getLocale().getString("einstellungen.fonts.label_test"));

       //allgemein
		//Farben
		lblColorText.setText(rz.getLocale().getString("einstellungen.farbe_text"));
		lblColorBackground.setText(rz.getLocale().getString("einstellungen.farbe_background"));
		lblColorHeadlineText.setText(rz.getLocale().getString("einstellungen.farbe_headline_text"));
		lblColorHeadlineBackground.setText(rz.getLocale().getString("einstellungen.farbe_headline_background"));
		lblColorErstellt.setText(rz.getLocale().getString("einstellungen.farbe_erstellt"));
		lblColorErstelltBack.setText(rz.getLocale().getString("einstellungen.farbe_erstellt_back"));
		lblColorGeaendert.setText(rz.getLocale().getString("einstellungen.farbe_geaendert"));
		lblColorGeaendertBack.setText(rz.getLocale().getString("einstellungen.farbe_geaendert_back"));
		lblColorAdressen.setText(rz.getLocale().getString("einstellungen.farbe_adressen"));
		lblColorAdressenBack.setText(rz.getLocale().getString("einstellungen.farbe_adressen_back"));
		lblColorMarkup.setText(rz.getLocale().getString("einstellungen.farbe_markup"));
		btFarbenDefault.setAction(getAction(ACTION_FARBEN_DEFAULT_CODE));
		lblColorHinweis.setText(rz.getLocale().getString("einstellungen.farbe_hinweis"));
		lblColorHinweisBack.setText(rz.getLocale().getString("einstellungen.farbe_hinweis_back"));
        // Drucker
        lblDrucker.setText(rz.getLocale().getString("einstellungen.drucker.label_drucker"));
        rbDirekt.setText(rz.getLocale().getString("einstellungen.drucker.label_direkt"));
        rbDialog.setText(rz.getLocale().getString("einstellungen.drucker.label_dialog"));
        rbVorschau.setText(rz.getLocale().getString("einstellungen.drucker.label_vorschau"));
        rbDirekt.setActionCommand("printdirect");
        rbDialog.setActionCommand("printdialog");
        rbVorschau.setActionCommand("printpreview");

		//ButtonPanel
    	btSpeichern.setAction(getAction(ACTION_SPEICHERN_CODE));
    	btAnwenden.setAction(getAction(ACTION_ANWENDEN_CODE));
		btRefresh.setAction(getAction(ACTION_REFRESH_CODE));
		btHilfe.setAction(getAction(ACTION_HILFE_CODE));
    	btAbbrechen.setAction(getAction(ACTION_ABBRECHEN_CODE));

        setResizable(true);
        rz.getFontFactory().setFrameFonts(this);
        pack();
        rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;
    }

    public void getMessage(MessageItem msg) {
        switch(msg.getMsgCode()) {
    	case MessageItem.MSG_ACTIONPERFORMED:
            switch(msg.getCode()){
		          case ACTION_ABBRECHEN_CODE:
		          case ACTION_CLOSE_CODE: cancelAction();break;
		          case ACTION_REFRESH_CODE:refreshAction();break;
		          case ACTION_HILFE_CODE: hilfeAction();break;
		          case ACTION_HIDE_CODE:hideAction();break;
		          case ACTION_ANWENDEN_CODE : applyAction();break;
		          case ACTION_SPEICHERN_CODE : saveAction();break;
		          case ACTION_FARBEN_DEFAULT_CODE:farbenDefaultAction();break;
		          default :
                break;
           }
    		break;
         case MessageItem.MSG_SHOW_EINSTELLUNGEN :
             	fromOptions();
         		resetGUI=false;
         		resetDesign=false;
	      		break;

        default:
            rz.getLogFactory().logMessage(2, "einstellungsfenster", "auswahlAction:" + msg.getMsgCode());
            break;
        }

    }
    public void createActions(){
        actionList.put(String.valueOf(ACTION_SPEICHERN_CODE),new AuswahlAction(rz,this,ACTION_SPEICHERN_CODE,ACTION_SPEICHERN_TEXT, KeyEvent.VK_S ,KeyEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_ANWENDEN_CODE),new AuswahlAction(rz,this,ACTION_ANWENDEN_CODE,ACTION_ANWENDEN_TEXT, KeyEvent.VK_A ,KeyEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_ABBRECHEN_CODE),new AuswahlAction(rz,this,ACTION_ABBRECHEN_CODE,ACTION_ABBRECHEN_TEXT, KeyEvent.VK_ESCAPE ,0));
        actionList.put(String.valueOf(ACTION_CLOSE_CODE),new AuswahlAction(rz,this,ACTION_CLOSE_CODE,ACTION_CLOSE_TEXT, KeyEvent.VK_Q ,KeyEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT, KeyEvent.VK_F5 ,KeyEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_REFRESH_CODE),new AuswahlAction(rz,this,ACTION_REFRESH_CODE,ACTION_REFRESH_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT, KeyEvent.VK_F1,0));
        actionList.put(String.valueOf(ACTION_KALKULATION_REFRESH_CODE),new AuswahlAction(rz,this,ACTION_KALKULATION_REFRESH_CODE,ACTION_KALKULATION_REFRESH_TEXT, 0,0));

        actionList.put(String.valueOf(ACTION_STAERKE_ADD_CODE),new AuswahlAction(rz,this,ACTION_STAERKE_ADD_CODE,ACTION_STAERKE_ADD_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_STAERKE_REMOVE_CODE),new AuswahlAction(rz,this,ACTION_STAERKE_REMOVE_CODE,ACTION_STAERKE_REMOVE_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_STAERKE_CLEAR_CODE),new AuswahlAction(rz,this,ACTION_STAERKE_CLEAR_CODE,ACTION_STAERKE_CLEAR_TEXT, 0,0));

        actionList.put(String.valueOf(ACTION_CLIENT_BEARBEITEN_CODE),new AuswahlAction(rz,this,ACTION_CLIENT_BEARBEITEN_CODE,ACTION_CLIENT_BEARBEITEN_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_CLIENT_LOESCHEN_CODE),new AuswahlAction(rz,this,ACTION_CLIENT_LOESCHEN_CODE,ACTION_CLIENT_LOESCHEN_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_FARBEN_DEFAULT_CODE),new AuswahlAction(rz,this,ACTION_FARBEN_DEFAULT_CODE,ACTION_FARBEN_DEFAULT_TEXT, 0,0));

    }

    private void fromOptions(){
    	
    	//allgemein timer
    	splTimeout.setValue(rz.getOptionFactory().getOption("default.inactivity.timeout",OptionFactory.DEFAULT_INACTIVITY_TIMEOUT));

        if(rz.getOptionFactory().getOption("confirm.abgang",OptionFactory.CONFIRM_BUCHUNG)==1) {
            chkAbgang.setSelected(true);
        } else {
            chkAbgang.setSelected(false);
        }
        //allgemein Tanklager-mode
        if(rz.getDatabase().getProperties().getProperty("tanklager.mode.fix").getP_value().equals("1")) {
        	chkTanklagerFix.setSelected(true);
        } else {
        	chkTanklagerFix.setSelected(false);
        }
        //fonts
        lblButtonFontName.setText(rz.getFontFactory().getButtonFont().getName());
        jspButtonFont.setValue(Integer.valueOf(rz.getFontFactory().getButtonFont().getSize()));

        lblMenuFontName.setText(rz.getFontFactory().getMenuFont().getName());
        jspMenuFont.setValue(Integer.valueOf(rz.getFontFactory().getMenuFont().getSize()));
        lblListFontName.setText(rz.getFontFactory().getListFont().getName());
        jspListFont.setValue(Integer.valueOf(rz.getFontFactory().getListFont().getSize()));
        lblTextFontName.setText(rz.getFontFactory().getTextFont().getName());
        jspTextFont.setValue(Integer.valueOf(rz.getFontFactory().getTextFont().getSize()));
        lblTableFontName.setText(rz.getFontFactory().getTableFont().getName());
        jspTableFont.setValue(Integer.valueOf(rz.getFontFactory().getTableFont().getSize()));
        lblErgebnisFontName.setText(rz.getFontFactory().getErgebnisFont().getName());
        jspErgebnisFont.setValue(Integer.valueOf(rz.getFontFactory().getErgebnisFont().getSize()));

	    btColorText.setBackground(rz.getOptionFactory().getRGBColor("auswahl.color_text"));
	    btColorBackground.setBackground(rz.getOptionFactory().getRGBColor("auswahl.color_background"));
	    btColorHeadlineText.setBackground(rz.getOptionFactory().getRGBColor("auswahl.color_headline_text"));
	    btColorHeadlineBackground.setBackground(rz.getOptionFactory().getRGBColor("auswahl.color_headline_background"));
	    btColorMarkup.setBackground(rz.getOptionFactory().getRGBColor("auswahl.color_markup"));
	    btColorErstellt.setBackground(rz.getOptionFactory().getRGBColor("auswahl.color_erstellt_text"));
	    btColorErstelltBack.setBackground(rz.getOptionFactory().getRGBColor("auswahl.color_erstellt_back"));
	    btColorGeaendert.setBackground(rz.getOptionFactory().getRGBColor("auswahl.color_geaendert_text"));
	    btColorGeaendertBack.setBackground(rz.getOptionFactory().getRGBColor("auswahl.color_geaendert_back"));
	    btColorAdressen.setBackground(rz.getOptionFactory().getRGBColor("auswahl.color_adressen_text"));
	    btColorAdressenBack.setBackground(rz.getOptionFactory().getRGBColor("auswahl.color_adressen_back"));
	    btColorHinweis.setBackground(rz.getOptionFactory().getRGBColor("auswahl.color_hinweis_text"));
	    btColorHinweisBack.setBackground(rz.getOptionFactory().getRGBColor("auswahl.color_hinweis_back"));

	    // Drucker
	    int i;
        String pName;
        String pCommand;
        cmbDrucker.removeAllItems();
        final PrintService[] ps = PrintServiceLookup.lookupPrintServices(null,null);
        for(i = 0;i < ps.length;i++){
            cmbDrucker.addItem(ps[i]);
        }
        pName = rz.getOptionFactory().getOption("printer.printer");
        if (pName.equals("")){
            pName = PrintServiceLookup.lookupDefaultPrintService().getName();
        }
        for(i=0;i < cmbDrucker.getModel().getSize();i++){
            if (((PrintService)cmbDrucker.getModel().getElementAt(i)).getName().equals(pName)){
                cmbDrucker.setSelectedItem(cmbDrucker.getModel().getElementAt(i));
                break;
            }
        }
        pCommand = rz.getOptionFactory().getOption("printercommand");
        if(pCommand.equals("printdirect")) {
			rbDirekt.setSelected(true);
		} else
            if (pCommand.equals("printdialog")) {
				rbDialog.setSelected(true);
			} else {
				rbVorschau.setSelected(true);
			}


		rz.getDatabase().getReport().setComboSelection(cmbFormularDeckblattSpezifikation,rz.getOptionFactory().getOption("auswahl.formular_deckblatt_spezifikation",OptionFactory.AUSWAHL_FORMULAR_DECKBLATT_SPEZIFIKATION));
		rz.getDatabase().getReport().setComboSelection(cmbFormularSpezifikation,rz.getOptionFactory().getOption("auswahl.formular_spezifikation",OptionFactory.AUSWAHL_FORMULAR_KALKULATION));


   }

    private void toOptions(){
    	
        //allgemein timer
        rz.getOptionFactory().setOption("default.inactivity.timeout", (Integer)splTimeout.getValue());
        rz.initInactivityTimer();
    	
        //Tanklager mode fix
        if(chkTanklagerFix.isSelected()) {
        	rz.getDatabase().getProperties().setProperty("tanklager.mode.fix", "1");
        } else {
        	rz.getDatabase().getProperties().setProperty("tanklager.mode.fix", "0");
        }
        //allgemein-zutatendialog
        if(chkAbgang.isSelected()) {
            rz.getOptionFactory().setOption("confirm.abgang",1);
        }else {
            rz.getOptionFactory().setOption("confirm.abgang",0);
        }
      
        //Kalkulation

        if(resetGUI ) {
        	if(cmbButtonFont.getSelectedIndex() != -1) {
        		if(rz.getFontFactory().setFont(FontFactory.BUTTON_FONT,(String)cmbButtonFont.getSelectedItem(),((Integer)jspButtonFont.getValue()).intValue())) {
        			lblButtonFontName.setText((String)cmbButtonFont.getSelectedItem());
        		}
            	if(cmbMenuFont.getSelectedIndex() != -1) {
            		if(rz.getFontFactory().setFont(FontFactory.MENU_FONT,(String)cmbMenuFont.getSelectedItem(),((Integer)jspMenuFont.getValue()).intValue())) {
            			lblMenuFontName.setText((String)cmbMenuFont.getSelectedItem());
            		}
            	}
            	if(cmbListFont.getSelectedIndex() != -1) {
            		if(rz.getFontFactory().setFont(FontFactory.LIST_FONT,(String)cmbListFont.getSelectedItem(),((Integer)jspListFont.getValue()).intValue())) {
            			lblListFontName.setText((String)cmbListFont.getSelectedItem());
            		}
            	}
            	if(cmbTextFont.getSelectedIndex() != -1) {
            		if(rz.getFontFactory().setFont(FontFactory.TEXT_FONT,(String)cmbTextFont.getSelectedItem(),((Integer)jspTextFont.getValue()).intValue())) {
            			lblTextFontName.setText((String)cmbTextFont.getSelectedItem());
            		}
            	}
            	if(cmbErgebnisFont.getSelectedIndex() != -1) {
            		if(rz.getFontFactory().setFont(FontFactory.ERGEBNIS_FONT,(String)cmbErgebnisFont.getSelectedItem(),((Integer)jspErgebnisFont.getValue()).intValue())) {
            			lblErgebnisFontName.setText((String)cmbErgebnisFont.getSelectedItem());
            		}
            	}
            	if(cmbTableFont.getSelectedIndex() != -1) {
            		if(rz.getFontFactory().setFont(FontFactory.TABLE_FONT,(String)cmbTableFont.getSelectedItem(),((Integer)jspTableFont.getValue()).intValue())) {
            			lblTableFontName.setText((String)cmbTableFont.getSelectedItem());
            		}
            	}
        	}
        }

        //Farben
        rz.getOptionFactory().setHexColor("auswahl.color_text",btColorText.getBackground());
        rz.getOptionFactory().setHexColor("auswahl.color_background",btColorBackground.getBackground());
        rz.getOptionFactory().setHexColor("auswahl.color_headline_text",btColorHeadlineText.getBackground());
        rz.getOptionFactory().setHexColor("auswahl.color_headline_background",btColorHeadlineBackground.getBackground());
        rz.getOptionFactory().setHexColor("auswahl.color_erstellt_text",btColorErstellt.getBackground());
        rz.getOptionFactory().setHexColor("auswahl.color_erstellt_back",btColorErstelltBack.getBackground());
        rz.getOptionFactory().setHexColor("auswahl.color_geaendert_text",btColorGeaendert.getBackground());
        rz.getOptionFactory().setHexColor("auswahl.color_geaendert_back",btColorGeaendertBack.getBackground());
        rz.getOptionFactory().setHexColor("auswahl.color_adressen_text",btColorAdressen.getBackground());
        rz.getOptionFactory().setHexColor("auswahl.color_adressen_back",btColorAdressenBack.getBackground());
        rz.getOptionFactory().setHexColor("auswahl.color_markup",btColorMarkup.getBackground());
        rz.getOptionFactory().setHexColor("auswahl.color_hinweis_back",btColorHinweisBack.getBackground());
        rz.getOptionFactory().setHexColor("auswahl.color_hinweis_text",btColorHinweis.getBackground());

        rz.getFensterFactory().getFensterListe().redrawFrames();

        //Drucker
        rz.getOptionFactory().setOption("printer.printer",((PrintService)cmbDrucker.getSelectedItem()).getName());
        rz.getOptionFactory().setOption("printercommand", btgDrucker.getSelection().getActionCommand());


        rz.getOptionFactory().setOption("auswahl.formular_spezifikation",((ReportItem)cmbFormularSpezifikation.getSelectedItem()).getID());
        rz.getOptionFactory().setOption("auswahl.formular_deckblatt_spezifikation",((ReportItem)cmbFormularDeckblattSpezifikation.getSelectedItem()).getID());
    }

    /**
     * Schriftarten einstellen
     */
    private void fontAction(int i) {
    	resetGUI = true;
    	int fontSize=12;
    	String fontName="";
    	try {
	    	switch(i){
	    		case FontFactory.BUTTON_FONT: fontSize=((Integer)jspButtonFont.getValue()).intValue();fontName=(String)cmbButtonFont.getSelectedItem();break;
	    		case FontFactory.MENU_FONT: fontSize=((Integer)jspMenuFont.getValue()).intValue();fontName=(String)cmbMenuFont.getSelectedItem();break;
	    		case FontFactory.LIST_FONT: fontSize=((Integer)jspListFont.getValue()).intValue();fontName=(String)cmbListFont.getSelectedItem();break;
	    		case FontFactory.TEXT_FONT: fontSize=((Integer)jspTextFont.getValue()).intValue();fontName=(String)cmbTextFont.getSelectedItem();break;
	    		case FontFactory.ERGEBNIS_FONT: fontSize=((Integer)jspErgebnisFont.getValue()).intValue();fontName=(String)cmbErgebnisFont.getSelectedItem();break;
	    		case FontFactory.TABLE_FONT: fontSize=((Integer)jspTableFont.getValue()).intValue();fontName=(String)cmbTableFont.getSelectedItem();break;

	    	}
	    	final Font fnt = new Font(fontName,0,fontSize);
	    	if(fnt != null) {
	    		lblTestSchrift.setFont(fnt);
	    		lblTestSchrift.repaint();
	    	}
    	} catch (final Exception e) {

    	}
    }

    /**
     * Alle Farben zurücksetzen
     */
    private void farbenDefaultAction() {
    	rz.getOptionFactory().resetColors();
    	fromOptions();
    }

    /** ein SpinButton hat den Zustand geändert
     *
     * @param origin  der geänderte SpinButton
     * @param evt  Event;
     */
    private void spinnerChanged(JSpinner origin,javax.swing.event.ChangeEvent evt) {
        if(origin == this.jspButtonFont) {
            if(((Integer)this.jspButtonFont.getValue()).intValue() < 6){
                origin.setValue(Integer.valueOf(6));
            }
            fontAction(FontFactory.BUTTON_FONT);
        }
        if(origin == this.jspTableFont) {
            if(((Integer)this.jspTableFont.getValue()).intValue() < 6){
                origin.setValue(Integer.valueOf(6));
            }
            fontAction(FontFactory.TABLE_FONT);
        }

        if(origin == this.jspMenuFont) {
            if(((Integer)this.jspMenuFont.getValue()).intValue() < 6){
                origin.setValue(Integer.valueOf(6));
            }
            fontAction(FontFactory.MENU_FONT);
        }
        if(origin == this.jspListFont) {
            if(((Integer)this.jspListFont.getValue()).intValue() < 6){
                origin.setValue(Integer.valueOf(6));
            }
            fontAction(FontFactory.LIST_FONT);
        }
        if(origin == this.jspTextFont) {
            if(((Integer)this.jspTextFont.getValue()).intValue() < 6){
                origin.setValue(Integer.valueOf(6));
            }
            fontAction(FontFactory.TEXT_FONT);
        }
        if(origin == this.jspErgebnisFont) {
            if(((Integer)this.jspErgebnisFont.getValue()).intValue() < 6){
                origin.setValue(Integer.valueOf(6));
            }
            fontAction(FontFactory.ERGEBNIS_FONT);
        }
    }

    public void openWindow(){
        if(!isVisible()) {
			setVisible(true);
		}
        toFront();
    }

    public void closeWindow(){
    	resetGUI = false;
    	resetDesign=false;
        setVisible(false);
    }


	/**
	 * Farben festlegen
	 * @param bt Button, der gedrückt wurde
	 * @param key   Optionskey
	 */
	private void setColor(JButton bt,String key) {
		final Color c = JColorChooser.showDialog(this,rz.getLocale().getString(key),bt.getBackground());
		if(c != null) {
			bt.setBackground(c);
		}
	}

    private void cancelAction(){
        closeWindow();
    }
    private void applyAction(){
       toOptions();
    }
    private void saveAction(){
       applyAction();
       rz.getOptionFactory().saveOptions();
       if(resetGUI) {
       		rz.getFontFactory().saveOptions();
       		resetGUI=false;
       }
       closeWindow();
    }

    //Extras-Menü
    private void hideAction(){
        rz.getFensterFactory().getFensterListe().sperren(this);
    }

    private void refreshAction(){
        fromOptions();
    }
    //hilfe
    private void hilfeAction(){
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"einstellungen.html",this));
    }

}
