/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package de.lunqual.rzpro.fenster.etikettenfenster;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Rectangle2D;

import javax.swing.JPanel;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.etiketten.EtikettenItem;
import de.lunqual.rzpro.items.etiketten.EtikettenListe;

/**
 * @author lunqual
 *
 */
public class EtikettenBogenPanel extends JPanel {


	EtikettenListe							etiketten;

	public static final double	MIN_MARGIN = 4;
	Color										background;
	Color										bogen;
	Color										linie;
	Color										selected;
	Color										empty;
	Color										text;
	RzPro									rz;

	double									marginX;
	double									marginY;
	double									eWidth; // etiketten-breite
	double									eHeight; // etikettenhoehe
	double									bWidth; //bogen-breite
	double									bHeight; //bogen -hoehe
	int 										startRow;
	int										startCol;
	Font										panelFont;

	public EtikettenBogenPanel(RzPro rz) {
		super();
		this.rz=rz;
		background = Color.LIGHT_GRAY;
		empty = Color.WHITE;
		bogen = new Color(240,240,240);
		linie = Color.BLACK;
		selected = Color.WHITE;
		text = Color.BLACK;
	}

	public void setEtikettenListe(EtikettenListe etiketten) {
		this.etiketten=etiketten;
	}

	public EtikettenListe getEtikettenListe() {
		return etiketten;
	}

	@Override
	public void paint(Graphics g) {
		super.paint(g);
		g.setColor(background);
		g.fillRect(0,0,this.getWidth(),this.getHeight());
		if(etiketten != null) {
			getValues((Graphics2D)g);
			bogenZeichnen((Graphics2D)g);
			markStartEtikett((Graphics2D)g);
		}
	}

	/**
	 * ermittelt Hoehe/Breite von Bogen und Etikett in pixeln
	 *
	 */
	private void getValues(Graphics2D g) {
		// Hoehe/breite Verhältnis des EtikettenBogens
		final double aspect =  etiketten.getBogen().getHeight() / etiketten.getBogen().getWidth();
		// Breite ermitteln
		bWidth = this.getWidth() - (2 * MIN_MARGIN);
		bHeight = bWidth * aspect;
		if(bHeight > (this.getHeight() + (2*MIN_MARGIN))) {
			bWidth *= Math.abs((this.getHeight() + (2*MIN_MARGIN)) / bHeight);
			bHeight = bWidth * aspect;
		}
		marginX = (this.getWidth()-bWidth) / 2;
		marginY = (this.getHeight() - bHeight)/2;

		// etikettenbreite,hoehe
		eWidth = bWidth/etiketten.getBogen().getColumns();
		eHeight = bHeight/etiketten.getBogen().getRows();
		panelFont = new Font("arial",Font.PLAIN,(int)(eHeight/(EtikettenItem.ETIKETTENZEILEN + 3)));
		g.setFont(panelFont);
	}

	/**
	 * zeichnet den Etikettenbogen ins Panel
	 * @param g  Graphics2D-Object des Panels
	 */
	private void bogenZeichnen(Graphics2D g) {
		// erst den ausgefüllten Umriss des Bogens zeichnen
		g.setColor(bogen);
		g.fill3DRect((int)marginX,(int)marginY,(int)bWidth,(int)bHeight,true);
		// jetzt die einzelnen Etiketten
		g.setColor(linie);
		for(int i = 0;i < etiketten.getBogen().getColumns();i++) {
			for(int j = 0; j < etiketten.getBogen().getRows();j++) {
				g.drawRect((int)((i*eWidth)+marginX),(int)((j*eHeight)+marginY),(int)eWidth,(int)eHeight);
			}
		}
	}

	private Point getEtikettPosition(int n) {
		final Point pt = new Point();
		pt.y = (n-1)/etiketten.getBogen().getColumns();
		pt.x = (n - 1 )-(pt.y * etiketten.getBogen().getColumns()) ;
		return pt;
	}

	/**
	 * zeichnet ein Etikett
	 * @param n
	 */
	private void drawEtikett(Graphics2D g,int etikett,int position) {
	    int i;
		final int row = (int)(getEtikettPosition(position).getY()) ;
		final int col = (int)(getEtikettPosition(position).getX()) ;
		// hintergrund zeichnen
		if(etiketten.getBogen().getImage() != null) {
			if(!etiketten.getItem(etikett).isEmptyLabel()) {
				g.drawImage(etiketten.getBogen().getImage(),
						(int)((col * eWidth)+marginX),
						(int)((row * eHeight)+marginY),
						(int)eWidth,
						(int)eHeight,this);
			} else {
				g.setColor(empty);
				g.fillRect(
						(int)((col * eWidth)+marginX),
						(int)((row * eHeight)+marginY),
						(int)eWidth,
						(int)eHeight
						);
				g.setColor(text);
			}
		}else {
			g.setColor(empty);
			g.fillRect(
					(int)((col * eWidth)+marginX),
					(int)((row * eHeight)+marginY),
					(int)eWidth,
					(int)eHeight
					);
			g.setColor(text);
		}
		for(i = 1;i <= EtikettenItem.ETIKETTENZEILEN;i++) {
			final Rectangle2D r = g.getFontMetrics().getStringBounds(etiketten.getItem(etikett).getZeile(i-1),g);
			g.drawString(etiketten.getItem(etikett).getZeile(i-1),
				(int)(((col * eWidth) + (eWidth/2) + marginX) - (r.getWidth()/2)) ,
				(int)((row * eHeight)+marginY) + (i*g.getFontMetrics().getHeight())
				);
		}
		final Rectangle2D r = g.getFontMetrics().getStringBounds(etiketten.getItem(etikett).getLosnummer(),g);
		g.drawString(etiketten.getItem(etikett).getLosnummer(),
				(int)(((col * eWidth) + (eWidth/2) + marginX) - (r.getWidth()/2)) ,
				(int)((row * eHeight)+marginY) + (i*g.getFontMetrics().getHeight())
				);

	}
	/**
	 * markiert das StartEtikett
	 * @param g
	 */
	private void markStartEtikett(Graphics2D g) {
		g.setColor(selected);
		startRow = (int)(getEtikettPosition(etiketten.getStartEtikett()).getY());
		startCol = (int)(getEtikettPosition(etiketten.getStartEtikett()).getX());
		g.fill3DRect((int)((startCol * eWidth) + marginX),(int)((startRow *eHeight)+marginY),
					(int)eWidth,(int)eHeight,true
				);

		int startPosition = etiketten.getStartEtikett();
		g.setColor(text);
		for(int i = 0;(i < etiketten.size()) && (startPosition <= etiketten.getBogen().getAnzahl());i++,startPosition++) {
			drawEtikett(g,i,startPosition);
		}

	}

	public int getEtikettAt(Point pt) {
		int ret = -1;
	    getValues((Graphics2D)this.getGraphics());
		if(
			(pt.getX() >= marginX) &&
			(pt.getX() <= (this.getWidth()-marginX)) &&
		    (pt.getY() >= marginY) &&
			(pt.getY() <= (this.getHeight()-marginY))
		) {
			// im Rahmen
			final int col = (int)((pt.getX() - marginX)/eWidth ) ;
			final int row = (int)((pt.getY() - marginY) /eHeight) ;
			ret =( (row) * etiketten.getBogen().getColumns() + col)+1;
		}
		return ret;
	}
}
