/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package de.lunqual.rzpro.fenster.gewichtsfenster;


import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.fenster.JNumberField;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.rezeptur.RezepturItem;
import de.lunqual.rzpro.log.LogFactory;
import de.lunqual.rzpro.options.OptionFactory;
/**
 *
 * @author  lunqual
 */
public class GewichtsFenster extends JRzFrame{

    //GUI-Variablen
    private JToolBar tb1;
    private JMenuBar mb;
    private JMenu mnuDatei;
    private JMenu	mnuBearbeiten;
    private JMenu 	mnuFenster;
    private JMenu mnuExtras;
    private JMenu mnuHilfe;
      private  JPanel contentPanel;
      	private JPanel tbPanel;
      	private JPanel centerPanel;
      		private JPanel labelPanel;
      			private JLabel lblBezeichnung;
      		private JPanel anzeigePanel;
      			private JScrollPane scrAnzeige;
      				private JEditorPane txtAnzeige;
      		private JPanel rechenPanel;
      			private JPanel rechenTaraPanel;
      				private JNumberField txtTara;
      				private JLabel lblErgebnis;
      			private JPanel rechenGewichtPanel;
	      			private JNumberField txtLiter;
	      			private JLabel lblRechnenLiter;
	      			private JNumberField txtKg;
	      			private JLabel lblRechnenKg;
  		private JPanel buttonPanel;
  	    	private JButton btClose;
  	    	private JButton btHilfe;

    public static final int         		ACTION_CLOSE_CODE = 1001;
    public static final String     		ACTION_CLOSE_TEXT = "verbrauch.action_close";
    public static final int         		ACTION_HILFE_CODE = 1003;
    public static final String     		ACTION_HILFE_TEXT = "action_hilfe";
    public static final int         		ACTION_HIDE_CODE = 1004;
    public static final String    		ACTION_HIDE_TEXT = "action_hide";


    RezepturItem	r;

    /** Creates new form AdressenFenster */
    public GewichtsFenster(RzPro r, String name, Object extendedData) {
        super(r,name,extendedData);

        createActions();
        createGUIComponents();
        setGUIComponents();
        getMessage((MessageItem)extendedData);
    }

    @Override
	public void createGUIComponents() {
    	// Menü
    	mb = new JMenuBar();
    	mnuDatei = new JMenu();
    	mnuFenster = new JMenu();
    	mnuExtras = new JMenu();
    	mnuHilfe = new JMenu();
    	mb.add(mnuDatei);
    	mb.add(mnuExtras);
    	mb.add(mnuHilfe);
    	setJMenuBar(mb);
		//Toolbar
		tb1 = new JToolBar();
		tb1.setFloatable(false);
		tb1.setRollover(true);
		//ToolbarPanel
		//contentPanel
		contentPanel = new JPanel(new BorderLayout());
			tbPanel = new JPanel(new BorderLayout());
				tbPanel.add(tb1,BorderLayout.NORTH);
			contentPanel.add(tbPanel,BorderLayout.NORTH);
			centerPanel = new JPanel(new BorderLayout());
				labelPanel=new JPanel(new BorderLayout());
					lblBezeichnung = new JLabel();
						lblBezeichnung.setHorizontalAlignment(SwingConstants.CENTER);
					labelPanel.add(lblBezeichnung);
					labelPanel.setBorder(BorderFactory.createEtchedBorder());
				centerPanel.add(labelPanel,BorderLayout.NORTH);
				anzeigePanel=new JPanel(new BorderLayout());
					scrAnzeige = new JScrollPane();
						txtAnzeige = new JEditorPane();
							txtAnzeige.setContentType("text/html");
							txtAnzeige.setEditable(false);
							txtAnzeige.setPreferredSize(new Dimension(200,200));
						scrAnzeige.setViewportView(txtAnzeige);
					anzeigePanel.add(scrAnzeige,BorderLayout.CENTER);
					anzeigePanel.setBorder(BorderFactory.createEtchedBorder());
				centerPanel.add(anzeigePanel,BorderLayout.CENTER);
				rechenPanel=new JPanel (new BorderLayout());
				
					rechenTaraPanel=new JPanel(new BorderLayout());
						txtTara= new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_NORMAL),0.0,0.0,Double.POSITIVE_INFINITY);
						txtTara.setColumns(12);
		 				txtTara.addKeyListener(new java.awt.event.KeyAdapter() {
	 			            public void keyReleased(java.awt.event.KeyEvent evt) {
	 			            	if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
	 			            		if(r != null) {
		 			            		txtTara.validateField();
		 			            		anzeige();
		 			            	}
	 			            	}
	 			            }
	 			        });
		 				txtTara.addFocusListener(new FocusListener() {
		 					public void focusGained(FocusEvent evt) {
		 					}
		 					public void focusLost(FocusEvent evt) {
		 						txtTara.validateField();
		 						anzeige();
		 					}
		 				});
						rechenTaraPanel.add(txtTara,BorderLayout.WEST);
						lblErgebnis = new JLabel() ;
						rechenTaraPanel.add(lblErgebnis,BorderLayout.CENTER);
					rechenTaraPanel.setBorder(BorderFactory.createEtchedBorder());
				rechenPanel.add(rechenTaraPanel,BorderLayout.NORTH);
					rechenGewichtPanel = new JPanel(new GridLayout(1,4));
						txtLiter = new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_NORMAL),1.0,0.0,Double.POSITIVE_INFINITY);
		 				txtLiter.addKeyListener(new java.awt.event.KeyAdapter() {
	 			            public void keyReleased(java.awt.event.KeyEvent evt) {
	 			            	if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
	 			            		if(r != null) {
		 			            		txtLiter.validateField();
		 			            		txtKg.setValue(r.getLitergewicht()*txtLiter.getValue());
		 			            		anzeige();
		 			            	}
	 			            	}
	 			            }
	 			        });
		 				txtLiter.addFocusListener(new FocusListener() {
		 					public void focusGained(FocusEvent evt) {
		 					}
		 					public void focusLost(FocusEvent evt) {
		 						if(r != null) {
			 						txtLiter.validateField();
	 			            		txtKg.setValue(r.getLitergewicht()*txtLiter.getValue());
			 						anzeige();
		 						}
		 					}
		 				});
						rechenGewichtPanel.add(txtLiter);
						lblRechnenLiter=new JLabel();
							lblRechnenLiter.setHorizontalAlignment(SwingConstants.CENTER);
						rechenGewichtPanel.add(lblRechnenLiter);
						txtKg = new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_NORMAL),1.0,0.0,Double.POSITIVE_INFINITY);
		 				txtKg.addKeyListener(new java.awt.event.KeyAdapter() {
	 			            public void keyReleased(java.awt.event.KeyEvent evt) {
	 			            	if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
	 			            		if(r != null) {
		 			            		txtKg.validateField();
		 			            		txtLiter.setValue((1/r.getLitergewicht())*txtKg.getValue());
		 			            		anzeige();
		 			            	}
	 			            	}
	 			            }
	 			        });
		 				txtKg.addFocusListener(new FocusListener() {
		 					public void focusLost(FocusEvent evt) {
		 						if(r != null) {
			 						txtKg.validateField();
	 			            		txtLiter.setValue((1/r.getLitergewicht())*txtKg.getValue());
			 						anzeige();
		 						}
		 					}

							public void focusGained(FocusEvent arg0) {
							}
		 				});
						rechenGewichtPanel.add(txtKg);
						lblRechnenKg=new JLabel();
							lblRechnenKg.setHorizontalAlignment(SwingConstants.CENTER);
						rechenGewichtPanel.add(lblRechnenKg);	
						rechenGewichtPanel.setBorder(BorderFactory.createEtchedBorder());
					rechenPanel.add(rechenGewichtPanel,BorderLayout.SOUTH);
				centerPanel.add(rechenPanel,BorderLayout.SOUTH);
			 contentPanel.add(centerPanel,BorderLayout.CENTER);
			 buttonPanel=new JPanel(new BorderLayout());
				btClose = new JButton();
					buttonPanel.add(btClose,BorderLayout.WEST);
				btHilfe = new JButton();
			buttonPanel.add(btHilfe,BorderLayout.EAST);
		contentPanel.add(buttonPanel,BorderLayout.SOUTH);

		//Panels ans Fenster hängen;
		this.getContentPane().setLayout(new BorderLayout());

		this.getContentPane().add(contentPanel, BorderLayout.CENTER);
    }


    @Override
	public void setGUIComponents() {
        setTitle(rz.getVersionString() + " " + rz.getLocale().getString("gewicht.titel").replaceAll("%s",""));

		mnuDatei.setText(rz.getLocale().getString("menu.datei"));
		mnuExtras.setText(rz.getLocale().getString("menu.extras"));
		mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));

		mnuDatei.addSeparator();
        mnuDatei.add(getAction(ACTION_CLOSE_CODE));

        mnuExtras.add(getAction(ACTION_HIDE_CODE));
        mnuHilfe.add(getAction(ACTION_HILFE_CODE));

		tb1.add(getAction(ACTION_CLOSE_CODE));
		tb1.addSeparator();
		tb1.add(getAction(ACTION_HIDE_CODE));
		tb1.addSeparator();
		tb1.add(getAction(ACTION_HILFE_CODE));
		tb1.addSeparator();

		lblRechnenLiter.setText(rz.getLocale().getString("gewicht.label_liter"));
		lblRechnenKg.setText(rz.getLocale().getString("gewicht.label_kg"));		
		lblErgebnis.setText(rz.getLocale().getString("gewicht.label_ergebnis"));		
				
		btHilfe.setAction(getAction(ACTION_HILFE_CODE));
		btClose.setAction(getAction(ACTION_CLOSE_CODE));

		setResizable(true);
        rz.getFontFactory().setFrameFonts(this);
        pack();
        rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;
    }

    @Override
	public void getMessage(MessageItem msg) {
		rz.getLogFactory().logMessage(LogFactory.LOG_MESSAGE,"GewichtsFenster",String.valueOf(msg.getMsgCode()+":"+String.valueOf(msg.getCode())));
        switch(msg.getMsgCode()) {
    	case MessageItem.MSG_ACTIONPERFORMED:
            switch(msg.getCode()){
		          case ACTION_HILFE_CODE: hilfeAction();break;
		          case ACTION_HIDE_CODE:hideAction();break;
		          case ACTION_CLOSE_CODE:closeWindow();break;
		          default :
		              break;
           }
    		break;
    	case MessageItem.MSG_SHOW_GEWICHT:
    		int id=msg.getCode();
    		if(id != 0) {
    			r = rz.getDatabase().getRezeptur().dbGetRezeptur(id,true);
    	        setTitle(rz.getVersionString() + " " + rz.getLocale().getString("gewicht.titel").replaceAll("%s",r.getTitel()));
    		}
    		break;
        default:
            rz.getLogFactory().logMessage(2, "GewichtsFenster", "auswahlAction:" + msg.getMsgCode());
            break;
        }

    }
    @Override
	public void createActions(){
        actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT, KeyEvent.VK_F5 ,InputEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT, KeyEvent.VK_F1,0));
        actionList.put(String.valueOf(ACTION_CLOSE_CODE),new AuswahlAction(rz,this,ACTION_CLOSE_CODE,ACTION_CLOSE_TEXT, KeyEvent.VK_ESCAPE,0));

    }

    private void anzeige() {
        lblBezeichnung.setText(rz.getLocale().getString("gewicht.label_bezeichnung")
        		.replaceAll("%s",r.getTitel()).replaceAll("%g",rz.getLocale().formatNumber(r.getLitergewicht(),OptionFactory.NF_LITERGEWICHT)));

		rz.getAusgabeFactory().gewichtsAusgabe(txtAnzeige, r,txtTara.getValue(),txtLiter.getValue());
    }
    @Override
	public void openWindow(){
    	if(r != null) {
            txtKg.setValue(r.getLitergewicht());
    		anzeige();
            setVisible(true);
            toFront();
            txtTara.requestFocus();
    	}
    }

    @Override
	public void closeWindow(){
        rz.getFensterFactory().getFensterListe().disposeFrame(this);
    }

    //Extras-Menü
    private void hideAction(){
        rz.getFensterFactory().getFensterListe().sperren(this);
    }

    //hilfe
    private void hilfeAction(){
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"gewichtsfenster.html",this));
    }


}

