
/**
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package de.lunqual.rzpro.fenster.inventurfenster;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.text.SimpleDateFormat;

import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.SwingConstants;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.ausgabe.CSVExport;
import de.lunqual.rzpro.ausgabe.ReportFactory;
import de.lunqual.rzpro.database.ItemNotFoundException;
import de.lunqual.rzpro.fenster.JNumberField;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fenster.JSelectedTextField;
import de.lunqual.rzpro.fenster.ZutatenDialog;
import de.lunqual.rzpro.fenster.dialoge.DialogControl;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.abfrage.AbfrageItem;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.container.ContainerItem;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.items.ergebnis.ErgebnisItem;
import de.lunqual.rzpro.items.inventur.InventurDetail;
import de.lunqual.rzpro.items.inventur.InventurItem;
import de.lunqual.rzpro.items.inventur.InventurSummenItem;
import de.lunqual.rzpro.items.inventur.InventurZeilenItem;
import de.lunqual.rzpro.items.inventur.InventurZeilenliste;
import de.lunqual.rzpro.items.inventur.RaumItem;
import de.lunqual.rzpro.items.inventur.SortOrderItem;
import de.lunqual.rzpro.items.inventur.inventurDetailItem;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.mischungen.MischungsHeaderItem;
import de.lunqual.rzpro.items.report.ReportItem;
import de.lunqual.rzpro.items.rezeptur.ChangesListe;
import de.lunqual.rzpro.items.rezeptur.SteuerDatenItem;
import de.lunqual.rzpro.items.rezeptur.ZutatenSuchItem;
import de.lunqual.rzpro.items.stichworte.StichwortListe;
import de.lunqual.rzpro.items.tank.tankItem;
import de.lunqual.rzpro.items.lager.LagerItem;
import de.lunqual.rzpro.items.mischungen.SortenItem;
import de.lunqual.rzpro.items.rezeptur.SteuerLagerItem;
import de.lunqual.rzpro.options.OptionFactory;

/**
 *
 */
public class InventurEingabe extends JRzFrame implements TableColumnModelListener {

    //GUI-Variablen
    private JMenuBar mb;
    	private JMenu mnuDatei;
    	private JMenu mnuBearbeiten;
    	private JMenu mnuExtras;
    	private JMenu mnuHilfe;
    private JPanel mainPanel;
    	private JPanel toolbarPanel;
    		private JToolBar tb1;
    	private JPanel contentPanel;
    		private JPanel bezeichnungPanel;
    			private JLabel lblBezeichnung;
    		private JPanel centerPanel;
    			private JPanel eingabePanel;
    				private JPanel panel0;
    					private JLabel lbl0;
    				private JPanel panel1;
    					private JButton btLeer;
    					private JLabel lblRaeume;
    					private JComboBox cmbRaumliste;
    					private JLabel lblTanknummer;
    					private JSelectedTextField txtTanknummer;
    					private JLabel lblInhalt;
    					private JCheckBox chkPrefix;
    					private JButton btInhalt;
    					private JSelectedTextField txtInhalt;
    					private JLabel lblStaerke;
    					private JNumberField txtStaerke;
    					private JCheckBox chkStaerkeAusRezeptur;
    				private JPanel panel2;
    					private JLabel lblLiter;
    					private JNumberField txtLiter;
    					private JLabel lblTanktemperatur;
    					private JNumberField txtTanktemperatur;
    				private JPanel panel3;
    					private JLabel lblBrutto;
    					private JNumberField txtBrutto;
    					private JLabel lblTara;
    					private JNumberField txtTara;
    					private JLabel lblLitergewicht;
    					private JNumberField txtLitergewicht;
    					private JButton btLitergewicht;
    			    private JPanel panel31;
    			    	private JLabel lblLager;
    			    	private JComboBox cmbLager;
    			    	private JLabel lblSteuer_Artikel;
    			    	private JSelectedTextField txtSteuerArtikel;
    			    	private JLabel lblSorte;
    			    	private JComboBox cmbSorte;
    			    	private JLabel lblSteuerlager;
    			    	private JComboBox cmbSteuerlager;
    			    	private JButton btVorgabeSpeichern;
    				private JPanel panel4;
    					private JButton btAdd;
    					private JButton btLoeschen;
    			private JPanel listenPanel;
    				private JPanel listenKopf;
    					private JLabel lblSortOrder;
    					private JComboBox cmbSortOrder;
    					private JSelectedTextField txtFilter;
    					private JButton btRefresh;
        			private JScrollPane scrListe;
        				private JTable tblListe;
        				private JPanel summenPanel;
        					private JPanel summenPanel1;
        						private JLabel lblDetail;
        					private JPanel summenPanel2;
        						private JLabel lblSumme1;
        						private JLabel lblSumme;
    	private JPanel buttonPanel;
    		private JButton btClose;
    		private JLabel lblFormular;
    		private JComboBox cmbFormular;
    		private JButton btPrint;
    		private JCheckBox chkVorschau;
    		private JCheckBox chkDuplex;
			private JButton btCsvFile;
			private JButton btCsvCopy;
    		private JButton btHilfe;

	    //Actioncodes
	    public static final int         ACTION_CLOSE_CODE = 1000;
	    public static final String     ACTION_CLOSE_TEXT = "inventureingabe.action_close";
	    public static final int         ACTION_HILFE_CODE = 1002;
	    public static final String     ACTION_HILFE_TEXT = "action_hilfe";
	    public static final int         ACTION_HIDE_CODE = 1003;
	    public static final String     ACTION_HIDE_TEXT = "action_hide";
	    public static final int         ACTION_REFRESH_CODE = 1005;
	    public static final String     ACTION_REFRESH_TEXT = "inventureingabe.action_refresh";
	    public static final int         ACTION_LITERGEWICHT_CODE = 1006;
	    public static final String     ACTION_LITERGEWICHT_TEXT = "inventureingabe.action_litergewicht";
	    public static final int         ACTION_LEER_CODE = 1007;
	    public static final String     ACTION_LEER_TEXT = "inventureingabe.action_leer";
	    public static final int         ACTION_ADD_CODE = 1008;
	    public static final String     ACTION_ADD_TEXT = "inventureingabe.action_add";
	    public static final int         ACTION_DELETE_CODE = 1009;
	    public static final String     ACTION_DELETE_TEXT = "inventureingabe.action_loeschen";
	    public static final int         ACTION_PRINT_CODE = 1010;
	    public static final String     ACTION_PRINT_TEXT = "inventureingabe.action_drucken";
	    public static final int			ACTION_MISCHUNG_CODE=1011;
	    public static final String     ACTION_MISCHUNG_TEXT = "inventureingabe.action_mischung";
	    public static final int			ACTION_ZUGANG_CODE=1012;
	    public static final String     ACTION_ZUGANG_TEXT = "inventureingabe.action_zugang";
	    public static final int			ACTION_ABGANG_CODE=1013;
	    public static final String     ACTION_ABGANG_TEXT = "inventureingabe.action_abgang";
	    public static final int			ACTION_SUCHEN_CODE=1014;
	    public static final String     ACTION_SUCHEN_TEXT = "inventureingabe.action_suchen";
	    public static final int			ACTION_TANK_CODE=1015;
	    public static final String     ACTION_TANK_TEXT = "inventureingabe.action_tanks";
	    public static final int			ACTION_SUCHEN_REZEPTUR_CODE=1016;
	    public static final String     ACTION_SUCHEN_REZEPTUR_TEXT = "inventureingabe.action_suchen_rezeptur";
	    public static final int			ACTION_VORGABE_CODE=1017;
	    public static final String     ACTION_VORGABE_TEXT = "inventureingabe.action_vorgabe";
	    public static final int			ACTION_EINGABEFELD_CODE=1018;
	    public static final String     ACTION_EINGABEFELD_TEXT = "inventureingabe.action_eingabefeld";
	    public static final int         		ACTION_CSV_FILE_CODE = 1019;
	    public static final String      		ACTION_CSV_FILE_TEXT = "csv.export_file";
	    public static final int         		ACTION_CSV_COPY_CODE = 1020;
	    public static final String      		ACTION_CSV_COPY_TEXT = "csv.export_copy";	    


	    public static final int			MAX_COLUMN			= 22;
	    public static final int			C_DATUM				= 0;
	    public static final int			C_TYP				= 1;
	    public static final int			C_RAUM				= 2;
	    public static final int			C_TANK				= 3;
	    public static final int			C_INHALT				= 4;
	    public static final int			C_STAERKE			= 5;
	    public static final int			C_LITER20			= 6;
	    public static final int			C_LA					= 7;
	    public static final int			C_LITER				= 8;
	    public static final int			C_TT					= 9;
	    public static final int			C_TAFEL3				= 10;
	    public static final int			C_BRUTTO				= 11;
	    public static final int			C_TARA				= 12;
	    public static final int			C_NETTO				= 13;
	    public static final int			C_EXTRAKT			= 14;
	    public static final int			C_TAFEL2				= 15;
	    public static final int			C_LITERGEWICHT		= 16;
	    public static final int			C_USER				= 17;
	    public static final int			C_LAGER				= 18;
	    public static final int			C_STEUER_ARTIKEL		= 19;
	    public static final int			C_SORTE				= 20;
	    public static final int			C_STEUERLAGER		= 21;

	    InventurItem	  				ii;
	    JRzFrame		  				origin;
	    ZutatenDialog					zd;
	    int								rezeptur=0;
	    int 								extrakt=InventurZeilenItem.ZEILE_EXTRAKTFREI;
	    InventurZeilenliste 			zeilen;
	    InventurSummenItem 	si;
	    double						summe_la = 0.0;
	    double						summe_liter = 0.0;
	    InventurDetail				ivd;
	    
	    /** Creates new form AdressEingabe */
    public InventurEingabe(RzPro r, String name,Object extendedData) {
        super(r,name,extendedData);
        createActions();
        createGUIComponents();
        setGUIComponents();
        si = new InventurSummenItem();
        getMessage((MessageItem)extendedData);
    }

    public void createGUIComponents() {
        mb = new JMenuBar();
		mnuDatei = new JMenu();
			mb.add(mnuDatei);
		mnuBearbeiten = new JMenu();
			mb.add(mnuBearbeiten);
        mnuExtras = new JMenu();
        	mb.add(mnuExtras);
        mnuHilfe = new JMenu();
        	mb.add(mnuHilfe);
		setJMenuBar(mb);
		mainPanel = new JPanel(new BorderLayout());
		toolbarPanel = new JPanel(new BorderLayout());
			tb1 = new JToolBar();
			tb1.setFloatable(false);
			tb1.setRollover(true);
			toolbarPanel.add(tb1);
			mainPanel.add(toolbarPanel,BorderLayout.NORTH);
			contentPanel = new JPanel(new BorderLayout());
					bezeichnungPanel = new JPanel(new BorderLayout());
						lblBezeichnung = new JLabel();
							lblBezeichnung.setHorizontalAlignment(SwingConstants.CENTER);
						bezeichnungPanel.add(lblBezeichnung,BorderLayout.NORTH);
					contentPanel.add(bezeichnungPanel,BorderLayout.NORTH);
					//----------------------------------------------------------
					centerPanel = new JPanel(new BorderLayout());
						eingabePanel = new JPanel();
							eingabePanel.setLayout(new BoxLayout(eingabePanel, BoxLayout.PAGE_AXIS));
							eingabePanel.setBorder(BorderFactory.createEtchedBorder());
							//Panel 0
							panel0=new JPanel(new BorderLayout());
								lbl0=new JLabel();
									lbl0.setHorizontalAlignment(SwingConstants.CENTER);
								panel0.add(lbl0,BorderLayout.CENTER);
							eingabePanel.add(panel0);
							//panel 1
							panel1= new JPanel();
								panel1.setLayout(new BoxLayout(panel1, BoxLayout.LINE_AXIS));
								btLeer = new JButton();
								panel1.add(btLeer);
								lblRaeume = new JLabel();
									lblRaeume.setHorizontalAlignment(SwingConstants.CENTER);
								panel1.add(lblRaeume);
								cmbRaumliste = new JComboBox();
								panel1.add(cmbRaumliste);
								lblTanknummer = new JLabel();
									lblTanknummer.setHorizontalAlignment(SwingConstants.CENTER);
								panel1.add(lblTanknummer);
								txtTanknummer = new JSelectedTextField();
									txtTanknummer.setColumns(8);
									txtTanknummer.addFocusListener(new FocusListener() {
										public void focusGained(FocusEvent evt) {
										}
										public void focusLost(FocusEvent evt) {
											checkTankNummer();
											}
							    		});
								panel1.add(txtTanknummer);
								lblInhalt = new JLabel();
									lblInhalt.setHorizontalAlignment(SwingConstants.CENTER);
								panel1.add(lblInhalt);
								chkPrefix = new JCheckBox();
								chkPrefix.addActionListener(new ActionListener() {
				    	        	public void actionPerformed(ActionEvent evt) {
				    	        			rz.getOptionFactory().setOption("inventureingabe.prefix",chkPrefix.isSelected()?1:0);
				    	        			rz.getOptionFactory().saveOptions();
				    	        	}
				                });
								panel1.add(chkPrefix);
								btInhalt = new JButton();
			    				btInhalt.addActionListener(new java.awt.event.ActionListener() {
				    				public void actionPerformed(java.awt.event.ActionEvent evt) {
				    						showZutatenDialog(txtInhalt.getText().trim());
				    				}
				    			});
								panel1.add(btInhalt);
								txtInhalt = new JSelectedTextField();
									txtInhalt.setColumns(25);
									panel1.add(txtInhalt);
								lblStaerke = new JLabel();
									lblStaerke.setHorizontalAlignment(SwingConstants.CENTER);
								panel1.add(lblStaerke);
								txtStaerke = new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_STAERKE),0.0,0.0,100.0);
									txtStaerke.setColumns(5);
									txtStaerke.addFocusListener(new FocusListener() {
										public void focusGained(FocusEvent evt) {
										}
										public void focusLost(FocusEvent evt) {
											if(rezeptur==0) {
												txtLitergewicht.setValue(rz.getTafelFactory().Litergewicht(txtStaerke.getValue()));
											}
											}
							    		});
								panel1.add(txtStaerke);
								chkStaerkeAusRezeptur= new JCheckBox();
								chkStaerkeAusRezeptur.addActionListener(new java.awt.event.ActionListener() {
	    			                public void actionPerformed(java.awt.event.ActionEvent evt) {
	    			                    if(chkStaerkeAusRezeptur.isSelected()) {
	    			                    	rz.getOptionFactory().setOption("inventureingabe.staerke_aus_rezeptur", 1);
	    			                    	rz.getOptionFactory().saveOptions();
	    			                    } else {
	    			                    	rz.getOptionFactory().setOption("inventureingabe.staerke_aus_rezeptur", 0);
	    			                    	rz.getOptionFactory().saveOptions();
	    			                    }
	    			                	}
	    			            	});
								panel1.add(chkStaerkeAusRezeptur);
							eingabePanel.add(panel1);
							//---------------------------------------------
							// panel2
							panel2=new JPanel();
							panel2.setLayout(new BoxLayout(panel2, BoxLayout.LINE_AXIS));
								lblLiter = new JLabel();
								panel2.add(lblLiter);
								txtLiter = new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_NORMAL),0.0,0.0,Double.POSITIVE_INFINITY);
									txtLiter.setColumns(10);
									txtLiter.addFocusListener(new FocusListener() {
										public void focusGained(FocusEvent evt) {
										}
										public void focusLost(FocusEvent evt) {
											if(txtLiter.getValue() > 0.0) {
												txtTanktemperatur.setValue(20.0);
											}
											}
							    		});
								panel2.add(txtLiter);
								lblTanktemperatur = new JLabel();
								panel2.add(lblTanktemperatur);
								txtTanktemperatur = new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_STAERKE),0.0,-30.0,+40.0);
									txtTanktemperatur.setColumns(10);
								panel2.add(txtTanktemperatur);
							eingabePanel.add(panel2);
							//---------------------------------------------
							// panel3
							panel3=new JPanel();
								panel3.setLayout(new BoxLayout(panel3, BoxLayout.LINE_AXIS));
								lblBrutto = new JLabel();
								panel3.add(lblBrutto);
								txtBrutto = new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_NORMAL),0.0,0.0,Double.POSITIVE_INFINITY);
								txtBrutto.setColumns(10);
								panel3.add(txtBrutto);
								lblTara = new JLabel();
								panel3.add(lblTara);
								txtTara = new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_NORMAL),0.0,0.0,Double.POSITIVE_INFINITY);
								txtTara.setColumns(10);
								panel3.add(txtTara);
								lblLitergewicht = new JLabel();
								panel3.add(lblLitergewicht);
								txtLitergewicht = new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_LITERGEWICHT),0.0,0.0,Double.POSITIVE_INFINITY);
								txtLitergewicht.setColumns(10);
								panel3.add(txtLitergewicht);
								btLitergewicht = new JButton();
								panel3.add(btLitergewicht);
								eingabePanel.add(panel3);
								
								//Panel31
								panel31 = new JPanel(new GridLayout(1,8));
			    			    		lblLager = new JLabel();
			    			    			lblLager.setHorizontalAlignment(SwingConstants.TRAILING);
			    			    		panel31.add(lblLager);
			    			    		cmbLager = new JComboBox();
			    			    			rz.getDatabase().getLager().setLagerCmb(cmbLager, 1);
			    			    		panel31.add(cmbLager);
			    			    		lblSteuer_Artikel = new JLabel();
			    			    			lblSteuer_Artikel.setHorizontalAlignment(SwingConstants.TRAILING);
			    			    		panel31.add(lblSteuer_Artikel);
			    			    		txtSteuerArtikel = new JSelectedTextField();
			    			    		panel31.add(txtSteuerArtikel);
			    			    		lblSorte = new JLabel();;
			    			    			lblSorte.setHorizontalAlignment(SwingConstants.TRAILING);
			    			    		panel31.add(lblSorte);
			    			    		cmbSorte = new JComboBox();
			    			    			rz.getDatabase().getMischungen().setSortenCmb(cmbSorte);
			    			    		panel31.add(cmbSorte);
			    			    		lblSteuerlager = new JLabel();
			    			    			lblSteuerlager.setHorizontalAlignment(SwingConstants.TRAILING);
			    			    		panel31.add(lblSteuerlager);
			    			    		cmbSteuerlager = new JComboBox();
			    			    			rz.getDatabase().getRezeptur().setSteuerlagerCmb(cmbSteuerlager, 1);
			    			    		panel31.add(cmbSteuerlager);
			    			    		btVorgabeSpeichern = new JButton();
			    			    		panel31.add(btVorgabeSpeichern);
								eingabePanel.add(panel31);
								//panel4
								panel4=new JPanel();
									panel4.setLayout(new BoxLayout(panel4, BoxLayout.LINE_AXIS));
									btAdd = new JButton();
									panel4.add(btAdd);
									btLoeschen = new JButton();
									panel4.add(btLoeschen);
								panel4.setBorder(BorderFactory.createRaisedBevelBorder());
							eingabePanel.add(panel4);
							eingabePanel.setBorder(BorderFactory.createRaisedBevelBorder());
							centerPanel.add(eingabePanel,BorderLayout.NORTH);
							listenPanel=new JPanel(new BorderLayout());
							listenKopf=new JPanel(new GridLayout(1,4));
							lblSortOrder = new JLabel();
								listenKopf.add(lblSortOrder);
								cmbSortOrder=new JComboBox();
									cmbSortOrder.addItem(new SortOrderItem(rz.getLocale().getString("inventureingabe.sort_datum"),"erstellt","tanknummer_num"));
									cmbSortOrder.addItem(new SortOrderItem(rz.getLocale().getString("inventureingabe.sort_raum"),"raum","tanknummer_num"));
									cmbSortOrder.addItem(new SortOrderItem(rz.getLocale().getString("inventureingabe.sort_tanknummer"),"tanknummer_num","tanknummer_num"));
									cmbSortOrder.addItem(new SortOrderItem(rz.getLocale().getString("inventureingabe.sort_bezeichnung"),"bezeichnung","tanknummer_num"));
									cmbSortOrder.addItem(new SortOrderItem(rz.getLocale().getString("inventureingabe.sort_lager"),"lager","tanknummer_num"));
									cmbSortOrder.addItem(new SortOrderItem(rz.getLocale().getString("inventureingabe.sort_steuer_artikel"),"steuer_artikel","tanknummer_num"));
									cmbSortOrder.addItem(new SortOrderItem(rz.getLocale().getString("inventureingabe.sort_sorte"),"sorte","tanknummer_num"));
									cmbSortOrder.addItem(new SortOrderItem(rz.getLocale().getString("inventureingabe.sort_steuerlager"),"steuerlager","tanknummer_num"));
									cmbSortOrder.setSelectedIndex(rz.getOptionFactory().getOption("inventureingabe.sortorder",0));
									listenKopf.add(cmbSortOrder);
									cmbSortOrder.addActionListener(new java.awt.event.ActionListener() {
		    			                public void actionPerformed(java.awt.event.ActionEvent evt) {
		    			                    if(txtFilter != null) {
		    			                    	txtFilter.requestFocus();
		    			                    }
		    			                	}
		    			            	});
								btRefresh=new JButton();
								txtFilter = new JSelectedTextField();
								txtFilter.addKeyListener(new java.awt.event.KeyAdapter() {
			 			            public void keyReleased(java.awt.event.KeyEvent evt) {
			 			            	if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
			 			            		refreshAction();
			 			            	}
			 			            }
			 			        });
								listenKopf.add(txtFilter);
								listenKopf.add(btRefresh);
								listenKopf.setBorder(BorderFactory.createEtchedBorder());
								listenPanel.add(listenKopf,BorderLayout.NORTH);
								scrListe=new JScrollPane();
									tblListe=new JTable();
									tblListe.setName("inventurfenster.spalten");
					    			tblListe.setColumnSelectionAllowed(false);
					    			tblListe.setRowSelectionAllowed(true);
									tblListe.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
					    			tblListe.getSelectionModel().addListSelectionListener(new ListSelectionListener() {
					                    public void valueChanged(ListSelectionEvent e) {
					        			        if (e.getValueIsAdjusting()) {
													return;
												}
					        			        listSelectionEvent();
					                        }
						    			});
								scrListe.setViewportView(tblListe);
								listenPanel.add(scrListe,BorderLayout.CENTER);
								summenPanel = new JPanel(new BorderLayout());
								summenPanel1 = new JPanel(new BorderLayout());
									lblDetail = new JLabel();
									lblDetail.setHorizontalAlignment(SwingConstants.CENTER);
									lblDetail.setBorder(BorderFactory.createEtchedBorder());
									summenPanel1.add(lblDetail,BorderLayout.NORTH);
								summenPanel.add(summenPanel1,BorderLayout.NORTH);
								summenPanel2 = new JPanel(new GridLayout(1,2));
									lblSumme = new JLabel();
										lblSumme.setHorizontalAlignment(SwingConstants.CENTER);
										lblSumme.setBorder(BorderFactory.createEtchedBorder());
									summenPanel2.add(lblSumme);
									lblSumme1 = new JLabel();
										lblSumme1.setHorizontalAlignment(SwingConstants.CENTER);
										lblSumme1.setBorder(BorderFactory.createEtchedBorder());
									summenPanel2.add(lblSumme1);
								summenPanel.add(summenPanel2,BorderLayout.SOUTH);
								listenPanel.add(summenPanel,BorderLayout.SOUTH);
							centerPanel.add(listenPanel,BorderLayout.CENTER);
						centerPanel.setBorder(BorderFactory.createRaisedBevelBorder());
					contentPanel.add(centerPanel,BorderLayout.CENTER);
			mainPanel.add(contentPanel,BorderLayout.CENTER);
			buttonPanel = new JPanel(new GridLayout(1,8));
				btClose = new JButton();
					buttonPanel.add(btClose);
				lblFormular=new JLabel();
					lblFormular.setHorizontalAlignment(SwingConstants.RIGHT);
					buttonPanel.add(lblFormular);
				cmbFormular=new JComboBox();
					rz.getDatabase().getReport().dbGetReportListeCombo(cmbFormular,ReportFactory.REPORT_TYPE_INVENTUR);
	        	    cmbFormular.addActionListener(new ActionListener() {
	    	        	public void actionPerformed(ActionEvent evt) {
	    	        		if(cmbFormular.getSelectedIndex() != -1) {
	    	        			rz.getOptionFactory().setOption("report.inventur",((ReportItem)cmbFormular.getSelectedItem()).getID());
	    	        		}
	    	        	}
	                });
					buttonPanel.add(cmbFormular);
				btPrint = new JButton();
					buttonPanel.add(btPrint);
				chkVorschau = new JCheckBox();
					buttonPanel.add(chkVorschau);
				chkDuplex = new JCheckBox();
			    	chkDuplex.setSelected((rz.getOptionFactory().getOption("inventur.duplex",0) == 1?true:false));
					chkDuplex.addActionListener(new ActionListener() {
	    	        	public void actionPerformed(ActionEvent evt) {
	    	        		rz.getOptionFactory().setOption("inventur.duplex", chkDuplex.isSelected()?1:0);
	    	        		rz.getOptionFactory().saveOptions();
	    	        	}
	        	    });
					buttonPanel.add(chkDuplex);
					btCsvFile = new JButton();
					buttonPanel.add(btCsvFile);
					btCsvCopy = new JButton();
					buttonPanel.add(btCsvCopy);
					btHilfe = new JButton();
						buttonPanel.add(btHilfe);
					
		getContentPane().setLayout(new BorderLayout());
		getContentPane().add(toolbarPanel,BorderLayout.NORTH);
		getContentPane().add(mainPanel,BorderLayout.CENTER);
		getContentPane().add(buttonPanel,BorderLayout.SOUTH);

    }

    public void createActions() {
        actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT, KeyEvent.VK_F1 ,0));
        actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT,KeyEvent.VK_F5 ,KeyEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_CLOSE_CODE),new AuswahlAction(rz,this,ACTION_CLOSE_CODE,ACTION_CLOSE_TEXT,KeyEvent.VK_ESCAPE ,KeyEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_REFRESH_CODE),new AuswahlAction(rz,this,ACTION_REFRESH_CODE,ACTION_REFRESH_TEXT,KeyEvent.VK_F5 ,0));
        actionList.put(String.valueOf(ACTION_LITERGEWICHT_CODE),new AuswahlAction(rz,this,ACTION_LITERGEWICHT_CODE,ACTION_LITERGEWICHT_TEXT,0 ,0));
        actionList.put(String.valueOf(ACTION_LEER_CODE),new AuswahlAction(rz,this,ACTION_LEER_CODE,ACTION_LEER_TEXT,0 ,0));
        actionList.put(String.valueOf(ACTION_ADD_CODE),new AuswahlAction(rz,this,ACTION_ADD_CODE,ACTION_ADD_TEXT,KeyEvent.VK_S,KeyEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_DELETE_CODE),new AuswahlAction(rz,this,ACTION_DELETE_CODE,ACTION_DELETE_TEXT,0 ,0));
        actionList.put(String.valueOf(ACTION_PRINT_CODE),new AuswahlAction(rz,this,ACTION_PRINT_CODE,ACTION_PRINT_TEXT,KeyEvent.VK_D ,KeyEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_ZUGANG_CODE),new AuswahlAction(rz,this,ACTION_ZUGANG_CODE,ACTION_ZUGANG_TEXT, KeyEvent.VK_F7,KeyEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_ABGANG_CODE),new AuswahlAction(rz,this,ACTION_ABGANG_CODE,ACTION_ABGANG_TEXT, KeyEvent.VK_F7,KeyEvent.CTRL_DOWN_MASK + KeyEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_MISCHUNG_CODE),new AuswahlAction(rz,this,ACTION_MISCHUNG_CODE,ACTION_MISCHUNG_TEXT,KeyEvent.VK_M,KeyEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_SUCHEN_CODE),new AuswahlAction(rz,this,ACTION_SUCHEN_CODE,ACTION_SUCHEN_TEXT,KeyEvent.VK_F,KeyEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_TANK_CODE),new AuswahlAction(rz,this,ACTION_TANK_CODE,ACTION_TANK_TEXT,KeyEvent.VK_T,KeyEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_SUCHEN_REZEPTUR_CODE),new AuswahlAction(rz,this,ACTION_SUCHEN_REZEPTUR_CODE,ACTION_SUCHEN_REZEPTUR_TEXT,0,0));
        actionList.put(String.valueOf(ACTION_VORGABE_CODE),new AuswahlAction(rz,this,ACTION_VORGABE_CODE,ACTION_VORGABE_TEXT,0,0));    
        actionList.put(String.valueOf(ACTION_EINGABEFELD_CODE),new AuswahlAction(rz,this,ACTION_EINGABEFELD_CODE,ACTION_EINGABEFELD_TEXT,KeyEvent.VK_F2,0));
        actionList.put(String.valueOf(ACTION_CSV_FILE_CODE),new AuswahlAction(rz,this,ACTION_CSV_FILE_CODE,ACTION_CSV_FILE_TEXT, 0 ,0));
        actionList.put(String.valueOf(ACTION_CSV_COPY_CODE),new AuswahlAction(rz,this,ACTION_CSV_COPY_CODE,ACTION_CSV_COPY_TEXT, 0 ,0));
    }

    public void setGUIComponents() {
       setTitle(rz.getVersionString() + " " + rz.getLocale().getString("inventureingabe.titel"));

      mnuDatei.setText(rz.getLocale().getString("menu.datei"));
      mnuExtras.setText(rz.getLocale().getString("menu.extras"));
      mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));
      mnuBearbeiten.setText(rz.getLocale().getString("menu.bearbeiten"));
      
      mnuDatei.add(getAction(ACTION_REFRESH_CODE));
      mnuDatei.add(getAction(ACTION_PRINT_CODE));
      mnuDatei.addSeparator();
	  mnuDatei.add(getAction(ACTION_CSV_FILE_CODE));
	  mnuDatei.add(getAction(ACTION_CSV_COPY_CODE));
	  mnuDatei.addSeparator();
      mnuDatei.add(getAction(ACTION_CLOSE_CODE));
      mnuExtras.add(getAction(ACTION_HIDE_CODE));
      mnuHilfe.add(getAction(ACTION_HILFE_CODE));
      mnuBearbeiten.add(getAction(ACTION_ZUGANG_CODE));
      mnuBearbeiten.add(getAction(ACTION_ABGANG_CODE));
      mnuBearbeiten.add(getAction(ACTION_SUCHEN_CODE));
      mnuBearbeiten.add(getAction(ACTION_SUCHEN_REZEPTUR_CODE));
      mnuBearbeiten.add(getAction(ACTION_VORGABE_CODE));
      mnuBearbeiten.add(getAction(ACTION_EINGABEFELD_CODE));
      mnuBearbeiten.addSeparator();
      mnuBearbeiten.add(getAction(ACTION_MISCHUNG_CODE));
      mnuBearbeiten.add(getAction(ACTION_TANK_CODE));
      

      tb1.add(getAction(ACTION_CLOSE_CODE));
      tb1.add(getAction(ACTION_HIDE_CODE));
      tb1.addSeparator();
      tb1.add(getAction(ACTION_PRINT_CODE));
      tb1.addSeparator();
      tb1.add(getAction(ACTION_ZUGANG_CODE));
      tb1.add(getAction(ACTION_ABGANG_CODE));
      tb1.add(getAction(ACTION_SUCHEN_CODE));
      tb1.add(getAction(ACTION_SUCHEN_REZEPTUR_CODE));
      tb1.add(getAction(ACTION_EINGABEFELD_CODE));
      tb1.addSeparator();
      tb1.add(getAction(ACTION_MISCHUNG_CODE));
      tb1.addSeparator();
      tb1.add(getAction(ACTION_TANK_CODE));
      tb1.addSeparator();
	  tb1.add(getAction(ACTION_CSV_COPY_CODE));
	  tb1.add(getAction(ACTION_CSV_FILE_CODE));
	  tb1.addSeparator();
      tb1.add(getAction(ACTION_HILFE_CODE));

      lblSortOrder.setText(rz.getLocale().getString("inventureingabe.label_sortorder"));
      lblRaeume.setText(rz.getLocale().getString("inventureingabe.label_raeume"));
      lblTanknummer.setText(rz.getLocale().getString("inventureingabe.label_tanknummer"));
      lblInhalt.setText(rz.getLocale().getString("inventureingabe.label_inhalt"));
      btInhalt.setText(rz.getLocale().getString("inventureingabe.label_zutat"));
      lblStaerke.setText(rz.getLocale().getString("inventureingabe.label_staerke"));
      lblBrutto.setText(rz.getLocale().getString("inventureingabe.label_brutto"));
      lblTara.setText(rz.getLocale().getString("inventureingabe.label_tara"));
      lblLitergewicht.setText(rz.getLocale().getString("inventureingabe.label_litergewicht"));
      lblLiter.setText(rz.getLocale().getString("inventureingabe.label_liter"));
      lblTanktemperatur.setText(rz.getLocale().getString("inventureingabe.label_tanktemperatur"));
      lbl0.setText(rz.getLocale().getString("inventureingabe.label_0"));
      lblFormular.setText(rz.getLocale().getString("inventureingabe.label_formular"));
      chkVorschau.setText(rz.getLocale().getString("inventureingabe.label_vorschau"));
      chkPrefix.setText(rz.getLocale().getString("inventureingabe.label_prefix"));
      chkStaerkeAusRezeptur.setText(rz.getLocale().getString("inventureingabe.label_staerke_aus_rezeptur"));
      
      lblLager.setText(rz.getLocale().getString("inventureingabe.label_lager"));
      lblSteuer_Artikel.setText(rz.getLocale().getString("inventureingabe.label_steuer_artikel"));
      lblSorte.setText(rz.getLocale().getString("inventureingabe.label_sorte"));
      lblSteuerlager.setText(rz.getLocale().getString("inventureingabe.label_steuerlager"));
      chkDuplex.setText(rz.getLocale().getString("inventur.duplex"));
      
      btClose.setAction(getAction(ACTION_CLOSE_CODE));
      btHilfe.setAction(getAction(ACTION_HILFE_CODE));
      btRefresh.setAction(getAction(ACTION_REFRESH_CODE));
      btLitergewicht.setAction(getAction(ACTION_LITERGEWICHT_CODE));
      btLeer.setAction(getAction(ACTION_LEER_CODE));
      btAdd.setAction(getAction(ACTION_ADD_CODE));
      btLoeschen.setAction(getAction(ACTION_DELETE_CODE));
      btPrint.setAction(getAction(ACTION_PRINT_CODE));
      btVorgabeSpeichern.setAction(getAction(ACTION_VORGABE_CODE));
	  btCsvFile.setAction(getAction(ACTION_CSV_FILE_CODE));
	  btCsvCopy.setAction(getAction(ACTION_CSV_COPY_CODE));
      
      getAction(ACTION_DELETE_CODE).setEnabled(false);
      getAction(ACTION_ZUGANG_CODE).setEnabled(false);
      getAction(ACTION_ABGANG_CODE).setEnabled(false);
      getAction(ACTION_MISCHUNG_CODE).setEnabled(false);
      getAction(ACTION_SUCHEN_CODE).setEnabled(false);
      getAction(ACTION_SUCHEN_REZEPTUR_CODE).setEnabled(false);
      getAction(ACTION_VORGABE_CODE).setEnabled(false);
      getAction(ACTION_EINGABEFELD_CODE).setEnabled(true);

      chkPrefix.setSelected(rz.getOptionFactory().getOption("inventureingabe.prefix",0)==0?false:true);
      chkStaerkeAusRezeptur.setSelected(rz.getOptionFactory().getOption("inventureingabe.staerke_aus_rezeptur",1)==1?true:false);
      
      setResizable(true);
      rz.getFontFactory().setFrameFonts(this);
      pack();
      rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;
    }

    public void getMessage(MessageItem msg) {
        switch(msg.getMsgCode()) {
	    	case MessageItem.MSG_ACTIONPERFORMED:
	            switch(msg.getCode()){
	            	case ACTION_CLOSE_CODE : closeAction();break;
	            	case ACTION_HILFE_CODE: hilfeAction();break;
	            	case ACTION_HIDE_CODE:hideAction();break;
	            	case ACTION_REFRESH_CODE:refreshAction();break;
	            	case ACTION_LITERGEWICHT_CODE:litergewichtAction();break;
	            	case ACTION_LEER_CODE:leerAction();break;
	            	case ACTION_ADD_CODE:addAction();break;
	            	case ACTION_DELETE_CODE:deleteAction();break;
	            	case ACTION_PRINT_CODE:druckenAction();break;
	            	case ACTION_ZUGANG_CODE:zugangAction();break;
	            	case ACTION_ABGANG_CODE:abgangAction();break;
	            	case ACTION_SUCHEN_CODE:suchenAction();break;
	            	case ACTION_SUCHEN_REZEPTUR_CODE:suchenRezepturAction();break;
	            	case ACTION_MISCHUNG_CODE:mischungAction();break;
	            	case ACTION_TANK_CODE:tankAction();break;
	            	case ACTION_VORGABE_CODE:vorgabeAction();break;
	                case ACTION_CSV_FILE_CODE:csvFileExportAction();break;
	                case ACTION_CSV_COPY_CODE:csvCopyExportAction();break;
	            	case ACTION_EINGABEFELD_CODE:
	            		System.out.println(">>>>req");
	            		txtFilter.requestFocus();
	            		break;
	            default :
	                break;
           }
	    	break;
       	 	case MessageItem.MSG_ZUTATEN_DIALOG_REPLY:
   	 			zutatenDialogReply((ZutatenSuchItem)msg.getData());
   	 			break;
	       case MessageItem.MSG_SHOW_INVENTUREINGABE:
   				origin = (JRzFrame)msg.getOrigin();
	    	   ii = (InventurItem)msg.getData();
	    	   lblBezeichnung.setText("<html><b>" + ii.getBezeichnung() + "</b></html>");
	  		   settblBuchungenModel(tblListe);
	    	   try {
	    		   zeilen = rz.getDatabase().getInventur().getZeilenListe(ii,((SortOrderItem)cmbSortOrder.getSelectedItem()).getSql());
	    	   } catch (final Exception e) {
	    		   zeilen = new InventurZeilenliste();
	    	   }
	    	   rz.getDatabase().getInventur().setRaumlisteCombo(ii,cmbRaumliste);
	    	   ivd = new InventurDetail(rz,zeilen);
	    	   break;
	       default:
	            rz.getLogFactory().logMessage(2, "inventureingabe:", "auswahlAction:" + msg.getMsgCode());
           break;
        }
    }

    private void csvFileExportAction() {
    	rz.getCSVExport().inventurCSV(zeilen,this.cmbSortOrder.getSelectedItem().toString(),this.txtFilter.getText().trim(),CSVExport.EXPORT_FILE);
    }
    
    private void csvCopyExportAction () {
       	rz.getCSVExport().inventurCSV(zeilen,this.cmbSortOrder.getSelectedItem().toString(),this.txtFilter.getText().trim(),CSVExport.EXPORT_COPY);
    }
    
    
    /**
     * detail
     * 
     */
    private void setDetail() {
    	String s = "<html><center>";
    	inventurDetailItem di=null;
    	if(ivd != null) {
    		if(tblListe.getSelectedRow() != -1) {
		    	InventurZeilenItem iz = zeilen.getItem(tblListe.getSelectedRow());
		    	if(iz != null) {
		        	//Bezeichnung
		    		di= ivd.getBezeichnung(iz.getInhalt());
		    		if(di != null) {
		    			s +="<b>" + iz.getInhalt() + "</b> (" + di.getCount()+") "+ 
		    				rz.getLocale().formatNumber(di.getLiter(),OptionFactory.NF_ONE) + " " + rz.getLocale().getString("string_liter") + ", " +
		    				rz.getLocale().formatNumber(di.getLa(),OptionFactory.NF_ONE) + " " + rz.getLocale().getString("string_la");   					
		    		}
		    		//Raum
		    		di= ivd.getRaum(iz.getRaumText());
		    		if(di != null) {
		    			s +=" :: <b>" +rz.getLocale().getString("inventureingabe.label_raum") + iz.getRaumText() + "</b> (" + di.getCount()+") "+ 
		    				rz.getLocale().formatNumber(di.getLiter(),OptionFactory.NF_ONE) + " " + rz.getLocale().getString("string_liter") + ", " +
		    				rz.getLocale().formatNumber(di.getLa(),OptionFactory.NF_ONE) + " " + rz.getLocale().getString("string_la");   					
		    		}
		    		//Sorte
		    		di = ivd.getSorte(iz.getStrSorte());
		    		if(di != null) {
		    			s += " :: <b>" + rz.getLocale().getString("inventureingabe.label_sorte") + iz.getStrSorte()+"</b> (" + di.getCount()+") "+ 
		    				rz.getLocale().formatNumber(di.getLiter(),OptionFactory.NF_ONE) + " " + rz.getLocale().getString("string_liter") + ", " +
		    				rz.getLocale().formatNumber(di.getLa(),OptionFactory.NF_ONE) + " " + rz.getLocale().getString("string_la");   					
		    		}
		    		
		    		//Artikel
		    		di = ivd.getArtikel(iz.getSteuer_artikel());
		    		if(di != null) {
		    			s += " :: <b>" + rz.getLocale().getString("inventureingabe.label_artikel") + (iz.getSteuer_artikel().equals("")?"---": iz.getSteuer_artikel()) +"</b> (" + di.getCount()+") "+ 
		    				rz.getLocale().formatNumber(di.getLiter(),OptionFactory.NF_ONE) + " " + rz.getLocale().getString("string_liter") + ", " +
		    				rz.getLocale().formatNumber(di.getLa(),OptionFactory.NF_ONE) + " " + rz.getLocale().getString("string_la");   					
		    		}
		    		//steuerlagerr
		    		di = ivd.getSteuerlager(iz.getSteuerlager());
		    		if(di != null) {
		    			s += " :: <b>" + rz.getLocale().getString("inventureingabe.label_steuerlager") + iz.getStrSteuerlager()+"</b> (" + di.getCount()+") "+ 
		    				rz.getLocale().formatNumber(di.getLiter(),OptionFactory.NF_ONE) + " " + rz.getLocale().getString("string_liter") + ", " +
		    				rz.getLocale().formatNumber(di.getLa(),OptionFactory.NF_ONE) + " " + rz.getLocale().getString("string_la");   					
		    		}
		    		//lager
		    		di = ivd.getLager(iz.getLager());
		    		if(di != null) {
		    			s += " :: <b>" + rz.getLocale().getString("inventureingabe.label_lager") + iz.getStrLager()+"</b> (" + di.getCount()+") "+ 
		    				rz.getLocale().formatNumber(di.getLiter(),OptionFactory.NF_ONE) + " " + rz.getLocale().getString("string_liter") + ", " +
		    				rz.getLocale().formatNumber(di.getLa(),OptionFactory.NF_ONE) + " " + rz.getLocale().getString("string_la");   					
		    		}
		    		
		    	}
    		}
    	}
    	lblDetail.setText(s + "</center></html>");
    }
    
    /**
     * als vorgabe speichern
     */
    private void vorgabeAction() {
		DialogItem di = null;    	
    	if(rezeptur != 0) {
			try {
				di = new DialogItem(
				        DialogControl.FRAGE_DIALOG,
				        "",0.0,
				        rz.getLocale().getString("herstellungbearbeiten.question_save"),
				        rz.getLocale().getString("herstellungbearbeiten.question_save"),
				        rz.getLocale().getString("herstellungbearbeiten.question_save_message")
				       		.replaceAll("%r",rz.getDatabase().getRezeptur().dbGetRezepturName(rezeptur))
				       		.replaceAll("%a", txtSteuerArtikel.getText().trim())
				       		.replaceAll("%s", ((SortenItem)cmbSorte.getSelectedItem()).getBezeichnung())
				       		.replaceAll("%l", ((SteuerLagerItem)cmbSteuerlager.getSelectedItem()).getBezeichnung()),
				        "frage.png",
				        rz.getLocale().getString("string_ja"),
				        rz.getLocale().getString("string_nein"),
				        this
				);
			} catch (ItemNotFoundException e) {
				e.printStackTrace();
			}
			if(di != null) {
            rz.getDialogFactory().getDialog(di);
	            if ((di.getReplyCode() == DialogControl.DIALOG_YES) || (di.getReplyCode() == DialogControl.DIALOG_OK)){
	           	 ChangesListe cl = new ChangesListe(rz,rezeptur);
	           	 if(cl != null){
	           		 rz.getDatabase().getRezeptur().updateSteuerDaten(rezeptur,txtSteuerArtikel.getText().trim(),((SortenItem)cmbSorte.getSelectedItem()).getId(),((SteuerLagerItem)cmbSteuerlager.getSelectedItem()).getId());
	           		 cl.commit();
	           		 ((AbstractTableModel)tblListe.getModel()).fireTableDataChanged();
	           		 this.toFront();
	           	 }
	            } 
			}
    	}
    }
    /**
     * ;tank
     */
    private void tankAction() {
		if(tblListe.getSelectedRow() != -1) {
			final InventurZeilenItem zi = zeilen.getItem(tblListe.getSelectedRow());
			if(zi !=null && !zi.getTanknummer().trim().equals("")) {
				tankItem ti = rz.getDatabase().getTank().getTank(zi.getTanknummer().trim());
				if (ti != null) {
					rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_TANKLISTE, true, new MessageItem(MessageItem.MSG_SHOW_TANKLISTE,0,ti.getNummer(),this));
				}
			}
		}
	}
    
    /**
     * ;Mischung
     */
    private void mischungAction() {
		if(tblListe.getSelectedRow() != -1) {
			final InventurZeilenItem zi = zeilen.getItem(tblListe.getSelectedRow());
			if(zi !=null && !zi.getTanknummer().trim().equals("")) {
			    MischungsHeaderItem mhi = rz.getDatabase().getMischungen().getMischungHeader(rz.getDatabase().getMischungen().getTankMischung(zi.getTanknummer().trim())); 
				if(mhi != null) {
					rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_MISCHUNG, false, new MessageItem(MessageItem.MSG_SHOW_MISCHUNGSFENSTER,mhi.getId(),null,this));
				}
			}
		}
	}
    /**
     * zugang
     */
    private void zugangAction() {
    		if(tblListe.getSelectedRow() != -1) {
    			final InventurZeilenItem zi = zeilen.getItem(tblListe.getSelectedRow());
    			if(zi != null) {
    		        final ErgebnisItem ei = new ErgebnisItem(rz,zi.getDbkey());
    			    rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_ZUGANG,false,new MessageItem(MessageItem.MSG_SHOW_ZUGANG,ei.getID(),null,this));
    			}
    		}
    }

    /**
     * zugang
     */
    private void abgangAction() {
    		if(tblListe.getSelectedRow() != -1) {
    			final InventurZeilenItem zi = zeilen.getItem(tblListe.getSelectedRow());
    			if(zi != null) {
    		        final ErgebnisItem ei = new ErgebnisItem(rz,zi.getDbkey());
    			    rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_ABGANG,false,new MessageItem(MessageItem.MSG_SHOW_ABGANG,ei.getID(),null,this));
    			}
    		}
    }
    
    /**
     * suchen
     */
    private void suchenAction() {
    		if(tblListe.getSelectedRow() != -1) {
    			final InventurZeilenItem zi = zeilen.getItem(tblListe.getSelectedRow());
    			if(zi != null) {
    				final AbfrageItem ai = new AbfrageItem();
    				ai.setID(0);
					ai.setAdressListe(new StichwortListe());
					ai.setStichwortListe(new StichwortListe());
					ai.setTyp(de.lunqual.rzpro.database.DBAbfrage.ABFRAGE_TYP_SQL);
					ai.setMuster(rz.getDatabase().getErgebnis().getErweitertSQLPrefix() + " rezeptliste.id in (" +String.valueOf( zi.getDbkey()) + ") and rezeptliste.typ=1 group by rezeptliste.id order by name");
					try {
						rz.setWaitCursor(this);
						JRzFrame frame = rz.getFensterFactory().getFensterListe().getAuswahl();
						frame.getMessage(new MessageItem(MessageItem.MSG_ADD_QUERY_REZEPT, ai.getID(), ai,this)); 
						rz.setFreeCursor(this);
					} catch (final Exception e) {}
    			}
    		}
    }
    
    /**
     * suchen Rezeptur
     */
    private void suchenRezepturAction() {
    		if(tblListe.getSelectedRow() != -1) {
    			final InventurZeilenItem zi = zeilen.getItem(tblListe.getSelectedRow());
    			if(zi != null) {
    				txtFilter.setText(zi.getInhalt());
    				cmbSortOrder.setSelectedIndex(3);
    				refreshAction();
    			}
    		}
    }
    
    
	/**
	 * die Inventur ausdrucken
	 */
	private void druckenAction() {
		String art = ((ReportItem)cmbFormular.getSelectedItem()).getName().toLowerCase();
		if(txtFilter.getText().trim().equals("")) {
			if(!zeilen.isEmpty()) {
				if( art.indexOf("inhalt")!=-1) {
					rz.getReportFactory().InventurReport(ii,chkVorschau.isSelected(), "bezeichnung",txtFilter.getText().trim(),this, chkDuplex.isSelected());
				} else  if (art.indexOf("raum") != -1){
					rz.getReportFactory().InventurReport(ii,chkVorschau.isSelected(),"raum",txtFilter.getText().trim(), this, chkDuplex.isSelected());
				}else  if (art.indexOf("sorte") != -1){
					rz.getReportFactory().InventurReport(ii,chkVorschau.isSelected(),"sorte",txtFilter.getText().trim(), this, chkDuplex.isSelected());
				} else  if (art.indexOf("steuerlager") != -1){
					rz.getReportFactory().InventurReport(ii,chkVorschau.isSelected(),"steuerlager",txtFilter.getText().trim(), this, chkDuplex.isSelected());
				}else  if (art.indexOf("artikel") != -1){
					rz.getReportFactory().InventurReport(ii,chkVorschau.isSelected(),"steuer_artikel",txtFilter.getText().trim(), this, chkDuplex.isSelected());
				} else  if (art.indexOf("lager") != -1){
					rz.getReportFactory().InventurReport(ii,chkVorschau.isSelected(),"lager",txtFilter.getText().trim(), this, chkDuplex.isSelected());
				}
			}
		}else {
			if(!zeilen.isEmpty()) {
				if( art.indexOf("inhalt")!=-1) {
					rz.getReportFactory().InventurReport(ii,chkVorschau.isSelected(),((SortOrderItem)cmbSortOrder.getSelectedItem()).getSql(),txtFilter.getText().trim(),this, chkDuplex.isSelected());
				} else if (art.indexOf("raum") != -1){
					rz.getReportFactory().InventurReport(ii,chkVorschau.isSelected(),((SortOrderItem)cmbSortOrder.getSelectedItem()).getSql(),txtFilter.getText().trim(), this, chkDuplex.isSelected());
				}else  if (art.indexOf("sorte") != -1){
					rz.getReportFactory().InventurReport(ii,chkVorschau.isSelected(),((SortOrderItem)cmbSortOrder.getSelectedItem()).getSql(),txtFilter.getText().trim(), this, chkDuplex.isSelected());
				} else  if (art.indexOf("steuerlager") != -1){
					rz.getReportFactory().InventurReport(ii,chkVorschau.isSelected(),((SortOrderItem)cmbSortOrder.getSelectedItem()).getSql(),txtFilter.getText().trim(), this, chkDuplex.isSelected());
				}else  if (art.indexOf("artikel") != -1){
					rz.getReportFactory().InventurReport(ii,chkVorschau.isSelected(),((SortOrderItem)cmbSortOrder.getSelectedItem()).getSql(),txtFilter.getText().trim(), this, chkDuplex.isSelected());
				} else  if (art.indexOf("lager") != -1){
					rz.getReportFactory().InventurReport(ii,chkVorschau.isSelected(),((SortOrderItem)cmbSortOrder.getSelectedItem()).getSql(),txtFilter.getText().trim(), this, chkDuplex.isSelected());
				}
			}
		}
	}

	private void checkTankNummer() {
		final ContainerItem c =  rz.getDatabase().getContainer().getContainerString(txtTanknummer.getText().trim());
		try {
		if(!c.getName().equals("")) {
			txtTara.setValue(c.getTara());
		}
		}catch (final Exception e) {}
	}

	/**
	 * füllt die Eingabefelder mit den Werten aus einem ZeilenElement
	 * @param zi
	 */
	private void fromZi(InventurZeilenItem zi) {
		rezeptur = zi.getDbkey();
    	extrakt = zi.getExtrakt();
    	if(rezeptur != 0) {
        	txtInhalt.setEnabled(false);
            getAction(ACTION_VORGABE_CODE).setEnabled(true);
    	} else {
    		txtInhalt.setEnabled(true);
            getAction(ACTION_VORGABE_CODE).setEnabled(false);
    	}
    	for(int i = 0;i < cmbRaumliste.getModel().getSize();i++) {
    		if(zi.getRaum() == ((RaumItem)cmbRaumliste.getModel().getElementAt(i)).getId()) {
        		cmbRaumliste.setSelectedIndex(i);
        		break;
    		}
    	}
    	txtTanknummer.setText(zi.getTanknummer());
    	txtInhalt.setText(zi.getInhalt());
    	txtStaerke.setValue(zi.getStaerke());
    	if(zi.getTyp() == InventurZeilenItem.TYP_LITER) {
        	txtLiter.setValue(zi.getLiter());
        	txtBrutto.setValue(0.0);
        	txtTara.setValue(0.0);
    	} else {
    		txtLiter.setValue(0.0);
        	txtBrutto.setValue(zi.getBrutto());
        	txtTara.setValue(zi.getTara());
    	}
    	txtTanktemperatur.setValue(zi.getTanktemperatur());
    	txtLitergewicht.setValue(zi.getLitergewicht());
    	txtSteuerArtikel.setText(zi.getSteuer_artikel());
    	cmbLager.setSelectedIndex(0);
    	cmbSorte.setSelectedIndex(0);
    	cmbSteuerlager.setSelectedIndex(0);
    	for(int i=0;i<cmbLager.getModel().getSize();i++) {
			if(zi.getLager() == ((LagerItem)cmbLager.getModel().getElementAt(i)).getID()) {
				cmbLager.setSelectedIndex(i);
				break;
			}
		}
		for(int i=0;i<cmbSorte.getModel().getSize();i++) {
			if(zi.getSorte() == ((SortenItem)cmbSorte.getModel().getElementAt(i)).getId()) {
				cmbSorte.setSelectedIndex(i);
				break;
			}
		}
		for(int i=0;i<cmbSteuerlager.getModel().getSize();i++) {
			if(zi.getSteuerlager() == ((SteuerLagerItem)cmbSteuerlager.getModel().getElementAt(i)).getId()) {
				cmbSteuerlager.setSelectedIndex(i);
				break;
			}
		}
	}

    /**
     * Tabelle SelectionChange
     */
    private void listSelectionEvent() {
		getAction(ACTION_ABGANG_CODE).setEnabled(false);
		getAction(ACTION_ZUGANG_CODE).setEnabled(false);
		getAction(ACTION_MISCHUNG_CODE).setEnabled(false);
		getAction(ACTION_SUCHEN_CODE).setEnabled(false);
		getAction(ACTION_SUCHEN_REZEPTUR_CODE).setEnabled(false);
	    	if(tblListe.getSelectedRow() != -1) {
	        	final InventurZeilenItem zi = zeilen.getItem(tblListe.getSelectedRow());
	        	fromZi(zi);
	        	getAction(ACTION_DELETE_CODE).setEnabled(true);
	        	if(zi.getDbkey() != 0) {
	        		getAction(ACTION_ABGANG_CODE).setEnabled(true);
	        		getAction(ACTION_ZUGANG_CODE).setEnabled(true);
	        		getAction(ACTION_SUCHEN_CODE).setEnabled(true);
	        		getAction(ACTION_SUCHEN_REZEPTUR_CODE).setEnabled(true);
	        	}if(!zi.getTanknummer().equals("")) {
	        		getAction(ACTION_MISCHUNG_CODE).setEnabled(true);
	        	}
		    	setDetail();
	        	cmbRaumliste.requestFocus();
	    	}else {
	    		getAction(ACTION_DELETE_CODE).setEnabled(false);
	    	}
    }
    /**
     * einen Behälter abspeichern
     */
    private void saveZeile(InventurZeilenItem zi) {
    	int selected = this.tblListe.getSelectedRow();
    	zi.setInhalt(txtInhalt.getText().trim());
    	if(rezeptur != 0) {
    		zi.setDbkey(rezeptur);
    		if(extrakt != InventurZeilenItem.ZEILE_EXTRAKTFREI) {
    			zi.setExtrakt(InventurZeilenItem.ZEILE_EXTRAKT);
    		}
    	}else {
    		zi.setDbkey(0);
    	}
    	zi.setRaum(((RaumItem)cmbRaumliste.getSelectedItem()).getId());
    	zi.setRaumText(((RaumItem)cmbRaumliste.getSelectedItem()).getBezeichnung());
    	zi.setTanknummer(txtTanknummer.getText().trim());
    	zi.setStaerke(txtStaerke.getValue());
    	zi.setLitergewicht(txtLitergewicht.getValue());
    	zi.setUebernommen(0);
    	zi.setUser_1(rz.getDatabase().dbGetUser());
    	zi.setSteuer_artikel(txtSteuerArtikel.getText().trim());
    	zi.setLager( ((LagerItem)cmbLager.getSelectedItem()).getID());
    	zi.setStrLager( ((LagerItem)cmbLager.getSelectedItem()).getName());
    	zi.setSorte( ((SortenItem)cmbSorte.getSelectedItem()).getId());
    	zi.setStrSorte(((SortenItem)cmbSorte.getSelectedItem()).getBezeichnung());
    	zi.setSteuerlager( ((SteuerLagerItem)cmbSteuerlager.getSelectedItem()).getId());
    	zi.setStrSteuerlager( ((SteuerLagerItem)cmbSteuerlager.getSelectedItem()).getBezeichnung());
    	switch (zi.getTyp()) {
    		case InventurZeilenItem.TYP_LITER:
    			zi.setLiter(txtLiter.getValue());
    			zi.setTanktemperatur(txtTanktemperatur.getValue());
    			zi.setTafel3(rz.getTafelFactory().Tafel3Tafel(zi.getStaerke(),zi.getTanktemperatur()));
    			zi.setLa(zi.getLiter() * (zi.getTafel3()/1000));
    			if(zi.getStaerke() < RzPro.DOUBLE_NULL) {
    				zi.setLiter20(zi.getLiter());
    				zi.setLa(0);
    			}else {
        			zi.setLiter20((zi.getLa() * 100)/zi.getStaerke());
    			}
    			break;
    		case InventurZeilenItem.TYP_GEWICHT:
    			zi.setBrutto(txtBrutto.getValue());
    			zi.setTara(txtTara.getValue());
    			zi.setTafel2(rz.getTafelFactory().Tafel2Tafel(zi.getStaerke()));
    			zi.setNetto(zi.getBrutto()-zi.getTara());
    			if(zi.getExtrakt() == InventurZeilenItem.ZEILE_EXTRAKT) {
	    			zi.setLiter((1/zi.getLitergewicht()) * zi.getNetto());
	    			zi.setLiter20(zi.getLiter());
	    			zi.setLa(zi.getLiter20() * (zi.getStaerke()/100));
    			} else {
    				zi.setLa(zi.getNetto() * (zi.getTafel2()/1000));
    				if(zi.getStaerke() > 0) {
    					zi.setLiter((zi.getLa()*100)/zi.getStaerke());
    				} else {
    					zi.setLiter(zi.getLitergewicht() * zi.getNetto());
    				}
    				zi.setLiter20(zi.getLiter());
    			}
    			break;
    	}
    	final int tankID = rz.getDatabase().getInventur().checkTankExists(ii.getId(),zi.getTanknummer());
    	if(tankID != 0) {
    		DialogItem di = null;
    		// Update
            di = new DialogItem(
                    DialogControl.FRAGE_DIALOG,
                    "",0.0,
	                  rz.getLocale().getString("inventureingabe.dialog_titel"),
	                  rz.getLocale().getString("inventureingabe.dialog_titel"),
	                  rz.getLocale().getString("inventureingabe.dialog_update").replaceAll("%s",zi.getTanknummer()),
	                  "frage.png",
	                  rz.getLocale().getString("string_ja"),
	                  rz.getLocale().getString("string_nein"),
	                  this
            );
            rz.getDialogFactory().getDialog(di);
            if ((di.getReplyCode() == DialogControl.DIALOG_YES) || (di.getReplyCode() == DialogControl.DIALOG_OK)){
            		int sel=0;
            		zi.setId(tankID);
            		rz.getDatabase().getInventur().saveZeilenItem(zi);
	        		for(int i=0;i < zeilen.size();i++) {
	        			if(zeilen.getItem(i).getId() == tankID) {
	        				zeilen.getItem(i).copyFrom(zi);
	        				sel = i;
	        				break;
	        			}
        		}
        		leerAction();
        		((AbstractTableModel)tblListe.getModel()).fireTableRowsUpdated(sel,sel);
        		tblListe.getSelectionModel().setSelectionInterval(sel,sel);
            } else {
            	cmbRaumliste.requestFocus();
            }
    	} else {
    		// Neueintrag
        	final int insertID = rz.getDatabase().getInventur().saveZeilenItem(zi);
        	if(insertID != 0) {
        		if(zeilen != null) {
        			zeilen.addItem(zi);
        		      ((AbstractTableModel)tblListe.getModel()).fireTableRowsInserted(zeilen.size(),zeilen.size());
        			leerAction();
        		}
        	}
    	}
    	ivd = new InventurDetail(rz,zeilen);
    	setDetail();
    	if(selected != -1) {
    		try {
    			tblListe.setRowSelectionInterval(selected,selected);
    		} catch (Exception e) {}
    		
    	}
    }
    /**
     * einen Behälter hinzufügen
     */
    private void addAction() {
    	final int insertID = 0;
    	final InventurZeilenItem iz = new InventurZeilenItem(rz,ii.getId());
    	if (minimumRequiredFields()) {
	    	final int t = determineTyp();
	    	if(t != InventurZeilenItem.TYP_INVALID) {
		    	if(insertID != 0) {
		    		leerAction();
		    	} else {
		    		iz.setTyp(t);
		    		saveZeile(iz);
		    	}
	    		si.setSummeLa(si.getSummeLa() + iz.getLa());
	    		si.setSummeLiter20(si.getSummeLiter20() + iz.getLiter20());
	        	ivd = new InventurDetail(rz,zeilen);
	        	setDetail();
	    		showSumme();
	    		this.tblListe.scrollRectToVisible(tblListe.getCellRect(zeilen.size(), 0,true));
	    	}
    	}
    }

    /**
     * ist mindestens Tanknummer und Bezeichnung ausgefüllt ?
     */
    private boolean minimumRequiredFields() {
    	if(txtTanknummer.getText().trim().equals("")  ||  txtInhalt.getText().trim().equals("")){
			  final DialogItem di  = new DialogItem(
	                  DialogControl.HINWEIS_DIALOG,
	                  "",0.0,
	                  rz.getLocale().getString("inventureingabe.dialog_titel"),
	                  rz.getLocale().getString("inventureingabe.dialog_titel"),
	                  rz.getLocale().getString("inventureingabe.dialog_not_minimum"),
	                  "warnung.png",
	                  rz.getLocale().getString("string_ok"),
	                  "",
	                  this
	          );
	          rz.getDialogFactory().getDialog(di);
	          txtTanknummer.requestFocus();
    		return false;
    	} else {
    		return true;
    	}

    }
    /**
     * ermittelt den Typ des Behälters (Liter oder Gewicht)
     */
    private int determineTyp() {
    	int ret = InventurZeilenItem.TYP_INVALID;
    	// auf leeren Behälter prüfen
    	if(!txtTanknummer.getText().trim().equals("") && (txtLiter.getValue()<=RzPro.DOUBLE_NULL) && (txtBrutto.getValue()<=RzPro.DOUBLE_NULL)) {
    		ret = InventurZeilenItem.TYP_LEER;
    	} else {
	    	// prüfen, ob das Liter-feld ausgefüllt ist
	    	if((txtLiter.getValue() != 0.0) && (txtBrutto.getValue() <= RzPro.DOUBLE_NULL)) {
	    		ret = InventurZeilenItem.TYP_LITER;
	    		txtBrutto.setValue(0.0);
	    		txtTara.setValue(0.0);
	    	} else {
	    		if((txtBrutto.getValue() > 0.0) && (txtLitergewicht.getValue() > 0.0) && (txtLiter.getValue() < RzPro.DOUBLE_NULL))  {
	    			if(txtBrutto.getValue() > txtTara.getValue()) {
	        			ret = InventurZeilenItem.TYP_GEWICHT;
	    			} else {
	    	  			  final DialogItem di  = new DialogItem(
	    		                  DialogControl.HINWEIS_DIALOG,
	    		                  "",0.0,
	    		                  rz.getLocale().getString("inventureingabe.dialog_titel"),
	    		                  rz.getLocale().getString("inventureingabe.dialog_titel"),
	    		                  rz.getLocale().getString("inventureingabe.dialog_brutto_tara"),
	    		                  "warnung.png",
	    		                  rz.getLocale().getString("string_ok"),
	    		                  "",
	    		                  this
	    		          );
	    		          rz.getDialogFactory().getDialog(di);
	    		          txtBrutto.requestFocus();
	    			}
	    		} else {
	  			  final DialogItem di  = new DialogItem(
		                  DialogControl.HINWEIS_DIALOG,
		                  "",0.0,
		                  rz.getLocale().getString("inventureingabe.dialog_titel"),
		                  rz.getLocale().getString("inventureingabe.dialog_titel"),
		                  rz.getLocale().getString("inventureingabe.dialog_not_determined"),
		                  "warnung.png",
		                  rz.getLocale().getString("string_ok"),
		                  "",
		                  this
		          );
		          rz.getDialogFactory().getDialog(di);
		          txtLiter.requestFocus();
	    		}
	    	}
    	}
    	return ret;
    }
    /**
     * einen Behälter löschen
     */
    private void deleteAction() {
    	if(tblListe.getSelectedRow() != -1) {
    		final InventurZeilenItem iz = zeilen.getItem(tblListe.getSelectedRow());
    		boolean do_it = false;
			DialogItem di = null;
				di= new DialogItem(
                    DialogControl.FRAGE_DIALOG,
                    "",0.0,
                    rz.getLocale().getString("inventureingabe.question_delete"),
                    rz.getLocale().getString("inventureingabe.question_delete"),
                    rz.getLocale().getString("inventureingabe.question_delete_message")
                    	.replaceAll("%s",iz.getTanknummer())
                    	.replaceAll("%n",iz.getInhalt()),
                    "frage.png",
                    rz.getLocale().getString("string_ja"),
                    rz.getLocale().getString("string_nein"),
                    null
            );
            rz.getDialogFactory().getDialog(di);
            if ((di.getReplyCode() == DialogControl.DIALOG_YES) || (di.getReplyCode() == DialogControl.DIALOG_OK)){
            	do_it = true;
            } else {
            	do_it = false;
            }
            if(do_it) {
            	if(!rz.getDatabase().getInventur().deleteZeilenItem(iz.getId())){
  	  			  di  = new DialogItem(
		                  DialogControl.HINWEIS_DIALOG,
		                  "",0.0,
		                  rz.getLocale().getString("inventureingabe.dialog_titel"),
		                  rz.getLocale().getString("inventureingabe.dialog_titel"),
		                  rz.getLocale().getString("inventureingabe.dialog_zeile_not_found")
		                  	.replaceAll("%s",iz.getTanknummer())
		                  	.replaceAll("%n",iz.getInhalt()),
		                  "warnung.png",
		                  rz.getLocale().getString("string_ok"),
		                  "",
		                  this
		          );
		          rz.getDialogFactory().getDialog(di);
            	}
            	rz.getDatabase().getInventur().getInventurSumme(ii.getId(),si);
            	si.setSummeLa(si.getSummeLa()-iz.getLa());
            	si.setSummeLiter20(si.getSummeLiter20()-iz.getLiter20());
            	zeilen.remove(iz);
            	updateTable();
            }
		}
    }
    /**
     * Alle Felder zurücksetzen
     */
    private void leerAction() {
    	updateTable();
    	this.getSummeFromDB();
    	rezeptur =0;
    	extrakt = InventurZeilenItem.ZEILE_EXTRAKTFREI;
    	txtTanknummer.setText("");
    	txtInhalt.setEnabled(true);
    	txtInhalt.setText("");
    	txtStaerke.setValue(0);
    	txtLiter.setValue(0);
    	txtTanktemperatur.setValue(20.0);
    	txtBrutto.setValue(0);
    	txtTara.setValue(0);
    	txtLitergewicht.setValue(rz.getTafelFactory().Litergewicht(0));
    	txtSteuerArtikel.setText("");
    	rz.getDatabase().getLager().setLagerIndex(cmbLager, 1);
    	rz.getDatabase().getMischungen().setSortenIndex(cmbSorte, 1);
    	rz.getDatabase().getRezeptur().setSteuerlagerIndex(cmbSteuerlager, 1);
    	getAction(ACTION_VORGABE_CODE).setEnabled(false);

    	txtTanknummer.requestFocus();
    }
    /**
     * Litergewicht berechnen
     */
    private void litergewichtAction() {
    	txtLitergewicht.setValue(rz.getTafelFactory().LitergewichtTafel(txtStaerke.getValue()));
    }
    /**
     * Zutatendialog anzeigen
     */
	/** zeigt den Dialog mit einzufügenden Zutaten an
	 *
	 *
	 */
	private void showZutatenDialog(String aZutat){
		int x, y;
		x = (int) (btInhalt.getLocationOnScreen().getX() );
		y = (int) (btInhalt.getLocationOnScreen().getY() );
		if(zd != null) {
			zd.dispose();
			zd = null;
		}
		zd = new ZutatenDialog(this, rz, x, y,aZutat,ZutatenDialog.MODE_REZEPTUREN);
		zd.setPrefix(chkPrefix.isSelected());
		zd.setVisible(true);
	}
    /** ZutatenDialog-Antwort
     *
     */
	private void zutatenDialogReply(ZutatenSuchItem zi) {
		boolean setRezeptur=false;
		if(zi != null) {
			if(zi.getID()!=0) {
				setRezeptur = true;
			}
		}
	    getAction(ACTION_VORGABE_CODE).setEnabled(false);
		if(setRezeptur) {
	    	getAction(ACTION_VORGABE_CODE).setEnabled(true);
			rezeptur = zi.getID();
			txtInhalt.setText(zi.getName());
			if(chkStaerkeAusRezeptur.isSelected()){
				txtStaerke.setValue(zi.getStaerke());
			} 
			txtLitergewicht.setValue(zi.getExtrakt() > 0.0?zi.getLitergewicht():rz.getTafelFactory().Litergewicht(zi.getStaerke()));
			txtInhalt.setEnabled(false);
			if(zi.getExtrakt() != 0.0) {
				extrakt = InventurZeilenItem.ZEILE_EXTRAKT;
			} else {
				extrakt = InventurZeilenItem.ZEILE_EXTRAKTFREI;
			}

			SteuerDatenItem st = rz.getDatabase().getRezeptur().getSteuerDaten(rezeptur);
			if(st != null) {
				this.txtSteuerArtikel.setText(st.getSteuer_artikel());
				for(int i=0;i<cmbLager.getModel().getSize();i++) {
					if(st.getLager() == ((LagerItem)cmbLager.getModel().getElementAt(i)).getID()) {
						cmbLager.setSelectedIndex(i);
						break;
					}
				}
				for(int i=0;i<cmbSorte.getModel().getSize();i++) {
					if(st.getSorte() == ((SortenItem)cmbSorte.getModel().getElementAt(i)).getId()) {
						cmbSorte.setSelectedIndex(i);
						break;
					}
				}
				for(int i=0;i<cmbSteuerlager.getModel().getSize();i++) {
					if(st.getSteuerlager() == ((SteuerLagerItem)cmbSteuerlager.getModel().getElementAt(i)).getId()) {
						cmbSteuerlager.setSelectedIndex(i);
						break;
					}
				}
			}
			txtStaerke.requestFocus();
		} else {
			rezeptur=0;
			extrakt = InventurZeilenItem.ZEILE_EXTRAKTFREI;
			txtInhalt.setEnabled(true);
			txtInhalt.setText("");
			txtInhalt.requestFocus();
		    getAction(ACTION_VORGABE_CODE).setEnabled(false);
			
		}
	}
    /**
     * Liste neu einlesen
     */
    private void refreshAction() {
    	rz.getDatabase().getInventur().setRaumlisteCombo(ii,cmbRaumliste);
    	if(txtFilter.getText().trim().equals("")) {
    		zeilen = rz.getDatabase().getInventur().getZeilenListe(ii,((SortOrderItem)cmbSortOrder.getSelectedItem()).getSql());
    	} else {
    		zeilen = rz.getDatabase().getInventur().getZeilenListe(ii,((SortOrderItem)cmbSortOrder.getSelectedItem()).getSql(),txtFilter.getText().trim());
    	}
    	getSummeFromDB();
    	showSumme();
    	updateTable();
    }

    private void updateTable() {
    	int selected = tblListe.getSelectedRow();
        ((AbstractTableModel)tblListe.getModel()).fireTableDataChanged();
    	try {
        if(selected != -1) {
        		tblListe.scrollRectToVisible(tblListe.getCellRect(selected, 1,true));
        		tblListe.setRowSelectionInterval(selected, selected);
        	} else {
        		tblListe.scrollRectToVisible(tblListe.getCellRect(tblListe.getRowCount()+10, 1,true));
        		tblListe.setRowSelectionInterval(tblListe.getRowCount(),tblListe.getRowCount());
        	}
    	}catch(Exception e) {}
    	
    	ivd = new InventurDetail(rz,zeilen);
    	setDetail();
        showSumme();
    }

    /**
     * Summe darstellen
     */
    private void showSumme(){
    	double sl = 0.0,sla=0.0;
    	for(int i = 0;i < zeilen.size();i++) {
    		sl += zeilen.getItem(i).getLiter20();
    		sla += zeilen.getItem(i).getLa();
    	}
        lblSumme.setText(rz.getLocale().getString("inventureingabe.label_summe")
            	.replaceAll("%s",rz.getLocale().formatNumber(si.getSummeLiter20(),OptionFactory.NF_INVENTUR))
            	.replaceAll("%n",rz.getLocale().formatNumber(si.getSummeLa(),OptionFactory.NF_INVENTUR))
            );
        lblSumme1.setText(rz.getLocale().getString("inventureingabe.label_summe1")
            	.replaceAll("%s",rz.getLocale().formatNumber(sl,OptionFactory.NF_INVENTUR))
            	.replaceAll("%n",rz.getLocale().formatNumber(sla,OptionFactory.NF_INVENTUR))
            );
    }
    /**
     * Summe aus der Datenbank holen
     */
    private void getSummeFromDB() {
        rz.getDatabase().getInventur().getInventurSumme(ii.getId(),si);
        showSumme();
    }
    /**
     * speichern
     */
    private void speichernAction() {
    	rz.getDatabase().getInventur().saveInventur(ii);
    	try {
    		origin.getMessage(new MessageItem(MessageItem.MSG_INVENTUR_REFRESH,0,ii,this ));
    	}catch (final Exception e) {}
    }
   /**
    */
    private void closeAction() {
    	closeWindow();
    }

    private void hideAction() {
        rz.getFensterFactory().getFensterListe().sperren(this);
    }

    private void hilfeAction() {
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"inventurbehaelter.html",this));
    }

    public void openWindow(){
    	if (ii != null) {
    	    final int v = rz.getOptionFactory().getOption("inventureingabe.vorschau",1);
    	    if(v == 1){
    	        chkVorschau.setSelected(true);
    	    } else {
    	       chkVorschau.setSelected(false);
    	    }
    		leerAction();
    		if(!isVisible()) {
				setVisible(true);
			}
    		toFront();
    		btLeer.requestFocus();
    	} else {
    		closeWindow();
    	}

    }
    public void closeWindow(){
	    if(chkVorschau.isSelected()) {
	        rz.getOptionFactory().setOption("inventureingabe.vorschau", 1);
	    } else {
	        rz.getOptionFactory().setOption("inventureingabe.vorschau", 0);
	    }
	    rz.getOptionFactory().saveOptions();
    	rz.getOptionFactory().setOption("inventureingabe.sortorder",cmbSortOrder.getSelectedIndex());
    	rz.getOptionFactory().setOption("inventureingabe.cmb_raumliste",cmbRaumliste.getSelectedIndex());
    	rz.getOptionFactory().saveOptions();
    	speichernAction();
        rz.getFensterFactory().getFensterListe().disposeFrame(this);
    }


    /*
     * Inventur TableModel
     * @author labor
     *
     */

    private void settblBuchungenModel(JTable t) {
	    final InventurColumnModel rcm = new InventurColumnModel();
	    final NumericRenderer nr = new NumericRenderer();
	    final StringRenderer sr = new StringRenderer();
	    TableColumn tc = new TableColumn();
	    tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("inventureingabe.tableheader_datum"));
	    	tc.setModelIndex(C_DATUM);
	    	tc.setCellRenderer(sr);
	    rcm.addColumn(tc);
	    tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("inventureingabe.tableheader_typ"));
	    	tc.setModelIndex(C_TYP);
	    	tc.setCellRenderer(sr);
	    rcm.addColumn(tc);
	    tc = new TableColumn();
    		tc.setHeaderValue(rz.getLocale().getString("inventureingabe.tableheader_raum"));
    		tc.setModelIndex(C_RAUM);
    		tc.setCellRenderer(sr);
    	rcm.addColumn(tc);
	    tc = new TableColumn();
    		tc.setHeaderValue(rz.getLocale().getString("inventureingabe.tableheader_tank"));
    		tc.setModelIndex(C_TANK);
    		tc.setCellRenderer(sr);
        rcm.addColumn(tc);
	    tc = new TableColumn();
    		tc.setHeaderValue(rz.getLocale().getString("inventureingabe.tableheader_inhalt"));
    		tc.setModelIndex(C_INHALT);
    		tc.setCellRenderer(sr);
    	rcm.addColumn(tc);
	    tc = new TableColumn();
    	tc.setHeaderValue(rz.getLocale().getString("inventureingabe.tableheader_staerke"));
    		tc.setModelIndex(C_STAERKE);
    		tc.setCellRenderer(nr);
    	rcm.addColumn(tc);
	    tc = new TableColumn();
    		tc.setHeaderValue(rz.getLocale().getString("inventureingabe.tableheader_liter20"));
    		tc.setModelIndex(C_LITER20);
    		tc.setCellRenderer(nr);
    	rcm.addColumn(tc);
	    tc = new TableColumn();
    		tc.setHeaderValue(rz.getLocale().getString("inventureingabe.tableheader_la"));
    		tc.setModelIndex(C_LA);
    		tc.setCellRenderer(nr);
   		rcm.addColumn(tc);
	    tc = new TableColumn();
		tc.setHeaderValue(rz.getLocale().getString("inventureingabe.tableheader_liter"));
			tc.setModelIndex(C_LITER);
			tc.setCellRenderer(nr);
		rcm.addColumn(tc);
	    tc = new TableColumn();
		tc.setHeaderValue(rz.getLocale().getString("inventureingabe.tableheader_tt"));
			tc.setModelIndex(C_TT);
			tc.setCellRenderer(nr);
	    rcm.addColumn(tc);
	    tc = new TableColumn();
		tc.setHeaderValue(rz.getLocale().getString("inventureingabe.tableheader_tafel3"));
			tc.setModelIndex(C_TAFEL3);
			tc.setCellRenderer(nr);
		rcm.addColumn(tc);
	    tc = new TableColumn();
		tc.setHeaderValue(rz.getLocale().getString("inventureingabe.tableheader_brutto"));
			tc.setModelIndex(C_BRUTTO);
			tc.setCellRenderer(nr);
		rcm.addColumn(tc);
	    tc = new TableColumn();
		tc.setHeaderValue(rz.getLocale().getString("inventureingabe.tableheader_tara"));
			tc.setModelIndex(C_TARA);
			tc.setCellRenderer(nr);
		rcm.addColumn(tc);
	    tc = new TableColumn();
		tc.setHeaderValue(rz.getLocale().getString("inventureingabe.tableheader_netto"));
			tc.setModelIndex(C_NETTO);
			tc.setCellRenderer(nr);
		rcm.addColumn(tc);
	    tc = new TableColumn();
		tc.setHeaderValue(rz.getLocale().getString("inventureingabe.tableheader_extrakt"));
			tc.setModelIndex(C_EXTRAKT);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
	    tc = new TableColumn();
		tc.setHeaderValue(rz.getLocale().getString("inventureingabe.tableheader_tafel2"));
			tc.setModelIndex(C_TAFEL2);
			tc.setCellRenderer(nr);
		rcm.addColumn(tc);
	    tc = new TableColumn();
		tc.setHeaderValue(rz.getLocale().getString("inventureingabe.tableheader_litergewicht"));
			tc.setModelIndex(C_LITERGEWICHT);
			tc.setCellRenderer(nr);
		rcm.addColumn(tc);
	    tc = new TableColumn();
		tc.setHeaderValue(rz.getLocale().getString("inventureingabe.tableheader_user"));
			tc.setModelIndex(C_USER);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);		
	    tc = new TableColumn();
		tc.setHeaderValue(rz.getLocale().getString("inventureingabe.tableheader_lager"));
			tc.setModelIndex(C_LAGER);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);	
	    tc = new TableColumn();
		tc.setHeaderValue(rz.getLocale().getString("inventureingabe.tableheader_steuer_artikel"));
			tc.setModelIndex(C_STEUER_ARTIKEL);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);	
	    tc = new TableColumn();
		tc.setHeaderValue(rz.getLocale().getString("inventureingabe.tableheader_sorte"));
			tc.setModelIndex(C_SORTE);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);	
	    tc = new TableColumn();
		tc.setHeaderValue(rz.getLocale().getString("inventureingabe.tableheader_steuerlager"));
			tc.setModelIndex(C_STEUERLAGER);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);	
        rcm.addColumnModelListener(this);
        tblListe.setModel(new InventurTableModel());
        tblListe.setColumnModel(rcm);
        tblListe.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
        tblListe.getTableHeader().setReorderingAllowed(false);
	}

	private class InventurColumnModel extends DefaultTableColumnModel{
	    public InventurColumnModel() {
	        super();
	    }

	}

	private  class InventurTableModel extends AbstractTableModel    {

	        SimpleDateFormat df;

	        public InventurTableModel() {
	        	df = new SimpleDateFormat("dd.MM.yyyy H:mm");
	        }

		   public int getColumnCount() {
		       	return MAX_COLUMN;
	        }
	        public int getRowCount() {
	        	if(zeilen != null) {
	                return zeilen.size();
	        	} else {
	        		return 0;
	        	}
	        }

	        public InventurZeilenItem getZeileAt(int rowIndex) {
	        	if((rowIndex != -1) && (zeilen != null)) {
	        		return zeilen.getItem(rowIndex);
	        	} else {
					return null;
				}
	        }

	        public Object getValueAt(int rowIndex, int columnIndex) {
	            Object ret = null;
	            if((rowIndex != -1) && (zeilen != null)) {
	                ret = getContent(zeilen.getItem(rowIndex),columnIndex);
	            }
	            return ret;
	        }

	        private Object getContent(InventurZeilenItem zi,int aColumn) {
	            Object ret = null;
	            if(zi != null) {
		            switch(aColumn){
		            	case C_DATUM:	ret = df.format(zi.getErstellt());
		            		break;
		            	case C_TYP:
		            		if(zi.getTyp() == InventurZeilenItem.TYP_LITER) {
		            			ret = rz.getLocale().getString("inventureingabe.table_typ_liter");
		            		} else {
		            			ret = rz.getLocale().getString("inventureingabe.table_typ_gewicht");
		            		}
		            		break;
		            	case C_RAUM: ret = zi.getRaumText();
		            		break;
		            	case C_TANK: ret = zi.getTanknummer();
		            		break;
		            	case C_INHALT: ret = zi.getInhalt();
		            		break;
		            	case C_STAERKE:
		            		ret = rz.getLocale().formatNumber(zi.getStaerke(),OptionFactory.NF_STAERKE);
		            		break;
		            	case C_LITER20:
		            		ret = rz.getLocale().formatNumber(zi.getLiter20(),OptionFactory.NF_INVENTUR);
		            		break;
		            	case C_LA:
		            		ret =  rz.getLocale().formatNumber(zi.getLa(),OptionFactory.NF_INVENTUR) ;
		            		break;
		            	case C_LITER:
		            		switch (zi.getTyp()) {
		            			case InventurZeilenItem.TYP_LITER:
		            				ret = rz.getLocale().formatNumber(zi.getLiter(),OptionFactory.NF_INVENTUR) ;
		            				break;
		            			case InventurZeilenItem.TYP_GEWICHT:
		            				ret ="0" ;
		            				break;
		            			case InventurZeilenItem.TYP_LEER:
		            				ret ="0" ;
		            				break;
		            		}
		            		break;
		            	case C_TT:
		            		switch (zi.getTyp()) {
		            			case InventurZeilenItem.TYP_LITER:
			            			ret = rz.getLocale().formatNumber(zi.getTanktemperatur(),OptionFactory.NF_INVENTUR) ;
		            				break;
		            			case InventurZeilenItem.TYP_GEWICHT:
		            				ret ="0" ;
		            				break;
		            			case InventurZeilenItem.TYP_LEER:
		            				ret ="0" ;
		            				break;
		            		}
		            		break;
		            	case C_TAFEL3:
		            		switch (zi.getTyp()) {
		            			case InventurZeilenItem.TYP_LITER:
			            			ret = rz.getLocale().formatNumber(zi.getTafel3(),OptionFactory.NF_INVENTUR) ;
		            				break;
		            			case InventurZeilenItem.TYP_GEWICHT:
		            				ret ="0" ;
		            				break;
		            			case InventurZeilenItem.TYP_LEER:
		            				ret ="0" ;
		            				break;
		            		}
		            		break;
		            	case C_BRUTTO:
		            		switch (zi.getTyp()) {
		            			case InventurZeilenItem.TYP_LITER:
		            				ret = "0";
		            				break;
		            			case InventurZeilenItem.TYP_GEWICHT:
			            			ret = rz.getLocale().formatNumber(zi.getBrutto(),OptionFactory.NF_INVENTUR) ;
		            				break;
		            			case InventurZeilenItem.TYP_LEER:
		            				ret ="0" ;
		            				break;
		            		}
		            		break;
		            	case C_TARA:
		            		switch (zi.getTyp()) {
		            			case InventurZeilenItem.TYP_LITER:
		            				ret = "0";
		            				break;
		            			case InventurZeilenItem.TYP_GEWICHT:
		            				ret = rz.getLocale().formatNumber(zi.getTara(),OptionFactory.NF_INVENTUR) ;
		            				break;
		            			case InventurZeilenItem.TYP_LEER:
		            				ret ="0" ;
		            				break;
		            		}
		            		break;
		            	case C_NETTO:
		            		switch (zi.getTyp()) {
		            			case InventurZeilenItem.TYP_LITER:
		            				ret = "0";
		            				break;
		            			case InventurZeilenItem.TYP_GEWICHT:
		            				ret = rz.getLocale().formatNumber(zi.getNetto(),OptionFactory.NF_INVENTUR) ;
		            				break;
		            			case InventurZeilenItem.TYP_LEER:
		            				ret ="0" ;
		            				break;
		            		}
		            		break;
		            	case C_EXTRAKT:
		            		switch (zi.getTyp()) {
		            			case InventurZeilenItem.TYP_LITER:
		            				ret = "";
		            				break;
		            			case InventurZeilenItem.TYP_GEWICHT:
		            				if(zi.getExtrakt() == 0) {
			            				ret = rz.getLocale().getString("string_ja");
			            			} else {
			            				ret = rz.getLocale().getString("string_nein");
			            			}
		            				break;
		            			case InventurZeilenItem.TYP_LEER:
		            				ret ="" ;
		            				break;
		            		}
		            		break;
		            	case C_TAFEL2:
		            		switch (zi.getTyp()) {
		            			case InventurZeilenItem.TYP_LITER:
		            				ret = "0";
		            				break;
		            			case InventurZeilenItem.TYP_GEWICHT:
			            			if(zi.getExtrakt() == 0) {
			            				ret = rz.getLocale().formatNumber(zi.getTafel2(),OptionFactory.NF_INVENTUR) ;
			            			} else {
			            				ret = "0";
			            			}
		            			break;
		            			case InventurZeilenItem.TYP_LEER:
		            				ret ="0" ;
		            				break;
		            		}
		            		break;
		            	case C_LITERGEWICHT:
		            		switch (zi.getTyp()) {
		            			case InventurZeilenItem.TYP_LITER:
		            				ret = "0";
		            				break;
		            			case InventurZeilenItem.TYP_GEWICHT:
		            				if(zi.getExtrakt() == 0) {
			            				ret = "0";
			            				} else {
			            				ret = rz.getLocale().formatNumber(zi.getLitergewicht(),OptionFactory.NF_LITERGEWICHT) ;
			            				}
		            				break;
            					case InventurZeilenItem.TYP_LEER:
            						ret ="0" ;
            						break;
		            		}
		            		break;
		            	case C_USER:
		            		ret=zi.getUser_1();
		            		break;
		            	case C_LAGER:
		            		ret=zi.getStrLager();
		            		break;
		            	case C_STEUER_ARTIKEL:
		            		ret=zi.getSteuer_artikel();
		            		break;
		            	case C_SORTE:
		            		ret=zi.getStrSorte();
		            		break;
		            	case C_STEUERLAGER:
		            		ret=zi.getStrSteuerlager();
		            		break;
		            }
	            }
	            return ret;
	        }
		}

    /** rendert alle Tabellenzeilen mit numerischen Inhalt
	 *  im wesentlichen heisst das rechts-ausgerichtent
	 * @author lunqual
	 */
	private class NumericRenderer extends DefaultTableCellRenderer {

	    NumericRenderer() {
	        super();
	        setOpaque(true);
	    }
	    public Component getTableCellRendererComponent(JTable table,
                Object value, boolean isSelected, boolean hasFocus, int row,
                int column)
	    {
	    	setFont(rz.getFontFactory().getTableFont());
	    	if((row != -1) && (zeilen != null)) {
	    		final InventurZeilenItem zi=zeilen.getItem(row);
	    		if(isSelected) {
	    		    setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_SELECTED));
	    		}else {
	    			switch (zi.getTyp()) {
	    				case InventurZeilenItem.TYP_LITER:
		    				setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_INVENTUR_LITER));
		    				break;
	    				case InventurZeilenItem.TYP_GEWICHT:
		    				setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_INVENTUR_GEWICHT));
		    				break;
	    				case InventurZeilenItem.TYP_LEER:
		    				setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_INVENTUR_LEER));
		    				break;
	    			}
	    		}
	    	}
	        if(value != null) {
	           if(!rz.isZero(rz.getLocale().getNumber(value.toString(), OptionFactory.NF_INVENTUR))) {
	        	   if(column == C_LA) {
	        		   setText("<html><b>" + value.toString() +"</b></html>");
	        	   } else {
	        		   setText(value.toString());
	        	   }
	           } else {
				setText("");
			}
	         } else {
				setText("");
			}
	        setHorizontalAlignment(SwingConstants.TRAILING);
	        return this;
        }
	}

	/** rendert alle Tabellenzeilen mit String Inhalt
	 *  im wesentlichen heisst das rechts-ausgerichtent
	 * @author lunqual
	 */
	private class StringRenderer extends DefaultTableCellRenderer {

	    StringRenderer() {
	        super();
	        setOpaque(true);
	    }
	    public Component getTableCellRendererComponent(JTable table,
                Object value, boolean isSelected, boolean hasFocus, int row,
                int column)
	    {
	    	setFont(rz.getFontFactory().getTableFont());
	    	if((row != -1) && (zeilen != null)) {
	    	    final InventurZeilenItem zi = zeilen.getItem(row);
	    		if(isSelected) {
	    		    setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_SELECTED));
	    		}else {
	    			switch (zi.getTyp()) {
	    				case InventurZeilenItem.TYP_LITER:
		    				setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_INVENTUR_LITER));
		    				break;
	    				case InventurZeilenItem.TYP_GEWICHT:
		    				setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_INVENTUR_GEWICHT));
		    				break;
	    				case InventurZeilenItem.TYP_LEER:
		    				setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_INVENTUR_LEER));
		    				break;
	    			}
	    		}
	    	}
	        if(value != null) {
	        	setText(value.toString());
	         } else {
				setText("");
			}
	        setHorizontalAlignment(SwingConstants.LEADING);
	        return this;
        }
	}

	public void columnAdded(TableColumnModelEvent e) {
	}

	public void columnRemoved(TableColumnModelEvent e) {
	}

	public void columnMoved(TableColumnModelEvent e) {
	}

	public void columnMarginChanged(ChangeEvent e) {
	}

	public void columnSelectionChanged(ListSelectionEvent e) {
	}

}
