/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package de.lunqual.rzpro.fenster.kalenderfenster;


import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fenster.JSelectedTextField;
import de.lunqual.rzpro.fenster.rzDatePicker.RzSimpleDatePicker;
import de.lunqual.rzpro.fenster.rzDatePicker.pickerDateListener;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.kalender.TerminItem;
import de.lunqual.rzpro.items.message.MessageItem;

/**
 *
 * @author  lunqual
 */
public class TerminEingabeFenster extends JRzFrame{

    //GUI-Variablen
    private JToolBar tb1;
    private JMenuBar mb;
    private JMenu mnuDatei; 
    private JMenu mnuBuchung;
    private JMenu mnuExtras;
    private JMenu mnuHilfe;
      private  JPanel contentPanel;
      	private JPanel tbPanel;
      	private JPanel centerPanel;
      		private JPanel titelPanel;
      			private JLabel lblTitel;
      			private JPanel dateChooserPanel;
      				private JLabel lblChooseDatum;
      				private RzSimpleDatePicker btDatum;
      			private JPanel eingabePanel;
      				private JPanel bezeichnungPanel;
      					private JLabel lblBezeichnung;
      					private JSelectedTextField txtBezeichnung;
      				private JPanel commentPanel;
      					private JLabel lblComment;
      					private JTextArea txtComment;
          			private JPanel erledigtPanel;
      					private JCheckBox chkErledigt;
      	
  		private JPanel buttonPanel;
  			private JPanel saveButtonPanel;
  				private JButton btSave;
  	      	    private JButton btClose;
      	    private JButton btHilfe;

    private static final int         		ACTION_ABBRECHEN_CODE = 1001;
    private static final String     		ACTION_ABBRECHEN_TEXT = "termineingabe.action_abbrechen";
    private static final int         		ACTION_SAVE_CODE = 1002;
    private static final String     		ACTION_SAVE_TEXT = "termineingabe.action_save";
    private static final int         		ACTION_HILFE_CODE = 1003;
    private static final String     		ACTION_HILFE_TEXT = "action_hilfe";
    private static final int         		ACTION_HIDE_CODE = 1004;
    private static final String    			ACTION_HIDE_TEXT = "action_hide";
    
   
    private static final String				DATUM_FORMAT="EEEE, dd. MMMM yyyy";
   
    JRzFrame								origin;
    SimpleDateFormat						df;
    TerminItem								ti;
    Calendar								today;

    /** Creates new form AdressenFenster */
    public TerminEingabeFenster(RzPro r, String name, Object extendedData) {
        super(r,name,extendedData);
        df=new SimpleDateFormat(DATUM_FORMAT);
        today=Calendar.getInstance();
        rz.roundDatum(today);
        createActions();
        createGUIComponents();
        setGUIComponents();
        getMessage((MessageItem)extendedData);
    }

    public void createGUIComponents() {
    	// Menü

    	mb = new JMenuBar();
    	mnuDatei = new JMenu();
    	mnuBuchung=new JMenu();
    	mnuExtras = new JMenu();
    	mnuHilfe = new JMenu();
    	mb.add(mnuDatei);
    	mb.add(mnuBuchung);
    	mb.add(mnuExtras);
    	mb.add(mnuHilfe);
    	setJMenuBar(mb);
		//Toolbar
		tb1 = new JToolBar();
		tb1.setFloatable(false);
		tb1.setRollover(true);
		//ToolbarPanel
		//contentPanel
		contentPanel = new JPanel(new BorderLayout());
			tbPanel = new JPanel(new BorderLayout());
				tbPanel.add(tb1,BorderLayout.NORTH);
		contentPanel.add(tbPanel,BorderLayout.NORTH);
			centerPanel = new JPanel(new BorderLayout());
      			titelPanel=new JPanel(new BorderLayout());
      				lblTitel=new JLabel();
      					lblTitel.setHorizontalAlignment(SwingConstants.CENTER);
      					lblTitel.setBorder(BorderFactory.createEtchedBorder());
      				titelPanel.add(lblTitel,BorderLayout.NORTH);
      				dateChooserPanel = new JPanel(new BorderLayout());
      					lblChooseDatum = new JLabel();
      						lblChooseDatum.setHorizontalAlignment(SwingConstants.TRAILING);
      					dateChooserPanel.add(lblChooseDatum,BorderLayout.WEST);
	      				btDatum = new RzSimpleDatePicker(rz);
	      					btDatum.addListener(new pickerDateListener() {
								@Override
								public void dateChanged(Date datum) {
									changeTag();
								}
	      						
	      					});
	      				dateChooserPanel.add(btDatum, BorderLayout.CENTER);
        	    	titelPanel.add(dateChooserPanel,BorderLayout.SOUTH);
      				eingabePanel = new JPanel(new BorderLayout());
          				bezeichnungPanel = new JPanel(new BorderLayout());
          					lblBezeichnung = new JLabel();
          						lblBezeichnung.setHorizontalAlignment(SwingConstants.TRAILING);
          					bezeichnungPanel.add(lblBezeichnung, BorderLayout.WEST);
          					txtBezeichnung = new JSelectedTextField();
          					txtBezeichnung.addKeyListener(new java.awt.event.KeyAdapter() {
      							public void keyReleased(java.awt.event.KeyEvent evt) {
      								if(!txtBezeichnung.getText().trim().equals("")) {
      									getAction(ACTION_SAVE_CODE).setEnabled(true);
      								}else {
      									getAction(ACTION_SAVE_CODE).setEnabled(false);
      								}
      							}
      						});
          					bezeichnungPanel.add(txtBezeichnung,BorderLayout.CENTER);
          				eingabePanel.add(bezeichnungPanel,BorderLayout.NORTH);
          				commentPanel = new JPanel(new BorderLayout());
          					commentPanel.setBorder(BorderFactory.createEtchedBorder());
          					lblComment = new JLabel();
          						lblComment.setHorizontalAlignment(SwingConstants.CENTER);
          					commentPanel.add(lblComment,BorderLayout.NORTH);
          					txtComment = new JTextArea();
          						txtComment.setPreferredSize(new Dimension(300,200));
          					commentPanel.add(txtComment,BorderLayout.CENTER);
          				eingabePanel.add(commentPanel, BorderLayout.CENTER);
          				erledigtPanel = new JPanel(new BorderLayout());
          					erledigtPanel.setBorder(BorderFactory.createEtchedBorder());
          					chkErledigt = new JCheckBox();
          					erledigtPanel.add(chkErledigt,BorderLayout.WEST);
          				eingabePanel.add(erledigtPanel, BorderLayout.SOUTH);
          			
          		centerPanel.add(eingabePanel,BorderLayout.CENTER);
  			centerPanel.add(titelPanel, BorderLayout.NORTH);
  			
  		
		contentPanel.add(centerPanel,BorderLayout.CENTER);
		    // ButtonPanel
		buttonPanel=new JPanel(new BorderLayout());
			saveButtonPanel=new JPanel(new BorderLayout());
				btSave=new JButton();
				saveButtonPanel.add(btSave,BorderLayout.WEST);
				btClose=new JButton();
				saveButtonPanel.add(btClose,BorderLayout.EAST);
			buttonPanel.add(saveButtonPanel,BorderLayout.WEST);
			btHilfe=new JButton();
			buttonPanel.add(btHilfe,BorderLayout.EAST);
		contentPanel.add(buttonPanel,BorderLayout.SOUTH);

		//Panels ans Fenster hängen;
		this.getContentPane().setLayout(new BorderLayout());

		this.getContentPane().add(contentPanel, BorderLayout.CENTER);
    }


    public void setGUIComponents() {
        setTitle(rz.getVersionString() + " " + rz.getLocale().getString("termineingabe.titel"));
        
		mnuDatei.setText(rz.getLocale().getString("menu.datei"));
		mnuExtras.setText(rz.getLocale().getString("menu.extras"));
		mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));

		mnuDatei.add(getAction(ACTION_SAVE_CODE));
		mnuDatei.addSeparator();
        mnuDatei.add(getAction(ACTION_ABBRECHEN_CODE));
        mnuExtras.add(getAction(ACTION_HIDE_CODE));
        mnuHilfe.add(getAction(ACTION_HILFE_CODE));

		tb1.add(getAction(ACTION_ABBRECHEN_CODE));
		tb1.addSeparator();
		tb1.add(getAction(ACTION_HIDE_CODE));
		tb1.addSeparator();
		tb1.add(getAction(ACTION_HILFE_CODE));
		tb1.addSeparator();

		lblBezeichnung.setText(rz.getLocale().getString("termineingabe.label_bezeichnung"));
		lblComment.setText(rz.getLocale().getString("termineingabe.label_comment"));
		lblChooseDatum.setText(rz.getLocale().getString("termineingabe.label_choose_datum"));
		chkErledigt.setText(rz.getLocale().getString("termineingabe.label_erledigt"));
		
		btHilfe.setAction(getAction(ACTION_HILFE_CODE));
		btClose.setAction(getAction(ACTION_ABBRECHEN_CODE));
		btSave.setAction(getAction(ACTION_SAVE_CODE));
		getAction(ACTION_SAVE_CODE).setEnabled(false);
		
		setResizable(true);
        rz.getFontFactory().setFrameFonts(this);
        pack();
        rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;
    }


    public void getMessage(MessageItem msg) {
        switch(msg.getMsgCode()) {
    	case MessageItem.MSG_ACTIONPERFORMED:
            switch(msg.getCode()){
		          case ACTION_HILFE_CODE: hilfeAction();break;
		          case ACTION_HIDE_CODE:hideAction();break;
		          case ACTION_ABBRECHEN_CODE:closeWindow();break;
		          case ACTION_SAVE_CODE:saveAction();break;
		          default :
		              break;
            }
    		break;
    	case MessageItem.MSG_SHOW_TERMIN:
    		long faellig = (Long)msg.getData();
    		ti = new TerminItem(rz,faellig);
    		break;
    		
    	case MessageItem.MSG_EDIT_TERMIN:
    		ti = null;
    		if(msg.getData() != null) {
    			ti = (TerminItem)msg.getData();
    		}
    		break;
        default:
            break;
        }

    }
    public void createActions(){
        actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT, KeyEvent.VK_F5 ,KeyEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT, KeyEvent.VK_F1,0));
        actionList.put(String.valueOf(ACTION_ABBRECHEN_CODE),new AuswahlAction(rz,this,ACTION_ABBRECHEN_CODE,ACTION_ABBRECHEN_TEXT, KeyEvent.VK_ESCAPE,0));
        actionList.put(String.valueOf(ACTION_SAVE_CODE),new AuswahlAction(rz,this,ACTION_SAVE_CODE,ACTION_SAVE_TEXT, KeyEvent.VK_S,KeyEvent.CTRL_DOWN_MASK));
        
    }

   
    private void saveAction() {
    	toItem();
    	if(ti != null) {
    		rz.getDatabase().getKalender().saveTermin(ti);
    		closeWindow();
    		rz.getFensterFactory().getFensterListe().propagateBestand(this);
    	}
    }
    
    public void openWindow(){
    	if(ti != null) {
    		fromItem();
            setVisible(true);
            toFront();
            txtBezeichnung.requestFocus();
    	}else {
    		closeWindow();
    	}
    }

    public void closeWindow(){
        rz.getFensterFactory().getFensterListe().disposeFrame(this);
    }
    
    private void changeTag() {
    	if(ti != null) {
    		Calendar temp = Calendar.getInstance();
    		temp.setTime(btDatum.getDate());
    		rz.roundDatum(temp);
    		if(temp.getTimeInMillis() < today.getTimeInMillis()) {
    			btDatum.setStartDate(new Date());
    		}else {
    			ti.setFaellig(btDatum.getDate().getTime());
    			lblTitel.setText(rz.getLocale().getString("termineingabe.label_titel").replaceAll("%s", df.format(ti.getFaellig().getTime())));
    		}
    	}
    }

    private void toItem() {
    	if(ti != null) {
    		ti.setGeaendert(rz.getDatabase().getServerTimestamp());
    		ti.setGeaendert_user(rz.getDatabase().dbGetUser());
    		ti.setBezeichnung(txtBezeichnung.getText().trim());
    		ti.setComment(txtComment.getText().trim());
    		if(chkErledigt.isSelected()) {
    			ti.setErledigt(true);
    			ti.setErledigt_datum(rz.getDatabase().getServerTimestamp());
    			ti.setErledigt_user(rz.getDatabase().dbGetUser());
    		}else {
    			ti.setErledigt(false);
    		}
    	}
    }
    
    private void fromItem() {
    	if(ti != null) {
    		btDatum.setStartDate(ti.getFaellig().getTime());
    		lblTitel.setText(rz.getLocale().getString("termineingabe.label_titel").replaceAll("%s", df.format(ti.getFaellig().getTime())));
    		txtBezeichnung.setText(ti.getBezeichnung());
    		txtComment.setText(ti.getComment());
    		chkErledigt.setSelected(ti.isErledigt());
    		if(!ti.getBezeichnung().equals("")) {
    			getAction(ACTION_SAVE_CODE).setEnabled(true);
    		}else {
    			getAction(ACTION_SAVE_CODE).setEnabled(false);
    		}
    	}
    	
    }

    private void hideAction(){
        rz.getFensterFactory().getFensterListe().sperren(this);
    }

    private void hilfeAction(){
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"termineingabe" +
        		".html",this));
    }

   
}


