/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package de.lunqual.rzpro.fenster.kalkulationsfenster;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;

import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.fenster.JNumberField;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fenster.JSelectedTextField;
import de.lunqual.rzpro.fenster.dialoge.DialogControl;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.currency.CurrencyItem;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.options.OptionFactory;

/*
The type javax.swing.text.DefaultFormatter cannot be resolved. It is indirectly referenced from required type 
javax.swing.text.MaskFormatter
*/

/**
 *
 * @author  administrator
 */
public class KalkulationEingabe extends JRzFrame {

    //GUI-Variablen
	private JMenuBar mb;
    	private JMenu mnuDatei;
    	private JMenu mnuExtras;
    	private JMenu mnuHilfe;
    private JPanel mainPanel;
    	private JPanel toolbarPanel;
    		private JToolBar tb1;
    	private JPanel contentPanel;
        	private JLabel lblName;
            private JSelectedTextField txtName;
        	private JLabel lblShortName;
            private JFormattedTextField txtShortName;
            private JLabel lblRate;
            private JNumberField txtRate;
    	private JPanel buttonPanel;
    		private JButton btOK;
    		private JButton btHilfe;
    		private JButton btCancel;

    // ActionCodes KalkulationEingabe
    public static final int         ACTION_OK_CODE = 1000;
    public static final String      ACTION_OK_TEXT = "kalkulationeingabe.action_ok";
    public static final int         ACTION_ABBRECHEN_CODE = 1001;
    public static final String      ACTION_ABBRECHEN_TEXT = "kalkulationeingabe.action_abbrechen";
    public static final int         ACTION_HILFE_CODE = 1002;
    public static final String      ACTION_HILFE_TEXT = "action_hilfe";
    public static final int         ACTION_HIDE_CODE = 1003;
    public static final String      ACTION_HIDE_TEXT = "action_hide";

    CurrencyItem    	ci;
    JRzFrame			origin;

    static final String SHORTNAME_MASK = "****";

    /** Creates new form AdressAuswahl */

    public KalkulationEingabe(RzPro r, String name,Object extendedData) {
        super(r,name,extendedData);
        createActions();
        createGUIComponents();
        setGUIComponents();
        getMessage((MessageItem)extendedData);
    }

    @Override
	public void createGUIComponents() {
        mb = new JMenuBar();
		mnuDatei = new JMenu();
			mb.add(mnuDatei);
        mnuExtras = new JMenu();
        	mb.add(mnuExtras);
        mnuHilfe = new JMenu();
        	mb.add(mnuHilfe);
		setJMenuBar(mb);
		mainPanel = new JPanel(new BorderLayout());
			toolbarPanel = new JPanel(new BorderLayout());
				tb1 = new JToolBar();
				tb1.setFloatable(false);
				tb1.setRollover(true);
				toolbarPanel.add(tb1);
			mainPanel.add(toolbarPanel,BorderLayout.NORTH);
			contentPanel  = new JPanel(new GridLayout(3,2));
	        	lblName = new JLabel();
	        		lblName.setHorizontalAlignment(SwingConstants.CENTER);
	        		contentPanel.add(lblName);
	            txtName = new JSelectedTextField();
	            	contentPanel.add(txtName);
	        	lblShortName = new JLabel();
	        		lblShortName.setHorizontalAlignment(SwingConstants.CENTER);
	        		contentPanel.add(lblShortName);
	        	txtShortName = new JFormattedTextField(rz.getOptionFactory().createFormatter(SHORTNAME_MASK));
	        		contentPanel.add(txtShortName);
	            lblRate = new JLabel();
	            	lblRate.setHorizontalAlignment(SwingConstants.CENTER);
	            	contentPanel.add(lblRate);
	            txtRate = new  JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_EXCHANGE),1.0,0.0,Double.POSITIVE_INFINITY);
	            	contentPanel.add(txtRate);
			buttonPanel=new JPanel(new GridLayout(1,3));
    			btOK=new JButton();
    				buttonPanel.add(btOK);
    			btHilfe = new JButton();
    				buttonPanel.add(btHilfe);
    		    btCancel = new JButton();
    		    	buttonPanel.add(btCancel)
    		    	;
			mainPanel.add(toolbarPanel,BorderLayout.NORTH);
			mainPanel.add(contentPanel,BorderLayout.CENTER);
			mainPanel.add(buttonPanel,BorderLayout.SOUTH);

			getContentPane().setLayout(new BorderLayout());
			getContentPane().add(mainPanel,BorderLayout.CENTER);
    }
    @Override
	public void setGUIComponents() {
        setTitle(rz.getLocale().getString("kalkulationeingabe.titel"));

        mnuDatei.setText(rz.getLocale().getString("menu.datei"));
        mnuExtras.setText(rz.getLocale().getString("menu.extras"));
        mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));
        mnuDatei.add(getAction(ACTION_OK_CODE));
        mnuDatei.addSeparator();
        mnuDatei.add(getAction(ACTION_ABBRECHEN_CODE));
        mnuExtras.add(getAction(ACTION_HIDE_CODE));
        mnuHilfe.add(getAction(ACTION_HILFE_CODE));

  	  	tb1.add(getAction(ACTION_OK_CODE));
  	  	tb1.add(getAction(ACTION_ABBRECHEN_CODE));
  	  	tb1.addSeparator();
  	  	tb1.add(getAction(ACTION_HIDE_CODE));
  	  	tb1.addSeparator();
  	  	tb1.add(getAction(ACTION_HILFE_CODE));

        btOK.setAction(getAction(ACTION_OK_CODE));
        btHilfe.setAction(getAction(ACTION_HILFE_CODE));
        btCancel.setAction(getAction(ACTION_ABBRECHEN_CODE));

        lblName.setText(rz.getLocale().getString("kalkulationeingabe.label_name"));
        lblShortName.setText(rz.getLocale().getString("kalkulationeingabe.label_shortname"));
        lblRate.setText(rz.getLocale().getString("kalkulationeingabe.label_rate").replaceAll("%s",rz.getDatabase().getCurrency().dbGetCurrency(1,true).getShortName()));

         setResizable(true);
         rz.getFontFactory().setFrameFonts(this);
         pack();
         rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;
    }
    @Override
	public void getMessage(MessageItem msg) {
        switch(msg.getMsgCode()) {
    	case MessageItem.MSG_ACTIONPERFORMED:
            switch(msg.getCode()){
            case ACTION_ABBRECHEN_CODE :cancelAction();break;
			case ACTION_OK_CODE :okAction();break;
            case ACTION_HILFE_CODE: hilfeAction();break;
            case ACTION_HIDE_CODE:hideAction();break;
            default :
                break;
           }
    		break;
         case MessageItem.MSG_EDIT_CURRENCY:
 			origin = msg.getOrigin();
            ci = rz.getDatabase().getCurrency().dbGetCurrency(msg.getCode(),false);
            if(ci !=null) {
            	fromItem();
            }
	      	break;

        default:
            rz.getLogFactory().logMessage(2, "kalkulation:_eingabe", "auswahlAction:" + msg.getMsgCode());
            break;
        }
    }

    @Override
	public void createActions(){
        actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT, KeyEvent.VK_F5 ,InputEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT, KeyEvent.VK_F1 ,0));
		actionList.put(String.valueOf(ACTION_OK_CODE), new AuswahlAction(rz,this,ACTION_OK_CODE,ACTION_OK_TEXT,KeyEvent.VK_O,	InputEvent.CTRL_DOWN_MASK));
		actionList.put(String.valueOf(ACTION_ABBRECHEN_CODE), new AuswahlAction(rz,this, ACTION_ABBRECHEN_CODE,ACTION_ABBRECHEN_TEXT,KeyEvent.VK_ESCAPE, 0));

    }

    /**
     * ok gedrückt... abspeichern oder ändern
     */
    private void okAction(){
        int insertID;
        toItem();

        if(!(ci.getName().equals("") || ci.getShortName().equals(""))) {
            insertID = rz.getDatabase().getCurrency().dbSaveCurrency(ci);
            closeWindow();
            origin.getMessage(new MessageItem(MessageItem.MSG_EDIT_CURRENCY_REPLY,insertID,null,this));
        } else {
            final DialogItem dlgItem = new DialogItem(0,"",0.0,"","","","","","",null);
            dlgItem.setTyp(DialogControl.HINWEIS_DIALOG);
            dlgItem.setCaption(rz.getLocale().getString("kalkulationeingabe.titel"));
            dlgItem.setTitel(rz.getLocale().getString("kalkulationeingabe.titel"));
            dlgItem.setMessage(rz.getLocale().getString("kalkulationeingabe.error_kein_name"));
            dlgItem.setIcon("warnung.png");
            dlgItem.setOk(rz.getLocale().getString("string_ok"));
            dlgItem.setOrigin(this);
            rz.getDialogFactory().getDialog(dlgItem);
        }
    }

    /**
     * cancel
     */
    private void cancelAction(){
        closeWindow();
    }

    private void fromItem(){
        txtName.setText(ci.getName());
        txtShortName.setValue(ci.getShortName());
        txtRate.setValue(ci.getRate());
        if(ci.getID()==1) {
        	txtRate.setEditable(false);
        	txtRate.setEnabled(false);
        }
    }

    private void toItem(){
        ci.setName(txtName.getText().trim());
        ci.setRate(txtRate.getValue());
        try{
            txtShortName.commitEdit();
            ci.setShortName(txtShortName.getText().trim());
        } catch (final Exception e){ci.setShortName("");}
    }

    @Override
	public void closeWindow(){
        rz.getFensterFactory().getFensterListe().disposeFrame(this);
    }
    @Override
	public void openWindow(){
    	if(ci != null) {
        if (!isVisible()) {
			setVisible(true);
		}
        toFront();
        txtName.requestFocus();
    	} else {
    		closeWindow();
    	}
    }

	//hilfe
	private void hilfeAction() {
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"kalkulation_eingabe.html",this));
	}

    private void hideAction() {
        rz.getFensterFactory().getFensterListe().sperren(this);
    }
}
