package de.lunqual.rzpro.fenster.kontraktFenster;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;

import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.database.DBKontrakte;
import de.lunqual.rzpro.fenster.JNumberField;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fenster.JSelectedTextField;
import de.lunqual.rzpro.fenster.ZutatenDialog;
import de.lunqual.rzpro.fenster.dialoge.DialogControl;
import de.lunqual.rzpro.fenster.rzDatePicker.RzSimpleDatePicker;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.adressen.AdressItem;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.items.einheiten.EinheitsItem;
import de.lunqual.rzpro.items.kontrakt.kontraktItem;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.rezeptur.RezepturItem;
import de.lunqual.rzpro.items.rezeptur.ZutatenSuchItem;
import de.lunqual.rzpro.items.stichworte.StichwortItem;
import de.lunqual.rzpro.log.LogFactory;
import de.lunqual.rzpro.options.OptionFactory;

public class kontraktEingabe extends JRzFrame{

	Icon 									suche;
	JRzFrame 								origin;
	kontraktItem 							ki;
    ZutatenDialog							zd;
    int										zdRezeptur = 0;
    boolean									adresseFill = false;
	
    
    private static final int				ERROR_REZEPTUR = 1;
    private static final int				ERROR_MENGE = 2;
    private static final int				ERROR_DATUM = 3;
    
   //GUI-Variablen
	private JMenuBar mb;
    	private JMenu mnuDatei;
    	private JMenu mnuExtras;
    	private JMenu mnuHilfe;
    private JPanel mainPanel;
    	private JPanel toolbarPanel;
    		private JToolBar tb1;
    	private JPanel contentPanel;
    		private JPanel rezepturPanel;
    			private JPanel typPanel;
    			private ButtonGroup typGroup;
					private JRadioButton btTypEinkauf;
					private JRadioButton btTypVerkauf;
    			private JPanel rezepturSelectPanel;
    				private JLabel lblRezeptur;
    				private JButton btRezeptur;
    			private JSplitPane splCenter;
					private JPanel adressPanel;
	    			private JPanel adressPanelOben;
	    				private JSelectedTextField txtFirma;
						private JLabel lblAdresse;
						private JComboBox cmbAdressen;
					private JPanel adressPanelCenter;
						private JScrollPane scrText;
							private JEditorPane txtAdressen;
						private JPanel bemerkungenPanel;
							private JLabel lblBemerkungen;
							private JScrollPane scrBemerkungen;
								private JTextPane txtBemerkungen;
			private JPanel datenPanel;
				private JPanel mengenPanel;
					private JLabel lblMenge;
					private JNumberField txtMenge;
					private JComboBox cmbEinheit;
				private JPanel datumPanel;
					private JPanel startDatumPanel;
						private JLabel lblStartDatum;
						private RzSimpleDatePicker dtStart;
					private JPanel endDatumPanel;
						private JLabel lblEndDatum;
						private RzSimpleDatePicker dtEnde;
    	private JPanel buttonPanel;
    		private JButton btSave;
    		private JButton btHilfe;
    		private JButton btCancel;
    		
    // ActionCodes 
    public static final int         ACTION_SAVE_CODE = 1000;
    public static final String      ACTION_SAVE_TEXT = "kontrakteingabe.action_save";
    public static final int         ACTION_ABBRECHEN_CODE = 1001;
    public static final String      ACTION_ABBRECHEN_TEXT = "kontrakteingabe.action_abbrechen";
    public static final int         ACTION_HILFE_CODE = 1002;
    public static final String      ACTION_HILFE_TEXT = "action_hilfe";
    public static final int         ACTION_HIDE_CODE = 1003;
    public static final String      ACTION_HIDE_TEXT = "action_hide";
		
    public kontraktEingabe(RzPro r, String name,Object extendedData) {
        super(r,name,extendedData);
        suche = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/auftrag.icon_suche.png"));
        createActions();
        createGUIComponents();
        setGUIComponents();
        getMessage((MessageItem)extendedData);
    }

    public void closeWindow() {
    	saveDividerLocations();
		rz.getFensterFactory().getFensterListe().disposeFrame(this);    
	}

	public void createActions() {
		actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT, KeyEvent.VK_F5 ,InputEvent.SHIFT_DOWN_MASK));
	    actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT, KeyEvent.VK_F1 ,0));
		actionList.put(String.valueOf(ACTION_SAVE_CODE), new AuswahlAction(rz,this,ACTION_SAVE_CODE,ACTION_SAVE_TEXT,KeyEvent.VK_O,	InputEvent.CTRL_DOWN_MASK));
		actionList.put(String.valueOf(ACTION_ABBRECHEN_CODE), new AuswahlAction(rz,this, ACTION_ABBRECHEN_CODE,ACTION_ABBRECHEN_TEXT,KeyEvent.VK_ESCAPE, 0));
	}

	public void createGUIComponents() {
		  mb = new JMenuBar();
			mnuDatei = new JMenu();
				mb.add(mnuDatei);
	        mnuExtras = new JMenu();
	        	mb.add(mnuExtras);
	        mnuHilfe = new JMenu();
	        	mb.add(mnuHilfe);
			setJMenuBar(mb);
			mainPanel = new JPanel(new BorderLayout());
				toolbarPanel = new JPanel(new BorderLayout());
					tb1 = new JToolBar();
					tb1.setFloatable(false);
					tb1.setRollover(true);
					toolbarPanel.add(tb1);
				mainPanel.add(toolbarPanel,BorderLayout.NORTH);
				contentPanel  = new JPanel(new BorderLayout());
					rezepturPanel = new JPanel(new BorderLayout());
					
						typPanel = new JPanel(new GridLayout(1,2));
							typGroup = new ButtonGroup();
							btTypEinkauf = new JRadioButton();
							typGroup.add(btTypEinkauf);
							btTypVerkauf = new JRadioButton();
							typGroup.add(btTypVerkauf);
							btTypEinkauf.setSelected(true);
							typPanel.add(btTypEinkauf);
							typPanel.add(btTypVerkauf);
							
						rezepturPanel.add(typPanel,BorderLayout.WEST);
					
						rezepturPanel.setBorder(BorderFactory.createEtchedBorder());
							rezepturSelectPanel = new JPanel(new BorderLayout());
								rezepturSelectPanel.setBorder(BorderFactory.createEtchedBorder());
								lblRezeptur = new JLabel();
								rezepturSelectPanel.add(lblRezeptur,BorderLayout.CENTER);
								btRezeptur = new JButton();
								btRezeptur.setIcon(suche);
								btRezeptur.addActionListener(new java.awt.event.ActionListener() {
					                public void actionPerformed(java.awt.event.ActionEvent evt) {
					                	selectRezeptur();
					                }
								});
								rezepturSelectPanel.add(btRezeptur,BorderLayout.EAST);
    						rezepturPanel.add(rezepturSelectPanel,BorderLayout.NORTH);
    			contentPanel.add(rezepturPanel,BorderLayout.NORTH);	
    			
    			splCenter = new JSplitPane();
    				splCenter.setOrientation(JSplitPane.HORIZONTAL_SPLIT);
    				splCenter.setDividerSize(6);
	    			adressPanel = new JPanel(new BorderLayout());
					adressPanelOben=new JPanel(new BorderLayout());
						lblAdresse=new JLabel();
						adressPanelOben.add(lblAdresse,BorderLayout.WEST);
						cmbAdressen=new JComboBox();
		        	    cmbAdressen.addActionListener(new ActionListener() {
	        	        	public void actionPerformed(ActionEvent evt) {
	        	        		adressWechsel();
	        	        	}
		        	    });
						adressPanelOben.add(cmbAdressen,BorderLayout.CENTER);
						txtFirma = new JSelectedTextField();
						adressPanelOben.add(txtFirma,BorderLayout.SOUTH);
					adressPanel.add(adressPanelOben,BorderLayout.NORTH);
					adressPanelCenter=new JPanel(new BorderLayout());
						scrText = new JScrollPane();
							txtAdressen = new JEditorPane();
							txtAdressen.setContentType("text/html");
							txtAdressen.setEditable(false);
							scrText.setViewportView(txtAdressen);
							adressPanelCenter.add(scrText,BorderLayout.CENTER);
					adressPanel.add(adressPanelCenter,BorderLayout.CENTER);
					adressPanel.setBorder(BorderFactory.createEtchedBorder());
					
					bemerkungenPanel = new JPanel(new BorderLayout());
						bemerkungenPanel.setBorder(BorderFactory.createEtchedBorder());
						lblBemerkungen = new JLabel();
							lblBemerkungen.setHorizontalAlignment(SwingConstants.CENTER);
						bemerkungenPanel.add(lblBemerkungen,BorderLayout.NORTH);
						scrBemerkungen = new JScrollPane();
							txtBemerkungen = new JTextPane();
							scrBemerkungen.setViewportView(txtBemerkungen);
						bemerkungenPanel.add(scrBemerkungen,BorderLayout.CENTER);
						
					splCenter.setLeftComponent(adressPanel);
					splCenter.setRightComponent(bemerkungenPanel);
				
			contentPanel.add(splCenter,BorderLayout.CENTER);
    		
			datenPanel = new JPanel(new BorderLayout());
				datenPanel.setBorder(BorderFactory.createEtchedBorder());
				mengenPanel = new JPanel(new BorderLayout());
					lblMenge = new JLabel();
					lblMenge.setHorizontalAlignment(SwingConstants.TRAILING);
					mengenPanel.add(lblMenge,BorderLayout.WEST);
					txtMenge =  new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_NORMAL),0.0,Double.NEGATIVE_INFINITY,Double.POSITIVE_INFINITY);
					mengenPanel.add(txtMenge,BorderLayout.CENTER);
					cmbEinheit = new JComboBox();
					rz.getDatabase().getEinheiten().setGrundeinheitenCmb(cmbEinheit,RzPro.EINHEIT_KG);
					mengenPanel.add(cmbEinheit,BorderLayout.EAST);
				datenPanel.add(mengenPanel,BorderLayout.NORTH);
				
				datumPanel = new JPanel(new GridLayout(2,1));
					datumPanel.setBorder(BorderFactory.createEtchedBorder());
					startDatumPanel = new JPanel(new BorderLayout());
						lblStartDatum = new JLabel();
						lblStartDatum.setHorizontalAlignment(SwingConstants.TRAILING);
			    	    dtStart = new RzSimpleDatePicker(rz,true,true);
					    startDatumPanel.add(dtStart,BorderLayout.CENTER);
						startDatumPanel.add(lblStartDatum,BorderLayout.WEST);
				datumPanel.add(startDatumPanel);
					endDatumPanel = new JPanel(new BorderLayout());
						lblEndDatum = new JLabel();
						lblEndDatum.setHorizontalAlignment(SwingConstants.TRAILING);
			    	    dtEnde = new RzSimpleDatePicker(rz,true,true);
			    	endDatumPanel.add(dtEnde,BorderLayout.CENTER);
					endDatumPanel.add(lblEndDatum,BorderLayout.WEST);
				datumPanel.add(endDatumPanel);					
					
				mengenPanel.add(datumPanel,BorderLayout.SOUTH);
			contentPanel.add(datenPanel,BorderLayout.SOUTH);
				buttonPanel=new JPanel(new GridLayout(1,3));
	    			btSave=new JButton();
	    				buttonPanel.add(btSave);
	    			btHilfe = new JButton();
	    				buttonPanel.add(btHilfe);
	    		    btCancel = new JButton();
	    		    	buttonPanel.add(btCancel);
				mainPanel.add(toolbarPanel,BorderLayout.NORTH);
				mainPanel.add(contentPanel,BorderLayout.CENTER);
				mainPanel.add(buttonPanel,BorderLayout.SOUTH);

				getContentPane().setLayout(new BorderLayout());
				getContentPane().add(mainPanel,BorderLayout.CENTER);
	}

	public void getMessage(MessageItem msg) {
        switch(msg.getMsgCode()) {
    	case MessageItem.MSG_ACTIONPERFORMED:
            switch(msg.getCode()){
            case ACTION_ABBRECHEN_CODE :cancelAction();break;
			case ACTION_SAVE_CODE :saveAction();break;
            case ACTION_HILFE_CODE: hilfeAction();break;
            case ACTION_HIDE_CODE:hideAction();break;
            default :
                break;
           }
    		break;
		case MessageItem.MSG_ZUTATEN_DIALOG_REPLY :
			zutatenDialogReply((ZutatenSuchItem) msg.getData());
			break;
         case MessageItem.MSG_EDIT_KONTRAKT:
 			 origin = msg.getOrigin();
 			 int id = msg.getCode();
 			 ki = rz.getDatabase().getKontrakte().getKontrakt(id);
        	 fromItem(ki);
	      	 break;

        default:
            break;
        }
	}

	/** speichert die Position der Splitbalken
	 */
    private void saveDividerLocations(){
        rz.getFensterFactory().setOption(this.getName() + ".splCenter", this.splCenter.getDividerLocation());
        rz.getFensterFactory().saveOptions();
    }
	/** setzt die Position der Splitbalken auf gespeicherte Positionen oder
	 * auf Standardposition, wenn keine gespeicherten vorliegen
	 *
	 */
    private void setDividerLocations() {
        splCenter.setDividerLocation(rz.getFensterFactory().getOption(this.getName() + ".splCenter",this.getWidth()/3));
    }
	
	public void openWindow() {
		if(ki != null) {
    		if (!isVisible()) {
				setVisible(true);
			}
    		toFront();
    	} else {
    		closeWindow();
    	}
	}

	public void setGUIComponents() {
        setTitle(rz.getLocale().getString("kontrakteingabe.titel"));

        mnuDatei.setText(rz.getLocale().getString("menu.datei"));
        mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));
        mnuExtras.setText(rz.getLocale().getString("menu.extras"));
        mnuDatei.add(getAction(ACTION_SAVE_CODE));
        mnuDatei.addSeparator();
        mnuDatei.add(getAction(ACTION_ABBRECHEN_CODE));
        mnuExtras.add(getAction(ACTION_HIDE_CODE));
        mnuHilfe.add(getAction(ACTION_HILFE_CODE));

  	  	tb1.add(getAction(ACTION_SAVE_CODE));
  	  	tb1.add(getAction(ACTION_ABBRECHEN_CODE));
  	  	tb1.addSeparator();
  	  	tb1.add(getAction(ACTION_HIDE_CODE));
  	  	tb1.addSeparator();
  	  	tb1.add(getAction(ACTION_HILFE_CODE));

  	  	btSave.setAction(getAction(ACTION_SAVE_CODE));
        btHilfe.setAction(getAction(ACTION_HILFE_CODE));
        btCancel.setAction(getAction(ACTION_ABBRECHEN_CODE));

        btSave.setAction(getAction(ACTION_SAVE_CODE));
        btCancel.setAction(getAction(ACTION_ABBRECHEN_CODE));
        btHilfe.setAction(getAction(ACTION_HILFE_CODE));
        
        setRezepturLabel("");
        lblMenge.setText(rz.getLocale().getString("kontrakteingabe.label_menge"));
        lblBemerkungen.setText(rz.getLocale().getString("kontrakteingabe.label_bemerkungen"));
        lblAdresse.setText(rz.getLocale().getString("kontrakteingabe.label_adresse"));
        lblStartDatum.setText(rz.getLocale().getString("kontrakteingabe.label_startdatum"));
        lblEndDatum.setText(rz.getLocale().getString("kontrakteingabe.label_enddatum"));
        btTypEinkauf.setText(rz.getLocale().getString("kontrakteingabe.label_einkauf"));        
        btTypVerkauf.setText(rz.getLocale().getString("kontrakteingabe.label_verkauf"));   
        
        
        setResizable(true);
        rz.getFontFactory().setFrameFonts(this);
        pack();
        rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;
        setDividerLocations();
	}

	private void cancelAction() {
		closeWindow();
	}
	
	private void saveAction() {
		toItem();
	}
	
	private void hilfeAction() {
		rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"kontrakte.html",this));		
	}
	
	private void hideAction() {
        rz.getFensterFactory().getFensterListe().sperren(this);	
	}
	
	private void selectRezeptur() {
		if(ki != null) {
			showZutatenDialog(ki.getName());
		} else {
			showZutatenDialog("");
		}
	}
	
	private void setRezepturLabel(String r) {
		 lblRezeptur.setText(rz.getLocale().getString("kontrakteingabe.rezeptur_label").replaceAll("%s", r));
	}
	
	private void fromItem(kontraktItem ki) {
		if(ki != null) {
			if(ki.getTyp() == DBKontrakte.KONTRAKT_EINKAUF) {
				btTypEinkauf.setSelected(true);
			} else {
				btTypVerkauf.setSelected(true);
			}
			adresseFill = true;
			setAdresse();
			adresseFill = false;
			setRezepturLabel(ki.getName());
			txtMenge.setValue(ki.getMenge());
			cmbEinheit.setSelectedItem(ki.getEinheitsItem());
			txtBemerkungen.setText(ki.getBemerkungen());
			dtStart.setStartDate(ki.getStartDate());
			dtEnde.setStartDate(ki.getEndDate());
		}
	}
	
	private void toItem() {
		if(ki != null) {
			if(ki.getRezeptur() != 0) {
				ki.setMenge(txtMenge.getValue());
				if(ki.getMenge()>0) {
					ki.setStartDate(dtStart.getDate());
					ki.setEndDate(dtEnde.getDate());
					if(ki.getEndDate().after(ki.getStartDate())){
						ki.setBemerkungen(txtBemerkungen.getText().trim());
						ki.setEinheit( ((EinheitsItem)cmbEinheit.getSelectedItem()).getID());
						ki.setAdresseText(txtFirma.getText().trim());
						if(btTypEinkauf.isSelected()) {
							ki.setTyp(DBKontrakte.KONTRAKT_EINKAUF);
						}else {
							ki.setTyp(DBKontrakte.KONTRAKT_VERKAUF);
						}
						int ok = rz.getDatabase().getKontrakte().saveKontrakt(ki);
						if(ok >0) {
							origin.getMessage(new MessageItem(MessageItem.MSG_EDIT_KONTRAKT_REPLY,ki.getId(),ki,this));
			            	rz.getFensterFactory().getFensterListe().propagateBestand(this,ki.getRezeptur());
							closeWindow();
						}
					}else {
						displayError(ERROR_DATUM);
					}
				}else {
					displayError(ERROR_MENGE);
				}
			}else {
				displayError(ERROR_REZEPTUR);
			}
		}
	}
	
	private void displayError(int error ) {
        DialogItem dlgItem = new DialogItem(0,"",0.0,"","","","","","",null);       
        dlgItem.setTyp(DialogControl.HINWEIS_DIALOG);
        dlgItem.setCaption(rz.getLocale().getString("kontraktauswahl.error_dialog"));
        dlgItem.setIcon("warnung.png");
        dlgItem.setOk(rz.getLocale().getString("string_ok"));
		switch (error) {
			case ERROR_REZEPTUR:
		        dlgItem.setTitel(rz.getLocale().getString("kontrakteingabe.error_rezeptur"));
		        dlgItem.setMessage(rz.getLocale().getString("kontrakeingabe.error_rezeptur_message"));
				break;
			case ERROR_MENGE:
		        dlgItem.setTitel(rz.getLocale().getString("kontrakteingabe.error_menge"));
		        dlgItem.setMessage(rz.getLocale().getString("kontrakteingabe.error_menge_message"));
				break;
			case ERROR_DATUM:
		        dlgItem.setTitel(rz.getLocale().getString("kontrakteingabe.datum_rezeptur"));
		        dlgItem.setMessage(rz.getLocale().getString("kontrakteingabe.error_datum_message"));
				break;
		}
        rz.getDialogFactory().getDialog(dlgItem);
	}
	
	private void showZutatenDialog(String aZutat) {
		int x, y;
		x = (int) (btRezeptur.getLocationOnScreen().getX());
		y = (int) (btRezeptur.getLocationOnScreen().getY());
		if(ki != null) {
			zdRezeptur = ki.getRezeptur();
		}
		if (zd != null) {
			zd.dispose();
			zd = null;
		}
		if(rz.isMain()) {
			zd = new ZutatenDialog(this, rz, x, y, aZutat,ZutatenDialog.MODE_REZEPTUREN);
		}else {
			zd = new ZutatenDialog(this, rz, x, y, aZutat,ZutatenDialog.MODE_FERTIGWAREN_AUSWAHL);
		}
		zd.setVisible(true);
	}
	
	  private void zutatenDialogReply(ZutatenSuchItem zi) {
		if (zi != null) {
			try {
				if(ki != null) {
					ki.setRezeptur(zi.getID());
					ki.setNameString(zi.getName());
					setRezepturLabel(ki.getName());
				}
			} catch (final Exception e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_WARN,"rezeptur.zutatenDialogReply.CatchAll:",e.getLocalizedMessage());
			}
		}
		if (zd != null) {
			zd.dispose();
			zd = null;
		}
		setAdresse();
	}
  
	private void setAdresse() {
		cmbAdressen.removeAllItems();
		if(ki != null && ki.getRezeptur() != 0) {
			txtFirma.setText(ki.getAdresseText());
			RezepturItem ri = rz.getDatabase().getRezeptur().dbGetRezeptur(ki.getRezeptur(), true);
			if(ri.getAdressListe().size()>0) {
				for(int i =0;i<ri.getAdressListe().size();i++) {
					final StichwortItem si= (StichwortItem)ri.getAdressListe().get(i);
					cmbAdressen.addItem(rz.getDatabase().getAdressen().dbGetAdresse(si.getID(),true));
				}
			}
			if((cmbAdressen.getModel().getSize() > 0) && (ki.getAdresse_id() != 0)) {
	         	for(int i=0;i < cmbAdressen.getModel().getSize();i++) {
	         		AdressItem ai = (AdressItem)cmbAdressen.getItemAt(i);
	         		if(ai.getID() == ki.getAdresse_id()) {
	         			adresseFill = false;
	         			cmbAdressen.setSelectedIndex(i);
	         			break;
	         		}
	         	}
	         }
		}
	}
    /*
     * Die Adresse wurde gewechselt
     *
     */
    private void adressWechsel() {
    	if(!adresseFill) {
	    	if(cmbAdressen.getSelectedIndex() != -1) {
		    	final AdressItem ai = (AdressItem)cmbAdressen.getSelectedItem();
		    	if (ai != null) {
		    		txtFirma.setText(ai.getVorname() + " " + ai.getNachname() + ", " + ai.getFirma() + ", " + ai.getOrt());
		    		rz.getAusgabeFactory().adressAusgabe(ai.getID(),txtAdressen);
		    		if(ki != null) {
		    			ki.setAdresse_id(ai.getID());
		    			ki.setAdresseText(txtFirma.getText());
		    		}
	
		    	}
	    	}
	}
    }
	  
	  
}
