/*
 * Created on 20.09.2004
 *
 */
package de.lunqual.rzpro.fenster.lieferscheinfenster;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;

import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.JCheckBox;
import javax.swing.ListSelectionModel;
import javax.swing.SwingConstants;
import javax.swing.border.BevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.ausgabe.ReportFactory;
import de.lunqual.rzpro.database.DBBuchung;
import de.lunqual.rzpro.fenster.JNumberField;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fenster.JSelectedTextField;
import de.lunqual.rzpro.fenster.ZutatenDialog;
import de.lunqual.rzpro.fenster.buchungsfenster.StatistikFenster;
import de.lunqual.rzpro.fenster.dialoge.BuchungsDialog;
import de.lunqual.rzpro.fenster.dialoge.DialogControl;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.adressen.AdressItem;
import de.lunqual.rzpro.items.bewertungen.BewertungsItem;
import de.lunqual.rzpro.items.buchung.BuchungsItem;
import de.lunqual.rzpro.items.buchung.LosnummerItem;
import de.lunqual.rzpro.items.buchung.herstellungReturnItem;
import de.lunqual.rzpro.items.container.ContainerItem;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.items.ergebnis.ErgebnisItem;
import de.lunqual.rzpro.items.lieferschein.LieferscheinAuftrag;
import de.lunqual.rzpro.items.lieferschein.LieferscheinItem;
import de.lunqual.rzpro.items.lieferschein.LieferscheinProbe;
import de.lunqual.rzpro.items.lieferschein.LieferscheinZeile;
import de.lunqual.rzpro.items.lieferschein.LosnummerReihenItem;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.rechnen.RechenItem;
import de.lunqual.rzpro.items.report.ReportItem;
import de.lunqual.rzpro.items.rezeptur.EanItem;
import de.lunqual.rzpro.items.rezeptur.RezepturItem;
import de.lunqual.rzpro.items.rezeptur.SteuerDatenItem;
import de.lunqual.rzpro.items.rezeptur.ZutatenSuchItem;
import de.lunqual.rzpro.options.OptionFactory;
/**
 * @author labor
 *
 */
public class LieferscheinFenster extends JRzFrame implements TableColumnModelListener {

    private JMenuBar	mb;
	private JMenu mnuDatei;
	private JMenu mnuBearbeiten;
	private JMenu mnuExtras;
	private JMenu mnuFenster;
	private JMenu mnuHilfe;
	JPopupMenu mnuBuchen;
	JPopupMenu mnuRechnen;
	private JPanel mainPanel;
		private JPanel contentPanel;
			private JPanel tbPanel;
				private JToolBar tb1;
			private JPanel northPanel;
				private JPanel northEastPanel;
					private JLabel lblNummerTitel;
					private JLabel lblNummer;
				private JPanel northWestPanel;
					private JLabel lblAdresseTitel;
					private JSelectedTextField txtAdresse;
					private JPanel adressButtonPanel;
						private JButton btAdresse;
						private JButton btAdresseEntfernen;
				private JLabel lblAdresse;
			private JPanel centerPanel;

				private JPanel centerNorthPanel;
				private JLabel lblMessage;
					private JPanel centerMainPanel;
	    				private JPanel rezepturPanel;
	    					private JButton btRezeptur;
	    					private JLabel lblRezeptur;
	    					private JLabel lblRezepturTitel;
	    					private JSelectedTextField txtRezeptur;
	    					private JLabel lblStaerke;
	    					private JNumberField txtStaerke;
	    					private JLabel lblLitergewicht;
	    					private JNumberField txtLitergewicht;
	    				private JPanel eingabePanel;
	    					private JPanel felderPanel;
		    					private JLabel lblContainer;
		    					private JSelectedTextField txtContainer;
		    					private JLabel lblBrutto;
		    					private JNumberField txtBrutto;
		    					private JLabel lblTara;
		    					private JNumberField txtTara;
		    					private JLabel lblFlaschen;
		    						private JPanel txtFlaschenPanel;
		    							private JSelectedTextField txtFlaschen;
		    							private JButton btFlaschenLosnummer;
		    					private JLabel lblDeckel;
		    						private JPanel txtDeckelPanel;
		    							private JSelectedTextField txtDeckel;
		    							private JButton btDeckelLosnummer;
		    					private JLabel lblBemerkungen;
		    					private JSelectedTextField txtBemerkungen;
		    					private JLabel lblEan;
		    					private JPanel EanPanel;
		    						private JSelectedTextField txtEan;
		    						private JPanel eanCMBPanel;
		    							private JComboBox cmbEan;
		    							private JButton btSaveEAN;
		    					private JPanel ergebnisPanel;
		    					private JLabel lblErgebnis;
		    				private JPanel tableButtonPanel;
		    					private JButton btUebernehmen;
		    					private JButton btBlattLoeschen;
		    					private JButton btPostenVerbuchen;
		    					private JButton btAbgang;
		    					private JButton btPostenLoeschen;
		    					private JButton btProbeNeu;
		    					private JButton btProbenverzeichnis;
		    					private JButton btBerechnen;

				private JPanel tablePanel;
					private JScrollPane scrTable;
						private JTable tblLieferschein;


			private JPanel buttonPanel;
				private JButton btSave;
				private JComboBox cmbFormulare;
				private JButton btDrucken;
				private JPanel etikettendruckPanel;
					private JButton btEtikettenDrucken;
				private JPanel musterPanel;
					private JCheckBox chkAbfuelltag;
				private JButton btHilfe;
				private JButton btClose;

	public static final int 			ACTION_SCHLIESSEN_CODE = 1000;
	public static final String 		ACTION_SCHLIESSEN_TEXT = "lieferschein.action_schliessen";
	public static final int         	ACTION_HILFE_CODE  = 1001;
    public static final String     	ACTION_HILFE_TEXT = "action_hilfe";
    public static final int         	ACTION_HIDE_CODE  = 1002;
    public static final String     	ACTION_HIDE_TEXT = "action_hide";
	public static final int 			ACTION_DRUCKEN_CODE = 1005;
	public static final String 		ACTION_DRUCKEN_TEXT = "lieferschein.action_drucken";
	public static final int 			ACTION_SAVE_CODE = 1006;
	public static final String 		ACTION_SAVE_TEXT = "lieferschein.action_speichern";
	public static final int 			ACTION_ADRESSE_CODE = 1007;
	public static final String 		ACTION_ADRESSE_TEXT = "lieferschein.action_adresse";
	public static final int 			ACTION_POSTEN_NEU_CODE = 1008;
	public static final String 		ACTION_POSTEN_NEU_TEXT = "lieferschein.action_posten_neu";
	public static final int 			ACTION_POSTEN_LOESCHEN_CODE = 1009;
	public static final String 		ACTION_POSTEN_LOESCHEN_TEXT = "lieferschein.action_posten_loeschen";
	public static final int 			ACTION_POSTEN_VERBUCHEN_CODE = 1010;
	public static final String 		ACTION_POSTEN_VERBUCHEN_TEXT = "lieferschein.action_buchen";
	public static final int 			ACTION_BLATT_LOESCHEN_CODE = 1011;
	public static final String 		ACTION_BLATT_LOESCHEN_TEXT = "lieferschein.action_blatt_loeschen";
	public static final int 			ACTION_ADRESSE_ENTFERNEN_CODE = 1012;
	public static final String 		ACTION_ADRESSE_ENTFERNEN_TEXT = "lieferschein.action_adresse_entfernen";
    public static final int         	ACTION_EINSTELLUNGSFENSTER_CODE  = 1013;
    public static final String     	ACTION_EINSTELLUNGSFENSTER_TEXT = "auswahl.action_einstellungsfenster";
    public static final int         	ACTION_ETIKETTEN_CODE  = 1014;
    public static final String     	ACTION_ETIKETTEN_TEXT = "lieferschein.action_etikettendruck";
    public static final int 			ACTION_VERSANDBUCHUNG_CODE = 1016;
    public static final String		ACTION_VERSANDBUCHUNG_TEXT = "lieferschein.action_versandbuchung";
    public static final int 			ACTION_HERSTELLBUCHUNG_CODE = 1017;
    public static final String		ACTION_HERSTELLBUCHUNG_TEXT = "lieferschein.action_herstellbuchung";
    public static final int 			ACTION_ABGANG_BUCHEN_CODE = 1018;
    public static final String		ACTION_ABGANG_BUCHEN_TEXT = "lieferschein.action_abgang_verbuchen";

    public static final int 			ACTION_VERSANDBUCHUNG_REST_CODE = 1019;
    public static final String		ACTION_VERSANDBUCHUNG_REST_TEXT = "lieferschein.action_versandbuchung_rest";
    public static final int 			ACTION_HERSTELLBUCHUNG_REST_CODE = 1020;
    public static final String		ACTION_HERSTELLBUCHUNG_REST_TEXT = "lieferschein.action_herstellbuchung_rest";

    public static final int         	ACTION_ZUGANG_CODE  = 1021;
    public static final String     	ACTION_ZUGANG_TEXT = "lieferschein.action_zugang";
    public static final int         	ACTION_ABGANG_CODE  = 1022;
    public static final String     	ACTION_ABGANG_TEXT = "lieferschein.action_abgang";
    public static final int        		ACTION_STATISTIK_CODE  = 1023;
    public static final String     	ACTION_STATISTIK_TEXT = "lieferschein.action_statistik";

    public static final int        		ACTION_HERSTELLBUCH_CODE  = 1024;
    public static final String     	ACTION_HERSTELLBUCH_TEXT = "lieferschein.action_herstellbuch";
    
    public static final int        		ACTION_FLASCHEN_LOSNUMMER_CODE  = 1025;
    public static final String     	ACTION_FLASCHEN_LOSNUMMER_TEXT = "lieferschein.action_flaschen_losnummer";    

    public static final int        		ACTION_DECKEL_LOSNUMMER_CODE  = 1026;
    public static final String     	ACTION_DECKEL_LOSNUMMER_TEXT = "lieferschein.action_deckel_losnummer";    
    
    public static final int         		ACTION_PROBE_NEU_CODE = 1027;
    public static final String     		ACTION_PROBE_NEU_TEXT = "lieferschein.action_neue_probe";
    public static final int         		ACTION_PROBE_CODE = 1028;
    public static final String     		ACTION_PROBE_TEXT = "lieferschein.action_probenverzeichnis";
    
    public static final int         		ACTION_SAVE_EAN_CODE = 1029;
    public static final String     		ACTION_SAVE_EAN_TEXT = "lieferschein.action_save_ean";
    
    

    public static final int 			ACTION_HERSTELLRECHNEN_CODE = 1031;
    public static final String		ACTION_HERSTELLRECHNEN_TEXT = "lieferschein.action_herstellungrechnen";

    public static final int 			ACTION_HERSTELLRECHNEN_REST_CODE = 1033;
    public static final String		ACTION_HERSTELLRECHNEN_REST_TEXT = "lieferschein.action_herstellungrechnen_rest";
	public static final int 			ACTION_POSTEN_RECHNEN_CODE = 1034;
	public static final String 		ACTION_POSTEN_RECHNEN_TEXT = "lieferschein.action_berechnen";
    
	private final static int			RECHNEN_HERSTELLUNG = 0;
	private final static int			RECHNEN_HERSTELLUNG_REST = 2;
    
    public static final int			C_MAX = 13;
	public static final int			C_BEZEICHNUNG=0;
	public static final int			C_NUMMER=1;
	public static final int			C_REIHE=2;
	public static final int			C_LOSNUMMER=3;
	public static final int			C_COMMENT = 4;
	public static final int			C_STAERKE = 5;
	public static final int			C_BRUTTO=6;
	public static final int			C_TARA=7;
	public static final int			C_NETTO =8;
	public static final int			C_LITER=9;
	public static final int			C_LA = 10;
	public static final int			C_BESTAND = 11;
	public static final int			C_EAN = 12;


	LieferscheinItem						li;
	LieferscheinZeile						zeile;
	MessageItem							mi;
	RezepturItem							rezeptur;
	ZutatenDialog							zd;
	DialogItem								dlgItem;
	Color										save1;
	Color										save2 = new Color(200,200,0);
	String										tmpLosnummer;
	BuchungsDialog						bd;
	ArrayList<LosnummerItem> lose = null;
	BewertungsItem						bwi;
	
	
	
    public LieferscheinFenster(RzPro r, String name, Object extendedData) {
    	super(r,name,extendedData);
        dlgItem = new DialogItem(0,"",0.0,"","","","","","",null);
	    mi = new MessageItem(MessageItem.MSG_NULL,0,null,this);
	    rezeptur=null;
        zeile = new LieferscheinZeile(rz);
		createActions();
		createGUIComponents();
		setGUIComponents();
		getMessage((MessageItem)extendedData);
    }

    /* (non-Javadoc)
     * @see de.lunqual.rzpro.fenster.JRzFrame#closeWindow()
     */
    public void closeWindow() {
	        if (zd != null) {
	        	zd.dispose();
	        	zd = null;
	        }
	        rz.getFensterFactory().getFensterListe().disposeFrame(this);
    }

    /* (non-Javadoc)
     * @see de.lunqual.rzpro.fenster.JRzFrame#createActions()
     */
    public void createActions() {
    	actionList.put(String.valueOf(ACTION_HIDE_CODE), new AuswahlAction(rz,this, ACTION_HIDE_CODE,ACTION_HIDE_TEXT, KeyEvent.VK_F5, KeyEvent.SHIFT_DOWN_MASK));
		actionList.put(String.valueOf(ACTION_SCHLIESSEN_CODE), new AuswahlAction(rz,this, ACTION_SCHLIESSEN_CODE,ACTION_SCHLIESSEN_TEXT, KeyEvent.VK_ESCAPE, 0));
		actionList.put(String.valueOf(ACTION_HILFE_CODE), new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT, KeyEvent.VK_F1, 0));
		actionList.put(String.valueOf(ACTION_DRUCKEN_CODE), new AuswahlAction(rz,this,ACTION_DRUCKEN_CODE,ACTION_DRUCKEN_TEXT, KeyEvent.VK_D, KeyEvent.CTRL_DOWN_MASK));
		actionList.put(String.valueOf(ACTION_SAVE_CODE), new AuswahlAction(rz,this,ACTION_SAVE_CODE,ACTION_SAVE_TEXT, KeyEvent.VK_S, KeyEvent.CTRL_DOWN_MASK));
		actionList.put(String.valueOf(ACTION_ADRESSE_CODE), new AuswahlAction(rz,this,ACTION_ADRESSE_CODE,ACTION_ADRESSE_TEXT, KeyEvent.VK_A, KeyEvent.CTRL_DOWN_MASK));
		actionList.put(String.valueOf(ACTION_POSTEN_NEU_CODE), new AuswahlAction(rz,this,ACTION_POSTEN_NEU_CODE,ACTION_POSTEN_NEU_TEXT, KeyEvent.VK_N, KeyEvent.CTRL_DOWN_MASK));
		actionList.put(String.valueOf(ACTION_BLATT_LOESCHEN_CODE), new AuswahlAction(rz,this,ACTION_BLATT_LOESCHEN_CODE,ACTION_BLATT_LOESCHEN_TEXT, KeyEvent.VK_F2,0));
		actionList.put(String.valueOf(ACTION_POSTEN_LOESCHEN_CODE), new AuswahlAction(rz,this,ACTION_POSTEN_LOESCHEN_CODE,ACTION_POSTEN_LOESCHEN_TEXT, 0,0));
		actionList.put(String.valueOf(ACTION_POSTEN_VERBUCHEN_CODE), new AuswahlAction(rz,this,ACTION_POSTEN_VERBUCHEN_CODE,ACTION_POSTEN_VERBUCHEN_TEXT, KeyEvent.VK_V, KeyEvent.CTRL_DOWN_MASK));
		actionList.put(String.valueOf(ACTION_ADRESSE_ENTFERNEN_CODE), new AuswahlAction(rz,this,ACTION_ADRESSE_ENTFERNEN_CODE,ACTION_ADRESSE_ENTFERNEN_TEXT, 0,0));
		actionList.put(String.valueOf(ACTION_EINSTELLUNGSFENSTER_CODE), new AuswahlAction(rz,this, ACTION_EINSTELLUNGSFENSTER_CODE,ACTION_EINSTELLUNGSFENSTER_TEXT, KeyEvent.VK_F12, 0));
		actionList.put(String.valueOf(ACTION_ETIKETTEN_CODE), new AuswahlAction(rz,this,ACTION_ETIKETTEN_CODE,ACTION_ETIKETTEN_TEXT, KeyEvent.VK_E, KeyEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_VERSANDBUCHUNG_CODE),new AuswahlAction(rz,this,ACTION_VERSANDBUCHUNG_CODE,ACTION_VERSANDBUCHUNG_TEXT, KeyEvent.VK_H,KeyEvent.CTRL_DOWN_MASK + KeyEvent.ALT_DOWN_MASK));
		actionList.put(String.valueOf(ACTION_HERSTELLBUCHUNG_CODE), new AuswahlAction(rz,this,ACTION_HERSTELLBUCHUNG_CODE,ACTION_HERSTELLBUCHUNG_TEXT, KeyEvent.VK_V, KeyEvent.CTRL_DOWN_MASK + KeyEvent.ALT_DOWN_MASK));
		actionList.put(String.valueOf(ACTION_ABGANG_BUCHEN_CODE), new AuswahlAction(rz,this,ACTION_ABGANG_BUCHEN_CODE,ACTION_ABGANG_BUCHEN_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_VERSANDBUCHUNG_REST_CODE),new AuswahlAction(rz,this,ACTION_VERSANDBUCHUNG_REST_CODE,ACTION_VERSANDBUCHUNG_REST_TEXT, KeyEvent.VK_H,KeyEvent.CTRL_DOWN_MASK + KeyEvent.ALT_DOWN_MASK + KeyEvent.SHIFT_DOWN_MASK));
		actionList.put(String.valueOf(ACTION_HERSTELLBUCHUNG_REST_CODE), new AuswahlAction(rz,this,ACTION_HERSTELLBUCHUNG_REST_CODE,ACTION_HERSTELLBUCHUNG_REST_TEXT, KeyEvent.VK_V, KeyEvent.CTRL_DOWN_MASK + KeyEvent.ALT_DOWN_MASK + KeyEvent.SHIFT_DOWN_MASK));
		actionList.put(String.valueOf(ACTION_ZUGANG_CODE), new AuswahlAction(rz,this,ACTION_ZUGANG_CODE,ACTION_ZUGANG_TEXT, 0,0));
		actionList.put(String.valueOf(ACTION_ABGANG_CODE), new AuswahlAction(rz,this,ACTION_ABGANG_CODE,ACTION_ABGANG_TEXT, 0,0));	
		actionList.put(String.valueOf(ACTION_STATISTIK_CODE), new AuswahlAction(rz,this,ACTION_STATISTIK_CODE,ACTION_STATISTIK_TEXT, 0,0));	
		actionList.put(String.valueOf(ACTION_HERSTELLBUCH_CODE), new AuswahlAction(rz,this,ACTION_HERSTELLBUCH_CODE,ACTION_HERSTELLBUCH_TEXT, 0,0));	
		actionList.put(String.valueOf(ACTION_DECKEL_LOSNUMMER_CODE), new AuswahlAction(rz,this,ACTION_DECKEL_LOSNUMMER_CODE,ACTION_DECKEL_LOSNUMMER_TEXT, 0,0));			
		actionList.put(String.valueOf(ACTION_FLASCHEN_LOSNUMMER_CODE), new AuswahlAction(rz,this,ACTION_FLASCHEN_LOSNUMMER_CODE,ACTION_FLASCHEN_LOSNUMMER_TEXT, 0,0));	
		actionList.put(String.valueOf(ACTION_PROBE_NEU_CODE), new AuswahlAction(rz,this,ACTION_PROBE_NEU_CODE,ACTION_PROBE_NEU_TEXT, 0,0));			
		actionList.put(String.valueOf(ACTION_PROBE_CODE), new AuswahlAction(rz,this,ACTION_PROBE_CODE,ACTION_PROBE_TEXT, 0,0));	
		actionList.put(String.valueOf(ACTION_SAVE_EAN_CODE), new AuswahlAction(rz,this,ACTION_SAVE_EAN_CODE,ACTION_SAVE_EAN_TEXT, 0,0));	
		
		actionList.put(String.valueOf(ACTION_HERSTELLRECHNEN_CODE), new AuswahlAction(rz,this,ACTION_HERSTELLRECHNEN_CODE,ACTION_HERSTELLRECHNEN_TEXT, 0,0));
		actionList.put(String.valueOf(ACTION_HERSTELLRECHNEN_REST_CODE), new AuswahlAction(rz,this,ACTION_HERSTELLRECHNEN_REST_CODE,ACTION_HERSTELLRECHNEN_REST_TEXT, 0,0));
		actionList.put(String.valueOf(ACTION_POSTEN_RECHNEN_CODE), new AuswahlAction(rz,this,ACTION_POSTEN_RECHNEN_CODE,ACTION_POSTEN_RECHNEN_TEXT, 0,0));

    }

    /* (non-Javadoc)
     * @see de.lunqual.rzpro.fenster.JRzFrame#createGUIComponents()
     */
    public void createGUIComponents() {
     	mb = new javax.swing.JMenuBar();
    	mnuDatei = new javax.swing.JMenu();
    	mnuBearbeiten = new JMenu();
    	mnuExtras = new JMenu();
    	mnuFenster = new JMenu();
    	mnuHilfe = new JMenu();
    	mb.add(mnuDatei);
    	mb.add(mnuBearbeiten);
    	mb.add(mnuExtras);
    	mb.add(mnuFenster);
    	mb.add(mnuHilfe);
        setJMenuBar(mb);
        mnuBuchen=new JPopupMenu();
        mnuRechnen = new JPopupMenu();
        mainPanel = new JPanel(new BorderLayout());
	        contentPanel = new JPanel(new BorderLayout());
			//Toolbar
			tb1 = new javax.swing.JToolBar();
			tb1.setFloatable(false);
			tb1.setRollover(true);
			//Panels & buttons...
				tbPanel = new JPanel(new BorderLayout());
				tbPanel.add(tb1,BorderLayout.CENTER);
			mainPanel.add(tbPanel,BorderLayout.NORTH);
				northPanel = new JPanel(new BorderLayout());
					northWestPanel=new JPanel(new GridLayout(1,2));
						lblNummerTitel=new JLabel();
						northWestPanel.add(lblNummerTitel);
						lblNummer =new JLabel();
						lblNummer.setHorizontalAlignment(SwingConstants.LEADING);
						northWestPanel.add(lblNummer);
					northPanel.add(northWestPanel,BorderLayout.WEST);

					northEastPanel=new JPanel(new BorderLayout());
						lblAdresseTitel = new JLabel();
						lblAdresseTitel.setHorizontalAlignment(SwingConstants.TRAILING);
						northEastPanel.add(lblAdresseTitel,BorderLayout.WEST);
						txtAdresse = new JSelectedTextField();
			  	        txtAdresse.addKeyListener(new java.awt.event.KeyAdapter() {
			  	            public void keyReleased(java.awt.event.KeyEvent evt) {
			  	                	setActions();
			  	            	}
			  	        	});
						txtAdresse.setColumns(20);
						northEastPanel.add(txtAdresse,BorderLayout.CENTER);
						adressButtonPanel=new JPanel(new GridLayout(1,2));
							btAdresse = new JButton();
							adressButtonPanel.add(btAdresse);
							btAdresseEntfernen = new JButton();
							adressButtonPanel.add(btAdresseEntfernen);
						northEastPanel.add(adressButtonPanel,BorderLayout.EAST);
					northPanel.add(northEastPanel,BorderLayout.EAST);

					lblAdresse = new JLabel();
						lblAdresse.setHorizontalAlignment(SwingConstants.CENTER);
						lblAdresse.setBorder(BorderFactory.createBevelBorder(BevelBorder.LOWERED));
					northPanel.add(lblAdresse,BorderLayout.SOUTH);
					northPanel.setBorder(BorderFactory.createBevelBorder(BevelBorder.RAISED));
				contentPanel.add(northPanel,BorderLayout.NORTH);

				centerPanel = new JPanel(new BorderLayout());

				  centerNorthPanel = new JPanel(new BorderLayout());
	            	lblMessage = new JLabel();
	            		lblMessage.setHorizontalAlignment(SwingConstants.CENTER);
	            	centerNorthPanel.add(lblMessage,BorderLayout.NORTH);
	            	centerMainPanel = new JPanel(new BorderLayout());
	            		rezepturPanel = new JPanel(new GridLayout(4,2));
							btRezeptur = new JButton();
				       	     btRezeptur.addActionListener(new ActionListener() {
				  	            public void actionPerformed(ActionEvent evt) {
				  	            		selectRezeptur();
				  	            	}
				  	        	});
				  	        btRezeptur.addKeyListener(new java.awt.event.KeyAdapter() {
				  	            public void keyReleased(java.awt.event.KeyEvent evt) {
				  	                	if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
				  	                	    selectRezeptur();
				  	                	}
				  	            	}
				  	        	});
							rezepturPanel.add(btRezeptur);
							lblRezeptur = new JLabel();
							rezepturPanel.add(lblRezeptur);
							lblRezepturTitel=new JLabel();
								lblRezepturTitel.setHorizontalAlignment(SwingConstants.TRAILING);
							rezepturPanel.add(lblRezepturTitel);
							txtRezeptur = new JSelectedTextField();
								txtRezeptur.setColumns(20);
							rezepturPanel.add(txtRezeptur);
							lblStaerke = new JLabel();
								lblStaerke.setHorizontalAlignment(SwingConstants.TRAILING);
							rezepturPanel.add(lblStaerke);
							txtStaerke =new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_STAERKE),0,0,99.99999);
								txtStaerke.setColumns(6);
								txtStaerke.addFocusListener(new FocusListener() {
								    public void focusGained(FocusEvent evt) {}
									public void focusLost(FocusEvent evt) {
										rechnen();
									}
						    	});
					            txtStaerke.addKeyListener(new java.awt.event.KeyAdapter() {
					                public void keyReleased(java.awt.event.KeyEvent evt) {
					                    if(evt.getKeyCode()==KeyEvent.VK_ENTER) {
					                      rechnen();
					                    }
					                }
					            });
							rezepturPanel.add(txtStaerke);
							lblLitergewicht = new JLabel();
							lblLitergewicht.setHorizontalAlignment(SwingConstants.TRAILING);
							rezepturPanel.add(lblLitergewicht);
							txtLitergewicht =new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_LITERGEWICHT),0,0,Double.POSITIVE_INFINITY);
								txtLitergewicht.setColumns(10);
								txtLitergewicht.addFocusListener(new FocusListener() {
								    public void focusGained(FocusEvent evt) {}
								    public void focusLost(FocusEvent evt) {
									rechnen();
								}
					    	});
					            txtLitergewicht.addKeyListener(new java.awt.event.KeyAdapter() {
					                public void keyReleased(java.awt.event.KeyEvent evt) {
					                    if(evt.getKeyCode()==KeyEvent.VK_ENTER) {
					                        rechnen();
					                    }
					                }
					            });
						rezepturPanel.add(txtLitergewicht);

	            		centerMainPanel.add(rezepturPanel,BorderLayout.NORTH);
	            		eingabePanel = new JPanel(new BorderLayout());

							felderPanel = new JPanel(new GridLayout(7,2));
								lblContainer=new JLabel();
									lblContainer.setHorizontalAlignment(SwingConstants.TRAILING);
						       felderPanel.add(lblContainer);
						       txtContainer = new JSelectedTextField();
						       		txtContainer.setColumns(10);
									txtContainer.addFocusListener(new FocusListener() {
									    public void focusGained(FocusEvent evt) {}
										public void focusLost(FocusEvent evt) {
											selectContainer();
										}
							    	});
						            txtContainer.addKeyListener(new java.awt.event.KeyAdapter() {
						                public void keyReleased(java.awt.event.KeyEvent evt) {
						                    if(evt.getKeyCode()==KeyEvent.VK_ENTER) {
						                       selectContainer();
						                    }
						                }
						            });
						       	felderPanel.add(txtContainer);
						       	lblBrutto = new JLabel();
						       		lblBrutto.setHorizontalAlignment(SwingConstants.TRAILING);
						       	felderPanel.add(lblBrutto);
						       	txtBrutto =new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_NORMAL),0,0,Double.POSITIVE_INFINITY);
						       		txtBrutto.setColumns(12);
									txtBrutto.addFocusListener(new FocusListener() {
									    public void focusGained(FocusEvent evt) {}
										public void focusLost(FocusEvent evt) {
											rechnen();
										}
							    	});
						            txtBrutto.addKeyListener(new java.awt.event.KeyAdapter() {
						                public void keyReleased(java.awt.event.KeyEvent evt) {
						                    if(evt.getKeyCode()==KeyEvent.VK_ENTER) {
						                      rechnen();
						                    }
						                }
						            });
						       	felderPanel.add(txtBrutto);
						       	
						       	lblTara = new JLabel();
						       		lblTara.setHorizontalAlignment(SwingConstants.TRAILING);
						       	felderPanel.add(lblTara);
						       	txtTara =new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_NORMAL),0,0,Double.POSITIVE_INFINITY);
					       			txtTara.setColumns(12);
									txtTara.addFocusListener(new FocusListener() {
									    public void focusGained(FocusEvent evt) {}
										public void focusLost(FocusEvent evt) {
											rechnen();
										}
							    	});
						            txtTara.addKeyListener(new java.awt.event.KeyAdapter() {
						                public void keyReleased(java.awt.event.KeyEvent evt) {
						                    if(evt.getKeyCode()==KeyEvent.VK_ENTER) {
						                       rechnen();
						                    }
						                }
						            });
					       		felderPanel.add(txtTara);
					       		
					       		
						       	lblFlaschen = new JLabel();
					       		lblFlaschen.setHorizontalAlignment(SwingConstants.TRAILING);
					       		felderPanel.add(lblFlaschen);
					       			txtFlaschenPanel = new JPanel(new GridLayout(1,2));
									       txtFlaschen = new JSelectedTextField();
								       		txtFlaschen.setColumns(10);
											txtFlaschen.addFocusListener(new FocusListener() {
											    public void focusGained(FocusEvent evt) {}
												public void focusLost(FocusEvent evt) {
												}
									    	});
								            txtFlaschen.addKeyListener(new java.awt.event.KeyAdapter() {
								                public void keyReleased(java.awt.event.KeyEvent evt) {
								                    if(evt.getKeyCode()==KeyEvent.VK_ENTER) {
								                    }
								                }
								            });
								        txtFlaschenPanel.add(txtFlaschen);
								        btFlaschenLosnummer = new JButton();
								        txtFlaschenPanel.add(btFlaschenLosnummer);
						       		felderPanel.add(txtFlaschenPanel);
					       		
						       	lblDeckel = new JLabel();
					       		lblDeckel.setHorizontalAlignment(SwingConstants.TRAILING);
					       		felderPanel.add(lblDeckel);
					       			txtDeckelPanel=new JPanel(new GridLayout(1,2));
					       			
									       txtDeckel = new JSelectedTextField();
								       		txtDeckel.setColumns(10);
											txtDeckel.addFocusListener(new FocusListener() {
											    public void focusGained(FocusEvent evt) {}
												public void focusLost(FocusEvent evt) {
												}
									    	});
								            txtDeckel.addKeyListener(new java.awt.event.KeyAdapter() {
								                public void keyReleased(java.awt.event.KeyEvent evt) {
								                    if(evt.getKeyCode()==KeyEvent.VK_ENTER) {
								                    }
								                }
								            });
								     txtDeckelPanel.add(txtDeckel);
								     btDeckelLosnummer = new JButton();
								     txtDeckelPanel.add(btDeckelLosnummer);
					       		felderPanel.add(txtDeckelPanel);
					            
						       	lblBemerkungen = new JLabel();
						       		lblBemerkungen.setHorizontalAlignment(SwingConstants.TRAILING);
						       	felderPanel.add(lblBemerkungen);
					       		
							       txtBemerkungen = new JSelectedTextField();
						       		txtBemerkungen.setColumns(10);
									txtBemerkungen.addFocusListener(new FocusListener() {
									    public void focusGained(FocusEvent evt) {}
										public void focusLost(FocusEvent evt) {
										}
							    	});
						            txtBemerkungen.addKeyListener(new java.awt.event.KeyAdapter() {
						                public void keyReleased(java.awt.event.KeyEvent evt) {
						                    if(evt.getKeyCode()==KeyEvent.VK_ENTER) {
						                    }
						                }
						            });
						       	felderPanel.add(txtBemerkungen);
						       	
						       	lblEan = new JLabel();
						       		lblEan.setHorizontalAlignment(SwingConstants.TRAILING);
						       	felderPanel.add(lblEan);
						       		EanPanel = new JPanel(new BorderLayout());
					       				txtEan = new JSelectedTextField();
					       				
					       				txtEan.getDocument().addDocumentListener(new DocumentListener() {
					       				  public void changedUpdate(DocumentEvent e) {
					       				    warn();
					       				  }
					       				  public void removeUpdate(DocumentEvent e) {
					       				    warn();
					       				  }
					       				  public void insertUpdate(DocumentEvent e) {
					       				    warn();
					       				  }

					       				  public void warn() {
					       				    if(txtEan.getText().trim().equals("")) {
					       				    	getAction(ACTION_SAVE_EAN_CODE).setEnabled(false);
					       				    } else {
					       				    	if(zeile != null) {
					       				    		if(zeile.getRezeptur() != null) {
					       				    			int id = zeile.getRezeptur().getID();
					       				    			if(id != 0) {
					       				    				getAction(ACTION_SAVE_EAN_CODE).setEnabled(true);	
					       				    			}
					       				    		}
					       				    	}
					       				    }
					       				  }
					       				});
					       				EanPanel.add(txtEan,BorderLayout.CENTER);
					       				
					       				eanCMBPanel = new JPanel(new BorderLayout());
							       			cmbEan = new JComboBox();
							       			cmbEan.addActionListener(new java.awt.event.ActionListener() {
												public void actionPerformed(java.awt.event.ActionEvent evt) {
													EanItem e = (EanItem)cmbEan.getSelectedItem();
													if (e != null) {
														txtEan.setText(e.getEan());
													}
												}
											});
							       			eanCMBPanel.add(cmbEan,BorderLayout.WEST);
							       			btSaveEAN = new JButton();
							       			eanCMBPanel.add(btSaveEAN,BorderLayout.EAST);
							       		EanPanel.add(eanCMBPanel,BorderLayout.EAST);
						       			
						       	felderPanel.add(EanPanel);
						       	
							eingabePanel.add(felderPanel,BorderLayout.NORTH);
							ergebnisPanel = new JPanel(new BorderLayout());
								lblErgebnis = new JLabel();
									lblErgebnis.setHorizontalAlignment(SwingConstants.CENTER);
								ergebnisPanel.add(lblErgebnis,BorderLayout.NORTH);
							eingabePanel.add(ergebnisPanel,BorderLayout.SOUTH);
	            		centerMainPanel.add(eingabePanel,BorderLayout.SOUTH);
	            		centerNorthPanel.add(centerMainPanel,BorderLayout.CENTER);
	            		ergebnisPanel = new JPanel(new BorderLayout());
		        			lblErgebnis = new JLabel();
		        				lblErgebnis.setHorizontalAlignment(SwingConstants.CENTER);
		        			ergebnisPanel.add(lblErgebnis,BorderLayout.NORTH);
							tableButtonPanel = new JPanel(new GridLayout(1,8));
								btUebernehmen = new JButton();
					            btUebernehmen.addKeyListener(new java.awt.event.KeyAdapter() {
					                public void keyReleased(java.awt.event.KeyEvent evt) {
					                    if(evt.getKeyCode()==KeyEvent.VK_ENTER) {
					                      uebernehmenAction();
					                    }
					                }
					            });
								tableButtonPanel.add(btUebernehmen);
								btPostenLoeschen = new JButton();
					            btPostenLoeschen.addKeyListener(new java.awt.event.KeyAdapter() {
					                public void keyReleased(java.awt.event.KeyEvent evt) {
					                    if(evt.getKeyCode()==KeyEvent.VK_ENTER) {
					                      postenLoeschenAction();
					                    }
					                }
					            });
								tableButtonPanel.add(btPostenLoeschen);
								btBlattLoeschen = new JButton();
					            btBlattLoeschen.addKeyListener(new java.awt.event.KeyAdapter() {
					                public void keyReleased(java.awt.event.KeyEvent evt) {
					                    if(evt.getKeyCode()==KeyEvent.VK_ENTER) {
					                      blattLoeschenAction();
					                    }
					                }
					            });
								tableButtonPanel.add(btBlattLoeschen);
								btAbgang = new JButton();
								tableButtonPanel.add(btAbgang);
								
								btProbeNeu=new JButton();
								tableButtonPanel.add(btProbeNeu);
								btProbenverzeichnis=new JButton();
								tableButtonPanel.add(btProbenverzeichnis);
								
								btBerechnen  = new JButton();
								tableButtonPanel.add(btBerechnen);
								
								btPostenVerbuchen = new JButton();
								tableButtonPanel.add(btPostenVerbuchen);
								

							ergebnisPanel.add(tableButtonPanel,BorderLayout.SOUTH);
		        		centerNorthPanel.add(ergebnisPanel,BorderLayout.SOUTH);
	            centerPanel.add(centerNorthPanel,BorderLayout.NORTH);


					tablePanel = new JPanel(new BorderLayout()
					        );
						scrTable = new JScrollPane();
							tblLieferschein = new JTable();
							tblLieferschein.setName("lieferscheinfenster.spalten");
			    			scrTable.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
			    			scrTable.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
							scrTable.setViewportView(tblLieferschein);
							tblLieferschein.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
			    			tblLieferschein.getSelectionModel().addListSelectionListener(new ListSelectionListener() {
			                    public void valueChanged(ListSelectionEvent e) {
			        			        if (!e.getValueIsAdjusting()) {
											return;
										}
			        			        selectionChanged();
			                        }
				    			});
						tablePanel.add(scrTable,BorderLayout.CENTER);
					centerPanel.add(tablePanel,BorderLayout.CENTER);


				contentPanel.add(centerPanel,BorderLayout.CENTER);
				buttonPanel=new JPanel(new GridLayout(1,6));
					btClose = new JButton();
					buttonPanel.add(btClose);
					btSave = new JButton();
					save1=btSave.getBackground();
					buttonPanel.add(btSave);
	    			cmbFormulare = new JComboBox();
    				rz.getDatabase().getReport().dbGetReportListeCombo(cmbFormulare,ReportFactory.REPORT_TYPE_LIEFERSCHEIN);
	        	    cmbFormulare.addActionListener(new ActionListener() {
        	        	public void actionPerformed(ActionEvent evt) {
        	        		if(cmbFormulare.getSelectedIndex() != -1) {
        	        		    rz.getOptionFactory().setOption("report.lieferschein",((ReportItem)cmbFormulare.getSelectedItem()).getID());
        	        		    rz.getOptionFactory().saveOptions();
        	        		    }
        	        		}
	        	    	});
	        	    buttonPanel.add(cmbFormulare);
					btDrucken = new JButton();
					buttonPanel.add(btDrucken);
					etikettendruckPanel = new JPanel(new BorderLayout());
						btEtikettenDrucken = new JButton();
						etikettendruckPanel.add(btEtikettenDrucken,BorderLayout.NORTH);
						musterPanel=new JPanel(new BorderLayout());

							
						etikettendruckPanel.add(musterPanel,BorderLayout.CENTER);
						chkAbfuelltag = new JCheckBox();
						chkAbfuelltag.addActionListener(new ActionListener() {
			  	            public void actionPerformed(ActionEvent evt) {
			  	            		if(chkAbfuelltag.isSelected()) {
			  	            			rz.getOptionFactory().setOption("lieferschein.abfuelltag",1);
			  	            		}else {
			  	            			rz.getOptionFactory().setOption("lieferschein.abfuelltag",0);
			  	            		}
			  	            		rz.getOptionFactory().saveOptions();
			  	            	}
			  	        	});
						etikettendruckPanel.add(chkAbfuelltag,BorderLayout.SOUTH);
					buttonPanel.add(etikettendruckPanel);
					btHilfe = new JButton();
					buttonPanel.add(btHilfe);
				contentPanel.add(buttonPanel,BorderLayout.SOUTH);
			mainPanel.add(contentPanel,BorderLayout.CENTER);
			this.getContentPane().setLayout(new BorderLayout());
			this.getContentPane().add(mainPanel,BorderLayout.CENTER);
			this.setFocusTraversalPolicy(new focusListe());
    }

    private void saveToggle(boolean s) {
    	//s=true Muss gespeichert werden
    	//s=false ist schon gespeichert
    	if(s) {
    		btSave.setBackground(save2);
    	}else {
    		btSave.setBackground(save1);
    	}
    }
    
    /* (non-Javadoc)
     * @see de.lunqual.rzpro.fenster.JRzFrame#getMessage(de.lunqual.rzpro.items.MessageItem)
     */
    public void getMessage(MessageItem msg) {
        switch(msg.getMsgCode()) {
    	case MessageItem.MSG_ACTIONPERFORMED:
            switch(msg.getCode()){
            case ACTION_HILFE_CODE: hilfeAction();break;
            case ACTION_HIDE_CODE:hideAction();break;
            case ACTION_SCHLIESSEN_CODE:closeWindow();break;
            case ACTION_ADRESSE_CODE:saveToggle(true);adresseAction();break;
            case ACTION_ADRESSE_ENTFERNEN_CODE:saveToggle(true);adresseEntfernenAction();break;
            case ACTION_POSTEN_NEU_CODE:saveToggle(true);uebernehmenAction();break;
            case ACTION_BLATT_LOESCHEN_CODE:saveToggle(true);blattLoeschenAction();break;
            case ACTION_POSTEN_LOESCHEN_CODE:saveToggle(true);postenLoeschenAction();break;
            case ACTION_SAVE_CODE:saveAction();break;
            case ACTION_DRUCKEN_CODE:druckenAction();break;
            case ACTION_EINSTELLUNGSFENSTER_CODE:einstellungenAction();break;
            case ACTION_ETIKETTEN_CODE:etikettenDruckAction();break;
            case ACTION_POSTEN_VERBUCHEN_CODE:
	               mnuBuchen.show(this.btPostenVerbuchen,10,10);
	              break;
            case ACTION_POSTEN_RECHNEN_CODE:
            		mnuRechnen.show(this.btBerechnen,10,10);
            	break;
            case ACTION_VERSANDBUCHUNG_CODE: verbuchen(DBBuchung.BUCHUNG_VERSAND);break;
            case ACTION_HERSTELLBUCHUNG_CODE: verbuchen(DBBuchung.BUCHUNG_HERSTELLUNG);break;
            case ACTION_HERSTELLBUCHUNG_REST_CODE: verbuchen(DBBuchung.BUCHUNG_HERSTELLUNG_REST);break;
            
            case ACTION_HERSTELLRECHNEN_CODE:berechnen(RECHNEN_HERSTELLUNG);break;
            case ACTION_HERSTELLRECHNEN_REST_CODE:berechnen(RECHNEN_HERSTELLUNG_REST);break;
            
            case ACTION_ABGANG_BUCHEN_CODE:abgangBuchen();break;
            case ACTION_ABGANG_CODE:abgangAction();break;
            case ACTION_ZUGANG_CODE:zugangAction();break;
            case ACTION_STATISTIK_CODE:statistikAction();break;
            case ACTION_HERSTELLBUCH_CODE:herstellbuchAction();break;
            case ACTION_FLASCHEN_LOSNUMMER_CODE:losnummerAction(true);break;
            case ACTION_DECKEL_LOSNUMMER_CODE:losnummerAction(false);break;
	        case ACTION_PROBE_NEU_CODE:probenNeuAction();break;
	        case ACTION_PROBE_CODE:probenVerzeichnisAction();break;
	        case ACTION_SAVE_EAN_CODE:saveEAN();break;
            }
    	break;
    case MessageItem.MSG_REFRESH_AUSGABE:
    		setSummenZeile();
    		break;
   	 case MessageItem.MSG_ZUTATEN_DIALOG_REPLY:
   	 		zutatenDialogReply((ZutatenSuchItem)msg.getData());
 			break;
      case MessageItem.MSG_SELECT_ADRESSE_REPLY:
          li.setAdresse(msg.getCode());
      	  li.setAi((AdressItem)msg.getData());
      	  txtAdresse.setText(li.getAi().getFirma());
          lblAdresse.setText(li.getAi().getFirma() + ", " +li.getAi().getStrasse() + ", " + li.getAi().getOrt());
          setActions();
          break;
          
      case MessageItem.MSG_REPLY_LOSNMMERVORLAGE_DECKEL:
      		txtDeckel.setText((String)msg.getData());
      		break;
      case MessageItem.MSG_REPLY_LOSNMMERVORLAGE_FLASCHEN:
      		txtFlaschen.setText((String)msg.getData());
      		break;
	  case MessageItem.MSG_EDIT_LIEFERSCHEIN_REQUEST:
	      mi = msg;
	      li = rz.getDatabase().getLieferschein().getLieferschein(mi.getCode(), false);
	      this.setTblRezepturModel(tblLieferschein);
	      if(li != null) {
		      if(msg.getData() != null) {
		          li.setAi((AdressItem)msg.getData());
		          li.setAdresse(li.getAi().getID());
		          lblAdresse.setText(li.getAi().getFirma() + ", " +li.getAi().getStrasse() + ", " + li.getAi().getOrt());
		      } else {
	              lblAdresse.setText(rz.getLocale().getString("lieferschein.label_keine_adresse_festgelegt"));
		      }
	          fromItem();
	      }
	      break;
	  case MessageItem.MSG_REPLY_BUCHUNGSDIALOG:
		  bwi = (BewertungsItem)msg.getData();
		  verbuchen2();
		  break;
        }
    }


    /* (non-Javadoc)
     * @see de.lunqual.rzpro.fenster.JRzFrame#setGUIComponents()
     */
    public void setGUIComponents() {
        setTitle(rz.getVersionString() + " " + rz.getLocale().getString("lieferschein.titel") + " " +rz.getDatabase().getKalender().getDatum20Now());
        rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE);

	    getAction(ACTION_POSTEN_VERBUCHEN_CODE).setEnabled(false);

		mnuDatei.setText(rz.getLocale().getString("menu.datei"));
		mnuBearbeiten.setText(rz.getLocale().getString("menu.bearbeiten"));
		mnuExtras.setText(rz.getLocale().getString("menu.extras"));
        mnuFenster.setText(rz.getLocale().getString("menu.fenster"));
		mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));
		mnuDatei.add(getAction(ACTION_SAVE_CODE));
		mnuDatei.add(getAction(ACTION_DRUCKEN_CODE));
		mnuDatei.add(getAction(ACTION_ETIKETTEN_CODE));
		mnuDatei.addSeparator();
		mnuDatei.add(getAction(ACTION_SCHLIESSEN_CODE));

		mnuBearbeiten.add(getAction(ACTION_POSTEN_NEU_CODE));
		mnuBearbeiten.add(getAction(ACTION_BLATT_LOESCHEN_CODE));
		mnuBearbeiten.add(getAction(ACTION_HERSTELLBUCHUNG_CODE));
		mnuBearbeiten.add(getAction(ACTION_VERSANDBUCHUNG_CODE));
		mnuBearbeiten.add(getAction(ACTION_HERSTELLBUCHUNG_REST_CODE));
		mnuBearbeiten.add(getAction(ACTION_VERSANDBUCHUNG_REST_CODE));
		mnuBearbeiten.addSeparator();
		mnuBearbeiten.add(getAction(ACTION_HERSTELLRECHNEN_CODE));
		mnuBearbeiten.add(getAction(ACTION_HERSTELLRECHNEN_REST_CODE));
		mnuBearbeiten.addSeparator();
		mnuBearbeiten.add(getAction(ACTION_ZUGANG_CODE));
		mnuBearbeiten.add(getAction(ACTION_ABGANG_CODE));
		mnuBearbeiten.add(getAction(ACTION_STATISTIK_CODE));
		mnuBearbeiten.add(getAction(ACTION_HERSTELLBUCH_CODE));
		mnuBearbeiten.addSeparator();
		mnuBearbeiten.add(getAction(ACTION_ABGANG_BUCHEN_CODE));
		mnuBearbeiten.addSeparator();
		mnuBearbeiten.add(getAction(ACTION_PROBE_NEU_CODE));
		mnuBearbeiten.add(getAction(ACTION_PROBE_CODE));
		mnuBearbeiten.addSeparator();
		mnuBearbeiten.add(getAction(ACTION_POSTEN_LOESCHEN_CODE));

		mnuFenster.add(getAction(ACTION_EINSTELLUNGSFENSTER_CODE));

		mnuExtras.add(getAction(ACTION_HIDE_CODE));
		mnuHilfe.add(getAction(ACTION_HILFE_CODE));

		mnuBuchen.add(getAction(ACTION_HERSTELLBUCHUNG_CODE));
		mnuBuchen.add(getAction(ACTION_VERSANDBUCHUNG_CODE));
		mnuBuchen.add(getAction(ACTION_HERSTELLBUCHUNG_REST_CODE));
		mnuBuchen.add(getAction(ACTION_VERSANDBUCHUNG_REST_CODE));
		
		mnuRechnen.add(getAction(ACTION_HERSTELLRECHNEN_CODE));
		mnuRechnen.add(getAction(ACTION_HERSTELLRECHNEN_REST_CODE));
		
		tb1.add(getAction(ACTION_SCHLIESSEN_CODE));
		tb1.add(getAction(ACTION_HIDE_CODE));
		tb1.addSeparator();
		tb1.add(getAction(ACTION_POSTEN_NEU_CODE));
		tb1.add(getAction(ACTION_BLATT_LOESCHEN_CODE));
		tb1.add(getAction(ACTION_POSTEN_VERBUCHEN_CODE));
		tb1.addSeparator();
		tb1.add(getAction(ACTION_SAVE_CODE));
		tb1.add(getAction(ACTION_DRUCKEN_CODE));
		tb1.add(getAction(ACTION_ETIKETTEN_CODE));
		tb1.addSeparator();
		tb1.add(getAction(ACTION_HERSTELLBUCHUNG_CODE));
		tb1.add(getAction(ACTION_VERSANDBUCHUNG_CODE));
		tb1.addSeparator();
		tb1.add(getAction(ACTION_ZUGANG_CODE));
		tb1.add(getAction(ACTION_ABGANG_CODE));
		tb1.add(getAction(ACTION_STATISTIK_CODE));
		tb1.add(getAction(ACTION_HERSTELLBUCH_CODE));
		tb1.addSeparator();
		tb1.add(getAction(ACTION_ABGANG_BUCHEN_CODE));
		tb1.addSeparator();
		tb1.add(getAction(ACTION_PROBE_NEU_CODE));
		tb1.add(getAction(ACTION_PROBE_CODE));
		tb1.addSeparator();
		tb1.add(getAction(ACTION_EINSTELLUNGSFENSTER_CODE));
		tb1.addSeparator();
		tb1.add(getAction(ACTION_HILFE_CODE));
		tb1.addSeparator();

		lblNummerTitel.setText(rz.getLocale().getString("lieferschein.label_nummer"));
		lblAdresseTitel.setText(rz.getLocale().getString("lieferschein.label_adresse"));
        lblAdresse.setText(rz.getLocale().getString("lieferschein.label_keine_adresse_festgelegt"));
		btDrucken.setAction(getAction(ACTION_DRUCKEN_CODE));
		btSave.setAction(getAction(ACTION_SAVE_CODE));
		btHilfe.setAction(getAction(ACTION_HILFE_CODE));
		btClose.setAction(getAction(ACTION_SCHLIESSEN_CODE));
		btAdresse.setAction(getAction(ACTION_ADRESSE_CODE));
		btAdresseEntfernen.setAction(getAction(ACTION_ADRESSE_ENTFERNEN_CODE));
		btEtikettenDrucken.setAction(getAction(ACTION_ETIKETTEN_CODE));
		btUebernehmen.setAction(getAction(ACTION_POSTEN_NEU_CODE));
		btBlattLoeschen.setAction(getAction(ACTION_BLATT_LOESCHEN_CODE));
		btPostenVerbuchen.setAction(getAction(ACTION_POSTEN_VERBUCHEN_CODE));
		btPostenLoeschen.setAction(getAction(ACTION_POSTEN_LOESCHEN_CODE));
		btAbgang.setAction(getAction(ACTION_ABGANG_BUCHEN_CODE));
		btFlaschenLosnummer.setAction(getAction(ACTION_FLASCHEN_LOSNUMMER_CODE));
		btDeckelLosnummer.setAction(getAction(ACTION_DECKEL_LOSNUMMER_CODE));
		btProbenverzeichnis.setAction(getAction(ACTION_PROBE_CODE));
		btProbeNeu.setAction(getAction(ACTION_PROBE_NEU_CODE));
		btSaveEAN.setAction(getAction(ACTION_SAVE_EAN_CODE));
		getAction(ACTION_SAVE_EAN_CODE).setEnabled(false);
		btRezeptur.setText(rz.getLocale().getString("lieferschein.postendialog.rezeptur"));
	        lblStaerke.setText(rz.getLocale().getString("rezeptur.postendialog.staerke"));
	        lblContainer.setText(rz.getLocale().getString("rezeptur.postendialog.container"));
	        lblBrutto.setText(rz.getLocale().getString("rezeptur.postendialog.brutto"));
	        lblTara.setText(rz.getLocale().getString("rezeptur.postendialog.tara"));
	        lblRezepturTitel.setText(rz.getLocale().getString("rezeptur.postendialog.rezepturtitel"));
	        lblLitergewicht.setText(rz.getLocale().getString("rezeptur.postendialog.litergewicht"));
	        lblBemerkungen.setText(rz.getLocale().getString("rezeptur.postendialog.bemerkungen"));
	        lblEan.setText(rz.getLocale().getString("rezeptur.postendialog.ean"));
	        lblFlaschen.setText(rz.getLocale().getString("rezeptur.postendialog.flaschen"));
	        lblDeckel.setText(rz.getLocale().getString("rezeptur.postendialog.deckel"));
	        chkAbfuelltag.setText(rz.getLocale().getString("lieferschein.abfuelltag"));
	        
	        chkAbfuelltag.setSelected(rz.getOptionFactory().getOption("lieferschein.abfuelltag",0)==0?false:true);
	        lblErgebnis.setText(" ");

			btBerechnen.setAction(getAction(ACTION_POSTEN_RECHNEN_CODE));
	        
 	    	getAction(ACTION_HERSTELLBUCHUNG_CODE).setEnabled(false);
 	    	getAction(ACTION_VERSANDBUCHUNG_CODE).setEnabled(false);
 	    	getAction(ACTION_HERSTELLBUCHUNG_REST_CODE).setEnabled(false);
 	    	getAction(ACTION_VERSANDBUCHUNG_REST_CODE).setEnabled(false);
 		   	getAction(ACTION_ABGANG_CODE).setEnabled(false);
 	 	   	getAction(ACTION_ZUGANG_CODE).setEnabled(false);
 	 	   	getAction(ACTION_STATISTIK_CODE).setEnabled(false);
 	 	   	getAction(ACTION_PROBE_NEU_CODE).setEnabled(false);
 		    getAction(ACTION_POSTEN_RECHNEN_CODE).setEnabled(false);
 		    getAction(ACTION_HERSTELLRECHNEN_CODE).setEnabled(false);
 		   	getAction(ACTION_HERSTELLRECHNEN_REST_CODE).setEnabled(false);
 	 	   	
		setResizable(true);
		rz.getFontFactory().setFrameFonts(this);
        pack();
        rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE);
    }

    
    private void saveEAN() {
    	if(zeile != null) {
	    		if(zeile.getRezeptur() != null) {
	    			RezepturItem ri = zeile.getRezeptur();
	    			if(ri != null && ri.getID() != 0) {
	    			        DialogItem dlgItem = new DialogItem(0,"",0.0,"","","","","","",null);
	    				 	dlgItem.setTyp(DialogControl.EINGABE_DIALOG);
	    			        dlgItem.setCaption(rz.getLocale().getString("lieferschein.save_ean_label").replaceAll("%r",ri.getTitel()).replaceAll("%e", txtEan.getText().trim()));
	    			        dlgItem.setTitel(rz.getLocale().getString("lieferschein.save_ean_label").replaceAll("%r",ri.getTitel()).replaceAll("%e", txtEan.getText().trim()));
	    			        dlgItem.setMessage(rz.getOptionFactory().getOption("lieferschein.save_ean_prefix"));
	    			        dlgItem.setIcon("frage.png");
	    			        dlgItem.setOk(rz.getLocale().getString("string_ok"));
	    			        dlgItem.setCancel(rz.getLocale().getString("string_abbrechen"));
	    				 	dlgItem.setOrigin(this);
	    			        rz.getDialogFactory().getDialog(dlgItem);
	    		            if(dlgItem.getReplyCode() == DialogControl.DIALOG_OK) {
	    		            	String out = dlgItem.getContent().trim();
	    		            	if(!out.trim().equals("")) {
	    		            		rz.getDatabase().getRezeptur().updateEAN(ri.getID(), out.trim(), txtEan.getText().trim());
	    		            		rz.getDatabase().getRezeptur().getEanListeCmb(cmbEan,ri.getID());
	    		            	}
	    		            }
	    		            if(dlgItem != null) {
	    		            	dlgItem.dispose();
	    		            }
	    			}
	    		}
	    	}
    }
    
    private void probenNeuAction() {
	   	final int selectedRow=tblLieferschein.getSelectedRow();
    	if(selectedRow != -1) {
		   	final LieferscheinZeile zl = li.getAuftragsListe().getRow(selectedRow);
		   	if(zl != null) {
		   		LieferscheinProbe p=new LieferscheinProbe();;
		   		if(zl.getTyp()==LieferscheinZeile.ZEILE_CONTAINER) {
					ArrayList<LosnummerItem> liste = rz.getDatabase().getBuchungen().getLosNummerListe(zl.getLosnummerReihe(), zl.getRezeptur().getID(), zl.getLiter(),rz.getDatabase().getEinheiten().getLiterItem());
		   			for(int i=0;i<liste.size();i++) {
		   				p.setRezeptur(zl.getRezeptur().getID());
		   				p.setBemerkungen(zl.getComment());
		   				p.setBezeichnung(li.getAuftragsListe().getAuftrag(zl.getUid()).getBezeichnung());
		   				p.setLosnummer(liste.get(i).getLosnummer());
		   				if(!liste.get(i).getLosnummer().equals("")) {
		   					rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_PROBEN_EINGABE, false, new MessageItem(MessageItem.MSG_SHOW_PROBENEINGABE_LIEFERSCHEIN,0,p,this));
		   				}else {
		   				  dlgItem.setTyp(DialogControl.HINWEIS_DIALOG);
		   				  dlgItem.setCaption(rz.getLocale().getString("lieferschein.probe"));
		   				  dlgItem.setTitel(rz.getLocale().getString("lieferschein.probe"));
		   				  dlgItem.setMessage(rz.getLocale().getString("lieferschein.probe_message"));
		   				  dlgItem.setIcon("warnung.png");
		   				  dlgItem.setOk(rz.getLocale().getString("string_ok"));
		   				  rz.getDialogFactory().getDialog(dlgItem);
		   				}
		   			}
		   		}
		   	}
    	}
    }
    
    private void probenVerzeichnisAction() {
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_PROBE,false,new MessageItem(MessageItem.MSG_SHOW_PROBENFENSTER,0,null,this));
    }

    
    
    private void fromItem() {
        lblNummer.setText(rz.getLocale().getString("lieferschein.nummer").replaceAll("%s", li.getNummer()));
        if(li.getAi() != null) {
           	txtAdresse.setText(li.getAi().getFirma());
            lblAdresse.setText(li.getAi().getFirma() + ", " +li.getAi().getStrasse() + ", " + li.getAi().getOrt());
        } else {
            txtAdresse.setText(li.getAdresse_string());
            lblAdresse.setText(rz.getLocale().getString("lieferschein.label_keine_adresse_festgelegt"));
        }
        setActions();
    }


    private void setSummenZeile() {
    	if(li != null) {
			for(int i = 0; i < li.getAuftragsListe().size();i++) {
				LieferscheinAuftrag a = li.getAuftragsListe().getItem(i);
				a.rechnen(); 
			}       
			((AbstractTableModel)tblLieferschein.getModel()).fireTableDataChanged();
    	}
    }
    
   
    
    private String setBemerkungen(String comment) {
    	String ret = "";
    	//fish for flaschennummer
    	int i =comment.indexOf(rz.getLocale().getString("rezeptur.postendialog.flaschen"));
    	 if (i != -1){
    		 String fl = comment.substring(i+ rz.getLocale().getString("rezeptur.postendialog.flaschen").length() +1);
    		 fl=fl.substring(0,fl.indexOf("]"));
    		 txtFlaschen.setText(fl);
    	 } else {
    		 txtFlaschen.setText("");
    	 }
    		 
    		
     	//fish for deckel
    	 i =comment.indexOf(rz.getLocale().getString("rezeptur.postendialog.deckel"));
     	 if (i != -1){
     		 String fl = comment.substring(i + rz.getLocale().getString("rezeptur.postendialog.deckel").length() +1);
     		 fl=fl.substring(0,fl.indexOf("]"));
     		 txtDeckel.setText(fl);
     	 } else {
     		 txtDeckel.setText("");
     	 }
     	 //alles ausserhalb der klammern
     	 if(comment.lastIndexOf("]") != -1) {
     		 ret = comment.substring(comment.lastIndexOf("]") +1);
     	 } else {
     		 ret = comment;
     	 }
    	return ret;
    }
    
    private String getBemerkungen() {
    	String ret = "";
    	if(!txtFlaschen.getText().trim().equals("")) {
    		ret += "[" + rz.getLocale().getString("rezeptur.postendialog.flaschen") + ":" + txtFlaschen.getText().trim()+"]";
    	}
    	if(!txtDeckel.getText().trim().equals("")) {
    		ret += "[" + rz.getLocale().getString("rezeptur.postendialog.deckel") + ":" + txtDeckel.getText().trim()+"]";
    	}
    	ret += txtBemerkungen.getText().trim();
    	return ret;
    }
    
    private void rechnen() {
        String r=" ";
        setActions();
        if(rezeptur != null) {
            if(rezeptur.getExtraktfrei()) {
                txtLitergewicht.setValue(rz.getTafelFactory().LitergewichtTafel(txtStaerke.getValue()));
            } else {
                txtLitergewicht.setValue(rezeptur.getLitergewicht());
            }
        }
        if(rz.isZero(txtLitergewicht.getValue())) {
            txtLitergewicht.setValue(rz.getTafelFactory().LitergewichtTafel(0));
        }
        zeile.setRezeptur(rezeptur);
        zeile.setStaerke(txtStaerke.getValue());
        zeile.setBezeichnung(txtRezeptur.getText().trim());
        zeile.setStaerke(txtStaerke.getValue());
        zeile.setLitergewicht(txtLitergewicht.getValue());
        zeile.setBrutto(txtBrutto.getValue());
        zeile.setTara(txtTara.getValue());
        zeile.setNetto(zeile.getBrutto() - zeile.getTara());
        zeile.setContainerS(txtContainer.getText().trim());
        zeile.setKg(zeile.getNetto());
        zeile.setLiter(zeile.getNetto() * (1/zeile.getLitergewicht()));
        zeile.setComment(getBemerkungen());
        zeile.setEan(txtEan.getText().trim());
        if(!rz.isZero(zeile.getStaerke())){
            zeile.setLa(zeile.getLiter() * (zeile.getStaerke()/100));
        } else {
            zeile.setLa(0);
        }
        if(!rz.isZero(zeile.getNetto())) {
            r= "<html><b><font color=\"blue\">" + rz.getLocale().getString("string_netto") + "  " + rz.getLocale().formatNumber(zeile.getNetto(), OptionFactory.NF_LIEFERSCHEIN) +
            	 rz.getLocale().getString("string_kg") + ",  " +
                rz.getLocale().formatNumber(zeile.getLiter(),OptionFactory.NF_LIEFERSCHEIN) + "  " +  rz.getLocale().getString("string_liter") + ",  " +
                rz.getLocale().formatNumber(zeile.getLa(),OptionFactory.NF_LIEFERSCHEIN) + "  " +  rz.getLocale().getString("string_la") +
                "</b></font></html>";
        } else {
            r = " ";
        }
        if(zeile.getLiter() <= 0){
            getAction(ACTION_POSTEN_NEU_CODE).setEnabled(false);
        } else {
            getAction(ACTION_POSTEN_NEU_CODE).setEnabled(true);
        }
        lblErgebnis.setText(r);
        ((AbstractTableModel)tblLieferschein.getModel()).fireTableDataChanged();
    }

    private RezepturItem getRezeptur(int id) {
    	RezepturItem ret = null;
		final RezepturItem r1 = rz.getDatabase().getRezeptur().dbGetRezeptur(id,true);
		if(r1 != null && r1.getID() != 0) {
			rz.getDatabase().getRezeptur().getEanListeCmb(cmbEan,r1.getID());
			if(r1.getVerweis() != 0) {
				ret = rz.getDatabase().getRezeptur().dbGetRezeptur(r1.getVerweis(),true);
				ret.setAdressListe(r1.getAdressListe());
				ret.setStichwortListe(r1.getStichwortListe());
				ret.setTitel(r1.getTitel());
				ret.setID(r1.getID());
				ret.setVerweis(r1.getVerweis());
			} else {
				ret = r1;
			}
		}
		return ret;
    }

    private void selectRezeptur() {
		int x, y;
		x = (int) (btRezeptur.getLocationOnScreen().getX() );
		y = (int) (btRezeptur.getLocationOnScreen().getY() );
		if(zd != null) {
			zd.dispose();
			zd=null;
		}
		zd = new ZutatenDialog(this, rz, x, y,txtRezeptur.getText().trim(),ZutatenDialog.MODE_REZEPTUREN);
		zd.setVisible(true);
    }

    private void zutatenDialogReply(ZutatenSuchItem zi) {
    	if(zi != null) {
    		rezeptur = getRezeptur(zi.getID());
    		zeile.setRezeptur(rezeptur);
        	zeile.clearZeile();
        	tmpLosnummer="";
    		rezepturSelected();
    	}
    	if(zd != null) {
    		zd.dispose();
    		zd= null;
    	}
    }

    private void  rezepturSelected() {
	    txtRezeptur.setText(rezeptur.getTitel());
	    lblRezeptur.setText(rezeptur.getTitel());
	    txtStaerke.setValue(rezeptur.getStaerke());
	    this.txtBemerkungen.setText("");
	    this.txtBrutto.setValue(0);
	    this.txtTara.setValue(0);
	    this.txtDeckel.setText("");
	    this.txtFlaschen.setText("");
	    this.txtContainer.setText("");
	    this.txtEan.setText("");
	    rechnen();
	    txtContainer.requestFocus();
    }

    private void selectContainer() {
        final ContainerItem ci = rz.getDatabase().getContainer().getContainerString(txtContainer.getText().trim());
        if(ci != null) {
            zeile.setContainer(ci.getID());
            zeile.setContainerS(ci.getName());
            zeile.setTara(ci.getTara());
            txtTara.setValue(ci.getTara());
            txtFlaschen.setText(ci.getName());
        }
    }
    /* (non-Javadoc)
     * @see de.lunqual.rzpro.fenster.JRzFrame#openWindow()
     */
    public void openWindow() {
        if(li != null) {
            setVisible(true);
            toFront();
        } else {
            closeWindow();
        }
    }
    private void setActions() {
    	if(li.getAuftragsListe().size() == 0) {
    		getAction(ACTION_SAVE_CODE).setEnabled(false);
    		getAction(ACTION_DRUCKEN_CODE).setEnabled(false);
    	}
    	else {
    		getAction(ACTION_SAVE_CODE).setEnabled(true);
    		getAction(ACTION_DRUCKEN_CODE).setEnabled(true);
    	}
        if(rezeptur == null) {
            getAction(ACTION_POSTEN_NEU_CODE).setEnabled(false);
            txtRezeptur.setEnabled(false);
            txtStaerke.setEnabled(false);
            txtLitergewicht.setEnabled(false);
            txtContainer.setEnabled(false);
            txtBrutto.setEnabled(false);
            txtTara.setEnabled(false);
            txtBemerkungen.setEnabled(false);
            txtFlaschen.setEnabled(false);
            txtDeckel.setEnabled(false);
            btFlaschenLosnummer.setEnabled(false);
            btDeckelLosnummer.setEnabled(false);
            txtEan.setEnabled(false);
        }else {
            getAction(ACTION_POSTEN_NEU_CODE).setEnabled(true);
            txtRezeptur.setEnabled(true);
            txtStaerke.setEnabled(true);
            txtLitergewicht.setEnabled(true);
            txtContainer.setEnabled(true);
            txtBrutto.setEnabled(true);
            txtTara.setEnabled(true);
            txtBemerkungen.setEnabled(true);
            txtFlaschen.setEnabled(true);
            txtDeckel.setEnabled(true);
            btFlaschenLosnummer.setEnabled(true);
            btDeckelLosnummer.setEnabled(true);
            txtEan.setEnabled(true);
        }
    }
    private void selectionChanged() {
	    getAction(ACTION_POSTEN_VERBUCHEN_CODE).setEnabled(false);
	    getAction(ACTION_HERSTELLBUCHUNG_CODE).setEnabled(false);
 	    getAction(ACTION_VERSANDBUCHUNG_CODE).setEnabled(false);
	   	getAction(ACTION_HERSTELLBUCHUNG_REST_CODE).setEnabled(false);
 	   	getAction(ACTION_VERSANDBUCHUNG_REST_CODE).setEnabled(false);
	    getAction(ACTION_POSTEN_RECHNEN_CODE).setEnabled(false);
	    getAction(ACTION_HERSTELLRECHNEN_CODE).setEnabled(false);
	   	getAction(ACTION_HERSTELLRECHNEN_REST_CODE).setEnabled(false);
	   	getAction(ACTION_ABGANG_CODE).setEnabled(false);
 	   	getAction(ACTION_ZUGANG_CODE).setEnabled(false);
	   	getAction(ACTION_STATISTIK_CODE).setEnabled(false);
	   	getAction(ACTION_PROBE_NEU_CODE).setEnabled(true);
	   	final int selectedRow=tblLieferschein.getSelectedRow();
	   	final LieferscheinZeile zl = li.getAuftragsListe().getRow(selectedRow);
 	   
		//getAction(ACTION_ETIKETTEN_CODE).putValue(AbstractAction.NAME, rz.getLocale().getString("lieferschein.action_etikettendruck"));
		//getAction(ACTION_ETIKETTEN_CODE).putValue(AbstractAction.SHORT_DESCRIPTION, rz.getLocale().getString("lieferschein.action_etikettendruck.1"));
        if(zl != null) {
            switch (zl.getTyp()){
            	case LieferscheinZeile.ZEILE_CONTAINER:
            	    getAction(ACTION_POSTEN_LOESCHEN_CODE).putValue(AbstractAction.NAME, rz.getLocale().getString("lieferschein.action_posten_loeschen"));
        	    	getAction(ACTION_ETIKETTEN_CODE).putValue(AbstractAction.NAME, rz.getLocale().getString("lieferschein.action_etikettendruck_container"));
         	    	getAction(ACTION_ETIKETTEN_CODE).putValue(AbstractAction.SHORT_DESCRIPTION, rz.getLocale().getString("lieferschein.action_etikettendruck_container.1"));
         	    	getAction(ACTION_POSTEN_VERBUCHEN_CODE).setEnabled(false);
         	    	getAction(ACTION_HERSTELLBUCHUNG_CODE).setEnabled(false);
         	    	getAction(ACTION_VERSANDBUCHUNG_CODE).setEnabled(false);
         	    	getAction(ACTION_HERSTELLBUCHUNG_REST_CODE).setEnabled(false);
         	    	getAction(ACTION_VERSANDBUCHUNG_REST_CODE).setEnabled(false);
         		    getAction(ACTION_POSTEN_RECHNEN_CODE).setEnabled(false);
         		    getAction(ACTION_HERSTELLRECHNEN_CODE).setEnabled(false);
         		   	getAction(ACTION_HERSTELLRECHNEN_REST_CODE).setEnabled(false);
         		   	getAction(ACTION_ABGANG_CODE).setEnabled(false);
         	 	   	getAction(ACTION_ZUGANG_CODE).setEnabled(false);
         	 	   	getAction(ACTION_STATISTIK_CODE).setEnabled(false);
         		   	getAction(ACTION_PROBE_NEU_CODE).setEnabled(true);
         	    	rezeptur = getRezeptur(zl.getRezeptur().getID());
            		rezepturSelected();
            		txtContainer.setText(zl.getContainerS());
            		txtBrutto.setValue(zl.getBrutto());
            		txtBemerkungen.setText(setBemerkungen(zl.getComment()));
            		txtEan.setText(zl.getEan().trim()); 
            		tmpLosnummer=zl.getLosnummer();
            		txtTara.setValue(zl.getTara());
            		break;
            	case LieferscheinZeile.ZEILE_SUMME:
               	    getAction(ACTION_POSTEN_LOESCHEN_CODE).putValue(AbstractAction.NAME, rz.getLocale().getString("lieferschein.action_auftrag_loeschen"));
            		getAction(ACTION_ETIKETTEN_CODE).putValue(AbstractAction.NAME, rz.getLocale().getString("lieferschein.action_etikettendruck_auftrag"));
            		getAction(ACTION_ETIKETTEN_CODE).putValue(AbstractAction.SHORT_DESCRIPTION, rz.getLocale().getString("lieferschein.action_etikettendruck_auftrag.1"));
         	    	getAction(ACTION_POSTEN_VERBUCHEN_CODE).setEnabled(true);
         	    	getAction(ACTION_HERSTELLBUCHUNG_CODE).setEnabled(true);
         	    	getAction(ACTION_VERSANDBUCHUNG_CODE).setEnabled(true);
         		    getAction(ACTION_POSTEN_RECHNEN_CODE).setEnabled(true);
         		    getAction(ACTION_HERSTELLRECHNEN_CODE).setEnabled(true);
         		   	getAction(ACTION_HERSTELLRECHNEN_REST_CODE).setEnabled(true);
         		   	getAction(ACTION_PROBE_NEU_CODE).setEnabled(false);
         	    	if(zl.getOpenLiter() > 0 && (zl.getOpenLiter() >= li.getAuftragsListe().getAuftrag(zl.getUid()).getBestand())) {
	         	    	getAction(ACTION_HERSTELLBUCHUNG_REST_CODE).setEnabled(true);
	         	    	getAction(ACTION_VERSANDBUCHUNG_REST_CODE).setEnabled(true);
	         	    	getAction(ACTION_HERSTELLRECHNEN_REST_CODE).setEnabled(true);
         	    	} else {
	         	    	getAction(ACTION_HERSTELLBUCHUNG_REST_CODE).setEnabled(false);
	         	    	getAction(ACTION_VERSANDBUCHUNG_REST_CODE).setEnabled(false);
	         	    	getAction(ACTION_HERSTELLRECHNEN_REST_CODE).setEnabled(false);
         	    	}
         		   	getAction(ACTION_ABGANG_CODE).setEnabled(true);
         	 	   	getAction(ACTION_ZUGANG_CODE).setEnabled(true);
         	 	   	getAction(ACTION_STATISTIK_CODE).setEnabled(true);
            	    break;
            	default:
               	    getAction(ACTION_POSTEN_LOESCHEN_CODE).putValue(AbstractAction.NAME, rz.getLocale().getString("lieferschein.action_nichts_loeschen"));
            		getAction(ACTION_ETIKETTEN_CODE).putValue(AbstractAction.NAME, rz.getLocale().getString("lieferschein.action_etikettendruck"));
            		getAction(ACTION_ETIKETTEN_CODE).putValue(AbstractAction.SHORT_DESCRIPTION, rz.getLocale().getString("lieferschein.action_etikettendruck.1"));
         	    	getAction(ACTION_POSTEN_VERBUCHEN_CODE).setEnabled(false);
         	    	getAction(ACTION_HERSTELLBUCHUNG_CODE).setEnabled(false);
         	    	getAction(ACTION_VERSANDBUCHUNG_CODE).setEnabled(false);
         	    	getAction(ACTION_HERSTELLBUCHUNG_REST_CODE).setEnabled(false);
         	    	getAction(ACTION_VERSANDBUCHUNG_REST_CODE).setEnabled(false);
         		    getAction(ACTION_POSTEN_RECHNEN_CODE).setEnabled(false);
         		    getAction(ACTION_HERSTELLRECHNEN_CODE).setEnabled(false);
         		   	getAction(ACTION_HERSTELLRECHNEN_REST_CODE).setEnabled(false);
         		   	getAction(ACTION_PROBE_NEU_CODE).setEnabled(false);
            	break;
            }
        }
        if(selectedRow >0) {
        	tblLieferschein.setRowSelectionInterval(selectedRow,selectedRow);
        }
    }

    private void losnummerAction(boolean what){
    	//true=flaschen
    	//false=deckel
    	if(what) {
  		   rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_LOSNUMMER_VORLAGE,true,new MessageItem(MessageItem.MSG_SHOW_LOSNUMMERVORLAGE_FLASCHEN, 0,null,this));
    	}else {
  		   rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_LOSNUMMER_VORLAGE,true,new MessageItem(MessageItem.MSG_SHOW_LOSNUMMERVORLAGE_DECKEL, 0,null,this)); 		
    	}
    	
    }
    
    private void herstellbuchAction() {
       String lose="";
 	   final LieferscheinZeile zl = li.getAuftragsListe().getRow(tblLieferschein.getSelectedRow());
       if(zl != null) {
    	   switch (zl.getTyp()) {
    		   case LieferscheinZeile.ZEILE_CONTAINER:
    			   lose = zl.getLosnummer();
    			   break;
    		   case LieferscheinZeile.ZEILE_SUMME:
					java.util.Hashtable t = new java.util.Hashtable();   	
   					LieferscheinAuftrag a = li.getAuftragsListe().getAuftrag(zl.getUid());
   					for(int i = 0; i <a.getZeilenListe().size();i++) {
   						if(a.getZeilenListe().getItem(i).getTyp() == LieferscheinZeile.ZEILE_CONTAINER) {
   						String ls = a.getZeilenListe().getItem(i).getLosnummer().trim();
   						if(!ls.equals("") && !t.contains(ls)) {
   								t.put(ls,ls);
   							}
   						}
   					}
   					Iterator ii = t.keySet().iterator();
   					while(ii.hasNext()) {
   						lose += ii.next() + " ";
   					}
   					break;
    	   }
    	   if(lose.equals("")) {
    		   lose=null;
    	   } else {
			   lose =lose.trim().replaceAll("[ ]+","|");
    	   }
    	   rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HERSTELLUNG,true,new MessageItem(MessageItem.MSG_SHOW_HERSTELLUNG,0,lose,this));
       }else {
      	   rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HERSTELLUNG,true,new MessageItem(MessageItem.MSG_SHOW_HERSTELLUNG,0,null,this));
       }
    }
    
    private void etikettenDruckAction() {
    	   final LieferscheinZeile zl = li.getAuftragsListe().getRow(tblLieferschein.getSelectedRow());
           if(zl != null) {
               switch (zl.getTyp()){
               	case LieferscheinZeile.ZEILE_CONTAINER:
               		zl.etikettenDruck(chkAbfuelltag.isSelected());
               		break;
               	case LieferscheinZeile.ZEILE_SUMME:
               		final LieferscheinAuftrag la = li.getAuftragsListe().getAuftrag(zl.getUid());
               		if(la != null) {
               			la.etikettenDruck(chkAbfuelltag.isSelected());
               		}
               		break;
               	default :
               		li.etikettenDruck(chkAbfuelltag.isSelected());
               		break;
               }
           } else {
           		li.etikettenDruck(chkAbfuelltag.isSelected());
           }
    }

    private boolean abgangFrage() {
    	boolean ret = false;
        dlgItem.setTyp(DialogControl.FRAGE_DIALOG);
        dlgItem.setCaption(rz.getLocale().getString("lieferschein.abgang_frage"));
        dlgItem.setTitel(rz.getLocale().getString("lieferschein.abgang_frage"));
        dlgItem.setMessage(rz.getLocale().getString("lieferschein.abgang_frage_message"));
        dlgItem.setIcon("frage.png");
        dlgItem.setOk(rz.getLocale().getString("string_ja"));
        dlgItem.setCancel(rz.getLocale().getString("string_nein"));
        rz.getDialogFactory().getDialog(dlgItem);
        if ((dlgItem.getReplyCode() == DialogControl.DIALOG_YES) || (dlgItem.getReplyCode() == DialogControl.DIALOG_OK)){
           ret=true;
        } else {
            ret=false;
        }
    	return ret;
    }

    private void abgangBuchen() {
    	if(li.getAuftragsListe().size()>0) {
    		if(abgangFrage()) {
	    		for(int i = 0;i < li.getAuftragsListe().size();i++) {
	    			final LieferscheinAuftrag a = li.getAuftragsListe().getItem(i);
	    			for(int j = 0;j < a.getZeilenListe().size();j++) {
	    				final LieferscheinZeile zl = a.getZeilenListe().getItem(j);
	    				if(zl.getTyp() == LieferscheinZeile.ZEILE_CONTAINER) {
	    					if((zl.getLosnummer() != null) && zl.getLosnummer().equals("")) {
	    						if(!a.isBestandWarnung()) {
	    							ArrayList<LosnummerItem> liste = rz.getDatabase().getBuchungen().getLosNummerListe(zl.getLosnummerReihe(), a.getRezeptur().getID(), zl.getLiter(),rz.getDatabase().getEinheiten().getLiterItem());
	    							if(!rz.getDatabase().getProben().checkProbeOK(liste)) {
	    							 dlgItem.setTyp(DialogControl.HINWEIS_DIALOG);
	 	    	                        dlgItem.setCaption(rz.getLocale().getString("lieferschein.probe_check"));
	 	    	                        dlgItem.setTitel(rz.getLocale().getString("lieferschein.probe_check"));
	 	    	                        dlgItem.setMessage(rz.getLocale().getString("lieferschein.probe_check_message").replaceAll("%s", zl.getRezeptur().getTitel()));
	 	    	                        dlgItem.setIcon("warnung.png");
	 	    	                        dlgItem.setOk(rz.getLocale().getString("string_ok"));
	 	    	                        rz.getDialogFactory().getDialog(dlgItem);
	    							} else {
	    								SteuerDatenItem si = rz.getDatabase().getRezeptur().getSteuerDaten(zl.getRezeptur().getID());
			    						final BuchungsItem bi =  new BuchungsItem(
				                                 rz,
				                                 0,
				                                 DBBuchung.TYP_ABGANG,
				                                 DBBuchung.CODE_ENTNAHME,
												 a.getRezeptur().getLager(),
				                                 0,
				                                 a.getRezeptur().getID(),
				                                 null,//a.getRezeptur().getID()  == 0 ? null : rz.getDatabase().getRezeptur().dbGetRezeptur(a.getRezeptur().getID(),true),
				                                 new Date(),
				                                 rz.getDatabase().dbGetUser(),
				                                 a.getBezeichnung(),
				                                 "",
				                                 zl.getLosnummerReihe(),
				                                 zl.getComment(),
				                                 false,
				                                 false,
				                                 zl.getRezeptur().getBestandseinheit(),
				                                 a.getStaerke(),
				                                 a.getLitergewicht(),
												 -zl.getLiter(),
												 -zl.getKg(),
												 -zl.getLa(),
				                                 0,0,0,
				                                 false,
				                                 true,
				                                 0L,
				                                 0,
				                                 si.getSteuer_artikel(),
				                                 si.getSorte(),
				                                 si.getSteuerlager(),
				                                 si.getStrSorte(),
				                                 si.getStrSteuerlager()
				                         );
				    					rz.getDatabase().getBuchungen().abgangBuchenTransaction(bi);
				    					zl.setLosnummer(bi.getLosnummerListe().toString());
	    							}
	    						} else {
	    	                        dlgItem.setTyp(DialogControl.HINWEIS_DIALOG);
	    	                        dlgItem.setCaption(rz.getLocale().getString("lieferschein.abgang_check"));
	    	                        dlgItem.setTitel(rz.getLocale().getString("lieferschein.abgang_check"));
	    	                        dlgItem.setMessage(rz.getLocale().getString("lieferschein.abgang_check_message").replaceAll("%s",zl.getContainerS()).replaceAll("%r",zl.getBezeichnung()));
	    	                        dlgItem.setIcon("warnung.png");
	    	                        dlgItem.setOk(rz.getLocale().getString("string_ok"));
	    	                        rz.getDialogFactory().getDialog(dlgItem);
	    						}
	    					}
	    				}
	    			}
	    		}
	    		setSummenZeile();
	   			setActions();
	    	}
    	}
    }

    private void statistikAction() {
   	   final LieferscheinZeile zl = li.getAuftragsListe().getRow(tblLieferschein.getSelectedRow());
  	   if(zl.getTyp() == LieferscheinZeile.ZEILE_SUMME) {
  		   final ErgebnisItem ei = new ErgebnisItem(rz,li.getAuftragsListe().getAuftrag(zl.getUid()).getRezeptur().getID());
           rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_STATISTIK,false,new MessageItem(MessageItem.MSG_SHOW_STATISTIK,StatistikFenster.NO_FILTER,ei,this));

  	   }
    }
    
    private void abgangAction() {
  	   final LieferscheinZeile zl = li.getAuftragsListe().getRow(tblLieferschein.getSelectedRow());
  	   if(zl.getTyp() == LieferscheinZeile.ZEILE_SUMME) {
  		   rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_ABGANG,false,new MessageItem(MessageItem.MSG_SHOW_ABGANG, li.getAuftragsListe().getAuftrag(zl.getUid()).getRezeptur().getID(),null,this));
    	}
    }
    
    private void zugangAction() {
   	   final LieferscheinZeile zl = li.getAuftragsListe().getRow(tblLieferschein.getSelectedRow());
	   if(zl.getTyp() == LieferscheinZeile.ZEILE_SUMME) {
  		   rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_ZUGANG,false,new MessageItem(MessageItem.MSG_SHOW_ZUGANG, li.getAuftragsListe().getAuftrag(zl.getUid()).getRezeptur().getID(),null,this));
    	}
    }
    
    
    private void berechnen(int typ) {
    	   final LieferscheinZeile zl = li.getAuftragsListe().getRow(tblLieferschein.getSelectedRow());
	       if(zl != null) {
	    	   double menge=0.0;
	       		if(zl.getTyp() == LieferscheinZeile.ZEILE_SUMME) {
	       			final LieferscheinAuftrag a = li.getAuftragsListe().getAuftrag(zl.getUid());
	       			switch (typ) {
	       				case RECHNEN_HERSTELLUNG:
	       						menge = zl.getLiter();
	       					break;
	       				case RECHNEN_HERSTELLUNG_REST:
	       						menge = zl.getOpenLiter()-a.getBestand();
	       					break;
	       			}
	      			if (menge < 0 )menge=0;
	      			if(zl.getRezeptur().getID() != 0 && menge > 0) {
	      				 final ErgebnisItem ei1 = new ErgebnisItem(
	                        		rz,
	                        		zl.getRezeptur().getID(),
	                        		RzPro.TYP_ID_REZEPT,
	        						zl.getRezeptur().getTitel(),zl.getLitergewicht(),0,zl.getRezeptur().getGeaendert(),	zl.getRezeptur().getStichwortListe().toString(),zl.getRezeptur().getAdressListe().toString(),0,zl.getRezeptur().getBestand(),zl.getRezeptur().getMeldebestand(),false,zl.getRezeptur().getBestandseinheit(),zl.getStaerke(),"","",20,20,false,false);
	                        ei1.setLiter(menge);
	                		rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_RECHNEN,false,new MessageItem(MessageItem.MSG_RECHNEN,0,ei1,this));
	        	        }
	       		}
	       }
    }
    
    private void  verbuchen(int typ) {
    		if(bd != null) {
    			bd.dispose();
    			bd=null;
    		}
	 	   final LieferscheinZeile zl = li.getAuftragsListe().getRow(tblLieferschein.getSelectedRow());
	       if(zl != null) {
	    	   double menge;
	       		if(zl.getTyp() == LieferscheinZeile.ZEILE_SUMME) {
	       			bd = new BuchungsDialog(rz,this);
	       			bd.setModal(false);
	       			final LieferscheinAuftrag a = li.getAuftragsListe().getAuftrag(zl.getUid());
	       			bd.setRezepturID(a.getRezeptur().getID());
	       			bd.setBezeichnung(a.getBezeichnung());
	       			bd.setSchwundsatz(zl.getRezeptur().getSchwundsatz());
	       			bd.setBemerkungen("[" + rz.getLocale().getString("lieferschein.buchung_bemerkungen") + li.getNummer() + "]");
	      			if(typ== DBBuchung.BUCHUNG_HERSTELLUNG_REST || typ== DBBuchung.BUCHUNG_VERSAND_REST) {
	       				menge = zl.getOpenLiter()-a.getBestand();
	       			}else {
	       				menge = zl.getLiter();
	       			}
	      			if (menge < 0 )menge=0;
	      			bd.setMenge(menge);
	       			if(typ==DBBuchung.BUCHUNG_HERSTELLUNG_REST)  typ=DBBuchung.BUCHUNG_HERSTELLUNG;
	       			if(typ==DBBuchung.BUCHUNG_VERSAND_REST)  typ=DBBuchung.BUCHUNG_VERSAND;
	       			bd.setTyp(typ);
	       			String tanks="";
	       			for(int j = 0;j<a.getZeilenListe().size();j++) {
	       				LieferscheinZeile z1=a.getZeilenListe().getItem(j);
	       				if (z1.getTyp() == LieferscheinZeile.ZEILE_CONTAINER) {
	       					tanks+=z1.getContainerS() + ",";
	       				}
	       			}
	       			if(tanks.endsWith(","))tanks=tanks.substring(0,tanks.length()-1);
	   				bd.setTank(tanks);
	   				bd.setRProbe(a.getRezeptur().isRProbe());
	   				bd.setBewertung(a.getRezeptur().isBewertung());
	   				bd.setBewertung(a.getRezeptur().isBewertung());
	       			bd.showDialog();
	       		}
	       }
    }
    
	private void verbuchen2() {
 	   final LieferscheinZeile zl = li.getAuftragsListe().getRow(tblLieferschein.getSelectedRow());
       if(zl != null) {
    	   double menge;
    	   if(bd.getTyp() == DBBuchung.BUCHUNG_HERSTELLUNG  || bd.getTyp() == DBBuchung.BUCHUNG_HERSTELLUNG_REST) {
    		   menge = bd.getMenge();
    	   }else {
    		   menge = bd.getEndmenge();
    	   }
       		if(zl.getTyp() == LieferscheinZeile.ZEILE_SUMME) {
       			final LieferscheinAuftrag a = li.getAuftragsListe().getAuftrag(zl.getUid());
       			if(bd.getCode() == BuchungsDialog.DIALOG_OK) {
       				final RechenItem ri = new RechenItem(rz,a.getRezeptur().getID(),null);
            		ri.setWaehrung( rz.getDatabase().getCurrency().dbGetCurrency(rz.getOptionFactory().getOption("kalkulation.currency",-1),true));
            		ri.setStaerke(a.getStaerke());
            		ri.rechnen(menge,RzPro.EINHEIT_LITER);
            		if(!ri.isBuchungsWarnung()) {
            			final String fl= bd.getFilterschichten().trim().equals("")?"":"[" + rz.getLocale().getString("buchungsdialog.label_filterschichten")  +bd.getFilterschichten() + "]";
            			herstellungReturnItem ok = rz.getDatabase().getBuchungen().herstellungBuchenTransaction(ri,bd.getTyp(),bd.getSchwundsatz(),
            					bd.getEndmenge(),
            					fl +bd.getBemerkungen(),
            					bd.getTank(),bd.isRProbe());
    					if(bwi != null) {
    						bwi.setLosnummer(ok.getLosnummer());
    						rz.getDatabase().getBewertungen().saveBewertungFromHerstellung(bwi);
    					}
                        if((rz.getOptionFactory().getOption("confirm.buchung",OptionFactory.CONFIRM_ZUGANG) == 1) && (ok.isRet())) {
                            dlgItem.setTyp(DialogControl.HINWEIS_DIALOG);
                            dlgItem.setCaption(rz.getLocale().getString("buchung.speichern"));
                            dlgItem.setTitel(rz.getLocale().getString("buchung.speichern"));
                            dlgItem.setMessage(rz.getLocale().getString("buchung.speichern_message")
                                    .replaceAll("%l", rz.getLocale().formatNumber(ri.getGesamtLiter(), OptionFactory.NF_NORMAL))
                                    .replaceAll("%s", ri.getBezeichnung()));
                            dlgItem.setIcon("warnung.png");
                            dlgItem.setOk(rz.getLocale().getString("string_ok"));
                            rz.getDialogFactory().getDialog(dlgItem);
                        }
            		} else {
                        dlgItem.setTyp(DialogControl.HINWEIS_DIALOG);
                        dlgItem.setCaption(rz.getLocale().getString("lieferschein.buchung_check"));
                        dlgItem.setTitel(rz.getLocale().getString("lieferschein.buchung_check"));
                        dlgItem.setMessage(rz.getLocale().getString("lieferschein.buchung_check_message").replaceAll("%s",a.getBezeichnung()));
                        dlgItem.setIcon("warnung.png");
                        dlgItem.setOk(rz.getLocale().getString("string_ok"));
                        rz.getDialogFactory().getDialog(dlgItem);
            		}
       				a.rechnen();
       				((AbstractTableModel)tblLieferschein.getModel()).fireTableDataChanged();
       				setActions();
       	        	rz.getFensterFactory().getFensterListe().propagateBestand(this,a.getRezeptur().getID());
       			}
       			if(bd != null) {
       				bd.dispose();
       				bd = null;
       			}
           }
       }

	}

    private void druckenAction() {
        rz.getReportFactory().lieferscheinReport(li,this);
    }

    private void saveAction() {
    	saveToggle(false);
        if(li.getAi() == null) {
            li.setAdresse_string(txtAdresse.getText().trim());
        }
        rz.getDatabase().getLieferschein().saveLieferschein(li);
    }

    private void postenLoeschenAction() {
        final LieferscheinZeile zl = li.getAuftragsListe().getRow(tblLieferschein.getSelectedRow());
        if(zl != null) {
            switch (zl.getTyp()){
            	case LieferscheinZeile.ZEILE_CONTAINER:
            	    li.getAuftragsListe().removeContainer(zl);
            	    break;
            	case LieferscheinZeile.ZEILE_SUMME:
            	    li.getAuftragsListe().removeAuftrag(zl.getUid());
            	    break;
            }
        }
        ((AbstractTableModel)tblLieferschein.getModel()).fireTableDataChanged();
        setActions();
        txtContainer.requestFocus();
    }

    private void blattLoeschenAction() {
        li.getAuftragsListe().clear();
        ((AbstractTableModel)tblLieferschein.getModel()).fireTableDataChanged();
        setActions();
        txtContainer.requestFocus();
    }

    private void uebernehmenAction() {
        rechnen();
        LieferscheinZeile zl= zeile.copyItem();
        if(tmpLosnummer != null && !tmpLosnummer.equals("")) {
        	zl.setLosnummer(tmpLosnummer);
        }  
        li.getAuftragsListe().addContainer(zl);
        ((AbstractTableModel)tblLieferschein.getModel()).fireTableDataChanged();
        setActions();
        txtContainer.requestFocus();
    }

    private void adresseAction() {
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_ADRESSAUSWAHL_EINFACH,true, new MessageItem(MessageItem.MSG_SELECT_ADRESSE_REQUEST,0, (Object)txtAdresse.getText().trim(),this));
    }
    private void adresseEntfernenAction() {
        li.setAi(null);
        li.setAdresse(0);
        txtAdresse.setText("");
        lblAdresse.setText(rz.getLocale().getString("lieferschein.label_keine_adresse_festgelegt"));
        setActions();
    }
    private void einstellungenAction(){
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_EINSTELLUNGEN,true,new MessageItem(MessageItem.MSG_SHOW_EINSTELLUNGEN,0,null,this));
    }

	//hilfe
	private void hilfeAction() {
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"lieferschein.html",this));
	}

    private void hideAction() {
        rz.getFensterFactory().getFensterListe().sperren(this);
    }


    public void columnAdded(TableColumnModelEvent e) {
    }
    public void columnMarginChanged(ChangeEvent e) {
    }
    public void columnMoved(TableColumnModelEvent e) {
    }
    public void columnRemoved(TableColumnModelEvent e) {
    }
    public void columnSelectionChanged(ListSelectionEvent e) {
    }

	private void setTblRezepturModel(JTable t) {
    	final JComboBox cmbReihe=new JComboBox();
    	cmbReihe.addItem(new LosnummerReihenItem(DBBuchung.REIHE_FIFO,rz.getLocale().getString("lieferschein.table_reihe_fifo")));
    	cmbReihe.addItem(new LosnummerReihenItem(DBBuchung.REIHE_LIFO,rz.getLocale().getString("lieferschein.table_reihe_lifo")));
    	cmbReihe.setSelectedIndex(0);
    	final RechenColumnModel rcm = new RechenColumnModel();
	    final NumericRenderer nr = new NumericRenderer();
	    final StringRenderer sr = new StringRenderer();
	    TableColumn tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("lieferschein.tableheader_bezeichnung"));
	    	tc.setModelIndex(C_BEZEICHNUNG);
	    	tc.setCellRenderer(sr);
	    rcm.addColumn(tc);
	    	tc = new TableColumn();
    		tc.setHeaderValue(rz.getLocale().getString("lieferschein.tableheader_nummer"));
    		tc.setCellRenderer(sr);
    		tc.setModelIndex(C_NUMMER);
        rcm.addColumn(tc);
    	tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("lieferschein.tableheader_reihe"));
			tc.setCellRenderer(sr);
			tc.setModelIndex(C_REIHE);
	    	tc.setCellEditor(new DefaultCellEditor(cmbReihe));
	    rcm.addColumn(tc);
        tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("lieferschein.tableheader_losnummer"));
			tc.setCellRenderer(sr);
			tc.setModelIndex(C_LOSNUMMER);
		rcm.addColumn(tc);
        tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("lieferschein.tableheader_bemerkungen"));
			tc.setCellRenderer(sr);
			tc.setModelIndex(C_COMMENT);
		rcm.addColumn(tc);
	    	tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("lieferschein.tableheader_staerke"));
	    	tc.setModelIndex(C_STAERKE);
	    	tc.setCellRenderer(nr);
    	rcm.addColumn(tc);
        tc = new TableColumn();
        	tc.setHeaderValue(rz.getLocale().getString("lieferschein.tableheader_brutto"));
        	tc.setModelIndex(C_BRUTTO);
        	tc.setCellRenderer(nr);
        rcm.addColumn(tc);
    	tc = new TableColumn();
        	tc.setHeaderValue(rz.getLocale().getString("lieferschein.tableheader_tara"));
        	tc.setModelIndex(C_TARA);
	    	tc.setCellRenderer(nr);
        rcm.addColumn(tc);
    	tc = new TableColumn();
        	tc.setHeaderValue(rz.getLocale().getString("lieferschein.tableheader_netto"));
        	tc.setModelIndex(C_NETTO);
	    	tc.setCellRenderer(nr);
        rcm.addColumn(tc);
    	tc = new TableColumn();
        	tc.setHeaderValue(rz.getLocale().getString("lieferschein.tableheader_liter"));
        	tc.setModelIndex(C_LITER);
	    	tc.setCellRenderer(nr);
        rcm.addColumn(tc);
    	tc = new TableColumn();
    		tc.setHeaderValue(rz.getLocale().getString("lieferschein.tableheader_la"));
    		tc.setModelIndex(C_LA);
	    	tc.setCellRenderer(nr);
	    rcm.addColumn(tc);
    	tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("lieferschein.tableheader_bestand"));
			tc.setModelIndex(C_BESTAND);
	    	tc.setCellRenderer(nr);
	    rcm.addColumn(tc);
    	tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("lieferschein.tableheader_ean"));
			tc.setModelIndex(C_EAN);
	    	tc.setCellRenderer(sr);
	    rcm.addColumn(tc);

        rcm.addColumnModelListener(this);
        tblLieferschein.setModel(new RechenTableModel());
        tblLieferschein.setColumnModel(rcm);
        tblLieferschein.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
        tblLieferschein.setCellSelectionEnabled(false);
        tblLieferschein.setRowSelectionAllowed(true);
        tblLieferschein.setColumnSelectionAllowed(false);
        tblLieferschein.getTableHeader().setReorderingAllowed(false);
	}

	private class RechenColumnModel extends DefaultTableColumnModel{
	    public RechenColumnModel() {
	        super();
	    }

	}

	private  class RechenTableModel extends AbstractTableModel    {


		   public int getColumnCount() {
		       	return C_MAX;
	        }
	        public int getRowCount() {
        		return	 li.getAuftragsListe().getRowCount();
	        }

	        public LieferscheinZeile getZeileAt(int rowIndex) {
	        	if(rowIndex != -1) {
	        		return	 li.getAuftragsListe().getRow(rowIndex);
	        	} else {
					return null;
				}
	        }

	        public boolean isCellEditable(int row, int col){
	        	boolean ret = false;
	    		final LieferscheinZeile z = li.getAuftragsListe().getRow(row);
	    		if (z != null) {
		        	switch(col) {
		        		case C_LOSNUMMER:
		    	    		if(z.getTyp() == LieferscheinZeile.ZEILE_CONTAINER) {
		    	    			ret = true;
		    	    		}
		        			break;
		        		case C_COMMENT:
		    	    		if(z.getTyp() == LieferscheinZeile.ZEILE_CONTAINER) {
		    	    			ret = true;
		    	    		}
		        			break;
		        		case C_REIHE:
		        			if(z.getTyp() == LieferscheinZeile.ZEILE_CONTAINER){
		        				ret = true;
		        			}
		        			break;
		        		case C_EAN:
		        			if(z.getTyp() == LieferscheinZeile.ZEILE_CONTAINER){
		        				ret = true;
		        			}	
		        			break;
		        	}
	    		}
	        	return ret;
	        }

	        public void setValueAt(Object value, int row, int col) {
	    		final LieferscheinZeile z = li.getAuftragsListe().getRow(row);
		    	if (z != null) {
		        	switch(col ) {
			        		case C_LOSNUMMER:
			    	    		if(z.getTyp() == LieferscheinZeile.ZEILE_CONTAINER) {
			    	    			z.setLosnummer(value.toString());
			    	    			saveToggle(true);
			    	    		}
			    	    		break;
			        		case C_COMMENT:
			    	    		if(z.getTyp() == LieferscheinZeile.ZEILE_CONTAINER) {
			    	    			z.setComment(value.toString());
			    	    			txtBemerkungen.setText(z.getComment());
			    	    			saveToggle(true);
			    	    		}
			        			break;
			        		case C_REIHE:
			    	    		if(z.getTyp() == LieferscheinZeile.ZEILE_CONTAINER) {
			    	    			z.setLosnummerReihe(((LosnummerReihenItem)value).getReihe());
			    	    		}
			        			break;
			        		case C_EAN:
			    	    		if(z.getTyp() == LieferscheinZeile.ZEILE_CONTAINER) {
			    	    			z.setEan(value.toString());
			    	    			saveToggle(true);
			    	    		}
			    	    		break;
		        	}
		        	setSummenZeile();
	    		}
	        }

	        public Object getValueAt(int rowIndex, int columnIndex) {
	            Object ret = null;
	    		final LieferscheinZeile z = li.getAuftragsListe().getRow(rowIndex);
	    		if(z != null) {
		            switch(z.getTyp()) {
		            	case LieferscheinZeile.ZEILE_CONTAINER:
		            	    ret = getContent(z,columnIndex);
		            	    break;
		            	case LieferscheinZeile.ZEILE_LEER:
		            	    ret = null;
		            	    break;
		            	case LieferscheinZeile.ZEILE_KOPF:
		            	    ret=null;
		            		break;
		            	case LieferscheinZeile.ZEILE_SUMME:
		            	    ret = getSumme(z,columnIndex);
		            	    break;
		            }
	    		}
	            return ret;
	        }

	        private Object getContent(LieferscheinZeile z,int aColumn) {
	            Object ret = null;
	            switch(aColumn) {
	            	case C_BEZEICHNUNG :
	            	    ret= z.getBezeichnung();
	            	    break;
	            	case C_NUMMER :
	            	    ret = z.getContainerS();
	            	    break;
	            	case C_REIHE:
	            		ret = z.getLosnummerReiheString();
	            		break;
	            	case C_LOSNUMMER :
            			ret = z.getLosnummer();
	            	    break;
	            	case C_COMMENT :
	            	    ret = z.getComment();
	            	    break;
	            	case C_STAERKE :
	            	    ret = rz.getLocale().formatNumber(z.getStaerke(),OptionFactory.NF_STAERKE);
	            	    break;
	            	case C_BRUTTO :
	            	    ret = rz.getLocale().formatNumber(z.getBrutto(),OptionFactory.NF_LIEFERSCHEIN);
	            	    break;
	            	case C_TARA:
	            	    ret = rz.getLocale().formatNumber(z.getTara(),OptionFactory.NF_LIEFERSCHEIN);
	            	    break;
	            	case C_NETTO :
	            	    ret = rz.getLocale().formatNumber(z.getNetto(),OptionFactory.NF_LIEFERSCHEIN);
	            	    break;
	            	case C_LITER :
	            	    ret = rz.getLocale().formatNumber(z.getLiter(),OptionFactory.NF_LIEFERSCHEIN) ;
	            	    break;
	            	case C_LA :
	            	    ret = rz.getLocale().formatNumber(z.getLa(),OptionFactory.NF_LIEFERSCHEIN);
	            	    break;
	            	case C_EAN :
            			ret = z.getEan();
            			break;
	            }
	            return ret;
	        }
	        private Object getSumme(LieferscheinZeile z,int aColumn) {
	            Object ret = null;
	            switch(aColumn) {
            	case C_BEZEICHNUNG :
            	    ret= "Summe";
            	    break;
            	case C_NUMMER :
            	    ret = " ";
            	    break;
            	case C_BRUTTO :
            	    ret = rz.getLocale().formatNumber(z.getBrutto(),OptionFactory.NF_LIEFERSCHEIN);
            	    break;
            	case C_TARA:
            	    ret = rz.getLocale().formatNumber(z.getTara(),OptionFactory.NF_LIEFERSCHEIN);
            	    break;
            	case C_NETTO :
            	    ret = rz.getLocale().formatNumber(z.getNetto(),OptionFactory.NF_LIEFERSCHEIN);
            	    break;
            	case C_LITER :
            		if(rz.isZero(z.getOpenLiter())) {
            			ret = rz.getLocale().formatNumber(z.getLiter(),OptionFactory.NF_LIEFERSCHEIN);
            		} else {
            			ret =rz.getLocale().formatNumber(z.getLiter(),OptionFactory.NF_LIEFERSCHEIN) ;
            		}
            	    break;
            	case C_LA :
            	    ret = rz.getLocale().formatNumber(z.getLa(),OptionFactory.NF_LIEFERSCHEIN);
            	    break;
            	case C_BESTAND :
           			ret = rz.getLocale().formatNumber( li.getAuftragsListe().getAuftrag(z.getUid()).getBestand(),OptionFactory.NF_NORMAL) + " " + 
           				rz.getDatabase().getEinheiten().getGrundEinheit(RzPro.EINHEIT_LITER).getName();
            	    break;
            	case C_EAN:
            			ret = "";
            		break;
	            }
	            return ret;
	        }
		}

	/** rendert alle Tabellenzeilen mit numerischen Inhalt
	 *  im wesentlichen heisst das rechts-ausgerichtent
	 * @author lunqual
	 */
	private class NumericRenderer extends DefaultTableCellRenderer {

	    NumericRenderer() {
	        super();
	        setOpaque(true);
	    }
	    public Component getTableCellRendererComponent(JTable table,
                Object value, boolean isSelected, boolean hasFocus, int row,
                int column)
	    {
	    	setFont(rz.getFontFactory().getTableFont());
	    	Color c;
    		LieferscheinZeile z=null;
	    	if(row != -1) {
	    	    z= li.getAuftragsListe().getRow(row);
	    	}
    		if(isSelected) {
    		    c= rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_SELECTED);
    		}else {
		   		c=rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_NORMAL);
    		}
	        if(value != null) {
    		    setText(value.toString());
	        } else {
	        	setText("");
	        }
	        setIcon(null);
    		if((z != null) &&  (z.getTyp() == LieferscheinZeile.ZEILE_SUMME)) {
	    		   if(value != null) {
    		   		setText("<html><b>" + value.toString() + "</b></html>");
	    		   } else {
	    		   		setText("");
	    		   }
	    		   
	    		   if(!rz.isZero(z.getOpenLiter())) {
		    		   if(li.getAuftragsListe().getAuftrag(z.getUid()).isBestandWarnung()) {
					    		if(isSelected) {
					    		    c = rz.getOptionFactory().getColor(OptionFactory.COLOR_RED);
					    		}else {
				 		   			c= rz.getOptionFactory().getColor(OptionFactory.COLOR_BESTAND_ROT);
					    		}
			    		   } else {
					    		if(isSelected) {
					    		     c= rz.getOptionFactory().getColor(OptionFactory.COLOR_GREEN);
					    		}else {
				 		   			c=rz.getOptionFactory().getColor(OptionFactory.COLOR_BESTAND_GRUEN);
					    		}
			    		   }
		    		}else {
		    			if(isSelected) {
		 		   			c=rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_SELECTED);
		    			}else {
		 		   			c=rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_GELB);
		    			}
		    		}

    		} else {
    		    setText(value == null ? "":value.toString());
	        }
	        setBackground(c);
	        setHorizontalAlignment(SwingConstants.TRAILING);
	        return this;
        }
	}
	/** rendert alle Tabellenzeilen mit String Inhalt
	 *  im wesentlichen heisst das rechts-ausgerichtent
	 * @author lunqual
	 */
	private class StringRenderer extends DefaultTableCellRenderer {

		Icon rot,gruen,gelb,probe;
	
	    StringRenderer() {
	        super();
	        rot = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/lieferschein.icon_rot.png"));
	        gruen = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/lieferschein.icon_gruen.png"));
	        gelb = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/lieferschein.icon_gelb.png"));
	        probe = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/lieferschein.icon_rprobe .png"));
	        setOpaque(true);
	    }
	    public Component getTableCellRendererComponent(JTable table,
                Object value, boolean isSelected, boolean hasFocus, int row,
                int column)
	    {
	    	setFont(rz.getFontFactory().getTableFont());
	    	Color c;
	        LieferscheinZeile z = null;
 		   setIcon(null);
	    	if(row != -1) {
	    	    z = li.getAuftragsListe().getRow(row);
	    	}
    		if(isSelected) {
    		    c= rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_SELECTED);
    		}else {
		   		c=rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_NORMAL);
    		}
	        if(value != null) {
    		    setText(value.toString());
	        } else {
	        	setText("");
	        }
    		if((z != null) && (z.getTyp() == LieferscheinZeile.ZEILE_SUMME)) {
    			 if (column == C_BEZEICHNUNG) {
    				 ArrayList<LosnummerItem> liste = rz.getDatabase().getBuchungen().getLosNummerListe(de.lunqual.rzpro.database.DBBuchung.REIHE_FIFO,z.getRezeptur().getID(),z.getLiter() ,rz.getDatabase().getEinheiten().getLiterItem());
    					if(!rz.getDatabase().getProben().checkProbeOK(liste)) {
    						setIcon(probe);
    					} else {
    						setIcon(null);
    					}
    			 }
	    		   if(value != null) {
	    		   		setText("<html><b>" + value.toString() + "</b></html>");
	    		   } else {
	    		   		setText("");
	    		   }
	    		   if(!rz.isZero(z.getOpenLiter())) {
		    		   if(li.getAuftragsListe().getAuftrag(z.getUid()).isBestandWarnung()) {
					    		if(isSelected) {
					    		    c = rz.getOptionFactory().getColor(OptionFactory.COLOR_RED);
					    		    if(z.getTyp()==LieferscheinZeile.ZEILE_SUMME && column==C_LOSNUMMER) {setIcon(rot);}
					    		}else {
				 		   			c= rz.getOptionFactory().getColor(OptionFactory.COLOR_BESTAND_ROT);
					    		    if(z.getTyp()==LieferscheinZeile.ZEILE_SUMME && column==C_LOSNUMMER) {setIcon(rot);}
					    		}
			    		   } else {
					    		if(isSelected) {
					    		     c= rz.getOptionFactory().getColor(OptionFactory.COLOR_GREEN);
						    		    if(z.getTyp()==LieferscheinZeile.ZEILE_SUMME && column==C_LOSNUMMER) {setIcon(gruen);}
					    		}else {
				 		   			c=rz.getOptionFactory().getColor(OptionFactory.COLOR_BESTAND_GRUEN);
					    		    if(z.getTyp()==LieferscheinZeile.ZEILE_SUMME && column==C_LOSNUMMER) {setIcon(gruen);}
					    		}
			    		   }
		    		}else {
		    			if(isSelected) {
		 		   			c=rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_SELECTED);
			    		    if(z.getTyp()==LieferscheinZeile.ZEILE_SUMME && column==C_LOSNUMMER) {setIcon(gelb);}
		    			}else {
		 		   			c=rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_GELB);
			    		    if(z.getTyp()==LieferscheinZeile.ZEILE_SUMME && column==C_LOSNUMMER) {setIcon(gelb);}
		    			}
		    		}
    		}
	        setBackground(c);
	        setHorizontalAlignment(SwingConstants.LEADING);
	        return this;
        }
	}

    private  class focusListe  extends FocusTraversalPolicy {

            public Component getComponentAfter(Container focusCycleRoot,
                Component aComponent) {
            if(aComponent.equals(txtAdresse)) {
                return btAdresse;
            } else if(aComponent.equals(btAdresse)) {
                return btAdresseEntfernen;
            } else if(aComponent.equals(btAdresseEntfernen)) {
                return btRezeptur;
            } else if (aComponent.equals(btRezeptur)) {
                return txtRezeptur;
            } else if(aComponent.equals(txtRezeptur)) {
                return txtStaerke;
            } else if(aComponent.equals(txtStaerke)) {
                return txtContainer;
            } else if (aComponent.equals(txtContainer)) {
                return txtBrutto;
            } else if(aComponent.equals(txtBrutto)) {
                return txtTara;
            } else if (aComponent.equals(txtTara)) {
                return txtFlaschen;
            } else if (aComponent.equals(txtFlaschen)) {
                return btFlaschenLosnummer;
            } else if (aComponent.equals(btFlaschenLosnummer)) {
                return txtDeckel;
            } else if (aComponent.equals(txtDeckel)) {
                return btDeckelLosnummer;
            } else if (aComponent.equals(btDeckelLosnummer)) {
                return txtBemerkungen;
            } else if (aComponent.equals(txtBemerkungen)) {
                    return txtEan;
            } else if (aComponent.equals(txtEan)) {
                return cmbEan;  
            } else if (aComponent.equals(cmbEan)) {
                    return btUebernehmen;  
            } else if (aComponent.equals(btUebernehmen)) {
                return btPostenLoeschen;
            } else if (aComponent.equals(btPostenLoeschen)) {
                return btBlattLoeschen;
            } else if (aComponent.equals(btBlattLoeschen)) {
                return btPostenVerbuchen;
            } else if (aComponent.equals(btPostenVerbuchen)) {
                return tblLieferschein;
            } else if (aComponent.equals(tblLieferschein)) {
                return btSave;
            } else if(aComponent.equals(btSave)) {
                return btDrucken;
            } else if (aComponent.equals(btDrucken)) {
                return btHilfe;
            } else if (aComponent.equals(btHilfe)) {
                return btClose;
            } else if(aComponent.equals(btClose)) {
                return txtAdresse;
            }
            return null;
        }
        public Component getComponentBefore(Container focusCycleRoot,
                Component aComponent) {
            if(aComponent.equals(btClose)) {
                return btHilfe;
            } else if(aComponent.equals(btHilfe)) {
                return btDrucken;
            } else if(aComponent.equals(btDrucken)) {
                return btSave;
            } else if (aComponent.equals(btSave)) {
                return tblLieferschein;
            } else if(aComponent.equals(tblLieferschein)) {
                return btPostenVerbuchen;
            } else if(aComponent.equals(btPostenVerbuchen)) {
                return btBlattLoeschen;
            } else if (aComponent.equals(btBlattLoeschen)) {
                return btPostenLoeschen;
            } else if(aComponent.equals(btPostenLoeschen)) {
                return btUebernehmen;
            } else if (aComponent.equals(btUebernehmen)) {
                return txtTara;
            } else if (aComponent.equals(txtTara)) {
                return txtBrutto;
            } else if (aComponent.equals(txtBrutto)) {
                return txtContainer;
            } else if (aComponent.equals(txtContainer)) {
                return txtStaerke;
            } else if (aComponent.equals(txtStaerke)) {
                return txtRezeptur;
            } else if (aComponent.equals(txtRezeptur)) {
                return btRezeptur;
            } else if(aComponent.equals(btRezeptur)) {
                return btAdresseEntfernen;
            } else if (aComponent.equals(btAdresseEntfernen)) {
                return btAdresse;
            } else if (aComponent.equals(btAdresse)) {
                return txtAdresse;
            } else if(aComponent.equals(txtAdresse)) {
                return btClose;
            }
            else if(aComponent.equals(txtBemerkungen)) {
                return btDeckelLosnummer;
            } else if (aComponent.equals(btDeckelLosnummer)) {
                return txtDeckel;
            }else if(aComponent.equals(txtDeckel)) {
                return btFlaschenLosnummer;
            } else if (aComponent.equals(btFlaschenLosnummer)) {
                return txtFlaschen;
            }else if(aComponent.equals(txtFlaschen)) {
                return txtTara;
            }
            return null;
        }
        public Component getDefaultComponent(Container focusCycleRoot) {
            if(rezeptur == null) {
                return txtAdresse;
            } else {
                return btRezeptur;
            }
        }
        public Component getFirstComponent(Container focusCycleRoot) {
            if(rezeptur == null) {
                return txtAdresse;
            } else {
                return btRezeptur;
            }
        }
        public Component getInitialComponent(Window window) {
            return txtAdresse;
        }
        public Component getLastComponent(Container focusCycleRoot) {
            return btClose;
        }
}
}
