package de.lunqual.rzpro.fenster.losnummervorlagefenster;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import java.util.Date;

import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingConstants;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fenster.dialoge.BuchungsDialog;
import de.lunqual.rzpro.fenster.dialoge.DialogControl;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.items.losnummerVorlage.LosnummerVorlageItem;
import de.lunqual.rzpro.items.losnummerVorlage.LosnummerVorlageListe;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.options.OptionFactory;

public class LosnummerVorlageFenster extends JRzFrame implements TableColumnModelListener{

	
	  //GUI-Variablen
    private JToolBar tb1;
    private JMenuBar mb;
    private JMenu mnuDatei;
    private JMenu mnuHilfe;
      private  JPanel contentPanel;
      	private JPanel tbPanel;
      	private JPanel centerPanel;
      		private JPanel northPanel;
      		private JPanel listenPanel;
      			private JScrollPane scrListe;
      				private JTable tblListe;
      		private JLabel lblStatus;
  		private JPanel buttonPanel;
  			private JButton btOK;
      	    private JButton btAbbrechen;
      	    private JButton btNeu;
      	    private JButton btDelete;

    public static final int         		ACTION_ABBRECHEN_CODE = 1001;
    public static final String     		ACTION_ABBRECHEN_TEXT = "losnummervorlage.action_close";
    public static final int         		ACTION_NEU_CODE = 1002;
    public static final String     		ACTION_NEU_TEXT = "losnummervorlage.action_neu";
    public static final int         		ACTION_DELETE_CODE = 1003;
    public static final String     		ACTION_DELETE_TEXT = "losnummervorlage.action_delete";
    public static final int         		ACTION_OK_CODE = 1004;
    public static final String     		ACTION_OK_TEXT = "losnummervorlage.action_ok";
    
    static final int							MAX_COLUMN = 5;
    static final int							C_VALUE=0;
    static final int							C_BEZEICHNUNG =1;
    static final int							C_LISTE=2;
    static final int							C_ERSTELLT=3;
    static final int							C_USER=4;
    
    int											ret = MessageItem.MSG_REPLY_LOSNMMERVORLAGE_FLASCHEN;
    LosnummerVorlageListe				lvl = new LosnummerVorlageListe();
    JRzFrame									origin;
    BuchungsDialog							originD;
    boolean									editable=false;
    
    /** Creates new form AdressenFenster */
    public LosnummerVorlageFenster(RzPro r, String name, Object extendedData) {
        super(r,name,extendedData);
        createActions();
        createGUIComponents();
        setGUIComponents();
        getMessage((MessageItem)extendedData);
    }

    @Override
	public void createGUIComponents() {
    	// Menü
		//contentPanel
    	mb = new JMenuBar();
    	mnuDatei = new JMenu();
    	mb.add(mnuDatei);
    	setJMenuBar(mb);
		contentPanel = new JPanel(new BorderLayout());
			centerPanel=new JPanel(new BorderLayout());
				northPanel = new JPanel(new BorderLayout());

				centerPanel.add(northPanel,BorderLayout.NORTH);
				listenPanel = new JPanel(new BorderLayout());
					scrListe = new JScrollPane();
					tblListe = new JTable();
						tblListe.setName("losnummervorlage.spalten");
						 tblListe.addMouseListener(new MouseAdapter(){
						     public void mouseClicked(MouseEvent e){
						      if (e.getClickCount() == 2){
						    	  	doppelklickAction();
						      } else {
						    	  	listeClickedAction();
						      }
						      }
						     } );
				         InputMap inputMap = tblListe.getInputMap(JComponent.WHEN_FOCUSED);
				         inputMap.remove(KeyStroke.getKeyStroke(KeyEvent.VK_ENTER,0));
					        Action enterKeyAction = new AbstractAction() {
					        	public void actionPerformed(ActionEvent e) {
						        	String actionCmd = e.getActionCommand();
						        	if (actionCmd.equals("EnterKey")) {
						        		okAction();
						        	}
					        	}
					        };		
					        tblListe.registerKeyboardAction(enterKeyAction,"EnterKey", KeyStroke.getKeyStroke(KeyEvent.VK_ENTER,0),JComponent.WHEN_FOCUSED);


						tblListe.getSelectionModel().addListSelectionListener(new ListSelectionListener() {
		                    public void valueChanged(ListSelectionEvent e) {
		        			        if (!e.getValueIsAdjusting()) {
										return;
									}
		        			       setActions();
		                        }
			    			});

						scrListe.setViewportView(tblListe);
					listenPanel.add(scrListe,BorderLayout.CENTER);
					lblStatus = new JLabel();
						lblStatus.setHorizontalAlignment(SwingConstants.CENTER);
					listenPanel.add(lblStatus,BorderLayout.SOUTH);
				centerPanel.add(listenPanel,BorderLayout.CENTER);
		contentPanel.add(centerPanel,BorderLayout.CENTER);
		    // ButtonPanel
			buttonPanel=new JPanel(new GridLayout(1,4));
				btOK = new JButton();
				buttonPanel.add(btOK);
				btNeu = new JButton();
				buttonPanel.add(btNeu);
				btDelete = new JButton();
				buttonPanel.add(btDelete);
				btAbbrechen = new JButton();
				buttonPanel.add(btAbbrechen);
		contentPanel.add(buttonPanel,BorderLayout.SOUTH);

		//Panels ans Fenster hängen;
		this.getContentPane().setLayout(new BorderLayout());

		this.getContentPane().add(contentPanel, BorderLayout.CENTER);
	     this.settblListenModel(this.tblListe);
    }


    @Override
	public void setGUIComponents() {
        setTitle(rz.getVersionString() + " " + rz.getLocale().getString("losnummervorlage.titel"));

		mnuDatei.setText(rz.getLocale().getString("menu.datei"));

        mnuDatei.add(getAction(ACTION_OK_CODE));
        mnuDatei.addSeparator();
		mnuDatei.add(getAction(ACTION_NEU_CODE));
		mnuDatei.addSeparator();
		mnuDatei.add(getAction(ACTION_DELETE_CODE));
		mnuDatei.addSeparator();
        mnuDatei.add(getAction(ACTION_ABBRECHEN_CODE));

		btOK.setAction(getAction(ACTION_OK_CODE));
		btAbbrechen.setAction(getAction(ACTION_ABBRECHEN_CODE));
		btNeu.setAction(getAction(ACTION_NEU_CODE));
		btDelete.setAction(getAction(ACTION_DELETE_CODE));

		lblStatus.setText("");
		
		setResizable(true);
        rz.getFontFactory().setFrameFonts(this);
        pack();
        rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;
    }

    @Override
	public void getMessage(MessageItem msg) {
        switch(msg.getMsgCode()) {
    	case MessageItem.MSG_ACTIONPERFORMED:
            switch(msg.getCode()){
		          case ACTION_ABBRECHEN_CODE:closeWindow();break;
		          case ACTION_NEU_CODE:neuAction();break;
		          case ACTION_DELETE_CODE:deleteAction();break;
		          case ACTION_OK_CODE:okAction();break;
		          default :
		              break;
           }
    		break;
    	 case MessageItem.MSG_SHOW_LOSNUMMERVORLAGE_FILTER:
    		 ret=-1;
    		 originD=(BuchungsDialog)msg.getData();
    		 updateListe();
    		 break;
         case MessageItem.MSG_SHOW_LOSNUMMERVORLAGE_SINGLE :
        	 ret = MessageItem.MSG_REPLY_LOSNMMERVORLAGE_FLASCHEN;
        	 editable=true;
        	 origin=msg.getOrigin();
        	 updateListe();
         	break;
         case MessageItem.MSG_SHOW_LOSNUMMERVORLAGE_FLASCHEN :
        	 ret = MessageItem.MSG_REPLY_LOSNMMERVORLAGE_FLASCHEN;
        	 editable=false;
        	 origin=msg.getOrigin();
        	 updateListe();
         	break;
         case MessageItem.MSG_SHOW_LOSNUMMERVORLAGE_DECKEL :
        	 ret=MessageItem.MSG_REPLY_LOSNMMERVORLAGE_DECKEL;
        	 editable=false;
        	 origin=msg.getOrigin();
        	 updateListe();
         	break;
        default:
            break;
        }

    }
    @Override
	public void createActions(){
        actionList.put(String.valueOf(ACTION_ABBRECHEN_CODE),new AuswahlAction(rz,this,ACTION_ABBRECHEN_CODE,ACTION_ABBRECHEN_TEXT, KeyEvent.VK_ESCAPE,0));
        actionList.put(String.valueOf(ACTION_NEU_CODE),new AuswahlAction(rz,this,ACTION_NEU_CODE,ACTION_NEU_TEXT, KeyEvent.VK_N,KeyEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_DELETE_CODE),new AuswahlAction(rz,this,ACTION_DELETE_CODE,ACTION_DELETE_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_OK_CODE),new AuswahlAction(rz,this,ACTION_OK_CODE,ACTION_OK_TEXT, 0,0));

    }

    private void setActions() {
    	if(this.tblListe.getSelectedRow() != -1) {
    		getAction(ACTION_DELETE_CODE).setEnabled(true);
    		getAction(ACTION_OK_CODE).setEnabled(true);
    	}else {
    		getAction(ACTION_DELETE_CODE).setEnabled(false);    		
    		getAction(ACTION_OK_CODE).setEnabled(false);    		
    	}
    }

    private void okAction() {
    	LosnummerVorlageItem lv;
    	if(tblListe.getSelectedRow()!= -1) {
    		lv=lvl.getItem(tblListe.getSelectedRow());
    		if(lv != null) {
    			try {
    				if(ret == -1) {
    					originD.setFilter( new String("("+lv.getBezeichnung()+")"+lv.getValue()));
    				}else {
    					origin.getMessage(new MessageItem(ret,0, new String("("+lv.getBezeichnung()+")"+lv.getValue()),this));
    				}
    			}catch(Exception e) {}
    			closeWindow();
    		}
    	}
    	
    }
    
    private void doppelklickAction() {
    	okAction();
    }
    
    
    private void listeClickedAction() {
    	if ( tblListe.getSelectedColumn() == C_LISTE) {
    		LosnummerVorlageItem lv = lvl.getItem(tblListe.getSelectedRow());
    		if(lv != null) {
    			rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_LOSNUMMERLISTE, true, new MessageItem(MessageItem.MSG_SHOW_LOSNUMMERLISTE_ID,0,lv,this));
    		}
    	}
    }
    
    private void deleteAction() {
    	DialogItem di;
    	LosnummerVorlageItem lv = null;
    	if(tblListe.getSelectedRow() != -1) {
    		lv = lvl.getItem(tblListe.getSelectedRow());
    	}
    	if(lv != null) {
    		if(!rz.getDatabase().getLosnummerVorlage().checkLosnummerHistory(lv)) {
		    	di = new DialogItem(
		                DialogControl.FRAGE_DIALOG,
		                "",0.0,
		                rz.getLocale().getString("losnummervorlage.question_delete"),
		                rz.getLocale().getString("losnummervorlage.question_delete"),
		                rz.getLocale().getString("losnummervorlage.question_delete_1").replaceAll("%s",lv.getBezeichnung()),
		                "frage.png",
		                rz.getLocale().getString("string_ja"),
		                rz.getLocale().getString("string_nein"),
		                this
		        );
		        rz.getDialogFactory().getDialog(di);
		        if ((di.getReplyCode() == DialogControl.DIALOG_YES) || (di.getReplyCode() == DialogControl.DIALOG_OK)){
		           rz.getDatabase().getLosnummerVorlage().delete(lv.getId());
		           updateListe();
		        }
    		} else {
    			di = new DialogItem(0,"",0.0,"","","","","","",null);
    		    	di.setTyp(DialogControl.HINWEIS_DIALOG);
    	        di.setCaption(rz.getLocale().getString("losnummervorlage.no_delete"));
    	        di.setTitel(rz.getLocale().getString("losnummervorlage.no_delete"));
    	        di.setMessage(rz.getLocale().getString("losnummervorlage.no_delete_message").replaceAll("%s", lv.getBezeichnung()));
    	        di.setIcon("warnung.png");
    	        di.setOk(rz.getLocale().getString("string_ok"));
    	        rz.getDialogFactory().getDialog(di);
    		}
    	}
    }
    
    private void neuAction() {
    	String key=rz.getLocale().getString("losnummervorlage.neu");
    	 final DialogItem di  = new DialogItem(
                 DialogControl.EINGABE_DIALOG,
                 "",0.0,
                 rz.getLocale().getString("losnummervorlage.neu_label"),
                 rz.getLocale().getString("losnummervorlage.neu_caption"),
                 key,
                 "frage.png",
                 rz.getLocale().getString("string_ok"),
                 rz.getLocale().getString("string_abbrechen"),
                 this
         );
         rz.getDialogFactory().getDialog(di,false,false);
         if(di.getReplyCode() == DialogControl.DIALOG_OK) {
        	 if(!di.getContent().trim().equals("")) {
        		 rz.getDatabase().getLosnummerVorlage().update(
        				 new LosnummerVorlageItem(
        						 0, di.getContent().trim(), rz.getLocale().getString("losnummervorlage.neu_value"), new Date(),rz.getDatabase().dbGetUser()
        						 )
        				 );
        		 updateListe();
        	 }
         }
    }

    /**
     * die Liste updaten....
     *
     */
    private void updateListe() {
    	lvl = rz.getDatabase().getLosnummerVorlage().getListe();
    	((AbstractTableModel)tblListe.getModel()).fireTableDataChanged();
    	setActions();
    	if(lvl.size()>0) {
    		tblListe.setRowSelectionInterval(0, 0);
    		tblListe.requestFocus();
    	}
    }

    @Override
	public void openWindow(){
    	rz.getLogFactory().setNotifyFrame(this);
    	updateListe();
    	setVisible(true);
        toFront();
    }

    @Override
	public void closeWindow(){
    	rz.getLogFactory().setNotifyFrame(null);
    	setVisible(false);
    	this.dispose();
    }

    

    private void settblListenModel(JTable t) {
	    final ListenColumnModel rcm = new ListenColumnModel();
	    final StringRenderer sr = new StringRenderer();
	    final IconRenderer ir = new IconRenderer();
	    TableColumn tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("losnummervorlage.tableheader_bezeichnung"));
	    	tc.setModelIndex(C_BEZEICHNUNG);
	    	tc.setCellRenderer(sr);
	    rcm.addColumn(tc);
	    tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("losnummervorlage.tableheader_value"));
	    	tc.setModelIndex(C_VALUE);
	    	tc.setCellRenderer(sr);
	    rcm.addColumn(tc);
	    tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("losnummervorlage.tableheader_liste"));
	    	tc.setModelIndex(C_LISTE);
	    	tc.setCellRenderer(ir);
	    rcm.addColumn(tc);
	    
	    tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("losnummervorlage.tableheader_erstellt"));
	    	tc.setModelIndex(C_ERSTELLT);
	    	tc.setCellRenderer(sr);
	    rcm.addColumn(tc);
	    tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("losnummervorlage.tableheader_user"));
	    	tc.setModelIndex(C_USER);
	    	tc.setCellRenderer(sr);
	    rcm.addColumn(tc);
	    

        rcm.addColumnModelListener(this);
        tblListe.setModel(new ListenTableModel());
        tblListe.setColumnModel(rcm);
        tblListe.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
        tblListe.getTableHeader().setReorderingAllowed(false);
	}

	private class ListenColumnModel extends DefaultTableColumnModel{
	    public ListenColumnModel() {
	        super();
	    }

	}

	private  class ListenTableModel extends AbstractTableModel    {

	        SimpleDateFormat df;

	        public ListenTableModel() {
	            df = new SimpleDateFormat("EEEEE, d. MMMMM yyyy HH:mm");
	        }

		   public int getColumnCount() {
		       	return MAX_COLUMN;
	        }
	        public int getRowCount() {
	        	if(rz.getLogFactory().getLog() != null) {
	                return lvl.size();
	        	} else {
	        		return 0;
	        	}
	        }

	        public void setValueAt(Object value, int row, int col) {
	    		final LosnummerVorlageItem z = lvl.getItem(row);
	    		if (z != null) {
		        	switch(col ) {
		        		case C_BEZEICHNUNG:
		        			if(!value.toString().trim().equals("")) {
		        				z.setBezeichnung(value.toString());
		        				z.setErstellt(new Date());
		        				rz.getDatabase().getLosnummerVorlage().update(z);
		        				updateListe();
		        			}
			    	    	break;
			        		case C_VALUE:
			        			if(!value.toString().trim().equals("")) {
			        				if(!value.toString().trim().equals(z.getValue())) {
			        					rz.getDatabase().getLosnummerVorlage().pushVorlage(z, value.toString().trim());
			        					lblStatus.setText(rz.getLocale().getString("losnummervorlage.status").replaceAll("%n", value.toString()).replaceAll("%s", z.getBezeichnung()));
			        				}
			        				z.setValue(value.toString().trim());
			        				z.setErstellt(new Date());
			        				rz.getDatabase().getLosnummerVorlage().update(z);
			        				updateListe();			        				
			        			} else {
			        				deleteAction();
			        			}
			    	    	break;
		        	}
	    		}
	        }

	        public boolean isCellEditable(int row, int col){
	        	boolean ret = false;
	    		final LosnummerVorlageItem z = lvl.getItem(row);
	    		if (z != null) {
		        	switch(col) {
		        		case C_BEZEICHNUNG:
		        			if(editable) {
		    	    			ret = true;
		        			} else {
		        				ret = false;
		        			}
		        			break;
		        		case C_VALUE:
		    	    			ret = true;
		        			break;
		        	}
	    		}
	        	return ret;
	        }
	        
	        public LosnummerVorlageItem getZeileAt(int rowIndex) {
	        	if((rowIndex != -1) && (rz.getLogFactory().getLog() != null)) {
	        		return lvl.getItem(rowIndex);
	        	} else {
					return null;
				}
	        }

	        public Object getValueAt(int rowIndex, int columnIndex) {
	            Object ret = null;
	            if((rowIndex != -1) && (lvl.getItem(rowIndex) != null)) {
	                ret = getContent(lvl.getItem(rowIndex),columnIndex);
	            }
	            return ret;
	        }

	        private Object getContent(LosnummerVorlageItem li,int aColumn) {
	            Object ret = null;
	            if(li != null) {
		            switch(aColumn){
		            	case C_ERSTELLT: ret = df.format(li.getErstellt());break;
		            	case C_BEZEICHNUNG: ret = li.getBezeichnung();break;
		            	case C_VALUE: ret=li.getValue();break;
		            	case C_USER:ret=li.getUser();
		            }
	            }
	            return ret;
	        }
		}

	
	/** rendert alle Tabellenzeilen mit icon Inhalt
	 *  im wesentlichen heisst das rechts-ausgerichtent
	 * @author lunqual
	 */
	private class IconRenderer extends DefaultTableCellRenderer {
		Icon liste;
	    IconRenderer() {
	        super();
	        liste = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/losnummervorlagefenster.icon_showliste.png"));
	        setOpaque(true);
	    }
	    public Component getTableCellRendererComponent(JTable table,
                Object value, boolean isSelected, boolean hasFocus, int row,
                int column)
	    {
	    	Color c;
    		setIcon(liste);
    		if(isSelected) {
    		    c= rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_SELECTED);
    		}else {
		   		c=rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_NORMAL);
    		}
    		  setBackground(c);
	    	return this;
	    }
	}

	/** rendert alle Tabellenzeilen mit String Inhalt
	 *  im wesentlichen heisst das rechts-ausgerichtent
	 * @author lunqual
	 */
	private class StringRenderer extends DefaultTableCellRenderer {

	    StringRenderer() {
	        super();
	        setOpaque(true);
	    }
	    @Override
		public Component getTableCellRendererComponent(JTable table,
                Object value, boolean isSelected, boolean hasFocus, int row,
                int column)
	    {
	    	Color c;
    		if(isSelected) {
    		    c= rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_SELECTED);
    		}else {
		   		c=rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_NORMAL);
    		}
	        setBackground(c);
	        if(value != null) {
	        	setText(value.toString());
	         } else {
				setText("");
			}
	        setHorizontalAlignment(SwingConstants.LEADING);
	        return this;
        }
	}


    public void columnAdded(TableColumnModelEvent e) {

    }
    public void columnMarginChanged(ChangeEvent e) {

    }
    public void columnMoved(TableColumnModelEvent e) {

    }
    public void columnRemoved(TableColumnModelEvent e) {

    }
    public void columnSelectionChanged(ListSelectionEvent e) {

    }


	
}
