package de.lunqual.rzpro.fenster.mischungsfenster;

/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */


import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;

import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.SwingConstants;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.ausgabe.ReportFactory;
import de.lunqual.rzpro.fenster.JIntegerField;
import de.lunqual.rzpro.fenster.JNumberField;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fenster.JSelectedTextField;
import de.lunqual.rzpro.fenster.MischungsDialog;
import de.lunqual.rzpro.fenster.TankDialog;
import de.lunqual.rzpro.fenster.ZutatenDialog;
import de.lunqual.rzpro.fenster.dialoge.DialogControl;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.abfrage.AbfrageItem;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.items.lager.LagerItem;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.mischungen.MischungsFreigabeItem;
import de.lunqual.rzpro.items.mischungen.MischungsHeaderItem;
import de.lunqual.rzpro.items.mischungen.MischungsItem;
import de.lunqual.rzpro.items.mischungen.SortenItem;
import de.lunqual.rzpro.items.mischungen.TicketItem;
import de.lunqual.rzpro.items.mischungen.TicketListe;
import de.lunqual.rzpro.items.mischungen.TransaktionsItem;
import de.lunqual.rzpro.items.report.ReportItem;
import de.lunqual.rzpro.items.rezeptur.RezepturHeaderItem;
import de.lunqual.rzpro.items.rezeptur.ZutatenSuchItem;
import de.lunqual.rzpro.items.stichworte.StichwortListe;
import de.lunqual.rzpro.items.tank.tankAuswahlItem;
import de.lunqual.rzpro.items.tank.tankItem;
import de.lunqual.rzpro.options.OptionFactory;

/**
 *
 * @author  lunqual
 */
public class MischungBearbeitenFenster extends JRzFrame implements TableColumnModelListener {

    //GUI-Variablen
    private JMenuBar mb;
    private JMenu mnuBearbeiten;
    private JMenu mnuDatei;
    private JMenu mnuExtras;
    private JMenu mnuHilfe;
    private JPanel mainPanel;
    	private JPanel toolbarPanel;
    		private JToolBar tb1;
    	private JPanel contentPanel;
    		private JSplitPane splPanel1;
	    		private JPanel listenPanel;
	    			private JPanel kopfPanel;
					private JLabel lblMischungNummer;
	    				private JPanel kopf1Panel;
	    					private JPanel kopf1TextPanel;
	    						private JSelectedTextField txtMischungBezeichnung;
	    						private JComboBox cmbSorte;
	    					private JPanel kopf1ButtonPanel;
	    						private JButton btRezeptur;
	    						private JButton btRezepturRemove;
	    					private JPanel kopf2Panel;
	    						private JLabel lblBemerkungen;
	    							private JScrollPane scrBemerkungen;
	    								private JTextArea txtBemerkungen;

	    								private JPanel adressen;
	    									private JLabel lblAdressenTitel;
	    												private JLabel lstAdressen;
	    									private JPanel adressenButtonPane;
	    										private JButton btAdressenBearbeiten;
	    										private JButton btAdressenLoeschen;
	    								
	    					private JPanel kopf3Panel;
	    						private JComboBox cmbLager;
	    						private JButton btSave; 
	    			private JSplitPane splListenTablePanel;
	    				private JSplitPane splTablePanel;
			    				private JPanel transaktionenPanel;
			    					private JLabel lblTransaktionen;
			    					private JScrollPane scrTransaktionen;
			    						private JTable tblTransaktionen;
			    					private JPanel transaktionenButtonPanel;
			    						private JPanel transaktionsAusgabePanel;
			    							private JScrollPane scrTransaktionsAusgabe;
			    								private JEditorPane txtTransaktionsAusgabe;
			    						private JPanel transaktionsButtonPanel;
			    							private JButton btTransaktionAdd;
			    							private JButton btTransaktionDelete;
		    				private JPanel ticketPanel;
		    					private JPanel ticketSelectionPanel;
		    						private JLabel lblTicketSelection;
		    						private JSelectedTextField txtTicketSelection;
		    						private JPanel ticketFilterButtons;
		    							private JButton btTicketSearch;
		    							private JButton btTicketFilterClear;
		    					private JScrollPane scrTickets;
		    						private JTable tblTickets;
		    					private JPanel ticketButtonPanel;
	    							private JButton btEditTicket;
	    							private JLabel lblTicketSumme;
		    						private JButton btCheckAll;
	    			private JPanel detailPanel;
	    				private JLabel lblDetail;
	    				private JScrollPane scrDetail;
	    					private JEditorPane txtDetail;
	    				private JPanel detailButtonPanel;
	    					private JCheckBox chkMischungen;
	    					private JCheckBox chkAlle;
	    	private JPanel actionPanel;
	    		private JPanel infoPanel;
	    			private JButton btPruefen;
	    			private JLabel lblLa;
	    			private JLabel lblStatusIcon;
	    			private JLabel lblStatus;
	    			private JLabel lblStatusDetail;
	    		private JPanel aktionenPanel;
	    			private JScrollPane scrAktionen;
	    				private JTabbedPane tabAktionen;
	    					/*
	    					 * ---------------------------------
	    					 * Hilfe
	    					 * ---------------------------------
	    					 */
	    					private JPanel tabHilfe;
	    						private JLabel lblHilfe;
	    					/*
	    					 * ----------------------------
	    					 *  Abschluss vollständig
	    					 *  ---------------------------
	    					 */
	    					//zusammenfassung
	    					private JPanel tabZusammenfassen;
	    						private JPanel zusammenfassenButtonPanel;
	    							private JButton btZusammenfassen;
	    					
	    					//Null-Abschluss
	    					private JPanel tabNullAbschluss;
	    						private JPanel nullAbschlussButtonPanel;
	    							private JButton btNullAbschluss;
	    					//Abschluss
	    					private JPanel tabAbschlussV;
	    						private JPanel tabAbschlussV2;
		    						private JPanel abschlussVDatenPanel; //center - Box
		    							private JPanel abschlussDatenVRezepturPanel;
		    								private JLabel lblabschlussVDatenTitel;
		    								private JLabel lblabschlussVDatenRezeptur;
		    								private JButton btabschlussVDatenRezeptur;
		    								private JButton btabschlussVDatenRezepturRemove;
		    							private JPanel abschlussVDatenMengenPanel;
		    								private JLabel lblabschlussVDatenMengeTitel;
		    								private JLabel lblabschlussVDatenMenge;
		    								private JLabel lblabschlussVDatenMengeStaerke;
		    								private JNumberField txtabschlussVDatenMengeStaerke;
		    								private JLabel lblabschlussVDatenMengeLiter;
		    							private JPanel abschlussVTankPanel;
		    								private JLabel lblAbschlussVTank;
		    								private JSelectedTextField txtAbschlussVTank;
		    								private JPanel abschlussVTankButtonPanel;
		    									private JButton btAbschlussVTankText;
		    									private JButton btAbschlussVTankPlan;
		    								private JLabel lblAbschlussVTankInhalt;
	    									
	    					    private JPanel abschlussVLosnummerPanel;
	    					    	private JLabel lblAbschlussVLosnummer;
	    					    	private JSelectedTextField txtAbschlussVLosnummer;
	    					    	private JButton btAbschlussVLosnummerVorschlag;

	    						private JPanel abschlussVButtonPanel;//south
	    							private JButton btAbschlussVOK;
    						
    							/*
    	    					 * ----------------------------
    	    					 *  Abschluss teilweise
    	    					 *  ---------------------------
    	    					 */
    	    					private JPanel tabAbschlussT;
    	    						private JPanel tabAbschlussT2;
    		    						private JPanel abschlussTDatenPanel; //center - Box
    		    							private JPanel abschlussTDatenRezepturPanel;
    		    								private JLabel lblabschlussTDatenTitel;
    		    								private JLabel lblabschlussTDatenRezeptur;
    		    								private JButton btabschlussTDatenRezeptur;
    		    								private JButton btabschlussTDatenRezepturRemove;
    		    							private JPanel abschlussTDatenMengenPanel;
    		    								private JLabel lblabschlussTDatenMengeTitel;
    		    								private JNumberField txtabschlussTDatenMenge;
    		    								private JLabel lblabschlussTDatenMenge;
    		    								private JLabel lblabschlussTDatenMengeStaerke;
    		    								private JNumberField txtabschlussTDatenMengeStaerke;
    		    								private JLabel lblabschlussTDatenMengeLiter;
    		    							private JPanel abschlussTTankPanel;
    		    								private JLabel lblAbschlussTTank;
    		    								private JSelectedTextField txtAbschlussTTank;
    		    								private JPanel abschlussTTankButtonPanel;
    		    									private JButton btAbschlussTTankText;
    		    									private JButton btAbschlussTTankPlan;
    		    								private JLabel lblAbschlussTTankInhalt;
    	    									
    	    					    private JPanel abschlussTLosnummerPanel;
    	    					    	private JLabel lblAbschlussTLosnummer;
    	    					    	private JSelectedTextField txtAbschlussTLosnummer;
    	    					    	private JButton btAbschlussTLosnummerVorschlag;

    	    						private JPanel abschlussTButtonPanel;//south
    	    							private JButton btAbschlussTOK;
    							
	    					/*
	    					 * ------------------------------
	    					 *  umpumpen vollständig
	    					 *  -------------------------------
	    					 */
	    					private JPanel tabUmpumpenV;
	    						private JPanel tabUmpumpenV2;
	    							private JPanel umpumpenVDatenPanel;
	    								//menge
	    								private JPanel umpumpenV1Panel;
	    									private JLabel lblUmpumpenVMenge;
	    								//tank
    									private JPanel umpumpenVTankPanel;
	    								private JLabel lblUmpumpenVTank;
	    								private JSelectedTextField txtUmpumpenVTank;
	    								private JPanel umpumpenVTankButtonPanel;
	    									private JButton btUmpumpenVTankText;
	    									private JButton btUmpumpenVTankPlan;
	    								private JLabel lblUmpumpenVTankInhalt;
		    							//mischung
	    								private JPanel umpumpenVMischungPanel;
	    									private JLabel lblUmpumpenVMischung;
	    									private JIntegerField txtUmpumpenMischungV;
	    									private JPanel umpumpenVMischungSuche;
	    										private JButton btUmpumpenVMischungText;
	    										private JButton btUmpumpenVMischungID;	    									
	    							private JPanel umpumpenVButtonPanel;
	    								private JButton btUmpumpenVOK;
	    					/*
	    					 * -----------------------------
	    					 * teilweise umpumpen
	    					 * -----------------------------
	    					 *  
	    					 */
    						private JPanel tabUmpumpenT;
    	    					private JPanel tabUmpumpenT2;
	    							private JPanel umpumpenTDatenPanel;
	    								//menge
	    								private JPanel umpumpenT1Panel;
    										private JLabel lblUmpumpenTMenge;
	    									private JNumberField txtUmpumpenTMenge;
	    									private JLabel lblUmpumpenTMenge2;
	    								//tank
    									private JPanel umpumpenTTankPanel;
	    								private JLabel lblUmpumpenTTank;
	    								private JSelectedTextField txtUmpumpenTTank;
	    								private JPanel umpumpenTTankButtonPanel;
	    									private JButton btUmpumpenTTankText;
	    									private JButton btUmpumpenTTankPlan;
	    								private JLabel lblUmpumpenTTankInhalt;
		    							//mischung
	    								private JPanel umpumpenTMischungPanel;
	    									private JLabel lblUmpumpenTMischung;
	    									private JIntegerField txtUmpumpenMischungT;
	    									private JPanel umpumpenTMischungSuche;
	    										private JButton btUmpumpenTMischungText;
	    										private JButton btUmpumpenTMischungID;	    									
	    							private JPanel umpumpenTButtonPanel;
	    								private JButton btUmpumpenTOK;
	    								
	    								
    	private JPanel buttonPanel;
    		private JPanel buttonPanelEast;
				private JButton btCancel;
				private JComboBox cmbDruckFormulare;
				private JCheckBox chkDuplex;
				private JButton btDrucken;
				private JButton btVorschau;
    			private JButton btHilfe;

    public static final int        	ACTION_CLOSE_CODE = 1001;
    public static final String     	ACTION_CLOSE_TEXT = "mischungbearbeitenfenster.action_close";
    public static final int        	ACTION_HIDE_CODE = 1002;
    public static final String     	ACTION_HIDE_TEXT = "action_hide";
    public static final int        	ACTION_HILFE_CODE = 1003;
    public static final String     	ACTION_HILFE_TEXT = "mischungbearbeitenfenster.action_hilfe";
    public static final int        	ACTION_TICKET_ADD_CODE = 1004;
    public static final String     	ACTION_TICKET_ADD_TEXT = "mischungbearbeitenfenster.action_ticket_add";
    public static final int        	ACTION_TICKET_DELETE_CODE = 1005;
    public static final String     	ACTION_TICKET_DELETE_TEXT = "mischungbearbeitenfenster.action_ticket_delete";
    public static final int        	ACTION_TICKET_CHECKALL_CODE = 1006;
    public static final String     	ACTION_TICKET_CHECKALL_TEXT = "mischungbearbeitenfenster.action_ticket_checkall";
    public static final int        	ACTION_TICKET_EDIT_CODE = 1007;
    public static final String     	ACTION_TICKET_EDIT_TEXT = "mischungbearbeitenfenster.action_ticket_bearbeiten";
    public static final int        	ACTION_REZEPTUR_CODE = 1008;
    public static final String      ACTION_REZEPTUR_TEXT = "mischungbearbeitenfenster.action_rezeptur";
    public static final int        	ACTION_REZEPTUR_REMOVE_CODE = 1009;
    public static final String      ACTION_REZEPTUR_REMOVE_TEXT = "mischungbearbeitenfenster.action_rezeptur_remove";
    public static final int        	ACTION_SAVE_CODE = 1010;
    public static final String     	ACTION_SAVE_TEXT = "mischungbearbeitenfenster.action_save";
    public static final int        	ACTION_CHECK_FREIGABE_CODE = 1011;
    public static final String     	ACTION_CHECK_FREIGABE_TEXT = "mischungbearbeitenfenster.action_check_freigabe";
    
    public static final int        	ACTION_ABSCHLUSS_V_OK_CODE = 1012;
    public static final String     	ACTION_ABSCHLUSSV_OK_TEXT = "mischungbearbeitenfenster.action_abschlussv_ok";
    public static final int        	ACTION_ABSCHLUSS_LOSNUMMER_CODE = 1013;
    public static final String     	ACTION_ABSCHLUSS_LOSNUMMER_TEXT = "mischungbearbeitenfenster.action_abschluss_losnummer_vorschlag";
    private static final int   		ACTION_TANKLISTE_PLAN_CODE = 1014;
    private static final String		ACTION_TANKLISTE_PLAN_TEXT = "tankliste_plan";
    private static final int   		ACTION_TANKLISTE_TEXT_CODE = 1015;
    private static final String		ACTION_TANKLISTE_TEXT_TEXT = "tankliste_text";
    public static final int        	ACTION_ABSCHLUSS_REZEPTUR_CODE = 1016;
    public static final String      ACTION_ABSCHLUSS_REZEPTUR_TEXT = "mischungbearbeitenfenster.action_rezeptur";
    public static final int        	ACTION_ABSCHLUSS_REZEPTUR_REMOVE_CODE = 1017;
    public static final String      ACTION_ABSCHLUSS_REZEPTUR_REMOVE_TEXT = "mischungbearbeitenfenster.action_rezeptur_remove";
    
    public static final int        	ACTION_UMPUMPEN_V_OK_CODE = 1018;
    public static final String     	ACTION_UMPUMPENV_OK_TEXT = "mischungbearbeitenfenster.action_umpumpenv_ok";
    private static final int   		ACTION_TANKLISTE_UMPUMPEN_V_PLAN_CODE = 1019;
    private static final String		ACTION_TANKLISTE_UMPUMPEN_V_PLAN_TEXT = "tankliste_plan";
    private static final int   		ACTION_TANKLISTE_UMPUMPEN_V_TEXT_CODE = 1020;
    private static final String		ACTION_TANKLISTE_UMPUMPEN_V_TEXT_TEXT = "tankliste_text";
    private static final int   		ACTION_TANKLISTE_UMPUMPEN_V_MISCHUNG_TEXT_CODE = 1021;
    private static final String		ACTION_TANKLISTE_UMPUMPEN_V_MISCHUNG_TEXT_TEXT = "mischungbearbeitenfenster.action_umpumpen_mischungv_text";
    private static final int   		ACTION_TANKLISTE_UMPUMPEN_V_MISCHUNG_ID_CODE = 1022;
    private static final String		ACTION_TANKLISTE_UMPUMPEN_V_MISCHUNG_ID_TEXT = "mischungbearbeitenfenster.action_umpumpen_mischungv_id"; 
    
    public static final int        	ACTION_UMPUMPEN_T_OK_CODE = 1023;
    public static final String     	ACTION_UMPUMPENT_OK_TEXT = "mischungbearbeitenfenster.action_umpumpent_ok";
    private static final int   		ACTION_TANKLISTE_UMPUMPEN_T_PLAN_CODE = 1024;
    private static final String		ACTION_TANKLISTE_UMPUMPEN_T_PLAN_TEXT = "tankliste_plan";
    private static final int   		ACTION_TANKLISTE_UMPUMPEN_T_TEXT_CODE = 1025;
    private static final String		ACTION_TANKLISTE_UMPUMPEN_T_TEXT_TEXT = "tankliste_text";
    private static final int   		ACTION_TANKLISTE_UMPUMPEN_T_MISCHUNG_TEXT_CODE = 1026;
    private static final String		ACTION_TANKLISTE_UMPUMPEN_T_MISCHUNG_TEXT_TEXT = "mischungbearbeitenfenster.action_umpumpen_mischungv_text";
    private static final int   		ACTION_TANKLISTE_UMPUMPEN_T_MISCHUNG_ID_CODE = 1027;
    private static final String		ACTION_TANKLISTE_UMPUMPEN_T_MISCHUNG_ID_TEXT = "mischungbearbeitenfenster.action_umpumpen_mischungv_id"; 

    public static final int        	ACTION_ABSCHLUSS_T_OK_CODE = 1028;
    public static final String     	ACTION_ABSCHLUSS_T_OK_TEXT = "mischungbearbeitenfenster.action_abschlusst_ok";
    public static final int        	ACTION_ABSCHLUSS_T_LOSNUMMER_CODE = 1029;
    public static final String     	ACTION_ABSCHLUSS_T_LOSNUMMER_TEXT = "mischungbearbeitenfenster.action_abschluss_losnummer_vorschlag";
    private static final int   		ACTION_TANKLISTE_T_PLAN_CODE = 1030;
    private static final String		ACTION_TANKLISTE_T_PLAN_TEXT = "tankliste_plan";
    private static final int   		ACTION_TANKLISTE_T_TEXT_CODE = 1031;
    private static final String		ACTION_TANKLISTE_T_TEXT_TEXT = "tankliste_text";
    public static final int        	ACTION_ABSCHLUSS_T_REZEPTUR_CODE = 1032;
    public static final String      ACTION_ABSCHLUSS_T_REZEPTUR_TEXT = "mischungbearbeitenfenster.action_rezeptur";
    public static final int        	ACTION_ABSCHLUSS_T_REZEPTUR_REMOVE_CODE = 1033;
    public static final String      ACTION_ABSCHLUSS_T_REZEPTUR_REMOVE_TEXT = "mischungbearbeitenfenster.action_rezeptur_remove";
    public static final int        	ACTION_ABSCHLUSS_NULL_CODE = 1034;
    public static final String      ACTION_ABSCHLUSS_NULL_TEXT = "mischungbearbeitenfenster.action_nullabschluss";
    public static final int        	ACTION_DRUCKEN_CODE = 1035;
    public static final String      ACTION_DRUCKEN_TEXT = "mischungsfenster.action_drucken";
    public static final int        	ACTION_VORSCHAU_CODE = 1036;
    public static final String      ACTION_VORSCHAU_TEXT = "mischungsfenster.action_vorschau";
    public static final int		 	ACTION_STAMMBAUM_CODE=1037;    
    public static final String     ACTION_STAMMBAUM_TEXT = "mischungsfenster.action_stammbaum";
    
    public static final int		 	ACTION_ZUSAMMENFASSEN_CODE=1038;    
    public static final String     ACTION_ZUSAMMENFASSEN_TEXT = "mischungsfenster.action_zusammenfassen";
    
	public static final int ACTION_ADRESSLISTE_BEARBEITEN_CODE = 1039;
	public static final String ACTION_ADRESSLISTE_BEARBEITEN_TEXT = "mischungbearbeitenfenster.action_adressen_bearbeiten";
	public static final int ACTION_ADRESSLISTE_LOESCHEN_CODE = 1040;
	public static final String ACTION_ADRESSLISTE_LOESCHEN_TEXT = "mischungbearbeitenfenster.action_adressen_loeschen";

	public static final int ACTION_TICKETFILTER_CLEAR_CODE = 1041;
	public static final String ACTION_TICKETFILTER_CLEAR_TEXT = "mischungbearbeitenfenster.action_ticketfilter_clear";
	public static final int ACTION_TICKETFILTER_SEARCH_CODE = 1042;
	public static final String ACTION_TICKETFILTER_SEARCH_TEXT = "mischungbearbeitenfenster.action_ticketfilter_search";    
	
    
	public static final int ACTION_CHART_CODE = 1043;
	public static final String ACTION_CHART_TEXT = "mischungbearbeitenfenster.action_chart";    
	
    private static final int		MAX_TRANSAKTIONS_COLUMN=3;
    private static final int		T_DATUM = 0;
    private static final int		T_BEZEICHNUNG=1;
    private static final int		T_USER = 2;
    
    private static final int		MAX_TICKETS_COLUMN = 8;
    private static final int		TI_TYP = 0;
    private static final int		TI_NUMMER = 1;
    private static final int		TI_TRANSAKTION = 2;
    private static final int		TI_BEZEICHNUNG = 3;
    private static final int		TI_LA = 4;
    private static final int		TI_PERCENTAGE = 5;
    private static final int		TI_STAERKE = 6;
    private static final int		TI_USER = 7;
    
    private static final int		TAB_HILFE 		= 0;
    private static final int		TAB_ZUSAMMENFASSEN = 1;
    private static final int		TAB_NULL = 2;
    private static final int		TAB_ABSCHLUSSV	= 3;
    private static final int		TAB_ABSCHLUSST	= 4;
    private static final int		TAB_UMPUMPENV	= 5;
    private static final int		TAB_UMPUMPENT	= 6;
    
    private static final int		QUERY_REZEPTUR_MAIN 		= 1;
    private static final int		QUERY_REZEPTUR_ABSCHLUSS 	= 2;
    private static final int		QUERY_REZEPTUR_ABSCHLUSS_T 	= 3;    
	JRzFrame								parent;
	MischungsItem						mischung;
	TicketListe								tickets;
	boolean									refreshTickets = false;
	Color										btBackground;
	ZutatenDialog						zd;
	Icon										freigegeben;
	Icon										nicht_freigegeben;
	Icon										hilfe;
    TankDialog								td;
    MischungsDialog					md;
    int											abschlussRezeptur = 0;
    double									abschlussStaerke = 0;
    String										abschlussTitel = "";
    double									abschlussLiter = 0;
    
    int											initialRezeptur;
    String										initialBezeichnung;
    String										initialBemerkungen;
    String										initialSorte;
    String										initialAdressen;
    int											initialLager;
    String										initialLagerText;
    StichwortListe						initialAdressListe;
    
    javax.swing.Timer  			 	ergebnisTimer;
	
    /** Creates new form HilfeFenster */
    public MischungBearbeitenFenster(RzPro r, String name,Object extendedData) {
        super(r,name,extendedData);
        freigegeben = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/mischungbearbeitenfenster.status_freigegeben.png"));
        nicht_freigegeben = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/mischungbearbeitenfenster.status_nicht_freigegeben.png"));
        hilfe = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/action_hilfe.png"));
        ergebnisTimer = new javax.swing.Timer(rz.getOptionFactory().getOption("list.timeout",RzPro.LIST_TIMEOUT), new ActionListener() {
	            public void actionPerformed(ActionEvent evt) {
	                 ergebnisTimerEvent();
	            }
	      });
        createActions();
        createGUIComponents();
        setGUIComponents();
        getMessage((MessageItem)extendedData);
    }


    @Override
	public void createGUIComponents() {
		mb = new JMenuBar();
		mnuDatei = new JMenu();
			mb.add(mnuDatei);
        mnuBearbeiten = new JMenu();
        	mb.add(mnuBearbeiten);
        mnuExtras = new JMenu();
        	mb.add(mnuExtras);
        mnuHilfe = new JMenu();
        	mb.add(mnuHilfe);
		setJMenuBar(mb);
		mainPanel = new JPanel(new BorderLayout());
			toolbarPanel = new JPanel(new BorderLayout());
				tb1 = new JToolBar();
				tb1.setFloatable(false);
				tb1.setRollover(true);
				toolbarPanel.add(tb1);
			mainPanel.add(toolbarPanel,BorderLayout.NORTH);
			contentPanel = new JPanel(new BorderLayout());
				
			splPanel1 = new JSplitPane();
				splPanel1.setOrientation(JSplitPane.VERTICAL_SPLIT);
    			listenPanel = new JPanel(new BorderLayout());
    				kopfPanel = new JPanel(new BorderLayout());
    					kopfPanel.setBorder(BorderFactory.createEtchedBorder());
    					lblMischungNummer = new JLabel();
    						lblMischungNummer.setHorizontalAlignment(SwingConstants.CENTER);
    							lblMischungNummer.setBorder(BorderFactory.createEtchedBorder());
    						kopfPanel.add(lblMischungNummer,BorderLayout.NORTH);
    						kopf1Panel = new JPanel(new BorderLayout());
    							kopf1Panel.setBorder(BorderFactory.createEtchedBorder());
    							kopf1TextPanel = new JPanel(new BorderLayout());
    		   						txtMischungBezeichnung = new JSelectedTextField();
    		   						kopf1TextPanel.add(txtMischungBezeichnung,BorderLayout.CENTER);
    							kopf1Panel.add(kopf1TextPanel,BorderLayout.NORTH);
    							kopf1ButtonPanel = new JPanel(new BorderLayout());
    								btRezeptur = new JButton();
    									btBackground = btRezeptur.getBackground();
    							kopf1ButtonPanel.add(btRezeptur,BorderLayout.WEST);
    							btRezepturRemove  = new JButton();
    							kopf1ButtonPanel.add(btRezepturRemove,BorderLayout.CENTER);
		    					cmbSorte = new JComboBox(rz.getDatabase().getMischungen().getSorten().toArray());
		    					kopf1ButtonPanel.add(cmbSorte,BorderLayout.EAST);
    						kopf1Panel.add(kopf1ButtonPanel,BorderLayout.SOUTH);
    					kopfPanel.add(kopf1Panel,BorderLayout.WEST);
    					kopf2Panel = new JPanel(new BorderLayout());
    						kopf2Panel.setBorder(BorderFactory.createEtchedBorder());
    						lblBemerkungen = new JLabel();
    							lblBemerkungen.setHorizontalAlignment(SwingConstants.TRAILING);
    						kopf2Panel.add(lblBemerkungen,BorderLayout.WEST);
    						scrBemerkungen = new JScrollPane();
    							txtBemerkungen = new JTextArea();
    							scrBemerkungen.setViewportView(txtBemerkungen);
    						kopf2Panel.add(scrBemerkungen,BorderLayout.CENTER);    
    						
    						// linkes Panel...Adressen
    						adressen = new JPanel(new BorderLayout());
    							adressen.setBorder(BorderFactory.createEtchedBorder());
    						listenPanel.add(adressen);
    						lblAdressenTitel = new JLabel();
    						lblAdressenTitel.setHorizontalAlignment(SwingConstants.CENTER);
    						adressen.add(lblAdressenTitel, BorderLayout.NORTH);
    						//adressenScrollPane.setPreferredSize(new Dimension(100, 150));
    						lstAdressen = new JLabel();
    						adressen.add(lstAdressen, BorderLayout.CENTER);
    						adressenButtonPane = new JPanel(new GridLayout(1, 2));
    						btAdressenBearbeiten = new JButton();
    						adressenButtonPane.add(btAdressenBearbeiten);
    						btAdressenLoeschen = new JButton();
    						adressenButtonPane.add(btAdressenLoeschen);
    						adressen.add(adressenButtonPane, BorderLayout.SOUTH);
    					kopf2Panel.add(adressen,BorderLayout.EAST);	
    						
    					kopfPanel.add(kopf2Panel,BorderLayout.CENTER);
    					kopf3Panel=new JPanel(new BorderLayout());
    						kopf3Panel.setBorder(BorderFactory.createEtchedBorder());
    						btSave = new JButton();
    						kopf3Panel.add(btSave,BorderLayout.SOUTH);
    						cmbLager = new JComboBox();
    						kopf3Panel.add(cmbLager,BorderLayout.NORTH);
    					kopfPanel.add(kopf3Panel,BorderLayout.EAST);
    				listenPanel.add(kopfPanel,BorderLayout.NORTH);
    					splListenTablePanel = new JSplitPane();
    						splListenTablePanel.setOrientation(JSplitPane.HORIZONTAL_SPLIT);
    						splTablePanel = new JSplitPane();
    							splTablePanel.setOrientation(JSplitPane.HORIZONTAL_SPLIT);
    					splListenTablePanel.setLeftComponent(splTablePanel);
		    					
		    					transaktionenPanel = new JPanel(new BorderLayout());
		    						transaktionenPanel.setBorder(BorderFactory.createEtchedBorder());
		    						lblTransaktionen = new JLabel();
		    							lblTransaktionen.setHorizontalAlignment(SwingConstants.CENTER);
		    						transaktionenPanel.add(lblTransaktionen,BorderLayout.NORTH);
		    						scrTransaktionen = new JScrollPane();
		    							tblTransaktionen = new JTable();
		    								tblTransaktionen.setName("mischungbearbeitenfenster.transaktionen");
		    								tblTransaktionen.getSelectionModel().addListSelectionListener(new javax.swing.event.ListSelectionListener() {
									            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
									            	if(evt.getValueIsAdjusting()) {
														return;
													}
									                tblTransaktionenValueChanged();
									            }
									        });
		    							scrTransaktionen.setViewportView(tblTransaktionen);
		    						transaktionenPanel.add(scrTransaktionen,BorderLayout.CENTER);
		    						transaktionenButtonPanel = new JPanel(new BorderLayout());
		    							transaktionsAusgabePanel = new JPanel(new BorderLayout());
		    								scrTransaktionsAusgabe = new JScrollPane();
		    									txtTransaktionsAusgabe = new JEditorPane();
		    										txtTransaktionsAusgabe.setEditable(false);
		    										txtTransaktionsAusgabe.setContentType("text/html");
		    										txtTransaktionsAusgabe.addHyperlinkListener(new javax.swing.event.HyperlinkListener() {
		    								            public void hyperlinkUpdate(javax.swing.event.HyperlinkEvent evt) {
		    								                if(evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED){
		    									                	linkAction(txtTransaktionsAusgabe);
		    								                	}
		    									            }
		    									        });
		    									scrTransaktionsAusgabe.setViewportView(txtTransaktionsAusgabe);
		    								transaktionsAusgabePanel.add(scrTransaktionsAusgabe);
		    							transaktionsButtonPanel = new JPanel(new GridLayout(1,2));
		    								btTransaktionAdd = new JButton();
		    								transaktionsButtonPanel.add(btTransaktionAdd);
		    								btTransaktionDelete = new JButton();
		    								transaktionsButtonPanel.add(btTransaktionDelete);
		    							transaktionenButtonPanel.add(transaktionsAusgabePanel,BorderLayout.CENTER);
		    							transaktionenButtonPanel.add(transaktionsButtonPanel,BorderLayout.SOUTH);
		    						transaktionenPanel.add(transaktionenButtonPanel,BorderLayout.SOUTH);
		    						
		    					ticketPanel = new JPanel(new BorderLayout());	
		    						ticketPanel.setBorder(BorderFactory.createEtchedBorder());
			    					ticketSelectionPanel = new JPanel(new BorderLayout());
		    							 lblTicketSelection = new JLabel();
		    							 	lblTicketSelection.setHorizontalAlignment(SwingConstants.TRAILING);
		    							 ticketSelectionPanel.add(lblTicketSelection,BorderLayout.WEST);
		    							 txtTicketSelection = new JSelectedTextField();
		    							 	txtTicketSelection.setColumns(12);
		    							 	txtTicketSelection.addKeyListener(new java.awt.event.KeyAdapter() {
									            public void keyReleased(java.awt.event.KeyEvent evt) {
								                  if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
								                	  if(!txtTicketSelection.getText().trim().equals("")) {   
									            		selectTickets(txtTicketSelection.getText().trim());
								                	  }
								                  }
								            }
								        });
		    							 ticketSelectionPanel.add(txtTicketSelection,BorderLayout.CENTER);
		    							 ticketButtonPanel = new JPanel(new GridLayout(1,2));
		    							 	btTicketSearch = new JButton();
		    							 	ticketButtonPanel.add(btTicketSearch);
		    							 	btTicketFilterClear = new JButton();
		    							 	ticketButtonPanel.add(btTicketFilterClear);
		    							ticketSelectionPanel.add(ticketButtonPanel,BorderLayout.EAST);
		    						ticketPanel.add(ticketSelectionPanel,BorderLayout.NORTH);
		    						scrTickets = new JScrollPane();
		    							tblTickets = new JTable();
								        JTableHeader header = tblTickets.getTableHeader();
								        header.addMouseListener(new ColumnHeaderListener());
								        //test
										tblTickets.setName("mischungbearbeitenfenster.tickets");
										tblTickets.getSelectionModel().addListSelectionListener(new javax.swing.event.ListSelectionListener() {
								            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
								            	if(evt.getValueIsAdjusting()) {
													return;
												}
								               tblTicketsValueChanged();
								            }
								        });
		    						scrTickets.setViewportView(tblTickets);
		    					ticketPanel.add(scrTickets,BorderLayout.CENTER);
		    					ticketButtonPanel = new JPanel(new BorderLayout());
		    						btEditTicket = new JButton();
		    							ticketButtonPanel.add(btEditTicket,BorderLayout.WEST);
		    						lblTicketSumme = new JLabel();
		    							lblTicketSumme.setHorizontalAlignment(SwingConstants.CENTER);
		    							ticketButtonPanel.add(lblTicketSumme,BorderLayout.CENTER);
		    						btCheckAll = new JButton();
		    							ticketButtonPanel.add(btCheckAll,BorderLayout.EAST);
		    					ticketPanel.add(ticketButtonPanel,BorderLayout.SOUTH);
		    				splTablePanel.setLeftComponent(transaktionenPanel);
		    				splTablePanel.setRightComponent(ticketPanel);
		    			
    				detailPanel = new JPanel(new BorderLayout());
    					detailPanel.setBorder(BorderFactory.createEtchedBorder());
    					lblDetail = new JLabel();
    						lblDetail.setHorizontalAlignment(SwingConstants.CENTER);
    					detailPanel.add(lblDetail, BorderLayout.NORTH);
    					scrDetail = new JScrollPane();
    						txtDetail = new JEditorPane();
    							txtDetail.setContentType("text/html");
    							txtDetail.setEditable(false);
    							scrDetail.setViewportView(txtDetail);
    							txtDetail.addHyperlinkListener(new javax.swing.event.HyperlinkListener() {
						            public void hyperlinkUpdate(javax.swing.event.HyperlinkEvent evt) {
						                if(evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED){
							                	linkAction(txtDetail);
						                	}
							            }
							        });
    					detailPanel.add(scrDetail,BorderLayout.CENTER);
    					detailButtonPanel=new JPanel(new BorderLayout());
    						chkMischungen = new JCheckBox();
    						chkMischungen.addActionListener(new ActionListener() {
    							public void actionPerformed(ActionEvent evt) {
    								rz.getOptionFactory().setOption("mischungbearbeitenfenster.mischungen_anzeigen",chkMischungen.isSelected()?1:0);
    								rz.getOptionFactory().saveOptions();
    								refreshAusgabe2();
    		    	        	}
    		                });
    						chkAlle = new JCheckBox();
    						chkAlle.addActionListener(new ActionListener() {
    							public void actionPerformed(ActionEvent evt) {
    								rz.getOptionFactory().setOption("mischungbearbeitenfenster.alle_tickets_anzeigen",chkAlle.isSelected()?1:0);
    								rz.getOptionFactory().saveOptions();
    								refreshAusgabe2();
    		    	        	}
    		                });
    						detailButtonPanel.add(chkMischungen,BorderLayout.EAST);
    						detailButtonPanel.add(chkAlle,BorderLayout.WEST);
    					detailPanel.add(detailButtonPanel,BorderLayout.SOUTH);
    				splListenTablePanel.setRightComponent(detailPanel);
    				listenPanel.add(splListenTablePanel,BorderLayout.CENTER);
    			splPanel1.setTopComponent(listenPanel);
    			actionPanel = new JPanel(new BorderLayout());
    				actionPanel.setBorder(BorderFactory.createEtchedBorder());
    					infoPanel = new JPanel();
    						infoPanel.setLayout(new BoxLayout(infoPanel,BoxLayout.LINE_AXIS));
    						infoPanel.setBorder(BorderFactory.createEtchedBorder());
    						btPruefen = new JButton();
    						infoPanel.add(btPruefen);
    						lblLa = new JLabel();
    						infoPanel.add(lblLa);
    						lblStatusIcon = new JLabel();
    						infoPanel.add(lblStatusIcon);
    						lblStatus = new JLabel();
    						infoPanel.add(lblStatus);
    						lblStatusDetail = new JLabel();
    						infoPanel.add(lblStatusDetail);
    					actionPanel.add(infoPanel,BorderLayout.NORTH);
    				aktionenPanel = new JPanel(new BorderLayout());
    					aktionenPanel.setBorder(BorderFactory.createEtchedBorder());
    						scrAktionen = new JScrollPane();
    							tabAktionen = new JTabbedPane();
    							tabAktionen.setTabLayoutPolicy(JTabbedPane.WRAP_TAB_LAYOUT);
    							tabAktionen.setTabPlacement(JTabbedPane.LEFT);
    							tabAktionen.addChangeListener(new ChangeListener() {
    							    public void stateChanged(ChangeEvent e) {
    							        tabChangedAction(tabAktionen.getSelectedIndex());
    							    }
    							});
    							/*
    							 * Hilfe
    							 */
    							tabHilfe = new JPanel(new BorderLayout());
    								lblHilfe = new JLabel();
    								tabHilfe.add(lblHilfe,BorderLayout.CENTER);
    							tabAktionen.add(tabHilfe);
    							
    							/*---------------------------------
    							 * zusammenfassen
    							 -----------------------------------
    							 */
    	    					tabZusammenfassen = new JPanel(new BorderLayout());
    	    						tabZusammenfassen.setBorder(BorderFactory.createEtchedBorder());
	    							zusammenfassenButtonPanel = new JPanel(new BorderLayout());
	    								zusammenfassenButtonPanel.setBorder(BorderFactory.createEtchedBorder());
	    								btZusammenfassen = new JButton();
	    								btZusammenfassen.setBackground(rz.getOptionFactory().getRGBColor("mischungen.ok_button_color"));
	    								zusammenfassenButtonPanel.add(btZusammenfassen,BorderLayout.EAST);
	    							tabZusammenfassen.add(zusammenfassenButtonPanel,BorderLayout.SOUTH);
	    						tabAktionen.add(tabZusammenfassen);
    							/*
    							 * Null Abschluss
    							 */
    							tabNullAbschluss = new JPanel(new BorderLayout());
									nullAbschlussButtonPanel = new JPanel(new BorderLayout());
										btNullAbschluss = new JButton();
										btNullAbschluss.setBackground(rz.getOptionFactory().getRGBColor("mischungen.ok_button_color"));
										nullAbschlussButtonPanel.add(btNullAbschluss, BorderLayout.EAST);
								tabNullAbschluss.add(nullAbschlussButtonPanel,BorderLayout.SOUTH);
									
								tabAktionen.add(tabNullAbschluss);
    							/*
    							 * Abschluss vollständig
    							 */
    							tabAbschlussV = new JPanel(new BorderLayout());
    								tabAbschlussV2 = new JPanel(new BorderLayout());
    	    						abschlussVDatenPanel = new JPanel();
    	    							abschlussVDatenPanel.setLayout(new BoxLayout(abschlussVDatenPanel,BoxLayout.PAGE_AXIS));
    	    							abschlussVDatenPanel.setBorder(BorderFactory.createEtchedBorder());
    	    							
    	    							//Rezeptur
    	    							abschlussDatenVRezepturPanel = new JPanel();
    	    							abschlussDatenVRezepturPanel.setLayout(new BoxLayout(abschlussDatenVRezepturPanel,BoxLayout.LINE_AXIS));
    	    								abschlussDatenVRezepturPanel.setBorder(BorderFactory.createEtchedBorder());
    	    									lblabschlussVDatenTitel = new JLabel();
    	    										lblabschlussVDatenTitel.setHorizontalAlignment(SwingConstants.LEADING);
    	    									abschlussDatenVRezepturPanel.add(lblabschlussVDatenTitel);
    	    									lblabschlussVDatenRezeptur = new JLabel();
    	    										lblabschlussVDatenRezeptur.setBorder(BorderFactory.createRaisedBevelBorder());
    	    									abschlussDatenVRezepturPanel.add(lblabschlussVDatenRezeptur);
    	    									btabschlussVDatenRezeptur = new JButton();
    	    									abschlussDatenVRezepturPanel.add(btabschlussVDatenRezeptur);
    	    									btabschlussVDatenRezepturRemove = new JButton();
    	    									abschlussDatenVRezepturPanel.add(btabschlussVDatenRezepturRemove);
	    								abschlussVDatenPanel.add(abschlussDatenVRezepturPanel);
	    								//Menge
	    								abschlussVDatenMengenPanel = new JPanel();
	    								abschlussVDatenMengenPanel.setLayout(new BoxLayout(abschlussVDatenMengenPanel,BoxLayout.LINE_AXIS));
	    									abschlussVDatenMengenPanel.setBorder(BorderFactory.createEtchedBorder());
	    									lblabschlussVDatenMengeTitel = new JLabel();
	    									abschlussVDatenMengenPanel.add(lblabschlussVDatenMengeTitel);
	    									lblabschlussVDatenMenge = new JLabel();
	    									abschlussVDatenMengenPanel.add(lblabschlussVDatenMenge);
	    									txtabschlussVDatenMengeStaerke = new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_STAERKE),0,0,99.99999);
	    									txtabschlussVDatenMengeStaerke.addKeyListener(new java.awt.event.KeyAdapter() {
										            public void keyReleased(java.awt.event.KeyEvent evt) {
									                    if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
									                    	setAbschlussLiter();
									                    }
									            }
									        });
	    									abschlussVDatenMengenPanel.add(txtabschlussVDatenMengeStaerke);
	    									lblabschlussVDatenMengeStaerke = new JLabel();
    											lblabschlussVDatenMengeStaerke.setHorizontalAlignment(SwingConstants.LEADING);
    										abschlussVDatenMengenPanel.add(lblabschlussVDatenMengeStaerke);
	    									lblabschlussVDatenMengeLiter = new JLabel();
	    									abschlussVDatenMengenPanel.add(lblabschlussVDatenMengeLiter);
    	    							abschlussVDatenPanel.add(abschlussVDatenMengenPanel);
    	    							
    	    							//Tank
	    								abschlussVTankPanel = new JPanel(new BorderLayout());
	    									abschlussVTankPanel.setBorder(BorderFactory.createEtchedBorder());
	    									lblAbschlussVTank = new JLabel();
	    										lblAbschlussVTank.setHorizontalAlignment(SwingConstants.TRAILING);
	    									abschlussVTankPanel.add(lblAbschlussVTank,BorderLayout.WEST);
	    									txtAbschlussVTank = new JSelectedTextField();
	    										txtAbschlussVTank.addKeyListener(new java.awt.event.KeyAdapter() {
										            public void keyReleased(java.awt.event.KeyEvent evt) {
										                    if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
										                    	setAbschlussVTankInhaltLabel();
										                    }
										            }
										        });
	    										txtAbschlussVTank.addFocusListener(new FocusListener() {
													public void focusGained(FocusEvent arg0) {
													}
													public void focusLost(FocusEvent arg0) {
								                    	setAbschlussVTankInhaltLabel();
													}
						      					});
	    									abschlussVTankPanel.add(txtAbschlussVTank);
	    									abschlussVTankButtonPanel = new JPanel(new GridLayout(1,2));
	    										btAbschlussVTankText = new JButton();
	    										abschlussVTankButtonPanel.add(btAbschlussVTankText);
	    										btAbschlussVTankPlan = new JButton();
	    										abschlussVTankButtonPanel.add(btAbschlussVTankPlan);
	    									abschlussVTankPanel.add(abschlussVTankButtonPanel,BorderLayout.EAST);
	    									lblAbschlussVTankInhalt = new JLabel();
	    									abschlussVTankPanel.add(lblAbschlussVTankInhalt,BorderLayout.SOUTH);
	    								abschlussVDatenPanel.add(abschlussVTankPanel);
	    								
	    								
	    								
	    								abschlussVLosnummerPanel = new JPanel(new BorderLayout());
	    									abschlussVLosnummerPanel.setBorder(BorderFactory.createEtchedBorder());
	    									lblAbschlussVLosnummer = new JLabel();
	    										lblAbschlussVLosnummer.setHorizontalAlignment(SwingConstants.TRAILING);
	    									abschlussVLosnummerPanel.add(lblAbschlussVLosnummer,BorderLayout.WEST);
	    									txtAbschlussVLosnummer = new JSelectedTextField();
	    									abschlussVLosnummerPanel.add(txtAbschlussVLosnummer,BorderLayout.CENTER);
	    									btAbschlussVLosnummerVorschlag = new JButton();
	    									abschlussVLosnummerPanel.add(btAbschlussVLosnummerVorschlag,BorderLayout.EAST);
	    								abschlussVDatenPanel.add(abschlussVLosnummerPanel,BorderLayout.CENTER);
	    									
	    						
	    								tabAbschlussV2.add(abschlussVDatenPanel,BorderLayout.NORTH);
	    								tabAbschlussV.add(tabAbschlussV2,BorderLayout.CENTER);
	    								
	    								
	    								abschlussVButtonPanel = new JPanel(new BorderLayout());
    										btAbschlussVOK = new JButton();
    										btAbschlussVOK.setBackground(rz.getOptionFactory().getRGBColor("mischungen.ok_button_color"));
    									abschlussVButtonPanel.add(btAbschlussVOK,BorderLayout.EAST);
    								tabAbschlussV.add(abschlussVButtonPanel,BorderLayout.SOUTH);
    							tabAktionen.add(tabAbschlussV);
    							
    							/*
    							 * Abschluss teilweise
    							 */
    							tabAbschlussT = new JPanel(new BorderLayout());
    								tabAbschlussT2 = new JPanel(new BorderLayout());
    	    						abschlussTDatenPanel = new JPanel();
    	    							abschlussTDatenPanel.setLayout(new BoxLayout(abschlussTDatenPanel,BoxLayout.PAGE_AXIS));
    	    							abschlussTDatenPanel.setBorder(BorderFactory.createEtchedBorder());
    	    							
    	    							//Rezeptur
    	    							abschlussTDatenRezepturPanel = new JPanel();
    	    							abschlussTDatenRezepturPanel.setLayout(new BoxLayout(abschlussTDatenRezepturPanel,BoxLayout.LINE_AXIS));
    	    								abschlussTDatenRezepturPanel.setBorder(BorderFactory.createEtchedBorder());
    	    									lblabschlussTDatenTitel = new JLabel();
    	    										lblabschlussTDatenTitel.setHorizontalAlignment(SwingConstants.LEADING);
    	    									abschlussTDatenRezepturPanel.add(lblabschlussTDatenTitel);
    	    									lblabschlussTDatenRezeptur = new JLabel();
    	    										lblabschlussTDatenRezeptur.setBorder(BorderFactory.createRaisedBevelBorder());
    	    									abschlussTDatenRezepturPanel.add(lblabschlussTDatenRezeptur);
    	    									btabschlussTDatenRezeptur = new JButton();
    	    									abschlussTDatenRezepturPanel.add(btabschlussTDatenRezeptur);
    	    									btabschlussTDatenRezepturRemove = new JButton();
    	    									abschlussTDatenRezepturPanel.add(btabschlussTDatenRezepturRemove);
	    								abschlussTDatenPanel.add(abschlussTDatenRezepturPanel);
	    								//Menge
	    								abschlussTDatenMengenPanel = new JPanel();
	    								abschlussTDatenMengenPanel.setLayout(new BoxLayout(abschlussTDatenMengenPanel,BoxLayout.LINE_AXIS));
	    									abschlussTDatenMengenPanel.setBorder(BorderFactory.createEtchedBorder());
	    									lblabschlussTDatenMengeTitel = new JLabel();
	    									abschlussTDatenMengenPanel.add(lblabschlussTDatenMengeTitel);
	    									txtabschlussTDatenMenge  = new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_NORMAL),0,0,Double.POSITIVE_INFINITY);
	    									txtabschlussTDatenMenge.addKeyListener(new java.awt.event.KeyAdapter() {
									            public void keyReleased(java.awt.event.KeyEvent evt) {
								                    if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
								                    	txtabschlussTDatenMenge.validateField();
								                    	setAbschlussTLiter();
								                    }
									            }
	    									});
	    									txtabschlussTDatenMenge.addFocusListener(new FocusListener() {
												public void focusGained(FocusEvent arg0) {
												}
												public void focusLost(FocusEvent arg0) {
													txtabschlussTDatenMenge.validateField();
								                   	setAbschlussTLiter();
							                    }
					      					});
	    									abschlussTDatenMengenPanel.add(txtabschlussTDatenMenge); 
	    									lblabschlussTDatenMenge = new JLabel();
	    									abschlussTDatenMengenPanel.add(lblabschlussTDatenMenge);
	    									txtabschlussTDatenMengeStaerke = new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_STAERKE),0,0,99.99999);
	    									txtabschlussTDatenMengeStaerke.addKeyListener(new java.awt.event.KeyAdapter() {
										            public void keyReleased(java.awt.event.KeyEvent evt) {
									                    if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
									                    	setAbschlussTLiter();
									                    }
									            }
									        });
	    									abschlussTDatenMengenPanel.add(txtabschlussTDatenMengeStaerke);
	    									lblabschlussTDatenMengeStaerke = new JLabel();
    											lblabschlussTDatenMengeStaerke.setHorizontalAlignment(SwingConstants.LEADING);
    										abschlussTDatenMengenPanel.add(lblabschlussTDatenMengeStaerke);
	    									lblabschlussTDatenMengeLiter = new JLabel();
	    									abschlussTDatenMengenPanel.add(lblabschlussTDatenMengeLiter);
    	    							abschlussTDatenPanel.add(abschlussTDatenMengenPanel);
    	    							
    	    							//Tank
	    								abschlussTTankPanel = new JPanel(new BorderLayout());
	    									abschlussTTankPanel.setBorder(BorderFactory.createEtchedBorder());
	    									lblAbschlussTTank = new JLabel();
	    										lblAbschlussTTank.setHorizontalAlignment(SwingConstants.TRAILING);
	    									abschlussTTankPanel.add(lblAbschlussTTank,BorderLayout.WEST);
	    									txtAbschlussTTank = new JSelectedTextField();
	    										txtAbschlussTTank.addKeyListener(new java.awt.event.KeyAdapter() {
										            public void keyReleased(java.awt.event.KeyEvent evt) {
										                    if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
										                    	setAbschlussTTankInhaltLabel();
										                    }
										            }
										        });
	    										txtAbschlussTTank.addFocusListener(new FocusListener() {
													public void focusGained(FocusEvent arg0) {
													}
													public void focusLost(FocusEvent arg0) {
								                    	setAbschlussTTankInhaltLabel();
													}
						      					});
	    									abschlussTTankPanel.add(txtAbschlussTTank);
	    									abschlussTTankButtonPanel = new JPanel(new GridLayout(1,2));
	    										btAbschlussTTankText = new JButton();
	    										abschlussTTankButtonPanel.add(btAbschlussTTankText);
	    										btAbschlussTTankPlan = new JButton();
	    										abschlussTTankButtonPanel.add(btAbschlussTTankPlan);
	    									abschlussTTankPanel.add(abschlussTTankButtonPanel,BorderLayout.EAST);
	    									lblAbschlussTTankInhalt = new JLabel();
	    									abschlussTTankPanel.add(lblAbschlussTTankInhalt,BorderLayout.SOUTH);
	    								abschlussTDatenPanel.add(abschlussTTankPanel);
	    								
	    								
	    								
	    								abschlussTLosnummerPanel = new JPanel(new BorderLayout());
	    									abschlussTLosnummerPanel.setBorder(BorderFactory.createEtchedBorder());
	    									lblAbschlussTLosnummer = new JLabel();
	    										lblAbschlussTLosnummer.setHorizontalAlignment(SwingConstants.TRAILING);
	    									abschlussTLosnummerPanel.add(lblAbschlussTLosnummer,BorderLayout.WEST);
	    									txtAbschlussTLosnummer = new JSelectedTextField();
	    									abschlussTLosnummerPanel.add(txtAbschlussTLosnummer,BorderLayout.CENTER);
	    									btAbschlussTLosnummerVorschlag = new JButton();
	    									abschlussTLosnummerPanel.add(btAbschlussTLosnummerVorschlag,BorderLayout.EAST);
	    								abschlussTDatenPanel.add(abschlussTLosnummerPanel,BorderLayout.CENTER);
	    									
	    						
	    								tabAbschlussT2.add(abschlussTDatenPanel,BorderLayout.NORTH);
	    								tabAbschlussT.add(tabAbschlussT2,BorderLayout.CENTER);
	    								
	    								abschlussTButtonPanel = new JPanel(new BorderLayout());
    										btAbschlussTOK = new JButton();
    										btAbschlussTOK.setBackground(rz.getOptionFactory().getRGBColor("mischungen.ok_button_color"));
    									abschlussTButtonPanel.add(btAbschlussTOK,BorderLayout.EAST);
    								tabAbschlussT.add(abschlussTButtonPanel,BorderLayout.SOUTH);
    							tabAktionen.add(tabAbschlussT);
    							
    							
    							
    							/*
    							 * --------------------------------------------------
    							 * Umpumpen vollständig
    							 * --------------------------------------------------
    							 */
    							tabUmpumpenV = new JPanel(new BorderLayout());
    								tabUmpumpenV2 = new JPanel(new BorderLayout());
    									//Datenpanel
	    								umpumpenVDatenPanel= new JPanel();
	    									umpumpenVDatenPanel.setLayout(new BoxLayout(umpumpenVDatenPanel,BoxLayout.PAGE_AXIS));
	    									umpumpenVDatenPanel.setBorder(BorderFactory.createEtchedBorder());
	    									//Menge
	    									umpumpenV1Panel = new JPanel(new BorderLayout());
    											umpumpenV1Panel.setBorder(BorderFactory.createEtchedBorder());
	    											lblUmpumpenVMenge = new JLabel();
	    										umpumpenV1Panel.add(lblUmpumpenVMenge);
	    									umpumpenVDatenPanel.add(umpumpenV1Panel);
	    									//Tank
	    									umpumpenVTankPanel = new JPanel(new BorderLayout());
	    									umpumpenVTankPanel.setBorder(BorderFactory.createEtchedBorder());
	    									lblUmpumpenVTank = new JLabel();
	    										lblUmpumpenVTank.setHorizontalAlignment(SwingConstants.TRAILING);
	    									umpumpenVTankPanel.add(lblUmpumpenVTank,BorderLayout.WEST);
	    									txtUmpumpenVTank = new JSelectedTextField();
	    										txtUmpumpenVTank.setColumns(10);
	    										txtUmpumpenVTank.addKeyListener(new java.awt.event.KeyAdapter() {
										            public void keyReleased(java.awt.event.KeyEvent evt) {
										                    if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
										                    	setUmpumpenVTankInhaltLabel();
										                    }
										            }
										        });
	    										txtUmpumpenVTank.addFocusListener(new FocusListener() {
													public void focusGained(FocusEvent arg0) {
													}
													public void focusLost(FocusEvent arg0) {
								                    	setUmpumpenVTankInhaltLabel();
													}
						      					});
	    									umpumpenVTankPanel.add(txtUmpumpenVTank);
	    									umpumpenVTankButtonPanel = new JPanel(new GridLayout(1,2));
	    										btUmpumpenVTankText = new JButton();
	    										umpumpenVTankButtonPanel.add(btUmpumpenVTankText);
	    										btUmpumpenVTankPlan = new JButton();
	    										umpumpenVTankButtonPanel.add(btUmpumpenVTankPlan);
	    									umpumpenVTankPanel.add(umpumpenVTankButtonPanel,BorderLayout.EAST);
	    									lblUmpumpenVTankInhalt = new JLabel();
	    									umpumpenVTankPanel.add(lblUmpumpenVTankInhalt,BorderLayout.SOUTH);
	    								umpumpenVDatenPanel.add(umpumpenVTankPanel);
	    								
	    								//Mischung
	    									 umpumpenVMischungPanel = new JPanel(new BorderLayout());
	    									 	umpumpenVMischungPanel.setBorder(BorderFactory.createEtchedBorder());
	    									 	lblUmpumpenVMischung = new JLabel();
	    									 		umpumpenVMischungPanel.add(lblUmpumpenVMischung,BorderLayout.WEST);
	    									 	txtUmpumpenMischungV = new JIntegerField(0,0,Integer.MAX_VALUE);
	    									 		txtUmpumpenMischungV.addKeyListener(new java.awt.event.KeyAdapter() {
										            public void keyReleased(java.awt.event.KeyEvent evt) {
										                    if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
										                    	txtUmpumpenMischungV.validateField();;
										                    	int id = txtUmpumpenMischungV.getValue();
										                    	if(id != 0) {
										                    		txtUmpumpenVTank.setText(rz.getDatabase().getMischungen().getMischungTank(id));			
											                    	setUmpumpenVTankInhaltLabel();	
										                    	}
										                    }
										            }
										        });
	    									 	txtUmpumpenMischungV.addFocusListener(new FocusListener() {
													public void focusGained(FocusEvent arg0) {
													}
													public void focusLost(FocusEvent arg0) {
														txtUmpumpenMischungV.validateField();;
								                    	int id = txtUmpumpenMischungV.getValue();
								                    	if(id != 0) {
								                    		txtUmpumpenVTank.setText(rz.getDatabase().getMischungen().getMischungTank(id));			
									                    	setUmpumpenVTankInhaltLabel();	
								                    	}
								                    }
						      					});
	    									 	umpumpenVMischungPanel.add(txtUmpumpenMischungV,BorderLayout.CENTER);
	    									 	umpumpenVMischungSuche = new JPanel(new BorderLayout());	
    									 			btUmpumpenVMischungID = new JButton();
    									 			umpumpenVMischungSuche.add(btUmpumpenVMischungID, BorderLayout.WEST);
	    									 		btUmpumpenVMischungText = new JButton();
	    									 		umpumpenVMischungSuche.add(btUmpumpenVMischungText, BorderLayout.EAST);
	    									 	umpumpenVMischungPanel.add(umpumpenVMischungSuche,BorderLayout.EAST);
	    							    umpumpenVDatenPanel.add(umpumpenVMischungPanel);
	    							    
	    								//ButtonPanel
	    								umpumpenVButtonPanel = new JPanel(new BorderLayout());
	    									umpumpenVButtonPanel.setBorder(BorderFactory.createEtchedBorder());
    											btUmpumpenVOK = new JButton();
    											btUmpumpenVOK.setBackground(rz.getOptionFactory().getRGBColor("mischungen.ok_button_color"));
    											umpumpenVButtonPanel.add(btUmpumpenVOK,BorderLayout.EAST);
	    								tabUmpumpenV2.add(umpumpenVButtonPanel,BorderLayout.SOUTH);
									tabUmpumpenV2.add(umpumpenVDatenPanel,BorderLayout.NORTH);
									tabUmpumpenV.add(tabUmpumpenV2,BorderLayout.CENTER);
    							tabAktionen.add(tabUmpumpenV,BorderLayout.CENTER);
    							
    							/*
    							 * ----------------------------------------------------
    							 * teilweise umpumpen
    							 *-----------------------------------------------------
    							 */
    							
    							tabUmpumpenT = new JPanel(new BorderLayout());
    								tabUmpumpenT2 = new JPanel(new BorderLayout());
    									//Datenpanel
	    								umpumpenTDatenPanel= new JPanel();
	    									umpumpenTDatenPanel.setLayout(new BoxLayout(umpumpenTDatenPanel,BoxLayout.PAGE_AXIS));
	    									umpumpenTDatenPanel.setBorder(BorderFactory.createEtchedBorder());
	    									//Menge
	    									umpumpenT1Panel = new JPanel(new BorderLayout());
    											umpumpenT1Panel.setBorder(BorderFactory.createEtchedBorder());
    												lblUmpumpenTMenge = new JLabel();
    													lblUmpumpenTMenge.setHorizontalAlignment(SwingConstants.TRAILING);
	    										umpumpenT1Panel.add(lblUmpumpenTMenge,BorderLayout.WEST);
    												txtUmpumpenTMenge = new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_NORMAL), 0.0, 0.0, Double.POSITIVE_INFINITY);
    													txtUmpumpenTMenge.setColumns(20);
    													txtUmpumpenTMenge.addKeyListener(new java.awt.event.KeyAdapter() {
    											            public void keyReleased(java.awt.event.KeyEvent evt) {
    										                    if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
    										                    	txtUmpumpenTMenge.validateField();
    										                    	validateUmpumpenTMenge(txtUmpumpenTMenge.getValue());
    										                    }
    										            }
    										        });
    												txtUmpumpenTMenge.addFocusListener(new FocusListener() {
    													public void focusGained(FocusEvent arg0) {
    													}
    													public void focusLost(FocusEvent arg0) {
									                    	txtUmpumpenTMenge.validateField();
									                    	validateUmpumpenTMenge(txtUmpumpenTMenge.getValue());
    													}
    						      					});
    												umpumpenT1Panel.add(txtUmpumpenTMenge,BorderLayout.CENTER);
    											lblUmpumpenTMenge2 = new JLabel();
													lblUmpumpenTMenge2.setHorizontalAlignment(SwingConstants.LEADING);
												umpumpenT1Panel.add(lblUmpumpenTMenge2,BorderLayout.EAST);
	    
	    									umpumpenTDatenPanel.add(umpumpenT1Panel);
	    									//Tank
	    									umpumpenTTankPanel = new JPanel(new BorderLayout());
	    									umpumpenTTankPanel.setBorder(BorderFactory.createEtchedBorder());
	    									lblUmpumpenTTank = new JLabel();
	    										lblUmpumpenTTank.setHorizontalAlignment(SwingConstants.TRAILING);
	    									umpumpenTTankPanel.add(lblUmpumpenTTank,BorderLayout.WEST);
	    									txtUmpumpenTTank = new JSelectedTextField();
	    										txtUmpumpenTTank.setColumns(10);
	    										txtUmpumpenTTank.addKeyListener(new java.awt.event.KeyAdapter() {
										            public void keyReleased(java.awt.event.KeyEvent evt) {
										                    if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
										                    	setUmpumpenTTankInhaltLabel();
										                    }
										            }
										        });
	    										txtUmpumpenTTank.addFocusListener(new FocusListener() {
													public void focusGained(FocusEvent arg0) {
													}
													public void focusLost(FocusEvent arg0) {
								                    	setUmpumpenTTankInhaltLabel();
													}
						      					});
	    									umpumpenTTankPanel.add(txtUmpumpenTTank);
	    									umpumpenTTankButtonPanel = new JPanel(new GridLayout(1,2));
	    										btUmpumpenTTankText = new JButton();
	    										umpumpenTTankButtonPanel.add(btUmpumpenTTankText);
	    										btUmpumpenTTankPlan = new JButton();
	    										umpumpenTTankButtonPanel.add(btUmpumpenTTankPlan);
	    									umpumpenTTankPanel.add(umpumpenTTankButtonPanel,BorderLayout.EAST);
	    									lblUmpumpenTTankInhalt = new JLabel();
	    									umpumpenTTankPanel.add(lblUmpumpenTTankInhalt,BorderLayout.SOUTH);
	    								umpumpenTDatenPanel.add(umpumpenTTankPanel);
	    								
	    								//Mischung
	    									 umpumpenTMischungPanel = new JPanel(new BorderLayout());
	    									 	umpumpenTMischungPanel.setBorder(BorderFactory.createEtchedBorder());
	    									 	lblUmpumpenTMischung = new JLabel();
	    									 		umpumpenTMischungPanel.add(lblUmpumpenTMischung,BorderLayout.WEST);
	    									 	txtUmpumpenMischungT = new JIntegerField(0,0,Integer.MAX_VALUE);
	    									 		txtUmpumpenMischungT.addKeyListener(new java.awt.event.KeyAdapter() {
										            public void keyReleased(java.awt.event.KeyEvent evt) {
										                    if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
										                    	txtUmpumpenMischungT.validateField();;
										                    	int id = txtUmpumpenMischungT.getValue();
										                    	if(id != 0) {
										                    		txtUmpumpenTTank.setText(rz.getDatabase().getMischungen().getMischungTank(id));			
											                    	setUmpumpenTTankInhaltLabel();	
										                    	}
										                    }
										            }
										        });
	    									 	txtUmpumpenMischungT.addFocusListener(new FocusListener() {
													public void focusGained(FocusEvent arg0) {
													}
													public void focusLost(FocusEvent arg0) {
														txtUmpumpenMischungT.validateField();;
								                    	int id = txtUmpumpenMischungT.getValue();
								                    	if(id != 0) {
								                    		txtUmpumpenTTank.setText(rz.getDatabase().getMischungen().getMischungTank(id));			
									                    	setUmpumpenTTankInhaltLabel();	
								                    	}
								                    }
						      					});
	    									 	umpumpenTMischungPanel.add(txtUmpumpenMischungT,BorderLayout.CENTER);
	    									 	umpumpenTMischungSuche = new JPanel(new BorderLayout());	
    									 			btUmpumpenTMischungID = new JButton();
    									 			umpumpenTMischungSuche.add(btUmpumpenTMischungID, BorderLayout.WEST);
	    									 		btUmpumpenTMischungText = new JButton();
	    									 		umpumpenTMischungSuche.add(btUmpumpenTMischungText, BorderLayout.EAST);
	    									 	umpumpenTMischungPanel.add(umpumpenTMischungSuche,BorderLayout.EAST);
	    							    umpumpenTDatenPanel.add(umpumpenTMischungPanel);
	    							    
	    								//ButtonPanel
	    								umpumpenTButtonPanel = new JPanel(new BorderLayout());
	    									umpumpenTButtonPanel.setBorder(BorderFactory.createEtchedBorder());
    											btUmpumpenTOK = new JButton();
    											btUmpumpenTOK.setBackground(rz.getOptionFactory().getRGBColor("mischungen.ok_button_color"));
    											umpumpenTButtonPanel.add(btUmpumpenTOK,BorderLayout.EAST);
	    								tabUmpumpenT2.add(umpumpenTButtonPanel,BorderLayout.SOUTH);
									tabUmpumpenT2.add(umpumpenTDatenPanel,BorderLayout.NORTH);
									tabUmpumpenT.add(tabUmpumpenT2,BorderLayout.CENTER);
    							tabAktionen.add(tabUmpumpenT,BorderLayout.CENTER);
    							
    							
    							
    						scrAktionen.setViewportView(tabAktionen);
    					aktionenPanel.add(scrAktionen,BorderLayout.CENTER);
    				actionPanel.add(aktionenPanel,BorderLayout.CENTER);
    			splPanel1.setBottomComponent(actionPanel);
			buttonPanel = new JPanel(new GridLayout(1,6));
				btCancel = new JButton();
				buttonPanel.add(btCancel);
				cmbDruckFormulare = new JComboBox();
		    	rz.getDatabase().getReport().dbGetReportListeCombo(cmbDruckFormulare,ReportFactory.REPORT_TYPE_MISCHUNG);
        	    cmbDruckFormulare.addActionListener(new ActionListener() {
					public void actionPerformed(ActionEvent evt) {
    	        		if(cmbDruckFormulare.getSelectedIndex() != -1) {
    	        			rz.getOptionFactory().setOption("report.mischung",((ReportItem)cmbDruckFormulare.getSelectedItem()).getID());
    	        			rz.getOptionFactory().saveOptions();
    	        		}
    	        	}
                });
		    		buttonPanel.add(cmbDruckFormulare);
		    		chkDuplex= new JCheckBox();
					chkDuplex.setSelected((rz.getOptionFactory().getOption("mischungbearbeiten.duplex",0) == 1?true:false));
					chkDuplex.addActionListener(new ActionListener() {
			        	public void actionPerformed(ActionEvent evt) {
			        		rz.getOptionFactory().setOption("mischungbearbeiten.duplex", chkDuplex.isSelected()?1:0);
			        		rz.getOptionFactory().saveOptions();
			        	}
		    	    });
					buttonPanel.add(chkDuplex);
		    	btDrucken = new JButton();
		    		buttonPanel.add(btDrucken);
		    	btVorschau = new JButton();
		    		buttonPanel.add(btVorschau);
				btHilfe = new JButton();
				buttonPanel.add(btHilfe);
			mainPanel.add(splPanel1,BorderLayout.CENTER);
			mainPanel.add(buttonPanel,BorderLayout.SOUTH);
			getContentPane().setLayout(new BorderLayout());
			getContentPane().add(toolbarPanel,BorderLayout.NORTH);
			getContentPane().add(mainPanel,BorderLayout.CENTER);


    }
    @Override
	public void setGUIComponents() {
      setTitle(rz.getVersionString() + " " + rz.getLocale().getString("mischungbearbeitenfenster.titel"));

      mnuDatei.setText(rz.getLocale().getString("menu.datei"));
      mnuExtras.setText(rz.getLocale().getString("menu.extras"));
      mnuBearbeiten.setText(rz.getLocale().getString("menu.bearbeiten"));
      mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));

	  mnuDatei.add(getAction(ACTION_STAMMBAUM_CODE));
	  mnuDatei.addSeparator();
	  mnuDatei.add(getAction(ACTION_ADRESSLISTE_BEARBEITEN_CODE));
	  mnuDatei.add(getAction(ACTION_ADRESSLISTE_LOESCHEN_CODE));
	  mnuDatei.addSeparator();
	  mnuDatei.add(getAction(ACTION_CHART_CODE));
	  mnuDatei.addSeparator();
      mnuDatei.add(getAction(ACTION_CLOSE_CODE));
      mnuBearbeiten.add(getAction(ACTION_TICKET_ADD_CODE));
      mnuBearbeiten.add(getAction(ACTION_TICKET_EDIT_CODE));
      mnuExtras.add(getAction(ACTION_HIDE_CODE));
      mnuHilfe.add(getAction(ACTION_HILFE_CODE));

      btCancel.setAction(getAction(ACTION_CLOSE_CODE));
      btHilfe.setAction(getAction(ACTION_HILFE_CODE));
      tb1.add(getAction(ACTION_CLOSE_CODE));
      tb1.add(getAction(ACTION_HIDE_CODE));
      tb1.addSeparator();
	  tb1.add(getAction(ACTION_STAMMBAUM_CODE));
      tb1.addSeparator();
      tb1.add(getAction(ACTION_CHART_CODE));
      tb1.addSeparator();
	  tb1.add(getAction(ACTION_ADRESSLISTE_BEARBEITEN_CODE));
	  tb1.add(getAction(ACTION_ADRESSLISTE_LOESCHEN_CODE));
		
      lblTransaktionen.setText(rz.getLocale().getString("mischungbearbeitenfenster.transaktionen_titel"));
      lblTicketSelection.setText(rz.getLocale().getString("mischungbearbeitenfenster.tickets_selection_titel"));
      lblDetail.setText(rz.getLocale().getString("mischungbearbeitenfenster.detail_titel"));
      lblBemerkungen.setText(rz.getLocale().getString("mischungbearbeitenfenster.label_bemerkungen"));
      lblAbschlussVTank.setText(rz.getLocale().getString("mischungbearbeitenfenster.label_abschluss_tank"));
      lblAbschlussVLosnummer.setText(rz.getLocale().getString("mischungbearbeitenfenster.label_abschluss_losnummer"));          
      
		lblAdressenTitel.setText(rz.getLocale().getString("mischungbearbeitenfenster.label_adressliste_titel"));
      
      
      btTransaktionAdd.setAction(getAction(ACTION_TICKET_ADD_CODE));
      btTransaktionDelete.setAction(getAction(ACTION_TICKET_DELETE_CODE));
      btEditTicket.setAction(getAction(ACTION_TICKET_EDIT_CODE));
      btCheckAll.setAction(getAction(ACTION_TICKET_CHECKALL_CODE));
      btRezeptur.setAction(getAction(ACTION_REZEPTUR_CODE));
      btRezepturRemove.setAction(getAction(ACTION_REZEPTUR_REMOVE_CODE));
      btSave.setAction(getAction(ACTION_SAVE_CODE));
      btPruefen.setAction(getAction(ACTION_CHECK_FREIGABE_CODE));
	  btDrucken.setAction(getAction(ACTION_DRUCKEN_CODE));
	  btVorschau.setAction(getAction(ACTION_VORSCHAU_CODE));
	  btAdressenBearbeiten.setAction(getAction(ACTION_ADRESSLISTE_BEARBEITEN_CODE));
	  btAdressenLoeschen.setAction(getAction(ACTION_ADRESSLISTE_LOESCHEN_CODE));
	  btTicketFilterClear.setAction(getAction(ACTION_TICKETFILTER_CLEAR_CODE));	  
	  btTicketSearch.setAction(getAction(ACTION_TICKETFILTER_SEARCH_CODE));	  
	  
	  chkMischungen.setText(rz.getLocale().getString("mischungbearbeitenfenster.mischungen_anzeigen"));
	  chkMischungen.setSelected(rz.getOptionFactory().getOption("mischungbearbeitenfenster.mischungen_anzeigen",0)==0?false:true);
	  
	  chkAlle.setText(rz.getLocale().getString("mischungbearbeitenfenster.alle_tickets_anzeigen"));
	  chkAlle.setSelected(rz.getOptionFactory().getOption("mischungbearbeitenfenster.alle_tickets_anzeigen",0)==0?false:true);
      /**
       * hilfe
       */
      lblHilfe.setText(rz.getLocale().getString("mischungbearbeitenfenster.tab_hilfe_text"));
      /*
       * zusammenfassen
       */
      btZusammenfassen.setAction(getAction(ACTION_ZUSAMMENFASSEN_CODE));
      /*
       * Nullabschluss
       */
      btNullAbschluss.setAction(getAction(ACTION_ABSCHLUSS_NULL_CODE));
      /*
       * Abschluss vollständig
       */
      btabschlussVDatenRezeptur.setAction(getAction(ACTION_ABSCHLUSS_REZEPTUR_CODE));
      btabschlussVDatenRezepturRemove.setAction(getAction(ACTION_ABSCHLUSS_REZEPTUR_REMOVE_CODE));
      lblabschlussVDatenTitel.setText(rz.getLocale().getString("mischungbearbeitenfenster.label_abschluss_rezeptur_titel"));        
      lblabschlussVDatenMengeStaerke.setText(rz.getLocale().getString("mischungbearbeitenfenster.label_abschluss_menge_staerke"));

      lblabschlussVDatenMengeTitel.setText(rz.getLocale().getString("mischungbearbeitenfenster.label_abschluss_menge_titel"));    
      btAbschlussVOK.setAction(getAction(ACTION_ABSCHLUSS_V_OK_CODE));
      btAbschlussVLosnummerVorschlag.setAction(getAction(ACTION_ABSCHLUSS_LOSNUMMER_CODE));
      btAbschlussVTankPlan.setAction(getAction(ACTION_TANKLISTE_PLAN_CODE));
      btAbschlussVTankText.setAction(getAction(ACTION_TANKLISTE_TEXT_CODE));

      /*
       * Abschluss teilweise
       */
      btabschlussTDatenRezeptur.setAction(getAction(ACTION_ABSCHLUSS_T_REZEPTUR_CODE));
      btabschlussTDatenRezepturRemove.setAction(getAction(ACTION_ABSCHLUSS_T_REZEPTUR_REMOVE_CODE));
      lblabschlussTDatenTitel.setText(rz.getLocale().getString("mischungbearbeitenfenster.label_abschluss_t_rezeptur_titel"));        
      lblabschlussTDatenMengeStaerke.setText(rz.getLocale().getString("mischungbearbeitenfenster.label_abschluss_t_menge_staerke"));

      lblabschlussTDatenMengeTitel.setText(rz.getLocale().getString("mischungbearbeitenfenster.label_abschluss_t_menge_titel"));    
      btAbschlussTOK.setAction(getAction(ACTION_ABSCHLUSS_T_OK_CODE));
      btAbschlussTLosnummerVorschlag.setAction(getAction(ACTION_ABSCHLUSS_T_LOSNUMMER_CODE));
      btAbschlussTTankPlan.setAction(getAction(ACTION_TANKLISTE_T_PLAN_CODE));
      btAbschlussTTankText.setAction(getAction(ACTION_TANKLISTE_T_TEXT_CODE));
      lblAbschlussTLosnummer.setText(rz.getLocale().getString("mischungbearbeitenfenster.label_abschluss_t_losnummer"));
      lblAbschlussTTank.setText(rz.getLocale().getString("mischungbearbeitenfenster.label_abschluss_t_tank")); 
      
      /*
       * Umpumpen Vollständig
       */
      btUmpumpenVOK.setAction(getAction(ACTION_UMPUMPEN_V_OK_CODE));
      btUmpumpenVTankPlan.setAction(getAction(ACTION_TANKLISTE_UMPUMPEN_V_PLAN_CODE));
      btUmpumpenVTankText.setAction(getAction(ACTION_TANKLISTE_UMPUMPEN_V_TEXT_CODE));
      lblUmpumpenVTank.setText(rz.getLocale().getString("mischungbearbeitenfenster.label_umpumpenv_tank"));      
      lblUmpumpenVMischung.setText(rz.getLocale().getString("mischungbearbeitenfenster.label_umpumpenv_mischung"));      
      btUmpumpenVMischungText.setAction(getAction(ACTION_TANKLISTE_UMPUMPEN_V_MISCHUNG_TEXT_CODE));
      btUmpumpenVMischungID.setAction(getAction(ACTION_TANKLISTE_UMPUMPEN_V_MISCHUNG_ID_CODE));

      /*
       * teilweise umpumpen
       */
      btUmpumpenTOK.setAction(getAction(ACTION_UMPUMPEN_T_OK_CODE));
      btUmpumpenTTankPlan.setAction(getAction(ACTION_TANKLISTE_UMPUMPEN_T_PLAN_CODE));
      btUmpumpenTTankText.setAction(getAction(ACTION_TANKLISTE_UMPUMPEN_T_TEXT_CODE));
      lblUmpumpenTTank.setText(rz.getLocale().getString("mischungbearbeitenfenster.label_umpumpent_tank"));      
      lblUmpumpenTMischung.setText(rz.getLocale().getString("mischungbearbeitenfenster.label_umpumpent_mischung"));      
      btUmpumpenTMischungText.setAction(getAction(ACTION_TANKLISTE_UMPUMPEN_T_MISCHUNG_TEXT_CODE));
      btUmpumpenTMischungID.setAction(getAction(ACTION_TANKLISTE_UMPUMPEN_T_MISCHUNG_ID_CODE));
      
      
      getAction(ACTION_TICKET_EDIT_CODE).setEnabled(false);
      
      tabAktionen.setTitleAt(TAB_NULL,rz.getLocale().getString("mischungbearbeitenfenster.tab_null"));
      tabAktionen.setTitleAt(TAB_HILFE, rz.getLocale().getString("mischungbearbeitenfenster.tab_hilfe"));
      tabAktionen.setTitleAt(TAB_ZUSAMMENFASSEN ,rz.getLocale().getString("mischungbearbeitenfenster.tab_zusammenfassen"));
      tabAktionen.setIconAt(TAB_HILFE, hilfe);
      tabAktionen.setTitleAt(TAB_ABSCHLUSSV, rz.getLocale().getString("mischungbearbeitenfenster.tab_abschlussv"));
      tabAktionen.setTitleAt(TAB_ABSCHLUSST, rz.getLocale().getString("mischungbearbeitenfenster.tab_abschlusst1"));
      tabAktionen.setTitleAt(TAB_UMPUMPENV, rz.getLocale().getString("mischungbearbeitenfenster.tab_umpumpenv"));
      tabAktionen.setTitleAt(TAB_UMPUMPENT, rz.getLocale().getString("mischungbearbeitenfenster.tab_umpumpent"));
      
      chkDuplex.setText(rz.getLocale().getString("mischungbearbeiten.duplex")); 
      
      setResizable(true);
      rz.getFontFactory().setFrameFonts(this);
      pack();
      rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;
      setDividerLocations();
    }

    /** speichert die Position der Splitbalken
	 */
    private void saveDividerLocations(){
        rz.getFensterFactory().setOption(this.getName() + ".splH1", this.splListenTablePanel.getDividerLocation());
        rz.getFensterFactory().setOption(this.getName() + ".splH2", this.splTablePanel.getDividerLocation());
        rz.getFensterFactory().setOption(this.getName() + ".splV1", this.splPanel1.getDividerLocation());
        rz.getFensterFactory().saveOptions();
    }
	/** setzt die Position der Splitbalken auf gespeicherte Positionen oder
	 * auf Standardposition, wenn keine gespeicherten vorliegen
	 *
	 */
    private void setDividerLocations() {
        splListenTablePanel.setDividerLocation(rz.getFensterFactory().getOption(this.getName() + ".splH1",this.getWidth()/3));
        splTablePanel.setDividerLocation(rz.getFensterFactory().getOption(this.getName() + ".splH2",this.getWidth()/6));
        splPanel1.setDividerLocation(rz.getFensterFactory().getOption(this.getName() + ".splV1",this.getHeight()/2));
    }

    
    @Override
	public void createActions(){
        actionList.put(String.valueOf(ACTION_CLOSE_CODE),new AuswahlAction(rz,this, ACTION_CLOSE_CODE,ACTION_CLOSE_TEXT,KeyEvent.VK_ESCAPE ,0));
        actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT,KeyEvent.VK_F5 ,InputEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT,KeyEvent.VK_F1 ,0));      
        actionList.put(String.valueOf(ACTION_TICKET_ADD_CODE),new AuswahlAction(rz,this,ACTION_TICKET_ADD_CODE,ACTION_TICKET_ADD_TEXT,KeyEvent.VK_T,InputEvent.ALT_DOWN_MASK)); 
        actionList.put(String.valueOf(ACTION_TICKET_DELETE_CODE),new AuswahlAction(rz,this,ACTION_TICKET_DELETE_CODE,ACTION_TICKET_DELETE_TEXT,0 ,0)); 
        actionList.put(String.valueOf(ACTION_TICKET_EDIT_CODE),new AuswahlAction(rz,this,ACTION_TICKET_EDIT_CODE,ACTION_TICKET_EDIT_TEXT,KeyEvent.VK_F2 ,0));
        actionList.put(String.valueOf(ACTION_TICKET_CHECKALL_CODE),new AuswahlAction(rz,this,ACTION_TICKET_CHECKALL_CODE,ACTION_TICKET_CHECKALL_TEXT,0 ,0));
        actionList.put(String.valueOf(ACTION_REZEPTUR_CODE),new AuswahlAction(rz,this,ACTION_REZEPTUR_CODE,ACTION_REZEPTUR_TEXT,0 ,0));
        actionList.put(String.valueOf(ACTION_REZEPTUR_REMOVE_CODE),new AuswahlAction(rz,this,ACTION_REZEPTUR_REMOVE_CODE,ACTION_REZEPTUR_REMOVE_TEXT,0 ,0)); 
        actionList.put(String.valueOf(ACTION_SAVE_CODE),new AuswahlAction(rz,this, ACTION_SAVE_CODE,ACTION_SAVE_TEXT,0 ,0));
        actionList.put(String.valueOf(ACTION_CHECK_FREIGABE_CODE),new AuswahlAction(rz,this, ACTION_CHECK_FREIGABE_CODE,ACTION_CHECK_FREIGABE_TEXT,0 ,0));
        
        actionList.put(String.valueOf(ACTION_ABSCHLUSS_V_OK_CODE),new AuswahlAction(rz,this, ACTION_ABSCHLUSS_V_OK_CODE,ACTION_ABSCHLUSSV_OK_TEXT,0 ,0));
        actionList.put(String.valueOf(ACTION_ABSCHLUSS_LOSNUMMER_CODE),new AuswahlAction(rz,this, ACTION_ABSCHLUSS_LOSNUMMER_CODE,ACTION_ABSCHLUSS_LOSNUMMER_TEXT,0 ,0));
        actionList.put(String.valueOf(ACTION_TANKLISTE_PLAN_CODE),new AuswahlAction(rz,this, ACTION_TANKLISTE_PLAN_CODE,ACTION_TANKLISTE_PLAN_TEXT,0 ,0));
        actionList.put(String.valueOf(ACTION_TANKLISTE_TEXT_CODE),new AuswahlAction(rz,this, ACTION_TANKLISTE_TEXT_CODE,ACTION_TANKLISTE_TEXT_TEXT,0 ,0));
        actionList.put(String.valueOf(ACTION_ABSCHLUSS_REZEPTUR_CODE),new AuswahlAction(rz,this, ACTION_ABSCHLUSS_REZEPTUR_CODE,ACTION_ABSCHLUSS_REZEPTUR_TEXT,0 ,0));
        actionList.put(String.valueOf(ACTION_ABSCHLUSS_REZEPTUR_REMOVE_CODE),new AuswahlAction(rz,this, ACTION_ABSCHLUSS_REZEPTUR_REMOVE_CODE,ACTION_ABSCHLUSS_REZEPTUR_REMOVE_TEXT,0 ,0));
   
        actionList.put(String.valueOf(ACTION_UMPUMPEN_V_OK_CODE),new AuswahlAction(rz,this, ACTION_UMPUMPEN_V_OK_CODE,ACTION_UMPUMPENV_OK_TEXT,0 ,0));
        actionList.put(String.valueOf(ACTION_TANKLISTE_UMPUMPEN_V_PLAN_CODE),new AuswahlAction(rz,this, ACTION_TANKLISTE_UMPUMPEN_V_PLAN_CODE,ACTION_TANKLISTE_UMPUMPEN_V_PLAN_TEXT,0 ,0));
        actionList.put(String.valueOf(ACTION_TANKLISTE_UMPUMPEN_V_TEXT_CODE),new AuswahlAction(rz,this, ACTION_TANKLISTE_UMPUMPEN_V_TEXT_CODE,ACTION_TANKLISTE_UMPUMPEN_V_TEXT_TEXT,0 ,0));
        actionList.put(String.valueOf(ACTION_TANKLISTE_UMPUMPEN_V_MISCHUNG_TEXT_CODE),new AuswahlAction(rz,this, ACTION_TANKLISTE_UMPUMPEN_V_MISCHUNG_TEXT_CODE,ACTION_TANKLISTE_UMPUMPEN_V_MISCHUNG_TEXT_TEXT,0 ,0));
        actionList.put(String.valueOf(ACTION_TANKLISTE_UMPUMPEN_V_MISCHUNG_ID_CODE),new AuswahlAction(rz,this, ACTION_TANKLISTE_UMPUMPEN_V_MISCHUNG_ID_CODE,ACTION_TANKLISTE_UMPUMPEN_V_MISCHUNG_ID_TEXT,0 ,0));
        
        actionList.put(String.valueOf(ACTION_UMPUMPEN_T_OK_CODE),new AuswahlAction(rz,this, ACTION_UMPUMPEN_T_OK_CODE,ACTION_UMPUMPENT_OK_TEXT,0 ,0));
        actionList.put(String.valueOf(ACTION_TANKLISTE_UMPUMPEN_T_PLAN_CODE),new AuswahlAction(rz,this, ACTION_TANKLISTE_UMPUMPEN_T_PLAN_CODE,ACTION_TANKLISTE_UMPUMPEN_T_PLAN_TEXT,0 ,0));
        actionList.put(String.valueOf(ACTION_TANKLISTE_UMPUMPEN_T_TEXT_CODE),new AuswahlAction(rz,this, ACTION_TANKLISTE_UMPUMPEN_T_TEXT_CODE,ACTION_TANKLISTE_UMPUMPEN_T_TEXT_TEXT,0 ,0));
        actionList.put(String.valueOf(ACTION_TANKLISTE_UMPUMPEN_T_MISCHUNG_TEXT_CODE),new AuswahlAction(rz,this, ACTION_TANKLISTE_UMPUMPEN_T_MISCHUNG_TEXT_CODE,ACTION_TANKLISTE_UMPUMPEN_T_MISCHUNG_TEXT_TEXT,0 ,0));
        actionList.put(String.valueOf(ACTION_TANKLISTE_UMPUMPEN_T_MISCHUNG_ID_CODE),new AuswahlAction(rz,this, ACTION_TANKLISTE_UMPUMPEN_T_MISCHUNG_ID_CODE,ACTION_TANKLISTE_UMPUMPEN_T_MISCHUNG_ID_TEXT,0 ,0));
        
        actionList.put(String.valueOf(ACTION_ABSCHLUSS_T_OK_CODE),new AuswahlAction(rz,this, ACTION_ABSCHLUSS_T_OK_CODE,ACTION_ABSCHLUSS_T_OK_TEXT,0 ,0));
        actionList.put(String.valueOf(ACTION_ABSCHLUSS_T_LOSNUMMER_CODE),new AuswahlAction(rz,this, ACTION_ABSCHLUSS_T_LOSNUMMER_CODE,ACTION_ABSCHLUSS_T_LOSNUMMER_TEXT,0 ,0));
        actionList.put(String.valueOf(ACTION_TANKLISTE_T_PLAN_CODE),new AuswahlAction(rz,this, ACTION_TANKLISTE_T_PLAN_CODE,ACTION_TANKLISTE_T_PLAN_TEXT,0 ,0));
        actionList.put(String.valueOf(ACTION_TANKLISTE_T_TEXT_CODE),new AuswahlAction(rz,this, ACTION_TANKLISTE_T_TEXT_CODE,ACTION_TANKLISTE_T_TEXT_TEXT,0 ,0));
        actionList.put(String.valueOf(ACTION_ABSCHLUSS_T_REZEPTUR_CODE),new AuswahlAction(rz,this, ACTION_ABSCHLUSS_T_REZEPTUR_CODE,ACTION_ABSCHLUSS_T_REZEPTUR_TEXT,0 ,0));
        actionList.put(String.valueOf(ACTION_ABSCHLUSS_T_REZEPTUR_REMOVE_CODE),new AuswahlAction(rz,this, ACTION_ABSCHLUSS_T_REZEPTUR_REMOVE_CODE,ACTION_ABSCHLUSS_T_REZEPTUR_REMOVE_TEXT,0 ,0));
        actionList.put(String.valueOf(ACTION_ABSCHLUSS_NULL_CODE),new AuswahlAction(rz,this, ACTION_ABSCHLUSS_NULL_CODE,ACTION_ABSCHLUSS_NULL_TEXT,0 ,0));
     
		actionList.put(String.valueOf(ACTION_DRUCKEN_CODE), new AuswahlAction(rz,this, ACTION_DRUCKEN_CODE,ACTION_DRUCKEN_TEXT,0, 0));
		actionList.put(String.valueOf(ACTION_VORSCHAU_CODE), new AuswahlAction(rz,this, ACTION_VORSCHAU_CODE,ACTION_VORSCHAU_TEXT,0, 0));
        actionList.put(String.valueOf(ACTION_STAMMBAUM_CODE),new AuswahlAction(rz,this,ACTION_STAMMBAUM_CODE,ACTION_STAMMBAUM_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_ZUSAMMENFASSEN_CODE),new AuswahlAction(rz,this,ACTION_ZUSAMMENFASSEN_CODE,ACTION_ZUSAMMENFASSEN_TEXT, 0,0));        
        
		actionList.put(String.valueOf(ACTION_ADRESSLISTE_BEARBEITEN_CODE), new AuswahlAction(rz, this, ACTION_ADRESSLISTE_BEARBEITEN_CODE, ACTION_ADRESSLISTE_BEARBEITEN_TEXT, KeyEvent.VK_D, KeyEvent.CTRL_DOWN_MASK));
		actionList.put(String.valueOf(ACTION_ADRESSLISTE_LOESCHEN_CODE), new AuswahlAction(rz, this, ACTION_ADRESSLISTE_LOESCHEN_CODE, ACTION_ADRESSLISTE_LOESCHEN_TEXT, KeyEvent.VK_L, KeyEvent.CTRL_DOWN_MASK));

        actionList.put(String.valueOf(ACTION_TICKETFILTER_SEARCH_CODE),new AuswahlAction(rz,this,ACTION_TICKETFILTER_SEARCH_CODE,ACTION_TICKETFILTER_SEARCH_TEXT, 0,0));

		actionList.put(String.valueOf(ACTION_TICKETFILTER_CLEAR_CODE),new AuswahlAction(rz,this,ACTION_TICKETFILTER_CLEAR_CODE,ACTION_TICKETFILTER_CLEAR_TEXT, 0,0));
		actionList.put(String.valueOf(ACTION_CHART_CODE),new AuswahlAction(rz,this,ACTION_CHART_CODE,ACTION_CHART_TEXT, 0,0));
    }


    @Override
	public void getMessage(MessageItem msg) {
        switch(msg.getMsgCode()) {
        	case MessageItem.MSG_ACTIONPERFORMED :
        	    switch(msg.getCode()) {
	              	case ACTION_CLOSE_CODE:closeWindow();break;
	              	case ACTION_HIDE_CODE:hideAction();break;
	              	case ACTION_TICKET_ADD_CODE:addTransaktion();tabAktionen.setSelectedIndex(TAB_HILFE);break;
	              	case ACTION_TICKET_DELETE_CODE:deleteTransaktion();tabAktionen.setSelectedIndex(TAB_HILFE);break;
	              	case ACTION_TICKET_EDIT_CODE:editTicketAction();tabAktionen.setSelectedIndex(TAB_HILFE);break;
	              	case ACTION_TICKET_CHECKALL_CODE:ticketCheckAllAction();break;
		            case ACTION_REZEPTUR_CODE:selectRezepturAction();break;
		            case ACTION_REZEPTUR_REMOVE_CODE:deselectRezepturAction();break;
		            case ACTION_SAVE_CODE:saveAction();break;
		            case ACTION_CHECK_FREIGABE_CODE:checkFreigabeAction();break;
		            
		            case ACTION_ABSCHLUSS_REZEPTUR_CODE:selectAbschlussRezepturAction();break;
		            case ACTION_ABSCHLUSS_REZEPTUR_REMOVE_CODE:deselectAbschlussRezepturAction();break;
		            case ACTION_ABSCHLUSS_LOSNUMMER_CODE:abschlussLosnummerVorschlagAction();break;		            
		            
		            case ACTION_ABSCHLUSS_T_LOSNUMMER_CODE:abschlussTLosnummerVorschlagAction();break;
		            case ACTION_ABSCHLUSS_T_REZEPTUR_CODE:selectAbschlussTRezepturAction();break;
		            case ACTION_ABSCHLUSS_T_REZEPTUR_REMOVE_CODE:deselectAbschlussTRezepturAction();break;
		            
			        case ACTION_TANKLISTE_TEXT_CODE:tanklisteTextAction(this.btAbschlussVTankText,txtAbschlussVTank);break;
			        case ACTION_TANKLISTE_PLAN_CODE:tanklistePlanAction(btAbschlussVTankPlan,txtAbschlussVTank);break;

			        case ACTION_TANKLISTE_T_TEXT_CODE:tanklisteTextAction(this.btAbschlussTTankText,txtAbschlussTTank);break;
			        case ACTION_TANKLISTE_T_PLAN_CODE:tanklistePlanAction(btAbschlussTTankPlan,txtAbschlussTTank);break;
			        
			        case ACTION_TANKLISTE_UMPUMPEN_V_TEXT_CODE:tanklisteTextAction(btUmpumpenVTankText,txtUmpumpenVTank);break;
			        case ACTION_TANKLISTE_UMPUMPEN_V_PLAN_CODE:tanklistePlanAction(btUmpumpenVTankPlan,txtUmpumpenVTank);break;

			        case ACTION_TANKLISTE_UMPUMPEN_T_TEXT_CODE:tanklisteTextAction(btUmpumpenTTankText,txtUmpumpenTTank);break;
			        case ACTION_TANKLISTE_UMPUMPEN_T_PLAN_CODE:tanklistePlanAction(btUmpumpenTTankPlan,txtUmpumpenTTank);break;
			        
			        case ACTION_TANKLISTE_UMPUMPEN_V_MISCHUNG_TEXT_CODE: showMischungsDialog(btUmpumpenVMischungText,this.txtUmpumpenMischungV, MischungsDialog.MODE_TEXT);break;
			        case ACTION_TANKLISTE_UMPUMPEN_V_MISCHUNG_ID_CODE: showMischungsDialog(this.btUmpumpenVMischungID,txtUmpumpenMischungV,MischungsDialog.MODE_ID);break;

			        case ACTION_TANKLISTE_UMPUMPEN_T_MISCHUNG_TEXT_CODE: showMischungsDialog(btUmpumpenTMischungText,txtUmpumpenMischungT,MischungsDialog.MODE_TEXT);break;
			        case ACTION_TANKLISTE_UMPUMPEN_T_MISCHUNG_ID_CODE: showMischungsDialog(btUmpumpenTMischungID,txtUmpumpenMischungT,MischungsDialog.MODE_ID);break;
			        case ACTION_ABSCHLUSS_V_OK_CODE:rz.setWaitCursor(this);abschlussOKAction();rz.setFreeCursor(this);break;
			        case ACTION_ABSCHLUSS_T_OK_CODE:rz.setWaitCursor(this);abschlussTOKAction();rz.setFreeCursor(this);break;
			        case ACTION_UMPUMPEN_V_OK_CODE:rz.setWaitCursor(this);umpumpenVAction();rz.setFreeCursor(this);break;
			        case ACTION_UMPUMPEN_T_OK_CODE:rz.setWaitCursor(this);umpumpenTAction();rz.setFreeCursor(this);break;
			        case ACTION_ABSCHLUSS_NULL_CODE:rz.setWaitCursor(this);nullAbschlussAction();rz.setFreeCursor(this);break;
		            case ACTION_DRUCKEN_CODE:druckenAction(false);break;
		            case ACTION_VORSCHAU_CODE:druckenAction(true);break;
			        case ACTION_STAMMBAUM_CODE:stammbaumAction();break;
		            case ACTION_ZUSAMMENFASSEN_CODE:zusammenfassenAction();break;
		            case ACTION_TICKETFILTER_CLEAR_CODE:TicketFilterClearAction();break;
		            case ACTION_CHART_CODE:chartAction();break;
		            
		            case ACTION_TICKETFILTER_SEARCH_CODE:
		            	if(!txtTicketSelection.getText().trim().equals("")) {
		            		selectTickets(txtTicketSelection.getText().trim());
		            	};
		            break;
					case ACTION_ADRESSLISTE_BEARBEITEN_CODE :
						adressListeBearbeitenAction();
						break;
					case ACTION_ADRESSLISTE_LOESCHEN_CODE :
						adressenLoeschenAction();
						break;
        	    }
             break;
        	case MessageItem.MSG_MISCHUNGSLISTE_REPLY:
        		mischungsListeReply((MischungsHeaderItem)msg.getData());
        		break;
    		case MessageItem.MSG_TANKLISTE_REPLY :
    			tanklisteReply((tankItem) msg.getData());
    			break;
        	case MessageItem.MSG_ZUTATEN_DIALOG_REPLY:
	    	 	 zutatenDialogReply((ZutatenSuchItem)msg.getData(),msg.getCode());
	    	 	 break;
        	case MessageItem.MSG_REFRESH_AUSGABE_EDIT_TICKET:
    	        int t = msg.getCode();
    	        ((AbstractTableModel)tblTickets.getModel()).fireTableDataChanged();
    	        if(tickets != null) {
	    	        tickets.setEntsperrtStatus();
	    	        for(int i = 0;i < tickets.size();i++) {
	    	        	if(tickets.get(i).getId() == t) {
	    	    	        tblTickets.clearSelection();
	    	    	        tblTickets.setRowSelectionInterval(i, i);
	    	    	        break;
	    	        	}
	    	        }
    	        }
        		break;
        	case MessageItem.MSG_REFRESH_AUSGABE:
            	mischung = new MischungsItem(rz,mischung.getHeader().getId());
            	fromItem();
        		refreshAction(false);
        		break;
            case MessageItem.MSG_SHOW_MISCHUNGSFENSTER:
     		    this.settblTransaktionenModel(tblTransaktionen);
     		    this.settblTicketsModel(tblTickets);
            	parent=msg.getOrigin();
            	mischung = new MischungsItem(rz,msg.getCode());
            	fromItem();
            	refreshAction(true);
            	break;
        	case MessageItem.MSG_ADRESSLISTE_REPLY :
				mischung.getHeader().setAdressen(((StichwortListe) msg.getData()).copyList());
				lstAdressen.setText(((StichwortListe) msg.getData()).toVerboseString());
				break;
            default:
                break;
        }
    }

    @Override
	public void closeWindow() {
    	saveDividerLocations();
        setVisible(false);
    	rz.getFensterFactory().getFensterListe().disposeFrame(this);
    }

   
    
    @Override
	public void openWindow() {
    	if(mischung != null) {
    		tabAktionen.setSelectedIndex(0);
    	    tabChangedAction(0);
    		setVisible(true);
        	toFront();
    	}else {
    		closeWindow();
    	}
    }

    private void chartAction() {
		if(mischung != null) {
			rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_MISCHUNG_CHART,false,new MessageItem(MessageItem.MSG_SHOW_MISCHUNG_CHART,0,mischung,this));
		}
    }
    
    private void TicketFilterClearAction() {
    	txtTicketSelection.setText("");
    	deselectTickets();
    }
    
    private void deselectTickets() {
    	tblTickets.clearSelection();
    }
    
    private void selectTickets(String nummer) {
    	deselectTickets();
    	if(!nummer.trim().equals("")) {
        	for(int i=0;i<tickets.size();i++) {
	        		if(tickets.get(i).getNummer().trim().contains(nummer)) {
	        			tblTickets.getSelectionModel().addSelectionInterval(i,i);
	        		}
        	}
    	}
    }

    private void stammbaumAction() {
    			if(mischung != null) {
    				rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_STAMMBAUM,false,new MessageItem(MessageItem.MSG_SHOW_STAMMBAUM,0,mischung,this));
    			}
    }
    
	/**
	 * den Dialog mit der Adressenliste anzeigen
	 * 
	 * 
	 */
	private void adressListeBearbeitenAction() {
		final AbfrageItem ai = new AbfrageItem();
		ai.setAdressListe(mischung.getHeader().getAdressen().copyList());
		rz.getFensterFactory().getFensterListe().createWindow(
				FensterFactory.FENSTER_ADRESSAUSWAHL,
				true,
				new MessageItem(MessageItem.MSG_ADRESSLISTE_REQUEST, 0, ai,
						this));
	}
	private void adressenLoeschenAction() {
		mischung.getHeader().getAdressen().clear();
		lstAdressen.setText(mischung.getHeader().getAdressen().toVerboseString());
		lstAdressen.setToolTipText(mischung.getHeader().getAdressen().toVerboseString());
	}
    
    private void linkAction(JEditorPane txt) {
		 final Document d = txt.getDocument();
		 final HTMLDocument hd = (HTMLDocument)d;
		 final int pos = txt.viewToModel( txt.getMousePosition() );
		 if ( pos >= 0 ) {
		 	final Element e = hd.getCharacterElement(pos);
		 	if (e != null) {
		 		final SimpleAttributeSet se = (SimpleAttributeSet)e.getAttributes().getAttribute(HTML.Tag.A);
		 		if(se != null) {
		 			final String ziel = se.getAttribute(HTML.Attribute.HREF).toString();
		 			if(ziel.indexOf("mi:")!= -1) {
		 				try {
		 					int id = Integer.parseInt(ziel.substring(3));
		 					if(id != 0) {
		 		    			rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_MISCHUNG, false, new MessageItem(MessageItem.MSG_SHOW_MISCHUNGSFENSTER,id,null,this));
		 					}
		 				}catch(Exception ex) {}
		 			}
		 		}
		 	}
		 }
    }
    
    private void druckenAction(boolean vorschau) {
			if(mischung  != null) {
				rz.getReportFactory().mischungDrucken(mischung, vorschau, this,chkDuplex.isSelected());
			}
    }
    
    private void showMischungsDialog(JButton bt,JIntegerField txt,int mode) {
		int x=this.getWidth()/2, y=this.getHeight()/2;
		x = (int) (bt.getLocationOnScreen().getX());
		y = (int) (bt.getLocationOnScreen().getY());
		if (md != null) {
			md.dispose();
			md = null;
		}
		if(rz.isMain()) {
			if(mode == MischungsDialog.MODE_ID) {
				 md = new MischungsDialog(this,rz, x,y,String.valueOf(txt.getValue()), mode);
			} else {
				 md = new MischungsDialog(this,rz, x,y,"", mode);	
			}
		}
		md.setVisible(true);
	}
	
    
    private void showTankDialog(Component bt,String nummer) {
		int x=this.getWidth()/2, y=this.getHeight()/2;
		x = (int) (bt.getLocationOnScreen().getX());
		y = (int) (bt.getLocationOnScreen().getY());
		if (td != null) {
			td.dispose();
			td = null;
		}
		td = new TankDialog(this,null,null, null,rz, x, y, nummer);
		td.setVisible(true);
		
	}
	
    private void mischungsListeReply(MischungsHeaderItem mi) {
		if(mi != null) {

			if(tabAktionen.getSelectedIndex() == TAB_UMPUMPENV) {
				txtUmpumpenMischungV.setValue(mi.getId());
				this.txtUmpumpenVTank.setText(mi.getTank());
		    	setUmpumpenVTankInhaltLabel();
			} else if(tabAktionen.getSelectedIndex() == TAB_UMPUMPENT) {
				txtUmpumpenMischungT.setValue(mi.getId());
				this.txtUmpumpenTTank.setText(mi.getTank());
		    	setUmpumpenTTankInhaltLabel();
			}
		}
	}
    
    
	private void tanklisteReply(tankItem ti) {
		if(ti != null) {
			boolean ok = true;
			if(ti.getNummer().equals(mischung.getHeader().getTank())) {
				ok = true;
			}
			if(ok) {
				if(tabAktionen.getSelectedIndex() == TAB_ABSCHLUSSV) {
					txtAbschlussVTank.setText(ti.getNummer());				
			    	setAbschlussVTankInhaltLabel();
				} else if(tabAktionen.getSelectedIndex() == TAB_ABSCHLUSST) {
					txtAbschlussTTank.setText(ti.getNummer());				
			    	setAbschlussTTankInhaltLabel();
				} else if(tabAktionen.getSelectedIndex() == TAB_UMPUMPENV) {
					txtUmpumpenVTank.setText(ti.getNummer());				
			    	setUmpumpenVTankInhaltLabel();
				} else if(tabAktionen.getSelectedIndex() == TAB_UMPUMPENT) {
					txtUmpumpenTTank.setText(ti.getNummer());				
			    	setUmpumpenTTankInhaltLabel();
				}
			}
		}
	}
    
	/*
	 * ------------------------------------------------------------------
	 * vollständig umpumpen
	 * ------------------------------------------------------------------
	 */
	private void umpumpenVAction() {
		String destTank = txtUmpumpenVTank.getText().trim();
		int destMischung = txtUmpumpenMischungV.getValue();
		if(checkTankNummer(destTank)) {
			if(!destTank.equals("") && destMischung == 0) {
				
				/*
				 * ---------------------------------------------
				 * 
				 * Die gesamte Mischung in einen leeren Tank umpumpen
				 * 
				 * ---------------------------------------------
				 */
				// alles in leeren Tank umpumpen
				ArrayList<tankItem> tl = rz.getDatabase().getTank().getTankListeFromTankPattern(txtUmpumpenVTank.getText().trim());
				double inhalt = 0;
				for(tankItem ti:tl) {
					inhalt += ti.getRestLiter();
				}
				if(rz.isZero(inhalt)) {
					/*
					 * -----------------------------------------------------
					 * Tank ist leer 
					 * Umpumpen OK
					 * -----------------------------------------------------
					 */
					if(mischung != null) {
						if(!destTank.equals(mischung.getHeader().getTank().trim())) {
							if(rz.getDatabase().getMischungen().tankUmpumpenVTransaktion(mischung,destTank)) {
								getMessage(new MessageItem(MessageItem.MSG_REFRESH_AUSGABE,mischung.getHeader().getId(),null,this ));
								rz.getFensterFactory().getFensterListe().propagateMischung(this, mischung.getHeader().getId());
	    						tabAktionen.setSelectedIndex(0);
							} else {
								//Fehler
							}
						} else {
							//nicht in denselben Tank umpumpen
							DialogItem di  = new DialogItem(
					                DialogControl.HINWEIS_DIALOG,
					                "",0.0,
					                rz.getLocale().getString("mischungbearbeitenfenster.dialog_umpumpen_v_tank_gleich"),
					                rz.getLocale().getString("mischungbearbeitenfenster.dialog_umpumpen_v_tank_gleich"),
					                rz.getLocale().getString("mischungbearbeitenfenster.dialog_umpumpen_v_tank_gleich_text")
					                	.replaceAll("%t", destTank),
					                "warnung.png",
					                rz.getLocale().getString("string_ok"),
					                "",
					                this
					        );
					        rz.getDialogFactory().getDialog(di);
						}
					}
				}else {
						/*
						 * ----------------------------------------------------
						 * Tank ist nicht leer
						 * Umpumpen nicht erlaubt
						 * -----------------------------------------------------
						 */
				    	DialogItem di  = new DialogItem(
				                DialogControl.HINWEIS_DIALOG,
				                "",0.0,
				                rz.getLocale().getString("mischungbearbeitenfenster.dialog_umpumpen_v_tank_nicht_leer"),
				                rz.getLocale().getString("mischungbearbeitenfenster.dialog_umpumpen_v_tank_nicht_leer"),
				                rz.getLocale().getString("mischungbearbeitenfenster.dialog_umpumpen_v_tank_nicht_leer_text")
				                	.replaceAll("%t", destTank),
				                "warnung.png",
				                rz.getLocale().getString("string_ok"),
				                "",
				                this
				        );
				        rz.getDialogFactory().getDialog(di);
					
					}
				}else {
					/*
					 * ------------------------------------------
					 * In eine andere Mischung umpumpen
					 * ------------------------------------------
					 */
					MischungsItem dest = rz.getDatabase().getMischungen().getMischung(destMischung);
					if(dest != null) {
						if(dest.getHeader().getId() != mischung.getHeader().getId()) {
							//umpumpen ok
							boolean ok = rz.getDatabase().getMischungen().checkMischung(mischung, dest.getHeader().getSorte().getId());
							if(!ok) {
				    			final DialogItem di  = new DialogItem(
			 		                    DialogControl.FRAGE_DIALOG,
			 		                    "",0.0,
			 		                    rz.getLocale().getString("ticketeingabe.question_mischung_umpumpen_inkompatibel"),
			 		                    rz.getLocale().getString("ticketeingabe.question_mischung_umpumpen_inkompatibel"),
			 		                    rz.getLocale().getString("ticketeingabe.question_mischung_umpumpen_inkompatibel.text")
			 		                    	.replaceAll("%m1",mischung.getHeader().getSorte().getBezeichnung())
			 		                    	.replaceAll("%m2",dest.getHeader().getSorte().getBezeichnung()),
			 		                    "frage.png",
			 		                    rz.getLocale().getString("string_ja"),
			 		                    rz.getLocale().getString("string_nein"),
			 		                    this
			 						);
			 		         rz.getDialogFactory().getDialog(di);
			 		         if ((di.getReplyCode() == DialogControl.DIALOG_YES) || (di.getReplyCode() == DialogControl.DIALOG_OK)){
			 		        	 ok= true;
			 		         	}
							}
							if(ok) {
								if(rz.getDatabase().getMischungen().mischungUmpumpenVTransaktion(mischung, dest)) {
									getMessage(new MessageItem(MessageItem.MSG_REFRESH_AUSGABE,mischung.getHeader().getId(),null,this ));
									rz.getFensterFactory().getFensterListe().propagateMischung(this, mischung.getHeader().getId());
									rz.getFensterFactory().getFensterListe().propagateMischung(this, dest.getHeader().getId());
		    						tabAktionen.setSelectedIndex(0);
								}else {
									//fehler
								}
							}
						}else {
							//Zielmischung = quellmischung
							DialogItem di  = new DialogItem(
					                DialogControl.HINWEIS_DIALOG,
					                "",0.0,
					                rz.getLocale().getString("mischungbearbeitenfenster.dialog_umpumpen_v_quelle_ziel_gleich"),
					                rz.getLocale().getString("mischungbearbeitenfenster.dialog_umpumpen_v_quelle_ziel_gleich"),
					                rz.getLocale().getString("mischungbearbeitenfenster.dialog_umpumpen_v_quelle_ziel_gleich_text")
					                	.replaceAll("%m", String.valueOf(destMischung)),
					                "warnung.png",
					                rz.getLocale().getString("string_ok"),
					                "",
					                this
					        );
					        rz.getDialogFactory().getDialog(di);
						}
					}else {
						// Mischung existiert nicht
						DialogItem di  = new DialogItem(
				                DialogControl.HINWEIS_DIALOG,
				                "",0.0,
				                rz.getLocale().getString("mischungbearbeitenfenster.dialog_umpumpen_v_keine_mischung"),
				                rz.getLocale().getString("mischungbearbeitenfenster.dialog_umpumpen_v_keine_mischung"),
				                rz.getLocale().getString("mischungbearbeitenfenster.dialog_umpumpen_v_keine_mischung_text")
				                	.replaceAll("%m", String.valueOf(destMischung)),
				                "warnung.png",
				                rz.getLocale().getString("string_ok"),
				                "",
				                this
				        );
				        rz.getDialogFactory().getDialog(di);
					}
				}
		}else {
			showAbschlussUnvollstaendigDialog(rz.getLocale().getString("mischungbearbeitenfenster.dialog_abschluss_unvollstaendig_tanknummer"));
		}
	}
	
	
	/*
	 * ------------------------------------------------------------------
	 * teilweise umpumpen
	 * ------------------------------------------------------------------
	 */
	private void umpumpenTAction() {
		String destTank = txtUmpumpenTTank.getText().trim();
		int destMischung = txtUmpumpenMischungT.getValue();
		double umpumpmenge = txtUmpumpenTMenge.getValue();
		if(!rz.isZero(umpumpmenge)) {
			if(checkTankNummer(destTank)) {
			if(!destTank.equals("") && destMischung == 0) {
				/*
				 * ---------------------------------------------
				 * 
				 * Die  Mischung in einen leeren Tank umpumpen
				 * 
				 * ---------------------------------------------
				 */
				// alles in leeren Tank umpumpen
				ArrayList<tankItem> tl = rz.getDatabase().getTank().getTankListeFromTankPattern(txtUmpumpenTTank.getText().trim());
				double inhalt = 0;
				for(tankItem ti:tl) {
					inhalt += ti.getRestLiter();
				}
				if(rz.isZero(inhalt)) {
					/*
					 * -----------------------------------------------------
					 * Tank ist leer 
					 * Umpumpen OK
					 * -----------------------------------------------------
					 */
					if(mischung != null) {
						if(!destTank.equals(mischung.getHeader().getTank().trim())) {
							int neueMischung = rz.getDatabase().getMischungen().mischungUmpumpenTTransaktion(mischung,mischung.getLA(),umpumpmenge,destTank,rz.getLocale().getString("dbmischungen.typ_umpumpen"));
							if(neueMischung >=0){
								getMessage(new MessageItem(MessageItem.MSG_REFRESH_AUSGABE,mischung.getHeader().getId(),null,this ));
								rz.getFensterFactory().getFensterListe().propagateMischung(this, mischung.getHeader().getId());
								rz.getFensterFactory().getFensterListe().propagateMischung(this, neueMischung);
	    						tabAktionen.setSelectedIndex(0);
							} else {
								//Fehler
							}
						} else {
							//nicht in denselben Tank umpumpen
							DialogItem di  = new DialogItem(
					                DialogControl.HINWEIS_DIALOG,
					                "",0.0,
					                rz.getLocale().getString("mischungbearbeitenfenster.dialog_umpumpen_v_tank_gleich"),
					                rz.getLocale().getString("mischungbearbeitenfenster.dialog_umpumpen_v_tank_gleich"),
					                rz.getLocale().getString("mischungbearbeitenfenster.dialog_umpumpen_v_tank_gleich_text")
					                	.replaceAll("%t", destTank),
					                "warnung.png",
					                rz.getLocale().getString("string_ok"),
					                "",
					                this
					        );
					        rz.getDialogFactory().getDialog(di);
						}
					}
				}else {
						/*
						 * ----------------------------------------------------
						 * Tank ist nicht leer
						 * Umpumpen nicht erlaubt
						 * -----------------------------------------------------
						 */
				    	DialogItem di  = new DialogItem(
				                DialogControl.HINWEIS_DIALOG,
				                "",0.0,
				                rz.getLocale().getString("mischungbearbeitenfenster.dialog_umpumpen_v_tank_nicht_leer"),
				                rz.getLocale().getString("mischungbearbeitenfenster.dialog_umpumpen_v_tank_nicht_leer"),
				                rz.getLocale().getString("mischungbearbeitenfenster.dialog_umpumpen_v_tank_nicht_leer_text")
				                	.replaceAll("%t", destTank),
				                "warnung.png",
				                rz.getLocale().getString("string_ok"),
				                "",
				                this
				        );
				        rz.getDialogFactory().getDialog(di);
					
					}
				}else {
					/*
					 * ------------------------------------------
					 * In eine andere Mischung umpumpen
					 * ------------------------------------------
					 */
					MischungsItem dest = rz.getDatabase().getMischungen().getMischung(destMischung);
					if(dest != null) {
						if(dest.getHeader().getId() != mischung.getHeader().getId()) {
							//umpumpen ok
							boolean ok = rz.getDatabase().getMischungen().checkMischung(mischung, dest.getHeader().getSorte().getId());
							if(!ok) {
				    			final DialogItem di  = new DialogItem(
			 		                    DialogControl.FRAGE_DIALOG,
			 		                    "",0.0,
			 		                    rz.getLocale().getString("ticketeingabe.question_mischung_umpumpen_inkompatibel"),
			 		                    rz.getLocale().getString("ticketeingabe.question_mischung_umpumpen_inkompatibel"),
			 		                    rz.getLocale().getString("ticketeingabe.question_mischung_umpumpen_inkompatibel.text")
			 		                    	.replaceAll("%m1",mischung.getHeader().getSorte().getBezeichnung())
			 		                    	.replaceAll("%m2",dest.getHeader().getSorte().getBezeichnung()),
			 		                    "frage.png",
			 		                    rz.getLocale().getString("string_ja"),
			 		                    rz.getLocale().getString("string_nein"),
			 		                    this
			 						);
			 		         rz.getDialogFactory().getDialog(di);
			 		         if ((di.getReplyCode() == DialogControl.DIALOG_YES) || (di.getReplyCode() == DialogControl.DIALOG_OK)){
			 		        	 ok= true;
			 		         	}
							}
							if(ok) {
								if(rz.getDatabase().getMischungen().mischungUmpumpenTTransaktion(mischung, dest, mischung.getLA(),umpumpmenge,rz.getLocale().getString("dbmischungen.typ_umpumpen"))) {
									getMessage(new MessageItem(MessageItem.MSG_REFRESH_AUSGABE,mischung.getHeader().getId(),null,this ));
									rz.getFensterFactory().getFensterListe().propagateMischung(this, mischung.getHeader().getId());
									rz.getFensterFactory().getFensterListe().propagateMischung(this, dest.getHeader().getId());
		    						tabAktionen.setSelectedIndex(0);
								}else {
									//fehler
								}
							}
						}else {
							//Zielmischung = quellmischung
							DialogItem di  = new DialogItem(
					                DialogControl.HINWEIS_DIALOG,
					                "",0.0,
					                rz.getLocale().getString("mischungbearbeitenfenster.dialog_umpumpen_v_quelle_ziel_gleich"),
					                rz.getLocale().getString("mischungbearbeitenfenster.dialog_umpumpen_v_quelle_ziel_gleich"),
					                rz.getLocale().getString("mischungbearbeitenfenster.dialog_umpumpen_v_quelle_ziel_gleich_text")
					                	.replaceAll("%m", String.valueOf(destMischung)),
					                "warnung.png",
					                rz.getLocale().getString("string_ok"),
					                "",
					                this
					        );
					        rz.getDialogFactory().getDialog(di);
						}
					}else {
						// Mischung existiert nicht
						DialogItem di  = new DialogItem(
				                DialogControl.HINWEIS_DIALOG,
				                "",0.0,
				                rz.getLocale().getString("mischungbearbeitenfenster.dialog_umpumpen_v_keine_mischung"),
				                rz.getLocale().getString("mischungbearbeitenfenster.dialog_umpumpen_v_keine_mischung"),
				                rz.getLocale().getString("mischungbearbeitenfenster.dialog_umpumpen_v_keine_mischung_text")
				                	.replaceAll("%m", String.valueOf(destMischung)),
				                "warnung.png",
				                rz.getLocale().getString("string_ok"),
				                "",
				                this
				        );
				        rz.getDialogFactory().getDialog(di);
					}
				}
			}else {
				showAbschlussUnvollstaendigDialog(rz.getLocale().getString("mischungbearbeitenfenster.dialog_abschluss_unvollstaendig_tanknummer"));
			}
		}
	}
	
	
	
	private void tanklisteTextAction(JButton bt,JSelectedTextField txt) {
		showTankDialog(bt,txt.getText().trim());
	}
	
	private void tanklistePlanAction(JButton bt,JSelectedTextField txt) {
		ArrayList<tankItem> ti = rz.getDatabase().getTank().getTankListeFromTankPattern(txt.getText().trim());
		int messageCode = MessageItem.MSG_SHOW_TANKAUSWAHL;
		if(bt == this.btUmpumpenTTankPlan || bt == this.btUmpumpenVTankPlan) {
			 messageCode = MessageItem.MSG_SHOW_TANKAUSWAHL_MISCHUNG;
		}
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_TANKAUSWAHL,false,new MessageItem(messageCode,0,(Object)(new tankAuswahlItem(ti,this,null,null,null)),this));
	}
    
    private void zutatenDialogReply(ZutatenSuchItem zi,int which) {
    	if(zi != null) {
    		switch(which) {
    			case QUERY_REZEPTUR_ABSCHLUSS :
    				abschlussRezeptur = zi.getID();
	    			abschlussStaerke  = zi.getStaerke();
	    			abschlussTitel = zi.getName();
	    			lblabschlussVDatenRezeptur.setText(zi.getName());
	    			btabschlussVDatenRezeptur.setBackground(Color.YELLOW);
	    			txtabschlussVDatenMengeStaerke.setValue(zi.getStaerke());
	    			setAbschlussLiter();
	    			break;
    			case QUERY_REZEPTUR_ABSCHLUSS_T:
	    			abschlussRezeptur = zi.getID();
	    			abschlussStaerke  = zi.getStaerke();
	    			abschlussTitel = zi.getName();
	    			lblabschlussTDatenRezeptur.setText(zi.getName());
	    			btabschlussTDatenRezeptur.setBackground(Color.YELLOW);
	    			txtabschlussTDatenMengeStaerke.setValue(zi.getStaerke());
	    			setAbschlussTLiter();
	    			break;
	    		default:
	    			mischung.getHeader().setRezeptur_id(zi.getID());
	    			txtMischungBezeichnung.setText(zi.getName());
	    			btRezeptur.setBackground(Color.YELLOW);
	    			txtabschlussVDatenMengeStaerke.setValue(0);
	    			break;
    			}
    	}
    	if(zd != null) {
    		zd.dispose();
    		zd= null;
    	}
    }
    
    private void deselectRezepturAction() {
    	if(mischung != null) {
    		mischung.getHeader().setRezeptur_id(0);
    		txtMischungBezeichnung.setText("");
    		btRezeptur.setBackground(btBackground);
    	}
    }
    
    private void deselectAbschlussRezepturAction() {
    	if(mischung != null) {
			abschlussRezeptur = 0;
			abschlussStaerke  = 0;
			abschlussTitel = "";
			abschlussLiter = 0;
			lblabschlussVDatenRezeptur.setText("");
			btabschlussVDatenRezeptur.setBackground(btBackground);
			txtabschlussVDatenMengeStaerke.setValue(0);
    	}
    }
    
    private void deselectAbschlussTRezepturAction() {
    	if(mischung != null) {
			abschlussRezeptur = 0;
			abschlussStaerke  = 0;
			abschlussTitel = "";
			abschlussLiter = 0;
			lblabschlussTDatenRezeptur.setText("");
			btabschlussTDatenRezeptur.setBackground(btBackground);
			txtabschlussTDatenMengeStaerke.setValue(0);
    	}
    }
    
    private void selectRezepturAction() {
		int x, y;
		x = (int) (btRezeptur.getLocationOnScreen().getX() );
		y = (int) (btRezeptur.getLocationOnScreen().getY() );
		if(zd != null) {
			zd.dispose();
			zd=null;
		}
		zd = new ZutatenDialog(this, rz, x, y,txtMischungBezeichnung.getText().trim(),ZutatenDialog.MODE_REZEPTUREN,QUERY_REZEPTUR_MAIN);
		zd.setVisible(true);
    }
    
    private void selectAbschlussRezepturAction() {
		int x, y;
		x = (int) (btabschlussVDatenRezeptur.getLocationOnScreen().getX() );
		y = (int) (btabschlussVDatenRezeptur.getLocationOnScreen().getY() );
		if(zd != null) {
			zd.dispose();
			zd=null;
		}
		zd = new ZutatenDialog(this, rz, x, y,lblabschlussVDatenRezeptur.getText().trim(),ZutatenDialog.MODE_REZEPTUREN,QUERY_REZEPTUR_ABSCHLUSS);
		zd.setVisible(true);
    }

    private void selectAbschlussTRezepturAction() {
		int x, y;
		x = (int) (btabschlussTDatenRezeptur.getLocationOnScreen().getX() );
		y = (int) (btabschlussTDatenRezeptur.getLocationOnScreen().getY() );
		if(zd != null) {
			zd.dispose();
			zd=null;
		}
		zd = new ZutatenDialog(this, rz, x, y,lblabschlussTDatenRezeptur.getText().trim(),ZutatenDialog.MODE_REZEPTUREN,QUERY_REZEPTUR_ABSCHLUSS_T);
		zd.setVisible(true);
    }
    
    private void checkFreigabeAction() {
    	if(mischung != null) {
    		refreshAction(false);
    	}
    }
    
    private void tabChangedAction(int tab) {
    	if(mischung != null) {
	    	switch(tab) {
	    		case TAB_ZUSAMMENFASSEN:
	    			setupZusammenfassenTab();
	    			break;
	    		case TAB_ABSCHLUSSV:
	    			setupAbschlussVTab();
	    	    	txtabschlussVDatenMengeStaerke.requestFocus();
	    			break;
	    		case TAB_ABSCHLUSST:
	    			setupAbschlussTTab();
	    	    	txtabschlussTDatenMenge.requestFocus();
	    			break;
	    		case TAB_UMPUMPENV:
	    			setupUmpumpenVTab();
	    	    	txtUmpumpenVTank.requestFocus();
	    			break;
	    		case TAB_UMPUMPENT:
	    			setupUmpumpenTTab();
	    	    	txtUmpumpenTMenge.requestFocus();
	    			break;
	    	}
	    }
    }
    
    private void setupZusammenfassenTab() {
    	
    }
    private void setupUmpumpenVTab() {
    	double menge = mischung.getLA();
    	lblUmpumpenVMenge.setText(rz.getLocale().getString("mischungbearbeitenfenster.label_umpumpenv_menge").replaceAll("%s",rz.getLocale().formatNumber(menge, OptionFactory.NF_NORMAL)));
    }
    
    private void setupUmpumpenTTab() {
    	double menge = mischung.getLA();
    	lblUmpumpenTMenge.setText(rz.getLocale().getString("mischungbearbeitenfenster.label_umpumpent_menge"));
    	lblUmpumpenTMenge2.setText(rz.getLocale().getString("mischungbearbeitenfenster.label_umpumpent_menge_2").replaceAll("%s",rz.getLocale().formatNumber(menge, OptionFactory.NF_NORMAL)));
    }
    
    private void setupAbschlussVTab() {
    	abschlussRezeptur = mischung.getHeader().getRezeptur_id();
    	if(abschlussRezeptur != 0) {
    		RezepturHeaderItem rhi = rz.getDatabase().getRezeptur().getHeader(abschlussRezeptur);
    		abschlussTitel = rhi.getTitel();
    		abschlussStaerke = rhi.getStaerke();
    		btabschlussVDatenRezeptur.setBackground(Color.YELLOW);
			lblabschlussVDatenRezeptur.setText(abschlussTitel+ " (" + rhi.getArtikelnummer()+")");
			txtabschlussVDatenMengeStaerke.setValue(rhi.getStaerke());
			abschlussLiter = (abschlussStaerke >0)?((mischung.getLA() *100)/abschlussStaerke) :0; 
    	} else {
    		abschlussTitel = "";
    		abschlussStaerke = 0;
    		abschlussLiter = 0;
    		btabschlussVDatenRezeptur.setBackground(btBackground);
    		lblabschlussVDatenRezeptur.setText("");
    		txtabschlussVDatenMengeStaerke.setValue(0);
    	}
    	txtAbschlussVTank.setText(mischung.getHeader().getTank());
    	setAbschlussVTankInhaltLabel();
    	lblabschlussVDatenMenge.setText(rz.getLocale().getString("mischungbearbeitenfenster.label_abschluss_menge_la").replaceAll("%l", rz.getLocale().formatNumber(mischung.getLA(),OptionFactory.NF_NORMAL)));
    	setAbschlussLiter();
    }

    private void setupAbschlussTTab() {
    	abschlussRezeptur = mischung.getHeader().getRezeptur_id();
    	if(abschlussRezeptur != 0) {
    		RezepturHeaderItem rhi = rz.getDatabase().getRezeptur().getHeader(abschlussRezeptur);
    		abschlussTitel = rhi.getTitel();
    		abschlussStaerke = rhi.getStaerke();
    		btabschlussTDatenRezeptur.setBackground(Color.YELLOW);
			lblabschlussTDatenRezeptur.setText(abschlussTitel+ " (" + rhi.getArtikelnummer()+")");
			txtabschlussTDatenMengeStaerke.setValue(rhi.getStaerke());
			abschlussLiter = (abschlussStaerke >0)?((mischung.getLA() *100)/abschlussStaerke) :0; 
    	} else {
    		abschlussTitel = "";
    		abschlussStaerke = 0;
    		abschlussLiter = 0;
    		btabschlussTDatenRezeptur.setBackground(btBackground);
    		lblabschlussTDatenRezeptur.setText("");
    		txtabschlussTDatenMengeStaerke.setValue(0);
    	}
    	txtAbschlussTTank.setText("");
    	setAbschlussTTankInhaltLabel();
    	lblabschlussTDatenMenge.setText(rz.getLocale().getString("mischungbearbeitenfenster.label_abschluss_t_menge_la").replaceAll("%l", rz.getLocale().formatNumber(mischung.getLA(),OptionFactory.NF_NORMAL)));
    	setAbschlussTLiter();
    }
    
    
    private void setAbschlussLiter() {
    	abschlussStaerke = this.txtabschlussVDatenMengeStaerke.getValue();
		try {
			abschlussLiter = (abschlussStaerke >0)?((mischung.getLA() *100)/abschlussStaerke) :0;
	    	lblabschlussVDatenMengeLiter.setText(rz.getLocale().getString("mischungbearbeitenfenster.label_abschluss_menge_liter").replaceAll("%l", rz.getLocale().formatNumber(abschlussLiter,OptionFactory.NF_NORMAL)));
		} catch(Exception e) {}
    }
    
    private void setAbschlussTLiter() {
    	abschlussStaerke = this.txtabschlussTDatenMengeStaerke.getValue();
    	double menge = txtabschlussTDatenMenge.getValue();
    	menge = menge > mischung.getLA()?mischung.getLA():menge;
    	txtabschlussTDatenMenge.setValue(menge);
    	try {
    		abschlussLiter = (abschlussStaerke >0)?((menge *100)/abschlussStaerke) :0; 
    		lblabschlussTDatenMengeLiter.setText(rz.getLocale().getString("mischungbearbeitenfenster.label_abschluss_t_menge_liter").replaceAll("%l", rz.getLocale().formatNumber(abschlussLiter,OptionFactory.NF_NORMAL)));
    	} catch(Exception e) {}
    }

    
    private void setAbschlussTTankInhaltLabel() {
    	ArrayList<tankItem> liste = rz.getDatabase().getTank().getTankInhaltsListeSingle(txtAbschlussTTank.getText().trim());
    	String ret = "";
    	if(liste != null && liste.size() > 0) {
	    	for(tankItem ti:liste) {
	    		String l = ti.getInhaltsListe().getInhaltBezeichnung().replaceAll("\\n", "<br>");
	    		if(l.trim().equals("")) {
	    			l=ret += rz.getLocale().getString("mischungbearbeitenfenster.label_abschluss_t_tankinhalt_leer");
	    		}
	    		if(ti.isMischung()) {
	    			ret += rz.getLocale().getString("mischungbearbeitenfenster.label_abschluss_t_tankinhalt_mischung").replaceAll("%t", ti.getNummer()).replaceAll("%s",l);
	    		}else if (ti.isStellplatz()){
	    			ret += rz.getLocale().getString("mischungbearbeitenfenster.label_abschluss_t_tankinhalt_stellplatz").replaceAll("%t", ti.getNummer()).replaceAll("%s",l);
	    		} else {
	    			ret += rz.getLocale().getString("mischungbearbeitenfenster.label_abschluss_t_tankinhalt_tank").replaceAll("%t", ti.getNummer()).replaceAll("%s",l);
	    		}
	    		ret+="<br>";
	    	}
    	} else {
			ret += "";
    	}
    	while(ret.endsWith("<br>"))ret = ret.substring(0,ret.length()-4);
    	lblAbschlussTTankInhalt.setText(ret.equals("")?"<html>"+rz.getLocale().getString("mischungbearbeitenfenster.label_abschluss_t_tankinhalt_leer")+"</html>":"<html>"+ret+"</html>");
    }
    
    private void setAbschlussVTankInhaltLabel() {
    	ArrayList<tankItem> liste = rz.getDatabase().getTank().getTankInhaltsListeSingle(txtAbschlussVTank.getText().trim());
    	String ret = "";
    	if(liste != null && liste.size() > 0) {
	    	for(tankItem ti:liste) {
	    		String l = ti.getInhaltsListe().getInhaltBezeichnung().replaceAll("\\n", "<br>");
	    		if(l.trim().equals("")) {
	    			l=ret += rz.getLocale().getString("mischungbearbeitenfenster.label_abschluss_tankinhalt_leer");
	    		}
	    		if(ti.isMischung()) {
	    			ret += rz.getLocale().getString("mischungbearbeitenfenster.label_abschluss_tankinhalt_mischung").replaceAll("%t", ti.getNummer()).replaceAll("%s",l);
	    		}else if (ti.isStellplatz()){
	    			ret += rz.getLocale().getString("mischungbearbeitenfenster.label_abschluss_tankinhalt_stellplatz").replaceAll("%t", ti.getNummer()).replaceAll("%s",l);
	    		} else {
	    			ret += rz.getLocale().getString("mischungbearbeitenfenster.label_abschluss_tankinhalt_tank").replaceAll("%t", ti.getNummer()).replaceAll("%s",l);
	    		}
	    		ret+="<br>";
	    	}
    	} else {
			ret += "";
    	}
    	while(ret.endsWith("<br>"))ret = ret.substring(0,ret.length()-4);
    	lblAbschlussVTankInhalt.setText(ret.equals("")?"<html>"+rz.getLocale().getString("mischungbearbeitenfenster.label_abschluss_tankinhalt_leer")+"</html>":"<html>"+ret+"</html>");
    }
    
    private void setUmpumpenVTankInhaltLabel() {
    	ArrayList<tankItem> liste = rz.getDatabase().getTank().getTankInhaltsListeSingle(txtUmpumpenVTank.getText().trim());
    	String ret = "";
		txtUmpumpenMischungV.setValue(rz.getDatabase().getMischungen().getTankMischung(txtUmpumpenVTank.getText().trim()));
    	if(liste != null && liste.size() > 0) {
	    	for(tankItem ti:liste) {
	    		String l = ti.getInhaltsListe().getInhaltBezeichnung().replaceAll("\\n", "<br>");
	    		if(l.trim().equals("")) {
	    			l=ret += rz.getLocale().getString("mischungbearbeitenfenster.label_abschluss_tankinhalt_leer");
	    		}
	    		if(ti.isMischung()) {
	    			ret += rz.getLocale().getString("mischungbearbeitenfenster.label_abschluss_tankinhalt_mischung").replaceAll("%t", ti.getNummer()).replaceAll("%s",l);
	    		}else if (ti.isStellplatz()){
	    			ret += rz.getLocale().getString("mischungbearbeitenfenster.label_abschluss_tankinhalt_stellplatz").replaceAll("%t", ti.getNummer()).replaceAll("%s",l);
	    		} else {
	    			ret += rz.getLocale().getString("mischungbearbeitenfenster.label_abschluss_tankinhalt_tank").replaceAll("%t", ti.getNummer()).replaceAll("%s",l);
	    		}
	    		ret+="<br>";
	    	}
    	} else {
			ret += "";
    	}
    	while(ret.endsWith("<br>"))ret = ret.substring(0,ret.length()-4);
    	lblUmpumpenVTankInhalt.setText(ret.equals("")?"<html>"+rz.getLocale().getString("mischungbearbeitenfenster.label_abschluss_tankinhalt_leer")+"</html>":"<html>"+ret+"</html>");
    }
    
    private void setUmpumpenTTankInhaltLabel() {
    	ArrayList<tankItem> liste = rz.getDatabase().getTank().getTankInhaltsListeSingle(txtUmpumpenTTank.getText().trim());
    	String ret = "";
		txtUmpumpenMischungT.setValue(rz.getDatabase().getMischungen().getTankMischung(txtUmpumpenTTank.getText().trim()));
    	if(liste != null && liste.size() > 0) {
	    	for(tankItem ti:liste) {
	    		String l = ti.getInhaltsListe().getInhaltBezeichnung().replaceAll("\\n", "<br>");
	    		if(l.trim().equals("")) {
	    			l=ret += rz.getLocale().getString("mischungbearbeitenfenster.label_abschluss_tankinhalt_leer");
	    		}
	    		if(ti.isMischung()) {
	    			ret += rz.getLocale().getString("mischungbearbeitenfenster.label_abschluss_tankinhalt_mischung").replaceAll("%t", ti.getNummer()).replaceAll("%s",l);
	    		}else if (ti.isStellplatz()){
	    			ret += rz.getLocale().getString("mischungbearbeitenfenster.label_abschluss_tankinhalt_stellplatz").replaceAll("%t", ti.getNummer()).replaceAll("%s",l);
	    		} else {
	    			ret += rz.getLocale().getString("mischungbearbeitenfenster.label_abschluss_tankinhalt_tank").replaceAll("%t", ti.getNummer()).replaceAll("%s",l);
	    		}
	    		ret+="<br>";
	    	}
    	} else {
			ret += "";
    	}
    	while(ret.endsWith("<br>"))ret = ret.substring(0,ret.length()-4);
    	lblUmpumpenTTankInhalt.setText(ret.equals("")?"<html>"+rz.getLocale().getString("mischungbearbeitenfenster.label_abschluss_tankinhalt_leer")+"</html>":"<html>"+ret+"</html>");
    }
    
    private void zusammenfassenAction() {
    	MischungsFreigabeItem mfi = mischung.getFreigabeItem();
    	if(mfi != null) {
	    	if(mischung != null && mischung.getLA() >0) {
	    		if(!mischung.getHeader().getTank().equals("")) {
	    			if(rz.getDatabase().getMischungen().zusammenfassenTransaction(mischung)) {
	    				getMessage(new MessageItem(MessageItem.MSG_REFRESH_AUSGABE,mischung.getHeader().getId(),null,this ));
						tabAktionen.setSelectedIndex(0);
	    			}
	    		}
	    	}
    	}
    }
    
    private void abschlussOKAction() {
    	if(true) {
    		//Mischung mit Menge aufheben
    		if(abschlussRezeptur != 0) {
    			if(!txtAbschlussVLosnummer.getText().trim().equals("")) {
    				if(this.txtabschlussVDatenMengeStaerke.getValue() > 0 ) {
    					if(checkTankNummer(this.txtAbschlussVTank.getText().trim())) {
							if(isZielTankOK(this.txtAbschlussVTank.getText().trim())|| txtAbschlussVTank.getText().trim().equals(mischung.getHeader().getTank())) {
								if(!rz.getDatabase().getBuchungen().checkLosnummer(txtAbschlussVLosnummer.getText().trim())) {
									boolean ret = rz.getDatabase().getMischungen().abschlussVollstaendigTransaction(mischung,this.txtAbschlussVTank.getText().trim(),this.txtAbschlussVLosnummer.getText().trim(),abschlussRezeptur,mischung.getLA(),this.txtabschlussVDatenMengeStaerke.getValue(),abschlussLiter);
			    					if(ret) {
			    						int id = mischung.getHeader().getId();
			    						rz.getFensterFactory().getFensterListe().propagateBestand(this,abschlussRezeptur);
			    						getMessage(new MessageItem(MessageItem.MSG_REFRESH_AUSGABE,id,null,this ));
			    						tabAktionen.setSelectedIndex(0);
			    					}
								} else {
									showAbschlussUnvollstaendigDialog(rz.getLocale().getString("mischungbearbeitenfenster.dialog_losnummer_exists"));
								}
							}else {
								showAbschlussUnvollstaendigDialog(rz.getLocale().getString("mischungbearbeitenfenster.dialog_abschluss_unvollstaendig_tank"));
							}
						}else {
							showAbschlussUnvollstaendigDialog(rz.getLocale().getString("mischungbearbeitenfenster.dialog_abschluss_unvollstaendig_tanknummer"));
						}
    				} else {
    					showAbschlussUnvollstaendigDialog(rz.getLocale().getString("mischungbearbeitenfenster.dialog_abschluss_unvollstaendig_staerke"));
    				}
    			} else {
        			showAbschlussUnvollstaendigDialog(rz.getLocale().getString("mischungbearbeitenfenster.dialog_abschluss_unvollstaendig_losnummer"));
    			}
    		}else {
    			showAbschlussUnvollstaendigDialog(rz.getLocale().getString("mischungbearbeitenfenster.dialog_abschluss_unvollstaendig_Rezeptur"));
    		}
    	} else {
    		// keine Menge vorhanden
    		
    	}
    }
    
    private void nullAbschlussAction() {
    	if(mischung != null && rz.isZero(mischung.getLA())) {
    		if(rz.getDatabase().getMischungen().abschlussNull(mischung)) {
    			rz.getFensterFactory().getFensterListe().propagateBestand(this);
				getMessage(new MessageItem(MessageItem.MSG_REFRESH_AUSGABE,mischung.getHeader().getId(),null,this ));
				tabAktionen.setSelectedIndex(0);
    		}else {
    			//fehler
    		}
    	}
    }
    
    private void abschlussTOKAction() {
    	if(mischung.getLA() > 0) {
    		//Mischung mit Menge aufheben
    		if(abschlussRezeptur != 0) {
    			if(!txtAbschlussTLosnummer.getText().trim().equals("")) {
    				if(txtabschlussTDatenMengeStaerke.getValue() > 0 ) {
    					if( txtabschlussTDatenMenge.getValue() > 0) {
    						if(checkTankNummer(this.txtAbschlussTTank.getText().trim())) {
	    						if(isZielTankOK(this.txtAbschlussTTank.getText().trim())) {
									if(!rz.getDatabase().getBuchungen().checkLosnummer(txtAbschlussTLosnummer.getText().trim())) {
			    						boolean ret = rz.getDatabase().getMischungen().abschlussTeilweiseTransaction(mischung,this.txtAbschlussTTank.getText().trim(),this.txtAbschlussTLosnummer.getText().trim(),abschlussRezeptur,mischung.getLA(),txtabschlussTDatenMenge.getValue(),txtabschlussTDatenMengeStaerke.getValue(),abschlussLiter);
					    					if(ret) {
					    						rz.getFensterFactory().getFensterListe().propagateBestand(this,abschlussRezeptur);
					    						getMessage(new MessageItem(MessageItem.MSG_REFRESH_AUSGABE,mischung.getHeader().getId(),null,this ));
					    						tabAktionen.setSelectedIndex(0);
					    					}
										} else {
											showAbschlussUnvollstaendigDialog(rz.getLocale().getString("mischungbearbeitenfenster.dialog_losnummer_exists"));
										}
		    						}else {
		    							showAbschlussUnvollstaendigDialog(rz.getLocale().getString("mischungbearbeitenfenster.dialog_abschluss_unvollstaendig_tank"));
		    						}
		    					} else {
									showAbschlussUnvollstaendigDialog(rz.getLocale().getString("mischungbearbeitenfenster.dialog_abschluss_unvollstaendig_tanknummer"));
		    					} 
    						}
    						else {
        					showAbschlussUnvollstaendigDialog(rz.getLocale().getString("mischungbearbeitenfenster.dialog_abschluss_t_unvollstaendig_menge"));
    					}
    				} else {
    					showAbschlussUnvollstaendigDialog(rz.getLocale().getString("mischungbearbeitenfenster.dialog_abschluss_unvollstaendig_staerke"));
    				}
    			} else {
        			showAbschlussUnvollstaendigDialog(rz.getLocale().getString("mischungbearbeitenfenster.dialog_abschluss_unvollstaendig_losnummer"));
    			}
    		}else {
    			showAbschlussUnvollstaendigDialog(rz.getLocale().getString("mischungbearbeitenfenster.dialog_abschluss_unvollstaendig_Rezeptur"));
    		}
    	} else {
    		// keine Menge vorhanden
    		
    	}
    }
    /*
     * es darf nur EIN Tank angegeben sein
     */
    private boolean checkTankNummer(String tank) {
    	return tank.matches("^[a-zA-Z0-9_äöüÄÖÜ]*$");
    }
    private boolean isZielTankOK(String tank) {
    	// prüft ob der Zieltank entweder leer ist oder eine Losnummer enthält
    	// zum abschliessen darf keine Mischung im Tank sein
    	boolean ret = false;
    	if(!tank.equals("")) {
	    	if(rz.getDatabase().getMischungen().getTankMischung(tank) == 0){
	    		ret = true;
	    	}
    	}
    	return ret;
    }
    
    private void abschlussLosnummerVorschlagAction() {
    	if(mischung != null) {
    		txtAbschlussVLosnummer.setText(rz.getDatabase().getBuchungen().getLosnummerVorschlag(mischung,abschlussRezeptur));
    	}
    }

    private void abschlussTLosnummerVorschlagAction() {
    	if(mischung != null) {
    		txtAbschlussTLosnummer.setText(rz.getDatabase().getBuchungen().getLosnummerVorschlag(mischung,abschlussRezeptur));
    	}
    }
    
    private void disableInactive() {
    	if(!mischung.getHeader().isActive()) {
    		// Keine Bearbeitung von Tickets mehr zulässig
    	      
    	      getAction(ACTION_TICKET_ADD_CODE).setEnabled(false);
    	      getAction(ACTION_TICKET_EDIT_CODE).setEnabled(false);
    	      btCheckAll.setAction(getAction(ACTION_TICKET_CHECKALL_CODE));
    	      getAction(ACTION_REZEPTUR_CODE).setEnabled(false);
    	      getAction(ACTION_REZEPTUR_REMOVE_CODE).setEnabled(false);
    	      getAction(ACTION_SAVE_CODE).setEnabled(false);
    	      getAction(ACTION_CHECK_FREIGABE_CODE).setEnabled(false);
    	      txtMischungBezeichnung.setEnabled(false);
    	      txtBemerkungen.setEnabled(false);
    	      cmbSorte.setEnabled(false);
    	      getAction(ACTION_ABSCHLUSS_V_OK_CODE).setEnabled(false);
    	      //tabbedPane
    	      tabAktionen.setSelectedIndex(TAB_HILFE);
    	      tabAktionen.setEnabledAt(TAB_HILFE, true);
    	      tabAktionen.setEnabledAt(TAB_ABSCHLUSSV, false);
    	      tabAktionen.setEnabledAt(TAB_NULL, false);
    	      tabAktionen.setEnabledAt(TAB_ABSCHLUSST, false);
    	      tabAktionen.setEnabledAt(TAB_UMPUMPENV, false);
    	      tabAktionen.setEnabledAt(TAB_UMPUMPENT, false);
    	      tabAktionen.setEnabledAt(TAB_ZUSAMMENFASSEN, false);
    	} else {
  	      getAction(ACTION_TICKET_ADD_CODE).setEnabled(true);
  	      getAction(ACTION_TICKET_EDIT_CODE).setEnabled(true);
    	}
    }

    private void setInitials() {
    	if(mischung != null) {
    		initialRezeptur = mischung.getHeader().getRezeptur_id();
    		initialBezeichnung = mischung.getHeader().getBezeichnung();
    		initialBemerkungen = mischung.getHeader().getBemerkungen();
    		initialSorte = mischung.getHeader().getSorte().getBezeichnung();
    		initialLager = mischung.getHeader().getLager();
    		initialLagerText = rz.getDatabase().getLager().dbGetLager(initialLager, true).getName();
    		initialAdressen = mischung.getHeader().getAdressen().toString();
    		initialAdressListe = mischung.getHeader().getAdressen();
    	}
    }
    
    private void fromItem() {
    	if(mischung != null) {
    		setInitials();
	    	lblMischungNummer.setText(rz.getLocale().getString("mischungbearbeitenfenster.label_mischungsnummer").replaceAll("%s", String.valueOf(mischung.getHeader().getId())).replaceAll("%t", mischung.getHeader().getTank()));
	    	txtMischungBezeichnung.setText(mischung.getHeader().getBezeichnung());
	    	txtBemerkungen.setText(mischung.getHeader().getBemerkungen());
	    	try {
	    		for(int i = 0;i < cmbSorte.getModel().getSize();i++) {
	    			if(((SortenItem)cmbSorte.getItemAt(i)).getId()== mischung.getHeader().getSorte().getId()) {
		    			cmbSorte.setSelectedIndex(i);
		    			break;
	    			}
	    		}
	    	} catch(Exception e) {}
	    	lstAdressen.setText(mischung.getHeader().getAdressen().toVerboseString());
	    	lstAdressen.setToolTipText(mischung.getHeader().getAdressen().toVerboseString());
	    	if(mischung.getHeader().getRezeptur_id() != 0) {
	    		btRezeptur.setBackground(Color.YELLOW);
	    	}else {
	    		btRezeptur.setBackground(btBackground);
	    	}
			rz.getDatabase().getLager().setLagerCmb(cmbLager,mischung.getHeader().getLager());
    	}
    }

    private void toItem() {
    	if(mischung != null) {
    		mischung.getHeader().setBezeichnung(txtMischungBezeichnung.getText().trim());
    		mischung.getHeader().setBemerkungen(txtBemerkungen.getText().trim());
    		mischung.getHeader().setSorte(((SortenItem)cmbSorte.getSelectedItem()).getId());
    		mischung.getHeader().setLager(((LagerItem)cmbLager.getSelectedItem()).getID());
    		rz.getDatabase().getMischungen().updateMischungShort(mischung);
    		if(setAenderungen()) {
            	mischung = new MischungsItem(rz,mischung.getHeader().getId());
            	fromItem();
            	refreshAction(true);
    		}
    	}
    }
    
    private boolean  setAenderungen(){
    	boolean ret = false;
    	String n="";
    	if(!mischung.getHeader().getAdressen().toString().equals(initialAdressen)) {
    		n += rz.getLocale().getString("mischungbearbeitenfenster.aenderung_adressen").replaceAll("%a", initialAdressListe.toVerboseString()).replaceAll("%n", mischung.getHeader().getAdressen().toVerboseString().trim());
    	}
    	if(!txtMischungBezeichnung.getText().trim().equals(initialBezeichnung.trim())) {
    		n += rz.getLocale().getString("mischungbearbeitenfenster.aenderung_bezeichnung").replaceAll("%a", initialBezeichnung).replaceAll("%n", txtMischungBezeichnung.getText().trim());
    	}
    	if(!txtBemerkungen.getText().trim().equals(initialBemerkungen.trim())) {
    		n += rz.getLocale().getString("mischungbearbeitenfenster.aenderung_bemerkungen").replaceAll("%a", initialBemerkungen).replaceAll("%n", txtBemerkungen.getText().trim());
    	}
    	if(!((SortenItem)cmbSorte.getSelectedItem()).getBezeichnung().trim().equals(initialSorte.trim())) {
    		n += rz.getLocale().getString("mischungbearbeitenfenster.aenderung_sorte").replaceAll("%a", initialSorte).replaceAll("%n", ((SortenItem)cmbSorte.getSelectedItem()).getBezeichnung().trim());
    	}
    	if(((LagerItem)cmbLager.getSelectedItem()).getID()  != initialLager) {
    		n += rz.getLocale().getString("mischungbearbeitenfenster.aenderung_lager").replaceAll("%a", initialLagerText).replaceAll("%n", ((LagerItem)cmbLager.getSelectedItem()).getName());
    	}
    	
    	if(!n.trim().equals("")) {
    		TicketListe liste = new TicketListe(rz);
    		TicketItem ti = new TicketItem(rz);
    		ti.setTyp(TicketItem.TYP_TEXT);
    		ti.setBezeichnung(rz.getLocale().getString("mischungbearbeitenfenster.daten_aenderung"));
    		ti.setBemerkungen(n);
    		ti.setMischung(mischung.getHeader().getId());
    		liste.add(ti);
    		if(!liste.isEmpty()) {
    			rz.getDatabase().getMischungen().saveTicketListeTransaktion(liste, rz.getLocale().getString("mischungbearbeitenfenster.daten_aenderung"), mischung.getHeader().getTank(), mischung.getHeader().getTank(), mischung.getHeader().getId(),mischung.getHeader().getId());
    			ret = true;
    		}
		}
    	return ret;
    }
    private void saveAction() {
    	if(mischung != null) {
    		if(!txtMischungBezeichnung.getText().trim().equals("")) {
    			toItem();
    			rz.getDatabase().getMischungen().updateMischungShort(mischung);
    			rz.getFensterFactory().getFensterListe().propagateBestand(this);
    		}else {
    			showUnvollstaendigDialog(rz.getLocale().getString("mischungbearbeitenfenster.dialog_bezeichnung"));
    		}
    	}
    }
    
    private void showAbschlussUnvollstaendigDialog(String text) {
    	DialogItem di  = new DialogItem(
                DialogControl.HINWEIS_DIALOG,
                "",0.0,
                rz.getLocale().getString("mischungbearbeitenfenster.dialog_abschluss_unvollstaendig"),
                rz.getLocale().getString("mischungbearbeitenfenster.dialog_abschluss_unvollstaendig"),
                text,
                "warnung.png",
                rz.getLocale().getString("string_ok"),
                "",
                this
        );
        rz.getDialogFactory().getDialog(di);
    }
    
    private void showUnvollstaendigDialog(String text) {
    	DialogItem di  = new DialogItem(
                DialogControl.HINWEIS_DIALOG,
                "",0.0,
                rz.getLocale().getString("mischungbearbeitenfenster.dialog_unvollstaendig"),
                rz.getLocale().getString("mischungbearbeitenfenster.dialog_unvollstaendig"),
                text,
                "warnung.png",
                rz.getLocale().getString("string_ok"),
                "",
                this
        );
        rz.getDialogFactory().getDialog(di);
    }
    
    private void validateUmpumpenTMenge(double value) {
    	double la = mischung.getLA();
    	if(value >la) {
    		value = la;
    	} 
    	txtUmpumpenTMenge.setValue(value);
    }
    
    
    private void editTicketAction() {
    	if(mischung != null) {
    		if(tblTickets.getSelectedRowCount() == 1) {
    			TicketItem ti = tickets.get(tblTickets.getSelectedRow());
    			if(ti != null) {
    				rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_TICKETEINGABE,false,new MessageItem(MessageItem.MSG_SHOW_TICKETEINGABE_EDIT, mischung.getHeader().getId(),ti,this));    				
    			}
    		}
    	}
    }
    
    private void ticketCheckAllAction() {
    	if(mischung != null) {
    		tblTickets.setRowSelectionInterval(0, mischung.getAllTickets().size()-1);
    	}
    }
    
    private void refreshAction(boolean first) {
	    if(mischung != null && mischung.getHeader() != null) {
	    	lblMischungNummer.setText(rz.getLocale().getString("mischungbearbeitenfenster.label_mischungsnummer").replaceAll("%s", String.valueOf(mischung.getHeader().getId())).replaceAll("%t", mischung.getHeader().getTank()));
	        ((AbstractTableModel)tblTransaktionen.getModel()).fireTableDataChanged();
	        if(mischung.getTransaktionen().size()>0) {
	        	tblTransaktionen.setRowSelectionInterval(mischung.getTransaktionen().size()-1,mischung.getTransaktionen().size()-1);
	        }
	        tickets = mischung.getAllTickets();
	        ((AbstractTableModel)tblTickets.getModel()).fireTableDataChanged();
	        tblTransaktionenValueChanged();
	        lblLa.setText(rz.getLocale().getString("mischungbearbeitenfenster.label_la").replaceAll("%l", rz.getLocale().formatNumber(mischung.getLA(), OptionFactory.NF_NORMAL)));
	        setInfo();
	   }
	   tblTransaktionen.requestFocus();
	   disableInactive();
	   if(!first) {
		   if(mischung !=null && mischung.getAllTickets().size()==0) {
			   final DialogItem di  = new DialogItem(
	                   DialogControl.FRAGE_DIALOG,
	                   "",0.0,
	                   rz.getLocale().getString("mischungbearbeitenfenster.question_mischung_delete"),
	                   rz.getLocale().getString("mischungbearbeitenfenster.question_mischung_delete"),
	                   rz.getLocale().getString("mischungbearbeitenfenster.question_mischung_delete_1")
	                   .replaceAll("%s", mischung.getHeader().getBezeichnung())
	                   .replaceAll("%t", mischung.getHeader().getTank())
	                   .replaceAll("%o", mischung.getHeader().getSorte().getBezeichnung()),
	                		
	                   "frage.png",
	                   rz.getLocale().getString("string_ja"),
	                   rz.getLocale().getString("string_nein"),
	                   this
					);
		        rz.getDialogFactory().getDialog(di);
		        if ((di.getReplyCode() == DialogControl.DIALOG_YES) || (di.getReplyCode() == DialogControl.DIALOG_OK)){
		        	if(rz.getDatabase().getMischungen().deleteMischungTransaction(mischung.getHeader().getId())) {
		        		
			        	closeWindow();
		        	} else {
		        		//mischung konnte nicht gelöscht werden
		        	}
		        }
		   }
	   }
   	}

    
    private void setInfo() {
    	MischungsFreigabeItem mfi = mischung.getFreigabeItem();
        tabAktionen.setIconAt(TAB_UMPUMPENV, freigegeben);tabAktionen.setEnabledAt(TAB_UMPUMPENV, true);tabUmpumpenV.setEnabled(true);
        tabAktionen.setIconAt(TAB_UMPUMPENT, freigegeben);tabAktionen.setEnabledAt(TAB_UMPUMPENT, true);tabUmpumpenT.setEnabled(true);
        tabAktionen.setIconAt(TAB_ZUSAMMENFASSEN, nicht_freigegeben);tabAktionen.setEnabledAt(TAB_ZUSAMMENFASSEN, false);tabZusammenfassen.setEnabled(false);
    	tabAktionen.setIconAt(TAB_ABSCHLUSSV, nicht_freigegeben);tabAktionen.setEnabledAt(TAB_ABSCHLUSSV, false);tabAbschlussV.setEnabled(false);
		tabAktionen.setIconAt(TAB_NULL, nicht_freigegeben);tabAktionen.setEnabledAt(TAB_NULL,false);tabNullAbschluss.setEnabled(false);
	        if(mfi.isFreigegeben() || mfi.isEntnahmeFreigegeben() ) {
	        	//Abschluss
	        	if(mfi.isFreigegeben()) {
		        	if(mischung != null && !rz.isZero(mischung.getLA())) {
			        	tabAktionen.setIconAt(TAB_ZUSAMMENFASSEN, freigegeben);tabAktionen.setEnabledAt(TAB_ZUSAMMENFASSEN, true);tabZusammenfassen.setEnabled(true);
			        	tabAktionen.setIconAt(TAB_ABSCHLUSSV, freigegeben);tabAktionen.setEnabledAt(TAB_ABSCHLUSSV, true);tabAbschlussV.setEnabled(true);
			    	    getAction(ACTION_ABSCHLUSS_V_OK_CODE).setEnabled(true);
			    	    getAction(ACTION_ZUSAMMENFASSEN_CODE).setEnabled(true);
			    		tabAktionen.setIconAt(TAB_ABSCHLUSST, freigegeben);tabAktionen.setEnabledAt(TAB_ABSCHLUSST,true);tabAbschlussT.setEnabled(true);
			    	    getAction(ACTION_ABSCHLUSS_T_OK_CODE).setEnabled(true);
			    		tabAktionen.setIconAt(TAB_NULL, nicht_freigegeben);tabAktionen.setEnabledAt(TAB_NULL,false);tabNullAbschluss.setEnabled(false);
			    	    tabAktionen.setTitleAt(TAB_ABSCHLUSST, rz.getLocale().getString("mischungbearbeitenfenster.tab_abschlusst"));
		        	} else {
		        	    tabAktionen.setTitleAt(TAB_ABSCHLUSST, rz.getLocale().getString("mischungbearbeitenfenster.tab_abschlusst1"));
			        	tabAktionen.setIconAt(TAB_ABSCHLUSSV, nicht_freigegeben);tabAktionen.setEnabledAt(TAB_ABSCHLUSSV,false);tabAbschlussV.setEnabled(false);
			    	    getAction(ACTION_ABSCHLUSS_V_OK_CODE).setEnabled(false);
			    		tabAktionen.setIconAt(TAB_ABSCHLUSST, nicht_freigegeben);tabAktionen.setEnabledAt(TAB_ABSCHLUSST,false);tabAbschlussT.setEnabled(false);
			    	    getAction(ACTION_ABSCHLUSS_T_OK_CODE).setEnabled(false);
			    		tabAktionen.setIconAt(TAB_NULL, freigegeben);tabAktionen.setEnabledAt(TAB_NULL,true);tabNullAbschluss.setEnabled(true);
		        	}
		       		lblStatusIcon.setIcon(freigegeben);
		       		lblStatus.setText(rz.getLocale().getString("mischungbearbeitenfenster.label_freigegeben"));
		       		lblStatusDetail.setText(" ");
	        	} else if(mfi.isEntnahmeFreigegeben()) {
	        	    tabAktionen.setTitleAt(TAB_ABSCHLUSST, rz.getLocale().getString("mischungbearbeitenfenster.tab_abschlusste"));
		    		tabAktionen.setIconAt(TAB_ABSCHLUSST, freigegeben);tabAktionen.setEnabledAt(TAB_ABSCHLUSST,true);tabAbschlussT.setEnabled(true);
		    	    getAction(ACTION_ABSCHLUSS_T_OK_CODE).setEnabled(true);
	        		lblStatusIcon.setIcon(nicht_freigegeben);
		        	lblStatus.setText(rz.getLocale().getString("mischungbearbeitenfenster.label_nicht_freigegeben_entnahme_erlaubt"));
		        	lblStatusDetail.setText(rz.getLocale().getString("mischungbearbeitenfenster.label_status_detail")
		        			.replaceAll("%1", String.valueOf(mfi.getSperren()))
		        			.replaceAll("%2", String.valueOf(mfi.getEntsperren()))
		        			.replaceAll("%3", String.valueOf(mfi.getFreigaben()))
		        			.replaceAll("%4", String.valueOf(mfi.getFreigaben_aufgehoben()))
		        			);	
	        	}
	        }else {
	        	//Abschluss
	            tabAktionen.setTitleAt(TAB_ABSCHLUSST, rz.getLocale().getString("mischungbearbeitenfenster.tab_abschlusst1"));
	        	tabAktionen.setIconAt(TAB_ZUSAMMENFASSEN,nicht_freigegeben);tabAktionen.setEnabledAt(TAB_ZUSAMMENFASSEN, false);tabZusammenfassen.setEnabled(false);
	        	tabAktionen.setIconAt(TAB_ABSCHLUSSV, nicht_freigegeben);tabAktionen.setEnabledAt(TAB_ABSCHLUSSV,false);tabAbschlussV.setEnabled(false);
	    	    getAction(ACTION_ABSCHLUSS_V_OK_CODE).setEnabled(false);
	    	    getAction(ACTION_ZUSAMMENFASSEN_CODE).setEnabled(false);
	    		tabAktionen.setIconAt(TAB_ABSCHLUSST, nicht_freigegeben);tabAktionen.setEnabledAt(TAB_ABSCHLUSST,false);tabAbschlussT.setEnabled(false);
	    	    getAction(ACTION_ABSCHLUSS_T_OK_CODE).setEnabled(false);
	    		tabAktionen.setIconAt(TAB_NULL, nicht_freigegeben);tabAktionen.setEnabledAt(TAB_NULL,false);tabNullAbschluss.setEnabled(false);
	    	    
	    	    
	        	lblStatusIcon.setIcon(nicht_freigegeben);
	        	lblStatus.setText(rz.getLocale().getString("mischungbearbeitenfenster.label_nicht_freigegeben"));
	        	lblStatusDetail.setText(rz.getLocale().getString("mischungbearbeitenfenster.label_status_detail")
	        			.replaceAll("%1", String.valueOf(mfi.getSperren()))
	        			.replaceAll("%2", String.valueOf(mfi.getEntsperren()))
	        			.replaceAll("%3", String.valueOf(mfi.getFreigaben()))
	        			.replaceAll("%4", String.valueOf(mfi.getFreigaben_aufgehoben()))
	        			);	
	        }
        	if(rz.isZero(mischung.getHeader().getLa())){
	    		tabAktionen.setIconAt(TAB_NULL, freigegeben);tabAktionen.setEnabledAt(TAB_NULL,true);tabNullAbschluss.setEnabled(true);
        	}
    }

    private void addTransaktion() {
    	if(mischung != null) {
		   rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_TICKETEINGABE,false,new MessageItem(MessageItem.MSG_SHOW_TICKETEINGABE, 0,mischung,this));
    	}
    }
    
    private void deleteTransaktion() {
    	if(mischung != null) {
    		if(tblTransaktionen.getSelectedRow() != -1) {
    			TransaktionsItem tri = mischung.getTransaktionen().get(tblTransaktionen.getSelectedRow());
    			if(tri != null) {
    				 final DialogItem di  = new DialogItem(
    		                    DialogControl.FRAGE_DIALOG,
    		                    "",0.0,
    		                    rz.getLocale().getString("mischungbearbeitenfenster.question_abfrage_delete"),
    		                    rz.getLocale().getString("mischungbearbeitenfenster.question_abfrage_delete"),
    		                    rz.getLocale().getString("mischungbearbeitenfenster.question_abfrage_delete_1").replaceAll("%a",tri.getBemerkungen()).replaceAll("%l", tri.getTickets().toHTMLString()),
    		                    "frage.png",
    		                    rz.getLocale().getString("string_ja"),
    		                    rz.getLocale().getString("string_nein"),
    		                    this
    						);
    		         rz.getDialogFactory().getDialog(di);
    		         if ((di.getReplyCode() == DialogControl.DIALOG_YES) || (di.getReplyCode() == DialogControl.DIALOG_OK)){
    		        	 if(rz.getDatabase().getMischungen().deleteTransaktion(mischung.getHeader().getId(),tri)) {
    	    	            	mischung = new MischungsItem(rz,mischung.getHeader().getId());
    	    	        		refreshAction(false);
    	    	        		rz.getFensterFactory().getFensterListe().propagateBestand(this,mischung.getHeader().getRezeptur_id());
								rz.getFensterFactory().getFensterListe().propagateMischung(this, mischung.getHeader().getId());
    	    				}
    		         }
    			}
    		}
    	}
    }
    
   	private void hideAction(){
   		rz.getFensterFactory().getFensterListe().sperren(this);
   	}
   
   	
   	private void tblTransaktionenValueChanged() {
   		
   		if(refreshTickets == false) {
	   		if(tblTransaktionen.getSelectedRow() != -1) {
	   			TransaktionsItem tri = mischung.getTransaktionen().get(tblTransaktionen.getSelectedRow());
	   			if(rz.getDatabase().getMischungen().isTransaktionDeleteable(mischung.getHeader().getId(),tri)) {
	   				getAction(ACTION_TICKET_DELETE_CODE).setEnabled(true);
	   			}else {
	   				getAction(ACTION_TICKET_DELETE_CODE).setEnabled(false);	
	   			}
	   			transaktionsAusgabe(tri);
	   			if(tri != null && tickets != null) {
	   				tblTickets.clearSelection();  
	   				for(int i = 0;i< tickets.size();i++) {
	   					if(tri.getId() == tickets.get(i).getTransaktion()) {
	   						tblTickets.addRowSelectionInterval(i, i);
	   					}
	   				}
	   			}
	   		}else {
	   			
	   		}
   		}
   		refreshAusgabe();
   	}
   	
   	private void transaktionsAusgabe(TransaktionsItem tri) {
			if(tri != null){
				String srcTank = tri.getTank();
				String destTank = tri.getTank_dest();
				if(mischung != null) {
					if(mischung.getHeader().getTank().equals(srcTank))srcTank = "<b>"+srcTank+"</b>";
					if(mischung.getHeader().getTank().equals(destTank))destTank = "<b>"+destTank+"</b>";
				}
				txtTransaktionsAusgabe.setText(rz.getLocale().getString("mischungbearbeitenfenster.label_transaktion_ausgabe")
	   					.replaceAll("%s", tri.getBemerkungen())
	   					.replaceAll("%0",(tri.getMischung_source() != mischung.getHeader().getId())?"<a href=\"mi:" + String.valueOf(tri.getMischung_source())+"\">" + String.valueOf(tri.getMischung_source())+"</a>":String.valueOf(tri.getMischung_source()))
	   					.replaceAll("%1", srcTank)
	   					.replaceAll("%2", (tri.getMischung_dest() != mischung.getHeader().getId())?"<a href=\"mi:" + String.valueOf(tri.getMischung_dest())+"\">" + String.valueOf(tri.getMischung_dest())+"</a>":String.valueOf(tri.getMischung_dest()))
	   					.replaceAll("%3", destTank)
	   					);
			}
   	}
   	
   	private void tblTicketsValueChanged() {
   		refreshTickets = true;
   		if(tickets != null) {
	   		if(tblTickets.getSelectedRow() != -1) {
	   			TicketItem ti = tickets.get(tblTickets.getSelectedRow());
	   			if(ti != null) {
	   				tblTransaktionen.clearSelection();
	   				for(int i=0;i<mischung.getTransaktionen().size();i++) {
	   					if(mischung.getTransaktionen().get(i).getId() == ti.getTransaktion()) {
	   						tblTransaktionen.setRowSelectionInterval(i, i);
	   			   			TransaktionsItem tri = mischung.getTransaktionen().get(tblTransaktionen.getSelectedRow());
	   			   			if(tri != null) {
	   				   			transaktionsAusgabe(tri);
		   						if(rz.getDatabase().getMischungen().isTransaktionDeleteable(mischung.getHeader().getId(),tri)) {
		   			   				getAction(ACTION_TICKET_DELETE_CODE).setEnabled(true);
		   			   			}else {
		   			   				getAction(ACTION_TICKET_DELETE_CODE).setEnabled(false);	
		   			   			}
	   			   			}
	   						break;
	   					}
	   				}
	   			}
	   		}
   		}
   		if(mischung != null && !mischung.getHeader().isActive()) {
   			getAction(ACTION_TICKET_EDIT_CODE).setEnabled(false);
   		} else {
	   		if(tblTickets.getSelectedRowCount() == 1 ) {
	   			TicketItem ti = tickets.get(tblTickets.getSelectedRow());
	   			getAction(ACTION_TICKET_EDIT_CODE).setEnabled(true);
	   			if(ti != null) {
	   				if(ti.getTyp() == TicketItem.TYP_ENTNAHME) {
	   		   			getAction(ACTION_TICKET_EDIT_CODE).setEnabled(false);
	   				} 
	   			}
	   		}else {
	   			getAction(ACTION_TICKET_EDIT_CODE).setEnabled(false);
	   		}
   		}
   		refreshTickets = false;
   		refreshAusgabe();
   	}
   	
    /**
     * ergebnisTimerEvent zeigt an, dass eine Notiz/Rezeptur dargestellt werden
     * muss,
     */
    private void ergebnisTimerEvent(){
    	ergebnisTimer.stop();
    	refreshAusgabe2();
    }
    private void restartTimer() {
        if(ergebnisTimer.isRunning()) {
			ergebnisTimer.restart();
		} else {
			ergebnisTimer.start();
		}
    }
    
    private void refreshAusgabe() {
    	restartTimer();
    }
   	private void refreshAusgabe2() {
   		rz.setWaitCursor(this);
   		if(tickets != null && tickets.size() > 0) {
	   		TicketListe tl = new TicketListe(rz);
	   		for(int i=0,j=0;i < tickets.size();i++) {
	   			if(tblTickets.isRowSelected(i)) {
	   				int alle = rz.getOptionFactory().getOption("mischungbearbeitenfenster.alle_tickets_anzeigen", 0);
	   				if( (alle == 1) || (alle == 0 && j == 0) ) {
		   				tl.add(tickets.get(i).clones());
	   				}
	   				j++;
	   			}
	   		}
	        if(tblTickets.getSelectedRow()!=-1) {
	        	tblTickets.scrollRectToVisible(tblTickets.getCellRect(tblTickets.getSelectedRow(),0,true));
	        }
	   		rz.getAusgabeFactory().ticketAusgabe(txtDetail,mischung.getHeader().getId(),tl,chkMischungen.isSelected());
	   		double summe = tl.getSumme();
	   		lblTicketSumme.setText(rz.isZero(summe)?"":rz.getLocale().getString("mischungbearbeitenfenster.ticketsumme").replaceAll("%s", rz.getLocale().formatNumber(summe, OptionFactory.NF_NORMAL)));
   		}
   		rz.setFreeCursor(this);
   	}
   	/*
   	 * Ticket- Tablemodel
   	 */
    private void settblTicketsModel(JTable t) {
 	    final ticketsColumnModel rcm = new ticketsColumnModel();
 	    final StringRendererTickets sr = new StringRendererTickets();
 	    TableColumn tc = new TableColumn();
 	    	tc.setHeaderValue(rz.getLocale().getString("mischungbearbeitenfenster.tableheader_ti_typ"));
 	    	tc.setModelIndex(TI_TYP);
 	    	tc.setCellRenderer(sr);
 	    rcm.addColumn(tc);
 	    tc = new TableColumn();
		  	tc.setHeaderValue(rz.getLocale().getString("mischungbearbeitenfenster.tableheader_ti_nummer"));
			tc.setModelIndex(TI_NUMMER);
			tc.setCellRenderer(sr);
			rcm.addColumn(tc);
 	    tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("mischungbearbeitenfenster.tableheader_ti_transaktion"));
	    	tc.setModelIndex(TI_TRANSAKTION);
	    	tc.setCellRenderer(sr);
	    rcm.addColumn(tc);
 	    tc = new TableColumn();
 	    	tc.setHeaderValue(rz.getLocale().getString("mischungbearbeitenfenster.tableheader_ti_bezeichnung"));
 	    	tc.setModelIndex(TI_BEZEICHNUNG);
 	    	tc.setCellRenderer(sr);
 	    rcm.addColumn(tc);
 	    tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("mischungbearbeitenfenster.tableheader_ti_la"));
	    	tc.setModelIndex(TI_LA);
	    	tc.setCellRenderer(sr);
	    rcm.addColumn(tc);
 	    tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("mischungbearbeitenfenster.tableheader_ti_percentage"));
	    	tc.setModelIndex(TI_PERCENTAGE);
	    	tc.setCellRenderer(sr);
	    rcm.addColumn(tc);
 	    tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("mischungbearbeitenfenster.tableheader_ti_staerke"));
	    	tc.setModelIndex(TI_STAERKE);
	    	tc.setCellRenderer(sr);
	    rcm.addColumn(tc);
 	    tc = new TableColumn();
 	    	tc.setHeaderValue(rz.getLocale().getString("mischungbearbeitenfenster.tableheader_ti_user"));
 	    	tc.setModelIndex(TI_USER);
 	    	tc.setCellRenderer(sr);
 	    rcm.addColumn(tc);
        rcm.addColumnModelListener(this);
        tblTickets.setModel(new ticketsTableModel());
        tblTickets.setColumnModel(rcm);
        tblTickets.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
        tblTickets.getTableHeader().setReorderingAllowed(false);
        tblTickets.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
        tblTickets.setShowGrid(true);
        tblTickets.setGridColor(Color.BLACK);
 	}
   	
	private class ticketsColumnModel extends DefaultTableColumnModel{
	    public ticketsColumnModel() {
	        super();
	    }

	}

	private  class ticketsTableModel extends AbstractTableModel    {
			
			SimpleDateFormat df;	
	        
			public ticketsTableModel() {
	        	df = new SimpleDateFormat("dd.MM.yyyy H:mm");
	        }

		   public int getColumnCount() {
		       	return MAX_TRANSAKTIONS_COLUMN;
	        }
	        public int getRowCount() {
	        	if(tickets != null) {
	        		return tickets.size();
	        	} else {
	        		return 0;
	        	}
	        }

	        public TicketItem getZeileAt(int rowIndex) {
	        	if(tickets != null) {
	        		return tickets.get(rowIndex);
	        	} else {
	        		return null;
	        	}
	        }

	        public Object getValueAt(int rowIndex, int columnIndex) {
	            Object ret = null;
	            if(tickets != null) {
	                ret = getContent(tickets.get(rowIndex),columnIndex,rowIndex);
	            }
	            return ret;
	        }

	        private Object getContent(TicketItem ti,int aColumn,int row) {
	            Object ret = null;
	            if(ti != null) {
		            switch(aColumn){
		            	case TI_NUMMER:
		            		 ret = ti.getNummer();
		            		 break;
		            	case TI_BEZEICHNUNG:
		            		 ret = ti.getBezeichnung();
		            	     break;
		            	case TI_TRANSAKTION:
		            		 ret = String.valueOf(ti.getTransaktion());
		            		 break;
		            	case TI_USER:
		            		 ret = ti.getGeaendert_user();
		            		 break;
		            	case TI_TYP:
		            		 break;
		            	case TI_LA:
		            		 if(ti.getTyp() == TicketItem.TYP_WARE || ti.getTyp() == TicketItem.TYP_ENTNAHME || ti.getTyp() == TicketItem.TYP_UMPUMPEN) {
		            			 ret = rz.getLocale().formatNumber(ti.getLa(), OptionFactory.NF_NORMAL);
		            		 } else {
		            			 ret = "";
		            		 }
		            		 break;
		            	case TI_PERCENTAGE:
		            		 if(ti.getTyp() == TicketItem.TYP_WARE) {
		            			 ret = rz.getLocale().formatNumber(ti.getPercentage(), OptionFactory.NF_TWO);
		            		 } else if(ti.getTyp() == TicketItem.TYP_ENTNAHME) {
		            			 ret = rz.getLocale().formatNumber(ti.getNegativePercentage(), OptionFactory.NF_TWO);
		            		 } else {
		            			 ret = "";
		            		 }

		            		 break;
		            	case TI_STAERKE:
		            		 if(ti.getTyp() == TicketItem.TYP_WARE || ti.getTyp() == TicketItem.TYP_ENTNAHME || ti.getTyp() == TicketItem.TYP_UMPUMPEN) {
		            			 ret = rz.getLocale().formatNumber(ti.getStaerke(), OptionFactory.NF_NORMAL);
		            		 } else {
		            			 ret = "";
		            		 }
		            		 break;
		            		 
		            }
	            }
	            return ret;
	        }
		}
   	
	private class StringRendererTickets extends DefaultTableCellRenderer {

		Icon ware,freigabe,sperren,entsperren,text,freigabe_aufheben,abschluss,entnahme,umpumpen,zusammenfassen,sperren_entsperrt;
		
	    StringRendererTickets() {
	        super();
	        setOpaque(true);
            ware = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/mischungbearbeitenfenster.typ_ware.png"));
            freigabe = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/mischungbearbeitenfenster.typ_freigabe.png"));
            sperren = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/mischungbearbeitenfenster.typ_sperren.png"));
            entsperren = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/mischungbearbeitenfenster.typ_entsperren.png"));
            sperren_entsperrt = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/mischungbearbeitenfenster.typ_sperren_entsperrt.png"));
            text = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/mischungbearbeitenfenster.typ_text.png"));
            freigabe_aufheben = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/mischungbearbeitenfenster.typ_freigabe_aufheben.png"));
            abschluss = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/mischungbearbeitenfenster.typ_abschluss.png"));
            entnahme = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/mischungbearbeitenfenster.typ_entnahme.png"));
            umpumpen = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/mischungbearbeitenfenster.typ_umpumpen.png"));	
            zusammenfassen = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/mischungbearbeitenfenster.typ_zusammenfassung.png"));
	    }
	    public Component getTableCellRendererComponent(JTable table,
                Object value, boolean isSelected, boolean hasFocus, int row,
                int column)
	    {
	    	setIcon(null);
	    	if(isSelected) {
    			setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_SELECTED));
    	    	setFont(rz.getFontFactory().getTableBoldFont());
    		}else {
    			setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_NORMAL));
    	    	setFont(rz.getFontFactory().getTableFont());
    		}
	    	if(column == TI_TYP) {
		    	if(tickets != null) {
			    	TicketItem ti = tickets.get(row);
			    	if(ti != null) {
			    		switch(ti.getTyp()) {
			    			case TicketItem.TYP_WARE: setIcon(ware);break;
			    			case TicketItem.TYP_FREIGABE: setIcon(freigabe);break;
			    			case TicketItem.TYP_GESPERRT: 
			    				if(ti.isEntsperrt()) {
				    				setIcon(sperren_entsperrt);
				    			} else {
				    				setIcon(sperren);
				    			}
				    			break;
			    			case TicketItem.TYP_ENTSPERRT: setIcon(entsperren);break;
			    			case TicketItem.TYP_TEXT: setIcon(text);break;
			    			case TicketItem.TYP_FREIGABE_AUFHEBEN: setIcon(freigabe_aufheben);break;
			    			case TicketItem.TYP_ABSCHLUSS: setIcon(abschluss);break;
			    			case TicketItem.TYP_ENTNAHME: setIcon(entnahme);break;
			    			case TicketItem.TYP_UMPUMPEN: setIcon(umpumpen);break;
			    			case TicketItem.TYP_ZUSAMMENFASSUNG: setIcon(zusammenfassen);break;
			    		}
			    	}
		    	}
	    	}
    		setText((String)value);
	        return this;
        }
	}
   	
   /*
    * 
    * (Transaktion -Tablemodel)
    * 
    */

    
    private void settblTransaktionenModel(JTable t) {
 	    final transaktionenColumnModel rcm = new transaktionenColumnModel();
 	    final StringRenderer sr = new StringRenderer();
 	    TableColumn tc = new TableColumn();
 	    	tc.setHeaderValue(rz.getLocale().getString("mischungbearbeitenfenster.tableheader_t_datum"));
 	    	tc.setModelIndex(T_DATUM);
 	    	tc.setCellRenderer(sr);
 	    rcm.addColumn(tc);
 	    tc = new TableColumn();
 	    	tc.setHeaderValue(rz.getLocale().getString("mischungbearbeitenfenster.tableheader_t_bezeichnung"));
 	    	tc.setModelIndex(T_BEZEICHNUNG);
 	    	tc.setCellRenderer(sr);
 	    rcm.addColumn(tc);
 	    tc = new TableColumn();
 	    	tc.setHeaderValue(rz.getLocale().getString("mischungbearbeitenfenster.tableheader_t_user"));
 	    	tc.setModelIndex(T_USER);
 	    	tc.setCellRenderer(sr);
 	    rcm.addColumn(tc);
        rcm.addColumnModelListener(this);
        tblTransaktionen.setModel(new transaktionenTableModel());
        tblTransaktionen.setColumnModel(rcm);
        tblTransaktionen.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
        tblTransaktionen.getTableHeader().setReorderingAllowed(false);
        tblTransaktionen.setShowGrid(true);
        tblTransaktionen.setGridColor(Color.BLACK);
 	}
   	
	private class transaktionenColumnModel extends DefaultTableColumnModel{
	    public transaktionenColumnModel() {
	        super();
	    }

	}

	private  class transaktionenTableModel extends AbstractTableModel    {

			SimpleDateFormat df;
			
	        public transaktionenTableModel() {
	        	df = new SimpleDateFormat("dd.MM.yyyy H:mm");
	        }

		   public int getColumnCount() {
		       	return MAX_TRANSAKTIONS_COLUMN;
	        }
	        public int getRowCount() {
	        	if(mischung != null && mischung.getTransaktionen().size() >0) {
	                return mischung.getTransaktionen().size();
	        	} else {
	        		return 0;
	        	}
	        }

	        public TransaktionsItem getZeileAt(int rowIndex) {
	        	if((rowIndex != -1) && (mischung != null && mischung.getTransaktionen().size() >0)) {
	        		return mischung.getTransaktionen().get(rowIndex);
	        	} else {
					return null;
				}
	        }

	        public Object getValueAt(int rowIndex, int columnIndex) {
	            Object ret = null;
	            if((rowIndex != -1) && (mischung != null && mischung.getTransaktionen().size() > 0)) {
	                ret = getContent(mischung.getTransaktionen().get(rowIndex),columnIndex,rowIndex);
	            }
	            return ret;
	        }

	        private Object getContent(TransaktionsItem tri,int aColumn,int row) {
	            Object ret = null;
	            if(tri != null) {
		            switch(aColumn){
		            	 case T_BEZEICHNUNG:
		            	     ret = tri.getBemerkungen();
		            	     break;
		            	 case T_DATUM:
		            		 ret = df.format(tri.getErstellt());
		            		 break;
		            	 case T_USER:
		            		 ret = tri.getUser();
		            		 break;
		            }
	            }
	            return ret;
	        }
		}
   	
   	
	private class StringRenderer extends DefaultTableCellRenderer {

		Icon zugang,abgang;
		
	    StringRenderer() {
	        super();
	        setOpaque(true);
            zugang = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/mischungbearbeitenfenster.icon_umpumpen_zugang.png"));
            abgang = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/mischungbearbeitenfenster.icon_umpumpen_abgang.png"));
	    }
	    public Component getTableCellRendererComponent(JTable table,
                Object value, boolean isSelected, boolean hasFocus, int row,
                int column)
	    {
	    	setIcon(null);
	    	if(isSelected) {
    			setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_SELECTED));
    	    	setFont(rz.getFontFactory().getTableBoldFont());
    		}else {
    			setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_NORMAL));
    	    	setFont(rz.getFontFactory().getTableFont());
    		}
    		setText((String)value);
    		if(column == T_BEZEICHNUNG) {
	    		TransaktionsItem tri = mischung.getTransaktionen().get(row);
	    		if(tri != null) {
	    			if(!tri.getTank().equals(tri.getTank_dest())) {
	    				if(tri.getTank().equals(mischung.getHeader().getTank())) {
	    					setIcon(abgang);
	    				}else {
	    					setIcon(zugang);
	    				}
	    			}
	    		}
    		}
	        return this;
        }
	}
   	
   	
   	
   	
   	
	public void columnAdded(TableColumnModelEvent arg0) {
	}


	public void columnMarginChanged(ChangeEvent arg0) {
	}


	public void columnMoved(TableColumnModelEvent arg0) {
	}


	public void columnRemoved(TableColumnModelEvent arg0) {
	}


	public void columnSelectionChanged(ListSelectionEvent arg0) {
	}

	public class ColumnHeaderListener extends MouseAdapter {
	    public void mouseClicked(MouseEvent evt) {
	        JTable table = ((JTableHeader)evt.getSource()).getTable();
	        TableColumnModel colModel = table.getColumnModel();

	        int vColIndex = colModel.getColumnIndexAtX(evt.getX());
	        // Return if not clicked on any column header
	        if (vColIndex == -1) {
	            return;
	        }
	        // Determine if mouse was clicked between column heads
	        Rectangle headerRect = table.getTableHeader().getHeaderRect(vColIndex);
	        if (vColIndex == 0) {
	            headerRect.width -= 3;    // Hard-coded constant
	        } else {
	            headerRect.grow(-3, 0);   // Hard-coded constant
	        }
	        if (!headerRect.contains(evt.getX(), evt.getY())) {
	            // Mouse was clicked between column heads
	            // vColIndex is the column head closest to the click

	            // vLeftColIndex is the column head to the left of the click
	            if (evt.getX() < headerRect.x) {
	                vColIndex--;
	            }
	        }
	        int[]  sel = tblTickets.getSelectedRows();
	        int[] selected = sel.clone();
	        for(int i = 0;i<sel.length;i++) {
	        	selected[i] = tickets.get(sel[i]).getId();
	        }
	        if(tickets != null && tickets.size()>0) {
		        switch(vColIndex) {
		        	case TI_NUMMER:
		            		tickets.sortNummer();
		            		break;
		        	case TI_TRANSAKTION:
		        			tickets.sortAktion();
		        			break;
		        	case TI_TYP:
		        			tickets.sortTyp();
		        			break;
		        	case TI_BEZEICHNUNG:
		        			tickets.sortBezeichnung();
		        			break;
		        	case TI_LA:
		        			tickets.sortLA();
		        			break;
		        	case TI_PERCENTAGE:
		        			tickets.sortAnteil();
		        			break;
		        	case TI_USER:
		        			tickets.sortUser();
		        			break;
		        	case TI_STAERKE:
		        			tickets.sortStaerke();
		        			break;
		        }
                ((AbstractTableModel)tblTickets.getModel()).fireTableDataChanged();
		        if(selected.length > 0 ) {
		        	for(int i=0;i<tickets.size();i++) {
		        		for(int n:selected) {
			        		if(tickets.get(i).getId() == n) {
			        			tblTickets.getSelectionModel().addSelectionInterval(i,i);
			        			break;
			        		}
		        		}
		        	}
		        }
	        }
		}
	}
}


