	package de.lunqual.rzpro.fenster.mischungsfenster;
	import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Graphics2D;
	import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.InputEvent;
	import java.awt.event.KeyEvent;
	import java.awt.print.PageFormat;
	import java.awt.print.Printable;
	import java.awt.print.PrinterException;
	import java.awt.print.PrinterJob;

	import javax.swing.BorderFactory;
	import javax.swing.JButton;
	import javax.swing.JLabel;
	import javax.swing.JMenu;
	import javax.swing.JMenuBar;
	import javax.swing.JPanel;
	import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JToolBar;
	import javax.swing.SwingConstants;

	import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.fenster.JNumberField;
import de.lunqual.rzpro.fenster.JRzFrame;
	import de.lunqual.rzpro.fensterfactory.FensterFactory;
	import de.lunqual.rzpro.items.action.AuswahlAction;
	import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.mischungen.MischungsItem;
	import de.lunqual.rzpro.log.LogFactory;
import de.lunqual.rzpro.options.OptionFactory;
	/**
	 *
	 * @author  lunqual
	 */
	public class MischungChartFenster extends JRzFrame implements Printable{

	    //GUI-Variablen
	    private JToolBar tb1;
	    private JMenuBar mb;
	    private JMenu mnuDatei;
	    private JMenu mnuExtras;
	    private JMenu mnuHilfe;
	      private  JPanel contentPanel;
	      	private JPanel tbPanel;
	      	private JPanel centerPanel;
		      	private JPanel chartLimitPanel;
					private JSpinner spChartList;
					private JLabel lblChartList;
					private JNumberField txtLimit;
					private JLabel lblLimit;
					private JButton btLimit;
	      		private JLabel lblTitel;
	      		private JScrollPane scrListe;
	      			private MischungChartPanel chartPanel;
	  		private JPanel buttonPanel;
	  	    	private JButton btClose;
	  	    	private JPanel rightPanel;
	  	    		private JButton btDrucken;
	  	    		private JButton btHilfe;

	    public static final int         		ACTION_CLOSE_CODE = 1001;
	    public static final String     		ACTION_CLOSE_TEXT = "mischungChartFenster.action_close";
	    public static final int         		ACTION_HILFE_CODE = 1003;
	    public static final String     		ACTION_HILFE_TEXT = "action_hilfe";
	    public static final int         		ACTION_HIDE_CODE = 1004;
	    public static final String    		ACTION_HIDE_TEXT = "action_hide";
	    public static final int         		ACTION_DRUCKEN_CODE = 1005;
	    public static final String    		ACTION_DRUCKEN_TEXT = "mischungChartFenster.action_drucken";

	    
	    MischungsItem mischung = null;
	    /** Creates new form AdressenFenster */
	    public MischungChartFenster(RzPro r, String name, Object extendedData) {
	        super(r,name,extendedData);
	        createActions();
	        createGUIComponents();
	        setGUIComponents();
	        getMessage((MessageItem)extendedData);
	    }

	    @Override
		public void createGUIComponents() {
	    	// Menü
	    	mb = new JMenuBar();
	    	mnuDatei = new JMenu();
	    	mnuExtras = new JMenu();
	    	mnuHilfe = new JMenu();
	    	mb.add(mnuDatei);
	    	mb.add(mnuExtras);
	    	mb.add(mnuHilfe);
	    	setJMenuBar(mb);
			//Toolbar
			tb1 = new JToolBar();
			tb1.setFloatable(false);
			tb1.setRollover(true);
			//ToolbarPanel
			//contentPanel
			contentPanel = new JPanel(new BorderLayout());
				tbPanel = new JPanel(new BorderLayout());
					tbPanel.add(tb1,BorderLayout.NORTH);
			contentPanel.add(tbPanel,BorderLayout.NORTH);
				centerPanel = new JPanel(new BorderLayout());
					lblTitel = new JLabel();
						lblTitel.setHorizontalAlignment(SwingConstants.CENTER);
						lblTitel.setBorder(BorderFactory.createEtchedBorder());
					centerPanel.add(lblTitel,BorderLayout.NORTH);
					scrListe = new JScrollPane();
						chartPanel = new MischungChartPanel(rz,rz.getOptionFactory().getOption("mischung.chart.list",OptionFactory.MISCHUNG_CHART_LIST));
						chartPanel.setBackground(Color.white);
						scrListe.setViewportView(chartPanel);
						scrListe.setBorder(BorderFactory.createEtchedBorder());
					centerPanel.add(scrListe,BorderLayout.CENTER);
					chartLimitPanel = new JPanel(new GridLayout(1,6));
					chartLimitPanel.setBorder(BorderFactory.createEtchedBorder());
					
					btDrucken = new JButton();
					chartLimitPanel.add(btDrucken);
					spChartList = new JSpinner();
						spChartList.setValue(rz.getOptionFactory().getOption("mischung.chart.list",OptionFactory.MISCHUNG_CHART_LIST));
	    	           spChartList.addChangeListener(new javax.swing.event.ChangeListener() {
	    	               public void stateChanged(javax.swing.event.ChangeEvent evt) {
	    	                	spinnerChanged();
	    	            	}
	    	           });
	    	           chartLimitPanel.add(spChartList);
	    	           lblChartList = new JLabel();
	    	           		lblChartList.setHorizontalAlignment(SwingConstants.LEADING);
	    	           chartLimitPanel.add(lblChartList);

					txtLimit = new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_ONE), 5.0, 0.0, 99);
					txtLimit.setValue(rz.getOptionFactory().getDouble("mischungChart.limit", 5.0));
					txtLimit.addKeyListener(new java.awt.event.KeyAdapter() {
 			            @Override
						public void keyReleased(java.awt.event.KeyEvent evt) {
 			            	if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
 			            		rz.getOptionFactory().setDouble("mischungChart.limit", txtLimit.getValue());
 			            		rz.getOptionFactory().saveOptions();
 			            		refreshAction();
 			            	}
 			            }
 			        });
					chartLimitPanel.add(txtLimit,BorderLayout.WEST);
					lblLimit = new JLabel();
						lblLimit.setHorizontalAlignment(SwingConstants.LEADING);
						chartLimitPanel.add(lblLimit,BorderLayout.CENTER);
						btLimit = new JButton();
						btLimit.addActionListener(new ActionListener() {
				        	public void actionPerformed(ActionEvent evt) {
				        		refreshAction();
				        	}
			    	    });
					   chartLimitPanel.add(btLimit);

					centerPanel.add(chartLimitPanel,BorderLayout.SOUTH);
					
					contentPanel.add(centerPanel,BorderLayout.CENTER);
				 buttonPanel=new JPanel(new BorderLayout());
					btClose = new JButton();
						buttonPanel.add(btClose,BorderLayout.WEST);
					rightPanel=new JPanel(new GridLayout(1,5));

						btHilfe = new JButton();
						rightPanel.add(btHilfe,BorderLayout.EAST);
				buttonPanel.add(rightPanel,BorderLayout.EAST);
			contentPanel.add(buttonPanel,BorderLayout.SOUTH);

			addComponentListener(new ComponentListener() {
			    public void componentResized(ComponentEvent componentEvent) {
			    	if(chartPanel != null && mischung != null) {
			    		refreshAction();
					}
			    }

				@Override
				public void componentMoved(ComponentEvent e) {
					
				}

				@Override
				public void componentShown(ComponentEvent e) {
					
				}

				@Override
				public void componentHidden(ComponentEvent e) {
					
				}
			});
			//Panels ans Fenster hängen;
			this.getContentPane().setLayout(new BorderLayout());

			this.getContentPane().add(contentPanel, BorderLayout.CENTER);
	    }


	    @Override
		public void setGUIComponents() {
	        setTitle(rz.getVersionString() + " " + rz.getLocale().getString("MischungChatFenster.titel"));

			mnuDatei.setText(rz.getLocale().getString("menu.datei"));
			mnuExtras.setText(rz.getLocale().getString("menu.extras"));
			mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));

			mnuDatei.addSeparator();
			mnuDatei.add(getAction(ACTION_DRUCKEN_CODE));
			mnuDatei.addSeparator();
	        mnuDatei.add(getAction(ACTION_CLOSE_CODE));

	        mnuExtras.add(getAction(ACTION_HIDE_CODE));
	        mnuHilfe.add(getAction(ACTION_HILFE_CODE));

			tb1.add(getAction(ACTION_CLOSE_CODE));
			tb1.addSeparator();
			tb1.add(getAction(ACTION_HIDE_CODE));
			tb1.addSeparator();
			tb1.add(getAction(ACTION_HILFE_CODE));
			tb1.addSeparator();
			tb1.add(getAction(ACTION_DRUCKEN_CODE));

			btHilfe.setAction(getAction(ACTION_HILFE_CODE));
			btClose.setAction(getAction(ACTION_CLOSE_CODE));
			btDrucken.setAction(getAction(ACTION_DRUCKEN_CODE));
			
	  	  	lblLimit.setText(rz.getLocale().getString("mischungChartPanel.label_limit"));
	  	  	btLimit.setText(rz.getLocale().getString("mischungChartPanel.action_limit"));
	  	  	lblChartList.setText(rz.getLocale().getString("mischungslistenfenster.label_chart_list"));
			
			setResizable(true);
	        rz.getFontFactory().setFrameFonts(this);
	        pack();
	        rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;
	    }

	    @Override
		public void getMessage(MessageItem msg) {
	        switch(msg.getMsgCode()) {
	    	case MessageItem.MSG_ACTIONPERFORMED:
	            switch(msg.getCode()){
			          case ACTION_HILFE_CODE: hilfeAction();break;
			          case ACTION_HIDE_CODE:hideAction();break;
			          case ACTION_CLOSE_CODE:closeWindow();break;
			          case ACTION_DRUCKEN_CODE:
			        	  druckenAction();
			        	  refreshAction();
			        	  break;
			          default :
			              break;
	           }
	    		break;
	         case MessageItem.MSG_SHOW_MISCHUNG_CHART:
	        	mischung = (MischungsItem)msg.getData();
	 	         break;
	        default:
	            break;
	        }

	    }

	    private void spinnerChanged() {
	    	int value = (int)spChartList.getValue();
	    	if(value < 1) {
	    		spChartList.setValue(1);
	    	}
	    	if(value > rz.getOptionFactory().getOption("mischung.chart.max.list",OptionFactory.MISCHUNG_CHART_MAX_LIST)-1) {
	    		spChartList.setValue(rz.getOptionFactory().getOption("mischung.chart.max.list",OptionFactory.MISCHUNG_CHART_MAX_LIST)-1);
	    	}
	    	if(chartPanel != null) {
	    		chartPanel.setListCountMax((int)spChartList.getValue());
	    		refreshAction();
	    		rz.getOptionFactory().setOption("mischung.chart.list",(int)spChartList.getValue());
	    		rz.getOptionFactory().saveOptions();
	    	}

	    }
	
	    
	    private void refreshAction() {
	    	if(mischung !=null) {
	    		lblTitel.setText(rz.getLocale().getString("mischungChartFenster.label_titel").replaceAll("%n",String.valueOf(mischung.getHeader().getId())).replaceAll("%m", mischung.getHeader().getBezeichnung()));
	    		if(chartPanel != null && mischung != null) {
		    		chartPanel.setData(mischung,txtLimit.getValue());
		    		chartPanel.repaint();
		    	}
	    	}
	    }
	    
	   
	    @Override
		public void createActions(){
	        actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT, KeyEvent.VK_F5 ,InputEvent.SHIFT_DOWN_MASK));
	        actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT, KeyEvent.VK_F1,0));
	        actionList.put(String.valueOf(ACTION_CLOSE_CODE),new AuswahlAction(rz,this,ACTION_CLOSE_CODE,ACTION_CLOSE_TEXT, KeyEvent.VK_ESCAPE,0));
	        actionList.put(String.valueOf(ACTION_DRUCKEN_CODE),new AuswahlAction(rz,this,ACTION_DRUCKEN_CODE,ACTION_DRUCKEN_TEXT, KeyEvent.VK_D,InputEvent.CTRL_DOWN_MASK));
	    }

	    @Override
		public void openWindow(){
	    	if(mischung != null) {
	            setVisible(true);
	            toFront();
	            refreshAction();
	    	}
	    }

	    @Override
		public void closeWindow(){
	        rz.getFensterFactory().getFensterListe().disposeFrame(this);
	    }

	    //Extras-Menü
	    private void hideAction(){
	        rz.getFensterFactory().getFensterListe().sperren(this);
	    }

	    //hilfe
	    private void hilfeAction(){
	        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"mischungchartfenster.html",this));
	    }

	    private void druckenAction(){
	        final PrinterJob job = PrinterJob.getPrinterJob();
	        job.setPrintable(this);
	        final PageFormat pf=new PageFormat();
	        pf.setOrientation(PageFormat.LANDSCAPE);
	        if(job.printDialog()){
	        try{
	            job.print();
	            }
	        catch(final PrinterException pe){
	                rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "MischungChartFenster.druckenAction:" ,  pe.getLocalizedMessage());
	            }
	         refreshAction();
	        }
	    }
	    public int print(java.awt.Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
	        if(pageIndex != 0){
	            return Printable.NO_SUCH_PAGE;
	        }
	        else {
	            final Graphics2D g2d = (Graphics2D)graphics;
	            g2d.translate(pageFormat.getImageableX(),
	                          pageFormat.getImageableY());
	            final int cw = 	chartPanel.getWidth();
	            final int ch = chartPanel.getHeight();
	            final double pw = pageFormat.getImageableWidth();
	            final double ph = pageFormat.getImageableHeight();
	            if ((cw > pw) || (ch > ph)) {
	                final double scaleX = pw / cw;
	                final double scaleY = ph / ch;
	                final double scale = scaleX < scaleY ? scaleX : scaleY;
	                g2d.scale(scale, scale);
	            }
	        chartPanel.printAll(g2d);
	        return Printable.PAGE_EXISTS;
	        }
	    }

	}


