package de.lunqual.rzpro.fenster.mischungsfenster;

/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */


import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;

import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.ausgabe.ReportFactory;
import de.lunqual.rzpro.database.DBFactory;
import de.lunqual.rzpro.fenster.JNumberField;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fenster.JSelectedTextField;
import de.lunqual.rzpro.fenster.ZutatenDialog;
import de.lunqual.rzpro.fenster.dialoge.DialogControl;
import de.lunqual.rzpro.fenster.rzDatePicker.PickerDualDateListener;
import de.lunqual.rzpro.fenster.rzDatePicker.RzDualDatePicker;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.abfrage.AbfrageItem;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.adressen.AdressItem;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.mischungen.*;
import de.lunqual.rzpro.items.report.ReportItem;
import de.lunqual.rzpro.items.rezeptur.ZutatenSuchItem;
import de.lunqual.rzpro.items.stichworte.StichwortListe;
import de.lunqual.rzpro.items.tank.tankAuswahlItem;
import de.lunqual.rzpro.items.tank.tankItem;
import de.lunqual.rzpro.log.LogFactory;
import de.lunqual.rzpro.options.OptionFactory;


/**
 *
 * @author  administrator
 */
public class MischungsListenFenster extends JRzFrame implements TableColumnModelListener ,Printable{

    //GUI-Variablen
	private JMenuBar mb;
    	private JMenu mnuDatei;
    	private JMenu mnuExtras;
    	private JMenu mnuHilfe;
    private JPanel mainPanel;
    	private JPanel toolbarPanel;
    		private JToolBar tb1;
    	private JPanel contentPanel;
    		private JSplitPane spl1;
    			private JPanel leftPanel;
    				private JPanel leftButtonPanel;
    					private JPanel datumPanel;
    						private JPanel datumModePanel;
	    						private ButtonGroup datumGroup;
									private JRadioButton btDatumNone;
									private JRadioButton btDatumErstellt;
									private JRadioButton btDatumGeaendert;
							private JPanel datumChooserPanel;
								private JPanel pickerPanel;
									private RzDualDatePicker picker;
    					private JPanel auswahlPanel;
    						private JPanel auswahlActivePanel;
    							private ButtonGroup auswahlActiveGroup;
    								private JRadioButton btAlle;
    								private JRadioButton btActive;
    						private JPanel auswahlRezepturPanel;
    							private JLabel lblRezeptur;
    							private JPanel auswahlRezepturButtonPanel;
    								private JButton btRezeptur;
    								private JButton btRezepturClear;
    						private JPanel adressPanel;
    						   private JPanel adressPanelTitel;
    						   		private JLabel lblAdressenTitel;
    							private JPanel adressPanel1;
    								private JLabel lblAdressen;
    							private JPanel adressPanel2;
    								private JButton btAdressenBearbeiten;
    								private JButton btAdressenLoeschen;
    						private JPanel auswahlMischungsNummerPanel;
    							private JLabel lblMischungsNummer;
    							private JSelectedTextField txtMischungsNummer;
        					private JPanel auswahlMischungsBezeichnungPanel;
    							private JLabel lblMischungsBezeichnung;
    							private JSelectedTextField txtMischungsBezeichnung;
        					private JPanel auswahlLosnummerPanel;
    							private JLabel lblLosnummer;
    							private JSelectedTextField txtLosnummer;
    							private JButton btOriginalLosnummer;
        					private JPanel auswahlTankPanel;
    							private JLabel lblTank;
    							private JSelectedTextField txtTank;
  								private JButton btTankPlan;
    								
        					private JPanel auswahlTicketPanel;
    							private JLabel lblTicket;
    							private JSelectedTextField txtTicket;
    						private JPanel auswahlAktionenPanel;
    							private JLabel lblAktionen;
    							private JSelectedTextField txtAktionen;
    						private JPanel auswahlButtonPanel;
    							private JButton btAuswahlNeu;
    							private JButton btAnfang;
    							private JButton btBack;
    							private JLabel lblNav;
    							private JButton btForward;
    							private JButton btEnde;
    							private JButton btNavX;
    							private JButton btAuswahlGo;
    				private JPanel listenPanel;
    					private JScrollPane scrListe;
    						private JTable tblListe;
    					private JPanel listenButtonPanel;
    						private JPanel listenButtons;
    							private JButton btMischungNeu;
    							private JButton btMischungEdit;
    							private JButton btMischungDelete;
    							private JComboBox cmbListendruck;
    							private JButton btListendruck;
    							private JButton btListenVorschau;
    							private JCheckBox chkDuplexListe;
    						private JLabel lblListe;
    			private JPanel rightPanel;
    				private JPanel anzeigePanel;
    					private JSplitPane splAnzeige;
	    					private JScrollPane scrAnzeige;
	    						private JTable tblAnzeige;
	    					private JPanel mischungChartPanel;
	    							private JScrollPane scrChart;
	    							private MischungChartPanel chartPanel;
	    							private JPanel chartLimitPanel;
	    								private JButton btChartDruck;
	    								private JSpinner spChartList;
	    								private JLabel lblChartList;
	    								private JNumberField txtLimit;
	    								private JLabel lblLimit;
	    								private JButton btLimit;
	    						private JPanel mischungChartButtonPanel;
	    							private JCheckBox chkChart;
    					private JPanel anzeigeButtonPanel;
    						private JCheckBox chkMischungen;
    						private JCheckBox chkWarentickets;
    	private JPanel buttonPanel;
			private JButton btClose;
			private JComboBox cmbDruckFormulare;
			private JButton btDrucken;
			private JButton btVorschau;
    		private JButton btHilfe;
    		private JCheckBox chkDuplexMischung;

    // ActionCodes KalkulationEingabe
    public static final int         ACTION_CLOSE_CODE = 1001;
    public static final String      ACTION_CLOSE_TEXT = "mischungsfenster.action_close";
    public static final int         ACTION_HILFE_CODE = 1002;
    public static final String      ACTION_HILFE_TEXT = "action_hilfe";
    public static final int         ACTION_HIDE_CODE = 1003;
    public static final String      ACTION_HIDE_TEXT = "action_hide";
    public static final int         ACTION_MISCHUNG_NEU_CODE = 1004;
    public static final String      ACTION_MISCHUNG_NEU_TEXT = "mischungsfenster.action_mischung_neu";
    public static final int         ACTION_MISCHUNG_DELETE_CODE = 1005;
    public static final String      ACTION_MISCHUNG_DELETE_TEXT = "mischungsfenster.action_mischung_delete";
    public static final int         ACTION_ABFRAGE_NEU_CODE = 1006;
    public static final String      ACTION_ABFRAGE_NEU_TEXT = "mischungsfenster.action_abfrage_neu";
    public static final int         ACTION_ABFRAGE_GO_CODE = 1007;
    public static final String      ACTION_ABFRAGE_GO_TEXT = "mischungsfenster.action_abfrage_go";
    public static final int         ACTION_MISCHUNG_BEARBEITEN_CODE = 1008;
    public static final String      ACTION_MISCHUNG_BEARBEITEN_TEXT = "mischungsfenster.action_bearbeiten";
    public static final int         ACTION_DRUCKEN_CODE = 1009;
    public static final String      ACTION_DRUCKEN_TEXT = "mischungsfenster.action_drucken";
    public static final int         ACTION_VORSCHAU_CODE = 1010;
    public static final String      ACTION_VORSCHAU_TEXT = "mischungsfenster.action_vorschau";
    private static final int        ACTION_REZEPTUR_SET_CODE = 1011;
    private static final String    	ACTION_REZEPTUR_SET_TEXT = "mischungsfenster.action_rezeptur_set";
    private static final int        ACTION_REZEPTUR_RESET_CODE = 1012;
    private static final String    	ACTION_REZEPTUR_RESET_TEXT = "mischungsfenster.action_rezeptur_reset";
    public static final int         ACTION_LISTEN_DRUCKEN_CODE = 1013;
    public static final String      ACTION_LISTEN_DRUCKEN_TEXT = "mischungsfenster.action_listendruck";
    public static final int         ACTION_LISTEN_VORSCHAU_CODE = 1014;
    public static final String      ACTION_LISTEN_VORSCHAU_TEXT = "mischungsfenster.action_listenvorschau";
    public static final int         ACTION_VERLAUF_CODE = 1015;
    public static final String      ACTION_VERLAUF_TEXT = "mischungsfenster.action_verlauf";
    public static final int		 	ACTION_SHOW_TANKLISTE_CODE=1016;    
    public static final String     ACTION_SHOW_TANKLISTE_TEXT = "auswahl.action_tanks";
    public static final int         ACTION_VERLAUF_ALLE_CODE = 1017;
    public static final String      ACTION_VERLAUF_ALLE_TEXT = "mischungsfenster.action_verlauf_alle";
    
    public static final int		 	ACTION_NAV_ANFANG_CODE=1018;    
    public static final String     ACTION_NAV_ANFANG_TEXT = "mischungslistenfenster.action_nav_anfang";
    public static final int		 	ACTION_NAV_ENDE_CODE=1019;    
    public static final String     ACTION_NAV_ENDE_TEXT = "mischungslistenfenster.action_nav_ende";
    public static final int		 	ACTION_NAV_FORWARD_CODE=1020;    
    public static final String     ACTION_NAV_FORWARD_TEXT = "mischungslistenfenster.action_nav_forward";
    public static final int		 	ACTION_NAV_BACK_CODE=1021;    
    public static final String     ACTION_NAV_BACK_TEXT = "mischungslistenfenster.action_nav_back";
    public static final int		 	ACTION_NAV_X_CODE=1022;    
    public static final String     ACTION_NAV_X_TEXT = "mischungslistenfenster.action_nav_x";
    
    public static final int		 	ACTION_STAMMBAUM_CODE=1023;    
    public static final String     ACTION_STAMMBAUM_TEXT = "mischungslistenfenster.action_stammbaum";
    
	public static final int 		ACTION_ADRESSLISTE_BEARBEITEN_CODE = 1039;
	public static final String 		ACTION_ADRESSLISTE_BEARBEITEN_TEXT = "mischungbearbeitenfenster.action_adressen_bearbeiten";
	public static final int 		ACTION_ADRESSLISTE_LOESCHEN_CODE = 1040;
	public static final String 		ACTION_ADRESSLISTE_LOESCHEN_TEXT = "mischungbearbeitenfenster.action_adressen_loeschen";
	
	public static final int 		ACTION_CHART_CODE = 1042;
	public static final String 		ACTION_CHART_TEXT = "mischungslistenfenster.action_chart";
	

    public static final int        		ACTION_TANKLISTE_MISCHUNG_PLAN_CODE  = 1043;
    public static final String     		ACTION_TANKLISTE_MISCHUNG_PLAN_TEXT = "tankliste_plan"; 
    
    
    public static final int			DATE_HEUTE 			= 0;
    public static final int			DATE_GESTERN 		= 1;
    public static final int			DATE_DIESE_WOCHE 	= 2;
    public static final int			DATE_LETZTE_WOCHE 	= 3;
    public static final int			DATE_DIESEN_MONAT 	= 4;
    public static final int			DATE_LETZTEN_MONAT	= 5;
    public static final int			DATE_DIESES_JAHR 	= 6;
    public static final int			DATE_LETZTES_JAHR	= 7;
    public static final int			DATE_2_WOCHEN		= 8;
    public static final int			DATE_4_WOCHEN		= 9;
    
   
    public static final String 	CALENDAR_FORMAT		= "d. MMMMMM yyyy";
    private static final int 		C_MAX				= 10;
    private static final int		C_STATUS			= 0;
    private static final int		C_NUMMER			= 1;
    private static final int		C_BEZEICHNUNG		= 2;
    private static final int		C_SORTE				= 3;
    private static final int		C_TANK				= 4;
    private static final int		C_LA				= 5;
    private static final int		C_LOSNUMMER			= 6;
    private static final int		C_ADRESSEN			= 7;
    private static final int		C_ERSTELLT			= 8;
    private static final int		C_GEAENDERT			= 9;
    private static final int		C_ABGESCHLOSSEN		= 10;
   
    private static final int 		CT_MAX				= 13;
    private static final int		CT_TYP				= 0;
    private static final int		CT_NUMMER			= 1;
    private static final int		CT_AKTION			= 2;
    private static final int		CT_BEZEICHNUNG		= 3;
    private static final int 		CT_LA				= 4;
    private static final int		CT_STAERKE			= 5;
    private static final int		CT_ANTEIL			= 6;
    private static final int		CT_ORIGINAL_LOSNUMMER = 7;
    private static final int		CT_ERSTELLT			= 8;
    private static final int		CT_GEAENDERT		= 9;
    private static final int		CT_BEMERKUNGEN		= 10;
    private static final int 		CT_PROBEN			= 11;
    private static final int		CT_MISCHUNGEN		= 12;
    
    
    Calendar						datum1;
    Calendar						datum2;
    Calendar						heute;
    MischungsHeaderListe			liste;
    Timer					   		abfrageTimer;
    ZutatenDialog					zd;
    int								rezeptur_id;
    String							rezepturBezeichnung;
    MischungsAbfrageListe			abfragen;
    TicketListe						anzeigeTickets;
    StichwortListe				adressen;
    
    boolean							showChart = true;
    double								chartLimit = 5.0;
    
    /** Creates new form AdressAuswahl */

    public MischungsListenFenster(RzPro r, String name,Object extendedData) {
        super(r,name,extendedData);
        adressen = new StichwortListe();;
        heute = Calendar.getInstance();
        createActions();
        createGUIComponents();
        setGUIComponents();
        settblListenModel(tblListe);
        settblAnzeigeModel(tblAnzeige);
        abfrageTimer = new javax.swing.Timer(rz.getOptionFactory().getOption("list.timeout",RzPro.LIST_TIMEOUT), new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                 abfrageTimerEvent();
            }
        });
        

        abfragen = rz.getDatabase().getMischungen().getMischungsAbfrageListe();
        getMessage((MessageItem)extendedData);
    }

    @Override
	public void createGUIComponents() {
        mb = new JMenuBar();
		mnuDatei = new JMenu();
			mb.add(mnuDatei);
        mnuExtras = new JMenu();
        	mb.add(mnuExtras);
        mnuHilfe = new JMenu();
        	mb.add(mnuHilfe);
		setJMenuBar(mb);
		mainPanel = new JPanel(new BorderLayout());
			toolbarPanel = new JPanel(new BorderLayout());
				tb1 = new JToolBar();
				tb1.setFloatable(false);
				tb1.setRollover(true);
				toolbarPanel.add(tb1);
			mainPanel.add(toolbarPanel,BorderLayout.NORTH);
			contentPanel  = new JPanel(new BorderLayout());
			
    			spl1 = new JSplitPane();
    				spl1.addPropertyChangeListener(JSplitPane.DIVIDER_LOCATION_PROPERTY, 
						    new PropertyChangeListener() {
						@Override
						public void propertyChange(PropertyChangeEvent evt) {
							if (evt.getPropertyName().equals( JSplitPane.DIVIDER_LOCATION_PROPERTY)) {
								displayChart();
							}
						}
					});
    				leftPanel = new JPanel(new BorderLayout());	
    					leftButtonPanel = new JPanel(new BorderLayout());
    						datumPanel = new JPanel();
    							datumPanel.setLayout(new BoxLayout(datumPanel,BoxLayout.PAGE_AXIS));
    							datumPanel.setBorder(BorderFactory.createEtchedBorder());
    							datumModePanel = new JPanel();
    								datumModePanel.setLayout(new BoxLayout(datumModePanel,BoxLayout.LINE_AXIS));
    									datumModePanel.setBorder(BorderFactory.createEtchedBorder());
    									datumGroup = new ButtonGroup();
    										btDatumNone = new JRadioButton();
    										btDatumNone.addActionListener(new ActionListener() {
    					        	        	public void actionPerformed(ActionEvent evt) {
    					        	        	    datumSelection();
    					        	        	}
    						        	    });
    										datumGroup.add(btDatumNone);
    										datumModePanel.add(btDatumNone);
    										btDatumErstellt = new JRadioButton();
    										btDatumErstellt.addActionListener(new ActionListener() {
    					        	        	public void actionPerformed(ActionEvent evt) {
    					        	        	    datumSelection();
    					        	        	}
    						        	    });
    										datumGroup.add(btDatumErstellt);
    										datumModePanel.add(btDatumErstellt);
    										btDatumGeaendert = new JRadioButton();
    										btDatumGeaendert.addActionListener(new ActionListener() {
    					        	        	public void actionPerformed(ActionEvent evt) {
    					        	        	    datumSelection();
    					        	        	}
    						        	    });
    										datumGroup.add(btDatumGeaendert);
    										datumModePanel.add(btDatumGeaendert);
    										btDatumNone.setSelected(true);
    						datumPanel.add(datumModePanel);
    						datumChooserPanel = new JPanel(new BorderLayout());
	    						pickerPanel = new JPanel(new BorderLayout());
	    							picker = new RzDualDatePicker(rz,null,null);
	    								picker.addListener((PickerDualDateListener) new PickerDualDateListener() {
	
											public void dateChanged(Date datum1, Date datum2) {
												// TODO Auto-generated method stub
												datumSelection();
											}
	    								
	    								
	    								});
	    								pickerPanel.add(picker,BorderLayout.CENTER);
	    								datumChooserPanel.add(pickerPanel,BorderLayout.CENTER);
	    						datumPanel.add(datumChooserPanel);
    						
    						
    						
    					leftButtonPanel.add(datumPanel,BorderLayout.NORTH);
    						auswahlPanel = new JPanel();
    							auswahlPanel.setBorder(BorderFactory.createEtchedBorder());
    							auswahlPanel.setLayout(new BoxLayout(auswahlPanel,BoxLayout.PAGE_AXIS));
    								auswahlActivePanel = new JPanel(new BorderLayout());
    									auswahlActivePanel.setBorder(BorderFactory.createEtchedBorder());
    									auswahlActiveGroup = new ButtonGroup();
    										btAlle = new JRadioButton();
    											btAlle.addActionListener(new java.awt.event.ActionListener() {
    				    			                public void actionPerformed(java.awt.event.ActionEvent evt) {
    				    			                	typAuswahlAction();
    				    			                	}
    				    			            	});
    											auswahlActiveGroup.add(btAlle);
    										auswahlActivePanel.add(btAlle,BorderLayout.NORTH);
    										btActive = new JRadioButton();
    											btActive.addActionListener(new java.awt.event.ActionListener() {
    				    			                public void actionPerformed(java.awt.event.ActionEvent evt) {
    				    			                	typAuswahlAction();
    				    			                	}
    				    			            	});
    											auswahlActiveGroup.add(btActive);
    										auswahlActivePanel.add(btActive,BorderLayout.SOUTH);
    								auswahlPanel.add(auswahlActivePanel);
    								
    								auswahlRezepturPanel=new JPanel(new BorderLayout());
        								lblRezeptur = new JLabel();
        								auswahlRezepturPanel.add(lblRezeptur,BorderLayout.WEST);
        								auswahlRezepturButtonPanel = new JPanel(new GridLayout(1,2));
        									btRezeptur = new JButton();
        									auswahlRezepturButtonPanel.add(btRezeptur);
        									btRezepturClear = new JButton();
        									auswahlRezepturButtonPanel.add(btRezepturClear);
        								auswahlRezepturPanel.add(auswahlRezepturButtonPanel,BorderLayout.CENTER);
        							auswahlPanel.add(auswahlRezepturPanel);
        							
        							adressPanel = new JPanel(new BorderLayout());
        							   adressPanelTitel = new JPanel(new BorderLayout());
        							       lblAdressenTitel = new JLabel();
        							       lblAdressenTitel.setHorizontalAlignment(SwingConstants.TRAILING);
        							       adressPanelTitel.add(lblAdressenTitel);
        							     
        								adressPanel1 = new JPanel(new BorderLayout());
        									 lblAdressen = new JLabel();
        									 lblAdressen.setHorizontalAlignment(SwingConstants.TRAILING);
        									 adressPanel1.add(lblAdressen,BorderLayout.CENTER);
        							    adressPanel2 = new JPanel(new GridLayout(1,2));
        							    	btAdressenBearbeiten = new JButton();
        							    	adressPanel2.add(btAdressenBearbeiten);
        							    	btAdressenLoeschen = new JButton();
        							    	adressPanel2.add(btAdressenLoeschen);
        							    adressPanel.add(adressPanelTitel,BorderLayout.WEST);
        							    adressPanel.add(adressPanel1,BorderLayout.CENTER);
        							    adressPanel.add(adressPanel2,BorderLayout.EAST);
        							auswahlPanel.add(adressPanel);
        							
    								auswahlMischungsNummerPanel  = new JPanel(new BorderLayout());
    									lblMischungsNummer = new JLabel();
    										lblMischungsNummer.setHorizontalAlignment(SwingConstants.TRAILING);
    									auswahlMischungsNummerPanel.add(lblMischungsNummer, BorderLayout.WEST);
    									txtMischungsNummer = new JSelectedTextField();
    									txtMischungsNummer.addKeyListener(new java.awt.event.KeyAdapter() {
								            public void keyReleased(java.awt.event.KeyEvent evt) {
								                if(tblListe.isFocusOwner()) {
								                } else {
								                    if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
								                    	doAbfrageAction();
								                    }
								                }
								            }
								        });
    									auswahlMischungsNummerPanel.add(txtMischungsNummer,BorderLayout.CENTER);
    							auswahlPanel.add(auswahlMischungsNummerPanel);
    								
    							auswahlMischungsBezeichnungPanel  = new JPanel(new BorderLayout());
									lblMischungsBezeichnung = new JLabel();
										lblMischungsBezeichnung.setHorizontalAlignment(SwingConstants.TRAILING);
									auswahlMischungsBezeichnungPanel.add(lblMischungsBezeichnung, BorderLayout.WEST);
									txtMischungsBezeichnung = new JSelectedTextField();
									txtMischungsBezeichnung.addKeyListener(new java.awt.event.KeyAdapter() {
							            public void keyReleased(java.awt.event.KeyEvent evt) {
							                if(tblListe.isFocusOwner()) {
							                } else {
							                    if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
							                    	doAbfrageAction();
							                    }
							                }
							            }
							        });
									auswahlMischungsBezeichnungPanel.add(txtMischungsBezeichnung,BorderLayout.CENTER);
								auswahlPanel.add(auswahlMischungsBezeichnungPanel);
							
    							auswahlLosnummerPanel  = new JPanel(new BorderLayout());
									this.lblLosnummer = new JLabel();
										lblLosnummer.setHorizontalAlignment(SwingConstants.TRAILING);
									auswahlLosnummerPanel.add(lblLosnummer, BorderLayout.WEST);
									txtLosnummer = new JSelectedTextField();
									txtLosnummer.addKeyListener(new java.awt.event.KeyAdapter() {
							            public void keyReleased(java.awt.event.KeyEvent evt) {
							                if(tblListe.isFocusOwner()) {
							                } else {
							                    if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
							                    	doAbfrageAction();
							                    }
							                }
							            }
							        });
									auswahlLosnummerPanel.add(txtLosnummer,BorderLayout.CENTER);
									btOriginalLosnummer = new JButton();
									btOriginalLosnummer.addActionListener(new ActionListener() {
										public void actionPerformed(ActionEvent evt) {
											originalLosnummerSuchen();
					    	        	}
					                });
									auswahlLosnummerPanel.add(btOriginalLosnummer,BorderLayout.EAST);
								auswahlPanel.add(auswahlLosnummerPanel);
								
								//auswahlPanel.add(auswahlOriginalLosnummerPanel);
								
								
								auswahlTankPanel  = new JPanel(new BorderLayout());
									lblTank = new JLabel();
										lblTank.setHorizontalAlignment(SwingConstants.TRAILING);
									auswahlTankPanel.add(lblTank, BorderLayout.WEST);
									txtTank = new JSelectedTextField();
									txtTank.addKeyListener(new java.awt.event.KeyAdapter() {
							            public void keyReleased(java.awt.event.KeyEvent evt) {
							                if(tblListe.isFocusOwner()) {
							                } else {
							                    if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
							                    	doAbfrageAction();
							                    }
							                }
							            }
							        });
									auswahlTankPanel.add(txtTank,BorderLayout.CENTER);
							
									btTankPlan = new JButton();
									auswahlTankPanel.add(btTankPlan,BorderLayout.EAST);
										
								auswahlPanel.add(auswahlTankPanel);
							
								auswahlTicketPanel  = new JPanel(new BorderLayout());
									lblTicket = new JLabel();
										lblTicket.setHorizontalAlignment(SwingConstants.TRAILING);
									auswahlTicketPanel.add(lblTicket, BorderLayout.WEST);
									txtTicket = new JSelectedTextField();
									txtTicket.addKeyListener(new java.awt.event.KeyAdapter() {
							            public void keyReleased(java.awt.event.KeyEvent evt) {
							                if(tblListe.isFocusOwner()) {
							                } else {
							                    if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
							                    	doAbfrageAction();
							                    }
							                }
							            }
							        });
									auswahlTicketPanel.add(txtTicket,BorderLayout.CENTER);
								auswahlPanel.add(auswahlTicketPanel);
								
								auswahlAktionenPanel  = new JPanel(new BorderLayout());
								lblAktionen = new JLabel();
									lblAktionen.setHorizontalAlignment(SwingConstants.TRAILING);
								auswahlAktionenPanel.add(lblAktionen, BorderLayout.WEST);
								txtAktionen = new JSelectedTextField();
								txtAktionen.addKeyListener(new java.awt.event.KeyAdapter() {
						            public void keyReleased(java.awt.event.KeyEvent evt) {
						                if(tblListe.isFocusOwner()) {
						                } else {
						                    if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
						                    	doAbfrageAction();
						                    }
						                }
						            }
						        });
								auswahlAktionenPanel.add(txtAktionen,BorderLayout.CENTER);
							auswahlPanel.add(auswahlAktionenPanel);
							
								
								
	    						auswahlButtonPanel = new JPanel(new GridLayout(1,8));
	    							auswahlButtonPanel.setBorder(BorderFactory.createEtchedBorder());
	    								btAuswahlNeu = new JButton();
	    							auswahlButtonPanel.add(btAuswahlNeu);
	    							
	    								btAnfang = new JButton();
	    							auswahlButtonPanel.add(btAnfang);
	    								btBack = new JButton();
	    							auswahlButtonPanel.add(btBack);
	    								lblNav = new JLabel();
	    								lblNav.setHorizontalAlignment(SwingConstants.CENTER);
	    							auswahlButtonPanel.add(lblNav);
	    								btForward = new JButton();
	    							auswahlButtonPanel.add(btForward);
	    								btEnde = new JButton();
	    							auswahlButtonPanel.add(btEnde);
    									btNavX = new JButton();
    								auswahlButtonPanel.add(btNavX);
	    							
    									btAuswahlGo = new JButton();
    								auswahlButtonPanel.add(btAuswahlGo);
    							auswahlPanel.add(auswahlButtonPanel);
    					leftButtonPanel.add(auswahlPanel,BorderLayout.SOUTH);
    				leftPanel.add(leftButtonPanel,BorderLayout.NORTH);
    					listenPanel = new JPanel(new BorderLayout());
    						scrListe = new JScrollPane();
    							tblListe = new JTable();
						        JTableHeader header = tblListe.getTableHeader();
						        header.addMouseListener(new ColumnHeaderListener());
    							tblListe.setName("mischungsfenster.liste");
    							tblListe.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
				    			tblListe.setColumnSelectionAllowed(true);
				    			tblListe.setRowSelectionAllowed(true);
					    		tblListe.setShowGrid(true);
				    			tblListe.setGridColor(rz.getOptionFactory().getColor(OptionFactory.COLOR_VISIBLE_GRID));
				    			tblListe.getSelectionModel().addListSelectionListener(new ListSelectionListener() {
				                    public void valueChanged(ListSelectionEvent e) {
				        			        if (e.getValueIsAdjusting()) {
												return;
											}
					        			    if(abfrageTimer.isRunning()) {
					        			            abfrageTimer.stop();
					        			        }
				        			        abfrageTimer.start();
				                        }
					    			});
				    			tblListe.addMouseListener(new java.awt.event.MouseAdapter() {
						            public void mouseClicked(java.awt.event.MouseEvent evt) {
						                	listeClicked();
						            }
						        });
    						scrListe.setViewportView(tblListe);
    					listenPanel.add(scrListe,BorderLayout.CENTER);
    					
    					listenButtonPanel = new JPanel(new BorderLayout());
    						listenButtonPanel.setBorder(BorderFactory.createEtchedBorder());
							listenButtons = new JPanel (new  GridLayout(3,3));
								btMischungNeu = new JButton();
									listenButtons.add(btMischungNeu);
								btMischungEdit = new JButton();
									listenButtons.add(btMischungEdit);
								btMischungDelete = new JButton();
									listenButtons.add(btMischungDelete);
								cmbListendruck = new JComboBox();
						    	rz.getDatabase().getReport().dbGetReportListeCombo(cmbListendruck,ReportFactory.REPORT_TYPE_MISCHUNGSLISTE);
							    cmbListendruck.addActionListener(new ActionListener() {
									public void actionPerformed(ActionEvent evt) {
				    	        		if(cmbListendruck.getSelectedIndex() != -1) {
				    	        			rz.getOptionFactory().setOption("report.mischungsliste",((ReportItem)cmbListendruck.getSelectedItem()).getID());
				    	        			rz.getOptionFactory().saveOptions();
				    	        		}
				    	        	}
				                });
								
									listenButtons.add(cmbListendruck);
								btListendruck = new JButton();
									listenButtons.add(btListendruck);
								btListenVorschau = new JButton();
									listenButtons.add(btListenVorschau);
									chkDuplexListe= new JCheckBox();
									chkDuplexListe.setSelected((rz.getOptionFactory().getOption("mischung.liste.duplex",0) == 1?true:false));
									chkDuplexListe.addActionListener(new ActionListener() {
							        	public void actionPerformed(ActionEvent evt) {
							        		rz.getOptionFactory().setOption("mischung.liste.duplex", chkDuplexListe.isSelected()?1:0);
							        		rz.getOptionFactory().saveOptions();
							        	}
						    	    });
									listenButtons.add(chkDuplexListe);
						listenButtonPanel.add(listenButtons,BorderLayout.NORTH);
    					lblListe = new JLabel();
    						lblListe.setBorder(BorderFactory.createEtchedBorder());
    					listenButtonPanel.add(lblListe,BorderLayout.SOUTH);
    					listenPanel.add(listenButtonPanel,BorderLayout.SOUTH);
    				leftPanel.add(listenPanel,BorderLayout.CENTER);
			
    				rightPanel = new JPanel(new BorderLayout());
    				
    					splAnzeige = new JSplitPane();
    						splAnzeige.addPropertyChangeListener(JSplitPane.DIVIDER_LOCATION_PROPERTY, 
    							    new PropertyChangeListener() {
								@Override
								public void propertyChange(PropertyChangeEvent evt) {
									if (evt.getPropertyName().equals( JSplitPane.DIVIDER_LOCATION_PROPERTY)) {
										displayChart();
									}
								}
    						});
    						splAnzeige.setOrientation(JSplitPane.VERTICAL_SPLIT);
    				
	    					anzeigePanel = new JPanel(new BorderLayout());
	    						scrAnzeige = new JScrollPane();
	    						tblAnzeige = new JTable();
	    						tblAnzeige.setName("mischungsfenster.tickets");
								tblAnzeige.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
				    			tblAnzeige.setRowSelectionAllowed(true);
					    		tblAnzeige.setShowGrid(true);
				    			tblAnzeige.setGridColor(Color.GRAY);
	    						scrAnzeige.setViewportView(tblAnzeige);
	    					anzeigePanel.add(scrAnzeige,BorderLayout.CENTER);
    					
    					
    					
    					anzeigeButtonPanel = new JPanel(new BorderLayout());
    						chkMischungen = new JCheckBox();
    						chkMischungen.addActionListener(new ActionListener() {
    							public void actionPerformed(ActionEvent evt) {
    								rz.getOptionFactory().setOption("mischungsfenster.mischungen_anzeigen",chkMischungen.isSelected()?1:0);
    								rz.getOptionFactory().saveOptions();
    								doAbfrageAction();
    		    	        	}
    		                });
    						chkWarentickets = new JCheckBox();
    						chkWarentickets.addActionListener(new ActionListener() {
    							public void actionPerformed(ActionEvent evt) {
    								rz.getOptionFactory().setOption("mischungsfenster.warentickets_anzeigen",chkWarentickets.isSelected()?1:0);
    								rz.getOptionFactory().saveOptions();
    						       doAbfrageAction();
    		    	        	}
    		                });
    					anzeigeButtonPanel.add(chkMischungen,BorderLayout.WEST);
    					anzeigeButtonPanel.add(chkWarentickets,BorderLayout.EAST);
    					
    					
    					anzeigePanel.add(anzeigeButtonPanel,BorderLayout.NORTH);
    					
    					mischungChartPanel = new JPanel(new BorderLayout());
    						splAnzeige.getBottomComponent().setVisible(false);
    						mischungChartButtonPanel = new JPanel(new BorderLayout());
    							chkChart  = new JCheckBox();
			    				chkChart.setSelected((rz.getOptionFactory().getOption("mischung.chart",0) == 1?true:false));
    								chkChart.addActionListener(new ActionListener() {
							        	public void actionPerformed(ActionEvent evt) {
							        		rz.getOptionFactory().setOption("mischung.chart", chkChart.isSelected()?1:0);
							        		rz.getOptionFactory().saveOptions();
							        		if(chkChart.isSelected()) {
							        			splAnzeige.getBottomComponent().setVisible(true);
							        	        splAnzeige.setDividerLocation( getHeight()/2);
							        	        if(chartLimitPanel != null) {
							        	        	chartLimitPanel.setVisible(true);
							        	        }
							        			displayChart();
							        		}else {
							        			splAnzeige.getBottomComponent().setVisible(false);
							        	        if(chartLimitPanel != null) {
							        	        	chartLimitPanel.setVisible(false);
							        	        }
							        		}
							        	}
						    	    });
    							mischungChartButtonPanel.add(chkChart,BorderLayout.NORTH);
    							scrChart = new JScrollPane();
    								chartPanel = new MischungChartPanel(rz,rz.getOptionFactory().getOption("mischung.chart.list",OptionFactory.MISCHUNG_CHART_LIST));
    								scrChart.setViewportView(chartPanel);
    						mischungChartPanel.add(scrChart,BorderLayout.CENTER);
    							chartLimitPanel = new JPanel(new GridLayout(2,4));
    							chartLimitPanel.setBorder(BorderFactory.createEtchedBorder());
    							btChartDruck = new JButton();
    								btChartDruck.addActionListener(new ActionListener() {
    						        	public void actionPerformed(ActionEvent evt) {
    						        		if(chartPanel != null) {
    						        			chartDruck();
    						        		}
    						        	}
    					    	    });
    							chartLimitPanel.add(btChartDruck);
    							spChartList = new JSpinner();
    								spChartList.setValue(rz.getOptionFactory().getOption("mischung.chart.list",OptionFactory.MISCHUNG_CHART_LIST));
    			    	           spChartList.addChangeListener(new javax.swing.event.ChangeListener() {
    			    	               public void stateChanged(javax.swing.event.ChangeEvent evt) {
    			    	                	spinnerChanged();
    			    	            	}
    			    	           });
    			    	           chartLimitPanel.add(spChartList);
    			    	           lblChartList = new JLabel();
    			    	           		lblChartList.setHorizontalAlignment(SwingConstants.LEADING);
    			    	           chartLimitPanel.add(lblChartList);
    						
								txtLimit = new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_ONE), 5.0, 0.0, 99);
								txtLimit.setValue(rz.getOptionFactory().getDouble("mischungChart.limit", 5.0));
								txtLimit.addKeyListener(new java.awt.event.KeyAdapter() {
			 			            @Override
									public void keyReleased(java.awt.event.KeyEvent evt) {
			 			            	if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
			 			            		rz.getOptionFactory().setDouble("mischungChart.limit", txtLimit.getValue());
			 			            		rz.getOptionFactory().saveOptions();
			 			            		displayChart();
			 			            	}
			 			            }
			 			        });
								chartLimitPanel.add(txtLimit,BorderLayout.WEST);
								lblLimit = new JLabel();
									lblLimit.setHorizontalAlignment(SwingConstants.LEADING);
								chartLimitPanel.add(lblLimit,BorderLayout.CENTER);
								
								btLimit = new JButton();
								btLimit.addActionListener(new ActionListener() {
						        	public void actionPerformed(ActionEvent evt) {
						        		displayChart();
						        	}
					    	    });
								   chartLimitPanel.add(btLimit);
								
								mischungChartButtonPanel.add(chartLimitPanel,BorderLayout.CENTER);
    							
    						anzeigePanel.add(mischungChartButtonPanel,BorderLayout.SOUTH);
    						splAnzeige.setTopComponent(anzeigePanel);
    						splAnzeige.setBottomComponent(mischungChartPanel);
    					
    				rightPanel.add(splAnzeige, BorderLayout.CENTER);
			
    			spl1.setDividerSize(5);
    			spl1.setOrientation(JSplitPane.HORIZONTAL_SPLIT);
    			spl1.setTopComponent(leftPanel);
    			spl1.setBottomComponent(rightPanel);
			contentPanel.add(spl1,BorderLayout.CENTER);
			buttonPanel=new JPanel(new GridLayout(1,6));
		    	btClose = new JButton();
		    		buttonPanel.add(btClose);
		    	cmbDruckFormulare = new JComboBox();
		    	rz.getDatabase().getReport().dbGetReportListeCombo(cmbDruckFormulare,ReportFactory.REPORT_TYPE_MISCHUNG);
        	    cmbDruckFormulare.addActionListener(new ActionListener() {
					public void actionPerformed(ActionEvent evt) {
    	        		if(cmbDruckFormulare.getSelectedIndex() != -1) {
    	        			rz.getOptionFactory().setOption("report.mischung",((ReportItem)cmbDruckFormulare.getSelectedItem()).getID());
    	        			rz.getOptionFactory().saveOptions();
    	        		}
    	        	}
                });
		    		buttonPanel.add(cmbDruckFormulare);
		    		chkDuplexMischung= new JCheckBox();
					chkDuplexMischung.setSelected((rz.getOptionFactory().getOption("mischung.mischung.duplex",0) == 1?true:false));
					chkDuplexMischung.addActionListener(new ActionListener() {
			        	public void actionPerformed(ActionEvent evt) {
			        		rz.getOptionFactory().setOption("mischung.mischung.duplex", chkDuplexMischung.isSelected()?1:0);
			        		rz.getOptionFactory().saveOptions();
			        	}
		    	    });
					buttonPanel.add(chkDuplexMischung);
		    	btDrucken = new JButton();
		    		buttonPanel.add(btDrucken);
		    	btVorschau = new JButton();
		    		buttonPanel.add(btVorschau);
    			btHilfe = new JButton();
    				buttonPanel.add(btHilfe);
			mainPanel.add(toolbarPanel,BorderLayout.NORTH);
			mainPanel.add(contentPanel,BorderLayout.CENTER);
			mainPanel.add(buttonPanel,BorderLayout.SOUTH);
			addComponentListener(new ComponentListener() {
			    public void componentResized(ComponentEvent componentEvent) {
			    	displayChart();
			    }

				@Override
				public void componentMoved(ComponentEvent e) {
					
				}

				@Override
				public void componentShown(ComponentEvent e) {
					
				}

				@Override
				public void componentHidden(ComponentEvent e) {
					
				}
			});
			getContentPane().setLayout(new BorderLayout());
			getContentPane().add(mainPanel,BorderLayout.CENTER);
    }
    @Override
	public void setGUIComponents() {
        setTitle(rz.getLocale().getString("mischungsfenster.titel"));

        mnuDatei.setText(rz.getLocale().getString("menu.datei"));
        mnuExtras.setText(rz.getLocale().getString("menu.extras"));
        mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));

        mnuDatei.add(getAction(ACTION_MISCHUNG_NEU_CODE));
        mnuDatei.add(getAction(ACTION_MISCHUNG_BEARBEITEN_CODE));
        mnuDatei.addSeparator();
        mnuDatei.add(getAction(ACTION_MISCHUNG_DELETE_CODE));
        mnuDatei.addSeparator();
  	  	mnuDatei.add(getAction(ACTION_STAMMBAUM_CODE));
  	  	mnuDatei.addSeparator();
  	  	mnuDatei.add(getAction(ACTION_CHART_CODE));
  	  	mnuDatei.addSeparator();
        mnuDatei.add(getAction(ACTION_LISTEN_DRUCKEN_CODE));
  	  	mnuDatei.add(getAction(ACTION_LISTEN_VORSCHAU_CODE));
  	  	mnuDatei.addSeparator();
  	  	mnuDatei.add(getAction(ACTION_LISTEN_DRUCKEN_CODE));
  	  	mnuDatei.add(getAction(ACTION_LISTEN_VORSCHAU_CODE));
  	  	mnuDatei.addSeparator();
  	  	mnuDatei.add(getAction(ACTION_VERLAUF_CODE));
  	  	mnuDatei.add(getAction(ACTION_VERLAUF_ALLE_CODE));
        mnuDatei.add(getAction(ACTION_SHOW_TANKLISTE_CODE));
  	  	mnuDatei.addSeparator();
  	  	mnuDatei.add( getAction(ACTION_CLOSE_CODE));
  	  	
        mnuDatei.add(getAction(ACTION_CLOSE_CODE));
        mnuExtras.add(getAction(ACTION_HIDE_CODE));
        mnuHilfe.add(getAction(ACTION_HILFE_CODE));

  	  	tb1.add(getAction(ACTION_CLOSE_CODE));
  	  	tb1.addSeparator();
  	  	tb1.add(getAction(ACTION_HIDE_CODE));
  	  	tb1.addSeparator();
  	  	tb1.add(getAction(ACTION_DRUCKEN_CODE));
  	  	tb1.add(getAction(ACTION_VORSCHAU_CODE));
  	  	tb1.add(getAction(ACTION_VERLAUF_CODE));
  	  	tb1.add(getAction(ACTION_VERLAUF_ALLE_CODE));
  	  	tb1.add(getAction(ACTION_STAMMBAUM_CODE));
  	  	tb1.addSeparator();
        tb1.add(getAction(ACTION_CHART_CODE));
        tb1.addSeparator();
  	  	tb1.add(getAction(ACTION_SHOW_TANKLISTE_CODE));
  	  	tb1.addSeparator();
  	  	tb1.add(getAction(ACTION_LISTEN_DRUCKEN_CODE));
  	  	tb1.add(getAction(ACTION_LISTEN_VORSCHAU_CODE));
  	  	tb1.addSeparator();
  	  	tb1.add(getAction(ACTION_MISCHUNG_NEU_CODE));
  	  	tb1.add(getAction(ACTION_MISCHUNG_BEARBEITEN_CODE));
  	  	tb1.addSeparator();
  	  	tb1.add(getAction(ACTION_MISCHUNG_DELETE_CODE));  	  
  	  	tb1.addSeparator();
  	  	tb1.add(getAction(ACTION_HILFE_CODE));

        btHilfe.setAction(getAction(ACTION_HILFE_CODE));
        btClose.setAction(getAction(ACTION_CLOSE_CODE));
        btAuswahlNeu.setAction(getAction(ACTION_ABFRAGE_NEU_CODE));
        btAuswahlGo.setAction(getAction(ACTION_ABFRAGE_GO_CODE));
  	  	btDrucken.setAction(getAction(ACTION_DRUCKEN_CODE));
  	  	btVorschau.setAction(getAction(ACTION_VORSCHAU_CODE));
		btRezeptur.setAction(getAction(ACTION_REZEPTUR_SET_CODE));
		btRezepturClear.setAction(getAction(ACTION_REZEPTUR_RESET_CODE));
  	  	btMischungNeu.setAction(getAction(ACTION_MISCHUNG_NEU_CODE));
  	  	btMischungEdit.setAction(getAction(ACTION_MISCHUNG_BEARBEITEN_CODE));
  	  	btMischungDelete.setAction(getAction(ACTION_MISCHUNG_DELETE_CODE));  	  
  	  	btListendruck.setAction(getAction(ACTION_LISTEN_DRUCKEN_CODE));
  	  	btListenVorschau.setAction(getAction(ACTION_LISTEN_VORSCHAU_CODE));
		btTankPlan.setAction(getAction(ACTION_TANKLISTE_MISCHUNG_PLAN_CODE));
		
  	   lblAdressenTitel.setText(rz.getLocale().getString("mischungslistenfenster.label_adresstitel"));
  	  	
  	  	btAnfang.setAction(getAction(ACTION_NAV_ANFANG_CODE));
  	  	btEnde.setAction(getAction(ACTION_NAV_ENDE_CODE));
  	  	btForward.setAction(getAction(ACTION_NAV_FORWARD_CODE));
  	  	btBack.setAction(getAction(ACTION_NAV_BACK_CODE));
  	  	btNavX.setAction(getAction(ACTION_NAV_X_CODE));
        
  	   btAdressenBearbeiten.setAction(getAction(ACTION_ADRESSLISTE_BEARBEITEN_CODE));
  	   btAdressenLoeschen.setAction(getAction(ACTION_ADRESSLISTE_LOESCHEN_CODE));
  	  	
  	  	getAction(ACTION_NAV_BACK_CODE).setEnabled(false);
  	  	getAction(ACTION_NAV_FORWARD_CODE).setEnabled(false);
  	  	getAction(ACTION_NAV_ENDE_CODE).setEnabled(false);
  	  	getAction(ACTION_NAV_ANFANG_CODE).setEnabled(false);
  	  	
  	  	getAction(ACTION_MISCHUNG_DELETE_CODE).setEnabled(false);
		getAction(ACTION_MISCHUNG_BEARBEITEN_CODE).setEnabled(false);
  	  	getAction(ACTION_VORSCHAU_CODE).setEnabled(false);
  	  	getAction(ACTION_DRUCKEN_CODE).setEnabled(false);
  	  	getAction(ACTION_VERLAUF_CODE).setEnabled(false);
  	  	
  	  	lblMischungsNummer.setText(rz.getLocale().getString("mischungsfenster.label_mischungsnummer"));
  	  	lblMischungsBezeichnung.setText(rz.getLocale().getString("mischungsfenster.label_mischungsbezeichnung"));
  	  	lblTank.setText(rz.getLocale().getString("mischungsfenster.label_tank"));
  	  	lblTicket.setText(rz.getLocale().getString("mischungsfenster.label_ticket"));
  	  	btDatumNone.setText(rz.getLocale().getString("mischungsfenster.datum_none"));
  	  	btDatumErstellt.setText(rz.getLocale().getString("mischungsfenster.datum_erstellt"));
  	  	btDatumGeaendert.setText(rz.getLocale().getString("mischungsfenster.datum_geaendert"));
	
		btAlle.setText(rz.getLocale().getString("mischungsfenster.label_alle"));
		btActive.setText(rz.getLocale().getString("mischungsfenster.label_active"));
  	  	lblLosnummer.setText(rz.getLocale().getString("mischungsfenster.label_losnummer"));
  	  	btOriginalLosnummer.setText(rz.getLocale().getString("mischungsfenster.label_original_losnummer"));
        lblRezeptur.setText(rz.getLocale().getString("mischungeingabe.label_rezeptur_leer"));
  	  	lblAktionen.setText(rz.getLocale().getString("mischungsfenster.label_aktionen"));
  	  	chkMischungen.setText(rz.getLocale().getString("mischungsfenster.mischungen_anzeigen"));
  	  	chkWarentickets.setText(rz.getLocale().getString("mischungsfenster.warentickets_anzeigen"));  	  	
  	  	chkMischungen.setSelected(rz.getOptionFactory().getOption("mischungsfenster.mischungen_anzeigen",0)==0?false:true);
  	  	chkWarentickets.setSelected(rz.getOptionFactory().getOption("mischungsfenster.warentickets_anzeigen",0)==0?false:true);
  	  	chkDuplexMischung.setText(rz.getLocale().getString("mischung.mischung.duplex"));
  	  	chkDuplexListe.setText(rz.getLocale().getString("mischung.liste.duplex"));
  	  	chkChart.setText(rz.getLocale().getString("mischungslistenfenster.chkchart"));
  	  	lblLimit.setText(rz.getLocale().getString("mischungChartPanel.label_limit"));
  	  	btLimit.setText(rz.getLocale().getString("mischungChartPanel.action_limit"));
  	  	lblChartList.setText(rz.getLocale().getString("mischungslistenfenster.label_chart_list"));
  	  	btChartDruck.setText(rz.getLocale().getString("mischungslistenfenster.chart_druck"));
  	  	
  	  	setResizable(true);
        rz.getFontFactory().setFrameFonts(this);
        pack();
        rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE);
        setDividerLocations();
    }
    @Override
	public void getMessage(MessageItem msg) {
    	MischungsAbfrageItem mai = null; 
        switch(msg.getMsgCode()) {
	    	case MessageItem.MSG_ACTIONPERFORMED:
	            switch(msg.getCode()){
	            case ACTION_CLOSE_CODE :closeWindow();break;
	            case ACTION_HILFE_CODE: hilfeAction();break;
	            case ACTION_HIDE_CODE:hideAction();break;
	            case ACTION_MISCHUNG_NEU_CODE:mischungNeuAction();break;
	            case ACTION_MISCHUNG_DELETE_CODE:mischungDeleteAction();break;
	            case ACTION_MISCHUNG_BEARBEITEN_CODE:mischungBearbeitenAction();break;
	            case ACTION_ABFRAGE_GO_CODE: doAbfrageAction();break;
	            case ACTION_ABFRAGE_NEU_CODE: neuAbfrageAction();break;
	            case ACTION_DRUCKEN_CODE:druckenAction(false);break;
	            case ACTION_VORSCHAU_CODE:druckenAction(true);break;
	            case ACTION_LISTEN_DRUCKEN_CODE:listenDruckAction(false);break;
	            case ACTION_LISTEN_VORSCHAU_CODE:listenDruckAction(true);break;
		        case ACTION_REZEPTUR_SET_CODE:rezepturSetAction();break;
		        case ACTION_REZEPTUR_RESET_CODE:rezepturResetAction();break;
		        case ACTION_VERLAUF_CODE:verlaufAction();break;
		        case ACTION_VERLAUF_ALLE_CODE:verlaufAlleAction();break;
		        case ACTION_SHOW_TANKLISTE_CODE:showTankListeAction();break;
		        case ACTION_STAMMBAUM_CODE:stammbaumAction();break;
	            case ACTION_CHART_CODE:chartAction();break;
		        case ACTION_TANKLISTE_MISCHUNG_PLAN_CODE: tanklisteMischungPlanAction();break;
		        case ACTION_ADRESSLISTE_BEARBEITEN_CODE :
					adressListeBearbeitenAction();
					break;
				case ACTION_ADRESSLISTE_LOESCHEN_CODE :
					adressenLoeschenAction();
					break;
		        case ACTION_NAV_ANFANG_CODE:
		        	abfragen.moveAnfang();
			        displayAbfrage();
			        doAbfrage();
		        	break;
		        case ACTION_NAV_ENDE_CODE:
		        	abfragen.moveEnde();
			        displayAbfrage();
			        doAbfrage();
		        	break;
		        case ACTION_NAV_FORWARD_CODE:
		        	abfragen.moveForward();
			        displayAbfrage();
			        doAbfrage();
		        	break;
		        case ACTION_NAV_BACK_CODE:
		        	abfragen.moveBack();
			        displayAbfrage();
			        doAbfrage();
		        	break;
		        case ACTION_NAV_X_CODE:
		        	abfragen.reset();
		        	saveLast();
		        	setActions();
		        	break;
	            default :
	                break;
	           }
	           break;
			case MessageItem.MSG_ZUTATEN_DIALOG_REPLY :
				rezepturSetReply((ZutatenSuchItem) msg.getData());
				break;
	    case MessageItem.MSG_REFRESH_MISCHUNGEN:
		case MessageItem.MSG_REFRESH_AUSGABE:
			mai = (MischungsAbfrageItem)msg.getData();
			if(mai != null) {
		    	abfragen.add(mai);
			}
			doAbfrage();
			break;      
	    case MessageItem.MSG_SHOW_MISCHUNGSFENSTER_TICKETS:
	    		mai = new MischungsAbfrageItem(rz,"");
	    		mai.setTicketNummer((String)msg.getData());
	    		abfragen.add(mai);
	    		displayAbfrage();
	    		doAbfrage();
			break;
	    case MessageItem.MSG_SHOW_MISCHUNGSFENSTER_MISCHUNGEN:
	    	mai = new MischungsAbfrageItem(rz,"");
	    	AdressItem ai = (AdressItem)msg.getData();
	    	mai.setAdressen(rz.getDatabase().getSTW().dbGetAdressenListe("<" + ai.getID()+">"));
	    	mai.setActive(true);
	    	abfragen.add(mai);
	    	displayAbfrage();
	    	doAbfrage();
			break;
	    case MessageItem.MSG_SHOW_MISCHUNGSFENSTER_MISCHUNGSLISTE:
	    	mai = new MischungsAbfrageItem(rz,"");
	    	mai.setTank("");
	    	mai.setDateMode(MischungsAbfrageItem.DATE_NONE);
	    	mai.setLosnummer("");
	    	mai.setMischungBezeichnung("");
	    	mai.setRezeptur(0);
	    	mai.setTicketNummer("");
	    	mai.setMischungNummer((String)msg.getData());
	    	mai.setActive(false);
            btActive.setSelected(mai.isActive());
            btAlle.setSelected(!mai.isActive());
	    	abfragen.add(mai);
	    	displayAbfrage();
	    	doAbfrage();
			break;
	    case MessageItem.MSG_SHOW_MISCHUNGSFENSTER_MISCHUNG:
	    	mai = new MischungsAbfrageItem(rz,msg.getCode());
	    	mai.setActive(false);
	    	abfragen.add(mai);
	    	doAbfrage();
            btActive.setSelected(mai.isActive());
            btAlle.setSelected(!mai.isActive());
			break;
	    case MessageItem.MSG_SHOW_MISCHUNGSLISTENFENSTER:
	    	if(abfragen != null) {
	    		abfragen.moveEnde();
	    	}
	    	displayAbfrage();
	    	doAbfrage();
			break;
	 	case MessageItem.MSG_ADRESSLISTE_REPLY :
			adressen = ((StichwortListe) msg.getData()).copyList();
			this.lblAdressen.setText(adressen.toVerboseString());
			if(!adressen.isEmpty()) {
				doAbfrageAction();
			}
			break;
		case MessageItem.MSG_TANKLISTE_REPLY :
			tanklisteReply((tankItem) msg.getData());
		break;
        default:
            break;
        }


    }

    @Override
	public void createActions(){
        actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT, KeyEvent.VK_F5 ,InputEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT, KeyEvent.VK_F1 ,0));
		actionList.put(String.valueOf(ACTION_CLOSE_CODE), new AuswahlAction(rz,this, ACTION_CLOSE_CODE,ACTION_CLOSE_TEXT,KeyEvent.VK_ESCAPE, 0));
		actionList.put(String.valueOf(ACTION_MISCHUNG_NEU_CODE), new AuswahlAction(rz,this, ACTION_MISCHUNG_NEU_CODE,ACTION_MISCHUNG_NEU_TEXT,KeyEvent.VK_F6, 0));
		actionList.put(String.valueOf(ACTION_MISCHUNG_DELETE_CODE), new AuswahlAction(rz,this, ACTION_MISCHUNG_DELETE_CODE,ACTION_MISCHUNG_DELETE_TEXT,0, 0));
		actionList.put(String.valueOf(ACTION_ABFRAGE_NEU_CODE), new AuswahlAction(rz,this, ACTION_ABFRAGE_NEU_CODE,ACTION_ABFRAGE_NEU_TEXT,KeyEvent.VK_N, KeyEvent.ALT_DOWN_MASK));
		actionList.put(String.valueOf(ACTION_ABFRAGE_GO_CODE), new AuswahlAction(rz,this, ACTION_ABFRAGE_GO_CODE,ACTION_ABFRAGE_GO_TEXT,0, 0));
		actionList.put(String.valueOf(ACTION_MISCHUNG_BEARBEITEN_CODE), new AuswahlAction(rz,this, ACTION_MISCHUNG_BEARBEITEN_CODE,ACTION_MISCHUNG_BEARBEITEN_TEXT,KeyEvent.VK_F2, 0));
		actionList.put(String.valueOf(ACTION_DRUCKEN_CODE), new AuswahlAction(rz,this, ACTION_DRUCKEN_CODE,ACTION_DRUCKEN_TEXT,0, 0));
		actionList.put(String.valueOf(ACTION_VORSCHAU_CODE), new AuswahlAction(rz,this, ACTION_VORSCHAU_CODE,ACTION_VORSCHAU_TEXT,0, 0));
        actionList.put(String.valueOf(ACTION_REZEPTUR_SET_CODE),new AuswahlAction(rz,this,ACTION_REZEPTUR_SET_CODE,ACTION_REZEPTUR_SET_TEXT,0,0));  
        actionList.put(String.valueOf(ACTION_REZEPTUR_RESET_CODE),new AuswahlAction(rz,this,ACTION_REZEPTUR_RESET_CODE,ACTION_REZEPTUR_RESET_TEXT,0,0)); 
		actionList.put(String.valueOf(ACTION_LISTEN_DRUCKEN_CODE), new AuswahlAction(rz,this, ACTION_LISTEN_DRUCKEN_CODE,ACTION_LISTEN_DRUCKEN_TEXT,0, 0));
		actionList.put(String.valueOf(ACTION_LISTEN_VORSCHAU_CODE), new AuswahlAction(rz,this, ACTION_LISTEN_VORSCHAU_CODE,ACTION_LISTEN_VORSCHAU_TEXT,0, 0));
		actionList.put(String.valueOf(ACTION_VERLAUF_CODE), new AuswahlAction(rz,this, ACTION_VERLAUF_CODE,ACTION_VERLAUF_TEXT,0, 0));
		actionList.put(String.valueOf(ACTION_VERLAUF_ALLE_CODE), new AuswahlAction(rz,this, ACTION_VERLAUF_ALLE_CODE,ACTION_VERLAUF_ALLE_TEXT,0, 0));
        actionList.put(String.valueOf(ACTION_SHOW_TANKLISTE_CODE),new AuswahlAction(rz,this,ACTION_SHOW_TANKLISTE_CODE,ACTION_SHOW_TANKLISTE_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_NAV_ANFANG_CODE),new AuswahlAction(rz,this,ACTION_NAV_ANFANG_CODE,ACTION_NAV_ANFANG_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_NAV_ENDE_CODE),new AuswahlAction(rz,this,ACTION_NAV_ENDE_CODE,ACTION_NAV_ENDE_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_NAV_FORWARD_CODE),new AuswahlAction(rz,this,ACTION_NAV_FORWARD_CODE,ACTION_NAV_FORWARD_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_NAV_BACK_CODE),new AuswahlAction(rz,this,ACTION_NAV_BACK_CODE,ACTION_NAV_BACK_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_NAV_X_CODE),new AuswahlAction(rz,this,ACTION_NAV_X_CODE,ACTION_NAV_X_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_STAMMBAUM_CODE),new AuswahlAction(rz,this,ACTION_STAMMBAUM_CODE,ACTION_STAMMBAUM_TEXT, 0,0));
		actionList.put(String.valueOf(ACTION_ADRESSLISTE_BEARBEITEN_CODE), new AuswahlAction(rz, this, ACTION_ADRESSLISTE_BEARBEITEN_CODE, ACTION_ADRESSLISTE_BEARBEITEN_TEXT, KeyEvent.VK_D, KeyEvent.CTRL_DOWN_MASK));
		actionList.put(String.valueOf(ACTION_ADRESSLISTE_LOESCHEN_CODE), new AuswahlAction(rz, this, ACTION_ADRESSLISTE_LOESCHEN_CODE, ACTION_ADRESSLISTE_LOESCHEN_TEXT, KeyEvent.VK_L, KeyEvent.CTRL_DOWN_MASK));
		actionList.put(String.valueOf(ACTION_CHART_CODE),new AuswahlAction(rz,this,ACTION_CHART_CODE,ACTION_CHART_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_TANKLISTE_MISCHUNG_PLAN_CODE),new AuswahlAction(rz,this,ACTION_TANKLISTE_MISCHUNG_PLAN_CODE,ACTION_TANKLISTE_MISCHUNG_PLAN_TEXT, 0,0));
    }

    
    private void tanklisteReply(tankItem ti) {
    	if(ti != null) {
    		if(txtTank.getText().trim().equals("")) {
    			txtTank.setText("^"+ti.getNummer()+"$");				
    		}else {
    			txtTank.setText(txtTank.getText().trim()+"|^"+ti.getNummer()+"$");
    		}
    		txtTank.requestFocus();
    		doAbfrageAction();
    	}
    }
    
    private void tanklisteMischungPlanAction() {
    	ArrayList<tankItem> ti = rz.getDatabase().getTank().getTankListeFromTankPattern(txtTank.getText().trim());
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_TANKAUSWAHL,false,new MessageItem(MessageItem.MSG_SHOW_TANKAUSWAHL_MISCHUNG,0,(Object)(new tankAuswahlItem(ti,this,null,null,null)),this));
    }

    
    private void chartAction() {
    	if(tblListe.getSelectedRow() != -1) {
    		MischungsHeaderItem mhi = liste.getItem(tblListe.getSelectedRow());
    		if(mhi != null) {
    			MischungsItem mi = rz.getDatabase().getMischungen().getMischung(mhi.getId());
    			if(mi != null) {
    				rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_MISCHUNG_CHART,false,new MessageItem(MessageItem.MSG_SHOW_MISCHUNG_CHART,0,mi,this));
    			}
    		}
    	}
    }
    
    private void chartDruck() {
   	 final PrinterJob job = PrinterJob.getPrinterJob();
     job.setPrintable(this);
     final PageFormat pf=new PageFormat();
     pf.setOrientation(PageFormat.PORTRAIT);
     if(job.printDialog()){
	     try{
	         job.print();
	     }
	     catch(final PrinterException pe){
	             rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "mischungslistenfenster.chart.druckenAction:" ,  pe.getLocalizedMessage());
	     	}	
     	}
     displayChart();
    }
	@Override
	public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
		if(pageIndex == 0){
            final Graphics2D g2d = (Graphics2D)graphics;
            g2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
           final int cw = chartPanel.getWidth();
           final int ch = chartPanel.getHeight();
            final double pw = pageFormat.getImageableWidth();
            final double ph = pageFormat.getImageableHeight();
            if ((cw > pw) || (ch > ph)) {
                final double scaleX = pw / cw;
                final double scaleY = ph / ch;
                final double scale = scaleX < scaleY ? scaleX : scaleY;
                g2d.scale(scale, scale);
            }
            chartPanel.printAll(g2d);
            return Printable.PAGE_EXISTS;
		} else {
			return Printable.NO_SUCH_PAGE;
        }
	}
	

    
    private void spinnerChanged() {
    	int value = (int)spChartList.getValue();
    	if(value < 1) {
    		spChartList.setValue(1);
    	}
    	if(value > rz.getOptionFactory().getOption("mischung.chart.max.list",OptionFactory.MISCHUNG_CHART_MAX_LIST)-1) {
    		spChartList.setValue(rz.getOptionFactory().getOption("mischung.chart.max.list",OptionFactory.MISCHUNG_CHART_MAX_LIST)-1);
    	}
    	if(chartPanel != null) {
    		chartPanel.setListCountMax((int)spChartList.getValue());
    		displayChart();
    		rz.getOptionFactory().setOption("mischung.chart.list",(int)spChartList.getValue());
    		rz.getOptionFactory().saveOptions();
    	}

    }
	/**
	 * den Dialog mit der Adressenliste anzeigen
	 * 
	 * 
	 */
	private void adressListeBearbeitenAction() {
		final AbfrageItem ai = new AbfrageItem();
		ai.setAdressListe(adressen.copyList());
		rz.getFensterFactory().getFensterListe().createWindow(
				FensterFactory.FENSTER_ADRESSAUSWAHL,
				true,
				new MessageItem(MessageItem.MSG_ADRESSLISTE_REQUEST, 0, ai,
						this));
	}
	private void adressenLoeschenAction() {
		adressen.clear();
		lblAdressen.setText("");
	}
    
    private void abfrageTimerEvent(){
    	if(tblListe != null) {
	        if(abfrageTimer.isRunning()) {
				abfrageTimer.stop();
		    	setActions();
			}
	    }
    }
    	

    
    private void originalLosnummerSuchen() {
    	String suche = "";
        final DialogItem di  = new DialogItem(
	                DialogControl.EINGABE_DIALOG,
	                "",0.0,
	                rz.getLocale().getString("mischungsfenster.caption_suche"),
	                rz.getLocale().getString("mischungsfenster.label_suche"),
	                "",
	                "frage.png",
	                rz.getLocale().getString("string_ok"),
	                rz.getLocale().getString("string_abbrechen"),
	                null
	        );
        rz.getDialogFactory().getDialog(di);
        if(di.getReplyCode() == DialogControl.DIALOG_OK) {
        	suche  = di.getContent().trim();
        	if(!suche.equals("")) {
        		String ret = (rz.getDatabase().getMischungen().getOriginalLosnummer(suche));
					neuAbfrageAction();
					txtTicket.setText(ret);
					doAbfrageAction();
        	}
        }
    }
    
    private void linkAction(JEditorPane txt) {
		 final Document d = txt.getDocument();
		 final HTMLDocument hd = (HTMLDocument)d;
		 final int pos = txt.viewToModel( txt.getMousePosition() );
		 if ( pos >= 0 ) {
		 	final Element e = hd.getCharacterElement(pos);
		 	if (e != null) {
		 		final SimpleAttributeSet se = (SimpleAttributeSet)e.getAttributes().getAttribute(HTML.Tag.A);
		 		if(se != null) {
		 			final String ziel = se.getAttribute(HTML.Attribute.HREF).toString();
		 			if(ziel.indexOf("mil:")!= -1) {
		 				try {
		 					String mischungen = ziel.substring(4);
		 					MischungsAbfrageItem mai = new MischungsAbfrageItem(rz,mischungen);
		 					abfragen.add(mai);
		 					displayAbfrage();
		 					doAbfrage();
		 				}catch(Exception ex) {}
		 			} else if(ziel.indexOf("mi:")!= -1) {
			 				try {
			 					int id = Integer.parseInt(ziel.substring(3));
			 					if(id != 0) {
			 		    			rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_MISCHUNG, false, new MessageItem(MessageItem.MSG_SHOW_MISCHUNGSFENSTER,id,null,this));
			 					}
			 				}catch(Exception ex) {}
			 			}
			 		}
			 	}
		 }
   }
    
    private void setActions() {

    	anzeigeTickets = new TicketListe(rz);
    	lblNav.setText(abfragen.getZeigerStr());
    	getAction(ACTION_NAV_ANFANG_CODE).setEnabled(false);
    	getAction(ACTION_NAV_ENDE_CODE).setEnabled(false);
    	getAction(ACTION_NAV_FORWARD_CODE).setEnabled(false);
    	getAction(ACTION_NAV_BACK_CODE).setEnabled(false);
    	getAction(ACTION_STAMMBAUM_CODE).setEnabled(false);
    	getAction(ACTION_CHART_CODE).setEnabled(false);
    	if(abfragen.isAnfang() && !abfragen.isEmpty()) {
    		getAction(ACTION_NAV_ANFANG_CODE).setEnabled(false);
    	}else {
    		getAction(ACTION_NAV_ANFANG_CODE).setEnabled(true);
    	}
    	if(abfragen.isEnde() && !abfragen.isEmpty()) {
    		getAction(ACTION_NAV_ENDE_CODE).setEnabled(false);
    	} else {
    		getAction(ACTION_NAV_ENDE_CODE).setEnabled(true);
    	}
    	if(!abfragen.isEmpty()) {
    		getAction(ACTION_NAV_FORWARD_CODE).setEnabled(!abfragen.isEnde());
    		getAction(ACTION_NAV_BACK_CODE).setEnabled(!abfragen.isAnfang());
    	}
  	  	getAction(ACTION_VERLAUF_CODE).setEnabled(false);
  	  	anzeigeTickets = new TicketListe(rz);
    	if(tblListe.getSelectedRow() != -1) {
        	MischungsHeaderItem mi = liste.getItem(tblListe.getSelectedRow());
        	MischungsItem mis = rz.getDatabase().getMischungen().getMischung(mi.getId());
        	if(mis != null) {
        		anzeigeTickets =(chkWarentickets.isSelected())?mis.getWarenTickets():mis.getAllTickets();
	        		getAction(ACTION_MISCHUNG_DELETE_CODE).setEnabled(false);
	        		getAction(ACTION_MISCHUNG_BEARBEITEN_CODE).setEnabled(false);
	            	getAction(ACTION_STAMMBAUM_CODE).setEnabled(true);
	          	  	getAction(ACTION_DRUCKEN_CODE).setEnabled(true);
	          	  	getAction(ACTION_VORSCHAU_CODE).setEnabled(true);
	        		if(rz.getDatabase().getMischungen().canDeleteMischung(mis)) {
	        			getAction(ACTION_MISCHUNG_DELETE_CODE).setEnabled(true);
	        		} else {
		        		getAction(ACTION_MISCHUNG_DELETE_CODE).setEnabled(false);		
	        		}
	        		if(mi.getLosnummer().equals("")) {
	        	  	  	getAction(ACTION_VERLAUF_CODE).setEnabled(false);
	        		}else {
	        	  	  	getAction(ACTION_VERLAUF_CODE).setEnabled(true);
	        		}
	        		getAction(ACTION_MISCHUNG_BEARBEITEN_CODE).setEnabled(true);
	            	getAction(ACTION_CHART_CODE).setEnabled(true);
        	}
        } else {
      	  	getAction(ACTION_DRUCKEN_CODE).setEnabled(false);
      	  	getAction(ACTION_VORSCHAU_CODE).setEnabled(false);
        }
    	if(liste.size() == 0) {
      	  	getAction(ACTION_LISTEN_DRUCKEN_CODE).setEnabled(false);
      	  	getAction(ACTION_LISTEN_VORSCHAU_CODE).setEnabled(false);
    	}else {
      	  	getAction(ACTION_LISTEN_DRUCKEN_CODE).setEnabled(true);
      	  	getAction(ACTION_LISTEN_VORSCHAU_CODE).setEnabled(true);
    	}
        ((AbstractTableModel)tblAnzeige.getModel()).fireTableDataChanged();
    	setSummenLabel();
    	if(showChart) {
    		displayChart();
    	}
    	
    }
    
    private void setSummenLabel(){
    	double summe = 0;
    	for(int i=0;i<liste.size();i++){
    		summe +=((MischungsHeaderItem)liste.getItem(i)).getLa(); 
    	}
    	lblListe.setText(rz.getLocale().getString("mischungsfenster.label_summe")
    			.replaceAll("%n", String.valueOf(liste.size()))
    			.replaceAll("%l", rz.getLocale().formatNumber(summe, OptionFactory.NF_NORMAL))
    			);
    }
    
    private void rezepturSetAction() {
		int x, y;
		x = (int) (btRezeptur.getLocationOnScreen().getX());
		y = (int) (btRezeptur.getLocationOnScreen().getY());
		if (zd != null) {
			zd.dispose();
			zd = null;
		}
		String r = lblRezeptur.getText().trim();
		if(r.indexOf("(")!= -1) {
			r = r.substring(0, r.indexOf("("));
		}
		final ZutatenDialog zd = new ZutatenDialog(this, rz, x, y, r,ZutatenDialog.MODE_REZEPTUREN);
		zd.setVisible(true);
}

private void rezepturSetReply(ZutatenSuchItem zi) {
	if(zi != null) {
		rezeptur_id = zi.getID();
		rezepturBezeichnung = zi.getName();
    	lblRezeptur.setText(rz.getLocale().getString("mischungeingabe.label_rezeptur")
    			.replaceAll("%s", rezepturBezeichnung)
    			.replaceAll("%n",String.valueOf(zi.getID()))
    		);
	}
	if(rezeptur_id != 0) {
		doAbfrageAction();
	}
}

private void stammbaumAction() {
	if(tblListe.getSelectedRow()!=-1) {
		MischungsHeaderItem mih = liste.getItem(tblListe.getSelectedRow());
		if(mih != null) {
			MischungsItem mi = rz.getDatabase().getMischungen().getMischung(mih.getId());
			if(mi != null) {
				rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_STAMMBAUM,false,new MessageItem(MessageItem.MSG_SHOW_STAMMBAUM,0,mi,this));
			}
		}
	}
}

private void showTankListeAction() {
	rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_TANKLISTE,true,new MessageItem(MessageItem.MSG_SHOW_TANKLISTE,0,this,this));
}

private void verlaufAlleAction() {
	String losnummern = "";
	for(int i = 0;i < liste.size();i++) {
		MischungsHeaderItem mhi = liste.getItem(i);
		if(mhi != null && !mhi.getLosnummer().equals("")) {
			losnummern += "^" + mhi.getLosnummer()+"$|";
		}
	}
	if(losnummern.endsWith("|"))losnummern = losnummern.substring(0,losnummern.length()-1);
	if(!losnummern.equals("")) {
			rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_VERLAUF,false,new MessageItem(MessageItem.MSG_SHOW_HISTORY,0,losnummern,this));
	}
}

	private void verlaufAction() {
		if(tblListe.getSelectedRow()!=-1) {
			MischungsHeaderItem mih = liste.getItem(tblListe.getSelectedRow());
			if(mih != null) {
				rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_VERLAUF,false,new MessageItem(MessageItem.MSG_SHOW_HISTORY,0,"^" +mih.getLosnummer()+ "$",this));		
			}
		}
	}

	private void rezepturResetAction() {
		rezeptur_id = 0;
		rezepturBezeichnung  ="";
		lblRezeptur.setText(rz.getLocale().getString("mischungeingabe.label_rezeptur_leer"));
		doAbfrageAction();
	}
    private void druckenAction(boolean vorschau) {
    	if(tblListe.getSelectedRow() != -1) {
    		MischungsHeaderItem mhi = liste.getItem(tblListe.getSelectedRow());
    		if(mhi != null) {
    			MischungsItem mi = rz.getDatabase().getMischungen().getMischung(mhi.getId());
    			if(mi != null) {
    				rz.getReportFactory().mischungDrucken(mi, vorschau, this,chkDuplexMischung.isSelected());
    			}
    		}
    	}
    }
    
    private void listeClicked() {
    	if(tblListe.getSelectedRow()!=-1) {
    		MischungsHeaderItem mhi = liste.getItem(tblListe.getSelectedRow());
    		if(mhi != null) {
    			switch(tblListe.getSelectedColumn()) {
    				case C_TANK: 
                   		ArrayList<tankItem> ti = rz.getDatabase().getTank().getTankListeFromTankPattern(mhi.getTank());
                        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_TANKAUSWAHL,false,new MessageItem(MessageItem.MSG_SHOW_TANKAUSWAHL,0,(Object)(new tankAuswahlItem(ti,this,null,null,null)),this));
    					break;
    			}
    		}
    	}
    }
    
    private void listenDruckAction(boolean vorschau) {
    	if(liste != null && !liste.isEmpty()) {
    		ReportItem ri = (ReportItem)cmbListendruck.getSelectedItem();
    		if(ri != null) {
    			if(ri.getName().equals(DBFactory.FIELD_2_2_0_22)) {
    	        	int sel=0;
    	        	try {
    	        		sel=liste.getItem(tblListe.getSelectedRow()).getId();
    	        	}catch (Exception e) {}
    				liste.sortSorteForward();
                    ((AbstractTableModel)tblListe.getModel()).fireTableDataChanged();
                    if(sel != 0 ) {
    		        	for(int i=0;i<liste.size();i++) {
    		        		if(liste.getItem(i).getId() == sel) {
    		        			tblListe.getSelectionModel().setSelectionInterval(i,i);
    		        	        tblListe.scrollRectToVisible(tblListe.getCellRect(i, 0,true));
    		        			break;
    		        		}
    		        	}
    		        }
    			}
    		}
			rz.getReportFactory().mischungsListeDrucken(liste, vorschau, this,chkDuplexListe.isSelected());
    	}
    }
    
    
    private void neuAbfrageAction() {
    	btDatumNone.setSelected(true);
    	datumSelection();
    	txtMischungsNummer.setText("");
    	txtMischungsBezeichnung.setText("");
    	txtTank.setText("");
    	txtTicket.setText("");
    	btActive.setSelected(true);
    	btAlle.setSelected(false);
    	txtLosnummer.setText("");
    	txtAktionen.setText("");
    	rezeptur_id=0;
    	rezepturBezeichnung="";
        lblRezeptur.setText(rz.getLocale().getString("mischungeingabe.label_rezeptur_leer"));
        txtTank.requestFocus();
        adressen.clear();
        lblAdressen.setText("");
    }
    
       
    private void doAbfrageAction() {
    	MischungsAbfrageItem mai = new MischungsAbfrageItem(rz,"");
    	if(btDatumNone.isSelected()) {
    		mai.setDateMode(MischungsAbfrageItem.DATE_NONE);
    	}else if(btDatumErstellt.isSelected()) {
    		mai.setDateMode(MischungsAbfrageItem.DATE_ERSTELLT);
    	} else if(btDatumGeaendert.isSelected()) {
    		mai.setDateMode(MischungsAbfrageItem.DATE_GEAENDERT);
    	}
    	mai.setVonJahr(picker.getLocalDate1().getYear());
    	mai.setVonMonat(picker.getLocalDate1().getMonthValue()-1);
    	mai.setVonTag(picker.getLocalDate1().getDayOfMonth());
    	mai.setBisJahr(picker.getLocalDate2().getYear());
    	mai.setBisMonat(picker.getLocalDate2().getMonthValue()-1);
    	mai.setBisTag(picker.getLocalDate2().getDayOfMonth());
    	mai.setMischungNummer(txtMischungsNummer.getText().trim());
    	mai.setMischungBezeichnung(txtMischungsBezeichnung.getText().trim());
    	mai.setTank(txtTank.getText().trim());
    	mai.setTicketNummer(txtTicket.getText().trim());
    	mai.setActive(btActive.isSelected());
    	mai.setLosnummer(txtLosnummer.getText().trim());
    	mai.setRezeptur(rezeptur_id);
    	mai.setAktionen(txtAktionen.getText().trim());
    	mai.setAdressen(adressen);
		abfragen.add(mai);
    	doAbfrage();
    }
    
    private void doAbfrage() {
    	rz.setWaitCursor(this);
    	MischungsAbfrageItem mai = abfragen.getCurrent();
    	if(mai != null) {
    		lblNav.setText(abfragen.getZeigerStr());
    		liste = rz.getDatabase().getMischungen().getMischungsListe(mai);
        	if(liste != null) {
                ((AbstractTableModel)tblListe.getModel()).fireTableDataChanged();
                tblListe.getSelectionModel().setSelectionInterval(liste.size()-1,liste.size()-1);
    	        tblListe.scrollRectToVisible(tblListe.getCellRect(liste.size()-1, 0,true));
        	} 
    		setActions();
    	}
    	saveLast();
    	rz.setFreeCursor(this);
    }
    
    private void displayAbfrage() {
    	MischungsAbfrageItem mai = abfragen.getCurrent();
    	if(mai != null) {
    		datum1 = Calendar.getInstance();
    		datum2 = Calendar.getInstance();
    		switch(mai.getDateMode()) {
    			case MischungsAbfrageItem.DATE_NONE: btDatumNone.setSelected(true);break;
    			case MischungsAbfrageItem.DATE_ERSTELLT: btDatumErstellt.setSelected(true);break;
    			case MischungsAbfrageItem.DATE_GEAENDERT: btDatumGeaendert.setSelected(true);break;
    		}
    		datum1.set(Calendar.YEAR, mai.getVonJahr());
    		datum1.set(Calendar.MONTH, mai.getVonMonat());
    		datum1.set(Calendar.DAY_OF_MONTH, mai.getVonTag());
    		datum2.set(Calendar.YEAR, mai.getBisJahr());
    		datum2.set(Calendar.MONTH, mai.getBisMonat());
    		datum2.set(Calendar.DAY_OF_MONTH, mai.getBisTag());
            adressen = mai.getAdressen();
            lblAdressen.setText(adressen.toVerboseString());
            txtMischungsNummer.setText(mai.getMischungNummer());
            txtMischungsBezeichnung.setText(mai.getMischungBezeichnung());
            txtTank.setText(mai.getTank());
            txtTicket.setText(mai.getTicketNummer());
            txtAktionen.setText(mai.getAktionen());
            btActive.setSelected(mai.isActive());
            btAlle.setSelected(!mai.isActive());
            txtLosnummer.setText(mai.getLosnummer());
            if(!btDatumNone.isSelected()) {
            	picker.setComponentsEnabled(pickerPanel, true);
            }else {
            	picker.setComponentsEnabled(pickerPanel, false);
            }
            if(mai.getRezeptur()==0) {
                lblRezeptur.setText(rz.getLocale().getString("mischungeingabe.label_rezeptur_leer"));
            }else {
            	try {
            		lblRezeptur.setText(rz.getDatabase().getRezeptur().dbGetRezepturName(rezeptur_id)
                			.replaceAll("%s", rezepturBezeichnung)
                			.replaceAll("%n",String.valueOf(rezeptur_id))
                		);
            	}catch(Exception e) {}
            }
    	}
    }
    
    private void datumSelection() {
        if(!btDatumNone.isSelected()) {
        	picker.setComponentsEnabled(pickerPanel, true);
        }else {
        	picker.setComponentsEnabled(pickerPanel, false);
        }
        setDatum();
    }
    
    private void saveDividerLocations(){
        rz.getFensterFactory().setOption(this.getName() + ".spl1", this.spl1.getDividerLocation());
        rz.getFensterFactory().setOption(this.getName() + ".splAnzeige", this.splAnzeige.getDividerLocation());
        rz.getFensterFactory().saveOptions();
    }
    private void setDividerLocations() {
        spl1.setDividerLocation(rz.getFensterFactory().getOption(this.getName() + ".spl1",this.getWidth()/2));
        splAnzeige.setDividerLocation(rz.getFensterFactory().getOption(this.getName() + ".splAnzeige",this.getHeight()/2));
    }
    

    private void setDatum() {
        	doAbfrageAction();
    }
    
    private void typAuswahlAction(){
    		doAbfrageAction();
   }

    private void mischungNeuAction() {
    	rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_MISCHUNG_EINGABE, false, new MessageItem(MessageItem.MSG_SHOW_MISCHUNG_EINGABE_TANK,0,null,this));
    }
    
    private void mischungDeleteAction() {
    	if(tblListe.getSelectedRow() != -1) {
    		MischungsHeaderItem mhi = liste.getItem(tblListe.getSelectedRow());
    		if(mhi != null) {
    			final DialogItem di  = new DialogItem(
		                    DialogControl.FRAGE_DIALOG,
		                    "",0.0,
		                    rz.getLocale().getString("mischungslistenfenster.dialog_mischung_delete"),
		                    rz.getLocale().getString("mischungslistenfenster.dialog_mischung_delete"),
		                    rz.getLocale().getString("mischungslistenfenster.dialog_mischung_delete_text")
		                    	.replaceAll("%s",mhi.getBezeichnung())
		                    	.replaceAll("%n", String.valueOf(mhi.getId())),
		                    "frage.png",
		                    rz.getLocale().getString("string_ja"),
		                    rz.getLocale().getString("string_nein"),
		                    this
						);
		         rz.getDialogFactory().getDialog(di);
		         if ((di.getReplyCode() == DialogControl.DIALOG_YES) || (di.getReplyCode() == DialogControl.DIALOG_OK)){
			    		if(rz.getDatabase().getMischungen().deleteMischungTransaction(mhi.getId())) {
			    			doAbfrageAction();
			    		}else {
			    		 	DialogItem di1  = new DialogItem(
			    	                DialogControl.HINWEIS_DIALOG,
			    	                "",0.0,
			    	                rz.getLocale().getString("mischungslistenfenster.dialog_cannot_delete"),
			    	                rz.getLocale().getString("mischungslistenfenster.dialog_cannot_delete"),
			    	                rz.getLocale().getString("mischungslistenfenster.dialog_cannot_delete_text")
			    	                	.replaceAll("%n",String.valueOf(mhi.getId()))
			    	                	.replaceAll("%s", mhi.getBezeichnung())
			    	                ,
			    	                "warnung.png",
			    	                rz.getLocale().getString("string_ok"),
			    	                "",
			    	                this
			    	        );
			    	        rz.getDialogFactory().getDialog(di1);
			    		}
		         }
	    	}
    	}
    }
    
    private void mischungBearbeitenAction() {
	    	if(tblListe.getSelectedRow() != -1) {
	    		MischungsHeaderItem mhi = liste.getItem(tblListe.getSelectedRow());
	    		if(mhi != null) {
	    			rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_MISCHUNG, false, new MessageItem(MessageItem.MSG_SHOW_MISCHUNGSFENSTER,mhi.getId(),null,this));
	    		}
	    	}
    }
    
    
    private void displayChart() {
    	if(chkChart.isSelected()) {
	    	if(liste != null &&  !liste.isEmpty()) {
		    	MischungsHeaderItem mi = liste.getItem(tblListe.getSelectedRow());
		    	MischungsItem mis = rz.getDatabase().getMischungen().getMischung(mi.getId());
		    	if(chartPanel != null && mis != null) {
		    		chartPanel.setData(mis,txtLimit.getValue());
		    		chartPanel.repaint();
		    	}
	    	}else {
	    		chartPanel.setData(null,0);
	    		chartPanel.repaint();	
	    	}
    	}
    }
    

    
    private void saveLast() {
    	rz.getDatabase().getMischungen().saveMischungsAbfrageListe(abfragen);
    }
    
   
    @Override
	public void closeWindow(){
    	saveLast();
    	saveDividerLocations();
    	rz.getFensterFactory().getFensterListe().disposeFrame(this);
    }
    @Override
	public void openWindow(){
		if (!isVisible()) {
			setVisible(true);
		}
		toFront();
		txtTank.requestFocus();
    }

	//hilfe
	private void hilfeAction() {
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"mischungsfenster.html",this));
	}

    private void hideAction() {
        rz.getFensterFactory().getFensterListe().sperren(this);
    }

    
    
    
    private void settblAnzeigeModel(JTable t) {
	    final anzeigeColumnModel rcm = new anzeigeColumnModel();
	    final StringRendererAnzeige sr = new StringRendererAnzeige();
	    TableColumn tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("mischungsfenster.tableheader_ct_typ"));
	    	tc.setModelIndex(CT_TYP);
	    	tc.setCellRenderer(sr);
	    rcm.addColumn(tc);
	    tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("mischungsfenster.tableheader_ct_nummer"));
	    	tc.setModelIndex(CT_NUMMER);
	    	tc.setCellRenderer(sr);
	    rcm.addColumn(tc);
	    tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("mischungsfenster.tableheader_ct_aktion"));
	    	tc.setModelIndex(CT_AKTION);
	    	tc.setCellRenderer(sr);
	    rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("mischungsfenster.tableheader_ct_bezeichnung"));
			tc.setModelIndex(CT_BEZEICHNUNG);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("mischungsfenster.tableheader_ct_la"));
			tc.setModelIndex(CT_LA);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("mischungsfenster.tableheader_ct_staerke"));
			tc.setModelIndex(CT_STAERKE);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("mischungsfenster.tableheader_ct_anteil"));
			tc.setModelIndex(CT_ANTEIL);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("mischungsfenster.tableheader_ct_original_losnummer"));
			tc.setModelIndex(CT_ORIGINAL_LOSNUMMER);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("mischungsfenster.tableheader_ct_erstellt"));
			tc.setModelIndex(CT_ERSTELLT);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("mischungsfenster.tableheader_ct_geaendert"));
			tc.setModelIndex(CT_GEAENDERT);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("mischungsfenster.tableheader_ct_bemerkungen"));
			tc.setModelIndex(CT_BEMERKUNGEN);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("mischungsfenster.tableheader_ct_proben"));
			tc.setModelIndex(CT_PROBEN);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("mischungsfenster.tableheader_ct_mischungen"));
			tc.setModelIndex(CT_MISCHUNGEN);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
        rcm.addColumnModelListener(this);
        t.setModel(new anzeigeTableModel());
        t.setColumnModel(rcm);
        t.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
        t.getTableHeader().setReorderingAllowed(false);
        rz.setPreferredRowHeights(t);
        TableModelListener l = new TableModelListener() {
			public void tableChanged(TableModelEvent e) {
		         SwingUtilities.invokeLater(new Runnable() {
		              public void run() {
		                  rz.setPreferredRowHeights(tblAnzeige);
		              }
		         });
			}
	     }; 
	     t.getModel().addTableModelListener(l);
	}
    
    
    private void settblListenModel(JTable t) {
	    final listenColumnModel rcm = new listenColumnModel();
	    final StringRenderer sr = new StringRenderer();
	    TableColumn tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("mischungsfenster.tableheader_status"));
	    	tc.setModelIndex(C_STATUS);
	    	tc.setCellRenderer(sr);
	    rcm.addColumn(tc);
	    tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("mischungsfenster.tableheader_nummer"));
	    	tc.setModelIndex(C_NUMMER);
	    	tc.setCellRenderer(sr);
	    rcm.addColumn(tc);
	    tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("mischungsfenster.tableheader_bezeichnung"));
	    	tc.setModelIndex(C_BEZEICHNUNG);
	    	tc.setCellRenderer(sr);
	    rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("mischungsfenster.tableheader_sorte"));
			tc.setModelIndex(C_SORTE);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("mischungsfenster.tableheader_tank"));
			tc.setModelIndex(C_TANK);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("mischungsfenster.tableheader_la"));
			tc.setModelIndex(C_LA);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("mischungsfenster.tableheader_losnummer"));
			tc.setModelIndex(C_LOSNUMMER);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("mischungsfenster.tableheader_adressen"));
			tc.setModelIndex(C_ADRESSEN);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);		
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("mischungsfenster.tableheader_erstellt"));
			tc.setModelIndex(C_ERSTELLT);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("mischungsfenster.tableheader_geaendert"));
			tc.setModelIndex(C_GEAENDERT);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
	    tc = new TableColumn();
			tc.setHeaderValue(rz.getLocale().getString("mischungsfenster.tableheader_abgeschlossen"));
			tc.setModelIndex(C_ABGESCHLOSSEN);
			tc.setCellRenderer(sr);
		rcm.addColumn(tc);
        rcm.addColumnModelListener(this);
        tblListe.setModel(new listenTableModel());
        tblListe.setColumnModel(rcm);
        tblListe.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
        tblListe.getTableHeader().setReorderingAllowed(false);
	}

    
	private class anzeigeColumnModel extends DefaultTableColumnModel{
	    public anzeigeColumnModel() {
	        super();
	    }
	}
    
	private class listenColumnModel extends DefaultTableColumnModel{
	    public listenColumnModel() {
	        super();
	    }
	}
    
	private  class listenTableModel extends AbstractTableModel    {

        SimpleDateFormat df;

        public listenTableModel() {
        	try {
        	}catch (Exception e) {
        	}
            df = new SimpleDateFormat("dd.MM.yyyy");
        }

	   public int getColumnCount() {
	       	return C_MAX;
        }
        public int getRowCount() {
        	if(liste != null) {
                return liste.size();
        	} else {
        		return 0;
        	}
        }

        public MischungsHeaderItem getZeileAt(int rowIndex) {
        	if((rowIndex != -1) && (liste != null)) {
        		return liste.getItem(rowIndex);
        	} else {
				return null;
			}
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            Object ret = null;
            if((rowIndex != -1) && (liste != null)) {
                ret = getContent(liste.getItem(rowIndex),columnIndex,rowIndex);
            }
            return ret;
        }

        private Object getContent(MischungsHeaderItem mhi,int aColumn,int row) {
            Object ret = null;
            if(mhi != null) {
	            switch(aColumn){
	            	case C_STATUS:
	            		ret = "";
	            		break;
	            	case C_NUMMER:
	            		ret = String.valueOf(mhi.getId());
	            		break;
	            	case C_BEZEICHNUNG:
	            	    ret = mhi.getBezeichnung();
	            	    break;
	            	case C_TANK:
	            		ret = mhi.getTank();
	            		break;
	            	case C_LA:
	            		ret =rz.getLocale().formatNumber( mhi.getLa(),OptionFactory.NF_ONE);;
	            		break;
	            	case C_ADRESSEN:
	            		ret = mhi.getAdressen().toVerboseString();
	            		break;
	            	case C_LOSNUMMER:
	            		ret = mhi.getLosnummer();
	            		break;
	            	case C_ERSTELLT: 
	            		ret = df.format(mhi.getErstellt());
	            		break;
	            	case C_GEAENDERT:
	            		ret = df.format(mhi.getGeaendert());
	            		break;
	            	case C_SORTE:
	            		ret =mhi.getSorte().getBezeichnung();
	            		break;
	            	case C_ABGESCHLOSSEN:
	            		if(!mhi.isActive()) {
	            			ret = df.format(mhi.getAbgeschlossen());
	            		} else {
	            			ret = "";
	            		}
	            		break;
	            }
            }
            return ret;
        }
	}
	
	private  class anzeigeTableModel extends AbstractTableModel    {
        SimpleDateFormat df;
        
        public anzeigeTableModel() {
        	try {
        	}catch (Exception e) {
        	}
            df = new SimpleDateFormat("dd.MM.yyyy");
        }

	   public int getColumnCount() {
	       	return CT_MAX;
        }
        public int getRowCount() {
        	if(anzeigeTickets != null) {
                return anzeigeTickets.size();
        	} else {
        		return 0;
        	}
        }

        public MischungsHeaderItem getZeileAt(int rowIndex) {
        	if((rowIndex != -1) && (anzeigeTickets != null)) {
        		return liste.getItem(rowIndex);
        	} else {
				return null;
			}
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            Object ret = null;
            if((rowIndex != -1) && (anzeigeTickets != null)) {
                ret = getContent(anzeigeTickets.get(rowIndex),columnIndex,rowIndex);
            }
            return ret;
        }

        private Object getContent(TicketItem ti,int aColumn,int row) {
            Object ret = null;
            if(ti != null) {
	            switch(aColumn){
	            	case CT_TYP:
	            		ret = rz.getDatabase().getMischungen().getTicket(ti.getTyp()).getText();
	            		break;
	            	case CT_NUMMER:ret =ti.getNummer();
	            		break;
	            	case CT_AKTION: ret = String.valueOf(ti.getTransaktion());
	            		break;
	            	case CT_BEZEICHNUNG: ret =  "<html>"+ti.getBezeichnung()+"</html>";
	            		break;
	            	case CT_ORIGINAL_LOSNUMMER:ret = ti.getLosnummer_original();
	            		break;
	            	case CT_ERSTELLT: ret = ti.getErstelltToString() + "/"+ti.getErstellt_user();
	            		break;
	            	case CT_GEAENDERT: ret = ti.getGeaendertToString()+ "/"+ti.getGeaendert_user();
	            		break;
	            	case CT_BEMERKUNGEN: ret = "<html>" + ti.getBemerkungen().replaceAll("\\n", "<br>") + "</html>";
	            		break;
	            	case CT_LA: ret = rz.isZero(ti.getLa()) ? "" :rz.getLocale().formatNumber(ti.getLa(), OptionFactory.NF_NORMAL);
	            		break;
	            	case CT_STAERKE: ret = rz.isZero(ti.getStaerke()) ? "": rz.getLocale().formatNumber(ti.getStaerke(), OptionFactory.NF_STAERKE);
	            		break;
	            	case CT_ANTEIL:
	            		if(ti.getTyp() == TicketItem.TYP_WARE || ti.getTyp() == TicketItem.TYP_ENTNAHME) {
	            			ret = (ti.getTyp() == TicketItem.TYP_WARE)?	rz.getLocale().formatNumber(ti.getPercentage(), OptionFactory.NF_NORMAL):	rz.getLocale().formatNumber(ti.getNegativePercentage(), OptionFactory.NF_NORMAL);
	            		} else {
	            			ret="";
	            		}
	            	
            		break;	            		
	            	case CT_PROBEN:ret = ti.getProbe() == 0?"":String.valueOf(ti.getProbe());
	            		break;
	            	case CT_MISCHUNGEN:if(chkMischungen.isSelected()) {
	            			ret = "<html>" +  rz.getDatabase().getMischungen().getmischungenFromTicketNummerHTML(ti.getMischung(),ti.getNummer(),false) + "</html>";
	            		} else {
	            			ret = "";
	            		}
	            		break;
	            		
	            }
            }
            return ret;
        }
	}
	
	
	private class StringRendererAnzeige extends DefaultTableCellRenderer {
		ImageIcon probe;
	    StringRendererAnzeige() {
	        super();
	        probe = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/herstellfenster.icon_probe.png"));
	        setOpaque(true);
	        
	    }
	    public Component getTableCellRendererComponent(JTable table,
                Object value, boolean isSelected, boolean hasFocus, int row,
                int column)
	    {
	    	setIcon(null);
	    	TicketItem ti = anzeigeTickets.get(row);
	    	if(ti != null) {
	    		setForeground(Color.BLACK);
	    		setBackground(Color.WHITE);
	    		if(column == CT_TYP) {
	    			setIcon((ImageIcon)rz.getDatabase().getMischungen().getTicket(ti.getTyp()).getIcon());
	    		}
	    		if(column == CT_PROBEN && ti.getProbe() != 0) {
	    			setIcon(probe);
	    		}
	    		if(ti.getTyp()==TicketItem.TYP_WARE) {
	    			setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_BESTAND_GRUEN));
	    		}
	    		if(ti.getTyp() == TicketItem.TYP_ENTNAHME) {
	    			setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_BESTAND_ROT));
	    		}
	    		if(ti.getTyp()==TicketItem.TYP_ENTSPERRT) {
	    			setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_GREEN));
	    		}
	    		if(ti.getTyp() == TicketItem.TYP_GESPERRT) {
	    			setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_RED));
	    			setForeground(Color.WHITE);
	    		}
	    	}
	    	if(isSelected) {
    			setFont(rz.getFontFactory().getTableBoldFont());
    		}else {
    			setFont(rz.getFontFactory().getTableFont());
    		}
	    	setText((String)value);
	        return this;
        }
	}
	
	
	private class StringRenderer extends DefaultTableCellRenderer {
		Icon active,inactive;
	    StringRenderer() {
	        super();
	        active = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/mischung.icon_active.png"));
	        inactive = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/mischung.icon_inactive.png"));
	        setOpaque(true);
	        
	    }
	    public Component getTableCellRendererComponent(JTable table,
                Object value, boolean isSelected, boolean hasFocus, int row,
                int column)
	    {
	    	setIcon(null);
	    	setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_BESTAND_WHITE));
	    	MischungsHeaderItem mi = liste.getItem(row);
	    	if(mi != null) {
	    		if(column == C_STATUS ) {
		    		if(mi.isActive()){
	    				setIcon(active);
	    			} else {
	    				setIcon(inactive);
	    			}	
	    		}
	    		setForeground(Color.BLACK);
	    		if(column == C_TANK) {
	    			setForeground(Color.BLUE);
	    		}
	    		if(isSelected) {
	    			setFont(rz.getFontFactory().getTableBoldFont());
	    		}else {
	    			setFont(rz.getFontFactory().getTableFont());
	    		}
		    	if(mi.isActive()){
		    		setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_BESTAND_GRUEN));
		    	}else {
		    		setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_BESTAND_ROT));
		        }
	    	}
	    	setText((String)value);
	        return this;
        }
	}
	
	@Override
	public void columnAdded(TableColumnModelEvent arg0) {}
	@Override
	public void columnMarginChanged(ChangeEvent arg0) {}
	@Override
	public void columnMoved(TableColumnModelEvent arg0) {}
	@Override
	public void columnRemoved(TableColumnModelEvent arg0) {}
	@Override
	public void columnSelectionChanged(ListSelectionEvent arg0) {}
    
	public class ColumnHeaderListener extends MouseAdapter {
	    public void mouseClicked(MouseEvent evt) {
	        JTable table = ((JTableHeader)evt.getSource()).getTable();
	        TableColumnModel colModel = table.getColumnModel();

	        int vColIndex = colModel.getColumnIndexAtX(evt.getX());
	        // Return if not clicked on any column header
	        if (vColIndex == -1) {
	            return;
	        }
	        // Determine if mouse was clicked between column heads
	        Rectangle headerRect = table.getTableHeader().getHeaderRect(vColIndex);
	        if (vColIndex == 0) {
	            headerRect.width -= 3;    // Hard-coded constant
	        } else {
	            headerRect.grow(-3, 0);   // Hard-coded constant
	        }
	        if (!headerRect.contains(evt.getX(), evt.getY())) {
	            // Mouse was clicked between column heads
	            // vColIndex is the column head closest to the click

	            // vLeftColIndex is the column head to the left of the click
	            if (evt.getX() < headerRect.x) {
	                vColIndex--;
	            }
	        }
	        if(liste != null && liste.size()>0) {
	        	int sel=0;
	        	try {
	        		sel=liste.getItem(tblListe.getSelectedRow()).getId();
	        	}catch (Exception e) {}
		        switch(vColIndex) {
		            case C_STATUS:
		            	break;
		            case C_NUMMER:
		            	liste.sortID();
		            	break;
		            case C_BEZEICHNUNG:
		            	liste.sortBezeichnung();
		            	break;
		            case C_SORTE:
		            	liste.sortSorte();
		            	break;
		            case C_TANK:
		            	liste.sortTank();
		            	break;
		            case C_ERSTELLT:
		            	liste.sortErstellt();
		            	break;
		            case C_GEAENDERT:
		            	liste.sortGeaendert();
		            	break;
		        }
                ((AbstractTableModel)tblListe.getModel()).fireTableDataChanged();
		        if(sel != 0 ) {
		        	for(int i=0;i<liste.size();i++) {
		        		if(liste.getItem(i).getId() == sel) {
		        			tblListe.getSelectionModel().setSelectionInterval(i,i);
		        	        tblListe.scrollRectToVisible(tblListe.getCellRect(i, 0,true));
		        			break;
		        		}
		        	}
		        }
	        }
	    }
	}


    
}
