/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/*
 * db ist die zentrale Schnittstelle zur Datenbank. Hier wird die Verbindung
 * zur Datenbank aufgebaut, abgebaut und alle Datentransfers laufen �ber
 * diese Klasse. Keine andere Klasse im Programm nimmt eigenst�ndige
 * Verbindungen zur Datenbank auf
 *
 */


package de.lunqual.rzpro.fenster.notizfenster;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;

import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.SwingConstants;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.database.DBAbfrage;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fenster.JRzList;
import de.lunqual.rzpro.fenster.JRzTextPane;
import de.lunqual.rzpro.fenster.JSelectedTextField;
import de.lunqual.rzpro.fenster.dialoge.DialogControl;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.abfrage.AbfrageItem;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.items.ergebnis.ErgebnisItem;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.rezeptur.ChangesListe;
import de.lunqual.rzpro.items.rezeptur.NotizItem;
import de.lunqual.rzpro.items.stichworte.StichwortItem;
import de.lunqual.rzpro.items.stichworte.StichwortListe;
import de.lunqual.rzpro.options.OptionFactory;
/**
 *
 * @author  administrator
 */
public class NotizFenster extends JRzFrame {

    //GUI-Variablen
    private JMenuBar mb;
    private JMenu mnuDatei;
    private JMenu mnuBearbeiten;
    private JMenu mnuExtras;
    private JMenu mnuHilfe;

    private JPanel mainPanel;
    	private JPanel toolbarPanel;
    		private JToolBar tb1;
    	private JPanel contentPanel;
    		private JPanel leftPanel;
    			private JPanel topPanel;
	    			private JLabel lblAdresslisteTitel;
	    			private JScrollPane scrAdressen;
	    				private JRzList lstAdressen;
	    			private JPanel adressButtonPanel;
	    		    	private JButton btAdressenBearbeiten;
	    		    	private JButton btAdresslisteLoeschen;
		    	private JPanel downPanel;
    				private JLabel lblStichwortlisteTitel;
    				private JScrollPane scrStichworte;
    					private JRzList lstStichworte;
    				private JPanel stichwortButtonPanel;
    			    	private JButton btStichworteBearbeiten;
    			    	private JButton btStichworteLoeschen;
    		private JPanel rightPanel;
    			private JPanel namePanel;
    				private JLabel lblName;
    				private JSelectedTextField txtTitel;
    				private JButton btMusternummer;
    			private JScrollPane scrText;
    				private JRzTextPane txtComment;
    	private JPanel buttonPanel;
    		private JPanel buttonTopPanel;
    			private JLabel lblErstellt;
    			private JLabel lblGeaendert;
    		private JPanel buttonDownPanel;
    			private JButton btOK;
    			private JButton btHilfe;
    			private JButton btCancel;

    // ActionCodes NotizFenster
    public static final int         ACTION_OK_CODE = 1000;
    public static final String      ACTION_OK_TEXT = "notiz.action_ok";
    public static final int         ACTION_ABBRECHEN_CODE = 1001;
    public static final String      ACTION_ABBRECHEN_TEXT = "notiz.action_abbrechen";
    public static final int         ACTION_ADRESSLISTE_BEARBEITEN_CODE = 1002;
    public static final String      ACTION_ADRESSLISTE_BEARBEITEN_TEXT = "notiz.action_adressliste_bearbeiten";
    public static final int         ACTION_ADRESSLISTE_LOESCHEN_CODE = 1003;
    public static final String      ACTION_ADRESSLISTE_LOESCHEN_TEXT = "notiz.action_adressliste_loeschen";
    public static final int         ACTION_STICHWORTLISTE_BEARBEITEN_CODE = 1004;
    public static final String      ACTION_STICHWORTLISTE_BEARBEITEN_TEXT = "notiz.action_stichwortliste_bearbeiten";
    public static final int         ACTION_STICHWORTLISTE_LOESCHEN_CODE = 1005;
    public static final String      ACTION_STICHWORTLISTE_LOESCHEN_TEXT = "notiz.action_stichwortliste_loeschen";
    public static final int         ACTION_HIDE_CODE = 1006;
    public static final String      ACTION_HIDE_TEXT = "action_hide";
    public static final int         ACTION_HILFE_CODE = 1007;
    public static final String      ACTION_HILFE_TEXT= "action_hilfe";
    public static final int         ACTION_MUSTERNUMMER_CODE = 1010;
    public static final String      ACTION_MUSTERNUMMER_TEXT = "notiz.action_musternummer";
    
    int         			dbKey;
    NotizItem   		notiz;
    JRzFrame			origin;

    ErgebnisItem callerObject;
    /** Creates new form notizFenster */
    public NotizFenster(RzPro r, String name,Object extendedData) {
        super(r,name,extendedData);
        createActions();
        createGUIComponents();
        setGUIComponents();
        getMessage((MessageItem)extendedData);
    }

    @Override
	public void createGUIComponents() {
        mb = new JMenuBar();
		mnuDatei = new JMenu();
			mb.add(mnuDatei);
		mnuBearbeiten = new JMenu();
			mb.add(mnuBearbeiten);
        mnuExtras = new JMenu();
        	mb.add(mnuExtras);
        mnuHilfe = new JMenu();
        	mb.add(mnuHilfe);
		setJMenuBar(mb);
		mainPanel = new JPanel(new BorderLayout());
			toolbarPanel = new JPanel(new BorderLayout());
				tb1 = new JToolBar();
				tb1.setFloatable(false);
				tb1.setRollover(true);
				toolbarPanel.add(tb1);
			mainPanel.add(toolbarPanel,BorderLayout.NORTH);
			contentPanel  = new JPanel(new BorderLayout());
				leftPanel = new JPanel(new GridLayout(2,1));
					topPanel = new JPanel(new BorderLayout());
	    				lblAdresslisteTitel=new JLabel();
	    				lblAdresslisteTitel.setHorizontalAlignment(SwingConstants.CENTER);
	    				topPanel.add(lblAdresslisteTitel,BorderLayout.NORTH);
	    				scrAdressen = new JScrollPane();
	    					lstAdressen = new JRzList();
	    					lstAdressen.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
	    						scrAdressen.setViewportView(lstAdressen);
	    					topPanel.add(scrAdressen,BorderLayout.CENTER);
	    			    adressButtonPanel = new JPanel(new BorderLayout());
	    		    		btAdressenBearbeiten = new JButton();
	    		    			adressButtonPanel.add(btAdressenBearbeiten,BorderLayout.NORTH);
	    		    		btAdresslisteLoeschen = new JButton();
	    		    			adressButtonPanel.add(btAdresslisteLoeschen,BorderLayout.SOUTH);
	    		    	topPanel.add(adressButtonPanel,BorderLayout.SOUTH);
					leftPanel.add(topPanel);
					downPanel = new JPanel(new BorderLayout());
	    				lblStichwortlisteTitel=new JLabel();
	    				lblStichwortlisteTitel.setHorizontalAlignment(SwingConstants.CENTER);
	    				downPanel.add(lblStichwortlisteTitel,BorderLayout.NORTH);
	    				scrStichworte = new JScrollPane();
	    					lstStichworte = new JRzList();
	    					lstStichworte.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
	    						scrStichworte.setViewportView(lstStichworte);
	    					lstStichworte.setCellRenderer(new STWListRenderer(rz));
	    					downPanel.add(scrStichworte,BorderLayout.CENTER);
	    			    stichwortButtonPanel = new JPanel(new BorderLayout());
	    		    		btStichworteBearbeiten = new JButton();
	    		    			stichwortButtonPanel.add(btStichworteBearbeiten,BorderLayout.NORTH);
	    		    		btStichworteLoeschen = new JButton();
	    		    			stichwortButtonPanel.add(btStichworteLoeschen,BorderLayout.SOUTH);
	    		    		downPanel.add(stichwortButtonPanel,BorderLayout.SOUTH);
					leftPanel.add(downPanel);
				contentPanel.add(leftPanel,BorderLayout.WEST);
				rightPanel = new JPanel(new BorderLayout());
					namePanel = new JPanel(new BorderLayout());
						lblName=new JLabel();
							namePanel.add(lblName,BorderLayout.WEST);
						txtTitel = new JSelectedTextField();
							namePanel.add(txtTitel,BorderLayout.CENTER);
						btMusternummer = new JButton();
							namePanel.add(btMusternummer,BorderLayout.EAST);
					rightPanel.add(namePanel,BorderLayout.NORTH);
			        scrText = new JScrollPane();
			        	txtComment = new JRzTextPane(rz.getLocale().getNumberFormat(OptionFactory.NF_NORMAL));
			    		txtComment.addKeyListener(new java.awt.event.KeyAdapter() {
							@Override
							public void keyReleased(java.awt.event.KeyEvent evt) {
								txtTextKeyReleased(evt);
							}
				    		});
			        	scrText.setViewportView(txtComment);
			        rightPanel.add(scrText,BorderLayout.CENTER);
				contentPanel.add(rightPanel,BorderLayout.CENTER);
				buttonPanel = new JPanel(new BorderLayout());
					buttonTopPanel=new JPanel(new BorderLayout());
						lblErstellt = new JLabel();
							lblErstellt.setHorizontalAlignment(SwingConstants.CENTER);
							buttonTopPanel.add(lblErstellt,BorderLayout.NORTH);
						lblGeaendert = new JLabel();
							lblGeaendert.setHorizontalAlignment(SwingConstants.CENTER);
							buttonTopPanel.add(lblGeaendert,BorderLayout.SOUTH);
					buttonPanel.add(buttonTopPanel,BorderLayout.NORTH);
					buttonDownPanel=new JPanel(new GridLayout(1,3));
						btOK = new JButton();
							buttonDownPanel.add(btOK);
						btHilfe = new JButton();
							buttonDownPanel.add(btHilfe);
						btCancel = new JButton();
							buttonDownPanel.add(btCancel);
					buttonPanel.add(buttonDownPanel,BorderLayout.SOUTH);

				mainPanel.add(toolbarPanel,BorderLayout.NORTH);
				mainPanel.add(contentPanel,BorderLayout.CENTER);
				mainPanel.add(buttonPanel,BorderLayout.SOUTH);

				getContentPane().setLayout(new BorderLayout());
				getContentPane().add(mainPanel,BorderLayout.CENTER);

    }


    @Override
	public void setGUIComponents() {
      setTitle(rz.getVersionString() + " " + rz.getLocale().getString("notiz.titel"));

      mnuDatei.setText(rz.getLocale().getString("menu.datei"));
      mnuBearbeiten.setText(rz.getLocale().getString("menu.bearbeiten"));
      mnuExtras.setText(rz.getLocale().getString("menu.extras"));
      mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));

      mnuDatei.add(getAction(ACTION_OK_CODE));
      mnuDatei.addSeparator();
      mnuDatei.add(getAction(ACTION_ABBRECHEN_CODE));

      mnuBearbeiten.add(getAction(ACTION_ADRESSLISTE_BEARBEITEN_CODE));
      mnuBearbeiten.addSeparator();
      mnuBearbeiten.add(getAction(ACTION_ADRESSLISTE_LOESCHEN_CODE));

      mnuBearbeiten.add(getAction(ACTION_STICHWORTLISTE_BEARBEITEN_CODE));
      mnuBearbeiten.addSeparator();
      mnuBearbeiten.add(getAction(ACTION_STICHWORTLISTE_LOESCHEN_CODE));

      mnuExtras.add(getAction(ACTION_HIDE_CODE));
      mnuHilfe.add(getAction(ACTION_HILFE_CODE));

	  btAdressenBearbeiten.setAction(getAction(ACTION_ADRESSLISTE_BEARBEITEN_CODE));
	  btAdresslisteLoeschen.setAction(getAction(ACTION_ADRESSLISTE_LOESCHEN_CODE));

	  btStichworteBearbeiten.setAction(getAction(ACTION_STICHWORTLISTE_BEARBEITEN_CODE));
	  btStichworteLoeschen.setAction(getAction(ACTION_STICHWORTLISTE_LOESCHEN_CODE));

	  tb1.add(getAction(ACTION_OK_CODE));
	  tb1.add(getAction(ACTION_ABBRECHEN_CODE));
	  tb1.addSeparator();
	  tb1.add(getAction(ACTION_HIDE_CODE));
	  tb1.addSeparator();
	  tb1.add(getAction(ACTION_ADRESSLISTE_BEARBEITEN_CODE));
	  tb1.add(getAction(ACTION_ADRESSLISTE_LOESCHEN_CODE));
	  tb1.addSeparator();
	  tb1.add(getAction(ACTION_STICHWORTLISTE_BEARBEITEN_CODE));
	  tb1.add(getAction(ACTION_STICHWORTLISTE_LOESCHEN_CODE));
	  tb1.addSeparator();
	  tb1.add(getAction(ACTION_HILFE_CODE));

      lblAdresslisteTitel.setText(rz.getLocale().getString("notiz.label_adressliste_titel"));
      lblStichwortlisteTitel.setText(rz.getLocale().getString("notiz.label_stichwortliste_titel"));
      lblName.setText(rz.getLocale().getString("notiz.label_name"));

      btOK.setAction(getAction(ACTION_OK_CODE));
      btHilfe.setAction(getAction(ACTION_HILFE_CODE));
      btCancel.setAction(getAction(ACTION_ABBRECHEN_CODE));
      btMusternummer.setAction(getAction(ACTION_MUSTERNUMMER_CODE));

      

       setResizable(true);
       rz.getFontFactory().setFrameFonts(this);
       pack();
       rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;
    }

    @Override
	public void createActions(){
        actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT, KeyEvent.VK_F5 ,InputEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT, KeyEvent.VK_F1 ,0));
		actionList.put(String.valueOf(ACTION_OK_CODE), new AuswahlAction(rz,this,ACTION_OK_CODE,ACTION_OK_TEXT,KeyEvent.VK_O,	InputEvent.CTRL_DOWN_MASK));
		actionList.put(String.valueOf(ACTION_ABBRECHEN_CODE), new AuswahlAction(rz,this, ACTION_ABBRECHEN_CODE,ACTION_ABBRECHEN_TEXT,KeyEvent.VK_ESCAPE, 0));
		actionList.put(String.valueOf(ACTION_ADRESSLISTE_BEARBEITEN_CODE),new AuswahlAction(rz,this,ACTION_ADRESSLISTE_BEARBEITEN_CODE,ACTION_ADRESSLISTE_BEARBEITEN_TEXT, KeyEvent.VK_D ,InputEvent.CTRL_DOWN_MASK));
		actionList.put(String.valueOf(ACTION_ADRESSLISTE_LOESCHEN_CODE),new AuswahlAction(rz,this,ACTION_ADRESSLISTE_LOESCHEN_CODE,ACTION_ADRESSLISTE_LOESCHEN_TEXT, KeyEvent.VK_L ,InputEvent.CTRL_DOWN_MASK));
		actionList.put(String.valueOf(ACTION_STICHWORTLISTE_BEARBEITEN_CODE),new AuswahlAction(rz,this,ACTION_STICHWORTLISTE_BEARBEITEN_CODE,ACTION_STICHWORTLISTE_BEARBEITEN_TEXT, KeyEvent.VK_S ,InputEvent.CTRL_DOWN_MASK));
		actionList.put(String.valueOf(ACTION_STICHWORTLISTE_LOESCHEN_CODE),new AuswahlAction(rz,this,ACTION_STICHWORTLISTE_LOESCHEN_CODE,ACTION_STICHWORTLISTE_LOESCHEN_TEXT,KeyEvent.VK_W ,InputEvent.CTRL_DOWN_MASK));
		actionList.put(String.valueOf(ACTION_MUSTERNUMMER_CODE),new AuswahlAction(rz,this,ACTION_MUSTERNUMMER_CODE,ACTION_MUSTERNUMMER_TEXT,KeyEvent.VK_W ,InputEvent.CTRL_DOWN_MASK));

    }

	private void txtTextKeyReleased(java.awt.event.KeyEvent evt) {
		/**
		 * Pattern matching
		 */
	    if(evt.getKeyCode() == KeyEvent.VK_TAB) {
	        this.transferFocus();
	    }
	    if((evt.getKeyCode() == KeyEvent.VK_TAB) && (evt.getModifiers()== InputEvent.CTRL_DOWN_MASK)) {
	        this.transferFocusBackward();
	    }
	}

    private void editNotiz(boolean gruppe){
      notiz = rz.getDatabase().getNotizen().dbGetNotiz(callerObject.getID(),false);
      if(notiz != null) {
    	  if(gruppe) {
				if(!callerObject.getAdressen().equals("")) {
					notiz.setAdressListe(rz.getDatabase().getSTW().dbGetAdressenListe(callerObject.getAdressen()));
				}
				if(!callerObject.getStichworte().equals("")) {
					notiz.setStichwortListe(rz.getDatabase().getSTW().dbGetStichwortListe(callerObject.getStichworte()));
				}
    	  	}
	        if(notiz != null){
	            fromItem(notiz);
	            setVisible(true);
	            txtTitel.requestFocus();
	        }
	        else {
	            final DialogItem di = new DialogItem(
	                    DialogControl.HINWEIS_DIALOG,
	                    "",0.0,
	                    rz.getLocale().getString("notiz.key_not_found"),
	                    rz.getLocale().getString("notiz.key_not_found"),
	                    rz.getLocale().getString("notiz.fehler_not_found"),
	                    "frage.png",
	                    rz.getLocale().getString("string_ok"),
						"",
	                    this
	            );
	            rz.getDialogFactory().getDialog(di);
			    closeWindow();
	        }
      	}
    }

    @Override
	public void getMessage(MessageItem msg) {
        switch(msg.getMsgCode()) {
    	case MessageItem.MSG_ACTIONPERFORMED:
            switch(msg.getCode()){
            case ACTION_ABBRECHEN_CODE :cancelAction();break;
			case ACTION_ADRESSLISTE_BEARBEITEN_CODE :adressListeBearbeitenAction();break;
			case ACTION_ADRESSLISTE_LOESCHEN_CODE :adressListeLoeschenAction();break;
			case ACTION_OK_CODE :okAction();break;
			case ACTION_STICHWORTLISTE_BEARBEITEN_CODE :stichwortListeBearbeitenAction();	break;
			case ACTION_STICHWORTLISTE_LOESCHEN_CODE :stichwortListeLoeschenAction();break;
            case ACTION_HILFE_CODE: hilfeAction();break;
            case ACTION_HIDE_CODE:hideAction();break;
			case ACTION_MUSTERNUMMER_CODE :
				musterNummerAction();
				break;
            default :
                break;
           }
    		break;
         case MessageItem.MSG_EDIT_NOTIZ:
 				origin = msg.getOrigin();
         		callerObject = (ErgebnisItem)msg.getData();
             	editNotiz(false);
             	break;
             	
         case MessageItem.MSG_EDIT_NOTIZ_GRUPPE:
				origin = msg.getOrigin();
	      		callerObject = (ErgebnisItem)msg.getData();
	          	editNotiz(true);
	          	break;
         case MessageItem.MSG_STICHWORTLISTE_REPLY:
         		notiz.setStichwortListe(((StichwortListe)msg.getData()).copyList());
      			lstStichworte.setListData(((StichwortListe)msg.getData()).toArray());
      			openWindow();
      			break;
         case MessageItem.MSG_ADRESSLISTE_REPLY:
     			notiz.setAdressListe(((StichwortListe)msg.getData()).copyList());
         		lstAdressen.setListData(((StichwortListe)msg.getData()).toArray());
	      		openWindow();
	      		break;

        default:
            rz.getLogFactory().logMessage(2, "notizfenster:", "auswahlAction:" + msg.getMsgCode());
            break;
        }
    }


	private void musterNummerAction() {
		String t=rz.getDatabase().getRezeptur().getMusterNummer("","".trim());
		if(!t.equals("")) {
			this.txtTitel.setText(txtTitel.getText().replaceAll(t,"").trim() + " " + t);
		}
	}
    
    @Override
	public void closeWindow(){
        rz.getFensterFactory().getFensterListe().disposeFrame(this);
    }

    // fromItem überträgt die Daten eines NotizItems in das Fenster
    private void fromItem(NotizItem notiz){
        txtTitel.setText(notiz.getTitel());
        txtComment.setText(notiz.getComment());
        txtComment.setCaretPosition(0);
        lstAdressen.setListData(notiz.getAdressListe().toArray());
        lstStichworte.setListData(notiz.getStichwortListe().toArray());
        lblErstellt.setText(rz.getLocale().getString("string_erstellt").replaceAll("%s",notiz.getErstelltToString()).replaceAll("%v",notiz.getUser1()));
        lblGeaendert.setText(rz.getLocale().getString("string_geaendert").replaceAll("%s",notiz.getGeaendertToString()).replaceAll("%v",notiz.getUser2()));
    }

    // toItem() überträgt die Texte aus dem GUI in das NotizItem
    private void toItem(NotizItem ni){
        ni.setTitel(txtTitel.getText().trim());
        ni.setComment(txtComment.getText().trim());
    }
    @Override
	public void openWindow(){
    	if(notiz != null) {
	        if(!isVisible()) {
				setVisible(true);
			}
	        toFront();
	        txtTitel.requestFocus();
    	} else {
    		rz.getFensterFactory().getFensterListe().disposeFrame(this);
    	}
    }

    /**
     * ok gedrückt... abspeichern oder ändern
     */
    private void okAction(){
        int i;
        toItem(notiz);
        rz.setWaitCursor(this);
        ChangesListe liste = new ChangesListe(rz,notiz.getID(),RzPro.TYP_ID_NOTIZ);
        i = rz.getDatabase().getNotizen().dbSaveNotiz(notiz);
        liste.commit();
        rz.setFreeCursor(this);
        if (i > 0){

            final AbfrageItem ai = new AbfrageItem();
            ai.setTyp(DBAbfrage.ABFRAGE_TYP_NORMAL);
            ai.setID(i);
            ai.setAdressListe(notiz.getAdressListe());
            ai.setStichwortListe(notiz.getStichwortListe());
            ai.setMuster(rz.getDatabase().getErgebnis().getMusterString(notiz.getTitel()));
            origin.getMessage(new MessageItem(MessageItem.MSG_ADD_QUERY_NOTIZ,0,ai,this));
            closeWindow();
        }
    }

    /**
     * cancel
     */
    private void cancelAction(){
        closeWindow();
        this.dispose();
    }

    private void adressListeBearbeitenAction() {
		final AbfrageItem ai = new AbfrageItem();
		ai.setAdressListe(notiz.getAdressListe().copyList());
    	rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_ADRESSAUSWAHL,true,
    			new MessageItem(MessageItem.MSG_ADRESSLISTE_REQUEST,0,ai,this));
    }
    private void adressListeLoeschenAction() {
        notiz.getAdressListe().clear();
        lstAdressen.setListData(notiz.getAdressListe().toArray());

        txtTitel.requestFocus();
    }

    private void stichwortListeBearbeitenAction() {
		final AbfrageItem ai = new AbfrageItem();
		ai.setStichwortListe(notiz.getStichwortListe().copyList());
    	rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_STICHWORTAUSWAHL,true,
    			new MessageItem(MessageItem.MSG_STICHWORTLISTE_REQUEST,0,ai,this));
    }
    private void stichwortListeLoeschenAction() {
        notiz.getStichwortListe().clear();
        lstStichworte.setListData(notiz.getStichwortListe().toArray());
        txtTitel.requestFocus();
    }
	//hilfe
	private void hilfeAction() {
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"notiz.html",this));
	}

    private void hideAction() {
        rz.getFensterFactory().getFensterListe().sperren(this);
    }
    private final class STWListRenderer extends JLabel implements ListCellRenderer{
        RzPro   rz;
        public STWListRenderer(RzPro r){
            rz = r;
            setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list,Object value,int index, boolean isSelected,boolean cellHasFocus){
            final StichwortItem si = (StichwortItem)value;
            this.setFont(rz.getFontFactory().getListFont());
            setText(si.toString());
            if(isSelected){
                setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_SELECTED));
                setForeground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_FOREGROUND_SELECTED));
            }else {
                setBackground(rz.getOptionFactory().getRGBColorString(si.getHg()));
                setForeground(rz.getOptionFactory().getRGBColorString(si.getVg()));
            }
            return this;
        }
    }

}
