/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package de.lunqual.rzpro.fenster.palettenfenster;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;

import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.fenster.JIntegerField;
import de.lunqual.rzpro.fenster.JNumberField;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fenster.JSelectedTextField;
import de.lunqual.rzpro.fenster.dialoge.DialogControl;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.paletten.PalettenItem;
import de.lunqual.rzpro.options.OptionFactory;


/**
 *
 * @author  administrator
 */
public class PalettenEingabe extends JRzFrame {

    //GUI-Variablen
	private JMenuBar mb;
    	private JMenu mnuDatei;
    	private JMenu mnuExtras;
    	private JMenu mnuHilfe;
    private JPanel mainPanel;
    	private JPanel toolbarPanel;
    		private JToolBar tb1;
    	private JPanel contentPanel;
    		private JPanel gadgetPanel;
	        	private JLabel lblBezeichnung;
	            private JSelectedTextField txtBezeichnung;
	            private JLabel lblInhalt;
	            private JNumberField txtInhalt;
	            private JLabel lblFlaschen;
	            private JIntegerField txtFlaschen;
	            private JLabel lblKartons;
	            private JIntegerField txtKartons;
    	private JPanel buttonPanel;
    		private JButton btOK;
    		private JButton btHilfe;
    		private JButton btCancel;

    // ActionCodes KalkulationEingabe
    public static final int         ACTION_OK_CODE = 1000;
    public static final String      ACTION_OK_TEXT = "paletteneingabe.action_ok";
    public static final int         ACTION_ABBRECHEN_CODE = 1001;
    public static final String      ACTION_ABBRECHEN_TEXT = "paletteneingabe.action_abbrechen";
    public static final int         ACTION_HILFE_CODE = 1002;
    public static final String      ACTION_HILFE_TEXT = "action_hilfe";
    public static final int         ACTION_HIDE_CODE = 1003;
    public static final String      ACTION_HIDE_TEXT = "action_hide";

    PalettenItem		pi;
    MessageItem		mi;


    /** Creates new form AdressAuswahl */

    public PalettenEingabe(RzPro r, String name,Object extendedData) {
        super(r,name,extendedData);
        createActions();
        createGUIComponents();
        setGUIComponents();
        getMessage((MessageItem)extendedData);
    }

    @Override
	public void createGUIComponents() {
        mb = new JMenuBar();
		mnuDatei = new JMenu();
			mb.add(mnuDatei);
        mnuExtras = new JMenu();
        	mb.add(mnuExtras);
        mnuHilfe = new JMenu();
        	mb.add(mnuHilfe);
		setJMenuBar(mb);
		mainPanel = new JPanel(new BorderLayout());
			toolbarPanel = new JPanel(new BorderLayout());
				tb1 = new JToolBar();
				tb1.setFloatable(false);
				tb1.setRollover(true);
				toolbarPanel.add(tb1);
			mainPanel.add(toolbarPanel,BorderLayout.NORTH);
			contentPanel = new JPanel(new BorderLayout());
			gadgetPanel  = new JPanel(new GridLayout(0,2));
	        	lblBezeichnung = new JLabel();
	       		lblBezeichnung.setHorizontalAlignment(SwingConstants.CENTER);
	        		gadgetPanel.add(lblBezeichnung);
	            txtBezeichnung = new JSelectedTextField();
	            	gadgetPanel.add(txtBezeichnung);
	            lblInhalt = new JLabel();
	            	lblInhalt.setHorizontalAlignment(SwingConstants.RIGHT);
	            	gadgetPanel.add(lblInhalt);
	            txtInhalt = new  JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_NORMAL),1.0,0.0,Double.POSITIVE_INFINITY);
	            	gadgetPanel.add(txtInhalt);
	            lblFlaschen = new JLabel();
	            	lblFlaschen.setHorizontalAlignment(SwingConstants.RIGHT);
	            	gadgetPanel.add(lblFlaschen);
	            txtFlaschen = new JIntegerField(6,0,Integer.MAX_VALUE);
	            	gadgetPanel.add(txtFlaschen);
	            lblKartons = new JLabel();
	            	lblKartons.setHorizontalAlignment(SwingConstants.RIGHT);
	            	gadgetPanel.add(lblKartons);
	            txtKartons = new JIntegerField(1,0,Integer.MAX_VALUE);
	            	gadgetPanel.add(txtKartons);
	            contentPanel.add(gadgetPanel,BorderLayout.NORTH);
			buttonPanel=new JPanel(new GridLayout(1,3));
    			btOK=new JButton();
    				buttonPanel.add(btOK);
    			btHilfe = new JButton();
    				buttonPanel.add(btHilfe);
    		    btCancel = new JButton();
    		    	buttonPanel.add(btCancel)
    		    	;
			mainPanel.add(toolbarPanel,BorderLayout.NORTH);
			mainPanel.add(contentPanel,BorderLayout.CENTER);
			mainPanel.add(buttonPanel,BorderLayout.SOUTH);

			getContentPane().setLayout(new BorderLayout());
			getContentPane().add(mainPanel,BorderLayout.CENTER);
    }
    @Override
	public void setGUIComponents() {
        setTitle(rz.getLocale().getString("paletteneingabe.titel"));

        mnuDatei.setText(rz.getLocale().getString("menu.datei"));
        mnuExtras.setText(rz.getLocale().getString("menu.extras"));
        mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));
        mnuDatei.add(getAction(ACTION_OK_CODE));
        mnuDatei.addSeparator();
        mnuDatei.add(getAction(ACTION_ABBRECHEN_CODE));
        mnuExtras.add(getAction(ACTION_HIDE_CODE));
        mnuHilfe.add(getAction(ACTION_HILFE_CODE));

  	  	tb1.add(getAction(ACTION_OK_CODE));
  	  	tb1.add(getAction(ACTION_ABBRECHEN_CODE));
  	  	tb1.addSeparator();
  	  	tb1.add(getAction(ACTION_HIDE_CODE));
  	  	tb1.addSeparator();
  	  	tb1.add(getAction(ACTION_HILFE_CODE));

        btOK.setAction(getAction(ACTION_OK_CODE));
        btHilfe.setAction(getAction(ACTION_HILFE_CODE));
        btCancel.setAction(getAction(ACTION_ABBRECHEN_CODE));

        lblBezeichnung.setText(rz.getLocale().getString("paletteneingabe.label_bezeichnung"));
        lblInhalt.setText(rz.getLocale().getString("paletteneingabe.label_inhalt"));
        lblFlaschen.setText(rz.getLocale().getString("paletteneingabe.label_flaschen_per_karton"));
        lblKartons.setText(rz.getLocale().getString("paletteneingabe.label_karton_per_palette"));

         setResizable(true);
         rz.getFontFactory().setFrameFonts(this);
         pack();
         rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;
    }
    @Override
	public void getMessage(MessageItem msg) {
        switch(msg.getMsgCode()) {
    	case MessageItem.MSG_ACTIONPERFORMED:
            switch(msg.getCode()){
            case ACTION_ABBRECHEN_CODE :cancelAction();break;
			case ACTION_OK_CODE :okAction();break;
            case ACTION_HILFE_CODE: hilfeAction();break;
            case ACTION_HIDE_CODE:hideAction();break;
            default :
                break;
           }
    		break;
         case MessageItem.MSG_EDIT_PALETTE_REQUEST:
            mi = msg;
            pi = rz.getDatabase().getPaletten().getPalette(msg.getCode());
            if(pi !=null) {
            	fromItem();
            }
	      	break;

        default:
            rz.getLogFactory().logMessage(2, "paletteneingabe", "auswahlAction:" + msg.getMsgCode());
            break;
        }
    }

    @Override
	public void createActions(){
        actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT, KeyEvent.VK_F5 ,InputEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT, KeyEvent.VK_F1 ,0));
		actionList.put(String.valueOf(ACTION_OK_CODE), new AuswahlAction(rz,this,ACTION_OK_CODE,ACTION_OK_TEXT,KeyEvent.VK_O,	InputEvent.CTRL_DOWN_MASK));
		actionList.put(String.valueOf(ACTION_ABBRECHEN_CODE), new AuswahlAction(rz,this, ACTION_ABBRECHEN_CODE,ACTION_ABBRECHEN_TEXT,KeyEvent.VK_ESCAPE, 0));

    }

    /**
     * ok gedrückt... abspeichern oder ändern
     */
    private void okAction(){
        int insertID;
        toItem();

        if(!pi.getBezeichnung().trim().equals("") ) {
            insertID = rz.getDatabase().getPaletten().savePalette(pi);
            closeWindow();
            try {
            	mi.getOrigin().getMessage(new MessageItem(MessageItem.MSG_EDIT_PALETTE_REPLY,insertID,null,this));
            } catch (final Exception e) {}
        } else {
            final DialogItem dlgItem = new DialogItem(0,"",0.0,"","","","","","",null);
            dlgItem.setTyp(DialogControl.HINWEIS_DIALOG);
            dlgItem.setCaption(rz.getLocale().getString("paletteneingabe.titel"));
            dlgItem.setTitel(rz.getLocale().getString("paletteneingabe.titel"));
            dlgItem.setMessage(rz.getLocale().getString("paletteneingabe.error_kein_name"));
            dlgItem.setIcon("warnung.png");
            dlgItem.setOk(rz.getLocale().getString("string_ok"));
            dlgItem.setOrigin(this);
            rz.getDialogFactory().getDialog(dlgItem);
        }
    }

    /**
     * cancel
     */
    private void cancelAction(){
    	setVisible(false);
    }

    private void fromItem(){
    	try {
    		txtBezeichnung.setText(pi.getBezeichnung());
    		txtInhalt.setValue(pi.getInhalt());
    		txtFlaschen.setValue(pi.getFlaschen_per_karton());
    		txtKartons.setValue(pi.getKarton_per_palette());
    	}catch (final Exception e) {}
    }

    private void toItem(){
    	pi.setBezeichnung(txtBezeichnung.getText());
    	pi.setInhalt(txtInhalt.getValue());
    	pi.setFlaschen_per_karton(txtFlaschen.getValue());
    	pi.setKarton_per_palette(txtKartons.getValue());
    }

    @Override
	public void closeWindow(){
        rz.getFensterFactory().getFensterListe().disposeFrame(this);
    }
    @Override
	public void openWindow(){
    	if(pi != null) {
        if (!isVisible()) {
			setVisible(true);
		}
        toFront();
        txtBezeichnung.requestFocus();
    	} else {
    		closeWindow();
    	}
    }

	//hilfe
	private void hilfeAction() {
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"paletten.html",this));
	}

    private void hideAction() {
        rz.getFensterFactory().getFensterListe().sperren(this);
    }
}

