/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package de.lunqual.rzpro.fenster.palettenfenster;


import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;

import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.paletten.PalettenItem;
import de.lunqual.rzpro.items.paletten.PalettenListe;
/**
 *
 * @author  lunqual
 */
public class PalettenListenFenster extends JRzFrame{

    //GUI-Variablen
    private JMenuBar mb;
    private JMenu mnuDatei;
    private JMenu mnuBearbeiten;
    private JMenu mnuExtras;
    private JMenu mnuHilfe;
    private JPanel mainPanel;
    	private JPanel toolbarPanel;
    		private JToolBar tb1;
    	private JPanel contentPanel;
    		private JPanel leftPanel;
    			private JScrollPane scrPaletten;
    				private JList lstPaletten;
    			private JPanel bottomPanel;
    				private JButton btNeu;
    				private JButton btBearbeiten;
    				private JButton btLoeschen;
    		private JPanel rightPanel;
    			private JScrollPane scrText;
    				private JEditorPane txtText;
    	private JPanel buttonPanel;
    		private JButton btClose;
    		private JButton btHilfe;

    // ActionCodes palettenfenstersfenster
    public static final int         ACTION_NEU_CODE = 1000;
    public static final String      ACTION_NEU_TEXT = "palettenfenster.action_neu";
    public static final int         ACTION_BEARBEITEN_CODE = 1001;
    public static final String      ACTION_BEARBEITEN_TEXT = "palettenfenster.action_bearbeiten";
    public static final int         ACTION_LOESCHEN_CODE = 1002;
    public static final String      ACTION_LOESCHEN_TEXT = "palettenfenster.action_loeschen";
    public static final int         ACTION_CLOSE_CODE = 1003;
    public static final String      ACTION_CLOSE_TEXT = "palettenfenster.action_close";
    public static final int         ACTION_HILFE_CODE = 1004;
    public static final String      ACTION_HILFE_TEXT = "action_hilfe";
    public static final int         ACTION_HIDE_CODE = 1005;
    public static final String      ACTION_HIDE_TEXT = "action_hide";
    public static final int         ACTION_REFRESH_CODE = 1006;
    public static final String      ACTION_REFRESH_TEXT = "action_refresh";

    PalettenListe	pl;
    MessageItem mi;

    /** Creates new form AdressenFenster */
    public PalettenListenFenster(RzPro r, String name, Object extendedData) {
        super(r,name,extendedData);
        createActions();
        createGUIComponents();
        setGUIComponents();
        getMessage((MessageItem)extendedData);
    }

    @Override
	public void createGUIComponents() {
        mb = new JMenuBar();
		mnuDatei = new JMenu();
			mb.add(mnuDatei);
		mnuBearbeiten = new JMenu();
			mb.add(mnuBearbeiten);
        mnuExtras = new JMenu();
        	mb.add(mnuExtras);
        mnuHilfe = new JMenu();
        	mb.add(mnuHilfe);
		setJMenuBar(mb);
		mainPanel = new JPanel(new BorderLayout());
			toolbarPanel = new JPanel(new BorderLayout());
				tb1 = new JToolBar();
				tb1.setFloatable(false);
				tb1.setRollover(true);
				toolbarPanel.add(tb1);
			mainPanel.add(toolbarPanel,BorderLayout.NORTH);
				contentPanel  = new JPanel(new BorderLayout());
					leftPanel = new JPanel (new BorderLayout());
						scrPaletten = new JScrollPane();
							lstPaletten = new JList();
					        lstPaletten.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
					            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
					                palettenSelected();
					            }
					        });
							scrPaletten.setViewportView(lstPaletten);
						leftPanel.add(scrPaletten,BorderLayout.CENTER);
						bottomPanel = new JPanel(new GridLayout(1,3));
							btNeu = new JButton();
							bottomPanel.add(btNeu);
							btBearbeiten = new JButton();
							bottomPanel.add(btBearbeiten);
							btLoeschen = new JButton();
							bottomPanel.add(btLoeschen);
							leftPanel.add(bottomPanel,BorderLayout.SOUTH);
					contentPanel.add(leftPanel,BorderLayout.WEST);
					rightPanel = new JPanel(new BorderLayout());
						scrText = new JScrollPane();
						txtText = new JEditorPane();
							txtText.setContentType("text/html");
							txtText.setEditable(false);
						scrText.setViewportView(txtText);
						rightPanel.add(scrText,BorderLayout.CENTER);
					contentPanel.add(rightPanel,BorderLayout.CENTER);
			mainPanel.add(contentPanel,BorderLayout.CENTER);
				buttonPanel = new JPanel(new BorderLayout());
					btClose = new JButton();
						buttonPanel.add(btClose,BorderLayout.WEST);
					btHilfe = new JButton();
						buttonPanel.add(btHilfe,BorderLayout.EAST);


			mainPanel.add(toolbarPanel,BorderLayout.NORTH);
			mainPanel.add(contentPanel,BorderLayout.CENTER);
			mainPanel.add(buttonPanel,BorderLayout.SOUTH);

			getContentPane().setLayout(new BorderLayout());
			getContentPane().add(mainPanel,BorderLayout.CENTER);
    }

    @Override
	public void setGUIComponents() {
      setTitle(rz.getVersionString() + " " + rz.getLocale().getString("palettenfenster.titel"));


      mnuDatei.setText(rz.getLocale().getString("menu.datei"));
      mnuExtras.setText(rz.getLocale().getString("menu.extras"));
      mnuBearbeiten.setText(rz.getLocale().getString("menu.bearbeiten"));
      mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));

      mnuDatei.add(getAction(ACTION_CLOSE_CODE));

      mnuBearbeiten.add(getAction(ACTION_NEU_CODE));
      mnuBearbeiten.add(getAction(ACTION_BEARBEITEN_CODE));
      mnuBearbeiten.addSeparator();
      mnuBearbeiten.add(getAction(ACTION_LOESCHEN_CODE));

      mnuExtras.add(getAction(ACTION_HIDE_CODE));
      mnuExtras.add(getAction(ACTION_REFRESH_CODE));

      mnuHilfe.add(getAction(ACTION_HILFE_CODE));

      btHilfe .setAction(getAction(ACTION_HILFE_CODE));
      btClose.setAction(getAction(ACTION_CLOSE_CODE));
      btNeu.setAction(getAction(ACTION_NEU_CODE));
      btBearbeiten.setAction(getAction(ACTION_BEARBEITEN_CODE));
      btLoeschen.setAction(getAction(ACTION_LOESCHEN_CODE));

      tb1.add(getAction(ACTION_CLOSE_CODE));
      tb1.add(getAction(ACTION_HIDE_CODE));
      tb1.add(getAction(ACTION_REFRESH_CODE));
      tb1.addSeparator();
      tb1.add(getAction(ACTION_NEU_CODE));
      tb1.add(getAction(ACTION_BEARBEITEN_CODE));
      tb1.addSeparator();
      tb1.add(getAction(ACTION_LOESCHEN_CODE));
      tb1.addSeparator();
      tb1.add(getAction(ACTION_HILFE_CODE));

      setResizable(true);
      rz.getFontFactory().setFrameFonts(this);
      pack();
      rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;
    }

    @Override
	public void getMessage(MessageItem msg) {
        switch(msg.getMsgCode()) {
    	case MessageItem.MSG_ACTIONPERFORMED:
            switch(msg.getCode()){
		          case ACTION_CLOSE_CODE:closeWindow();break;
		          case ACTION_REFRESH_CODE:refreshAction();break;
		          case ACTION_NEU_CODE:neuAction();break;
		          case ACTION_BEARBEITEN_CODE:bearbeitenAction();break;
		          case ACTION_LOESCHEN_CODE:loeschenAction();break;
		          case ACTION_HILFE_CODE: hilfeAction();break;
		          case ACTION_HIDE_CODE:hideAction();break;
            default :
                break;
           }
    		break;
		case MessageItem.MSG_REFRESH_AUSGABE:
			refreshAction();
			break;
		case MessageItem.MSG_EDIT_PALETTE_REPLY :
			final int id = msg.getCode();
			refreshAction();
			if(lstPaletten.getModel().getSize() > 0){
	            for(int i = 0;i < lstPaletten.getModel().getSize();i++) {
	                if(id == ((PalettenItem)lstPaletten.getModel().getElementAt(i)).getId()) {
	                    lstPaletten.setSelectedIndex(i);
	                    continue;
	                }
	            }
	        }
			break;
		case MessageItem.MSG_SHOW_PALETTENLISTE:
			mi = msg;
			refreshAction();
			break;

        default:
            rz.getLogFactory().logMessage(2, "palettenfenster", "auswahlAction:" + msg.getMsgCode());
            break;
        }
    }


    @Override
	public void createActions(){
        actionList.put(String.valueOf(ACTION_CLOSE_CODE),new AuswahlAction(rz,this,ACTION_CLOSE_CODE,ACTION_CLOSE_TEXT,KeyEvent.VK_ESCAPE ,0));
        actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT,KeyEvent.VK_F5 ,InputEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_NEU_CODE),new AuswahlAction(rz,this,ACTION_NEU_CODE,ACTION_NEU_TEXT,KeyEvent.VK_N ,InputEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_BEARBEITEN_CODE),new AuswahlAction(rz,this,ACTION_BEARBEITEN_CODE,ACTION_BEARBEITEN_TEXT,KeyEvent.VK_F2 ,0));
        actionList.put(String.valueOf(ACTION_LOESCHEN_CODE),new AuswahlAction(rz,this,ACTION_LOESCHEN_CODE,ACTION_LOESCHEN_TEXT,KeyEvent.VK_DELETE ,0));
        actionList.put(String.valueOf(ACTION_REFRESH_CODE),new AuswahlAction(rz,this,ACTION_REFRESH_CODE,ACTION_REFRESH_TEXT,KeyEvent.VK_F5,0));
        actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT,KeyEvent.VK_F1,0));
    }


    @Override
	public void openWindow(){
        if(!isVisible()) {
			setVisible(true);
		}
        toFront();
    }

    @Override
	public void closeWindow(){
    	try {
            try {
            	mi.getOrigin().getMessage(new MessageItem(MessageItem.MSG_ALTERED_PALETTE,0,null,this));
            } catch (final Exception e) {}
    	}catch(final Exception e) {}
        //this.setVisible(false);
    	rz.getFensterFactory().getFensterListe().disposeFrame(this);
    }

    private void refreshAction() {
    	pl = rz.getDatabase().getPaletten().getPalettenListe();
    	lstPaletten.setListData(pl.toArray());
    	if(lstPaletten.getModel().getSize()>0) {
    		lstPaletten.setSelectedIndex(0);
    	}
    }

    // datei-menü
    // bearbeiten-menü
    private void neuAction(){
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_PALETTENEINGABE,true, new MessageItem(MessageItem.MSG_EDIT_PALETTE_REQUEST,0,null,this));
    }
    private void bearbeitenAction(){
    	if(lstPaletten.getSelectedIndex() != -1) {
    	       rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_PALETTENEINGABE,true, new MessageItem(MessageItem.MSG_EDIT_PALETTE_REQUEST,((PalettenItem)lstPaletten.getSelectedValue()).getId(),null,this));
    	}
    }

    private void loeschenAction(){
    	if(lstPaletten.getSelectedIndex()!= -1) {
    		rz.getDatabase().getPaletten().deletePalette(((PalettenItem)lstPaletten.getSelectedValue()).getId());
    		refreshAction();
    	}
    }

    private void palettenSelected() {
		if(lstPaletten.getSelectedIndex()!= -1) {
			rz.getAusgabeFactory().palettenAusgabe((PalettenItem)lstPaletten.getSelectedValue(),txtText);
		}
    }

	//hilfe
	private void hilfeAction() {
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"paletten.html",this));
	}

    private void hideAction() {
        rz.getFensterFactory().getFensterListe().sperren(this);
    }

}
