/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package de.lunqual.rzpro.fenster.palettenfenster;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.fenster.JIntegerField;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fenster.JRzList;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.paletten.PalettenItem;
import de.lunqual.rzpro.items.paletten.PalettenReturnItem;
import de.lunqual.rzpro.options.OptionFactory;


/**
 *
 * @author  administrator
 */
public class PalettenRechner extends JRzFrame {

    //GUI-Variablen
	private JMenuBar mb;
    	private JMenu mnuDatei;
    	private JMenu mnuFenster;
    	private JMenu mnuExtras;
    	private JMenu mnuHilfe;
    private JPanel mainPanel;
    	private JPanel toolbarPanel;
    		private JToolBar tb1;
    	private JPanel contentPanel;
        	private JPanel leftPanel;
        		
        		private JPanel listenPanel;
        			private JLabel lblPalettenTitel;
        			private JScrollPane scrListe;
        				private JRzList lstPaletten;
        		private JButton btBearbeiten;
        		private JLabel lblDaten;
        	private JPanel midPanel;
	        	private JPanel eingabePanel;
	        		private JIntegerField	txtPaletten;
	        		private JLabel lblPaletten;
	        		private JIntegerField txtKorrekturPaletten;
	        		private JIntegerField txtKartons;
	        		private JLabel lblKartons;
	        		private JIntegerField txtKorrekturKartons;
	        		private JIntegerField txtFlaschen;
	        		private JLabel lblFlaschen;
	        		private JIntegerField txtKorrekturFlaschen;
        	private JPanel anzeigePanel;
        		private JLabel lblAnzeige;
    	private JPanel buttonPanel;
    		private JButton btOK;
    		private JButton btHilfe;
    		private JButton btCancel;

    // ActionCodes KalkulationEingabe
    public static final int         ACTION_OK_CODE = 1000;
    public static final String      ACTION_OK_TEXT = "palettenrechner.action_ok";
    public static final int         ACTION_ABBRECHEN_CODE = 1001;
    public static final String      ACTION_ABBRECHEN_TEXT = "palettenrechner.action_abbrechen";
    public static final int         ACTION_HILFE_CODE = 1002;
    public static final String      ACTION_HILFE_TEXT = "action_hilfe";
    public static final int         ACTION_HIDE_CODE = 1003;
    public static final String      ACTION_HIDE_TEXT = "action_hide";
    public static final int         		ACTION_PALETTEN_CODE = 1004;
    public static final String     		ACTION_PALETTEN_TEXT = "palettenrechner.action_palette";

    MessageItem		mi;
    double				liter=0.0;
    double				flaschen=0.0;
    String				menge = "";

    /** Creates new form AdressAuswahl */

    public PalettenRechner(RzPro r, String name,Object extendedData) {
        super(r,name,extendedData);
        createActions();
        createGUIComponents();
        setGUIComponents();
        getMessage((MessageItem)extendedData);
    }

    @Override
	public void createGUIComponents() {
        mb = new JMenuBar();
		mnuDatei = new JMenu();
			mb.add(mnuDatei);
		mnuFenster = new JMenu();
			mb.add(mnuFenster);
        mnuExtras = new JMenu();
        	mb.add(mnuExtras);
        mnuHilfe = new JMenu();
        	mb.add(mnuHilfe);
		setJMenuBar(mb);
		mainPanel = new JPanel(new BorderLayout());
			toolbarPanel = new JPanel(new BorderLayout());
				tb1 = new JToolBar();
				tb1.setFloatable(false);
				tb1.setRollover(true);
				toolbarPanel.add(tb1);
			mainPanel.add(toolbarPanel,BorderLayout.NORTH);
			contentPanel  = new JPanel(new BorderLayout());
	        	leftPanel = new JPanel(new BorderLayout());
	        		listenPanel = new JPanel(new BorderLayout());
	        			listenPanel.setBorder(BorderFactory.createEtchedBorder());
	        			lblPalettenTitel = new JLabel();
	        			lblPalettenTitel.setHorizontalAlignment(SwingConstants.CENTER);
	        			listenPanel.add(lblPalettenTitel,BorderLayout.NORTH);
	        			scrListe = new JScrollPane();
	        				lstPaletten = new JRzList();
	        					lstPaletten.setBorder(BorderFactory.createEtchedBorder());
	        				rz.getDatabase().getPaletten().getPalettenListe(lstPaletten);
	        			    lstPaletten.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
					            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
					            	rz.getOptionFactory().setOption("palettenrechner.palette", lstPaletten.getSelectedIndex());
					                rechnen();
					                txtPaletten.requestFocus();
					                txtPaletten.selectAll();
					            }
					        });
	        				scrListe.setViewportView(lstPaletten);
	        			listenPanel.add(scrListe,BorderLayout.CENTER);
	        			btBearbeiten = new JButton();
	        		listenPanel.add(btBearbeiten,BorderLayout.SOUTH);
	        		leftPanel.add(listenPanel,BorderLayout.CENTER);
	        	contentPanel.add(leftPanel,BorderLayout.WEST);
	        	midPanel=new JPanel(new BorderLayout());
	        		midPanel.setBorder(BorderFactory.createEtchedBorder());
	        		eingabePanel=new JPanel(new GridLayout(3,3));
	        			eingabePanel.setBorder(BorderFactory.createEtchedBorder());
	        			txtPaletten=new JIntegerField(1,0,Integer.MAX_VALUE);
				        txtPaletten.addKeyListener(new java.awt.event.KeyAdapter() {
	 			            @Override
							public void keyReleased(java.awt.event.KeyEvent evt) {
	 			            	if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
	 			            		rechnen();
	 			            	}
	 			            }
	 			        });
						txtPaletten.addFocusListener(new FocusListener() {
							public void focusGained(FocusEvent evt) {
							}
							public void focusLost(FocusEvent evt) {
								rechnen();
								}
				    		});
	        			txtPaletten.setColumns(8);
	        			eingabePanel.add(txtPaletten);
	        			lblPaletten=new JLabel();
	        				lblPaletten.setHorizontalAlignment(SwingConstants.CENTER);
	        			eingabePanel.add(lblPaletten);

	        			txtKorrekturPaletten=new JIntegerField(0,0,Integer.MAX_VALUE);
	        			txtKorrekturPaletten.setForeground(Color.red);
				        txtKorrekturPaletten.addKeyListener(new java.awt.event.KeyAdapter() {
	 			            @Override
							public void keyReleased(java.awt.event.KeyEvent evt) {
	 			            	if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
	 			            		rechnen();
	 			            	}
	 			            }
	 			        });
						txtKorrekturPaletten.addFocusListener(new FocusListener() {
							public void focusGained(FocusEvent evt) {
							}
							public void focusLost(FocusEvent evt) {
								rechnen();
								}
				    		});
	        			txtKorrekturPaletten.setColumns(8);
	        			eingabePanel.add(txtKorrekturPaletten);
	        			
	        			
	        			txtKartons=new JIntegerField(1,0,Integer.MAX_VALUE);
				        txtKartons.addKeyListener(new java.awt.event.KeyAdapter() {
	 			            @Override
							public void keyReleased(java.awt.event.KeyEvent evt) {
	 			            	if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
	 			            		rechnen();
	 			            	}
	 			            }
	 			        });
						txtKartons.addFocusListener(new FocusListener() {
							public void focusGained(FocusEvent evt) {
							}
							public void focusLost(FocusEvent evt) {
								rechnen();
								}
				    		});
        				txtKartons.setColumns(8);
	        			eingabePanel.add(txtKartons);
	        			lblKartons=new JLabel();
	        				lblKartons.setHorizontalAlignment(SwingConstants.CENTER);
	        			eingabePanel.add(lblKartons);

	        			txtKorrekturKartons=new JIntegerField(0,0,Integer.MAX_VALUE);
	        			txtKorrekturKartons.setForeground(Color.red);
				        txtKorrekturKartons.addKeyListener(new java.awt.event.KeyAdapter() {
	 			            @Override
							public void keyReleased(java.awt.event.KeyEvent evt) {
	 			            	if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
	 			            		rechnen();
	 			            	}
	 			            }
	 			        });
						txtKorrekturKartons.addFocusListener(new FocusListener() {
							public void focusGained(FocusEvent evt) {
							}
							public void focusLost(FocusEvent evt) {
								rechnen();
								}
				    		});
	        			txtKorrekturKartons.setColumns(8);
	        			eingabePanel.add(txtKorrekturKartons);
	        			
	        			
	        			txtFlaschen=new JIntegerField(1,0,Integer.MAX_VALUE);
				        txtFlaschen.addKeyListener(new java.awt.event.KeyAdapter() {
	 			            @Override
							public void keyReleased(java.awt.event.KeyEvent evt) {
	 			            	if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
	 			            		rechnen();
	 			            	}
	 			            }
	 			        });
						txtFlaschen.addFocusListener(new FocusListener() {
							public void focusGained(FocusEvent evt) {
							}
							public void focusLost(FocusEvent evt) {
								rechnen();
								}
				    		});
        				txtFlaschen.setColumns(8);
	        			eingabePanel.add(txtFlaschen);
	        			lblFlaschen=new JLabel();
	        				lblFlaschen.setHorizontalAlignment(SwingConstants.CENTER);
	        			eingabePanel.add(lblFlaschen);
	        			
	        			
	        			txtKorrekturFlaschen=new JIntegerField(0,0,Integer.MAX_VALUE);
	        			txtKorrekturFlaschen.setForeground(Color.red);
				        txtKorrekturFlaschen.addKeyListener(new java.awt.event.KeyAdapter() {
	 			            @Override
							public void keyReleased(java.awt.event.KeyEvent evt) {
	 			            	if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
	 			            		rechnen();
	 			            	}
	 			            }
	 			        });
						txtKorrekturFlaschen.addFocusListener(new FocusListener() {
							public void focusGained(FocusEvent evt) {
							}
							public void focusLost(FocusEvent evt) {
								rechnen();
								}
				    		});
	        			txtKorrekturFlaschen.setColumns(8);
	        			eingabePanel.add(txtKorrekturFlaschen);
	        			
		        			lblDaten = new JLabel();
		        			lblDaten.setHorizontalAlignment(SwingConstants.CENTER);
		        			midPanel.add(lblDaten,BorderLayout.SOUTH);
	        		midPanel.add(eingabePanel,BorderLayout.NORTH);
	        	contentPanel.add(midPanel,BorderLayout.CENTER);
	        	anzeigePanel=new JPanel(new BorderLayout());
	        		lblAnzeige = new JLabel();
	        			lblAnzeige.setHorizontalAlignment(SwingConstants.CENTER);
	        		anzeigePanel.add(lblAnzeige,BorderLayout.NORTH);
	        	contentPanel.add(anzeigePanel,BorderLayout.SOUTH);
			buttonPanel=new JPanel(new GridLayout(1,3));
    			btOK=new JButton();
    				buttonPanel.add(btOK);
    			btHilfe = new JButton();
    				buttonPanel.add(btHilfe);
    		    btCancel = new JButton();
    		    	buttonPanel.add(btCancel)
    		    	;
			mainPanel.add(toolbarPanel,BorderLayout.NORTH);
			mainPanel.add(contentPanel,BorderLayout.CENTER);
			mainPanel.add(buttonPanel,BorderLayout.SOUTH);

			getContentPane().setLayout(new BorderLayout());
			getContentPane().add(mainPanel,BorderLayout.CENTER);
    }
    @Override
	public void setGUIComponents() {
        setTitle(rz.getLocale().getString("palettenrechner.titel"));

        mnuDatei.setText(rz.getLocale().getString("menu.datei"));
        mnuExtras.setText(rz.getLocale().getString("menu.extras"));
        mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));
        mnuFenster.setText(rz.getLocale().getString("menu.fenster"));
        mnuDatei.add(getAction(ACTION_OK_CODE));
        mnuDatei.addSeparator();
        mnuDatei.add(getAction(ACTION_ABBRECHEN_CODE));
        mnuFenster.add(getAction(ACTION_PALETTEN_CODE));
        mnuExtras.add(getAction(ACTION_HIDE_CODE));
        mnuHilfe.add(getAction(ACTION_HILFE_CODE));

  	  	tb1.add(getAction(ACTION_OK_CODE));
  	  	tb1.add(getAction(ACTION_ABBRECHEN_CODE));
  	  	tb1.addSeparator();
  	  	tb1.add(getAction(ACTION_PALETTEN_CODE));
  	  	tb1.addSeparator();
  	  	tb1.add(getAction(ACTION_HIDE_CODE));
  	  	tb1.addSeparator();
  	  	tb1.add(getAction(ACTION_HILFE_CODE));

        btOK.setAction(getAction(ACTION_OK_CODE));
        btHilfe.setAction(getAction(ACTION_HILFE_CODE));
        btCancel.setAction(getAction(ACTION_ABBRECHEN_CODE));
        btBearbeiten.setAction(getAction(ACTION_PALETTEN_CODE));

        lblPaletten.setText(rz.getLocale().getString("palettenrechner.label_paletten"));
        lblKartons.setText(rz.getLocale().getString("palettenrechner.label_kartons"));
        lblFlaschen.setText(rz.getLocale().getString("palettenrechner.label_flaschen"));
        lblAnzeige.setText(rz.getLocale().getString("palettenrechner.label_anzeige").replaceAll("%s",String.valueOf(0)));
        lblPalettenTitel.setText(rz.getLocale().getString("palettenrechner.label_combo"));
        lblDaten.setText(rz.getLocale().getString("palettenrechner.label_anzeige"));

	    getAction(ACTION_OK_CODE).setEnabled(false);
        
         setResizable(true);
         rz.getFontFactory().setFrameFonts(this);
         pack();
         rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;
    }
    @Override
	public void getMessage(MessageItem msg) {
        switch(msg.getMsgCode()) {
    	case MessageItem.MSG_ACTIONPERFORMED:
            switch(msg.getCode()){
            case ACTION_ABBRECHEN_CODE :cancelAction();break;
			case ACTION_OK_CODE :okAction();break;
            case ACTION_HILFE_CODE: hilfeAction();break;
            case ACTION_HIDE_CODE:hideAction();break;
            case ACTION_PALETTEN_CODE:palettenAction();break;
            default :
                break;
           }
    		break;
         case MessageItem.MSG_SHOW_PALETTENRECHNER:
            mi = msg;
            fromOptions();
	      	break;
         case MessageItem.MSG_ALTERED_PALETTE:
 			rz.getDatabase().getPaletten().getPalettenListe(lstPaletten);
 			rechnen();
 	      	break;
        default:
            rz.getLogFactory().logMessage(2, "palettenrechner", "auswahlAction:" + msg.getMsgCode());
            break;
        }
    }

    @Override
	public void createActions(){
        actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT, KeyEvent.VK_F5 ,InputEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT, KeyEvent.VK_F1 ,0));
		actionList.put(String.valueOf(ACTION_OK_CODE), new AuswahlAction(rz,this,ACTION_OK_CODE,ACTION_OK_TEXT,KeyEvent.VK_O,	InputEvent.CTRL_DOWN_MASK));
		actionList.put(String.valueOf(ACTION_ABBRECHEN_CODE), new AuswahlAction(rz,this, ACTION_ABBRECHEN_CODE,ACTION_ABBRECHEN_TEXT,KeyEvent.VK_ESCAPE, 0));
	    actionList.put(String.valueOf(ACTION_PALETTEN_CODE),new AuswahlAction(rz,this,ACTION_PALETTEN_CODE,ACTION_PALETTEN_TEXT, 0,0));

    }

    /**
     * Palettenfenster
     */
    private void palettenAction() {
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_PALETTENLISTE,true,new MessageItem(MessageItem.MSG_SHOW_PALETTENLISTE,0,null,this));
    }

    /**
     * ok gedrückt... abspeichern oder ändern
     */
    private void okAction(){
        toOptions();
        try {
        	String comment="";
        	if(lstPaletten.getSelectedIndex() != -1) {
        		final PalettenItem pi = (PalettenItem)lstPaletten.getSelectedValue();
        		if(pi != null) {
	        		comment += pi.getBezeichnung() + " (" ;
	        		comment += rz.getLocale().getString("palettenrechner.reply")
	        			.replaceAll("%s",rz.getLocale().formatNumber(liter,OptionFactory.NF_NORMAL))
	        			.replaceAll("%f",rz.getLocale().formatNumber(flaschen,OptionFactory.NF_NORMAL));
	        		comment += ") ";
	        		//comment += "(" + txtPaletten.getText() + "," + txtKartons.getText() + "," + txtFlaschen.getText() + ") ";
	        		comment += menge;
	        	}
        	}
        	final PalettenReturnItem pr = new PalettenReturnItem(rechnen(),comment);
            mi.getOrigin().getMessage(new MessageItem(MessageItem.MSG_PALETTENRECHNER_REPLY,0,pr,this));
        }catch (final Exception e) {}
        closeWindow();
    }

    /**
     * cancel
     */
    private void cancelAction(){
    	closeWindow();
    }


    @Override
	public void closeWindow(){
    	toOptions();
        rz.getFensterFactory().getFensterListe().disposeFrame(this);
    }
    @Override
	public void openWindow(){
        if (!isVisible()) {
			setVisible(true);
		}
        toFront();
        txtPaletten.requestFocus();
        txtPaletten.selectAll();
    }
    /**
     * rechnen
     */
    private double rechnen() {
    	liter = 0.0;
    	flaschen = 0.0;
    	if(lstPaletten.getSelectedIndex() != -1) {
    		final PalettenItem pi = (PalettenItem)lstPaletten.getSelectedValue();
    		if(pi != null) {
	    		final double p = (txtPaletten.getValue()  * pi.getKarton_per_palette() * pi.getFlaschen_per_karton());
	    		final double k = (txtKartons.getValue() * pi.getFlaschen_per_karton());
	    		final double f = (txtFlaschen.getValue());
	    		final double kp = (txtKorrekturPaletten.getValue()  * pi.getKarton_per_palette() * pi.getFlaschen_per_karton());
	    		final double kk = (txtKorrekturKartons.getValue() * pi.getFlaschen_per_karton());
	    		final double kf = (txtKorrekturFlaschen.getValue());
	    		flaschen = p + k + f - kp - kk -kf;
	    		liter = flaschen * pi.getInhalt();
	    		lblDaten.setText(rz.getLocale().getString("palettenrechner.label_daten")
	    				.replaceAll("%i",rz.getLocale().formatNumber(pi.getInhalt(),OptionFactory.NF_NORMAL))
	    				.replaceAll("%f",String.valueOf(pi.getFlaschen_per_karton()))
	    				.replaceAll("%k",String.valueOf(pi.getKarton_per_palette()))
	    		);
	    	   
	    	   	int pm = (int) Math.floor( (flaschen / (pi.getFlaschen_per_karton() * pi.getKarton_per_palette())));
	    	   	int restflaschen = (int) Math.floor((flaschen - pi.getFlaschen_per_karton() *  pi.getKarton_per_palette() * pm));
	    	   	int pk = 0;
	    	   	try {
	    	   		pk = restflaschen / pi.getFlaschen_per_karton();
	    	   	}catch(Exception e) {
	    	   		
	    	   	}
	    	   	int pf = (int) Math.floor((flaschen - (pk * pi.getFlaschen_per_karton()) - (pm * pi.getFlaschen_per_karton() * pi.getKarton_per_palette()) ));
	    	   	menge = rz.getLocale().getString("palettenrechner.ergebnis")
	    	   			.replaceAll("%p", String.valueOf(pm))
	    	   			.replaceAll("%k", String.valueOf(pk))
	    	   			.replace("%f", String.valueOf(pf));
	    	   			
	    	   	
	    		
	
	    		if(liter <= 0 || flaschen <= 0) {
	    			lblAnzeige.setText(rz.getLocale().getString("palettenrechner.negativ"));
	    		    getAction(ACTION_OK_CODE).setEnabled(false);
	    		} else {
	    			lblAnzeige.setText(rz.getLocale().getString("palettenrechner.label_anzeige")
		    	   			.replaceAll("%s",rz.getLocale().formatNumber(liter,OptionFactory.NF_NORMAL))
		    	   			.replaceAll("%f",rz.getLocale().formatNumber(flaschen,OptionFactory.NF_NORMAL))
		    	   			.replaceAll("%m", menge));
	    		    getAction(ACTION_OK_CODE).setEnabled(true);
	    		}
	    	}
    	}
    	return liter;
    }

    /**
     * WErte aus Optionen holen
     */
    private void fromOptions() {
    	try {
    		final int sel = rz.getOptionFactory().getOption("palettenrechner.palette",0);
    		if(lstPaletten.getModel().getSize() >= sel) {
    			lstPaletten.setSelectedIndex(sel);
    		}
    	}catch (final Exception e) {}
    	txtPaletten.setValue( rz.getOptionFactory().getOption("palettenrechner.paletten_count",0));
       	txtKartons.setValue( rz.getOptionFactory().getOption("palettenrechner.kartons_count",0));
       	txtFlaschen.setValue( rz.getOptionFactory().getOption("palettenrechner.flaschen_count",0));
    	rechnen();
    }
    /**
     * Werte in Options speichern
     */
    private void toOptions() {
    	rz.getOptionFactory().setOption("palettenrechner.paletten_count",txtPaletten.getValue());
    	rz.getOptionFactory().setOption("palettenrechner.kartons_count",txtKartons.getValue());
    	rz.getOptionFactory().setOption("palettenrechner.flaschen_count",txtFlaschen.getValue());
    	if(lstPaletten.getSelectedIndex() != -1) {
    	   	rz.getOptionFactory().setOption("palettenrechner.palette",lstPaletten.getSelectedIndex());
    	}
    	rz.getOptionFactory().saveOptions();
    }
	//hilfe
	private void hilfeAction() {
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"palettenrechner.html",this));
	}

    private void hideAction() {
        rz.getFensterFactory().getFensterListe().sperren(this);
    }
}


