/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/*
 * db ist die zentrale Schnittstelle zur Datenbank. Hier wird die Verbindung
 * zur Datenbank aufgebaut, abgebaut und alle Datentransfers laufen �ber
 * diese Klasse. Keine andere Klasse im Programm nimmt eigenst�ndige
 * Verbindungen zur Datenbank auf
 *
 */


package de.lunqual.rzpro.fenster.probenfenster;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;

import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.SwingConstants;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fenster.JRzList;
import de.lunqual.rzpro.fenster.JRzTextPane;
import de.lunqual.rzpro.fenster.JSelectedTextField;
import de.lunqual.rzpro.fenster.ZutatenDialog;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.abfrage.AbfrageItem;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.adressen.AdressItem;
import de.lunqual.rzpro.items.buchung.HerstellungsItem;
import de.lunqual.rzpro.items.buchung.LosnummerItem;
import de.lunqual.rzpro.items.ergebnis.ErgebnisItem;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.mischungen.TicketItem;
import de.lunqual.rzpro.items.proben.ProbenItem;
import de.lunqual.rzpro.items.rezeptur.ZutatenSuchItem;
import de.lunqual.rzpro.items.stichworte.StichwortItem;
import de.lunqual.rzpro.items.stichworte.StichwortListe;
import de.lunqual.rzpro.log.LogFactory;
import de.lunqual.rzpro.options.OptionFactory;
import de.lunqual.rzpro.items.lieferschein.LieferscheinProbe;
/**
 *
 * @author  administrator
 */
public class ProbenEingabe extends JRzFrame {

    //GUI-Variablen
    private JMenuBar mb;
    private JMenu mnuDatei;
    private JMenu mnuBearbeiten;
    private JMenu mnuExtras;
    private JMenu mnuHilfe;

    private JPanel mainPanel;
    	private JPanel toolbarPanel;
    		private JToolBar tb1;
    	private JPanel contentPanel;
    		private JPanel topPanel;
    			private JPanel labelPanel;
    				private JLabel lblNummer;
    			private JPanel bezeichnungsPanel;
    				private JLabel lblBezeichnung;
    				private JSelectedTextField txtBezeichnung;
    			private JPanel rezepturPanel;
    				private JPanel r1Panel;
    					private JLabel lblRezeptur;
    					private JButton btRezeptur;
    				private JLabel lblRezepturBezeichnung;
    				private JButton btDeleteRezeptur;
    			private JPanel losnummerPanel;
    				private JLabel lblLosnummer;
    				private JSelectedTextField txtLosnummer;
    		private JPanel bottomPanel;
    			private JSplitPane splVertical;
    				private JPanel leftPanel;
    					private JPanel adrTopPanel;
		    				private JLabel lblAdresslisteTitel;
			    			private JScrollPane scrAdressen;
			    				private JRzList lstAdressen;
			    			private JPanel adressButtonPanel;
			    		    	private JButton btAdressenBearbeiten;
			    		    	private JButton btAdresslisteLoeschen;
    				private JPanel rightPanel;
    					private JLabel lblBemerkungen;
    						private JScrollPane scrBemerkungen;
    							private JRzTextPane txtBemerkungen;
  		private JPanel buttonPanel;
   			private JButton btSave;
   			private JButton btHilfe;
   			private JButton btCancel;

    // ActionCodes NotizFenster
    public static final int         ACTION_SAVE_CODE = 1000;
    public static final String      ACTION_SAVE_TEXT = "probeneingabe.action_save";
    public static final int         ACTION_ABBRECHEN_CODE = 1001;
    public static final String      ACTION_ABBRECHEN_TEXT = "probeneingabe.action_abbrechen";
    public static final int         ACTION_ADRESSLISTE_BEARBEITEN_CODE = 1002;
    public static final String      ACTION_ADRESSLISTE_BEARBEITEN_TEXT = "probeneingabe.action_adressliste_bearbeiten";
    public static final int         ACTION_ADRESSLISTE_LOESCHEN_CODE = 1003;
    public static final String      ACTION_ADRESSLISTE_LOESCHEN_TEXT = "probeneingabe.action_adressliste_loeschen";
    public static final int         ACTION_REZEPTUR_LOESCHEN_CODE = 1004;
    public static final String      ACTION_REZEPTUR_LOESCHEN_TEXT = "probeneingabe.action_rezeptur_loeschen";
    public static final int         ACTION_REZEPTUR_SUCHEN_CODE = 1005;
    public static final String      ACTION_REZEPTUR_SUCHEN_TEXT = "probeneingabe.action_rezeptur_suchen";

    public static final int         ACTION_HIDE_CODE = 1006;
    public static final String      ACTION_HIDE_TEXT = "action_hide";
    public static final int         ACTION_HILFE_CODE = 1007;
    public static final String      ACTION_HILFE_TEXT= "action_hilfe";
    
    boolean 							showProbeWhenDone = true;

    JRzFrame			origin;
    ProbenItem		probe;
	ZutatenDialog 		zd;

    ErgebnisItem callerObject;
    /** Creates new form notizFenster */
    public ProbenEingabe(RzPro r, String name,Object extendedData) {
        super(r,name,extendedData);
        createActions();
        createGUIComponents();
        setGUIComponents();
        getMessage((MessageItem)extendedData);
    }

    @Override
	public void createGUIComponents() {
        mb = new JMenuBar();
		mnuDatei = new JMenu();
			mb.add(mnuDatei);
		mnuBearbeiten = new JMenu();
			mb.add(mnuBearbeiten);
        mnuExtras = new JMenu();
        	mb.add(mnuExtras);
        mnuHilfe = new JMenu();
        	mb.add(mnuHilfe);
		setJMenuBar(mb);
		mainPanel = new JPanel(new BorderLayout());
			toolbarPanel = new JPanel(new BorderLayout());
				tb1 = new JToolBar();
				tb1.setFloatable(false);
				tb1.setRollover(true);
				toolbarPanel.add(tb1);
			mainPanel.add(toolbarPanel,BorderLayout.NORTH);
			contentPanel  = new JPanel(new BorderLayout());
				topPanel = new JPanel();
				topPanel.setLayout(new BoxLayout(topPanel, BoxLayout.PAGE_AXIS));
				topPanel.setBorder(BorderFactory.createRaisedBevelBorder());
					labelPanel = new JPanel(new BorderLayout());
						lblNummer = new JLabel();
						lblNummer.setHorizontalAlignment(SwingConstants.CENTER);
					labelPanel.add(lblNummer,BorderLayout.CENTER);
				topPanel.add(labelPanel);
					bezeichnungsPanel=new JPanel(new BorderLayout());
						lblBezeichnung=new JLabel();
						bezeichnungsPanel.add(lblBezeichnung,BorderLayout.WEST);
						txtBezeichnung = new JSelectedTextField();
						bezeichnungsPanel.add(txtBezeichnung,BorderLayout.CENTER);
				topPanel.add(bezeichnungsPanel);
				rezepturPanel = new JPanel(new BorderLayout());
					r1Panel=new JPanel(new BorderLayout());
							lblRezeptur = new JLabel();
						r1Panel.add(lblRezeptur,BorderLayout.WEST);
							btRezeptur = new JButton();
						r1Panel.add(btRezeptur,BorderLayout.EAST);
					rezepturPanel.add(r1Panel,BorderLayout.WEST);
						lblRezepturBezeichnung=new JLabel();
					rezepturPanel.add(lblRezepturBezeichnung,BorderLayout.CENTER);
						btDeleteRezeptur=new JButton();
					rezepturPanel.add(btDeleteRezeptur,BorderLayout.EAST);
				topPanel.add(rezepturPanel);
					losnummerPanel = new JPanel(new BorderLayout());
						lblLosnummer=new JLabel();
						losnummerPanel.add(lblLosnummer,BorderLayout.WEST);
						txtLosnummer=new JSelectedTextField();
						losnummerPanel.add(txtLosnummer,BorderLayout.CENTER);
				topPanel.add(losnummerPanel);
				bottomPanel=new JPanel(new BorderLayout());
					splVertical = new JSplitPane();
					splVertical.setDividerSize(6);
				 	splVertical.setOrientation(JSplitPane.HORIZONTAL_SPLIT);
						leftPanel=new JPanel(new BorderLayout());
							adrTopPanel = new JPanel(new BorderLayout());
		    				lblAdresslisteTitel=new JLabel();
		    				lblAdresslisteTitel.setHorizontalAlignment(SwingConstants.CENTER);
		    				adrTopPanel.add(lblAdresslisteTitel,BorderLayout.NORTH);
		    				scrAdressen = new JScrollPane();
		    					lstAdressen = new JRzList();
		    					lstAdressen.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		    						scrAdressen.setViewportView(lstAdressen);
		    					adrTopPanel.add(scrAdressen,BorderLayout.CENTER);
		    			    adressButtonPanel = new JPanel(new BorderLayout());
		    		    		btAdressenBearbeiten = new JButton();
		    		    			adressButtonPanel.add(btAdressenBearbeiten,BorderLayout.NORTH);
		    		    		btAdresslisteLoeschen = new JButton();
		    		    			adressButtonPanel.add(btAdresslisteLoeschen,BorderLayout.SOUTH);
		    		    	adrTopPanel.add(adressButtonPanel,BorderLayout.SOUTH);
						leftPanel.add(adrTopPanel,BorderLayout.CENTER);
						rightPanel = new JPanel(new BorderLayout());
							lblBemerkungen=new JLabel();
							rightPanel.add(lblBemerkungen,BorderLayout.NORTH);
							scrBemerkungen = new JScrollPane();
								txtBemerkungen = new JRzTextPane(rz.getLocale().getNumberFormat(OptionFactory.NF_NORMAL));
								txtBemerkungen.addKeyListener(new java.awt.event.KeyAdapter() {
										@Override
										public void keyReleased(java.awt.event.KeyEvent evt) {
												txtTextKeyReleased(evt);
										}
								});
			        	scrBemerkungen.setViewportView(txtBemerkungen);
		        rightPanel.add(scrBemerkungen,BorderLayout.CENTER);


					splVertical.setLeftComponent(leftPanel);
					splVertical.setRightComponent(rightPanel);


				bottomPanel.add(splVertical,BorderLayout.CENTER);
				bottomPanel.setBorder(BorderFactory.createRaisedBevelBorder());
			contentPanel.add(topPanel,BorderLayout.NORTH);
			contentPanel.add(bottomPanel,BorderLayout.CENTER);

			buttonPanel=new JPanel(new GridLayout(1,3));
				btSave = new JButton();
					buttonPanel.add(btSave);
				btHilfe = new JButton();
					buttonPanel.add(btHilfe);
				btCancel = new JButton();
					buttonPanel.add(btCancel);

		mainPanel.add(toolbarPanel,BorderLayout.NORTH);
		mainPanel.add(contentPanel,BorderLayout.CENTER);
		mainPanel.add(buttonPanel,BorderLayout.SOUTH);
		getContentPane().setLayout(new BorderLayout());
		getContentPane().add(mainPanel,BorderLayout.CENTER);

    }


    @Override
	public void setGUIComponents() {
      setTitle(rz.getVersionString() + " " + rz.getLocale().getString("probeneingabe.titel"));

      mnuDatei.setText(rz.getLocale().getString("menu.datei"));
      mnuBearbeiten.setText(rz.getLocale().getString("menu.bearbeiten"));
      mnuExtras.setText(rz.getLocale().getString("menu.extras"));
      mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));

      mnuDatei.add(getAction(ACTION_SAVE_CODE));
      mnuDatei.addSeparator();
      mnuDatei.add(getAction(ACTION_ABBRECHEN_CODE));

      mnuBearbeiten.add(getAction(ACTION_ADRESSLISTE_BEARBEITEN_CODE));
      mnuBearbeiten.addSeparator();
      mnuBearbeiten.add(getAction(ACTION_ADRESSLISTE_LOESCHEN_CODE));


      mnuExtras.add(getAction(ACTION_HIDE_CODE));
      mnuHilfe.add(getAction(ACTION_HILFE_CODE));


	  tb1.add(getAction(ACTION_SAVE_CODE));
	  tb1.add(getAction(ACTION_ABBRECHEN_CODE));
	  tb1.addSeparator();
	  tb1.add(getAction(ACTION_HIDE_CODE));
	  tb1.addSeparator();
	  tb1.add(getAction(ACTION_ADRESSLISTE_BEARBEITEN_CODE));
	  tb1.add(getAction(ACTION_ADRESSLISTE_LOESCHEN_CODE));
	  tb1.addSeparator();
	  tb1.add(getAction(ACTION_HILFE_CODE));


      btSave.setAction(getAction(ACTION_SAVE_CODE));
      btHilfe.setAction(getAction(ACTION_HILFE_CODE));
      btCancel.setAction(getAction(ACTION_ABBRECHEN_CODE));

      btRezeptur.setAction(getAction(ACTION_REZEPTUR_SUCHEN_CODE));
      btDeleteRezeptur.setAction(getAction(ACTION_REZEPTUR_LOESCHEN_CODE));
      btAdresslisteLoeschen.setAction(getAction(ACTION_ADRESSLISTE_LOESCHEN_CODE));
      btAdressenBearbeiten.setAction(getAction(ACTION_ADRESSLISTE_BEARBEITEN_CODE));

      lblBezeichnung.setText(rz.getLocale().getString("probeneingabe.label_bezeichnung"));
      lblRezeptur.setText(rz.getLocale().getString("probeneingabe.label_rezeptur"));
      lblLosnummer.setText(rz.getLocale().getString("probeneingabe.label_losnummer"));
      lblAdresslisteTitel.setText(rz.getLocale().getString("probeneingabe.label_adressen"));
      lblBemerkungen.setText(rz.getLocale().getString("probeneingabe.label_bemerkungen"));

      setResizable(true);
      rz.getFontFactory().setFrameFonts(this);
      pack();
      rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;
      setDividerLocations();
    }

    @Override
	public void createActions(){
        actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT, KeyEvent.VK_F5 ,InputEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT, KeyEvent.VK_F1 ,0));
		actionList.put(String.valueOf(ACTION_SAVE_CODE), new AuswahlAction(rz,this,ACTION_SAVE_CODE,ACTION_SAVE_TEXT,KeyEvent.VK_O,	InputEvent.CTRL_DOWN_MASK));
		actionList.put(String.valueOf(ACTION_ABBRECHEN_CODE), new AuswahlAction(rz,this, ACTION_ABBRECHEN_CODE,ACTION_ABBRECHEN_TEXT,KeyEvent.VK_ESCAPE, 0));
		actionList.put(String.valueOf(ACTION_ADRESSLISTE_BEARBEITEN_CODE),new AuswahlAction(rz,this,ACTION_ADRESSLISTE_BEARBEITEN_CODE,ACTION_ADRESSLISTE_BEARBEITEN_TEXT, KeyEvent.VK_D ,InputEvent.CTRL_DOWN_MASK));
		actionList.put(String.valueOf(ACTION_ADRESSLISTE_LOESCHEN_CODE),new AuswahlAction(rz,this,ACTION_ADRESSLISTE_LOESCHEN_CODE,ACTION_ADRESSLISTE_LOESCHEN_TEXT, KeyEvent.VK_L ,InputEvent.CTRL_DOWN_MASK));
		actionList.put(String.valueOf(ACTION_REZEPTUR_LOESCHEN_CODE),new AuswahlAction(rz,this,ACTION_REZEPTUR_LOESCHEN_CODE,ACTION_REZEPTUR_LOESCHEN_TEXT,0,0));
		actionList.put(String.valueOf(ACTION_REZEPTUR_SUCHEN_CODE),new AuswahlAction(rz,this,ACTION_REZEPTUR_SUCHEN_CODE,ACTION_REZEPTUR_SUCHEN_TEXT, 0,0));

    }


	/** speichert die Position der Splitbalken
	 */
    private void saveDividerLocations(){
        rz.getFensterFactory().setOption(this.getName() + ".splVertical", this.splVertical.getDividerLocation());
        rz.getFensterFactory().saveOptions();
    }
	/** setzt die Position der Splitbalken auf gespeicherte Positionen oder
	 * auf Standardposition, wenn keine gespeicherten vorliegen
	 *
	 */
    private void setDividerLocations() {
        splVertical.setDividerLocation(rz.getFensterFactory().getOption(this.getName() + ".splVertical",this.getWidth()/3));
    }


    @Override
	public void getMessage(MessageItem msg) {
        switch(msg.getMsgCode()) {
    	case MessageItem.MSG_ACTIONPERFORMED:
            switch(msg.getCode()){
            case ACTION_ABBRECHEN_CODE :cancelAction();break;
			case ACTION_ADRESSLISTE_BEARBEITEN_CODE :adressListeBearbeitenAction();break;
			case ACTION_ADRESSLISTE_LOESCHEN_CODE :adressListeLoeschenAction();break;
			case ACTION_REZEPTUR_LOESCHEN_CODE :rezepturLoeschenAction();break;
			case ACTION_REZEPTUR_SUCHEN_CODE :rezepturSuchenAction();break;
			case ACTION_SAVE_CODE :saveAction();break;
            case ACTION_HILFE_CODE: hilfeAction();break;
            case ACTION_HIDE_CODE:hideAction();break;
            default :
                break;
           }
    		break;
        case MessageItem.MSG_ADRESSLISTE_REPLY:
 			probe.setAdressListe(((StichwortListe)msg.getData()).copyList());
     		lstAdressen.setListData(((StichwortListe)msg.getData()).toArray());
      		break;

   	 	case MessageItem.MSG_ZUTATEN_DIALOG_REPLY:
	 			zutatenDialogReply((ZutatenSuchItem)msg.getData());
	 			break;
         case MessageItem.MSG_SHOW_PROBENEINGABE_REZEPTUR:
        	 // Probe aus Rezeptur
        	 probe = rz.getDatabase().getProben().getProbeRezeptur(msg.getCode());
             break;
         case MessageItem.MSG_SHOW_PROBENEINGABE_HERSTELLUNG:
        	 // Probe aus Herstellung
        	 probe = rz.getDatabase().getProben().getProbeHerstellung((HerstellungsItem)msg.getData());
             break;
         case MessageItem.MSG_SHOW_PROBENEINGABE_PROBE:
        	 // Probe aus Rezeptur
        	 probe = rz.getDatabase().getProben().getProbe(msg.getCode());
             break;
         case MessageItem.MSG_SHOW_PROBENEINGABE_ABGANG:
        	 // Probe aus Rezeptur
        	 showProbeWhenDone = false;
        	 probe = rz.getDatabase().getProben().getProbeAbgang((LosnummerItem)msg.getData());
             break;
         case MessageItem.MSG_SHOW_PROBENEINGABE_LIEFERSCHEIN:
        	 // Probe aus Rezeptur
        	 probe = rz.getDatabase().getProben().getProbeLieferschein((LieferscheinProbe)msg.getData());
             break;
         case MessageItem.MSG_SHOW_PROBENEINGABE_VERLAUF:
        	 String z[] = (String[])msg.getData();
        	 int rezeptur_id = Integer.valueOf(z[0]);
        	 try {
        		 String rezepturBezeichnung = rz.getDatabase().getRezeptur().dbGetRezepturName(rezeptur_id);
        		 probe = new ProbenItem(rezepturBezeichnung);
        		 probe.setRezeptur_bezeichnung(rezepturBezeichnung);
        		 
        	 }catch (Exception e) {}
        	 probe.setLosnummer(z[2]);
        	 probe.setAdressListe(new StichwortListe());
        	 probe.setRezeptur(rezeptur_id);
        	 break;
         case MessageItem.MSG_SHOW_PROBENEINGABE_TICKET:
        	 TicketItem ti = (TicketItem)msg.getData();
        	 if(ti != null) {
        		 probe = new ProbenItem(ti.getBezeichnung());
        		 probe.setLosnummer(rz.getLocale().getString("ticketeingabe.probenlosnummer").replaceAll("%n", ti.getNummer()));
        		 probe.setRezeptur(ti.getRezeptur_id());
        		 StichwortListe adressen = new StichwortListe();
        		 AdressItem ai = rz.getDatabase().getAdressen().dbGetAdresse(ti.getAdresse_id(),true);
        		 if(ai != null) {
        			 adressen.addItem(new StichwortItem(ai.getID(),ai.getFirma(),"",""));
        	 	}
        		 probe.setAdressListe(adressen);
        		 if(ti.getRezeptur_id() != 0) {
        			 try {
        				 probe.setRezeptur_bezeichnung(rz.getDatabase().getRezeptur().dbGetRezepturName(ti.getRezeptur_id()));
        			 }catch(Exception e) {
            			 probe.setRezeptur_bezeichnung(ti.getBezeichnung()); 
        			 }
        		 } else {
        			 probe.setRezeptur_bezeichnung(ti.getBezeichnung());
        		 }
        	 }
        	 break;
         default:
            rz.getLogFactory().logMessage(2, "probeneingabe:", "auswahlAction:" + msg.getMsgCode());
            break;
        }
    }


    @Override
	public void closeWindow(){
    	saveDividerLocations();
        rz.getFensterFactory().getFensterListe().disposeFrame(this);
    }

    // fromItem überträgt die Daten eines ProbenItems in das Fenster
    private void fromItem(ProbenItem pi){
    	lblNummer.setText(rz.getLocale().getString("probeneingabe.label_nummer").replaceAll("%n",String.valueOf(pi.getId())));
    	txtBezeichnung.setText(pi.getBezeichnung());
    	lblRezepturBezeichnung.setText(pi.getRezeptur_bezeichnung());
    	txtLosnummer.setText(pi.getLosnummer());
        lstAdressen.setListData (pi.getAdressListe().toArray());
        txtBemerkungen.setText(pi.getBemerkungen());
        txtBemerkungen.setCaretPosition(0);
    }

    // toItem() überträgt die Texte aus dem GUI in das ProbenItem
    private void toItem(ProbenItem pi){
    	pi.setBezeichnung(txtBezeichnung.getText().trim());
    	pi.setRezeptur(pi.getRezeptur());
    	pi.setRezeptur_bezeichnung(lblRezepturBezeichnung.getText().trim());
    	pi.setLosnummer(txtLosnummer.getText().trim());
    	pi.setBemerkungen(txtBemerkungen.getText().trim());
    }
    @Override
	public void openWindow(){
    	if (probe != null) {
    		fromItem(probe);
    		this.setVisible(true);
    		this.toFront();
    		txtBezeichnung.requestFocus();
    	}
    }


    /**
     * Rezeptur entfernen
     */
    private void rezepturLoeschenAction() {
    	probe.setRezeptur(0);
    	probe.setRezeptur_bezeichnung("");
    	lblRezepturBezeichnung.setText("");
    }


	private void zutatenDialogReply(ZutatenSuchItem zi) {
		if(zi != null) {
			try {
				probe.setRezeptur(zi.getID());
				probe.setRezeptur_bezeichnung(zi.getName());
				lblRezepturBezeichnung.setText(zi.getName());
			} catch (final Exception e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_WARN,"probeneingabe.zutatenDialogReply.",e.getLocalizedMessage());
			}
		}
		if(zd!= null) {
			zd.dispose();
			zd = null;
		}
	}

	/** zeigt einen Dialog zur Auswahl eines VerweisZiels an
	 *
	 *
	 */

    private void rezepturSuchenAction() {
		int x, y;
		x = (int) (btRezeptur.getLocationOnScreen().getX());
		y = (int) (btRezeptur.getLocationOnScreen().getY());
		if(zd != null) {
			zd.dispose();
			zd = null;
		}
		final ZutatenDialog zd = new ZutatenDialog(this,  rz, x, y,probe.getBezeichnung() ,ZutatenDialog.MODE_REZEPTUREN);
		zd.setVisible(true);
    }
    /**
     * ok gedrückt... abspeichern oder ändern
     */
    private void saveAction(){
    	int i;
    	toItem(probe);
        rz.setWaitCursor(this);
        i = rz.getDatabase().getProben().saveProbe(probe);
        rz.setFreeCursor(this);
        if (i > 0){
        	rz.getFensterFactory().getFensterListe().propagateBestand(this,probe.getId());
        	rz.getFensterFactory().getFensterListe().propagateProbe(this,probe.getId());
        	if(showProbeWhenDone) {
        		rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_PROBE,true,new MessageItem(MessageItem.MSG_PROBEN_EDIT_REPLY,0,null,this));
        	}
        }
        cancelAction();
    }

    /**
     * cancel
     */
    private void cancelAction(){
        closeWindow();
        this.dispose();
    }

    private void adressListeBearbeitenAction() {
		final AbfrageItem ai = new AbfrageItem();
		ai.setAdressListe(probe.getAdressListe().copyList());
    	rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_ADRESSAUSWAHL,true,new MessageItem(MessageItem.MSG_ADRESSLISTE_REQUEST,0,ai,this));
    }
    private void adressListeLoeschenAction() {
        probe.getAdressListe().clear();
        lstAdressen.setListData(probe.getAdressListe().toArray());
        txtBezeichnung.requestFocus();
    }

	//hilfe
	private void hilfeAction() {
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"neue_probe.html",this));
	}

    private void hideAction() {
        rz.getFensterFactory().getFensterListe().sperren(this);
    }

	private void txtTextKeyReleased(java.awt.event.KeyEvent evt) {
		/**
		 * Pattern matching
		 */
	    if(evt.getKeyCode() == KeyEvent.VK_TAB) {
	        this.transferFocus();
	    }
	    if((evt.getKeyCode() == KeyEvent.VK_TAB) && (evt.getModifiers()== InputEvent.CTRL_DOWN_MASK)) {
	        this.transferFocusBackward();
	    }
	}

}
