/*
 * Created on 07.09.2004
 *
 */
package de.lunqual.rzpro.fenster.rechenfenster;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.math.BigDecimal;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingConstants;
import javax.swing.border.BevelBorder;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.fenster.JNumberField;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.currency.CurrencyItem;
import de.lunqual.rzpro.items.einheiten.EinheitsItem;
import de.lunqual.rzpro.items.ergebnis.DependencyListe;
import de.lunqual.rzpro.items.ergebnis.IDItem;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.rezeptur.ChangesListe;
import de.lunqual.rzpro.options.OptionFactory;

/**
 * @author labor
 *
 */
public class RechenKalkulationDialog extends JDialog {
    //GUI-Variablen
    private JPanel contentPanel;
     	private JLabel lblTitel;
    	private JPanel leftPanel;
    			private JLabel lblIcon;
    		private JPanel rightPanel;
    			private JLabel lblMessage;
    				private JPanel eingabePanel;
    					private JNumberField txtPreisMenge;
    					private JComboBox cmbEinheiten;
    					private JLabel lblKostet;
    					private JNumberField txtPreis;
    					private JComboBox cmbWaehrungen;
    					private JButton btSave;
    	private JPanel buttonPanel;
    		private JButton btOK;
    		private JButton btCancel;

    public static final int         	DIALOG_CANCEL     	= 0;
    public static final int			DIALOG_OK				= 1;

    RzPro				rz;

    int				numberFormat;
    double			minValue;
    double 			maxValue;
    double 			preisMenge;
    int				preisEinheit;
    BigDecimal		preis;
    
    BigDecimal preisAlt=new BigDecimal(0.0);
    double       preisMengeAlt = 0.0;
    int				  preisEinheitAlt =0;
    
    int				waehrung;
    String			bezeichnung;
    String			alt;
    int				code;
    JFrame 			parent;
    int				key;
    JFrame	dependencyFrame=null;

    public RechenKalkulationDialog(RzPro r,JFrame parent) {
    	super(parent,true);
        rz = r;
        minValue = 0.0;
        maxValue = Double.POSITIVE_INFINITY;
        preisMenge = 0.0;
        preisEinheit = 1;
        preis = new BigDecimal(0.0);
        waehrung = 1;
        code = DIALOG_CANCEL;
        numberFormat = OptionFactory.NF_NORMAL;
        this.parent = parent;
        createGUIComponents();
        setGUIComponents();
    }


    private void createGUIComponents() {
		final GridBagConstraints c = new GridBagConstraints();
        getContentPane().setLayout(new BorderLayout());
        addComponentListener(new java.awt.event.ComponentAdapter() {
            @Override
			public void componentShown(java.awt.event.ComponentEvent evt) {
                formComponentShown(evt);
            }
        });
        contentPanel = new JPanel(new BorderLayout());
	        lblTitel = new JLabel();
	    	lblTitel.setForeground(Color.WHITE);
	    	lblTitel.setBackground(Color.BLUE);
	    	lblTitel.setOpaque(true);
	        	lblTitel.setHorizontalAlignment(SwingConstants.CENTER);
	            contentPanel.add(lblTitel,BorderLayout.NORTH);
	        	leftPanel = new JPanel(new BorderLayout());
	        		lblIcon = new JLabel();
	        			lblIcon.setHorizontalAlignment(SwingConstants.CENTER);
	        			lblIcon.setVerticalAlignment(SwingConstants.CENTER);
	        		leftPanel.add(lblIcon,BorderLayout.WEST);
	        	rightPanel = new JPanel(new BorderLayout());
	        	    lblMessage = new JLabel();
	        	    	lblMessage.setHorizontalAlignment(SwingConstants.CENTER);
	        	    rightPanel.add(lblMessage,BorderLayout.NORTH);
	        	    	eingabePanel = new JPanel(new FlowLayout());
			        		txtPreisMenge= new JNumberField(rz.getLocale().getNumberFormat(numberFormat),preisMenge,minValue,maxValue);
				 	        txtPreisMenge.addKeyListener(new java.awt.event.KeyAdapter() {
				 	            @Override
								public void keyReleased(java.awt.event.KeyEvent evt) {
				 	                switch(evt.getKeyCode())  {
				 	                    case KeyEvent.VK_ENTER :
					 	                	okPressed(false);
					 	                	break;
					 	                case KeyEvent.VK_ESCAPE:
					 	                	code = DIALOG_CANCEL;
					 	                	setVisible(false);
					 	                	break;
				 	                	}
				 	            	}
				 	        	});
				 	        txtPreisMenge.setColumns(6);
				 	        eingabePanel.add(txtPreisMenge);
			        		cmbEinheiten= new JComboBox();
				 	        cmbEinheiten.addKeyListener(new java.awt.event.KeyAdapter() {
				 	            @Override
								public void keyReleased(java.awt.event.KeyEvent evt) {
				 	                switch(evt.getKeyCode())  {
				 	                    case KeyEvent.VK_ENTER :
				 	                       okPressed(false);
					 	                	break;
					 	                case KeyEvent.VK_ESCAPE:
					 	                	code = DIALOG_CANCEL;
					 	                	setVisible(false);
					 	                	break;
				 	                	}
				 	            	}
				 	        	});
				 	        eingabePanel.add(cmbEinheiten);
				 	        lblKostet = new JLabel();
				 	        	lblKostet.setHorizontalAlignment(SwingConstants.CENTER);
					 	    eingabePanel.add(lblKostet);
			        		txtPreis= new JNumberField(rz.getLocale().getNumberFormat(numberFormat),preis.doubleValue(),minValue,maxValue);
				 	        txtPreis.addKeyListener(new java.awt.event.KeyAdapter() {
				 	            @Override
								public void keyReleased(java.awt.event.KeyEvent evt) {
				 	                switch(evt.getKeyCode())  {
				 	                    case KeyEvent.VK_ENTER :
				 	                       okPressed(false);
					 	                	break;
					 	                case KeyEvent.VK_ESCAPE:
					 	                	code = DIALOG_CANCEL;
					 	                	setVisible(false);
					 	                	break;
				 	                	}
				 	            	}
				 	        	});
				 	        txtPreis.setColumns(6);
				 	        eingabePanel.add(txtPreis);
			        		cmbWaehrungen= new JComboBox();
				 	        cmbWaehrungen.addKeyListener(new java.awt.event.KeyAdapter() {
				 	            @Override
								public void keyReleased(java.awt.event.KeyEvent evt) {
				 	                switch(evt.getKeyCode())  {
				 	                    case KeyEvent.VK_ENTER :
				 	                       okPressed(false);
					 	                	break;
					 	                case KeyEvent.VK_ESCAPE:
					 	                	code = DIALOG_CANCEL;
					 	                	setVisible(false);
					 	                	break;
				 	                	}
				 	            	}
				 	        	});
				 	        eingabePanel.add(cmbWaehrungen);
				 	        btSave = new JButton();
				       	     btSave.addActionListener(new ActionListener() {
			       	            public void actionPerformed(ActionEvent evt) {
			       	            		if(key != 0) {
			       	            		    //speichern
			       	            		 okPressed(true);
			       	            		}
			       	            	}
			       	        	});
				 	     	eingabePanel.add(btSave);
	        	rightPanel.add(eingabePanel,BorderLayout.SOUTH);
	        	contentPanel.add(leftPanel,BorderLayout.WEST);
	        	contentPanel.add(rightPanel,BorderLayout.CENTER);
	        	buttonPanel = new JPanel(new GridBagLayout());
	    			c.weightx = 1;c.fill = GridBagConstraints.BOTH;
	    			c.insets = new Insets(5,5,5,5);
	    			c.gridx=0;c.gridy=0;c.gridwidth=1;c.gridheight=1;
	        		btOK = new JButton();
	        	     btOK.addActionListener(new ActionListener() {
	        	            public void actionPerformed(ActionEvent evt) {
	        	            		okPressed(false);
	        	            	}
	        	        	});
	        	        btOK.addKeyListener(new java.awt.event.KeyAdapter() {
	        	            @Override
							public void keyReleased(java.awt.event.KeyEvent evt) {
	        	                	if(evt.getKeyCode() == KeyEvent.VK_ESCAPE) {
	            	            		code = DIALOG_CANCEL;
	            	            		setVisible(false);
	        	                	}
	        	            	}
	        	        	});
	        		buttonPanel.add(btOK,c);
	        		btCancel = new JButton();
		       	     btCancel.addActionListener(new ActionListener() {
		 	            public void actionPerformed(ActionEvent evt) {
		 	            		code = DIALOG_CANCEL;
	 	                		setVisible(false);
		 	            	}
		 	        	});
		 	        btCancel.addKeyListener(new java.awt.event.KeyAdapter() {
		 	            @Override
						public void keyReleased(java.awt.event.KeyEvent evt) {
		 	                	code =DIALOG_CANCEL;
		 	                	setVisible(false);
		 	            	}
		 	        	});
	    			c.gridx=1;c.gridy=0;c.gridwidth=1;c.gridheight=1;
	        		buttonPanel.add(btCancel,c);
              contentPanel.add(buttonPanel,BorderLayout.SOUTH);
              contentPanel.setBorder(BorderFactory.createBevelBorder(BevelBorder.RAISED));
              getContentPane().add(contentPanel,BorderLayout.CENTER);
        setResizable(false);
    }

    private void setGUIComponents() {
    	this.setUndecorated(true);
        setTitle(rz.getLocale().getString("rechnen.kalkulationdialog"));
        lblTitel.setText(getTitle());
        lblIcon.setIcon(new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/frage.png" )));
        btSave.setIcon(new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/rechenkalkulationdialog.speichern.png" )));
        btSave.setText(rz.getLocale().getString("rechenkalkulationdialog.speichern"));
        lblKostet.setText(rz.getLocale().getString("rechenkalkulationdialog.kostet"));
        btOK.setText(rz.getLocale().getString("string_ok"));
        btCancel.setText(rz.getLocale().getString("string_abbrechen"));
        rz.getFontFactory().setFrameFonts(this);
    }

    /** den Dialog anzeigen
     *
     */
    public void  showDialog() {
    	code = DIALOG_CANCEL;

    	rz.getDatabase().getEinheiten().setGrundeinheitenCmb(cmbEinheiten,preisEinheit);
    	rz.getDatabase().getCurrency().dbGetCurrencyListeCombo(cmbWaehrungen,waehrung);
    	txtPreisMenge.setValue(preisMenge);
    	txtPreis.setValue(preis.doubleValue());
      
    	preisAlt=preis;
    	preisMengeAlt=preisMenge;
    	preisEinheitAlt=preisEinheit;
    	
        lblMessage.setText(rz.getLocale().getString("rechenkalkulationdialog.message")
                    	.replaceAll("%z",bezeichnung)
                    	.replaceAll("%s",alt));

        pack();
        this.setLocationRelativeTo(parent);
        setVisible(true);
    }

    public void okPressed(boolean save) {
        code = DIALOG_OK;
        preisMenge = txtPreisMenge.getValue();
        preisEinheit = ((EinheitsItem)cmbEinheiten.getSelectedItem()).getID();
        waehrung = ((CurrencyItem)cmbWaehrungen.getSelectedItem()).getID();
        preis = new BigDecimal(txtPreis.getValue()).setScale(RzPro.CURRENCY_DEFAULT_SCALE,java.math.BigDecimal.ROUND_HALF_UP);
        
        if(save) {
        	ChangesListe liste  = new ChangesListe(rz,key);
            rz.getDatabase().getRezeptur().updateKalkulation(key, preisMenge, preisEinheit, preis, waehrung);
			rz.getDatabase().getRezeptur().calcSingle(key,RzPro.TYP_ID_REZEPT);
			liste.commit();
			if(key != 0 && ((!preisAlt.equals(preis))  || (Math.abs(preisMengeAlt -preisMenge) > RzPro.DOUBLE_NULL ) ||( preisEinheitAlt != preisEinheit) )) {
        		rz.setWaitCursor(this);
        		final DependencyListe el = rz.getDatabase().getErgebnis().dbGetErgebnisListeByID(key,true);
        		rz.setFreeCursor(this);
        		if(el.size() > 0) {
     		       dependencyFrame = rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_DEPENDENCY,false,new MessageItem(MessageItem.MSG_DEPENDENCY_CALC,0,new IDItem(el,bezeichnung),parent));
        		}
			}
        }
        setVisible(false);
    }

    private void formComponentShown(java.awt.event.ComponentEvent evt) {
        txtPreisMenge.requestFocus();
    }

	public int getCode() {
		return code;
	}


	public void setBezeichnung(String bezeichnung) {
		this.bezeichnung = bezeichnung;
	}


    public int getKey() {
        return key;
    }
    public void setKey(int key) {
        this.key = key;
    }


    public BigDecimal getPreis() {
        return preis;
    }
    public void setPreis(BigDecimal preis) {
        this.preis = preis;
    }
    public int getPreisEinheit() {
        return preisEinheit;
    }
    public void setPreisEinheit(int preisEinheit) {
        this.preisEinheit = preisEinheit;
    }
    public double getPreisMenge() {
        return preisMenge;
    }
    public void setPreisMenge(double preisMenge) {
        this.preisMenge = preisMenge;
    }
    public int getWaehrung() {
        return waehrung;
    }
    public void setWaehrung(int waehrung) {
        this.waehrung = waehrung;
    }
    public void setAlt(String alt) {
        this.alt = alt;
    }
    
    public JFrame getDependencyFrame() {
    	return dependencyFrame;
    }
}