	package de.lunqual.rzpro.fenster.rechenfenster;
	import java.awt.BorderLayout;

	import java.awt.event.KeyEvent;

	import javax.swing.JButton;
	import javax.swing.JLabel;
	import javax.swing.JMenu;
	import javax.swing.JMenuBar;
	import javax.swing.JPanel;
	import javax.swing.JScrollPane;
	import javax.swing.JTextPane;
	import javax.swing.JToolBar;
	import javax.swing.SwingConstants;
	import javax.swing.text.BadLocationException;
	
	import de.lunqual.rzpro.RzPro;
	import de.lunqual.rzpro.fenster.JRzFrame;
	import de.lunqual.rzpro.fenster.JRzTextPane;
	import de.lunqual.rzpro.fenster.ZutatenDialog;
	import de.lunqual.rzpro.fenster.dialoge.DialogControl;
	import de.lunqual.rzpro.fenster.rezepturfenster.EinheitenDialog;
	import de.lunqual.rzpro.fensterfactory.FensterFactory;
	import de.lunqual.rzpro.items.action.AuswahlAction;
	import de.lunqual.rzpro.items.dialog.DialogItem;
	import de.lunqual.rzpro.items.einheiten.EinheitsItem;
	import de.lunqual.rzpro.items.message.MessageItem;
	import de.lunqual.rzpro.items.rechnen.RechenItem;
	import de.lunqual.rzpro.items.rezeptur.ZutatenSuchItem;
	import de.lunqual.rzpro.log.LogFactory;
	import de.lunqual.rzpro.options.OptionFactory;
	/**
	 *
	 * @author  lunqual
	 */
	public class RezepturEditFenster extends JRzFrame {

	    //GUI-Variablen
	    private JToolBar tb1;
	    private JMenuBar mb;
	    private JMenu mnuDatei;
	    private JMenu mnuHilfe;
	      private  JPanel contentPanel;
	      	private JPanel tbPanel;
	      	private JPanel centerPanel;
	      		private JPanel titelPanel;
	      			private JLabel lblTitel;
	      		private JPanel textPanel;
	      			private JScrollPane scrText;
	      			private JTextPane txtText;
	  		private JPanel buttonPanel;
  	    		private JButton btSave;	
  	    		private JButton btClose;
		

	    public static final int         		ACTION_CANCEL_CODE = 1001;
	    public static final String     			ACTION_CANCEL_TEXT = "rechnen_edit.action_close";
	    public static final int         		ACTION_SAVE_CODE = 1002;
	    public static final String     			ACTION_SAVE_TEXT = "rechnen_edit.action_save";
	    public static final int         		ACTION_REFRESH_CODE = 1003;
	    public static final String     			ACTION_REFRESH_TEXT = "rechnen_edit.action_refresh";

		private static final int GET_REZEPTUR = 1;
	    RechenItem ri;
	    EinheitenDialog ed;
	    ZutatenDialog zd;
		int zd_dialog_typ = GET_REZEPTUR;
		JRzFrame parent;
	    
	    /** Creates new form AdressenFenster */
	    public RezepturEditFenster(RzPro r, String name, Object extendedData) {
	        super(r,name,extendedData);
	        createActions();
	        createGUIComponents();
	        setGUIComponents();
	        getMessage((MessageItem)extendedData);
	    }

	    @Override
		public void createGUIComponents() {
	    	// Menü
	    	mb = new JMenuBar();
	    	mnuDatei = new JMenu();
	    	mnuHilfe = new JMenu();
	    	mb.add(mnuDatei);
	    	setJMenuBar(mb);
			//Toolbar
			tb1 = new JToolBar();
			tb1.setFloatable(false);
			tb1.setRollover(true);
			//ToolbarPanel
			//contentPanel
			contentPanel = new JPanel(new BorderLayout());
				tbPanel = new JPanel(new BorderLayout());
					tbPanel.add(tb1,BorderLayout.NORTH);
			contentPanel.add(tbPanel,BorderLayout.NORTH);
				centerPanel = new JPanel(new BorderLayout());
					titelPanel = new JPanel(new BorderLayout() );
	      				lblTitel = new JLabel() ;
	      					lblTitel.setHorizontalAlignment(SwingConstants.CENTER);
	      				titelPanel.add(lblTitel);
	      			textPanel = new JPanel(new BorderLayout());
	      				scrText = new JScrollPane();
	      				txtText = new JRzTextPane(rz.getLocale().getNumberFormat(
	      						OptionFactory.NF_NORMAL));
	      				scrText.setViewportView(txtText);
	      				txtText.addKeyListener(new java.awt.event.KeyAdapter() {
	      					@Override
	      					public void keyReleased(java.awt.event.KeyEvent evt) {
	      						txtTextKeyReleased(evt);
	      					}
	      				});
						scrText.setViewportView(txtText);
					textPanel.add(scrText,BorderLayout.CENTER);
				 centerPanel.add(titelPanel,BorderLayout.NORTH);
				 centerPanel.add(textPanel,BorderLayout.CENTER);
				 buttonPanel=new JPanel(new BorderLayout());
					btSave = new JButton();
						buttonPanel.add(btSave,BorderLayout.WEST);
					btClose = new JButton();
						buttonPanel.add(btClose,BorderLayout.EAST);
			contentPanel.add(centerPanel,BorderLayout.CENTER);		
			contentPanel.add(buttonPanel,BorderLayout.SOUTH);

		
			//Panels ans Fenster hängen;
			this.getContentPane().setLayout(new BorderLayout());

			this.getContentPane().add(contentPanel, BorderLayout.CENTER);
	    }


	    @Override
		public void setGUIComponents() {
	        setTitle(rz.getVersionString() + " " + rz.getLocale().getString("rechnen_edit.titel"));

			mnuDatei.setText(rz.getLocale().getString("menu.datei"));

			mnuDatei.add(getAction(ACTION_REFRESH_CODE));
			mnuDatei.addSeparator();
			mnuDatei.add(getAction(ACTION_SAVE_CODE));
			mnuDatei.addSeparator();
	        mnuDatei.add(getAction(ACTION_CANCEL_CODE));


			tb1.add(getAction(ACTION_CANCEL_CODE));
			tb1.addSeparator();
			tb1.add(getAction(ACTION_REFRESH_CODE));
			tb1.addSeparator();
	        tb1.add(getAction(ACTION_SAVE_CODE));
			
			btSave.setAction(getAction(ACTION_SAVE_CODE));
			btClose.setAction(getAction(ACTION_CANCEL_CODE));
			
			
			
			setResizable(true);
	        rz.getFontFactory().setFrameFonts(this);
	        pack();
	        rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;
	    }

	    @Override
		public void getMessage(MessageItem msg) {
	        switch(msg.getMsgCode()) {
	    	case MessageItem.MSG_ACTIONPERFORMED:
	            switch(msg.getCode()){
			          case ACTION_CANCEL_CODE:closeWindow();break;
			          case ACTION_SAVE_CODE:saveAction();break;
			          case ACTION_REFRESH_CODE:fromItem();break;
			          default :
			              break;
	           }
	    		break;
			case MessageItem.MSG_EINHEITEN_DIALOG_REPLY :
				einheitenDialogReply((EinheitsItem) msg.getData());
				break;
			case MessageItem.MSG_ZUTATEN_DIALOG_REPLY :
				zutatenDialogReply((ZutatenSuchItem) msg.getData());
				break;
	         case MessageItem.MSG_SHOW_RECHNEN_EDIT:
	        	this.parent = msg.getOrigin();
	        	ri = (RechenItem)msg.getData();
	        	if(ri !=null) {
	        		fromItem();
	        		openWindow();
	        	}
	        default:
	            break;
	        }

	    }

	    private void txtTextKeyReleased(java.awt.event.KeyEvent evt) {
			/**
			 * Pattern matching
			 */
			if (evt.getKeyCode() == KeyEvent.VK_TAB) {
				this.transferFocus();
			}
			if ((evt.getKeyCode() == KeyEvent.VK_TAB)
					&& (evt.getModifiers() == KeyEvent.CTRL_DOWN_MASK)) {
				this.transferFocusBackward();
			}
			if (evt.getKeyChar() == ' ') {
				processKeyStroke();
			}
		}

	    /**
		 * wird nach jeder Eingabe eines Leerzeichens im Textfeld aufgerufen. prüft
		 * ob eine gültige zeile vorliegt um den Dialog für Einheiten oder Zutaten
		 * zu öffnen
		 */
		private void processKeyStroke() {
			final String zeile = getLine(txtText);
			final String extend = getExtend(txtText);
			final String tokens[] = zeile.split(" ");
			/*
			 * Zeile in tokens aufspalten 1 token bedeutet dass wir nur prüfen
			 * müssen, ob es sich um eine gültige zahl handelt, 2 tokens bedeuten
			 * dass wir auf Zahl UND Einheit prüfen müssen
			 */

			switch (tokens.length) {
				case 1 : // auf Zahl prüfen
					if (rz.getLocale().isNumber(tokens[0].trim())) {
						showEinheitenDialog();
					}
					break;
				case 2 : // auf Zahl und Einheit prüfen
					if (rz.getLocale().isNumber(tokens[0].trim())) {
						if (rz.getDatabase().getEinheiten().isEinheit(
								tokens[1].trim())) {
							showZutatenDialog(extend);
						}
					}
					break;
			}
		}
		
		/**
		 * Hilfsfunktionen getline extrahiert die aktuelle Zeile im Textfeld vom
		 * Anfang bis zum Cursor
		 * 
		 */
		private String getLine(JTextPane p) {
			String ret = "";
			int start, end;
			end = p.getCaretPosition();
			start = (p.getText().lastIndexOf("\n", p.getCaretPosition() - 1) == -1)
					? 0
					: p.getText().lastIndexOf("\n", p.getCaretPosition() - 1);
			try {
				ret = p.getText().substring(start, end);
			} catch (final Exception e) {
			}
			return ret;
		}
		/**
		 * Hilfsfunktionen getExtend extrahiert die aktuelle Zeile im Textfeld vom
		 * Cursor bis zum Zeilenende
		 * 
		 */
		private String getExtend(JTextPane p) {
			String ret = "";
			int start, end;
			start = p.getCaretPosition();
			end = (p.getText().indexOf("\n", start) == -1)
					? p.getText().length()
					: p.getText().indexOf("\n", start);
			try {
				ret = p.getText().substring(start, end);
			} catch (final Exception e) {
			}
			return ret;
		}
	    
		/**
		 * zeigt den dialog mit der verfügbaren Einheiten an
		 * 
		 * 
		 */
		private void showEinheitenDialog() {
			/*
			 * am Anfang steht eine Zahl.. jetzt bitte den Einheitendialog zeigen...
			 */
			int x, y;
			x = (int) (txtText.getLocationOnScreen().getX() + txtText.getCaret()
					.getMagicCaretPosition().getX());
			y = (int) (txtText.getLocationOnScreen().getY() + txtText.getCaret()
					.getMagicCaretPosition().getY());
			if (ed != null) {
				ed.dispose();
				ed = null;
			}
			ed = new EinheitenDialog(this, true, rz, x, y);
			ed.setVisible(true);
		}

		/**
		 * zeigt den Dialog mit einzufügenden Zutaten an
		 * 
		 * 
		 */
		private void showZutatenDialog(String aZutat) {
			int x, y;
			x = (int) (txtText.getLocationOnScreen().getX() + txtText.getCaret().getMagicCaretPosition().getX());
			y = (int) (txtText.getLocationOnScreen().getY() + txtText.getCaret().getMagicCaretPosition().getY());
			if (zd != null) {
				zd.dispose();
				zd = null;
			}
			zd_dialog_typ = GET_REZEPTUR;
			zd = new ZutatenDialog(this, rz, x, y, aZutat,ZutatenDialog.MODE_REZEPTUREN);
			zd.setVisible(true);
		}
		
		private void zutatenDialogReply(ZutatenSuchItem zi) {
			if (zi != null) {
				try {
					switch (zd_dialog_typ) {
						case GET_REZEPTUR :
							try {
								txtText.select(txtText.getCaretPosition(),getExtendPosition(txtText));
								if (zi.getExclusive()) {
									txtText.replaceSelection(zi.getName());
								} else {
									txtText.replaceSelection(zi.getName() + " [[" + zi.getID() + "]]");
								}
							}catch(Exception e) {
								rz.getLogFactory().logMessage(LogFactory.LOG_WARN,"rezeptur.zutatenDialogReply.getRezeptur:",e.getLocalizedMessage());

							}
							break;
					
						default:		
							rz.getLogFactory().logMessage(LogFactory.LOG_WARN,"rezeptur.zutatenDialogReplyDefaultClause:",String.valueOf(zd_dialog_typ));
							zd_dialog_typ = GET_REZEPTUR;
					}
				} catch (final Exception e) {
					rz.getLogFactory().logMessage(LogFactory.LOG_WARN,"rezeptur.zutatenDialogReply.CatchAll:",e.getLocalizedMessage());
				}
			}
			if (zd != null) {
				zd.dispose();
				zd = null;
			}
		}

		/**
		 * gibt die Position des Zeilenendes (oder des TExtendes) in der JTextPane
		 * an
		 * 
		 * @param p
		 *            JTextPane
		 * @return int Zeilenende
		 */
		private int getExtendPosition(JTextPane p) {
			return (p.getText().indexOf("\n", p.getCaretPosition()) <0) ? p.getText().length() : p.getText().indexOf("\n",p.getCaretPosition());
		}

		private void einheitenDialogReply(EinheitsItem eh) {
			if (eh != null) {
				try {
					txtText.getDocument().insertString(txtText.getCaretPosition(),
							eh.getName(), null);
				} catch (final BadLocationException e) {
				}
			}
			if (ed != null) {
				ed.dispose();
				ed = null;
			}
		}
		
	    private void fromItem() {
	    	if(ri != null) {
	    		lblTitel.setText(ri.getRezeptur().getTitel());
	    		txtText.setText(ri.getRezeptur().getComment());
	    		lblTitel.setText(rz.getLocale().getString("rechnen.label_titel")
						.replaceAll("%m",rz.getLocale().formatNumber(ri.getRezeptur().getBasismenge(),OptionFactory.NF_NORMAL))
						.replaceAll("%e", rz.getDatabase().getEinheiten().getGrundeinheit(ri.getRezeptur().getBasiseinheit()).getName())
						.replaceAll("%t",ri.getRezeptur().getTitel())
						);
				
	    	}
	    }
	  
	    private void saveAction() {
	    	if(checkSave()) {
	    		ri.getRezeptur().setComment(txtText.getText().trim());
	    		ri.getRezeptur().CommentToRaw(txtText.getText().trim());
	    		ri.initItem(ri.getRezeptur().getID(), ri.getRezeptur());
	    		try {
	    			parent.getMessage(new MessageItem(MessageItem.MSG_SHOW_RECHNEN_EDIT_REPLY,0,ri,this));
	    		}catch(Exception e) {}
		    	closeWindow();
	    	} else {
	    		final DialogItem di = new DialogItem(DialogControl.HINWEIS_DIALOG,
						"", 0.0, rz.getLocale().getString("rechnen_edit_no_text"),
								rz.getLocale()	.getString("rechnen_edit_no_text"),
								rz.getLocale().getString("rechnen_edit_no_text_message"),
								"warnung.png", rz.getLocale().getString("string_ok"), 
								rz.getLocale().getString("string_nein"), this);
				rz.getDialogFactory().getDialog(di);
	    	}

	    }
	    
	    private boolean checkSave() {
	    	boolean ret = false;
	    	if(!txtText.getText().trim().isEmpty()) {
	    		ret = true;
	    	}
	    	return ret;
	    }
	    @Override
		public void createActions(){
	        actionList.put(String.valueOf(ACTION_CANCEL_CODE),new AuswahlAction(rz,this,ACTION_CANCEL_CODE,ACTION_CANCEL_TEXT, KeyEvent.VK_ESCAPE,0));
	        actionList.put(String.valueOf(ACTION_SAVE_CODE),new AuswahlAction(rz,this,ACTION_SAVE_CODE,ACTION_SAVE_TEXT, 0,0));
	        actionList.put(String.valueOf(ACTION_REFRESH_CODE),new AuswahlAction(rz,this,ACTION_REFRESH_CODE,ACTION_REFRESH_TEXT, 0,KeyEvent.VK_F5));
	    }

	    @Override
		public void openWindow(){
	    	if(ri != null) {
	            setVisible(true);
	            toFront();
	    	}
	    }

	    @Override
		public void closeWindow(){
			if (zd != null) {
				zd.dispose();
				zd = null;
			}
			if (ed != null) {
				ed.dispose();
				ed = null;
			}
			rz.getFensterFactory().getFensterListe().disposeFrame(this);
	    }

	
	}


