/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/*
 * db ist die zentrale Schnittstelle zur Datenbank. Hier wird die Verbindung
 * zur Datenbank aufgebaut, abgebaut und alle Datentransfers laufen aber
 * diese Klasse. Keine andere Klasse im Programm nimmt eigenständige
 * Verbindungen zur Datenbank auf
 *
 */

package de.lunqual.rzpro.fenster.rezepturfenster;


import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.math.BigDecimal;
import java.text.DecimalFormatSymbols;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.ScrollPaneConstants;
import javax.swing.SwingConstants;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.fenster.JNumberField;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fenster.JRzList;
import de.lunqual.rzpro.fenster.JSelectedTextField;
import de.lunqual.rzpro.fenster.ZutatenDialog;
import de.lunqual.rzpro.fenster.dialoge.DialogControl;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.abfrage.AbfrageItem;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.currency.CurrencyItem;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.items.ergebnis.ErgebnisItem;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.rezeptur.AusstattungsItem;
import de.lunqual.rzpro.items.rezeptur.ChangesListe;
import de.lunqual.rzpro.items.rezeptur.ZutatenSuchItem;
import de.lunqual.rzpro.items.stichworte.StichwortItem;
import de.lunqual.rzpro.items.stichworte.StichwortListe;
import de.lunqual.rzpro.log.LogFactory;
import de.lunqual.rzpro.options.OptionFactory;
/**
 *
 * @author  lunqual
 */
public class Ausstattung extends JRzFrame {

    //GUI-Variablen
    private JMenuBar mb;
    private JMenu mnuDatei;
    private JMenu mnuBearbeiten;
    private JMenu mnuExtras;
    private JMenu mnuHilfe;
    private JPanel mainPanel;
    	private JPanel toolbarPanel;
    		private JToolBar tb1;
    	private JPanel contentPanel;
	    	private JPanel topPanel;//name,staerke,stichworte,adressen
			private JPanel nameStaerke;
				private JPanel name;
					private JLabel lblName;
					private JSelectedTextField txtName;
			private JPanel listenPanel;
				private JPanel adressen;
					private JLabel lblAdressenTitel;
						private JScrollPane adressenScrollPane;
								private JRzList lstAdressen;
						private JPanel adressenButtonPane;
							private JButton btAdressenBearbeiten;
							private JButton btAdressenLoeschen;
					private JPanel stichworte;
						private JLabel lblStichworteTitel;
						private JScrollPane stichworteScrollPane;
								private JRzList lstStichworte;
						private JPanel stichwortButtonPane;
							private JButton btStichworteBearbeiten;
							private JButton btStichworteLoeschen;
			private JPanel centerPanel;
				private JPanel datenPanel;
					private JPanel gebindePanel;
						private JLabel lblGebinde;
						private JNumberField txtGebinde;
						private JLabel lblGebindeEinheit;
					private JPanel gebindeGewichtPanel;
						private JLabel lblGebindeGewicht;
						private JNumberField txtGebindeGewicht;
						private JLabel lblGebindeGewichtEinheit;
					private JPanel preisPanel;
						private JLabel lblPreis;
						private JNumberField txtPreis;
						private JComboBox cmbWaehrung;
						private JButton btRechnen;
					private JPanel artikelNummerPanel;
						private JLabel lblArtikelnummer;
						private JSelectedTextField txtArtikelnummer;
					private JPanel anzeigePanel;
						private JCheckBox chkAnzeige;
				private JPanel textPanel;
					private JLabel lblCaption;
					private JSplitPane splText;
						private JScrollPane scrText;
							private JTextPane txtText;
						private JScrollPane scrRechnen;
							private JEditorPane txtRechnen;
    	private JPanel buttonPanel;
    		private JButton btSpeichern;
			private JButton btDrucken;
    		private JButton btHilfe;
    		private JButton btAbbrechen;

    //ActionCodes Adressenfenster
    public static final int         		ACTION_ABBRECHEN_CODE = 1001;
    public static final String      		ACTION_ABBRECHEN_TEXT = "ausstattung.action_abbrechen";
    public static final int         		ACTION_SAVE_CODE = 1002;
    public static final String      		ACTION_SAVE_TEXT = "ausstattung.action_speichern";
    public static final int         		ACTION_HILFE_CODE = 1003;
    public static final String      		ACTION_HILFE_TEXT = "action_hilfe";
    public static final int         		ACTION_HIDE_CODE = 1004;
    public static final String      		ACTION_HIDE_TEXT = "action_hide";
	public static final int 				ACTION_ADRESSLISTE_BEARBEITEN_CODE = 1005;
	public static final String 			ACTION_ADRESSLISTE_BEARBEITEN_TEXT = "ausstattung.action_adressliste_bearbeiten";
	public static final int 				ACTION_ADRESSLISTE_LOESCHEN_CODE = 1006;
	public static final String 			ACTION_ADRESSLISTE_LOESCHEN_TEXT = "ausstattung.action_adressliste_loeschen";
	public static final int 				ACTION_STICHWORTLISTE_BEARBEITEN_CODE = 1007;
	public static final String 			ACTION_STICHWORTLISTE_BEARBEITEN_TEXT = "ausstattung.action_stichwortliste_bearbeiten";
	public static final int 				ACTION_STICHWORTLISTE_LOESCHEN_CODE = 1008;
	public static final String 			ACTION_STICHWORTLISTE_LOESCHEN_TEXT = "ausstattung.action_stichwortliste_loeschen";
	public static final int 				ACTION_RECHNEN_CODE = 1009;
	public static final String 			ACTION_RECHNEN_TEXT = "ausstattung.action_rechnen";
	public static final int 				ACTION_DRUCKEN_CODE = 1010;
	public static final String 			ACTION_DRUCKEN_TEXT = "ausstattung.action_drucken";

	AusstattungsItem 							ausstattung;
    ErgebnisItem								ergebnis;
	ZutatenDialog 								zd;
	JRzFrame										origin;
    DecimalFormatSymbols 				dfs;
    char 											comma=',';

    /** Creates new form AusstattungsFenster */
    public Ausstattung(RzPro r,String name,Object extendedData) {
        super(r,name,extendedData);
        createActions();
        createGUIComponents();
        setGUIComponents();
        getMessage((MessageItem)extendedData);
    }

    @Override
	public void createGUIComponents() {
        mb = new JMenuBar();
		mnuDatei = new JMenu();
			mb.add(mnuDatei);
		mnuBearbeiten=new JMenu();
			mb.add(mnuBearbeiten);
        mnuExtras = new JMenu();
        	mb.add(mnuExtras);
        mnuHilfe = new JMenu();
        	mb.add(mnuHilfe);
		setJMenuBar(mb);
		mainPanel = new JPanel(new BorderLayout());
		toolbarPanel = new JPanel(new BorderLayout());
			tb1 = new JToolBar();
			tb1.setFloatable(false);
			tb1.setRollover(true);
			toolbarPanel.add(tb1);
			contentPanel = new JPanel(new BorderLayout());

				topPanel = new JPanel(new BorderLayout());

						// oberer Teil Name
						nameStaerke = new JPanel(new BorderLayout());
						topPanel.add(nameStaerke,BorderLayout.NORTH);
							//Name,stärke
							name = new JPanel(new BorderLayout());
							nameStaerke.add(name,BorderLayout.NORTH);
								// name
								lblName = new JLabel();lblName.setHorizontalAlignment(SwingConstants.TRAILING);
								name.add(lblName,BorderLayout.WEST);
								txtName = new JSelectedTextField();
								name.add(txtName,BorderLayout.CENTER);


					    // Panel mit Adressen und Stichworten
					    listenPanel = new JPanel(new BorderLayout());
					    topPanel.add(listenPanel,BorderLayout.CENTER);
					    // linkes Panel...Adressen
					    	adressen = new JPanel(new BorderLayout());
					    	listenPanel.add(adressen,BorderLayout.WEST);
						    	lblAdressenTitel = new JLabel();lblAdressenTitel.setHorizontalAlignment(SwingConstants.CENTER);
						    	adressen.add(lblAdressenTitel,BorderLayout.NORTH);
						    	adressenScrollPane = new JScrollPane();
						    		adressenScrollPane.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_AS_NEEDED);
						    		adressenScrollPane.setHorizontalScrollBarPolicy(ScrollPaneConstants.HORIZONTAL_SCROLLBAR_AS_NEEDED);
						    		adressenScrollPane.setPreferredSize(new Dimension(100,150));
						    		lstAdressen = new JRzList();
						    		adressenScrollPane.setViewportView(lstAdressen);
						    		lstAdressen.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
						    		adressen.add(adressenScrollPane,BorderLayout.CENTER);
						    	adressenButtonPane= new JPanel(new GridLayout(1,2));
						    		btAdressenBearbeiten = new JButton();
						    		adressenButtonPane.add(btAdressenBearbeiten);
						    		btAdressenLoeschen = new JButton();
						    		adressenButtonPane.add(btAdressenLoeschen);
						    	adressen.add(adressenButtonPane,BorderLayout.SOUTH);


					    //rechtes Panel .. Stichworte
					    	stichworte = new JPanel(new BorderLayout());
					    	listenPanel.add(stichworte,BorderLayout.EAST);
						    	lblStichworteTitel = new JLabel();lblStichworteTitel.setHorizontalAlignment(SwingConstants.CENTER);
								stichworte.add(lblStichworteTitel,BorderLayout.NORTH);
								stichworteScrollPane = new JScrollPane();
						    		stichworteScrollPane.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_AS_NEEDED);
						    		stichworteScrollPane.setHorizontalScrollBarPolicy(ScrollPaneConstants.HORIZONTAL_SCROLLBAR_AS_NEEDED);
						    		stichworteScrollPane.setPreferredSize(new Dimension(100,150));
						    		lstStichworte = new JRzList();
						    		lstStichworte.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
						    		stichworteScrollPane.setViewportView(lstStichworte);
						    		lstStichworte.setCellRenderer(new STWListRenderer(rz));
						    		stichworte.add(stichworteScrollPane,BorderLayout.CENTER);
						    	stichwortButtonPane= new JPanel(new GridLayout(1,2));
						    		btStichworteBearbeiten = new JButton();
						    		stichwortButtonPane.add(btStichworteBearbeiten);
						    		btStichworteLoeschen = new JButton();
						    		stichwortButtonPane.add(btStichworteLoeschen);
						    	stichworte.add(stichwortButtonPane,BorderLayout.SOUTH);
					   topPanel.setBorder(BorderFactory.createEtchedBorder());
			    contentPanel.add(topPanel,BorderLayout.NORTH);

						centerPanel = new JPanel(new BorderLayout());
							datenPanel = new JPanel(new GridLayout(5,1));
								datenPanel.setBorder(BorderFactory.createRaisedBevelBorder());
								//--------------------------------------
								gebindePanel = new JPanel();
								gebindePanel.setLayout(new GridLayout(1,3));
									lblGebinde = new JLabel();
										lblGebinde.setHorizontalAlignment(SwingConstants.RIGHT);
									gebindePanel.add(lblGebinde);
				    				txtGebinde  = new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_NORMAL),1.0,0.0,Double.POSITIVE_INFINITY);
									gebindePanel.add(txtGebinde);
									lblGebindeEinheit = new JLabel();
										lblGebindeEinheit.setHorizontalAlignment(SwingConstants.LEFT);
									gebindePanel.add(lblGebindeEinheit);
								datenPanel.add(gebindePanel);
								//-------------------------------------------
								gebindeGewichtPanel = new JPanel();
								gebindeGewichtPanel.setLayout(new GridLayout(1,3));
									lblGebindeGewicht = new JLabel();
										lblGebindeGewicht.setHorizontalAlignment(SwingConstants.RIGHT);
									gebindeGewichtPanel.add(lblGebindeGewicht);
				    				txtGebindeGewicht  = new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_NORMAL),1.0,0.0,Double.POSITIVE_INFINITY);
									gebindeGewichtPanel.add(txtGebindeGewicht);
									lblGebindeGewichtEinheit = new JLabel();
										lblGebindeGewichtEinheit.setHorizontalAlignment(SwingConstants.LEFT);
									gebindeGewichtPanel.add(lblGebindeGewichtEinheit);
								datenPanel.add(gebindeGewichtPanel);
								//----------------------------------------
								preisPanel = new JPanel();
									preisPanel.setLayout(new GridLayout(1,4));
										lblPreis = new JLabel();
										lblPreis.setHorizontalAlignment(SwingConstants.CENTER);
										preisPanel.add(lblPreis);
										txtPreis = new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_NORMAL),0.0,0.0,Double.POSITIVE_INFINITY);
										preisPanel.add(txtPreis);
										cmbWaehrung = new JComboBox();
										preisPanel.add(cmbWaehrung);
										btRechnen=new JButton();
										preisPanel.add(btRechnen);
								datenPanel.add(preisPanel);
								//--------------------------------------
								artikelNummerPanel = new JPanel();
								artikelNummerPanel.setLayout(new BorderLayout());
									lblArtikelnummer = new JLabel();
									lblArtikelnummer.setHorizontalAlignment(SwingConstants.RIGHT);
									artikelNummerPanel.add(lblArtikelnummer,BorderLayout.WEST);
									txtArtikelnummer = new JSelectedTextField();
									artikelNummerPanel.add(txtArtikelnummer,BorderLayout.CENTER);
								datenPanel.add(artikelNummerPanel);
								//----------------------------------------
							    anzeigePanel = new JPanel(new BorderLayout());
							    	chkAnzeige = new JCheckBox();
							    	anzeigePanel.add(chkAnzeige,BorderLayout.WEST);
							    datenPanel.add(anzeigePanel);
							  //------------------------------------------
							centerPanel.add(datenPanel,BorderLayout.NORTH);
								textPanel = new JPanel(new BorderLayout());
									lblCaption = new JLabel();
										lblCaption.setHorizontalAlignment(SwingConstants.CENTER);
									textPanel.add(lblCaption,BorderLayout.NORTH);
									splText = new JSplitPane();
										scrText = new JScrollPane();
											txtText = new JTextPane();
								    		txtText.addKeyListener(new java.awt.event.KeyAdapter() {
												@Override
												public void keyReleased(java.awt.event.KeyEvent evt) {
													txtTextKeyReleased(evt);
												}
									    		});
											scrText.setViewportView(txtText);
										splText.setLeftComponent(scrText);
											scrRechnen = new JScrollPane();
												txtRechnen = new JEditorPane();
													txtRechnen.setContentType("text/html");
													txtRechnen.setEditable(false);
													txtRechnen.setBackground(Color.GRAY);
													scrRechnen.setViewportView(txtRechnen);
										splText.setRightComponent(scrRechnen);
									textPanel.add(splText,BorderLayout.CENTER);
									textPanel.setBorder(BorderFactory.createRaisedBevelBorder());
							centerPanel.add(textPanel,BorderLayout.CENTER);
						contentPanel.add(centerPanel,BorderLayout.CENTER);
			mainPanel.add(contentPanel,BorderLayout.CENTER);
			buttonPanel = new JPanel(new GridLayout(1,3));
				btSpeichern = new JButton();
				buttonPanel.add(btSpeichern);

				btDrucken = new JButton();
				buttonPanel.add(btDrucken);

				btHilfe = new JButton();
				buttonPanel.add(btHilfe);

				btAbbrechen = new JButton();
				buttonPanel.add(btAbbrechen);

			mainPanel.add(buttonPanel,BorderLayout.SOUTH);
			getContentPane().setLayout(new BorderLayout());
			getContentPane().add(toolbarPanel,BorderLayout.NORTH);
			getContentPane().add(mainPanel,BorderLayout.CENTER);
			getContentPane().add(buttonPanel,BorderLayout.SOUTH);
    }

    @Override
	public void setGUIComponents() {
      setTitle(rz.getVersionString() + " " + rz.getLocale().getString("ausstattung.titel"));
      rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE);

      mnuDatei.setText(rz.getLocale().getString("menu.datei"));
      mnuExtras.setText(rz.getLocale().getString("menu.extras"));
      mnuBearbeiten.setText(rz.getLocale().getString("menu.bearbeiten"));
      mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));

      mnuDatei.add(getAction(ACTION_DRUCKEN_CODE));
      mnuDatei.addSeparator();
      mnuDatei.add(getAction(ACTION_ABBRECHEN_CODE));

      mnuExtras.add(getAction(ACTION_HIDE_CODE));

      mnuHilfe.add(getAction(ACTION_HILFE_CODE));

      lblGebinde.setText(rz.getLocale().getString("ausstattung.label_gebinde"));
      lblGebindeEinheit.setText(rz.getLocale().getString("ausstattung.label_gebinde_einheit"));
      lblGebindeGewicht.setText(rz.getLocale().getString("ausstattung.label_gebinde_gewicht"));
      lblGebindeGewichtEinheit.setText(rz.getLocale().getString("ausstattung.label_gebinde_einheit_gewicht"));
      lblPreis.setText(rz.getLocale().getString("ausstattung.label_preis"));
      lblArtikelnummer.setText(rz.getLocale().getString("ausstattung.label_artikelnummer"));
      lblCaption.setText(rz.getLocale().getString("ausstattung.label_text_caption"));
      chkAnzeige.setText(rz.getLocale().getString("ausstattung.label_anzeige"));

	  btAdressenBearbeiten.setAction(getAction(ACTION_ADRESSLISTE_BEARBEITEN_CODE));
	  btAdressenLoeschen.setAction(getAction(ACTION_ADRESSLISTE_LOESCHEN_CODE));
	  btStichworteBearbeiten.setAction(getAction(ACTION_STICHWORTLISTE_BEARBEITEN_CODE));
	  btStichworteLoeschen.setAction(getAction(ACTION_STICHWORTLISTE_LOESCHEN_CODE));
      btHilfe.setAction(getAction(ACTION_HILFE_CODE));
      btAbbrechen.setAction(getAction(ACTION_ABBRECHEN_CODE));
      btSpeichern.setAction(getAction(ACTION_SAVE_CODE));
      btRechnen.setAction(getAction(ACTION_RECHNEN_CODE));
      btDrucken.setAction(getAction(ACTION_DRUCKEN_CODE));

      tb1.add(getAction(ACTION_ABBRECHEN_CODE));
      tb1.add(getAction(ACTION_HIDE_CODE));
      tb1.addSeparator();
      tb1.add(getAction(ACTION_RECHNEN_CODE));
      tb1.add(getAction(ACTION_DRUCKEN_CODE));
      tb1.addSeparator();
      tb1.add(getAction(ACTION_HILFE_CODE));

      setResizable(true);
      rz.getFontFactory().setFrameFonts(this);
      pack();
      rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;
      setDividerLocations();
    }

    @Override
	public void getMessage(MessageItem msg) {
        switch(msg.getMsgCode()) {
        	case MessageItem.MSG_ACTIONPERFORMED:
                switch(msg.getCode()){
                case ACTION_HILFE_CODE: hilfeAction();break;
                case ACTION_HIDE_CODE:hideAction();break;
                case ACTION_ABBRECHEN_CODE:closeWindow();break;
    			case ACTION_ADRESSLISTE_BEARBEITEN_CODE :adressListeBearbeitenAction();break;
    			case ACTION_ADRESSLISTE_LOESCHEN_CODE :adressenLoeschenAction();break;
    			case ACTION_STICHWORTLISTE_BEARBEITEN_CODE :stichwortListeBearbeitenAction();	break;
    			case ACTION_STICHWORTLISTE_LOESCHEN_CODE :stichwortListeLoeschenAction();break;
    			case ACTION_SAVE_CODE: speichernAction();break;
    			case ACTION_RECHNEN_CODE:rechnenAction();break;
    			case ACTION_DRUCKEN_CODE:druckenAction();break;
                default :
                    break;
               }
        		break;
            case MessageItem.MSG_STICHWORTLISTE_REPLY:
         		ausstattung.setStichwortListe(((StichwortListe)msg.getData()).copyList());
      			lstStichworte.setListData(((StichwortListe)msg.getData()).toArray());
      			break;
            case MessageItem.MSG_ADRESSLISTE_REPLY:
     			ausstattung.setAdressListe(((StichwortListe)msg.getData()).copyList());
         		lstAdressen.setListData(((StichwortListe)msg.getData()).toArray());
	      		break;
    	 	case MessageItem.MSG_ZUTATEN_DIALOG_REPLY:
   	 			zutatenDialogReply((ZutatenSuchItem)msg.getData());
   	 			break;
           case MessageItem.MSG_EDIT_AUSSTATTUNG:
        	   ergebnis = (ErgebnisItem)msg.getData();
        	   origin = msg.getOrigin();
        	   editAusstattung();
        	   rechnenAction();
        	   	break;
           case MessageItem.MSG_SHOW_AUSSTATTUNG:
        	   ergebnis = (ErgebnisItem)msg.getData();
        	   origin = msg.getOrigin();
        	   refreshAction();
        	   rechnenAction();
                break;
            default:
                rz.getLogFactory().logMessage(2, "ausstattungsfenster:", "auswahlAction:" + msg.getMsgCode());
                break;
        }
    }


     @Override
	public void createActions(){
        actionList.put(String.valueOf(ACTION_ABBRECHEN_CODE),new AuswahlAction(rz,this,ACTION_ABBRECHEN_CODE,ACTION_ABBRECHEN_TEXT,KeyEvent.VK_ESCAPE ,0));
        actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT, KeyEvent.VK_F5 ,InputEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT, KeyEvent.VK_F1 ,0));
        actionList.put(String.valueOf(ACTION_SAVE_CODE),new AuswahlAction(rz,this,ACTION_SAVE_CODE,ACTION_SAVE_TEXT, KeyEvent.VK_S ,InputEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_ADRESSLISTE_BEARBEITEN_CODE),new AuswahlAction(rz,this,ACTION_ADRESSLISTE_BEARBEITEN_CODE,ACTION_ADRESSLISTE_BEARBEITEN_TEXT, KeyEvent.VK_D,InputEvent.CTRL_DOWN_MASK));
		actionList.put(String.valueOf(ACTION_ADRESSLISTE_LOESCHEN_CODE), new AuswahlAction(rz,this, ACTION_ADRESSLISTE_LOESCHEN_CODE,ACTION_ADRESSLISTE_LOESCHEN_TEXT,KeyEvent.VK_L,InputEvent.CTRL_DOWN_MASK));
		actionList.put(String.valueOf(ACTION_STICHWORTLISTE_BEARBEITEN_CODE),new AuswahlAction(rz,this,	ACTION_STICHWORTLISTE_BEARBEITEN_CODE,ACTION_STICHWORTLISTE_BEARBEITEN_TEXT,KeyEvent.VK_S,InputEvent.CTRL_DOWN_MASK));
		actionList.put(String.valueOf(ACTION_STICHWORTLISTE_LOESCHEN_CODE),new AuswahlAction(rz,this,ACTION_STICHWORTLISTE_LOESCHEN_CODE,ACTION_STICHWORTLISTE_LOESCHEN_TEXT,KeyEvent.VK_W,	InputEvent.CTRL_DOWN_MASK));
		actionList.put(String.valueOf(ACTION_RECHNEN_CODE),new AuswahlAction(rz,this,ACTION_RECHNEN_CODE,ACTION_RECHNEN_TEXT,KeyEvent.VK_R,	InputEvent.CTRL_DOWN_MASK));
		actionList.put(String.valueOf(ACTION_DRUCKEN_CODE),new AuswahlAction(rz,this,ACTION_DRUCKEN_CODE,ACTION_DRUCKEN_TEXT,KeyEvent.VK_P,	InputEvent.CTRL_DOWN_MASK));

     }

 	/** speichert die Position der Splitbalken
 	 */
     private void saveDividerLocations(){
         rz.getFensterFactory().setOption(this.getName() + ".splHorizontal", this.splText.getDividerLocation());
         rz.getFensterFactory().saveOptions();
     }
 	/** setzt die Position der Splitbalken auf gespeicherte Positionen oder
 	 * auf Standardposition, wenn keine gespeicherten vorliegen
 	 *
 	 */
     private void setDividerLocations() {
         splText.setDividerLocation(rz.getFensterFactory().getOption(this.getName() + ".splHorizontal",this.getWidth()/2));
     }

 	private void txtTextKeyReleased(java.awt.event.KeyEvent evt) {
		/**
		 * Pattern matching
		 */
	    if(evt.getKeyCode() == KeyEvent.VK_TAB) {
	        this.transferFocus();
	    }
	    if((evt.getKeyCode() == KeyEvent.VK_TAB) && (evt.getModifiers()== InputEvent.CTRL_DOWN_MASK)) {
	        this.transferFocusBackward();
	    }
		if (evt.getKeyChar() == ' ') {
			processKeyStroke();
		}
	}

 	/**
	 * wird nach jeder Eingabe eines Leerzeichens im Textfeld aufgerufen. prüft
	 * ob eine gültige zeile vorliegt um den Dialog für Einheiten oder Zutaten
	 * zu öffnen
	 */
	private void processKeyStroke() {
		final String zeile = getLine(txtText);
		final String extend = getExtend(txtText);
		final String tokens[] = zeile.split(" ");
		/*
		 * Zeile in tokens aufspalten 1 token bedeutet dass wir nur prüfen
		 * müssen, ob es sich um eine gültige zahl handelt, 2 tokens bedeuten
		 * dass wir auf Zahl UND Einheit prüfen müssen
		 */

		switch (tokens.length) {
			case 2 : // auf Rechenzeichen und Zahl
				if (tokens[0].trim().equals(RzPro.TYP_AUSSTATTUNG_EINFACH) || tokens[0].trim().equals(RzPro.TYP_AUSSTATTUNG_MULTI)) {
					if (rz.getLocale().isNumber(tokens[1].trim())) {
						showZutatenDialog(extend);
					}
				}
				break;
		}
	}

     /** zeigt den Dialog mit einzufügenden Zutaten an
 	 *
 	 *
 	 */
 	private void showZutatenDialog(String aZutat){
 		int x, y;
 		x = (int) (txtText.getLocationOnScreen().getX() +   txtText.getCaret().getMagicCaretPosition().getX());
 		y = (int) (txtText.getLocationOnScreen().getY() +   txtText.getCaret().getMagicCaretPosition().getY());
 		if(zd != null) {
 			zd.dispose();
 			zd = null;
 		}
 		zd = new ZutatenDialog(this, rz, x, y,aZutat,ZutatenDialog.MODE_AUSSTATTUNG);
 		zd.setVisible(true);
 	}



 	private void zutatenDialogReply(ZutatenSuchItem zi) {
 		if(zi != null) {
 			try {
					txtText.getDocument().remove(txtText.getCaretPosition(),getExtendPosition(txtText)-txtText.getCaretPosition());
					if(zi.getExclusive()){
						txtText.getDocument().insertString(txtText.getCaretPosition(),zi.getName(), null);
					}
					else {
						txtText.getDocument().insertString(txtText.getCaretPosition(),zi.getName() + " [["+zi.getID() + "]]", null);
					}
 			} catch (final Exception e) {
 				rz.getLogFactory().logMessage(LogFactory.LOG_WARN,"ausstattung.zutatenDialog.",e.getLocalizedMessage());
 			}
 		}
 		if(zd!= null) {
 			zd.dispose();
 			zd = null;
 		}
 	}
	/** gibt die Position des Zeilenendes (oder des TExtendes) in der JTextPane an
	 *
	 * @param p JTextPane
	 * @return int Zeilenende
	 */
	private int getExtendPosition(JTextPane p){
		return  (p.getText().indexOf("\n",p.getCaretPosition()) == -1) ? p.getText().length() : p.getText().indexOf("\n",p.getCaretPosition());
	}

	/**
	 * Hilfsfunktionen getline extrahiert die aktuelle Zeile im Textfeld
	 * vom Anfang bis zum Cursor
	 *
	 */
	private String getLine(JTextPane p) {
		String ret = "";
		int start, end;
		end = p.getCaretPosition();
		start = (p.getText().lastIndexOf("\n", p.getCaretPosition() - 1) == -1)
				? 0
				: p.getText().lastIndexOf("\n", p.getCaretPosition() - 1);
		try {
			ret = p.getText().substring(start, end);
		} catch (final Exception e) {
		}
		return ret;
	}
	/**
	 * Hilfsfunktionen getExtend extrahiert die aktuelle Zeile im Textfeld
	 * vom Cursor bis zum Zeilenende
	 *
	 */
	private String getExtend(JTextPane p) {
		String ret = "";
		int start, end;
		start= p.getCaretPosition();
		end = (p.getText().indexOf("\n",start) == -1) ? p.getText().length() : p.getText().indexOf("\n",start);
		try {
			ret = p.getText().substring(start, end);
		} catch (final Exception e) {}
		return ret;
	}


    @Override
	public void openWindow(){
        if(!isVisible()) {
			setVisible(true);
		}
        toFront();
        txtName.requestFocus();
    }

    @Override
	public void closeWindow(){
		if(zd != null) {
			zd.dispose();
			zd = null;
		}
		saveDividerLocations();
        rz.getFensterFactory().getFensterListe().disposeFrame(this);
    }

    /**
     * rechnen
     */
    private void rechnenAction() {
    	if(ausstattung != null) {
    		rz.setWaitCursor(this);
    		ausstattung.setComment(txtText.getText().trim());
    		ausstattung.setPreis(new BigDecimal(txtPreis.getValue()));
    		ausstattung.setGebindeGewicht(txtGebindeGewicht.getValue());
    		ausstattung.rechnen(this.txtGebinde.getValue(),(CurrencyItem)cmbWaehrung.getSelectedItem()).doubleValue();
    		txtPreis.setValue(ausstattung.getGesamtPreis().doubleValue());
    		txtGebindeGewicht.setValue(ausstattung.getGesamtGewicht());
    		rz.getAusgabeFactory().ausstattungsBerechnungsAusgabe(ausstattung, ((CurrencyItem)cmbWaehrung.getSelectedItem()).getName(),txtRechnen);
    		rz.setFreeCursor(this);
    	}
    }

    private void editAusstattung() {
		ausstattung = rz.getDatabase().getAusstattung().getAusstattung(ergebnis.getID());
		if(ausstattung != null) {
			if(!ergebnis.getAdressen().equals("")) {
				ausstattung.setAdressListe(rz.getDatabase().getSTW().dbGetAdressenListe(ergebnis.getAdressen()));
			}
			if(!ergebnis.getStichworte().equals("")) {
				ausstattung.setStichwortListe(rz.getDatabase().getSTW().dbGetStichwortListe(ergebnis.getStichworte()));
			}
			if (ausstattung.getID() == 0) {
				setTitle(rz.getVersionString() + " "
						+ rz.getLocale().getString("ausstattung.titel") + " "
						+ rz.getLocale().getString("string_neu_eingeben"));
			} else {
				setTitle(rz.getVersionString() + " "
						+ rz.getLocale().getString("ausstattung.titel") + " "
						+ rz.getLocale().getString("string_bearbeiten"));
			}

			if (ausstattung != null) {
			    fromItem(ausstattung);
			} else {
	            final DialogItem di = new DialogItem(
	                    DialogControl.HINWEIS_DIALOG,
	                    "",0.0,
	                    rz.getLocale().getString("rezeptur.key_not_found"),
	                    rz.getLocale().getString("rezeptur.key_not_found"),
	                    rz.getLocale().getString("rezeptur.fehler_not_found"),
	                    "frage.png",
	                    rz.getLocale().getString("string_ok"),
						"",
	                    this
	            );
	            rz.getDialogFactory().getDialog(di);
			}
		}
    }

    /**
     * speichern
     *
     */
    private void speichernAction() {
		toItem(ausstattung);
		final String titel = ausstattung.getTitel();
		rz.setWaitCursor(this);
		ChangesListe liste = new ChangesListe(rz,ausstattung.getID(),RzPro.TYP_ID_AUSSTATTUNG);
		final int key = rz.getDatabase().getAusstattung().saveAusstattung(ausstattung);
		liste.commit();
		rz.setFreeCursor(this);
		final StichwortListe sl = ausstattung.getStichwortListe().copyList();
		final StichwortListe al = ausstattung.getAdressListe().copyList();
		if (key > 0) {
				final AbfrageItem ai = new AbfrageItem();
				ai.setTyp(de.lunqual.rzpro.database.DBAbfrage.ABFRAGE_TYP_NORMAL);
				ai.setID(key);
				ai.setAdressListe(al);
				ai.setStichwortListe(sl);
				ai.setMuster(rz.getDatabase().getErgebnis().getMusterString(titel));
				try {
					origin.getMessage(new MessageItem(MessageItem.MSG_ADD_QUERY_REZEPT,ai.getID(),	ai,this));
				} catch(final Exception e) {}
				closeWindow();
		} else {
			// ist was schiefgegangen
		}
	}

    /**
     * drucken
     *
     *
     */
    private void druckenAction() {
    	rechnenAction();
    	rz.getReportFactory().AusstattungCalcReport(ausstattung, (CurrencyItem)cmbWaehrung.getSelectedItem() ,this);
    }

	private void stichwortListeBearbeitenAction() {
		final AbfrageItem ai = new AbfrageItem();
		ai.setStichwortListe(ausstattung.getStichwortListe().copyList());
    	rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_STICHWORTAUSWAHL,true,
    			new MessageItem(MessageItem.MSG_STICHWORTLISTE_REQUEST,0,ai,this));
	}
	private void stichwortListeLoeschenAction() {
		ausstattung.getStichwortListe().clear();
		lstStichworte.setListData(ausstattung.getStichwortListe().toArray());
		txtName.requestFocus();
	}

	private void adressListeBearbeitenAction() {
		final AbfrageItem ai = new AbfrageItem();
		ai.setAdressListe(ausstattung.getAdressListe().copyList());
    	rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_ADRESSAUSWAHL,true,
    			new MessageItem(MessageItem.MSG_ADRESSLISTE_REQUEST,0,ai,this));
	}
	private void adressenLoeschenAction() {
		ausstattung.getAdressListe().clear();
		lstAdressen.setListData(ausstattung.getAdressListe().toArray());

		txtName.requestFocus();
	}

    /**
     * Ein AusstattungsItem holen
     */
    private void refreshAction() {
    	ausstattung = rz.getDatabase().getAusstattung().getAusstattung(ergebnis.getID());
    	if(ausstattung != null) {
    		fromItem(ausstattung);
    	} else {
    		//ist was schiefgegangen
    		closeWindow();
    	}
    }

    /**
     * Die Daten aus der Struktur ins GUI übernehmen
     *
     */
    private void fromItem(AusstattungsItem as) {
    	txtName.setText(as.getTitel());
		lstAdressen.setListData(as.getAdressListe().toArray());
		lstStichworte.setListData(as.getStichwortListe().toArray());
		txtGebinde.setValue(as.getGebindegroesse());
		txtGebindeGewicht.setValue(as.getGebindeGewicht());
		txtPreis.setValue(as.getPreis().doubleValue());
		rz.getDatabase().getCurrency().dbGetCurrencyListeCombo(cmbWaehrung,as.getWaehrung());
		txtArtikelnummer.setText(as.getArtikelnummer());
		txtText.setText(as.getComment());
		chkAnzeige.setSelected(as.getListe());
    }
    /**
     * Die Daten aus dem GUI in die Struktur übertragen
     *
     */
    private void toItem(AusstattungsItem as) {
    	as.setTitel(txtName.getText().trim());
    	as.setGebindeGroesse(txtGebinde.getValue());
    	as.setGebindeGewicht(txtGebindeGewicht.getValue());
    	as.setPreis(txtPreis.getText());
		as.setWaehrung(((CurrencyItem)cmbWaehrung.getSelectedItem()).getID());
		as.setArtikelnummer(txtArtikelnummer.getText().trim());
		as.setListe(chkAnzeige.isSelected());
		as.setComment(txtText.getText().trim());
    }

    //Extras-Menü
    private void hideAction(){
        rz.getFensterFactory().getFensterListe().sperren(this);
    }

    //hilfe-menü
    private void hilfeAction(){
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"ausstattung.html",this));
    }


	  private final class STWListRenderer extends JLabel implements ListCellRenderer{
	        RzPro   rz;
	        public STWListRenderer(RzPro r){
	            rz = r;
	            setOpaque(true);
	        }

	        public Component getListCellRendererComponent(JList list,Object value,int index, boolean isSelected,boolean cellHasFocus){
	            final StichwortItem si = (StichwortItem)value;
	            this.setFont(rz.getFontFactory().getListFont());
	            setText(si.toString());
	            if(isSelected){
	                setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_SELECTED));
	                setForeground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_FOREGROUND_SELECTED));
	            }else {
	                setBackground(rz.getOptionFactory().getRGBColorString(si.getHg()));
	                setForeground(rz.getOptionFactory().getRGBColorString(si.getVg()));
	            }
	            return this;
	        }
	    }
}
