/*
 * EinheitenDialog.java
 *
 * Created on 7. Juli 2004, 13:04
 */

package de.lunqual.rzpro.fenster.rezepturfenster;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;

import javax.swing.JFrame;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.items.einheiten.EinheitsItem;
import de.lunqual.rzpro.items.message.MessageItem;
/**
 *
 * @author  labor
 */
public class EinheitenDialog extends JFrame {

    EinheitsItem         	selected;
    RzPro                		rz;
    JRzFrame				parentFrame;

    /** Creates new form EinheitenDialog */
    public EinheitenDialog(JRzFrame parent, boolean modal,RzPro r,int x,int y) {
        rz = r;
        parentFrame = parent;
        setUndecorated(true);
        initComponents();
        selected = null;
        lstEinheiten.setListData(rz.getDatabase().getEinheiten().getEinheitenListe().toArray());
        this.setBounds(x, y, this.getWidth(), this.getHeight());

    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {
        jScrollPane1 = new javax.swing.JScrollPane();
        lstEinheiten = new javax.swing.JList();

        setUndecorated(true);
        addFocusListener(new java.awt.event.FocusAdapter() {
            @Override
			public void focusGained(java.awt.event.FocusEvent evt) {
                formFocusGained(evt);
            }
            @Override
			public void focusLost(FocusEvent evt) {
            	setVisible(false);
            }
        });

        lstEinheiten.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        lstEinheiten.addKeyListener(new java.awt.event.KeyAdapter() {
            @Override
			public void keyReleased(java.awt.event.KeyEvent evt) {
                lstEinheitenKeyReleased(evt);
            }
        });

        jScrollPane1.setViewportView(lstEinheiten);

        getContentPane().add(jScrollPane1, java.awt.BorderLayout.CENTER);

        pack();
    }

    private void lstEinheitenKeyReleased(java.awt.event.KeyEvent evt) {
        lstEinheiten.ensureIndexIsVisible(lstEinheiten.getSelectedIndex());
        if (evt.getKeyCode() == KeyEvent.VK_ENTER){
            selected = (EinheitsItem)lstEinheiten.getSelectedValue();
            try {
            	parentFrame.getMessage(new MessageItem(MessageItem.MSG_EINHEITEN_DIALOG_REPLY,0,selected,this));
            } catch (final Exception e) { }
            setVisible(false);
        }
        if (evt.getKeyCode() == KeyEvent.VK_ESCAPE){
            selected = null;
            setVisible(false);
        }
    }

    private void formFocusGained(java.awt.event.FocusEvent evt) {
        if(lstEinheiten.getModel().getSize() > 0){
            lstEinheiten.setSelectedIndex(2);
        }
        lstEinheiten.requestFocus();
    }


    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JList lstEinheiten;


}
