/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package de.lunqual.rzpro.fenster.rezepturfenster;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;

import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.ScrollPaneConstants;
import javax.swing.SwingConstants;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.BadLocationException;
import java.math.BigDecimal;
import java.math.RoundingMode;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.fenster.JIntegerField;
import de.lunqual.rzpro.fenster.JNumberField;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fenster.JRzList;
import de.lunqual.rzpro.fenster.JRzTextPane;
import de.lunqual.rzpro.fenster.JSelectedTextField;
import de.lunqual.rzpro.fenster.ZutatenDialog;
import de.lunqual.rzpro.fenster.dialoge.DialogControl;
import de.lunqual.rzpro.fenster.rzDatePicker.RzSimpleDatePicker;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.abfrage.AbfrageItem;
import de.lunqual.rzpro.items.acid.AcidAnzeigeItem;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.bewertungen.BewertungsItem;
import de.lunqual.rzpro.items.currency.CurrencyItem;
import de.lunqual.rzpro.items.deklarationen.DeklarationsListe;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.items.einheiten.EinheitsItem;
import de.lunqual.rzpro.items.ergebnis.DependencyListe;
import de.lunqual.rzpro.items.ergebnis.ErgebnisItem;
import de.lunqual.rzpro.items.ergebnis.IDItem;
import de.lunqual.rzpro.items.laborwerte.LaborwertItem;
import de.lunqual.rzpro.items.laborwerte.LaborwertValueItem;
import de.lunqual.rzpro.items.laborwerte.LaborwertValueListe;
import de.lunqual.rzpro.items.lager.LagerItem;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.mischungen.SortenItem;
import de.lunqual.rzpro.items.rechnen.RechenItem;
import de.lunqual.rzpro.items.rezeptur.ChangesListe;
import de.lunqual.rzpro.items.rezeptur.RezepturItem;
import de.lunqual.rzpro.items.rezeptur.SteuerLagerItem;
import de.lunqual.rzpro.items.rezeptur.ZutatenSuchItem;
import de.lunqual.rzpro.items.stichworte.StichwortItem;
import de.lunqual.rzpro.items.stichworte.StichwortListe;
import de.lunqual.rzpro.items.tank.tankAuswahlItem;
import de.lunqual.rzpro.items.tank.tankItem;
import de.lunqual.rzpro.items.versionen.VersionsItem;
import de.lunqual.rzpro.items.zutatenverzeichnis.ZutatenverzeichnisListe;
import de.lunqual.rzpro.log.LogFactory;
import de.lunqual.rzpro.options.OptionFactory;

/**
 * 
 * @author administrator
 */
public class Rezeptur extends JRzFrame  implements TableColumnModelListener{

	// ActionCodes NotizFenster
	public static final int ACTION_OK_CODE = 1000;
	public static final String ACTION_OK_TEXT = "rezeptur.action_ok";
	public static final int ACTION_ABBRECHEN_CODE = 1001;
	public static final String ACTION_ABBRECHEN_TEXT = "rezeptur.action_abbrechen";
	public static final int ACTION_ADRESSLISTE_BEARBEITEN_CODE = 1002;
	public static final String ACTION_ADRESSLISTE_BEARBEITEN_TEXT = "rezeptur.action_adressliste_bearbeiten";
	public static final int ACTION_ADRESSLISTE_LOESCHEN_CODE = 1003;
	public static final String ACTION_ADRESSLISTE_LOESCHEN_TEXT = "rezeptur.action_adressliste_loeschen";
	public static final int ACTION_STICHWORTLISTE_BEARBEITEN_CODE = 1004;
	public static final String ACTION_STICHWORTLISTE_BEARBEITEN_TEXT = "rezeptur.action_stichwortliste_bearbeiten";
	public static final int ACTION_STICHWORTLISTE_LOESCHEN_CODE = 1005;
	public static final String ACTION_STICHWORTLISTE_LOESCHEN_TEXT = "rezeptur.action_stichwortliste_loeschen";
	public static final int ACTION_VERWEIS_CODE = 1006;
	public static final String ACTION_VERWEIS_TEXT = "rezeptur.action_verweis";
	public static final int ACTION_VERWEIS_ENTFERNEN_CODE = 1007;
	public static final String ACTION_VERWEIS_ENTFERNEN_TEXT = "rezeptur.action_verweis_entfernen";
	public static final int ACTION_HIDE_CODE = 1008;
	public static final String ACTION_HIDE_TEXT = "action_hide";
	public static final int ACTION_HILFE_CODE = 1009;
	public static final String ACTION_HILFE_TEXT = "action_hilfe";
	public static final int ACTION_ACIDRECHNER_CODE = 1010;
	public static final String ACTION_ACIDRECHNER_TEXT = "rezeptur.action_acidrechner";
	public static final int ACTION_DEKLARATIONEN_BEARBEITEN_CODE = 1011;
	public static final String ACTION_DEKLARATIONEN_BEARBEITEN_TEXT = "rezeptur.action_deklarationsliste_bearbeiten";
	public static final int ACTION_DEKLARATIONEN_LOESCHEN_CODE = 1012;
	public static final String ACTION_DEKLARATIONEN_LOESCHEN_TEXT = "rezeptur.action_deklarationsliste_loeschen";
	public static final int ACTION_MUSTERNUMMER_CODE = 1013;
	public static final String ACTION_MUSTERNUMMER_TEXT = "rezeptur.action_musternummer";
	public static final int ACTION_BACKUP_VERSION_CODE = 1014;
	public static final String ACTION_BACKUP_VERSION_TEXT = "rezeptur.action_backup_version";
	public static final int ACTION_DELETE_VERSION_CODE = 1015;
	public static final String ACTION_DELETE_VERSION_TEXT = "rezeptur.action_delete_version";
	public static final int ACTION_LABORWERTE_CODE = 1016;
	public static final String ACTION_LABORWERTE_TEXT = "rezeptur.action_berechnen";
	public static final int ACTION_TANKLISTE_PLAN_CODE = 1017;
	public static final String ACTION_TANKLISTE_PLAN_TEXT = "tankliste_plan";
	public static final int ACTION_ZUTATENVERZEICHNIS_CODE = 1018;
	public static final String ACTION_ZUTATENVERZEICHNIS_TEXT = "rezeptur.action_zutatenverzeichnis";
	public static final int ACTION_LABORWERTE_ALLE_CODE = 1019;
	public static final String ACTION_LABORWERTE_ALLE_TEXT = "rezeptur.action_berechnen_alle";
	
	
    private static final String				DATUM_FORMAT="EEEE, dd. MMMM yyyy";
	
	// Swing-Variablen

	private JMenuBar mb;
	private JMenu mnuAdressliste;
	private JMenu mnuDatei;
	private JMenu mnuFenster;
	private JMenu mnuExtras;
	private JMenu mnuHilfe;
	private JMenu mnuStichwortListe;
	private JMenu mnuDeklarationen;
	private JToolBar tb1;
	private JPanel tbPanel;
	private JPanel mainPanel;
	private JPanel mainNorth;
	private JPanel topPanel;// name,staerke,stichworte,adressen
	private JPanel nameStaerke;
	private JPanel name;
	private JLabel lblName;
	private JSelectedTextField txtName;
		private JButton btMusternummer;
	private JPanel verweis;
	private JLabel lblVerweis;
	private JLabel lblVerweisRezeptur;
	private JPanel verweisButtonPanel;
	private JButton btVerweis;
	private JButton btVerweisEntfernen;
	private JPanel listenPanel;
		private JPanel eanPanel;
			private JLabel lblEan;
			private JScrollPane scrEan;
			private JTextPane txtEan;
	private JPanel adressen;
	private JLabel lblAdressenTitel;
	private JScrollPane adressenScrollPane;
	private JRzList lstAdressen;
	private JPanel adressenButtonPane;
	private JButton btAdressenBearbeiten;
	private JButton btAdressenLoeschen;
	private JPanel deklarationen;
	private JLabel lblDeklarationenTitel;
	private JScrollPane deklarationenScrollPane;
	private JRzList lstDeklarationen;
	private JPanel deklarationenButtonPane;
	private JButton btDeklarationenBearbeiten;
	private JButton btDeklarationenLoeschen;
	private JPanel stichworte;
	private JLabel lblStichworteTitel;
	private JScrollPane stichworteScrollPane;
	private JRzList lstStichworte;
	private JPanel stichwortButtonPane;
	private JButton btStichworteBearbeiten;
	private JButton btStichworteLoeschen;
	private JPanel mainCenter;
	private JPanel textMenge;
	private JPanel menge;
	private JPanel basis;
	private JLabel lblBasis;
	private JNumberField txtBasis;
	private JComboBox cmbBasiseinheit;
	private JLabel lblStaerke;
	private JNumberField txtStaerke;
	private JPanel textPanel;
		private JPanel versionsPanel;
			private JLabel textTitel;
			private JPanel versionsCMBPanel;
				private JComboBox cmbVersionen;
				private JPanel versionsButtonPanel;
					private JButton btVBackup;
					private JButton btVOriginal;
					private JButton btVDelete;
	private JScrollPane textScrollPane;
	private JTextPane txtText;
	private JPanel summenPanel;
	private JPanel gesamtsummePanel;
	private JPanel gesamtsummeLabelPanel;
	private JLabel lblGesamtsumme;
	private JPanel gesamtsummeButtonPanel;
	private JButton btGesamtsummeLiter;
	private JButton btGesamtsummeKg;
	private JButton btGesamtsummeLA;
	private JButton btGesamtsummeProzent;
	private JPanel einzelsummePanel;
	private JPanel einzelsummeLabelPanel;
	private JLabel lblEinzelsumme;
	private JPanel einzelsummeButtonPanel;
	private JButton btEinzelsummeStart;
	private JButton btEinzelsummeLiter;
	private JButton btEinzelsummeKg;
	private JButton btEinzelsummeLA;
	private JButton btEinzelsummeProzent;

	private JScrollPane scrDaten;
	private JPanel daten;
	private JPanel aDaten;
	private JCheckBox chkExtraktfrei;
	private JLabel lblExtrakt;
	private JLabel lblExtrakt2;
	private JNumberField txtExtrakt;
	private JLabel lblLitergewicht;
	private JLabel lblLitergewicht2;
	private JNumberField txtLitergewicht;
	private JLabel lblLagertitel;
	private JLabel lblBestand;
	private JNumberField txtBestand;
	private JLabel lblMeldebestand;
	private JNumberField txtMeldebestand;
	private JLabel lblVorschlagsbestand;
	private JNumberField txtVorschlagsbestand;
	private JComboBox cmbBestandseinheit;
	
	private JCheckBox chkAutoAnfrage;
	
	private JLabel lblSchwundsatz;
	private JNumberField txtSchwundsatz;
	private JLabel lblLager;
	private JComboBox cmbLager;
	
	private JLabel lblSteuerArtikel;
	private JSelectedTextField txtSteuerArtikel;
	private JLabel lblSorte;
	private JComboBox cmbSorte;
	private JLabel lblSteuerLager;
	private JComboBox cmbSteuerlager;
	
	private JNumberField txtPreismenge;
	private JComboBox cmbPreiseinheit;
	private JLabel lblKostet;
	private JLabel lblPreistitel;
	private JNumberField txtPreis;
	private JComboBox cmbWaehrung;

	private JLabel lblBrennwertAlkohol;
	private JLabel lblBrennwertAlkoholValue;
	private JLabel lblBrennwert;
	private JNumberField txtBrennwert;

	private JLabel lblAcid;
	private JNumberField txtAcid;
	private JButton btAcid;

	private JLabel lblArtikelnummer;
	private JSelectedTextField txtArtikelnummer;
	private JLabel lblLosnummer;
	private JSelectedTextField txtLosnummer;
	private JLabel lblTank;
	private JSelectedTextField txtTank;
		private JButton tankNummer;
		private JButton btTankPlan;
	private JLabel lblSpezifikation;
	private JSelectedTextField txtSpezifikation;
	
	private JCheckBox chkKonform;
	private JLabel lblKonformDatum;
	private RzSimpleDatePicker	picker;
	
	private JLabel lblKonformComment;
	private JSelectedTextField txtKonformComment;
	
	
	private JLabel lblRProbe;
	private JCheckBox chkRProbe;
	private JLabel lblProbenAnzahl;
	private JSpinner spProbenAnzahl;

	private JLabel lblBewertung;
		private JCheckBox chkBewertung;
	
	private JLabel lblTemperatur;
	private JIntegerField tmpVon;
	private JLabel lblTemperaturBis;
	private JIntegerField tmpBis;
	private JLabel lblTemperaturDurchschnitt;
	
	
	private JPanel laborwertePanel;
		private JPanel laborwerteButtons;
			private JButton btRechnenFenster;
			private JButton btRechnenAlle;
				private JScrollPane scrLaborwerte;
					private JTable tblWerte;

	private JPanel spezifikationTextPanel;
	 	private JPanel spezifikationLabelPanel;
			private JLabel lblSpezifikationText;
			private JButton btZutatenVerzeichnis;
		private JScrollPane scrSpezifikationText;
			private JTextPane txtSpezifikationText;
	
	JPanel blind;
	private JPanel mainSouth;
	private JPanel erstelltGeaendert;
	private JLabel lblErstellt;
	private JLabel lblGeaendert;
	private JPanel okCancel;
	private JButton btOK;
	private JPanel platzhalter;
	private JButton btHilfe;
	private JButton btCancel;

	RezepturItem rezeptur;
	RezepturItem rezepturVerweis;

	ErgebnisItem callerObject;

	JRzFrame origin;
	BigDecimal preis = new BigDecimal(0.0);
	double preisMenge = 0.0;
	int preisEinheit = 0;
	// Actions

	ZutatenDialog zd;
	private static final int GET_REZEPTUR = 1;
	private static final int GET_VERWEIS = 2;
	int zd_dialog_typ = GET_REZEPTUR;

	private static final int 				MAX_COLUMN = 6;
	private static final int 				C_WERT=0;
	private static final int				C_RECHNEN=1;
	private static final int				C_VALUE=2;
	private static final int				C_EINHEIT=3;
	private static final int				C_SPEZIFIKATION=4;
	private static final int				C_AUSGABE=5;
	
	
	EinheitenDialog						 ed;

	DecimalFormatSymbols 				dfs;
	char 								comma = ',';
	ArrayList<LaborwertValueItem>		liste;
	
	BewertungsItem						bwi;
	boolean								modified = false;
	String								originalComment = "";
	double								originalBasismenge = 0;
	double								originalStaerke = 0;
	
	/** Creates new form rezepturFenster */
	public Rezeptur(RzPro r, String name, Object extendedData) {
		super(r, name, extendedData);
		try {
			dfs = ((DecimalFormat) rz.getLocale().getNumberFormat(
					OptionFactory.NF_NORMAL)).getDecimalFormatSymbols();
			comma = dfs.getDecimalSeparator();
		} catch (final Exception e) {
		};
		liste = new ArrayList<LaborwertValueItem>();
		bwi=null;
		createActions();
		createGUIComponents();
		setGUIComponents();
		getMessage((MessageItem) extendedData);
	}

	@Override
	public void createGUIComponents() {
		mb = new JMenuBar();
		mnuDatei = new JMenu();
		mnuAdressliste = new JMenu();
		mnuStichwortListe = new JMenu();
		mnuDeklarationen = new JMenu();
		mnuExtras = new JMenu();
		mnuFenster = new JMenu();
		mnuHilfe = new JMenu();
		mb.add(mnuDatei);
		mb.add(mnuAdressliste);
		mb.add(mnuDeklarationen);
		mb.add(mnuStichwortListe);
		mb.add(mnuFenster);
		mb.add(mnuExtras);
		mb.add(mnuHilfe);
		setJMenuBar(mb); // Ans Fenster ketten

		tb1 = new JToolBar();
		tb1.setFloatable(false);
		tb1.setRollover(true);
		// Panels & buttons...
		tbPanel = new JPanel(new BorderLayout());
		tbPanel.add(tb1, BorderLayout.CENTER);
		mainPanel = new JPanel(new BorderLayout());
		this.getContentPane().setLayout(new BorderLayout());
		this.getContentPane().add(tbPanel, BorderLayout.NORTH);
		// mainPanel
		mainPanel = new JPanel(new BorderLayout());
		this.getContentPane().add(mainPanel, BorderLayout.CENTER);
		// mainNorthPanel
		mainNorth = new JPanel(new BorderLayout());
		mainPanel.add(mainNorth, BorderLayout.NORTH);
		// topPanel Name,staerke,adressen,stichworte
		topPanel = new JPanel(new BorderLayout());
		mainNorth.add(topPanel, BorderLayout.NORTH);
		// oberer Teil Name und Stärke
		nameStaerke = new JPanel(new BorderLayout());
		topPanel.add(nameStaerke, BorderLayout.NORTH);
		// Name,stärke
		name = new JPanel(new BorderLayout());
		nameStaerke.add(name, BorderLayout.NORTH);
		// name
		lblName = new JLabel();
		lblName.setHorizontalAlignment(SwingConstants.TRAILING);
		name.add(lblName, BorderLayout.WEST);
		txtName = new JSelectedTextField();
		name.add(txtName, BorderLayout.CENTER);
		btMusternummer = new JButton();
			name.add(btMusternummer,BorderLayout.EAST);
		verweis = new JPanel(new BorderLayout());
		lblVerweis = new JLabel();
		lblVerweis.setHorizontalAlignment(SwingConstants.TRAILING);
		lblVerweisRezeptur = new JLabel();
		lblVerweisRezeptur.setHorizontalAlignment(SwingConstants.CENTER);
		lblVerweisRezeptur.setBorder(BorderFactory.createEtchedBorder());
		lblVerweisRezeptur.setOpaque(true);
		verweis.add(lblVerweis, BorderLayout.WEST);
		verweis.add(lblVerweisRezeptur, BorderLayout.CENTER);
		verweisButtonPanel = new JPanel(new BorderLayout());
		btVerweis = new JButton();
		verweisButtonPanel.add(btVerweis, BorderLayout.WEST);
		btVerweisEntfernen = new JButton();
		verweisButtonPanel.add(btVerweisEntfernen, BorderLayout.EAST);
		verweis.add(verweisButtonPanel, BorderLayout.EAST);
		nameStaerke.add(verweis, BorderLayout.SOUTH);

		// Panel mit Adressen und Stichworten
		listenPanel = new JPanel(new GridLayout(0, 4));
		topPanel.add(listenPanel, BorderLayout.CENTER);
		
		eanPanel = new JPanel(new BorderLayout());
			eanPanel.setBorder(BorderFactory.createEtchedBorder());
			lblEan = new JLabel();
			lblEan.setHorizontalAlignment(SwingConstants.CENTER);
			eanPanel.add(lblEan,BorderLayout.NORTH);
			scrEan = new JScrollPane();
				txtEan = new JTextPane();
				scrEan.setViewportView(txtEan);
			eanPanel.add(scrEan,BorderLayout.CENTER);
		
		listenPanel.add(eanPanel);
		// linkes Panel...Adressen
		adressen = new JPanel(new BorderLayout());
			adressen.setBorder(BorderFactory.createEtchedBorder());
		listenPanel.add(adressen);
		lblAdressenTitel = new JLabel();
		lblAdressenTitel.setHorizontalAlignment(SwingConstants.CENTER);
		adressen.add(lblAdressenTitel, BorderLayout.NORTH);
		adressenScrollPane = new JScrollPane();
		adressenScrollPane
				.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_AS_NEEDED);
		adressenScrollPane
				.setHorizontalScrollBarPolicy(ScrollPaneConstants.HORIZONTAL_SCROLLBAR_AS_NEEDED);
		adressenScrollPane.setPreferredSize(new Dimension(100, 150));
		lstAdressen = new JRzList();
		adressenScrollPane.setViewportView(lstAdressen);
		lstAdressen.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		adressen.add(adressenScrollPane, BorderLayout.CENTER);
		adressenButtonPane = new JPanel(new GridLayout(1, 2));
		btAdressenBearbeiten = new JButton();
		adressenButtonPane.add(btAdressenBearbeiten);
		btAdressenLoeschen = new JButton();
		adressenButtonPane.add(btAdressenLoeschen);
		adressen.add(adressenButtonPane, BorderLayout.SOUTH);

		// mittleres Panel...Deklarationen
		deklarationen = new JPanel(new BorderLayout());
			deklarationen.setBorder(BorderFactory.createEtchedBorder());
		listenPanel.add(deklarationen);
		lblDeklarationenTitel = new JLabel();
		lblDeklarationenTitel.setHorizontalAlignment(SwingConstants.CENTER);
		deklarationen.add(lblDeklarationenTitel, BorderLayout.NORTH);
		deklarationenScrollPane = new JScrollPane();
		deklarationenScrollPane
				.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_AS_NEEDED);
		deklarationenScrollPane
				.setHorizontalScrollBarPolicy(ScrollPaneConstants.HORIZONTAL_SCROLLBAR_AS_NEEDED);
		deklarationenScrollPane.setPreferredSize(new Dimension(100, 150));
		lstDeklarationen = new JRzList();
		deklarationenScrollPane.setViewportView(lstDeklarationen);
		lstDeklarationen.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		deklarationen.add(deklarationenScrollPane, BorderLayout.CENTER);
		deklarationenButtonPane = new JPanel(new GridLayout(1, 2));
		btDeklarationenBearbeiten = new JButton();
		deklarationenButtonPane.add(btDeklarationenBearbeiten);
		btDeklarationenLoeschen = new JButton();
		deklarationenButtonPane.add(btDeklarationenLoeschen);
		deklarationen.add(deklarationenButtonPane, BorderLayout.SOUTH);

		// rechtes Panel .. Stichworte
		stichworte = new JPanel(new BorderLayout());
			stichworte.setBorder(BorderFactory.createEtchedBorder());
		listenPanel.add(stichworte);
		lblStichworteTitel = new JLabel();
		lblStichworteTitel.setHorizontalAlignment(SwingConstants.CENTER);
		stichworte.add(lblStichworteTitel, BorderLayout.NORTH);
		stichworteScrollPane = new JScrollPane();
		stichworteScrollPane
				.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_AS_NEEDED);
		stichworteScrollPane
				.setHorizontalScrollBarPolicy(ScrollPaneConstants.HORIZONTAL_SCROLLBAR_AS_NEEDED);
		stichworteScrollPane.setPreferredSize(new Dimension(100, 150));
		lstStichworte = new JRzList();
		lstStichworte.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		stichworteScrollPane.setViewportView(lstStichworte);
		lstStichworte.setCellRenderer(new STWListRenderer(rz));
		stichworte.add(stichworteScrollPane, BorderLayout.CENTER);
		stichwortButtonPane = new JPanel(new GridLayout(1, 2));
		btStichworteBearbeiten = new JButton();
		stichwortButtonPane.add(btStichworteBearbeiten);
		btStichworteLoeschen = new JButton();
		stichwortButtonPane.add(btStichworteLoeschen);
		stichworte.add(stichwortButtonPane, BorderLayout.SOUTH);
		listenPanel.add(stichworte);
		topPanel.setBorder(BorderFactory.createEtchedBorder());
		mainPanel.add(topPanel, BorderLayout.NORTH);
		// Text und Menge
		// mainCenter = new JPanel(new GridLayout(1,2));
		mainCenter = new JPanel(new BorderLayout());
		textMenge = new JPanel(new BorderLayout());
		mainCenter.add(textMenge, BorderLayout.WEST);
		// menge
		menge = new JPanel(new BorderLayout());
		textMenge.add(menge, BorderLayout.NORTH);
		// basis
		basis = new JPanel(new GridLayout(2, 3));
		lblBasis = new JLabel();
		basis.add(lblBasis);
		lblBasis.setHorizontalAlignment(SwingConstants.TRAILING);
		txtBasis = new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_NORMAL), 100.0, 0.0, Double.POSITIVE_INFINITY);
			txtBasis.addFocusListener(new FocusListener() {
				public void focusGained(FocusEvent evt) {
				}
				public void focusLost(FocusEvent evt) {
					setLaborwerteSaveable(isLaborwerteSaveable());	
				}	
			});
		basis.add(txtBasis);
		cmbBasiseinheit = new JComboBox();
		basis.add(cmbBasiseinheit);
		// stärke
		lblStaerke = new JLabel();
		lblStaerke.setHorizontalAlignment(SwingConstants.TRAILING);
		basis.add(lblStaerke);
		basis.add(lblStaerke, BorderLayout.WEST);
		txtStaerke = new JNumberField(rz.getLocale().getNumberFormat(
				OptionFactory.NF_STAERKE), 0.0, 0.0, 99.9);
		txtStaerke.addKeyListener(new java.awt.event.KeyAdapter() {
			@Override
			public void keyReleased(java.awt.event.KeyEvent evt) {
				txtStaerkeKeyReleased(evt);
			}
		});
		txtStaerke.addFocusListener(new FocusListener() {
			public void focusGained(FocusEvent evt) {
			}
			public void focusLost(FocusEvent evt) {
				if (rezeptur != null) {
					if (!rz.isZero(txtStaerke.getValue())) {
						rezeptur.setBestandseinheit(rz.getDatabase().getEinheiten().getLaItem().getTyp());
						for (int i = 0; i < cmbBestandseinheit.getModel()
								.getSize(); i++) {
							if (((EinheitsItem) cmbBestandseinheit.getModel().getElementAt(i)).getTyp() == rezeptur.getBestandseinheit()) {
								cmbBestandseinheit.setSelectedIndex(i);
								break;
							}
						}
						// Brennwert
					}
					setBrennwertAlkoholValue();
					setLaborwerteSaveable(isLaborwerteSaveable());	
				}	
			}
		});
		basis.add(txtStaerke);
		menge.add(basis, BorderLayout.NORTH);
		// text
		textPanel = new JPanel(new BorderLayout());

		versionsPanel=new JPanel(new BorderLayout());
			versionsPanel.setBorder(BorderFactory.createEtchedBorder());
			textTitel = new JLabel();
			textTitel.setHorizontalAlignment(SwingConstants.CENTER);
			versionsPanel.add(textTitel,BorderLayout.NORTH);
			versionsCMBPanel = new JPanel(new BorderLayout());
				cmbVersionen = new JComboBox();
				cmbVersionen.addActionListener(new java.awt.event.ActionListener() {
					public void actionPerformed(java.awt.event.ActionEvent evt) {
						versionenCMBAction();
					}
				});
				versionsCMBPanel.add(cmbVersionen, BorderLayout.NORTH);
				versionsButtonPanel=new JPanel(new GridLayout(1,2));
					btVBackup=new JButton();
					versionsButtonPanel.add(btVBackup);
					btVDelete=new JButton();
					versionsButtonPanel.add(btVDelete);
				versionsPanel.add(versionsButtonPanel,BorderLayout.SOUTH);
			versionsPanel.add(versionsCMBPanel,BorderLayout.CENTER);
			versionsPanel.add(versionsButtonPanel,BorderLayout.SOUTH);
		textPanel.add(versionsPanel, BorderLayout.NORTH);
		textScrollPane = new JScrollPane();
		textPanel.add(textScrollPane);
		textPanel.setBorder(BorderFactory.createRaisedBevelBorder());
		textScrollPane
				.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_AS_NEEDED);
		textScrollPane
				.setHorizontalScrollBarPolicy(ScrollPaneConstants.HORIZONTAL_SCROLLBAR_AS_NEEDED);
		textScrollPane.setPreferredSize(new Dimension(100, 250));
		txtText = new JRzTextPane(rz.getLocale().getNumberFormat(
				OptionFactory.NF_NORMAL));
		textScrollPane.setViewportView(txtText);
		txtText.addKeyListener(new java.awt.event.KeyAdapter() {
			@Override
			public void keyReleased(java.awt.event.KeyEvent evt) {
				txtTextKeyReleased(evt);
			}
		});
		textMenge.add(textPanel, BorderLayout.CENTER);
		summenPanel = new JPanel(new BorderLayout());
		gesamtsummePanel = new JPanel(new BorderLayout());
		gesamtsummePanel.setBorder(BorderFactory.createEtchedBorder());
		gesamtsummeLabelPanel = new JPanel(new BorderLayout());
		lblGesamtsumme = new JLabel();
		lblGesamtsumme.setHorizontalAlignment(SwingConstants.CENTER);
		gesamtsummeLabelPanel.add(lblGesamtsumme, BorderLayout.NORTH);
		gesamtsummePanel.add(gesamtsummeLabelPanel, BorderLayout.NORTH);
		gesamtsummeButtonPanel = new JPanel();
		btGesamtsummeLiter = new JButton();
		btGesamtsummeLiter
				.addActionListener(new java.awt.event.ActionListener() {
					public void actionPerformed(java.awt.event.ActionEvent evt) {
						summenInsert(btGesamtsummeLiter.getText());
					}
				});
		gesamtsummeButtonPanel.add(btGesamtsummeLiter);
		btGesamtsummeKg = new JButton();
		btGesamtsummeKg.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				summenInsert(btGesamtsummeKg.getText());
			}
		});
		gesamtsummeButtonPanel.add(btGesamtsummeKg);
		btGesamtsummeLA = new JButton();
		btGesamtsummeLA.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				summenInsert(btGesamtsummeLA.getText());
			}
		});
		gesamtsummeButtonPanel.add(btGesamtsummeLA);
		btGesamtsummeProzent = new JButton();
		btGesamtsummeProzent
				.addActionListener(new java.awt.event.ActionListener() {
					public void actionPerformed(java.awt.event.ActionEvent evt) {
						summenInsert(btGesamtsummeProzent.getText());
					}
				});
		gesamtsummeButtonPanel.add(btGesamtsummeProzent);
		gesamtsummePanel.add(gesamtsummeButtonPanel, BorderLayout.SOUTH);
		summenPanel.add(gesamtsummePanel, BorderLayout.NORTH);

		einzelsummePanel = new JPanel(new BorderLayout());
		einzelsummePanel.setBorder(BorderFactory.createEtchedBorder());
		einzelsummeLabelPanel = new JPanel(new BorderLayout());
		lblEinzelsumme = new JLabel();
		lblEinzelsumme.setHorizontalAlignment(SwingConstants.CENTER);
		einzelsummeLabelPanel.add(lblEinzelsumme, BorderLayout.NORTH);
		einzelsummePanel.add(einzelsummeLabelPanel, BorderLayout.NORTH);
		einzelsummeButtonPanel = new JPanel();
		btEinzelsummeStart = new JButton();
		btEinzelsummeStart
				.addActionListener(new java.awt.event.ActionListener() {
					public void actionPerformed(java.awt.event.ActionEvent evt) {
						summenInsert(btEinzelsummeStart.getText());
					}
				});
		einzelsummeButtonPanel.add(btEinzelsummeStart);
		btEinzelsummeLiter = new JButton();
		btEinzelsummeLiter
				.addActionListener(new java.awt.event.ActionListener() {
					public void actionPerformed(java.awt.event.ActionEvent evt) {
						summenInsert(btEinzelsummeLiter.getText());
					}
				});
		einzelsummeButtonPanel.add(btEinzelsummeLiter);
		btEinzelsummeKg = new JButton();
		btEinzelsummeKg.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				summenInsert(btEinzelsummeKg.getText());
			}
		});
		einzelsummeButtonPanel.add(btEinzelsummeKg);
		btEinzelsummeLA = new JButton();
		btEinzelsummeLA.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				summenInsert(btEinzelsummeLA.getText());
			}
		});
		einzelsummeButtonPanel.add(btEinzelsummeLA);
		btEinzelsummeProzent = new JButton();
		btEinzelsummeProzent
				.addActionListener(new java.awt.event.ActionListener() {
					public void actionPerformed(java.awt.event.ActionEvent evt) {
						summenInsert(btEinzelsummeProzent.getText());
					}
				});
		einzelsummeButtonPanel.add(btEinzelsummeProzent);
		einzelsummePanel.add(einzelsummeButtonPanel, BorderLayout.SOUTH);
		summenPanel.add(einzelsummePanel, BorderLayout.SOUTH);

		textPanel.add(summenPanel, BorderLayout.SOUTH);

		// DatenPanel
		scrDaten = new JScrollPane();
		daten = new JPanel(new BorderLayout());
		aDaten = new JPanel(new GridBagLayout());
		final GridBagConstraints c = new GridBagConstraints();
		c.weightx = 1.5;
		c.fill = GridBagConstraints.BOTH;
		c.insets = new Insets(1, 1, 1, 1);
		chkExtraktfrei = new JCheckBox();
		chkExtraktfrei.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				setExtraktfreiStatus();
			}
		});
		c.gridx = 0;
		c.gridy = 0;
		c.gridheight = 1;
		c.gridwidth = 1;
		aDaten.add(chkExtraktfrei, c);

		lblLitergewicht = new JLabel();
		lblLitergewicht.setHorizontalAlignment(SwingConstants.TRAILING);
		c.gridx = 1;
		c.gridy = 0;
		c.gridheight = 1;
		c.gridwidth = 1;
		aDaten.add(lblLitergewicht, c);

		txtLitergewicht = new JNumberField(rz.getLocale().getNumberFormat(
				OptionFactory.NF_LITERGEWICHT), 1.0, 0.0,
				Double.POSITIVE_INFINITY);
		c.gridx = 2;
		c.gridy = 0;
		c.gridheight = 1;
		c.gridwidth = 1;
		aDaten.add(txtLitergewicht, c);

		lblLitergewicht2 = new JLabel();
		lblLitergewicht.setHorizontalAlignment(SwingConstants.TRAILING);
		lblLitergewicht2.setText(rz.getDatabase().getEinheiten()
				.dbGetLitergewichtString());
		c.gridx = 3;
		c.gridy = 0;
		c.gridheight = 1;
		c.gridwidth = 1;
		aDaten.add(lblLitergewicht2, c);

		lblExtrakt = new JLabel();
		lblExtrakt.setHorizontalAlignment(SwingConstants.TRAILING);
		c.gridx = 4;
		c.gridy = 0;
		c.gridheight = 1;
		c.gridwidth = 1;
		aDaten.add(lblExtrakt, c);

		txtExtrakt = new JNumberField(rz.getLocale().getNumberFormat(
				OptionFactory.NF_NORMAL), 0.0, 0.0, Double.POSITIVE_INFINITY);
		c.gridx = 5;
		c.gridy = 0;
		c.gridheight = 1;
		c.gridwidth = 1;
		aDaten.add(txtExtrakt, c);

		lblExtrakt2 = new JLabel();
		lblExtrakt2.setHorizontalAlignment(SwingConstants.LEADING);
		c.gridx = 6;
		c.gridy = 0;
		c.gridheight = 1;
		c.gridwidth = 1;
		aDaten.add(lblExtrakt2, c);
		//-------------------------------------------------------------------------
		//1.zeile
		c.gridx = 0;
		c.gridy = 1;
		c.gridheight = 1;
		c.gridwidth = 7;
		aDaten.add(new JSeparator(SwingConstants.HORIZONTAL), c);
		lblLagertitel = new JLabel();
		lblLagertitel.setHorizontalAlignment(SwingConstants.CENTER);
		c.gridx = 0;
		c.gridy =2;
		c.gridheight = 1;
		c.gridwidth = 7;
		aDaten.add(lblLagertitel, c);

		lblBestand = new JLabel();
		lblBestand.setHorizontalAlignment(SwingConstants.LEADING);
		c.gridx = 0;
		c.gridy = 3;
		c.gridheight = 1;
		c.gridwidth = 1;
		aDaten.add(lblBestand, c);

		txtBestand = new JNumberField(rz.getLocale().getNumberFormat(
				OptionFactory.NF_NORMAL), 0.0, Double.NEGATIVE_INFINITY,
				Double.POSITIVE_INFINITY);
		txtBestand.setEditable(false);
		c.gridx = 1;
		c.gridy = 3;
		c.gridheight = 1;
		c.gridwidth = 1;
		aDaten.add(txtBestand, c);
		txtBestand.setEnabled(false);
		lblMeldebestand = new JLabel();
		lblMeldebestand.setHorizontalAlignment(SwingConstants.TRAILING);
		c.gridx = 2;
		c.gridy = 3;
		c.gridheight = 1;
		c.gridwidth = 1;
		aDaten.add(lblMeldebestand, c);

		txtMeldebestand = new JNumberField(rz.getLocale().getNumberFormat(
				OptionFactory.NF_NORMAL), 0.0, Double.NEGATIVE_INFINITY,
				Double.POSITIVE_INFINITY);
		c.gridx = 3;
		c.gridy = 3;
		c.gridheight = 1;
		c.gridwidth = 1;
		aDaten.add(txtMeldebestand, c);

		cmbBestandseinheit = new JComboBox();
		c.gridx = 4;
		c.gridy = 3;
		c.gridheight = 1;
		c.gridwidth = 1;
		aDaten.add(cmbBestandseinheit, c);

		lblVorschlagsbestand = new JLabel();
		lblVorschlagsbestand.setHorizontalAlignment(SwingConstants.TRAILING);
		c.gridx = 5;
		c.gridy = 3;
		c.gridheight = 1;
		c.gridwidth = 1;
		aDaten.add(lblVorschlagsbestand, c);

		txtVorschlagsbestand = new JNumberField(rz.getLocale().getNumberFormat(
				OptionFactory.NF_NORMAL), 0.0, Double.NEGATIVE_INFINITY,
				Double.POSITIVE_INFINITY);
		c.gridx = 6;
		c.gridy = 3;
		c.gridheight = 1;
		c.gridwidth = 1;
		aDaten.add(txtVorschlagsbestand, c);

		chkAutoAnfrage = new JCheckBox();
		c.gridx = 6;
		c.gridy = 4;
		c.gridheight = 1;
		c.gridwidth = 1;
		aDaten.add(chkAutoAnfrage, c);
//-------------------------------------------------------------
		lblSchwundsatz = new JLabel();
		lblSchwundsatz.setHorizontalAlignment(SwingConstants.LEADING);
		c.gridx = 0;
		c.gridy = 5;
		c.gridheight = 1;
		c.gridwidth = 1;
		aDaten.add(lblSchwundsatz, c);

		txtSchwundsatz = new JNumberField(rz.getLocale().getNumberFormat(
				OptionFactory.NF_STAERKE), 0.0, 0.0, Double.POSITIVE_INFINITY);
		c.gridx = 2;
		c.gridy = 5;
		c.gridheight = 1;
		c.gridwidth = 3;
		aDaten.add(txtSchwundsatz, c);

		lblLager = new JLabel();
		lblLager.setHorizontalAlignment(SwingConstants.TRAILING);
		c.gridx = 5;
		c.gridy = 5;
		c.gridheight = 1;
		c.gridwidth = 1;
		aDaten.add(lblLager, c);

		cmbLager = new JComboBox();
		c.gridx = 6;
		c.gridy = 5;
		c.gridheight = 1;
		c.gridwidth = 2;
		aDaten.add(cmbLager, c);
		//--------------------------------------------
		c.gridx = 0;
		c.gridy = 6;
		c.gridheight = 1;
		c.gridwidth = 1;
		lblSteuerArtikel=new JLabel();
		
		aDaten.add(lblSteuerArtikel,c);
		
		c.gridx = 1;
		c.gridy = 6;
		c.gridheight = 1;
		c.gridwidth = 2;
		txtSteuerArtikel = new JSelectedTextField();
		aDaten.add(txtSteuerArtikel,c);
		
		c.gridx = 3;
		c.gridy = 6;
		c.gridheight = 1;
		c.gridwidth = 1;
		lblSorte=new JLabel();
		lblSorte.setHorizontalAlignment(SwingConstants.TRAILING);
		aDaten.add(lblSorte,c);
		
		c.gridx = 4;
		c.gridy = 6;
		c.gridheight = 1;
		c.gridwidth = 1;
		cmbSorte=new JComboBox(rz.getDatabase().getMischungen().getSorten().toArray());
		
		aDaten.add(cmbSorte,c);
		
		c.gridx = 5;
		c.gridy = 6;
		c.gridheight = 1;
		c.gridwidth = 1;
		lblSteuerLager=new JLabel();
		lblSteuerLager.setHorizontalAlignment(SwingConstants.TRAILING);
		
		aDaten.add(lblSteuerLager,c);
		
		c.gridx = 6;
		c.gridy = 6;
		c.gridheight = 1;
		c.gridwidth = 1;
		cmbSteuerlager=new JComboBox(rz.getDatabase().getRezeptur().getSteuerlagerListe().toArray());
		aDaten.add(cmbSteuerlager,c);
		
		//-------------------------------------------
		c.gridx = 0;
		c.gridy = 7;
		c.gridheight = 1;
		c.gridwidth = 7;
		aDaten.add(new JSeparator(SwingConstants.HORIZONTAL), c);
		//------------------------------------------------------------
		lblPreistitel = new JLabel();
		lblPreistitel.setHorizontalAlignment(SwingConstants.CENTER);
		lblPreistitel.setHorizontalAlignment(SwingConstants.CENTER);
		c.gridx = 0;
		c.gridy = 8;
		c.gridheight = 1;
		c.gridwidth = 7;
		aDaten.add(lblPreistitel, c);

		txtPreismenge = new JNumberField(rz.getLocale().getNumberFormat(
				OptionFactory.NF_NORMAL), 0.0, 0.0, Double.POSITIVE_INFINITY);
		c.gridx = 0;
		c.gridy = 9;
		c.gridheight = 1;
		c.gridwidth = 2;
		aDaten.add(txtPreismenge, c);

		cmbPreiseinheit = new JComboBox();
		c.gridx = 2;
		c.gridy = 9;
		c.gridheight = 1;
		c.gridwidth = 1;
		aDaten.add(cmbPreiseinheit, c);

		lblKostet = new JLabel();
		lblKostet.setHorizontalAlignment(SwingConstants.CENTER);
		c.gridx = 3;
		c.gridy = 9;
		c.gridheight = 1;
		c.gridwidth = 1;
		aDaten.add(lblKostet, c);

		txtPreis = new JNumberField(rz.getLocale().getNumberFormat(
				OptionFactory.NF_NORMAL), 0.0, 0.0, Double.POSITIVE_INFINITY);
		c.gridx = 4;
		c.gridy = 9;
		c.gridheight = 1;
		c.gridwidth = 2;
		aDaten.add(txtPreis, c);

		cmbWaehrung = new JComboBox();
		c.gridx = 6;
		c.gridy = 9;
		c.gridheight = 1;
		c.gridwidth = 1;
		aDaten.add(cmbWaehrung, c);
		//------------------------------------------------------
		c.gridx = 0;
		c.gridy = 10;
		c.gridheight = 1;
		c.gridwidth = 7;
		aDaten.add(new JSeparator(SwingConstants.HORIZONTAL), c);

		lblBrennwertAlkohol = new JLabel();
		c.gridx = 0;
		c.gridy = 11;
		c.gridheight = 1;
		c.gridwidth = 2;
		aDaten.add(lblBrennwertAlkohol, c);

		lblBrennwertAlkoholValue = new JLabel();
		c.gridx = 2;
		c.gridy = 11;
		c.gridheight = 1;
		c.gridwidth = 3;
		aDaten.add(lblBrennwertAlkoholValue, c);

		lblBrennwert = new JLabel();
		c.gridx = 0;
		c.gridy = 12;
		c.gridheight = 1;
		c.gridwidth = 2;
		aDaten.add(lblBrennwert, c);

		txtBrennwert = new JNumberField(rz.getLocale().getNumberFormat(
				OptionFactory.NF_NORMAL), 0.0, 0.0, Double.POSITIVE_INFINITY);
		c.gridx = 2;
		c.gridy = 12;
		c.gridheight = 1;
		c.gridwidth = 3;
		aDaten.add(txtBrennwert, c);

		c.gridx = 0;
		c.gridy = 13;
		c.gridheight = 1;
		c.gridwidth = 7;
		aDaten.add(new JSeparator(SwingConstants.HORIZONTAL), c);

		// ----------------------------------
		lblAcid = new JLabel();
		c.gridx = 0;
		c.gridy = 14;
		c.gridheight = 1;
		c.gridwidth = 2;
		aDaten.add(lblAcid, c);

		txtAcid = new JNumberField(rz.getLocale().getNumberFormat(
				OptionFactory.NF_NORMAL), 0.0, 0.0, Double.POSITIVE_INFINITY);
		c.gridx = 2;
		c.gridy = 14;
		c.gridheight = 1;
		c.gridwidth = 2;
		aDaten.add(txtAcid, c);

		btAcid = new JButton();
		c.gridx = 4;
		c.gridy = 14;
		c.gridheight = 1;
		c.gridwidth = 1;
		aDaten.add(btAcid, c);

		c.gridx = 0;
		c.gridy = 15;
		c.gridheight = 1;
		c.gridwidth = 7;
		aDaten.add(new JSeparator(SwingConstants.HORIZONTAL), c);
		// ---------------------------------------------------

		lblArtikelnummer = new JLabel();
		lblArtikelnummer.setHorizontalAlignment(SwingConstants.TRAILING);
		c.gridx = 0;
		c.gridy = 16;
		c.gridheight = 1;
		c.gridwidth = 1;
		aDaten.add(lblArtikelnummer, c);

		txtArtikelnummer = new JSelectedTextField();
		c.gridx = 1;
		c.gridy = 16;
		c.gridheight = 1;
		c.gridwidth = 2;
		aDaten.add(txtArtikelnummer, c);

		lblLosnummer = new JLabel();
		lblLosnummer.setHorizontalAlignment(SwingConstants.TRAILING);
		c.gridx = 3;
		c.gridy = 16;
		c.gridheight = 1;
		c.gridwidth = 2;summenInsert(btGesamtsummeLiter.getText());
		aDaten.add(lblLosnummer, c);
		
		txtLosnummer = new JSelectedTextField();
		c.gridx = 5;
		c.gridy = 16;
		c.gridheight = 1;
		c.gridwidth = 2;
		aDaten.add(txtLosnummer, c);
		//-----------------------------------------------------------------
		
		lblTank = new JLabel();
		lblTank.setHorizontalAlignment(SwingConstants.TRAILING);
		c.gridx = 0;
		c.gridy = 17;
		c.gridheight = 1;
		c.gridwidth = 1;
		aDaten.add(lblTank, c);

		txtTank = new JSelectedTextField();
		c.gridx = 1;
		c.gridy = 17;
		c.gridheight = 1;
		c.gridwidth = 1;
		aDaten.add(txtTank, c);

		btTankPlan = new JButton();
		c.gridx = 2;
		c.gridy = 17;
		c.gridheight = 1;
		c.gridwidth = 1;
		aDaten.add(btTankPlan, c);
			
		
		lblSpezifikation = new JLabel();
		lblSpezifikation.setHorizontalAlignment(SwingConstants.TRAILING);
		c.gridx = 4;
		c.gridy = 17;
		c.gridheight = 1;
		c.gridwidth = 1;
		aDaten.add(lblSpezifikation, c);

		txtSpezifikation = new JSelectedTextField();
		c.gridx = 5;
		c.gridy = 17;
		c.gridheight = 1;
		c.gridwidth = 2;
		aDaten.add(txtSpezifikation, c);
		
		c.gridx = 0;
		c.gridy = 18;
		c.gridheight = 1;
		c.gridwidth = 7;
		aDaten.add(new JSeparator(SwingConstants.HORIZONTAL), c);
		
		//konformitätserklärung
		
		chkKonform = new JCheckBox();
		chkKonform.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
            	if(picker != null && txtKonformComment != null) {
            		if(chkKonform.isSelected()) {
            			if(picker !=  null)picker.setComponentsEnabled(picker, true);
            			txtKonformComment.setEnabled(true);
            		}else {
            			if(picker != null)picker.setComponentsEnabled(picker, false);
            			txtKonformComment.setEnabled(false);
            		}
            	}
        	}
    	});
		c.gridx = 0;
		c.gridy = 19;
		c.gridheight = 1;
		c.gridwidth = 1;
		aDaten.add(chkKonform, c);
		
		lblKonformDatum = new JLabel();
		lblKonformDatum.setHorizontalAlignment(SwingConstants.TRAILING);
		c.gridx = 1;
		c.gridy = 19;
		c.gridheight = 1;
		c.gridwidth = 1;
		aDaten.add(lblKonformDatum, c);
		

		
		c.gridx = 2;
		c.gridy = 19;
		c.gridheight = 1;
		c.gridwidth = 1;
		//aDaten.add(chKonformDatum, c);
		
		picker = new RzSimpleDatePicker(rz);
		if(picker !=  null)picker.setComponentsEnabled(picker, false);
		aDaten.add(picker,c);
		
		lblKonformComment = new JLabel();
		lblKonformComment.setHorizontalAlignment(SwingConstants.TRAILING);
		c.gridx = 4;
		c.gridy = 19;
		c.gridheight = 1;
		c.gridwidth = 1;
		aDaten.add(lblKonformComment, c);
		
		txtKonformComment = new JSelectedTextField();
		txtKonformComment.setEnabled(false);
		c.gridx = 5;
		c.gridy = 19;
		c.gridheight = 1;
		c.gridwidth = 2;
		aDaten.add(txtKonformComment, c);
		
		c.gridx = 0;
		c.gridy = 20;
		c.gridheight = 1;
		c.gridwidth = 7;
		aDaten.add(new JSeparator(SwingConstants.HORIZONTAL), c);
		
		
		
		//--------------------------Temperatur
		lblTemperatur=new JLabel();
			lblTemperatur.setHorizontalAlignment(SwingConstants.LEADING);
		c.gridx = 0;
		c.gridy = 21;
		c.gridheight = 1;
		c.gridwidth = 1;
		aDaten.add(lblTemperatur, c);
		
		tmpVon=new JIntegerField(
				rz.getOptionFactory().getOption("rezeptur.temperatur_default",20),
				rz.getOptionFactory().getOption("rezeptur.temperatur_min",-20),
				rz.getOptionFactory().getOption("rezeptur.temperatur_max",30)
				);
		tmpVon.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
            	if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
            		tmpVon.validate();
            		if(tmpVon.getValue() > tmpBis.getValue()) {
            			tmpVon.setValue(tmpBis.getValue());
            		}
            		lblTemperaturDurchschnitt.setText(rz.getLocale().getString("rezeptur.label_temperatur_durchschnitt").replaceAll("%s",String.valueOf((tmpBis.getValue()+tmpVon.getValue())/2)));
            	}
            }
        });
		
		c.gridx = 2;
		c.gridy = 21;
		c.gridheight = 1;
		c.gridwidth = 1;
		aDaten.add(tmpVon, c);
		
		this.lblTemperaturBis=new JLabel();
			lblTemperaturBis.setHorizontalAlignment(SwingConstants.CENTER);
		c.gridx = 3;
		c.gridy = 21;
		c.gridheight = 1;
		c.gridwidth = 1;
		aDaten.add(lblTemperaturBis, c);
		
		tmpBis=new JIntegerField(
				rz.getOptionFactory().getOption("rezeptur.temperatur_default",20),
				rz.getOptionFactory().getOption("rezeptur.temperatur_min",-20),
				rz.getOptionFactory().getOption("rezeptur.temperatur_max",30)
				);
			tmpBis.addKeyListener(new java.awt.event.KeyAdapter() {
		            public void keyReleased(java.awt.event.KeyEvent evt) {
		            	if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
		            		tmpBis.validate();
		            		if(tmpBis.getValue() <tmpVon.getValue()) {
		            			tmpBis.setValue(tmpVon.getValue());
		            		}
		            		lblTemperaturDurchschnitt.setText(rz.getLocale().getString("rezeptur.label_temperatur_durchschnitt").replaceAll("%s",String.valueOf((tmpBis.getValue()+tmpVon.getValue())/2)));
		            	}
		            }
		        });
		
		c.gridx = 4;
		c.gridy = 21;
		c.gridheight = 1;
		c.gridwidth = 1;
		aDaten.add(tmpBis, c);
		
		this.lblTemperaturDurchschnitt=new JLabel();
		lblTemperaturDurchschnitt.setHorizontalAlignment(SwingConstants.LEADING);
			c.gridx = 5;
			c.gridy = 21;
			c.gridheight = 1;
			c.gridwidth = 1;
		aDaten.add(lblTemperaturDurchschnitt, c);
		
		c.gridx = 0;
		c.gridy = 22;
		c.gridheight = 1;
		c.gridwidth = 7;
		aDaten.add(new JSeparator(SwingConstants.HORIZONTAL), c);
		
		lblRProbe = new JLabel();
		c.gridx = 0;
		c.gridy = 23;
		c.gridheight = 1;
		c.gridwidth = 1;
		aDaten.add(lblRProbe, c);

	    spProbenAnzahl = new JSpinner();
	    spProbenAnzahl.setEnabled(false);
          spProbenAnzahl.addChangeListener(new javax.swing.event.ChangeListener() {
             public void stateChanged(javax.swing.event.ChangeEvent evt) {
                  spinnerChanged(spProbenAnzahl,evt);
              }
         });
  		c.gridx = 4;
  		c.gridy = 23;
  		c.gridheight = 1;
  		c.gridwidth = 1;
  		aDaten.add(spProbenAnzahl, c);
		
		
		chkRProbe = new JCheckBox();
		chkRProbe.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
            	if(chkRProbe.isSelected()) {
            		spProbenAnzahl.setEnabled(true);
            	} else {
            		spProbenAnzahl.setEnabled(false);
            	}
        	}
    	});
		c.gridx = 1;
		c.gridy = 23;
		c.gridheight = 1;
		c.gridwidth = 4;
		aDaten.add(chkRProbe, c);
		
		lblProbenAnzahl = new JLabel();
		c.gridx = 2;
		c.gridy = 23;
		c.gridheight = 1;
		c.gridwidth = 1;
		aDaten.add(lblProbenAnzahl, c);
		

		
		lblBewertung = new JLabel();
		c.gridx = 0;
		c.gridy = 24;
		c.gridheight = 1;
		c.gridwidth = 1;
		aDaten.add(lblBewertung, c);

		chkBewertung = new JCheckBox();
		c.gridx = 1;
		c.gridy = 24;
		c.gridheight = 1;
		c.gridwidth = 4;
		aDaten.add(chkBewertung, c);
		
		
		
		laborwertePanel = new JPanel(new BorderLayout());
		c.gridx = 0;
		c.gridy = 25;
		c.gridheight = 1;
		c.gridwidth = 4;
			laborwertePanel.setBorder(BorderFactory.createEtchedBorder());
			scrLaborwerte=new JScrollPane();
				tblWerte = new JTable();
				tblWerte.setName("rezeptur.laborwert.spalten");
	 	        tblWerte.addMouseListener(new MouseAdapter() {
	 	            @Override
					public void mousePressed(MouseEvent e) {
	 	            	//modifyTable();
	 	            }
		 	       @Override
				public void mouseReleased(MouseEvent e) {
		 	          // maybeShowPopup(e);
		 	       }
		 	      public void mouseClicked(MouseEvent e){
			    	  werteClickedAction();
			      }
	 	        });
				tblWerte.setName("rezeptur.laborwerte");
			scrLaborwerte.setViewportView(tblWerte);
			laborwertePanel.add(scrLaborwerte,BorderLayout.CENTER);
			laborwerteButtons = new JPanel(new BorderLayout());
				btRechnenFenster=new JButton();
				laborwerteButtons.add(btRechnenFenster,BorderLayout.WEST);
				btRechnenAlle=new JButton();
				laborwerteButtons.add(btRechnenAlle,BorderLayout.EAST);
		laborwertePanel.add(laborwerteButtons,BorderLayout.NORTH);
		aDaten.add(laborwertePanel, c);
		
		spezifikationTextPanel = new JPanel(new BorderLayout());
		c.gridx = 4;
		c.gridy = 25;
		c.gridheight = 1;
		c.gridwidth = 4;
		spezifikationTextPanel.setBorder(BorderFactory.createEtchedBorder());
			spezifikationLabelPanel = new JPanel (new BorderLayout());
				lblSpezifikationText = new JLabel();
					lblSpezifikationText.setHorizontalAlignment(SwingConstants.CENTER);
					spezifikationLabelPanel.add(lblSpezifikationText,BorderLayout.CENTER);
				btZutatenVerzeichnis = new JButton();
					spezifikationLabelPanel.add(btZutatenVerzeichnis,BorderLayout.EAST);
				spezifikationTextPanel.add(spezifikationLabelPanel,BorderLayout.NORTH);
			scrSpezifikationText = new JScrollPane();
				txtSpezifikationText = new JTextPane();
					scrSpezifikationText.setViewportView(txtSpezifikationText);
			spezifikationTextPanel.add(scrSpezifikationText,BorderLayout.CENTER);
		aDaten.add(spezifikationTextPanel,c);
		
		daten.add(aDaten, BorderLayout.NORTH);

		blind = new JPanel(new BorderLayout());
		daten.add(blind, BorderLayout.CENTER);
		scrDaten.setViewportView(daten);
		mainCenter.add(scrDaten, BorderLayout.CENTER);
		mainCenter.setBorder(BorderFactory.createEtchedBorder());
		mainPanel.add(mainCenter, BorderLayout.CENTER);
		// unten erstellt,geandert,ok,cancel,hilfe
		mainSouth = new JPanel(new BorderLayout());
		erstelltGeaendert = new JPanel(new BorderLayout());
		lblErstellt = new JLabel();
		lblErstellt.setHorizontalAlignment(SwingConstants.CENTER);
		erstelltGeaendert.add(lblErstellt, BorderLayout.NORTH);
		lblGeaendert = new JLabel();
		lblGeaendert.setHorizontalAlignment(SwingConstants.CENTER);
		erstelltGeaendert.add(lblGeaendert, BorderLayout.CENTER);
		mainSouth.add(erstelltGeaendert, BorderLayout.NORTH);
		okCancel = new JPanel(new GridLayout(1, 4));
		btOK = new JButton();
		btOK.setAction(getAction(ACTION_OK_CODE));
		okCancel.add(btOK);
		platzhalter = new JPanel();
		okCancel.add(platzhalter);
		btHilfe = new JButton();
		btHilfe.setAction(getAction(ACTION_HILFE_CODE));
		okCancel.add(btHilfe);
		btCancel = new JButton();
		btCancel.setAction(getAction(ACTION_ABBRECHEN_CODE));
		okCancel.add(btCancel);
		mainSouth.add(okCancel, BorderLayout.CENTER);
		okCancel.setBorder(BorderFactory.createEtchedBorder());
		mainPanel.add(mainSouth, BorderLayout.SOUTH);
		settblLaborwerteModel(tblWerte);
	}

	@Override
	public void setGUIComponents() {
		mnuDatei.setText(rz.getLocale().getString("menu.datei"));
		mnuAdressliste.setText(rz.getLocale().getString("menu.adressen"));
		mnuStichwortListe.setText(rz.getLocale().getString("menu.stichworte"));
		mnuExtras.setText(rz.getLocale().getString("menu.extras"));
		mnuFenster.setText(rz.getLocale().getString("menu.fenster"));
		mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));
		mnuDatei.add(getAction(ACTION_OK_CODE));
		mnuDatei.addSeparator();
		mnuDatei.add(getAction(ACTION_ABBRECHEN_CODE));
		mnuAdressliste.add(getAction(ACTION_ADRESSLISTE_BEARBEITEN_CODE));
		mnuAdressliste.addSeparator();
		mnuAdressliste.add(getAction(ACTION_ADRESSLISTE_LOESCHEN_CODE));
		mnuDeklarationen.add(getAction(ACTION_DEKLARATIONEN_BEARBEITEN_CODE));
		mnuDeklarationen.addSeparator();
		mnuDeklarationen.add(getAction(ACTION_DEKLARATIONEN_LOESCHEN_CODE));
		mnuStichwortListe.add(getAction(ACTION_STICHWORTLISTE_BEARBEITEN_CODE));
		mnuStichwortListe.addSeparator();
		mnuStichwortListe.add(getAction(ACTION_STICHWORTLISTE_LOESCHEN_CODE));
		mnuFenster.add(getAction(ACTION_ACIDRECHNER_CODE));
		mnuExtras.add(getAction(ACTION_HIDE_CODE));
		mnuHilfe.add(getAction(ACTION_HILFE_CODE));

		tb1.add(getAction(ACTION_OK_CODE));
		tb1.add(getAction(ACTION_ABBRECHEN_CODE));
		tb1.addSeparator();
		tb1.add(getAction(ACTION_HIDE_CODE));
		tb1.addSeparator();
		tb1.add(getAction(ACTION_ACIDRECHNER_CODE));
		tb1.addSeparator();
		tb1.add(getAction(ACTION_ADRESSLISTE_BEARBEITEN_CODE));
		tb1.add(getAction(ACTION_ADRESSLISTE_LOESCHEN_CODE));
		tb1.addSeparator();
		tb1.add(getAction(ACTION_DEKLARATIONEN_BEARBEITEN_CODE));
		tb1.add(getAction(ACTION_DEKLARATIONEN_LOESCHEN_CODE));
		tb1.addSeparator();
		tb1.add(getAction(ACTION_STICHWORTLISTE_BEARBEITEN_CODE));
		tb1.add(getAction(ACTION_STICHWORTLISTE_LOESCHEN_CODE));
		tb1.addSeparator();
		tb1.add(getAction(ACTION_HILFE_CODE));

		
		chkKonform.setText(rz.getLocale().getString("rezeptur.label_konform"));
		lblKonformDatum.setText(rz.getLocale().getString("rezeptur.label_konform_datum"));
		lblKonformComment.setText(rz.getLocale().getString("rezeptur.label_konform_comment"));

		lblName.setText(rz.getLocale().getString("rezeptur.label_name"));
		lblVerweis.setText(rz.getLocale().getString("rezeptur.label_verweis"));
		lblAdressenTitel.setText(rz.getLocale().getString("rezeptur.label_adressliste_titel"));
		lblStichworteTitel.setText(rz.getLocale().getString("rezeptur.label_stichwortliste_titel"));
		lblDeklarationenTitel.setText(rz.getLocale().getString("rezeptur.label_deklarationen_titel"));
		lblBasis.setText(rz.getLocale().getString("rezeptur.label_basis"));
		lblStaerke.setText(rz.getLocale().getString("rezeptur.label_staerke"));
		textTitel.setText(rz.getLocale().getString("rezeptur.label_text_titel"));
		lblLitergewicht.setText(rz.getLocale().getString("rezeptur.label_litergewicht"));
		lblExtrakt.setText(rz.getLocale().getString("rezeptur.label_extrakt"));
		lblExtrakt2.setText(rz.getLocale().getString("rezeptur.label_extrakt2"));
		lblLagertitel.setText(rz.getLocale().getString("rezeptur.label_lagertitel"));
		lblBestand.setText(rz.getLocale().getString("rezeptur.label_bestand"));
		lblMeldebestand.setText(rz.getLocale().getString("rezeptur.label_meldebestand"));
		lblVorschlagsbestand.setText(rz.getLocale().getString("rezeptur.label_vorschlagsbestand"));
		lblSchwundsatz.setText(rz.getLocale().getString("rezeptur.label_schwundsatz"));
		lblLager.setText(rz.getLocale().getString("rezeptur.label_lager"));
		lblPreistitel.setText(rz.getLocale().getString("rezeptur.label_preis"));
		lblKostet.setText(rz.getLocale().getString("rezeptur.label_kostet"));
		lblBrennwert.setText(rz.getLocale().getString("rezeptur.label_brennwert"));
		lblBrennwertAlkohol.setText(rz.getLocale().getString("rezeptur.label_brennwert_alkohol"));
		lblArtikelnummer.setText(rz.getLocale().getString("rezeptur.label_artikelnummer"));
		lblLosnummer.setText(rz.getLocale().getString("rezeptur.label_losnummer"));
		lblAcid.setText(rz.getLocale().getString("rezeptur.label_acid"));
		lblTank.setText(rz.getLocale().getString("rezeptur.label_tank"));
		lblSpezifikation.setText(rz.getLocale().getString("rezeptur.label_spezifikation"));
		lblRProbe.setText(rz.getLocale().getString("rezeptur.label_rprobe"));		
		lblProbenAnzahl.setText(rz.getLocale().getString("rezeptur.label_rprobe_anzahl"));		
		lblBewertung.setText(rz.getLocale().getString("rezeptur.label_bewertung"));
		lblEan.setText(rz.getLocale().getString("rezeptur.label_ean"));
		chkAutoAnfrage.setText(rz.getLocale().getString("rezeptur.label_autoanfrage"));
		
		lblGesamtsumme.setText(rz.getLocale().getString("rezeptur.label_gesamtsumme"));
		lblEinzelsumme.setText(rz.getLocale().getString("rezeptur.label_einzelsumme"));

		btGesamtsummeLiter.setText(rz.getLocale().getString("rezeptur.label_summe_zliter"));
		btGesamtsummeKg.setText(rz.getLocale().getString("rezeptur.label_summe_zkg"));
		btGesamtsummeLA.setText(rz.getLocale().getString("rezeptur.label_summe_zla"));
		btGesamtsummeProzent.setText(rz.getLocale().getString("rezeptur.label_summe_zprozent"));

		btEinzelsummeStart.setText(rz.getLocale().getString("rezeptur.label_summe_estart"));
		btEinzelsummeLiter.setText(rz.getLocale().getString("rezeptur.label_summe_eliter"));
		btEinzelsummeKg.setText(rz.getLocale().getString("rezeptur.label_summe_ekg"));
		btEinzelsummeLA.setText(rz.getLocale().getString("rezeptur.label_summe_ela"));
		btEinzelsummeProzent.setText(rz.getLocale().getString("rezeptur.label_summe_eprozent"));

		chkExtraktfrei.setText(rz.getLocale().getString("rezeptur.label_extraktfrei"));

		lblTemperatur.setText(rz.getLocale().getString("rezeptur.label_temperatur"));

		lblTemperaturBis.setText(rz.getLocale().getString("rezeptur.label_temperatur_bis"));
		lblTemperaturDurchschnitt.setText(rz.getLocale().getString("rezeptur.label_temperatur_durchschnitt"));

		lblSpezifikationText.setText(rz.getLocale().getString("rezeptur.label_spezifikation_text"));
		lblSteuerArtikel.setText(rz.getLocale().getString("rezeptur.label_steuer_arikel"));
		lblSorte.setText(rz.getLocale().getString("rezeptur.label_sorte"));
		lblSteuerLager.setText(rz.getLocale().getString("rezeptur.label_steuer_lager"));
		
		btVerweis.setAction(getAction(ACTION_VERWEIS_CODE));
		btVerweisEntfernen.setAction(getAction(ACTION_VERWEIS_ENTFERNEN_CODE));
		btAdressenBearbeiten.setAction(getAction(ACTION_ADRESSLISTE_BEARBEITEN_CODE));
		btAdressenLoeschen.setAction(getAction(ACTION_ADRESSLISTE_LOESCHEN_CODE));
		btStichworteBearbeiten.setAction(getAction(ACTION_STICHWORTLISTE_BEARBEITEN_CODE));
		btStichworteLoeschen.setAction(getAction(ACTION_STICHWORTLISTE_LOESCHEN_CODE));
		btDeklarationenBearbeiten.setAction(getAction(ACTION_DEKLARATIONEN_BEARBEITEN_CODE));
		btDeklarationenLoeschen.setAction(getAction(ACTION_DEKLARATIONEN_LOESCHEN_CODE));
		btAcid.setAction(getAction(ACTION_ACIDRECHNER_CODE));
		btMusternummer.setAction(getAction(ACTION_MUSTERNUMMER_CODE));
		btZutatenVerzeichnis.setAction(getAction(ACTION_ZUTATENVERZEICHNIS_CODE));

		btVBackup.setAction(getAction(ACTION_BACKUP_VERSION_CODE));
		getAction(ACTION_BACKUP_VERSION_CODE).setEnabled(false);
		btVDelete.setAction(getAction(ACTION_DELETE_VERSION_CODE));
		getAction(ACTION_DELETE_VERSION_CODE).setEnabled(false);

		btRechnenFenster.setAction(getAction(ACTION_LABORWERTE_CODE));
		btRechnenAlle.setAction(getAction(ACTION_LABORWERTE_ALLE_CODE));
		btTankPlan.setAction(getAction(ACTION_TANKLISTE_PLAN_CODE));
		
		setResizable(true);
		rz.getFontFactory().setFrameFonts(this);
		pack();
		rz.getFensterFactory().setLocation(this, FensterFactory.POSITION_SIZE);
	}

	public void getMessage(MessageItem msg) {
		switch (msg.getMsgCode()) {
			case MessageItem.MSG_ACTIONPERFORMED :
				switch (msg.getCode()) {
					case ACTION_ABBRECHEN_CODE :
						cancelAction();
						break;
					case ACTION_ADRESSLISTE_BEARBEITEN_CODE :
						adressListeBearbeitenAction();
						break;
					case ACTION_ADRESSLISTE_LOESCHEN_CODE :
						adressenLoeschenAction();
						break;
					case ACTION_OK_CODE :
						okAction();
						break;
					case ACTION_STICHWORTLISTE_BEARBEITEN_CODE :
						stichwortListeBearbeitenAction();
						break;
					case ACTION_STICHWORTLISTE_LOESCHEN_CODE :
						stichwortListeLoeschenAction();
						break;
					case ACTION_VERWEIS_CODE :
						verweisAction();
						break;
					case ACTION_VERWEIS_ENTFERNEN_CODE :
						verweisEntfernenAction();
						break;
					case ACTION_HILFE_CODE :
						hilfeAction();
						break;
					case ACTION_HIDE_CODE :
						hideAction();
						break;
					case ACTION_ACIDRECHNER_CODE :
						acidRechnerAction();
						break;
					case ACTION_DEKLARATIONEN_BEARBEITEN_CODE :
						deklarationenBearbeitenAction();
						break;
					case ACTION_DEKLARATIONEN_LOESCHEN_CODE :
						deklarationenLoeschenAction();
						break;
					case ACTION_MUSTERNUMMER_CODE :
						musterNummerAction();
						break;
					case ACTION_BACKUP_VERSION_CODE :
						backupVersionAction();
						break;
					case ACTION_DELETE_VERSION_CODE :
						deleteVersionAction();
					case ACTION_LABORWERTE_CODE :
						rechnenAction();
						break;
					case ACTION_LABORWERTE_ALLE_CODE :
						rechnenAlleAction();
						break;	
					case ACTION_ZUTATENVERZEICHNIS_CODE :
						zutatenVerzeichnisAction();
						break;			
			          case ACTION_TANKLISTE_PLAN_CODE:tanklistePlanAction();break;
					default :
						break;
				}
				break;
			case MessageItem.MSG_TANKLISTE_REPLY :
				tankItem ti =  (tankItem) msg.getData();
				if(ti != null) {
					if(txtTank.getText().trim().equals("")) {
						txtTank.setText(ti.getNummer());
					}else {
						txtTank.setText(txtTank.getText().trim()+","+ti.getNummer());
					}
						
				}
				break;
			case MessageItem.MSG_DEKLARATION_AUSWAHL_REPLY :
				if (msg.getData() != null) {
					rezeptur.setDeklarationenListe(((DeklarationsListe) msg
							.getData()).copyList());
					lstDeklarationen.setListData(((DeklarationsListe) msg
							.getData()).toArray());
				}
				break;
			case MessageItem.MSG_ACIDRECHNER_REPLY :
				if (msg.getData() != null) {
					txtAcid.setValue(((Double) msg.getData()).doubleValue());
				}
				break;
			case MessageItem.MSG_EINHEITEN_DIALOG_REPLY :
				einheitenDialogReply((EinheitsItem) msg.getData());
				break;
			case MessageItem.MSG_ZUTATEN_DIALOG_REPLY :
				zutatenDialogReply((ZutatenSuchItem) msg.getData());
				break;
			case MessageItem.MSG_EDIT_REZEPTUR :
				origin = (JRzFrame) msg.getOrigin();
				callerObject = (ErgebnisItem) msg.getData();
				editRezeptur(false);
				break;
				
			case MessageItem.MSG_REFRESH_LABORWERTE :
				refreshLaborwerte();
				break;
				
			case MessageItem.MSG_EDIT_REZEPTUR_GRUPPE :
				origin = (JRzFrame) msg.getOrigin();
				callerObject = (ErgebnisItem) msg.getData();
				editRezeptur(true);
				break;
			case MessageItem.MSG_STICHWORTLISTE_REPLY :
				rezeptur.setStichwortListe(((StichwortListe) msg.getData())
						.copyList());
				lstStichworte.setListData(((StichwortListe) msg.getData())
						.toArray());
				break;
			case MessageItem.MSG_ADRESSLISTE_REPLY :
				rezeptur.setAdressListe(((StichwortListe) msg.getData())
						.copyList());
				lstAdressen.setListData(((StichwortListe) msg.getData())
						.toArray());
				break;
			case MessageItem.ZUTATENVERZEICHNIS_REZEPTUR_REPLY:
				try {
					txtSpezifikationText.setText((String)msg.getData());
				}catch(Exception e) {}
				break;
			default :
				rz.getLogFactory().logMessage(2, "rezepturfenster:",
						"auswahlAction:" + msg.getMsgCode());
				break;
		}
	}

	  private void spinnerChanged(JSpinner origin,javax.swing.event.ChangeEvent evt) {
		   if(((Integer)origin.getValue()).intValue() < 1){
			  origin.setValue(Integer.valueOf(1));
		  }
	  }
	
	private boolean isLaborwerteSaveable() {
		boolean ret = true;
		if(rezeptur == null) ret = false;
		if(rezeptur != null && rezeptur.getID() == 0) ret = false;
		boolean mStaerke = false;
		boolean mBasis = false;
		boolean mText = false;
		if( (rz.isZero(Math.abs(txtStaerke.getValue() - originalStaerke)))) {
			mStaerke = false;
		} else {
			mStaerke = true;
		}
		if(rz.isZero(Math.abs(txtBasis.getValue() - originalBasismenge))) {
			mBasis = false;
		} else {
			mBasis = true;
		}
		if(txtText.getText().equals(originalComment)) {
			mText = false;
		} else {
			mText = true;
		}
		if(mStaerke || mBasis || mText) {
			modified = true;
		} else {
			modified = false;
		}
		if(modified) ret = false;
		return ret;
	}
	
	private void setLaborwerteSaveable(boolean ok) {
		if(ok) {
			getAction(ACTION_LABORWERTE_CODE).setEnabled(true);
			getAction(ACTION_LABORWERTE_ALLE_CODE).setEnabled(true);
		}else {
			getAction(ACTION_LABORWERTE_CODE).setEnabled(false);
			getAction(ACTION_LABORWERTE_ALLE_CODE).setEnabled(false);
		}
		((AbstractTableModel)tblWerte.getModel()).fireTableDataChanged();
	}
	
	public void laborwertBerechnung(LaborwertValueItem lvi) {
		if(lvi != null && !lvi.isFix()) {
        	final RechenItem ri = new RechenItem(rz,rezeptur.getID(),null);
	    	ri.setWaehrung(rz.getDatabase().getCurrency().dbGetCurrency(ri.getRezeptur().getWaehrung(),true));
	    	ri.rechnen(100,RechenItem.RECHNEN_LITER);
	    	LaborwertItem lw = rz.getDatabase().getLaborwerte().getWert(lvi.getLaborwert());
			LaborwertValueListe vliste=rz.getDatabase().getLaborwerte().getValueListe(lvi.getLbwBezeichnung(),lw.getId(),ri,lvi.getEinheit2(),lvi.getLbwBezeichnung());
			if(vliste != null) {
				vliste.rechnen();
				double value = 0;
				switch(vliste.getEinheit()) {
		           	case RzPro.EINHEIT_KG:value =vliste.getValue_kg()/ri.getGesamtKg();break;
		           	case RzPro.EINHEIT_LITER:value =vliste.getValue_liter()/ri.getGesamtLiter();break;
		           	case RzPro.EINHEIT_LA:value =vliste.getValue_la()/ri.getGesamtLA();break;
		        
				}
				Double alt = lvi.getValue();
				Double neu = value;
				if(!rz.isZero(alt) || !rz.isZero(neu)) {
				    BigDecimal bAlt = new BigDecimal(Double.toString(alt));
				    BigDecimal bNeu = new BigDecimal(Double.toString(neu));
				    bAlt = bAlt.setScale(rz.getOptionFactory().getOption("laborwerte.decimal_digits",OptionFactory.LABORWERTE_DECIMAL_DIGITS), RoundingMode.HALF_UP);
				    bNeu = bNeu.setScale(rz.getOptionFactory().getOption("laborwerte.decimal_digits",OptionFactory.LABORWERTE_DECIMAL_DIGITS), RoundingMode.HALF_UP);
					if (bAlt.compareTo(bNeu)!= 0) {
						ChangesListe ch=new ChangesListe(rz,lvi.getRezeptur());
						ch.add(rz.getLocale().getString("changes.laborwert"),lvi.getLbwBezeichnung() + ":  " + bAlt.toString() + " " + lvi.getStrEinheit1() + "/"+lvi.getStrEinheit2() , bNeu.toString()  + " " + lvi.getStrEinheit1() + "/"+lvi.getStrEinheit2(),true);
						ch.commit();
					}
				}
				lvi.setValue(value);
				lvi.setBerechnet(true);
				rz.getDatabase().getLaborwerte().saveValue(lvi);
	   			((AbstractTableModel)tblWerte.getModel()).fireTableDataChanged();
			}
		}
	}
	
	public void werteClickedAction() {
		if(liste != null && !liste.isEmpty() && tblWerte.getSelectedRow() != -1 && tblWerte.getSelectedColumn() == C_RECHNEN){
			LaborwertValueItem lvi = liste.get(tblWerte.getSelectedRow());
			if(lvi != null) {
				laborwertBerechnung(lvi);
			}
		}
	}
	
	
	private void zutatenVerzeichnisAction() {
		if(rezeptur != null && rezeptur.getID() != 0) {
			final ZutatenverzeichnisListe zl=rz.getDatabase().getZutatenverzeichnis().getListe();
	    	if(zl != null) {
	        	final RechenItem ri = new RechenItem(rz,rezeptur.getID(),null);
	        	ri.setWaehrung(rz.getDatabase().getCurrency().dbGetCurrency(ri.getRezeptur().getWaehrung(),true));
	        	ri.rechnen(100,RechenItem.RECHNEN_LITER);
	    	    zl.setRi(ri);
	    		rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_ZUTATENVERZEICHNIS,true,new MessageItem(MessageItem.MSG_SHOW_ZUTATENVERZEICHNIS_REZEPTUR,0,zl,this));
	    	}
		}
	}
	
	private void tanklistePlanAction() {
		ArrayList<tankItem> ti = rz.getDatabase().getTank().getTankListeFromTankPattern(txtTank.getText().trim());
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_TANKAUSWAHL,false,new MessageItem(MessageItem.MSG_SHOW_TANKAUSWAHL,0,(Object)(new tankAuswahlItem(ti,this,null,null,null)),this));
	}
	
	private void rechnenAction() {
    	final RechenItem ri = new RechenItem(rz,rezeptur.getID(),null);
    	ri.setWaehrung(rz.getDatabase().getCurrency().dbGetCurrency(ri.getRezeptur().getWaehrung(),true));
    	ri.rechnen(100,RechenItem.RECHNEN_LITER);
		if(ri != null) {
		       rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_LABORWERT_BERECHNEN,true,new MessageItem(MessageItem.MSG_SHOW_LABORWERTBERECHNUNG,ri.getRezeptur().getID(),ri,this));
		}
	}
	
	private void rechnenAlleAction() {
		if(liste != null && !liste.isEmpty()) {
			rz.setWaitCursor(this);
			for(LaborwertValueItem lvi:liste) {
				 laborwertBerechnung(lvi);
			}
			rz.setFreeCursor(this);
		}
	}
	
	private void backupVersionAction() {
		
        final DialogItem di  = new DialogItem(
                DialogControl.EINGABE_DIALOG,
                "",0.0,
                rz.getLocale().getString("rezeptur.question_version_titel"),
                rz.getLocale().getString("rezeptur.question_version_label"),
                " ",
                "frage.png",
                rz.getLocale().getString("string_ok"),
                rz.getLocale().getString("string_abbrechen"),
                null
        );
        rz.getDialogFactory().getDialog(di,true,false);

        final String bezeichnung = di.getContent();
	    if(bezeichnung != null && !bezeichnung.trim().equals("")) {
	    	cmbVersionen.addItem(rz.getDatabase().getRezeptur().saveVersion(rezeptur.getID(), txtText.getText().trim(),bezeichnung));
	    }
	}
	
	private void deleteVersionAction() {
		VersionsItem vi = (VersionsItem)cmbVersionen.getModel().getSelectedItem();
		if(vi != null) {
			if (vi.getId() != -1) {
				final DialogItem di = new DialogItem(DialogControl.FRAGE_DIALOG,
						"", 0.0, rz.getLocale().getString(
								"rezeptur.question_delete_version"), rz.getLocale()
								.getString("rezeptur.question_einheit"), rz
								.getLocale().getString("rezeptur.question_delete_version_message")
									.replaceAll("%s", vi.toString()),
								"frage.png", rz.getLocale().getString("string_ja"), rz
								.getLocale().getString("string_nein"), this);
				rz.getDialogFactory().getDialog(di);
				if (di.getReplyCode() == DialogControl.DIALOG_OK) {
					rz.getDatabase().getRezeptur().deleteVersion(vi.getId());
					cmbVersionen.removeItem((Object)vi);
					cmbVersionen.setSelectedIndex(0);
				}
			}
		}
	}
	
	private void versionenCMBAction() {
		VersionsItem vi = (VersionsItem)cmbVersionen.getSelectedItem();
		if(vi.getId()==-1) {
			getAction(ACTION_BACKUP_VERSION_CODE).setEnabled(true);
			getAction(ACTION_DELETE_VERSION_CODE).setEnabled(false);
		}else {
			getAction(ACTION_BACKUP_VERSION_CODE).setEnabled(false);
			getAction(ACTION_DELETE_VERSION_CODE).setEnabled(true);
		}
		if(rezeptur.getID() <1) {
			getAction(ACTION_BACKUP_VERSION_CODE).setEnabled(false);
		}
		txtText.setText(vi.getVersion());
		setLaborwerteSaveable(isLaborwerteSaveable());
	}
	
	private void musterNummerAction() {
		String t=rz.getDatabase().getRezeptur().getMusterNummer(txtLosnummer.getText().trim(),txtArtikelnummer.getText().trim());
		if(!t.equals("")) {
			txtName.setText(txtName.getText().replaceAll(t,"").trim() + " " + t);
		}
	}
	
	private void editRezeptur(boolean gruppe) {
		rezeptur = rz.getDatabase().getRezeptur().dbGetRezeptur(callerObject.getID(), false);
		if (rezeptur != null) {
			rezepturVerweis = rz.getDatabase().getRezeptur().dbGetRezeptur(rezeptur.getVerweis(), true);
			if (gruppe) {
				if (!callerObject.getAdressen().equals("")) {
					rezeptur.setAdressListe(rz.getDatabase().getSTW().dbGetAdressenListe(callerObject.getAdressen()));
				}
				if (!callerObject.getStichworte().equals("")) {
					rezeptur.setStichwortListe(rz.getDatabase().getSTW().dbGetStichwortListe(callerObject.getStichworte()));
				}
			}
			if (rezeptur.getID() == 0) {
				setTitle(rz.getVersionString() + " " + rz.getLocale().getString("rezeptur.titel") + " " + rz.getLocale().getString("string_neu_eingeben"));
			} else {
				setTitle(rz.getVersionString() + " " + rz.getLocale().getString("rezeptur.titel") + " " + rz.getLocale().getString("string_bearbeiten"));
			}

			if (rezeptur != null) {
				fromItem(rezeptur);
			} else {
				final DialogItem di = new DialogItem(DialogControl.HINWEIS_DIALOG, "", 0.0, rz.getLocale().getString("rezeptur.key_not_found"), rz.getLocale().getString("rezeptur.key_not_found"), rz.getLocale().getString("rezeptur.fehler_not_found"), "frage.png", rz.getLocale().getString("string_ok"), "", this);
				rz.getDialogFactory().getDialog(di);
			}
		}
	}

	private void txtStaerkeKeyReleased(java.awt.event.KeyEvent evt) {
		setExtraktfreiStatus();	
	}

	private void txtTextKeyReleased(java.awt.event.KeyEvent evt) {
		/**
		 * Pattern matching
		 */
		if (evt.getKeyCode() == KeyEvent.VK_TAB) {
			this.transferFocus();
		}
		if ((evt.getKeyCode() == KeyEvent.VK_TAB)
				&& (evt.getModifiers() == KeyEvent.CTRL_DOWN_MASK)) {
			this.transferFocusBackward();
		}
		if (evt.getKeyChar() == ' ') {
			processKeyStroke();
		}
		setLaborwerteSaveable(isLaborwerteSaveable());
	}

	private void numpad() {
		for (int i = 0; i < txtText.getText().length(); i++) {
			final char c = txtText.getText().charAt(i);
			if (c > 255) {
				txtText.setText(txtText.getText().replace(c, comma));
			}
		}
	}

	private void chkExtraktfreiActionPerformed(java.awt.event.ActionEvent evt) {
		setExtraktfreiStatus();
	}

	public void closeWindow() {
		if (zd != null) {
			zd.dispose();
			zd = null;
		}
		if (ed != null) {
			ed.dispose();
			ed = null;
		}
		rz.getFensterFactory().getFensterListe().disposeFrame(this);
	}

	/**
	 * wird nach jeder Eingabe eines Leerzeichens im Textfeld aufgerufen. prüft
	 * ob eine gültige zeile vorliegt um den Dialog für Einheiten oder Zutaten
	 * zu öffnen
	 */
	private void processKeyStroke() {
		final String zeile = getLine(txtText);
		final String extend = getExtend(txtText);
		final String tokens[] = zeile.split(" ");
		/*
		 * Zeile in tokens aufspalten 1 token bedeutet dass wir nur prüfen
		 * müssen, ob es sich um eine gültige zahl handelt, 2 tokens bedeuten
		 * dass wir auf Zahl UND Einheit prüfen müssen
		 */

		switch (tokens.length) {
			case 1 : // auf Zahl prüfen
				if (rz.getLocale().isNumber(tokens[0].trim())) {
					showEinheitenDialog();
				}
				break;
			case 2 : // auf Zahl und Einheit prüfen
				if (rz.getLocale().isNumber(tokens[0].trim())) {
					if (rz.getDatabase().getEinheiten().isEinheit(
							tokens[1].trim())) {
						showZutatenDialog(extend);
					}
				}
				break;
		}
	}
	/**
	 * zeigt den dialog mit der verfügbaren Einheiten an
	 * 
	 * 
	 */
	private void showEinheitenDialog() {
		/*
		 * am Anfang steht eine Zahl.. jetzt bitte den Einheitendialog zeigen...
		 */
		int x, y;
		x = (int) (txtText.getLocationOnScreen().getX() + txtText.getCaret()
				.getMagicCaretPosition().getX());
		y = (int) (txtText.getLocationOnScreen().getY() + txtText.getCaret()
				.getMagicCaretPosition().getY());
		if (ed != null) {
			ed.dispose();
			ed = null;
		}
		ed = new EinheitenDialog(this, true, rz, x, y);
		ed.setVisible(true);
	}

	private void einheitenDialogReply(EinheitsItem eh) {
		if (eh != null) {
			try {
				txtText.getDocument().insertString(txtText.getCaretPosition(),
						eh.getName(), null);
			} catch (final BadLocationException e) {
			}
		}
		if (ed != null) {
			ed.dispose();
			ed = null;
		}
	}
	/**
	 * zeigt den Dialog mit einzufügenden Zutaten an
	 * 
	 * 
	 */
	private void showZutatenDialog(String aZutat) {
		int x, y;
		x = (int) (txtText.getLocationOnScreen().getX() + txtText.getCaret().getMagicCaretPosition().getX());
		y = (int) (txtText.getLocationOnScreen().getY() + txtText.getCaret().getMagicCaretPosition().getY());
		if (zd != null) {
			zd.dispose();
			zd = null;
		}
		zd_dialog_typ = GET_REZEPTUR;
		zd = new ZutatenDialog(this, rz, x, y, aZutat,ZutatenDialog.MODE_REZEPTUREN);
		zd.setVisible(true);
	}

	private void zutatenDialogReply(ZutatenSuchItem zi) {
		if (zi != null) {
			try {
				switch (zd_dialog_typ) {
					case GET_REZEPTUR :
						try {
							txtText.select(txtText.getCaretPosition(),getExtendPosition(txtText));
							if (zi.getExclusive()) {
								txtText.replaceSelection(zi.getName());
							} else {
								txtText.replaceSelection(zi.getName() + " [[" + zi.getID() + "]]");
							}
						}catch(Exception e) {
							rz.getLogFactory().logMessage(LogFactory.LOG_WARN,"rezeptur.zutatenDialogReply.getRezeptur:",e.getLocalizedMessage());

						}
						break;
					case GET_VERWEIS :
						if (zi.getExclusive()) {
							rezeptur.setVerweis(zi.getID());
							lblVerweisRezeptur.setText(zi.getName());
						} else {
							rezeptur.setVerweis(zi.getID());
							lblVerweisRezeptur.setText(zi.getName() + " [["+ zi.getID() + "]]");
						}
						rezepturVerweis = rz.getDatabase().getRezeptur().dbGetRezeptur(rezeptur.getVerweis(), true);
						fromItem(rezeptur);
						break;
					default:		
						rz.getLogFactory().logMessage(LogFactory.LOG_WARN,"rezeptur.zutatenDialogReplyDefaultClause:",String.valueOf(zd_dialog_typ));
						zd_dialog_typ = GET_REZEPTUR;
				}
			} catch (final Exception e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_WARN,"rezeptur.zutatenDialogReply.CatchAll:",e.getLocalizedMessage());
			}
		}
		if (zd != null) {
			zd.dispose();
			zd = null;
		}
	}

	/**
	 * eine Variable in den Text einfügen
	 */
	private void summenInsert(String txt) {
		try {
			if (txtText != null) {
				txtText.getDocument().insertString(txtText.getCaretPosition(),
						txt + " ", null);
				txtText.requestFocus();
			}
		} catch (final BadLocationException ex) {

		}
	}

	/**
	 * zeigt einen Dialog zur Auswahl eines VerweisZiels an
	 * 
	 * 
	 */
	private void showVerweisDialog(String aZutat) {
		int x, y;
		x = (int) (btVerweis.getLocationOnScreen().getX());
		y = (int) (btVerweis.getLocationOnScreen().getY());
		if (rezeptur.getVerweis() == 0) {
			aZutat = "";
		}
		if (zd != null) {
			zd.dispose();
			zd = null;
		}
		zd_dialog_typ = GET_VERWEIS;
		final ZutatenDialog zd = new ZutatenDialog(this, rz, x, y, aZutat,ZutatenDialog.MODE_REZEPTUREN);
		zd.setVisible(true);
	}

	private void verweisEntfernenAction() {
		if (rezeptur.getVerweis() != 0) {
			rezeptur.setVerweis(0);
			fromItem(rezeptur);
		}
	}

	/**
	 * setStatus stellt den Status der Elemente (enabled/disabled) in
	 * Abhängigkeit von der Rezeptur dar...
	 */
	private void setExtraktfreiStatus() {
		if (chkExtraktfrei.isSelected()) {
			txtExtrakt.setEditable(false);
			txtExtrakt.setValue(0);
			txtExtrakt.setEnabled(false);
			txtLitergewicht.setEnabled(false);
			txtLitergewicht.setEditable(false);
			try {
				final double lg = NumberFormat.getNumberInstance().parse(
						txtStaerke.getText()).doubleValue();
				txtLitergewicht.setValue(rz.getTafelFactory().Litergewicht(lg));
			} catch (final ParseException ne) {
			}
		} else {
			txtExtrakt.setEnabled(true);
			txtExtrakt.setEditable(true);
			txtLitergewicht.setEnabled(true);
			txtLitergewicht.setEditable(true);
		}
	}
	/**
	 * setPanelColors setzt die Farben nach Verweis oder original
	 * 
	 * @param aColor
	 *            true=verweis false=original
	 */
	private void setPanelColors(boolean aColor) {
		Color c;
		if (aColor) {
			c = rz.getOptionFactory().getColor(
					OptionFactory.COLOR_VERWEIS_VERWEIS);
			txtText.setBackground(rz.getOptionFactory().getColor(
					OptionFactory.COLOR_VERWEIS_TEXT));
		} else {
			c = SystemColor.getColor("awt.window");
			txtText.setBackground(Color.WHITE);
		}
		setContainerColor(mainCenter, c);
		setContainerColor(textMenge, c);
		setContainerColor(this.erstelltGeaendert, c);

	}

	private void setComponentColor(Component c1, Color c) {
		if (c1 instanceof JLabel) {
			((JLabel) c1).setOpaque(true);
		}
		if (c1 instanceof JPanel) {
			((JPanel) c1).setOpaque(true);
		}
		if (c1 instanceof JSelectedTextField) {
			((JSelectedTextField) c1).setOpaque(true);
		}
		if (c1 instanceof JNumberField) {
			((JNumberField) c1).setOpaque(true);
		}
		if (c1 instanceof JComboBox) {
			((JComboBox) c1).setOpaque(true);
		}
		if (c1 instanceof JCheckBox) {
			((JCheckBox) c1).setOpaque(true);
		}
		if (c1 instanceof JTextPane) {
			((JTextPane) c1).setOpaque(true);
		}
		c1.setBackground(c);
	}
	private void setContainerColor(Container cc, Color c) {
		for (int i = 0; i < cc.getComponentCount(); i++) {
			if (cc.getComponent(i) instanceof JPanel) {
				final Container c1 = (Container) cc.getComponent(i);
				for (int j = 0; j < c1.getComponentCount(); j++) {
					setComponentColor(c1.getComponent(j), c);
				}
			} else {
				setComponentColor(cc.getComponent(i), c);
			}
		}
	}

	/**
	 * fromItem überträgt die Daten eines RezepturItems in das Fenster
	 * 
	 * @param rezeptur
	 */
	private void fromItem(RezepturItem rezeptur) {
		RezepturItem source;
		txtName.setText(rezeptur.getTitel());
		if (rezeptur.getVerweis() != 0) {
			// verweis
			lblVerweisRezeptur.setText(rezepturVerweis.getTitel());
			lblVerweisRezeptur.setBackground(Color.ORANGE);
			source = rezepturVerweis;
			setPanelColors(true);
		} else {
			// kein verweis
			lblVerweisRezeptur.setText(rz.getLocale().getString(
					"rezeptur.verweis"));
			lblVerweisRezeptur
					.setBackground(SystemColor.getColor("awt.window"));
			source = rezeptur;
			setPanelColors(false);
		}
		lstAdressen.setListData(rezeptur.getAdressListe().toArray());
		lstStichworte.setListData(rezeptur.getStichwortListe().toArray());
		lstDeklarationen
				.setListData(rezeptur.getDeklarationenListe().toArray());
		txtText.setText(source.getComment());
		txtStaerke.setValue(source.getStaerke());
		txtBasis.setValue(source.getBasismenge());
		txtExtrakt.setValue(source.getExtrakt());
		txtLitergewicht.setValue(source.getLitergewicht());
		chkExtraktfrei.setSelected(source.getExtraktfrei());
		rz.getDatabase().getEinheiten().setGrundeinheitenCmb(
				this.cmbBasiseinheit, source.getBasiseinheit());
		lblErstellt.setText(rz.getLocale().getString("string_erstellt")
				.replaceAll("%s", source.getErstelltToString()).replaceAll(
						"%v", source.getUser1()));
		lblGeaendert.setText(rz.getLocale().getString("string_geaendert")
				.replaceAll("%s", source.getGeaendertToString()).replaceAll(
						"%v", source.getUser2()));
		rz.getDatabase().getLager().setLagerCmb(cmbLager, source.getLager());
		
		
		
		txtArtikelnummer.setText(source.getArtikelnummer());
		txtLosnummer.setText(source.getLosnummer());
		txtBestand.setValue(source.getBestand());
		txtMeldebestand.setValue(source.getMeldebestand());
		txtVorschlagsbestand.setValue(source.getVorschlagsbestand());
		rz.getDatabase().getEinheiten().setGrundeinheitenCmb(
				this.cmbBestandseinheit, source.getBestandseinheit());
		if (rz.isZero(source.getBestand())) {
			cmbBestandseinheit.setEnabled(true);
		} else {
			cmbBestandseinheit.setEnabled(false);
		}
		txtPreismenge.setValue(source.getPreisMenge());
		txtPreis.setValue(source.getPreis().doubleValue());
		preis = source.getPreis();
		preisMenge = source.getPreisMenge();
		txtSchwundsatz.setValue(source.getSchwundsatz());
		txtBrennwert.setValue(source.getBrennwertAF());
		txtAcid.setValue(source.getAcid());
		txtTank.setText(source.getTank());
		txtSpezifikation.setText(source.getSpezifikation());
		chkRProbe.setSelected(source.isRProbe());
		spProbenAnzahl.setValue(Integer.valueOf(source.getProbenAnzahl()));
		if(chkRProbe.isSelected()) {
			spProbenAnzahl.setEnabled(true);
		} else {
			spProbenAnzahl.setEnabled(false);
		}
		chkBewertung.setSelected(source.isBewertung());
		tmpVon.setValue(source.getTempVon());
		tmpBis.setValue(source.getTempBis());
		lblTemperaturDurchschnitt.setText(rz.getLocale().getString("rezeptur.label_temperatur_durchschnitt").replaceAll("%s",String.valueOf(source.getTemperaturDurchschnitt())));
		
		rz.getDatabase().getCurrency().dbGetCurrencyListeCombo(cmbWaehrung,
				source.getWaehrung());
		rz.getDatabase().getEinheiten().setGrundeinheitenCmb(cmbPreiseinheit,
				source.getPreisEinheit());
		preisEinheit = source.getPreisEinheit();
		setExtraktfreiStatus();
		setBrennwertAlkoholValue();
		rz.getDatabase().getRezeptur().setVersionenCMB(source.getID(),txtText.getText(), source.getUser1(), source.getErstellt(),"", cmbVersionen);
		
		//konformitätserklärung
		if(rezeptur.isKonform()) {
			chkKonform.setSelected(true);
			txtKonformComment.setText(rezeptur.getKonformComment());
			picker.setStartDate(rezeptur.getKonformDatum());
			txtKonformComment.setEnabled(true);
			picker.setComponentsEnabled(picker, true);
		}else {
			chkKonform.setSelected(false);
			txtKonformComment.setEnabled(false);
			picker.setComponentsEnabled(picker, false);
		}
		txtSpezifikationText.setText(source.getSpezifikation_text());
		originalComment = source.getComment();
		originalStaerke = source.getStaerke();
		originalBasismenge = source.getBasismenge();
		txtEan.setText(source.getEan());
		txtSteuerArtikel.setText(source.getSteuerArtikel());
		for(int i=0;i< cmbSorte.getModel().getSize();i++) {
			SortenItem si = (SortenItem)cmbSorte.getModel().getElementAt(i);
			if(si.getId() == source.getSorte()){
				cmbSorte.setSelectedIndex(i);
				break;
			};
		}
		for(int i=0;i< cmbSteuerlager.getModel().getSize();i++) {
			SteuerLagerItem si = (SteuerLagerItem)cmbSteuerlager.getModel().getElementAt(i);
			if(si.getId() == source.getSteuerLager()){
				cmbSteuerlager.setSelectedIndex(i);
				break;
			};
		}
		if(source.isAuto_anfrage()) {
			chkAutoAnfrage.setSelected(true);
		} else {
			chkAutoAnfrage.setSelected(false);
		}
		refreshLaborwerte();
		setLaborwerteSaveable(isLaborwerteSaveable());
	}

	private void refreshLaborwerte() {
		liste=rz.getDatabase().getLaborwerte().getListeRezeptur(rezeptur.getID());
		((AbstractTableModel)tblWerte.getModel()).fireTableDataChanged();
	}
	
	/**
	 * toItem() überträgt die Texte aus dem GUI in das RezepturItem
	 * 
	 * @param ri
	 *            RezepturItem
	 */
	private void toItem(RezepturItem ri) {
		ri.setTitel(txtName.getText().trim());
		ri.setComment(this.txtText.getText().trim());
		ri.setStaerke(txtStaerke.getValue());
		ri.setBasismenge(txtBasis.getValue());
		ri.setExtrakt(txtExtrakt.getValue());
		ri.setLitergewicht(txtLitergewicht.getValue());
		ri.setExtraktfrei((chkExtraktfrei.getSelectedObjects() == null) ? false : true);
		ri.setBasiseinheit(((EinheitsItem) cmbBasiseinheit.getSelectedItem()).getID());
		ri.setAdressListe(rezeptur.getAdressListe().copyList());
		ri.setStichwortListe(rezeptur.getStichwortListe().copyList());
		ri.setDeklarationenListe(rezeptur.getDeklarationenListe().copyList());
		ri.setLager(((LagerItem) cmbLager.getSelectedItem()).getID());
		ri.setArtikelnummer(txtArtikelnummer.getText().trim());
		ri.setLosnummer(txtLosnummer.getText().trim());
		ri.setBestand(rz.getDatabase().getRezeptur().getBestandsSaldo(ri.getID()).getBestand());
		ri.setMeldebestand(txtMeldebestand.getValue());
		ri.setVorschlagsbestand(txtVorschlagsbestand.getValue());
		ri.setBestandseinheit(((EinheitsItem) cmbBestandseinheit.getSelectedItem()).getID());
		ri.setPreisMenge(txtPreismenge.getValue());
		ri.setPreis(txtPreis.getText());
		ri.setSchwundsatz(txtSchwundsatz.getValue());
		ri.setWaehrung(((CurrencyItem) cmbWaehrung.getSelectedItem()).getID());
		ri.setPreisEinheit(((EinheitsItem) cmbPreiseinheit.getSelectedItem()).getID());
		ri.setBrennwertAF(txtBrennwert.getValue());
		ri.setBrennwert(txtBrennwert.getValue() + rz.getTafelFactory().Brennwert(txtStaerke.getValue()));
		ri.setAcid(txtAcid.getValue());
		ri.setTank(txtTank.getText().trim());
		ri.setSpezifikation(txtSpezifikation.getText().trim());
		ri.setRProbe(chkRProbe.isSelected());
		ri.setBewertung(chkBewertung.isSelected());
		ri.setTempVon(tmpVon.getValue());
		ri.setTempBis(tmpBis.getValue());
		if (chkKonform.isSelected()) {
			ri.setKonform(true);
			ri.setKonformComment(txtKonformComment.getText().trim());
			ri.setKonformDatum(picker.getDate());
		} else {
			ri.setKonform(false);
			ri.setKonformComment("");
			ri.setKonformDatum(null);
		}
		ri.setSpezifikation_text(txtSpezifikationText.getText().trim());
		ri.setEan(txtEan.getText().trim());
		ri.setSteuerArtikel(txtSteuerArtikel.getText().trim());
		ri.setSorte( ((SortenItem)cmbSorte.getSelectedItem()).getId());
		ri.setSteuerLager( ((SteuerLagerItem)cmbSteuerlager.getSelectedItem()).getId());
		ri.setAuto_anfrage(chkAutoAnfrage.isSelected());
		ri.setProbenAnzahl (((Integer)this.spProbenAnzahl.getValue()).intValue()); 
	}
	

	
	public void openWindow() {
		if (rezeptur != null) {
			if (!isVisible()) {
				setVisible(true);
			}
			toFront();
			this.txtName.requestFocus();
		} else {
			rz.getFensterFactory().getFensterListe().disposeFrame(this);
		}
	}

	public void createActions() {
		actionList.put(String.valueOf(ACTION_HIDE_CODE), new AuswahlAction(rz, this, ACTION_HIDE_CODE, ACTION_HIDE_TEXT, KeyEvent.VK_F5, KeyEvent.SHIFT_DOWN_MASK));
		actionList.put(String.valueOf(ACTION_HILFE_CODE), new AuswahlAction(rz, this, ACTION_HILFE_CODE, ACTION_HILFE_TEXT, KeyEvent.VK_F1, 0));
		actionList.put(String.valueOf(ACTION_OK_CODE), new AuswahlAction(rz, this, ACTION_OK_CODE, ACTION_OK_TEXT, KeyEvent.VK_O, KeyEvent.CTRL_DOWN_MASK));
		actionList.put(String.valueOf(ACTION_ABBRECHEN_CODE), new AuswahlAction(rz, this, ACTION_ABBRECHEN_CODE, ACTION_ABBRECHEN_TEXT, KeyEvent.VK_ESCAPE, 0));
		actionList.put(String.valueOf(ACTION_ADRESSLISTE_BEARBEITEN_CODE), new AuswahlAction(rz, this, ACTION_ADRESSLISTE_BEARBEITEN_CODE, ACTION_ADRESSLISTE_BEARBEITEN_TEXT, KeyEvent.VK_D, KeyEvent.CTRL_DOWN_MASK));
		actionList.put(String.valueOf(ACTION_ADRESSLISTE_LOESCHEN_CODE), new AuswahlAction(rz, this, ACTION_ADRESSLISTE_LOESCHEN_CODE, ACTION_ADRESSLISTE_LOESCHEN_TEXT, KeyEvent.VK_L, KeyEvent.CTRL_DOWN_MASK));
		actionList.put(String.valueOf(ACTION_STICHWORTLISTE_BEARBEITEN_CODE), new AuswahlAction(rz, this, ACTION_STICHWORTLISTE_BEARBEITEN_CODE, ACTION_STICHWORTLISTE_BEARBEITEN_TEXT, KeyEvent.VK_S, KeyEvent.CTRL_DOWN_MASK));
		actionList.put(String.valueOf(ACTION_STICHWORTLISTE_LOESCHEN_CODE), new AuswahlAction(rz, this, ACTION_STICHWORTLISTE_LOESCHEN_CODE, ACTION_STICHWORTLISTE_LOESCHEN_TEXT, KeyEvent.VK_W, KeyEvent.CTRL_DOWN_MASK));
		actionList.put(String.valueOf(ACTION_VERWEIS_CODE), new AuswahlAction(rz, this, ACTION_VERWEIS_CODE, ACTION_VERWEIS_TEXT, 0, 0));
		actionList.put(String.valueOf(ACTION_VERWEIS_ENTFERNEN_CODE), new AuswahlAction(rz, this, ACTION_VERWEIS_ENTFERNEN_CODE, ACTION_VERWEIS_ENTFERNEN_TEXT, 0, 0));
		actionList.put(String.valueOf(ACTION_ACIDRECHNER_CODE), new AuswahlAction(rz, this, ACTION_ACIDRECHNER_CODE, ACTION_ACIDRECHNER_TEXT, 0, 0));
		actionList.put(String.valueOf(ACTION_DEKLARATIONEN_BEARBEITEN_CODE), new AuswahlAction(rz, this, ACTION_DEKLARATIONEN_BEARBEITEN_CODE, ACTION_DEKLARATIONEN_BEARBEITEN_TEXT, 0, 0));
		actionList.put(String.valueOf(ACTION_DEKLARATIONEN_LOESCHEN_CODE), new AuswahlAction(rz, this, ACTION_DEKLARATIONEN_LOESCHEN_CODE, ACTION_DEKLARATIONEN_LOESCHEN_TEXT, 0, 0));
		actionList.put(String.valueOf(ACTION_MUSTERNUMMER_CODE), new AuswahlAction(rz, this, ACTION_MUSTERNUMMER_CODE, ACTION_MUSTERNUMMER_TEXT, 0, 0));
		actionList.put(String.valueOf(ACTION_BACKUP_VERSION_CODE), new AuswahlAction(rz, this, ACTION_BACKUP_VERSION_CODE, ACTION_BACKUP_VERSION_TEXT, 0, 0));
		actionList.put(String.valueOf(ACTION_DELETE_VERSION_CODE), new AuswahlAction(rz, this, ACTION_DELETE_VERSION_CODE, ACTION_DELETE_VERSION_TEXT, 0, 0));
		actionList.put(String.valueOf(ACTION_LABORWERTE_CODE), new AuswahlAction(rz, this, ACTION_LABORWERTE_CODE, ACTION_LABORWERTE_TEXT, 0, 0));
		actionList.put(String.valueOf(ACTION_TANKLISTE_PLAN_CODE), new AuswahlAction(rz, this, ACTION_TANKLISTE_PLAN_CODE, ACTION_TANKLISTE_PLAN_TEXT, 0, 0));
		actionList.put(String.valueOf(ACTION_ZUTATENVERZEICHNIS_CODE), new AuswahlAction(rz, this, ACTION_ZUTATENVERZEICHNIS_CODE, ACTION_ZUTATENVERZEICHNIS_TEXT, 0, 0));
		actionList.put(String.valueOf(ACTION_LABORWERTE_ALLE_CODE), new AuswahlAction(rz, this, ACTION_LABORWERTE_ALLE_CODE, ACTION_LABORWERTE_ALLE_TEXT, 0, 0));

	}

	/**
	 * Hilfsfunktionen getline extrahiert die aktuelle Zeile im Textfeld vom
	 * Anfang bis zum Cursor
	 * 
	 */
	private String getLine(JTextPane p) {
		String ret = "";
		int start, end;
		end = p.getCaretPosition();
		start = (p.getText().lastIndexOf("\n", p.getCaretPosition() - 1) == -1)
				? 0
				: p.getText().lastIndexOf("\n", p.getCaretPosition() - 1);
		try {
			ret = p.getText().substring(start, end);
		} catch (final Exception e) {
		}
		return ret;
	}
	/**
	 * Hilfsfunktionen getExtend extrahiert die aktuelle Zeile im Textfeld vom
	 * Cursor bis zum Zeilenende
	 * 
	 */
	private String getExtend(JTextPane p) {
		String ret = "";
		int start, end;
		start = p.getCaretPosition();
		end = (p.getText().indexOf("\n", start) == -1)
				? p.getText().length()
				: p.getText().indexOf("\n", start);
		try {
			ret = p.getText().substring(start, end);
		} catch (final Exception e) {
		}
		return ret;
	}
	/**
	 * gibt die Position des Zeilenendes (oder des TExtendes) in der JTextPane
	 * an
	 * 
	 * @param p
	 *            JTextPane
	 * @return int Zeilenende
	 */
	private int getExtendPosition(JTextPane p) {
		return (p.getText().indexOf("\n", p.getCaretPosition()) <0) ? p.getText().length() : p.getText().indexOf("\n",p.getCaretPosition());
	}

	private void setBrennwertAlkoholValue() {
		if (txtStaerke.getValue() != 0) {
			lblBrennwertAlkoholValue.setText(rz.getLocale().formatNumber(
					rz.getTafelFactory().Brennwert(txtStaerke.getValue()),
					OptionFactory.NF_NORMAL));
		} else {
			lblBrennwertAlkoholValue.setText(rz.getLocale().formatNumber(0.0,
					OptionFactory.NF_NORMAL));
		}
	}
	/**
	 * ok gedrückt... abspeichern oder ändern
	 */
	private void okAction() {
		int i = 0;
		int idAlt = rezeptur.getID();
		boolean do_it = true;
		if ((!rz.isZero(txtStaerke.getValue()))
				&& (((EinheitsItem) cmbBestandseinheit.getSelectedItem()).getTyp() != RzPro.EINHEIT_LA)) {
			final DialogItem di = new DialogItem(DialogControl.FRAGE_DIALOG,
					"", 0.0, rz.getLocale().getString(
							"rezeptur.question_einheit"), rz.getLocale()
							.getString("rezeptur.question_einheit"), rz
							.getLocale().getString("rezeptur.question_einheit_message")
							.replaceAll("%s", rezeptur.getTitel()),
							"frage.png", rz.getLocale().getString("string_ja"), rz
							.getLocale().getString("string_nein"), this);
			rz.getDialogFactory().getDialog(di);
			if ((di.getReplyCode() == DialogControl.DIALOG_NO)
					|| (di.getReplyCode() == DialogControl.DIALOG_CANCEL)) {
				do_it = false;
			}
		}
		if(rz.getDatabase().getErgebnis().checkSpezifikation(txtSpezifikation.getText().trim(),rezeptur.getID())) {
			do_it=false;
			final DialogItem di = new DialogItem(DialogControl.HINWEIS_DIALOG,
					"", 0.0, rz.getLocale().getString("rezeptur.spezifikation"),
							rz.getLocale()	.getString("rezeptur.spezifikation"),
							rz.getLocale().getString("rezeptur.spezifikation_message")
							.replaceAll("%s", txtSpezifikation.getText().trim()),
							"warnung.png", rz.getLocale().getString("string_ok"), 
							rz.getLocale().getString("string_nein"), this);
			rz.getDialogFactory().getDialog(di);
		}
		
		if(!rz.getDatabase().getRezeptur().checkNameID(txtName.getText().trim(), rezeptur.getID())) {
			if(rz.getDatabase().getRezeptur().checkRezepturNameExists(txtName.getText().trim(),false)) {
				 
				 final DialogItem di = new DialogItem(
	                       DialogControl.FRAGE_DIALOG,
	                       "",
	                       0.0,
	                       rz.getLocale().getString("rezeptur.name_exists"),
	                       rz.getLocale().getString("rezeptur.name_exists"),
	                       rz.getLocale().getString("rezeptur.name_exists_message").replaceAll("%n",rz.getDatabase().getRezeptur().getNameStichworte(txtName.getText().trim())),
	                       "frage.png",
	                       rz.getLocale().getString("string_ja"),
	                       rz.getLocale().getString("string_nein"),
	                       this
	               );
				rz.getDialogFactory().getDialog(di);
				if ((di.getReplyCode() == DialogControl.DIALOG_NO) || (di.getReplyCode() == DialogControl.DIALOG_CANCEL)){
					do_it = false;
				}
			}
		}
		
		if(txtName.getText().trim().equals("")) {
			do_it=false;
			final DialogItem di = new DialogItem(DialogControl.HINWEIS_DIALOG,
					"", 0.0, rz.getLocale().getString("rezeptur.bezeichnung"),
							rz.getLocale()	.getString("rezeptur.bezeichnung"),
							rz.getLocale().getString("rezeptur.bezeichnung.message")
							.replaceAll("%s", txtSpezifikation.getText().trim()),
							"warnung.png", rz.getLocale().getString("string_ok"), 
							rz.getLocale().getString("string_nein"), this);
			rz.getDialogFactory().getDialog(di);
		}
		
		if (do_it) {
			toItem(rezeptur);
			final StichwortListe sl = rezeptur.getStichwortListe().copyList();
			final StichwortListe al = rezeptur.getAdressListe().copyList();
			final String titel = rezeptur.getTitel();
			rz.setWaitCursor(this);
			if (rezeptur.getVerweis() == 0) {
				i = rz.getDatabase().getRezeptur().dbSaveRezeptur(rezeptur);
			} else {
				i = rz.getDatabase().getRezeptur().dbSaveVerweis(rezeptur);
			}
			rz.setFreeCursor(this);
			if (i > 0) {
				rz.getDatabase().getRezeptur().calcSingle(	i,rezeptur.getVerweis() == 0? RzPro.TYP_ID_REZEPT	: RzPro.TYP_ID_VERWEIS);
				if (idAlt != 0
						&& ((!preis.equals(rezeptur.getPreis()))
								|| (Math.abs(preisMenge
										- rezeptur.getPreisMenge()) > RzPro.DOUBLE_NULL) || (preisEinheit != rezeptur
								.getPreisEinheit()))) {
					rz.setWaitCursor(this);
					final DependencyListe el = rz.getDatabase().getErgebnis()
							.dbGetErgebnisListeByID(i,true);
					rz.setFreeCursor(this);
					if (el.size() > 0) {
						rz.getFensterFactory().getFensterListe().createWindow(
								FensterFactory.FENSTER_DEPENDENCY,
								false,
								new MessageItem(
										MessageItem.MSG_DEPENDENCY_CALC, 0,
										new IDItem(el, rezeptur.getTitel()),
										this));
					}
				}
				closeWindow();
				final AbfrageItem ai = new AbfrageItem();
				ai.setTyp(de.lunqual.rzpro.database.DBAbfrage.ABFRAGE_TYP_NORMAL);
				ai.setID(i);
				ai.setAdressListe(al);
				ai.setStichwortListe(sl);
				ai.setMuster(rz.getDatabase().getErgebnis()
						.getMusterString(titel));
				try {
					origin.getMessage(new MessageItem(
							MessageItem.MSG_ADD_QUERY_REZEPT, ai.getID(), ai,
							this));
					rz.getFensterFactory().getFensterListe()
							.propagateBestand(this, rezeptur.getID());
				} catch (final Exception e) {
				}
				closeWindow();
			}
		}
	}

	/**
	 * cancel gedrückt, Fenster schliessen, nicht abspeichern
	 */
	private void cancelAction() {
		closeWindow();
	}

	/**
	 * Säurerechner anzeigen
	 */
	private void acidRechnerAction() {
		final AcidAnzeigeItem ai = new AcidAnzeigeItem(
				txtName.getText().trim(), txtLitergewicht.getValue(), txtAcid
						.getValue());
		rz.getFensterFactory().getFensterListe().createWindow(
				FensterFactory.FENSTER_ACIDRECHNER, false,
				new MessageItem(MessageItem.MSG_SHOW_ACIDRECHNER, 1, ai, this));
	}

	/**
	 * den Dialog mit der Adressenliste anzeigen
	 * 
	 * 
	 */
	private void adressListeBearbeitenAction() {
		final AbfrageItem ai = new AbfrageItem();
		ai.setAdressListe(rezeptur.getAdressListe().copyList());
		rz.getFensterFactory().getFensterListe().createWindow(
				FensterFactory.FENSTER_ADRESSAUSWAHL,
				true,
				new MessageItem(MessageItem.MSG_ADRESSLISTE_REQUEST, 0, ai,
						this));
	}
	private void adressenLoeschenAction() {
		rezeptur.getAdressListe().clear();
		lstAdressen.setListData(rezeptur.getAdressListe().toArray());

		txtName.requestFocus();
	}

	private void deklarationenLoeschenAction() {
		rezeptur.getDeklarationenListe().clear();
		lstDeklarationen
				.setListData(rezeptur.getDeklarationenListe().toArray());
		txtName.requestFocus();
	}

	private void deklarationenBearbeitenAction() {
		rz.getFensterFactory().getFensterListe().createWindow(
				FensterFactory.FENSTER_DEKLARATIONS_AUSWAHL,
				true,
				new MessageItem(MessageItem.MSG_SHOW_DEKLARATION_AUSWAHL, 0,
						rezeptur.getDeklarationenListe(), this));
	}

	private void stichwortListeBearbeitenAction() {
		final AbfrageItem ai = new AbfrageItem();
		ai.setStichwortListe(rezeptur.getStichwortListe().copyList());
		rz.getFensterFactory().getFensterListe().createWindow(
				FensterFactory.FENSTER_STICHWORTAUSWAHL,
				true,
				new MessageItem(MessageItem.MSG_STICHWORTLISTE_REQUEST, 0, ai,
						this));
	}
	private void stichwortListeLoeschenAction() {
		rezeptur.getStichwortListe().clear();
		lstStichworte.setListData(rezeptur.getStichwortListe().toArray());
		txtName.requestFocus();
	}
	// hilfe
	private void hilfeAction() {
		rz.getFensterFactory().getFensterListe()
				.createWindow(
						FensterFactory.FENSTER_HILFE,
						true,
						new MessageItem(MessageItem.MSG_HILFE, 0,
								"rezeptur.html", this));
	}

	private void hideAction() {
		rz.getFensterFactory().getFensterListe().sperren(this);
	}

	private void verweisAction() {
		rezeptur.setTitel(txtName.getText().trim());
		showVerweisDialog(lblVerweisRezeptur.getText().trim());
		fromItem(rezeptur);
	}

	private final class STWListRenderer extends JLabel
			implements
				ListCellRenderer {
		RzPro rz;
		public STWListRenderer(RzPro r) {
			rz = r;
			setOpaque(true);
		}

		public Component getListCellRendererComponent(JList list, Object value,
				int index, boolean isSelected, boolean cellHasFocus) {
			final StichwortItem si = (StichwortItem) value;
			this.setFont(rz.getFontFactory().getListFont());
			setText(si.toString());
			if (isSelected) {
				setBackground(rz.getOptionFactory().getColor(
						OptionFactory.COLOR_LIST_BACKGROUND_SELECTED));
				setForeground(rz.getOptionFactory().getColor(
						OptionFactory.COLOR_LIST_FOREGROUND_SELECTED));
			} else {
				setBackground(rz.getOptionFactory().getRGBColorString(
						si.getHg()));
				setForeground(rz.getOptionFactory().getRGBColorString(
						si.getVg()));
			}
			return this;
		}
	}

	public void columnAdded(TableColumnModelEvent arg0) {
	}

	public void columnMarginChanged(ChangeEvent arg0) {
	}

	public void columnMoved(TableColumnModelEvent arg0) {
	}

	public void columnRemoved(TableColumnModelEvent arg0) {
	}

	public void columnSelectionChanged(ListSelectionEvent arg0) {
	}

    private void settblLaborwerteModel(JTable t) {
    	final JComboBox cmbAusgabe=new JComboBox();
    	rz.getDatabase().getEinheiten().setEinheitenCmb(cmbAusgabe,1);
    	final JComboBox cmbEditLager=new JComboBox();
    	final JCheckBox chkSpezifikation=new JCheckBox();
    	rz.getDatabase().getLager().setLagerCmb(cmbEditLager,-1);
	    final werteColumnModel rcm = new werteColumnModel();
	    final NumericRenderer nr = new NumericRenderer();
	    final StringRenderer sr = new StringRenderer();
	    final chkRenderer cr = new chkRenderer();
	    TableColumn tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("rezeptur.tableheader_wert"));
	    	tc.setModelIndex(C_WERT);
	    	tc.setCellRenderer(sr);
	    rcm.addColumn(tc);
	    tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("rezeptur.tableheader_rechnen"));
	    	tc.setModelIndex(C_RECHNEN);
	    	tc.setCellRenderer(sr);
	    rcm.addColumn(tc);
    	tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("rezeptur.tableheader_value"));
	    	tc.setModelIndex(C_VALUE);
	    	tc.setCellRenderer(nr);
	    rcm.addColumn(tc);
    	tc = new TableColumn();
        	tc.setHeaderValue(rz.getLocale().getString("rezeptur.tableheader_einheit"));
        	tc.setModelIndex(C_EINHEIT);
        	tc.setCellRenderer(sr);
        rcm.addColumn(tc);
    	tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("rezeptur.tableheader_spezifikation"));
	    	tc.setModelIndex(C_SPEZIFIKATION);
        	tc.setCellRenderer(cr);
	    	tc.setCellEditor(new DefaultCellEditor(chkSpezifikation));
	    rcm.addColumn(tc);
    	tc = new TableColumn();
	    	tc.setHeaderValue(rz.getLocale().getString("rezeptur.tableheader_ausgabe"));
	    	tc.setModelIndex(C_AUSGABE);
	    	tc.setCellRenderer(sr);
	    	tc.setCellEditor(new DefaultCellEditor(cmbAusgabe));
	    rcm.addColumn(tc);


        rcm.addColumnModelListener(this);
        tblWerte.setModel(new werteTableModel());
        tblWerte.setColumnModel(rcm);
        tblWerte.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
        tblWerte.setCellSelectionEnabled(true);
        tblWerte.setShowGrid(true);
        tblWerte.getTableHeader().setReorderingAllowed(false);
	}

    private class werteColumnModel extends DefaultTableColumnModel{
	    public werteColumnModel() {
	        super();
	    }
	}

	private  class werteTableModel extends AbstractTableModel    {

	        SimpleDateFormat df;

	        public werteTableModel() {
	            df = new SimpleDateFormat("dd.MM.yyyy");
	        }

		   public int getColumnCount() {
		       	return MAX_COLUMN;
	        }
	        public int getRowCount() {
	        	if(liste != null) {
	                return liste.size();
	        	} else {
	        		return 0;
	        	}
	        }

	        public LaborwertValueItem getZeileAt(int rowIndex) {
	        	if((rowIndex != -1) && (liste != null)) {
	        		return liste.get(rowIndex);
	        	} else {
					return null;
				}
	        }

	        public Object getValueAt(int rowIndex, int columnIndex) {
	            Object ret = null;
	            if((rowIndex != -1) && (liste != null)) {
	                ret = getContent(liste.get(rowIndex),columnIndex);
	            }
	            return ret;
	        }

	        @Override
			public boolean isCellEditable(int row, int col){
	        	boolean ret = false;
	        	switch(col) {
	        		case C_VALUE:ret= true;break;
	        		case C_SPEZIFIKATION:ret=true;break;
	        		case C_AUSGABE:ret=true;break;
	        	}
	        	return ret;
	        }


	        @Override
			public void setValueAt(Object value, int row, int col) {
	        	if(!modified) {
		        	if (row != -1) {
		        		switch (col) {
		        			case C_VALUE:
		        					LaborwertValueItem  lvi = liste.get(row);
		        					Double alt = lvi.getValue();
		        					Double neu = rz.getLocale().getNumber((String)value,OptionFactory.NF_LITERGEWICHT);
		        				    BigDecimal bAlt = new BigDecimal(Double.toString(alt));
		        				    BigDecimal bNeu = new BigDecimal(Double.toString(neu));
		        				    bAlt = bAlt.setScale(rz.getOptionFactory().getOption("laborwerte.decimal_digits",OptionFactory.LABORWERTE_DECIMAL_DIGITS), RoundingMode.HALF_UP);
		        				    bNeu = bNeu.setScale(rz.getOptionFactory().getOption("laborwerte.decimal_digits",OptionFactory.LABORWERTE_DECIMAL_DIGITS), RoundingMode.HALF_UP);
		        					if(bAlt.compareTo(bNeu)!=0) {
		        	    				ChangesListe ch=new ChangesListe(rz,lvi.getRezeptur());
		        	    				ch.add(rz.getLocale().getString("changes.laborwert"),lvi.getLbwBezeichnung() + ":  " + bAlt+ " " + lvi.getStrEinheit1() + "/"+lvi.getStrEinheit2() , bNeu  + " " + lvi.getStrEinheit1() + "/"+lvi.getStrEinheit2(),true);
		        	    				ch.commit();
		        					}
		        					liste.get(row).setValue(rz.getLocale().getNumber((String)value,OptionFactory.NF_NORMAL));
		        					rz.getDatabase().getLaborwerte().saveValue(liste.get(row));
		        					break;
		        			case C_SPEZIFIKATION:
		        					liste.get(row).setSpezifikation(!liste.get(row).isSpezifikation());
			        				liste.get(row).setId(rz.getDatabase().getLaborwerte().saveValue(liste.get(row)));
		        					rz.getDatabase().getLaborwerte().setSpezifikation(liste.get(row).getId(),liste.get(row).isSpezifikation());
		        				break;
		        			case C_AUSGABE:
		        					liste.get(row).setAusgabeeinheit(((EinheitsItem)value).getID());
			        				liste.get(row).setId(rz.getDatabase().getLaborwerte().saveValue(liste.get(row)));
		        					rz.getDatabase().getLaborwerte().setAusgabeEinheit(liste.get(row).getId(),liste.get(row).getAusgabeeinheit());
		        					break;
		       			}
		        	}
	        	}else {
	        		
	        	}
        	}

	        private Object getContent(LaborwertValueItem vi,int aColumn) {
	            Object ret = null;
	            switch(aColumn){
	                case C_WERT: ret = vi.getLbwBezeichnung(); break;
	                case C_VALUE: ret = rz.getLocale().formatNumber( vi.getValue(),OptionFactory.NF_NORMAL); break;
		            case C_EINHEIT:
		                if(vi.isFix()) {
		                	ret = rz.getLocale().getString("laborwert.fix");
		                } else {
		                	ret = vi.getStrEinheit1() + " / " + vi.getStrEinheit2();
		                }
		                break;
	                case C_SPEZIFIKATION:ret=vi.isSpezifikation();break;
	                case C_AUSGABE:ret=rz.getDatabase().getEinheiten().getEinheit(vi.getAusgabeeinheit());break;
	            }

	            return ret;
	        }
		}
    
    
	private class NumericRenderer extends DefaultTableCellRenderer {

	    NumericRenderer() {
	        super();
	        setOpaque(true);
	    }
	    @Override
		public Component getTableCellRendererComponent(JTable table,
                Object value, boolean isSelected, boolean hasFocus, int row,
                int column)
	    {
            this.setFont(rz.getFontFactory().getTableFont());
	        if(value != null) {
	           if(!rz.isZero(rz.getLocale().getNumber(value.toString(), OptionFactory.NF_NORMAL))) {
	               setText(value.toString());
	           } else {
				setText("");
			}
	         } else {
				setText("");
			}
	        if(column == C_VALUE) {
	        	this.setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_BESTAND_GELB));
	        }else {
	        	this.setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_BESTAND_WHITE));
	        }
	        setHorizontalAlignment(SwingConstants.TRAILING);
	        return this;
        }
	}
	/** rendert alle Tabellenzeilen mit String Inhalt
	 *  im wesentlichen heisst das rechts-ausgerichtent
	 * @author lunqual
	 */
	private class StringRenderer extends DefaultTableCellRenderer {

		Icon 	rechnen;
		Icon	rechnen_ok;
	    StringRenderer() {
	        super();
	        rechnen = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/rezeptur.icon_rechnen.png"));
	        rechnen_ok = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/rezeptur.icon_rechnen_ok.png"));
	        setOpaque(true);
	    }
	    @Override
		public Component getTableCellRendererComponent(JTable table,
                Object value, boolean isSelected, boolean hasFocus, int row,
                int column)
	    {
            this.setFont(rz.getFontFactory().getTableFont());
	        if(value != null) {
	        	setText(value.toString());
	         } else {
				setText("");
			}
	        setHorizontalAlignment(SwingConstants.LEADING);
	        if(column == C_VALUE) {
	        	this.setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_BESTAND_GELB));
	        }else {
	        	this.setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_BESTAND_WHITE));
	        }
	        setIcon(null);
	        LaborwertValueItem lvi = liste.get(row);
	        if(column == C_RECHNEN && !lvi.isFix()){
	        	if(isLaborwerteSaveable()) {
		        	if(lvi.isBerechnet()) {
		        		setIcon(rechnen_ok);
		        	}else {
		        		setIcon(rechnen);
		        	}
	        	}
	        }
	        return this;
        }
	}

	private class chkRenderer extends JCheckBox implements TableCellRenderer {

	    chkRenderer() {
	        super();
	        setOpaque(true);
	    }
	    public Component getTableCellRendererComponent(JTable table,
                Object value, boolean isSelected, boolean hasFocus, int row,
                int column)
	    {
	    	if(value != null) {
	    		this.setSelected((Boolean)value);
	    	}
	    	return this;
        }
	}

	
}