/*
 * Created on 06.08.2004
 *
 */
package de.lunqual.rzpro.fenster.rezepturfenster;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.ArrayList;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.rezeptur.ChangesFilterItem;
import de.lunqual.rzpro.items.rezeptur.ChangesFilterListe;
import de.lunqual.rzpro.items.rezeptur.SteuerLagerItem;
/**
 * @author labor
 *
 */
public class changesFilterAuswahl extends JFrame{

    private JPanel 			mainPanel;
    private JScrollPane 	scrListe;
    private JList				lstfilterliste;
    private JPanel				buttonPanel;
    	private JPanel				auswahlPanel;
    		private JButton			btAlle;
    		private JButton			btKeine;
    	private JPanel				okButtonPanel;
    		private JButton			btOK;
    		private JButton			btCancel;


    int							x;
    int							y;
    RzPro                		rz;
    ChangesFilterListe			filterliste;
    ArrayList<SteuerLagerItem>  steuerlagerliste;
    JRzFrame					parentFrame;


    /** Creates new form EinheitenDialog */
    public changesFilterAuswahl(JRzFrame parent, RzPro r,int x,int y,ChangesFilterListe liste) {
        rz = r;
        parentFrame = parent;
        this.filterliste = liste.copyList();
        this.x = x;
        this.y = y;
        createGUI();
    }

    //
    private void formFocusGained() {
    	showListe();
    }

    private void formFocusLost() {
    	setVisible(false);
    }

    private void showListe(){
    }

    private void itemSelected() {
		try {
			parentFrame.getMessage(new MessageItem(MessageItem.MSG_CHANGESFILTER_DIALOG_REPLY,0,filterliste,this));
		} catch (final Exception e) {}
		setVisible(false);
    }

    private void formKeyEvent(KeyEvent evt){
    	switch (evt.getKeyCode()){
    		case KeyEvent.VK_ESCAPE:
    			this.setVisible(false);
    			break;
    		case KeyEvent.VK_ENTER:
    			itemSelected();
    			break;
    		default :
    			break;
    	}
    }

    public void createGUI(){
        setUndecorated(true);
    	mainPanel = new JPanel(new BorderLayout());
        getContentPane().add(mainPanel, java.awt.BorderLayout.CENTER);
        addWindowFocusListener(new WindowFocusListener()
                {
            		public void windowLostFocus(WindowEvent evt) {
            		    formFocusLost();
            		}
            		public void windowGainedFocus(WindowEvent evt) {
					    formFocusGained();
					}
                });
        scrListe = new JScrollPane();
        	lstfilterliste = new JList();
            lstfilterliste.setSelectionMode(javax.swing.ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
            lstfilterliste.setCellRenderer(new CheckBoxRenderer());
            lstfilterliste.addKeyListener(new java.awt.event.KeyAdapter() {
                @Override
				public void keyReleased(java.awt.event.KeyEvent evt) {
                    formKeyEvent(evt);
                }
            });
      		lstfilterliste.addMouseListener(new MouseAdapter() {
          		@Override
				public void mouseClicked(MouseEvent me) {
    	  			final int selectedIndex = lstfilterliste.locationToIndex(me.getPoint());
    				if (selectedIndex < 0) {
						return;
					}
            			final ChangesFilterItem item = (ChangesFilterItem)lstfilterliste.getModel().getElementAt(selectedIndex);
            			item.setChecked(!item.isChecked());
            			lstfilterliste.repaint();
          		}
        		});
            scrListe.setViewportView(lstfilterliste);
            mainPanel.add(scrListe,BorderLayout.CENTER);
            buttonPanel = new JPanel(new BorderLayout());
            	auswahlPanel = new JPanel(new GridLayout(1,2));
            		btAlle = new JButton();
            		btAlle.setText(rz.getLocale().getString("lager.liste_alle"));
            	    btAlle.addActionListener(new ActionListener() {
        	        	public void actionPerformed(ActionEvent evt) {
        	        		filterliste.setCheckForAll(true);
        	        		lstfilterliste.repaint();
        	        	}
                    });
                    btAlle.addKeyListener(new java.awt.event.KeyAdapter() {
                        @Override
						public void keyReleased(java.awt.event.KeyEvent evt) {
                            formKeyEvent(evt);
                        }
                    });
            		auswahlPanel.add(btAlle);
            		btKeine = new JButton();
            		btKeine.setText(rz.getLocale().getString("lager.liste_keine"));
            	    btKeine.addActionListener(new ActionListener() {
        	        	public void actionPerformed(ActionEvent evt) {
        	        		filterliste.setCheckForAll(false);
        	        		lstfilterliste.repaint();
        	        	}
                    });
                    btKeine.addKeyListener(new java.awt.event.KeyAdapter() {
                        @Override
						public void keyReleased(java.awt.event.KeyEvent evt) {
                            formKeyEvent(evt);
                        }
                    });
            		auswahlPanel.add(btKeine);
                buttonPanel.add(auswahlPanel,BorderLayout.NORTH);
            	okButtonPanel = new JPanel(new GridLayout(1,2));
        			btOK = new JButton();
        			btOK.setText(rz.getLocale().getString("ok"));
            	    btOK.addActionListener(new ActionListener() {
        	        	public void actionPerformed(ActionEvent evt) {
        	        		itemSelected();
        	        	}
                    });
        			okButtonPanel.add(btOK);
        			btCancel = new JButton();
        			btCancel.setText(rz.getLocale().getString("cancel"));
            	    btCancel.addActionListener(new ActionListener() {
        	        	public void actionPerformed(ActionEvent evt) {
        	        		setVisible(false);
        	        	}
                    });
        			okButtonPanel.add(btCancel);
        			okButtonPanel.setBorder(BorderFactory.createRaisedBevelBorder());
        		buttonPanel.add(okButtonPanel,BorderLayout.SOUTH);
            buttonPanel.add(auswahlPanel,BorderLayout.NORTH);
            mainPanel.add(buttonPanel,BorderLayout.SOUTH);
		// Grösse, Position, Fonts....
        lstfilterliste.setListData(filterliste.toArray());
        pack();
		rz.getFontFactory().setFrameFonts(this);
		pack();
        setBounds(x,y,this.getWidth(),this.getHeight());
    }

	private class CheckBoxRenderer extends JCheckBox implements ListCellRenderer {

		public CheckBoxRenderer() {
			setOpaque(true);
    		}

    		public Component getListCellRendererComponent(JList listBox, Object obj, int currentindex,
					boolean isChecked, boolean hasFocus) {
    		final ChangesFilterItem ci = (ChangesFilterItem)obj;
     		setFont(rz.getFontFactory().getListFont());
    		setText(ci.getBezeichnung());
      		setSelected(ci.isChecked());
      		return this;
    		}

  	}

}
