package de.lunqual.rzpro.fenster.rzDatePicker;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingConstants;

import com.github.lgooddatepicker.components.DatePicker;
import com.github.lgooddatepicker.components.DatePickerSettings;
import com.github.lgooddatepicker.optionalusertools.DateChangeListener;
import com.github.lgooddatepicker.zinternaltools.DateChangeEvent;

import de.lunqual.rzpro.RzPro;

public class RzDualDatePicker extends JPanel{

	
	private static final int				BUTTON_UP_1				= 1;
	private static final int				BUTTON_DOWN_1	 	= 2;
	private static final int				BUTTON_UP_2				= 3;
	private static final int				BUTTON_DOWN_2	 	= 4;
	
	private static final int				B_HEUTE						= 1;
	private static final int				B_GESTERN					= 2;
	private static final int				B_DIESE_WOCHE			= 3;
	private static final int				B_LETZTE_WOCHE		= 4;
	private static final int				B_2WOCHEN					= 5;
	private static final int				B_DIESEN_MONAT		= 6;
	private static final int				B_LETZTEN_MONAT		= 7;
	private static final int				B_4WOCHEN					= 8;
	private static final int				B_DIESES_JAHR			= 9;
	private static final int				B_LETZTES_JAHR			= 10;
	private static final int				B_2JAHRE						= 11;
	private static final int				B_5JAHRE						= 12;
	
	RzPro 										rz;
	JPanel										centerPanel;


	JPanel										pickerPanel;
		JPanel										pickerPanel1;
			JLabel									lblPicker1;
			DatePicker							picker1;
			JPanel										pickerButtonPanel1;
				JButton									btUp1;
				JButton									btDown1;
		JPanel										pickerPanel2;
			JLabel										lblPicker2;
			DatePicker								picker2;
			JPanel										pickerButtonPanel2;
				JButton									btUp2;
				JButton									btDown2;
		JPanel									 	buttonPanel;
			JButton									btHeute;
			JButton									btGestern;
			JButton									btDieseWoche;
			JButton									btLetzteWoche;
			JButton									bt2Wochen;
			JButton									btDiesenMonat;
			JButton									btLetztenMonat;
			JButton									bt4Wochen;
			JButton									btdiesesJahr;
			JButton									btLetztesJahr;
			JButton									bt2Jahre;
			JButton									bt5Jahre;
			

	ImageIcon								icon;
	 List<PickerDualDateListener> 	listeners;
	boolean									atDayEnd = false;



	public RzDualDatePicker(RzPro rz) {
		this.rz = rz;
		initComponent();
		picker1.setDate(LocalDate.now());
		picker2.setDate(LocalDate.now());
	}


	public RzDualDatePicker(RzPro rz,LocalDate datum1, LocalDate datum2) {
		super();
		this.rz = rz;
		initComponent();
		setStartDate(datum1,datum2);
	}

	public  void setComponentsEnabled(JPanel panel, Boolean enabled) {
	    Component[] components = panel.getComponents();
	    for (Component component : components) {
	        if (component instanceof JPanel) {
	            setComponentsEnabled((JPanel) component, enabled);
	        }
	        component.setEnabled(enabled);
	    }
	}

	public void setStartDate(LocalDate datum1,LocalDate datum2) {
		if(datum1 == null) {
			picker1.setDate(LocalDate.now());
		} else {
			picker1.setDate(datum1);
		}
		if(datum2== null) {
			picker2.setDate(LocalDate.now());
		} else {
			picker2.setDate(datum2);
		}
	}
	
	private void initComponent() {
		listeners = new ArrayList<PickerDualDateListener>();
		this.setLayout(new BorderLayout());
		this.setBorder(BorderFactory.createEtchedBorder());
		centerPanel = new JPanel(new BorderLayout());
		icon = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/rzdatepicker_icon.png"));


		
		 DatePickerSettings s1 = new DatePickerSettings();
	        	s1.setFormatForDatesCommonEra(rz.getOptionFactory().getOption("rzsimpledatepicker.format"));
	        	s1.setWeekNumbersDisplayed(true, true);
	  	 DatePickerSettings s2 = new DatePickerSettings();
	        	s2.setFormatForDatesCommonEra(rz.getOptionFactory().getOption("rzsimpledatepicker.format"));
	        	s2.setWeekNumbersDisplayed(true, true);
	              	
	        	
	     pickerPanel = new JPanel(new GridLayout(1,2));
	     	pickerPanel.setBorder(BorderFactory.createEtchedBorder());
		/*
		 * Date Picker 1
		 */
	     pickerPanel1 = new JPanel(new BorderLayout());
	     	pickerPanel1.setBorder(BorderFactory.createEtchedBorder());
	     	lblPicker1 = new JLabel();
	     		lblPicker1.setHorizontalAlignment(SwingConstants.CENTER);
	     		lblPicker1.setText(rz.getLocale().getString("picker.dual.label.picker1"));
	     		pickerPanel1.add(lblPicker1,BorderLayout.NORTH);
	     	picker1 = new DatePicker(s1);	
	        	JButton datePickerButton1 = picker1.getComponentToggleCalendarButton();
	        	datePickerButton1.setText("");
	        	datePickerButton1.setIcon(icon);
	        	picker1.addDateChangeListener(new DateChangeListener() {
				@Override
					public void dateChanged(DateChangeEvent event) {
						dateNew( );
			}});
	        pickerPanel1.add(picker1,BorderLayout.CENTER);
	        pickerButtonPanel1 = new JPanel(new GridLayout(1,2));
				btDown1 = new JButton();
					btDown1.setText("-");
					btDown1.addActionListener(new ActionListener() {
			        	public void actionPerformed(ActionEvent evt) {
			        		dateButton(BUTTON_DOWN_1);
			        	}
		    	    });
				pickerButtonPanel1.add(btDown1);
				btUp1 = new JButton();
				btUp1.setText("+");
				btUp1.addActionListener(new ActionListener() {
		        	public void actionPerformed(ActionEvent evt) {
		        		dateButton(BUTTON_UP_1);
		        	}
			    });
				pickerButtonPanel1.add(btUp1);
			pickerPanel1.add(pickerButtonPanel1,BorderLayout.WEST);
		pickerPanel.add(pickerPanel1);
		
		
		/*
		 * Date Picker 2
		 */
	     pickerPanel2 = new JPanel(new BorderLayout());
	     	pickerPanel2.setBorder(BorderFactory.createEtchedBorder());
	     	lblPicker2 = new JLabel();
	     		lblPicker2.setHorizontalAlignment(SwingConstants.CENTER);
	     		lblPicker2.setText(rz.getLocale().getString("picker.dual.label.picker2"));
	     		pickerPanel2.add(lblPicker2,BorderLayout.NORTH);
	     	picker2 = new DatePicker(s2);	
	        	JButton datePickerButton2 = picker2.getComponentToggleCalendarButton();
	        	datePickerButton2.setText("");
	        	datePickerButton2.setIcon(icon);
	        	picker2.addDateChangeListener(new DateChangeListener() {
				@Override
					public void dateChanged(DateChangeEvent event) {
						dateNew( );
			}});
	        pickerPanel2.add(picker2,BorderLayout.CENTER);
	        pickerButtonPanel2 = new JPanel(new GridLayout(1,2));
				btDown2 = new JButton();
					btDown2.setText("-");
					btDown2.addActionListener(new ActionListener() {
			        	public void actionPerformed(ActionEvent evt) {
			        		dateButton(BUTTON_DOWN_2);
			        	}
		    	    });
				pickerButtonPanel2.add(btDown2);
				btUp2 = new JButton();
				btUp2.setText("+");
				btUp2.addActionListener(new ActionListener() {
		        	public void actionPerformed(ActionEvent evt) {
		        		dateButton(BUTTON_UP_2);
		        	}
			    });
				pickerButtonPanel2.add(btUp2);
			pickerPanel2.add(pickerButtonPanel2,BorderLayout.WEST);
		pickerPanel.add(pickerPanel2);
		
		/*
		 * Buttons
		 */
		buttonPanel = new JPanel(new GridLayout(2,6));
			btHeute = new JButton();
				btHeute.setText(rz.getLocale().getString("picker.dual.button.heute"));
				btHeute.addActionListener(new ActionListener() {
		        	public void actionPerformed(ActionEvent evt) {
		        		buttonPressed(B_HEUTE);
		        	}
	    	    });
				buttonPanel.add(btHeute);
			btGestern  = new JButton();
				btGestern.setText(rz.getLocale().getString("picker.dual.button.gestern"));
				btGestern.addActionListener(new ActionListener() {
		        	public void actionPerformed(ActionEvent evt) {
		        		buttonPressed(B_GESTERN);
		        	}
	    	    });
				buttonPanel.add(btGestern);
			btDieseWoche =  new JButton();
				btDieseWoche.setText(rz.getLocale().getString("picker.dual.button.diese_woche"));
				btDieseWoche.addActionListener(new ActionListener() {
		        	public void actionPerformed(ActionEvent evt) {
		        		buttonPressed(B_DIESE_WOCHE);
		        	}
	    	    });  
				buttonPanel.add(btDieseWoche);
			btLetzteWoche =  new JButton();
				btLetzteWoche.setText(rz.getLocale().getString("picker.dual.button.letzte_woche"));
				btLetzteWoche.addActionListener(new ActionListener() {
		        	public void actionPerformed(ActionEvent evt) {
		        		buttonPressed(B_LETZTE_WOCHE);
		        	}
	    	    });
				buttonPanel.add(btLetzteWoche);
			bt2Wochen =  new JButton();
			bt2Wochen.setText(rz.getLocale().getString("picker.dual.button.2wochen"));
			bt2Wochen.addActionListener(new ActionListener() {
	        	public void actionPerformed(ActionEvent evt) {
	        		buttonPressed(B_2WOCHEN);
	        	}
    	    });
			buttonPanel.add(bt2Wochen);
			btDiesenMonat =  new JButton();
			btDiesenMonat.setText(rz.getLocale().getString("picker.dual.button.diesen_monat"));
			btDiesenMonat.addActionListener(new ActionListener() {
	        	public void actionPerformed(ActionEvent evt) {
	        		buttonPressed(B_DIESEN_MONAT);
	        	}
    	    });
			buttonPanel.add(btDiesenMonat); 
			btLetztenMonat =  new JButton();
			btLetztenMonat.setText(rz.getLocale().getString("picker.dual.button.letzten_monat"));
			btLetztenMonat.addActionListener(new ActionListener() {
	        	public void actionPerformed(ActionEvent evt) {
	        		buttonPressed(B_LETZTEN_MONAT);
	        	}
    	    });
			buttonPanel.add(btLetztenMonat);
			bt4Wochen =  new JButton();
			bt4Wochen.setText(rz.getLocale().getString("picker.dual.button.4wochen"));
			bt4Wochen.addActionListener(new ActionListener() {
	        	public void actionPerformed(ActionEvent evt) {
	        		buttonPressed(B_4WOCHEN);
	        	}
    	    });
			buttonPanel.add(bt4Wochen);   
			btdiesesJahr =  new JButton();
			btdiesesJahr.setText(rz.getLocale().getString("picker.dual.button.dieses_jahr"));
			btdiesesJahr.addActionListener(new ActionListener() {
	        	public void actionPerformed(ActionEvent evt) {
	        		buttonPressed(B_DIESES_JAHR);
	        	}
    	    });
			buttonPanel.add(btdiesesJahr); 
			btLetztesJahr =  new JButton();
			btLetztesJahr.setText(rz.getLocale().getString("picker.dual.button.letztes_jahr"));
			btLetztesJahr.addActionListener(new ActionListener() {
	        	public void actionPerformed(ActionEvent evt) {
	        		buttonPressed(B_LETZTES_JAHR);
	        	}
    	    });
			buttonPanel.add(btLetztesJahr);
			bt2Jahre =  new JButton();
			bt2Jahre.setText(rz.getLocale().getString("picker.dual.button.2jahre"));
			bt2Jahre.addActionListener(new ActionListener() {
	        	public void actionPerformed(ActionEvent evt) {
	        		buttonPressed(B_2JAHRE);
	        	}
    	    });
			buttonPanel.add(bt2Jahre); 
			bt5Jahre =  new JButton();
			bt5Jahre.setText(rz.getLocale().getString("picker.dual.button.5jahre"));
			bt5Jahre.addActionListener(new ActionListener() {
	        	public void actionPerformed(ActionEvent evt) {
	        		buttonPressed(B_5JAHRE);
	        	}
    	    });
			buttonPanel.add(bt5Jahre); 
        	
	
        centerPanel.add(pickerPanel,BorderLayout.CENTER);
        centerPanel.add(buttonPanel,BorderLayout.SOUTH);
		this.add(centerPanel,BorderLayout.CENTER);
	}
	
	
	private void dateButton(int direction) {
		switch (direction) {
			case BUTTON_UP_1:
				picker1.setDate(picker1.getDate().plusDays(1));
				break;
			case BUTTON_DOWN_1:
				picker1.setDate(picker1.getDate().plusDays(-1));
				break;
			case BUTTON_UP_2:
				picker2.setDate(picker2.getDate().plusDays(1));
				break;
			case BUTTON_DOWN_2:
				picker2.setDate(picker2.getDate().plusDays(-1));
				break;
		}
	}
	
	private void buttonPressed(int which) {
		LocalDate now = LocalDate.now();
		switch(which) {
			case B_HEUTE:
				picker1.setDate(now);
				picker2.setDate(now);
				break;
			case B_GESTERN:
				now = now.minusDays(1);
				picker1.setDate(now);
				picker2.setDate(now);
				break;
			case B_DIESE_WOCHE:
				picker2.setDate(now);
				picker1.setDate(now.with(DayOfWeek.MONDAY));
				break;
			case B_LETZTE_WOCHE:
				now = now.minusWeeks(1);
				picker1.setDate(now.with(DayOfWeek.MONDAY));
				picker2.setDate(rz.getDatabase().getAuftrag().getAuftragsConfig().getValidDate( now.with(DayOfWeek.SUNDAY),false));
				break;
			case B_2WOCHEN:
				picker2.setDate(now);
				picker1.setDate(now.minusWeeks(2));
				break;
			case B_DIESEN_MONAT:
				picker2.setDate(now);
				picker1.setDate(now.withDayOfMonth(1));
				break;
			case B_LETZTEN_MONAT:
				now = now.minusMonths(1).withDayOfMonth(1);
				picker1.setDate(now);
				picker2.setDate( now.withDayOfMonth(now.lengthOfMonth()));
				break;
			case B_4WOCHEN:
				picker2.setDate(now);
				picker1.setDate(now.minusWeeks(4));
				break;
			case B_DIESES_JAHR:
				picker2.setDate(now);
				picker1.setDate(now.with(TemporalAdjusters.firstDayOfYear()));
				break;
			case B_LETZTES_JAHR:
				now = now.with(TemporalAdjusters.firstDayOfYear()).minusDays(1);
				picker2.setDate(now);
				picker1.setDate(now.minusYears(1).plusDays(1));
				break;
			case B_2JAHRE:
				picker2.setDate(now);
				picker1.setDate(now.minusYears(1).with(TemporalAdjusters.firstDayOfYear()));
				break;
			case B_5JAHRE:
				picker2.setDate(now);
				picker1.setDate(now.minusYears(4).with(TemporalAdjusters.firstDayOfYear()));
				break;
		}
	}
	

	
	public Date getDate1() {
		return getSelectedDate1();
	}
	
	public Date getDate2() {
		return getSelectedDate2();
	}
	
	public LocalDate getLocalDate1() {
		return picker1.getDate();
	}
	
	public LocalDate getLocalDate2() {
		return  picker2.getDate();
	}
	
	private void dateNew() {
        for (PickerDualDateListener hl : listeners) {
          hl.dateChanged(getSelectedDate1(),getSelectedDate2());
        }
	}
	
	private Date getSelectedDate1(){
		LocalDateTime time =picker1.getDate().atStartOfDay();
		return  Date.from(time.atZone(ZoneId.systemDefault()).toInstant());
	}
	private Date getSelectedDate2(){
		LocalDateTime time = picker2.getDate().atTime(23,59,59);
		return  Date.from(time.atZone(ZoneId.systemDefault()).toInstant());
	}

	 public void addListener(PickerDualDateListener  pickerDualDateListener) {
	        listeners.add(pickerDualDateListener);
	    }

	
}





